/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.agent.tool.linecount;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001d\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH&\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH&J'\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/agent/tool/linecount/CmdWrapper;", "T", "", "timeoutMs", "", "getTimeoutMs", "()J", "buildCommand", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "arguments", "", "", "([Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "parseResult", "", "json", "runSync", "([Ljava/lang/String;)Ljava/util/List;", "findBinary", "Ljava/nio/file/Path;", "name", "core"})
public interface CmdWrapper<T> {
    public long getTimeoutMs();

    @NotNull
    public GeneralCommandLine buildCommand(@NotNull String[] var1);

    @NotNull
    public List<T> parseResult(@NotNull String var1);

    @NotNull
    public List<T> runSync(String ... var1);

    @Nullable
    public Path findBinary(@NotNull String var1) throws IOException;

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static <T> long getTimeoutMs(@NotNull CmdWrapper<T> $this) {
            return 30000L;
        }

        @NotNull
        public static <T> List<T> runSync(@NotNull CmdWrapper<T> $this, String ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            GeneralCommandLine command = $this.buildCommand(arguments);
            OSProcessHandler handler = (OSProcessHandler)new ColoredProcessHandler(command);
            handler.startNotify();
            StringBuilder stdout = new StringBuilder();
            StringBuilder stderr = new StringBuilder();
            handler.addProcessListener((ProcessListener)new ProcessAdapter(stdout, stderr){
                final /* synthetic */ StringBuilder $stdout;
                final /* synthetic */ StringBuilder $stderr;
                {
                    this.$stdout = $stdout;
                    this.$stderr = $stderr;
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                        this.$stdout.append(event.getText());
                    } else if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR)) {
                        this.$stderr.append(event.getText());
                    }
                }
            });
            if (!handler.waitFor($this.getTimeoutMs())) {
                throw new IOException("Command timed out");
            }
            Integer n = handler.getExitCode();
            if (n == null || n != 0) {
                throw new IOException("Command failed with exit code " + handler.getExitCode() + ": " + stderr);
            }
            String string = stdout.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return $this.parseResult(string);
        }

        @Nullable
        public static <T> Path findBinary(@NotNull CmdWrapper<T> $this, @NotNull String name) throws IOException {
            Object[] objectArray;
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String osName = string3;
            Object binName = StringsKt.contains$default((CharSequence)osName, (CharSequence)"win", (boolean)false, (int)2, null) ? name + ".exe" : name;
            List searchPaths = new ArrayList();
            if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null)) {
                var5_5 = new String[]{"/opt/homebrew/bin", "/usr/local/bin", "/usr/bin", "/bin", "/Library/Developer/CommandLineTools/usr/bin", "/opt/local/bin", "/sw/bin"};
                searchPaths.addAll(CollectionsKt.listOf((Object[])var5_5));
            } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"linux", (boolean)false, (int)2, null)) {
                var5_5 = new String[]{"/usr/local/bin", "/usr/bin", "/bin", "/snap/bin", "/usr/local/sbin", "/usr/sbin", "/sbin"};
                searchPaths.addAll(CollectionsKt.listOf((Object[])var5_5));
            } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"win", (boolean)false, (int)2, null)) {
                var5_5 = new String[]{"C:\\Program Files\\Git\\bin", "C:\\msys64\\usr\\bin", "C:\\cygwin64\\bin"};
                searchPaths.addAll(CollectionsKt.listOf((Object[])var5_5));
            }
            String whichCommand = StringsKt.contains$default((CharSequence)osName, (CharSequence)"win", (boolean)false, (int)2, null) ? "where" : "which";
            try {
                stringArray = new String[]{whichCommand, binName};
                ProcessBuilder pb = new ProcessBuilder(stringArray);
                Process process2 = pb.start();
                if (process2.waitFor(2L, TimeUnit.SECONDS) && process2.exitValue() == 0) {
                    Path pathObj;
                    byte[] byArray = process2.getInputStream().readAllBytes();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                    objectArray = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    String path = ((Object)StringsKt.trim((CharSequence)new String((byte[])objectArray, charset2))).toString();
                    if (((CharSequence)path).length() > 0 && (pathObj = Paths.get(path, new String[0])).toFile().exists() && pathObj.toFile().canExecute()) {
                        return pathObj;
                    }
                }
            }
            catch (Exception pb) {
                // empty catch block
            }
            for (String searchPath : searchPaths) {
                Path fullPath = Paths.get(searchPath, objectArray = new String[]{binName});
                if (!fullPath.toFile().exists() || !fullPath.toFile().canExecute()) continue;
                return fullPath;
            }
            stringArray = new String[]{binName};
            Path currentDirPath = Paths.get(".", stringArray);
            if (currentDirPath.toFile().exists() && currentDirPath.toFile().canExecute()) {
                return currentDirPath.toAbsolutePath();
            }
            return null;
        }
    }
}

