/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.agent.custom;

import cc.unitmesh.devti.agent.custom.model.AuthType;
import cc.unitmesh.devti.agent.custom.model.ConnectorConfig;
import cc.unitmesh.devti.agent.custom.model.CustomAgentAuth;
import cc.unitmesh.devti.agent.custom.model.CustomAgentConfig;
import cc.unitmesh.devti.agent.custom.model.CustomAgentResponseAction;
import cc.unitmesh.devti.llms.LLMProvider;
import cc.unitmesh.devti.llms.LlmFactory;
import cc.unitmesh.devti.llms.custom.CustomRequest;
import cc.unitmesh.devti.llms.custom.CustomRequestKt;
import cc.unitmesh.devti.llms.custom.CustomSSEProcessor;
import cc.unitmesh.devti.llms.custom.Message;
import cc.unitmesh.devti.provider.devins.CustomAgentContext;
import cc.unitmesh.devti.provider.devins.LanguageProcessor;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014\u00a8\u0006!"}, d2={"Lcc/unitmesh/devti/agent/custom/CustomAgentExecutor;", "Lcc/unitmesh/devti/llms/custom/CustomSSEProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "client", "Lokhttp3/OkHttpClient;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "messages", "", "Lcc/unitmesh/devti/llms/custom/Message;", "requestFormat", "", "getRequestFormat", "()Ljava/lang/String;", "setRequestFormat", "(Ljava/lang/String;)V", "responseFormat", "getResponseFormat", "setResponseFormat", "execute", "Lkotlinx/coroutines/flow/Flow;", "promptText", "agent", "Lcc/unitmesh/devti/agent/custom/model/CustomAgentConfig;", "displayMessage", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCustomAgentExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomAgentExecutor.kt\ncc/unitmesh/devti/agent/custom/CustomAgentExecutor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,122:1\n11#2:123\n205#3:124\n*S KotlinDebug\n*F\n+ 1 CustomAgentExecutor.kt\ncc/unitmesh/devti/agent/custom/CustomAgentExecutor\n*L\n28#1:123\n61#1:124\n*E\n"})
public final class CustomAgentExecutor
extends CustomSSEProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private OkHttpClient client;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<Message> messages;
    @NotNull
    private String requestFormat;
    @NotNull
    private String responseFormat;
    @NotNull
    private static final String SIMPLE_CONTENT_PLACEHOLDER = "\"content\":\"$content\"";
    @NotNull
    private static final String JSON_VALUE_PLACEHOLDER_PATTERN = ":\\s*\"\\$content\"";

    public CustomAgentExecutor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.client = new OkHttpClient();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CustomAgentExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.messages = new ArrayList();
        this.requestFormat = "";
        this.responseFormat = "";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getRequestFormat() {
        return this.requestFormat;
    }

    public void setRequestFormat(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.requestFormat = string;
    }

    @Override
    @NotNull
    public String getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.responseFormat = string;
    }

    @Nullable
    public final Flow<String> execute(@NotNull String promptText2, @NotNull CustomAgentConfig agent, @NotNull StringBuilder displayMessage) {
        CustomAgentAuth auth;
        String string;
        Intrinsics.checkNotNullParameter((Object)promptText2, (String)"promptText");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)displayMessage, (String)"displayMessage");
        if (agent.isFromDevIns()) {
            LanguageProcessor languageProcessor = LanguageProcessor.Companion.devin();
            Intrinsics.checkNotNull((Object)languageProcessor);
            LanguageProcessor devin = languageProcessor;
            VirtualFile virtualFile = this.project.getBaseDir().findFileByRelativePath(agent.getDevinScriptPath());
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile file = virtualFile;
            String prompt2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(agent, file, promptText2, devin, this, null){
                int label;
                final /* synthetic */ CustomAgentConfig $agent;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ String $promptText;
                final /* synthetic */ LanguageProcessor $devin;
                final /* synthetic */ CustomAgentExecutor this$0;
                {
                    this.$agent = $agent;
                    this.$file = $file;
                    this.$promptText = $promptText;
                    this.$devin = $devin;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CustomAgentContext context = new CustomAgentContext(this.$agent, "", this.$file, MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)this.$promptText)));
                            this.label = 1;
                            Object object3 = this.$devin.execute(this.this$0.getProject(), context, (Continuation<? super String>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            displayMessage.append(prompt2);
            this.messages.add(new Message("user", prompt2));
            return LLMProvider.DefaultImpls.stream$default(LlmFactory.INSTANCE.create(this.project), prompt2, "", false, false, 12, null);
        }
        displayMessage.append(promptText2);
        this.messages.add(new Message("user", promptText2));
        Object object = agent.getConnector();
        if (object == null || (object = ((ConnectorConfig)object).getRequestFormat()) == null) {
            object = this.getRequestFormat();
        }
        this.setRequestFormat((String)object);
        Object object2 = agent.getConnector();
        if (object2 == null || (object2 = ((ConnectorConfig)object2).getResponseFormat()) == null) {
            object2 = this.getResponseFormat();
        }
        this.setResponseFormat((String)object2);
        CustomRequest customRequest = new CustomRequest(CollectionsKt.listOf((Object)new Message("user", promptText2)));
        if (((CharSequence)this.getRequestFormat()).length() > 0) {
            string = CustomRequestKt.updateCustomFormat(customRequest, this.getRequestFormat());
        } else {
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            string = this_$iv.encodeToString((SerializationStrategy)CustomRequest.Companion.serializer(), (Object)customRequest);
        }
        String request2 = string;
        request2 = Companion.replacePlaceholders(request2, promptText2);
        RequestBody body = RequestBody.Companion.create(request2, MediaType.Companion.parse("application/json"));
        Request.Builder builder = new Request.Builder();
        CustomAgentAuth customAgentAuth = auth = agent.getAuth();
        AuthType authType = customAgentAuth != null ? customAgentAuth.getType() : null;
        switch (authType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[authType.ordinal()]) {
            case 1: {
                builder.addHeader("Authorization", "Bearer " + auth.getToken());
                builder.addHeader("Content-Type", "application/json");
                break;
            }
            case -1: {
                this.logger.info("No auth type found for agent " + agent.getName());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.client = this.client.newBuilder().connectTimeout(agent.getDefaultTimeout(), TimeUnit.SECONDS).readTimeout(agent.getDefaultTimeout(), TimeUnit.SECONDS).build();
        Call call = this.client.newCall(builder.url(agent.getUrl()).post(body).build());
        return WhenMappings.$EnumSwitchMapping$1[agent.getResponseAction().ordinal()] == 1 ? CustomSSEProcessor.streamSSE$default(this, call, promptText2, false, this.messages, 4, null) : this.streamJson(call, promptText2, this.messages);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcc/unitmesh/devti/agent/custom/CustomAgentExecutor$Companion;", "", "<init>", "()V", "SIMPLE_CONTENT_PLACEHOLDER", "", "JSON_VALUE_PLACEHOLDER_PATTERN", "replacePlaceholders", "request", "promptText", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String replacePlaceholders(@NotNull String request2, @NotNull String promptText2) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)promptText2, (String)"promptText");
            String result = request2;
            if (StringsKt.contains$default((CharSequence)result, (CharSequence)CustomAgentExecutor.SIMPLE_CONTENT_PLACEHOLDER, (boolean)false, (int)2, null)) {
                result = StringsKt.replace$default((String)result, (String)CustomAgentExecutor.SIMPLE_CONTENT_PLACEHOLDER, (String)("\"content\": \"" + promptText2 + "\""), (boolean)false, (int)4, null);
                return result;
            }
            Regex regex = new Regex(CustomAgentExecutor.JSON_VALUE_PLACEHOLDER_PATTERN);
            if (regex.containsMatchIn((CharSequence)result)) {
                result = regex.replace((CharSequence)result, ": \"" + promptText2 + "\"");
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AuthType.values().length];
            try {
                nArray[AuthType.Bearer.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CustomAgentResponseAction.values().length];
            try {
                nArray[CustomAgentResponseAction.Stream.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

