/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.actions.chat.base;

import cc.unitmesh.devti.actions.chat.base.ChatBaseActionKt;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"CANONICAL_NAME_REGEX_PATTERN", "Lkotlin/text/Regex;", "getCanonicalName", "", "", "input", "collectProblems", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "core"})
public final class CodeProblemAnalysisKt {
    @NotNull
    private static final Regex CANONICAL_NAME_REGEX_PATTERN = new Regex("\\(([a-zA-Z]+(\\.[a-zA-Z]+)+(\\.[a-zA-Z0-9_]+))\\)");

    @NotNull
    public static final List<String> getCanonicalName(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Sequence matches = Regex.findAll$default((Regex)CANONICAL_NAME_REGEX_PATTERN, (CharSequence)input, (int)0, (int)2, null);
        List canonicalNames = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)matches, CodeProblemAnalysisKt::getCanonicalName$lambda$0));
        return canonicalNames;
    }

    @NotNull
    public static final String collectProblems(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextRange range = element.getTextRange();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        List errors = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights((Document)document2, (Project)project, null, (int)range.getStartOffset(), (int)range.getEndOffset(), arg_0 -> CodeProblemAnalysisKt.collectProblems$lambda$2(arg_0 -> CodeProblemAnalysisKt.collectProblems$lambda$1(errors, arg_0), arg_0));
        String commentSymbol = ChatBaseActionKt.commentPrefix(element);
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)errors), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> CodeProblemAnalysisKt.collectProblems$lambda$3(commentSymbol, arg_0), (int)30, null);
    }

    private static final String getCanonicalName$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getValue().substring(1, it.getValue().length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final boolean collectProblems$lambda$1(List $errors, HighlightInfo it) {
        if (it.getDescription() != null) {
            String string = it.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            $errors.add(string);
        }
        return true;
    }

    private static final boolean collectProblems$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence collectProblems$lambda$3(String $commentSymbol, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $commentSymbol + " - " + it;
    }
}

