/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.actions.chat;

import cc.unitmesh.devti.actions.chat.base.ChatBaseActionKt;
import cc.unitmesh.devti.actions.chat.base.ChatCheckForUpdateAction;
import cc.unitmesh.devti.actions.chat.base.CodeProblemAnalysisKt;
import cc.unitmesh.devti.gui.chat.message.ChatActionType;
import cc.unitmesh.devti.provider.RefactoringTool;
import cc.unitmesh.devti.settings.locale.LanguageChangedCallback;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/devti/actions/chat/RefactorThisAction;", "Lcc/unitmesh/devti/actions/chat/base/ChatCheckForUpdateAction;", "<init>", "()V", "getActionType", "Lcc/unitmesh/devti/gui/chat/message/ChatActionType;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addAdditionPrompt", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "core"})
public class RefactorThisAction
extends ChatCheckForUpdateAction {
    public RefactorThisAction() {
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
        LanguageChangedCallback.presentationText$default(LanguageChangedCallback.INSTANCE, "settings.autodev.rightClick.refactor", presentation, 0, 4, null);
    }

    @Override
    @NotNull
    public ChatActionType getActionType() {
        return ChatActionType.REFACTOR;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file != null && file.isWritable()) {
            super.update(e);
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    @Override
    @NotNull
    public String addAdditionPrompt(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                String commentSymbol = ChatBaseActionKt.commentPrefix(element);
                object = CodeProblemAnalysisKt.collectProblems(project, editor, element);
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                String string = "\n\n" + commentSymbol + " relative static analysis result:\n" + it;
                object = string;
                if (string != null) break block5;
            }
            object = "";
        }
        String staticCodeResults = object;
        Language language = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        RefactoringTool refactoringTool = RefactoringTool.Companion.forLanguage(language);
        if (refactoringTool == null) {
            return staticCodeResults;
        }
        String devinRefactorPrompt = "```\n- You should summary in the end with `DevIn` language in markdown fence-code block, I will handle it.\n- the DevIn language current only support rename method.\n- If you had rename method name or class name, return follow format:\n```DevIn\n/refactor:rename <sourceMethodName> to <targetMethodName> [comments: method and class only]";
        return staticCodeResults + devinRefactorPrompt;
    }
}

