/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.actions.chat;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.actions.chat.AutoTestInMenuActionKt;
import cc.unitmesh.devti.gui.chat.message.ChatActionType;
import cc.unitmesh.devti.intentions.action.task.TestCodeGenTask;
import cc.unitmesh.devti.intentions.action.test.TestCodeGenRequest;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/actions/chat/AutoTestInMenuAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getActionType", "Lcc/unitmesh/devti/gui/chat/message/ChatActionType;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "batchGenerateTests", "files", "", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabled", "", "showNothingToConvertErrorMessage", "getSelectedWritableFiles", "core"})
@SourceDebugExtension(value={"SMAP\nAutoTestInMenuAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoTestInMenuAction.kt\ncc/unitmesh/devti/actions/chat/AutoTestInMenuAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,159:1\n11#2:160\n12474#3,2:161\n12474#3,2:163\n*S KotlinDebug\n*F\n+ 1 AutoTestInMenuAction.kt\ncc/unitmesh/devti/actions/chat/AutoTestInMenuAction\n*L\n26#1:160\n121#1:161,2\n125#1:163,2\n*E\n"})
public final class AutoTestInMenuAction
extends AnAction {
    @NotNull
    private final Logger logger;

    public AutoTestInMenuAction() {
        super(AutoDevBundle.message("intentions.chat.code.test.name", new Object[0]));
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AutoTestInMenuAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    public final ChatActionType getActionType() {
        return ChatActionType.GENERATE_TEST;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.isEnabled(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List<PsiFile> files = this.getSelectedWritableFiles(e);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (files.isEmpty()) {
            this.showNothingToConvertErrorMessage(project2);
            return;
        }
        if (files.size() == 1) {
            PsiFile file = files.get(0);
            TestCodeGenTask task2 = new TestCodeGenTask(new TestCodeGenRequest(file, (PsiElement)file, project2, editor), AutoDevBundle.message("intentions.chat.code.test.name", new Object[0]));
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task2, (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task2));
            return;
        }
        this.batchGenerateTests(files, project2, editor);
    }

    private final void batchGenerateTests(List<? extends PsiFile> files, Project project, Editor editor) {
        String string = AutoDevBundle.message("intentions.chat.code.test.name", new Object[0]) + " (Batch)";
        Task.Backgroundable batchTask2 = new Task.Backgroundable(project, files, editor, this, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ List<PsiFile> $files;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ AutoTestInMenuAction this$0;
            {
                this.$project = $project;
                this.$files = $files;
                this.$editor = $editor;
                this.this$0 = $receiver;
                super($project, $super_call_param$1, true);
            }

            /*
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                void $this$forEachIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                int total = this.$files.size();
                indicator.setIndeterminate(false);
                indicator.setFraction(0.0);
                Iterable iterable = this.$files;
                Project project = this.$project;
                Editor editor = this.$editor;
                AutoTestInMenuAction autoTestInMenuAction = this.this$0;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void file;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    PsiFile psiFile2 = (PsiFile)item$iv;
                    int index = n;
                    boolean bl = false;
                    indicator.checkCanceled();
                    indicator.setText("Processing " + (index + 1) + "/" + total + ": " + file.getName());
                    indicator.setFraction((double)index / (double)total);
                    TestCodeGenTask task2 = new TestCodeGenTask(new TestCodeGenRequest((PsiFile)file, (PsiElement)file, project, editor), AutoDevBundle.message("intentions.chat.code.test.name", new Object[0]));
                    try {
                        task2.run(indicator);
                        indicator.setFraction((double)(index + 1) / (double)total);
                    }
                    catch (ProcessCanceledException e) {
                        indicator.setText("Batch test generation cancelled");
                        throw e;
                    }
                    catch (Exception e) {
                        AutoTestInMenuAction.access$getLogger$p(autoTestInMenuAction).warn("Failed to generate test for file: " + file.getName(), (Throwable)e);
                        indicator.setFraction((double)(index + 1) / (double)total);
                    }
                }
                indicator.setFraction(1.0);
                indicator.setText("Batch test generation completed");
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(batchTask2, (ProgressIndicator)new BackgroundableProcessIndicator(batchTask2));
    }

    private final boolean isEnabled(AnActionEvent e) {
        boolean bl;
        block9: {
            VirtualFile p0;
            VirtualFile element$iv;
            int n;
            int n2;
            boolean $i$f$any;
            VirtualFile[] $this$any$iv;
            Project project = e.getProject();
            if (project == null) {
                return false;
            }
            Project project2 = project;
            if (project2.isDisposed()) {
                return false;
            }
            if (e.getData(PlatformCoreDataKeys.MODULE) == null) {
                return false;
            }
            VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray == null) {
                return false;
            }
            VirtualFile[] files = virtualFileArray;
            if (!Intrinsics.areEqual((Object)e.getPlace(), (Object)"ProjectViewPopup")) {
                boolean bl2;
                block8: {
                    $this$any$iv = files;
                    $i$f$any = false;
                    n2 = $this$any$iv.length;
                    for (n = 0; n < n2; ++n) {
                        p0 = element$iv = $this$any$iv[n];
                        boolean bl3 = false;
                        if (!AutoTestInMenuAction.isEnabled$isWritablePackageDirectory(project2, p0)) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return true;
                }
            }
            $this$any$iv = files;
            $i$f$any = false;
            n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                p0 = element$iv = $this$any$iv[n];
                boolean bl4 = false;
                if (!AutoTestInMenuAction.isEnabled$isWritableJavaFile(p0)) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        return bl;
    }

    private final void showNothingToConvertErrorMessage(Project project) {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(AutoDevBundle.message("batch.nothing.to.testing", new Object[0]), MessageType.ERROR, null).createBalloon().showInCenterOf(statusBar.getComponent());
    }

    private final List<PsiFile> getSelectedWritableFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile[] virtualFilesAndDirectories = virtualFileArray;
        Project project = e.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)AutoTestInMenuActionKt.getAllFilesRecursively(virtualFilesAndDirectories)), arg_0 -> AutoTestInMenuAction.getSelectedWritableFiles$lambda$1(psiManager2, arg_0)), AutoTestInMenuAction::getSelectedWritableFiles$lambda$2));
    }

    private static final boolean isEnabled$isWritableJavaFile(VirtualFile file) {
        return file.isWritable();
    }

    private static final boolean isEnabled$isWritablePackageDirectory(Project project, VirtualFile file) {
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(file);
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory directory = psiDirectory;
        return PsiDirectoryFactory.getInstance((Project)project).isPackage(directory) && file.isWritable();
    }

    private static final PsiFile getSelectedWritableFiles$lambda$1(PsiManager $psiManager, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $psiManager.findFile(it);
    }

    private static final boolean getSelectedWritableFiles$lambda$2(PsiFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isWritable();
    }

    public static final /* synthetic */ Logger access$getLogger$p(AutoTestInMenuAction $this) {
        return $this.logger;
    }
}

