/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.actions;

import cc.unitmesh.cf.core.llms.LlmMsg;
import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.actions.context.DevOpsContext;
import cc.unitmesh.devti.custom.tasks.FileGenerateTask;
import cc.unitmesh.devti.provider.BuildSystemProvider;
import cc.unitmesh.devti.template.TemplateRender;
import cc.unitmesh.devti.template.context.DockerfileContext;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcc/unitmesh/devti/actions/GenerateGitHubActionsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "core"})
@SourceDebugExtension(value={"SMAP\nGenerateGitHubActionsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateGitHubActionsAction.kt\ncc/unitmesh/devti/actions/GenerateGitHubActionsAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n11#2:48\n*S KotlinDebug\n*F\n+ 1 GenerateGitHubActionsAction.kt\ncc/unitmesh/devti/actions/GenerateGitHubActionsAction\n*L\n41#1:48\n*E\n"})
public final class GenerateGitHubActionsAction
extends AnAction {
    public GenerateGitHubActionsAction() {
        super(AutoDevBundle.message("action.new.genius.cicd.github", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        try {
            List<DockerfileContext> buildSystem = BuildSystemProvider.Companion.guess(project2);
            TemplateRender templateRender = new TemplateRender("/cicd");
            templateRender.setContext(DevOpsContext.Companion.from(buildSystem));
            String template = templateRender.getTemplate("generate-github-action.vm");
            Object object = ProjectUtil.guessProjectDir((Project)project2);
            if (object == null || (object = object.toNioPath()) == null) {
                throw new IllegalStateException("Cannot determine project directory");
            }
            Object projectDir = object;
            Path workflowDir = projectDir.resolve(".github").resolve("workflows");
            Intrinsics.checkNotNull((Object)workflowDir);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(workflowDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            List<LlmMsg.ChatMessage> msgs = templateRender.buildMsgs(template);
            Task.Backgroundable task2 = new FileGenerateTask(project2, msgs, "ci.yml", false, null, 24, null);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        }
        catch (Exception e2) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GenerateGitHubActionsAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to generate GitHub Actions workflow", (Throwable)e2);
        }
    }
}

