/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.a2a.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import io.a2a.spec.AgentCapabilities;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentProvider;
import io.a2a.spec.AgentSkill;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcc/unitmesh/devti/a2a/ui/A2AAgentDetailDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "agentCard", "Lio/a2a/spec/AgentCard;", "<init>", "(Lcom/intellij/openapi/project/Project;Lio/a2a/spec/AgentCard;)V", "getAgentName", "", "createCenterPanel", "Ljavax/swing/JComponent;", "createAgentDetailsPanel", "Ljavax/swing/JPanel;", "addSectionHeader", "", "panel", "title", "addDetailRow", "label", "value", "addSkillRow", "skill", "Lio/a2a/spec/AgentSkill;", "core"})
@SourceDebugExtension(value={"SMAP\nA2AAgentDetailDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 A2AAgentDetailDialog.kt\ncc/unitmesh/devti/a2a/ui/A2AAgentDetailDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n1855#2,2:217\n*S KotlinDebug\n*F\n+ 1 A2AAgentDetailDialog.kt\ncc/unitmesh/devti/a2a/ui/A2AAgentDetailDialog\n*L\n79#1:217,2\n*E\n"})
public final class A2AAgentDetailDialog
extends DialogWrapper {
    @NotNull
    private final AgentCard agentCard;

    public A2AAgentDetailDialog(@NotNull Project project, @NotNull AgentCard agentCard) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)agentCard, (String)"agentCard");
        super(project);
        this.agentCard = agentCard;
        this.setTitle("Agent: " + this.getAgentName());
        this.init();
    }

    private final String getAgentName() {
        String string = this.agentCard.name();
        if (string == null) {
            string = "Unknown Agent";
        }
        return string;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(0, 10));
        panel2.setPreferredSize(new Dimension(600, 500));
        JPanel detailsPanel = this.createAgentDetailsPanel();
        panel2.add((Component)new JBScrollPane((Component)detailsPanel), "Center");
        return panel2;
    }

    private final JPanel createAgentDetailsPanel() {
        AgentCapabilities capabilities;
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder(JBUI.Borders.empty((int)16));
        this.addSectionHeader(panel2, "Basic Information");
        String string = this.agentCard.name();
        if (string == null) {
            string = "N/A";
        }
        this.addDetailRow(panel2, "Name", string);
        String string2 = this.agentCard.description();
        if (string2 == null) {
            string2 = "N/A";
        }
        this.addDetailRow(panel2, "Description", string2);
        String string3 = this.agentCard.version();
        if (string3 == null) {
            string3 = "N/A";
        }
        this.addDetailRow(panel2, "Version", string3);
        String string4 = this.agentCard.url();
        if (string4 == null) {
            string4 = "N/A";
        }
        this.addDetailRow(panel2, "URL", string4);
        String string5 = this.agentCard.protocolVersion();
        if (string5 == null) {
            string5 = "N/A";
        }
        this.addDetailRow(panel2, "Protocol Version", string5);
        AgentProvider provider = this.agentCard.provider();
        if (provider != null) {
            this.addSectionHeader(panel2, "Provider");
            try {
                String string6 = provider.organization();
                if (string6 == null) {
                    string6 = "N/A";
                }
                this.addDetailRow(panel2, "Organization", string6);
                String string7 = provider.url();
                if (string7 == null) {
                    string7 = "N/A";
                }
                this.addDetailRow(panel2, "URL", string7);
            }
            catch (Exception e) {
                String string8 = provider.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
                this.addDetailRow(panel2, "Provider", string8);
            }
        }
        if ((capabilities = this.agentCard.capabilities()) != null) {
            this.addSectionHeader(panel2, "Capabilities");
            String string9 = String.valueOf(capabilities.streaming());
            if (string9 == null) {
                string9 = "N/A";
            }
            this.addDetailRow(panel2, "Supports Streaming", string9);
            String string10 = String.valueOf(capabilities.pushNotifications());
            if (string10 == null) {
                string10 = "N/A";
            }
            this.addDetailRow(panel2, "Push Notifications", string10);
            String string11 = String.valueOf(capabilities.stateTransitionHistory());
            if (string11 == null) {
                string11 = "N/A";
            }
            this.addDetailRow(panel2, "State Transition History", string11);
        }
        this.addSectionHeader(panel2, "Skills (" + this.agentCard.skills().size() + ")");
        List list = this.agentCard.skills();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"skills(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AgentSkill skill = (AgentSkill)element$iv;
            boolean bl = false;
            if (skill == null) continue;
            this.addSkillRow(panel2, skill);
        }
        this.addSectionHeader(panel2, "Input/Output Modes");
        List inputModes = this.agentCard.defaultInputModes();
        List outputModes = this.agentCard.defaultOutputModes();
        Object object = inputModes;
        if (object == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)) == null) {
            object = "N/A";
        }
        this.addDetailRow(panel2, "Default Input Modes", (String)object);
        Object object2 = outputModes;
        if (object2 == null || (object2 = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)) == null) {
            object2 = "N/A";
        }
        this.addDetailRow(panel2, "Default Output Modes", (String)object2);
        this.addSectionHeader(panel2, "Additional Information");
        String string12 = this.agentCard.documentationUrl();
        if (string12 == null) {
            string12 = "N/A";
        }
        this.addDetailRow(panel2, "Documentation URL", string12);
        String string13 = this.agentCard.iconUrl();
        if (string13 == null) {
            string13 = "N/A";
        }
        this.addDetailRow(panel2, "Icon URL", string13);
        String string14 = this.agentCard.preferredTransport();
        if (string14 == null) {
            string14 = "N/A";
        }
        this.addDetailRow(panel2, "Preferred Transport", string14);
        this.addDetailRow(panel2, "Supports Auth Extended Card", String.valueOf(this.agentCard.supportsAuthenticatedExtendedCard()));
        return panel2;
    }

    private final void addSectionHeader(JPanel panel2, String title) {
        JBLabel jBLabel;
        panel2.add(Box.createVerticalStrut(16));
        JBLabel $this$addSectionHeader_u24lambda_u241 = jBLabel = new JBLabel(title);
        boolean bl = false;
        $this$addSectionHeader_u24lambda_u241.setFont((Font)JBUI.Fonts.label((float)14.0f).asBold());
        $this$addSectionHeader_u24lambda_u241.setForeground((Color)new JBColor(2042167, 16382715));
        JBLabel headerLabel = jBLabel;
        panel2.add((Component)headerLabel);
        panel2.add(Box.createVerticalStrut(8));
    }

    private final void addDetailRow(JPanel panel2, String label, String value) {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel $this$addDetailRow_u24lambda_u242 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$addDetailRow_u24lambda_u242.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        $this$addDetailRow_u24lambda_u242.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        JPanel rowPanel = jPanel;
        JPanel $this$addDetailRow_u24lambda_u243 = $this$addDetailRow_u24lambda_u242 = new JBLabel(label + ":");
        boolean bl2 = false;
        $this$addDetailRow_u24lambda_u243.setFont((Font)JBUI.Fonts.label((float)12.0f).asBold());
        $this$addDetailRow_u24lambda_u243.setForeground((Color)new JBColor(3621201, 13751771));
        $this$addDetailRow_u24lambda_u243.setPreferredSize(new Dimension(150, 20));
        JPanel labelComponent = $this$addDetailRow_u24lambda_u242;
        JBLabel $this$addDetailRow_u24lambda_u244 = jBLabel = new JBLabel(value);
        boolean bl3 = false;
        $this$addDetailRow_u24lambda_u244.setFont((Font)JBUI.Fonts.label((float)12.0f));
        $this$addDetailRow_u24lambda_u244.setForeground((Color)new JBColor(7041664, 10265519));
        JBLabel valueComponent = jBLabel;
        rowPanel.add((Component)labelComponent, "West");
        rowPanel.add((Component)valueComponent, "Center");
        panel2.add(rowPanel);
    }

    private final void addSkillRow(JPanel panel2, AgentSkill skill) {
        JPanel jPanel;
        JPanel $this$addSkillRow_u24lambda_u245 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$addSkillRow_u24lambda_u245.setMaximumSize(new Dimension(Integer.MAX_VALUE, 240));
        $this$addSkillRow_u24lambda_u245.setBorder((Border)JBUI.Borders.empty((int)8, (int)16, (int)8, (int)0));
        $this$addSkillRow_u24lambda_u245.setBackground((Color)new JBColor(16382715, 2042167));
        $this$addSkillRow_u24lambda_u245.setOpaque(true);
        JPanel skillPanel = jPanel;
        String string = skill.name();
        if (string == null) {
            string = "Unnamed Skill";
        }
        JPanel $this$addSkillRow_u24lambda_u246 = $this$addSkillRow_u24lambda_u245 = new JBLabel(string);
        boolean bl2 = false;
        $this$addSkillRow_u24lambda_u246.setFont((Font)JBUI.Fonts.label((float)13.0f).asBold());
        $this$addSkillRow_u24lambda_u246.setForeground((Color)new JBColor(2042167, 16382715));
        JPanel nameLabel = $this$addSkillRow_u24lambda_u245;
        String string2 = skill.id();
        if (string2 == null) {
            string2 = "N/A";
        }
        JPanel $this$addSkillRow_u24lambda_u247 = $this$addSkillRow_u24lambda_u246 = new JBLabel("ID: " + string2);
        boolean bl3 = false;
        $this$addSkillRow_u24lambda_u247.setFont((Font)JBUI.Fonts.label((float)11.0f));
        $this$addSkillRow_u24lambda_u247.setForeground((Color)new JBColor(7041664, 10265519));
        JPanel idLabel = $this$addSkillRow_u24lambda_u246;
        String string3 = skill.description();
        if (string3 == null) {
            string3 = "";
        }
        JPanel $this$addSkillRow_u24lambda_u248 = $this$addSkillRow_u24lambda_u247 = new JBLabel(string3);
        boolean bl4 = false;
        $this$addSkillRow_u24lambda_u248.setFont((Font)JBUI.Fonts.label((float)11.0f));
        $this$addSkillRow_u24lambda_u248.setForeground((Color)new JBColor(3621201, 13751771));
        JPanel descLabel = $this$addSkillRow_u24lambda_u247;
        List list = skill.tags();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List tagsText = list;
        JBLabel $this$addSkillRow_u24lambda_u249 = bl4 = new JBLabel("Tags: " + A2AAgentDetailDialog.addSkillRow$formatList$default(tagsText, 0, 2, null));
        boolean bl5 = false;
        $this$addSkillRow_u24lambda_u249.setFont((Font)JBUI.Fonts.label((float)11.0f));
        $this$addSkillRow_u24lambda_u249.setForeground((Color)new JBColor(7041664, 10265519));
        JBLabel tagsLabel = bl4;
        List list2 = skill.inputModes();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List inputModesText = list2;
        JBLabel $this$addSkillRow_u24lambda_u2410 = bl5 = new JBLabel("Input Modes: " + A2AAgentDetailDialog.addSkillRow$formatList$default(inputModesText, 0, 2, null));
        boolean bl6 = false;
        $this$addSkillRow_u24lambda_u2410.setFont((Font)JBUI.Fonts.label((float)11.0f));
        $this$addSkillRow_u24lambda_u2410.setForeground((Color)new JBColor(7041664, 10265519));
        JBLabel inputModesLabel = bl5;
        List list3 = skill.outputModes();
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List outputModesText = list3;
        JBLabel $this$addSkillRow_u24lambda_u2411 = bl6 = new JBLabel("Output Modes: " + A2AAgentDetailDialog.addSkillRow$formatList$default(outputModesText, 0, 2, null));
        boolean bl7 = false;
        $this$addSkillRow_u24lambda_u2411.setFont((Font)JBUI.Fonts.label((float)11.0f));
        $this$addSkillRow_u24lambda_u2411.setForeground((Color)new JBColor(7041664, 10265519));
        JBLabel outputModesLabel = bl6;
        List examplesText = skill.examples();
        JBLabel $this$addSkillRow_u24lambda_u2412 = bl7 = new JBLabel("Examples: " + A2AAgentDetailDialog.addSkillRow$formatList(examplesText, 3));
        boolean bl8 = false;
        $this$addSkillRow_u24lambda_u2412.setFont((Font)JBUI.Fonts.label((float)11.0f));
        $this$addSkillRow_u24lambda_u2412.setForeground((Color)new JBColor(7041664, 10265519));
        JBLabel examplesLabel = bl7;
        Object object = skill.security();
        if (object == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"; ", null, null, (int)0, null, A2AAgentDetailDialog::addSkillRow$lambda$14, (int)30, null)) == null) {
            object = "N/A";
        }
        Object securitySummary = object;
        JBLabel $this$addSkillRow_u24lambda_u2415 = bl8 = new JBLabel("Security: " + (String)securitySummary);
        boolean bl9 = false;
        $this$addSkillRow_u24lambda_u2415.setFont((Font)JBUI.Fonts.label((float)11.0f));
        $this$addSkillRow_u24lambda_u2415.setForeground((Color)new JBColor(7041664, 10265519));
        JBLabel securityLabel = bl8;
        Object object2 = new JPanel();
        JPanel $this$addSkillRow_u24lambda_u2416 = object2;
        boolean bl10 = false;
        $this$addSkillRow_u24lambda_u2416.setLayout(new BoxLayout($this$addSkillRow_u24lambda_u2416, 1));
        JPanel skillContent = object2;
        skillContent.add(nameLabel);
        skillContent.add(idLabel);
        object2 = descLabel.getText();
        if (!(object2 == null || StringsKt.isBlank((CharSequence)object2))) {
            skillContent.add(descLabel);
        }
        skillContent.add((Component)tagsLabel);
        skillContent.add((Component)inputModesLabel);
        skillContent.add((Component)outputModesLabel);
        skillContent.add((Component)examplesLabel);
        skillContent.add((Component)securityLabel);
        skillPanel.add((Component)skillContent, "Center");
        panel2.add(skillPanel);
    }

    private static final String addSkillRow$formatList(List<String> items, int max) {
        if (items == null || items.isEmpty()) {
            return "N/A";
        }
        String head = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)items, (int)max), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        return items.size() > max ? head + " \u2026(" + items.size() + ")" : head;
    }

    static /* synthetic */ String addSkillRow$formatList$default(List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 5;
        }
        return A2AAgentDetailDialog.addSkillRow$formatList(list, n);
    }

    private static final CharSequence addSkillRow$lambda$14$lambda$13(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String k = (String)entry.getKey();
        List v = (List)entry.getValue();
        Intrinsics.checkNotNull((Object)v);
        return k + ": " + CollectionsKt.joinToString$default((Iterable)v, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    private static final CharSequence addSkillRow$lambda$14(Map m) {
        return CollectionsKt.joinToString$default((Iterable)m.entrySet(), (CharSequence)", ", null, null, (int)0, null, A2AAgentDetailDialog::addSkillRow$lambda$14$lambda$13, (int)30, null);
    }
}

