/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.a2a.ui;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.a2a.A2AClientConsumer;
import cc.unitmesh.devti.a2a.ui.A2AAgentDetailDialog;
import cc.unitmesh.devti.provider.local.JsonLanguageField;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.a2a.spec.AgentCard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcc/unitmesh/devti/a2a/ui/A2AAgentCardPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "agentCard", "Lio/a2a/spec/AgentCard;", "a2aClientConsumer", "Lcc/unitmesh/devti/a2a/A2AClientConsumer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lio/a2a/spec/AgentCard;Lcc/unitmesh/devti/a2a/A2AClientConsumer;)V", "getAgentName", "", "getAgentDescription", "getAgentVersion", "getProviderName", "getSkillsCount", "", "borderColor", "Lcom/intellij/ui/JBColor;", "textGray", "mutedBackground", "MAX_AGENT_CARD_HEIGHT", "AGENT_CARD_WIDTH", "buildCardUI", "", "showAgentDetails", "testAgent", "A2AAgentTestDialog", "core"})
public final class A2AAgentCardPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final AgentCard agentCard;
    @NotNull
    private final A2AClientConsumer a2aClientConsumer;
    @NotNull
    private final JBColor borderColor;
    @NotNull
    private final JBColor textGray;
    @NotNull
    private final JBColor mutedBackground;
    private final int MAX_AGENT_CARD_HEIGHT;
    private final int AGENT_CARD_WIDTH;

    public A2AAgentCardPanel(@NotNull Project project, @NotNull AgentCard agentCard, @NotNull A2AClientConsumer a2aClientConsumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)agentCard, (String)"agentCard");
        Intrinsics.checkNotNullParameter((Object)a2aClientConsumer, (String)"a2aClientConsumer");
        super(new BorderLayout(0, 0));
        this.project = project;
        this.agentCard = agentCard;
        this.a2aClientConsumer = a2aClientConsumer;
        this.borderColor = new JBColor(15067115, 3948353);
        this.textGray = new JBColor(7041664, 10330280);
        this.mutedBackground = new JBColor(15987958, 2829616);
        this.MAX_AGENT_CARD_HEIGHT = 180;
        this.AGENT_CARD_WIDTH = 220;
        this.buildCardUI();
    }

    private final String getAgentName() {
        String string = this.agentCard.name();
        if (string == null) {
            string = "Unknown Agent";
        }
        return string;
    }

    private final String getAgentDescription() {
        String string = this.agentCard.description();
        if (string == null) {
            string = "No description available";
        }
        return string;
    }

    private final String getAgentVersion() {
        String string = this.agentCard.version();
        if (string == null) {
            string = "1.0.0";
        }
        return string;
    }

    private final String getProviderName() {
        Object object = this.agentCard.provider();
        if (object == null || (object = object.organization()) == null) {
            object = "Unknown";
        }
        return object;
    }

    private final int getSkillsCount() {
        List list = this.agentCard.skills();
        return list != null ? list.size() : 0;
    }

    private final void buildCardUI() {
        JPanel jPanel;
        JPanel jPanel2;
        this.setBackground(UIUtil.getPanelBackground());
        this.setBorder(new CompoundBorder(BorderFactory.createLineBorder((Color)this.borderColor), (Border)JBUI.Borders.empty((int)4, (int)8)));
        this.setPreferredSize(new Dimension(this.AGENT_CARD_WIDTH, this.MAX_AGENT_CARD_HEIGHT));
        JPanel $this$buildCardUI_u24lambda_u240 = jPanel2 = new JPanel(new BorderLayout(8, 0));
        boolean bl = false;
        $this$buildCardUI_u24lambda_u240.setBackground(UIUtil.getPanelBackground());
        $this$buildCardUI_u24lambda_u240.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)this.borderColor), JBUI.Borders.empty((int)2)));
        JPanel headerPanel2 = jPanel2;
        JPanel $this$buildCardUI_u24lambda_u241 = $this$buildCardUI_u24lambda_u240 = new JBLabel(this.getAgentName());
        boolean bl2 = false;
        $this$buildCardUI_u24lambda_u241.setFont((Font)JBUI.Fonts.label((float)14.0f).asBold());
        JPanel titleLabel = $this$buildCardUI_u24lambda_u240;
        JPanel $this$buildCardUI_u24lambda_u242 = $this$buildCardUI_u24lambda_u241 = new JBLabel("v" + this.getAgentVersion());
        boolean bl3 = false;
        $this$buildCardUI_u24lambda_u242.setFont((Font)JBUI.Fonts.label((float)10.0f));
        $this$buildCardUI_u24lambda_u242.setForeground((Color)this.textGray);
        JPanel versionLabel = $this$buildCardUI_u24lambda_u241;
        headerPanel2.add((Component)titleLabel, "Center");
        headerPanel2.add((Component)versionLabel, "East");
        JPanel $this$buildCardUI_u24lambda_u243 = $this$buildCardUI_u24lambda_u242 = new JPanel(new BorderLayout());
        boolean $i$a$-apply-A2AAgentCardPanel$buildCardUI$contentPanel$22 = false;
        $this$buildCardUI_u24lambda_u243.setBackground(UIUtil.getPanelBackground());
        JPanel contentPanel = $this$buildCardUI_u24lambda_u242;
        String descriptionText = this.getAgentDescription();
        JTextPane $i$a$-apply-A2AAgentCardPanel$buildCardUI$contentPanel$22 = new JTextPane();
        JComponent $this$buildCardUI_u24lambda_u244 = $i$a$-apply-A2AAgentCardPanel$buildCardUI$contentPanel$22;
        boolean bl4 = false;
        ((JEditorPane)$this$buildCardUI_u24lambda_u244).setText(descriptionText);
        $this$buildCardUI_u24lambda_u244.setFont((Font)JBUI.Fonts.label((float)12.0f));
        $this$buildCardUI_u24lambda_u244.setForeground((Color)this.textGray);
        ((JTextComponent)$this$buildCardUI_u24lambda_u244).setEditable(false);
        $this$buildCardUI_u24lambda_u244.setBackground(null);
        $this$buildCardUI_u24lambda_u244.setBorder(null);
        JTextPane descLabel = $i$a$-apply-A2AAgentCardPanel$buildCardUI$contentPanel$22;
        contentPanel.add((Component)descLabel, "Center");
        JComponent $this$buildCardUI_u24lambda_u245 = $this$buildCardUI_u24lambda_u244 = new JPanel(new FlowLayout(0, 0, 2));
        boolean bl5 = false;
        $this$buildCardUI_u24lambda_u245.setBackground(UIUtil.getPanelBackground());
        JComponent providerPanel = $this$buildCardUI_u24lambda_u244;
        JComponent $this$buildCardUI_u24lambda_u246 = $this$buildCardUI_u24lambda_u245 = new JBLabel("Provider: " + this.getProviderName());
        boolean bl6 = false;
        $this$buildCardUI_u24lambda_u246.setFont((Font)JBUI.Fonts.label((float)11.0f));
        $this$buildCardUI_u24lambda_u246.setForeground((Color)this.textGray);
        $this$buildCardUI_u24lambda_u246.setBackground((Color)this.mutedBackground);
        $this$buildCardUI_u24lambda_u246.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
        $this$buildCardUI_u24lambda_u246.setOpaque(true);
        JComponent providerLabel = $this$buildCardUI_u24lambda_u245;
        providerPanel.add(providerLabel);
        int skillsCount = this.getSkillsCount();
        if (skillsCount > 0) {
            JBLabel $this$buildCardUI_u24lambda_u247 = bl6 = new JBLabel("Skills: " + skillsCount);
            boolean bl7 = false;
            $this$buildCardUI_u24lambda_u247.setFont((Font)JBUI.Fonts.label((float)11.0f));
            $this$buildCardUI_u24lambda_u247.setForeground((Color)this.textGray);
            $this$buildCardUI_u24lambda_u247.setBackground((Color)this.mutedBackground);
            $this$buildCardUI_u24lambda_u247.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
            $this$buildCardUI_u24lambda_u247.setOpaque(true);
            JBLabel skillsLabel = bl6;
            providerPanel.add((Component)skillsLabel);
        }
        JPanel $this$buildCardUI_u24lambda_u248 = bl6 = new JPanel(new BorderLayout());
        boolean bl8 = false;
        $this$buildCardUI_u24lambda_u248.setBackground(UIUtil.getPanelBackground());
        $this$buildCardUI_u24lambda_u248.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        JPanel footerPanel = bl6;
        JPanel $this$buildCardUI_u24lambda_u2410 = $this$buildCardUI_u24lambda_u248 = new HyperlinkLabel("Details");
        boolean bl9 = false;
        $this$buildCardUI_u24lambda_u2410.setFont((Font)JBUI.Fonts.label((float)12.0f));
        $this$buildCardUI_u24lambda_u2410.addHyperlinkListener(arg_0 -> A2AAgentCardPanel.buildCardUI$lambda$10$lambda$9(this, arg_0));
        JPanel detailsLink = $this$buildCardUI_u24lambda_u248;
        JPanel $this$buildCardUI_u24lambda_u2412 = $this$buildCardUI_u24lambda_u2410 = new HyperlinkLabel("Test");
        boolean bl10 = false;
        $this$buildCardUI_u24lambda_u2412.setFont((Font)JBUI.Fonts.label((float)12.0f));
        $this$buildCardUI_u24lambda_u2412.addHyperlinkListener(arg_0 -> A2AAgentCardPanel.buildCardUI$lambda$12$lambda$11(this, arg_0));
        JPanel testLink = $this$buildCardUI_u24lambda_u2410;
        JPanel $this$buildCardUI_u24lambda_u2413 = jPanel = new JPanel(new FlowLayout(2, 4, 0));
        boolean bl11 = false;
        $this$buildCardUI_u24lambda_u2413.setBackground(UIUtil.getPanelBackground());
        $this$buildCardUI_u24lambda_u2413.add(testLink);
        $this$buildCardUI_u24lambda_u2413.add(detailsLink);
        JPanel linkWrapperPanel = jPanel;
        footerPanel.add((Component)providerPanel, "West");
        footerPanel.add((Component)linkWrapperPanel, "East");
        this.add((Component)headerPanel2, "North");
        this.add((Component)contentPanel, "Center");
        this.add((Component)footerPanel, "South");
    }

    private final void showAgentDetails() {
        A2AAgentDetailDialog dialog2 = new A2AAgentDetailDialog(this.project, this.agentCard);
        dialog2.show();
    }

    private final void testAgent() {
        A2AAgentTestDialog dialog2 = new A2AAgentTestDialog(this.project, this.agentCard, this.a2aClientConsumer);
        dialog2.show();
    }

    private static final void buildCardUI$lambda$10$lambda$9(A2AAgentCardPanel this$0, HyperlinkEvent it) {
        this$0.showAgentDetails();
    }

    private static final void buildCardUI$lambda$12$lambda$11(A2AAgentCardPanel this$0, HyperlinkEvent it) {
        this$0.testAgent();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcc/unitmesh/devti/a2a/ui/A2AAgentCardPanel$A2AAgentTestDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "agentCard", "Lio/a2a/spec/AgentCard;", "a2aClientConsumer", "Lcc/unitmesh/devti/a2a/A2AClientConsumer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lio/a2a/spec/AgentCard;Lcc/unitmesh/devti/a2a/A2AClientConsumer;)V", "messageField", "Ljavax/swing/JTextField;", "resultArea", "Lcc/unitmesh/devti/provider/local/JsonLanguageField;", "getAgentName", "", "createCenterPanel", "Ljavax/swing/JComponent;", "sendTestMessage", "", "core"})
    private static final class A2AAgentTestDialog
    extends DialogWrapper {
        @NotNull
        private final Project project;
        @NotNull
        private final AgentCard agentCard;
        @NotNull
        private final A2AClientConsumer a2aClientConsumer;
        @NotNull
        private final JTextField messageField;
        @NotNull
        private final JsonLanguageField resultArea;

        public A2AAgentTestDialog(@NotNull Project project, @NotNull AgentCard agentCard, @NotNull A2AClientConsumer a2aClientConsumer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)agentCard, (String)"agentCard");
            Intrinsics.checkNotNullParameter((Object)a2aClientConsumer, (String)"a2aClientConsumer");
            super(project);
            this.project = project;
            this.agentCard = agentCard;
            this.a2aClientConsumer = a2aClientConsumer;
            this.messageField = new JTextField("Hello, how can you help me?");
            this.resultArea = new JsonLanguageField(this.project, "", null, null, false, 28, null);
            this.setTitle("Test Agent: " + this.getAgentName());
            this.init();
        }

        private final String getAgentName() {
            String string;
            try {
                String string2 = this.agentCard.name();
                if (string2 == null) {
                    string2 = "Unknown Agent";
                }
                string = string2;
            }
            catch (Exception e) {
                string = "Unknown Agent";
            }
            return string;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JsonLanguageField jsonLanguageField;
            JButton jButton;
            JPanel panel2 = new JPanel(new BorderLayout(0, 10));
            panel2.setPreferredSize(new Dimension(600, 400));
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)new JLabel("Message:"), "North");
            topPanel.add((Component)this.messageField, "Center");
            JButton $this$createCenterPanel_u24lambda_u241 = jButton = new JButton("Send");
            boolean bl = false;
            $this$createCenterPanel_u24lambda_u241.addActionListener(arg_0 -> A2AAgentTestDialog.createCenterPanel$lambda$1$lambda$0(this, arg_0));
            JButton sendButton = jButton;
            topPanel.add((Component)sendButton, "East");
            JPanel bottomPanel = new JPanel(new BorderLayout());
            bottomPanel.add((Component)new JLabel("Response:"), "North");
            JsonLanguageField $this$createCenterPanel_u24lambda_u242 = jsonLanguageField = this.resultArea;
            boolean bl2 = false;
            $this$createCenterPanel_u24lambda_u242.setFont((Font)JBUI.Fonts.create((String)"Monospaced", (int)12));
            $this$createCenterPanel_u24lambda_u242.setPlaceholder("Click 'Send' to test the agent...");
            bottomPanel.add((Component)new JBScrollPane((Component)((Object)this.resultArea)), "Center");
            panel2.add((Component)topPanel, "North");
            panel2.add((Component)bottomPanel, "Center");
            return panel2;
        }

        private final void sendTestMessage() {
            String string = this.messageField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String message = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)message).length() == 0) {
                this.resultArea.setText("Please enter a message to send.");
                return;
            }
            try {
                this.resultArea.setText("Sending message...");
                String result = this.a2aClientConsumer.sendMessage(this.getAgentName(), message);
                this.resultArea.setText(result);
            }
            catch (Exception e) {
                this.resultArea.setText("Error sending message: " + e.getMessage());
                AutoDevNotifications.INSTANCE.error(this.project, "Failed to send A2A message: " + e.getMessage());
            }
        }

        private static final void createCenterPanel$lambda$1$lambda$0(A2AAgentTestDialog this$0, ActionEvent it) {
            this$0.sendTestMessage();
        }
    }
}

