/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.a2a;

import cc.unitmesh.devti.a2a.A2AClientConsumer;
import cc.unitmesh.devti.agent.extention.A2aServer;
import cc.unitmesh.devti.agent.extention.McpConfig;
import cc.unitmesh.devti.agent.extention.McpServer;
import cc.unitmesh.devti.settings.customize.AutoDevCustomizeSettingsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import io.a2a.spec.AgentCard;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0002J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\rJ\b\u0010\u001b\u001a\u00020\u000fH\u0002J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcc/unitmesh/devti/a2a/A2AService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "a2aClientConsumer", "Lcc/unitmesh/devti/a2a/A2AClientConsumer;", "availableAgents", "", "Lio/a2a/spec/AgentCard;", "cached", "", "", "initialize", "", "servers", "Lcc/unitmesh/devti/agent/extention/A2aServer;", "getAvailableAgents", "sendMessage", "agentName", "message", "isAvailable", "", "getEnabledServers", "", "content", "refreshAvailableAgents", "getClientConsumer", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nA2AService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 A2AService.kt\ncc/unitmesh/devti/a2a/A2AService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n526#2:125\n511#2,6:126\n453#2:132\n403#2:133\n1238#3,4:134\n*S KotlinDebug\n*F\n+ 1 A2AService.kt\ncc/unitmesh/devti/a2a/A2AService\n*L\n98#1:125\n98#1:126,6\n101#1:132\n101#1:133\n101#1:134,4\n*E\n"})
public final class A2AService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private A2AClientConsumer a2aClientConsumer;
    @NotNull
    private List<AgentCard> availableAgents;
    @NotNull
    private final Map<String, List<AgentCard>> cached;

    public A2AService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.availableAgents = CollectionsKt.emptyList();
        this.cached = new LinkedHashMap();
    }

    public final void initialize() {
        McpConfig mcpConfig;
        String mcpServerConfig = AutoDevCustomizeSettingsKt.getCustomizeSetting(this.project).getMcpServerConfig();
        if (((CharSequence)mcpServerConfig).length() == 0) {
            this.a2aClientConsumer = null;
            this.availableAgents = CollectionsKt.emptyList();
            return;
        }
        if (this.cached.containsKey(mcpServerConfig)) {
            List list = this.cached.get(mcpServerConfig);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            this.availableAgents = list;
            return;
        }
        McpConfig mcpConfig2 = mcpConfig = McpServer.Companion.load(mcpServerConfig);
        Map<String, A2aServer> map = mcpConfig2 != null ? mcpConfig2.getA2aServers() : null;
        if (map == null || map.isEmpty()) {
            this.a2aClientConsumer = null;
            this.availableAgents = CollectionsKt.emptyList();
            return;
        }
        List servers = CollectionsKt.toList((Iterable)mcpConfig.getA2aServers().values());
        this.initialize(servers);
        this.cached.put(mcpServerConfig, this.availableAgents);
    }

    private final void initialize(List<A2aServer> servers) {
        try {
            A2AClientConsumer a2AClientConsumer = this.a2aClientConsumer = new A2AClientConsumer();
            if (a2AClientConsumer != null) {
                a2AClientConsumer.init(servers);
            }
            this.refreshAvailableAgents();
        }
        catch (Exception e) {
            this.a2aClientConsumer = null;
            this.availableAgents = CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final List<AgentCard> getAvailableAgents() {
        return this.availableAgents;
    }

    @Nullable
    public final String sendMessage(@NotNull String agentName, @NotNull String message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            A2AClientConsumer a2AClientConsumer = this.a2aClientConsumer;
            string = a2AClientConsumer != null ? a2AClientConsumer.sendMessage(agentName, message) : null;
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    public final boolean isAvailable() {
        return this.a2aClientConsumer != null && !((Collection)this.availableAgents).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<String, A2aServer> getEnabledServers(@NotNull String content) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        McpConfig mcpConfig = McpServer.Companion.load(content);
        Object object = mcpConfig;
        if (object != null && (object = ((McpConfig)object).getA2aServers()) != null) {
            void $this$mapValuesTo$iv$iv;
            Map $this$filterTo$iv$iv;
            Object $this$filter$iv = object;
            boolean $i$f$filter = false;
            Object object2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!true) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$filterTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void entry;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                A2aServer a2aServer = (A2aServer)entry.getValue();
                map3.put(k, a2aServer);
            }
            map = destination$iv$iv;
        } else {
            map = null;
        }
        return map;
    }

    private final void refreshAvailableAgents() {
        Object object;
        A2AService a2AService;
        A2AService a2AService2 = this;
        try {
            a2AService = a2AService2;
            Object object2 = this.a2aClientConsumer;
            if (object2 == null || (object2 = ((A2AClientConsumer)object2).listAgents()) == null) {
                object2 = CollectionsKt.emptyList();
            }
            object = object2;
        }
        catch (Exception e) {
            a2AService = a2AService2;
            object = CollectionsKt.emptyList();
        }
        a2AService.availableAgents = object;
    }

    @Nullable
    public final A2AClientConsumer getClientConsumer() {
        return this.a2aClientConsumer;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcc/unitmesh/devti/a2a/A2AService$Companion;", "", "<init>", "()V", "getInstance", "Lcc/unitmesh/devti/a2a/A2AService;", "project", "Lcom/intellij/openapi/project/Project;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final A2AService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(A2AService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (A2AService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

