/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.a2a;

import cc.unitmesh.devti.agent.extention.A2aServer;
import com.intellij.openapi.diagnostic.Logger;
import io.a2a.A2A;
import io.a2a.client.Client;
import io.a2a.client.ClientEvent;
import io.a2a.client.MessageEvent;
import io.a2a.client.TaskEvent;
import io.a2a.client.TaskUpdateEvent;
import io.a2a.client.config.ClientConfig;
import io.a2a.client.http.A2ACardResolver;
import io.a2a.client.transport.jsonrpc.JSONRPCTransport;
import io.a2a.client.transport.jsonrpc.JSONRPCTransportConfig;
import io.a2a.client.transport.spi.ClientTransportConfig;
import io.a2a.spec.AgentCard;
import io.a2a.spec.Message;
import io.a2a.spec.Part;
import io.a2a.spec.TextPart;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\rJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/a2a/A2AClientConsumer;", "", "<init>", "()V", "clientMap", "", "", "Lio/a2a/client/Client;", "cardMap", "Lio/a2a/spec/AgentCard;", "responseMap", "Ljava/util/concurrent/CompletableFuture;", "init", "", "servers", "Lcc/unitmesh/devti/agent/extention/A2aServer;", "listAgents", "sendMessage", "agentName", "msgText", "handleClientEvent", "", "event", "Lio/a2a/client/ClientEvent;", "card", "handleStreamingError", "error", "", "extractTextFromMessage", "message", "Lio/a2a/spec/Message;", "core"})
@SourceDebugExtension(value={"SMAP\nA2AClientConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 A2AClientConsumer.kt\ncc/unitmesh/devti/a2a/A2AClientConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n1855#2,2:140\n11#3:142\n*S KotlinDebug\n*F\n+ 1 A2AClientConsumer.kt\ncc/unitmesh/devti/a2a/A2AClientConsumer\n*L\n25#1:140,2\n81#1:142\n*E\n"})
public final class A2AClientConsumer {
    @NotNull
    private final Map<String, Client> clientMap = new ConcurrentHashMap();
    @NotNull
    private final Map<String, AgentCard> cardMap = new ConcurrentHashMap();
    @NotNull
    private final Map<String, CompletableFuture<String>> responseMap = new ConcurrentHashMap();

    @NotNull
    public final List<Client> init(@NotNull List<A2aServer> servers) {
        Intrinsics.checkNotNullParameter(servers, (String)"servers");
        Iterable $this$forEach$iv = servers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            A2aServer server = (A2aServer)element$iv;
            boolean bl = false;
            try {
                A2ACardResolver cardResolver = new A2ACardResolver(server.getUrl());
                AgentCard agentCard = cardResolver.getAgentCard();
                String agentName = agentCard.name();
                Object[] objectArray = new String[]{"text", "application/json"};
                ClientConfig clientConfig = new ClientConfig.Builder().setAcceptedOutputModes(CollectionsKt.listOf((Object[])objectArray)).build();
                List consumers = CollectionsKt.listOf((arg_0, arg_1) -> A2AClientConsumer.init$lambda$2$lambda$0(this, agentName, arg_0, arg_1));
                Consumer<Throwable> errorHandler = arg_0 -> A2AClientConsumer.init$lambda$2$lambda$1(this, agentName, arg_0);
                Client client = Client.builder((AgentCard)agentCard).clientConfig(clientConfig).withTransport(JSONRPCTransport.class, (ClientTransportConfig)new JSONRPCTransportConfig()).addConsumers(consumers).streamingErrorHandler(errorHandler).build();
                this.cardMap.put(agentName, agentCard);
                this.clientMap.put(agentName, client);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize A2A client for " + server.getUrl() + ": " + e.getMessage(), e);
            }
        }
        return CollectionsKt.toList((Iterable)this.clientMap.values());
    }

    @NotNull
    public final List<AgentCard> listAgents() {
        return CollectionsKt.toList((Iterable)this.cardMap.values());
    }

    @NotNull
    public final String sendMessage(@NotNull String agentName, @NotNull String msgText) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter((Object)msgText, (String)"msgText");
        Client client = this.clientMap.get(agentName);
        if (client == null) {
            return "Failed to find A2A client for " + agentName + ". Available clients: " + this.clientMap.keySet();
        }
        Client client2 = client;
        try {
            Message message = A2A.toUserMessage((String)msgText);
            CompletableFuture responseFuture = new CompletableFuture();
            this.responseMap.put(agentName, responseFuture);
            client2.sendMessage(message, null);
            object = responseFuture.get(120L, TimeUnit.SECONDS);
            Intrinsics.checkNotNull(object);
            object = (String)object;
        }
        catch (Exception e) {
            this.responseMap.remove(agentName);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(A2AClientConsumer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to send message to " + agentName + ": " + e.getMessage(), (Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            return string;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleClientEvent(ClientEvent event, AgentCard card, String agentName) {
        ClientEvent clientEvent = event;
        if (clientEvent instanceof MessageEvent) {
            Message message = ((MessageEvent)event).getMessage();
            CompletableFuture<String> responseFuture = this.responseMap.get(agentName);
            if (responseFuture != null && !responseFuture.isDone()) {
                try {
                    Intrinsics.checkNotNull((Object)message);
                    String responseText = this.extractTextFromMessage(message);
                    responseFuture.complete(responseText);
                }
                catch (Exception e) {
                    responseFuture.completeExceptionally(e);
                }
                finally {
                    this.responseMap.remove(agentName);
                }
            }
        } else if (!(clientEvent instanceof TaskEvent) && !(clientEvent instanceof TaskUpdateEvent)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void handleStreamingError(Throwable error, String agentName) {
        CompletableFuture<String> responseFuture = this.responseMap.get(agentName);
        if (responseFuture != null && !responseFuture.isDone()) {
            responseFuture.completeExceptionally(error);
            this.responseMap.remove(agentName);
        }
    }

    private final String extractTextFromMessage(Message message) {
        List list = message.getParts();
        if (list == null) {
            return "";
        }
        List parts = list;
        return CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"", null, null, (int)0, null, A2AClientConsumer::extractTextFromMessage$lambda$3, (int)30, null);
    }

    private static final void init$lambda$2$lambda$0(A2AClientConsumer this$0, String $agentName, ClientEvent event, AgentCard card) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Intrinsics.checkNotNull((Object)$agentName);
        this$0.handleClientEvent(event, card, $agentName);
    }

    private static final void init$lambda$2$lambda$1(A2AClientConsumer this$0, String $agentName, Throwable error) {
        Intrinsics.checkNotNull((Object)error);
        Intrinsics.checkNotNull((Object)$agentName);
        this$0.handleStreamingError(error, $agentName);
    }

    private static final CharSequence extractTextFromMessage$lambda$3(Part part) {
        if (part instanceof TextPart) {
            String string = ((TextPart)part).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
        return part.toString();
    }
}

