/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.database.util;

import cc.unitmesh.database.util.DatabaseSchemaAssistant;
import cc.unitmesh.database.util.SqlUtilKt;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/database/util/SqlContextBuilder;", "", "<init>", "()V", "getCurrentNamespace", "Lcom/intellij/database/util/ObjectPath;", "sqlFile", "Lcom/intellij/sql/psi/SqlFile;", "getSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "ds", "Lcom/intellij/database/psi/DbDataSource;", "currentNamespace", "formatSchema", "", "schema", "describeTable", "table", "Lcom/intellij/database/model/basic/BasicTable;", "buildDatabaseInfo", "project", "Lcom/intellij/openapi/project/Project;", "ext-database"})
@SourceDebugExtension(value={"SMAP\nSqlContextBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlContextBuilder.kt\ncc/unitmesh/database/util/SqlContextBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1603#2,9:53\n1855#2:62\n1856#2:64\n1612#2:65\n1#3:63\n*S KotlinDebug\n*F\n+ 1 SqlContextBuilder.kt\ncc/unitmesh/database/util/SqlContextBuilder\n*L\n28#1:53,9\n28#1:62\n28#1:64\n28#1:65\n28#1:63\n*E\n"})
public final class SqlContextBuilder {
    @NotNull
    public static final SqlContextBuilder INSTANCE = new SqlContextBuilder();

    private SqlContextBuilder() {
    }

    @Nullable
    public final ObjectPath getCurrentNamespace(@NotNull SqlFile sqlFile) {
        JdbcConsole console2;
        Intrinsics.checkNotNullParameter((Object)sqlFile, (String)"sqlFile");
        JdbcConsole jdbcConsole = console2 = JdbcConsoleProvider.getValidConsole((Project)sqlFile.getProject(), (VirtualFile)sqlFile.getVirtualFile());
        return jdbcConsole != null ? jdbcConsole.getCurrentNamespace() : null;
    }

    @Nullable
    public final BasicSchema getSchema(@Nullable DbDataSource ds, @Nullable ObjectPath currentNamespace) {
        DbDataSource dbDataSource = ds;
        DasModel dasModel = dbDataSource != null ? dbDataSource.getModel() : null;
        BasicModel basicModel = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (basicModel == null) {
            return null;
        }
        BasicModel basicModel2 = basicModel;
        JBIterable jBIterable = QNameUtil.findByPath((DasModel)((DasModel)basicModel2), (ObjectPath)currentNamespace);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"findByPath(...)");
        DasObject dasObject = (DasObject)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
        if (dasObject == null) {
            return null;
        }
        DasObject dasObject2 = dasObject;
        return dasObject2 instanceof BasicSchema ? (BasicSchema)dasObject2 : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String formatSchema(@NotNull BasicSchema schema) {
        String string;
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Family family = schema.familyOf(ObjectKind.TABLE);
        if (family != null && (jBIterable = family.jbi()) != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = (Iterable)jBIterable;
            boolean $i$f$mapNotNull = false;
            void var6_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                BasicTable it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                BasicElement it = (BasicElement)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof BasicTable ? (BasicTable)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n\n", null, null, (int)0, null, SqlContextBuilder::formatSchema$lambda$1, (int)30, null);
        } else {
            string = null;
        }
        return string;
    }

    private final String describeTable(BasicTable table) {
        String string = table.getName();
        PositioningNamingFamily positioningNamingFamily = table.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
        return StringsKt.trimMargin$default((String)("\n        |create table " + string + " {\n        |  " + CollectionsKt.joinToString$default((Iterable)((Iterable)positioningNamingFamily), (CharSequence)",\n  ", null, null, (int)0, null, SqlContextBuilder::describeTable$lambda$2, (int)30, null) + "\n        |}\n        "), null, (int)1, null);
    }

    @NotNull
    public final String buildDatabaseInfo(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<RawDataSource> dataSources = DatabaseSchemaAssistant.INSTANCE.allRawDatasource(project);
        return CollectionsKt.joinToString$default((Iterable)dataSources, (CharSequence)"\n", null, null, (int)0, null, SqlContextBuilder::buildDatabaseInfo$lambda$3, (int)30, null);
    }

    private static final CharSequence formatSchema$lambda$1(BasicTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.describeTable(it);
    }

    private static final CharSequence describeTable$lambda$2(BasicTableOrViewColumn it) {
        String string = it.getName();
        Intrinsics.checkNotNull((Object)it);
        return string + " " + SqlUtilKt.columnType(it);
    }

    private static final CharSequence buildDatabaseInfo$lambda$3(RawDataSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RawConnectionConfig rawConnectionConfig = it.getConnectionConfig();
        return StringsKt.trimIndent((String)("\n            DatabaseName: " + it.getDatabaseVersion().name + "\n            DatabaseVersion: " + it.getDatabaseVersion().version + "\n            Database: " + it.getName() + "\n            ConnectionConfig: " + (rawConnectionConfig != null ? rawConnectionConfig.getUrl() : null) + "\n            "));
    }
}

