/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.database.util;

import cc.unitmesh.database.util.DatabaseSchemaAssistant;
import com.intellij.database.DataBus;
import com.intellij.database.Dbms;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0006J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcc/unitmesh/database/util/SQLExecutor;", "", "<init>", "()V", "DANGEROUS_OPERATIONS", "", "", "checkSqlSafety", "Lkotlin/Pair;", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "executeSqlQuery", "sql", "getAttachDataSourceRunners", "", "Lcom/intellij/database/script/PersistenceConsoleProvider$Runner;", "info", "Lcom/intellij/database/console/JdbcConsoleProvider$Info;", "executeSqlInConsole", "console", "Lcom/intellij/database/console/JdbcConsole;", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "executeSql", "query", "createConsole", "file", "Lcom/intellij/testFramework/LightVirtualFile;", "MyCompatDataConsumer", "ext-database"})
@SourceDebugExtension(value={"SMAP\nSQLExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLExecutor.kt\ncc/unitmesh/database/util/SQLExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1747#2,3:211\n*S KotlinDebug\n*F\n+ 1 SQLExecutor.kt\ncc/unitmesh/database/util/SQLExecutor\n*L\n47#1:211,3\n*E\n"})
public final class SQLExecutor {
    @NotNull
    public static final SQLExecutor INSTANCE = new SQLExecutor();
    @NotNull
    private static final Set<String> DANGEROUS_OPERATIONS;

    private SQLExecutor() {
    }

    private final Pair<Boolean, String> checkSqlSafety(Project project, PsiFile psiFile2) {
        SqlFile sqlFile = psiFile2 instanceof SqlFile ? (SqlFile)psiFile2 : null;
        if (sqlFile == null) {
            return new Pair((Object)true, (Object)"Not a SQL file");
        }
        SqlFile sqlFile2 = sqlFile;
        Object object = ActionsKt.runReadAction(() -> SQLExecutor.checkSqlSafety$lambda$0(sqlFile2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        List statements = (List)object;
        for (SqlElement statement : statements) {
            boolean bl;
            Object operation;
            block6: {
                PsiElement firstChild = statement.getFirstChild();
                Object object2 = firstChild;
                if (object2 == null || (object2 = object2.getText()) == null) continue;
                String string = ((String)object2).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                object2 = string;
                if (string == null) {
                    continue;
                }
                operation = object2;
                Iterable $this$any$iv = DANGEROUS_OPERATIONS;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)((CharSequence)operation), (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return new Pair((Object)true, (Object)("Dangerous operation detected: " + (String)operation + ". Please confirm this operation."));
        }
        return new Pair((Object)false, (Object)"");
    }

    @NotNull
    public final String executeSqlQuery(@NotNull Project project, @NotNull String sql) {
        JdbcConsole console2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        LightVirtualFile file = new LightVirtualFile("temp.sql", (CharSequence)sql);
        PsiFile psiFile2 = (PsiFile)ActionsKt.runReadAction(() -> SQLExecutor.executeSqlQuery$lambda$2(project, file));
        if (psiFile2 == null) {
            return "ShireError[Database]: Can't find PSI file";
        }
        PsiFile psiFile3 = psiFile2;
        Pair<Boolean, String> pair = this.checkSqlSafety(project, psiFile3);
        boolean isDangerous = (Boolean)pair.component1();
        String reason = (String)pair.component2();
        if (isDangerous) {
            return "ShireError[Database]: " + reason;
        }
        RawDataSource rawDataSource = (RawDataSource)CollectionsKt.firstOrNull(DatabaseSchemaAssistant.INSTANCE.allRawDatasource(project));
        if (rawDataSource == null) {
            throw new IllegalArgumentException("ShireError[Database]: No database found");
        }
        RawDataSource dataSource = rawDataSource;
        List list = DatabaseSettings.getSettings().execOptions;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execOptions");
        DatabaseSettings.ExecOption execOptions = (DatabaseSettings.ExecOption)CollectionsKt.last((List)list);
        List list2 = JdbcConsole.getActiveConsoles((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getActiveConsoles(...)");
        JdbcConsole jdbcConsole = (JdbcConsole)CollectionsKt.firstOrNull((List)list2);
        if (jdbcConsole == null && (jdbcConsole = JdbcConsoleProvider.getValidConsole((Project)project, (VirtualFile)((VirtualFile)file))) == null) {
            jdbcConsole = this.createConsole(project, file);
        }
        if ((console2 = jdbcConsole) != null) {
            return this.executeSqlInConsole(console2, sql, dataSource);
        }
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            throw new IllegalArgumentException("ShireError[Database]: No editor found");
        }
        Editor editor2 = editor;
        ScriptModel scriptModel = SqlPsiFacade.getInstance((Project)project).createScriptModel(psiFile3);
        Intrinsics.checkNotNullExpressionValue((Object)scriptModel, (String)"createScriptModel(...)");
        ScriptModel scriptModel2 = scriptModel;
        JdbcConsoleProvider.Info info = new JdbcConsoleProvider.Info(psiFile3, psiFile3, (EditorEx)editor2, scriptModel2, execOptions, null);
        List runners = (List)ActionsKt.runReadAction(() -> SQLExecutor.executeSqlQuery$lambda$3(info));
        if (runners.size() == 1) {
            Ref.ObjectRef result = new Ref.ObjectRef();
            result.element = "";
            ActionsKt.runInEdt$default(null, () -> SQLExecutor.executeSqlQuery$lambda$4(result, project, dataSource, sql), (int)1, null);
            if (((CharSequence)((Object)StringsKt.trim((CharSequence)((String)result.element))).toString()).length() == 0) {
                result.element = "ShireError[Database]: No result for " + sql;
            }
            return (String)result.element;
        }
        Object[] objectArray = new Class[]{List.class, EditorEx.class, Object.class};
        Method chooseAndRunRunnersMethod = Class.forName("com.intellij.database.intentions.RunQueryInConsoleIntentionAction$Manager").getDeclaredMethod("chooseAndRunRunners", (Class<?>[])objectArray);
        objectArray = new Object[]{runners, info.editor, null};
        chooseAndRunRunnersMethod.invoke(null, objectArray);
        return "ShireError[Database]: Currently not support multiple runners";
    }

    private final List<PersistenceConsoleProvider.Runner> getAttachDataSourceRunners(JdbcConsoleProvider.Info info) {
        EditorEx editorEx = info.editor;
        Intrinsics.checkNotNull((Object)editorEx);
        VirtualFile virtualFile = editorEx.getVirtualFile();
        Project project = info.originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Intrinsics.checkNotNull((Object)virtualFile);
        String title = SessionsUtil.getSessionTitle((VirtualFile)virtualFile);
        Consumer consumer = arg_0 -> SQLExecutor.getAttachDataSourceRunners$lambda$6(project2, virtualFile, info, arg_0);
        List list = DatabaseRunners.getAttachDataSourceRunners((PsiFile)info.file, (String)title, (Consumer)consumer);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttachDataSourceRunners(...)");
        return list;
    }

    private final String executeSqlInConsole(JdbcConsole console2, String sql, RawDataSource dataSource) {
        CompletableFuture future = new CompletableFuture();
        Object v = ApplicationManager.getApplication().executeOnPooledThread(() -> SQLExecutor.executeSqlInConsole$lambda$7(console2, sql, dataSource, future)).get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        return (String)v;
    }

    private final String executeSql(Project project, RawDataSource dataSource, String query) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        LocalDataSource localDataSource = DbImplUtilCore.getLocalDataSource((DasDataSource)((DasDataSource)dataSource));
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getLocalDataSource(...)");
        LocalDataSource localDs = localDataSource;
        DatabaseSession session = DatabaseSessionManager.getSession((Project)project, (DatabaseConnectionPoint)((DatabaseConnectionPoint)localDs));
        DataBus.Consuming consuming = session.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)consuming, (String)"getMessageBus(...)");
        DataBus.Consuming messageBus = consuming;
        messageBus.addConsumer((DataConsumer)new MyCompatDataConsumer(future){
            private List<GridRow> result;
            final /* synthetic */ CompletableFuture<String> $future;
            {
                this.$future = $future;
                this.result = new ArrayList<E>();
            }

            public final List<GridRow> getResult() {
                return this.result;
            }

            public final void setResult(List<GridRow> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.result = list;
            }

            public void addRows(GridDataRequest.Context context, List<? extends GridRow> rows) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(rows, (String)"rows");
                CollectionsKt.addAll((Collection)this.result, (Iterable)rows);
                if (rows.size() < 100) {
                    this.$future.complete(this.result.toString());
                }
            }

            public void afterLastRowAdded(GridDataRequest.Context context, int total) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.$future.complete(this.result.toString());
            }
        });
        DataRequest.Constraints constraints = DataRequest.QueryRequest.newConstraints((Dbms)dataSource.getDbms());
        DataRequest.QueryRequest request2 = new DataRequest.QueryRequest(session, query, constraints){};
        messageBus.getDataProducer().processRequest((GridDataRequest)request2);
        return future.get(30L, TimeUnit.SECONDS);
    }

    private final JdbcConsole createConsole(Project project, LightVirtualFile file) {
        DatabaseSession databaseSession = JdbcConsoleProvider.findOrCreateSession((Project)project, (VirtualFile)((VirtualFile)file));
        if (databaseSession == null) {
            return null;
        }
        DatabaseSession attached = databaseSession;
        return JdbcConsoleProvider.attachConsole((Project)project, (DatabaseSession)attached, (VirtualFile)((VirtualFile)file));
    }

    private static final List checkSqlSafety$lambda$0(SqlFile $sqlFile) {
        return $sqlFile.getDdl();
    }

    private static final PsiFile executeSqlQuery$lambda$2(Project $project, LightVirtualFile $file) {
        return PsiManager.getInstance((Project)$project).findFile((VirtualFile)$file);
    }

    private static final List executeSqlQuery$lambda$3(JdbcConsoleProvider.Info $info) {
        return INSTANCE.getAttachDataSourceRunners($info);
    }

    private static final Unit executeSqlQuery$lambda$4(Ref.ObjectRef $result, Project $project, RawDataSource $dataSource, String $sql) {
        String string = INSTANCE.executeSql($project, $dataSource, $sql);
        if (string == null) {
            string = "Error";
        }
        $result.element = string;
        return Unit.INSTANCE;
    }

    private static final void getAttachDataSourceRunners$lambda$6$lambda$5(JdbcConsole $console, JdbcConsoleProvider.Info $info) {
        JdbcConsoleProvider.doRunQueryInConsole((JdbcConsole)$console, (JdbcConsoleProvider.Info)$info);
    }

    private static final void getAttachDataSourceRunners$lambda$6(Project $project, VirtualFile $virtualFile, JdbcConsoleProvider.Info $info, DatabaseSession newSession) {
        DatabaseSession databaseSession = newSession;
        Intrinsics.checkNotNull((Object)databaseSession);
        JdbcConsole console2 = JdbcConsoleProvider.attachConsole((Project)$project, (DatabaseSession)databaseSession, (VirtualFile)$virtualFile);
        if (console2 != null) {
            Runnable runnable = () -> SQLExecutor.getAttachDataSourceRunners$lambda$6$lambda$5(console2, $info);
            if (DbVFSUtils.isAssociatedWithDataSourceAndSchema((VirtualFile)$virtualFile)) {
                runnable.run();
            } else {
                EditorEx editorEx = $info.editor;
                Intrinsics.checkNotNull((Object)editorEx);
                DatabaseRunners.chooseSchemaAndRun((Editor)((Editor)editorEx), (Runnable)runnable);
            }
        }
    }

    private static final String executeSqlInConsole$lambda$7(JdbcConsole $console, String $sql, RawDataSource $dataSource, CompletableFuture $future) {
        DataBus.Consuming consuming = $console.getSession().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)consuming, (String)"getMessageBus(...)");
        DataBus.Consuming messageBus = consuming;
        DataRequest dataRequest = EvaluationRequest.newRequest((DataRequest.OwnerEx)((DataRequest.OwnerEx)$console), (String)$sql, (Dbms)$dataSource.getDbms());
        Intrinsics.checkNotNullExpressionValue((Object)dataRequest, (String)"newRequest(...)");
        DataRequest newConsoleRequest = dataRequest;
        messageBus.getDataProducer().processRequest((GridDataRequest)newConsoleRequest);
        messageBus.addConsumer((DataConsumer)new MyCompatDataConsumer($future){
            private List<GridRow> result;
            final /* synthetic */ CompletableFuture<String> $future;
            {
                this.$future = $future;
                this.result = new ArrayList<E>();
            }

            public final List<GridRow> getResult() {
                return this.result;
            }

            public final void setResult(List<GridRow> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.result = list;
            }

            public void addRows(GridDataRequest.Context context, List<? extends GridRow> rows) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(rows, (String)"rows");
                CollectionsKt.addAll((Collection)this.result, (Iterable)rows);
                if (rows.size() < 100) {
                    this.$future.complete(this.result.toString());
                }
            }
        });
        return (String)$future.get();
    }

    static {
        Object[] objectArray = new String[]{"DELETE", "DROP", "TRUNCATE", "ALTER", "GRANT", "REVOKE"};
        DANGEROUS_OPERATIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/database/util/SQLExecutor$MyCompatDataConsumer;", "Lcom/intellij/database/datagrid/DataConsumer;", "<init>", "()V", "setColumns", "", "context", "Lcom/intellij/database/datagrid/GridDataRequest$Context;", "subQueryIndex", "", "resultSetIndex", "columns", "", "Lcom/intellij/database/datagrid/GridColumn;", "firstRowNum", "(Lcom/intellij/database/datagrid/GridDataRequest$Context;II[Lcom/intellij/database/datagrid/GridColumn;I)V", "afterLastRowAdded", "total", "ext-database"})
    public static abstract class MyCompatDataConsumer
    implements DataConsumer {
        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, @NotNull GridColumn[] columns2, int firstRowNum) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        }

        public void afterLastRowAdded(@NotNull GridDataRequest.Context context, int total) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        }
    }
}

