/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.database.util;

import cc.unitmesh.database.util.SQLExecutor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.project.Project;
import com.intellij.sql.SqlUtilFun;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0012\u001a\u00020\fJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nJ\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\nJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u0005J\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0010J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/database/util/DatabaseSchemaAssistant;", "", "<init>", "()V", "getDataSources", "", "Lcom/intellij/database/psi/DbDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "listSchemas", "", "allRawDatasource", "Lcom/intellij/database/model/RawDataSource;", "getDatabase", "dbName", "getAllTables", "Lcom/intellij/database/model/DasTable;", "getTableByDataSource", "dataSource", "getTable", "tableName", "executeSqlQuery", "sql", "isSQLiteTable", "", "rawDataSource", "table", "getTableColumns", "tables", "getTableColumn", "displayTable", "ext-database"})
@SourceDebugExtension(value={"SMAP\nDatabaseSchemaAssistant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSchemaAssistant.kt\ncc/unitmesh/database/util/DatabaseSchemaAssistant\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1603#2,9:105\n1855#2:114\n1603#2,9:115\n1855#2:124\n1856#2:126\n1612#2:127\n1856#2:129\n1612#2:130\n1549#2:131\n1620#2,3:132\n288#2,2:135\n1549#2:137\n1620#2,3:138\n1549#2:141\n1620#2,3:142\n1603#2,9:145\n1855#2:154\n1856#2:156\n1612#2:157\n1#3:125\n1#3:128\n1#3:155\n*S KotlinDebug\n*F\n+ 1 DatabaseSchemaAssistant.kt\ncc/unitmesh/database/util/DatabaseSchemaAssistant\n*L\n20#1:105,9\n20#1:114\n21#1:115,9\n21#1:124\n21#1:126\n21#1:127\n20#1:129\n20#1:130\n38#1:131\n38#1:132,3\n44#1:135,2\n48#1:137\n48#1:138,3\n78#1:141\n78#1:142,3\n81#1:145,9\n81#1:154\n81#1:156\n81#1:157\n21#1:125\n20#1:128\n81#1:155\n*E\n"})
public final class DatabaseSchemaAssistant {
    @NotNull
    public static final DatabaseSchemaAssistant INSTANCE = new DatabaseSchemaAssistant();

    private DatabaseSchemaAssistant() {
    }

    @NotNull
    public final List<DbDataSource> getDataSources(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list = DbPsiFacade.getInstance((Project)project).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        return CollectionsKt.toList((Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String listSchemas(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JBIterable jBIterable = DbUtil.getDataSources((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getDataSources(...)");
        JBIterable dataSources = jBIterable;
        if (dataSources.isEmpty()) {
            return "[Database]: No database found";
        }
        Iterable $this$mapNotNull$iv = (Iterable)dataSources;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            void $this$mapNotNullTo$iv$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbDataSource it = (DbDataSource)element$iv$iv;
            boolean bl2 = false;
            List list = DasUtil.getTables((DasDataSource)((DasDataSource)it)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            Iterable $this$mapNotNull$iv2 = list;
            boolean $i$f$mapNotNull2 = false;
            Iterable iterable2 = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv2;
                Object element$iv$iv2 = element$iv$iv$iv2 = iterator2.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                DasTable it2 = (DasTable)element$iv$iv2;
                boolean bl3 = false;
                DasObject dasObject = it2.getDasParent();
                if ((Intrinsics.areEqual((Object)(dasObject != null ? dasObject.getName() : null), (Object)"information_schema") ? null : INSTANCE.getTableColumn(it2)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List tableSchema = (List)destination$iv$iv2;
            if (tableSchema.isEmpty()) {
                string = null;
            } else {
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String name = StringsKt.substringBeforeLast$default((String)string2, (char)'@', null, (int)2, null);
                string = "Database Schema result:\n\n```sql\n-- DATABASE NAME: " + name + ";\n" + CollectionsKt.joinToString$default((Iterable)tableSchema, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n```\n";
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List dataItems = (List)destination$iv$iv;
        if (dataItems.isEmpty()) {
            return "[Database]: No table found";
        }
        return CollectionsKt.joinToString$default((Iterable)dataItems, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RawDataSource> allRawDatasource(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
        DbPsiFacade dbPsiFacade2 = dbPsiFacade;
        List list = dbPsiFacade2.getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void dataSource;
            DbDataSource dbDataSource = (DbDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(dbPsiFacade2.getDataSourceManager((DbDataSource)dataSource).getDataSources());
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final RawDataSource getDatabase(@NotNull Project project, @NotNull String dbName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            Iterable $this$firstOrNull$iv = this.allRawDatasource(project);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RawDataSource it = (RawDataSource)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)dbName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DasTable> getAllTables(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$map$iv = this.allRawDatasource(project);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RawDataSource rawDataSource = (RawDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String schemaName = StringsKt.substringBeforeLast$default((String)string, (char)'@', null, (int)2, null);
            collection.add(DasUtil.getTables((DasDataSource)((DasDataSource)it)).filter(arg_0 -> DatabaseSchemaAssistant.getAllTables$lambda$5$lambda$4(new Function1(schemaName, (RawDataSource)it){
                final /* synthetic */ String $schemaName;
                final /* synthetic */ RawDataSource $it;
                {
                    this.$schemaName = $schemaName;
                    this.$it = $it;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(DasTable table) {
                    boolean bl;
                    block2: {
                        block3: {
                            if (!Intrinsics.areEqual((Object)((DasNamed)table).getKind(), (Object)ObjectKind.TABLE)) break block2;
                            DasObject dasObject = ((DasObject)table).getDasParent();
                            if (Intrinsics.areEqual((Object)(dasObject != null ? dasObject.getName() : null), (Object)this.$schemaName)) break block3;
                            Intrinsics.checkNotNull((Object)table);
                            if (!DatabaseSchemaAssistant.access$isSQLiteTable(DatabaseSchemaAssistant.INSTANCE, this.$it, table)) break block2;
                        }
                        bl = true;
                        return bl;
                    }
                    bl = false;
                    return bl;
                }
            }, arg_0)));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final List<DasTable> getTableByDataSource(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        List list = DasUtil.getTables((DasDataSource)((DasDataSource)dataSource)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @NotNull
    public final List<DasTable> getTable(@NotNull RawDataSource dataSource, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        JBIterable dasTables2 = DasUtil.getTables((DasDataSource)((DasDataSource)dataSource));
        List list = dasTables2.filter(arg_0 -> DatabaseSchemaAssistant.getTable$lambda$6(new Function1(tableName){
            final /* synthetic */ String $tableName;
            {
                this.$tableName = $tableName;
            }

            public final Boolean invoke(DasTable it) {
                return Intrinsics.areEqual((Object)((DasNamed)it).getName(), (Object)this.$tableName);
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @NotNull
    public final String executeSqlQuery(@NotNull Project project, @NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return SQLExecutor.INSTANCE.executeSqlQuery(project, sql);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSQLiteTable(RawDataSource rawDataSource, DasTable table) {
        if (!Intrinsics.areEqual((Object)rawDataSource.getDatabaseVersion().name, (Object)"SQLite")) return false;
        DasObject dasObject = table.getDasParent();
        if (!Intrinsics.areEqual((Object)(dasObject != null ? dasObject.getName() : null), (Object)"main")) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getTableColumns(@NotNull Project project, @NotNull List<String> tables) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        List<DasTable> dasTables2 = this.getAllTables(project);
        if (tables.isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = dasTables2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DasTable dasTable = (DasTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.displayTable((DasTable)p0));
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$mapNotNull$iv = dasTables2;
        boolean $i$f$mapNotNull = false;
        Iterable $this$mapTo$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DasTable table = (DasTable)element$iv$iv;
            boolean bl2 = false;
            if ((tables.contains(table.getName()) ? INSTANCE.displayTable(table) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getTableColumns$default(DatabaseSchemaAssistant databaseSchemaAssistant, Project project, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return databaseSchemaAssistant.getTableColumns(project, list);
    }

    @NotNull
    public final String getTableColumn(@NotNull DasTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return this.displayTable(table);
    }

    private final String displayTable(DasTable table) {
        JBIterable dasColumns = DasUtil.getColumns((DasObject)((DasObject)table));
        Intrinsics.checkNotNull((Object)dasColumns);
        String columns2 = CollectionsKt.joinToString$default((Iterable)((Iterable)dasColumns), (CharSequence)",", null, null, (int)0, null, DatabaseSchemaAssistant::displayTable$lambda$8, (int)30, null);
        return StringsKt.trimIndent((String)("\n    CREATE TABLE " + table.getName() + " (\n            " + columns2 + "\n        );\n    "));
    }

    private static final boolean getAllTables$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getTable$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence displayTable$lambda$8(DasColumn column) {
        return column.getName() + " " + column.getDasType().toDataType() + (SqlUtilFun.isNullOr((Object)column, (Object)"") ? "" : " NOT NULL");
    }

    public static final /* synthetic */ boolean access$isSQLiteTable(DatabaseSchemaAssistant $this, RawDataSource rawDataSource, DasTable table) {
        return $this.isSQLiteTable(rawDataSource, table);
    }
}

