/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.database.provider;

import cc.unitmesh.database.util.DatabaseSchemaAssistant;
import cc.unitmesh.devti.provider.RunService;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.psi.DbDataSource;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.psi.SqlFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001a\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0016J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0018"}, d2={"Lcc/unitmesh/database/provider/SqlRunService;", "Lcc/unitmesh/devti/provider/RunService;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runFile", "", "virtualFile", "psiElement", "Lcom/intellij/psi/PsiElement;", "isFromToolAction", "runConfigurationClass", "Ljava/lang/Class;", "Lcom/intellij/execution/configurations/RunProfile;", "createConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "createRunSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "createRunnerConfig", "ext-database"})
@SourceDebugExtension(value={"SMAP\nSqlRunService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlRunService.kt\ncc/unitmesh/database/provider/SqlRunService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n288#2,2:79\n*S KotlinDebug\n*F\n+ 1 SqlRunService.kt\ncc/unitmesh/database/provider/SqlRunService\n*L\n66#1:79,2\n*E\n"})
public final class SqlRunService
implements RunService {
    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getExtension(), (Object)"sql");
    }

    @Override
    @Nullable
    public String runFile(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement, boolean isFromToolAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Object object = ActionsKt.runReadAction(() -> SqlRunService.runFile$lambda$0(project, virtualFile));
        SqlFile sqlFile = object instanceof SqlFile ? (SqlFile)object : null;
        if (sqlFile == null) {
            return "<DevInsError> SQL: cannot find PSI file";
        }
        SqlFile sql = sqlFile;
        if (!(sql.getFileType() instanceof SqlFileType)) {
            return "<DevInsError> SQL: not a SQL file";
        }
        String content = (String)ActionsKt.runReadAction(() -> SqlRunService.runFile$lambda$1(sql));
        try {
            Intrinsics.checkNotNull((Object)content);
            return DatabaseSchemaAssistant.INSTANCE.executeSqlQuery(project, content);
        }
        catch (Exception e) {
            return "<DevInsError> SQL: " + e.getMessage();
        }
    }

    @Override
    @Nullable
    public Class<? extends RunProfile> runConfigurationClass(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DatabaseScriptRunConfiguration.class;
    }

    @Override
    @Nullable
    public RunConfiguration createConfiguration(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.createRunnerConfig(project, virtualFile);
        return runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings createRunSettings(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.createRunnerConfig(project, virtualFile);
    }

    /*
     * WARNING - void declaration
     */
    private final RunnerAndConfigurationSettings createRunnerConfig(Project project, VirtualFile file) {
        Object v2;
        Iterable iterable;
        DbDataSource dataSource;
        block4: {
            void $this$firstOrNull$iv;
            Object object = ActionsKt.runReadAction(() -> SqlRunService.createRunnerConfig$lambda$2(project, file));
            SqlFile sqlFile = object instanceof SqlFile ? (SqlFile)object : null;
            if (sqlFile == null) {
                return null;
            }
            SqlFile psiFile2 = sqlFile;
            DbDataSource dbDataSource = (DbDataSource)CollectionsKt.firstOrNull(DatabaseSchemaAssistant.INSTANCE.getDataSources(project));
            if (dbDataSource == null) {
                return null;
            }
            dataSource = dbDataSource;
            List configurationsFromContext = (List)ActionsKt.runReadAction(() -> SqlRunService.createRunnerConfig$lambda$3(psiFile2));
            iterable = configurationsFromContext;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ConfigurationFromContext it = (ConfigurationFromContext)element$iv;
                boolean bl = false;
                if (!(it.getConfiguration() instanceof DatabaseScriptRunConfiguration)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        ConfigurationFromContext configurationFromContext = v2;
        if (configurationFromContext == null || (iterable = configurationFromContext.getConfigurationSettings()) == null) {
            return null;
        }
        Iterable configurationSettings = iterable;
        DatabaseScriptRunConfigurationOptions.Target target = new DatabaseScriptRunConfigurationOptions.Target(dataSource.getUniqueId(), null);
        RunConfiguration runConfiguration = configurationSettings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration");
        ((DatabaseScriptRunConfiguration)runConfiguration).getOptions().getTargets().add(target);
        configurationSettings.setActivateToolWindowBeforeRun(false);
        return configurationSettings;
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings createDefaultConfigurations(@NotNull Project project, @NotNull PsiElement element) {
        return RunService.DefaultImpls.createDefaultConfigurations(this, project, element);
    }

    @Override
    @NotNull
    public List<String> collectPsiError(@NotNull PsiFile $this$collectPsiError) {
        return RunService.DefaultImpls.collectPsiError(this, $this$collectPsiError);
    }

    @Override
    @Nullable
    public String runFileAsync(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement) {
        return RunService.DefaultImpls.runFileAsync(this, project, virtualFile, psiElement);
    }

    private static final PsiFile runFile$lambda$0(Project $project, VirtualFile $virtualFile) {
        return PsiManager.getInstance((Project)$project).findFile($virtualFile);
    }

    private static final String runFile$lambda$1(SqlFile $sql) {
        return $sql.getText();
    }

    private static final PsiFile createRunnerConfig$lambda$2(Project $project, VirtualFile $file) {
        return PsiManager.getInstance((Project)$project).findFile($file);
    }

    private static final List createRunnerConfig$lambda$3(SqlFile $psiFile) {
        List list = new ConfigurationContext((PsiElement)$psiFile).getConfigurationsFromContext();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

