/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.database.provider;

import cc.unitmesh.database.util.DatabaseSchemaAssistant;
import cc.unitmesh.devti.agent.tool.AgentTool;
import cc.unitmesh.devti.bridge.provider.DatabaseFunction;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.provider.toolchain.ToolchainFunctionProvider;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.RawDataSource;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0010JO\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00162\u000b\u0010\u0017\u001a\u00070\r\u00a2\u0006\u0002\b\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u001b\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u001c\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\rH\u0002\u00a8\u0006 "}, d2={"Lcc/unitmesh/database/provider/DatabaseFunctionProvider;", "Lcc/unitmesh/devti/provider/toolchain/ToolchainFunctionProvider;", "<init>", "()V", "toolInfos", "", "Lcc/unitmesh/devti/agent/tool/AgentTool;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isApplicable", "", "funcName", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "funcNames", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execute", "", "prop", "args", "allVariables", "", "commandName", "Lcom/intellij/openapi/util/NlsSafe;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeTableFunction", "executeSqlFunction", "executeColumnFunction", "getTable", "Lcom/intellij/database/model/DasTable;", "dbName", "ext-database"})
@SourceDebugExtension(value={"SMAP\nDatabaseFunctionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseFunctionProvider.kt\ncc/unitmesh/database/provider/DatabaseFunctionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,180:1\n1747#2,3:181\n1549#2:184\n1620#2,3:185\n1549#2:188\n1620#2,3:189\n1549#2:192\n1620#2,3:193\n1549#2:196\n1620#2,3:197\n1549#2:200\n1620#2,3:201\n1603#2,9:204\n1855#2:213\n288#2,2:214\n1856#2:217\n1612#2:218\n288#2,2:219\n1#3:216\n11#4:221\n*S KotlinDebug\n*F\n+ 1 DatabaseFunctionProvider.kt\ncc/unitmesh/database/provider/DatabaseFunctionProvider\n*L\n22#1:181,3\n60#1:184\n60#1:185,3\n69#1:188\n69#1:189,3\n100#1:192\n100#1:193,3\n126#1:196\n126#1:197,3\n132#1:200\n132#1:201,3\n147#1:204,9\n147#1:213\n148#1:214,2\n147#1:217\n147#1:218\n157#1:219,2\n147#1:216\n168#1:221\n*E\n"})
public final class DatabaseFunctionProvider
implements ToolchainFunctionProvider {
    @Override
    @Nullable
    public Object toolInfos(@NotNull Project project, @NotNull Continuation<? super List<AgentTool>> $completion) {
        String example = BuiltinCommand.Companion.example("database");
        return CollectionsKt.listOf((Object)new AgentTool("database", "Database schema and query tool", example, false, null, null, false, null, 248, null));
    }

    @Override
    @Nullable
    public Object isApplicable(@NotNull Project project, @NotNull String funcName, @NotNull Continuation<? super Boolean> $completion) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)DatabaseFunction.getEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DatabaseFunction it = (DatabaseFunction)((Object)element$iv);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFunName(), (Object)funcName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return Boxing.boxBoolean((boolean)bl);
    }

    @Override
    @Nullable
    public Object funcNames(@NotNull Continuation<? super List<String>> $completion) {
        return DatabaseFunction.Companion.allFuncNames();
    }

    @Override
    @Nullable
    public Object execute(@NotNull Project project, @NotNull String prop, @NotNull List<? extends Object> args, @NotNull Map<String, ? extends Object> allVariables, @NotNull String commandName, @NotNull Continuation<Object> $completion) {
        DatabaseFunction databaseFunction = DatabaseFunction.Companion.fromString(prop);
        if (databaseFunction == null) {
            throw new IllegalArgumentException("[Database]: Invalid Database function name");
        }
        DatabaseFunction databaseFunction2 = databaseFunction;
        return switch (WhenMappings.$EnumSwitchMapping$0[databaseFunction2.ordinal()]) {
            case 1 -> DatabaseSchemaAssistant.INSTANCE.listSchemas(project);
            case 2 -> this.executeTableFunction(args, project);
            case 3 -> this.executeColumnFunction(args, project);
            case 4 -> this.executeSqlFunction(args, project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final String executeTableFunction(List<? extends Object> args, Project project) {
        if (args.isEmpty()) {
            RawDataSource rawDataSource = (RawDataSource)CollectionsKt.firstOrNull(DatabaseSchemaAssistant.INSTANCE.allRawDatasource(project));
            if (rawDataSource == null) {
                return "[Database]: No database found";
            }
            RawDataSource dataSource = rawDataSource;
            return CollectionsKt.joinToString$default((Iterable)DatabaseSchemaAssistant.INSTANCE.getTableByDataSource(dataSource), (CharSequence)"\n", null, null, (int)0, null, DatabaseFunctionProvider::executeTableFunction$lambda$1, (int)30, null);
        }
        Object dbName = CollectionsKt.first(args);
        List result = new ArrayList();
        Object object = dbName;
        if (object instanceof String) {
            if (StringsKt.startsWith$default((String)((String)dbName), (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)((String)dbName), (String)"]", (boolean)false, (int)2, null)) {
                void $this$mapTo$iv$iv;
                String string = ((String)dbName).substring(1, ((String)dbName).length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String[] stringArray = new String[]{","};
                List tableNames = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                Iterable $this$map$iv = tableNames;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.getTable(project, ((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
                }
                result = CollectionsKt.toMutableList((Collection)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
            } else {
                result = CollectionsKt.toMutableList((Collection)this.getTable(project, (String)dbName));
            }
        } else if (object instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)dbName;
            boolean $i$f$map = false;
            Iterable $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object item$iv$iv2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.String");
                collection.add(this.getTable(project, (String)it));
            }
            result = CollectionsKt.toMutableList((Collection)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        }
        if (result.isEmpty()) {
            return "[Database]: Table not found";
        }
        return CollectionsKt.joinToString$default((Iterable)result, (CharSequence)"\n", null, null, (int)0, null, DatabaseFunctionProvider::executeTableFunction$lambda$4, (int)30, null);
    }

    private final Object executeSqlFunction(List<? extends Object> args, Project project) {
        if (args.isEmpty()) {
            return "ShireError[DBTool]: SQL function requires a SQL query";
        }
        Object sqlQuery = CollectionsKt.first(args);
        Intrinsics.checkNotNull((Object)sqlQuery, (String)"null cannot be cast to non-null type kotlin.String");
        return DatabaseSchemaAssistant.INSTANCE.executeSqlQuery(project, (String)sqlQuery);
    }

    /*
     * WARNING - void declaration
     */
    private final Object executeColumnFunction(List<? extends Object> args, Project project) {
        Object first;
        block23: {
            Object object;
            block25: {
                block24: {
                    DasTable dasTable;
                    Object v6;
                    block22: {
                        if (args.isEmpty()) {
                            void $this$mapTo$iv$iv;
                            List<DasTable> allTables = DatabaseSchemaAssistant.INSTANCE.getAllTables(project);
                            Iterable $this$map$iv = allTables;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                DasTable dasTable2 = (DasTable)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(DatabaseSchemaAssistant.INSTANCE.getTableColumn((DasTable)it));
                            }
                            List map = (List)destination$iv$iv;
                            return StringsKt.trimMargin$default((String)("\n                |```sql\n                |" + CollectionsKt.joinToString$default((Iterable)map, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n                |```\n            "), null, (int)1, null);
                        }
                        first = args.get(0);
                        if (first instanceof RawDataSource) {
                            List<DasTable> list;
                            if (args.size() == 1) {
                                list = DatabaseSchemaAssistant.INSTANCE.getTableByDataSource((RawDataSource)first);
                            } else {
                                RawDataSource rawDataSource = (RawDataSource)first;
                                Object object2 = args.get(1);
                                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                                list = DatabaseSchemaAssistant.INSTANCE.getTable(rawDataSource, (String)object2);
                            }
                            return list;
                        }
                        if (first instanceof DasTable) {
                            return DatabaseSchemaAssistant.INSTANCE.getTableColumn((DasTable)first);
                        }
                        if (first instanceof List) {
                            Object map = CollectionsKt.first((List)((List)first));
                            if (map instanceof RawDataSource) {
                                Iterable $this$map$iv = (Iterable)first;
                                boolean $i$f$map = false;
                                Iterable $this$mapTo$iv$iv = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                Iterator iterator = $this$mapTo$iv$iv.iterator();
                                while (iterator.hasNext()) {
                                    Object item$iv$iv;
                                    Object it = item$iv$iv = iterator.next();
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type com.intellij.database.model.RawDataSource");
                                    collection.add(DatabaseSchemaAssistant.INSTANCE.getTableByDataSource((RawDataSource)it));
                                }
                                return (List)destination$iv$iv;
                            }
                            if (map instanceof DasTable) {
                                Iterable $this$map$iv = (Iterable)first;
                                boolean $i$f$map = false;
                                Iterable $this$mapTo$iv$iv = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                Iterator iterator = $this$mapTo$iv$iv.iterator();
                                while (iterator.hasNext()) {
                                    Object item$iv$iv;
                                    Object it = item$iv$iv = iterator.next();
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type com.intellij.database.model.DasTable");
                                    collection.add(DatabaseSchemaAssistant.INSTANCE.getTableColumn((DasTable)it));
                                }
                                return (List)destination$iv$iv;
                            }
                            return "ShireError[DBTool]: Table function requires a data source or a list of table names";
                        }
                        if (!(first instanceof String)) break block23;
                        List<DasTable> allTables = DatabaseSchemaAssistant.INSTANCE.getAllTables(project);
                        if (StringsKt.startsWith$default((String)((String)first), (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)((String)first), (String)"]", (boolean)false, (int)2, null)) {
                            void $this$mapNotNullTo$iv$iv;
                            String string = ((String)first).substring(1, ((String)first).length() - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            String[] $i$f$map = new String[]{","};
                            List tableNames = StringsKt.split$default((CharSequence)string, (String[])$i$f$map, (boolean)false, (int)0, (int)6, null);
                            Iterable $this$mapNotNull$iv = tableNames;
                            boolean $i$f$mapNotNull = false;
                            Iterable destination$iv$iv = $this$mapNotNull$iv;
                            Collection destination$iv$iv2 = new ArrayList();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                String string2;
                                Object v4;
                                block21: {
                                    Object element$iv$iv$iv;
                                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                                    boolean bl = false;
                                    String it = (String)element$iv$iv;
                                    boolean bl2 = false;
                                    Iterable $this$firstOrNull$iv = allTables;
                                    boolean $i$f$firstOrNull = false;
                                    for (Object element$iv : $this$firstOrNull$iv) {
                                        DasTable table = (DasTable)element$iv;
                                        boolean bl3 = false;
                                        if (!Intrinsics.areEqual((Object)table.getName(), (Object)((Object)StringsKt.trim((CharSequence)it)).toString())) continue;
                                        v4 = element$iv;
                                        break block21;
                                    }
                                    v4 = null;
                                }
                                DasTable dasTable3 = v4;
                                if (dasTable3 != null) {
                                    DasTable it;
                                    boolean bl = false;
                                    string2 = DatabaseSchemaAssistant.INSTANCE.getTableColumn(it);
                                } else {
                                    string2 = null;
                                }
                                if (string2 == null) continue;
                                String it$iv$iv = string2;
                                boolean bl = false;
                                destination$iv$iv2.add(it$iv$iv);
                            }
                            return (List)destination$iv$iv2;
                        }
                        Iterable $this$firstOrNull$iv = allTables;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            DasTable table = (DasTable)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)table.getName(), (Object)first)) continue;
                            v6 = element$iv;
                            break block22;
                        }
                        v6 = null;
                    }
                    if ((object = (dasTable = (DasTable)v6)) == null) break block24;
                    DasTable it = object;
                    boolean bl = false;
                    String string = DatabaseSchemaAssistant.INSTANCE.getTableColumn(it);
                    object = string;
                    if (string != null) break block25;
                }
                object = "ShireError[DBTool]: Table not found";
            }
            return object;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DatabaseFunctionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("ShireError[DBTool] args types: " + first.getClass());
        return "ShireError[DBTool]: Table function requires a data source or a list of table names";
    }

    private final List<DasTable> getTable(Project project, String dbName) {
        RawDataSource rawDataSource = DatabaseSchemaAssistant.INSTANCE.getDatabase(project, dbName);
        if (rawDataSource == null) {
            return CollectionsKt.emptyList();
        }
        RawDataSource database = rawDataSource;
        return DatabaseSchemaAssistant.INSTANCE.getTableByDataSource(database);
    }

    private static final CharSequence executeTableFunction$lambda$1(DasTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    private static final CharSequence executeTableFunction$lambda$4(DasTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseFunction.values().length];
            try {
                nArray[DatabaseFunction.Schema.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseFunction.Table.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseFunction.Column.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseFunction.Query.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

