/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.database.flow;

import cc.unitmesh.database.flow.AutoSqlBackgroundTaskKt;
import cc.unitmesh.database.flow.AutoSqlFlow;
import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.util.parser.MarkdownCodeHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.psi.SqlFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/database/flow/AutoSqlBackgroundTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "flow", "Lcc/unitmesh/database/flow/AutoSqlFlow;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcc/unitmesh/database/flow/AutoSqlFlow;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/lang/Language;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "writeToFile", "sqlScript", "", "ext-database"})
@SourceDebugExtension(value={"SMAP\nAutoSqlBackgroundTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoSqlBackgroundTask.kt\ncc/unitmesh/database/flow/AutoSqlBackgroundTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n11#2:101\n1549#3:102\n1620#3,3:103\n*S KotlinDebug\n*F\n+ 1 AutoSqlBackgroundTask.kt\ncc/unitmesh/database/flow/AutoSqlBackgroundTask\n*L\n24#1:101\n36#1:102\n36#1:103,3\n*E\n"})
public final class AutoSqlBackgroundTask
extends Task.Backgroundable {
    @NotNull
    private final Project project;
    @NotNull
    private final AutoSqlFlow flow;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Language language;
    @NotNull
    private final Logger logger;

    public AutoSqlBackgroundTask(@NotNull Project project, @NotNull AutoSqlFlow flow, @NotNull Editor editor, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        super(project, "Gen SQL", true);
        this.project = project;
        this.flow = flow;
        this.editor = editor;
        this.language = language;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AutoSqlBackgroundTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull ProgressIndicator indicator) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setFraction(0.2);
        indicator.setText(AutoDevBundle.message("autosql.generate.clarify", new Object[0]));
        String tables = this.flow.clarify();
        this.logger.info("Tables: " + tables);
        String[] stringArray = new String[]{", "};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)tables, (String)"[", null, (int)2, null), (String)"]", null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List tableNames = (List)destination$iv$iv;
        if (tableNames.isEmpty()) {
            indicator.setFraction(1.0);
            List<String> allTables = this.flow.getAllTables();
            this.logger.warn("no table related: " + allTables);
            return;
        }
        indicator.setFraction(0.6);
        indicator.setText(AutoDevBundle.message("autosql.generate.generate", new Object[0]));
        String sqlScript = this.flow.design(tableNames).get(0);
        try {
            String sqlCode = (String)CollectionsKt.first(MarkdownCodeHelper.INSTANCE.parseCodeFromString(sqlScript));
            SqlFile sqlFile = (SqlFile)ActionsKt.runReadAction(() -> AutoSqlBackgroundTask.run$lambda$1(this, sqlCode));
            List<String> errors = AutoSqlBackgroundTaskKt.verifySqlElement(sqlFile);
            if (!((Collection)errors).isEmpty()) {
                String response = this.flow.fix(CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                String code = (String)CollectionsKt.last(MarkdownCodeHelper.INSTANCE.parseCodeFromString(response));
                this.writeToFile(code, indicator);
            }
        }
        catch (Exception e) {
            this.logger.error("SQL Script parse error: " + e);
        }
        this.writeToFile(sqlScript, indicator);
        indicator.setFraction(1.0);
    }

    private final void writeToFile(String sqlScript, ProgressIndicator indicator) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, (String)"Gen SQL", (String)"cc.unitmesh.livingDoc", () -> AutoSqlBackgroundTask.writeToFile$lambda$2(this, sqlScript), (PsiFile[])new PsiFile[0]);
    }

    private static final SqlFile run$lambda$1(AutoSqlBackgroundTask this$0, String $sqlCode) {
        PsiFile psiFile2 = PsiFileFactory.getInstance((Project)this$0.project).createFileFromText("temp.sql", this$0.language, (CharSequence)$sqlCode);
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlFile");
        return (SqlFile)psiFile2;
    }

    private static final void writeToFile$lambda$2(AutoSqlBackgroundTask this$0, String $sqlScript) {
        this$0.editor.getDocument().insertString(this$0.editor.getCaretModel().getOffset(), (CharSequence)"\n");
        String code = (String)CollectionsKt.first(MarkdownCodeHelper.INSTANCE.parseCodeFromString($sqlScript));
        this$0.editor.getDocument().insertString(this$0.editor.getCaretModel().getOffset() + 1, (CharSequence)code);
    }
}

