/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.database.actions;

import cc.unitmesh.database.DbContextActionProvider;
import cc.unitmesh.database.flow.AutoSqlBackgroundTask;
import cc.unitmesh.database.flow.AutoSqlContext;
import cc.unitmesh.database.flow.AutoSqlFlow;
import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.gui.SendToWindowKt;
import cc.unitmesh.devti.gui.chat.ChatCodingService;
import cc.unitmesh.devti.gui.chat.NormalChatCodingPanel;
import cc.unitmesh.devti.intentions.action.base.ChatBaseIntention;
import cc.unitmesh.devti.llms.LLMProvider;
import cc.unitmesh.devti.llms.LlmFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J$\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J%\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/database/actions/AutoSqlAction;", "Lcc/unitmesh/devti/intentions/action/base/ChatBaseIntention;", "<init>", "()V", "priority", "", "startInWriteAction", "", "getFamilyName", "", "getText", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "isSQLiteTable", "rawDataSource", "Lcom/intellij/database/model/RawDataSource;", "table", "Lcom/intellij/database/model/DasTable;", "ext-database"})
@SourceDebugExtension(value={"SMAP\nAutoSqlAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoSqlAction.kt\ncc/unitmesh/database/actions/AutoSqlAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n*S KotlinDebug\n*F\n+ 1 AutoSqlAction.kt\ncc/unitmesh/database/actions/AutoSqlAction\n*L\n58#1:80\n58#1:81,3\n*E\n"})
public final class AutoSqlAction
extends ChatBaseIntention {
    @Override
    public int priority() {
        return 900;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return AutoDevBundle.message("autosql.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        return AutoDevBundle.message("autosql.generate", new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list = DbPsiFacade.getInstance((Project)project).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        if ((DbDataSource)CollectionsKt.firstOrNull((List)list) == null) {
            return false;
        }
        Editor editor2 = editor;
        String hasSelectionText = editor2 != null && (editor2 = editor2.getSelectionModel()) != null ? editor2.getSelectedText() : null;
        return hasSelectionText != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || file == null) {
            return;
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
        DbPsiFacade dbPsiFacade2 = dbPsiFacade;
        List list = dbPsiFacade2.getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        DbDataSource dbDataSource = (DbDataSource)CollectionsKt.firstOrNull((List)list);
        if (dbDataSource == null) {
            return;
        }
        DbDataSource dataSource = dbDataSource;
        String selectedText = editor.getSelectionModel().getSelectedText();
        List list2 = dbPsiFacade2.getDataSourceManager(dataSource).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDataSources(...)");
        RawDataSource rawDataSource = (RawDataSource)CollectionsKt.firstOrNull((List)list2);
        if (rawDataSource == null) {
            return;
        }
        RawDataSource rawDataSource2 = rawDataSource;
        NameVersion nameVersion = rawDataSource2.getDatabaseVersion();
        Intrinsics.checkNotNullExpressionValue((Object)nameVersion, (String)"getDatabaseVersion(...)");
        NameVersion databaseVersion = nameVersion;
        String string = rawDataSource2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String schemaName = StringsKt.substringBeforeLast$default((String)string, (char)'@', null, (int)2, null);
        RawDataSource it = rawDataSource2;
        boolean bl = false;
        List list3 = DasUtil.getTables((DasDataSource)((DasDataSource)rawDataSource2)).filter(arg_0 -> AutoSqlAction.invoke$lambda$1$lambda$0(new Function1(schemaName, this, it){
            final /* synthetic */ String $schemaName;
            final /* synthetic */ AutoSqlAction this$0;
            final /* synthetic */ RawDataSource $it;
            {
                this.$schemaName = $schemaName;
                this.this$0 = $receiver;
                this.$it = $it;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(DasTable table) {
                boolean bl;
                block2: {
                    block3: {
                        if (!Intrinsics.areEqual((Object)((DasNamed)table).getKind(), (Object)ObjectKind.TABLE)) break block2;
                        DasObject dasObject = ((DasObject)table).getDasParent();
                        if (Intrinsics.areEqual((Object)(dasObject != null ? dasObject.getName() : null), (Object)this.$schemaName)) break block3;
                        Intrinsics.checkNotNull((Object)table);
                        if (!AutoSqlAction.access$isSQLiteTable(this.this$0, this.$it, table)) break block2;
                    }
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"toList(...)");
        List dasTables2 = list3;
        String string2 = selectedText;
        if (string2 == null) {
            string2 = "";
        }
        it = databaseVersion;
        String string3 = string2;
        boolean $i$a$-let-AutoSqlAction$invoke$genSqlContext$22 = false;
        Iterable iterable = dasTables2;
        String string4 = schemaName;
        String string5 = "name: " + it.name + ", version: " + it.version;
        boolean $i$f$map = false;
        void $i$a$-let-AutoSqlAction$invoke$genSqlContext$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DasTable dasTable = (DasTable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string6 = it2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
            collection.add(string6);
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 16;
        List list4 = null;
        Collection<String> collection2 = collection;
        String string7 = string4;
        String string8 = string5;
        String string9 = string3;
        AutoSqlContext genSqlContext = new AutoSqlContext(string9, string8, string7, (List)collection2, list4, n, defaultConstructorMarker);
        DbContextActionProvider actions = new DbContextActionProvider(dasTables2);
        SendToWindowKt.sendToChatPanel(project, (Function2<? super NormalChatCodingPanel, ? super ChatCodingService, Unit>)((Function2)(arg_0, arg_1) -> AutoSqlAction.invoke$lambda$4(project, genSqlContext, actions, editor, file, arg_0, arg_1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSQLiteTable(RawDataSource rawDataSource, DasTable table) {
        if (!Intrinsics.areEqual((Object)rawDataSource.getDatabaseVersion().name, (Object)"SQLite")) return false;
        DasObject dasObject = table.getDasParent();
        if (!Intrinsics.areEqual((Object)(dasObject != null ? dasObject.getName() : null), (Object)"main")) return false;
        return true;
    }

    private static final boolean invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit invoke$lambda$4(Project $project, AutoSqlContext $genSqlContext, DbContextActionProvider $actions, Editor $editor, PsiFile $file, NormalChatCodingPanel contentPanel, ChatCodingService chatCodingService) {
        Intrinsics.checkNotNullParameter((Object)contentPanel, (String)"contentPanel");
        Intrinsics.checkNotNullParameter((Object)chatCodingService, (String)"<unused var>");
        LLMProvider llmProvider = LlmFactory.INSTANCE.create($project);
        AutoSqlFlow prompter = new AutoSqlFlow($genSqlContext, $actions, contentPanel, llmProvider);
        Language language = $file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        AutoSqlBackgroundTask task2 = new AutoSqlBackgroundTask($project, prompter, $editor, language);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task2, (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task2));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isSQLiteTable(AutoSqlAction $this, RawDataSource rawDataSource, DasTable table) {
        return $this.isSQLiteTable(rawDataSource, table);
    }
}

