/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.container;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.provider.RunService;
import com.intellij.clouds.docker.gateway.DockerDevcontainerDeployContext;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.devcontainers.DevcontainerPaths;
import com.intellij.docker.agent.devcontainers.buildStrategy.DevcontainerBuildStrategy;
import com.intellij.docker.agent.util.UtilsKt;
import com.intellij.docker.connection.DockerConnectionConfiguratorKt;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remoteDev.hostStatus.UnattendedHostStatus;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.gateway.api.GatewayConnectionHandle;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.api.GatewayConnectorView;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cH\u0002J$\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\"\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010!H\u0002\u00a8\u0006'"}, d2={"Lcc/unitmesh/container/RunDevContainerService;", "Lcc/unitmesh/devti/provider/RunService;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runConfigurationClass", "Ljava/lang/Class;", "Lcom/intellij/execution/configurations/RunProfile;", "runFile", "", "virtualFile", "psiElement", "Lcom/intellij/psi/PsiElement;", "isFromToolAction", "createDeployViewComponentFor241", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "context", "Lcom/intellij/clouds/docker/gateway/DockerDevcontainerDeployContext;", "createDeployViewComponentFor242", "createByLifetime", "dockerServers", "", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "createContext", "modelFile", "Ljava/io/File;", "workingDir", "dockerServer", "createBuildData", "Lcom/intellij/docker/agent/devcontainers/buildStrategy/DevcontainerBuildStrategy$LocalBuildData;", "sources", "ext-container"})
@SourceDebugExtension(value={"SMAP\nRunDevContainerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunDevContainerService.kt\ncc/unitmesh/container/RunDevContainerService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n11#2:195\n11#2:201\n288#3,2:196\n766#3:198\n857#3,2:199\n*S KotlinDebug\n*F\n+ 1 RunDevContainerService.kt\ncc/unitmesh/container/RunDevContainerService\n*L\n56#1:195\n161#1:201\n137#1:196,2\n147#1:198\n147#1:199,2\n*E\n"})
public final class RunDevContainerService
implements RunService {
    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)"devcontainer.json");
    }

    @Override
    @Nullable
    public Class<? extends RunProfile> runConfigurationClass(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @Override
    @Nullable
    public String runFile(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement, boolean isFromToolAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        RemoteServer server = (RemoteServer)CollectionsKt.firstOrNull(this.dockerServers());
        if (server == null) {
            AutoDevNotifications.INSTANCE.warn(project, "Cannot create DockerCloud server");
            return null;
        }
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project);
        Intrinsics.checkNotNull((Object)virtualFile2);
        File projectDir = virtualFile2.toNioPath().toFile();
        File containerFile = new File(projectDir, "devcontainer.json");
        byte[] byArray = virtualFile.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        FilesKt.writeText$default((File)containerFile, (String)new String(byArray2, charset), null, (int)2, null);
        try {
            Intrinsics.checkNotNull((Object)projectDir);
            charset = this.createContext(containerFile, projectDir, (RemoteServer<DockerCloudConfiguration>)server);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RunDevContainerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot create context: " + e);
            charset = new DockerDevcontainerDeployContext();
        }
        Charset context = charset;
        DialogWrapper wrapper2 = new DialogWrapper(project, this, (DockerDevcontainerDeployContext)context){
            final /* synthetic */ Project $project;
            final /* synthetic */ RunDevContainerService this$0;
            final /* synthetic */ DockerDevcontainerDeployContext $context;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$context = $context;
                super($project);
            }

            protected JComponent createCenterPanel() {
                return (JComponent)new BorderLayoutPanel();
            }

            public void beforeShowCallback() {
                JComponent jComponent;
                JComponent panel2 = this.getContentPanel();
                Lifetime lifetime = Lifetime.Companion.getEternal();
                int baseLine = ApplicationInfo.getInstance().getBuild().getBaselineVersion();
                try {
                    JComponent jComponent2;
                    if (baseLine >= 242) {
                        jComponent2 = this.this$0.createByLifetime(lifetime);
                        if (jComponent2 == null) {
                            jComponent2 = RunDevContainerService.access$createDeployViewComponentFor242(this.this$0, this.$project, lifetime, this.$context);
                        }
                    } else {
                        jComponent2 = RunDevContainerService.access$createDeployViewComponentFor241(this.this$0, this.$project, lifetime, this.$context);
                    }
                    jComponent = jComponent2;
                }
                catch (Exception e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(RunDevContainerService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Cannot create component: " + e);
                    JComponent jComponent3 = this.this$0.createByLifetime(lifetime);
                    if (jComponent3 == null) {
                        throw e;
                    }
                    jComponent = jComponent3;
                }
                JComponent component2 = jComponent;
                component2.setBorder((Border)JBUI.Borders.empty());
                panel2.add(component2);
                panel2.revalidate();
                panel2.repaint();
            }
        };
        wrapper2.show();
        return "Running devcontainer.json";
    }

    private final JComponent createDeployViewComponentFor241(Project project, Lifetime lifetime, DockerDevcontainerDeployContext context) {
        Class<?> dockerDeployViewClass = Class.forName("com.intellij.clouds.docker.gateway.ui.DockerDeployView");
        Class[] classArray = new Class[]{Project.class, Lifetime.class, DockerDevcontainerDeployContext.class, Function0.class, Function0.class};
        Constructor<?> constructor = dockerDeployViewClass.getDeclaredConstructor(classArray);
        constructor.setAccessible(true);
        Function0 emptyAction = RunDevContainerService::createDeployViewComponentFor241$lambda$0;
        Object[] objectArray = new Object[]{project, lifetime, context, emptyAction, emptyAction};
        Object dockerDeployViewInstance = constructor.newInstance(objectArray);
        Method componentMethod = dockerDeployViewClass.getMethod("getComponent", new Class[0]);
        Object object = componentMethod.invoke(dockerDeployViewInstance, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent component2 = (JComponent)object;
        return component2;
    }

    private final JComponent createDeployViewComponentFor242(Project project, Lifetime lifetime, DockerDevcontainerDeployContext context) {
        Class<?> dockerDeployViewClass = Class.forName("com.intellij.clouds.docker.gateway.ui.DockerDeployView");
        Class[] classArray = new Class[]{Project.class, Lifetime.class, DockerDevcontainerDeployContext.class, Function2.class};
        Constructor<?> constructor = dockerDeployViewClass.getDeclaredConstructor(classArray);
        Function2 function2 = RunDevContainerService::createDeployViewComponentFor242$lambda$1;
        Object[] objectArray = new Object[]{project, lifetime, context, function2};
        Object instance = constructor.newInstance(objectArray);
        Method componentMethod = dockerDeployViewClass.getMethod("getComponent", new Class[0]);
        Object object = componentMethod.invoke(instance, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent component2 = (JComponent)object;
        return component2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JComponent createByLifetime(@NotNull Lifetime lifetime) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Iterable iterable = GatewayConnector.Companion.getConnectors();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GatewayConnector it = (GatewayConnector)element$iv;
                boolean bl = false;
                if (!(it.isAvailable() && Intrinsics.areEqual((Object)it.getClass().getName(), (Object)"com.intellij.clouds.docker.gateway.DockerGatewayConnector"))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        GatewayConnector gatewayConnector = v0;
        if (gatewayConnector == null) {
            return null;
        }
        GatewayConnector view = gatewayConnector;
        GatewayConnectorView connectorView = view.createView(lifetime);
        return connectorView.getComponent();
    }

    /*
     * WARNING - void declaration
     */
    private final List<RemoteServer<DockerCloudConfiguration>> dockerServers() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = DockerUtils.getDockerServers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RemoteServer it = (RemoteServer)element$iv$iv;
            boolean bl = false;
            if (!(DockerConnectionConfiguratorKt.getSshId((RemoteServer)it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)UtilsKt.nullize((Collection)((List)destination$iv$iv));
        if (list == null) {
            list = CollectionsKt.listOf((Object)DockerUtils.createDefaultDockerServer((String)"Local"));
        }
        List filteredServers = list;
        return filteredServers;
    }

    @NotNull
    public final DockerDevcontainerDeployContext createContext(@NotNull File modelFile, @NotNull File workingDir, @NotNull RemoteServer<DockerCloudConfiguration> dockerServer) {
        Intrinsics.checkNotNullParameter((Object)modelFile, (String)"modelFile");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter(dockerServer, (String)"dockerServer");
        Path path = modelFile.toPath();
        Intrinsics.checkNotNull((Object)path);
        Path path2 = DevcontainerPaths.INSTANCE.computeSourcesMountPath(path);
        File sources = path2 != null ? path2.toFile() : null;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RunDevContainerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Creating context for " + modelFile + ", " + workingDir + ", " + sources);
        DockerDevcontainerDeployContext deployContext = new DockerDevcontainerDeployContext();
        deployContext.setConfig(dockerServer);
        deployContext.setBuildFromLocalSources(this.createBuildData(workingDir, modelFile, sources));
        return deployContext;
    }

    private final DevcontainerBuildStrategy.LocalBuildData createBuildData(File workingDir, File modelFile, File sources) {
        Object object;
        try {
            Class[] classArray = new Class[]{File.class, File.class, File.class, Boolean.TYPE};
            Constructor constructor = DevcontainerBuildStrategy.LocalBuildData.class.getConstructor(classArray);
            Intrinsics.checkNotNullExpressionValue(constructor, (String)"getConstructor(...)");
            Constructor oldConstructor = constructor;
            Object[] objectArray = new Object[]{workingDir, modelFile, sources, true};
            object = oldConstructor.newInstance(objectArray);
            Intrinsics.checkNotNull(object);
            object = (DevcontainerBuildStrategy.LocalBuildData)object;
        }
        catch (NoSuchMethodException e) {
            Class[] classArray = new Class[]{Path.class, Path.class, Boolean.TYPE};
            Constructor constructor = DevcontainerBuildStrategy.LocalBuildData.class.getConstructor(classArray);
            Intrinsics.checkNotNullExpressionValue(constructor, (String)"getConstructor(...)");
            Constructor newConstructor = constructor;
            Object[] objectArray = new Object[3];
            objectArray[0] = modelFile.toPath();
            File file = sources;
            if (file == null) {
                file = workingDir;
            }
            objectArray[1] = file.toPath();
            objectArray[2] = true;
            Object t = newConstructor.newInstance(objectArray);
            Intrinsics.checkNotNull(t);
            object = (DevcontainerBuildStrategy.LocalBuildData)t;
        }
        return object;
    }

    @Override
    @Nullable
    public RunConfiguration createConfiguration(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        return RunService.DefaultImpls.createConfiguration(this, project, virtualFile);
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings createRunSettings(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement) {
        return RunService.DefaultImpls.createRunSettings(this, project, virtualFile, psiElement);
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings createDefaultConfigurations(@NotNull Project project, @NotNull PsiElement element) {
        return RunService.DefaultImpls.createDefaultConfigurations(this, project, element);
    }

    @Override
    @NotNull
    public List<String> collectPsiError(@NotNull PsiFile $this$collectPsiError) {
        return RunService.DefaultImpls.collectPsiError(this, $this$collectPsiError);
    }

    @Override
    @Nullable
    public String runFileAsync(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement) {
        return RunService.DefaultImpls.runFileAsync(this, project, virtualFile, psiElement);
    }

    private static final Unit createDeployViewComponentFor241$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit createDeployViewComponentFor242$lambda$1(GatewayConnectionHandle gatewayConnectionHandle, UnattendedHostStatus unattendedHostStatus) {
        Intrinsics.checkNotNullParameter((Object)gatewayConnectionHandle, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)unattendedHostStatus, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ JComponent access$createDeployViewComponentFor242(RunDevContainerService $this, Project project, Lifetime lifetime, DockerDevcontainerDeployContext context) {
        return $this.createDeployViewComponentFor242(project, lifetime, context);
    }

    public static final /* synthetic */ JComponent access$createDeployViewComponentFor241(RunDevContainerService $this, Project project, Lifetime lifetime, DockerDevcontainerDeployContext context) {
        return $this.createDeployViewComponentFor241(project, lifetime, context);
    }
}

