/****** Object:  Table [dbo].[Physicians]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Physicians](
	[PhysicianId] [bigint] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](255) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[PhysicianId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[Physicians] ON
INSERT [dbo].[Physicians] ([PhysicianId], [Name]) VALUES (1, N'Dr Dobbs')
INSERT [dbo].[Physicians] ([PhysicianId], [Name]) VALUES (2, N'Dr Watson')
SET IDENTITY_INSERT [dbo].[Physicians] OFF
/****** Object:  Table [dbo].[Region]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Region](
	[RegionId] [bigint] IDENTITY(1,1) NOT NULL,
	[RegionDescription] [nvarchar](50) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[RegionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Suppliers]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Suppliers](
	[SupplierId] [int] NOT NULL,
	[CompanyName] [nvarchar](40) NOT NULL,
	[ContactName] [nvarchar](30) NULL,
	[ContactTitle] [nvarchar](30) NULL,
	[HomePage] [nvarchar](255) NULL,
	[Address] [nvarchar](60) NULL,
	[City] [nvarchar](15) NULL,
	[Region] [nvarchar](15) NULL,
	[PostalCode] [nvarchar](10) NULL,
	[Country] [nvarchar](15) NULL,
	[Phone] [nvarchar](24) NULL,
	[Fax] [nvarchar](24) NULL,
PRIMARY KEY CLUSTERED 
(
	[SupplierId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[NumericEntity](
	[Short] [smallint] IDENTITY(1,1) NOT NULL,
	[NullableShort] [smallint] NULL,
	[Integer] [int] NOT NULL,
	[NullableInteger] [int] NULL,
	[Long] [bigint] NOT NULL,
	[NullableLong] [bigint] NULL,
	[Decimal] [decimal](19, 5) NOT NULL,
	[NullableDecimal] [decimal](19, 5) NULL,
	[Single] [real] NOT NULL,
	[NullableSingle] [real] NULL,
	[Double] [float] NOT NULL,
	[NullableDouble] [float] NULL,
PRIMARY KEY CLUSTERED 
(
	[Short] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (1, N'Exotic Liquids', N'Charlotte Cooper', N'Purchasing Manager', N'', N'49 Gilbert St.', N'London', N'', N'EC1 4SD', N'UK', N'(171) 555-2222', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (2, N'New Orleans Cajun Delights', N'Shelley Burke', N'Order Administrator', N'#CAJUN.HTM#', N'P.O. Box 78934', N'New Orleans', N'LA', N'70117', N'USA', N'(100) 555-4822', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (3, N'Grandma Kelly''s Homestead', N'Regina Murphy', N'Sales Representative', N'', N'707 Oxford Rd.', N'Ann Arbor', N'MI', N'48104', N'USA', N'(313) 555-5735', N'(313) 555-3349')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (4, N'Tokyo Traders', N'Yoshi Nagase', N'Marketing Manager', N'', N'9-8 Sekimai Musashino-shi', N'Tokyo', N'', N'100', N'Japan', N'(03) 3555-5011', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (5, N'Cooperativa de Quesos ''Las Cabras''', N'Antonio del Valle Saavedra', N'Export Administrator', N'', N'Calle del Rosal 4', N'Oviedo', N'Asturias', N'33007', N'Spain', N'(98) 598 76 54', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (6, N'Mayumi''s', N'Mayumi Ohno', N'Marketing Representative', N'Mayumi''s (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/mayumi.htm#', N'92 Setsuko Chuo-ku', N'Osaka', N'', N'545', N'Japan', N'(06) 431-7877', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (7, N'Pavlova, Ltd.', N'Ian Devling', N'Marketing Manager', N'', N'74 Rose St. Moonie Ponds', N'Melbourne', N'Victoria', N'3058', N'Australia', N'(03) 444-2343', N'(03) 444-6588')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (8, N'Specialty Biscuits, Ltd.', N'Peter Wilson', N'Sales Representative', N'', N'29 King''s Way', N'Manchester', N'', N'M14 GSD', N'UK', N'(161) 555-4448', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (9, N'PB Knäckebröd AB', N'Lars Peterson', N'Sales Agent', N'', N'Kaloadagatan 13', N'Göteborg', N'', N'S-345 67', N'Sweden', N'031-987 65 43', N'031-987 65 91')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (10, N'Refrescos Americanas LTDA', N'Carlos Diaz', N'Marketing Manager', N'', N'Av. das Americanas 12.890', N'Sao Paulo', N'', N'5442', N'Brazil', N'(11) 555 4640', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (11, N'Heli Süßwaren GmbH & Co. KG', N'Petra Winkler', N'Sales Manager', N'', N'Tiergartenstraße 5', N'Berlin', N'', N'10785', N'Germany', N'(010) 9984510', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (12, N'Plutzer Lebensmittelgroßmärkte AG', N'Martin Bein', N'International Marketing Mgr.', N'Plutzer (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/plutzer.htm#', N'Bogenallee 51', N'Frankfurt', N'', N'60439', N'Germany', N'(069) 992755', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (13, N'Nord-Ost-Fisch Handelsgesellschaft mbH', N'Sven Petersen', N'Coordinator Foreign Markets', N'', N'Frahmredder 112a', N'Cuxhaven', N'', N'27478', N'Germany', N'(04721) 8713', N'(04721) 8714')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (14, N'Formaggi Fortini s.r.l.', N'Elio Rossi', N'Sales Representative', N'#FORMAGGI.HTM#', N'Viale Dante, 75', N'Ravenna', N'', N'48100', N'Italy', N'(0544) 60323', N'(0544) 60603')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (15, N'Norske Meierier', N'Beate Vileid', N'Marketing Manager', N'', N'Hatlevegen 5', N'Sandvika', N'', N'1320', N'Norway', N'(0)2-953010', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (16, N'Bigfoot Breweries', N'Cheryl Saylor', N'Regional Account Rep.', N'', N'3400 - 8th Avenue Suite 210', N'Bend', N'OR', N'97101', N'USA', N'(503) 555-9931', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (17, N'Svensk Sjöföda AB', N'Michael Björn', N'Sales Representative', N'', N'Brovallavägen 231', N'Stockholm', N'', N'S-123 45', N'Sweden', N'08-123 45 67', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (18, N'Aux joyeux ecclésiastiques', N'Guylène Nodier', N'Sales Manager', N'', N'203, Rue des Francs-Bourgeois', N'Paris', N'', N'75004', N'France', N'(1) 03.83.00.68', N'(1) 03.83.00.62')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (19, N'New England Seafood Cannery', N'Robb Merchant', N'Wholesale Account Agent', N'', N'Order Processing Dept. 2100 Paul Revere Blvd.', N'Boston', N'MA', N'02134', N'USA', N'(617) 555-3267', N'(617) 555-3389')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (20, N'Leka Trading', N'Chandra Leka', N'Owner', N'', N'471 Serangoon Loop, Suite #402', N'Singapore', N'', N'0512', N'Singapore', N'555-8787', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (21, N'Lyngbysild', N'Niels Petersen', N'Sales Manager', N'', N'Lyngbysild Fiskebakken 10', N'Lyngby', N'', N'2800', N'Denmark', N'43844108', N'43844115')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (22, N'Zaanse Snoepfabriek', N'Dirk Luchte', N'Accounting Manager', N'', N'Verkoop Rijnweg 22', N'Zaandam', N'', N'9999 ZZ', N'Netherlands', N'(12345) 1212', N'(12345) 1210')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (23, N'Karkki Oy', N'Anne Heikkonen', N'Product Manager', N'', N'Valtakatu 12', N'Lappeenranta', N'', N'53120', N'Finland', N'(953) 10956', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (24, N'G''day, Mate', N'Wendy Mackenzie', N'Sales Representative', N'G''day Mate (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/gdaymate.htm#', N'170 Prince Edward Parade Hunter''s Hill', N'Sydney', N'NSW', N'2042', N'Australia', N'(02) 555-5914', N'(02) 555-4873')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (25, N'Ma Maison', N'Jean-Guy Lauzon', N'Marketing Manager', N'', N'2960 Rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada', N'(514) 555-9022', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (26, N'Pasta Buttini s.r.l.', N'Giovanni Giudici', N'Order Administrator', N'', N'Via dei Gelsomini, 153', N'Salerno', N'', N'84100', N'Italy', N'(089) 6547665', N'(089) 6547667')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (27, N'Escargots Nouveaux', N'Marie Delamare', N'Sales Manager', N'', N'22, rue H. Voiron', N'Montceau', N'', N'71300', N'France', N'85.57.00.07', N'')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (28, N'Gai pâturage', N'Eliane Noz', N'Sales Representative', N'', N'Bat. B 3, rue des Alpes', N'Annecy', N'', N'74000', N'France', N'38.76.98.06', N'38.76.98.58')
INSERT [dbo].[Suppliers] ([SupplierId], [CompanyName], [ContactName], [ContactTitle], [HomePage], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (29, N'Forêts d''érables', N'Chantal Goulet', N'Accounting Manager', N'', N'148 rue Chasseur', N'Ste-Hyacinthe', N'Québec', N'J2S 7S8', N'Canada', N'(514) 555-2955', N'(514) 555-2921')
/****** Object:  Table [dbo].[States]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[States](
	[StateId] [bigint] IDENTITY(1,1) NOT NULL,
	[Abbreviation] [nvarchar](255) NOT NULL,
	[FullName] [nvarchar](255) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[StateId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[States] ON
INSERT [dbo].[States] ([StateId], [Abbreviation], [FullName]) VALUES (1, N'NY', N'New York')
INSERT [dbo].[States] ([StateId], [Abbreviation], [FullName]) VALUES (2, N'FL', N'Florida')
SET IDENTITY_INSERT [dbo].[States] OFF
/****** Object:  Table [dbo].[Shippers]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Shippers](
	[ShipperId] [int] NOT NULL,
	[CompanyName] [nvarchar](40) NOT NULL,
	[Phone] [nvarchar](24) NULL,
	[Reference] [uniqueidentifier] NULL,
PRIMARY KEY CLUSTERED 
(
	[ShipperId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Shippers] ([ShipperId], [CompanyName], [Phone], [Reference]) VALUES (1, N'Speedy Express', N'(503) 555-9831', N'356e4a7e-b027-4321-ba40-e2677e6502cf')
INSERT [dbo].[Shippers] ([ShipperId], [CompanyName], [Phone], [Reference]) VALUES (2, N'United Package', N'(503) 555-3199', N'6dfcd0d7-4d2e-4525-a502-3ea9aa52e965')
INSERT [dbo].[Shippers] ([ShipperId], [CompanyName], [Phone], [Reference]) VALUES (3, N'Federal Shipping', N'(503) 555-9931', N'716f114b-e253-4166-8c76-46e6f340b58f')
/****** Object:  Table [dbo].[AnotherEntity]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AnotherEntity](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Output] [nvarchar](255) NULL,
	[Input] [nvarchar](255) NULL,
	[CompositeObjectId] INT NULL,
	[CompositeTenantId] INT NULL,
PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[AnotherEntity] ON
INSERT [dbo].[AnotherEntity] ([Id], [Output]) VALUES (1, N'output')
INSERT [dbo].[AnotherEntity] ([Id], [Input]) VALUES (2, N'input')
INSERT [dbo].[AnotherEntity] ([Id], [Input], [Output]) VALUES (3, N'i/o', N'i/o')
INSERT [dbo].[AnotherEntity] ([Id], [Input], [Output], [CompositeObjectId], [CompositeTenantId]) VALUES (4, N'input', N'output', 1, 10)
INSERT [dbo].[AnotherEntity] ([Id], [Input], [Output]) VALUES (5, NULL, NULL)
SET IDENTITY_INSERT [dbo].[AnotherEntity] OFF
/****** Object:  Table [dbo].[CompositeIdEntity] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CompositeIdEntity](
	[ObjectId] [int] NOT NULL,
	[TenantId] [int] NOT NULL,
	[Name] [nvarchar](128) NULL
PRIMARY KEY CLUSTERED 
(
	[ObjectId] ASC,
	[TenantId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[CompositeIdEntity] ([ObjectId], [TenantId], [Name]) VALUES (1, 10, N'Jack Stephan')

/****** Object:  Table [dbo].[Animal]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Animal](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Description] [nvarchar](255) NULL,
	[body_weight] [float] NULL,
	[mother_id] [int] NULL,
	[father_id] [int] NULL,
	[SerialNumber] [nvarchar](255) NULL,
	[ParentId] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[Animal] ON
INSERT [dbo].[Animal] ([Id], [Description], [body_weight], [mother_id], [father_id], [SerialNumber], [ParentId]) VALUES (1, NULL, 100, NULL, NULL, N'123', NULL)
INSERT [dbo].[Animal] ([Id], [Description], [body_weight], [mother_id], [father_id], [SerialNumber], [ParentId]) VALUES (2, NULL, 40, NULL, NULL, N'789', NULL)
INSERT [dbo].[Animal] ([Id], [Description], [body_weight], [mother_id], [father_id], [SerialNumber], [ParentId]) VALUES (3, NULL, 30, NULL, NULL, N'1234', NULL)
INSERT [dbo].[Animal] ([Id], [Description], [body_weight], [mother_id], [father_id], [SerialNumber], [ParentId]) VALUES (4, NULL, 156, NULL, NULL, N'5678', 1)
INSERT [dbo].[Animal] ([Id], [Description], [body_weight], [mother_id], [father_id], [SerialNumber], [ParentId]) VALUES (5, NULL, 205, NULL, NULL, N'9101', 1)
INSERT [dbo].[Animal] ([Id], [Description], [body_weight], [mother_id], [father_id], [SerialNumber], [ParentId]) VALUES (6, NULL, 115, 5, 4, N'1121', 2)
SET IDENTITY_INSERT [dbo].[Animal] OFF
/****** Object:  Table [dbo].[Customers]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Customers](
	[CustomerId] [nvarchar](255) NOT NULL,
	[CompanyName] [nvarchar](40) NOT NULL,
	[ContactName] [nvarchar](30) NULL,
	[ContactTitle] [nvarchar](30) NULL,
	[Address] [nvarchar](60) NULL,
	[City] [nvarchar](15) NULL,
	[Region] [nvarchar](15) NULL,
	[PostalCode] [nvarchar](10) NULL,
	[Country] [nvarchar](15) NULL,
	[Phone] [nvarchar](24) NULL,
	[Fax] [nvarchar](24) NULL,
PRIMARY KEY CLUSTERED 
(
	[CustomerId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'ALFKI', N'Alfreds Futterkiste', N'Maria Anders', N'Sales Representative', N'Obere Str. 57', N'Berlin', N'', N'12209', N'Germany', N'030-0074321', N'030-0076545')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'ANATR', N'Ana Trujillo Emparedados y helados', N'Ana Trujillo', N'Owner', N'Avda. de la Constitución 2222', N'México D.F.', N'', N'05021', N'Mexico', N'(5) 555-4729', N'(5) 555-3745')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'ANTON', N'Antonio Moreno Taquería', N'Antonio Moreno', N'Owner', N'Mataderos  2312', N'México D.F.', N'', N'05023', N'Mexico', N'(5) 555-3932', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'AROUT', N'Around the Horn', N'Thomas Hardy', N'Sales Representative', N'120 Hanover Sq.', N'London', N'', N'WA1 1DP', N'UK', N'(171) 555-7788', N'(171) 555-6750')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'BERGS', N'Berglunds snabbköp', N'Christina Berglund', N'Order Administrator', N'Berguvsvägen  8', N'Luleå', N'', N'S-958 22', N'Sweden', N'0921-12 34 65', N'0921-12 34 67')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'BLAUS', N'Blauer See Delikatessen', N'Hanna Moos', N'Sales Representative', N'Forsterstr. 57', N'Mannheim', N'', N'68306', N'Germany', N'0621-08460', N'0621-08924')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'BLONP', N'Blondesddsl père et fils', N'Frédérique Citeaux', N'Marketing Manager', N'24, place Kléber', N'Strasbourg', N'', N'67000', N'France', N'88.60.15.31', N'88.60.15.32')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'BOLID', N'Bólido Comidas preparadas', N'Martín Sommer', N'Owner', N'C/ Araquil, 67', N'Madrid', N'', N'28023', N'Spain', N'(91) 555 22 82', N'(91) 555 91 99')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'BONAP', N'Bon app''', N'Laurence Lebihan', N'Owner', N'12, rue des Bouchers', N'Marseille', N'', N'13008', N'France', N'91.24.45.40', N'91.24.45.41')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'BOTTM', N'Bottom-Dollar Markets', N'Elizabeth Lincoln', N'Accounting Manager', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada', N'(604) 555-4729', N'(604) 555-3745')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'BSBEV', N'B''s Beverages', N'Victoria Ashworth', N'Sales Representative', N'Fauntleroy Circus', N'London', N'', N'EC2 5NT', N'UK', N'(171) 555-1212', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'CACTU', N'Cactus Comidas para llevar', N'Patricio Simpson', N'Sales Agent', N'Cerrito 333', N'Buenos Aires', N'', N'1010', N'Argentina', N'(1) 135-5555', N'(1) 135-4892')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'CENTC', N'Centro comercial Moctezuma', N'Francisco Chang', N'Marketing Manager', N'Sierras de Granada 9993', N'México D.F.', N'', N'05022', N'Mexico', N'(5) 555-3392', N'(5) 555-7293')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'CHOPS', N'Chop-suey Chinese', N'Yang Wang', N'Owner', N'Hauptstr. 29', N'Bern', N'', N'3012', N'Switzerland', N'0452-076545', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'COMMI', N'Comércio Mineiro', N'Pedro Afonso', N'Sales Associate', N'Av. dos Lusíadas, 23', N'Sao Paulo', N'SP', N'05432-043', N'Brazil', N'(11) 555-7647', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'CONSH', N'Consolidated Holdings', N'Elizabeth Brown', N'Sales Representative', N'Berkeley Gardens 12  Brewery', N'London', N'', N'WX1 6LT', N'UK', N'(171) 555-2282', N'(171) 555-9199')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'DRACD', N'Drachenblut Delikatessen', N'Sven Ottlieb', N'Order Administrator', N'Walserweg 21', N'Aachen', N'', N'52066', N'Germany', N'0241-039123', N'0241-059428')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'DUMON', N'Du monde entier', N'Janine Labrune', N'Owner', N'67, rue des Cinquante Otages', N'Nantes', N'', N'44000', N'France', N'40.67.88.88', N'40.67.89.89')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'EASTC', N'Eastern Connection', N'Ann Devon', N'Sales Agent', N'35 King George', N'London', N'', N'WX3 6FW', N'UK', N'(171) 555-0297', N'(171) 555-3373')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'ERNSH', N'Ernst Handel', N'Roland Mendel', N'Sales Manager', N'Kirchgasse 6', N'Graz', N'', N'8010', N'Austria', N'7675-3425', N'7675-3426')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'FAMIA', N'Familia Arquibaldo', N'Aria Cruz', N'Marketing Assistant', N'Rua Orós, 92', N'Sao Paulo', N'SP', N'05442-030', N'Brazil', N'(11) 555-9857', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'FISSA', N'FISSA Fabrica Inter. Salchichas S.A.', N'Diego Roel', N'Accounting Manager', N'C/ Moralzarzal, 86', N'Madrid', N'', N'28034', N'Spain', N'(91) 555 94 44', N'(91) 555 55 93')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'FOLIG', N'Folies gourmandes', N'Martine Rancé', N'Assistant Sales Agent', N'184, chaussée de Tournai', N'Lille', N'', N'59000', N'France', N'20.16.10.16', N'20.16.10.17')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'FOLKO', N'Folk och fä HB', N'Maria Larsson', N'Owner', N'Åkergatan 24', N'Bräcke', N'', N'S-844 67', N'Sweden', N'0695-34 67 21', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'FRANK', N'Frankenversand', N'Peter Franken', N'Marketing Manager', N'Berliner Platz 43', N'München', N'', N'80805', N'Germany', N'089-0877310', N'089-0877451')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'FRANR', N'France restauration', N'Carine Schmitt', N'Marketing Manager', N'54, rue Royale', N'Nantes', N'', N'44000', N'France', N'40.32.21.21', N'40.32.21.20')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'FRANS', N'Franchi S.p.A.', N'Paolo Accorti', N'Sales Representative', N'Via Monte Bianco 34', N'Torino', N'', N'10100', N'Italy', N'011-4988260', N'011-4988261')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'FURIB', N'Furia Bacalhau e Frutos do Mar', N'Lino Rodriguez', N'Sales Manager', N'Jardim das rosas n. 32', N'Lisboa', N'', N'1675', N'Portugal', N'(1) 354-2534', N'(1) 354-2535')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'GALED', N'Galería del gastrónomo', N'Eduardo Saavedra', N'Marketing Manager', N'Rambla de Cataluña, 23', N'Barcelona', N'', N'08022', N'Spain', N'(93) 203 4560', N'(93) 203 4561')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'GODOS', N'Godos Cocina Típica', N'José Pedro Freyre', N'Sales Manager', N'C/ Romero, 33', N'Sevilla', N'', N'41101', N'Spain', N'(95) 555 82 82', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'GOURL', N'Gourmet Lanchonetes', N'André Fonseca', N'Sales Associate', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil', N'(11) 555-9482', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'GREAL', N'Great Lakes Food Market', N'Howard Snyder', N'Marketing Manager', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA', N'(503) 555-7555', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'GROSR', N'GROSELLA-Restaurante', N'Manuel Pereira', N'Owner', N'5ª Ave. Los Palos Grandes', N'Caracas', N'DF', N'1081', N'Venezuela', N'(2) 283-2951', N'(2) 283-3397')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'HANAR', N'Hanari Carnes', N'Mario Pontes', N'Accounting Manager', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil', N'(21) 555-0091', N'(21) 555-8765')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'HILAA', N'HILARION-Abastos', N'Carlos Hernández', N'Sales Representative', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela', N'(5) 555-1340', N'(5) 555-1948')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'HUNGC', N'Hungry Coyote Import Store', N'Yoshi Latimer', N'Sales Representative', N'City Center Plaza 516 Main St.', N'Elgin', N'OR', N'97827', N'USA', N'(503) 555-6874', N'(503) 555-2376')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'HUNGO', N'Hungry Owl All-Night Grocers', N'Patricia McKenna', N'Sales Associate', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'', N'Ireland', N'2967 542', N'2967 3333')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'ISLAT', N'Island Trading', N'Helen Bennett', N'Marketing Manager', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK', N'(198) 555-8888', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'KOENE', N'Königlich Essen', N'Philip Cramer', N'Sales Associate', N'Maubelstr. 90', N'Brandenburg', N'', N'14776', N'Germany', N'0555-09876', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'LACOR', N'La corne d''abondance', N'Daniel Tonini', N'Sales Representative', N'67, avenue de l''Europe', N'Versailles', N'', N'78000', N'France', N'30.59.84.10', N'30.59.85.11')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'LAMAI', N'La maison d''Asie', N'Annette Roulet', N'Sales Manager', N'1 rue Alsace-Lorraine', N'Toulouse', N'', N'31000', N'France', N'61.77.61.10', N'61.77.61.11')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'LAUGB', N'Laughing Bacchus Wine Cellars', N'Yoshi Tannamuri', N'Marketing Assistant', N'1900 Oak St.', N'Vancouver', N'BC', N'V3F 2K1', N'Canada', N'(604) 555-3392', N'(604) 555-7293')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'LAZYK', N'Lazy K Kountry Store', N'John Steel', N'Marketing Manager', N'12 Orchestra Terrace', N'Walla Walla', N'WA', N'99362', N'USA', N'(509) 555-7969', N'(509) 555-6221')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'LEHMS', N'Lehmanns Marktstand', N'Renate Messner', N'Sales Representative', N'Magazinweg 7', N'Frankfurt a.M.', N'', N'60528', N'Germany', N'069-0245984', N'069-0245874')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'LETSS', N'Let''s Stop N Shop', N'Jaime Yorres', N'Owner', N'87 Polk St. Suite 5', N'San Francisco', N'CA', N'94117', N'USA', N'(415) 555-5938', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'LILAS', N'LILA-Supermercado', N'Carlos González', N'Accounting Manager', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela', N'(9) 331-6954', N'(9) 331-7256')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'LINOD', N'LINO-Delicateses', N'Felipe Izquierdo', N'Owner', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela', N'(8) 34-56-12', N'(8) 34-93-93')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'LONEP', N'Lonesome Pine Restaurant', N'Fran Wilson', N'Sales Manager', N'89 Chiaroscuro Rd.', N'Portland', N'OR', N'97219', N'USA', N'(503) 555-9573', N'(503) 555-9646')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'MAGAA', N'Magazzini Alimentari Riuniti', N'Giovanni Rovelli', N'Marketing Manager', N'Via Ludovico il Moro 22', N'Bergamo', N'', N'24100', N'Italy', N'035-640230', N'035-640231')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'MAISD', N'Maison Dewey', N'Catherine Dewey', N'Sales Agent', N'Rue Joseph-Bens 532', N'Bruxelles', N'', N'B-1180', N'Belgium', N'(02) 201 24 67', N'(02) 201 24 68')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'MEREP', N'Mère Paillarde', N'Jean Fresnière', N'Marketing Assistant', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada', N'(514) 555-8054', N'(514) 555-8055')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'MORGK', N'Morgenstern Gesundkost', N'Alexander Feuer', N'Marketing Assistant', N'Heerstr. 22', N'Leipzig', N'', N'04179', N'Germany', N'0342-023176', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'NORTS', N'North/South', N'Simon Crowther', N'Sales Associate', N'South House 300 Queensbridge', N'London', N'', N'SW7 1RZ', N'UK', N'(171) 555-7733', N'(171) 555-2530')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'OCEAN', N'Océano Atlántico Ltda.', N'Yvonne Moncada', N'Sales Agent', N'Ing. Gustavo Moncada 8585 Piso 20-A', N'Buenos Aires', N'', N'1010', N'Argentina', N'(1) 135-5333', N'(1) 135-5535')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'OLDWO', N'Old World Delicatessen', N'Rene Phillips', N'Sales Representative', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA', N'(907) 555-7584', N'(907) 555-2880')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'OTTIK', N'Ottilies Käseladen', N'Henriette Pfalzheim', N'Owner', N'Mehrheimerstr. 369', N'Köln', N'', N'50739', N'Germany', N'0221-0644327', N'0221-0765721')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'PARIS', N'Paris spécialités', N'Marie Bertrand', N'Owner', N'265, boulevard Charonne', N'Paris', N'', N'75012', N'France', N'(1) 42.34.22.66', N'(1) 42.34.22.77')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'PERIC', N'Pericles Comidas clásicas', N'Guillermo Fernández', N'Sales Representative', N'Calle Dr. Jorge Cash 321', N'México D.F.', N'', N'05033', N'Mexico', N'(5) 552-3745', N'(5) 545-3745')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'PICCO', N'Piccolo und mehr', N'Georg Pipps', N'Sales Manager', N'Geislweg 14', N'Salzburg', N'', N'5020', N'Austria', N'6562-9722', N'6562-9723')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'PRINI', N'Princesa Isabel Vinhos', N'Isabel de Castro', N'Sales Representative', N'Estrada da saúde n. 58', N'Lisboa', N'', N'1756', N'Portugal', N'(1) 356-5634', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'QUEDE', N'Que Delícia', N'Bernardo Batista', N'Accounting Manager', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil', N'(21) 555-4252', N'(21) 555-4545')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'QUEEN', N'Queen Cozinha', N'Lúcia Carvalho', N'Marketing Assistant', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil', N'(11) 555-1189', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'QUICK', N'QUICK-Stop', N'Horst Kloss', N'Accounting Manager', N'Taucherstraße 10', N'Cunewalde', N'', N'01307', N'Germany', N'0372-035188', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'RANCH', N'Rancho grande', N'Sergio Gutiérrez', N'Sales Representative', N'Av. del Libertador 900', N'Buenos Aires', N'', N'1010', N'Argentina', N'(1) 123-5555', N'(1) 123-5556')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'RATTC', N'Rattlesnake Canyon Grocery', N'Paula Wilson', N'Assistant Sales Representative', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA', N'(505) 555-5939', N'(505) 555-3620')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'REGGC', N'Reggiani Caseifici', N'Maurizio Moroni', N'Sales Associate', N'Strada Provinciale 124', N'Reggio Emilia', N'', N'42100', N'Italy', N'0522-556721', N'0522-556722')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'RICAR', N'Ricardo Adocicados', N'Janete Limeira', N'Assistant Sales Agent', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil', N'(21) 555-3412', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'RICSU', N'Richter Supermarkt', N'Michael Holz', N'Sales Manager', N'Grenzacherweg 237', N'Genève', N'', N'1203', N'Switzerland', N'0897-034214', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'ROMEY', N'Romero y tomillo', N'Alejandra Camino', N'Accounting Manager', N'Gran Vía, 1', N'Madrid', N'', N'28001', N'Spain', N'(91) 745 6200', N'(91) 745 6210')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'SANTG', N'Santé Gourmet', N'Jonas Bergulfsen', N'Owner', N'Erling Skakkes gate 78', N'Stavern', N'', N'4110', N'Norway', N'07-98 92 35', N'07-98 92 47')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'SAVEA', N'Save-a-lot Markets', N'Jose Pavarotti', N'Sales Representative', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA', N'(208) 555-8097', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'SEVES', N'Seven Seas Imports', N'Hari Kumar', N'Sales Manager', N'90 Wadhurst Rd.', N'London', N'', N'OX15 4NB', N'UK', N'(171) 555-1717', N'(171) 555-5646')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'SIMOB', N'Simons bistro', N'Jytte Petersen', N'Owner', N'Vinbæltet 34', N'Kobenhavn', N'', N'1734', N'Denmark', N'31 12 34 56', N'31 13 35 57')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'SPECD', N'Spécialités du monde', N'Dominique Perrier', N'Marketing Manager', N'25, rue Lauriston', N'Paris', N'', N'75016', N'France', N'(1) 47.55.60.10', N'(1) 47.55.60.20')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'SPLIR', N'Split Rail Beer & Ale', N'Art Braunschweiger', N'Sales Manager', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA', N'(307) 555-4680', N'(307) 555-6525')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'SUPRD', N'Suprêmes délices', N'Pascale Cartrain', N'Accounting Manager', N'Boulevard Tirou, 255', N'Charleroi', N'', N'B-6000', N'Belgium', N'(071) 23 67 22 20', N'(071) 23 67 22 21')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'THEBI', N'The Big Cheese', N'Liz Nixon', N'Marketing Manager', N'89 Jefferson Way Suite 2', N'Portland', N'OR', N'97201', N'USA', N'(503) 555-3612', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'THECR', N'The Cracker Box', N'Liu Wong', N'Marketing Assistant', N'55 Grizzly Peak Rd.', N'Butte', N'MT', N'59801', N'USA', N'(406) 555-5834', N'(406) 555-8083')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'TOMSP', N'Toms Spezialitäten', N'Karin Josephs', N'Marketing Manager', N'Luisenstr. 48', N'Münster', N'', N'44087', N'Germany', N'0251-031259', N'0251-035695')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'TORTU', N'Tortuga Restaurante', N'Miguel Angel Paolino', N'Owner', N'Avda. Azteca 123', N'México D.F.', N'', N'05033', N'Mexico', N'(5) 555-2933', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'TRADH', N'Tradição Hipermercados', N'Anabela Domingues', N'Sales Representative', N'Av. Inês de Castro, 414', N'Sao Paulo', N'SP', N'05634-030', N'Brazil', N'(11) 555-2167', N'(11) 555-2168')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'TRAIH', N'Trail''s Head Gourmet Provisioners', N'Helvetius Nagy', N'Sales Associate', N'722 DaVinci Blvd.', N'Kirkland', N'WA', N'98034', N'USA', N'(206) 555-8257', N'(206) 555-2174')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'VAFFE', N'Vaffeljernet', N'Palle Ibsen', N'Sales Manager', N'Smagsloget 45', N'Århus', N'', N'8200', N'Denmark', N'86 21 32 43', N'86 22 33 44')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'VICTE', N'Victuailles en stock', N'Mary Saveley', N'Sales Agent', N'2, rue du Commerce', N'Lyon', N'', N'69004', N'France', N'78.32.54.86', N'78.32.54.87')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'VINET', N'Vins et alcools Chevalier', N'Paul Henriot', N'Accounting Manager', N'59 rue de l''Abbaye', N'Reims', N'', N'51100', N'France', N'26.47.15.10', N'26.47.15.11')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'WANDK', N'Die Wandernde Kuh', N'Rita Müller', N'Sales Representative', N'Adenauerallee 900', N'Stuttgart', N'', N'70563', N'Germany', N'0711-020361', N'0711-035428')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'WARTH', N'Wartian Herkku', N'Pirkko Koskitalo', N'Accounting Manager', N'Torikatu 38', N'Oulu', N'', N'90110', N'Finland', N'981-443655', N'981-443655')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'WELLI', N'Wellington Importadora', N'Paula Parente', N'Sales Manager', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil', N'(14) 555-8122', N'')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'WHITC', N'White Clover Markets', N'Karl Jablonski', N'Owner', N'305 - 14th Ave. S. Suite 3B', N'Seattle', N'WA', N'98128', N'USA', N'(206) 555-4112', N'(206) 555-4115')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'WILMK', N'Wilman Kala', N'Matti Karttunen', N'Owner/Marketing Assistant', N'Keskuskatu 45', N'Helsinki', N'', N'21240', N'Finland', N'90-224 8858', N'90-224 8858')
INSERT [dbo].[Customers] ([CustomerId], [CompanyName], [ContactName], [ContactTitle], [Address], [City], [Region], [PostalCode], [Country], [Phone], [Fax]) VALUES (N'WOLZA', N'Wolski  Zajazd', N'Zbyszek Piestrzeniewicz', N'Owner', N'ul. Filtrowa 68', N'Warszawa', N'', N'01-012', N'Poland', N'(26) 642-7012', N'(26) 642-7012')
/****** Object:  Table [dbo].[Categories]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Categories](
	[CategoryId] [int] NOT NULL,
	[CategoryName] [nvarchar](15) NOT NULL,
	[Description] [nvarchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[CategoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Categories] ([CategoryId], [CategoryName], [Description]) VALUES (1, N'Beverages', N'Soft drinks, coffees, teas, beers, and ales')
INSERT [dbo].[Categories] ([CategoryId], [CategoryName], [Description]) VALUES (2, N'Condiments', N'Sweet and savory sauces, relishes, spreads, and seasonings')
INSERT [dbo].[Categories] ([CategoryId], [CategoryName], [Description]) VALUES (3, N'Confections', N'Desserts, candies, and sweet breads')
INSERT [dbo].[Categories] ([CategoryId], [CategoryName], [Description]) VALUES (4, N'Dairy Products', N'Cheeses')
INSERT [dbo].[Categories] ([CategoryId], [CategoryName], [Description]) VALUES (5, N'Grains/Cereals', N'Breads, crackers, pasta, and cereal')
INSERT [dbo].[Categories] ([CategoryId], [CategoryName], [Description]) VALUES (6, N'Meat/Poultry', N'Prepared meats')
INSERT [dbo].[Categories] ([CategoryId], [CategoryName], [Description]) VALUES (7, N'Produce', N'Dried fruit and bean curd')
INSERT [dbo].[Categories] ([CategoryId], [CategoryName], [Description]) VALUES (8, N'Seafood', N'Seaweed and fish')
/****** Object:  Table [dbo].[Employees]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Employees](
	[EmployeeId] [int] NOT NULL,
	[LastName] [nvarchar](20) NOT NULL,
	[FirstName] [nvarchar](10) NOT NULL,
	[Title] [nvarchar](30) NULL,
	[TitleOfCourtesy] [nvarchar](25) NULL,
	[BirthDate] [datetime] NULL,
	[HireDate] [datetime] NULL,
	[Address] [nvarchar](60) NULL,
	[City] [nvarchar](15) NULL,
	[Region] [nvarchar](15) NULL,
	[PostalCode] [nvarchar](10) NULL,
	[Country] [nvarchar](15) NULL,
	[HomePhone] [nvarchar](24) NULL,
	[Extension] [nvarchar](4) NULL,
	[Notes] [nvarchar](4000) NULL,
	[ReportsTo] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[EmployeeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Employees] ([EmployeeId], [LastName], [FirstName], [Title], [TitleOfCourtesy], [BirthDate], [HireDate], [Address], [City], [Region], [PostalCode], [Country], [HomePhone], [Extension], [Notes], [ReportsTo]) VALUES (1, N'Davolio', N'Nancy', N'Sales Representative', N'Ms.', CAST(0x000045D100000000 AS DateTime), CAST(0x000083BB00000000 AS DateTime), N'507 - 20th Ave. E.Apt. 2A', N'Seattle', N'WA', N'98122', N'USA', N'(206) 555-9857', N'5467', N'Education includes a BA in psychology from Colorado State University in 1970.  She also completed ''The Art of the Cold Call.''  Nancy is a member of Toastmasters International.', NULL)
INSERT [dbo].[Employees] ([EmployeeId], [LastName], [FirstName], [Title], [TitleOfCourtesy], [BirthDate], [HireDate], [Address], [City], [Region], [PostalCode], [Country], [HomePhone], [Extension], [Notes], [ReportsTo]) VALUES (2, N'Fuller', N'Andrew', N'Vice President, Sales', N'Dr.', CAST(0x00004A6100000000 AS DateTime), CAST(0x0000842400000000 AS DateTime), N'908 W. Capital Way', N'Tacoma', N'WA', N'98401', N'USA', N'(206) 555-9482', N'3457', N'Andrew received his BTS commercial in 1974 and a Ph.D. in international marketing from the University of Dallas in 1981.  He is fluent in French and Italian and reads German.  He joined the company as a sales representative, was promoted to sales manager in January 1992 and to vice president of sales in March 1993.  Andrew is a member of the Sales Management Roundtable, the Seattle Chamber of Commerce, and the Pacific Rim Importers Association.', NULL)
INSERT [dbo].[Employees] ([EmployeeId], [LastName], [FirstName], [Title], [TitleOfCourtesy], [BirthDate], [HireDate], [Address], [City], [Region], [PostalCode], [Country], [HomePhone], [Extension], [Notes], [ReportsTo]) VALUES (3, N'Leverling', N'Janet', N'Sales Representative', N'Ms.', CAST(0x00005AD300000000 AS DateTime), CAST(0x0000839D00000000 AS DateTime), N'722 Moss Bay Blvd.', N'Kirkland', N'WA', N'98033', N'USA', N'(206) 555-3412', N'3355', N'Janet has a BS degree in chemistry from Boston College (1984).  She has also completed a certificate program in food retailing management.  Janet was hired as a sales associate in 1991 and promoted to sales representative in February 1992.', NULL)
INSERT [dbo].[Employees] ([EmployeeId], [LastName], [FirstName], [Title], [TitleOfCourtesy], [BirthDate], [HireDate], [Address], [City], [Region], [PostalCode], [Country], [HomePhone], [Extension], [Notes], [ReportsTo]) VALUES (4, N'Peacock', N'Margaret', N'Sales Representative', N'Mrs.', CAST(0x000035CF00000000 AS DateTime), CAST(0x0000852A00000000 AS DateTime), N'4110 Old Redmond Rd.', N'Redmond', N'WA', N'98052', N'USA', N'(206) 555-8122', N'5176', N'Margaret holds a BA in English literature from Concordia College (1958) and an MA from the American Institute of Culinary Arts (1966).  She was assigned to the London office temporarily from July through November 1992.', NULL)
INSERT [dbo].[Employees] ([EmployeeId], [LastName], [FirstName], [Title], [TitleOfCourtesy], [BirthDate], [HireDate], [Address], [City], [Region], [PostalCode], [Country], [HomePhone], [Extension], [Notes], [ReportsTo]) VALUES (5, N'Buchanan', N'Steven', N'Sales Manager', N'Mr.', CAST(0x00004EB600000000 AS DateTime), CAST(0x000085D100000000 AS DateTime), N'14 Garrett Hill', N'London', N'', N'SW1 8JR', N'UK', N'(71) 555-4848', N'3453', N'Steven Buchanan graduated from St. Andrews University, Scotland, with a BSC degree in 1976.  Upon joining the company as a sales representative in 1992, he spent 6 months in an orientation program at the Seattle office and then returned to his permanent post in London.  He was promoted to sales manager in March 1993.  Mr. Buchanan has completed the courses ''Successful Telemarketing'' and ''International Sales Management.''  He is fluent in French.', NULL)
INSERT [dbo].[Employees] ([EmployeeId], [LastName], [FirstName], [Title], [TitleOfCourtesy], [BirthDate], [HireDate], [Address], [City], [Region], [PostalCode], [Country], [HomePhone], [Extension], [Notes], [ReportsTo]) VALUES (6, N'Suyama', N'Michael', N'Sales Representative', N'Mr.', CAST(0x00005A9800000000 AS DateTime), CAST(0x000085D100000000 AS DateTime), N'Coventry HouseMiner Rd.', N'London', N'', N'EC2 7JR', N'UK', N'(71) 555-7773', N'428', N'Michael is a graduate of Sussex University (MA, economics, 1983) and the University of California at Los Angeles (MBA, marketing, 1986).  He has also taken the courses ''Multi-Cultural Selling'' and ''Time Management for the Sales Professional.''  He is fluent in Japanese and can read and write French, Portuguese, and Spanish.', NULL)
INSERT [dbo].[Employees] ([EmployeeId], [LastName], [FirstName], [Title], [TitleOfCourtesy], [BirthDate], [HireDate], [Address], [City], [Region], [PostalCode], [Country], [HomePhone], [Extension], [Notes], [ReportsTo]) VALUES (7, N'King', N'Robert', N'Sales Representative', N'Mr.', CAST(0x0000562F00000000 AS DateTime), CAST(0x0000861E00000000 AS DateTime), N'Edgeham HollowWinchester Way', N'London', N'', N'RG1 9SP', N'UK', N'(71) 555-5598', N'465', N'Robert King served in the Peace Corps and traveled extensively before completing his degree in English at the University of Michigan in 1992, the year he joined the company.  After completing a course entitled ''Selling in Europe,'' he was transferred to the London office in March 1993.', NULL)
INSERT [dbo].[Employees] ([EmployeeId], [LastName], [FirstName], [Title], [TitleOfCourtesy], [BirthDate], [HireDate], [Address], [City], [Region], [PostalCode], [Country], [HomePhone], [Extension], [Notes], [ReportsTo]) VALUES (8, N'Callahan', N'Laura', N'Inside Sales Coordinator', N'Ms.', CAST(0x000052C800000000 AS DateTime), CAST(0x0000865C00000000 AS DateTime), N'4726 - 11th Ave. N.E.', N'Seattle', N'WA', N'98105', N'USA', N'(206) 555-1189', N'2344', N'Laura received a BA in psychology from the University of Washington.  She has also completed a course in business French.  She reads and writes French.', NULL)
INSERT [dbo].[Employees] ([EmployeeId], [LastName], [FirstName], [Title], [TitleOfCourtesy], [BirthDate], [HireDate], [Address], [City], [Region], [PostalCode], [Country], [HomePhone], [Extension], [Notes], [ReportsTo]) VALUES (9, N'Dodsworth', N'Anne', N'Sales Representative', N'Ms.', CAST(0x00005E4400000000 AS DateTime), CAST(0x0000875B00000000 AS DateTime), N'7 Houndstooth Rd.', N'London', N'', N'WG2 7LT', N'UK', N'(71) 555-4444', N'452', N'Anne has a BA degree in English from St. Lawrence College.  She is fluent in French and German.', NULL)
/****** Object:  Table [dbo].[Timesheets]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Timesheets](
	[TimesheetId] [int] IDENTITY(1,1) NOT NULL,
	[SubmittedDate] [datetime] NULL,
	[Submitted] [bit] NULL,
PRIMARY KEY CLUSTERED 
(
	[TimesheetId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[Timesheets] ON
INSERT [dbo].[Timesheets] ([TimesheetId], [SubmittedDate], [Submitted]) VALUES (1, CAST(0x00009D9800000000 AS DateTime), 1)
INSERT [dbo].[Timesheets] ([TimesheetId], [SubmittedDate], [Submitted]) VALUES (2, CAST(0x00009D9700000000 AS DateTime), 0)
INSERT [dbo].[Timesheets] ([TimesheetId], [SubmittedDate], [Submitted]) VALUES (3, CAST(0x00009D990110B41C AS DateTime), 1)
SET IDENTITY_INSERT [dbo].[Timesheets] OFF
/****** Object:  Table [dbo].[TimesheetEntries]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TimesheetEntries](
	[TimesheetEntryId] [int] IDENTITY(1,1) NOT NULL,
	[EntryDate] [datetime] NULL,
	[NumberOfHours] [int] NULL,
	[Comments] [nvarchar](255) NULL,
	[TimesheetID] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[TimesheetEntryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[TimesheetEntries] ON
INSERT [dbo].[TimesheetEntries] ([TimesheetEntryId], [EntryDate], [NumberOfHours], [Comments], [TimesheetID]) VALUES (1, CAST(0x00009D9800000000 AS DateTime), 6, N'testing 123', 2)
INSERT [dbo].[TimesheetEntries] ([TimesheetEntryId], [EntryDate], [NumberOfHours], [Comments], [TimesheetID]) VALUES (2, CAST(0x00009D9900000000 AS DateTime), 14, NULL, 2)
INSERT [dbo].[TimesheetEntries] ([TimesheetEntryId], [EntryDate], [NumberOfHours], [Comments], [TimesheetID]) VALUES (3, CAST(0x00009D980116325C AS DateTime), 4, NULL, 3)
INSERT [dbo].[TimesheetEntries] ([TimesheetEntryId], [EntryDate], [NumberOfHours], [Comments], [TimesheetID]) VALUES (4, CAST(0x00009D980113733C AS DateTime), 8, N'testing 456', 3)
INSERT [dbo].[TimesheetEntries] ([TimesheetEntryId], [EntryDate], [NumberOfHours], [Comments], [TimesheetID]) VALUES (5, CAST(0x00009D980114462C AS DateTime), 7, NULL, 3)
INSERT [dbo].[TimesheetEntries] ([TimesheetEntryId], [EntryDate], [NumberOfHours], [Comments], [TimesheetID]) VALUES (6, CAST(0x00009D98011D102C AS DateTime), 38, NULL, 3)
SET IDENTITY_INSERT [dbo].[TimesheetEntries] OFF
/****** Object:  Table [dbo].[Territories]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Territories](
	[TerritoryId] [bigint] IDENTITY(1,1) NOT NULL,
	[TerritoryDescription] [nvarchar](50) NOT NULL,
	[RegionId] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[TerritoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Orders]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Orders](
	[OrderId] [int] NOT NULL,
	[CustomerId] [nvarchar](255) NOT NULL,
	[EmployeeId] [int] NULL,
	[OrderDate] [datetime] NULL,
	[RequiredDate] [datetime] NULL,
	[ShippedDate] [datetime] NULL,
	[ShipVia] [int] NULL,
	[Freight] [decimal](19, 5) NULL,
	[ShipName] [nvarchar](40) NULL,
	[ShipAddress] [nvarchar](60) NULL,
	[ShipCity] [nvarchar](15) NULL,
	[ShipRegion] [nvarchar](15) NULL,
	[ShipPostalCode] [nvarchar](10) NULL,
	[ShipCountry] [nvarchar](15) NULL,
PRIMARY KEY CLUSTERED 
(
	[OrderId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10248, N'VINET', 5, CAST(0x000089B000000000 AS DateTime), CAST(0x000089CC00000000 AS DateTime), CAST(0x000089BC00000000 AS DateTime), 3, CAST(32.38000 AS Decimal(19, 5)), N'Vins et alcools Chevalier', N'59 rue de l''Abbaye', N'Reims', N'null', N'51100', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10249, N'TOMSP', 6, CAST(0x000089B100000000 AS DateTime), CAST(0x000089DB00000000 AS DateTime), CAST(0x000089B600000000 AS DateTime), 1, CAST(11.61000 AS Decimal(19, 5)), N'Toms Spezialitäten', N'Luisenstr. 48', N'Münster', N'null', N'44087', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10250, N'HANAR', 4, CAST(0x000089B400000000 AS DateTime), CAST(0x000089D000000000 AS DateTime), CAST(0x000089B800000000 AS DateTime), 2, CAST(65.83000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10251, N'VICTE', 3, CAST(0x000089B400000000 AS DateTime), CAST(0x000089D000000000 AS DateTime), CAST(0x000089BB00000000 AS DateTime), 1, CAST(41.34000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10252, N'SUPRD', 4, CAST(0x000089B500000000 AS DateTime), CAST(0x000089D100000000 AS DateTime), CAST(0x000089B700000000 AS DateTime), 2, CAST(51.30000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10253, N'HANAR', 3, CAST(0x000089B600000000 AS DateTime), CAST(0x000089C400000000 AS DateTime), CAST(0x000089BC00000000 AS DateTime), 2, CAST(58.17000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10254, N'CHOPS', 5, CAST(0x000089B700000000 AS DateTime), CAST(0x000089D300000000 AS DateTime), CAST(0x000089C300000000 AS DateTime), 2, CAST(22.98000 AS Decimal(19, 5)), N'Chop-suey Chinese', N'Hauptstr. 31', N'Bern', N'null', N'3012', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10255, N'RICSU', 9, CAST(0x000089B800000000 AS DateTime), CAST(0x000089D400000000 AS DateTime), CAST(0x000089BB00000000 AS DateTime), 3, CAST(148.33000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10256, N'WELLI', 3, CAST(0x000089BB00000000 AS DateTime), CAST(0x000089D700000000 AS DateTime), CAST(0x000089BD00000000 AS DateTime), 2, CAST(13.97000 AS Decimal(19, 5)), N'Wellington Importadora', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10257, N'HILAA', 4, CAST(0x000089BC00000000 AS DateTime), CAST(0x000089D800000000 AS DateTime), CAST(0x000089C200000000 AS DateTime), 3, CAST(81.91000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10258, N'ERNSH', 1, CAST(0x000089BD00000000 AS DateTime), CAST(0x000089D900000000 AS DateTime), CAST(0x000089C300000000 AS DateTime), 1, CAST(140.51000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10259, N'CENTC', 4, CAST(0x000089BE00000000 AS DateTime), CAST(0x000089DA00000000 AS DateTime), CAST(0x000089C500000000 AS DateTime), 3, CAST(3.25000 AS Decimal(19, 5)), N'Centro comercial Moctezuma', N'Sierras de Granada 9993', N'México D.F.', N'null', N'05022', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10260, N'OTTIK', 4, CAST(0x000089BF00000000 AS DateTime), CAST(0x000089DB00000000 AS DateTime), CAST(0x000089C900000000 AS DateTime), 1, CAST(55.09000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10261, N'QUEDE', 4, CAST(0x000089BF00000000 AS DateTime), CAST(0x000089DB00000000 AS DateTime), CAST(0x000089CA00000000 AS DateTime), 2, CAST(3.05000 AS Decimal(19, 5)), N'Que Delícia', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10262, N'RATTC', 8, CAST(0x000089C200000000 AS DateTime), CAST(0x000089DE00000000 AS DateTime), CAST(0x000089C500000000 AS DateTime), 3, CAST(48.29000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10263, N'ERNSH', 9, CAST(0x000089C300000000 AS DateTime), CAST(0x000089DF00000000 AS DateTime), CAST(0x000089CB00000000 AS DateTime), 3, CAST(146.06000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10264, N'FOLKO', 6, CAST(0x000089C400000000 AS DateTime), CAST(0x000089E000000000 AS DateTime), CAST(0x000089E200000000 AS DateTime), 3, CAST(3.67000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10265, N'BLONP', 2, CAST(0x000089C500000000 AS DateTime), CAST(0x000089E100000000 AS DateTime), CAST(0x000089D700000000 AS DateTime), 1, CAST(55.28000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10266, N'WARTH', 3, CAST(0x000089C600000000 AS DateTime), CAST(0x000089F000000000 AS DateTime), CAST(0x000089CB00000000 AS DateTime), 3, CAST(25.73000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10267, N'FRANK', 4, CAST(0x000089C900000000 AS DateTime), CAST(0x000089E500000000 AS DateTime), CAST(0x000089D100000000 AS DateTime), 1, CAST(208.58000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10268, N'GROSR', 8, CAST(0x000089CA00000000 AS DateTime), CAST(0x000089E600000000 AS DateTime), CAST(0x000089CD00000000 AS DateTime), 3, CAST(66.29000 AS Decimal(19, 5)), N'GROSELLA-Restaurante', N'5ª Ave. Los Palos Grandes', N'Caracas', N'DF', N'1081', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10269, N'WHITC', 5, CAST(0x000089CB00000000 AS DateTime), CAST(0x000089D900000000 AS DateTime), CAST(0x000089D400000000 AS DateTime), 1, CAST(4.56000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10270, N'WARTH', 1, CAST(0x000089CC00000000 AS DateTime), CAST(0x000089E800000000 AS DateTime), CAST(0x000089CD00000000 AS DateTime), 1, CAST(136.54000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10271, N'SPLIR', 6, CAST(0x000089CC00000000 AS DateTime), CAST(0x000089E800000000 AS DateTime), CAST(0x000089E900000000 AS DateTime), 2, CAST(4.54000 AS Decimal(19, 5)), N'Split Rail Beer & Ale', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10272, N'RATTC', 6, CAST(0x000089CD00000000 AS DateTime), CAST(0x000089E900000000 AS DateTime), CAST(0x000089D100000000 AS DateTime), 2, CAST(98.03000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10273, N'QUICK', 3, CAST(0x000089D000000000 AS DateTime), CAST(0x000089EC00000000 AS DateTime), CAST(0x000089D700000000 AS DateTime), 3, CAST(76.07000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10274, N'VINET', 6, CAST(0x000089D100000000 AS DateTime), CAST(0x000089ED00000000 AS DateTime), CAST(0x000089DB00000000 AS DateTime), 1, CAST(6.01000 AS Decimal(19, 5)), N'Vins et alcools Chevalier', N'59 rue de l''Abbaye', N'Reims', N'null', N'51100', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10275, N'MAGAA', 1, CAST(0x000089D200000000 AS DateTime), CAST(0x000089EE00000000 AS DateTime), CAST(0x000089D400000000 AS DateTime), 1, CAST(26.93000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10276, N'TORTU', 8, CAST(0x000089D300000000 AS DateTime), CAST(0x000089E100000000 AS DateTime), CAST(0x000089D900000000 AS DateTime), 3, CAST(13.84000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10277, N'MORGK', 2, CAST(0x000089D400000000 AS DateTime), CAST(0x000089F000000000 AS DateTime), CAST(0x000089D800000000 AS DateTime), 3, CAST(125.77000 AS Decimal(19, 5)), N'Morgenstern Gesundkost', N'Heerstr. 22', N'Leipzig', N'null', N'04179', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10278, N'BERGS', 8, CAST(0x000089D700000000 AS DateTime), CAST(0x000089F300000000 AS DateTime), CAST(0x000089DB00000000 AS DateTime), 2, CAST(92.69000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10279, N'LEHMS', 8, CAST(0x000089D800000000 AS DateTime), CAST(0x000089F400000000 AS DateTime), CAST(0x000089DB00000000 AS DateTime), 2, CAST(25.83000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10280, N'BERGS', 2, CAST(0x000089D900000000 AS DateTime), CAST(0x000089F500000000 AS DateTime), CAST(0x000089F600000000 AS DateTime), 1, CAST(8.98000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10281, N'ROMEY', 4, CAST(0x000089D900000000 AS DateTime), CAST(0x000089E700000000 AS DateTime), CAST(0x000089E000000000 AS DateTime), 1, CAST(2.94000 AS Decimal(19, 5)), N'Romero y tomillo', N'Gran Vía, 1', N'Madrid', N'null', N'28001', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10282, N'ROMEY', 4, CAST(0x000089DA00000000 AS DateTime), CAST(0x000089F600000000 AS DateTime), CAST(0x000089E000000000 AS DateTime), 1, CAST(12.69000 AS Decimal(19, 5)), N'Romero y tomillo', N'Gran Vía, 1', N'Madrid', N'null', N'28001', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10283, N'LILAS', 3, CAST(0x000089DB00000000 AS DateTime), CAST(0x000089F700000000 AS DateTime), CAST(0x000089E200000000 AS DateTime), 3, CAST(84.81000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10284, N'LEHMS', 4, CAST(0x000089DE00000000 AS DateTime), CAST(0x000089FA00000000 AS DateTime), CAST(0x000089E600000000 AS DateTime), 1, CAST(76.56000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10285, N'QUICK', 1, CAST(0x000089DF00000000 AS DateTime), CAST(0x000089FB00000000 AS DateTime), CAST(0x000089E500000000 AS DateTime), 2, CAST(76.83000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10286, N'QUICK', 8, CAST(0x000089E000000000 AS DateTime), CAST(0x000089FC00000000 AS DateTime), CAST(0x000089E900000000 AS DateTime), 3, CAST(229.24000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10287, N'RICAR', 8, CAST(0x000089E100000000 AS DateTime), CAST(0x000089FD00000000 AS DateTime), CAST(0x000089E700000000 AS DateTime), 3, CAST(12.76000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10288, N'REGGC', 4, CAST(0x000089E200000000 AS DateTime), CAST(0x000089FE00000000 AS DateTime), CAST(0x000089ED00000000 AS DateTime), 1, CAST(7.45000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10289, N'BSBEV', 7, CAST(0x000089E500000000 AS DateTime), CAST(0x00008A0100000000 AS DateTime), CAST(0x000089E700000000 AS DateTime), 3, CAST(22.77000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10290, N'COMMI', 8, CAST(0x000089E600000000 AS DateTime), CAST(0x00008A0200000000 AS DateTime), CAST(0x000089ED00000000 AS DateTime), 1, CAST(79.70000 AS Decimal(19, 5)), N'Comércio Mineiro', N'Av. dos Lusíadas, 23', N'Sao Paulo', N'SP', N'05432-043', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10291, N'QUEDE', 6, CAST(0x000089E600000000 AS DateTime), CAST(0x00008A0200000000 AS DateTime), CAST(0x000089EE00000000 AS DateTime), 2, CAST(6.40000 AS Decimal(19, 5)), N'Que Delícia', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10292, N'TRADH', 1, CAST(0x000089E700000000 AS DateTime), CAST(0x00008A0300000000 AS DateTime), CAST(0x000089EC00000000 AS DateTime), 2, CAST(1.35000 AS Decimal(19, 5)), N'Tradiçao Hipermercados', N'Av. Inês de Castro, 414', N'Sao Paulo', N'SP', N'05634-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10293, N'TORTU', 1, CAST(0x000089E800000000 AS DateTime), CAST(0x00008A0400000000 AS DateTime), CAST(0x000089F500000000 AS DateTime), 3, CAST(21.18000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10294, N'RATTC', 4, CAST(0x000089E900000000 AS DateTime), CAST(0x00008A0500000000 AS DateTime), CAST(0x000089EF00000000 AS DateTime), 2, CAST(147.26000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10295, N'VINET', 2, CAST(0x000089EC00000000 AS DateTime), CAST(0x00008A0800000000 AS DateTime), CAST(0x000089F400000000 AS DateTime), 2, CAST(1.15000 AS Decimal(19, 5)), N'Vins et alcools Chevalier', N'59 rue de l''Abbaye', N'Reims', N'null', N'51100', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10296, N'LILAS', 6, CAST(0x000089ED00000000 AS DateTime), CAST(0x00008A0900000000 AS DateTime), CAST(0x000089F500000000 AS DateTime), 1, CAST(0.12000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10297, N'BLONP', 5, CAST(0x000089EE00000000 AS DateTime), CAST(0x00008A1800000000 AS DateTime), CAST(0x000089F400000000 AS DateTime), 2, CAST(5.74000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10298, N'HUNGO', 6, CAST(0x000089EF00000000 AS DateTime), CAST(0x00008A0B00000000 AS DateTime), CAST(0x000089F500000000 AS DateTime), 2, CAST(168.22000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10299, N'RICAR', 4, CAST(0x000089F000000000 AS DateTime), CAST(0x00008A0C00000000 AS DateTime), CAST(0x000089F700000000 AS DateTime), 2, CAST(29.76000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10300, N'MAGAA', 2, CAST(0x000089F300000000 AS DateTime), CAST(0x00008A0F00000000 AS DateTime), CAST(0x000089FC00000000 AS DateTime), 2, CAST(17.68000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10301, N'WANDK', 8, CAST(0x000089F300000000 AS DateTime), CAST(0x00008A0F00000000 AS DateTime), CAST(0x000089FB00000000 AS DateTime), 2, CAST(45.08000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10302, N'SUPRD', 4, CAST(0x000089F400000000 AS DateTime), CAST(0x00008A1000000000 AS DateTime), CAST(0x00008A1100000000 AS DateTime), 2, CAST(6.27000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10303, N'GODOS', 7, CAST(0x000089F500000000 AS DateTime), CAST(0x00008A1100000000 AS DateTime), CAST(0x000089FC00000000 AS DateTime), 2, CAST(107.83000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10304, N'TORTU', 1, CAST(0x000089F600000000 AS DateTime), CAST(0x00008A1200000000 AS DateTime), CAST(0x000089FB00000000 AS DateTime), 2, CAST(63.79000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10305, N'OLDWO', 8, CAST(0x000089F700000000 AS DateTime), CAST(0x00008A1300000000 AS DateTime), CAST(0x00008A1100000000 AS DateTime), 3, CAST(257.62000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10306, N'ROMEY', 1, CAST(0x000089FA00000000 AS DateTime), CAST(0x00008A1600000000 AS DateTime), CAST(0x00008A0100000000 AS DateTime), 3, CAST(7.56000 AS Decimal(19, 5)), N'Romero y tomillo', N'Gran Vía, 1', N'Madrid', N'null', N'28001', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10307, N'LONEP', 2, CAST(0x000089FB00000000 AS DateTime), CAST(0x00008A1700000000 AS DateTime), CAST(0x00008A0300000000 AS DateTime), 2, CAST(0.56000 AS Decimal(19, 5)), N'Lonesome Pine Restaurant', N'89 Chiaroscuro Rd.', N'Portland', N'OR', N'97219', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10308, N'ANATR', 7, CAST(0x000089FC00000000 AS DateTime), CAST(0x00008A1800000000 AS DateTime), CAST(0x00008A0200000000 AS DateTime), 3, CAST(1.61000 AS Decimal(19, 5)), N'Ana Trujillo Emparedados y helados', N'Avda. de la Constitución 2222', N'México D.F.', N'null', N'05021', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10309, N'HUNGO', 3, CAST(0x000089FD00000000 AS DateTime), CAST(0x00008A1900000000 AS DateTime), CAST(0x00008A1F00000000 AS DateTime), 1, CAST(47.30000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10310, N'THEBI', 8, CAST(0x000089FE00000000 AS DateTime), CAST(0x00008A1A00000000 AS DateTime), CAST(0x00008A0500000000 AS DateTime), 2, CAST(17.52000 AS Decimal(19, 5)), N'The Big Cheese', N'89 Jefferson Way Suite 2', N'Portland', N'OR', N'97201', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10311, N'DUMON', 1, CAST(0x000089FE00000000 AS DateTime), CAST(0x00008A0C00000000 AS DateTime), CAST(0x00008A0400000000 AS DateTime), 3, CAST(24.69000 AS Decimal(19, 5)), N'Du monde entier', N'67, rue des Cinquante Otages', N'Nantes', N'null', N'44000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10312, N'WANDK', 2, CAST(0x00008A0100000000 AS DateTime), CAST(0x00008A1D00000000 AS DateTime), CAST(0x00008A0B00000000 AS DateTime), 2, CAST(40.26000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10313, N'QUICK', 2, CAST(0x00008A0200000000 AS DateTime), CAST(0x00008A1E00000000 AS DateTime), CAST(0x00008A0C00000000 AS DateTime), 2, CAST(1.96000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10314, N'RATTC', 1, CAST(0x00008A0300000000 AS DateTime), CAST(0x00008A1F00000000 AS DateTime), CAST(0x00008A0C00000000 AS DateTime), 2, CAST(74.16000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10315, N'ISLAT', 4, CAST(0x00008A0400000000 AS DateTime), CAST(0x00008A2000000000 AS DateTime), CAST(0x00008A0B00000000 AS DateTime), 2, CAST(41.76000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10316, N'RATTC', 1, CAST(0x00008A0500000000 AS DateTime), CAST(0x00008A2100000000 AS DateTime), CAST(0x00008A1000000000 AS DateTime), 3, CAST(150.15000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10317, N'LONEP', 6, CAST(0x00008A0800000000 AS DateTime), CAST(0x00008A2400000000 AS DateTime), CAST(0x00008A1200000000 AS DateTime), 1, CAST(12.69000 AS Decimal(19, 5)), N'Lonesome Pine Restaurant', N'89 Chiaroscuro Rd.', N'Portland', N'OR', N'97219', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10318, N'ISLAT', 8, CAST(0x00008A0900000000 AS DateTime), CAST(0x00008A2500000000 AS DateTime), CAST(0x00008A0C00000000 AS DateTime), 2, CAST(4.73000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10319, N'TORTU', 7, CAST(0x00008A0A00000000 AS DateTime), CAST(0x00008A2600000000 AS DateTime), CAST(0x00008A1300000000 AS DateTime), 3, CAST(64.50000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10320, N'WARTH', 5, CAST(0x00008A0B00000000 AS DateTime), CAST(0x00008A1900000000 AS DateTime), CAST(0x00008A1A00000000 AS DateTime), 3, CAST(34.57000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10321, N'ISLAT', 3, CAST(0x00008A0B00000000 AS DateTime), CAST(0x00008A2700000000 AS DateTime), CAST(0x00008A1300000000 AS DateTime), 2, CAST(3.43000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10322, N'PERIC', 7, CAST(0x00008A0C00000000 AS DateTime), CAST(0x00008A2800000000 AS DateTime), CAST(0x00008A1F00000000 AS DateTime), 3, CAST(0.40000 AS Decimal(19, 5)), N'Pericles Comidas clásicas', N'Calle Dr. Jorge Cash 321', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10323, N'KOENE', 4, CAST(0x00008A0F00000000 AS DateTime), CAST(0x00008A2B00000000 AS DateTime), CAST(0x00008A1600000000 AS DateTime), 1, CAST(4.88000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10324, N'SAVEA', 9, CAST(0x00008A1000000000 AS DateTime), CAST(0x00008A2C00000000 AS DateTime), CAST(0x00008A1200000000 AS DateTime), 1, CAST(214.27000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10325, N'KOENE', 1, CAST(0x00008A1100000000 AS DateTime), CAST(0x00008A1F00000000 AS DateTime), CAST(0x00008A1600000000 AS DateTime), 3, CAST(64.86000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10326, N'BOLID', 4, CAST(0x00008A1200000000 AS DateTime), CAST(0x00008A2E00000000 AS DateTime), CAST(0x00008A1600000000 AS DateTime), 2, CAST(77.92000 AS Decimal(19, 5)), N'Bólido Comidas preparadas', N'C/ Araquil, 67', N'Madrid', N'null', N'28023', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10327, N'FOLKO', 2, CAST(0x00008A1300000000 AS DateTime), CAST(0x00008A2F00000000 AS DateTime), CAST(0x00008A1600000000 AS DateTime), 1, CAST(63.36000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10328, N'FURIB', 4, CAST(0x00008A1600000000 AS DateTime), CAST(0x00008A3200000000 AS DateTime), CAST(0x00008A1900000000 AS DateTime), 3, CAST(87.03000 AS Decimal(19, 5)), N'Furia Bacalhau e Frutos do Mar', N'Jardim das rosas n. 32', N'Lisboa', N'null', N'1675', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10329, N'SPLIR', 4, CAST(0x00008A1700000000 AS DateTime), CAST(0x00008A4100000000 AS DateTime), CAST(0x00008A1F00000000 AS DateTime), 2, CAST(191.67000 AS Decimal(19, 5)), N'Split Rail Beer & Ale', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10330, N'LILAS', 3, CAST(0x00008A1800000000 AS DateTime), CAST(0x00008A3400000000 AS DateTime), CAST(0x00008A2400000000 AS DateTime), 1, CAST(12.75000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10331, N'BONAP', 9, CAST(0x00008A1800000000 AS DateTime), CAST(0x00008A4200000000 AS DateTime), CAST(0x00008A1D00000000 AS DateTime), 1, CAST(10.19000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10332, N'MEREP', 3, CAST(0x00008A1900000000 AS DateTime), CAST(0x00008A4300000000 AS DateTime), CAST(0x00008A1D00000000 AS DateTime), 2, CAST(52.84000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10333, N'WARTH', 5, CAST(0x00008A1A00000000 AS DateTime), CAST(0x00008A3600000000 AS DateTime), CAST(0x00008A2100000000 AS DateTime), 3, CAST(0.59000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10334, N'VICTE', 8, CAST(0x00008A1D00000000 AS DateTime), CAST(0x00008A3900000000 AS DateTime), CAST(0x00008A2400000000 AS DateTime), 2, CAST(8.56000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10335, N'HUNGO', 7, CAST(0x00008A1E00000000 AS DateTime), CAST(0x00008A3A00000000 AS DateTime), CAST(0x00008A2000000000 AS DateTime), 2, CAST(42.11000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10336, N'PRINI', 7, CAST(0x00008A1F00000000 AS DateTime), CAST(0x00008A3B00000000 AS DateTime), CAST(0x00008A2100000000 AS DateTime), 2, CAST(15.51000 AS Decimal(19, 5)), N'Princesa Isabel Vinhos', N'Estrada da saúde n. 58', N'Lisboa', N'null', N'1756', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10337, N'FRANK', 4, CAST(0x00008A2000000000 AS DateTime), CAST(0x00008A3C00000000 AS DateTime), CAST(0x00008A2500000000 AS DateTime), 3, CAST(108.26000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10338, N'OLDWO', 4, CAST(0x00008A2100000000 AS DateTime), CAST(0x00008A3D00000000 AS DateTime), CAST(0x00008A2500000000 AS DateTime), 3, CAST(84.21000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10339, N'MEREP', 2, CAST(0x00008A2400000000 AS DateTime), CAST(0x00008A4000000000 AS DateTime), CAST(0x00008A2B00000000 AS DateTime), 2, CAST(15.66000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10340, N'BONAP', 1, CAST(0x00008A2500000000 AS DateTime), CAST(0x00008A4100000000 AS DateTime), CAST(0x00008A2F00000000 AS DateTime), 3, CAST(166.31000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10341, N'SIMOB', 7, CAST(0x00008A2500000000 AS DateTime), CAST(0x00008A4100000000 AS DateTime), CAST(0x00008A2C00000000 AS DateTime), 3, CAST(26.78000 AS Decimal(19, 5)), N'Simons bistro', N'Vinbæltet 34', N'Kobenhavn', N'null', N'1734', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10342, N'FRANK', 4, CAST(0x00008A2600000000 AS DateTime), CAST(0x00008A3400000000 AS DateTime), CAST(0x00008A2B00000000 AS DateTime), 2, CAST(54.83000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10343, N'LEHMS', 4, CAST(0x00008A2700000000 AS DateTime), CAST(0x00008A4300000000 AS DateTime), CAST(0x00008A2D00000000 AS DateTime), 1, CAST(110.37000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10344, N'WHITC', 4, CAST(0x00008A2800000000 AS DateTime), CAST(0x00008A4400000000 AS DateTime), CAST(0x00008A2C00000000 AS DateTime), 2, CAST(23.29000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10345, N'QUICK', 2, CAST(0x00008A2B00000000 AS DateTime), CAST(0x00008A4700000000 AS DateTime), CAST(0x00008A3200000000 AS DateTime), 2, CAST(249.06000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10346, N'RATTC', 3, CAST(0x00008A2C00000000 AS DateTime), CAST(0x00008A5600000000 AS DateTime), CAST(0x00008A2F00000000 AS DateTime), 3, CAST(142.08000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10347, N'FAMIA', 4, CAST(0x00008A2D00000000 AS DateTime), CAST(0x00008A4900000000 AS DateTime), CAST(0x00008A2F00000000 AS DateTime), 3, CAST(3.10000 AS Decimal(19, 5)), N'Familia Arquibaldo', N'Rua Orós, 92', N'Sao Paulo', N'SP', N'05442-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10348, N'WANDK', 4, CAST(0x00008A2E00000000 AS DateTime), CAST(0x00008A4A00000000 AS DateTime), CAST(0x00008A3600000000 AS DateTime), 2, CAST(0.78000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
GO
print 'Processed 100 total records'
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10349, N'SPLIR', 7, CAST(0x00008A2F00000000 AS DateTime), CAST(0x00008A4B00000000 AS DateTime), CAST(0x00008A3600000000 AS DateTime), 1, CAST(8.63000 AS Decimal(19, 5)), N'Split Rail Beer & Ale', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10350, N'LAMAI', 6, CAST(0x00008A3200000000 AS DateTime), CAST(0x00008A4E00000000 AS DateTime), CAST(0x00008A4800000000 AS DateTime), 2, CAST(64.19000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10351, N'ERNSH', 1, CAST(0x00008A3200000000 AS DateTime), CAST(0x00008A4E00000000 AS DateTime), CAST(0x00008A3B00000000 AS DateTime), 1, CAST(162.33000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10352, N'FURIB', 3, CAST(0x00008A3300000000 AS DateTime), CAST(0x00008A4100000000 AS DateTime), CAST(0x00008A3900000000 AS DateTime), 3, CAST(1.30000 AS Decimal(19, 5)), N'Furia Bacalhau e Frutos do Mar', N'Jardim das rosas n. 32', N'Lisboa', N'null', N'1675', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10353, N'PICCO', 7, CAST(0x00008A3400000000 AS DateTime), CAST(0x00008A5000000000 AS DateTime), CAST(0x00008A4000000000 AS DateTime), 3, CAST(360.63000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10354, N'PERIC', 8, CAST(0x00008A3500000000 AS DateTime), CAST(0x00008A5100000000 AS DateTime), CAST(0x00008A3B00000000 AS DateTime), 3, CAST(53.80000 AS Decimal(19, 5)), N'Pericles Comidas clásicas', N'Calle Dr. Jorge Cash 321', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10355, N'AROUT', 6, CAST(0x00008A3600000000 AS DateTime), CAST(0x00008A5200000000 AS DateTime), CAST(0x00008A3B00000000 AS DateTime), 1, CAST(41.95000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10356, N'WANDK', 6, CAST(0x00008A3900000000 AS DateTime), CAST(0x00008A5500000000 AS DateTime), CAST(0x00008A4200000000 AS DateTime), 2, CAST(36.71000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10357, N'LILAS', 1, CAST(0x00008A3A00000000 AS DateTime), CAST(0x00008A5600000000 AS DateTime), CAST(0x00008A4700000000 AS DateTime), 3, CAST(34.88000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10358, N'LAMAI', 5, CAST(0x00008A3B00000000 AS DateTime), CAST(0x00008A5700000000 AS DateTime), CAST(0x00008A4200000000 AS DateTime), 1, CAST(19.64000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10359, N'SEVES', 5, CAST(0x00008A3C00000000 AS DateTime), CAST(0x00008A5800000000 AS DateTime), CAST(0x00008A4100000000 AS DateTime), 3, CAST(288.43000 AS Decimal(19, 5)), N'Seven Seas Imports', N'90 Wadhurst Rd.', N'London', N'null', N'OX15 4NB', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10360, N'BLONP', 4, CAST(0x00008A3D00000000 AS DateTime), CAST(0x00008A5900000000 AS DateTime), CAST(0x00008A4700000000 AS DateTime), 3, CAST(131.70000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10361, N'QUICK', 1, CAST(0x00008A3D00000000 AS DateTime), CAST(0x00008A5900000000 AS DateTime), CAST(0x00008A4800000000 AS DateTime), 2, CAST(183.17000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10362, N'BONAP', 3, CAST(0x00008A4000000000 AS DateTime), CAST(0x00008A5C00000000 AS DateTime), CAST(0x00008A4300000000 AS DateTime), 1, CAST(96.04000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10363, N'DRACD', 4, CAST(0x00008A4100000000 AS DateTime), CAST(0x00008A5D00000000 AS DateTime), CAST(0x00008A4900000000 AS DateTime), 3, CAST(30.54000 AS Decimal(19, 5)), N'Drachenblut Delikatessen', N'Walserweg 21', N'Aachen', N'null', N'52066', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10364, N'EASTC', 1, CAST(0x00008A4100000000 AS DateTime), CAST(0x00008A6B00000000 AS DateTime), CAST(0x00008A4900000000 AS DateTime), 1, CAST(71.97000 AS Decimal(19, 5)), N'Eastern Connection', N'35 King George', N'London', N'null', N'WX3 6FW', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10365, N'ANTON', 3, CAST(0x00008A4200000000 AS DateTime), CAST(0x00008A5E00000000 AS DateTime), CAST(0x00008A4700000000 AS DateTime), 2, CAST(22.00000 AS Decimal(19, 5)), N'Antonio Moreno Taquería', N'Mataderos  2312', N'México D.F.', N'null', N'05023', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10366, N'GALED', 8, CAST(0x00008A4300000000 AS DateTime), CAST(0x00008A6D00000000 AS DateTime), CAST(0x00008A6300000000 AS DateTime), 2, CAST(10.14000 AS Decimal(19, 5)), N'Galería del gastronómo', N'Rambla de Cataluña, 23', N'Barcelona', N'null', N'8022', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10367, N'VAFFE', 7, CAST(0x00008A4300000000 AS DateTime), CAST(0x00008A5F00000000 AS DateTime), CAST(0x00008A4700000000 AS DateTime), 3, CAST(13.55000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10368, N'ERNSH', 2, CAST(0x00008A4400000000 AS DateTime), CAST(0x00008A6000000000 AS DateTime), CAST(0x00008A4700000000 AS DateTime), 2, CAST(101.95000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10369, N'SPLIR', 8, CAST(0x00008A4700000000 AS DateTime), CAST(0x00008A6300000000 AS DateTime), CAST(0x00008A4E00000000 AS DateTime), 2, CAST(195.68000 AS Decimal(19, 5)), N'Split Rail Beer & Ale', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10370, N'CHOPS', 6, CAST(0x00008A4800000000 AS DateTime), CAST(0x00008A6400000000 AS DateTime), CAST(0x00008A6000000000 AS DateTime), 2, CAST(1.17000 AS Decimal(19, 5)), N'Chop-suey Chinese', N'Hauptstr. 31', N'Bern', N'null', N'3012', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10371, N'LAMAI', 1, CAST(0x00008A4800000000 AS DateTime), CAST(0x00008A6400000000 AS DateTime), CAST(0x00008A5D00000000 AS DateTime), 1, CAST(0.45000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10372, N'QUEEN', 5, CAST(0x00008A4900000000 AS DateTime), CAST(0x00008A6500000000 AS DateTime), CAST(0x00008A4E00000000 AS DateTime), 2, CAST(890.78000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10373, N'HUNGO', 4, CAST(0x00008A4A00000000 AS DateTime), CAST(0x00008A6600000000 AS DateTime), CAST(0x00008A5000000000 AS DateTime), 3, CAST(124.12000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10374, N'WOLZA', 1, CAST(0x00008A4A00000000 AS DateTime), CAST(0x00008A6600000000 AS DateTime), CAST(0x00008A4E00000000 AS DateTime), 3, CAST(3.94000 AS Decimal(19, 5)), N'Wolski Zajazd', N'ul. Filtrowa 68', N'Warszawa', N'null', N'01-012', N'Poland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10375, N'HUNGC', 3, CAST(0x00008A4B00000000 AS DateTime), CAST(0x00008A6700000000 AS DateTime), CAST(0x00008A4E00000000 AS DateTime), 2, CAST(20.12000 AS Decimal(19, 5)), N'Hungry Coyote Import Store', N'City Center Plaza 516 Main St.', N'Elgin', N'OR', N'97827', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10376, N'MEREP', 1, CAST(0x00008A4E00000000 AS DateTime), CAST(0x00008A6A00000000 AS DateTime), CAST(0x00008A5200000000 AS DateTime), 2, CAST(20.39000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10377, N'SEVES', 1, CAST(0x00008A4E00000000 AS DateTime), CAST(0x00008A6A00000000 AS DateTime), CAST(0x00008A5200000000 AS DateTime), 3, CAST(22.21000 AS Decimal(19, 5)), N'Seven Seas Imports', N'90 Wadhurst Rd.', N'London', N'null', N'OX15 4NB', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10378, N'FOLKO', 5, CAST(0x00008A4F00000000 AS DateTime), CAST(0x00008A6B00000000 AS DateTime), CAST(0x00008A5800000000 AS DateTime), 3, CAST(5.44000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10379, N'QUEDE', 2, CAST(0x00008A5000000000 AS DateTime), CAST(0x00008A6C00000000 AS DateTime), CAST(0x00008A5200000000 AS DateTime), 1, CAST(45.03000 AS Decimal(19, 5)), N'Que Delícia', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10380, N'HUNGO', 8, CAST(0x00008A5100000000 AS DateTime), CAST(0x00008A6D00000000 AS DateTime), CAST(0x00008A7400000000 AS DateTime), 3, CAST(35.03000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10381, N'LILAS', 3, CAST(0x00008A5100000000 AS DateTime), CAST(0x00008A6D00000000 AS DateTime), CAST(0x00008A5200000000 AS DateTime), 3, CAST(7.99000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10382, N'ERNSH', 4, CAST(0x00008A5200000000 AS DateTime), CAST(0x00008A6E00000000 AS DateTime), CAST(0x00008A5500000000 AS DateTime), 1, CAST(94.77000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10383, N'AROUT', 8, CAST(0x00008A5500000000 AS DateTime), CAST(0x00008A7100000000 AS DateTime), CAST(0x00008A5700000000 AS DateTime), 3, CAST(34.24000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10384, N'BERGS', 3, CAST(0x00008A5500000000 AS DateTime), CAST(0x00008A7100000000 AS DateTime), CAST(0x00008A5900000000 AS DateTime), 3, CAST(168.64000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10385, N'SPLIR', 1, CAST(0x00008A5600000000 AS DateTime), CAST(0x00008A7200000000 AS DateTime), CAST(0x00008A5C00000000 AS DateTime), 2, CAST(30.96000 AS Decimal(19, 5)), N'Split Rail Beer & Ale', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10386, N'FAMIA', 9, CAST(0x00008A5700000000 AS DateTime), CAST(0x00008A6500000000 AS DateTime), CAST(0x00008A5E00000000 AS DateTime), 3, CAST(13.99000 AS Decimal(19, 5)), N'Familia Arquibaldo', N'Rua Orós, 92', N'Sao Paulo', N'SP', N'05442-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10387, N'SANTG', 1, CAST(0x00008A5700000000 AS DateTime), CAST(0x00008A7300000000 AS DateTime), CAST(0x00008A5900000000 AS DateTime), 2, CAST(93.63000 AS Decimal(19, 5)), N'Santé Gourmet', N'Erling Skakkes gate 78', N'Stavern', N'null', N'4110', N'Norway')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10388, N'SEVES', 2, CAST(0x00008A5800000000 AS DateTime), CAST(0x00008A7400000000 AS DateTime), CAST(0x00008A5900000000 AS DateTime), 1, CAST(34.86000 AS Decimal(19, 5)), N'Seven Seas Imports', N'90 Wadhurst Rd.', N'London', N'null', N'OX15 4NB', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10389, N'BOTTM', 4, CAST(0x00008A5900000000 AS DateTime), CAST(0x00008A7500000000 AS DateTime), CAST(0x00008A5D00000000 AS DateTime), 2, CAST(47.42000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10390, N'ERNSH', 6, CAST(0x00008A5C00000000 AS DateTime), CAST(0x00008A7800000000 AS DateTime), CAST(0x00008A5F00000000 AS DateTime), 1, CAST(126.38000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10391, N'DRACD', 3, CAST(0x00008A5C00000000 AS DateTime), CAST(0x00008A7800000000 AS DateTime), CAST(0x00008A6400000000 AS DateTime), 3, CAST(5.45000 AS Decimal(19, 5)), N'Drachenblut Delikatessen', N'Walserweg 21', N'Aachen', N'null', N'52066', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10392, N'PICCO', 2, CAST(0x00008A5D00000000 AS DateTime), CAST(0x00008A7900000000 AS DateTime), CAST(0x00008A6500000000 AS DateTime), 3, CAST(122.46000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10393, N'SAVEA', 1, CAST(0x00008A5E00000000 AS DateTime), CAST(0x00008A7A00000000 AS DateTime), CAST(0x00008A6700000000 AS DateTime), 3, CAST(126.56000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10394, N'HUNGC', 1, CAST(0x00008A5E00000000 AS DateTime), CAST(0x00008A7A00000000 AS DateTime), CAST(0x00008A6700000000 AS DateTime), 3, CAST(30.34000 AS Decimal(19, 5)), N'Hungry Coyote Import Store', N'City Center Plaza 516 Main St.', N'Elgin', N'OR', N'97827', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10395, N'HILAA', 6, CAST(0x00008A5F00000000 AS DateTime), CAST(0x00008A7B00000000 AS DateTime), CAST(0x00008A6700000000 AS DateTime), 1, CAST(184.41000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10396, N'FRANK', 1, CAST(0x00008A6000000000 AS DateTime), CAST(0x00008A6E00000000 AS DateTime), CAST(0x00008A6A00000000 AS DateTime), 3, CAST(135.35000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10397, N'PRINI', 5, CAST(0x00008A6000000000 AS DateTime), CAST(0x00008A7C00000000 AS DateTime), CAST(0x00008A6600000000 AS DateTime), 1, CAST(60.26000 AS Decimal(19, 5)), N'Princesa Isabel Vinhos', N'Estrada da saúde n. 58', N'Lisboa', N'null', N'1756', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10398, N'SAVEA', 2, CAST(0x00008A6300000000 AS DateTime), CAST(0x00008A7F00000000 AS DateTime), CAST(0x00008A6D00000000 AS DateTime), 3, CAST(89.16000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10399, N'VAFFE', 8, CAST(0x00008A6400000000 AS DateTime), CAST(0x00008A7200000000 AS DateTime), CAST(0x00008A6C00000000 AS DateTime), 3, CAST(27.36000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10400, N'EASTC', 1, CAST(0x00008A6500000000 AS DateTime), CAST(0x00008A8100000000 AS DateTime), CAST(0x00008A7400000000 AS DateTime), 3, CAST(83.93000 AS Decimal(19, 5)), N'Eastern Connection', N'35 King George', N'London', N'null', N'WX3 6FW', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10401, N'RATTC', 1, CAST(0x00008A6500000000 AS DateTime), CAST(0x00008A8100000000 AS DateTime), CAST(0x00008A6E00000000 AS DateTime), 1, CAST(12.51000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10402, N'ERNSH', 8, CAST(0x00008A6600000000 AS DateTime), CAST(0x00008A9000000000 AS DateTime), CAST(0x00008A6E00000000 AS DateTime), 2, CAST(67.88000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10403, N'ERNSH', 4, CAST(0x00008A6700000000 AS DateTime), CAST(0x00008A8300000000 AS DateTime), CAST(0x00008A6D00000000 AS DateTime), 3, CAST(73.79000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10404, N'MAGAA', 2, CAST(0x00008A6700000000 AS DateTime), CAST(0x00008A8300000000 AS DateTime), CAST(0x00008A6C00000000 AS DateTime), 1, CAST(155.97000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10405, N'LINOD', 1, CAST(0x00008A6A00000000 AS DateTime), CAST(0x00008A8600000000 AS DateTime), CAST(0x00008A7A00000000 AS DateTime), 1, CAST(34.82000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10406, N'QUEEN', 7, CAST(0x00008A6B00000000 AS DateTime), CAST(0x00008A9500000000 AS DateTime), CAST(0x00008A7100000000 AS DateTime), 1, CAST(108.04000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10407, N'OTTIK', 2, CAST(0x00008A6B00000000 AS DateTime), CAST(0x00008A8700000000 AS DateTime), CAST(0x00008A8200000000 AS DateTime), 2, CAST(91.48000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10408, N'FOLIG', 8, CAST(0x00008A6C00000000 AS DateTime), CAST(0x00008A8800000000 AS DateTime), CAST(0x00008A7200000000 AS DateTime), 1, CAST(11.26000 AS Decimal(19, 5)), N'Folies gourmandes', N'184, chaussée de Tournai', N'Lille', N'null', N'59000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10409, N'OCEAN', 3, CAST(0x00008A6D00000000 AS DateTime), CAST(0x00008A8900000000 AS DateTime), CAST(0x00008A7200000000 AS DateTime), 1, CAST(29.83000 AS Decimal(19, 5)), N'Océano Atlántico Ltda.', N'Ing. Gustavo Moncada 8585 Piso 20-A', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10410, N'BOTTM', 3, CAST(0x00008A6E00000000 AS DateTime), CAST(0x00008A8A00000000 AS DateTime), CAST(0x00008A7300000000 AS DateTime), 3, CAST(2.40000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10411, N'BOTTM', 9, CAST(0x00008A6E00000000 AS DateTime), CAST(0x00008A8A00000000 AS DateTime), CAST(0x00008A7900000000 AS DateTime), 3, CAST(23.65000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10412, N'WARTH', 8, CAST(0x00008A7100000000 AS DateTime), CAST(0x00008A8D00000000 AS DateTime), CAST(0x00008A7300000000 AS DateTime), 2, CAST(3.77000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10413, N'LAMAI', 3, CAST(0x00008A7200000000 AS DateTime), CAST(0x00008A8E00000000 AS DateTime), CAST(0x00008A7400000000 AS DateTime), 2, CAST(95.66000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10414, N'FAMIA', 2, CAST(0x00008A7200000000 AS DateTime), CAST(0x00008A8E00000000 AS DateTime), CAST(0x00008A7500000000 AS DateTime), 3, CAST(21.48000 AS Decimal(19, 5)), N'Familia Arquibaldo', N'Rua Orós, 92', N'Sao Paulo', N'SP', N'05442-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10415, N'HUNGC', 3, CAST(0x00008A7300000000 AS DateTime), CAST(0x00008A8F00000000 AS DateTime), CAST(0x00008A7C00000000 AS DateTime), 1, CAST(0.20000 AS Decimal(19, 5)), N'Hungry Coyote Import Store', N'City Center Plaza 516 Main St.', N'Elgin', N'OR', N'97827', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10416, N'WARTH', 8, CAST(0x00008A7400000000 AS DateTime), CAST(0x00008A9000000000 AS DateTime), CAST(0x00008A7F00000000 AS DateTime), 3, CAST(22.72000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10417, N'SIMOB', 4, CAST(0x00008A7400000000 AS DateTime), CAST(0x00008A9000000000 AS DateTime), CAST(0x00008A8000000000 AS DateTime), 3, CAST(70.29000 AS Decimal(19, 5)), N'Simons bistro', N'Vinbæltet 34', N'Kobenhavn', N'null', N'1734', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10418, N'QUICK', 4, CAST(0x00008A7500000000 AS DateTime), CAST(0x00008A9100000000 AS DateTime), CAST(0x00008A7C00000000 AS DateTime), 1, CAST(17.55000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10419, N'RICSU', 4, CAST(0x00008A7800000000 AS DateTime), CAST(0x00008A9400000000 AS DateTime), CAST(0x00008A8200000000 AS DateTime), 2, CAST(137.35000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10420, N'WELLI', 3, CAST(0x00008A7900000000 AS DateTime), CAST(0x00008A9500000000 AS DateTime), CAST(0x00008A7F00000000 AS DateTime), 1, CAST(44.12000 AS Decimal(19, 5)), N'Wellington Importadora', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10421, N'QUEDE', 8, CAST(0x00008A7900000000 AS DateTime), CAST(0x00008AA300000000 AS DateTime), CAST(0x00008A7F00000000 AS DateTime), 1, CAST(99.23000 AS Decimal(19, 5)), N'Que Delícia', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10422, N'FRANS', 2, CAST(0x00008A7A00000000 AS DateTime), CAST(0x00008A9600000000 AS DateTime), CAST(0x00008A8300000000 AS DateTime), 1, CAST(3.02000 AS Decimal(19, 5)), N'Franchi S.p.A.', N'Via Monte Bianco 34', N'Torino', N'null', N'10100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10423, N'GOURL', 6, CAST(0x00008A7B00000000 AS DateTime), CAST(0x00008A8900000000 AS DateTime), CAST(0x00008A9B00000000 AS DateTime), 3, CAST(24.50000 AS Decimal(19, 5)), N'Gourmet Lanchonetes', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10424, N'MEREP', 7, CAST(0x00008A7B00000000 AS DateTime), CAST(0x00008A9700000000 AS DateTime), CAST(0x00008A7F00000000 AS DateTime), 2, CAST(370.61000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10425, N'LAMAI', 6, CAST(0x00008A7C00000000 AS DateTime), CAST(0x00008A9800000000 AS DateTime), CAST(0x00008A9100000000 AS DateTime), 2, CAST(7.93000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10426, N'GALED', 4, CAST(0x00008A7F00000000 AS DateTime), CAST(0x00008A9B00000000 AS DateTime), CAST(0x00008A8900000000 AS DateTime), 1, CAST(18.69000 AS Decimal(19, 5)), N'Galería del gastronómo', N'Rambla de Cataluña, 23', N'Barcelona', N'null', N'8022', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10427, N'PICCO', 4, CAST(0x00008A7F00000000 AS DateTime), CAST(0x00008A9B00000000 AS DateTime), CAST(0x00008AA200000000 AS DateTime), 2, CAST(31.29000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10428, N'REGGC', 7, CAST(0x00008A8000000000 AS DateTime), CAST(0x00008A9C00000000 AS DateTime), CAST(0x00008A8700000000 AS DateTime), 1, CAST(11.09000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10429, N'HUNGO', 3, CAST(0x00008A8100000000 AS DateTime), CAST(0x00008AAB00000000 AS DateTime), CAST(0x00008A8A00000000 AS DateTime), 2, CAST(56.63000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10430, N'ERNSH', 4, CAST(0x00008A8200000000 AS DateTime), CAST(0x00008A9000000000 AS DateTime), CAST(0x00008A8600000000 AS DateTime), 1, CAST(458.78000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10431, N'BOTTM', 4, CAST(0x00008A8200000000 AS DateTime), CAST(0x00008A9000000000 AS DateTime), CAST(0x00008A8A00000000 AS DateTime), 2, CAST(44.17000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10432, N'SPLIR', 3, CAST(0x00008A8300000000 AS DateTime), CAST(0x00008A9100000000 AS DateTime), CAST(0x00008A8A00000000 AS DateTime), 2, CAST(4.34000 AS Decimal(19, 5)), N'Split Rail Beer & Ale', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10433, N'PRINI', 3, CAST(0x00008A8600000000 AS DateTime), CAST(0x00008AA200000000 AS DateTime), CAST(0x00008AA300000000 AS DateTime), 3, CAST(73.83000 AS Decimal(19, 5)), N'Princesa Isabel Vinhos', N'Estrada da saúde n. 58', N'Lisboa', N'null', N'1756', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10434, N'FOLKO', 3, CAST(0x00008A8600000000 AS DateTime), CAST(0x00008AA200000000 AS DateTime), CAST(0x00008A9000000000 AS DateTime), 2, CAST(17.92000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10435, N'CONSH', 8, CAST(0x00008A8700000000 AS DateTime), CAST(0x00008AB100000000 AS DateTime), CAST(0x00008A8A00000000 AS DateTime), 2, CAST(9.21000 AS Decimal(19, 5)), N'Consolidated Holdings', N'Berkeley Gardens 12  Brewery', N'London', N'null', N'WX1 6LT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10436, N'BLONP', 3, CAST(0x00008A8800000000 AS DateTime), CAST(0x00008AA400000000 AS DateTime), CAST(0x00008A8E00000000 AS DateTime), 2, CAST(156.66000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10437, N'WARTH', 8, CAST(0x00008A8800000000 AS DateTime), CAST(0x00008AA400000000 AS DateTime), CAST(0x00008A8F00000000 AS DateTime), 1, CAST(19.97000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10438, N'TOMSP', 3, CAST(0x00008A8900000000 AS DateTime), CAST(0x00008AA500000000 AS DateTime), CAST(0x00008A9100000000 AS DateTime), 2, CAST(8.24000 AS Decimal(19, 5)), N'Toms Spezialitäten', N'Luisenstr. 48', N'Münster', N'null', N'44087', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10439, N'MEREP', 6, CAST(0x00008A8A00000000 AS DateTime), CAST(0x00008AA600000000 AS DateTime), CAST(0x00008A8D00000000 AS DateTime), 3, CAST(4.07000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10440, N'SAVEA', 4, CAST(0x00008A8D00000000 AS DateTime), CAST(0x00008AA900000000 AS DateTime), CAST(0x00008A9F00000000 AS DateTime), 2, CAST(86.53000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10441, N'OLDWO', 3, CAST(0x00008A8D00000000 AS DateTime), CAST(0x00008AB700000000 AS DateTime), CAST(0x00008AAD00000000 AS DateTime), 2, CAST(73.02000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10442, N'ERNSH', 3, CAST(0x00008A8E00000000 AS DateTime), CAST(0x00008AAA00000000 AS DateTime), CAST(0x00008A9500000000 AS DateTime), 2, CAST(47.94000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10443, N'REGGC', 8, CAST(0x00008A8F00000000 AS DateTime), CAST(0x00008AAB00000000 AS DateTime), CAST(0x00008A9100000000 AS DateTime), 1, CAST(13.95000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10444, N'BERGS', 3, CAST(0x00008A8F00000000 AS DateTime), CAST(0x00008AAB00000000 AS DateTime), CAST(0x00008A9800000000 AS DateTime), 3, CAST(3.50000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10445, N'BERGS', 3, CAST(0x00008A9000000000 AS DateTime), CAST(0x00008AAC00000000 AS DateTime), CAST(0x00008A9700000000 AS DateTime), 1, CAST(9.30000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10446, N'TOMSP', 6, CAST(0x00008A9100000000 AS DateTime), CAST(0x00008AAD00000000 AS DateTime), CAST(0x00008A9600000000 AS DateTime), 1, CAST(14.68000 AS Decimal(19, 5)), N'Toms Spezialitäten', N'Luisenstr. 48', N'Münster', N'null', N'44087', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10447, N'RICAR', 4, CAST(0x00008A9100000000 AS DateTime), CAST(0x00008AAD00000000 AS DateTime), CAST(0x00008AA600000000 AS DateTime), 2, CAST(68.66000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10448, N'RANCH', 4, CAST(0x00008A9400000000 AS DateTime), CAST(0x00008AB000000000 AS DateTime), CAST(0x00008A9B00000000 AS DateTime), 2, CAST(38.82000 AS Decimal(19, 5)), N'Rancho grande', N'Av. del Libertador 900', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10449, N'BLONP', 3, CAST(0x00008A9500000000 AS DateTime), CAST(0x00008AB100000000 AS DateTime), CAST(0x00008A9E00000000 AS DateTime), 2, CAST(53.30000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
GO
print 'Processed 200 total records'
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10450, N'VICTE', 8, CAST(0x00008A9600000000 AS DateTime), CAST(0x00008AB200000000 AS DateTime), CAST(0x00008AAA00000000 AS DateTime), 2, CAST(7.23000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10451, N'QUICK', 4, CAST(0x00008A9600000000 AS DateTime), CAST(0x00008AA400000000 AS DateTime), CAST(0x00008AAB00000000 AS DateTime), 3, CAST(189.09000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10452, N'SAVEA', 8, CAST(0x00008A9700000000 AS DateTime), CAST(0x00008AB300000000 AS DateTime), CAST(0x00008A9D00000000 AS DateTime), 1, CAST(140.26000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10453, N'AROUT', 1, CAST(0x00008A9800000000 AS DateTime), CAST(0x00008AB400000000 AS DateTime), CAST(0x00008A9D00000000 AS DateTime), 2, CAST(25.36000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10454, N'LAMAI', 4, CAST(0x00008A9800000000 AS DateTime), CAST(0x00008AB400000000 AS DateTime), CAST(0x00008A9C00000000 AS DateTime), 3, CAST(2.74000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10455, N'WARTH', 8, CAST(0x00008A9B00000000 AS DateTime), CAST(0x00008AC500000000 AS DateTime), CAST(0x00008AA200000000 AS DateTime), 2, CAST(180.45000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10456, N'KOENE', 8, CAST(0x00008A9C00000000 AS DateTime), CAST(0x00008AC600000000 AS DateTime), CAST(0x00008A9F00000000 AS DateTime), 2, CAST(8.12000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10457, N'KOENE', 2, CAST(0x00008A9C00000000 AS DateTime), CAST(0x00008AB800000000 AS DateTime), CAST(0x00008AA200000000 AS DateTime), 1, CAST(11.57000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10458, N'SUPRD', 7, CAST(0x00008A9D00000000 AS DateTime), CAST(0x00008AB900000000 AS DateTime), CAST(0x00008AA300000000 AS DateTime), 3, CAST(147.06000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10459, N'VICTE', 4, CAST(0x00008A9E00000000 AS DateTime), CAST(0x00008ABA00000000 AS DateTime), CAST(0x00008A9F00000000 AS DateTime), 2, CAST(25.09000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10460, N'FOLKO', 8, CAST(0x00008A9F00000000 AS DateTime), CAST(0x00008ABB00000000 AS DateTime), CAST(0x00008AA200000000 AS DateTime), 1, CAST(16.27000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10461, N'LILAS', 1, CAST(0x00008A9F00000000 AS DateTime), CAST(0x00008ABB00000000 AS DateTime), CAST(0x00008AA400000000 AS DateTime), 3, CAST(148.61000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10462, N'CONSH', 2, CAST(0x00008AA200000000 AS DateTime), CAST(0x00008ABE00000000 AS DateTime), CAST(0x00008AB100000000 AS DateTime), 1, CAST(6.17000 AS Decimal(19, 5)), N'Consolidated Holdings', N'Berkeley Gardens 12  Brewery', N'London', N'null', N'WX1 6LT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10463, N'SUPRD', 5, CAST(0x00008AA300000000 AS DateTime), CAST(0x00008ABF00000000 AS DateTime), CAST(0x00008AA500000000 AS DateTime), 3, CAST(14.78000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10464, N'FURIB', 4, CAST(0x00008AA300000000 AS DateTime), CAST(0x00008ABF00000000 AS DateTime), CAST(0x00008AAD00000000 AS DateTime), 2, CAST(89.00000 AS Decimal(19, 5)), N'Furia Bacalhau e Frutos do Mar', N'Jardim das rosas n. 32', N'Lisboa', N'null', N'1675', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10465, N'VAFFE', 1, CAST(0x00008AA400000000 AS DateTime), CAST(0x00008AC000000000 AS DateTime), CAST(0x00008AAD00000000 AS DateTime), 3, CAST(145.04000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10466, N'COMMI', 4, CAST(0x00008AA500000000 AS DateTime), CAST(0x00008AC100000000 AS DateTime), CAST(0x00008AAC00000000 AS DateTime), 1, CAST(11.93000 AS Decimal(19, 5)), N'Comércio Mineiro', N'Av. dos Lusíadas, 23', N'Sao Paulo', N'SP', N'05432-043', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10467, N'MAGAA', 8, CAST(0x00008AA500000000 AS DateTime), CAST(0x00008AC100000000 AS DateTime), CAST(0x00008AAA00000000 AS DateTime), 2, CAST(4.93000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10468, N'KOENE', 3, CAST(0x00008AA600000000 AS DateTime), CAST(0x00008AC200000000 AS DateTime), CAST(0x00008AAB00000000 AS DateTime), 3, CAST(44.12000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10469, N'WHITC', 1, CAST(0x00008AA900000000 AS DateTime), CAST(0x00008AC500000000 AS DateTime), CAST(0x00008AAD00000000 AS DateTime), 1, CAST(60.18000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10470, N'BONAP', 4, CAST(0x00008AAA00000000 AS DateTime), CAST(0x00008AC600000000 AS DateTime), CAST(0x00008AAD00000000 AS DateTime), 2, CAST(64.56000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10471, N'BSBEV', 2, CAST(0x00008AAA00000000 AS DateTime), CAST(0x00008AC600000000 AS DateTime), CAST(0x00008AB100000000 AS DateTime), 3, CAST(45.59000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10472, N'SEVES', 8, CAST(0x00008AAB00000000 AS DateTime), CAST(0x00008AC700000000 AS DateTime), CAST(0x00008AB200000000 AS DateTime), 1, CAST(4.20000 AS Decimal(19, 5)), N'Seven Seas Imports', N'90 Wadhurst Rd.', N'London', N'null', N'OX15 4NB', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10473, N'ISLAT', 1, CAST(0x00008AAC00000000 AS DateTime), CAST(0x00008ABA00000000 AS DateTime), CAST(0x00008AB400000000 AS DateTime), 3, CAST(16.37000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10474, N'PERIC', 5, CAST(0x00008AAC00000000 AS DateTime), CAST(0x00008AC800000000 AS DateTime), CAST(0x00008AB400000000 AS DateTime), 2, CAST(83.49000 AS Decimal(19, 5)), N'Pericles Comidas clásicas', N'Calle Dr. Jorge Cash 321', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10475, N'SUPRD', 9, CAST(0x00008AAD00000000 AS DateTime), CAST(0x00008AC900000000 AS DateTime), CAST(0x00008AC200000000 AS DateTime), 1, CAST(68.52000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10476, N'HILAA', 8, CAST(0x00008AB000000000 AS DateTime), CAST(0x00008ACC00000000 AS DateTime), CAST(0x00008AB700000000 AS DateTime), 3, CAST(4.41000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10477, N'PRINI', 5, CAST(0x00008AB000000000 AS DateTime), CAST(0x00008ACC00000000 AS DateTime), CAST(0x00008AB800000000 AS DateTime), 2, CAST(13.02000 AS Decimal(19, 5)), N'Princesa Isabel Vinhos', N'Estrada da saúde n. 58', N'Lisboa', N'null', N'1756', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10478, N'VICTE', 2, CAST(0x00008AB100000000 AS DateTime), CAST(0x00008ABF00000000 AS DateTime), CAST(0x00008AB900000000 AS DateTime), 3, CAST(4.81000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10479, N'RATTC', 3, CAST(0x00008AB200000000 AS DateTime), CAST(0x00008ACE00000000 AS DateTime), CAST(0x00008AB400000000 AS DateTime), 3, CAST(708.95000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10480, N'FOLIG', 6, CAST(0x00008AB300000000 AS DateTime), CAST(0x00008ACF00000000 AS DateTime), CAST(0x00008AB700000000 AS DateTime), 2, CAST(1.35000 AS Decimal(19, 5)), N'Folies gourmandes', N'184, chaussée de Tournai', N'Lille', N'null', N'59000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10481, N'RICAR', 8, CAST(0x00008AB300000000 AS DateTime), CAST(0x00008ACF00000000 AS DateTime), CAST(0x00008AB800000000 AS DateTime), 2, CAST(64.33000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10482, N'LAZYK', 1, CAST(0x00008AB400000000 AS DateTime), CAST(0x00008AD000000000 AS DateTime), CAST(0x00008AC800000000 AS DateTime), 3, CAST(7.48000 AS Decimal(19, 5)), N'Lazy K Kountry Store', N'12 Orchestra Terrace', N'Walla Walla', N'WA', N'99362', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10483, N'WHITC', 7, CAST(0x00008AB700000000 AS DateTime), CAST(0x00008AD300000000 AS DateTime), CAST(0x00008AD700000000 AS DateTime), 2, CAST(15.28000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10484, N'BSBEV', 3, CAST(0x00008AB700000000 AS DateTime), CAST(0x00008AD300000000 AS DateTime), CAST(0x00008ABF00000000 AS DateTime), 3, CAST(6.88000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10485, N'LINOD', 4, CAST(0x00008AB800000000 AS DateTime), CAST(0x00008AC600000000 AS DateTime), CAST(0x00008ABE00000000 AS DateTime), 2, CAST(64.45000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10486, N'HILAA', 1, CAST(0x00008AB900000000 AS DateTime), CAST(0x00008AD500000000 AS DateTime), CAST(0x00008AC000000000 AS DateTime), 2, CAST(30.53000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10487, N'QUEEN', 2, CAST(0x00008AB900000000 AS DateTime), CAST(0x00008AD500000000 AS DateTime), CAST(0x00008ABB00000000 AS DateTime), 2, CAST(71.07000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10488, N'FRANK', 8, CAST(0x00008ABA00000000 AS DateTime), CAST(0x00008AD600000000 AS DateTime), CAST(0x00008AC000000000 AS DateTime), 2, CAST(4.93000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10489, N'PICCO', 6, CAST(0x00008ABB00000000 AS DateTime), CAST(0x00008AD700000000 AS DateTime), CAST(0x00008AC700000000 AS DateTime), 2, CAST(5.29000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10490, N'HILAA', 7, CAST(0x00008ABE00000000 AS DateTime), CAST(0x00008ADA00000000 AS DateTime), CAST(0x00008AC100000000 AS DateTime), 2, CAST(210.19000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10491, N'FURIB', 8, CAST(0x00008ABE00000000 AS DateTime), CAST(0x00008ADA00000000 AS DateTime), CAST(0x00008AC600000000 AS DateTime), 3, CAST(16.96000 AS Decimal(19, 5)), N'Furia Bacalhau e Frutos do Mar', N'Jardim das rosas n. 32', N'Lisboa', N'null', N'1675', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10492, N'BOTTM', 3, CAST(0x00008ABF00000000 AS DateTime), CAST(0x00008ADB00000000 AS DateTime), CAST(0x00008AC900000000 AS DateTime), 1, CAST(62.89000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10493, N'LAMAI', 4, CAST(0x00008AC000000000 AS DateTime), CAST(0x00008ADC00000000 AS DateTime), CAST(0x00008AC800000000 AS DateTime), 3, CAST(10.64000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10494, N'COMMI', 4, CAST(0x00008AC000000000 AS DateTime), CAST(0x00008ADC00000000 AS DateTime), CAST(0x00008AC700000000 AS DateTime), 2, CAST(65.99000 AS Decimal(19, 5)), N'Comércio Mineiro', N'Av. dos Lusíadas, 23', N'Sao Paulo', N'SP', N'05432-043', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10495, N'LAUGB', 3, CAST(0x00008AC100000000 AS DateTime), CAST(0x00008ADD00000000 AS DateTime), CAST(0x00008AC900000000 AS DateTime), 3, CAST(4.65000 AS Decimal(19, 5)), N'Laughing Bacchus Wine Cellars', N'2319 Elm St.', N'Vancouver', N'BC', N'V3F 2K1', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10496, N'TRADH', 7, CAST(0x00008AC200000000 AS DateTime), CAST(0x00008ADE00000000 AS DateTime), CAST(0x00008AC500000000 AS DateTime), 2, CAST(46.77000 AS Decimal(19, 5)), N'Tradiçao Hipermercados', N'Av. Inês de Castro, 414', N'Sao Paulo', N'SP', N'05634-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10497, N'LEHMS', 7, CAST(0x00008AC200000000 AS DateTime), CAST(0x00008ADE00000000 AS DateTime), CAST(0x00008AC500000000 AS DateTime), 1, CAST(36.21000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10498, N'HILAA', 8, CAST(0x00008AC500000000 AS DateTime), CAST(0x00008AE100000000 AS DateTime), CAST(0x00008AC900000000 AS DateTime), 2, CAST(29.75000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10499, N'LILAS', 4, CAST(0x00008AC600000000 AS DateTime), CAST(0x00008AE200000000 AS DateTime), CAST(0x00008ACE00000000 AS DateTime), 2, CAST(102.02000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10500, N'LAMAI', 6, CAST(0x00008AC700000000 AS DateTime), CAST(0x00008AE300000000 AS DateTime), CAST(0x00008ACF00000000 AS DateTime), 1, CAST(42.68000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10501, N'BLAUS', 9, CAST(0x00008AC700000000 AS DateTime), CAST(0x00008AE300000000 AS DateTime), CAST(0x00008ACE00000000 AS DateTime), 3, CAST(8.85000 AS Decimal(19, 5)), N'Blauer See Delikatessen', N'Forsterstr. 57', N'Mannheim', N'null', N'68306', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10502, N'PERIC', 2, CAST(0x00008AC800000000 AS DateTime), CAST(0x00008AE400000000 AS DateTime), CAST(0x00008ADB00000000 AS DateTime), 1, CAST(69.32000 AS Decimal(19, 5)), N'Pericles Comidas clásicas', N'Calle Dr. Jorge Cash 321', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10503, N'HUNGO', 6, CAST(0x00008AC900000000 AS DateTime), CAST(0x00008AE500000000 AS DateTime), CAST(0x00008ACE00000000 AS DateTime), 2, CAST(16.74000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10504, N'WHITC', 4, CAST(0x00008AC900000000 AS DateTime), CAST(0x00008AE500000000 AS DateTime), CAST(0x00008AD000000000 AS DateTime), 3, CAST(59.13000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10505, N'MEREP', 3, CAST(0x00008ACC00000000 AS DateTime), CAST(0x00008AE800000000 AS DateTime), CAST(0x00008AD300000000 AS DateTime), 3, CAST(7.13000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10506, N'KOENE', 9, CAST(0x00008ACD00000000 AS DateTime), CAST(0x00008AE900000000 AS DateTime), CAST(0x00008ADE00000000 AS DateTime), 2, CAST(21.19000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10507, N'ANTON', 7, CAST(0x00008ACD00000000 AS DateTime), CAST(0x00008AE900000000 AS DateTime), CAST(0x00008AD400000000 AS DateTime), 1, CAST(47.45000 AS Decimal(19, 5)), N'Antonio Moreno Taquería', N'Mataderos  2312', N'México D.F.', N'null', N'05023', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10508, N'OTTIK', 1, CAST(0x00008ACE00000000 AS DateTime), CAST(0x00008AEA00000000 AS DateTime), CAST(0x00008AE900000000 AS DateTime), 2, CAST(4.99000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10509, N'BLAUS', 4, CAST(0x00008ACF00000000 AS DateTime), CAST(0x00008AEB00000000 AS DateTime), CAST(0x00008ADB00000000 AS DateTime), 1, CAST(0.15000 AS Decimal(19, 5)), N'Blauer See Delikatessen', N'Forsterstr. 57', N'Mannheim', N'null', N'68306', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10510, N'SAVEA', 6, CAST(0x00008AD000000000 AS DateTime), CAST(0x00008AEC00000000 AS DateTime), CAST(0x00008ADA00000000 AS DateTime), 3, CAST(367.63000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10511, N'BONAP', 4, CAST(0x00008AD000000000 AS DateTime), CAST(0x00008AEC00000000 AS DateTime), CAST(0x00008AD300000000 AS DateTime), 3, CAST(350.64000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10512, N'FAMIA', 7, CAST(0x00008AD300000000 AS DateTime), CAST(0x00008AEF00000000 AS DateTime), CAST(0x00008AD600000000 AS DateTime), 2, CAST(3.53000 AS Decimal(19, 5)), N'Familia Arquibaldo', N'Rua Orós, 92', N'Sao Paulo', N'SP', N'05442-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10513, N'WANDK', 7, CAST(0x00008AD400000000 AS DateTime), CAST(0x00008AFE00000000 AS DateTime), CAST(0x00008ADA00000000 AS DateTime), 1, CAST(105.65000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10514, N'ERNSH', 3, CAST(0x00008AD400000000 AS DateTime), CAST(0x00008AF000000000 AS DateTime), CAST(0x00008AEC00000000 AS DateTime), 2, CAST(789.95000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10515, N'QUICK', 2, CAST(0x00008AD500000000 AS DateTime), CAST(0x00008AE300000000 AS DateTime), CAST(0x00008AF300000000 AS DateTime), 1, CAST(204.47000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10516, N'HUNGO', 2, CAST(0x00008AD600000000 AS DateTime), CAST(0x00008AF200000000 AS DateTime), CAST(0x00008ADD00000000 AS DateTime), 3, CAST(62.78000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10517, N'NORTS', 3, CAST(0x00008AD600000000 AS DateTime), CAST(0x00008AF200000000 AS DateTime), CAST(0x00008ADB00000000 AS DateTime), 3, CAST(32.07000 AS Decimal(19, 5)), N'North/South', N'South House 300 Queensbridge', N'London', N'null', N'SW7 1RZ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10518, N'TORTU', 4, CAST(0x00008AD700000000 AS DateTime), CAST(0x00008AE500000000 AS DateTime), CAST(0x00008AE100000000 AS DateTime), 2, CAST(218.15000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10519, N'CHOPS', 6, CAST(0x00008ADA00000000 AS DateTime), CAST(0x00008AF600000000 AS DateTime), CAST(0x00008ADD00000000 AS DateTime), 3, CAST(91.76000 AS Decimal(19, 5)), N'Chop-suey Chinese', N'Hauptstr. 31', N'Bern', N'null', N'3012', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10520, N'SANTG', 7, CAST(0x00008ADB00000000 AS DateTime), CAST(0x00008AF700000000 AS DateTime), CAST(0x00008ADD00000000 AS DateTime), 1, CAST(13.37000 AS Decimal(19, 5)), N'Santé Gourmet', N'Erling Skakkes gate 78', N'Stavern', N'null', N'4110', N'Norway')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10521, N'CACTU', 8, CAST(0x00008ADB00000000 AS DateTime), CAST(0x00008AF700000000 AS DateTime), CAST(0x00008ADE00000000 AS DateTime), 2, CAST(17.22000 AS Decimal(19, 5)), N'Cactus Comidas para llevar', N'Cerrito 333', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10522, N'LEHMS', 4, CAST(0x00008ADC00000000 AS DateTime), CAST(0x00008AF800000000 AS DateTime), CAST(0x00008AE200000000 AS DateTime), 1, CAST(45.33000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10523, N'SEVES', 7, CAST(0x00008ADD00000000 AS DateTime), CAST(0x00008AF900000000 AS DateTime), CAST(0x00008AFA00000000 AS DateTime), 2, CAST(77.63000 AS Decimal(19, 5)), N'Seven Seas Imports', N'90 Wadhurst Rd.', N'London', N'null', N'OX15 4NB', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10524, N'BERGS', 1, CAST(0x00008ADD00000000 AS DateTime), CAST(0x00008AF900000000 AS DateTime), CAST(0x00008AE300000000 AS DateTime), 2, CAST(244.79000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10525, N'BONAP', 1, CAST(0x00008ADE00000000 AS DateTime), CAST(0x00008AFA00000000 AS DateTime), CAST(0x00008AF300000000 AS DateTime), 2, CAST(11.06000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10526, N'WARTH', 4, CAST(0x00008AE100000000 AS DateTime), CAST(0x00008AFD00000000 AS DateTime), CAST(0x00008AEB00000000 AS DateTime), 2, CAST(58.59000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10527, N'QUICK', 7, CAST(0x00008AE100000000 AS DateTime), CAST(0x00008AFD00000000 AS DateTime), CAST(0x00008AE300000000 AS DateTime), 1, CAST(41.90000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10528, N'GREAL', 6, CAST(0x00008AE200000000 AS DateTime), CAST(0x00008AF000000000 AS DateTime), CAST(0x00008AE500000000 AS DateTime), 2, CAST(3.35000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10529, N'MAISD', 5, CAST(0x00008AE300000000 AS DateTime), CAST(0x00008AFF00000000 AS DateTime), CAST(0x00008AE500000000 AS DateTime), 2, CAST(66.69000 AS Decimal(19, 5)), N'Maison Dewey', N'Rue Joseph-Bens 532', N'Bruxelles', N'null', N'B-1180', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10530, N'PICCO', 3, CAST(0x00008AE400000000 AS DateTime), CAST(0x00008B0000000000 AS DateTime), CAST(0x00008AE800000000 AS DateTime), 2, CAST(339.22000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10531, N'OCEAN', 7, CAST(0x00008AE400000000 AS DateTime), CAST(0x00008B0000000000 AS DateTime), CAST(0x00008AEF00000000 AS DateTime), 1, CAST(8.12000 AS Decimal(19, 5)), N'Océano Atlántico Ltda.', N'Ing. Gustavo Moncada 8585 Piso 20-A', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10532, N'EASTC', 7, CAST(0x00008AE500000000 AS DateTime), CAST(0x00008B0100000000 AS DateTime), CAST(0x00008AE800000000 AS DateTime), 3, CAST(74.46000 AS Decimal(19, 5)), N'Eastern Connection', N'35 King George', N'London', N'null', N'WX3 6FW', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10533, N'FOLKO', 8, CAST(0x00008AE800000000 AS DateTime), CAST(0x00008B0400000000 AS DateTime), CAST(0x00008AF200000000 AS DateTime), 1, CAST(188.04000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10534, N'LEHMS', 8, CAST(0x00008AE800000000 AS DateTime), CAST(0x00008B0400000000 AS DateTime), CAST(0x00008AEA00000000 AS DateTime), 2, CAST(27.94000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10535, N'ANTON', 4, CAST(0x00008AE900000000 AS DateTime), CAST(0x00008B0500000000 AS DateTime), CAST(0x00008AF100000000 AS DateTime), 1, CAST(15.64000 AS Decimal(19, 5)), N'Antonio Moreno Taquería', N'Mataderos  2312', N'México D.F.', N'null', N'05023', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10536, N'LEHMS', 3, CAST(0x00008AEA00000000 AS DateTime), CAST(0x00008B0600000000 AS DateTime), CAST(0x00008B0100000000 AS DateTime), 2, CAST(58.88000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10537, N'RICSU', 1, CAST(0x00008AEA00000000 AS DateTime), CAST(0x00008AF800000000 AS DateTime), CAST(0x00008AEF00000000 AS DateTime), 1, CAST(78.85000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10538, N'BSBEV', 9, CAST(0x00008AEB00000000 AS DateTime), CAST(0x00008B0700000000 AS DateTime), CAST(0x00008AEC00000000 AS DateTime), 3, CAST(4.87000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10539, N'BSBEV', 6, CAST(0x00008AEC00000000 AS DateTime), CAST(0x00008B0800000000 AS DateTime), CAST(0x00008AF300000000 AS DateTime), 3, CAST(12.36000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10540, N'QUICK', 3, CAST(0x00008AEF00000000 AS DateTime), CAST(0x00008B0B00000000 AS DateTime), CAST(0x00008B0800000000 AS DateTime), 3, CAST(1007.64000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10541, N'HANAR', 2, CAST(0x00008AEF00000000 AS DateTime), CAST(0x00008B0B00000000 AS DateTime), CAST(0x00008AF900000000 AS DateTime), 1, CAST(68.65000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10542, N'KOENE', 1, CAST(0x00008AF000000000 AS DateTime), CAST(0x00008B0C00000000 AS DateTime), CAST(0x00008AF600000000 AS DateTime), 3, CAST(10.95000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10543, N'LILAS', 8, CAST(0x00008AF100000000 AS DateTime), CAST(0x00008B0D00000000 AS DateTime), CAST(0x00008AF300000000 AS DateTime), 2, CAST(48.17000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10544, N'LONEP', 4, CAST(0x00008AF100000000 AS DateTime), CAST(0x00008B0D00000000 AS DateTime), CAST(0x00008AFA00000000 AS DateTime), 1, CAST(24.91000 AS Decimal(19, 5)), N'Lonesome Pine Restaurant', N'89 Chiaroscuro Rd.', N'Portland', N'OR', N'97219', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10545, N'LAZYK', 8, CAST(0x00008AF200000000 AS DateTime), CAST(0x00008B0E00000000 AS DateTime), CAST(0x00008B1500000000 AS DateTime), 2, CAST(11.92000 AS Decimal(19, 5)), N'Lazy K Kountry Store', N'12 Orchestra Terrace', N'Walla Walla', N'WA', N'99362', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10546, N'VICTE', 1, CAST(0x00008AF300000000 AS DateTime), CAST(0x00008B0F00000000 AS DateTime), CAST(0x00008AF700000000 AS DateTime), 3, CAST(194.72000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10547, N'SEVES', 3, CAST(0x00008AF300000000 AS DateTime), CAST(0x00008B0F00000000 AS DateTime), CAST(0x00008AFD00000000 AS DateTime), 2, CAST(178.43000 AS Decimal(19, 5)), N'Seven Seas Imports', N'90 Wadhurst Rd.', N'London', N'null', N'OX15 4NB', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10548, N'TOMSP', 3, CAST(0x00008AF600000000 AS DateTime), CAST(0x00008B1200000000 AS DateTime), CAST(0x00008AFD00000000 AS DateTime), 2, CAST(1.43000 AS Decimal(19, 5)), N'Toms Spezialitäten', N'Luisenstr. 48', N'Münster', N'null', N'44087', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10549, N'QUICK', 5, CAST(0x00008AF700000000 AS DateTime), CAST(0x00008B0500000000 AS DateTime), CAST(0x00008AFA00000000 AS DateTime), 1, CAST(171.24000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10550, N'GODOS', 7, CAST(0x00008AF800000000 AS DateTime), CAST(0x00008B1400000000 AS DateTime), CAST(0x00008B0100000000 AS DateTime), 3, CAST(4.32000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
GO
print 'Processed 300 total records'
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10551, N'FURIB', 4, CAST(0x00008AF800000000 AS DateTime), CAST(0x00008B2200000000 AS DateTime), CAST(0x00008B0100000000 AS DateTime), 3, CAST(72.95000 AS Decimal(19, 5)), N'Furia Bacalhau e Frutos do Mar', N'Jardim das rosas n. 32', N'Lisboa', N'null', N'1675', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10552, N'HILAA', 2, CAST(0x00008AF900000000 AS DateTime), CAST(0x00008B1500000000 AS DateTime), CAST(0x00008B0000000000 AS DateTime), 1, CAST(83.22000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10553, N'WARTH', 2, CAST(0x00008AFA00000000 AS DateTime), CAST(0x00008B1600000000 AS DateTime), CAST(0x00008AFE00000000 AS DateTime), 2, CAST(149.49000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10554, N'OTTIK', 4, CAST(0x00008AFA00000000 AS DateTime), CAST(0x00008B1600000000 AS DateTime), CAST(0x00008B0000000000 AS DateTime), 3, CAST(120.97000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10555, N'SAVEA', 6, CAST(0x00008AFD00000000 AS DateTime), CAST(0x00008B1900000000 AS DateTime), CAST(0x00008AFF00000000 AS DateTime), 3, CAST(252.49000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10556, N'SIMOB', 2, CAST(0x00008AFE00000000 AS DateTime), CAST(0x00008B2800000000 AS DateTime), CAST(0x00008B0800000000 AS DateTime), 1, CAST(9.80000 AS Decimal(19, 5)), N'Simons bistro', N'Vinbæltet 34', N'Kobenhavn', N'null', N'1734', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10557, N'LEHMS', 9, CAST(0x00008AFE00000000 AS DateTime), CAST(0x00008B0C00000000 AS DateTime), CAST(0x00008B0100000000 AS DateTime), 2, CAST(96.72000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10558, N'AROUT', 1, CAST(0x00008AFF00000000 AS DateTime), CAST(0x00008B1B00000000 AS DateTime), CAST(0x00008B0500000000 AS DateTime), 2, CAST(72.97000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10559, N'BLONP', 6, CAST(0x00008B0000000000 AS DateTime), CAST(0x00008B1C00000000 AS DateTime), CAST(0x00008B0800000000 AS DateTime), 1, CAST(8.05000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10560, N'FRANK', 8, CAST(0x00008B0100000000 AS DateTime), CAST(0x00008B1D00000000 AS DateTime), CAST(0x00008B0400000000 AS DateTime), 1, CAST(36.65000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10561, N'FOLKO', 2, CAST(0x00008B0100000000 AS DateTime), CAST(0x00008B1D00000000 AS DateTime), CAST(0x00008B0400000000 AS DateTime), 2, CAST(242.21000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10562, N'REGGC', 1, CAST(0x00008B0400000000 AS DateTime), CAST(0x00008B2000000000 AS DateTime), CAST(0x00008B0700000000 AS DateTime), 1, CAST(22.95000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10563, N'RICAR', 2, CAST(0x00008B0500000000 AS DateTime), CAST(0x00008B2F00000000 AS DateTime), CAST(0x00008B1300000000 AS DateTime), 2, CAST(60.43000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10564, N'RATTC', 4, CAST(0x00008B0500000000 AS DateTime), CAST(0x00008B2100000000 AS DateTime), CAST(0x00008B0B00000000 AS DateTime), 3, CAST(13.75000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10565, N'MEREP', 8, CAST(0x00008B0600000000 AS DateTime), CAST(0x00008B2200000000 AS DateTime), CAST(0x00008B0D00000000 AS DateTime), 2, CAST(7.15000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10566, N'BLONP', 9, CAST(0x00008B0700000000 AS DateTime), CAST(0x00008B2300000000 AS DateTime), CAST(0x00008B0D00000000 AS DateTime), 1, CAST(88.40000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10567, N'HUNGO', 1, CAST(0x00008B0700000000 AS DateTime), CAST(0x00008B2300000000 AS DateTime), CAST(0x00008B0C00000000 AS DateTime), 1, CAST(33.97000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10568, N'GALED', 3, CAST(0x00008B0800000000 AS DateTime), CAST(0x00008B2400000000 AS DateTime), CAST(0x00008B2200000000 AS DateTime), 3, CAST(6.54000 AS Decimal(19, 5)), N'Galería del gastronómo', N'Rambla de Cataluña, 23', N'Barcelona', N'null', N'8022', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10569, N'RATTC', 5, CAST(0x00008B0B00000000 AS DateTime), CAST(0x00008B2700000000 AS DateTime), CAST(0x00008B2400000000 AS DateTime), 1, CAST(58.98000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10570, N'MEREP', 3, CAST(0x00008B0C00000000 AS DateTime), CAST(0x00008B2800000000 AS DateTime), CAST(0x00008B0E00000000 AS DateTime), 3, CAST(188.99000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10571, N'ERNSH', 8, CAST(0x00008B0C00000000 AS DateTime), CAST(0x00008B3600000000 AS DateTime), CAST(0x00008B1D00000000 AS DateTime), 3, CAST(26.06000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10572, N'BERGS', 3, CAST(0x00008B0D00000000 AS DateTime), CAST(0x00008B2900000000 AS DateTime), CAST(0x00008B1400000000 AS DateTime), 2, CAST(116.43000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10573, N'ANTON', 7, CAST(0x00008B0E00000000 AS DateTime), CAST(0x00008B2A00000000 AS DateTime), CAST(0x00008B0F00000000 AS DateTime), 3, CAST(84.84000 AS Decimal(19, 5)), N'Antonio Moreno Taquería', N'Mataderos  2312', N'México D.F.', N'null', N'05023', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10574, N'TRAIH', 4, CAST(0x00008B0E00000000 AS DateTime), CAST(0x00008B2A00000000 AS DateTime), CAST(0x00008B1900000000 AS DateTime), 2, CAST(37.60000 AS Decimal(19, 5)), N'Trail''s Head Gourmet Provisioners', N'722 DaVinci Blvd.', N'Kirkland', N'WA', N'98034', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10575, N'MORGK', 5, CAST(0x00008B0F00000000 AS DateTime), CAST(0x00008B1D00000000 AS DateTime), CAST(0x00008B1900000000 AS DateTime), 1, CAST(127.34000 AS Decimal(19, 5)), N'Morgenstern Gesundkost', N'Heerstr. 22', N'Leipzig', N'null', N'04179', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10576, N'TORTU', 3, CAST(0x00008B1200000000 AS DateTime), CAST(0x00008B2000000000 AS DateTime), CAST(0x00008B1900000000 AS DateTime), 3, CAST(18.56000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10577, N'TRAIH', 9, CAST(0x00008B1200000000 AS DateTime), CAST(0x00008B3C00000000 AS DateTime), CAST(0x00008B1900000000 AS DateTime), 2, CAST(25.41000 AS Decimal(19, 5)), N'Trail''s Head Gourmet Provisioners', N'722 DaVinci Blvd.', N'Kirkland', N'WA', N'98034', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10578, N'BSBEV', 4, CAST(0x00008B1300000000 AS DateTime), CAST(0x00008B2F00000000 AS DateTime), CAST(0x00008B3200000000 AS DateTime), 3, CAST(29.60000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10579, N'LETSS', 1, CAST(0x00008B1400000000 AS DateTime), CAST(0x00008B3000000000 AS DateTime), CAST(0x00008B1D00000000 AS DateTime), 2, CAST(13.73000 AS Decimal(19, 5)), N'Let''s Stop N Shop', N'87 Polk St. Suite 5', N'San Francisco', N'CA', N'94117', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10580, N'OTTIK', 4, CAST(0x00008B1500000000 AS DateTime), CAST(0x00008B3100000000 AS DateTime), CAST(0x00008B1A00000000 AS DateTime), 3, CAST(75.89000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10581, N'FAMIA', 3, CAST(0x00008B1500000000 AS DateTime), CAST(0x00008B3100000000 AS DateTime), CAST(0x00008B1B00000000 AS DateTime), 1, CAST(3.01000 AS Decimal(19, 5)), N'Familia Arquibaldo', N'Rua Orós, 92', N'Sao Paulo', N'SP', N'05442-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10582, N'BLAUS', 3, CAST(0x00008B1600000000 AS DateTime), CAST(0x00008B3200000000 AS DateTime), CAST(0x00008B2700000000 AS DateTime), 2, CAST(27.71000 AS Decimal(19, 5)), N'Blauer See Delikatessen', N'Forsterstr. 57', N'Mannheim', N'null', N'68306', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10583, N'WARTH', 2, CAST(0x00008B1900000000 AS DateTime), CAST(0x00008B3500000000 AS DateTime), CAST(0x00008B1D00000000 AS DateTime), 2, CAST(7.28000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10584, N'BLONP', 4, CAST(0x00008B1900000000 AS DateTime), CAST(0x00008B3500000000 AS DateTime), CAST(0x00008B1D00000000 AS DateTime), 1, CAST(59.14000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10585, N'WELLI', 7, CAST(0x00008B1A00000000 AS DateTime), CAST(0x00008B3600000000 AS DateTime), CAST(0x00008B2300000000 AS DateTime), 1, CAST(13.41000 AS Decimal(19, 5)), N'Wellington Importadora', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10586, N'REGGC', 9, CAST(0x00008B1B00000000 AS DateTime), CAST(0x00008B3700000000 AS DateTime), CAST(0x00008B2200000000 AS DateTime), 1, CAST(0.48000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10587, N'QUEDE', 1, CAST(0x00008B1B00000000 AS DateTime), CAST(0x00008B3700000000 AS DateTime), CAST(0x00008B2200000000 AS DateTime), 1, CAST(62.52000 AS Decimal(19, 5)), N'Que Delícia', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10588, N'QUICK', 2, CAST(0x00008B1C00000000 AS DateTime), CAST(0x00008B3800000000 AS DateTime), CAST(0x00008B2300000000 AS DateTime), 3, CAST(194.67000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10589, N'GREAL', 8, CAST(0x00008B1D00000000 AS DateTime), CAST(0x00008B3900000000 AS DateTime), CAST(0x00008B2700000000 AS DateTime), 2, CAST(4.42000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10590, N'MEREP', 4, CAST(0x00008B2000000000 AS DateTime), CAST(0x00008B3C00000000 AS DateTime), CAST(0x00008B2700000000 AS DateTime), 3, CAST(44.77000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10591, N'VAFFE', 1, CAST(0x00008B2000000000 AS DateTime), CAST(0x00008B2E00000000 AS DateTime), CAST(0x00008B2900000000 AS DateTime), 1, CAST(55.92000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10592, N'LEHMS', 3, CAST(0x00008B2100000000 AS DateTime), CAST(0x00008B3D00000000 AS DateTime), CAST(0x00008B2900000000 AS DateTime), 1, CAST(32.10000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10593, N'LEHMS', 7, CAST(0x00008B2200000000 AS DateTime), CAST(0x00008B3E00000000 AS DateTime), CAST(0x00008B4500000000 AS DateTime), 2, CAST(174.20000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10594, N'OLDWO', 3, CAST(0x00008B2200000000 AS DateTime), CAST(0x00008B3E00000000 AS DateTime), CAST(0x00008B2900000000 AS DateTime), 2, CAST(5.24000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10595, N'ERNSH', 2, CAST(0x00008B2300000000 AS DateTime), CAST(0x00008B3F00000000 AS DateTime), CAST(0x00008B2700000000 AS DateTime), 1, CAST(96.78000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10596, N'WHITC', 8, CAST(0x00008B2400000000 AS DateTime), CAST(0x00008B4000000000 AS DateTime), CAST(0x00008B4400000000 AS DateTime), 1, CAST(16.34000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10597, N'PICCO', 7, CAST(0x00008B2400000000 AS DateTime), CAST(0x00008B4000000000 AS DateTime), CAST(0x00008B2B00000000 AS DateTime), 3, CAST(35.12000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10598, N'RATTC', 1, CAST(0x00008B2700000000 AS DateTime), CAST(0x00008B4300000000 AS DateTime), CAST(0x00008B2B00000000 AS DateTime), 3, CAST(44.42000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10599, N'BSBEV', 6, CAST(0x00008B2800000000 AS DateTime), CAST(0x00008B5200000000 AS DateTime), CAST(0x00008B2E00000000 AS DateTime), 3, CAST(29.98000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10600, N'HUNGC', 4, CAST(0x00008B2900000000 AS DateTime), CAST(0x00008B4500000000 AS DateTime), CAST(0x00008B2E00000000 AS DateTime), 1, CAST(45.13000 AS Decimal(19, 5)), N'Hungry Coyote Import Store', N'City Center Plaza 516 Main St.', N'Elgin', N'OR', N'97827', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10601, N'HILAA', 7, CAST(0x00008B2900000000 AS DateTime), CAST(0x00008B5300000000 AS DateTime), CAST(0x00008B2F00000000 AS DateTime), 1, CAST(58.30000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10602, N'VAFFE', 8, CAST(0x00008B2A00000000 AS DateTime), CAST(0x00008B4600000000 AS DateTime), CAST(0x00008B2F00000000 AS DateTime), 2, CAST(2.92000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10603, N'SAVEA', 8, CAST(0x00008B2B00000000 AS DateTime), CAST(0x00008B4700000000 AS DateTime), CAST(0x00008B4000000000 AS DateTime), 2, CAST(48.77000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10604, N'FURIB', 1, CAST(0x00008B2B00000000 AS DateTime), CAST(0x00008B4700000000 AS DateTime), CAST(0x00008B3600000000 AS DateTime), 1, CAST(7.46000 AS Decimal(19, 5)), N'Furia Bacalhau e Frutos do Mar', N'Jardim das rosas n. 32', N'Lisboa', N'null', N'1675', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10605, N'MEREP', 1, CAST(0x00008B2E00000000 AS DateTime), CAST(0x00008B4A00000000 AS DateTime), CAST(0x00008B3600000000 AS DateTime), 2, CAST(379.13000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10606, N'TRADH', 4, CAST(0x00008B2F00000000 AS DateTime), CAST(0x00008B4B00000000 AS DateTime), CAST(0x00008B3800000000 AS DateTime), 3, CAST(79.40000 AS Decimal(19, 5)), N'Tradiçao Hipermercados', N'Av. Inês de Castro, 414', N'Sao Paulo', N'SP', N'05634-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10607, N'SAVEA', 5, CAST(0x00008B2F00000000 AS DateTime), CAST(0x00008B4B00000000 AS DateTime), CAST(0x00008B3200000000 AS DateTime), 1, CAST(200.24000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10608, N'TOMSP', 4, CAST(0x00008B3000000000 AS DateTime), CAST(0x00008B4C00000000 AS DateTime), CAST(0x00008B3900000000 AS DateTime), 2, CAST(27.79000 AS Decimal(19, 5)), N'Toms Spezialitäten', N'Luisenstr. 48', N'Münster', N'null', N'44087', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10609, N'DUMON', 7, CAST(0x00008B3100000000 AS DateTime), CAST(0x00008B4D00000000 AS DateTime), CAST(0x00008B3700000000 AS DateTime), 2, CAST(1.85000 AS Decimal(19, 5)), N'Du monde entier', N'67, rue des Cinquante Otages', N'Nantes', N'null', N'44000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10610, N'LAMAI', 8, CAST(0x00008B3200000000 AS DateTime), CAST(0x00008B4E00000000 AS DateTime), CAST(0x00008B3E00000000 AS DateTime), 1, CAST(26.78000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10611, N'WOLZA', 6, CAST(0x00008B3200000000 AS DateTime), CAST(0x00008B4E00000000 AS DateTime), CAST(0x00008B3900000000 AS DateTime), 2, CAST(80.65000 AS Decimal(19, 5)), N'Wolski Zajazd', N'ul. Filtrowa 68', N'Warszawa', N'null', N'01-012', N'Poland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10612, N'SAVEA', 1, CAST(0x00008B3500000000 AS DateTime), CAST(0x00008B5100000000 AS DateTime), CAST(0x00008B3900000000 AS DateTime), 2, CAST(544.08000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10613, N'HILAA', 4, CAST(0x00008B3600000000 AS DateTime), CAST(0x00008B5200000000 AS DateTime), CAST(0x00008B3900000000 AS DateTime), 2, CAST(8.11000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10614, N'BLAUS', 8, CAST(0x00008B3600000000 AS DateTime), CAST(0x00008B5200000000 AS DateTime), CAST(0x00008B3900000000 AS DateTime), 3, CAST(1.93000 AS Decimal(19, 5)), N'Blauer See Delikatessen', N'Forsterstr. 57', N'Mannheim', N'null', N'68306', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10615, N'WILMK', 2, CAST(0x00008B3700000000 AS DateTime), CAST(0x00008B5300000000 AS DateTime), CAST(0x00008B3E00000000 AS DateTime), 3, CAST(0.75000 AS Decimal(19, 5)), N'Wilman Kala', N'Keskuskatu 45', N'Helsinki', N'null', N'21240', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10616, N'GREAL', 1, CAST(0x00008B3800000000 AS DateTime), CAST(0x00008B5400000000 AS DateTime), CAST(0x00008B3D00000000 AS DateTime), 2, CAST(116.53000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10617, N'GREAL', 4, CAST(0x00008B3800000000 AS DateTime), CAST(0x00008B5400000000 AS DateTime), CAST(0x00008B3C00000000 AS DateTime), 2, CAST(18.53000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10618, N'MEREP', 1, CAST(0x00008B3900000000 AS DateTime), CAST(0x00008B6300000000 AS DateTime), CAST(0x00008B4000000000 AS DateTime), 1, CAST(154.68000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10619, N'MEREP', 3, CAST(0x00008B3C00000000 AS DateTime), CAST(0x00008B5800000000 AS DateTime), CAST(0x00008B3F00000000 AS DateTime), 3, CAST(91.05000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10620, N'LAUGB', 2, CAST(0x00008B3D00000000 AS DateTime), CAST(0x00008B5900000000 AS DateTime), CAST(0x00008B4600000000 AS DateTime), 3, CAST(0.94000 AS Decimal(19, 5)), N'Laughing Bacchus Wine Cellars', N'2319 Elm St.', N'Vancouver', N'BC', N'V3F 2K1', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10621, N'ISLAT', 4, CAST(0x00008B3D00000000 AS DateTime), CAST(0x00008B5900000000 AS DateTime), CAST(0x00008B4300000000 AS DateTime), 2, CAST(23.73000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10622, N'RICAR', 4, CAST(0x00008B3E00000000 AS DateTime), CAST(0x00008B5A00000000 AS DateTime), CAST(0x00008B4300000000 AS DateTime), 3, CAST(50.97000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10623, N'FRANK', 8, CAST(0x00008B3F00000000 AS DateTime), CAST(0x00008B5B00000000 AS DateTime), CAST(0x00008B4400000000 AS DateTime), 2, CAST(97.18000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10624, N'THECR', 4, CAST(0x00008B3F00000000 AS DateTime), CAST(0x00008B5B00000000 AS DateTime), CAST(0x00008B4B00000000 AS DateTime), 2, CAST(94.80000 AS Decimal(19, 5)), N'The Cracker Box', N'55 Grizzly Peak Rd.', N'Butte', N'MT', N'59801', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10625, N'ANATR', 3, CAST(0x00008B4000000000 AS DateTime), CAST(0x00008B5C00000000 AS DateTime), CAST(0x00008B4600000000 AS DateTime), 1, CAST(43.90000 AS Decimal(19, 5)), N'Ana Trujillo Emparedados y helados', N'Avda. de la Constitución 2222', N'México D.F.', N'null', N'05021', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10626, N'BERGS', 1, CAST(0x00008B4300000000 AS DateTime), CAST(0x00008B5F00000000 AS DateTime), CAST(0x00008B4C00000000 AS DateTime), 2, CAST(138.69000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10627, N'SAVEA', 8, CAST(0x00008B4300000000 AS DateTime), CAST(0x00008B6D00000000 AS DateTime), CAST(0x00008B4D00000000 AS DateTime), 3, CAST(107.46000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10628, N'BLONP', 4, CAST(0x00008B4400000000 AS DateTime), CAST(0x00008B6000000000 AS DateTime), CAST(0x00008B4C00000000 AS DateTime), 3, CAST(30.36000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10629, N'GODOS', 4, CAST(0x00008B4400000000 AS DateTime), CAST(0x00008B6000000000 AS DateTime), CAST(0x00008B4C00000000 AS DateTime), 3, CAST(85.46000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10630, N'KOENE', 1, CAST(0x00008B4500000000 AS DateTime), CAST(0x00008B6100000000 AS DateTime), CAST(0x00008B4B00000000 AS DateTime), 2, CAST(32.35000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10631, N'LAMAI', 8, CAST(0x00008B4600000000 AS DateTime), CAST(0x00008B6200000000 AS DateTime), CAST(0x00008B4700000000 AS DateTime), 1, CAST(0.87000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10632, N'WANDK', 8, CAST(0x00008B4600000000 AS DateTime), CAST(0x00008B6200000000 AS DateTime), CAST(0x00008B4B00000000 AS DateTime), 1, CAST(41.38000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10633, N'ERNSH', 7, CAST(0x00008B4700000000 AS DateTime), CAST(0x00008B6300000000 AS DateTime), CAST(0x00008B4A00000000 AS DateTime), 3, CAST(477.90000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10634, N'FOLIG', 4, CAST(0x00008B4700000000 AS DateTime), CAST(0x00008B6300000000 AS DateTime), CAST(0x00008B4D00000000 AS DateTime), 3, CAST(487.38000 AS Decimal(19, 5)), N'Folies gourmandes', N'184, chaussée de Tournai', N'Lille', N'null', N'59000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10635, N'MAGAA', 8, CAST(0x00008B4A00000000 AS DateTime), CAST(0x00008B6600000000 AS DateTime), CAST(0x00008B4D00000000 AS DateTime), 3, CAST(47.46000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10636, N'WARTH', 4, CAST(0x00008B4B00000000 AS DateTime), CAST(0x00008B6700000000 AS DateTime), CAST(0x00008B5200000000 AS DateTime), 1, CAST(1.15000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10637, N'QUEEN', 6, CAST(0x00008B4B00000000 AS DateTime), CAST(0x00008B6700000000 AS DateTime), CAST(0x00008B5200000000 AS DateTime), 1, CAST(201.29000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10638, N'LINOD', 3, CAST(0x00008B4C00000000 AS DateTime), CAST(0x00008B6800000000 AS DateTime), CAST(0x00008B5800000000 AS DateTime), 1, CAST(158.44000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10639, N'SANTG', 7, CAST(0x00008B4C00000000 AS DateTime), CAST(0x00008B6800000000 AS DateTime), CAST(0x00008B5300000000 AS DateTime), 3, CAST(38.64000 AS Decimal(19, 5)), N'Santé Gourmet', N'Erling Skakkes gate 78', N'Stavern', N'null', N'4110', N'Norway')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10640, N'WANDK', 4, CAST(0x00008B4D00000000 AS DateTime), CAST(0x00008B6900000000 AS DateTime), CAST(0x00008B5400000000 AS DateTime), 1, CAST(23.55000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10641, N'HILAA', 4, CAST(0x00008B4E00000000 AS DateTime), CAST(0x00008B6A00000000 AS DateTime), CAST(0x00008B5200000000 AS DateTime), 2, CAST(179.61000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10642, N'SIMOB', 7, CAST(0x00008B4E00000000 AS DateTime), CAST(0x00008B6A00000000 AS DateTime), CAST(0x00008B5C00000000 AS DateTime), 3, CAST(41.89000 AS Decimal(19, 5)), N'Simons bistro', N'Vinbæltet 34', N'Kobenhavn', N'null', N'1734', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10643, N'ALFKI', 6, CAST(0x00008B5100000000 AS DateTime), CAST(0x00008B6D00000000 AS DateTime), CAST(0x00008B5900000000 AS DateTime), 1, CAST(29.46000 AS Decimal(19, 5)), N'Alfreds Futterkiste', N'Obere Str. 57', N'Berlin', N'null', N'12209', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10644, N'WELLI', 3, CAST(0x00008B5100000000 AS DateTime), CAST(0x00008B6D00000000 AS DateTime), CAST(0x00008B5800000000 AS DateTime), 2, CAST(0.14000 AS Decimal(19, 5)), N'Wellington Importadora', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10645, N'HANAR', 4, CAST(0x00008B5200000000 AS DateTime), CAST(0x00008B6E00000000 AS DateTime), CAST(0x00008B5900000000 AS DateTime), 1, CAST(12.41000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10646, N'HUNGO', 9, CAST(0x00008B5300000000 AS DateTime), CAST(0x00008B7D00000000 AS DateTime), CAST(0x00008B5A00000000 AS DateTime), 3, CAST(142.33000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10647, N'QUEDE', 4, CAST(0x00008B5300000000 AS DateTime), CAST(0x00008B6100000000 AS DateTime), CAST(0x00008B5A00000000 AS DateTime), 2, CAST(45.54000 AS Decimal(19, 5)), N'Que Delícia', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10648, N'RICAR', 5, CAST(0x00008B5400000000 AS DateTime), CAST(0x00008B7E00000000 AS DateTime), CAST(0x00008B6000000000 AS DateTime), 2, CAST(14.25000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10649, N'MAISD', 5, CAST(0x00008B5400000000 AS DateTime), CAST(0x00008B7000000000 AS DateTime), CAST(0x00008B5500000000 AS DateTime), 3, CAST(6.20000 AS Decimal(19, 5)), N'Maison Dewey', N'Rue Joseph-Bens 532', N'Bruxelles', N'null', N'B-1180', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10650, N'FAMIA', 5, CAST(0x00008B5500000000 AS DateTime), CAST(0x00008B7100000000 AS DateTime), CAST(0x00008B5A00000000 AS DateTime), 3, CAST(176.81000 AS Decimal(19, 5)), N'Familia Arquibaldo', N'Rua Orós, 92', N'Sao Paulo', N'SP', N'05442-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10651, N'WANDK', 8, CAST(0x00008B5800000000 AS DateTime), CAST(0x00008B7400000000 AS DateTime), CAST(0x00008B6200000000 AS DateTime), 2, CAST(20.60000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
GO
print 'Processed 400 total records'
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10652, N'GOURL', 4, CAST(0x00008B5800000000 AS DateTime), CAST(0x00008B7400000000 AS DateTime), CAST(0x00008B5F00000000 AS DateTime), 2, CAST(7.14000 AS Decimal(19, 5)), N'Gourmet Lanchonetes', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10653, N'FRANK', 1, CAST(0x00008B5900000000 AS DateTime), CAST(0x00008B7500000000 AS DateTime), CAST(0x00008B6A00000000 AS DateTime), 1, CAST(93.25000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10654, N'BERGS', 5, CAST(0x00008B5900000000 AS DateTime), CAST(0x00008B7500000000 AS DateTime), CAST(0x00008B6200000000 AS DateTime), 1, CAST(55.26000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10655, N'REGGC', 1, CAST(0x00008B5A00000000 AS DateTime), CAST(0x00008B7600000000 AS DateTime), CAST(0x00008B6200000000 AS DateTime), 2, CAST(4.41000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10656, N'GREAL', 6, CAST(0x00008B5B00000000 AS DateTime), CAST(0x00008B7700000000 AS DateTime), CAST(0x00008B6100000000 AS DateTime), 1, CAST(57.15000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10657, N'SAVEA', 2, CAST(0x00008B5B00000000 AS DateTime), CAST(0x00008B7700000000 AS DateTime), CAST(0x00008B6600000000 AS DateTime), 2, CAST(352.69000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10658, N'QUICK', 4, CAST(0x00008B5C00000000 AS DateTime), CAST(0x00008B7800000000 AS DateTime), CAST(0x00008B5F00000000 AS DateTime), 1, CAST(364.15000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10659, N'QUEEN', 7, CAST(0x00008B5C00000000 AS DateTime), CAST(0x00008B7800000000 AS DateTime), CAST(0x00008B6100000000 AS DateTime), 2, CAST(105.81000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10660, N'HUNGC', 8, CAST(0x00008B5F00000000 AS DateTime), CAST(0x00008B7B00000000 AS DateTime), CAST(0x00008B8400000000 AS DateTime), 1, CAST(111.29000 AS Decimal(19, 5)), N'Hungry Coyote Import Store', N'City Center Plaza 516 Main St.', N'Elgin', N'OR', N'97827', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10661, N'HUNGO', 7, CAST(0x00008B6000000000 AS DateTime), CAST(0x00008B7C00000000 AS DateTime), CAST(0x00008B6600000000 AS DateTime), 3, CAST(17.55000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10662, N'LONEP', 3, CAST(0x00008B6000000000 AS DateTime), CAST(0x00008B7C00000000 AS DateTime), CAST(0x00008B6900000000 AS DateTime), 2, CAST(1.28000 AS Decimal(19, 5)), N'Lonesome Pine Restaurant', N'89 Chiaroscuro Rd.', N'Portland', N'OR', N'97219', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10663, N'BONAP', 2, CAST(0x00008B6100000000 AS DateTime), CAST(0x00008B6F00000000 AS DateTime), CAST(0x00008B7800000000 AS DateTime), 2, CAST(113.15000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10664, N'FURIB', 1, CAST(0x00008B6100000000 AS DateTime), CAST(0x00008B7D00000000 AS DateTime), CAST(0x00008B6A00000000 AS DateTime), 3, CAST(1.27000 AS Decimal(19, 5)), N'Furia Bacalhau e Frutos do Mar', N'Jardim das rosas n. 32', N'Lisboa', N'null', N'1675', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10665, N'LONEP', 1, CAST(0x00008B6200000000 AS DateTime), CAST(0x00008B7E00000000 AS DateTime), CAST(0x00008B6800000000 AS DateTime), 2, CAST(26.31000 AS Decimal(19, 5)), N'Lonesome Pine Restaurant', N'89 Chiaroscuro Rd.', N'Portland', N'OR', N'97219', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10666, N'RICSU', 7, CAST(0x00008B6300000000 AS DateTime), CAST(0x00008B7F00000000 AS DateTime), CAST(0x00008B6D00000000 AS DateTime), 2, CAST(232.42000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10667, N'ERNSH', 7, CAST(0x00008B6300000000 AS DateTime), CAST(0x00008B7F00000000 AS DateTime), CAST(0x00008B6A00000000 AS DateTime), 1, CAST(78.09000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10668, N'WANDK', 1, CAST(0x00008B6600000000 AS DateTime), CAST(0x00008B8200000000 AS DateTime), CAST(0x00008B6E00000000 AS DateTime), 2, CAST(47.22000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10669, N'SIMOB', 2, CAST(0x00008B6600000000 AS DateTime), CAST(0x00008B8200000000 AS DateTime), CAST(0x00008B6D00000000 AS DateTime), 1, CAST(24.39000 AS Decimal(19, 5)), N'Simons bistro', N'Vinbæltet 34', N'Kobenhavn', N'null', N'1734', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10670, N'FRANK', 4, CAST(0x00008B6700000000 AS DateTime), CAST(0x00008B8300000000 AS DateTime), CAST(0x00008B6900000000 AS DateTime), 1, CAST(203.48000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10671, N'FRANR', 1, CAST(0x00008B6800000000 AS DateTime), CAST(0x00008B8400000000 AS DateTime), CAST(0x00008B6F00000000 AS DateTime), 1, CAST(30.34000 AS Decimal(19, 5)), N'France restauration', N'54, rue Royale', N'Nantes', N'null', N'44000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10672, N'BERGS', 9, CAST(0x00008B6800000000 AS DateTime), CAST(0x00008B7600000000 AS DateTime), CAST(0x00008B7100000000 AS DateTime), 2, CAST(95.75000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10673, N'WILMK', 2, CAST(0x00008B6900000000 AS DateTime), CAST(0x00008B8500000000 AS DateTime), CAST(0x00008B6A00000000 AS DateTime), 1, CAST(22.76000 AS Decimal(19, 5)), N'Wilman Kala', N'Keskuskatu 45', N'Helsinki', N'null', N'21240', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10674, N'ISLAT', 4, CAST(0x00008B6900000000 AS DateTime), CAST(0x00008B8500000000 AS DateTime), CAST(0x00008B7500000000 AS DateTime), 2, CAST(0.90000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10675, N'FRANK', 5, CAST(0x00008B6A00000000 AS DateTime), CAST(0x00008B8600000000 AS DateTime), CAST(0x00008B6E00000000 AS DateTime), 2, CAST(31.85000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10676, N'TORTU', 2, CAST(0x00008B6D00000000 AS DateTime), CAST(0x00008B8900000000 AS DateTime), CAST(0x00008B7400000000 AS DateTime), 2, CAST(2.01000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10677, N'ANTON', 1, CAST(0x00008B6D00000000 AS DateTime), CAST(0x00008B8900000000 AS DateTime), CAST(0x00008B7100000000 AS DateTime), 3, CAST(4.03000 AS Decimal(19, 5)), N'Antonio Moreno Taquería', N'Mataderos  2312', N'México D.F.', N'null', N'05023', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10678, N'SAVEA', 7, CAST(0x00008B6E00000000 AS DateTime), CAST(0x00008B8A00000000 AS DateTime), CAST(0x00008B8500000000 AS DateTime), 3, CAST(388.98000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10679, N'BLONP', 8, CAST(0x00008B6E00000000 AS DateTime), CAST(0x00008B8A00000000 AS DateTime), CAST(0x00008B7500000000 AS DateTime), 3, CAST(27.94000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10680, N'OLDWO', 1, CAST(0x00008B6F00000000 AS DateTime), CAST(0x00008B8B00000000 AS DateTime), CAST(0x00008B7100000000 AS DateTime), 1, CAST(26.61000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10681, N'GREAL', 3, CAST(0x00008B7000000000 AS DateTime), CAST(0x00008B8C00000000 AS DateTime), CAST(0x00008B7500000000 AS DateTime), 3, CAST(76.13000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10682, N'ANTON', 3, CAST(0x00008B7000000000 AS DateTime), CAST(0x00008B8C00000000 AS DateTime), CAST(0x00008B7600000000 AS DateTime), 2, CAST(36.13000 AS Decimal(19, 5)), N'Antonio Moreno Taquería', N'Mataderos  2312', N'México D.F.', N'null', N'05023', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10683, N'DUMON', 2, CAST(0x00008B7100000000 AS DateTime), CAST(0x00008B8D00000000 AS DateTime), CAST(0x00008B7600000000 AS DateTime), 1, CAST(4.40000 AS Decimal(19, 5)), N'Du monde entier', N'67, rue des Cinquante Otages', N'Nantes', N'null', N'44000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10684, N'OTTIK', 3, CAST(0x00008B7100000000 AS DateTime), CAST(0x00008B8D00000000 AS DateTime), CAST(0x00008B7500000000 AS DateTime), 1, CAST(145.63000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10685, N'GOURL', 4, CAST(0x00008B7400000000 AS DateTime), CAST(0x00008B8200000000 AS DateTime), CAST(0x00008B7800000000 AS DateTime), 2, CAST(33.75000 AS Decimal(19, 5)), N'Gourmet Lanchonetes', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10686, N'PICCO', 2, CAST(0x00008B7500000000 AS DateTime), CAST(0x00008B9100000000 AS DateTime), CAST(0x00008B7D00000000 AS DateTime), 1, CAST(96.50000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10687, N'HUNGO', 9, CAST(0x00008B7500000000 AS DateTime), CAST(0x00008B9100000000 AS DateTime), CAST(0x00008B9300000000 AS DateTime), 2, CAST(296.43000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10688, N'VAFFE', 4, CAST(0x00008B7600000000 AS DateTime), CAST(0x00008B8400000000 AS DateTime), CAST(0x00008B7C00000000 AS DateTime), 2, CAST(299.09000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10689, N'BERGS', 1, CAST(0x00008B7600000000 AS DateTime), CAST(0x00008B9200000000 AS DateTime), CAST(0x00008B7C00000000 AS DateTime), 2, CAST(13.42000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10690, N'HANAR', 1, CAST(0x00008B7700000000 AS DateTime), CAST(0x00008B9300000000 AS DateTime), CAST(0x00008B7800000000 AS DateTime), 1, CAST(15.80000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10691, N'QUICK', 2, CAST(0x00008B7800000000 AS DateTime), CAST(0x00008BA200000000 AS DateTime), CAST(0x00008B8B00000000 AS DateTime), 2, CAST(810.05000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10692, N'ALFKI', 4, CAST(0x00008B7800000000 AS DateTime), CAST(0x00008B9400000000 AS DateTime), CAST(0x00008B8200000000 AS DateTime), 2, CAST(61.02000 AS Decimal(19, 5)), N'Alfred''s Futterkiste', N'Obere Str. 57', N'Berlin', N'null', N'12209', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10693, N'WHITC', 3, CAST(0x00008B7B00000000 AS DateTime), CAST(0x00008B8900000000 AS DateTime), CAST(0x00008B7F00000000 AS DateTime), 3, CAST(139.34000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10694, N'QUICK', 8, CAST(0x00008B7B00000000 AS DateTime), CAST(0x00008B9700000000 AS DateTime), CAST(0x00008B7E00000000 AS DateTime), 3, CAST(398.36000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10695, N'WILMK', 7, CAST(0x00008B7C00000000 AS DateTime), CAST(0x00008BA600000000 AS DateTime), CAST(0x00008B8300000000 AS DateTime), 1, CAST(16.72000 AS Decimal(19, 5)), N'Wilman Kala', N'Keskuskatu 45', N'Helsinki', N'null', N'21240', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10696, N'WHITC', 8, CAST(0x00008B7D00000000 AS DateTime), CAST(0x00008BA700000000 AS DateTime), CAST(0x00008B8300000000 AS DateTime), 3, CAST(102.55000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10697, N'LINOD', 3, CAST(0x00008B7D00000000 AS DateTime), CAST(0x00008B9900000000 AS DateTime), CAST(0x00008B8300000000 AS DateTime), 1, CAST(45.52000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10698, N'ERNSH', 4, CAST(0x00008B7E00000000 AS DateTime), CAST(0x00008B9A00000000 AS DateTime), CAST(0x00008B8600000000 AS DateTime), 1, CAST(272.47000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10699, N'MORGK', 3, CAST(0x00008B7E00000000 AS DateTime), CAST(0x00008B9A00000000 AS DateTime), CAST(0x00008B8200000000 AS DateTime), 3, CAST(0.58000 AS Decimal(19, 5)), N'Morgenstern Gesundkost', N'Heerstr. 22', N'Leipzig', N'null', N'04179', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10700, N'SAVEA', 3, CAST(0x00008B7F00000000 AS DateTime), CAST(0x00008B9B00000000 AS DateTime), CAST(0x00008B8500000000 AS DateTime), 1, CAST(65.10000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10701, N'HUNGO', 6, CAST(0x00008B8200000000 AS DateTime), CAST(0x00008B9000000000 AS DateTime), CAST(0x00008B8400000000 AS DateTime), 3, CAST(220.31000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10702, N'ALFKI', 4, CAST(0x00008B8200000000 AS DateTime), CAST(0x00008BAC00000000 AS DateTime), CAST(0x00008B8A00000000 AS DateTime), 1, CAST(23.94000 AS Decimal(19, 5)), N'Alfred''s Futterkiste', N'Obere Str. 57', N'Berlin', N'null', N'12209', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10703, N'FOLKO', 6, CAST(0x00008B8300000000 AS DateTime), CAST(0x00008B9F00000000 AS DateTime), CAST(0x00008B8900000000 AS DateTime), 2, CAST(152.30000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10704, N'QUEEN', 6, CAST(0x00008B8300000000 AS DateTime), CAST(0x00008B9F00000000 AS DateTime), CAST(0x00008B9B00000000 AS DateTime), 1, CAST(4.78000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10705, N'HILAA', 9, CAST(0x00008B8400000000 AS DateTime), CAST(0x00008BA000000000 AS DateTime), CAST(0x00008BA600000000 AS DateTime), 2, CAST(3.52000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10706, N'OLDWO', 8, CAST(0x00008B8500000000 AS DateTime), CAST(0x00008BA100000000 AS DateTime), CAST(0x00008B8A00000000 AS DateTime), 3, CAST(135.63000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10707, N'AROUT', 4, CAST(0x00008B8500000000 AS DateTime), CAST(0x00008B9300000000 AS DateTime), CAST(0x00008B8C00000000 AS DateTime), 3, CAST(21.74000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10708, N'THEBI', 6, CAST(0x00008B8600000000 AS DateTime), CAST(0x00008BB000000000 AS DateTime), CAST(0x00008B9900000000 AS DateTime), 2, CAST(2.96000 AS Decimal(19, 5)), N'The Big Cheese', N'89 Jefferson Way Suite 2', N'Portland', N'OR', N'97201', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10709, N'GOURL', 1, CAST(0x00008B8600000000 AS DateTime), CAST(0x00008BA200000000 AS DateTime), CAST(0x00008BA800000000 AS DateTime), 3, CAST(210.80000 AS Decimal(19, 5)), N'Gourmet Lanchonetes', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10710, N'FRANS', 1, CAST(0x00008B8900000000 AS DateTime), CAST(0x00008BA500000000 AS DateTime), CAST(0x00008B8C00000000 AS DateTime), 1, CAST(4.98000 AS Decimal(19, 5)), N'Franchi S.p.A.', N'Via Monte Bianco 34', N'Torino', N'null', N'10100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10711, N'SAVEA', 5, CAST(0x00008B8A00000000 AS DateTime), CAST(0x00008BB400000000 AS DateTime), CAST(0x00008B9200000000 AS DateTime), 2, CAST(52.41000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10712, N'HUNGO', 3, CAST(0x00008B8A00000000 AS DateTime), CAST(0x00008BA600000000 AS DateTime), CAST(0x00008B9400000000 AS DateTime), 1, CAST(89.93000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10713, N'SAVEA', 1, CAST(0x00008B8B00000000 AS DateTime), CAST(0x00008BA700000000 AS DateTime), CAST(0x00008B8D00000000 AS DateTime), 1, CAST(167.05000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10714, N'SAVEA', 5, CAST(0x00008B8B00000000 AS DateTime), CAST(0x00008BA700000000 AS DateTime), CAST(0x00008B9000000000 AS DateTime), 3, CAST(24.49000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10715, N'BONAP', 3, CAST(0x00008B8C00000000 AS DateTime), CAST(0x00008B9A00000000 AS DateTime), CAST(0x00008B9200000000 AS DateTime), 1, CAST(63.20000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10716, N'RANCH', 4, CAST(0x00008B8D00000000 AS DateTime), CAST(0x00008BA900000000 AS DateTime), CAST(0x00008B9000000000 AS DateTime), 2, CAST(22.57000 AS Decimal(19, 5)), N'Rancho grande', N'Av. del Libertador 900', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10717, N'FRANK', 1, CAST(0x00008B8D00000000 AS DateTime), CAST(0x00008BA900000000 AS DateTime), CAST(0x00008B9200000000 AS DateTime), 2, CAST(59.25000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10718, N'KOENE', 1, CAST(0x00008B9000000000 AS DateTime), CAST(0x00008BAC00000000 AS DateTime), CAST(0x00008B9200000000 AS DateTime), 3, CAST(170.88000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10719, N'LETSS', 8, CAST(0x00008B9000000000 AS DateTime), CAST(0x00008BAC00000000 AS DateTime), CAST(0x00008B9900000000 AS DateTime), 2, CAST(51.44000 AS Decimal(19, 5)), N'Let''s Stop N Shop', N'87 Polk St. Suite 5', N'San Francisco', N'CA', N'94117', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10720, N'QUEDE', 8, CAST(0x00008B9100000000 AS DateTime), CAST(0x00008B9F00000000 AS DateTime), CAST(0x00008B9900000000 AS DateTime), 2, CAST(9.53000 AS Decimal(19, 5)), N'Que Delícia', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10721, N'QUICK', 5, CAST(0x00008B9200000000 AS DateTime), CAST(0x00008BAE00000000 AS DateTime), CAST(0x00008B9400000000 AS DateTime), 3, CAST(48.92000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10722, N'SAVEA', 8, CAST(0x00008B9200000000 AS DateTime), CAST(0x00008BBC00000000 AS DateTime), CAST(0x00008B9800000000 AS DateTime), 1, CAST(74.58000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10723, N'WHITC', 3, CAST(0x00008B9300000000 AS DateTime), CAST(0x00008BAF00000000 AS DateTime), CAST(0x00008BAD00000000 AS DateTime), 1, CAST(21.72000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10724, N'MEREP', 8, CAST(0x00008B9300000000 AS DateTime), CAST(0x00008BBD00000000 AS DateTime), CAST(0x00008B9900000000 AS DateTime), 2, CAST(57.75000 AS Decimal(19, 5)), N'Mère Paillarde', N'43 rue St. Laurent', N'Montréal', N'Québec', N'H1J 1C3', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10725, N'FAMIA', 4, CAST(0x00008B9400000000 AS DateTime), CAST(0x00008BB000000000 AS DateTime), CAST(0x00008B9900000000 AS DateTime), 3, CAST(10.83000 AS Decimal(19, 5)), N'Familia Arquibaldo', N'Rua Orós, 92', N'Sao Paulo', N'SP', N'05442-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10726, N'EASTC', 4, CAST(0x00008B9700000000 AS DateTime), CAST(0x00008BA500000000 AS DateTime), CAST(0x00008BB700000000 AS DateTime), 1, CAST(16.56000 AS Decimal(19, 5)), N'Eastern Connection', N'35 King George', N'London', N'null', N'WX3 6FW', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10727, N'REGGC', 2, CAST(0x00008B9700000000 AS DateTime), CAST(0x00008BB300000000 AS DateTime), CAST(0x00008BB700000000 AS DateTime), 1, CAST(89.90000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10728, N'QUEEN', 4, CAST(0x00008B9800000000 AS DateTime), CAST(0x00008BB400000000 AS DateTime), CAST(0x00008B9F00000000 AS DateTime), 2, CAST(58.33000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10729, N'LINOD', 8, CAST(0x00008B9800000000 AS DateTime), CAST(0x00008BC200000000 AS DateTime), CAST(0x00008BA200000000 AS DateTime), 3, CAST(141.06000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10730, N'BONAP', 5, CAST(0x00008B9900000000 AS DateTime), CAST(0x00008BB500000000 AS DateTime), CAST(0x00008BA200000000 AS DateTime), 1, CAST(20.12000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10731, N'CHOPS', 7, CAST(0x00008B9A00000000 AS DateTime), CAST(0x00008BB600000000 AS DateTime), CAST(0x00008BA200000000 AS DateTime), 1, CAST(96.65000 AS Decimal(19, 5)), N'Chop-suey Chinese', N'Hauptstr. 31', N'Bern', N'null', N'3012', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10732, N'BONAP', 3, CAST(0x00008B9A00000000 AS DateTime), CAST(0x00008BB600000000 AS DateTime), CAST(0x00008B9B00000000 AS DateTime), 1, CAST(16.97000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10733, N'BERGS', 1, CAST(0x00008B9B00000000 AS DateTime), CAST(0x00008BB700000000 AS DateTime), CAST(0x00008B9E00000000 AS DateTime), 3, CAST(110.11000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10734, N'GOURL', 2, CAST(0x00008B9B00000000 AS DateTime), CAST(0x00008BB700000000 AS DateTime), CAST(0x00008BA000000000 AS DateTime), 3, CAST(1.63000 AS Decimal(19, 5)), N'Gourmet Lanchonetes', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10735, N'LETSS', 6, CAST(0x00008B9E00000000 AS DateTime), CAST(0x00008BBA00000000 AS DateTime), CAST(0x00008BA900000000 AS DateTime), 2, CAST(45.97000 AS Decimal(19, 5)), N'Let''s Stop N Shop', N'87 Polk St. Suite 5', N'San Francisco', N'CA', N'94117', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10736, N'HUNGO', 9, CAST(0x00008B9F00000000 AS DateTime), CAST(0x00008BBB00000000 AS DateTime), CAST(0x00008BA900000000 AS DateTime), 2, CAST(44.10000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10737, N'VINET', 2, CAST(0x00008B9F00000000 AS DateTime), CAST(0x00008BBB00000000 AS DateTime), CAST(0x00008BA600000000 AS DateTime), 2, CAST(7.79000 AS Decimal(19, 5)), N'Vins et alcools Chevalier', N'59 rue de l''Abbaye', N'Reims', N'null', N'51100', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10738, N'SPECD', 2, CAST(0x00008BA000000000 AS DateTime), CAST(0x00008BBC00000000 AS DateTime), CAST(0x00008BA600000000 AS DateTime), 1, CAST(2.91000 AS Decimal(19, 5)), N'Spécialités du monde', N'25, rue Lauriston', N'Paris', N'null', N'75016', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10739, N'VINET', 3, CAST(0x00008BA000000000 AS DateTime), CAST(0x00008BBC00000000 AS DateTime), CAST(0x00008BA500000000 AS DateTime), 3, CAST(11.08000 AS Decimal(19, 5)), N'Vins et alcools Chevalier', N'59 rue de l''Abbaye', N'Reims', N'null', N'51100', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10740, N'WHITC', 4, CAST(0x00008BA100000000 AS DateTime), CAST(0x00008BBD00000000 AS DateTime), CAST(0x00008BAD00000000 AS DateTime), 2, CAST(81.88000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10741, N'AROUT', 4, CAST(0x00008BA200000000 AS DateTime), CAST(0x00008BB000000000 AS DateTime), CAST(0x00008BA600000000 AS DateTime), 3, CAST(10.96000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10742, N'BOTTM', 3, CAST(0x00008BA200000000 AS DateTime), CAST(0x00008BBE00000000 AS DateTime), CAST(0x00008BA600000000 AS DateTime), 3, CAST(243.73000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10743, N'AROUT', 1, CAST(0x00008BA500000000 AS DateTime), CAST(0x00008BC100000000 AS DateTime), CAST(0x00008BA900000000 AS DateTime), 2, CAST(23.72000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10744, N'VAFFE', 6, CAST(0x00008BA500000000 AS DateTime), CAST(0x00008BC100000000 AS DateTime), CAST(0x00008BAC00000000 AS DateTime), 1, CAST(69.19000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10745, N'QUICK', 9, CAST(0x00008BA600000000 AS DateTime), CAST(0x00008BC200000000 AS DateTime), CAST(0x00008BAF00000000 AS DateTime), 1, CAST(3.52000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10746, N'CHOPS', 1, CAST(0x00008BA700000000 AS DateTime), CAST(0x00008BC300000000 AS DateTime), CAST(0x00008BA900000000 AS DateTime), 3, CAST(31.43000 AS Decimal(19, 5)), N'Chop-suey Chinese', N'Hauptstr. 31', N'Bern', N'null', N'3012', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10747, N'PICCO', 6, CAST(0x00008BA700000000 AS DateTime), CAST(0x00008BC300000000 AS DateTime), CAST(0x00008BAE00000000 AS DateTime), 1, CAST(117.33000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10748, N'SAVEA', 3, CAST(0x00008BA800000000 AS DateTime), CAST(0x00008BC400000000 AS DateTime), CAST(0x00008BB000000000 AS DateTime), 1, CAST(232.55000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10749, N'ISLAT', 4, CAST(0x00008BA800000000 AS DateTime), CAST(0x00008BC400000000 AS DateTime), CAST(0x00008BC500000000 AS DateTime), 2, CAST(61.53000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10750, N'WARTH', 9, CAST(0x00008BA900000000 AS DateTime), CAST(0x00008BC500000000 AS DateTime), CAST(0x00008BAC00000000 AS DateTime), 1, CAST(79.30000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10751, N'RICSU', 3, CAST(0x00008BAC00000000 AS DateTime), CAST(0x00008BC800000000 AS DateTime), CAST(0x00008BB500000000 AS DateTime), 3, CAST(130.79000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10752, N'NORTS', 2, CAST(0x00008BAC00000000 AS DateTime), CAST(0x00008BC800000000 AS DateTime), CAST(0x00008BB000000000 AS DateTime), 3, CAST(1.39000 AS Decimal(19, 5)), N'North/South', N'South House 300 Queensbridge', N'London', N'null', N'SW7 1RZ', N'UK')
GO
print 'Processed 500 total records'
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10753, N'FRANS', 3, CAST(0x00008BAD00000000 AS DateTime), CAST(0x00008BC900000000 AS DateTime), CAST(0x00008BAF00000000 AS DateTime), 1, CAST(7.70000 AS Decimal(19, 5)), N'Franchi S.p.A.', N'Via Monte Bianco 34', N'Torino', N'null', N'10100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10754, N'MAGAA', 6, CAST(0x00008BAD00000000 AS DateTime), CAST(0x00008BC900000000 AS DateTime), CAST(0x00008BAF00000000 AS DateTime), 3, CAST(2.38000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10755, N'BONAP', 4, CAST(0x00008BAE00000000 AS DateTime), CAST(0x00008BCA00000000 AS DateTime), CAST(0x00008BB000000000 AS DateTime), 2, CAST(16.71000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10756, N'SPLIR', 8, CAST(0x00008BAF00000000 AS DateTime), CAST(0x00008BCB00000000 AS DateTime), CAST(0x00008BB400000000 AS DateTime), 2, CAST(73.21000 AS Decimal(19, 5)), N'Split Rail Beer & Ale', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10757, N'SAVEA', 6, CAST(0x00008BAF00000000 AS DateTime), CAST(0x00008BCB00000000 AS DateTime), CAST(0x00008BC100000000 AS DateTime), 1, CAST(8.19000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10758, N'RICSU', 3, CAST(0x00008BB000000000 AS DateTime), CAST(0x00008BCC00000000 AS DateTime), CAST(0x00008BB600000000 AS DateTime), 3, CAST(138.17000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10759, N'ANATR', 3, CAST(0x00008BB000000000 AS DateTime), CAST(0x00008BCC00000000 AS DateTime), CAST(0x00008BBE00000000 AS DateTime), 3, CAST(11.99000 AS Decimal(19, 5)), N'Ana Trujillo Emparedados y helados', N'Avda. de la Constitución 2222', N'México D.F.', N'null', N'05021', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10760, N'MAISD', 4, CAST(0x00008BB300000000 AS DateTime), CAST(0x00008BCF00000000 AS DateTime), CAST(0x00008BBC00000000 AS DateTime), 1, CAST(155.64000 AS Decimal(19, 5)), N'Maison Dewey', N'Rue Joseph-Bens 532', N'Bruxelles', N'null', N'B-1180', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10761, N'RATTC', 5, CAST(0x00008BB400000000 AS DateTime), CAST(0x00008BD000000000 AS DateTime), CAST(0x00008BBA00000000 AS DateTime), 2, CAST(18.66000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10762, N'FOLKO', 3, CAST(0x00008BB400000000 AS DateTime), CAST(0x00008BD000000000 AS DateTime), CAST(0x00008BBB00000000 AS DateTime), 1, CAST(328.74000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10763, N'FOLIG', 3, CAST(0x00008BB500000000 AS DateTime), CAST(0x00008BD100000000 AS DateTime), CAST(0x00008BBA00000000 AS DateTime), 3, CAST(37.35000 AS Decimal(19, 5)), N'Folies gourmandes', N'184, chaussée de Tournai', N'Lille', N'null', N'59000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10764, N'ERNSH', 6, CAST(0x00008BB500000000 AS DateTime), CAST(0x00008BD100000000 AS DateTime), CAST(0x00008BBA00000000 AS DateTime), 3, CAST(145.45000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10765, N'QUICK', 3, CAST(0x00008BB600000000 AS DateTime), CAST(0x00008BD200000000 AS DateTime), CAST(0x00008BBB00000000 AS DateTime), 3, CAST(42.74000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10766, N'OTTIK', 4, CAST(0x00008BB700000000 AS DateTime), CAST(0x00008BD300000000 AS DateTime), CAST(0x00008BBB00000000 AS DateTime), 1, CAST(157.55000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10767, N'SUPRD', 4, CAST(0x00008BB700000000 AS DateTime), CAST(0x00008BD300000000 AS DateTime), CAST(0x00008BC100000000 AS DateTime), 3, CAST(1.59000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10768, N'AROUT', 3, CAST(0x00008BBA00000000 AS DateTime), CAST(0x00008BD600000000 AS DateTime), CAST(0x00008BC100000000 AS DateTime), 2, CAST(146.32000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10769, N'VAFFE', 3, CAST(0x00008BBA00000000 AS DateTime), CAST(0x00008BD600000000 AS DateTime), CAST(0x00008BBE00000000 AS DateTime), 1, CAST(65.06000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10770, N'HANAR', 8, CAST(0x00008BBB00000000 AS DateTime), CAST(0x00008BD700000000 AS DateTime), CAST(0x00008BC300000000 AS DateTime), 3, CAST(5.32000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10771, N'ERNSH', 9, CAST(0x00008BBC00000000 AS DateTime), CAST(0x00008BD800000000 AS DateTime), CAST(0x00008BD300000000 AS DateTime), 2, CAST(11.19000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10772, N'LEHMS', 3, CAST(0x00008BBC00000000 AS DateTime), CAST(0x00008BD800000000 AS DateTime), CAST(0x00008BC500000000 AS DateTime), 2, CAST(91.28000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10773, N'ERNSH', 1, CAST(0x00008BBD00000000 AS DateTime), CAST(0x00008BD900000000 AS DateTime), CAST(0x00008BC200000000 AS DateTime), 3, CAST(96.43000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10774, N'FOLKO', 4, CAST(0x00008BBD00000000 AS DateTime), CAST(0x00008BCB00000000 AS DateTime), CAST(0x00008BBE00000000 AS DateTime), 1, CAST(48.20000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10775, N'THECR', 7, CAST(0x00008BBE00000000 AS DateTime), CAST(0x00008BDA00000000 AS DateTime), CAST(0x00008BCC00000000 AS DateTime), 1, CAST(20.25000 AS Decimal(19, 5)), N'The Cracker Box', N'55 Grizzly Peak Rd.', N'Butte', N'MT', N'59801', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10776, N'ERNSH', 1, CAST(0x00008BC100000000 AS DateTime), CAST(0x00008BDD00000000 AS DateTime), CAST(0x00008BC400000000 AS DateTime), 3, CAST(351.53000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10777, N'GOURL', 7, CAST(0x00008BC100000000 AS DateTime), CAST(0x00008BCF00000000 AS DateTime), CAST(0x00008BE600000000 AS DateTime), 2, CAST(3.01000 AS Decimal(19, 5)), N'Gourmet Lanchonetes', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10778, N'BERGS', 3, CAST(0x00008BC200000000 AS DateTime), CAST(0x00008BDE00000000 AS DateTime), CAST(0x00008BCA00000000 AS DateTime), 1, CAST(6.79000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10779, N'MORGK', 3, CAST(0x00008BC200000000 AS DateTime), CAST(0x00008BDE00000000 AS DateTime), CAST(0x00008BDF00000000 AS DateTime), 2, CAST(58.13000 AS Decimal(19, 5)), N'Morgenstern Gesundkost', N'Heerstr. 22', N'Leipzig', N'null', N'04179', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10780, N'LILAS', 2, CAST(0x00008BC200000000 AS DateTime), CAST(0x00008BD000000000 AS DateTime), CAST(0x00008BCB00000000 AS DateTime), 1, CAST(42.13000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10781, N'WARTH', 2, CAST(0x00008BC300000000 AS DateTime), CAST(0x00008BDF00000000 AS DateTime), CAST(0x00008BC500000000 AS DateTime), 3, CAST(73.16000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10782, N'CACTU', 9, CAST(0x00008BC300000000 AS DateTime), CAST(0x00008BDF00000000 AS DateTime), CAST(0x00008BC800000000 AS DateTime), 3, CAST(1.10000 AS Decimal(19, 5)), N'Cactus Comidas para llevar', N'Cerrito 333', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10783, N'HANAR', 4, CAST(0x00008BC400000000 AS DateTime), CAST(0x00008BE000000000 AS DateTime), CAST(0x00008BC500000000 AS DateTime), 2, CAST(124.98000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10784, N'MAGAA', 4, CAST(0x00008BC400000000 AS DateTime), CAST(0x00008BE000000000 AS DateTime), CAST(0x00008BC800000000 AS DateTime), 3, CAST(70.09000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10785, N'GROSR', 1, CAST(0x00008BC400000000 AS DateTime), CAST(0x00008BE000000000 AS DateTime), CAST(0x00008BCA00000000 AS DateTime), 3, CAST(1.51000 AS Decimal(19, 5)), N'GROSELLA-Restaurante', N'5ª Ave. Los Palos Grandes', N'Caracas', N'DF', N'1081', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10786, N'QUEEN', 8, CAST(0x00008BC500000000 AS DateTime), CAST(0x00008BE100000000 AS DateTime), CAST(0x00008BC900000000 AS DateTime), 1, CAST(110.87000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10787, N'LAMAI', 2, CAST(0x00008BC500000000 AS DateTime), CAST(0x00008BD300000000 AS DateTime), CAST(0x00008BCC00000000 AS DateTime), 1, CAST(249.93000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10788, N'QUICK', 1, CAST(0x00008BC800000000 AS DateTime), CAST(0x00008BE400000000 AS DateTime), CAST(0x00008BE400000000 AS DateTime), 2, CAST(42.70000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10789, N'FOLIG', 1, CAST(0x00008BC800000000 AS DateTime), CAST(0x00008BE400000000 AS DateTime), CAST(0x00008BD100000000 AS DateTime), 2, CAST(100.60000 AS Decimal(19, 5)), N'Folies gourmandes', N'184, chaussée de Tournai', N'Lille', N'null', N'59000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10790, N'GOURL', 6, CAST(0x00008BC800000000 AS DateTime), CAST(0x00008BE400000000 AS DateTime), CAST(0x00008BCC00000000 AS DateTime), 1, CAST(28.23000 AS Decimal(19, 5)), N'Gourmet Lanchonetes', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10791, N'FRANK', 6, CAST(0x00008BC900000000 AS DateTime), CAST(0x00008BE500000000 AS DateTime), CAST(0x00008BD200000000 AS DateTime), 2, CAST(16.85000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10792, N'WOLZA', 1, CAST(0x00008BC900000000 AS DateTime), CAST(0x00008BE500000000 AS DateTime), CAST(0x00008BD100000000 AS DateTime), 3, CAST(23.79000 AS Decimal(19, 5)), N'Wolski Zajazd', N'ul. Filtrowa 68', N'Warszawa', N'null', N'01-012', N'Poland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10793, N'AROUT', 3, CAST(0x00008BCA00000000 AS DateTime), CAST(0x00008BE600000000 AS DateTime), CAST(0x00008BD900000000 AS DateTime), 3, CAST(4.52000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10794, N'QUEDE', 6, CAST(0x00008BCA00000000 AS DateTime), CAST(0x00008BE600000000 AS DateTime), CAST(0x00008BD300000000 AS DateTime), 1, CAST(21.49000 AS Decimal(19, 5)), N'Que Delícia', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10795, N'ERNSH', 8, CAST(0x00008BCA00000000 AS DateTime), CAST(0x00008BE600000000 AS DateTime), CAST(0x00008BE500000000 AS DateTime), 2, CAST(126.66000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10796, N'HILAA', 3, CAST(0x00008BCB00000000 AS DateTime), CAST(0x00008BE700000000 AS DateTime), CAST(0x00008BDF00000000 AS DateTime), 1, CAST(26.52000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10797, N'DRACD', 7, CAST(0x00008BCB00000000 AS DateTime), CAST(0x00008BE700000000 AS DateTime), CAST(0x00008BD600000000 AS DateTime), 2, CAST(33.35000 AS Decimal(19, 5)), N'Drachenblut Delikatessen', N'Walserweg 21', N'Aachen', N'null', N'52066', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10798, N'ISLAT', 2, CAST(0x00008BCC00000000 AS DateTime), CAST(0x00008BE800000000 AS DateTime), CAST(0x00008BD600000000 AS DateTime), 1, CAST(2.33000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10799, N'KOENE', 9, CAST(0x00008BCC00000000 AS DateTime), CAST(0x00008BF600000000 AS DateTime), CAST(0x00008BD600000000 AS DateTime), 3, CAST(30.76000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10800, N'SEVES', 1, CAST(0x00008BCC00000000 AS DateTime), CAST(0x00008BE800000000 AS DateTime), CAST(0x00008BD600000000 AS DateTime), 3, CAST(137.44000 AS Decimal(19, 5)), N'Seven Seas Imports', N'90 Wadhurst Rd.', N'London', N'null', N'OX15 4NB', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10801, N'BOLID', 4, CAST(0x00008BCF00000000 AS DateTime), CAST(0x00008BEB00000000 AS DateTime), CAST(0x00008BD100000000 AS DateTime), 2, CAST(97.09000 AS Decimal(19, 5)), N'Bólido Comidas preparadas', N'C/ Araquil, 67', N'Madrid', N'null', N'28023', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10802, N'SIMOB', 4, CAST(0x00008BCF00000000 AS DateTime), CAST(0x00008BEB00000000 AS DateTime), CAST(0x00008BD300000000 AS DateTime), 2, CAST(257.26000 AS Decimal(19, 5)), N'Simons bistro', N'Vinbæltet 34', N'Kobenhavn', N'null', N'1734', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10803, N'WELLI', 4, CAST(0x00008BD000000000 AS DateTime), CAST(0x00008BEC00000000 AS DateTime), CAST(0x00008BD700000000 AS DateTime), 1, CAST(55.23000 AS Decimal(19, 5)), N'Wellington Importadora', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10804, N'SEVES', 6, CAST(0x00008BD000000000 AS DateTime), CAST(0x00008BEC00000000 AS DateTime), CAST(0x00008BD800000000 AS DateTime), 2, CAST(27.33000 AS Decimal(19, 5)), N'Seven Seas Imports', N'90 Wadhurst Rd.', N'London', N'null', N'OX15 4NB', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10805, N'THEBI', 2, CAST(0x00008BD000000000 AS DateTime), CAST(0x00008BEC00000000 AS DateTime), CAST(0x00008BDA00000000 AS DateTime), 3, CAST(237.34000 AS Decimal(19, 5)), N'The Big Cheese', N'89 Jefferson Way Suite 2', N'Portland', N'OR', N'97201', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10806, N'VICTE', 3, CAST(0x00008BD100000000 AS DateTime), CAST(0x00008BED00000000 AS DateTime), CAST(0x00008BD600000000 AS DateTime), 2, CAST(22.11000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10807, N'FRANS', 4, CAST(0x00008BD100000000 AS DateTime), CAST(0x00008BED00000000 AS DateTime), CAST(0x00008BEF00000000 AS DateTime), 1, CAST(1.36000 AS Decimal(19, 5)), N'Franchi S.p.A.', N'Via Monte Bianco 34', N'Torino', N'null', N'10100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10808, N'OLDWO', 2, CAST(0x00008BD200000000 AS DateTime), CAST(0x00008BEE00000000 AS DateTime), CAST(0x00008BDA00000000 AS DateTime), 3, CAST(45.53000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10809, N'WELLI', 7, CAST(0x00008BD200000000 AS DateTime), CAST(0x00008BEE00000000 AS DateTime), CAST(0x00008BD800000000 AS DateTime), 1, CAST(4.87000 AS Decimal(19, 5)), N'Wellington Importadora', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10810, N'LAUGB', 2, CAST(0x00008BD200000000 AS DateTime), CAST(0x00008BEE00000000 AS DateTime), CAST(0x00008BD800000000 AS DateTime), 3, CAST(4.33000 AS Decimal(19, 5)), N'Laughing Bacchus Wine Cellars', N'2319 Elm St.', N'Vancouver', N'BC', N'V3F 2K1', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10811, N'LINOD', 8, CAST(0x00008BD300000000 AS DateTime), CAST(0x00008BEF00000000 AS DateTime), CAST(0x00008BD900000000 AS DateTime), 1, CAST(31.22000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10812, N'REGGC', 5, CAST(0x00008BD300000000 AS DateTime), CAST(0x00008BEF00000000 AS DateTime), CAST(0x00008BDD00000000 AS DateTime), 1, CAST(59.78000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10813, N'RICAR', 1, CAST(0x00008BD600000000 AS DateTime), CAST(0x00008BF200000000 AS DateTime), CAST(0x00008BDA00000000 AS DateTime), 1, CAST(47.38000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10814, N'VICTE', 3, CAST(0x00008BD600000000 AS DateTime), CAST(0x00008BF200000000 AS DateTime), CAST(0x00008BDF00000000 AS DateTime), 3, CAST(130.94000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10815, N'SAVEA', 2, CAST(0x00008BD600000000 AS DateTime), CAST(0x00008BF200000000 AS DateTime), CAST(0x00008BDF00000000 AS DateTime), 3, CAST(14.62000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10816, N'GREAL', 4, CAST(0x00008BD700000000 AS DateTime), CAST(0x00008BF300000000 AS DateTime), CAST(0x00008BF400000000 AS DateTime), 2, CAST(719.78000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10817, N'KOENE', 3, CAST(0x00008BD700000000 AS DateTime), CAST(0x00008BE500000000 AS DateTime), CAST(0x00008BDE00000000 AS DateTime), 2, CAST(306.07000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10818, N'MAGAA', 7, CAST(0x00008BD800000000 AS DateTime), CAST(0x00008BF400000000 AS DateTime), CAST(0x00008BDD00000000 AS DateTime), 3, CAST(65.48000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10819, N'CACTU', 2, CAST(0x00008BD800000000 AS DateTime), CAST(0x00008BF400000000 AS DateTime), CAST(0x00008BE100000000 AS DateTime), 3, CAST(19.76000 AS Decimal(19, 5)), N'Cactus Comidas para llevar', N'Cerrito 333', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10820, N'RATTC', 3, CAST(0x00008BD800000000 AS DateTime), CAST(0x00008BF400000000 AS DateTime), CAST(0x00008BDE00000000 AS DateTime), 2, CAST(37.52000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10821, N'SPLIR', 1, CAST(0x00008BD900000000 AS DateTime), CAST(0x00008BF500000000 AS DateTime), CAST(0x00008BE000000000 AS DateTime), 1, CAST(36.68000 AS Decimal(19, 5)), N'Split Rail Beer & Ale', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10822, N'TRAIH', 6, CAST(0x00008BD900000000 AS DateTime), CAST(0x00008BF500000000 AS DateTime), CAST(0x00008BE100000000 AS DateTime), 3, CAST(7.00000 AS Decimal(19, 5)), N'Trail''s Head Gourmet Provisioners', N'722 DaVinci Blvd.', N'Kirkland', N'WA', N'98034', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10823, N'LILAS', 5, CAST(0x00008BDA00000000 AS DateTime), CAST(0x00008BF600000000 AS DateTime), CAST(0x00008BDE00000000 AS DateTime), 2, CAST(163.97000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10824, N'FOLKO', 8, CAST(0x00008BDA00000000 AS DateTime), CAST(0x00008BF600000000 AS DateTime), CAST(0x00008BEF00000000 AS DateTime), 1, CAST(1.23000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10825, N'DRACD', 1, CAST(0x00008BDA00000000 AS DateTime), CAST(0x00008BF600000000 AS DateTime), CAST(0x00008BDF00000000 AS DateTime), 1, CAST(79.25000 AS Decimal(19, 5)), N'Drachenblut Delikatessen', N'Walserweg 21', N'Aachen', N'null', N'52066', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10826, N'BLONP', 6, CAST(0x00008BDD00000000 AS DateTime), CAST(0x00008BF900000000 AS DateTime), CAST(0x00008BF600000000 AS DateTime), 1, CAST(7.09000 AS Decimal(19, 5)), N'Blondel père et fils', N'24, place Kléber', N'Strasbourg', N'null', N'67000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10827, N'BONAP', 1, CAST(0x00008BDD00000000 AS DateTime), CAST(0x00008BEB00000000 AS DateTime), CAST(0x00008BF600000000 AS DateTime), 2, CAST(63.54000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10828, N'RANCH', 9, CAST(0x00008BDE00000000 AS DateTime), CAST(0x00008BEC00000000 AS DateTime), CAST(0x00008BF400000000 AS DateTime), 1, CAST(90.85000 AS Decimal(19, 5)), N'Rancho grande', N'Av. del Libertador 900', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10829, N'ISLAT', 9, CAST(0x00008BDE00000000 AS DateTime), CAST(0x00008BFA00000000 AS DateTime), CAST(0x00008BE800000000 AS DateTime), 1, CAST(154.72000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10830, N'TRADH', 4, CAST(0x00008BDE00000000 AS DateTime), CAST(0x00008C0800000000 AS DateTime), CAST(0x00008BE600000000 AS DateTime), 2, CAST(81.83000 AS Decimal(19, 5)), N'Tradiçao Hipermercados', N'Av. Inês de Castro, 414', N'Sao Paulo', N'SP', N'05634-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10831, N'SANTG', 3, CAST(0x00008BDF00000000 AS DateTime), CAST(0x00008BFB00000000 AS DateTime), CAST(0x00008BE800000000 AS DateTime), 2, CAST(72.19000 AS Decimal(19, 5)), N'Santé Gourmet', N'Erling Skakkes gate 78', N'Stavern', N'null', N'4110', N'Norway')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10832, N'LAMAI', 2, CAST(0x00008BDF00000000 AS DateTime), CAST(0x00008BFB00000000 AS DateTime), CAST(0x00008BE400000000 AS DateTime), 2, CAST(43.26000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10833, N'OTTIK', 6, CAST(0x00008BE000000000 AS DateTime), CAST(0x00008BFC00000000 AS DateTime), CAST(0x00008BE800000000 AS DateTime), 2, CAST(71.49000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10834, N'TRADH', 1, CAST(0x00008BE000000000 AS DateTime), CAST(0x00008BFC00000000 AS DateTime), CAST(0x00008BE400000000 AS DateTime), 3, CAST(29.78000 AS Decimal(19, 5)), N'Tradiçao Hipermercados', N'Av. Inês de Castro, 414', N'Sao Paulo', N'SP', N'05634-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10835, N'ALFKI', 1, CAST(0x00008BE000000000 AS DateTime), CAST(0x00008BFC00000000 AS DateTime), CAST(0x00008BE600000000 AS DateTime), 3, CAST(69.53000 AS Decimal(19, 5)), N'Alfred''s Futterkiste', N'Obere Str. 57', N'Berlin', N'null', N'12209', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10836, N'ERNSH', 7, CAST(0x00008BE100000000 AS DateTime), CAST(0x00008BFD00000000 AS DateTime), CAST(0x00008BE600000000 AS DateTime), 1, CAST(411.88000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10837, N'BERGS', 9, CAST(0x00008BE100000000 AS DateTime), CAST(0x00008BFD00000000 AS DateTime), CAST(0x00008BE800000000 AS DateTime), 3, CAST(13.32000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10838, N'LINOD', 3, CAST(0x00008BE400000000 AS DateTime), CAST(0x00008C0000000000 AS DateTime), CAST(0x00008BE800000000 AS DateTime), 3, CAST(59.28000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10839, N'TRADH', 3, CAST(0x00008BE400000000 AS DateTime), CAST(0x00008C0000000000 AS DateTime), CAST(0x00008BE700000000 AS DateTime), 3, CAST(35.43000 AS Decimal(19, 5)), N'Tradiçao Hipermercados', N'Av. Inês de Castro, 414', N'Sao Paulo', N'SP', N'05634-030', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10840, N'LINOD', 4, CAST(0x00008BE400000000 AS DateTime), CAST(0x00008C0E00000000 AS DateTime), CAST(0x00008C0000000000 AS DateTime), 2, CAST(2.71000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10841, N'SUPRD', 5, CAST(0x00008BE500000000 AS DateTime), CAST(0x00008C0100000000 AS DateTime), CAST(0x00008BEE00000000 AS DateTime), 2, CAST(424.30000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10842, N'TORTU', 1, CAST(0x00008BE500000000 AS DateTime), CAST(0x00008C0100000000 AS DateTime), CAST(0x00008BEE00000000 AS DateTime), 3, CAST(54.42000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10843, N'VICTE', 4, CAST(0x00008BE600000000 AS DateTime), CAST(0x00008C0200000000 AS DateTime), CAST(0x00008BEB00000000 AS DateTime), 2, CAST(9.26000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10844, N'PICCO', 8, CAST(0x00008BE600000000 AS DateTime), CAST(0x00008C0200000000 AS DateTime), CAST(0x00008BEB00000000 AS DateTime), 2, CAST(25.22000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10845, N'QUICK', 8, CAST(0x00008BE600000000 AS DateTime), CAST(0x00008BF400000000 AS DateTime), CAST(0x00008BEF00000000 AS DateTime), 1, CAST(212.98000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10846, N'SUPRD', 2, CAST(0x00008BE700000000 AS DateTime), CAST(0x00008C1100000000 AS DateTime), CAST(0x00008BE800000000 AS DateTime), 3, CAST(56.46000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10847, N'SAVEA', 4, CAST(0x00008BE700000000 AS DateTime), CAST(0x00008BF500000000 AS DateTime), CAST(0x00008BFA00000000 AS DateTime), 3, CAST(487.57000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10848, N'CONSH', 7, CAST(0x00008BE800000000 AS DateTime), CAST(0x00008C0400000000 AS DateTime), CAST(0x00008BEE00000000 AS DateTime), 2, CAST(38.24000 AS Decimal(19, 5)), N'Consolidated Holdings', N'Berkeley Gardens 12  Brewery', N'London', N'null', N'WX1 6LT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10849, N'KOENE', 9, CAST(0x00008BE800000000 AS DateTime), CAST(0x00008C0400000000 AS DateTime), CAST(0x00008BEF00000000 AS DateTime), 2, CAST(0.56000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10850, N'VICTE', 1, CAST(0x00008BE800000000 AS DateTime), CAST(0x00008C1200000000 AS DateTime), CAST(0x00008BEF00000000 AS DateTime), 1, CAST(49.19000 AS Decimal(19, 5)), N'Victuailles en stock', N'2, rue du Commerce', N'Lyon', N'null', N'69004', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10851, N'RICAR', 5, CAST(0x00008BEB00000000 AS DateTime), CAST(0x00008C0700000000 AS DateTime), CAST(0x00008BF200000000 AS DateTime), 1, CAST(160.55000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10852, N'RATTC', 8, CAST(0x00008BEB00000000 AS DateTime), CAST(0x00008BF900000000 AS DateTime), CAST(0x00008BEF00000000 AS DateTime), 1, CAST(174.05000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10853, N'BLAUS', 9, CAST(0x00008BEC00000000 AS DateTime), CAST(0x00008C0800000000 AS DateTime), CAST(0x00008BF300000000 AS DateTime), 2, CAST(53.83000 AS Decimal(19, 5)), N'Blauer See Delikatessen', N'Forsterstr. 57', N'Mannheim', N'null', N'68306', N'Germany')
GO
print 'Processed 600 total records'
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10854, N'ERNSH', 3, CAST(0x00008BEC00000000 AS DateTime), CAST(0x00008C0800000000 AS DateTime), CAST(0x00008BF500000000 AS DateTime), 2, CAST(100.22000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10855, N'OLDWO', 3, CAST(0x00008BEC00000000 AS DateTime), CAST(0x00008C0800000000 AS DateTime), CAST(0x00008BF400000000 AS DateTime), 1, CAST(170.97000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10856, N'ANTON', 3, CAST(0x00008BED00000000 AS DateTime), CAST(0x00008C0900000000 AS DateTime), CAST(0x00008BFA00000000 AS DateTime), 2, CAST(58.43000 AS Decimal(19, 5)), N'Antonio Moreno Taquería', N'Mataderos  2312', N'México D.F.', N'null', N'05023', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10857, N'BERGS', 8, CAST(0x00008BED00000000 AS DateTime), CAST(0x00008C0900000000 AS DateTime), CAST(0x00008BF600000000 AS DateTime), 2, CAST(188.85000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10858, N'LACOR', 2, CAST(0x00008BEE00000000 AS DateTime), CAST(0x00008C0A00000000 AS DateTime), CAST(0x00008BF300000000 AS DateTime), 1, CAST(52.51000 AS Decimal(19, 5)), N'La corne d''abondance', N'67, avenue de l''Europe', N'Versailles', N'null', N'78000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10859, N'FRANK', 1, CAST(0x00008BEE00000000 AS DateTime), CAST(0x00008C0A00000000 AS DateTime), CAST(0x00008BF200000000 AS DateTime), 2, CAST(76.10000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10860, N'FRANR', 3, CAST(0x00008BEE00000000 AS DateTime), CAST(0x00008C0A00000000 AS DateTime), CAST(0x00008BF400000000 AS DateTime), 3, CAST(19.26000 AS Decimal(19, 5)), N'France restauration', N'54, rue Royale', N'Nantes', N'null', N'44000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10861, N'WHITC', 4, CAST(0x00008BEF00000000 AS DateTime), CAST(0x00008C0B00000000 AS DateTime), CAST(0x00008C0100000000 AS DateTime), 2, CAST(14.93000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10862, N'LEHMS', 8, CAST(0x00008BEF00000000 AS DateTime), CAST(0x00008C1900000000 AS DateTime), CAST(0x00008BF200000000 AS DateTime), 2, CAST(53.23000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10863, N'HILAA', 4, CAST(0x00008BF200000000 AS DateTime), CAST(0x00008C0E00000000 AS DateTime), CAST(0x00008C0100000000 AS DateTime), 2, CAST(30.26000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10864, N'AROUT', 4, CAST(0x00008BF200000000 AS DateTime), CAST(0x00008C0E00000000 AS DateTime), CAST(0x00008BF900000000 AS DateTime), 2, CAST(3.04000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10865, N'QUICK', 2, CAST(0x00008BF200000000 AS DateTime), CAST(0x00008C0000000000 AS DateTime), CAST(0x00008BFC00000000 AS DateTime), 1, CAST(348.14000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10866, N'BERGS', 5, CAST(0x00008BF300000000 AS DateTime), CAST(0x00008C0F00000000 AS DateTime), CAST(0x00008BFC00000000 AS DateTime), 1, CAST(109.11000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10867, N'LONEP', 6, CAST(0x00008BF300000000 AS DateTime), CAST(0x00008C1D00000000 AS DateTime), CAST(0x00008BFB00000000 AS DateTime), 1, CAST(1.93000 AS Decimal(19, 5)), N'Lonesome Pine Restaurant', N'89 Chiaroscuro Rd.', N'Portland', N'OR', N'97219', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10868, N'QUEEN', 7, CAST(0x00008BF400000000 AS DateTime), CAST(0x00008C1000000000 AS DateTime), CAST(0x00008C0700000000 AS DateTime), 2, CAST(191.27000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10869, N'SEVES', 5, CAST(0x00008BF400000000 AS DateTime), CAST(0x00008C1000000000 AS DateTime), CAST(0x00008BF900000000 AS DateTime), 1, CAST(143.28000 AS Decimal(19, 5)), N'Seven Seas Imports', N'90 Wadhurst Rd.', N'London', N'null', N'OX15 4NB', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10870, N'WOLZA', 5, CAST(0x00008BF400000000 AS DateTime), CAST(0x00008C1000000000 AS DateTime), CAST(0x00008BFD00000000 AS DateTime), 3, CAST(12.04000 AS Decimal(19, 5)), N'Wolski Zajazd', N'ul. Filtrowa 68', N'Warszawa', N'null', N'01-012', N'Poland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10871, N'BONAP', 9, CAST(0x00008BF500000000 AS DateTime), CAST(0x00008C1100000000 AS DateTime), CAST(0x00008BFA00000000 AS DateTime), 2, CAST(112.27000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10872, N'GODOS', 5, CAST(0x00008BF500000000 AS DateTime), CAST(0x00008C1100000000 AS DateTime), CAST(0x00008BF900000000 AS DateTime), 2, CAST(175.32000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10873, N'WILMK', 4, CAST(0x00008BF600000000 AS DateTime), CAST(0x00008C1200000000 AS DateTime), CAST(0x00008BF900000000 AS DateTime), 1, CAST(0.82000 AS Decimal(19, 5)), N'Wilman Kala', N'Keskuskatu 45', N'Helsinki', N'null', N'21240', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10874, N'GODOS', 5, CAST(0x00008BF600000000 AS DateTime), CAST(0x00008C1200000000 AS DateTime), CAST(0x00008BFB00000000 AS DateTime), 2, CAST(19.58000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10875, N'BERGS', 4, CAST(0x00008BF600000000 AS DateTime), CAST(0x00008C1200000000 AS DateTime), CAST(0x00008C0F00000000 AS DateTime), 2, CAST(32.37000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10876, N'BONAP', 7, CAST(0x00008BF900000000 AS DateTime), CAST(0x00008C1500000000 AS DateTime), CAST(0x00008BFC00000000 AS DateTime), 3, CAST(60.42000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10877, N'RICAR', 1, CAST(0x00008BF900000000 AS DateTime), CAST(0x00008C1500000000 AS DateTime), CAST(0x00008C0300000000 AS DateTime), 1, CAST(38.06000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10878, N'QUICK', 4, CAST(0x00008BFA00000000 AS DateTime), CAST(0x00008C1600000000 AS DateTime), CAST(0x00008BFC00000000 AS DateTime), 1, CAST(46.69000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10879, N'WILMK', 3, CAST(0x00008BFA00000000 AS DateTime), CAST(0x00008C1600000000 AS DateTime), CAST(0x00008BFC00000000 AS DateTime), 3, CAST(8.50000 AS Decimal(19, 5)), N'Wilman Kala', N'Keskuskatu 45', N'Helsinki', N'null', N'21240', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10880, N'FOLKO', 7, CAST(0x00008BFA00000000 AS DateTime), CAST(0x00008C2400000000 AS DateTime), CAST(0x00008C0200000000 AS DateTime), 1, CAST(88.01000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10881, N'CACTU', 4, CAST(0x00008BFB00000000 AS DateTime), CAST(0x00008C1700000000 AS DateTime), CAST(0x00008C0200000000 AS DateTime), 1, CAST(2.84000 AS Decimal(19, 5)), N'Cactus Comidas para llevar', N'Cerrito 333', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10882, N'SAVEA', 4, CAST(0x00008BFB00000000 AS DateTime), CAST(0x00008C1700000000 AS DateTime), CAST(0x00008C0400000000 AS DateTime), 3, CAST(23.10000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10883, N'LONEP', 8, CAST(0x00008BFC00000000 AS DateTime), CAST(0x00008C1800000000 AS DateTime), CAST(0x00008C0400000000 AS DateTime), 3, CAST(0.53000 AS Decimal(19, 5)), N'Lonesome Pine Restaurant', N'89 Chiaroscuro Rd.', N'Portland', N'OR', N'97219', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10884, N'LETSS', 4, CAST(0x00008BFC00000000 AS DateTime), CAST(0x00008C1800000000 AS DateTime), CAST(0x00008BFD00000000 AS DateTime), 2, CAST(90.97000 AS Decimal(19, 5)), N'Let''s Stop N Shop', N'87 Polk St. Suite 5', N'San Francisco', N'CA', N'94117', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10885, N'SUPRD', 6, CAST(0x00008BFC00000000 AS DateTime), CAST(0x00008C1800000000 AS DateTime), CAST(0x00008C0200000000 AS DateTime), 3, CAST(5.64000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10886, N'HANAR', 1, CAST(0x00008BFD00000000 AS DateTime), CAST(0x00008C1900000000 AS DateTime), CAST(0x00008C0E00000000 AS DateTime), 1, CAST(4.99000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10887, N'GALED', 8, CAST(0x00008BFD00000000 AS DateTime), CAST(0x00008C1900000000 AS DateTime), CAST(0x00008C0000000000 AS DateTime), 3, CAST(1.25000 AS Decimal(19, 5)), N'Galería del gastronómo', N'Rambla de Cataluña, 23', N'Barcelona', N'null', N'8022', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10888, N'GODOS', 1, CAST(0x00008C0000000000 AS DateTime), CAST(0x00008C1C00000000 AS DateTime), CAST(0x00008C0700000000 AS DateTime), 2, CAST(51.87000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10889, N'RATTC', 9, CAST(0x00008C0000000000 AS DateTime), CAST(0x00008C1C00000000 AS DateTime), CAST(0x00008C0700000000 AS DateTime), 3, CAST(280.61000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10890, N'DUMON', 7, CAST(0x00008C0000000000 AS DateTime), CAST(0x00008C1C00000000 AS DateTime), CAST(0x00008C0200000000 AS DateTime), 1, CAST(32.76000 AS Decimal(19, 5)), N'Du monde entier', N'67, rue des Cinquante Otages', N'Nantes', N'null', N'44000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10891, N'LEHMS', 7, CAST(0x00008C0100000000 AS DateTime), CAST(0x00008C1D00000000 AS DateTime), CAST(0x00008C0300000000 AS DateTime), 2, CAST(20.37000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10892, N'MAISD', 4, CAST(0x00008C0100000000 AS DateTime), CAST(0x00008C1D00000000 AS DateTime), CAST(0x00008C0300000000 AS DateTime), 2, CAST(120.27000 AS Decimal(19, 5)), N'Maison Dewey', N'Rue Joseph-Bens 532', N'Bruxelles', N'null', N'B-1180', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10893, N'KOENE', 9, CAST(0x00008C0200000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), CAST(0x00008C0400000000 AS DateTime), 2, CAST(77.78000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10894, N'SAVEA', 1, CAST(0x00008C0200000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), CAST(0x00008C0400000000 AS DateTime), 1, CAST(116.13000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10895, N'ERNSH', 3, CAST(0x00008C0200000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), CAST(0x00008C0700000000 AS DateTime), 1, CAST(162.75000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10896, N'MAISD', 7, CAST(0x00008C0300000000 AS DateTime), CAST(0x00008C1F00000000 AS DateTime), CAST(0x00008C0B00000000 AS DateTime), 3, CAST(32.45000 AS Decimal(19, 5)), N'Maison Dewey', N'Rue Joseph-Bens 532', N'Bruxelles', N'null', N'B-1180', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10897, N'HUNGO', 3, CAST(0x00008C0300000000 AS DateTime), CAST(0x00008C1F00000000 AS DateTime), CAST(0x00008C0900000000 AS DateTime), 2, CAST(603.54000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10898, N'OCEAN', 4, CAST(0x00008C0400000000 AS DateTime), CAST(0x00008C2000000000 AS DateTime), CAST(0x00008C1200000000 AS DateTime), 2, CAST(1.27000 AS Decimal(19, 5)), N'Océano Atlántico Ltda.', N'Ing. Gustavo Moncada 8585 Piso 20-A', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10899, N'LILAS', 5, CAST(0x00008C0400000000 AS DateTime), CAST(0x00008C2000000000 AS DateTime), CAST(0x00008C0A00000000 AS DateTime), 3, CAST(1.21000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10900, N'WELLI', 1, CAST(0x00008C0400000000 AS DateTime), CAST(0x00008C2000000000 AS DateTime), CAST(0x00008C1000000000 AS DateTime), 2, CAST(1.66000 AS Decimal(19, 5)), N'Wellington Importadora', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10901, N'HILAA', 4, CAST(0x00008C0700000000 AS DateTime), CAST(0x00008C2300000000 AS DateTime), CAST(0x00008C0A00000000 AS DateTime), 1, CAST(62.09000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10902, N'FOLKO', 1, CAST(0x00008C0700000000 AS DateTime), CAST(0x00008C2300000000 AS DateTime), CAST(0x00008C0F00000000 AS DateTime), 1, CAST(44.15000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10903, N'HANAR', 3, CAST(0x00008C0800000000 AS DateTime), CAST(0x00008C2400000000 AS DateTime), CAST(0x00008C1000000000 AS DateTime), 3, CAST(36.71000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10904, N'WHITC', 3, CAST(0x00008C0800000000 AS DateTime), CAST(0x00008C2400000000 AS DateTime), CAST(0x00008C0B00000000 AS DateTime), 3, CAST(162.95000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10905, N'WELLI', 9, CAST(0x00008C0800000000 AS DateTime), CAST(0x00008C2400000000 AS DateTime), CAST(0x00008C1200000000 AS DateTime), 2, CAST(13.72000 AS Decimal(19, 5)), N'Wellington Importadora', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10906, N'WOLZA', 4, CAST(0x00008C0900000000 AS DateTime), CAST(0x00008C1700000000 AS DateTime), CAST(0x00008C0F00000000 AS DateTime), 3, CAST(26.29000 AS Decimal(19, 5)), N'Wolski Zajazd', N'ul. Filtrowa 68', N'Warszawa', N'null', N'01-012', N'Poland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10907, N'SPECD', 6, CAST(0x00008C0900000000 AS DateTime), CAST(0x00008C2500000000 AS DateTime), CAST(0x00008C0B00000000 AS DateTime), 3, CAST(9.19000 AS Decimal(19, 5)), N'Spécialités du monde', N'25, rue Lauriston', N'Paris', N'null', N'75016', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10908, N'REGGC', 4, CAST(0x00008C0A00004650 AS DateTime), CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C1200000000 AS DateTime), 2, CAST(32.96000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10909, N'SANTG', 1, CAST(0x00008C0A00000000 AS DateTime), CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C1600000000 AS DateTime), 2, CAST(53.05000 AS Decimal(19, 5)), N'Santé Gourmet', N'Erling Skakkes gate 78', N'Stavern', N'null', N'4110', N'Norway')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10910, N'WILMK', 1, CAST(0x00008C0A00000000 AS DateTime), CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C1000000000 AS DateTime), 3, CAST(38.11000 AS Decimal(19, 5)), N'Wilman Kala', N'Keskuskatu 45', N'Helsinki', N'null', N'21240', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10911, N'GODOS', 3, CAST(0x00008C0A00000000 AS DateTime), CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C1100000000 AS DateTime), 1, CAST(38.19000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10912, N'HUNGO', 2, CAST(0x00008C0A00000000 AS DateTime), CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), 2, CAST(580.91000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10913, N'QUEEN', 4, CAST(0x00008C0A00000000 AS DateTime), CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C1000000000 AS DateTime), 1, CAST(33.05000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10914, N'QUEEN', 6, CAST(0x00008C0B00000000 AS DateTime), CAST(0x00008C2700000000 AS DateTime), CAST(0x00008C0E00000000 AS DateTime), 1, CAST(21.19000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10915, N'TORTU', 2, CAST(0x00008C0B00000000 AS DateTime), CAST(0x00008C2700000000 AS DateTime), CAST(0x00008C0E00000000 AS DateTime), 2, CAST(3.51000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10916, N'RANCH', 1, CAST(0x00008C0B00000000 AS DateTime), CAST(0x00008C2700000000 AS DateTime), CAST(0x00008C1500000000 AS DateTime), 2, CAST(63.77000 AS Decimal(19, 5)), N'Rancho grande', N'Av. del Libertador 900', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10917, N'ROMEY', 4, CAST(0x00008C0E00000000 AS DateTime), CAST(0x00008C2A00000000 AS DateTime), CAST(0x00008C1700000000 AS DateTime), 2, CAST(8.29000 AS Decimal(19, 5)), N'Romero y tomillo', N'Gran Vía, 1', N'Madrid', N'null', N'28001', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10918, N'BOTTM', 3, CAST(0x00008C0E00000000 AS DateTime), CAST(0x00008C2A00000000 AS DateTime), CAST(0x00008C1700000000 AS DateTime), 3, CAST(48.83000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10919, N'LINOD', 2, CAST(0x00008C0E00000000 AS DateTime), CAST(0x00008C2A00000000 AS DateTime), CAST(0x00008C1000000000 AS DateTime), 2, CAST(19.80000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10920, N'AROUT', 4, CAST(0x00008C0F00000000 AS DateTime), CAST(0x00008C2B00000000 AS DateTime), CAST(0x00008C1500000000 AS DateTime), 2, CAST(29.61000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10921, N'VAFFE', 1, CAST(0x00008C0F00000000 AS DateTime), CAST(0x00008C3900000000 AS DateTime), CAST(0x00008C1500000000 AS DateTime), 1, CAST(176.48000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10922, N'HANAR', 5, CAST(0x00008C0F00000000 AS DateTime), CAST(0x00008C2B00000000 AS DateTime), CAST(0x00008C1100000000 AS DateTime), 3, CAST(62.74000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10923, N'LAMAI', 7, CAST(0x00008C0F00000000 AS DateTime), CAST(0x00008C3900000000 AS DateTime), CAST(0x00008C1900000000 AS DateTime), 3, CAST(68.26000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10924, N'BERGS', 3, CAST(0x00008C1000000000 AS DateTime), CAST(0x00008C2C00000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), 2, CAST(151.52000 AS Decimal(19, 5)), N'Berglunds snabbköp', N'Berguvsvägen  8', N'Luleå', N'null', N'S-958 22', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10925, N'HANAR', 3, CAST(0x00008C1000000000 AS DateTime), CAST(0x00008C2C00000000 AS DateTime), CAST(0x00008C1900000000 AS DateTime), 1, CAST(2.27000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10926, N'ANATR', 4, CAST(0x00008C1000000000 AS DateTime), CAST(0x00008C2C00000000 AS DateTime), CAST(0x00008C1700000000 AS DateTime), 3, CAST(39.92000 AS Decimal(19, 5)), N'Ana Trujillo Emparedados y helados', N'Avda. de la Constitución 2222', N'México D.F.', N'null', N'05021', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10927, N'LACOR', 4, CAST(0x00008C1100000000 AS DateTime), CAST(0x00008C2D00000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), 1, CAST(19.79000 AS Decimal(19, 5)), N'La corne d''abondance', N'67, avenue de l''Europe', N'Versailles', N'null', N'78000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10928, N'GALED', 1, CAST(0x00008C1100000000 AS DateTime), CAST(0x00008C2D00000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), 1, CAST(1.36000 AS Decimal(19, 5)), N'Galería del gastronómo', N'Rambla de Cataluña, 23', N'Barcelona', N'null', N'8022', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10929, N'FRANK', 6, CAST(0x00008C1100000000 AS DateTime), CAST(0x00008C2D00000000 AS DateTime), CAST(0x00008C1800000000 AS DateTime), 1, CAST(33.93000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10930, N'SUPRD', 4, CAST(0x00008C1200000000 AS DateTime), CAST(0x00008C3C00000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), 3, CAST(15.55000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10931, N'RICSU', 4, CAST(0x00008C1200000000 AS DateTime), CAST(0x00008C2000000000 AS DateTime), CAST(0x00008C1F00000000 AS DateTime), 2, CAST(13.60000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10932, N'BONAP', 8, CAST(0x00008C1200000000 AS DateTime), CAST(0x00008C2E00000000 AS DateTime), CAST(0x00008C2400000000 AS DateTime), 1, CAST(134.64000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10933, N'ISLAT', 6, CAST(0x00008C1200000000 AS DateTime), CAST(0x00008C2E00000000 AS DateTime), CAST(0x00008C1C00000000 AS DateTime), 3, CAST(54.15000 AS Decimal(19, 5)), N'Island Trading', N'Garden House Crowther Way', N'Cowes', N'Isle of Wight', N'PO31 7PJ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10934, N'LEHMS', 3, CAST(0x00008C1500000000 AS DateTime), CAST(0x00008C3100000000 AS DateTime), CAST(0x00008C1800000000 AS DateTime), 3, CAST(32.01000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10935, N'WELLI', 4, CAST(0x00008C1500000000 AS DateTime), CAST(0x00008C3100000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), 3, CAST(47.59000 AS Decimal(19, 5)), N'Wellington Importadora', N'Rua do Mercado, 12', N'Resende', N'SP', N'08737-363', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10936, N'GREAL', 3, CAST(0x00008C1500000000 AS DateTime), CAST(0x00008C3100000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), 2, CAST(33.68000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10937, N'CACTU', 7, CAST(0x00008C1600000000 AS DateTime), CAST(0x00008C2400000000 AS DateTime), CAST(0x00008C1900000000 AS DateTime), 3, CAST(31.51000 AS Decimal(19, 5)), N'Cactus Comidas para llevar', N'Cerrito 333', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10938, N'QUICK', 3, CAST(0x00008C1600000000 AS DateTime), CAST(0x00008C3200000000 AS DateTime), CAST(0x00008C1C00000000 AS DateTime), 2, CAST(31.89000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10939, N'MAGAA', 2, CAST(0x00008C1600000000 AS DateTime), CAST(0x00008C3200000000 AS DateTime), CAST(0x00008C1900000000 AS DateTime), 2, CAST(76.33000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10940, N'BONAP', 8, CAST(0x00008C1700000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), CAST(0x00008C2300000000 AS DateTime), 3, CAST(19.77000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10941, N'SAVEA', 7, CAST(0x00008C1700000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), CAST(0x00008C2000000000 AS DateTime), 2, CAST(400.81000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10942, N'REGGC', 9, CAST(0x00008C1700000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), 3, CAST(17.95000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10943, N'BSBEV', 4, CAST(0x00008C1700000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), CAST(0x00008C1F00000000 AS DateTime), 2, CAST(2.17000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10944, N'BOTTM', 6, CAST(0x00008C1800000000 AS DateTime), CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C1900000000 AS DateTime), 3, CAST(52.92000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10945, N'MORGK', 4, CAST(0x00008C1800000000 AS DateTime), CAST(0x00008C3400000000 AS DateTime), CAST(0x00008C1E00000000 AS DateTime), 1, CAST(10.22000 AS Decimal(19, 5)), N'Morgenstern Gesundkost', N'Heerstr. 22', N'Leipzig', N'null', N'04179', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10946, N'VAFFE', 1, CAST(0x00008C1800000000 AS DateTime), CAST(0x00008C3400000000 AS DateTime), CAST(0x00008C1F00000000 AS DateTime), 2, CAST(27.20000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10947, N'BSBEV', 3, CAST(0x00008C1900000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), CAST(0x00008C1C00000000 AS DateTime), 2, CAST(3.26000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10948, N'GODOS', 3, CAST(0x00008C1900000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), CAST(0x00008C1F00000000 AS DateTime), 3, CAST(23.39000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10949, N'BOTTM', 2, CAST(0x00008C1900000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), CAST(0x00008C1D00000000 AS DateTime), 3, CAST(74.44000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10950, N'MAGAA', 1, CAST(0x00008C1C00000000 AS DateTime), CAST(0x00008C3800000000 AS DateTime), CAST(0x00008C2300000000 AS DateTime), 2, CAST(2.50000 AS Decimal(19, 5)), N'Magazzini Alimentari Riuniti', N'Via Ludovico il Moro 22', N'Bergamo', N'null', N'24100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10951, N'RICSU', 9, CAST(0x00008C1C00000000 AS DateTime), CAST(0x00008C4600000000 AS DateTime), CAST(0x00008C3200000000 AS DateTime), 2, CAST(30.85000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10952, N'ALFKI', 1, CAST(0x00008C1C00000000 AS DateTime), CAST(0x00008C4600000000 AS DateTime), CAST(0x00008C2400000000 AS DateTime), 1, CAST(40.42000 AS Decimal(19, 5)), N'Alfred''s Futterkiste', N'Obere Str. 57', N'Berlin', N'null', N'12209', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10953, N'AROUT', 9, CAST(0x00008C1C00000000 AS DateTime), CAST(0x00008C2A00000000 AS DateTime), CAST(0x00008C2500000000 AS DateTime), 2, CAST(23.72000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10954, N'LINOD', 5, CAST(0x00008C1D00000000 AS DateTime), CAST(0x00008C4700000000 AS DateTime), CAST(0x00008C2000000000 AS DateTime), 1, CAST(27.91000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
GO
print 'Processed 700 total records'
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10955, N'FOLKO', 8, CAST(0x00008C1D00000000 AS DateTime), CAST(0x00008C3900000000 AS DateTime), CAST(0x00008C2000000000 AS DateTime), 2, CAST(3.26000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10956, N'BLAUS', 6, CAST(0x00008C1D00000000 AS DateTime), CAST(0x00008C4700000000 AS DateTime), CAST(0x00008C2000000000 AS DateTime), 2, CAST(44.65000 AS Decimal(19, 5)), N'Blauer See Delikatessen', N'Forsterstr. 57', N'Mannheim', N'null', N'68306', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10957, N'HILAA', 8, CAST(0x00008C1E00000000 AS DateTime), CAST(0x00008C3A00000000 AS DateTime), CAST(0x00008C2700000000 AS DateTime), 3, CAST(105.36000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10958, N'OCEAN', 7, CAST(0x00008C1E00000000 AS DateTime), CAST(0x00008C3A00000000 AS DateTime), CAST(0x00008C2700000000 AS DateTime), 2, CAST(49.56000 AS Decimal(19, 5)), N'Océano Atlántico Ltda.', N'Ing. Gustavo Moncada 8585 Piso 20-A', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10959, N'GOURL', 6, CAST(0x00008C1E00000000 AS DateTime), CAST(0x00008C4800000000 AS DateTime), CAST(0x00008C2300000000 AS DateTime), 2, CAST(4.98000 AS Decimal(19, 5)), N'Gourmet Lanchonetes', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10960, N'HILAA', 3, CAST(0x00008C1F00000000 AS DateTime), CAST(0x00008C2D00000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), 1, CAST(2.08000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10961, N'QUEEN', 8, CAST(0x00008C1F00000000 AS DateTime), CAST(0x00008C3B00000000 AS DateTime), CAST(0x00008C2A00000000 AS DateTime), 1, CAST(104.47000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10962, N'QUICK', 8, CAST(0x00008C1F00000000 AS DateTime), CAST(0x00008C3B00000000 AS DateTime), CAST(0x00008C2300000000 AS DateTime), 2, CAST(275.79000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10963, N'FURIB', 9, CAST(0x00008C1F00000000 AS DateTime), CAST(0x00008C3B00000000 AS DateTime), CAST(0x00008C2600000000 AS DateTime), 3, CAST(2.70000 AS Decimal(19, 5)), N'Furia Bacalhau e Frutos do Mar', N'Jardim das rosas n. 32', N'Lisboa', N'null', N'1675', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10964, N'SPECD', 3, CAST(0x00008C2000000000 AS DateTime), CAST(0x00008C3C00000000 AS DateTime), CAST(0x00008C2400000000 AS DateTime), 2, CAST(87.38000 AS Decimal(19, 5)), N'Spécialités du monde', N'25, rue Lauriston', N'Paris', N'null', N'75016', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10965, N'OLDWO', 6, CAST(0x00008C2000000000 AS DateTime), CAST(0x00008C3C00000000 AS DateTime), CAST(0x00008C2A00000000 AS DateTime), 3, CAST(144.38000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10966, N'CHOPS', 4, CAST(0x00008C2000000000 AS DateTime), CAST(0x00008C3C00000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), 1, CAST(27.19000 AS Decimal(19, 5)), N'Chop-suey Chinese', N'Hauptstr. 31', N'Bern', N'null', N'3012', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10967, N'TOMSP', 2, CAST(0x00008C2300000000 AS DateTime), CAST(0x00008C3F00000000 AS DateTime), CAST(0x00008C2D00000000 AS DateTime), 2, CAST(62.22000 AS Decimal(19, 5)), N'Toms Spezialitäten', N'Luisenstr. 48', N'Münster', N'null', N'44087', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10968, N'ERNSH', 1, CAST(0x00008C2300000000 AS DateTime), CAST(0x00008C3F00000000 AS DateTime), CAST(0x00008C2C00000000 AS DateTime), 3, CAST(74.60000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10969, N'COMMI', 1, CAST(0x00008C2300000000 AS DateTime), CAST(0x00008C3F00000000 AS DateTime), CAST(0x00008C2A00000000 AS DateTime), 2, CAST(0.21000 AS Decimal(19, 5)), N'Comércio Mineiro', N'Av. dos Lusíadas, 23', N'Sao Paulo', N'SP', N'05432-043', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10970, N'BOLID', 9, CAST(0x00008C2400000000 AS DateTime), CAST(0x00008C3200000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), 1, CAST(16.16000 AS Decimal(19, 5)), N'Bólido Comidas preparadas', N'C/ Araquil, 67', N'Madrid', N'null', N'28023', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10971, N'FRANR', 2, CAST(0x00008C2400000000 AS DateTime), CAST(0x00008C4000000000 AS DateTime), CAST(0x00008C2D00000000 AS DateTime), 2, CAST(121.82000 AS Decimal(19, 5)), N'France restauration', N'54, rue Royale', N'Nantes', N'null', N'44000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10972, N'LACOR', 4, CAST(0x00008C2400000000 AS DateTime), CAST(0x00008C4000000000 AS DateTime), CAST(0x00008C2600000000 AS DateTime), 2, CAST(0.02000 AS Decimal(19, 5)), N'La corne d''abondance', N'67, avenue de l''Europe', N'Versailles', N'null', N'78000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10973, N'LACOR', 6, CAST(0x00008C2400000000 AS DateTime), CAST(0x00008C4000000000 AS DateTime), CAST(0x00008C2700000000 AS DateTime), 2, CAST(15.17000 AS Decimal(19, 5)), N'La corne d''abondance', N'67, avenue de l''Europe', N'Versailles', N'null', N'78000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10974, N'SPLIR', 3, CAST(0x00008C2500000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), CAST(0x00008C2E00000000 AS DateTime), 3, CAST(12.96000 AS Decimal(19, 5)), N'Split Rail Beer & Ale', N'P.O. Box 555', N'Lander', N'WY', N'82520', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10975, N'BOTTM', 1, CAST(0x00008C2500000000 AS DateTime), CAST(0x00008C4100000000 AS DateTime), CAST(0x00008C2700000000 AS DateTime), 3, CAST(32.27000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10976, N'HILAA', 1, CAST(0x00008C2500000000 AS DateTime), CAST(0x00008C4F00000000 AS DateTime), CAST(0x00008C2E00000000 AS DateTime), 1, CAST(37.97000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10977, N'FOLKO', 8, CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C4200000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), 3, CAST(208.50000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10978, N'MAISD', 9, CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C4200000000 AS DateTime), CAST(0x00008C4200000000 AS DateTime), 2, CAST(32.82000 AS Decimal(19, 5)), N'Maison Dewey', N'Rue Joseph-Bens 532', N'Bruxelles', N'null', N'B-1180', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10979, N'ERNSH', 8, CAST(0x00008C2600000000 AS DateTime), CAST(0x00008C4200000000 AS DateTime), CAST(0x00008C2B00000000 AS DateTime), 2, CAST(353.07000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10980, N'FOLKO', 4, CAST(0x00008C2700000000 AS DateTime), CAST(0x00008C5100000000 AS DateTime), CAST(0x00008C3C00000000 AS DateTime), 1, CAST(1.26000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10981, N'HANAR', 1, CAST(0x00008C2700000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), CAST(0x00008C2D00000000 AS DateTime), 2, CAST(193.37000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10982, N'BOTTM', 2, CAST(0x00008C2700000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), 1, CAST(14.01000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10983, N'SAVEA', 2, CAST(0x00008C2700000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), CAST(0x00008C3100000000 AS DateTime), 2, CAST(657.54000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10984, N'SAVEA', 1, CAST(0x00008C2A00000000 AS DateTime), CAST(0x00008C4600000000 AS DateTime), CAST(0x00008C2E00000000 AS DateTime), 3, CAST(211.22000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10985, N'HUNGO', 2, CAST(0x00008C2A00000000 AS DateTime), CAST(0x00008C4600000000 AS DateTime), CAST(0x00008C2D00000000 AS DateTime), 1, CAST(91.51000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10986, N'OCEAN', 8, CAST(0x00008C2A00000000 AS DateTime), CAST(0x00008C4600000000 AS DateTime), CAST(0x00008C4000000000 AS DateTime), 2, CAST(217.86000 AS Decimal(19, 5)), N'Océano Atlántico Ltda.', N'Ing. Gustavo Moncada 8585 Piso 20-A', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10987, N'EASTC', 8, CAST(0x00008C2B00000000 AS DateTime), CAST(0x00008C4700000000 AS DateTime), CAST(0x00008C3100000000 AS DateTime), 1, CAST(185.48000 AS Decimal(19, 5)), N'Eastern Connection', N'35 King George', N'London', N'null', N'WX3 6FW', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10988, N'RATTC', 3, CAST(0x00008C2B00000000 AS DateTime), CAST(0x00008C4700000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), 2, CAST(61.14000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10989, N'QUEDE', 2, CAST(0x00008C2B00000000 AS DateTime), CAST(0x00008C4700000000 AS DateTime), CAST(0x00008C2D00000000 AS DateTime), 1, CAST(34.76000 AS Decimal(19, 5)), N'Que Delícia', N'Rua da Panificadora, 12', N'Rio de Janeiro', N'RJ', N'02389-673', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10990, N'ERNSH', 2, CAST(0x00008C2C00000000 AS DateTime), CAST(0x00008C5600000000 AS DateTime), CAST(0x00008C3200000000 AS DateTime), 3, CAST(117.61000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10991, N'QUICK', 1, CAST(0x00008C2C00000000 AS DateTime), CAST(0x00008C4800000000 AS DateTime), CAST(0x00008C3200000000 AS DateTime), 1, CAST(38.51000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10992, N'THEBI', 1, CAST(0x00008C2C00000000 AS DateTime), CAST(0x00008C4800000000 AS DateTime), CAST(0x00008C2E00000000 AS DateTime), 3, CAST(4.27000 AS Decimal(19, 5)), N'The Big Cheese', N'89 Jefferson Way Suite 2', N'Portland', N'OR', N'97201', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10993, N'FOLKO', 7, CAST(0x00008C2C00000000 AS DateTime), CAST(0x00008C4800000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), 3, CAST(8.81000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10994, N'VAFFE', 2, CAST(0x00008C2D00000000 AS DateTime), CAST(0x00008C3B00000000 AS DateTime), CAST(0x00008C3400000000 AS DateTime), 3, CAST(65.53000 AS Decimal(19, 5)), N'Vaffeljernet', N'Smagsloget 45', N'Århus', N'null', N'8200', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10995, N'PERIC', 1, CAST(0x00008C2D00000000 AS DateTime), CAST(0x00008C4900000000 AS DateTime), CAST(0x00008C3100000000 AS DateTime), 3, CAST(46.00000 AS Decimal(19, 5)), N'Pericles Comidas clásicas', N'Calle Dr. Jorge Cash 321', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10996, N'QUICK', 4, CAST(0x00008C2D00000000 AS DateTime), CAST(0x00008C4900000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), 2, CAST(1.12000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10997, N'LILAS', 8, CAST(0x00008C2E00000000 AS DateTime), CAST(0x00008C5800000000 AS DateTime), CAST(0x00008C3800000000 AS DateTime), 2, CAST(73.91000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10998, N'WOLZA', 8, CAST(0x00008C2E00000000 AS DateTime), CAST(0x00008C3C00000000 AS DateTime), CAST(0x00008C3C00000000 AS DateTime), 2, CAST(20.31000 AS Decimal(19, 5)), N'Wolski Zajazd', N'ul. Filtrowa 68', N'Warszawa', N'null', N'01-012', N'Poland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (10999, N'OTTIK', 6, CAST(0x00008C2E00000000 AS DateTime), CAST(0x00008C4A00000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), 2, CAST(96.35000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11000, N'RATTC', 2, CAST(0x00008C3100000000 AS DateTime), CAST(0x00008C4D00000000 AS DateTime), CAST(0x00008C3900000000 AS DateTime), 3, CAST(55.12000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11001, N'FOLKO', 2, CAST(0x00008C3100000000 AS DateTime), CAST(0x00008C4D00000000 AS DateTime), CAST(0x00008C3900000000 AS DateTime), 2, CAST(197.30000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11002, N'SAVEA', 4, CAST(0x00008C3100000000 AS DateTime), CAST(0x00008C4D00000000 AS DateTime), CAST(0x00008C3B00000000 AS DateTime), 1, CAST(141.16000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11003, N'THECR', 3, CAST(0x00008C3100000000 AS DateTime), CAST(0x00008C4D00000000 AS DateTime), CAST(0x00008C3300000000 AS DateTime), 3, CAST(14.91000 AS Decimal(19, 5)), N'The Cracker Box', N'55 Grizzly Peak Rd.', N'Butte', N'MT', N'59801', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11004, N'MAISD', 3, CAST(0x00008C3200000000 AS DateTime), CAST(0x00008C4E00000000 AS DateTime), CAST(0x00008C3F00000000 AS DateTime), 1, CAST(44.84000 AS Decimal(19, 5)), N'Maison Dewey', N'Rue Joseph-Bens 532', N'Bruxelles', N'null', N'B-1180', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11005, N'WILMK', 2, CAST(0x00008C3200000000 AS DateTime), CAST(0x00008C4E00000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), 1, CAST(0.75000 AS Decimal(19, 5)), N'Wilman Kala', N'Keskuskatu 45', N'Helsinki', N'null', N'21240', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11006, N'GREAL', 3, CAST(0x00008C3200000000 AS DateTime), CAST(0x00008C4E00000000 AS DateTime), CAST(0x00008C3A00000000 AS DateTime), 2, CAST(25.19000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11007, N'PRINI', 8, CAST(0x00008C3300000000 AS DateTime), CAST(0x00008C4F00000000 AS DateTime), CAST(0x00008C3800000000 AS DateTime), 2, CAST(202.24000 AS Decimal(19, 5)), N'Princesa Isabel Vinhos', N'Estrada da saúde n. 58', N'Lisboa', N'null', N'1756', N'Portugal')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11008, N'ERNSH', 7, CAST(0x00008C3300000000 AS DateTime), CAST(0x00008C4F00000000 AS DateTime), NULL, 3, CAST(79.46000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11009, N'GODOS', 2, CAST(0x00008C3300000000 AS DateTime), CAST(0x00008C4F00000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), 1, CAST(59.11000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11010, N'REGGC', 2, CAST(0x00008C3400000000 AS DateTime), CAST(0x00008C5000000000 AS DateTime), CAST(0x00008C4000000000 AS DateTime), 2, CAST(28.71000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11011, N'ALFKI', 3, CAST(0x00008C3400000000 AS DateTime), CAST(0x00008C5000000000 AS DateTime), CAST(0x00008C3800000000 AS DateTime), 1, CAST(1.21000 AS Decimal(19, 5)), N'Alfred''s Futterkiste', N'Obere Str. 57', N'Berlin', N'null', N'12209', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11012, N'FRANK', 1, CAST(0x00008C3400000000 AS DateTime), CAST(0x00008C4200000000 AS DateTime), CAST(0x00008C3C00000000 AS DateTime), 3, CAST(242.95000 AS Decimal(19, 5)), N'Frankenversand', N'Berliner Platz 43', N'München', N'null', N'80805', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11013, N'ROMEY', 2, CAST(0x00008C3400000000 AS DateTime), CAST(0x00008C5000000000 AS DateTime), CAST(0x00008C3500000000 AS DateTime), 1, CAST(32.99000 AS Decimal(19, 5)), N'Romero y tomillo', N'Gran Vía, 1', N'Madrid', N'null', N'28001', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11014, N'LINOD', 2, CAST(0x00008C3500000000 AS DateTime), CAST(0x00008C5100000000 AS DateTime), CAST(0x00008C3A00000000 AS DateTime), 3, CAST(23.60000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11015, N'SANTG', 2, CAST(0x00008C3500000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), CAST(0x00008C3F00000000 AS DateTime), 2, CAST(4.62000 AS Decimal(19, 5)), N'Santé Gourmet', N'Erling Skakkes gate 78', N'Stavern', N'null', N'4110', N'Norway')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11016, N'AROUT', 9, CAST(0x00008C3500000000 AS DateTime), CAST(0x00008C5100000000 AS DateTime), CAST(0x00008C3800000000 AS DateTime), 2, CAST(33.80000 AS Decimal(19, 5)), N'Around the Horn', N'Brook Farm Stratford St. Mary', N'Colchester', N'Essex', N'CO7 6JX', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11017, N'ERNSH', 9, CAST(0x00008C3800000000 AS DateTime), CAST(0x00008C5400000000 AS DateTime), CAST(0x00008C3F00000000 AS DateTime), 2, CAST(754.26000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11018, N'LONEP', 4, CAST(0x00008C3800000000 AS DateTime), CAST(0x00008C5400000000 AS DateTime), CAST(0x00008C3B00000000 AS DateTime), 2, CAST(11.65000 AS Decimal(19, 5)), N'Lonesome Pine Restaurant', N'89 Chiaroscuro Rd.', N'Portland', N'OR', N'97219', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11019, N'RANCH', 6, CAST(0x00008C3800000000 AS DateTime), CAST(0x00008C5400000000 AS DateTime), NULL, 3, CAST(3.17000 AS Decimal(19, 5)), N'Rancho grande', N'Av. del Libertador 900', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11020, N'OTTIK', 2, CAST(0x00008C3900000000 AS DateTime), CAST(0x00008C5500000000 AS DateTime), CAST(0x00008C3B00000000 AS DateTime), 2, CAST(43.30000 AS Decimal(19, 5)), N'Ottilies Käseladen', N'Mehrheimerstr. 369', N'Köln', N'null', N'50739', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11021, N'QUICK', 3, CAST(0x00008C3900000000 AS DateTime), CAST(0x00008C5500000000 AS DateTime), CAST(0x00008C4000000000 AS DateTime), 1, CAST(297.18000 AS Decimal(19, 5)), N'QUICK-Stop', N'Taucherstraße 10', N'Cunewalde', N'null', N'01307', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11022, N'HANAR', 9, CAST(0x00008C3900000000 AS DateTime), CAST(0x00008C5500000000 AS DateTime), CAST(0x00008C4D00000000 AS DateTime), 2, CAST(6.27000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11023, N'BSBEV', 1, CAST(0x00008C3900000000 AS DateTime), CAST(0x00008C4700000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), 2, CAST(123.83000 AS Decimal(19, 5)), N'B''s Beverages', N'Fauntleroy Circus', N'London', N'null', N'EC2 5NT', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11024, N'EASTC', 4, CAST(0x00008C3A00000000 AS DateTime), CAST(0x00008C5600000000 AS DateTime), CAST(0x00008C3F00000000 AS DateTime), 1, CAST(74.36000 AS Decimal(19, 5)), N'Eastern Connection', N'35 King George', N'London', N'null', N'WX3 6FW', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11025, N'WARTH', 6, CAST(0x00008C3A00000000 AS DateTime), CAST(0x00008C5600000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), 3, CAST(29.17000 AS Decimal(19, 5)), N'Wartian Herkku', N'Torikatu 38', N'Oulu', N'null', N'90110', N'Finland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11026, N'FRANS', 4, CAST(0x00008C3A00000000 AS DateTime), CAST(0x00008C5600000000 AS DateTime), CAST(0x00008C4700000000 AS DateTime), 1, CAST(47.09000 AS Decimal(19, 5)), N'Franchi S.p.A.', N'Via Monte Bianco 34', N'Torino', N'null', N'10100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11027, N'BOTTM', 1, CAST(0x00008C3B00000000 AS DateTime), CAST(0x00008C5700000000 AS DateTime), CAST(0x00008C3F00000000 AS DateTime), 1, CAST(52.52000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11028, N'KOENE', 2, CAST(0x00008C3B00000000 AS DateTime), CAST(0x00008C5700000000 AS DateTime), CAST(0x00008C4100000000 AS DateTime), 1, CAST(29.59000 AS Decimal(19, 5)), N'Königlich Essen', N'Maubelstr. 90', N'Brandenburg', N'null', N'14776', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11029, N'CHOPS', 4, CAST(0x00008C3B00000000 AS DateTime), CAST(0x00008C5700000000 AS DateTime), CAST(0x00008C4600000000 AS DateTime), 1, CAST(47.84000 AS Decimal(19, 5)), N'Chop-suey Chinese', N'Hauptstr. 31', N'Bern', N'null', N'3012', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11030, N'SAVEA', 7, CAST(0x00008C3C00000000 AS DateTime), CAST(0x00008C5800000000 AS DateTime), CAST(0x00008C4600000000 AS DateTime), 2, CAST(830.75000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11031, N'SAVEA', 6, CAST(0x00008C3C00000000 AS DateTime), CAST(0x00008C5800000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), 2, CAST(227.22000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11032, N'WHITC', 2, CAST(0x00008C3C00000000 AS DateTime), CAST(0x00008C5800000000 AS DateTime), CAST(0x00008C4200000000 AS DateTime), 3, CAST(606.19000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11033, N'RICSU', 7, CAST(0x00008C3C00000000 AS DateTime), CAST(0x00008C5800000000 AS DateTime), CAST(0x00008C4200000000 AS DateTime), 3, CAST(84.74000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11034, N'OLDWO', 8, CAST(0x00008C3F00000000 AS DateTime), CAST(0x00008C6900000000 AS DateTime), CAST(0x00008C4600000000 AS DateTime), 1, CAST(40.32000 AS Decimal(19, 5)), N'Old World Delicatessen', N'2743 Bering St.', N'Anchorage', N'AK', N'99508', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11035, N'SUPRD', 2, CAST(0x00008C3F00000000 AS DateTime), CAST(0x00008C5B00000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), 2, CAST(0.17000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11036, N'DRACD', 8, CAST(0x00008C3F00000000 AS DateTime), CAST(0x00008C5B00000000 AS DateTime), CAST(0x00008C4100000000 AS DateTime), 3, CAST(149.47000 AS Decimal(19, 5)), N'Drachenblut Delikatessen', N'Walserweg 21', N'Aachen', N'null', N'52066', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11037, N'GODOS', 7, CAST(0x00008C4000000000 AS DateTime), CAST(0x00008C5C00000000 AS DateTime), CAST(0x00008C4600000000 AS DateTime), 1, CAST(3.20000 AS Decimal(19, 5)), N'Godos Cocina Típica', N'C/ Romero, 33', N'Sevilla', N'null', N'41101', N'Spain')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11038, N'SUPRD', 1, CAST(0x00008C4000000000 AS DateTime), CAST(0x00008C5C00000000 AS DateTime), CAST(0x00008C4900000000 AS DateTime), 2, CAST(29.59000 AS Decimal(19, 5)), N'Suprêmes délices', N'Boulevard Tirou, 255', N'Charleroi', N'null', N'B-6000', N'Belgium')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11039, N'LINOD', 1, CAST(0x00008C4000000000 AS DateTime), CAST(0x00008C5C00000000 AS DateTime), NULL, 2, CAST(65.00000 AS Decimal(19, 5)), N'LINO-Delicateses', N'Ave. 5 de Mayo Porlamar', N'I. de Margarita', N'Nueva Esparta', N'4980', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11040, N'GREAL', 4, CAST(0x00008C4100000000 AS DateTime), CAST(0x00008C5D00000000 AS DateTime), NULL, 3, CAST(18.84000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11041, N'CHOPS', 3, CAST(0x00008C4100000000 AS DateTime), CAST(0x00008C5D00000000 AS DateTime), CAST(0x00008C4700000000 AS DateTime), 2, CAST(48.22000 AS Decimal(19, 5)), N'Chop-suey Chinese', N'Hauptstr. 31', N'Bern', N'null', N'3012', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11042, N'COMMI', 2, CAST(0x00008C4100000000 AS DateTime), CAST(0x00008C4F00000000 AS DateTime), CAST(0x00008C4A00000000 AS DateTime), 1, CAST(29.99000 AS Decimal(19, 5)), N'Comércio Mineiro', N'Av. dos Lusíadas, 23', N'Sao Paulo', N'SP', N'05432-043', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11043, N'SPECD', 5, CAST(0x00008C4100000000 AS DateTime), CAST(0x00008C5D00000000 AS DateTime), CAST(0x00008C4800000000 AS DateTime), 2, CAST(8.80000 AS Decimal(19, 5)), N'Spécialités du monde', N'25, rue Lauriston', N'Paris', N'null', N'75016', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11044, N'WOLZA', 4, CAST(0x00008C4200000000 AS DateTime), CAST(0x00008C5E00000000 AS DateTime), CAST(0x00008C4A00000000 AS DateTime), 1, CAST(8.72000 AS Decimal(19, 5)), N'Wolski Zajazd', N'ul. Filtrowa 68', N'Warszawa', N'null', N'01-012', N'Poland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11045, N'BOTTM', 6, CAST(0x00008C4200000000 AS DateTime), CAST(0x00008C5E00000000 AS DateTime), NULL, 2, CAST(70.58000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11046, N'WANDK', 8, CAST(0x00008C4200000000 AS DateTime), CAST(0x00008C5E00000000 AS DateTime), CAST(0x00008C4300000000 AS DateTime), 2, CAST(71.64000 AS Decimal(19, 5)), N'Die Wandernde Kuh', N'Adenauerallee 900', N'Stuttgart', N'null', N'70563', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11047, N'EASTC', 7, CAST(0x00008C4300000000 AS DateTime), CAST(0x00008C5F00000000 AS DateTime), CAST(0x00008C4A00000000 AS DateTime), 3, CAST(46.62000 AS Decimal(19, 5)), N'Eastern Connection', N'35 King George', N'London', N'null', N'WX3 6FW', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11048, N'BOTTM', 7, CAST(0x00008C4300000000 AS DateTime), CAST(0x00008C5F00000000 AS DateTime), CAST(0x00008C4900000000 AS DateTime), 3, CAST(24.12000 AS Decimal(19, 5)), N'Bottom-Dollar Markets', N'23 Tsawassen Blvd.', N'Tsawassen', N'BC', N'T2F 8M4', N'Canada')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11049, N'GOURL', 3, CAST(0x00008C4300000000 AS DateTime), CAST(0x00008C5F00000000 AS DateTime), CAST(0x00008C4D00000000 AS DateTime), 1, CAST(8.34000 AS Decimal(19, 5)), N'Gourmet Lanchonetes', N'Av. Brasil, 442', N'Campinas', N'SP', N'04876-786', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11050, N'FOLKO', 8, CAST(0x00008C4600000000 AS DateTime), CAST(0x00008C6200000000 AS DateTime), CAST(0x00008C4E00000000 AS DateTime), 2, CAST(59.41000 AS Decimal(19, 5)), N'Folk och fä HB', N'Åkergatan 24', N'Bräcke', N'null', N'S-844 67', N'Sweden')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11051, N'LAMAI', 7, CAST(0x00008C4600000000 AS DateTime), CAST(0x00008C6200000000 AS DateTime), NULL, 3, CAST(2.79000 AS Decimal(19, 5)), N'La maison d''Asie', N'1 rue Alsace-Lorraine', N'Toulouse', N'null', N'31000', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11052, N'HANAR', 3, CAST(0x00008C4600000000 AS DateTime), CAST(0x00008C6200000000 AS DateTime), CAST(0x00008C4A00000000 AS DateTime), 1, CAST(67.26000 AS Decimal(19, 5)), N'Hanari Carnes', N'Rua do Paço, 67', N'Rio de Janeiro', N'RJ', N'05454-876', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11053, N'PICCO', 2, CAST(0x00008C4600000000 AS DateTime), CAST(0x00008C6200000000 AS DateTime), CAST(0x00008C4800000000 AS DateTime), 2, CAST(53.05000 AS Decimal(19, 5)), N'Piccolo und mehr', N'Geislweg 14', N'Salzburg', N'null', N'5020', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11054, N'CACTU', 8, CAST(0x00008C4700000000 AS DateTime), CAST(0x00008C6300000000 AS DateTime), NULL, 1, CAST(0.33000 AS Decimal(19, 5)), N'Cactus Comidas para llevar', N'Cerrito 333', N'Buenos Aires', N'null', N'1010', N'Argentina')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11055, N'HILAA', 7, CAST(0x00008C4700000000 AS DateTime), CAST(0x00008C6300000000 AS DateTime), CAST(0x00008C4E00000000 AS DateTime), 2, CAST(120.92000 AS Decimal(19, 5)), N'HILARION-Abastos', N'Carrera 22 con Ave. Carlos Soublette #8-35', N'San Cristóbal', N'Táchira', N'5022', N'Venezuela')
GO
print 'Processed 800 total records'
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11056, N'EASTC', 8, CAST(0x00008C4700000000 AS DateTime), CAST(0x00008C5500000000 AS DateTime), CAST(0x00008C4A00000000 AS DateTime), 2, CAST(278.96000 AS Decimal(19, 5)), N'Eastern Connection', N'35 King George', N'London', N'null', N'WX3 6FW', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11057, N'NORTS', 3, CAST(0x00008C4800000000 AS DateTime), CAST(0x00008C6400000000 AS DateTime), CAST(0x00008C4A00000000 AS DateTime), 3, CAST(4.13000 AS Decimal(19, 5)), N'North/South', N'South House 300 Queensbridge', N'London', N'null', N'SW7 1RZ', N'UK')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11058, N'BLAUS', 9, CAST(0x00008C4800000000 AS DateTime), CAST(0x00008C6400000000 AS DateTime), NULL, 3, CAST(31.14000 AS Decimal(19, 5)), N'Blauer See Delikatessen', N'Forsterstr. 57', N'Mannheim', N'null', N'68306', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11059, N'RICAR', 2, CAST(0x00008C4800000000 AS DateTime), CAST(0x00008C7200000000 AS DateTime), NULL, 2, CAST(85.80000 AS Decimal(19, 5)), N'Ricardo Adocicados', N'Av. Copacabana, 267', N'Rio de Janeiro', N'RJ', N'02389-890', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11060, N'FRANS', 2, CAST(0x00008C4900000000 AS DateTime), CAST(0x00008C6500000000 AS DateTime), CAST(0x00008C4D00000000 AS DateTime), 2, CAST(10.98000 AS Decimal(19, 5)), N'Franchi S.p.A.', N'Via Monte Bianco 34', N'Torino', N'null', N'10100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11061, N'GREAL', 4, CAST(0x00008C4900000000 AS DateTime), CAST(0x00008C7300000000 AS DateTime), NULL, 3, CAST(14.01000 AS Decimal(19, 5)), N'Great Lakes Food Market', N'2732 Baker Blvd.', N'Eugene', N'OR', N'97403', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11062, N'REGGC', 4, CAST(0x00008C4900000000 AS DateTime), CAST(0x00008C6500000000 AS DateTime), NULL, 2, CAST(29.93000 AS Decimal(19, 5)), N'Reggiani Caseifici', N'Strada Provinciale 124', N'Reggio Emilia', N'null', N'42100', N'Italy')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11063, N'HUNGO', 3, CAST(0x00008C4900000000 AS DateTime), CAST(0x00008C6500000000 AS DateTime), CAST(0x00008C4F00000000 AS DateTime), 2, CAST(81.73000 AS Decimal(19, 5)), N'Hungry Owl All-Night Grocers', N'8 Johnstown Road', N'Cork', N'Co. Cork', N'null', N'Ireland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11064, N'SAVEA', 1, CAST(0x00008C4A00000000 AS DateTime), CAST(0x00008C6600000000 AS DateTime), CAST(0x00008C4D00000000 AS DateTime), 1, CAST(30.09000 AS Decimal(19, 5)), N'Save-a-lot Markets', N'187 Suffolk Ln.', N'Boise', N'ID', N'83720', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11065, N'LILAS', 8, CAST(0x00008C4A00000000 AS DateTime), CAST(0x00008C6600000000 AS DateTime), NULL, 1, CAST(12.91000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11066, N'WHITC', 7, CAST(0x00008C4A00000000 AS DateTime), CAST(0x00008C6600000000 AS DateTime), CAST(0x00008C4D00000000 AS DateTime), 2, CAST(44.72000 AS Decimal(19, 5)), N'White Clover Markets', N'1029 - 12th Ave. S.', N'Seattle', N'WA', N'98124', N'USA')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11067, N'DRACD', 1, CAST(0x00008C4D00000000 AS DateTime), CAST(0x00008C5B00000000 AS DateTime), CAST(0x00008C4F00000000 AS DateTime), 2, CAST(7.98000 AS Decimal(19, 5)), N'Drachenblut Delikatessen', N'Walserweg 21', N'Aachen', N'null', N'52066', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11068, N'QUEEN', 8, CAST(0x00008C4D00000000 AS DateTime), CAST(0x00008C6900000000 AS DateTime), NULL, 2, CAST(81.75000 AS Decimal(19, 5)), N'Queen Cozinha', N'Alameda dos Canàrios, 891', N'Sao Paulo', N'SP', N'05487-020', N'Brazil')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11069, N'TORTU', 1, CAST(0x00008C4D00000000 AS DateTime), CAST(0x00008C6900000000 AS DateTime), CAST(0x00008C4F00000000 AS DateTime), 2, CAST(15.67000 AS Decimal(19, 5)), N'Tortuga Restaurante', N'Avda. Azteca 123', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11070, N'LEHMS', 2, CAST(0x00008C4E00000000 AS DateTime), CAST(0x00008C6A00000000 AS DateTime), NULL, 1, CAST(136.00000 AS Decimal(19, 5)), N'Lehmanns Marktstand', N'Magazinweg 7', N'Frankfurt a.M.', N'null', N'60528', N'Germany')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11071, N'LILAS', 1, CAST(0x00008C4E00000000 AS DateTime), CAST(0x00008C6A00000000 AS DateTime), NULL, 1, CAST(0.93000 AS Decimal(19, 5)), N'LILA-Supermercado', N'Carrera 52 con Ave. Bolívar #65-98 Llano Largo', N'Barquisimeto', N'Lara', N'3508', N'Venezuela')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11072, N'ERNSH', 4, CAST(0x00008C4E00000000 AS DateTime), CAST(0x00008C6A00000000 AS DateTime), NULL, 2, CAST(258.64000 AS Decimal(19, 5)), N'Ernst Handel', N'Kirchgasse 6', N'Graz', N'null', N'8010', N'Austria')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11073, N'PERIC', 2, CAST(0x00008C4E00000000 AS DateTime), CAST(0x00008C6A00000000 AS DateTime), NULL, 2, CAST(24.95000 AS Decimal(19, 5)), N'Pericles Comidas clásicas', N'Calle Dr. Jorge Cash 321', N'México D.F.', N'null', N'05033', N'Mexico')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11074, N'SIMOB', 7, CAST(0x00008C4F00000000 AS DateTime), CAST(0x00008C6B00000000 AS DateTime), NULL, 2, CAST(18.44000 AS Decimal(19, 5)), N'Simons bistro', N'Vinbæltet 34', N'Kobenhavn', N'null', N'1734', N'Denmark')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11075, N'RICSU', 8, CAST(0x00008C4F00000000 AS DateTime), CAST(0x00008C6B00000000 AS DateTime), NULL, 2, CAST(6.19000 AS Decimal(19, 5)), N'Richter Supermarkt', N'Starenweg 5', N'Genève', N'null', N'1204', N'Switzerland')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11076, N'BONAP', 4, CAST(0x00008C4F00000000 AS DateTime), CAST(0x00008C6B00000000 AS DateTime), NULL, 2, CAST(38.28000 AS Decimal(19, 5)), N'Bon app''', N'12, rue des Bouchers', N'Marseille', N'null', N'13008', N'France')
INSERT [dbo].[Orders] ([OrderId], [CustomerId], [EmployeeId], [OrderDate], [RequiredDate], [ShippedDate], [ShipVia], [Freight], [ShipName], [ShipAddress], [ShipCity], [ShipRegion], [ShipPostalCode], [ShipCountry]) VALUES (11077, N'RATTC', 1, CAST(0x00008C4F00000000 AS DateTime), CAST(0x00008C6B00000000 AS DateTime), NULL, 2, CAST(8.53000 AS Decimal(19, 5)), N'Rattlesnake Canyon Grocery', N'2817 Milton Dr.', N'Albuquerque', N'NM', N'87110', N'USA')
/****** Object:  Table [dbo].[Mammal]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Mammal](
	[Animal] [int] NOT NULL,
	[Pregnant] [bit] NULL,
	[BirthDate] [datetime] NULL,
PRIMARY KEY CLUSTERED 
(
	[Animal] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Mammal] ([Animal], [Pregnant], [BirthDate]) VALUES (4, 0, CAST(0x000072E300000000 AS DateTime))
INSERT [dbo].[Mammal] ([Animal], [Pregnant], [BirthDate]) VALUES (5, 0, CAST(0x0000737E00000000 AS DateTime))
INSERT [dbo].[Mammal] ([Animal], [Pregnant], [BirthDate]) VALUES (6, 1, NULL)
/****** Object:  Table [dbo].[Roles]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Roles](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](255) NULL,
	[IsActive] [bit] NULL,
	[EntityId] [int] NULL,
	[ParentId] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[Roles] ON
INSERT [dbo].[Roles] ([Id], [Name], [IsActive], [EntityId], [ParentId]) VALUES (1, N'Admin', 1, 1, NULL)
INSERT [dbo].[Roles] ([Id], [Name], [IsActive], [EntityId], [ParentId]) VALUES (2, N'User', 0, NULL, NULL)
SET IDENTITY_INSERT [dbo].[Roles] OFF
/****** Object:  Table [dbo].[Reptile]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Reptile](
	[Animal] [int] NOT NULL,
	[BodyTemperature] [float] NULL,
PRIMARY KEY CLUSTERED 
(
	[Animal] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Reptile] ([Animal], [BodyTemperature]) VALUES (2, 14)
INSERT [dbo].[Reptile] ([Animal], [BodyTemperature]) VALUES (3, 18)
/****** Object:  Table [dbo].[Products]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Products](
	[ProductId] [int] NOT NULL,
	[ProductName] [nvarchar](40) NOT NULL,
	[SupplierId] [int] NULL,
	[CategoryId] [int] NULL,
	[QuantityPerUnit] [nvarchar](20) NULL,
	[UnitPrice] [decimal](19, 5) NULL,
	[UnitsInStock] [int] NULL,
	[UnitsOnOrder] [int] NULL,
	[ReorderLevel] [int] NULL,
	[Discontinued] [bit] NOT NULL,
	[ShippingWeight] [float] NULL,
PRIMARY KEY CLUSTERED 
(
	[ProductId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (1, N'Chai', 1, 1, N'10 boxes x 20 bags', CAST(18.00000 AS Decimal(19, 5)), 39, 0, 10, 0, 10.1)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (2, N'Chang', 1, 1, N'24 - 12 oz bottles', CAST(19.00000 AS Decimal(19, 5)), 17, 40, 25, 0, 23.142)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (3, N'Aniseed Syrup', 1, 2, N'12 - 550 ml bottles', CAST(10.00000 AS Decimal(19, 5)), 13, 70, 25, 0, 5.44)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (4, N'Chef Anton''s Cajun Seasoning', 2, 2, N'48 - 6 oz jars', CAST(22.00000 AS Decimal(19, 5)), 53, 0, 0, 0, 8.08)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (5, N'Chef Anton''s Gumbo Mix', 2, 2, N'36 boxes', CAST(21.35000 AS Decimal(19, 5)), 0, 0, 0, 1, 9.0)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (6, N'Grandma''s Boysenberry Spread', 3, 2, N'12 - 8 oz jars', CAST(25.00000 AS Decimal(19, 5)), 120, 0, 25, 0, 9.0)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (7, N'Uncle Bob''s Organic Dried Pears', 3, 7, N'12 - 1 lb pkgs.', CAST(30.00000 AS Decimal(19, 5)), 15, 0, 10, 0, 11.1)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (8, N'Northwoods Cranberry Sauce', 3, 2, N'12 - 12 oz jars', CAST(40.00000 AS Decimal(19, 5)), 6, 0, 0, 0, 11.01)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (9, N'Mishi Kobe Niku', 4, 6, N'18 - 500 g pkgs.', CAST(97.00000 AS Decimal(19, 5)), 29, 0, 0, 1, 3.022)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (10, N'Ikura', 4, 8, N'12 - 200 ml jars', CAST(31.00000 AS Decimal(19, 5)), 31, 0, 0, 0, 15.225)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (11, N'Queso Cabrales', 5, 4, N'1 kg pkg.', CAST(21.00000 AS Decimal(19, 5)), 22, 30, 30, 0, 13.3333)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (12, N'Queso Manchego La Pastora', 5, 4, N'10 - 500 g pkgs.', CAST(38.00000 AS Decimal(19, 5)), 86, 0, 0, 0, 9.0)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (13, N'Konbu', 6, 8, N'2 kg box', CAST(6.00000 AS Decimal(19, 5)), 24, 0, 5, 0, 8.0)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (14, N'Tofu', 6, 7, N'40 - 100 g pkgs.', CAST(23.25000 AS Decimal(19, 5)), 35, 0, 0, 0, 8.0)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (15, N'Genen Shouyu', 6, 2, N'24 - 250 ml bottles', CAST(15.50000 AS Decimal(19, 5)), 39, 0, 5, 0, 7.5)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (16, N'Pavlova', 7, 3, N'32 - 500 g boxes', CAST(17.45000 AS Decimal(19, 5)), 29, 0, 10, 0, 6.25)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (17, N'Alice Mutton', 7, 6, N'20 - 1 kg tins', CAST(39.00000 AS Decimal(19, 5)), 0, 0, 0, 1, 8.755)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (18, N'Carnarvon Tigers', 7, 8, N'16 kg pkg.', CAST(62.50000 AS Decimal(19, 5)), 42, 0, 0, 0, 6.33)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (19, N'Teatime Chocolate Biscuits', 8, 3, N'10 boxes x 12 pieces', CAST(9.20000 AS Decimal(19, 5)), 25, 0, 5, 0, 4)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (20, N'Sir Rodney''s Marmalade', 8, 3, N'30 gift boxes', CAST(81.00000 AS Decimal(19, 5)), 40, 0, 0, 0, 2.22)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (21, N'Sir Rodney''s Scones', 8, 3, N'24 pkgs. x 4 pieces', CAST(10.00000 AS Decimal(19, 5)), 3, 40, 5, 0, 3.671)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (22, N'Gustaf''s Knäckebröd', 9, 5, N'24 - 500 g pkgs.', CAST(21.00000 AS Decimal(19, 5)), 104, 0, 25, 0, 7.77)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (23, N'Tunnbröd', 9, 5, N'12 - 250 g pkgs.', CAST(9.00000 AS Decimal(19, 5)), 61, 0, 25, 0, 9.98944)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (24, N'Guaraná Fantástica', 10, 1, N'12 - 355 ml cans', CAST(4.50000 AS Decimal(19, 5)), 20, 0, 0, 1, 4.5)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (25, N'NuNuCa Nuß-Nougat-Creme', 11, 3, N'20 - 450 g glasses', CAST(14.00000 AS Decimal(19, 5)), 76, 0, 30, 0, 3.5)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (26, N'Gumbär Gummibärchen', 11, 3, N'100 - 250 g bags', CAST(31.23000 AS Decimal(19, 5)), 15, 0, 0, 0, 8.88)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (27, N'Schoggi Schokolade', 11, 3, N'100 - 100 g pieces', CAST(43.90000 AS Decimal(19, 5)), 49, 0, 30, 0, 9.00)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (28, N'Rössle Sauerkraut', 12, 7, N'25 - 825 g cans', CAST(45.60000 AS Decimal(19, 5)), 26, 0, 0, 1, 10)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (29, N'Thüringer Rostbratwurst', 12, 6, N'50 bags x 30 sausgs.', CAST(123.79000 AS Decimal(19, 5)), 0, 0, 0, 1, 7.321)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (30, N'Nord-Ost Matjeshering', 13, 8, N'10 - 200 g glasses', CAST(25.89000 AS Decimal(19, 5)), 10, 0, 15, 0, 5.55)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (31, N'Gorgonzola Telino', 14, 4, N'12 - 100 g pkgs', CAST(12.50000 AS Decimal(19, 5)), 0, 70, 20, 0, 17.0)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (32, N'Mascarpone Fabioli', 14, 4, N'24 - 200 g pkgs.', CAST(32.00000 AS Decimal(19, 5)), 9, 40, 25, 0, 3)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (33, N'Geitost', 15, 4, N'500 g', CAST(2.50000 AS Decimal(19, 5)), 112, 0, 20, 0, 9)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (34, N'Sasquatch Ale', 16, 1, N'24 - 12 oz bottles', CAST(14.00000 AS Decimal(19, 5)), 111, 0, 15, 0, 3)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (35, N'Steeleye Stout', 16, 1, N'24 - 12 oz bottles', CAST(18.00000 AS Decimal(19, 5)), 20, 0, 15, 0, 4)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (36, N'Inlagd Sill', 17, 8, N'24 - 250 g  jars', CAST(19.00000 AS Decimal(19, 5)), 112, 0, 20, 0, 5)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (37, N'Gravad lax', 17, 8, N'12 - 500 g pkgs.', CAST(26.00000 AS Decimal(19, 5)), 11, 50, 25, 0, 6)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (38, N'Côte de Blaye', 18, 1, N'12 - 75 cl bottles', CAST(263.50000 AS Decimal(19, 5)), 17, 0, 15, 0, 4.43)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (39, N'Chartreuse verte', 18, 1, N'750 cc per bottle', CAST(18.00000 AS Decimal(19, 5)), 69, 0, 5, 0, 7.99)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (40, N'Boston Crab Meat', 19, 8, N'24 - 4 oz tins', CAST(18.40000 AS Decimal(19, 5)), 123, 0, 30, 0, 9.77)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (41, N'Jack''s New England Clam Chowder', 19, 8, N'12 - 12 oz cans', CAST(9.65000 AS Decimal(19, 5)), 85, 0, 10, 0, 4.98)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (42, N'Singaporean Hokkien Fried Mee', 20, 5, N'32 - 1 kg pkgs.', CAST(14.00000 AS Decimal(19, 5)), 26, 0, 0, 1, 9.565)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (43, N'Ipoh Coffee', 20, 1, N'16 - 500 g tins', CAST(46.00000 AS Decimal(19, 5)), 17, 10, 25, 0, 6.555)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (44, N'Gula Malacca', 20, 2, N'20 - 2 kg bags', CAST(19.45000 AS Decimal(19, 5)), 27, 0, 15, 0, 5.111)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (45, N'Rogede sild', 21, 8, N'1k pkg.', CAST(9.50000 AS Decimal(19, 5)), 5, 70, 15, 0, 7.6)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (46, N'Spegesild', 21, 8, N'4 - 450 g glasses', CAST(12.00000 AS Decimal(19, 5)), 95, 0, 0, 0, 8.8)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (47, N'Zaanse koeken', 22, 3, N'10 - 4 oz boxes', CAST(9.50000 AS Decimal(19, 5)), 36, 0, 0, 0, 4.3)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (48, N'Chocolade', 22, 3, N'10 pkgs.', CAST(12.75000 AS Decimal(19, 5)), 15, 70, 25, 0, 5.5)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (49, N'Maxilaku', 23, 3, N'24 - 50 g pkgs.', CAST(20.00000 AS Decimal(19, 5)), 10, 60, 15, 0, 6.6)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (50, N'Valkoinen suklaa', 23, 3, N'12 - 100 g bars', CAST(16.25000 AS Decimal(19, 5)), 65, 0, 30, 0, 8.888)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (51, N'Manjimup Dried Apples', 24, 7, N'50 - 300 g pkgs.', CAST(53.00000 AS Decimal(19, 5)), 20, 0, 10, 0, 7.654)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (52, N'Filo Mix', 24, 5, N'16 - 2 kg boxes', CAST(7.00000 AS Decimal(19, 5)), 38, 0, 25, 0, 1.2345)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (53, N'Perth Pasties', 24, 6, N'48 pieces', CAST(32.80000 AS Decimal(19, 5)), 0, 0, 0, 1, 9.12)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (54, N'Tourtière', 25, 6, N'16 pies', CAST(7.45000 AS Decimal(19, 5)), 21, 0, 10, 0, 5)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (55, N'Pâté chinois', 25, 6, N'24 boxes x 2 pies', CAST(24.00000 AS Decimal(19, 5)), 115, 0, 20, 0, 6)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (56, N'Gnocchi di nonna Alice', 26, 5, N'24 - 250 g pkgs.', CAST(38.00000 AS Decimal(19, 5)), 21, 10, 30, 0, 7.0)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (57, N'Ravioli Angelo', 26, 5, N'24 - 250 g pkgs.', CAST(19.50000 AS Decimal(19, 5)), 36, 0, 20, 0, 8.22)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (58, N'Escargots de Bourgogne', 27, 8, N'24 pieces', CAST(13.25000 AS Decimal(19, 5)), 62, 0, 20, 0, 8.33)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (59, N'Raclette Courdavault', 28, 4, N'5 kg pkg.', CAST(55.00000 AS Decimal(19, 5)), 79, 0, 0, 0, 8.44)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (60, N'Camembert Pierrot', 28, 4, N'15 - 300 g rounds', CAST(34.00000 AS Decimal(19, 5)), 19, 0, 0, 0, 7.74)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (61, N'Sirop d''érable', 29, 2, N'24 - 500 ml bottles', CAST(28.50000 AS Decimal(19, 5)), 113, 0, 25, 0, 7.11111)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (62, N'Tarte au sucre', 29, 3, N'48 pies', CAST(49.30000 AS Decimal(19, 5)), 17, 0, 0, 0, 8.9123)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (63, N'Vegie-spread', 7, 2, N'15 - 625 g jars', CAST(43.90000 AS Decimal(19, 5)), 24, 0, 5, 0, 5)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (64, N'Wimmers gute Semmelknödel', 12, 5, N'20 bags x 4 pieces', CAST(33.25000 AS Decimal(19, 5)), 22, 80, 30, 0, 6)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (65, N'Louisiana Fiery Hot Pepper Sauce', 2, 2, N'32 - 8 oz bottles', CAST(21.05000 AS Decimal(19, 5)), 76, 0, 0, 0, 13.3)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (66, N'Louisiana Hot Spiced Okra', 2, 2, N'24 - 8 oz jars', CAST(17.00000 AS Decimal(19, 5)), 4, 100, 20, 0, 12.4)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (67, N'Laughing Lumberjack Lager', 16, 1, N'24 - 12 oz bottles', CAST(14.00000 AS Decimal(19, 5)), 52, 0, 10, 0, 7.6767)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (68, N'Scottish Longbreads', 8, 3, N'10 boxes x 8 pieces', CAST(12.50000 AS Decimal(19, 5)), 6, 10, 15, 0, 5.556)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (69, N'Gudbrandsdalsost', 15, 4, N'10 kg pkg.', CAST(36.00000 AS Decimal(19, 5)), 26, 0, 15, 0, 9.302)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (70, N'Outback Lager', 7, 1, N'24 - 355 ml bottles', CAST(15.00000 AS Decimal(19, 5)), 15, 10, 30, 0, 2.654)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (71, N'Flotemysost', 15, 4, N'10 - 500 g pkgs.', CAST(21.50000 AS Decimal(19, 5)), 26, 0, 0, 0, 9.375)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (72, N'Mozzarella di Giovanni', 14, 4, N'24 - 200 g pkgs.', CAST(34.80000 AS Decimal(19, 5)), 14, 0, 0, 0, 2)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (73, N'Röd Kaviar', 17, 8, N'24 - 150 g jars', CAST(15.00000 AS Decimal(19, 5)), 101, 0, 5, 0, 4)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (74, N'Longlife Tofu', 4, 7, N'5 kg pkg.', CAST(10.00000 AS Decimal(19, 5)), 4, 20, 5, 0, 7.139)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (75, N'Rhönbräu Klosterbier', 12, 1, N'24 - 0.5 l bottles', CAST(7.75000 AS Decimal(19, 5)), 125, 0, 25, 0, 6.667)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (76, N'Lakkalikööri', 23, 1, N'500 ml', CAST(18.00000 AS Decimal(19, 5)), 57, 0, 20, 0, 5.4)
INSERT [dbo].[Products] ([ProductId], [ProductName], [SupplierId], [CategoryId], [QuantityPerUnit], [UnitPrice], [UnitsInStock], [UnitsOnOrder], [ReorderLevel], [Discontinued], [ShippingWeight]) VALUES (77, N'Original Frankfurter grüne Soße', 12, 2, N'12 boxes', CAST(13.00000 AS Decimal(19, 5)), 32, 0, 15, 0, 3)
/****** Object:  Table [dbo].[Patients]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Patients](
	[PatientId] [bigint] IDENTITY(1,1) NOT NULL,
	[Active] [bit] NOT NULL,
	[PhysicianId] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[PatientId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[Patients] ON
INSERT [dbo].[Patients] ([PatientId], [Active], [PhysicianId]) VALUES (1, 0, 1)
INSERT [dbo].[Patients] ([PatientId], [Active], [PhysicianId]) VALUES (2, 1, 2)
SET IDENTITY_INSERT [dbo].[Patients] OFF
/****** Object:  Table [dbo].[PatientRecords]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PatientRecords](
	[PatientRecordId] [bigint] IDENTITY(1,1) NOT NULL,
	[Gender] [int] NOT NULL,
	[BirthDate] [datetime] NOT NULL,
	[FirstName] [nvarchar](255) NOT NULL,
	[LastName] [nvarchar](255) NOT NULL,
	[AddressLine1] [nvarchar](255) NULL,
	[AddressLine2] [nvarchar](255) NULL,
	[City] [nvarchar](255) NULL,
	[StateId] [bigint] NULL,
	[ZipCode] [nvarchar](255) NULL,
	[PatientId] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[PatientRecordId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[PatientRecords] ON
INSERT [dbo].[PatientRecords] ([PatientRecordId], [Gender], [BirthDate], [FirstName], [LastName], [AddressLine1], [AddressLine2], [City], [StateId], [ZipCode], [PatientId]) VALUES (1, 1, CAST(0x00002ACD00000000 AS DateTime), N'Bob', N'Barker', N'123 Main St', NULL, N'New York', 1, N'10001', 1)
INSERT [dbo].[PatientRecords] ([PatientRecordId], [Gender], [BirthDate], [FirstName], [LastName], [AddressLine1], [AddressLine2], [City], [StateId], [ZipCode], [PatientId]) VALUES (2, 1, CAST(0x0000627200000000 AS DateTime), N'John', N'Doe', N'123 Main St', NULL, N'Tampa', 2, N'33602', 2)
INSERT [dbo].[PatientRecords] ([PatientRecordId], [Gender], [BirthDate], [FirstName], [LastName], [AddressLine1], [AddressLine2], [City], [StateId], [ZipCode], [PatientId]) VALUES (3, 0, CAST(0x0000627200000000 AS DateTime), N'John', N'Doe', N'123 Main St', N'Apt 2', N'Tampa', 2, N'33602', 2)
SET IDENTITY_INSERT [dbo].[PatientRecords] OFF
/****** Object:  Table [dbo].[Lizard]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Lizard](
	[Reptile] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[Reptile] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Lizard] ([Reptile]) VALUES (2)
INSERT [dbo].[Lizard] ([Reptile]) VALUES (3)
/****** Object:  Table [dbo].[EmployeeTerritories]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[EmployeeTerritories](
	[EmployeeId] [int] NOT NULL,
	[TerritoryId] [bigint] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[TerritoryId] ASC,
	[EmployeeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Dog]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Dog](
	[Mammal] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[Mammal] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Dog] ([Mammal]) VALUES (4)
INSERT [dbo].[Dog] ([Mammal]) VALUES (5)
/****** Object:  Table [dbo].[Cat]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Cat](
	[Mammal] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[Mammal] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[Cat] ([Mammal]) VALUES (6)
/****** Object:  Table [dbo].[OrderLines]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OrderLines](
	[OrderLineId] [bigint] IDENTITY(1,1) NOT NULL,
	[OrderId] [int] NOT NULL,
	[ProductId] [int] NOT NULL,
	[UnitPrice] [decimal](19, 5) NOT NULL,
	[Quantity] [int] NOT NULL,
	[Discount] [decimal](19, 5) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[OrderLineId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[OrderLines] ON
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1, 10248, 11, CAST(14.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2, 10248, 42, CAST(9.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (3, 10248, 72, CAST(34.80000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (4, 10249, 14, CAST(18.60000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (5, 10249, 51, CAST(42.40000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (6, 10250, 41, CAST(7.70000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (7, 10250, 51, CAST(42.40000 AS Decimal(19, 5)), 35, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (8, 10250, 65, CAST(16.80000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (9, 10251, 22, CAST(16.80000 AS Decimal(19, 5)), 6, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (10, 10251, 57, CAST(15.60000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (11, 10251, 65, CAST(16.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (12, 10252, 20, CAST(64.80000 AS Decimal(19, 5)), 40, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (13, 10252, 33, CAST(2.00000 AS Decimal(19, 5)), 25, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (14, 10252, 60, CAST(27.20000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (15, 10253, 31, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (16, 10253, 39, CAST(14.40000 AS Decimal(19, 5)), 42, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (17, 10253, 49, CAST(16.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (18, 10254, 24, CAST(3.60000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (19, 10254, 55, CAST(19.20000 AS Decimal(19, 5)), 21, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (20, 10254, 74, CAST(8.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (21, 10255, 2, CAST(15.20000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (22, 10255, 16, CAST(13.90000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (23, 10255, 36, CAST(15.20000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (24, 10255, 59, CAST(44.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (25, 10256, 53, CAST(26.20000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (26, 10256, 77, CAST(10.40000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (27, 10257, 27, CAST(35.10000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (28, 10257, 39, CAST(14.40000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (29, 10257, 77, CAST(10.40000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (30, 10258, 2, CAST(15.20000 AS Decimal(19, 5)), 50, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (31, 10258, 5, CAST(17.00000 AS Decimal(19, 5)), 65, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (32, 10258, 32, CAST(25.60000 AS Decimal(19, 5)), 6, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (33, 10259, 21, CAST(8.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (34, 10259, 37, CAST(20.80000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (35, 10260, 41, CAST(7.70000 AS Decimal(19, 5)), 16, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (36, 10260, 57, CAST(15.60000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (37, 10260, 62, CAST(39.40000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (38, 10260, 70, CAST(12.00000 AS Decimal(19, 5)), 21, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (39, 10261, 21, CAST(8.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (40, 10261, 35, CAST(14.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (41, 10262, 5, CAST(17.00000 AS Decimal(19, 5)), 12, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (42, 10262, 7, CAST(24.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (43, 10262, 56, CAST(30.40000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (44, 10263, 16, CAST(13.90000 AS Decimal(19, 5)), 60, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (45, 10263, 24, CAST(3.60000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (46, 10263, 30, CAST(20.70000 AS Decimal(19, 5)), 60, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (47, 10263, 74, CAST(8.00000 AS Decimal(19, 5)), 36, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (48, 10264, 2, CAST(15.20000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (49, 10264, 41, CAST(7.70000 AS Decimal(19, 5)), 25, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (50, 10265, 17, CAST(31.20000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (51, 10265, 70, CAST(12.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (52, 10266, 12, CAST(30.40000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (53, 10267, 40, CAST(14.70000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (54, 10267, 59, CAST(44.00000 AS Decimal(19, 5)), 70, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (55, 10267, 76, CAST(14.40000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (56, 10268, 29, CAST(99.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (57, 10268, 72, CAST(27.80000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (58, 10269, 33, CAST(2.00000 AS Decimal(19, 5)), 60, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (59, 10269, 72, CAST(27.80000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (60, 10270, 36, CAST(15.20000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (61, 10270, 43, CAST(36.80000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (62, 10271, 33, CAST(2.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (63, 10272, 20, CAST(64.80000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (64, 10272, 31, CAST(10.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (65, 10272, 72, CAST(27.80000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (66, 10273, 10, CAST(24.80000 AS Decimal(19, 5)), 24, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (67, 10273, 31, CAST(10.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (68, 10273, 33, CAST(2.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (69, 10273, 40, CAST(14.70000 AS Decimal(19, 5)), 60, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (70, 10273, 76, CAST(14.40000 AS Decimal(19, 5)), 33, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (71, 10274, 71, CAST(17.20000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (72, 10274, 72, CAST(27.80000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (73, 10275, 24, CAST(3.60000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (74, 10275, 59, CAST(44.00000 AS Decimal(19, 5)), 6, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (75, 10276, 10, CAST(24.80000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (76, 10276, 13, CAST(4.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (77, 10277, 28, CAST(36.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (78, 10277, 62, CAST(39.40000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (79, 10278, 44, CAST(15.50000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (80, 10278, 59, CAST(44.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (81, 10278, 63, CAST(35.10000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (82, 10278, 73, CAST(12.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (83, 10279, 17, CAST(31.20000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (84, 10280, 24, CAST(3.60000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (85, 10280, 55, CAST(19.20000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (86, 10280, 75, CAST(6.20000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (87, 10281, 19, CAST(7.30000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (88, 10281, 24, CAST(3.60000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (89, 10281, 35, CAST(14.40000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (90, 10282, 30, CAST(20.70000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (91, 10282, 57, CAST(15.60000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (92, 10283, 15, CAST(12.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (93, 10283, 19, CAST(7.30000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (94, 10283, 60, CAST(27.20000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (95, 10283, 72, CAST(27.80000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (96, 10284, 27, CAST(35.10000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (97, 10284, 44, CAST(15.50000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (98, 10284, 60, CAST(27.20000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (99, 10284, 67, CAST(11.20000 AS Decimal(19, 5)), 5, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (100, 10285, 1, CAST(14.40000 AS Decimal(19, 5)), 45, CAST(0.20000 AS Decimal(19, 5)))
GO
print 'Processed 100 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (101, 10285, 40, CAST(14.70000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (102, 10285, 53, CAST(26.20000 AS Decimal(19, 5)), 36, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (103, 10286, 35, CAST(14.40000 AS Decimal(19, 5)), 100, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (104, 10286, 62, CAST(39.40000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (105, 10287, 16, CAST(13.90000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (106, 10287, 34, CAST(11.20000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (107, 10287, 46, CAST(9.60000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (108, 10288, 54, CAST(5.90000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (109, 10288, 68, CAST(10.00000 AS Decimal(19, 5)), 3, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (110, 10289, 3, CAST(8.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (111, 10289, 64, CAST(26.60000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (112, 10290, 5, CAST(17.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (113, 10290, 29, CAST(99.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (114, 10290, 49, CAST(16.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (115, 10290, 77, CAST(10.40000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (116, 10291, 13, CAST(4.80000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (117, 10291, 44, CAST(15.50000 AS Decimal(19, 5)), 24, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (118, 10291, 51, CAST(42.40000 AS Decimal(19, 5)), 2, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (119, 10292, 20, CAST(64.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (120, 10293, 18, CAST(50.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (121, 10293, 24, CAST(3.60000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (122, 10293, 63, CAST(35.10000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (123, 10293, 75, CAST(6.20000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (124, 10294, 1, CAST(14.40000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (125, 10294, 17, CAST(31.20000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (126, 10294, 43, CAST(36.80000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (127, 10294, 60, CAST(27.20000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (128, 10294, 75, CAST(6.20000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (129, 10295, 56, CAST(30.40000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (130, 10296, 11, CAST(16.80000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (131, 10296, 16, CAST(13.90000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (132, 10296, 69, CAST(28.80000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (133, 10297, 39, CAST(14.40000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (134, 10297, 72, CAST(27.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (135, 10298, 2, CAST(15.20000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (136, 10298, 36, CAST(15.20000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (137, 10298, 59, CAST(44.00000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (138, 10298, 62, CAST(39.40000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (139, 10299, 19, CAST(7.30000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (140, 10299, 70, CAST(12.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (141, 10300, 66, CAST(13.60000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (142, 10300, 68, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (143, 10301, 40, CAST(14.70000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (144, 10301, 56, CAST(30.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (145, 10302, 17, CAST(31.20000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (146, 10302, 28, CAST(36.40000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (147, 10302, 43, CAST(36.80000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (148, 10303, 40, CAST(14.70000 AS Decimal(19, 5)), 40, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (149, 10303, 65, CAST(16.80000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (150, 10303, 68, CAST(10.00000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (151, 10304, 49, CAST(16.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (152, 10304, 59, CAST(44.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (153, 10304, 71, CAST(17.20000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (154, 10305, 18, CAST(50.00000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (155, 10305, 29, CAST(99.00000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (156, 10305, 39, CAST(14.40000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (157, 10306, 30, CAST(20.70000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (158, 10306, 53, CAST(26.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (159, 10306, 54, CAST(5.90000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (160, 10307, 62, CAST(39.40000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (161, 10307, 68, CAST(10.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (162, 10308, 69, CAST(28.80000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (163, 10308, 70, CAST(12.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (164, 10309, 4, CAST(17.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (165, 10309, 6, CAST(20.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (166, 10309, 42, CAST(11.20000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (167, 10309, 43, CAST(36.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (168, 10309, 71, CAST(17.20000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (169, 10310, 16, CAST(13.90000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (170, 10310, 62, CAST(39.40000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (171, 10311, 42, CAST(11.20000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (172, 10311, 69, CAST(28.80000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (173, 10312, 28, CAST(36.40000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (174, 10312, 43, CAST(36.80000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (175, 10312, 53, CAST(26.20000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (176, 10312, 75, CAST(6.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (177, 10313, 36, CAST(15.20000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (178, 10314, 32, CAST(25.60000 AS Decimal(19, 5)), 40, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (179, 10314, 58, CAST(10.60000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (180, 10314, 62, CAST(39.40000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (181, 10315, 34, CAST(11.20000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (182, 10315, 70, CAST(12.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (183, 10316, 41, CAST(7.70000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (184, 10316, 62, CAST(39.40000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (185, 10317, 1, CAST(14.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (186, 10318, 41, CAST(7.70000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (187, 10318, 76, CAST(14.40000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (188, 10319, 17, CAST(31.20000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (189, 10319, 28, CAST(36.40000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (190, 10319, 76, CAST(14.40000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (191, 10320, 71, CAST(17.20000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (192, 10321, 35, CAST(14.40000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (193, 10322, 52, CAST(5.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (194, 10323, 15, CAST(12.40000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (195, 10323, 25, CAST(11.20000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (196, 10323, 39, CAST(14.40000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (197, 10324, 16, CAST(13.90000 AS Decimal(19, 5)), 21, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (198, 10324, 35, CAST(14.40000 AS Decimal(19, 5)), 70, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (199, 10324, 46, CAST(9.60000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (200, 10324, 59, CAST(44.00000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (201, 10324, 63, CAST(35.10000 AS Decimal(19, 5)), 80, CAST(0.15000 AS Decimal(19, 5)))
GO
print 'Processed 200 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (202, 10325, 6, CAST(20.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (203, 10325, 13, CAST(4.80000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (204, 10325, 14, CAST(18.60000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (205, 10325, 31, CAST(10.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (206, 10325, 72, CAST(27.80000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (207, 10326, 4, CAST(17.60000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (208, 10326, 57, CAST(15.60000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (209, 10326, 75, CAST(6.20000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (210, 10327, 2, CAST(15.20000 AS Decimal(19, 5)), 25, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (211, 10327, 11, CAST(16.80000 AS Decimal(19, 5)), 50, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (212, 10327, 30, CAST(20.70000 AS Decimal(19, 5)), 35, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (213, 10327, 58, CAST(10.60000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (214, 10328, 59, CAST(44.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (215, 10328, 65, CAST(16.80000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (216, 10328, 68, CAST(10.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (217, 10329, 19, CAST(7.30000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (218, 10329, 30, CAST(20.70000 AS Decimal(19, 5)), 8, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (219, 10329, 38, CAST(210.80000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (220, 10329, 56, CAST(30.40000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (221, 10330, 26, CAST(24.90000 AS Decimal(19, 5)), 50, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (222, 10330, 72, CAST(27.80000 AS Decimal(19, 5)), 25, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (223, 10331, 54, CAST(5.90000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (224, 10332, 18, CAST(50.00000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (225, 10332, 42, CAST(11.20000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (226, 10332, 47, CAST(7.60000 AS Decimal(19, 5)), 16, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (227, 10333, 14, CAST(18.60000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (228, 10333, 21, CAST(8.00000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (229, 10333, 71, CAST(17.20000 AS Decimal(19, 5)), 40, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (230, 10334, 52, CAST(5.60000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (231, 10334, 68, CAST(10.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (232, 10335, 2, CAST(15.20000 AS Decimal(19, 5)), 7, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (233, 10335, 31, CAST(10.00000 AS Decimal(19, 5)), 25, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (234, 10335, 32, CAST(25.60000 AS Decimal(19, 5)), 6, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (235, 10335, 51, CAST(42.40000 AS Decimal(19, 5)), 48, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (236, 10336, 4, CAST(17.60000 AS Decimal(19, 5)), 18, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (237, 10337, 23, CAST(7.20000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (238, 10337, 26, CAST(24.90000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (239, 10337, 36, CAST(15.20000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (240, 10337, 37, CAST(20.80000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (241, 10337, 72, CAST(27.80000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (242, 10338, 17, CAST(31.20000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (243, 10338, 30, CAST(20.70000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (244, 10339, 4, CAST(17.60000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (245, 10339, 17, CAST(31.20000 AS Decimal(19, 5)), 70, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (246, 10339, 62, CAST(39.40000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (247, 10340, 18, CAST(50.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (248, 10340, 41, CAST(7.70000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (249, 10340, 43, CAST(36.80000 AS Decimal(19, 5)), 40, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (250, 10341, 33, CAST(2.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (251, 10341, 59, CAST(44.00000 AS Decimal(19, 5)), 9, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (252, 10342, 2, CAST(15.20000 AS Decimal(19, 5)), 24, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (253, 10342, 31, CAST(10.00000 AS Decimal(19, 5)), 56, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (254, 10342, 36, CAST(15.20000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (255, 10342, 55, CAST(19.20000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (256, 10343, 64, CAST(26.60000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (257, 10343, 68, CAST(10.00000 AS Decimal(19, 5)), 4, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (258, 10343, 76, CAST(14.40000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (259, 10344, 4, CAST(17.60000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (260, 10344, 8, CAST(32.00000 AS Decimal(19, 5)), 70, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (261, 10345, 8, CAST(32.00000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (262, 10345, 19, CAST(7.30000 AS Decimal(19, 5)), 80, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (263, 10345, 42, CAST(11.20000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (264, 10346, 17, CAST(31.20000 AS Decimal(19, 5)), 36, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (265, 10346, 56, CAST(30.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (266, 10347, 25, CAST(11.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (267, 10347, 39, CAST(14.40000 AS Decimal(19, 5)), 50, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (268, 10347, 40, CAST(14.70000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (269, 10347, 75, CAST(6.20000 AS Decimal(19, 5)), 6, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (270, 10348, 1, CAST(14.40000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (271, 10348, 23, CAST(7.20000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (272, 10349, 54, CAST(5.90000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (273, 10350, 50, CAST(13.00000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (274, 10350, 69, CAST(28.80000 AS Decimal(19, 5)), 18, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (275, 10351, 38, CAST(210.80000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (276, 10351, 41, CAST(7.70000 AS Decimal(19, 5)), 13, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (277, 10351, 44, CAST(15.50000 AS Decimal(19, 5)), 77, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (278, 10351, 65, CAST(16.80000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (279, 10352, 24, CAST(3.60000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (280, 10352, 54, CAST(5.90000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (281, 10353, 11, CAST(16.80000 AS Decimal(19, 5)), 12, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (282, 10353, 38, CAST(210.80000 AS Decimal(19, 5)), 50, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (283, 10354, 1, CAST(14.40000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (284, 10354, 29, CAST(99.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (285, 10355, 24, CAST(3.60000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (286, 10355, 57, CAST(15.60000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (287, 10356, 31, CAST(10.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (288, 10356, 55, CAST(19.20000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (289, 10356, 69, CAST(28.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (290, 10357, 10, CAST(24.80000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (291, 10357, 26, CAST(24.90000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (292, 10357, 60, CAST(27.20000 AS Decimal(19, 5)), 8, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (293, 10358, 24, CAST(3.60000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (294, 10358, 34, CAST(11.20000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (295, 10358, 36, CAST(15.20000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (296, 10359, 16, CAST(13.90000 AS Decimal(19, 5)), 56, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (297, 10359, 31, CAST(10.00000 AS Decimal(19, 5)), 70, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (298, 10359, 60, CAST(27.20000 AS Decimal(19, 5)), 80, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (299, 10360, 28, CAST(36.40000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (300, 10360, 29, CAST(99.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (301, 10360, 38, CAST(210.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (302, 10360, 49, CAST(16.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 300 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (303, 10360, 54, CAST(5.90000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (304, 10361, 39, CAST(14.40000 AS Decimal(19, 5)), 54, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (305, 10361, 60, CAST(27.20000 AS Decimal(19, 5)), 55, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (306, 10362, 25, CAST(11.20000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (307, 10362, 51, CAST(42.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (308, 10362, 54, CAST(5.90000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (309, 10363, 31, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (310, 10363, 75, CAST(6.20000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (311, 10363, 76, CAST(14.40000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (312, 10364, 69, CAST(28.80000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (313, 10364, 71, CAST(17.20000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (314, 10365, 11, CAST(16.80000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (315, 10366, 65, CAST(16.80000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (316, 10366, 77, CAST(10.40000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (317, 10367, 34, CAST(11.20000 AS Decimal(19, 5)), 36, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (318, 10367, 54, CAST(5.90000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (319, 10367, 65, CAST(16.80000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (320, 10367, 77, CAST(10.40000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (321, 10368, 21, CAST(8.00000 AS Decimal(19, 5)), 5, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (322, 10368, 28, CAST(36.40000 AS Decimal(19, 5)), 13, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (323, 10368, 57, CAST(15.60000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (324, 10368, 64, CAST(26.60000 AS Decimal(19, 5)), 35, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (325, 10369, 29, CAST(99.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (326, 10369, 56, CAST(30.40000 AS Decimal(19, 5)), 18, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (327, 10370, 1, CAST(14.40000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (328, 10370, 64, CAST(26.60000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (329, 10370, 74, CAST(8.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (330, 10371, 36, CAST(15.20000 AS Decimal(19, 5)), 6, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (331, 10372, 20, CAST(64.80000 AS Decimal(19, 5)), 12, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (332, 10372, 38, CAST(210.80000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (333, 10372, 60, CAST(27.20000 AS Decimal(19, 5)), 70, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (334, 10372, 72, CAST(27.80000 AS Decimal(19, 5)), 42, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (335, 10373, 58, CAST(10.60000 AS Decimal(19, 5)), 80, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (336, 10373, 71, CAST(17.20000 AS Decimal(19, 5)), 50, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (337, 10374, 31, CAST(10.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (338, 10374, 58, CAST(10.60000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (339, 10375, 14, CAST(18.60000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (340, 10375, 54, CAST(5.90000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (341, 10376, 31, CAST(10.00000 AS Decimal(19, 5)), 42, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (342, 10377, 28, CAST(36.40000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (343, 10377, 39, CAST(14.40000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (344, 10378, 71, CAST(17.20000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (345, 10379, 41, CAST(7.70000 AS Decimal(19, 5)), 8, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (346, 10379, 63, CAST(35.10000 AS Decimal(19, 5)), 16, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (347, 10379, 65, CAST(16.80000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (348, 10380, 30, CAST(20.70000 AS Decimal(19, 5)), 18, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (349, 10380, 53, CAST(26.20000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (350, 10380, 60, CAST(27.20000 AS Decimal(19, 5)), 6, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (351, 10380, 70, CAST(12.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (352, 10381, 74, CAST(8.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (353, 10382, 5, CAST(17.00000 AS Decimal(19, 5)), 32, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (354, 10382, 18, CAST(50.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (355, 10382, 29, CAST(99.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (356, 10382, 33, CAST(2.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (357, 10382, 74, CAST(8.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (358, 10383, 13, CAST(4.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (359, 10383, 50, CAST(13.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (360, 10383, 56, CAST(30.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (361, 10384, 20, CAST(64.80000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (362, 10384, 60, CAST(27.20000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (363, 10385, 7, CAST(24.00000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (364, 10385, 60, CAST(27.20000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (365, 10385, 68, CAST(10.00000 AS Decimal(19, 5)), 8, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (366, 10386, 24, CAST(3.60000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (367, 10386, 34, CAST(11.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (368, 10387, 24, CAST(3.60000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (369, 10387, 28, CAST(36.40000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (370, 10387, 59, CAST(44.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (371, 10387, 71, CAST(17.20000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (372, 10388, 45, CAST(7.60000 AS Decimal(19, 5)), 15, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (373, 10388, 52, CAST(5.60000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (374, 10388, 53, CAST(26.20000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (375, 10389, 10, CAST(24.80000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (376, 10389, 55, CAST(19.20000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (377, 10389, 62, CAST(39.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (378, 10389, 70, CAST(12.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (379, 10390, 31, CAST(10.00000 AS Decimal(19, 5)), 60, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (380, 10390, 35, CAST(14.40000 AS Decimal(19, 5)), 40, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (381, 10390, 46, CAST(9.60000 AS Decimal(19, 5)), 45, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (382, 10390, 72, CAST(27.80000 AS Decimal(19, 5)), 24, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (383, 10391, 13, CAST(4.80000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (384, 10392, 69, CAST(28.80000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (385, 10393, 2, CAST(15.20000 AS Decimal(19, 5)), 25, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (386, 10393, 14, CAST(18.60000 AS Decimal(19, 5)), 42, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (387, 10393, 25, CAST(11.20000 AS Decimal(19, 5)), 7, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (388, 10393, 26, CAST(24.90000 AS Decimal(19, 5)), 70, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (389, 10393, 31, CAST(10.00000 AS Decimal(19, 5)), 32, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (390, 10394, 13, CAST(4.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (391, 10394, 62, CAST(39.40000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (392, 10395, 46, CAST(9.60000 AS Decimal(19, 5)), 28, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (393, 10395, 53, CAST(26.20000 AS Decimal(19, 5)), 70, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (394, 10395, 69, CAST(28.80000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (395, 10396, 23, CAST(7.20000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (396, 10396, 71, CAST(17.20000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (397, 10396, 72, CAST(27.80000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (398, 10397, 21, CAST(8.00000 AS Decimal(19, 5)), 10, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (399, 10397, 51, CAST(42.40000 AS Decimal(19, 5)), 18, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (400, 10398, 35, CAST(14.40000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (401, 10398, 55, CAST(19.20000 AS Decimal(19, 5)), 120, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (402, 10399, 68, CAST(10.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (403, 10399, 71, CAST(17.20000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 400 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (404, 10399, 76, CAST(14.40000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (405, 10399, 77, CAST(10.40000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (406, 10400, 29, CAST(99.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (407, 10400, 35, CAST(14.40000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (408, 10400, 49, CAST(16.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (409, 10401, 30, CAST(20.70000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (410, 10401, 56, CAST(30.40000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (411, 10401, 65, CAST(16.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (412, 10401, 71, CAST(17.20000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (413, 10402, 23, CAST(7.20000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (414, 10402, 63, CAST(35.10000 AS Decimal(19, 5)), 65, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (415, 10403, 16, CAST(13.90000 AS Decimal(19, 5)), 21, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (416, 10403, 48, CAST(10.20000 AS Decimal(19, 5)), 70, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (417, 10404, 26, CAST(24.90000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (418, 10404, 42, CAST(11.20000 AS Decimal(19, 5)), 40, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (419, 10404, 49, CAST(16.00000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (420, 10405, 3, CAST(8.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (421, 10406, 1, CAST(14.40000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (422, 10406, 21, CAST(8.00000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (423, 10406, 28, CAST(36.40000 AS Decimal(19, 5)), 42, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (424, 10406, 36, CAST(15.20000 AS Decimal(19, 5)), 5, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (425, 10406, 40, CAST(14.70000 AS Decimal(19, 5)), 2, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (426, 10407, 11, CAST(16.80000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (427, 10407, 69, CAST(28.80000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (428, 10407, 71, CAST(17.20000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (429, 10408, 37, CAST(20.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (430, 10408, 54, CAST(5.90000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (431, 10408, 62, CAST(39.40000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (432, 10409, 14, CAST(18.60000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (433, 10409, 21, CAST(8.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (434, 10410, 33, CAST(2.00000 AS Decimal(19, 5)), 49, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (435, 10410, 59, CAST(44.00000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (436, 10411, 41, CAST(7.70000 AS Decimal(19, 5)), 25, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (437, 10411, 44, CAST(15.50000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (438, 10411, 59, CAST(44.00000 AS Decimal(19, 5)), 9, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (439, 10412, 14, CAST(18.60000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (440, 10413, 1, CAST(14.40000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (441, 10413, 62, CAST(39.40000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (442, 10413, 76, CAST(14.40000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (443, 10414, 19, CAST(7.30000 AS Decimal(19, 5)), 18, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (444, 10414, 33, CAST(2.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (445, 10415, 17, CAST(31.20000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (446, 10415, 33, CAST(2.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (447, 10416, 19, CAST(7.30000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (448, 10416, 53, CAST(26.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (449, 10416, 57, CAST(15.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (450, 10417, 38, CAST(210.80000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (451, 10417, 46, CAST(9.60000 AS Decimal(19, 5)), 2, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (452, 10417, 68, CAST(10.00000 AS Decimal(19, 5)), 36, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (453, 10417, 77, CAST(10.40000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (454, 10418, 2, CAST(15.20000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (455, 10418, 47, CAST(7.60000 AS Decimal(19, 5)), 55, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (456, 10418, 61, CAST(22.80000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (457, 10418, 74, CAST(8.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (458, 10419, 60, CAST(27.20000 AS Decimal(19, 5)), 60, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (459, 10419, 69, CAST(28.80000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (460, 10420, 9, CAST(77.60000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (461, 10420, 13, CAST(4.80000 AS Decimal(19, 5)), 2, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (462, 10420, 70, CAST(12.00000 AS Decimal(19, 5)), 8, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (463, 10420, 73, CAST(12.00000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (464, 10421, 19, CAST(7.30000 AS Decimal(19, 5)), 4, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (465, 10421, 26, CAST(24.90000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (466, 10421, 53, CAST(26.20000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (467, 10421, 77, CAST(10.40000 AS Decimal(19, 5)), 10, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (468, 10422, 26, CAST(24.90000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (469, 10423, 31, CAST(10.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (470, 10423, 59, CAST(44.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (471, 10424, 35, CAST(14.40000 AS Decimal(19, 5)), 60, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (472, 10424, 38, CAST(210.80000 AS Decimal(19, 5)), 49, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (473, 10424, 68, CAST(10.00000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (474, 10425, 55, CAST(19.20000 AS Decimal(19, 5)), 10, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (475, 10425, 76, CAST(14.40000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (476, 10426, 56, CAST(30.40000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (477, 10426, 64, CAST(26.60000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (478, 10427, 14, CAST(18.60000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (479, 10428, 46, CAST(9.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (480, 10429, 50, CAST(13.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (481, 10429, 63, CAST(35.10000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (482, 10430, 17, CAST(31.20000 AS Decimal(19, 5)), 45, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (483, 10430, 21, CAST(8.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (484, 10430, 56, CAST(30.40000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (485, 10430, 59, CAST(44.00000 AS Decimal(19, 5)), 70, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (486, 10431, 17, CAST(31.20000 AS Decimal(19, 5)), 50, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (487, 10431, 40, CAST(14.70000 AS Decimal(19, 5)), 50, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (488, 10431, 47, CAST(7.60000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (489, 10432, 26, CAST(24.90000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (490, 10432, 54, CAST(5.90000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (491, 10433, 56, CAST(30.40000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (492, 10434, 11, CAST(16.80000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (493, 10434, 76, CAST(14.40000 AS Decimal(19, 5)), 18, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (494, 10435, 2, CAST(15.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (495, 10435, 22, CAST(16.80000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (496, 10435, 72, CAST(27.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (497, 10436, 46, CAST(9.60000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (498, 10436, 56, CAST(30.40000 AS Decimal(19, 5)), 40, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (499, 10436, 64, CAST(26.60000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (500, 10436, 75, CAST(6.20000 AS Decimal(19, 5)), 24, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (501, 10437, 53, CAST(26.20000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (502, 10438, 19, CAST(7.30000 AS Decimal(19, 5)), 15, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (503, 10438, 34, CAST(11.20000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (504, 10438, 57, CAST(15.60000 AS Decimal(19, 5)), 15, CAST(0.20000 AS Decimal(19, 5)))
GO
print 'Processed 500 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (505, 10439, 12, CAST(30.40000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (506, 10439, 16, CAST(13.90000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (507, 10439, 64, CAST(26.60000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (508, 10439, 74, CAST(8.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (509, 10440, 2, CAST(15.20000 AS Decimal(19, 5)), 45, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (510, 10440, 16, CAST(13.90000 AS Decimal(19, 5)), 49, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (511, 10440, 29, CAST(99.00000 AS Decimal(19, 5)), 24, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (512, 10440, 61, CAST(22.80000 AS Decimal(19, 5)), 90, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (513, 10441, 27, CAST(35.10000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (514, 10442, 11, CAST(16.80000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (515, 10442, 54, CAST(5.90000 AS Decimal(19, 5)), 80, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (516, 10442, 66, CAST(13.60000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (517, 10443, 11, CAST(16.80000 AS Decimal(19, 5)), 6, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (518, 10443, 28, CAST(36.40000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (519, 10444, 17, CAST(31.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (520, 10444, 26, CAST(24.90000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (521, 10444, 35, CAST(14.40000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (522, 10444, 41, CAST(7.70000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (523, 10445, 39, CAST(14.40000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (524, 10445, 54, CAST(5.90000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (525, 10446, 19, CAST(7.30000 AS Decimal(19, 5)), 12, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (526, 10446, 24, CAST(3.60000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (527, 10446, 31, CAST(10.00000 AS Decimal(19, 5)), 3, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (528, 10446, 52, CAST(5.60000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (529, 10447, 19, CAST(7.30000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (530, 10447, 65, CAST(16.80000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (531, 10447, 71, CAST(17.20000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (532, 10448, 26, CAST(24.90000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (533, 10448, 40, CAST(14.70000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (534, 10449, 10, CAST(24.80000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (535, 10449, 52, CAST(5.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (536, 10449, 62, CAST(39.40000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (537, 10450, 10, CAST(24.80000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (538, 10450, 54, CAST(5.90000 AS Decimal(19, 5)), 6, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (539, 10451, 55, CAST(19.20000 AS Decimal(19, 5)), 120, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (540, 10451, 64, CAST(26.60000 AS Decimal(19, 5)), 35, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (541, 10451, 65, CAST(16.80000 AS Decimal(19, 5)), 28, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (542, 10451, 77, CAST(10.40000 AS Decimal(19, 5)), 55, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (543, 10452, 28, CAST(36.40000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (544, 10452, 44, CAST(15.50000 AS Decimal(19, 5)), 100, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (545, 10453, 48, CAST(10.20000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (546, 10453, 70, CAST(12.00000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (547, 10454, 16, CAST(13.90000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (548, 10454, 33, CAST(2.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (549, 10454, 46, CAST(9.60000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (550, 10455, 39, CAST(14.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (551, 10455, 53, CAST(26.20000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (552, 10455, 61, CAST(22.80000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (553, 10455, 71, CAST(17.20000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (554, 10456, 21, CAST(8.00000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (555, 10456, 49, CAST(16.00000 AS Decimal(19, 5)), 21, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (556, 10457, 59, CAST(44.00000 AS Decimal(19, 5)), 36, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (557, 10458, 26, CAST(24.90000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (558, 10458, 28, CAST(36.40000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (559, 10458, 43, CAST(36.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (560, 10458, 56, CAST(30.40000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (561, 10458, 71, CAST(17.20000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (562, 10459, 7, CAST(24.00000 AS Decimal(19, 5)), 16, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (563, 10459, 46, CAST(9.60000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (564, 10459, 72, CAST(27.80000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (565, 10460, 68, CAST(10.00000 AS Decimal(19, 5)), 21, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (566, 10460, 75, CAST(6.20000 AS Decimal(19, 5)), 4, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (567, 10461, 21, CAST(8.00000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (568, 10461, 30, CAST(20.70000 AS Decimal(19, 5)), 28, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (569, 10461, 55, CAST(19.20000 AS Decimal(19, 5)), 60, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (570, 10462, 13, CAST(4.80000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (571, 10462, 23, CAST(7.20000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (572, 10463, 19, CAST(7.30000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (573, 10463, 42, CAST(11.20000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (574, 10464, 4, CAST(17.60000 AS Decimal(19, 5)), 16, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (575, 10464, 43, CAST(36.80000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (576, 10464, 56, CAST(30.40000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (577, 10464, 60, CAST(27.20000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (578, 10465, 24, CAST(3.60000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (579, 10465, 29, CAST(99.00000 AS Decimal(19, 5)), 18, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (580, 10465, 40, CAST(14.70000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (581, 10465, 45, CAST(7.60000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (582, 10465, 50, CAST(13.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (583, 10466, 11, CAST(16.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (584, 10466, 46, CAST(9.60000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (585, 10467, 24, CAST(3.60000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (586, 10467, 25, CAST(11.20000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (587, 10468, 30, CAST(20.70000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (588, 10468, 43, CAST(36.80000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (589, 10469, 2, CAST(15.20000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (590, 10469, 16, CAST(13.90000 AS Decimal(19, 5)), 35, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (591, 10469, 44, CAST(15.50000 AS Decimal(19, 5)), 2, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (592, 10470, 18, CAST(50.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (593, 10470, 23, CAST(7.20000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (594, 10470, 64, CAST(26.60000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (595, 10471, 7, CAST(24.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (596, 10471, 56, CAST(30.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (597, 10472, 24, CAST(3.60000 AS Decimal(19, 5)), 80, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (598, 10472, 51, CAST(42.40000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (599, 10473, 33, CAST(2.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (600, 10473, 71, CAST(17.20000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (601, 10474, 14, CAST(18.60000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (602, 10474, 28, CAST(36.40000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (603, 10474, 40, CAST(14.70000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (604, 10474, 75, CAST(6.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (605, 10475, 31, CAST(10.00000 AS Decimal(19, 5)), 35, CAST(0.15000 AS Decimal(19, 5)))
GO
print 'Processed 600 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (606, 10475, 66, CAST(13.60000 AS Decimal(19, 5)), 60, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (607, 10475, 76, CAST(14.40000 AS Decimal(19, 5)), 42, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (608, 10476, 55, CAST(19.20000 AS Decimal(19, 5)), 2, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (609, 10476, 70, CAST(12.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (610, 10477, 1, CAST(14.40000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (611, 10477, 21, CAST(8.00000 AS Decimal(19, 5)), 21, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (612, 10477, 39, CAST(14.40000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (613, 10478, 10, CAST(24.80000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (614, 10479, 38, CAST(210.80000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (615, 10479, 53, CAST(26.20000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (616, 10479, 59, CAST(44.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (617, 10479, 64, CAST(26.60000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (618, 10480, 47, CAST(7.60000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (619, 10480, 59, CAST(44.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (620, 10481, 49, CAST(16.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (621, 10481, 60, CAST(27.20000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (622, 10482, 40, CAST(14.70000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (623, 10483, 34, CAST(11.20000 AS Decimal(19, 5)), 35, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (624, 10483, 77, CAST(10.40000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (625, 10484, 21, CAST(8.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (626, 10484, 40, CAST(14.70000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (627, 10484, 51, CAST(42.40000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (628, 10485, 2, CAST(15.20000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (629, 10485, 3, CAST(8.00000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (630, 10485, 55, CAST(19.20000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (631, 10485, 70, CAST(12.00000 AS Decimal(19, 5)), 60, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (632, 10486, 11, CAST(16.80000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (633, 10486, 51, CAST(42.40000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (634, 10486, 74, CAST(8.00000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (635, 10487, 19, CAST(7.30000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (636, 10487, 26, CAST(24.90000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (637, 10487, 54, CAST(5.90000 AS Decimal(19, 5)), 24, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (638, 10488, 59, CAST(44.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (639, 10488, 73, CAST(12.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (640, 10489, 11, CAST(16.80000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (641, 10489, 16, CAST(13.90000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (642, 10490, 59, CAST(44.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (643, 10490, 68, CAST(10.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (644, 10490, 75, CAST(6.20000 AS Decimal(19, 5)), 36, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (645, 10491, 44, CAST(15.50000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (646, 10491, 77, CAST(10.40000 AS Decimal(19, 5)), 7, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (647, 10492, 25, CAST(11.20000 AS Decimal(19, 5)), 60, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (648, 10492, 42, CAST(11.20000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (649, 10493, 65, CAST(16.80000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (650, 10493, 66, CAST(13.60000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (651, 10493, 69, CAST(28.80000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (652, 10494, 56, CAST(30.40000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (653, 10495, 23, CAST(7.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (654, 10495, 41, CAST(7.70000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (655, 10495, 77, CAST(10.40000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (656, 10496, 31, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (657, 10497, 56, CAST(30.40000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (658, 10497, 72, CAST(27.80000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (659, 10497, 77, CAST(10.40000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (660, 10498, 24, CAST(4.50000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (661, 10498, 40, CAST(18.40000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (662, 10498, 42, CAST(14.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (663, 10499, 28, CAST(45.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (664, 10499, 49, CAST(20.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (665, 10500, 15, CAST(15.50000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (666, 10500, 28, CAST(45.60000 AS Decimal(19, 5)), 8, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (667, 10501, 54, CAST(7.45000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (668, 10502, 45, CAST(9.50000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (669, 10502, 53, CAST(32.80000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (670, 10502, 67, CAST(14.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (671, 10503, 14, CAST(23.25000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (672, 10503, 65, CAST(21.05000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (673, 10504, 2, CAST(19.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (674, 10504, 21, CAST(10.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (675, 10504, 53, CAST(32.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (676, 10504, 61, CAST(28.50000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (677, 10505, 62, CAST(49.30000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (678, 10506, 25, CAST(14.00000 AS Decimal(19, 5)), 18, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (679, 10506, 70, CAST(15.00000 AS Decimal(19, 5)), 14, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (680, 10507, 43, CAST(46.00000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (681, 10507, 48, CAST(12.75000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (682, 10508, 13, CAST(6.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (683, 10508, 39, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (684, 10509, 28, CAST(45.60000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (685, 10510, 29, CAST(123.79000 AS Decimal(19, 5)), 36, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (686, 10510, 75, CAST(7.75000 AS Decimal(19, 5)), 36, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (687, 10511, 4, CAST(22.00000 AS Decimal(19, 5)), 50, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (688, 10511, 7, CAST(30.00000 AS Decimal(19, 5)), 50, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (689, 10511, 8, CAST(40.00000 AS Decimal(19, 5)), 10, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (690, 10512, 24, CAST(4.50000 AS Decimal(19, 5)), 10, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (691, 10512, 46, CAST(12.00000 AS Decimal(19, 5)), 9, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (692, 10512, 47, CAST(9.50000 AS Decimal(19, 5)), 6, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (693, 10512, 60, CAST(34.00000 AS Decimal(19, 5)), 12, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (694, 10513, 21, CAST(10.00000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (695, 10513, 32, CAST(32.00000 AS Decimal(19, 5)), 50, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (696, 10513, 61, CAST(28.50000 AS Decimal(19, 5)), 15, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (697, 10514, 20, CAST(81.00000 AS Decimal(19, 5)), 39, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (698, 10514, 28, CAST(45.60000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (699, 10514, 56, CAST(38.00000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (700, 10514, 65, CAST(21.05000 AS Decimal(19, 5)), 39, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (701, 10514, 75, CAST(7.75000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (702, 10515, 9, CAST(97.00000 AS Decimal(19, 5)), 16, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (703, 10515, 16, CAST(17.45000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (704, 10515, 27, CAST(43.90000 AS Decimal(19, 5)), 120, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (705, 10515, 33, CAST(2.50000 AS Decimal(19, 5)), 16, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (706, 10515, 60, CAST(34.00000 AS Decimal(19, 5)), 84, CAST(0.15000 AS Decimal(19, 5)))
GO
print 'Processed 700 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (707, 10516, 18, CAST(62.50000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (708, 10516, 41, CAST(9.65000 AS Decimal(19, 5)), 80, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (709, 10516, 42, CAST(14.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (710, 10517, 52, CAST(7.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (711, 10517, 59, CAST(55.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (712, 10517, 70, CAST(15.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (713, 10518, 24, CAST(4.50000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (714, 10518, 38, CAST(263.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (715, 10518, 44, CAST(19.45000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (716, 10519, 10, CAST(31.00000 AS Decimal(19, 5)), 16, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (717, 10519, 56, CAST(38.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (718, 10519, 60, CAST(34.00000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (719, 10520, 24, CAST(4.50000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (720, 10520, 53, CAST(32.80000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (721, 10521, 35, CAST(18.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (722, 10521, 41, CAST(9.65000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (723, 10521, 68, CAST(12.50000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (724, 10522, 1, CAST(18.00000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (725, 10522, 8, CAST(40.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (726, 10522, 30, CAST(25.89000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (727, 10522, 40, CAST(18.40000 AS Decimal(19, 5)), 25, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (728, 10523, 17, CAST(39.00000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (729, 10523, 20, CAST(81.00000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (730, 10523, 37, CAST(26.00000 AS Decimal(19, 5)), 18, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (731, 10523, 41, CAST(9.65000 AS Decimal(19, 5)), 6, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (732, 10524, 10, CAST(31.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (733, 10524, 30, CAST(25.89000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (734, 10524, 43, CAST(46.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (735, 10524, 54, CAST(7.45000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (736, 10525, 36, CAST(19.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (737, 10525, 40, CAST(18.40000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (738, 10526, 1, CAST(18.00000 AS Decimal(19, 5)), 8, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (739, 10526, 13, CAST(6.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (740, 10526, 56, CAST(38.00000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (741, 10527, 4, CAST(22.00000 AS Decimal(19, 5)), 50, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (742, 10527, 36, CAST(19.00000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (743, 10528, 11, CAST(21.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (744, 10528, 33, CAST(2.50000 AS Decimal(19, 5)), 8, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (745, 10528, 72, CAST(34.80000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (746, 10529, 55, CAST(24.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (747, 10529, 68, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (748, 10529, 69, CAST(36.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (749, 10530, 17, CAST(39.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (750, 10530, 43, CAST(46.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (751, 10530, 61, CAST(28.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (752, 10530, 76, CAST(18.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (753, 10531, 59, CAST(55.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (754, 10532, 30, CAST(25.89000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (755, 10532, 66, CAST(17.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (756, 10533, 4, CAST(22.00000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (757, 10533, 72, CAST(34.80000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (758, 10533, 73, CAST(15.00000 AS Decimal(19, 5)), 24, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (759, 10534, 30, CAST(25.89000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (760, 10534, 40, CAST(18.40000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (761, 10534, 54, CAST(7.45000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (762, 10535, 11, CAST(21.00000 AS Decimal(19, 5)), 50, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (763, 10535, 40, CAST(18.40000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (764, 10535, 57, CAST(19.50000 AS Decimal(19, 5)), 5, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (765, 10535, 59, CAST(55.00000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (766, 10536, 12, CAST(38.00000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (767, 10536, 31, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (768, 10536, 33, CAST(2.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (769, 10536, 60, CAST(34.00000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (770, 10537, 31, CAST(12.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (771, 10537, 51, CAST(53.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (772, 10537, 58, CAST(13.25000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (773, 10537, 72, CAST(34.80000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (774, 10537, 73, CAST(15.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (775, 10538, 70, CAST(15.00000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (776, 10538, 72, CAST(34.80000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (777, 10539, 13, CAST(6.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (778, 10539, 21, CAST(10.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (779, 10539, 33, CAST(2.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (780, 10539, 49, CAST(20.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (781, 10540, 3, CAST(10.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (782, 10540, 26, CAST(31.23000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (783, 10540, 38, CAST(263.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (784, 10540, 68, CAST(12.50000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (785, 10541, 24, CAST(4.50000 AS Decimal(19, 5)), 35, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (786, 10541, 38, CAST(263.50000 AS Decimal(19, 5)), 4, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (787, 10541, 65, CAST(21.05000 AS Decimal(19, 5)), 36, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (788, 10541, 71, CAST(21.50000 AS Decimal(19, 5)), 9, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (789, 10542, 11, CAST(21.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (790, 10542, 54, CAST(7.45000 AS Decimal(19, 5)), 24, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (791, 10543, 12, CAST(38.00000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (792, 10543, 23, CAST(9.00000 AS Decimal(19, 5)), 70, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (793, 10544, 28, CAST(45.60000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (794, 10544, 67, CAST(14.00000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (795, 10545, 11, CAST(21.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (796, 10546, 7, CAST(30.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (797, 10546, 35, CAST(18.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (798, 10546, 62, CAST(49.30000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (799, 10547, 32, CAST(32.00000 AS Decimal(19, 5)), 24, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (800, 10547, 36, CAST(19.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (801, 10548, 34, CAST(14.00000 AS Decimal(19, 5)), 10, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (802, 10548, 41, CAST(9.65000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (803, 10549, 31, CAST(12.50000 AS Decimal(19, 5)), 55, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (804, 10549, 45, CAST(9.50000 AS Decimal(19, 5)), 100, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (805, 10549, 51, CAST(53.00000 AS Decimal(19, 5)), 48, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (806, 10550, 17, CAST(39.00000 AS Decimal(19, 5)), 8, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (807, 10550, 19, CAST(9.20000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 800 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (808, 10550, 21, CAST(10.00000 AS Decimal(19, 5)), 6, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (809, 10550, 61, CAST(28.50000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (810, 10551, 16, CAST(17.45000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (811, 10551, 35, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (812, 10551, 44, CAST(19.45000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (813, 10552, 69, CAST(36.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (814, 10552, 75, CAST(7.75000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (815, 10553, 11, CAST(21.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (816, 10553, 16, CAST(17.45000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (817, 10553, 22, CAST(21.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (818, 10553, 31, CAST(12.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (819, 10553, 35, CAST(18.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (820, 10554, 16, CAST(17.45000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (821, 10554, 23, CAST(9.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (822, 10554, 62, CAST(49.30000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (823, 10554, 77, CAST(13.00000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (824, 10555, 14, CAST(23.25000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (825, 10555, 19, CAST(9.20000 AS Decimal(19, 5)), 35, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (826, 10555, 24, CAST(4.50000 AS Decimal(19, 5)), 18, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (827, 10555, 51, CAST(53.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (828, 10555, 56, CAST(38.00000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (829, 10556, 72, CAST(34.80000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (830, 10557, 64, CAST(33.25000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (831, 10557, 75, CAST(7.75000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (832, 10558, 47, CAST(9.50000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (833, 10558, 51, CAST(53.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (834, 10558, 52, CAST(7.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (835, 10558, 53, CAST(32.80000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (836, 10558, 73, CAST(15.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (837, 10559, 41, CAST(9.65000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (838, 10559, 55, CAST(24.00000 AS Decimal(19, 5)), 18, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (839, 10560, 30, CAST(25.89000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (840, 10560, 62, CAST(49.30000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (841, 10561, 44, CAST(19.45000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (842, 10561, 51, CAST(53.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (843, 10562, 33, CAST(2.50000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (844, 10562, 62, CAST(49.30000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (845, 10563, 36, CAST(19.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (846, 10563, 52, CAST(7.00000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (847, 10564, 17, CAST(39.00000 AS Decimal(19, 5)), 16, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (848, 10564, 31, CAST(12.50000 AS Decimal(19, 5)), 6, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (849, 10564, 55, CAST(24.00000 AS Decimal(19, 5)), 25, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (850, 10565, 24, CAST(4.50000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (851, 10565, 64, CAST(33.25000 AS Decimal(19, 5)), 18, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (852, 10566, 11, CAST(21.00000 AS Decimal(19, 5)), 35, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (853, 10566, 18, CAST(62.50000 AS Decimal(19, 5)), 18, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (854, 10566, 76, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (855, 10567, 31, CAST(12.50000 AS Decimal(19, 5)), 60, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (856, 10567, 51, CAST(53.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (857, 10567, 59, CAST(55.00000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (858, 10568, 10, CAST(31.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (859, 10569, 31, CAST(12.50000 AS Decimal(19, 5)), 35, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (860, 10569, 76, CAST(18.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (861, 10570, 11, CAST(21.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (862, 10570, 56, CAST(38.00000 AS Decimal(19, 5)), 60, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (863, 10571, 14, CAST(23.25000 AS Decimal(19, 5)), 11, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (864, 10571, 42, CAST(14.00000 AS Decimal(19, 5)), 28, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (865, 10572, 16, CAST(17.45000 AS Decimal(19, 5)), 12, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (866, 10572, 32, CAST(32.00000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (867, 10572, 40, CAST(18.40000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (868, 10572, 75, CAST(7.75000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (869, 10573, 17, CAST(39.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (870, 10573, 34, CAST(14.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (871, 10573, 53, CAST(32.80000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (872, 10574, 33, CAST(2.50000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (873, 10574, 40, CAST(18.40000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (874, 10574, 62, CAST(49.30000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (875, 10574, 64, CAST(33.25000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (876, 10575, 59, CAST(55.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (877, 10575, 63, CAST(43.90000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (878, 10575, 72, CAST(34.80000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (879, 10575, 76, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (880, 10576, 1, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (881, 10576, 31, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (882, 10576, 44, CAST(19.45000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (883, 10577, 39, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (884, 10577, 75, CAST(7.75000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (885, 10577, 77, CAST(13.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (886, 10578, 35, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (887, 10578, 57, CAST(19.50000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (888, 10579, 15, CAST(15.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (889, 10579, 75, CAST(7.75000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (890, 10580, 14, CAST(23.25000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (891, 10580, 41, CAST(9.65000 AS Decimal(19, 5)), 9, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (892, 10580, 65, CAST(21.05000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (893, 10581, 75, CAST(7.75000 AS Decimal(19, 5)), 50, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (894, 10582, 57, CAST(19.50000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (895, 10582, 76, CAST(18.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (896, 10583, 29, CAST(123.79000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (897, 10583, 60, CAST(34.00000 AS Decimal(19, 5)), 24, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (898, 10583, 69, CAST(36.00000 AS Decimal(19, 5)), 10, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (899, 10584, 31, CAST(12.50000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (900, 10585, 47, CAST(9.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (901, 10586, 52, CAST(7.00000 AS Decimal(19, 5)), 4, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (902, 10587, 26, CAST(31.23000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (903, 10587, 35, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (904, 10587, 77, CAST(13.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (905, 10588, 18, CAST(62.50000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (906, 10588, 42, CAST(14.00000 AS Decimal(19, 5)), 100, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (907, 10589, 35, CAST(18.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (908, 10590, 1, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 900 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (909, 10590, 77, CAST(13.00000 AS Decimal(19, 5)), 60, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (910, 10591, 3, CAST(10.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (911, 10591, 7, CAST(30.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (912, 10591, 54, CAST(7.45000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (913, 10592, 15, CAST(15.50000 AS Decimal(19, 5)), 25, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (914, 10592, 26, CAST(31.23000 AS Decimal(19, 5)), 5, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (915, 10593, 20, CAST(81.00000 AS Decimal(19, 5)), 21, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (916, 10593, 69, CAST(36.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (917, 10593, 76, CAST(18.00000 AS Decimal(19, 5)), 4, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (918, 10594, 52, CAST(7.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (919, 10594, 58, CAST(13.25000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (920, 10595, 35, CAST(18.00000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (921, 10595, 61, CAST(28.50000 AS Decimal(19, 5)), 120, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (922, 10595, 69, CAST(36.00000 AS Decimal(19, 5)), 65, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (923, 10596, 56, CAST(38.00000 AS Decimal(19, 5)), 5, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (924, 10596, 63, CAST(43.90000 AS Decimal(19, 5)), 24, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (925, 10596, 75, CAST(7.75000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (926, 10597, 24, CAST(4.50000 AS Decimal(19, 5)), 35, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (927, 10597, 57, CAST(19.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (928, 10597, 65, CAST(21.05000 AS Decimal(19, 5)), 12, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (929, 10598, 27, CAST(43.90000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (930, 10598, 71, CAST(21.50000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (931, 10599, 62, CAST(49.30000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (932, 10600, 54, CAST(7.45000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (933, 10600, 73, CAST(15.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (934, 10601, 13, CAST(6.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (935, 10601, 59, CAST(55.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (936, 10602, 77, CAST(13.00000 AS Decimal(19, 5)), 5, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (937, 10603, 22, CAST(21.00000 AS Decimal(19, 5)), 48, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (938, 10603, 49, CAST(20.00000 AS Decimal(19, 5)), 25, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (939, 10604, 48, CAST(12.75000 AS Decimal(19, 5)), 6, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (940, 10604, 76, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (941, 10605, 16, CAST(17.45000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (942, 10605, 59, CAST(55.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (943, 10605, 60, CAST(34.00000 AS Decimal(19, 5)), 70, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (944, 10605, 71, CAST(21.50000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (945, 10606, 4, CAST(22.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (946, 10606, 55, CAST(24.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (947, 10606, 62, CAST(49.30000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (948, 10607, 7, CAST(30.00000 AS Decimal(19, 5)), 45, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (949, 10607, 17, CAST(39.00000 AS Decimal(19, 5)), 100, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (950, 10607, 33, CAST(2.50000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (951, 10607, 40, CAST(18.40000 AS Decimal(19, 5)), 42, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (952, 10607, 72, CAST(34.80000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (953, 10608, 56, CAST(38.00000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (954, 10609, 1, CAST(18.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (955, 10609, 10, CAST(31.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (956, 10609, 21, CAST(10.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (957, 10610, 36, CAST(19.00000 AS Decimal(19, 5)), 21, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (958, 10611, 1, CAST(18.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (959, 10611, 2, CAST(19.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (960, 10611, 60, CAST(34.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (961, 10612, 10, CAST(31.00000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (962, 10612, 36, CAST(19.00000 AS Decimal(19, 5)), 55, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (963, 10612, 49, CAST(20.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (964, 10612, 60, CAST(34.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (965, 10612, 76, CAST(18.00000 AS Decimal(19, 5)), 80, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (966, 10613, 13, CAST(6.00000 AS Decimal(19, 5)), 8, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (967, 10613, 75, CAST(7.75000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (968, 10614, 11, CAST(21.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (969, 10614, 21, CAST(10.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (970, 10614, 39, CAST(18.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (971, 10615, 55, CAST(24.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (972, 10616, 38, CAST(263.50000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (973, 10616, 56, CAST(38.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (974, 10616, 70, CAST(15.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (975, 10616, 71, CAST(21.50000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (976, 10617, 59, CAST(55.00000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (977, 10618, 6, CAST(25.00000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (978, 10618, 56, CAST(38.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (979, 10618, 68, CAST(12.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (980, 10619, 21, CAST(10.00000 AS Decimal(19, 5)), 42, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (981, 10619, 22, CAST(21.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (982, 10620, 24, CAST(4.50000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (983, 10620, 52, CAST(7.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (984, 10621, 19, CAST(9.20000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (985, 10621, 23, CAST(9.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (986, 10621, 70, CAST(15.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (987, 10621, 71, CAST(21.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (988, 10622, 2, CAST(19.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (989, 10622, 68, CAST(12.50000 AS Decimal(19, 5)), 18, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (990, 10623, 14, CAST(23.25000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (991, 10623, 19, CAST(9.20000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (992, 10623, 21, CAST(10.00000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (993, 10623, 24, CAST(4.50000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (994, 10623, 35, CAST(18.00000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (995, 10624, 28, CAST(45.60000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (996, 10624, 29, CAST(123.79000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (997, 10624, 44, CAST(19.45000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (998, 10625, 14, CAST(23.25000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (999, 10625, 42, CAST(14.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1000, 10625, 60, CAST(34.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1001, 10626, 53, CAST(32.80000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1002, 10626, 60, CAST(34.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1003, 10626, 71, CAST(21.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1004, 10627, 62, CAST(49.30000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1005, 10627, 73, CAST(15.00000 AS Decimal(19, 5)), 35, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1006, 10628, 1, CAST(18.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1007, 10629, 29, CAST(123.79000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1008, 10629, 64, CAST(33.25000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1009, 10630, 55, CAST(24.00000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
GO
print 'Processed 1000 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1010, 10630, 76, CAST(18.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1011, 10631, 75, CAST(7.75000 AS Decimal(19, 5)), 8, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1012, 10632, 2, CAST(19.00000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1013, 10632, 33, CAST(2.50000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1014, 10633, 12, CAST(38.00000 AS Decimal(19, 5)), 36, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1015, 10633, 13, CAST(6.00000 AS Decimal(19, 5)), 13, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1016, 10633, 26, CAST(31.23000 AS Decimal(19, 5)), 35, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1017, 10633, 62, CAST(49.30000 AS Decimal(19, 5)), 80, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1018, 10634, 7, CAST(30.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1019, 10634, 18, CAST(62.50000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1020, 10634, 51, CAST(53.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1021, 10634, 75, CAST(7.75000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1022, 10635, 4, CAST(22.00000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1023, 10635, 5, CAST(21.35000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1024, 10635, 22, CAST(21.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1025, 10636, 4, CAST(22.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1026, 10636, 58, CAST(13.25000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1027, 10637, 11, CAST(21.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1028, 10637, 50, CAST(16.25000 AS Decimal(19, 5)), 25, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1029, 10637, 56, CAST(38.00000 AS Decimal(19, 5)), 60, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1030, 10638, 45, CAST(9.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1031, 10638, 65, CAST(21.05000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1032, 10638, 72, CAST(34.80000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1033, 10639, 18, CAST(62.50000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1034, 10640, 69, CAST(36.00000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1035, 10640, 70, CAST(15.00000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1036, 10641, 2, CAST(19.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1037, 10641, 40, CAST(18.40000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1038, 10642, 21, CAST(10.00000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1039, 10642, 61, CAST(28.50000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1040, 10643, 28, CAST(45.60000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1041, 10643, 39, CAST(18.00000 AS Decimal(19, 5)), 21, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1042, 10643, 46, CAST(12.00000 AS Decimal(19, 5)), 2, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1043, 10644, 18, CAST(62.50000 AS Decimal(19, 5)), 4, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1044, 10644, 43, CAST(46.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1045, 10644, 46, CAST(12.00000 AS Decimal(19, 5)), 21, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1046, 10645, 18, CAST(62.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1047, 10645, 36, CAST(19.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1048, 10646, 1, CAST(18.00000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1049, 10646, 10, CAST(31.00000 AS Decimal(19, 5)), 18, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1050, 10646, 71, CAST(21.50000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1051, 10646, 77, CAST(13.00000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1052, 10647, 19, CAST(9.20000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1053, 10647, 39, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1054, 10648, 22, CAST(21.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1055, 10648, 24, CAST(4.50000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1056, 10649, 28, CAST(45.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1057, 10649, 72, CAST(34.80000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1058, 10650, 30, CAST(25.89000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1059, 10650, 53, CAST(32.80000 AS Decimal(19, 5)), 25, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1060, 10650, 54, CAST(7.45000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1061, 10651, 19, CAST(9.20000 AS Decimal(19, 5)), 12, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1062, 10651, 22, CAST(21.00000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1063, 10652, 30, CAST(25.89000 AS Decimal(19, 5)), 2, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1064, 10652, 42, CAST(14.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1065, 10653, 16, CAST(17.45000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1066, 10653, 60, CAST(34.00000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1067, 10654, 4, CAST(22.00000 AS Decimal(19, 5)), 12, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1068, 10654, 39, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1069, 10654, 54, CAST(7.45000 AS Decimal(19, 5)), 6, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1070, 10655, 41, CAST(9.65000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1071, 10656, 14, CAST(23.25000 AS Decimal(19, 5)), 3, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1072, 10656, 44, CAST(19.45000 AS Decimal(19, 5)), 28, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1073, 10656, 47, CAST(9.50000 AS Decimal(19, 5)), 6, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1074, 10657, 15, CAST(15.50000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1075, 10657, 41, CAST(9.65000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1076, 10657, 46, CAST(12.00000 AS Decimal(19, 5)), 45, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1077, 10657, 47, CAST(9.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1078, 10657, 56, CAST(38.00000 AS Decimal(19, 5)), 45, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1079, 10657, 60, CAST(34.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1080, 10658, 21, CAST(10.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1081, 10658, 40, CAST(18.40000 AS Decimal(19, 5)), 70, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1082, 10658, 60, CAST(34.00000 AS Decimal(19, 5)), 55, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1083, 10658, 77, CAST(13.00000 AS Decimal(19, 5)), 70, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1084, 10659, 31, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1085, 10659, 40, CAST(18.40000 AS Decimal(19, 5)), 24, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1086, 10659, 70, CAST(15.00000 AS Decimal(19, 5)), 40, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1087, 10660, 20, CAST(81.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1088, 10661, 39, CAST(18.00000 AS Decimal(19, 5)), 3, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1089, 10661, 58, CAST(13.25000 AS Decimal(19, 5)), 49, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1090, 10662, 68, CAST(12.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1091, 10663, 40, CAST(18.40000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1092, 10663, 42, CAST(14.00000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1093, 10663, 51, CAST(53.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1094, 10664, 10, CAST(31.00000 AS Decimal(19, 5)), 24, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1095, 10664, 56, CAST(38.00000 AS Decimal(19, 5)), 12, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1096, 10664, 65, CAST(21.05000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1097, 10665, 51, CAST(53.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1098, 10665, 59, CAST(55.00000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1099, 10665, 76, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1100, 10666, 29, CAST(123.79000 AS Decimal(19, 5)), 36, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1101, 10666, 65, CAST(21.05000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1102, 10667, 69, CAST(36.00000 AS Decimal(19, 5)), 45, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1103, 10667, 71, CAST(21.50000 AS Decimal(19, 5)), 14, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1104, 10668, 31, CAST(12.50000 AS Decimal(19, 5)), 8, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1105, 10668, 55, CAST(24.00000 AS Decimal(19, 5)), 4, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1106, 10668, 64, CAST(33.25000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1107, 10669, 36, CAST(19.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1108, 10670, 23, CAST(9.00000 AS Decimal(19, 5)), 32, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1109, 10670, 46, CAST(12.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1110, 10670, 67, CAST(14.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 1100 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1111, 10670, 73, CAST(15.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1112, 10670, 75, CAST(7.75000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1113, 10671, 16, CAST(17.45000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1114, 10671, 62, CAST(49.30000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1115, 10671, 65, CAST(21.05000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1116, 10672, 38, CAST(263.50000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1117, 10672, 71, CAST(21.50000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1118, 10673, 16, CAST(17.45000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1119, 10673, 42, CAST(14.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1120, 10673, 43, CAST(46.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1121, 10674, 23, CAST(9.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1122, 10675, 14, CAST(23.25000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1123, 10675, 53, CAST(32.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1124, 10675, 58, CAST(13.25000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1125, 10676, 10, CAST(31.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1126, 10676, 19, CAST(9.20000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1127, 10676, 44, CAST(19.45000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1128, 10677, 26, CAST(31.23000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1129, 10677, 33, CAST(2.50000 AS Decimal(19, 5)), 8, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1130, 10678, 12, CAST(38.00000 AS Decimal(19, 5)), 100, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1131, 10678, 33, CAST(2.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1132, 10678, 41, CAST(9.65000 AS Decimal(19, 5)), 120, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1133, 10678, 54, CAST(7.45000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1134, 10679, 59, CAST(55.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1135, 10680, 16, CAST(17.45000 AS Decimal(19, 5)), 50, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1136, 10680, 31, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1137, 10680, 42, CAST(14.00000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1138, 10681, 19, CAST(9.20000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1139, 10681, 21, CAST(10.00000 AS Decimal(19, 5)), 12, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1140, 10681, 64, CAST(33.25000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1141, 10682, 33, CAST(2.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1142, 10682, 66, CAST(17.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1143, 10682, 75, CAST(7.75000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1144, 10683, 52, CAST(7.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1145, 10684, 40, CAST(18.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1146, 10684, 47, CAST(9.50000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1147, 10684, 60, CAST(34.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1148, 10685, 10, CAST(31.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1149, 10685, 41, CAST(9.65000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1150, 10685, 47, CAST(9.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1151, 10686, 17, CAST(39.00000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1152, 10686, 26, CAST(31.23000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1153, 10687, 9, CAST(97.00000 AS Decimal(19, 5)), 50, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1154, 10687, 29, CAST(123.79000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1155, 10687, 36, CAST(19.00000 AS Decimal(19, 5)), 6, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1156, 10688, 10, CAST(31.00000 AS Decimal(19, 5)), 18, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1157, 10688, 28, CAST(45.60000 AS Decimal(19, 5)), 60, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1158, 10688, 34, CAST(14.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1159, 10689, 1, CAST(18.00000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1160, 10690, 56, CAST(38.00000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1161, 10690, 77, CAST(13.00000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1162, 10691, 1, CAST(18.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1163, 10691, 29, CAST(123.79000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1164, 10691, 43, CAST(46.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1165, 10691, 44, CAST(19.45000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1166, 10691, 62, CAST(49.30000 AS Decimal(19, 5)), 48, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1167, 10692, 63, CAST(43.90000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1168, 10693, 9, CAST(97.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1169, 10693, 54, CAST(7.45000 AS Decimal(19, 5)), 60, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1170, 10693, 69, CAST(36.00000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1171, 10693, 73, CAST(15.00000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1172, 10694, 7, CAST(30.00000 AS Decimal(19, 5)), 90, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1173, 10694, 59, CAST(55.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1174, 10694, 70, CAST(15.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1175, 10695, 8, CAST(40.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1176, 10695, 12, CAST(38.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1177, 10695, 24, CAST(4.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1178, 10696, 17, CAST(39.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1179, 10696, 46, CAST(12.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1180, 10697, 19, CAST(9.20000 AS Decimal(19, 5)), 7, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1181, 10697, 35, CAST(18.00000 AS Decimal(19, 5)), 9, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1182, 10697, 58, CAST(13.25000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1183, 10697, 70, CAST(15.00000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1184, 10698, 11, CAST(21.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1185, 10698, 17, CAST(39.00000 AS Decimal(19, 5)), 8, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1186, 10698, 29, CAST(123.79000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1187, 10698, 65, CAST(21.05000 AS Decimal(19, 5)), 65, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1188, 10698, 70, CAST(15.00000 AS Decimal(19, 5)), 8, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1189, 10699, 47, CAST(9.50000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1190, 10700, 1, CAST(18.00000 AS Decimal(19, 5)), 5, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1191, 10700, 34, CAST(14.00000 AS Decimal(19, 5)), 12, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1192, 10700, 68, CAST(12.50000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1193, 10700, 71, CAST(21.50000 AS Decimal(19, 5)), 60, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1194, 10701, 59, CAST(55.00000 AS Decimal(19, 5)), 42, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1195, 10701, 71, CAST(21.50000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1196, 10701, 76, CAST(18.00000 AS Decimal(19, 5)), 35, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1197, 10702, 3, CAST(10.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1198, 10702, 76, CAST(18.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1199, 10703, 2, CAST(19.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1200, 10703, 59, CAST(55.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1201, 10703, 73, CAST(15.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1202, 10704, 4, CAST(22.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1203, 10704, 24, CAST(4.50000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1204, 10704, 48, CAST(12.75000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1205, 10705, 31, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1206, 10705, 32, CAST(32.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1207, 10706, 16, CAST(17.45000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1208, 10706, 43, CAST(46.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1209, 10706, 59, CAST(55.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1210, 10707, 55, CAST(24.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1211, 10707, 57, CAST(19.50000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 1200 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1212, 10707, 70, CAST(15.00000 AS Decimal(19, 5)), 28, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1213, 10708, 5, CAST(21.35000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1214, 10708, 36, CAST(19.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1215, 10709, 8, CAST(40.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1216, 10709, 51, CAST(53.00000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1217, 10709, 60, CAST(34.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1218, 10710, 19, CAST(9.20000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1219, 10710, 47, CAST(9.50000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1220, 10711, 19, CAST(9.20000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1221, 10711, 41, CAST(9.65000 AS Decimal(19, 5)), 42, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1222, 10711, 53, CAST(32.80000 AS Decimal(19, 5)), 120, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1223, 10712, 53, CAST(32.80000 AS Decimal(19, 5)), 3, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1224, 10712, 56, CAST(38.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1225, 10713, 10, CAST(31.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1226, 10713, 26, CAST(31.23000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1227, 10713, 45, CAST(9.50000 AS Decimal(19, 5)), 110, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1228, 10713, 46, CAST(12.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1229, 10714, 2, CAST(19.00000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1230, 10714, 17, CAST(39.00000 AS Decimal(19, 5)), 27, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1231, 10714, 47, CAST(9.50000 AS Decimal(19, 5)), 50, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1232, 10714, 56, CAST(38.00000 AS Decimal(19, 5)), 18, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1233, 10714, 58, CAST(13.25000 AS Decimal(19, 5)), 12, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1234, 10715, 10, CAST(31.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1235, 10715, 71, CAST(21.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1236, 10716, 21, CAST(10.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1237, 10716, 51, CAST(53.00000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1238, 10716, 61, CAST(28.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1239, 10717, 21, CAST(10.00000 AS Decimal(19, 5)), 32, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1240, 10717, 54, CAST(7.45000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1241, 10717, 69, CAST(36.00000 AS Decimal(19, 5)), 25, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1242, 10718, 12, CAST(38.00000 AS Decimal(19, 5)), 36, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1243, 10718, 16, CAST(17.45000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1244, 10718, 36, CAST(19.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1245, 10718, 62, CAST(49.30000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1246, 10719, 18, CAST(62.50000 AS Decimal(19, 5)), 12, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1247, 10719, 30, CAST(25.89000 AS Decimal(19, 5)), 3, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1248, 10719, 54, CAST(7.45000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1249, 10720, 35, CAST(18.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1250, 10720, 71, CAST(21.50000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1251, 10721, 44, CAST(19.45000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1252, 10722, 2, CAST(19.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1253, 10722, 31, CAST(12.50000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1254, 10722, 68, CAST(12.50000 AS Decimal(19, 5)), 45, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1255, 10722, 75, CAST(7.75000 AS Decimal(19, 5)), 42, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1256, 10723, 26, CAST(31.23000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1257, 10724, 10, CAST(31.00000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1258, 10724, 61, CAST(28.50000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1259, 10725, 41, CAST(9.65000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1260, 10725, 52, CAST(7.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1261, 10725, 55, CAST(24.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1262, 10726, 4, CAST(22.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1263, 10726, 11, CAST(21.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1264, 10727, 17, CAST(39.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1265, 10727, 56, CAST(38.00000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1266, 10727, 59, CAST(55.00000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1267, 10728, 30, CAST(25.89000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1268, 10728, 40, CAST(18.40000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1269, 10728, 55, CAST(24.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1270, 10728, 60, CAST(34.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1271, 10729, 1, CAST(18.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1272, 10729, 21, CAST(10.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1273, 10729, 50, CAST(16.25000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1274, 10730, 16, CAST(17.45000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1275, 10730, 31, CAST(12.50000 AS Decimal(19, 5)), 3, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1276, 10730, 65, CAST(21.05000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1277, 10731, 21, CAST(10.00000 AS Decimal(19, 5)), 40, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1278, 10731, 51, CAST(53.00000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1279, 10732, 76, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1280, 10733, 14, CAST(23.25000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1281, 10733, 28, CAST(45.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1282, 10733, 52, CAST(7.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1283, 10734, 6, CAST(25.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1284, 10734, 30, CAST(25.89000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1285, 10734, 76, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1286, 10735, 61, CAST(28.50000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1287, 10735, 77, CAST(13.00000 AS Decimal(19, 5)), 2, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1288, 10736, 65, CAST(21.05000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1289, 10736, 75, CAST(7.75000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1290, 10737, 13, CAST(6.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1291, 10737, 41, CAST(9.65000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1292, 10738, 16, CAST(17.45000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1293, 10739, 36, CAST(19.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1294, 10739, 52, CAST(7.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1295, 10740, 28, CAST(45.60000 AS Decimal(19, 5)), 5, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1296, 10740, 35, CAST(18.00000 AS Decimal(19, 5)), 35, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1297, 10740, 45, CAST(9.50000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1298, 10740, 56, CAST(38.00000 AS Decimal(19, 5)), 14, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1299, 10741, 2, CAST(19.00000 AS Decimal(19, 5)), 15, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1300, 10742, 3, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1301, 10742, 60, CAST(34.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1302, 10742, 72, CAST(34.80000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1303, 10743, 46, CAST(12.00000 AS Decimal(19, 5)), 28, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1304, 10744, 40, CAST(18.40000 AS Decimal(19, 5)), 50, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1305, 10745, 18, CAST(62.50000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1306, 10745, 44, CAST(19.45000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1307, 10745, 59, CAST(55.00000 AS Decimal(19, 5)), 45, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1308, 10745, 72, CAST(34.80000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1309, 10746, 13, CAST(6.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1310, 10746, 42, CAST(14.00000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1311, 10746, 62, CAST(49.30000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1312, 10746, 69, CAST(36.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 1300 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1313, 10747, 31, CAST(12.50000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1314, 10747, 41, CAST(9.65000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1315, 10747, 63, CAST(43.90000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1316, 10747, 69, CAST(36.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1317, 10748, 23, CAST(9.00000 AS Decimal(19, 5)), 44, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1318, 10748, 40, CAST(18.40000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1319, 10748, 56, CAST(38.00000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1320, 10749, 56, CAST(38.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1321, 10749, 59, CAST(55.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1322, 10749, 76, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1323, 10750, 14, CAST(23.25000 AS Decimal(19, 5)), 5, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1324, 10750, 45, CAST(9.50000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1325, 10750, 59, CAST(55.00000 AS Decimal(19, 5)), 25, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1326, 10751, 26, CAST(31.23000 AS Decimal(19, 5)), 12, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1327, 10751, 30, CAST(25.89000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1328, 10751, 50, CAST(16.25000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1329, 10751, 73, CAST(15.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1330, 10752, 1, CAST(18.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1331, 10752, 69, CAST(36.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1332, 10753, 45, CAST(9.50000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1333, 10753, 74, CAST(10.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1334, 10754, 40, CAST(18.40000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1335, 10755, 47, CAST(9.50000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1336, 10755, 56, CAST(38.00000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1337, 10755, 57, CAST(19.50000 AS Decimal(19, 5)), 14, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1338, 10755, 69, CAST(36.00000 AS Decimal(19, 5)), 25, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1339, 10756, 18, CAST(62.50000 AS Decimal(19, 5)), 21, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1340, 10756, 36, CAST(19.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1341, 10756, 68, CAST(12.50000 AS Decimal(19, 5)), 6, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1342, 10756, 69, CAST(36.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1343, 10757, 34, CAST(14.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1344, 10757, 59, CAST(55.00000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1345, 10757, 62, CAST(49.30000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1346, 10757, 64, CAST(33.25000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1347, 10758, 26, CAST(31.23000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1348, 10758, 52, CAST(7.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1349, 10758, 70, CAST(15.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1350, 10759, 32, CAST(32.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1351, 10760, 25, CAST(14.00000 AS Decimal(19, 5)), 12, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1352, 10760, 27, CAST(43.90000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1353, 10760, 43, CAST(46.00000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1354, 10761, 25, CAST(14.00000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1355, 10761, 75, CAST(7.75000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1356, 10762, 39, CAST(18.00000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1357, 10762, 47, CAST(9.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1358, 10762, 51, CAST(53.00000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1359, 10762, 56, CAST(38.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1360, 10763, 21, CAST(10.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1361, 10763, 22, CAST(21.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1362, 10763, 24, CAST(4.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1363, 10764, 3, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1364, 10764, 39, CAST(18.00000 AS Decimal(19, 5)), 130, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1365, 10765, 65, CAST(21.05000 AS Decimal(19, 5)), 80, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1366, 10766, 2, CAST(19.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1367, 10766, 7, CAST(30.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1368, 10766, 68, CAST(12.50000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1369, 10767, 42, CAST(14.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1370, 10768, 22, CAST(21.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1371, 10768, 31, CAST(12.50000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1372, 10768, 60, CAST(34.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1373, 10768, 71, CAST(21.50000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1374, 10769, 41, CAST(9.65000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1375, 10769, 52, CAST(7.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1376, 10769, 61, CAST(28.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1377, 10769, 62, CAST(49.30000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1378, 10770, 11, CAST(21.00000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1379, 10771, 71, CAST(21.50000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1380, 10772, 29, CAST(123.79000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1381, 10772, 59, CAST(55.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1382, 10773, 17, CAST(39.00000 AS Decimal(19, 5)), 33, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1383, 10773, 31, CAST(12.50000 AS Decimal(19, 5)), 70, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1384, 10773, 75, CAST(7.75000 AS Decimal(19, 5)), 7, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1385, 10774, 31, CAST(12.50000 AS Decimal(19, 5)), 2, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1386, 10774, 66, CAST(17.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1387, 10775, 10, CAST(31.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1388, 10775, 67, CAST(14.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1389, 10776, 31, CAST(12.50000 AS Decimal(19, 5)), 16, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1390, 10776, 42, CAST(14.00000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1391, 10776, 45, CAST(9.50000 AS Decimal(19, 5)), 27, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1392, 10776, 51, CAST(53.00000 AS Decimal(19, 5)), 120, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1393, 10777, 42, CAST(14.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1394, 10778, 41, CAST(9.65000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1395, 10779, 16, CAST(17.45000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1396, 10779, 62, CAST(49.30000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1397, 10780, 70, CAST(15.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1398, 10780, 77, CAST(13.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1399, 10781, 54, CAST(7.45000 AS Decimal(19, 5)), 3, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1400, 10781, 56, CAST(38.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1401, 10781, 74, CAST(10.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1402, 10782, 31, CAST(12.50000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1403, 10783, 31, CAST(12.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1404, 10783, 38, CAST(263.50000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1405, 10784, 36, CAST(19.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1406, 10784, 39, CAST(18.00000 AS Decimal(19, 5)), 2, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1407, 10784, 72, CAST(34.80000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1408, 10785, 10, CAST(31.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1409, 10785, 75, CAST(7.75000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1410, 10786, 8, CAST(40.00000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1411, 10786, 30, CAST(25.89000 AS Decimal(19, 5)), 15, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1412, 10786, 75, CAST(7.75000 AS Decimal(19, 5)), 42, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1413, 10787, 2, CAST(19.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
GO
print 'Processed 1400 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1414, 10787, 29, CAST(123.79000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1415, 10788, 19, CAST(9.20000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1416, 10788, 75, CAST(7.75000 AS Decimal(19, 5)), 40, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1417, 10789, 18, CAST(62.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1418, 10789, 35, CAST(18.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1419, 10789, 63, CAST(43.90000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1420, 10789, 68, CAST(12.50000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1421, 10790, 7, CAST(30.00000 AS Decimal(19, 5)), 3, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1422, 10790, 56, CAST(38.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1423, 10791, 29, CAST(123.79000 AS Decimal(19, 5)), 14, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1424, 10791, 41, CAST(9.65000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1425, 10792, 2, CAST(19.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1426, 10792, 54, CAST(7.45000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1427, 10792, 68, CAST(12.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1428, 10793, 41, CAST(9.65000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1429, 10793, 52, CAST(7.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1430, 10794, 14, CAST(23.25000 AS Decimal(19, 5)), 15, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1431, 10794, 54, CAST(7.45000 AS Decimal(19, 5)), 6, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1432, 10795, 16, CAST(17.45000 AS Decimal(19, 5)), 65, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1433, 10795, 17, CAST(39.00000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1434, 10796, 26, CAST(31.23000 AS Decimal(19, 5)), 21, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1435, 10796, 44, CAST(19.45000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1436, 10796, 64, CAST(33.25000 AS Decimal(19, 5)), 35, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1437, 10796, 69, CAST(36.00000 AS Decimal(19, 5)), 24, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1438, 10797, 11, CAST(21.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1439, 10798, 62, CAST(49.30000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1440, 10798, 72, CAST(34.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1441, 10799, 13, CAST(6.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1442, 10799, 24, CAST(4.50000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1443, 10799, 59, CAST(55.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1444, 10800, 11, CAST(21.00000 AS Decimal(19, 5)), 50, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1445, 10800, 51, CAST(53.00000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1446, 10800, 54, CAST(7.45000 AS Decimal(19, 5)), 7, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1447, 10801, 17, CAST(39.00000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1448, 10801, 29, CAST(123.79000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1449, 10802, 30, CAST(25.89000 AS Decimal(19, 5)), 25, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1450, 10802, 51, CAST(53.00000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1451, 10802, 55, CAST(24.00000 AS Decimal(19, 5)), 60, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1452, 10802, 62, CAST(49.30000 AS Decimal(19, 5)), 5, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1453, 10803, 19, CAST(9.20000 AS Decimal(19, 5)), 24, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1454, 10803, 25, CAST(14.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1455, 10803, 59, CAST(55.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1456, 10804, 10, CAST(31.00000 AS Decimal(19, 5)), 36, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1457, 10804, 28, CAST(45.60000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1458, 10804, 49, CAST(20.00000 AS Decimal(19, 5)), 4, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1459, 10805, 34, CAST(14.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1460, 10805, 38, CAST(263.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1461, 10806, 2, CAST(19.00000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1462, 10806, 65, CAST(21.05000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1463, 10806, 74, CAST(10.00000 AS Decimal(19, 5)), 15, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1464, 10807, 40, CAST(18.40000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1465, 10808, 56, CAST(38.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1466, 10808, 76, CAST(18.00000 AS Decimal(19, 5)), 50, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1467, 10809, 52, CAST(7.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1468, 10810, 13, CAST(6.00000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1469, 10810, 25, CAST(14.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1470, 10810, 70, CAST(15.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1471, 10811, 19, CAST(9.20000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1472, 10811, 23, CAST(9.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1473, 10811, 40, CAST(18.40000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1474, 10812, 31, CAST(12.50000 AS Decimal(19, 5)), 16, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1475, 10812, 72, CAST(34.80000 AS Decimal(19, 5)), 40, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1476, 10812, 77, CAST(13.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1477, 10813, 2, CAST(19.00000 AS Decimal(19, 5)), 12, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1478, 10813, 46, CAST(12.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1479, 10814, 41, CAST(9.65000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1480, 10814, 43, CAST(46.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1481, 10814, 48, CAST(12.75000 AS Decimal(19, 5)), 8, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1482, 10814, 61, CAST(28.50000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1483, 10815, 33, CAST(2.50000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1484, 10816, 38, CAST(263.50000 AS Decimal(19, 5)), 30, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1485, 10816, 62, CAST(49.30000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1486, 10817, 26, CAST(31.23000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1487, 10817, 38, CAST(263.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1488, 10817, 40, CAST(18.40000 AS Decimal(19, 5)), 60, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1489, 10817, 62, CAST(49.30000 AS Decimal(19, 5)), 25, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1490, 10818, 32, CAST(32.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1491, 10818, 41, CAST(9.65000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1492, 10819, 43, CAST(46.00000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1493, 10819, 75, CAST(7.75000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1494, 10820, 56, CAST(38.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1495, 10821, 35, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1496, 10821, 51, CAST(53.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1497, 10822, 62, CAST(49.30000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1498, 10822, 70, CAST(15.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1499, 10823, 11, CAST(21.00000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1500, 10823, 57, CAST(19.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1501, 10823, 59, CAST(55.00000 AS Decimal(19, 5)), 40, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1502, 10823, 77, CAST(13.00000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1503, 10824, 41, CAST(9.65000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1504, 10824, 70, CAST(15.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1505, 10825, 26, CAST(31.23000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1506, 10825, 53, CAST(32.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1507, 10826, 31, CAST(12.50000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1508, 10826, 57, CAST(19.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1509, 10827, 10, CAST(31.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1510, 10827, 39, CAST(18.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1511, 10828, 20, CAST(81.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1512, 10828, 38, CAST(263.50000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1513, 10829, 2, CAST(19.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1514, 10829, 8, CAST(40.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 1500 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1515, 10829, 13, CAST(6.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1516, 10829, 60, CAST(34.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1517, 10830, 6, CAST(25.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1518, 10830, 39, CAST(18.00000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1519, 10830, 60, CAST(34.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1520, 10830, 68, CAST(12.50000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1521, 10831, 19, CAST(9.20000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1522, 10831, 35, CAST(18.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1523, 10831, 38, CAST(263.50000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1524, 10831, 43, CAST(46.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1525, 10832, 13, CAST(6.00000 AS Decimal(19, 5)), 3, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1526, 10832, 25, CAST(14.00000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1527, 10832, 44, CAST(19.45000 AS Decimal(19, 5)), 16, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1528, 10832, 64, CAST(33.25000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1529, 10833, 7, CAST(30.00000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1530, 10833, 31, CAST(12.50000 AS Decimal(19, 5)), 9, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1531, 10833, 53, CAST(32.80000 AS Decimal(19, 5)), 9, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1532, 10834, 29, CAST(123.79000 AS Decimal(19, 5)), 8, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1533, 10834, 30, CAST(25.89000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1534, 10835, 59, CAST(55.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1535, 10835, 77, CAST(13.00000 AS Decimal(19, 5)), 2, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1536, 10836, 22, CAST(21.00000 AS Decimal(19, 5)), 52, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1537, 10836, 35, CAST(18.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1538, 10836, 57, CAST(19.50000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1539, 10836, 60, CAST(34.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1540, 10836, 64, CAST(33.25000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1541, 10837, 13, CAST(6.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1542, 10837, 40, CAST(18.40000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1543, 10837, 47, CAST(9.50000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1544, 10837, 76, CAST(18.00000 AS Decimal(19, 5)), 21, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1545, 10838, 1, CAST(18.00000 AS Decimal(19, 5)), 4, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1546, 10838, 18, CAST(62.50000 AS Decimal(19, 5)), 25, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1547, 10838, 36, CAST(19.00000 AS Decimal(19, 5)), 50, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1548, 10839, 58, CAST(13.25000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1549, 10839, 72, CAST(34.80000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1550, 10840, 25, CAST(14.00000 AS Decimal(19, 5)), 6, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1551, 10840, 39, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1552, 10841, 10, CAST(31.00000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1553, 10841, 56, CAST(38.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1554, 10841, 59, CAST(55.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1555, 10841, 77, CAST(13.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1556, 10842, 11, CAST(21.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1557, 10842, 43, CAST(46.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1558, 10842, 68, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1559, 10842, 70, CAST(15.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1560, 10843, 51, CAST(53.00000 AS Decimal(19, 5)), 4, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1561, 10844, 22, CAST(21.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1562, 10845, 23, CAST(9.00000 AS Decimal(19, 5)), 70, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1563, 10845, 35, CAST(18.00000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1564, 10845, 42, CAST(14.00000 AS Decimal(19, 5)), 42, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1565, 10845, 58, CAST(13.25000 AS Decimal(19, 5)), 60, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1566, 10845, 64, CAST(33.25000 AS Decimal(19, 5)), 48, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1567, 10846, 4, CAST(22.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1568, 10846, 70, CAST(15.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1569, 10846, 74, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1570, 10847, 1, CAST(18.00000 AS Decimal(19, 5)), 80, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1571, 10847, 19, CAST(9.20000 AS Decimal(19, 5)), 12, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1572, 10847, 37, CAST(26.00000 AS Decimal(19, 5)), 60, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1573, 10847, 45, CAST(9.50000 AS Decimal(19, 5)), 36, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1574, 10847, 60, CAST(34.00000 AS Decimal(19, 5)), 45, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1575, 10847, 71, CAST(21.50000 AS Decimal(19, 5)), 55, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1576, 10848, 5, CAST(21.35000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1577, 10848, 9, CAST(97.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1578, 10849, 3, CAST(10.00000 AS Decimal(19, 5)), 49, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1579, 10849, 26, CAST(31.23000 AS Decimal(19, 5)), 18, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1580, 10850, 25, CAST(14.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1581, 10850, 33, CAST(2.50000 AS Decimal(19, 5)), 4, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1582, 10850, 70, CAST(15.00000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1583, 10851, 2, CAST(19.00000 AS Decimal(19, 5)), 5, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1584, 10851, 25, CAST(14.00000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1585, 10851, 57, CAST(19.50000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1586, 10851, 59, CAST(55.00000 AS Decimal(19, 5)), 42, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1587, 10852, 2, CAST(19.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1588, 10852, 17, CAST(39.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1589, 10852, 62, CAST(49.30000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1590, 10853, 18, CAST(62.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1591, 10854, 10, CAST(31.00000 AS Decimal(19, 5)), 100, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1592, 10854, 13, CAST(6.00000 AS Decimal(19, 5)), 65, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1593, 10855, 16, CAST(17.45000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1594, 10855, 31, CAST(12.50000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1595, 10855, 56, CAST(38.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1596, 10855, 65, CAST(21.05000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1597, 10856, 2, CAST(19.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1598, 10856, 42, CAST(14.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1599, 10857, 3, CAST(10.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1600, 10857, 26, CAST(31.23000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1601, 10857, 29, CAST(123.79000 AS Decimal(19, 5)), 10, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1602, 10858, 7, CAST(30.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1603, 10858, 27, CAST(43.90000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1604, 10858, 70, CAST(15.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1605, 10859, 24, CAST(4.50000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1606, 10859, 54, CAST(7.45000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1607, 10859, 64, CAST(33.25000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1608, 10860, 51, CAST(53.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1609, 10860, 76, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1610, 10861, 17, CAST(39.00000 AS Decimal(19, 5)), 42, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1611, 10861, 18, CAST(62.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1612, 10861, 21, CAST(10.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1613, 10861, 33, CAST(2.50000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1614, 10861, 62, CAST(49.30000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1615, 10862, 11, CAST(21.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 1600 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1616, 10862, 52, CAST(7.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1617, 10863, 1, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1618, 10863, 58, CAST(13.25000 AS Decimal(19, 5)), 12, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1619, 10864, 35, CAST(18.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1620, 10864, 67, CAST(14.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1621, 10865, 38, CAST(263.50000 AS Decimal(19, 5)), 60, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1622, 10865, 39, CAST(18.00000 AS Decimal(19, 5)), 80, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1623, 10866, 2, CAST(19.00000 AS Decimal(19, 5)), 21, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1624, 10866, 24, CAST(4.50000 AS Decimal(19, 5)), 6, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1625, 10866, 30, CAST(25.89000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1626, 10867, 53, CAST(32.80000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1627, 10868, 26, CAST(31.23000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1628, 10868, 35, CAST(18.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1629, 10868, 49, CAST(20.00000 AS Decimal(19, 5)), 42, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1630, 10869, 1, CAST(18.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1631, 10869, 11, CAST(21.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1632, 10869, 23, CAST(9.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1633, 10869, 68, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1634, 10870, 35, CAST(18.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1635, 10870, 51, CAST(53.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1636, 10871, 6, CAST(25.00000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1637, 10871, 16, CAST(17.45000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1638, 10871, 17, CAST(39.00000 AS Decimal(19, 5)), 16, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1639, 10872, 55, CAST(24.00000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1640, 10872, 62, CAST(49.30000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1641, 10872, 64, CAST(33.25000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1642, 10872, 65, CAST(21.05000 AS Decimal(19, 5)), 21, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1643, 10873, 21, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1644, 10873, 28, CAST(45.60000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1645, 10874, 10, CAST(31.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1646, 10875, 19, CAST(9.20000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1647, 10875, 47, CAST(9.50000 AS Decimal(19, 5)), 21, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1648, 10875, 49, CAST(20.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1649, 10876, 46, CAST(12.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1650, 10876, 64, CAST(33.25000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1651, 10877, 16, CAST(17.45000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1652, 10877, 18, CAST(62.50000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1653, 10878, 20, CAST(81.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1654, 10879, 40, CAST(18.40000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1655, 10879, 65, CAST(21.05000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1656, 10879, 76, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1657, 10880, 23, CAST(9.00000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1658, 10880, 61, CAST(28.50000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1659, 10880, 70, CAST(15.00000 AS Decimal(19, 5)), 50, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1660, 10881, 73, CAST(15.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1661, 10882, 42, CAST(14.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1662, 10882, 49, CAST(20.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1663, 10882, 54, CAST(7.45000 AS Decimal(19, 5)), 32, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1664, 10883, 24, CAST(4.50000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1665, 10884, 21, CAST(10.00000 AS Decimal(19, 5)), 40, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1666, 10884, 56, CAST(38.00000 AS Decimal(19, 5)), 21, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1667, 10884, 65, CAST(21.05000 AS Decimal(19, 5)), 12, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1668, 10885, 2, CAST(19.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1669, 10885, 24, CAST(4.50000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1670, 10885, 70, CAST(15.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1671, 10885, 77, CAST(13.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1672, 10886, 10, CAST(31.00000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1673, 10886, 31, CAST(12.50000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1674, 10886, 77, CAST(13.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1675, 10887, 25, CAST(14.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1676, 10888, 2, CAST(19.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1677, 10888, 68, CAST(12.50000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1678, 10889, 11, CAST(21.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1679, 10889, 38, CAST(263.50000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1680, 10890, 17, CAST(39.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1681, 10890, 34, CAST(14.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1682, 10890, 41, CAST(9.65000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1683, 10891, 30, CAST(25.89000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1684, 10892, 59, CAST(55.00000 AS Decimal(19, 5)), 40, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1685, 10893, 8, CAST(40.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1686, 10893, 24, CAST(4.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1687, 10893, 29, CAST(123.79000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1688, 10893, 30, CAST(25.89000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1689, 10893, 36, CAST(19.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1690, 10894, 13, CAST(6.00000 AS Decimal(19, 5)), 28, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1691, 10894, 69, CAST(36.00000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1692, 10894, 75, CAST(7.75000 AS Decimal(19, 5)), 120, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1693, 10895, 24, CAST(4.50000 AS Decimal(19, 5)), 110, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1694, 10895, 39, CAST(18.00000 AS Decimal(19, 5)), 45, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1695, 10895, 40, CAST(18.40000 AS Decimal(19, 5)), 91, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1696, 10895, 60, CAST(34.00000 AS Decimal(19, 5)), 100, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1697, 10896, 45, CAST(9.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1698, 10896, 56, CAST(38.00000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1699, 10897, 29, CAST(123.79000 AS Decimal(19, 5)), 80, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1700, 10897, 30, CAST(25.89000 AS Decimal(19, 5)), 36, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1701, 10898, 13, CAST(6.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1702, 10899, 39, CAST(18.00000 AS Decimal(19, 5)), 8, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1703, 10900, 70, CAST(15.00000 AS Decimal(19, 5)), 3, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1704, 10901, 41, CAST(9.65000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1705, 10901, 71, CAST(21.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1706, 10902, 55, CAST(24.00000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1707, 10902, 62, CAST(49.30000 AS Decimal(19, 5)), 6, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1708, 10903, 13, CAST(6.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1709, 10903, 65, CAST(21.05000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1710, 10903, 68, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1711, 10904, 58, CAST(13.25000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1712, 10904, 62, CAST(49.30000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1713, 10905, 1, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1714, 10906, 61, CAST(28.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1715, 10907, 75, CAST(7.75000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1716, 10908, 7, CAST(30.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
GO
print 'Processed 1700 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1717, 10908, 52, CAST(7.00000 AS Decimal(19, 5)), 14, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1718, 10909, 7, CAST(30.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1719, 10909, 16, CAST(17.45000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1720, 10909, 41, CAST(9.65000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1721, 10910, 19, CAST(9.20000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1722, 10910, 49, CAST(20.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1723, 10910, 61, CAST(28.50000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1724, 10911, 1, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1725, 10911, 17, CAST(39.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1726, 10911, 67, CAST(14.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1727, 10912, 11, CAST(21.00000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1728, 10912, 29, CAST(123.79000 AS Decimal(19, 5)), 60, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1729, 10913, 4, CAST(22.00000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1730, 10913, 33, CAST(2.50000 AS Decimal(19, 5)), 40, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1731, 10913, 58, CAST(13.25000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1732, 10914, 71, CAST(21.50000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1733, 10915, 17, CAST(39.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1734, 10915, 33, CAST(2.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1735, 10915, 54, CAST(7.45000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1736, 10916, 16, CAST(17.45000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1737, 10916, 32, CAST(32.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1738, 10916, 57, CAST(19.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1739, 10917, 30, CAST(25.89000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1740, 10917, 60, CAST(34.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1741, 10918, 1, CAST(18.00000 AS Decimal(19, 5)), 60, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1742, 10918, 60, CAST(34.00000 AS Decimal(19, 5)), 25, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1743, 10919, 16, CAST(17.45000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1744, 10919, 25, CAST(14.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1745, 10919, 40, CAST(18.40000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1746, 10920, 50, CAST(16.25000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1747, 10921, 35, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1748, 10921, 63, CAST(43.90000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1749, 10922, 17, CAST(39.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1750, 10922, 24, CAST(4.50000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1751, 10923, 42, CAST(14.00000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1752, 10923, 43, CAST(46.00000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1753, 10923, 67, CAST(14.00000 AS Decimal(19, 5)), 24, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1754, 10924, 10, CAST(31.00000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1755, 10924, 28, CAST(45.60000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1756, 10924, 75, CAST(7.75000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1757, 10925, 36, CAST(19.00000 AS Decimal(19, 5)), 25, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1758, 10925, 52, CAST(7.00000 AS Decimal(19, 5)), 12, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1759, 10926, 11, CAST(21.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1760, 10926, 13, CAST(6.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1761, 10926, 19, CAST(9.20000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1762, 10926, 72, CAST(34.80000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1763, 10927, 20, CAST(81.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1764, 10927, 52, CAST(7.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1765, 10927, 76, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1766, 10928, 47, CAST(9.50000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1767, 10928, 76, CAST(18.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1768, 10929, 21, CAST(10.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1769, 10929, 75, CAST(7.75000 AS Decimal(19, 5)), 49, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1770, 10929, 77, CAST(13.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1771, 10930, 21, CAST(10.00000 AS Decimal(19, 5)), 36, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1772, 10930, 27, CAST(43.90000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1773, 10930, 55, CAST(24.00000 AS Decimal(19, 5)), 25, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1774, 10930, 58, CAST(13.25000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1775, 10931, 13, CAST(6.00000 AS Decimal(19, 5)), 42, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1776, 10931, 57, CAST(19.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1777, 10932, 16, CAST(17.45000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1778, 10932, 62, CAST(49.30000 AS Decimal(19, 5)), 14, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1779, 10932, 72, CAST(34.80000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1780, 10932, 75, CAST(7.75000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1781, 10933, 53, CAST(32.80000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1782, 10933, 61, CAST(28.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1783, 10934, 6, CAST(25.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1784, 10935, 1, CAST(18.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1785, 10935, 18, CAST(62.50000 AS Decimal(19, 5)), 4, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1786, 10935, 23, CAST(9.00000 AS Decimal(19, 5)), 8, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1787, 10936, 36, CAST(19.00000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1788, 10937, 28, CAST(45.60000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1789, 10937, 34, CAST(14.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1790, 10938, 13, CAST(6.00000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1791, 10938, 43, CAST(46.00000 AS Decimal(19, 5)), 24, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1792, 10938, 60, CAST(34.00000 AS Decimal(19, 5)), 49, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1793, 10938, 71, CAST(21.50000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1794, 10939, 2, CAST(19.00000 AS Decimal(19, 5)), 10, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1795, 10939, 67, CAST(14.00000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1796, 10940, 7, CAST(30.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1797, 10940, 13, CAST(6.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1798, 10941, 31, CAST(12.50000 AS Decimal(19, 5)), 44, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1799, 10941, 62, CAST(49.30000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1800, 10941, 68, CAST(12.50000 AS Decimal(19, 5)), 80, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1801, 10941, 72, CAST(34.80000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1802, 10942, 49, CAST(20.00000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1803, 10943, 13, CAST(6.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1804, 10943, 22, CAST(21.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1805, 10943, 46, CAST(12.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1806, 10944, 11, CAST(21.00000 AS Decimal(19, 5)), 5, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1807, 10944, 44, CAST(19.45000 AS Decimal(19, 5)), 18, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1808, 10944, 56, CAST(38.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1809, 10945, 13, CAST(6.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1810, 10945, 31, CAST(12.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1811, 10946, 10, CAST(31.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1812, 10946, 24, CAST(4.50000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1813, 10946, 77, CAST(13.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1814, 10947, 59, CAST(55.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1815, 10948, 50, CAST(16.25000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1816, 10948, 51, CAST(53.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1817, 10948, 55, CAST(24.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 1800 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1818, 10949, 6, CAST(25.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1819, 10949, 10, CAST(31.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1820, 10949, 17, CAST(39.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1821, 10949, 62, CAST(49.30000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1822, 10950, 4, CAST(22.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1823, 10951, 33, CAST(2.50000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1824, 10951, 41, CAST(9.65000 AS Decimal(19, 5)), 6, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1825, 10951, 75, CAST(7.75000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1826, 10952, 6, CAST(25.00000 AS Decimal(19, 5)), 16, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1827, 10952, 28, CAST(45.60000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1828, 10953, 20, CAST(81.00000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1829, 10953, 31, CAST(12.50000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1830, 10954, 16, CAST(17.45000 AS Decimal(19, 5)), 28, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1831, 10954, 31, CAST(12.50000 AS Decimal(19, 5)), 25, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1832, 10954, 45, CAST(9.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1833, 10954, 60, CAST(34.00000 AS Decimal(19, 5)), 24, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1834, 10955, 75, CAST(7.75000 AS Decimal(19, 5)), 12, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1835, 10956, 21, CAST(10.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1836, 10956, 47, CAST(9.50000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1837, 10956, 51, CAST(53.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1838, 10957, 30, CAST(25.89000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1839, 10957, 35, CAST(18.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1840, 10957, 64, CAST(33.25000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1841, 10958, 5, CAST(21.35000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1842, 10958, 7, CAST(30.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1843, 10958, 72, CAST(34.80000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1844, 10959, 75, CAST(7.75000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1845, 10960, 24, CAST(4.50000 AS Decimal(19, 5)), 10, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1846, 10960, 41, CAST(9.65000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1847, 10961, 52, CAST(7.00000 AS Decimal(19, 5)), 6, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1848, 10961, 76, CAST(18.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1849, 10962, 7, CAST(30.00000 AS Decimal(19, 5)), 45, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1850, 10962, 13, CAST(6.00000 AS Decimal(19, 5)), 77, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1851, 10962, 53, CAST(32.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1852, 10962, 69, CAST(36.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1853, 10962, 76, CAST(18.00000 AS Decimal(19, 5)), 44, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1854, 10963, 60, CAST(34.00000 AS Decimal(19, 5)), 2, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1855, 10964, 18, CAST(62.50000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1856, 10964, 38, CAST(263.50000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1857, 10964, 69, CAST(36.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1858, 10965, 51, CAST(53.00000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1859, 10966, 37, CAST(26.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1860, 10966, 56, CAST(38.00000 AS Decimal(19, 5)), 12, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1861, 10966, 62, CAST(49.30000 AS Decimal(19, 5)), 12, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1862, 10967, 19, CAST(9.20000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1863, 10967, 49, CAST(20.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1864, 10968, 12, CAST(38.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1865, 10968, 24, CAST(4.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1866, 10968, 64, CAST(33.25000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1867, 10969, 46, CAST(12.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1868, 10970, 52, CAST(7.00000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1869, 10971, 29, CAST(123.79000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1870, 10972, 17, CAST(39.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1871, 10972, 33, CAST(2.50000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1872, 10973, 26, CAST(31.23000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1873, 10973, 41, CAST(9.65000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1874, 10973, 75, CAST(7.75000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1875, 10974, 63, CAST(43.90000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1876, 10975, 8, CAST(40.00000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1877, 10975, 75, CAST(7.75000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1878, 10976, 28, CAST(45.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1879, 10977, 39, CAST(18.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1880, 10977, 47, CAST(9.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1881, 10977, 51, CAST(53.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1882, 10977, 63, CAST(43.90000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1883, 10978, 8, CAST(40.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1884, 10978, 21, CAST(10.00000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1885, 10978, 40, CAST(18.40000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1886, 10978, 44, CAST(19.45000 AS Decimal(19, 5)), 6, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1887, 10979, 7, CAST(30.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1888, 10979, 12, CAST(38.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1889, 10979, 24, CAST(4.50000 AS Decimal(19, 5)), 80, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1890, 10979, 27, CAST(43.90000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1891, 10979, 31, CAST(12.50000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1892, 10979, 63, CAST(43.90000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1893, 10980, 75, CAST(7.75000 AS Decimal(19, 5)), 40, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1894, 10981, 38, CAST(263.50000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1895, 10982, 7, CAST(30.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1896, 10982, 43, CAST(46.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1897, 10983, 13, CAST(6.00000 AS Decimal(19, 5)), 84, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1898, 10983, 57, CAST(19.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1899, 10984, 16, CAST(17.45000 AS Decimal(19, 5)), 55, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1900, 10984, 24, CAST(4.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1901, 10984, 36, CAST(19.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1902, 10985, 16, CAST(17.45000 AS Decimal(19, 5)), 36, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1903, 10985, 18, CAST(62.50000 AS Decimal(19, 5)), 8, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1904, 10985, 32, CAST(32.00000 AS Decimal(19, 5)), 35, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1905, 10986, 11, CAST(21.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1906, 10986, 20, CAST(81.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1907, 10986, 76, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1908, 10986, 77, CAST(13.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1909, 10987, 7, CAST(30.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1910, 10987, 43, CAST(46.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1911, 10987, 72, CAST(34.80000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1912, 10988, 7, CAST(30.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1913, 10988, 62, CAST(49.30000 AS Decimal(19, 5)), 40, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1914, 10989, 6, CAST(25.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1915, 10989, 11, CAST(21.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1916, 10989, 41, CAST(9.65000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1917, 10990, 21, CAST(10.00000 AS Decimal(19, 5)), 65, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1918, 10990, 34, CAST(14.00000 AS Decimal(19, 5)), 60, CAST(0.15000 AS Decimal(19, 5)))
GO
print 'Processed 1900 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1919, 10990, 55, CAST(24.00000 AS Decimal(19, 5)), 65, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1920, 10990, 61, CAST(28.50000 AS Decimal(19, 5)), 66, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1921, 10991, 2, CAST(19.00000 AS Decimal(19, 5)), 50, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1922, 10991, 70, CAST(15.00000 AS Decimal(19, 5)), 20, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1923, 10991, 76, CAST(18.00000 AS Decimal(19, 5)), 90, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1924, 10992, 72, CAST(34.80000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1925, 10993, 29, CAST(123.79000 AS Decimal(19, 5)), 50, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1926, 10993, 41, CAST(9.65000 AS Decimal(19, 5)), 35, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1927, 10994, 59, CAST(55.00000 AS Decimal(19, 5)), 18, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1928, 10995, 51, CAST(53.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1929, 10995, 60, CAST(34.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1930, 10996, 42, CAST(14.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1931, 10997, 32, CAST(32.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1932, 10997, 46, CAST(12.00000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1933, 10997, 52, CAST(7.00000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1934, 10998, 24, CAST(4.50000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1935, 10998, 61, CAST(28.50000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1936, 10998, 74, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1937, 10998, 75, CAST(7.75000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1938, 10999, 41, CAST(9.65000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1939, 10999, 51, CAST(53.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1940, 10999, 77, CAST(13.00000 AS Decimal(19, 5)), 21, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1941, 11000, 4, CAST(22.00000 AS Decimal(19, 5)), 25, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1942, 11000, 24, CAST(4.50000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1943, 11000, 77, CAST(13.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1944, 11001, 7, CAST(30.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1945, 11001, 22, CAST(21.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1946, 11001, 46, CAST(12.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1947, 11001, 55, CAST(24.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1948, 11002, 13, CAST(6.00000 AS Decimal(19, 5)), 56, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1949, 11002, 35, CAST(18.00000 AS Decimal(19, 5)), 15, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1950, 11002, 42, CAST(14.00000 AS Decimal(19, 5)), 24, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1951, 11002, 55, CAST(24.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1952, 11003, 1, CAST(18.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1953, 11003, 40, CAST(18.40000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1954, 11003, 52, CAST(7.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1955, 11004, 26, CAST(31.23000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1956, 11004, 76, CAST(18.00000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1957, 11005, 1, CAST(18.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1958, 11005, 59, CAST(55.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1959, 11006, 1, CAST(18.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1960, 11006, 29, CAST(123.79000 AS Decimal(19, 5)), 2, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1961, 11007, 8, CAST(40.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1962, 11007, 29, CAST(123.79000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1963, 11007, 42, CAST(14.00000 AS Decimal(19, 5)), 14, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1964, 11008, 28, CAST(45.60000 AS Decimal(19, 5)), 70, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1965, 11008, 34, CAST(14.00000 AS Decimal(19, 5)), 90, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1966, 11008, 71, CAST(21.50000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1967, 11009, 24, CAST(4.50000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1968, 11009, 36, CAST(19.00000 AS Decimal(19, 5)), 18, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1969, 11009, 60, CAST(34.00000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1970, 11010, 7, CAST(30.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1971, 11010, 24, CAST(4.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1972, 11011, 58, CAST(13.25000 AS Decimal(19, 5)), 40, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1973, 11011, 71, CAST(21.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1974, 11012, 19, CAST(9.20000 AS Decimal(19, 5)), 50, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1975, 11012, 60, CAST(34.00000 AS Decimal(19, 5)), 36, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1976, 11012, 71, CAST(21.50000 AS Decimal(19, 5)), 60, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1977, 11013, 23, CAST(9.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1978, 11013, 42, CAST(14.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1979, 11013, 45, CAST(9.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1980, 11013, 68, CAST(12.50000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1981, 11014, 41, CAST(9.65000 AS Decimal(19, 5)), 28, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1982, 11015, 30, CAST(25.89000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1983, 11015, 77, CAST(13.00000 AS Decimal(19, 5)), 18, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1984, 11016, 31, CAST(12.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1985, 11016, 36, CAST(19.00000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1986, 11017, 3, CAST(10.00000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1987, 11017, 59, CAST(55.00000 AS Decimal(19, 5)), 110, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1988, 11017, 70, CAST(15.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1989, 11018, 12, CAST(38.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1990, 11018, 18, CAST(62.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1991, 11018, 56, CAST(38.00000 AS Decimal(19, 5)), 5, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1992, 11019, 46, CAST(12.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1993, 11019, 49, CAST(20.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1994, 11020, 10, CAST(31.00000 AS Decimal(19, 5)), 24, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1995, 11021, 2, CAST(19.00000 AS Decimal(19, 5)), 11, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1996, 11021, 20, CAST(81.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1997, 11021, 26, CAST(31.23000 AS Decimal(19, 5)), 63, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1998, 11021, 51, CAST(53.00000 AS Decimal(19, 5)), 44, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (1999, 11021, 72, CAST(34.80000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2000, 11022, 19, CAST(9.20000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2001, 11022, 69, CAST(36.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2002, 11023, 7, CAST(30.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2003, 11023, 43, CAST(46.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2004, 11024, 26, CAST(31.23000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2005, 11024, 33, CAST(2.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2006, 11024, 65, CAST(21.05000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2007, 11024, 71, CAST(21.50000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2008, 11025, 1, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2009, 11025, 13, CAST(6.00000 AS Decimal(19, 5)), 20, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2010, 11026, 18, CAST(62.50000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2011, 11026, 51, CAST(53.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2012, 11027, 24, CAST(4.50000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2013, 11027, 62, CAST(49.30000 AS Decimal(19, 5)), 21, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2014, 11028, 55, CAST(24.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2015, 11028, 59, CAST(55.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2016, 11029, 56, CAST(38.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2017, 11029, 63, CAST(43.90000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2018, 11030, 2, CAST(19.00000 AS Decimal(19, 5)), 100, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2019, 11030, 5, CAST(21.35000 AS Decimal(19, 5)), 70, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 2000 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2020, 11030, 29, CAST(123.79000 AS Decimal(19, 5)), 60, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2021, 11030, 59, CAST(55.00000 AS Decimal(19, 5)), 100, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2022, 11031, 1, CAST(18.00000 AS Decimal(19, 5)), 45, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2023, 11031, 13, CAST(6.00000 AS Decimal(19, 5)), 80, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2024, 11031, 24, CAST(4.50000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2025, 11031, 64, CAST(33.25000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2026, 11031, 71, CAST(21.50000 AS Decimal(19, 5)), 16, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2027, 11032, 36, CAST(19.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2028, 11032, 38, CAST(263.50000 AS Decimal(19, 5)), 25, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2029, 11032, 59, CAST(55.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2030, 11033, 53, CAST(32.80000 AS Decimal(19, 5)), 70, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2031, 11033, 69, CAST(36.00000 AS Decimal(19, 5)), 36, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2032, 11034, 21, CAST(10.00000 AS Decimal(19, 5)), 15, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2033, 11034, 44, CAST(19.45000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2034, 11034, 61, CAST(28.50000 AS Decimal(19, 5)), 6, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2035, 11035, 1, CAST(18.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2036, 11035, 35, CAST(18.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2037, 11035, 42, CAST(14.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2038, 11035, 54, CAST(7.45000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2039, 11036, 13, CAST(6.00000 AS Decimal(19, 5)), 7, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2040, 11036, 59, CAST(55.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2041, 11037, 70, CAST(15.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2042, 11038, 40, CAST(18.40000 AS Decimal(19, 5)), 5, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2043, 11038, 52, CAST(7.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2044, 11038, 71, CAST(21.50000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2045, 11039, 28, CAST(45.60000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2046, 11039, 35, CAST(18.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2047, 11039, 49, CAST(20.00000 AS Decimal(19, 5)), 60, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2048, 11039, 57, CAST(19.50000 AS Decimal(19, 5)), 28, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2049, 11040, 21, CAST(10.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2050, 11041, 2, CAST(19.00000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2051, 11041, 63, CAST(43.90000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2052, 11042, 44, CAST(19.45000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2053, 11042, 61, CAST(28.50000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2054, 11043, 11, CAST(21.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2055, 11044, 62, CAST(49.30000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2056, 11045, 33, CAST(2.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2057, 11045, 51, CAST(53.00000 AS Decimal(19, 5)), 24, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2058, 11046, 12, CAST(38.00000 AS Decimal(19, 5)), 20, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2059, 11046, 32, CAST(32.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2060, 11046, 35, CAST(18.00000 AS Decimal(19, 5)), 18, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2061, 11047, 1, CAST(18.00000 AS Decimal(19, 5)), 25, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2062, 11047, 5, CAST(21.35000 AS Decimal(19, 5)), 30, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2063, 11048, 68, CAST(12.50000 AS Decimal(19, 5)), 42, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2064, 11049, 2, CAST(19.00000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2065, 11049, 12, CAST(38.00000 AS Decimal(19, 5)), 4, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2066, 11050, 76, CAST(18.00000 AS Decimal(19, 5)), 50, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2067, 11051, 24, CAST(4.50000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2068, 11052, 43, CAST(46.00000 AS Decimal(19, 5)), 30, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2069, 11052, 61, CAST(28.50000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2070, 11053, 18, CAST(62.50000 AS Decimal(19, 5)), 35, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2071, 11053, 32, CAST(32.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2072, 11053, 64, CAST(33.25000 AS Decimal(19, 5)), 25, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2073, 11054, 33, CAST(2.50000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2074, 11054, 67, CAST(14.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2075, 11055, 24, CAST(4.50000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2076, 11055, 25, CAST(14.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2077, 11055, 51, CAST(53.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2078, 11055, 57, CAST(19.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2079, 11056, 7, CAST(30.00000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2080, 11056, 55, CAST(24.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2081, 11056, 60, CAST(34.00000 AS Decimal(19, 5)), 50, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2082, 11057, 70, CAST(15.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2083, 11058, 21, CAST(10.00000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2084, 11058, 60, CAST(34.00000 AS Decimal(19, 5)), 21, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2085, 11058, 61, CAST(28.50000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2086, 11059, 13, CAST(6.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2087, 11059, 17, CAST(39.00000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2088, 11059, 60, CAST(34.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2089, 11060, 60, CAST(34.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2090, 11060, 77, CAST(13.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2091, 11061, 60, CAST(34.00000 AS Decimal(19, 5)), 15, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2092, 11062, 53, CAST(32.80000 AS Decimal(19, 5)), 10, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2093, 11062, 70, CAST(15.00000 AS Decimal(19, 5)), 12, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2094, 11063, 34, CAST(14.00000 AS Decimal(19, 5)), 30, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2095, 11063, 40, CAST(18.40000 AS Decimal(19, 5)), 40, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2096, 11063, 41, CAST(9.65000 AS Decimal(19, 5)), 30, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2097, 11064, 17, CAST(39.00000 AS Decimal(19, 5)), 77, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2098, 11064, 41, CAST(9.65000 AS Decimal(19, 5)), 12, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2099, 11064, 53, CAST(32.80000 AS Decimal(19, 5)), 25, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2100, 11064, 55, CAST(24.00000 AS Decimal(19, 5)), 4, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2101, 11064, 68, CAST(12.50000 AS Decimal(19, 5)), 55, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2102, 11065, 30, CAST(25.89000 AS Decimal(19, 5)), 4, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2103, 11065, 54, CAST(7.45000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2104, 11066, 16, CAST(17.45000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2105, 11066, 19, CAST(9.20000 AS Decimal(19, 5)), 42, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2106, 11066, 34, CAST(14.00000 AS Decimal(19, 5)), 35, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2107, 11067, 41, CAST(9.65000 AS Decimal(19, 5)), 9, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2108, 11068, 28, CAST(45.60000 AS Decimal(19, 5)), 8, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2109, 11068, 43, CAST(46.00000 AS Decimal(19, 5)), 36, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2110, 11068, 77, CAST(13.00000 AS Decimal(19, 5)), 28, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2111, 11069, 39, CAST(18.00000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2112, 11070, 1, CAST(18.00000 AS Decimal(19, 5)), 40, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2113, 11070, 2, CAST(19.00000 AS Decimal(19, 5)), 20, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2114, 11070, 16, CAST(17.45000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2115, 11070, 31, CAST(12.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2116, 11071, 7, CAST(30.00000 AS Decimal(19, 5)), 15, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2117, 11071, 13, CAST(6.00000 AS Decimal(19, 5)), 10, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2118, 11072, 2, CAST(19.00000 AS Decimal(19, 5)), 8, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2119, 11072, 41, CAST(9.65000 AS Decimal(19, 5)), 40, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2120, 11072, 50, CAST(16.25000 AS Decimal(19, 5)), 22, CAST(0.00000 AS Decimal(19, 5)))
GO
print 'Processed 2100 total records'
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2121, 11072, 64, CAST(33.25000 AS Decimal(19, 5)), 130, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2122, 11073, 11, CAST(21.00000 AS Decimal(19, 5)), 10, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2123, 11073, 24, CAST(4.50000 AS Decimal(19, 5)), 20, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2124, 11074, 16, CAST(17.45000 AS Decimal(19, 5)), 14, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2125, 11075, 2, CAST(19.00000 AS Decimal(19, 5)), 10, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2126, 11075, 46, CAST(12.00000 AS Decimal(19, 5)), 30, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2127, 11075, 76, CAST(18.00000 AS Decimal(19, 5)), 2, CAST(0.15000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2128, 11076, 6, CAST(25.00000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2129, 11076, 14, CAST(23.25000 AS Decimal(19, 5)), 20, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2130, 11076, 19, CAST(9.20000 AS Decimal(19, 5)), 10, CAST(0.25000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2131, 11077, 2, CAST(19.00000 AS Decimal(19, 5)), 24, CAST(0.20000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2132, 11077, 3, CAST(10.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2133, 11077, 4, CAST(22.00000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2134, 11077, 6, CAST(25.00000 AS Decimal(19, 5)), 1, CAST(0.02000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2135, 11077, 7, CAST(30.00000 AS Decimal(19, 5)), 1, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2136, 11077, 8, CAST(40.00000 AS Decimal(19, 5)), 2, CAST(0.10000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2137, 11077, 10, CAST(31.00000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2138, 11077, 12, CAST(38.00000 AS Decimal(19, 5)), 2, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2139, 11077, 13, CAST(6.00000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2140, 11077, 14, CAST(23.25000 AS Decimal(19, 5)), 1, CAST(0.03000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2141, 11077, 16, CAST(17.45000 AS Decimal(19, 5)), 2, CAST(0.03000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2142, 11077, 20, CAST(81.00000 AS Decimal(19, 5)), 1, CAST(0.04000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2143, 11077, 23, CAST(9.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2144, 11077, 32, CAST(32.00000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2145, 11077, 39, CAST(18.00000 AS Decimal(19, 5)), 2, CAST(0.05000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2146, 11077, 41, CAST(9.65000 AS Decimal(19, 5)), 3, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2147, 11077, 46, CAST(12.00000 AS Decimal(19, 5)), 3, CAST(0.02000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2148, 11077, 52, CAST(7.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2149, 11077, 55, CAST(24.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2150, 11077, 60, CAST(34.00000 AS Decimal(19, 5)), 2, CAST(0.06000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2151, 11077, 64, CAST(33.25000 AS Decimal(19, 5)), 2, CAST(0.03000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2152, 11077, 66, CAST(17.00000 AS Decimal(19, 5)), 1, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2153, 11077, 73, CAST(15.00000 AS Decimal(19, 5)), 2, CAST(0.01000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2154, 11077, 75, CAST(7.75000 AS Decimal(19, 5)), 4, CAST(0.00000 AS Decimal(19, 5)))
INSERT [dbo].[OrderLines] ([OrderLineId], [OrderId], [ProductId], [UnitPrice], [Quantity], [Discount]) VALUES (2155, 11077, 77, CAST(13.00000 AS Decimal(19, 5)), 2, CAST(0.00000 AS Decimal(19, 5)))
SET IDENTITY_INSERT [dbo].[OrderLines] OFF
/****** Object:  Table [dbo].[Users]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Users](
	[UserId] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](255) NULL,
	[InvalidLoginAttempts] [int] NULL,
	[RegisteredAt] [datetime] NULL,
	[LastLoginDate] [datetime] NULL,
	[Enum1] [nvarchar](12) NULL,
	[Enum2] [int] NOT NULL,
	[Features] [int] NOT NULL DEFAULT(0),
	[RoleId] [int] NULL,
	[Property1] [varchar](255) NULL,
	[Property2] [varchar](255) NULL,
	[OtherProperty1] [varchar](255) NULL,
	[CreatedById] [int] NOT NULL,
	[ModifiedById] [int] NULL
PRIMARY KEY CLUSTERED 
(
	[UserId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET IDENTITY_INSERT [dbo].[Users] ON
INSERT [dbo].[Users] ([UserId], [Name], [InvalidLoginAttempts], [RegisteredAt], [LastLoginDate], [Enum1], [Enum2], [RoleId], [Property1], [Property2], [OtherProperty1], [CreatedById], [ModifiedById]) VALUES (1, N'ayende', 4, CAST(0x00009D9800000000 AS DateTime), NULL, N'Medium', 1, 1, N'test1', N'test2', N'othertest1', 1, NULL)
INSERT [dbo].[Users] ([UserId], [Name], [InvalidLoginAttempts], [RegisteredAt], [LastLoginDate], [Enum1], [Enum2], [RoleId], [Property1], [Property2], [OtherProperty1], [CreatedById], [ModifiedById]) VALUES (2, N'rahien', 5, CAST(0x00008D3E00000000 AS DateTime), NULL, N'Small', 0, 2, NULL, N'test2', NULL, 1, NULL)
INSERT [dbo].[Users] ([UserId], [Name], [InvalidLoginAttempts], [RegisteredAt], [LastLoginDate], [Enum1], [Enum2], [Features], [RoleId], [Property1], [Property2], [OtherProperty1], [CreatedById], [ModifiedById]) VALUES (3, N'nhibernate', 6, CAST(0x00008EAC00000000 AS DateTime), CAST(0x00009D970110B41C AS DateTime), N'Medium', 0, 8, NULL, NULL, NULL, NULL, 1, NULL)
SET IDENTITY_INSERT [dbo].[Users] OFF
/****** Object:  Table [dbo].[TimeSheetUsers]    Script Date: 06/17/2010 13:08:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TimeSheetUsers](
	[TimesheetID] [int] NOT NULL,
	[UserId] [int] NOT NULL
) ON [PRIMARY]
GO
INSERT [dbo].[TimeSheetUsers] ([TimesheetID], [UserId]) VALUES (1, 1)
INSERT [dbo].[TimeSheetUsers] ([TimesheetID], [UserId]) VALUES (1, 2)
INSERT [dbo].[TimeSheetUsers] ([TimesheetID], [UserId]) VALUES (2, 1)
/****** Object:  ForeignKey [FK8DED0743B77C69F9]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Animal]  WITH CHECK ADD  CONSTRAINT [FK8DED0743B77C69F9] FOREIGN KEY([ParentId])
REFERENCES [dbo].[Animal] ([Id])
GO
ALTER TABLE [dbo].[Animal] CHECK CONSTRAINT [FK8DED0743B77C69F9]
GO
/****** Object:  ForeignKey [FK8DED0743CE2F4A5D]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Animal]  WITH CHECK ADD  CONSTRAINT [FK8DED0743CE2F4A5D] FOREIGN KEY([father_id])
REFERENCES [dbo].[Animal] ([Id])
GO
ALTER TABLE [dbo].[Animal] CHECK CONSTRAINT [FK8DED0743CE2F4A5D]
GO
/****** Object:  ForeignKey [FK8DED0743F6A91370]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Animal]  WITH CHECK ADD  CONSTRAINT [FK8DED0743F6A91370] FOREIGN KEY([mother_id])
REFERENCES [dbo].[Animal] ([Id])
GO
ALTER TABLE [dbo].[Animal] CHECK CONSTRAINT [FK8DED0743F6A91370]
GO
/****** Object:  ForeignKey [FK983303232BA76857]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Cat]  WITH CHECK ADD  CONSTRAINT [FK983303232BA76857] FOREIGN KEY([Mammal])
REFERENCES [dbo].[Mammal] ([Animal])
GO
ALTER TABLE [dbo].[Cat] CHECK CONSTRAINT [FK983303232BA76857]
GO
/****** Object:  ForeignKey [FKAAA2AAA32BA76857]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Dog]  WITH CHECK ADD  CONSTRAINT [FKAAA2AAA32BA76857] FOREIGN KEY([Mammal])
REFERENCES [dbo].[Mammal] ([Animal])
GO
ALTER TABLE [dbo].[Dog] CHECK CONSTRAINT [FKAAA2AAA32BA76857]
GO
/****** Object:  ForeignKey [FKBF2D7FFDE7B80F7]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Employees]  WITH CHECK ADD  CONSTRAINT [FKBF2D7FFDE7B80F7] FOREIGN KEY([ReportsTo])
REFERENCES [dbo].[Employees] ([EmployeeId])
GO
ALTER TABLE [dbo].[Employees] CHECK CONSTRAINT [FKBF2D7FFDE7B80F7]
GO
/****** Object:  ForeignKey [FKF4419A39B229473A]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[EmployeeTerritories]  WITH CHECK ADD  CONSTRAINT [FKF4419A39B229473A] FOREIGN KEY([TerritoryId])
REFERENCES [dbo].[Territories] ([TerritoryId])
GO
ALTER TABLE [dbo].[EmployeeTerritories] CHECK CONSTRAINT [FKF4419A39B229473A]
GO
/****** Object:  ForeignKey [FKF4419A39BBA2339D]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[EmployeeTerritories]  WITH CHECK ADD  CONSTRAINT [FKF4419A39BBA2339D] FOREIGN KEY([EmployeeId])
REFERENCES [dbo].[Employees] ([EmployeeId])
GO
ALTER TABLE [dbo].[EmployeeTerritories] CHECK CONSTRAINT [FKF4419A39BBA2339D]
GO
/****** Object:  ForeignKey [FKD8DE3264EBBAEE33]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Lizard]  WITH CHECK ADD  CONSTRAINT [FKD8DE3264EBBAEE33] FOREIGN KEY([Reptile])
REFERENCES [dbo].[Reptile] ([Animal])
GO
ALTER TABLE [dbo].[Lizard] CHECK CONSTRAINT [FKD8DE3264EBBAEE33]
GO
/****** Object:  ForeignKey [FK180FD9F36676DC17]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Mammal]  WITH CHECK ADD  CONSTRAINT [FK180FD9F36676DC17] FOREIGN KEY([Animal])
REFERENCES [dbo].[Animal] ([Id])
GO
ALTER TABLE [dbo].[Mammal] CHECK CONSTRAINT [FK180FD9F36676DC17]
GO
/****** Object:  ForeignKey [FK9D532A8F25C466D]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[OrderLines]  WITH CHECK ADD  CONSTRAINT [FK9D532A8F25C466D] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Products] ([ProductId])
GO
ALTER TABLE [dbo].[OrderLines] CHECK CONSTRAINT [FK9D532A8F25C466D]
GO
/****** Object:  ForeignKey [FK9D532A8FD0FB5F15]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[OrderLines]  WITH CHECK ADD  CONSTRAINT [FK9D532A8FD0FB5F15] FOREIGN KEY([OrderId])
REFERENCES [dbo].[Orders] ([OrderId])
GO
ALTER TABLE [dbo].[OrderLines] CHECK CONSTRAINT [FK9D532A8FD0FB5F15]
GO
/****** Object:  ForeignKey [FK318A099B476D239C]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Orders]  WITH CHECK ADD  CONSTRAINT [FK318A099B476D239C] FOREIGN KEY([ShipVia])
REFERENCES [dbo].[Shippers] ([ShipperId])
GO
ALTER TABLE [dbo].[Orders] CHECK CONSTRAINT [FK318A099B476D239C]
GO
/****** Object:  ForeignKey [FK318A099B5D4A9938]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Orders]  WITH CHECK ADD  CONSTRAINT [FK318A099B5D4A9938] FOREIGN KEY([CustomerId])
REFERENCES [dbo].[Customers] ([CustomerId])
GO
ALTER TABLE [dbo].[Orders] CHECK CONSTRAINT [FK318A099B5D4A9938]
GO
/****** Object:  ForeignKey [FK318A099BBBA2339D]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Orders]  WITH CHECK ADD  CONSTRAINT [FK318A099BBBA2339D] FOREIGN KEY([EmployeeId])
REFERENCES [dbo].[Employees] ([EmployeeId])
GO
ALTER TABLE [dbo].[Orders] CHECK CONSTRAINT [FK318A099BBBA2339D]
GO
/****** Object:  ForeignKey [FK43582E961AB7AECE]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[PatientRecords]  WITH CHECK ADD  CONSTRAINT [FK43582E961AB7AECE] FOREIGN KEY([PatientId])
REFERENCES [dbo].[Patients] ([PatientId])
GO
ALTER TABLE [dbo].[PatientRecords] CHECK CONSTRAINT [FK43582E961AB7AECE]
GO
/****** Object:  ForeignKey [FK43582E96A06D1DCD]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[PatientRecords]  WITH CHECK ADD  CONSTRAINT [FK43582E96A06D1DCD] FOREIGN KEY([StateId])
REFERENCES [dbo].[States] ([StateId])
GO
ALTER TABLE [dbo].[PatientRecords] CHECK CONSTRAINT [FK43582E96A06D1DCD]
GO
/****** Object:  ForeignKey [FK668848599D524470]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Patients]  WITH CHECK ADD  CONSTRAINT [FK668848599D524470] FOREIGN KEY([PhysicianId])
REFERENCES [dbo].[Physicians] ([PhysicianId])
GO
ALTER TABLE [dbo].[Patients] CHECK CONSTRAINT [FK668848599D524470]
GO
/****** Object:  ForeignKey [FK4A7FD86A4A4379C2]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Products]  WITH CHECK ADD  CONSTRAINT [FK4A7FD86A4A4379C2] FOREIGN KEY([CategoryId])
REFERENCES [dbo].[Categories] ([CategoryId])
GO
ALTER TABLE [dbo].[Products] CHECK CONSTRAINT [FK4A7FD86A4A4379C2]
GO
/****** Object:  ForeignKey [FK4A7FD86A7E57CC2E]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Products]  WITH CHECK ADD  CONSTRAINT [FK4A7FD86A7E57CC2E] FOREIGN KEY([SupplierId])
REFERENCES [dbo].[Suppliers] ([SupplierId])
GO
ALTER TABLE [dbo].[Products] CHECK CONSTRAINT [FK4A7FD86A7E57CC2E]
GO
/****** Object:  ForeignKey [FK93D08BCA6676DC17]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Reptile]  WITH CHECK ADD  CONSTRAINT [FK93D08BCA6676DC17] FOREIGN KEY([Animal])
REFERENCES [dbo].[Animal] ([Id])
GO
ALTER TABLE [dbo].[Reptile] CHECK CONSTRAINT [FK93D08BCA6676DC17]
GO
/****** Object:  ForeignKey [FK1A2E670F36A436]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Roles]  WITH CHECK ADD  CONSTRAINT [FK1A2E670F36A436] FOREIGN KEY([EntityId])
REFERENCES [dbo].[AnotherEntity] ([Id])
GO
ALTER TABLE [dbo].[Roles] CHECK CONSTRAINT [FK1A2E670F36A436]
GO
/****** Object:  ForeignKey [FK_AnotherEntity_CompositeIdEntity] ******/
ALTER TABLE [dbo].[AnotherEntity]  WITH CHECK ADD  CONSTRAINT [FK_AnotherEntity_CompositeIdEntity] FOREIGN KEY([CompositeObjectId], [CompositeTenantId])
REFERENCES [dbo].[CompositeIdEntity] ([ObjectId], [TenantId])
GO
ALTER TABLE [dbo].[AnotherEntity] CHECK CONSTRAINT [FK_AnotherEntity_CompositeIdEntity]
GO
/****** Object:  ForeignKey [FK1A2E670F9E248253]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Roles]  WITH CHECK ADD  CONSTRAINT [FK1A2E670F9E248253] FOREIGN KEY([ParentId])
REFERENCES [dbo].[Roles] ([Id])
GO
ALTER TABLE [dbo].[Roles] CHECK CONSTRAINT [FK1A2E670F9E248253]
GO
/****** Object:  ForeignKey [FKE8C9AC0917D79B7C]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Territories]  WITH CHECK ADD  CONSTRAINT [FKE8C9AC0917D79B7C] FOREIGN KEY([RegionId])
REFERENCES [dbo].[Region] ([RegionId])
GO
ALTER TABLE [dbo].[Territories] CHECK CONSTRAINT [FKE8C9AC0917D79B7C]
GO
/****** Object:  ForeignKey [FK7E222050C7D0B317]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[TimesheetEntries]  WITH CHECK ADD  CONSTRAINT [FK7E222050C7D0B317] FOREIGN KEY([TimesheetID])
REFERENCES [dbo].[Timesheets] ([TimesheetId])
GO
ALTER TABLE [dbo].[TimesheetEntries] CHECK CONSTRAINT [FK7E222050C7D0B317]
GO
/****** Object:  ForeignKey [FKA6EEF73795E61DFF]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[TimeSheetUsers]  WITH CHECK ADD  CONSTRAINT [FKA6EEF73795E61DFF] FOREIGN KEY([UserId])
REFERENCES [dbo].[Users] ([UserId])
GO
ALTER TABLE [dbo].[TimeSheetUsers] CHECK CONSTRAINT [FKA6EEF73795E61DFF]
GO
/****** Object:  ForeignKey [FKA6EEF737C7D0B317]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[TimeSheetUsers]  WITH CHECK ADD  CONSTRAINT [FKA6EEF737C7D0B317] FOREIGN KEY([TimesheetID])
REFERENCES [dbo].[Timesheets] ([TimesheetId])
GO
ALTER TABLE [dbo].[TimeSheetUsers] CHECK CONSTRAINT [FKA6EEF737C7D0B317]
GO
/****** Object:  ForeignKey [FK2C1C7FE5D8C957C7]    Script Date: 06/17/2010 13:08:54 ******/
ALTER TABLE [dbo].[Users]  WITH CHECK ADD  CONSTRAINT [FK2C1C7FE5D8C957C7] FOREIGN KEY([RoleId])
REFERENCES [dbo].[Roles] ([Id])
GO
ALTER TABLE [dbo].[Users] CHECK CONSTRAINT [FK2C1C7FE5D8C957C7]
GO
