/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @generated SignedSource<<3bbbf27ae54f7b245d6adad352761339>>
 * generated by gentest/gentest-driver.ts from gentest/fixtures/YGStaticPositionTest.html
 */

package org.lwjgl.util.yoga;

import org.testng.annotations.*;

import static org.lwjgl.util.yoga.YogaNode.*;
import static org.testng.AssertJUnit.assertEquals;

public class YGStaticPositionTest {
    @Test
    public void test_static_position_insets_have_no_effect_left_top() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setPositionType(YogaPositionType.STATIC);
        root_child0.setPosition(YogaEdge.LEFT, 50f);
        root_child0.setPosition(YogaEdge.TOP, 50f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_insets_have_no_effect_right_bottom() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setPositionType(YogaPositionType.STATIC);
        root_child0.setPosition(YogaEdge.RIGHT, 50f);
        root_child0.setPosition(YogaEdge.BOTTOM, 50f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_insets_relative_to_positioned_ancestor() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 100f);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.LEFT, 50f);
        root_child0_child0_child0.setPosition(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_insets_relative_to_positioned_ancestor_row_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.LEFT, 50f);
        root_child0_child0_child0.setPosition(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_reverse_static_position_absolute_child_insets_relative_to_positioned_ancestor_row_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.LEFT, 50f);
        root_child0_child0_child0.setPosition(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_insets_relative_to_positioned_ancestor_row() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setPosition(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_reverse_static_position_absolute_child_insets_relative_to_positioned_ancestor_row() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setPosition(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_insets_relative_to_positioned_ancestor_column_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setPosition(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_reverse_static_position_absolute_child_insets_relative_to_positioned_ancestor_column_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setPosition(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_insets_relative_to_positioned_ancestor_deep() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 100f);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 100f);
        root_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0.setHeight(100f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 100f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(100f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 100f);
        root_child0_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0_child0.setHeight(100f);
        root_child0_child0_child0_child0.addChildAt(root_child0_child0_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0_child0_child0_child0.setPosition(YogaEdge.LEFT, 50f);
        root_child0_child0_child0_child0_child0_child0.setPosition(YogaEdge.TOP, 50f);
        root_child0_child0_child0_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0_child0_child0.addChildAt(root_child0_child0_child0_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-350f, root_child0_child0_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-50f, root_child0_child0_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_width_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setWidthPercent(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_width_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setWidthPercent(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_width_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setWidthPercent(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_height_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeightPercent(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_height_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeightPercent(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_height_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeightPercent(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_left_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPositionPercent(YogaEdge.LEFT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_left_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionPercent(YogaEdge.LEFT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_left_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setPositionPercent(YogaEdge.LEFT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_right_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPositionPercent(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_right_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionPercent(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_right_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setPositionPercent(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_top_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPositionPercent(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_top_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionPercent(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_top_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setPositionPercent(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_bottom_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPositionPercent(YogaEdge.BOTTOM, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_bottom_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionPercent(YogaEdge.BOTTOM, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_bottom_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setPositionPercent(YogaEdge.BOTTOM, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_margin_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMarginPercent(YogaEdge.LEFT, 50f);
        root_child0_child0_child0.setMarginPercent(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setMarginPercent(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setMarginPercent(YogaEdge.BOTTOM, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_margin_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setMarginPercent(YogaEdge.LEFT, 50f);
        root_child0_child0_child0.setMarginPercent(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setMarginPercent(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setMarginPercent(YogaEdge.BOTTOM, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_margin_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setMarginPercent(YogaEdge.LEFT, 50f);
        root_child0_child0_child0.setMarginPercent(YogaEdge.TOP, 50f);
        root_child0_child0_child0.setMarginPercent(YogaEdge.RIGHT, 50f);
        root_child0_child0_child0.setMarginPercent(YogaEdge.BOTTOM, 50f);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_padding_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.LEFT, 50);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.TOP, 50);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.RIGHT, 50);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.BOTTOM, 50);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_padding_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.LEFT, 50);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.TOP, 50);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.RIGHT, 50);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.BOTTOM, 50);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_padding_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.LEFT, 50);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.TOP, 50);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.RIGHT, 50);
        root_child0_child0_child0.setPaddingPercent(YogaEdge.BOTTOM, 50);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_border_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_border_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_border_percentage() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(200f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setWidth(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(200f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_containing_block_padding_box() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setPadding(YogaEdge.LEFT, 100);
        root_child0.setPadding(YogaEdge.TOP, 100);
        root_child0.setPadding(YogaEdge.RIGHT, 100);
        root_child0.setPadding(YogaEdge.BOTTOM, 100);
        root_child0.setWidth(400f);
        root_child0.setHeight(400f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setWidthPercent(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(200f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_containing_block_padding_box() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setPadding(YogaEdge.LEFT, 100);
        root_child0.setPadding(YogaEdge.TOP, 100);
        root_child0.setPadding(YogaEdge.RIGHT, 100);
        root_child0.setPadding(YogaEdge.BOTTOM, 100);
        root_child0.setWidth(400f);
        root_child0.setHeight(400f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setWidthPercent(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(200f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_containing_block_padding_box() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setPadding(YogaEdge.LEFT, 100);
        root_child0.setPadding(YogaEdge.TOP, 100);
        root_child0.setPadding(YogaEdge.RIGHT, 100);
        root_child0.setPadding(YogaEdge.BOTTOM, 100);
        root_child0.setWidth(400f);
        root_child0.setHeight(400f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0_child0.setWidthPercent(50f);
        root_child0_child0_child0.setHeight(50f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(200f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_absolute_child_containing_block_content_box() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setPadding(YogaEdge.LEFT, 100);
        root_child0.setPadding(YogaEdge.TOP, 100);
        root_child0.setPadding(YogaEdge.RIGHT, 100);
        root_child0.setPadding(YogaEdge.BOTTOM, 100);
        root_child0.setWidth(400f);
        root_child0.setHeight(400f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setWidthPercent(50f);
        root_child0_child0.setHeight(50f);
        root_child0.addChildAt(root_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_relative_child_containing_block_content_box() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setPadding(YogaEdge.LEFT, 100);
        root_child0.setPadding(YogaEdge.TOP, 100);
        root_child0.setPadding(YogaEdge.RIGHT, 100);
        root_child0.setPadding(YogaEdge.BOTTOM, 100);
        root_child0.setWidth(400f);
        root_child0.setHeight(400f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(50f);
        root_child0_child0.setHeight(50f);
        root_child0.addChildAt(root_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(200f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_child_containing_block_content_box() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setPadding(YogaEdge.LEFT, 100);
        root_child0.setPadding(YogaEdge.TOP, 100);
        root_child0.setPadding(YogaEdge.RIGHT, 100);
        root_child0.setPadding(YogaEdge.BOTTOM, 100);
        root_child0.setWidth(400f);
        root_child0.setHeight(400f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidthPercent(50f);
        root_child0_child0.setHeight(50f);
        root_child0.addChildAt(root_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(200f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_containing_block_padding_and_border() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setPadding(YogaEdge.LEFT, 9);
        root_child0.setPadding(YogaEdge.TOP, 8);
        root_child0.setPadding(YogaEdge.RIGHT, 1);
        root_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0.setBorder(YogaEdge.TOP, 5f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 4f);
        root_child0.setWidth(400f);
        root_child0.setHeight(400f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setWidth(100f);
        root_child0_child0.setHeight(100f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setWidthPercent(41f);
        root_child0_child0_child0.setHeightPercent(61f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(11f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(13f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(239f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(400f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(292f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(13f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-60f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(239f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root_child0.setWidth(500f);
        root_child0.setHeight(500f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0_child0.setWidth(200f);
        root_child0_child0.setHeight(200f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setPosition(YogaEdge.RIGHT, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(41f);
        root_child0_child0_child0.setHeightPercent(63f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(1f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(279f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-2f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_no_position_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root_child0.setWidth(500f);
        root_child0.setHeight(500f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0_child0.setWidth(200f);
        root_child0_child0.setHeight(200f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(41f);
        root_child0_child0_child0.setHeightPercent(63f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(279f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-15f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_zero_for_inset_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root_child0.setWidth(500f);
        root_child0.setHeight(500f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0_child0.setWidth(200f);
        root_child0_child0.setHeight(200f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPositionPercent(YogaEdge.LEFT, 0f);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(41f);
        root_child0_child0_child0.setHeightPercent(63f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-1f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(279f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-265f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_start_inset_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root_child0.setWidth(500f);
        root_child0.setHeight(500f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0_child0.setWidth(200f);
        root_child0_child0.setHeight(200f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.START, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(41f);
        root_child0_child0_child0.setHeightPercent(63f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(11f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(279f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-2f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_end_inset_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root_child0.setWidth(500f);
        root_child0.setHeight(500f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0_child0.setWidth(200f);
        root_child0_child0.setHeight(200f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.END, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(41f);
        root_child0_child0_child0.setHeightPercent(63f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(270f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(513f, root.getLayoutWidth(), 0.0f);
        assertEquals(506f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(500f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(279f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-261f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(306f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_row_reverse_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setHeightPercent(12f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(69f, root.getLayoutWidth(), 0.0f);
        assertEquals(79f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(56f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(73f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(22f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-128f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(133f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(23f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(69f, root.getLayoutWidth(), 0.0f);
        assertEquals(79f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(56f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(73f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(22f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(133f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(23f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_column_reverse_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(21f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(69f, root.getLayoutWidth(), 0.0f);
        assertEquals(79f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(56f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(73f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(22f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-82f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(69f, root.getLayoutWidth(), 0.0f);
        assertEquals(79f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(56f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(73f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(22f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-15f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-82f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_justify_flex_start_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(21f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);

        YogaNode root_child0_child0_child1 = createNode(config);
        root_child0_child0_child1.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child1, 1);

        YogaNode root_child0_child0_child1_child0 = createNode(config);
        root_child0_child0_child1_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1_child0.setWidth(100f);
        root_child0_child0_child1_child0.setHeight(50f);
        root_child0_child0_child1.addChildAt(root_child0_child0_child1_child0, 0);

        YogaNode root_child0_child0_child2 = createNode(config);
        root_child0_child0_child2.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child2, 2);

        YogaNode root_child0_child0_child2_child0 = createNode(config);
        root_child0_child0_child2_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2_child0.setWidth(100f);
        root_child0_child0_child2_child0.setHeight(50f);
        root_child0_child0_child2.addChildAt(root_child0_child0_child2_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(111f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-77f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_justify_flex_start_position_set_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPosition(YogaEdge.RIGHT, 30f);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(21f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);

        YogaNode root_child0_child0_child1 = createNode(config);
        root_child0_child0_child1.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child1, 1);

        YogaNode root_child0_child0_child1_child0 = createNode(config);
        root_child0_child0_child1_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1_child0.setWidth(100f);
        root_child0_child0_child1_child0.setHeight(50f);
        root_child0_child0_child1.addChildAt(root_child0_child0_child1_child0, 0);

        YogaNode root_child0_child0_child2 = createNode(config);
        root_child0_child0_child2.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child2, 2);

        YogaNode root_child0_child0_child2_child0 = createNode(config);
        root_child0_child0_child2_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2_child0.setWidth(100f);
        root_child0_child0_child2_child0.setHeight(50f);
        root_child0_child0_child2.addChildAt(root_child0_child0_child2_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(106f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(106f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-77f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_no_definite_size_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPositionPercent(YogaEdge.LEFT, 23f);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(69f, root.getLayoutWidth(), 0.0f);
        assertEquals(79f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(56f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(73f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(22f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(9f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(133f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(69f, root.getLayoutWidth(), 0.0f);
        assertEquals(79f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(56f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(73f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(22f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(9f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(133f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_both_insets_set_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setPositionPercent(YogaEdge.LEFT, 23f);
        root_child0_child0_child0.setPosition(YogaEdge.RIGHT, 13f);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(69f, root.getLayoutWidth(), 0.0f);
        assertEquals(79f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(56f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(73f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(22f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(9f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(69f, root.getLayoutWidth(), 0.0f);
        assertEquals(79f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(56f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(73f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(22f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-3f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_justify_center_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(21f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);

        YogaNode root_child0_child0_child1 = createNode(config);
        root_child0_child0_child1.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child1, 1);

        YogaNode root_child0_child0_child1_child0 = createNode(config);
        root_child0_child0_child1_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1_child0.setWidth(100f);
        root_child0_child0_child1_child0.setHeight(50f);
        root_child0_child0_child1.addChildAt(root_child0_child0_child1_child0, 0);

        YogaNode root_child0_child0_child2 = createNode(config);
        root_child0_child0_child2.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child2, 2);

        YogaNode root_child0_child0_child2_child0 = createNode(config);
        root_child0_child0_child2_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2_child0.setWidth(100f);
        root_child0_child0_child2_child0.setHeight(50f);
        root_child0_child0_child2.addChildAt(root_child0_child0_child2_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(85f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(111f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(85f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-77f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_justify_flex_end_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setJustifyContent(YogaJustify.FLEX_END);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(21f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);

        YogaNode root_child0_child0_child1 = createNode(config);
        root_child0_child0_child1.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child1, 1);

        YogaNode root_child0_child0_child1_child0 = createNode(config);
        root_child0_child0_child1_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1_child0.setWidth(100f);
        root_child0_child0_child1_child0.setHeight(50f);
        root_child0_child0_child1.addChildAt(root_child0_child0_child1_child0, 0);

        YogaNode root_child0_child0_child2 = createNode(config);
        root_child0_child0_child2.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child2, 2);

        YogaNode root_child0_child0_child2_child0 = createNode(config);
        root_child0_child0_child2_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2_child0.setWidth(100f);
        root_child0_child0_child2_child0.setHeight(50f);
        root_child0_child0_child2.addChildAt(root_child0_child0_child2_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(111f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-77f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_align_flex_start_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setAlignItems(YogaAlign.FLEX_START);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(21f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);

        YogaNode root_child0_child0_child1 = createNode(config);
        root_child0_child0_child1.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child1, 1);

        YogaNode root_child0_child0_child1_child0 = createNode(config);
        root_child0_child0_child1_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1_child0.setWidth(100f);
        root_child0_child0_child1_child0.setHeight(50f);
        root_child0_child0_child1.addChildAt(root_child0_child0_child1_child0, 0);

        YogaNode root_child0_child0_child2 = createNode(config);
        root_child0_child0_child2.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child2, 2);

        YogaNode root_child0_child0_child2_child0 = createNode(config);
        root_child0_child0_child2_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2_child0.setWidth(100f);
        root_child0_child0_child2_child0.setHeight(50f);
        root_child0_child0_child2.addChildAt(root_child0_child0_child2_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(111f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-77f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_align_center_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setAlignItems(YogaAlign.CENTER);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(21f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);

        YogaNode root_child0_child0_child1 = createNode(config);
        root_child0_child0_child1.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child1, 1);

        YogaNode root_child0_child0_child1_child0 = createNode(config);
        root_child0_child0_child1_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1_child0.setWidth(100f);
        root_child0_child0_child1_child0.setHeight(50f);
        root_child0_child0_child1.addChildAt(root_child0_child0_child1_child0, 0);

        YogaNode root_child0_child0_child2 = createNode(config);
        root_child0_child0_child2.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child2, 2);

        YogaNode root_child0_child0_child2_child0 = createNode(config);
        root_child0_child0_child2_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2_child0.setWidth(100f);
        root_child0_child0_child2_child0.setHeight(50f);
        root_child0_child0_child2.addChildAt(root_child0_child0_child2_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(65f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(39f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(75f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(75f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(65f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(39f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-77f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(75f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(75f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_align_flex_end_amalgamation() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.LEFT, 4f);
        root_child0.setMargin(YogaEdge.TOP, 5f);
        root_child0.setMargin(YogaEdge.RIGHT, 9f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 2);
        root_child0.setPadding(YogaEdge.TOP, 9);
        root_child0.setPadding(YogaEdge.RIGHT, 11);
        root_child0.setPadding(YogaEdge.BOTTOM, 13);
        root_child0.setBorder(YogaEdge.LEFT, 5f);
        root_child0.setBorder(YogaEdge.TOP, 6f);
        root_child0.setBorder(YogaEdge.RIGHT, 7f);
        root_child0.setBorder(YogaEdge.BOTTOM, 8f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setAlignItems(YogaAlign.FLEX_END);
        root_child0_child0.setPositionType(YogaPositionType.STATIC);
        root_child0_child0.setMargin(YogaEdge.LEFT, 8f);
        root_child0_child0.setMargin(YogaEdge.TOP, 6f);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 3f);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 9f);
        root_child0_child0.setPadding(YogaEdge.LEFT, 1);
        root_child0_child0.setPadding(YogaEdge.TOP, 7);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 9);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0_child0.setBorder(YogaEdge.LEFT, 8f);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0.setWidthPercent(21f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);

        YogaNode root_child0_child0_child0_child0 = createNode(config);
        root_child0_child0_child0_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child0_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child0_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child0_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child0_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child0_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child0_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child0_child0.setWidth(100f);
        root_child0_child0_child0_child0.setHeight(50f);
        root_child0_child0_child0.addChildAt(root_child0_child0_child0_child0, 0);

        YogaNode root_child0_child0_child1 = createNode(config);
        root_child0_child0_child1.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child1, 1);

        YogaNode root_child0_child0_child1_child0 = createNode(config);
        root_child0_child0_child1_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child1_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child1_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child1_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child1_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child1_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child1_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child1_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child1_child0.setWidth(100f);
        root_child0_child0_child1_child0.setHeight(50f);
        root_child0_child0_child1.addChildAt(root_child0_child0_child1_child0, 0);

        YogaNode root_child0_child0_child2 = createNode(config);
        root_child0_child0_child2.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2.setWidthPercent(10f);
        root_child0_child0.addChildAt(root_child0_child0_child2, 2);

        YogaNode root_child0_child0_child2_child0 = createNode(config);
        root_child0_child0_child2_child0.setMargin(YogaEdge.LEFT, 9f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.TOP, 12f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.RIGHT, 4f);
        root_child0_child0_child2_child0.setMargin(YogaEdge.BOTTOM, 7f);
        root_child0_child0_child2_child0.setPadding(YogaEdge.LEFT, 5);
        root_child0_child0_child2_child0.setPadding(YogaEdge.TOP, 3);
        root_child0_child0_child2_child0.setPadding(YogaEdge.RIGHT, 8);
        root_child0_child0_child2_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0_child2_child0.setBorder(YogaEdge.LEFT, 2f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.TOP, 1f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.RIGHT, 5f);
        root_child0_child0_child2_child0.setBorder(YogaEdge.BOTTOM, 9f);
        root_child0_child0_child2_child0.setWidth(100f);
        root_child0_child0_child2_child0.setHeight(50f);
        root_child0_child0_child2.addChildAt(root_child0_child0_child2_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(111f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(131f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(16f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(215f, root.getLayoutWidth(), 0.0f);
        assertEquals(301f, root.getLayoutHeight(), 0.0f);

        assertEquals(4f, root_child0.getLayoutX(), 0.0f);
        assertEquals(5f, root_child0.getLayoutY(), 0.0f);
        assertEquals(202f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(295f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(21f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(166f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(244f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(40f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(-77f, root_child0_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child1.getLayoutX(), 0.0f);
        assertEquals(29f, root_child0_child0_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child1_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child1_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0_child0_child2.getLayoutX(), 0.0f);
        assertEquals(140f, root_child0_child0_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(92f, root_child0_child0_child2.getLayoutHeight(), 0.0f);

        assertEquals(-97f, root_child0_child0_child2_child0.getLayoutX(), 0.0f);
        assertEquals(16f, root_child0_child0_child2_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0_child0_child2_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0_child2_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_static_position_static_root() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.STATIC);
        root.setPadding(YogaEdge.LEFT, 6);
        root.setPadding(YogaEdge.TOP, 1);
        root.setPadding(YogaEdge.RIGHT, 11);
        root.setPadding(YogaEdge.BOTTOM, 4);
        root.setWidth(100f);
        root.setHeight(200f);

        YogaNode root_child0 = createNode(config);
        root_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0.setMargin(YogaEdge.LEFT, 12f);
        root_child0.setMargin(YogaEdge.TOP, 11f);
        root_child0.setMargin(YogaEdge.RIGHT, 15f);
        root_child0.setMargin(YogaEdge.BOTTOM, 1f);
        root_child0.setPadding(YogaEdge.LEFT, 3);
        root_child0.setPadding(YogaEdge.TOP, 7);
        root_child0.setPadding(YogaEdge.RIGHT, 5);
        root_child0.setPadding(YogaEdge.BOTTOM, 4);
        root_child0.setBorder(YogaEdge.LEFT, 4f);
        root_child0.setBorder(YogaEdge.TOP, 3f);
        root_child0.setBorder(YogaEdge.RIGHT, 2f);
        root_child0.setBorder(YogaEdge.BOTTOM, 1f);
        root_child0.setWidthPercent(50f);
        root_child0.setHeightPercent(50f);
        root.addChildAt(root_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(18f, root_child0.getLayoutX(), 0.0f);
        assertEquals(12f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(24f, root_child0.getLayoutX(), 0.0f);
        assertEquals(12f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);
    }
}
