/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @generated SignedSource<<88d2dd510790179efc539f8d3cba00bb>>
 * generated by gentest/gentest-driver.ts from gentest/fixtures/YGJustifyContentTest.html
 */

package org.lwjgl.util.yoga;

import org.testng.annotations.*;

import static org.lwjgl.util.yoga.YogaNode.*;
import static org.testng.AssertJUnit.assertEquals;

public class YGJustifyContentTest {
    @Test
    public void test_justify_content_row_flex_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(92f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(82f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(72f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_row_flex_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.FLEX_END);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(72f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(82f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(92f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_row_center() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(36f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(46f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(56f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(56f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(46f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(36f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_row_space_between() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.SPACE_BETWEEN);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(46f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(92f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(92f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(46f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_row_space_around() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.SPACE_AROUND);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(12f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(46f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(46f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(12f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(102f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_column_flex_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_column_flex_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setJustifyContent(YogaJustify.FLEX_END);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(72f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(82f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(92f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(72f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(82f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(92f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_column_center() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setJustifyContent(YogaJustify.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(36f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(46f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(56f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(36f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(46f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(56f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_column_space_between() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setJustifyContent(YogaJustify.SPACE_BETWEEN);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(46f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(92f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(46f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(92f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_column_space_around() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setJustifyContent(YogaJustify.SPACE_AROUND);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(12f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(46f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(80f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(12f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(46f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(80f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_row_min_width_and_margin() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.LEFT, 100f);
        root.setMinWidth(50f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(100f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(50f, root.getLayoutWidth(), 0.0f);
        assertEquals(20f, root.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(100f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(50f, root.getLayoutWidth(), 0.0f);
        assertEquals(20f, root.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_row_max_width_and_margin() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.LEFT, 100f);
        root.setWidth(100f);
        root.setMaxWidth(80f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(100f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(20f, root.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(100f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(20f, root.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_column_min_height_and_margin() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setJustifyContent(YogaJustify.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.TOP, 100f);
        root.setMinHeight(50f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(100f, root.getLayoutY(), 0.0f);
        assertEquals(20f, root.getLayoutWidth(), 0.0f);
        assertEquals(50f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(15f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(100f, root.getLayoutY(), 0.0f);
        assertEquals(20f, root.getLayoutWidth(), 0.0f);
        assertEquals(50f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(15f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_colunn_max_height_and_margin() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setJustifyContent(YogaJustify.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.TOP, 100f);
        root.setHeight(100f);
        root.setMaxHeight(80f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(100f, root.getLayoutY(), 0.0f);
        assertEquals(20f, root.getLayoutWidth(), 0.0f);
        assertEquals(80f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(100f, root.getLayoutY(), 0.0f);
        assertEquals(20f, root.getLayoutWidth(), 0.0f);
        assertEquals(80f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_column_space_evenly() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setJustifyContent(YogaJustify.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(18f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(46f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(74f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(18f, root_child0.getLayoutY(), 0.0f);
        assertEquals(102f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(46f, root_child1.getLayoutY(), 0.0f);
        assertEquals(102f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(74f, root_child2.getLayoutY(), 0.0f);
        assertEquals(102f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_row_space_evenly() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(102f);
        root.setHeight(102f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(26f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(0f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(51f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(0f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(77f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(0f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(102f, root.getLayoutWidth(), 0.0f);
        assertEquals(102f, root.getLayoutHeight(), 0.0f);

        assertEquals(77f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(0f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(51f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(0f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(26f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(0f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_min_width_with_padding_child_width_greater_than_parent() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(1000f);
        root.setHeight(1584f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setAlignContent(YogaAlign.STRETCH);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0_child0.setAlignContent(YogaAlign.STRETCH);
        root_child0_child0.setPadding(YogaEdge.LEFT, 100);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 100);
        root_child0_child0.setMinWidth(400f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0_child0_child0.setAlignContent(YogaAlign.STRETCH);
        root_child0_child0_child0.setWidth(300f);
        root_child0_child0_child0.setHeight(100f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(1000f, root.getLayoutWidth(), 0.0f);
        assertEquals(1584f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(1000f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(300f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(1000f, root.getLayoutWidth(), 0.0f);
        assertEquals(1584f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(1000f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(500f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(500f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(300f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_min_width_with_padding_child_width_lower_than_parent() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(1080f);
        root.setHeight(1584f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setAlignContent(YogaAlign.STRETCH);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0_child0.setAlignContent(YogaAlign.STRETCH);
        root_child0_child0.setPadding(YogaEdge.LEFT, 100);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 100);
        root_child0_child0.setMinWidth(400f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child0_child0 = createNode(config);
        root_child0_child0_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0_child0_child0.setAlignContent(YogaAlign.STRETCH);
        root_child0_child0_child0.setWidth(199f);
        root_child0_child0_child0.setHeight(100f);
        root_child0_child0.addChildAt(root_child0_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(1080f, root.getLayoutWidth(), 0.0f);
        assertEquals(1584f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(1080f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(101f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(199f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(1080f, root.getLayoutWidth(), 0.0f);
        assertEquals(1584f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(1080f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(680f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(101f, root_child0_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0_child0.getLayoutY(), 0.0f);
        assertEquals(199f, root_child0_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_space_between_indefinite_container_dim_with_free_space() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setAlignItems(YogaAlign.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(300f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.SPACE_BETWEEN);
        root_child0.setMinWidth(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidth(50f);
        root_child0_child0.setHeight(50f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(50f);
        root_child0_child1.setHeight(50f);
        root_child0.addChildAt(root_child0_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(50f, root.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(150f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(50f, root.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(150f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_flex_start_row_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_justify_content_flex_end_row_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }
}
