/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @generated SignedSource<<f45f69191b808fe39b56a1473be47963>>
 * generated by gentest/gentest-driver.ts from gentest/fixtures/YGGapTest.html
 */

package org.lwjgl.util.yoga;

import org.testng.annotations.*;

import static org.lwjgl.util.yoga.YogaNode.*;
import static org.testng.AssertJUnit.assertEquals;

public class YGGapTest {
    @Test
    public void test_column_gap_flexible() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(80f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexGrow(1f);
        root_child0.setFlexShrink(1f);
        root_child0.setFlexBasisPercent(0f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root_child1.setFlexBasisPercent(0f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setFlexGrow(1f);
        root_child2.setFlexShrink(1f);
        root_child2.setFlexBasisPercent(0f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_inflexible() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(80f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_mixed_flexible() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(80f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root_child1.setFlexBasisPercent(0f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_child_margins() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(80f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexGrow(1f);
        root_child0.setFlexShrink(1f);
        root_child0.setFlexBasisPercent(0f);
        root_child0.setMargin(YogaEdge.LEFT, 2f);
        root_child0.setMargin(YogaEdge.RIGHT, 2f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root_child1.setFlexBasisPercent(0f);
        root_child1.setMargin(YogaEdge.LEFT, 10f);
        root_child1.setMargin(YogaEdge.RIGHT, 10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setFlexGrow(1f);
        root_child2.setFlexShrink(1f);
        root_child2.setFlexBasisPercent(0f);
        root_child2.setMargin(YogaEdge.LEFT, 15f);
        root_child2.setMargin(YogaEdge.RIGHT, 15f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(2f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(2f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(26f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(2f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(63f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(2f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(76f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(2f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(52f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(2f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(15f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(2f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_row_gap_wrapping() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(80f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root_child1.setHeight(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root_child2.setHeight(20f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(20f);
        root_child3.setHeight(20f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(20f);
        root_child4.setHeight(20f);
        root.addChildAt(root_child4, 4);

        YogaNode root_child5 = createNode(config);
        root_child5.setWidth(20f);
        root_child5.setHeight(20f);
        root.addChildAt(root_child5, 5);

        YogaNode root_child6 = createNode(config);
        root_child6.setWidth(20f);
        root_child6.setHeight(20f);
        root.addChildAt(root_child6, 6);

        YogaNode root_child7 = createNode(config);
        root_child7.setWidth(20f);
        root_child7.setHeight(20f);
        root.addChildAt(root_child7, 7);

        YogaNode root_child8 = createNode(config);
        root_child8.setWidth(20f);
        root_child8.setHeight(20f);
        root.addChildAt(root_child8, 8);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(40f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child4.getLayoutX(), 0.0f);
        assertEquals(40f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child5.getLayoutX(), 0.0f);
        assertEquals(40f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child6.getLayoutX(), 0.0f);
        assertEquals(80f, root_child6.getLayoutY(), 0.0f);
        assertEquals(20f, root_child6.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child6.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child7.getLayoutX(), 0.0f);
        assertEquals(80f, root_child7.getLayoutY(), 0.0f);
        assertEquals(20f, root_child7.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child7.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child8.getLayoutX(), 0.0f);
        assertEquals(80f, root_child8.getLayoutY(), 0.0f);
        assertEquals(20f, root_child8.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child8.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child3.getLayoutX(), 0.0f);
        assertEquals(40f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child4.getLayoutX(), 0.0f);
        assertEquals(40f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child5.getLayoutX(), 0.0f);
        assertEquals(40f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child6.getLayoutX(), 0.0f);
        assertEquals(80f, root_child6.getLayoutY(), 0.0f);
        assertEquals(20f, root_child6.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child6.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child7.getLayoutX(), 0.0f);
        assertEquals(80f, root_child7.getLayoutY(), 0.0f);
        assertEquals(20f, root_child7.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child7.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child8.getLayoutX(), 0.0f);
        assertEquals(80f, root_child8.getLayoutY(), 0.0f);
        assertEquals(20f, root_child8.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child8.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_start_index() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(80f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root_child1.setHeight(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root_child2.setHeight(20f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(20f);
        root_child3.setHeight(20f);
        root.addChildAt(root_child3, 3);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(20f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(20f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_justify_flex_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_justify_center() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_justify_flex_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.FLEX_END);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_justify_space_between() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.SPACE_BETWEEN);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_justify_space_around() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.SPACE_AROUND);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(3f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(77f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(77f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(3f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_justify_space_evenly() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setJustifyContent(YogaJustify.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(5f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(75f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(75f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(5f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_wrap_align_flex_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root_child1.setHeight(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root_child2.setHeight(20f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(20f);
        root_child3.setHeight(20f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(20f);
        root_child4.setHeight(20f);
        root.addChildAt(root_child4, 4);

        YogaNode root_child5 = createNode(config);
        root_child5.setWidth(20f);
        root_child5.setHeight(20f);
        root.addChildAt(root_child5, 5);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(40f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child4.getLayoutX(), 0.0f);
        assertEquals(40f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child5.getLayoutX(), 0.0f);
        assertEquals(40f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child3.getLayoutX(), 0.0f);
        assertEquals(40f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(40f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child5.getLayoutX(), 0.0f);
        assertEquals(40f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_wrap_align_center() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root_child1.setHeight(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root_child2.setHeight(20f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(20f);
        root_child3.setHeight(20f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(20f);
        root_child4.setHeight(20f);
        root.addChildAt(root_child4, 4);

        YogaNode root_child5 = createNode(config);
        root_child5.setWidth(20f);
        root_child5.setHeight(20f);
        root.addChildAt(root_child5, 5);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(60f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child4.getLayoutX(), 0.0f);
        assertEquals(60f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child5.getLayoutX(), 0.0f);
        assertEquals(60f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child3.getLayoutX(), 0.0f);
        assertEquals(60f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(60f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child5.getLayoutX(), 0.0f);
        assertEquals(60f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_wrap_align_flex_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.FLEX_END);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root_child1.setHeight(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root_child2.setHeight(20f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(20f);
        root_child3.setHeight(20f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(20f);
        root_child4.setHeight(20f);
        root.addChildAt(root_child4, 4);

        YogaNode root_child5 = createNode(config);
        root_child5.setWidth(20f);
        root_child5.setHeight(20f);
        root.addChildAt(root_child5, 5);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(40f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(80f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child4.getLayoutX(), 0.0f);
        assertEquals(80f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child5.getLayoutX(), 0.0f);
        assertEquals(80f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(40f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child3.getLayoutX(), 0.0f);
        assertEquals(80f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(80f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child5.getLayoutX(), 0.0f);
        assertEquals(80f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_wrap_align_space_between() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_BETWEEN);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root_child1.setHeight(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root_child2.setHeight(20f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(20f);
        root_child3.setHeight(20f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(20f);
        root_child4.setHeight(20f);
        root.addChildAt(root_child4, 4);

        YogaNode root_child5 = createNode(config);
        root_child5.setWidth(20f);
        root_child5.setHeight(20f);
        root.addChildAt(root_child5, 5);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(80f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child4.getLayoutX(), 0.0f);
        assertEquals(80f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child5.getLayoutX(), 0.0f);
        assertEquals(80f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child3.getLayoutX(), 0.0f);
        assertEquals(80f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(80f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child5.getLayoutX(), 0.0f);
        assertEquals(80f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_wrap_align_space_around() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_AROUND);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root_child0.setHeight(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root_child1.setHeight(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root_child2.setHeight(20f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(20f);
        root_child3.setHeight(20f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(20f);
        root_child4.setHeight(20f);
        root.addChildAt(root_child4, 4);

        YogaNode root_child5 = createNode(config);
        root_child5.setWidth(20f);
        root_child5.setHeight(20f);
        root.addChildAt(root_child5, 5);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(10f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(10f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(70f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child4.getLayoutX(), 0.0f);
        assertEquals(70f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child5.getLayoutX(), 0.0f);
        assertEquals(70f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(10f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(10f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child3.getLayoutX(), 0.0f);
        assertEquals(70f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(70f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child5.getLayoutX(), 0.0f);
        assertEquals(70f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child5.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_wrap_align_stretch() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(300f);
        root.setHeight(300f);
        root.setGap(YogaGutter.COLUMN, 5f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexGrow(1f);
        root_child0.setMinWidth(60f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexGrow(1f);
        root_child1.setMinWidth(60f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setFlexGrow(1f);
        root_child2.setMinWidth(60f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setFlexGrow(1f);
        root_child3.setMinWidth(60f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setFlexGrow(1f);
        root_child4.setMinWidth(60f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(71f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(76f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(72f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(153f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(71f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(229f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(71f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(150f, root_child4.getLayoutY(), 0.0f);
        assertEquals(300f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(229f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(71f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(153f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(71f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(76f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(72f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(71f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(150f, root_child4.getLayoutY(), 0.0f);
        assertEquals(300f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(150f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_column_gap_determines_parent_width() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setHeight(100f);
        root.setGap(YogaGutter.COLUMN, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(30f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(30f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(80f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(30f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_row_gap_align_items_stretch() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(200f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(20f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(20f);
        root.addChildAt(root_child4, 4);

        YogaNode root_child5 = createNode(config);
        root_child5.setWidth(20f);
        root.addChildAt(root_child5, 5);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(110f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child4.getLayoutX(), 0.0f);
        assertEquals(110f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child5.getLayoutX(), 0.0f);
        assertEquals(110f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child5.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child3.getLayoutX(), 0.0f);
        assertEquals(110f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(110f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child5.getLayoutX(), 0.0f);
        assertEquals(110f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child5.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_row_gap_align_items_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignItems(YogaAlign.FLEX_END);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(200f);
        root.setGap(YogaGutter.COLUMN, 10f);
        root.setGap(YogaGutter.ROW, 20f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(20f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(20f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(20f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(20f);
        root.addChildAt(root_child4, 4);

        YogaNode root_child5 = createNode(config);
        root_child5.setWidth(20f);
        root.addChildAt(root_child5, 5);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(20f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child4.getLayoutX(), 0.0f);
        assertEquals(20f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child5.getLayoutX(), 0.0f);
        assertEquals(20f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child5.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(20f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(20f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(20f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child3.getLayoutX(), 0.0f);
        assertEquals(20f, root_child3.getLayoutY(), 0.0f);
        assertEquals(20f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(20f, root_child4.getLayoutY(), 0.0f);
        assertEquals(20f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child4.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child5.getLayoutX(), 0.0f);
        assertEquals(20f, root_child5.getLayoutY(), 0.0f);
        assertEquals(20f, root_child5.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child5.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_row_gap_column_child_margins() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(200f);
        root.setGap(YogaGutter.ROW, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexGrow(1f);
        root_child0.setFlexShrink(1f);
        root_child0.setFlexBasisPercent(0f);
        root_child0.setMargin(YogaEdge.TOP, 2f);
        root_child0.setMargin(YogaEdge.BOTTOM, 2f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root_child1.setFlexBasisPercent(0f);
        root_child1.setMargin(YogaEdge.TOP, 10f);
        root_child1.setMargin(YogaEdge.BOTTOM, 10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setFlexGrow(1f);
        root_child2.setFlexShrink(1f);
        root_child2.setFlexBasisPercent(0f);
        root_child2.setMargin(YogaEdge.TOP, 15f);
        root_child2.setMargin(YogaEdge.BOTTOM, 15f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(2f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(42f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(66f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(42f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(143f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(42f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(2f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(42f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(66f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(42f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(143f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(42f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_row_gap_row_wrap_child_margins() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(200f);
        root.setGap(YogaGutter.ROW, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.TOP, 2f);
        root_child0.setMargin(YogaEdge.BOTTOM, 2f);
        root_child0.setWidth(60f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setMargin(YogaEdge.TOP, 10f);
        root_child1.setMargin(YogaEdge.BOTTOM, 10f);
        root_child1.setWidth(60f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setMargin(YogaEdge.TOP, 15f);
        root_child2.setMargin(YogaEdge.BOTTOM, 15f);
        root_child2.setWidth(60f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(2f, root_child0.getLayoutY(), 0.0f);
        assertEquals(60f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(24f, root_child1.getLayoutY(), 0.0f);
        assertEquals(60f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(59f, root_child2.getLayoutY(), 0.0f);
        assertEquals(60f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(200f, root.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child0.getLayoutX(), 0.0f);
        assertEquals(2f, root_child0.getLayoutY(), 0.0f);
        assertEquals(60f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(24f, root_child1.getLayoutY(), 0.0f);
        assertEquals(60f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child2.getLayoutX(), 0.0f);
        assertEquals(59f, root_child2.getLayoutY(), 0.0f);
        assertEquals(60f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_row_gap_determines_parent_height() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setGap(YogaGutter.ROW, 10f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(30f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(80f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(50f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(80f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(50f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child2.getLayoutHeight(), 0.0f);
    }
}
