/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @generated SignedSource<<4007f83eb3e84f3ee3fcf46d6d7be3bc>>
 * generated by gentest/gentest-driver.ts from gentest/fixtures/YGFlexDirectionTest.html
 */

package org.lwjgl.util.yoga;

import org.testng.annotations.*;

import static org.lwjgl.util.yoga.YogaNode.*;
import static org.testng.AssertJUnit.assertEquals;

public class YGFlexDirectionTest {
    @Test
    public void test_flex_direction_column_no_height() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(30f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(30f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_no_width() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(30f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(30f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(80f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(70f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(80f, root_child1.getLayoutY(), 0.0f);
        assertEquals(100f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(70f, root_child2.getLayoutY(), 0.0f);
        assertEquals(100f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_margin_left() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.LEFT, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(100f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(100f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_margin_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.START, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(100f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_margin_right() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.RIGHT, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_margin_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.END, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(100f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column_reverse_margin_top() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.TOP, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(100f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(100f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column_reverse_margin_bottom() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setMargin(YogaEdge.BOTTOM, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_padding_left() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setPadding(YogaEdge.LEFT, 100);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(110f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_padding_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setPadding(YogaEdge.START, 100);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_padding_right() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setPadding(YogaEdge.RIGHT, 100);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(-10f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(-20f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(-30f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_padding_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setPadding(YogaEdge.END, 100);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(-10f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(-20f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(-30f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(110f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column_reverse_padding_top() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setPadding(YogaEdge.TOP, 100);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column_reverse_padding_bottom() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setPadding(YogaEdge.BOTTOM, 100);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_border_left() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(110f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_border_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.START, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_border_right() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.RIGHT, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(-10f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(-20f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(-30f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_border_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.END, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(-10f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(-20f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(-30f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(110f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column_reverse_border_top() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.TOP, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column_reverse_border_bottom() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.BOTTOM, 100f);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(10f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_pos_left() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setPosition(YogaEdge.LEFT, 100f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidth(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_pos_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setPosition(YogaEdge.START, 100f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidth(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(-100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_pos_right() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setPosition(YogaEdge.RIGHT, 100f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidth(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(-100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(-100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_pos_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setPosition(YogaEdge.END, 100f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidth(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(-100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column_reverse_pos_top() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setPosition(YogaEdge.TOP, 100f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidth(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_column_reverse_pos_bottom() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setPosition(YogaEdge.BOTTOM, 100f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidth(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(-100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(-100f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_pos_left() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPosition(YogaEdge.LEFT, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_pos_right() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPosition(YogaEdge.RIGHT, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_col_reverse_inner_pos_top() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPosition(YogaEdge.TOP, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_col_reverse_inner_pos_bottom() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPosition(YogaEdge.BOTTOM, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(80f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(80f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    @Ignore
    public void test_flex_direction_row_reverse_inner_pos_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPosition(YogaEdge.START, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    @Ignore
    public void test_flex_direction_row_reverse_inner_pos_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPosition(YogaEdge.END, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_margin_left() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setMargin(YogaEdge.LEFT, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_margin_right() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setMargin(YogaEdge.RIGHT, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_col_reverse_inner_margin_top() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setMargin(YogaEdge.TOP, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_col_reverse_inner_margin_bottom() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setMargin(YogaEdge.BOTTOM, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(80f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(80f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_marign_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setMargin(YogaEdge.START, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_margin_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setMargin(YogaEdge.END, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_border_left() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setBorder(YogaEdge.LEFT, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_border_right() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_col_reverse_inner_border_top() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setBorder(YogaEdge.TOP, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_col_reverse_inner_border_bottom() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setBorder(YogaEdge.BOTTOM, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_border_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setBorder(YogaEdge.LEFT, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_border_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setBorder(YogaEdge.RIGHT, 10f);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_padding_left() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPadding(YogaEdge.LEFT, 10);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_padding_right() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPadding(YogaEdge.RIGHT, 10);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_col_reverse_inner_padding_top() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPadding(YogaEdge.TOP, 10);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_col_reverse_inner_padding_bottom() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.COLUMN_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPadding(YogaEdge.BOTTOM, 10);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_padding_start() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPadding(YogaEdge.START, 10);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_flex_direction_row_reverse_inner_padding_end() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setPositionType(YogaPositionType.ABSOLUTE);
        root_child0_child0.setPadding(YogaEdge.END, 10);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidth(10f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidth(10f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(80f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(10f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0_child2.getLayoutHeight(), 0.0f);
    }
}
