/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @generated SignedSource<<d93836c91c231c9c029763da7dc2d911>>
 * generated by gentest/gentest-driver.ts from gentest/fixtures/YGAlignContentTest.html
 */

package org.lwjgl.util.yoga;

import org.testng.annotations.*;

import static org.lwjgl.util.yoga.YogaNode.*;
import static org.testng.AssertJUnit.assertEquals;

public class YGAlignContentTest {
    @Test
    public void test_align_content_flex_start_nowrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_start_wrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root_child3.setHeight(10f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root_child4.setHeight(10f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(10f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(10f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(20f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(10f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child3.getLayoutX(), 0.0f);
        assertEquals(10f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child4.getLayoutX(), 0.0f);
        assertEquals(20f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_start_wrap_singleline() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_start_wrapped_negative_space() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_start_wrapped_negative_space_gap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root_child0.setGap(YogaGutter.COLUMN, 10f);
        root_child0.setGap(YogaGutter.ROW, 10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_start_without_height_on_children() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root_child3.setHeight(10f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(10f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(10f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(20f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child2.getLayoutX(), 0.0f);
        assertEquals(10f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(10f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(20f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_start_with_flex() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexGrow(1f);
        root_child0.setFlexBasisPercent(0f);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexBasisPercent(0f);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setFlexGrow(1f);
        root_child3.setFlexShrink(1f);
        root_child3.setFlexBasisPercent(0f);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(40f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(80f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(80f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(120f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(40f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child2.getLayoutX(), 0.0f);
        assertEquals(80f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(80f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(120f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_end_nowrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.FLEX_END);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_end_wrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.FLEX_END);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root_child3.setHeight(10f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root_child4.setHeight(10f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(90f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(100f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(110f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(90f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(90f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(100f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child3.getLayoutX(), 0.0f);
        assertEquals(100f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child4.getLayoutX(), 0.0f);
        assertEquals(110f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_end_wrap_singleline() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.FLEX_END);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(110f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(110f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(110f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(110f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_end_wrapped_negative_space() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.FLEX_END);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-50f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(-30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(-10f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-50f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(-30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(-10f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_end_wrapped_negative_space_gap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.FLEX_END);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root_child0.setGap(YogaGutter.COLUMN, 10f);
        root_child0.setGap(YogaGutter.ROW, 10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-70f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(-40f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(-10f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-70f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(-40f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(-10f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_center_nowrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_center_wrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root_child3.setHeight(10f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root_child4.setHeight(10f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(45f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(45f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(55f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(55f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(65f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(45f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(45f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(55f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child3.getLayoutX(), 0.0f);
        assertEquals(55f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child4.getLayoutX(), 0.0f);
        assertEquals(65f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_center_wrap_singleline() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(55f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(55f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(55f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(55f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_center_wrapped_negative_space() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.CENTER);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-25f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(-5f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(15f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-25f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(-5f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(15f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_center_wrapped_negative_space_gap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.CENTER);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root_child0.setGap(YogaGutter.COLUMN, 10f);
        root_child0.setGap(YogaGutter.ROW, 10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-35f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(-5f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(25f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(-35f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(-5f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(25f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_between_nowrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_BETWEEN);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_between_wrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_BETWEEN);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root_child3.setHeight(10f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root_child4.setHeight(10f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(55f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(55f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(110f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(55f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child3.getLayoutX(), 0.0f);
        assertEquals(55f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child4.getLayoutX(), 0.0f);
        assertEquals(110f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_between_wrap_singleline() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_BETWEEN);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_between_wrapped_negative_space() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.SPACE_BETWEEN);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_between_wrapped_negative_space_row_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.SPACE_BETWEEN);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_between_wrapped_negative_space_gap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.SPACE_BETWEEN);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root_child0.setGap(YogaGutter.COLUMN, 10f);
        root_child0.setGap(YogaGutter.ROW, 10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_around_nowrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_AROUND);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_around_wrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_AROUND);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root_child3.setHeight(10f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root_child4.setHeight(10f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(15f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(15f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(55f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(55f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(95f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(15f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(15f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(55f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child3.getLayoutX(), 0.0f);
        assertEquals(55f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child4.getLayoutX(), 0.0f);
        assertEquals(95f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_around_wrap_singleline() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_AROUND);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(55f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(55f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(55f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(55f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_around_wrapped_negative_space() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.SPACE_AROUND);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_around_wrapped_negative_space_row_reverse() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW_REVERSE);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.SPACE_AROUND);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_around_wrapped_negative_space_gap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.SPACE_AROUND);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root_child0.setGap(YogaGutter.COLUMN, 10f);
        root_child0.setGap(YogaGutter.ROW, 10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_nowrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_wrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root_child2.setHeight(10f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root_child3.setHeight(10f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root_child4.setHeight(10f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(23f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(23f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(55f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(55f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(88f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(23f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(23f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child2.getLayoutX(), 0.0f);
        assertEquals(55f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child3.getLayoutX(), 0.0f);
        assertEquals(55f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child4.getLayoutX(), 0.0f);
        assertEquals(88f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_wrap_singleline() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(140f);
        root.setHeight(120f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(10f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(55f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(55f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(140f, root.getLayoutWidth(), 0.0f);
        assertEquals(120f, root.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0.getLayoutX(), 0.0f);
        assertEquals(55f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(55f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_wrapped_negative_space() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.SPACE_EVENLY);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_wrapped_negative_space_gap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setBorder(YogaEdge.LEFT, 60f);
        root.setBorder(YogaEdge.TOP, 60f);
        root.setBorder(YogaEdge.RIGHT, 60f);
        root.setBorder(YogaEdge.BOTTOM, 60f);
        root.setWidth(320f);
        root.setHeight(320f);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setJustifyContent(YogaJustify.CENTER);
        root_child0.setAlignContent(YogaAlign.SPACE_EVENLY);
        root_child0.setWrap(YogaWrap.WRAP);
        root_child0.setHeight(10f);
        root_child0.setGap(YogaGutter.COLUMN, 10f);
        root_child0.setGap(YogaGutter.ROW, 10f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setWidthPercent(80f);
        root_child0_child0.setHeight(20f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child0_child1 = createNode(config);
        root_child0_child1.setWidthPercent(80f);
        root_child0_child1.setHeight(20f);
        root_child0.addChildAt(root_child0_child1, 1);

        YogaNode root_child0_child2 = createNode(config);
        root_child0_child2.setWidthPercent(80f);
        root_child0_child2.setHeight(20f);
        root_child0.addChildAt(root_child0_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(320f, root.getLayoutWidth(), 0.0f);
        assertEquals(320f, root.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child0.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0.getLayoutY(), 0.0f);
        assertEquals(200f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child1.getLayoutX(), 0.0f);
        assertEquals(30f, root_child0_child1.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0_child2.getLayoutX(), 0.0f);
        assertEquals(60f, root_child0_child2.getLayoutY(), 0.0f);
        assertEquals(160f, root_child0_child2.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child0_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(0f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child4.getLayoutX(), 0.0f);
        assertEquals(0f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row_with_children() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setFlexGrow(1f);
        root_child0_child0.setFlexShrink(1f);
        root_child0_child0.setFlexBasisPercent(0f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row_with_flex() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root_child1.setFlexBasisPercent(0f);
        root_child1.setWidth(50f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setFlexGrow(1f);
        root_child3.setFlexShrink(1f);
        root_child3.setFlexBasisPercent(0f);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(0f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(0f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child4.getLayoutX(), 0.0f);
        assertEquals(0f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(0f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(0f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(0f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row_with_flex_no_shrink() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root_child1.setFlexBasisPercent(0f);
        root_child1.setWidth(50f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setFlexGrow(1f);
        root_child3.setFlexBasisPercent(0f);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(0f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(0f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child4.getLayoutX(), 0.0f);
        assertEquals(0f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(0f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(0f, root_child3.getLayoutY(), 0.0f);
        assertEquals(0f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(0f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row_with_margin() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setMargin(YogaEdge.LEFT, 10f);
        root_child1.setMargin(YogaEdge.TOP, 10f);
        root_child1.setMargin(YogaEdge.RIGHT, 10f);
        root_child1.setMargin(YogaEdge.BOTTOM, 10f);
        root_child1.setWidth(50f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setMargin(YogaEdge.LEFT, 10f);
        root_child3.setMargin(YogaEdge.TOP, 10f);
        root_child3.setMargin(YogaEdge.RIGHT, 10f);
        root_child3.setMargin(YogaEdge.BOTTOM, 10f);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(60f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(80f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child1.getLayoutX(), 0.0f);
        assertEquals(10f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child2.getLayoutX(), 0.0f);
        assertEquals(40f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(40f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child4.getLayoutX(), 0.0f);
        assertEquals(80f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row_with_padding() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setPadding(YogaEdge.LEFT, 10);
        root_child1.setPadding(YogaEdge.TOP, 10);
        root_child1.setPadding(YogaEdge.RIGHT, 10);
        root_child1.setPadding(YogaEdge.BOTTOM, 10);
        root_child1.setWidth(50f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setPadding(YogaEdge.LEFT, 10);
        root_child3.setPadding(YogaEdge.TOP, 10);
        root_child3.setPadding(YogaEdge.RIGHT, 10);
        root_child3.setPadding(YogaEdge.BOTTOM, 10);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row_with_single_row() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row_with_fixed_height() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setHeight(60f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(80f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(60f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(80f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(80f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(80f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(80f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(60f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(80f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child3.getLayoutX(), 0.0f);
        assertEquals(80f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(80f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row_with_max_height() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setMaxHeight(20f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(20f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_row_with_min_height() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(150f);
        root.setHeight(100f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(50f);
        root_child1.setMinHeight(80f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setWidth(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setWidth(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(90f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(90f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(150f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(90f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child3.getLayoutX(), 0.0f);
        assertEquals(90f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(90f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_column() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(100f);
        root.setHeight(150f);

        YogaNode root_child0 = createNode(config);
        root_child0.setHeight(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setFlexGrow(1f);
        root_child0_child0.setFlexShrink(1f);
        root_child0_child0.setFlexBasisPercent(0f);
        root_child0.addChildAt(root_child0_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root_child1.setFlexBasisPercent(0f);
        root_child1.setHeight(50f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setHeight(50f);
        root.addChildAt(root_child2, 2);

        YogaNode root_child3 = createNode(config);
        root_child3.setHeight(50f);
        root.addChildAt(root_child3, 3);

        YogaNode root_child4 = createNode(config);
        root_child4.setHeight(50f);
        root.addChildAt(root_child4, 4);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(150f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(50f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child3.getLayoutX(), 0.0f);
        assertEquals(100f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child4.getLayoutX(), 0.0f);
        assertEquals(0f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(150f, root.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1.getLayoutY(), 0.0f);
        assertEquals(50f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(0f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child2.getLayoutX(), 0.0f);
        assertEquals(50f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child3.getLayoutX(), 0.0f);
        assertEquals(100f, root_child3.getLayoutY(), 0.0f);
        assertEquals(50f, root_child3.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child3.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child4.getLayoutX(), 0.0f);
        assertEquals(0f, root_child4.getLayoutY(), 0.0f);
        assertEquals(50f, root_child4.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child4.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_is_not_overriding_align_items() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);

        YogaNode root_child0 = createNode(config);
        root_child0.setFlexDirection(YogaFlexDirection.ROW);
        root_child0.setAlignContent(YogaAlign.STRETCH);
        root_child0.setAlignItems(YogaAlign.CENTER);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child0_child0 = createNode(config);
        root_child0_child0.setAlignContent(YogaAlign.STRETCH);
        root_child0_child0.setWidth(10f);
        root_child0_child0.setHeight(10f);
        root_child0.addChildAt(root_child0_child0, 0);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(45f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(100f, root.getLayoutWidth(), 0.0f);
        assertEquals(100f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child0_child0.getLayoutX(), 0.0f);
        assertEquals(45f, root_child0_child0.getLayoutY(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutWidth(), 0.0f);
        assertEquals(10f, root_child0_child0.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_with_min_cross_axis() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(500f);
        root.setMinHeight(500f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(400f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(400f);
        root_child1.setHeight(200f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(500f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(250f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(500f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1.getLayoutX(), 0.0f);
        assertEquals(250f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_with_max_cross_axis() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(500f);
        root.setMaxHeight(500f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(400f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(400f);
        root_child1.setHeight(200f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(200f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1.getLayoutX(), 0.0f);
        assertEquals(200f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_with_max_cross_axis_and_border_padding() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.STRETCH);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setPadding(YogaEdge.LEFT, 2);
        root.setPadding(YogaEdge.TOP, 2);
        root.setPadding(YogaEdge.RIGHT, 2);
        root.setPadding(YogaEdge.BOTTOM, 2);
        root.setBorder(YogaEdge.LEFT, 5f);
        root.setBorder(YogaEdge.TOP, 5f);
        root.setBorder(YogaEdge.RIGHT, 5f);
        root.setBorder(YogaEdge.BOTTOM, 5f);
        root.setWidth(500f);
        root.setMaxHeight(500f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(400f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(400f);
        root_child1.setHeight(200f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(414f, root.getLayoutHeight(), 0.0f);

        assertEquals(7f, root_child0.getLayoutX(), 0.0f);
        assertEquals(7f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(7f, root_child1.getLayoutX(), 0.0f);
        assertEquals(207f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(414f, root.getLayoutHeight(), 0.0f);

        assertEquals(93f, root_child0.getLayoutX(), 0.0f);
        assertEquals(7f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(93f, root_child1.getLayoutX(), 0.0f);
        assertEquals(207f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_with_min_cross_axis() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(500f);
        root.setMinHeight(500f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(400f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(400f);
        root_child1.setHeight(200f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(500f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(33f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(267f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(500f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(33f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1.getLayoutX(), 0.0f);
        assertEquals(267f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_with_max_cross_axis() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(500f);
        root.setMaxHeight(500f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(400f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(400f);
        root_child1.setHeight(200f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(200f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(400f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1.getLayoutX(), 0.0f);
        assertEquals(200f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_with_max_cross_axis_violated() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(500f);
        root.setMaxHeight(300f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(400f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(400f);
        root_child1.setHeight(200f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1.getLayoutX(), 0.0f);
        assertEquals(200f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1.getLayoutX(), 0.0f);
        assertEquals(200f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_with_max_cross_axis_violated_padding_and_border() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_EVENLY);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setPadding(YogaEdge.LEFT, 2);
        root.setPadding(YogaEdge.TOP, 2);
        root.setPadding(YogaEdge.RIGHT, 2);
        root.setPadding(YogaEdge.BOTTOM, 2);
        root.setBorder(YogaEdge.LEFT, 5f);
        root.setBorder(YogaEdge.TOP, 5f);
        root.setBorder(YogaEdge.RIGHT, 5f);
        root.setBorder(YogaEdge.BOTTOM, 5f);
        root.setWidth(500f);
        root.setMaxHeight(300f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(400f);
        root_child0.setHeight(200f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(400f);
        root_child1.setHeight(200f);
        root.addChildAt(root_child1, 1);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(7f, root_child0.getLayoutX(), 0.0f);
        assertEquals(7f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(7f, root_child1.getLayoutX(), 0.0f);
        assertEquals(207f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(500f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(93f, root_child0.getLayoutX(), 0.0f);
        assertEquals(7f, root_child0.getLayoutY(), 0.0f);
        assertEquals(400f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(93f, root_child1.getLayoutX(), 0.0f);
        assertEquals(207f, root_child1.getLayoutY(), 0.0f);
        assertEquals(400f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(200f, root_child1.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_around_and_align_items_flex_end_with_flex_wrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_AROUND);
        root.setAlignItems(YogaAlign.FLEX_END);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(300f);
        root.setHeight(300f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(150f);
        root_child0.setHeight(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(120f);
        root_child1.setHeight(100f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(120f);
        root_child2.setHeight(50f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(88f, root_child0.getLayoutY(), 0.0f);
        assertEquals(150f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(150f, root_child1.getLayoutX(), 0.0f);
        assertEquals(38f, root_child1.getLayoutY(), 0.0f);
        assertEquals(120f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(213f, root_child2.getLayoutY(), 0.0f);
        assertEquals(120f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(150f, root_child0.getLayoutX(), 0.0f);
        assertEquals(88f, root_child0.getLayoutY(), 0.0f);
        assertEquals(150f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(38f, root_child1.getLayoutY(), 0.0f);
        assertEquals(120f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(180f, root_child2.getLayoutX(), 0.0f);
        assertEquals(213f, root_child2.getLayoutY(), 0.0f);
        assertEquals(120f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_around_and_align_items_center_with_flex_wrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_AROUND);
        root.setAlignItems(YogaAlign.CENTER);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(300f);
        root.setHeight(300f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(150f);
        root_child0.setHeight(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(120f);
        root_child1.setHeight(100f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(120f);
        root_child2.setHeight(50f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(63f, root_child0.getLayoutY(), 0.0f);
        assertEquals(150f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(150f, root_child1.getLayoutX(), 0.0f);
        assertEquals(38f, root_child1.getLayoutY(), 0.0f);
        assertEquals(120f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(213f, root_child2.getLayoutY(), 0.0f);
        assertEquals(120f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(150f, root_child0.getLayoutX(), 0.0f);
        assertEquals(63f, root_child0.getLayoutY(), 0.0f);
        assertEquals(150f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(38f, root_child1.getLayoutY(), 0.0f);
        assertEquals(120f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(180f, root_child2.getLayoutX(), 0.0f);
        assertEquals(213f, root_child2.getLayoutY(), 0.0f);
        assertEquals(120f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_around_and_align_items_flex_start_with_flex_wrap() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setAlignContent(YogaAlign.SPACE_AROUND);
        root.setAlignItems(YogaAlign.FLEX_START);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setWrap(YogaWrap.WRAP);
        root.setWidth(300f);
        root.setHeight(300f);

        YogaNode root_child0 = createNode(config);
        root_child0.setWidth(150f);
        root_child0.setHeight(50f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setWidth(120f);
        root_child1.setHeight(100f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child2 = createNode(config);
        root_child2.setWidth(120f);
        root_child2.setHeight(50f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child0.getLayoutX(), 0.0f);
        assertEquals(38f, root_child0.getLayoutY(), 0.0f);
        assertEquals(150f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(150f, root_child1.getLayoutX(), 0.0f);
        assertEquals(38f, root_child1.getLayoutY(), 0.0f);
        assertEquals(120f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child2.getLayoutX(), 0.0f);
        assertEquals(213f, root_child2.getLayoutY(), 0.0f);
        assertEquals(120f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(300f, root.getLayoutWidth(), 0.0f);
        assertEquals(300f, root.getLayoutHeight(), 0.0f);

        assertEquals(150f, root_child0.getLayoutX(), 0.0f);
        assertEquals(38f, root_child0.getLayoutY(), 0.0f);
        assertEquals(150f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(30f, root_child1.getLayoutX(), 0.0f);
        assertEquals(38f, root_child1.getLayoutY(), 0.0f);
        assertEquals(120f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(180f, root_child2.getLayoutX(), 0.0f);
        assertEquals(213f, root_child2.getLayoutY(), 0.0f);
        assertEquals(120f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_flex_start_stretch_doesnt_influence_line_box_dim() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setPadding(YogaEdge.LEFT, 20);
        root.setPadding(YogaEdge.TOP, 20);
        root.setPadding(YogaEdge.RIGHT, 20);
        root.setPadding(YogaEdge.BOTTOM, 20);
        root.setWidth(400f);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.RIGHT, 20f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexDirection(YogaFlexDirection.ROW);
        root_child1.setWrap(YogaWrap.WRAP);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child1_child0 = createNode(config);
        root_child1_child0.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child0.setWidth(30f);
        root_child1_child0.setHeight(30f);
        root_child1.addChildAt(root_child1_child0, 0);

        YogaNode root_child1_child1 = createNode(config);
        root_child1_child1.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child1.setWidth(30f);
        root_child1_child1.setHeight(30f);
        root_child1.addChildAt(root_child1_child1, 1);

        YogaNode root_child1_child2 = createNode(config);
        root_child1_child2.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child2.setWidth(30f);
        root_child1_child2.setHeight(30f);
        root_child1.addChildAt(root_child1_child2, 2);

        YogaNode root_child1_child3 = createNode(config);
        root_child1_child3.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child3.setWidth(30f);
        root_child1_child3.setHeight(30f);
        root_child1.addChildAt(root_child1_child3, 3);

        YogaNode root_child1_child4 = createNode(config);
        root_child1_child4.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child4.setWidth(30f);
        root_child1_child4.setHeight(30f);
        root_child1.addChildAt(root_child1_child4, 4);

        YogaNode root_child2 = createNode(config);
        root_child2.setMargin(YogaEdge.LEFT, 20f);
        root_child2.setWidth(50f);
        root_child2.setHeight(50f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(140f, root.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(140f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(170f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child0.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child1.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child2.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1_child3.getLayoutX(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1_child4.getLayoutX(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutHeight(), 0.0f);

        assertEquals(330f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(140f, root.getLayoutHeight(), 0.0f);

        assertEquals(260f, root_child0.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(170f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child1_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child0.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child1_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child1.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child1_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child2.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child1_child3.getLayoutX(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child1_child4.getLayoutX(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_stretch_stretch_does_influence_line_box_dim() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setPadding(YogaEdge.LEFT, 20);
        root.setPadding(YogaEdge.TOP, 20);
        root.setPadding(YogaEdge.RIGHT, 20);
        root.setPadding(YogaEdge.BOTTOM, 20);
        root.setWidth(400f);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.RIGHT, 20f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexDirection(YogaFlexDirection.ROW);
        root_child1.setAlignContent(YogaAlign.STRETCH);
        root_child1.setWrap(YogaWrap.WRAP);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child1_child0 = createNode(config);
        root_child1_child0.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child0.setWidth(30f);
        root_child1_child0.setHeight(30f);
        root_child1.addChildAt(root_child1_child0, 0);

        YogaNode root_child1_child1 = createNode(config);
        root_child1_child1.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child1.setWidth(30f);
        root_child1_child1.setHeight(30f);
        root_child1.addChildAt(root_child1_child1, 1);

        YogaNode root_child1_child2 = createNode(config);
        root_child1_child2.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child2.setWidth(30f);
        root_child1_child2.setHeight(30f);
        root_child1.addChildAt(root_child1_child2, 2);

        YogaNode root_child1_child3 = createNode(config);
        root_child1_child3.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child3.setWidth(30f);
        root_child1_child3.setHeight(30f);
        root_child1.addChildAt(root_child1_child3, 3);

        YogaNode root_child1_child4 = createNode(config);
        root_child1_child4.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child4.setWidth(30f);
        root_child1_child4.setHeight(30f);
        root_child1.addChildAt(root_child1_child4, 4);

        YogaNode root_child2 = createNode(config);
        root_child2.setMargin(YogaEdge.LEFT, 20f);
        root_child2.setWidth(50f);
        root_child2.setHeight(50f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(140f, root.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(140f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(170f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child0.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child1.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child2.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1_child3.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1_child4.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutHeight(), 0.0f);

        assertEquals(330f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(140f, root.getLayoutHeight(), 0.0f);

        assertEquals(260f, root_child0.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(170f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child1_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child0.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child1_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child1.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child1_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child2.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child1_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1_child3.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child1_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1_child4.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);
    }

    @Test
    public void test_align_content_space_evenly_stretch_does_influence_line_box_dim() {
        YogaConfig config = YogaConfigFactory.create();

        YogaNode root = createNode(config);
        root.setFlexDirection(YogaFlexDirection.ROW);
        root.setPositionType(YogaPositionType.ABSOLUTE);
        root.setPadding(YogaEdge.LEFT, 20);
        root.setPadding(YogaEdge.TOP, 20);
        root.setPadding(YogaEdge.RIGHT, 20);
        root.setPadding(YogaEdge.BOTTOM, 20);
        root.setWidth(400f);

        YogaNode root_child0 = createNode(config);
        root_child0.setMargin(YogaEdge.RIGHT, 20f);
        root_child0.setWidth(100f);
        root_child0.setHeight(100f);
        root.addChildAt(root_child0, 0);

        YogaNode root_child1 = createNode(config);
        root_child1.setFlexDirection(YogaFlexDirection.ROW);
        root_child1.setAlignContent(YogaAlign.STRETCH);
        root_child1.setWrap(YogaWrap.WRAP);
        root_child1.setFlexGrow(1f);
        root_child1.setFlexShrink(1f);
        root.addChildAt(root_child1, 1);

        YogaNode root_child1_child0 = createNode(config);
        root_child1_child0.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child0.setWidth(30f);
        root_child1_child0.setHeight(30f);
        root_child1.addChildAt(root_child1_child0, 0);

        YogaNode root_child1_child1 = createNode(config);
        root_child1_child1.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child1.setWidth(30f);
        root_child1_child1.setHeight(30f);
        root_child1.addChildAt(root_child1_child1, 1);

        YogaNode root_child1_child2 = createNode(config);
        root_child1_child2.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child2.setWidth(30f);
        root_child1_child2.setHeight(30f);
        root_child1.addChildAt(root_child1_child2, 2);

        YogaNode root_child1_child3 = createNode(config);
        root_child1_child3.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child3.setWidth(30f);
        root_child1_child3.setHeight(30f);
        root_child1.addChildAt(root_child1_child3, 3);

        YogaNode root_child1_child4 = createNode(config);
        root_child1_child4.setMargin(YogaEdge.RIGHT, 20f);
        root_child1_child4.setWidth(30f);
        root_child1_child4.setHeight(30f);
        root_child1.addChildAt(root_child1_child4, 4);

        YogaNode root_child2 = createNode(config);
        root_child2.setMargin(YogaEdge.LEFT, 20f);
        root_child2.setWidth(50f);
        root_child2.setHeight(50f);
        root.addChildAt(root_child2, 2);
        root.setDirection(YogaDirection.LTR);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(140f, root.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child0.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(140f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(170f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child0.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child1.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutHeight(), 0.0f);

        assertEquals(100f, root_child1_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child2.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutHeight(), 0.0f);

        assertEquals(0f, root_child1_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1_child3.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutHeight(), 0.0f);

        assertEquals(50f, root_child1_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1_child4.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutHeight(), 0.0f);

        assertEquals(330f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);

        root.setDirection(YogaDirection.RTL);
        root.calculateLayout(YogaConstants.UNDEFINED, YogaConstants.UNDEFINED);

        assertEquals(0f, root.getLayoutX(), 0.0f);
        assertEquals(0f, root.getLayoutY(), 0.0f);
        assertEquals(400f, root.getLayoutWidth(), 0.0f);
        assertEquals(140f, root.getLayoutHeight(), 0.0f);

        assertEquals(260f, root_child0.getLayoutX(), 0.0f);
        assertEquals(20f, root_child0.getLayoutY(), 0.0f);
        assertEquals(100f, root_child0.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child0.getLayoutHeight(), 0.0f);

        assertEquals(90f, root_child1.getLayoutX(), 0.0f);
        assertEquals(20f, root_child1.getLayoutY(), 0.0f);
        assertEquals(170f, root_child1.getLayoutWidth(), 0.0f);
        assertEquals(100f, root_child1.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child1_child0.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child0.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child0.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child1_child1.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child1.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child1.getLayoutHeight(), 0.0f);

        assertEquals(20f, root_child1_child2.getLayoutX(), 0.0f);
        assertEquals(0f, root_child1_child2.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child2.getLayoutHeight(), 0.0f);

        assertEquals(120f, root_child1_child3.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1_child3.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child3.getLayoutHeight(), 0.0f);

        assertEquals(70f, root_child1_child4.getLayoutX(), 0.0f);
        assertEquals(50f, root_child1_child4.getLayoutY(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutWidth(), 0.0f);
        assertEquals(30f, root_child1_child4.getLayoutHeight(), 0.0f);

        assertEquals(40f, root_child2.getLayoutX(), 0.0f);
        assertEquals(20f, root_child2.getLayoutY(), 0.0f);
        assertEquals(50f, root_child2.getLayoutWidth(), 0.0f);
        assertEquals(50f, root_child2.getLayoutHeight(), 0.0f);
    }
}
