/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package vulkan

import org.lwjgl.generator.*

// Handle types
val VkBuffer = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkBuffer")
val VkImage = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkImage")
val VkInstance = VK_DEFINE_HANDLE("VkInstance")
val VkPhysicalDevice = VK_DEFINE_HANDLE("VkPhysicalDevice")
val VkDevice = VK_DEFINE_HANDLE("VkDevice")
val VkQueue = VK_DEFINE_HANDLE("VkQueue")
val VkSemaphore = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkSemaphore")
val VkCommandBuffer = VK_DEFINE_HANDLE("VkCommandBuffer")
val VkFence = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkFence")
val VkDeviceMemory = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDeviceMemory")
val VkEvent = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkEvent")
val VkQueryPool = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkQueryPool")
val VkBufferView = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkBufferView")
val VkImageView = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkImageView")
val VkShaderModule = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkShaderModule")
val VkPipelineCache = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkPipelineCache")
val VkPipelineLayout = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkPipelineLayout")
val VkPipeline = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkPipeline")
val VkRenderPass = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkRenderPass")
val VkDescriptorSetLayout = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDescriptorSetLayout")
val VkSampler = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkSampler")
val VkDescriptorSet = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDescriptorSet")
val VkDescriptorPool = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDescriptorPool")
val VkFramebuffer = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkFramebuffer")
val VkCommandPool = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkCommandPool")
val VkSamplerYcbcrConversion = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkSamplerYcbcrConversion")
val VkDescriptorUpdateTemplate = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDescriptorUpdateTemplate")
val VkPrivateDataSlot = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkPrivateDataSlot")

// Enum types
val VkResult = "VkResult".enumType
val VkStructureType = "VkStructureType".enumType
val VkPipelineCacheHeaderVersion = "VkPipelineCacheHeaderVersion".enumType
val VkImageLayout = "VkImageLayout".enumType
val VkObjectType = "VkObjectType".enumType
val VkVendorId = "VkVendorId".enumType
val VkSystemAllocationScope = "VkSystemAllocationScope".enumType
val VkInternalAllocationType = "VkInternalAllocationType".enumType
val VkFormat = "VkFormat".enumType
val VkFormatFeatureFlagBits = "VkFormatFeatureFlagBits".enumType
val VkImageCreateFlagBits = "VkImageCreateFlagBits".enumType
val VkImageTiling = "VkImageTiling".enumType
val VkImageType = "VkImageType".enumType
val VkImageUsageFlagBits = "VkImageUsageFlagBits".enumType
val VkInstanceCreateFlagBits = "VkInstanceCreateFlagBits".enumType
val VkMemoryHeapFlagBits = "VkMemoryHeapFlagBits".enumType
val VkMemoryPropertyFlagBits = "VkMemoryPropertyFlagBits".enumType
val VkPhysicalDeviceType = "VkPhysicalDeviceType".enumType
val VkQueueFlagBits = "VkQueueFlagBits".enumType
val VkSampleCountFlagBits = "VkSampleCountFlagBits".enumType
val VkPipelineStageFlagBits = "VkPipelineStageFlagBits".enumType
val VkMemoryMapFlagBits = "VkMemoryMapFlagBits".enumType
val VkImageAspectFlagBits = "VkImageAspectFlagBits".enumType
val VkSparseImageFormatFlagBits = "VkSparseImageFormatFlagBits".enumType
val VkSparseMemoryBindFlagBits = "VkSparseMemoryBindFlagBits".enumType
val VkFenceCreateFlagBits = "VkFenceCreateFlagBits".enumType
val VkEventCreateFlagBits = "VkEventCreateFlagBits".enumType
val VkQueryPipelineStatisticFlagBits = "VkQueryPipelineStatisticFlagBits".enumType
val VkQueryType = "VkQueryType".enumType
val VkQueryResultFlagBits = "VkQueryResultFlagBits".enumType
val VkBufferCreateFlagBits = "VkBufferCreateFlagBits".enumType
val VkSharingMode = "VkSharingMode".enumType
val VkBufferUsageFlagBits = "VkBufferUsageFlagBits".enumType
val VkComponentSwizzle = "VkComponentSwizzle".enumType
val VkImageViewCreateFlagBits = "VkImageViewCreateFlagBits".enumType
val VkImageViewType = "VkImageViewType".enumType
val VkBlendFactor = "VkBlendFactor".enumType
val VkBlendOp = "VkBlendOp".enumType
val VkColorComponentFlagBits = "VkColorComponentFlagBits".enumType
val VkCompareOp = "VkCompareOp".enumType
val VkShaderStageFlagBits = "VkShaderStageFlagBits".enumType
val VkCullModeFlagBits = "VkCullModeFlagBits".enumType
val VkDynamicState = "VkDynamicState".enumType
val VkFrontFace = "VkFrontFace".enumType
val VkVertexInputRate = "VkVertexInputRate".enumType
val VkPrimitiveTopology = "VkPrimitiveTopology".enumType
val VkPolygonMode = "VkPolygonMode".enumType
val VkStencilOp = "VkStencilOp".enumType
val VkLogicOp = "VkLogicOp".enumType
val VkPipelineCreateFlagBits = "VkPipelineCreateFlagBits".enumType
val VkPipelineShaderStageCreateFlagBits = "VkPipelineShaderStageCreateFlagBits".enumType
val VkBorderColor = "VkBorderColor".enumType
val VkFilter = "VkFilter".enumType
val VkSamplerAddressMode = "VkSamplerAddressMode".enumType
val VkSamplerCreateFlagBits = "VkSamplerCreateFlagBits".enumType
val VkSamplerMipmapMode = "VkSamplerMipmapMode".enumType
val VkDescriptorPoolCreateFlagBits = "VkDescriptorPoolCreateFlagBits".enumType
val VkDescriptorType = "VkDescriptorType".enumType
val VkDescriptorSetLayoutCreateFlagBits = "VkDescriptorSetLayoutCreateFlagBits".enumType
val VkAccessFlagBits = "VkAccessFlagBits".enumType
val VkAttachmentLoadOp = "VkAttachmentLoadOp".enumType
val VkAttachmentStoreOp = "VkAttachmentStoreOp".enumType
val VkAttachmentDescriptionFlagBits = "VkAttachmentDescriptionFlagBits".enumType
val VkDependencyFlagBits = "VkDependencyFlagBits".enumType
val VkFramebufferCreateFlagBits = "VkFramebufferCreateFlagBits".enumType
val VkPipelineBindPoint = "VkPipelineBindPoint".enumType
val VkRenderPassCreateFlagBits = "VkRenderPassCreateFlagBits".enumType
val VkSubpassDescriptionFlagBits = "VkSubpassDescriptionFlagBits".enumType
val VkCommandPoolCreateFlagBits = "VkCommandPoolCreateFlagBits".enumType
val VkCommandPoolResetFlagBits = "VkCommandPoolResetFlagBits".enumType
val VkCommandBufferLevel = "VkCommandBufferLevel".enumType
val VkCommandBufferResetFlagBits = "VkCommandBufferResetFlagBits".enumType
val VkCommandBufferUsageFlagBits = "VkCommandBufferUsageFlagBits".enumType
val VkQueryControlFlagBits = "VkQueryControlFlagBits".enumType
val VkIndexType = "VkIndexType".enumType
val VkStencilFaceFlagBits = "VkStencilFaceFlagBits".enumType
val VkSubpassContents = "VkSubpassContents".enumType
val VkSubgroupFeatureFlagBits = "VkSubgroupFeatureFlagBits".enumType
val VkPeerMemoryFeatureFlagBits = "VkPeerMemoryFeatureFlagBits".enumType
val VkMemoryAllocateFlagBits = "VkMemoryAllocateFlagBits".enumType
val VkPointClippingBehavior = "VkPointClippingBehavior".enumType
val VkTessellationDomainOrigin = "VkTessellationDomainOrigin".enumType
val VkDeviceQueueCreateFlagBits = "VkDeviceQueueCreateFlagBits".enumType
val VkSamplerYcbcrModelConversion = "VkSamplerYcbcrModelConversion".enumType
val VkSamplerYcbcrRange = "VkSamplerYcbcrRange".enumType
val VkChromaLocation = "VkChromaLocation".enumType
val VkDescriptorUpdateTemplateType = "VkDescriptorUpdateTemplateType".enumType
val VkExternalMemoryHandleTypeFlagBits = "VkExternalMemoryHandleTypeFlagBits".enumType
val VkExternalMemoryFeatureFlagBits = "VkExternalMemoryFeatureFlagBits".enumType
val VkExternalFenceHandleTypeFlagBits = "VkExternalFenceHandleTypeFlagBits".enumType
val VkExternalFenceFeatureFlagBits = "VkExternalFenceFeatureFlagBits".enumType
val VkFenceImportFlagBits = "VkFenceImportFlagBits".enumType
val VkSemaphoreImportFlagBits = "VkSemaphoreImportFlagBits".enumType
val VkExternalSemaphoreHandleTypeFlagBits = "VkExternalSemaphoreHandleTypeFlagBits".enumType
val VkExternalSemaphoreFeatureFlagBits = "VkExternalSemaphoreFeatureFlagBits".enumType
val VkDriverId = "VkDriverId".enumType
val VkShaderFloatControlsIndependence = "VkShaderFloatControlsIndependence".enumType
val VkDescriptorBindingFlagBits = "VkDescriptorBindingFlagBits".enumType
val VkResolveModeFlagBits = "VkResolveModeFlagBits".enumType
val VkSamplerReductionMode = "VkSamplerReductionMode".enumType
val VkSemaphoreType = "VkSemaphoreType".enumType
val VkSemaphoreWaitFlagBits = "VkSemaphoreWaitFlagBits".enumType
val VkPipelineCreationFeedbackFlagBits = "VkPipelineCreationFeedbackFlagBits".enumType
val VkToolPurposeFlagBits = "VkToolPurposeFlagBits".enumType
val VkPipelineStageFlagBits2 = "VkPipelineStageFlagBits2".enumType
val VkAccessFlagBits2 = "VkAccessFlagBits2".enumType
val VkSubmitFlagBits = "VkSubmitFlagBits".enumType
val VkRenderingFlagBits = "VkRenderingFlagBits".enumType
val VkFormatFeatureFlagBits2 = "VkFormatFeatureFlagBits2".enumType
val VkPipelineRobustnessBufferBehavior = "VkPipelineRobustnessBufferBehavior".enumType
val VkPipelineRobustnessImageBehavior = "VkPipelineRobustnessImageBehavior".enumType
val VkQueueGlobalPriority = "VkQueueGlobalPriority".enumType
val VkLineRasterizationMode = "VkLineRasterizationMode".enumType
val VkMemoryUnmapFlagBits = "VkMemoryUnmapFlagBits".enumType
val VkPipelineCreateFlagBits2 = "VkPipelineCreateFlagBits2".enumType
val VkBufferUsageFlagBits2 = "VkBufferUsageFlagBits2".enumType
val VkHostImageCopyFlagBits = "VkHostImageCopyFlagBits".enumType

// Bitmask types
val VkAccessFlags = typedef(VkFlags, "VkAccessFlags")
val VkImageAspectFlags = typedef(VkFlags, "VkImageAspectFlags")
val VkFormatFeatureFlags = typedef(VkFlags, "VkFormatFeatureFlags")
val VkImageCreateFlags = typedef(VkFlags, "VkImageCreateFlags")
val VkSampleCountFlags = typedef(VkFlags, "VkSampleCountFlags")
val VkImageUsageFlags = typedef(VkFlags, "VkImageUsageFlags")
val VkInstanceCreateFlags = typedef(VkFlags, "VkInstanceCreateFlags")
val VkMemoryHeapFlags = typedef(VkFlags, "VkMemoryHeapFlags")
val VkMemoryPropertyFlags = typedef(VkFlags, "VkMemoryPropertyFlags")
val VkQueueFlags = typedef(VkFlags, "VkQueueFlags")
val VkDeviceCreateFlags = typedef(VkFlags, "VkDeviceCreateFlags")
val VkDeviceQueueCreateFlags = typedef(VkFlags, "VkDeviceQueueCreateFlags")
val VkPipelineStageFlags = typedef(VkFlags, "VkPipelineStageFlags")
val VkMemoryMapFlags = typedef(VkFlags, "VkMemoryMapFlags")
val VkSparseMemoryBindFlags = typedef(VkFlags, "VkSparseMemoryBindFlags")
val VkSparseImageFormatFlags = typedef(VkFlags, "VkSparseImageFormatFlags")
val VkFenceCreateFlags = typedef(VkFlags, "VkFenceCreateFlags")
val VkSemaphoreCreateFlags = typedef(VkFlags, "VkSemaphoreCreateFlags")
val VkEventCreateFlags = typedef(VkFlags, "VkEventCreateFlags")
val VkQueryPipelineStatisticFlags = typedef(VkFlags, "VkQueryPipelineStatisticFlags")
val VkQueryPoolCreateFlags = typedef(VkFlags, "VkQueryPoolCreateFlags")
val VkQueryResultFlags = typedef(VkFlags, "VkQueryResultFlags")
val VkBufferCreateFlags = typedef(VkFlags, "VkBufferCreateFlags")
val VkBufferUsageFlags = typedef(VkFlags, "VkBufferUsageFlags")
val VkBufferViewCreateFlags = typedef(VkFlags, "VkBufferViewCreateFlags")
val VkImageViewCreateFlags = typedef(VkFlags, "VkImageViewCreateFlags")
val VkShaderModuleCreateFlags = typedef(VkFlags, "VkShaderModuleCreateFlags")
val VkPipelineCacheCreateFlags = typedef(VkFlags, "VkPipelineCacheCreateFlags")
val VkColorComponentFlags = typedef(VkFlags, "VkColorComponentFlags")
val VkPipelineCreateFlags = typedef(VkFlags, "VkPipelineCreateFlags")
val VkPipelineShaderStageCreateFlags = typedef(VkFlags, "VkPipelineShaderStageCreateFlags")
val VkCullModeFlags = typedef(VkFlags, "VkCullModeFlags")
val VkPipelineVertexInputStateCreateFlags = typedef(VkFlags, "VkPipelineVertexInputStateCreateFlags")
val VkPipelineInputAssemblyStateCreateFlags = typedef(VkFlags, "VkPipelineInputAssemblyStateCreateFlags")
val VkPipelineTessellationStateCreateFlags = typedef(VkFlags, "VkPipelineTessellationStateCreateFlags")
val VkPipelineViewportStateCreateFlags = typedef(VkFlags, "VkPipelineViewportStateCreateFlags")
val VkPipelineRasterizationStateCreateFlags = typedef(VkFlags, "VkPipelineRasterizationStateCreateFlags")
val VkPipelineMultisampleStateCreateFlags = typedef(VkFlags, "VkPipelineMultisampleStateCreateFlags")
val VkPipelineDepthStencilStateCreateFlags = typedef(VkFlags, "VkPipelineDepthStencilStateCreateFlags")
val VkPipelineColorBlendStateCreateFlags = typedef(VkFlags, "VkPipelineColorBlendStateCreateFlags")
val VkPipelineDynamicStateCreateFlags = typedef(VkFlags, "VkPipelineDynamicStateCreateFlags")
val VkPipelineLayoutCreateFlags = typedef(VkFlags, "VkPipelineLayoutCreateFlags")
val VkShaderStageFlags = typedef(VkFlags, "VkShaderStageFlags")
val VkSamplerCreateFlags = typedef(VkFlags, "VkSamplerCreateFlags")
val VkDescriptorPoolCreateFlags = typedef(VkFlags, "VkDescriptorPoolCreateFlags")
val VkDescriptorPoolResetFlags = typedef(VkFlags, "VkDescriptorPoolResetFlags")
val VkDescriptorSetLayoutCreateFlags = typedef(VkFlags, "VkDescriptorSetLayoutCreateFlags")
val VkAttachmentDescriptionFlags = typedef(VkFlags, "VkAttachmentDescriptionFlags")
val VkDependencyFlags = typedef(VkFlags, "VkDependencyFlags")
val VkFramebufferCreateFlags = typedef(VkFlags, "VkFramebufferCreateFlags")
val VkRenderPassCreateFlags = typedef(VkFlags, "VkRenderPassCreateFlags")
val VkSubpassDescriptionFlags = typedef(VkFlags, "VkSubpassDescriptionFlags")
val VkCommandPoolCreateFlags = typedef(VkFlags, "VkCommandPoolCreateFlags")
val VkCommandPoolResetFlags = typedef(VkFlags, "VkCommandPoolResetFlags")
val VkCommandBufferUsageFlags = typedef(VkFlags, "VkCommandBufferUsageFlags")
val VkQueryControlFlags = typedef(VkFlags, "VkQueryControlFlags")
val VkCommandBufferResetFlags = typedef(VkFlags, "VkCommandBufferResetFlags")
val VkStencilFaceFlags = typedef(VkFlags, "VkStencilFaceFlags")
val VkSubgroupFeatureFlags = typedef(VkFlags, "VkSubgroupFeatureFlags")
val VkPeerMemoryFeatureFlags = typedef(VkFlags, "VkPeerMemoryFeatureFlags")
val VkMemoryAllocateFlags = typedef(VkFlags, "VkMemoryAllocateFlags")
val VkCommandPoolTrimFlags = typedef(VkFlags, "VkCommandPoolTrimFlags")
val VkDescriptorUpdateTemplateCreateFlags = typedef(VkFlags, "VkDescriptorUpdateTemplateCreateFlags")
val VkExternalMemoryHandleTypeFlags = typedef(VkFlags, "VkExternalMemoryHandleTypeFlags")
val VkExternalMemoryFeatureFlags = typedef(VkFlags, "VkExternalMemoryFeatureFlags")
val VkExternalFenceHandleTypeFlags = typedef(VkFlags, "VkExternalFenceHandleTypeFlags")
val VkExternalFenceFeatureFlags = typedef(VkFlags, "VkExternalFenceFeatureFlags")
val VkFenceImportFlags = typedef(VkFlags, "VkFenceImportFlags")
val VkSemaphoreImportFlags = typedef(VkFlags, "VkSemaphoreImportFlags")
val VkExternalSemaphoreHandleTypeFlags = typedef(VkFlags, "VkExternalSemaphoreHandleTypeFlags")
val VkExternalSemaphoreFeatureFlags = typedef(VkFlags, "VkExternalSemaphoreFeatureFlags")
val VkResolveModeFlags = typedef(VkFlags, "VkResolveModeFlags")
val VkDescriptorBindingFlags = typedef(VkFlags, "VkDescriptorBindingFlags")
val VkSemaphoreWaitFlags = typedef(VkFlags, "VkSemaphoreWaitFlags")
val VkPipelineCreationFeedbackFlags = typedef(VkFlags, "VkPipelineCreationFeedbackFlags")
val VkToolPurposeFlags = typedef(VkFlags, "VkToolPurposeFlags")
val VkPrivateDataSlotCreateFlags = typedef(VkFlags, "VkPrivateDataSlotCreateFlags")
val VkPipelineStageFlags2 = typedef(VkFlags64, "VkPipelineStageFlags2")
val VkAccessFlags2 = typedef(VkFlags64, "VkAccessFlags2")
val VkSubmitFlags = typedef(VkFlags, "VkSubmitFlags")
val VkRenderingFlags = typedef(VkFlags, "VkRenderingFlags")
val VkFormatFeatureFlags2 = typedef(VkFlags64, "VkFormatFeatureFlags2")
val VkMemoryUnmapFlags = typedef(VkFlags, "VkMemoryUnmapFlags")
val VkPipelineCreateFlags2 = typedef(VkFlags64, "VkPipelineCreateFlags2")
val VkBufferUsageFlags2 = typedef(VkFlags64, "VkBufferUsageFlags2")
val VkHostImageCopyFlags = typedef(VkFlags, "VkHostImageCopyFlags")

// Function pointer types
val PFN_vkAllocationFunction = Module.VULKAN.callback {
    void.p(
        "VkAllocationFunction",
        "Application-defined memory allocation function.",

        opaque_p("pUserData", "the value specified for ##VkAllocationCallbacks{@code ::pUserData} in the allocator specified by the application."),
        size_t("size", "the size in bytes of the requested allocation."),
        size_t("alignment", "the requested alignment of the allocation in bytes and <b>must</b> be a power of two."),
        VkSystemAllocationScope("allocationScope", "a {@code VkSystemAllocationScope} value specifying the allocation scope of the lifetime of the allocation, as described <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#memory-host-allocation-scope\">here</a>."),

        nativeType = "PFN_vkAllocationFunction"
    ) {
        documentation =
        """
        Application-defined memory allocation function.

        <h5>C Specification</h5>
        The type of {@code pfnAllocation} is:

        <pre><code>
￿typedef void* (VKAPI_PTR *PFN_vkAllocationFunction)(
￿    void*                                       pUserData,
￿    size_t                                      size,
￿    size_t                                      alignment,
￿    VkSystemAllocationScope                     allocationScope);</code></pre>

        <h5>Description</h5>
        If {@code pfnAllocation} is unable to allocate the requested memory, it <b>must</b> return {@code NULL}. If the allocation was successful, it <b>must</b> return a valid pointer to memory allocation containing at least {@code size} bytes, and with the pointer value being a multiple of {@code alignment}.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Correct Vulkan operation <b>cannot</b> be assumed if the application does not follow these rules.

        For example, {@code pfnAllocation} (or {@code pfnReallocation}) could cause termination of running Vulkan instance(s) on a failed allocation for debugging purposes, either directly or indirectly. In these circumstances, it <b>cannot</b> be assumed that any part of any affected {@code VkInstance} objects are going to operate correctly (even #DestroyInstance()), and the application <b>must</b> ensure it cleans up properly via other means (e.g. process termination).
        </div>

        If {@code pfnAllocation} returns {@code NULL}, and if the implementation is unable to continue correct processing of the current command without the requested allocation, it <b>must</b> treat this as a runtime error, and generate #ERROR_OUT_OF_HOST_MEMORY at the appropriate time for the command in which the condition was detected, as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#fundamentals-errorcodes">Return Codes</a>.

        If the implementation is able to continue correct processing of the current command without the requested allocation, then it <b>may</b> do so, and <b>must</b> not generate #ERROR_OUT_OF_HOST_MEMORY as a result of this failed allocation.

        <h5>See Also</h5>
        ##VkAllocationCallbacks
        """
    }
}

val PFN_vkFreeFunction = Module.VULKAN.callback {
    void(
        "VkFreeFunction",
        "Application-defined memory free function.",

        opaque_p("pUserData", "the value specified for ##VkAllocationCallbacks{@code ::pUserData} in the allocator specified by the application."),
        opaque_p("pMemory", "the allocation to be freed."),

        nativeType = "PFN_vkFreeFunction"
    ) {
        documentation =
        """
        Application-defined memory free function.

        <h5>C Specification</h5>
        The type of {@code pfnFree} is:

        <pre><code>
￿typedef void (VKAPI_PTR *PFN_vkFreeFunction)(
￿    void*                                       pUserData,
￿    void*                                       pMemory);</code></pre>

        <h5>Description</h5>
        {@code pMemory} <b>may</b> be {@code NULL}, which the callback <b>must</b> handle safely. If {@code pMemory} is non-{@code NULL}, it <b>must</b> be a pointer previously allocated by {@code pfnAllocation} or {@code pfnReallocation}. The application <b>should</b> free this memory.

        <h5>See Also</h5>
        ##VkAllocationCallbacks
        """
    }
}

val PFN_vkInternalAllocationNotification = Module.VULKAN.callback {
    void(
        "VkInternalAllocationNotification",
        "Application-defined memory allocation notification function.",

        opaque_p("pUserData", "the value specified for ##VkAllocationCallbacks{@code ::pUserData} in the allocator specified by the application."),
        size_t("size", "the requested size of an allocation."),
        VkInternalAllocationType("allocationType", "a {@code VkInternalAllocationType} value specifying the requested type of an allocation."),
        VkSystemAllocationScope("allocationScope", "a {@code VkSystemAllocationScope} value specifying the allocation scope of the lifetime of the allocation, as described <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#memory-host-allocation-scope\">here</a>."),

        nativeType = "PFN_vkInternalAllocationNotification"
    ) {
        documentation =
        """
        Application-defined memory allocation notification function.

        <h5>C Specification</h5>
        The type of {@code pfnInternalAllocation} is:

        <pre><code>
￿typedef void (VKAPI_PTR *PFN_vkInternalAllocationNotification)(
￿    void*                                       pUserData,
￿    size_t                                      size,
￿    VkInternalAllocationType                    allocationType,
￿    VkSystemAllocationScope                     allocationScope);</code></pre>

        <h5>Description</h5>
        This is a purely informational callback.

        <h5>See Also</h5>
        ##VkAllocationCallbacks
        """
    }
}

val PFN_vkInternalFreeNotification = Module.VULKAN.callback {
    void(
        "VkInternalFreeNotification",
        "Application-defined memory free notification function.",

        opaque_p("pUserData", "the value specified for ##VkAllocationCallbacks{@code ::pUserData} in the allocator specified by the application."),
        size_t("size", "the requested size of an allocation."),
        VkInternalAllocationType("allocationType", "a {@code VkInternalAllocationType} value specifying the requested type of an allocation."),
        VkSystemAllocationScope("allocationScope", "a {@code VkSystemAllocationScope} value specifying the allocation scope of the lifetime of the allocation, as described <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#memory-host-allocation-scope\">here</a>."),

        nativeType = "PFN_vkInternalFreeNotification"
    ) {
        documentation =
        """
        Application-defined memory free notification function.

        <h5>C Specification</h5>
        The type of {@code pfnInternalFree} is:

        <pre><code>
￿typedef void (VKAPI_PTR *PFN_vkInternalFreeNotification)(
￿    void*                                       pUserData,
￿    size_t                                      size,
￿    VkInternalAllocationType                    allocationType,
￿    VkSystemAllocationScope                     allocationScope);</code></pre>

        <h5>Description</h5>
        This is a purely informational callback.

        <h5>See Also</h5>
        ##VkAllocationCallbacks
        """
    }
}

val PFN_vkReallocationFunction = Module.VULKAN.callback {
    void.p(
        "VkReallocationFunction",
        "Application-defined memory reallocation function.",

        opaque_p("pUserData", "the value specified for ##VkAllocationCallbacks{@code ::pUserData} in the allocator specified by the application."),
        opaque_p("pOriginal", "<b>must</b> be either {@code NULL} or a pointer previously returned by {@code pfnReallocation} or {@code pfnAllocation} of a compatible allocator."),
        size_t("size", "the size in bytes of the requested allocation."),
        size_t("alignment", "the requested alignment of the allocation in bytes and <b>must</b> be a power of two."),
        VkSystemAllocationScope("allocationScope", "a {@code VkSystemAllocationScope} value specifying the allocation scope of the lifetime of the allocation, as described <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#memory-host-allocation-scope\">here</a>."),

        nativeType = "PFN_vkReallocationFunction"
    ) {
        documentation =
        """
        Application-defined memory reallocation function.

        <h5>C Specification</h5>
        The type of {@code pfnReallocation} is:

        <pre><code>
￿typedef void* (VKAPI_PTR *PFN_vkReallocationFunction)(
￿    void*                                       pUserData,
￿    void*                                       pOriginal,
￿    size_t                                      size,
￿    size_t                                      alignment,
￿    VkSystemAllocationScope                     allocationScope);</code></pre>

        <h5>Description</h5>
        If the reallocation was successful, {@code pfnReallocation} <b>must</b> return an allocation with enough space for {@code size} bytes, and the contents of the original allocation from bytes zero to <code>min(original size, new size) - 1</code> <b>must</b> be preserved in the returned allocation. If {@code size} is larger than the old size, the contents of the additional space are undefined. If satisfying these requirements involves creating a new allocation, then the old allocation <b>should</b> be freed.

        If {@code pOriginal} is {@code NULL}, then {@code pfnReallocation} <b>must</b> behave equivalently to a call to ##VkAllocationFunction with the same parameter values (without {@code pOriginal}).

        If {@code size} is zero, then {@code pfnReallocation} <b>must</b> behave equivalently to a call to ##VkFreeFunction with the same {@code pUserData} parameter value, and {@code pMemory} equal to {@code pOriginal}.

        If {@code pOriginal} is non-{@code NULL}, the implementation <b>must</b> ensure that {@code alignment} is equal to the {@code alignment} used to originally allocate {@code pOriginal}.

        If this function fails and {@code pOriginal} is non-{@code NULL} the application <b>must</b> not free the old allocation.

        {@code pfnReallocation} <b>must</b> follow the same <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#vkAllocationFunction_return_rules">rules for return values as {@code PFN_vkAllocationFunction}</a>.

        <h5>See Also</h5>
        ##VkAllocationCallbacks
        """
    }
}

// Struct types
val VkExtent2D = struct(Module.VULKAN, "VkExtent2D") {
    documentation =
        """
        Structure specifying a two-dimensional extent.

        <h5>See Also</h5>
        ##VkDisplayModeParametersKHR, ##VkDisplayPlaneCapabilitiesKHR, ##VkDisplayPropertiesKHR, ##VkDisplaySurfaceCreateInfoKHR, ##VkFragmentShadingRateAttachmentInfoKHR, ##VkImageViewSampleWeightCreateInfoQCOM, ##VkMultisamplePropertiesEXT, ##VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM, ##VkPhysicalDeviceFragmentDensityMapPropertiesEXT, ##VkPhysicalDeviceFragmentShadingRateKHR, ##VkPhysicalDeviceFragmentShadingRatePropertiesKHR, ##VkPhysicalDeviceImageProcessing2PropertiesQCOM, ##VkPhysicalDeviceImageProcessingPropertiesQCOM, ##VkPhysicalDeviceRenderPassStripedPropertiesARM, ##VkPhysicalDeviceSampleLocationsPropertiesEXT, ##VkPhysicalDeviceShadingRateImagePropertiesNV, ##VkPipelineFragmentShadingRateStateCreateInfoKHR, ##VkRect2D, ##VkRectLayerKHR, ##VkRenderingFragmentShadingRateAttachmentInfoKHR, ##VkSampleLocationsInfoEXT, ##VkSamplerBlockMatchWindowCreateInfoQCOM, ##VkSurfaceCapabilities2EXT, ##VkSurfaceCapabilitiesKHR, ##VkSurfacePresentScalingCapabilitiesEXT, ##VkSwapchainCreateInfoKHR, ##VkTilePropertiesQCOM, ##VkVideoCapabilitiesKHR, ##VkVideoEncodeAV1CapabilitiesKHR, ##VkVideoEncodeCapabilitiesKHR, ##VkVideoEncodeH265CapabilitiesKHR, ##VkVideoEncodeQuantizationMapCapabilitiesKHR, ##VkVideoEncodeQuantizationMapInfoKHR, ##VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR, ##VkVideoFormatQuantizationMapPropertiesKHR, ##VkVideoPictureResourceInfoKHR, ##VkVideoSessionCreateInfoKHR, #CmdSetFragmentShadingRateKHR(), #GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(), #GetRenderAreaGranularity(), #GetRenderingAreaGranularity(), #GetRenderingAreaGranularityKHR()
        """

    uint32_t("width", "the width of the extent.")
    uint32_t("height", "the height of the extent.")
}

val VkExtent3D = struct(Module.VULKAN, "VkExtent3D") {
    documentation =
        """
        Structure specifying a three-dimensional extent.

        <h5>See Also</h5>
        ##VkBufferImageCopy, ##VkBufferImageCopy2, ##VkCopyMemoryToImageIndirectCommandNV, ##VkImageCopy, ##VkImageCopy2, ##VkImageCreateInfo, ##VkImageFormatProperties, ##VkImageResolve, ##VkImageResolve2, ##VkImageToMemoryCopy, ##VkMemoryToImageCopy, ##VkQueueFamilyProperties, ##VkSparseImageFormatProperties, ##VkSparseImageMemoryBind, ##VkTilePropertiesQCOM
        """

    uint32_t("width", "the width of the extent.")
    uint32_t("height", "the height of the extent.")
    uint32_t("depth", "the depth of the extent.")
}

val VkOffset2D = struct(Module.VULKAN, "VkOffset2D") {
    documentation =
        """
        Structure specifying a two-dimensional offset.

        <h5>See Also</h5>
        ##VkDisplayPlaneCapabilitiesKHR, ##VkImageViewSampleWeightCreateInfoQCOM, ##VkRect2D, ##VkRectLayerKHR, ##VkSubpassFragmentDensityMapOffsetEndInfoQCOM, ##VkTilePropertiesQCOM, ##VkVideoDecodeH264CapabilitiesKHR, ##VkVideoPictureResourceInfoKHR
        """

    int32_t("x", "the x offset.")
    int32_t("y", "the y offset.")
}

val VkOffset3D = struct(Module.VULKAN, "VkOffset3D") {
    documentation =
        """
        Structure specifying a three-dimensional offset.

        <h5>See Also</h5>
        ##VkBufferImageCopy, ##VkBufferImageCopy2, ##VkCopyMemoryToImageIndirectCommandNV, ##VkImageBlit, ##VkImageBlit2, ##VkImageCopy, ##VkImageCopy2, ##VkImageResolve, ##VkImageResolve2, ##VkImageToMemoryCopy, ##VkMemoryToImageCopy, ##VkSparseImageMemoryBind
        """

    int32_t("x", "the x offset.")
    int32_t("y", "the y offset.")
    int32_t("z", "the z offset.")
}

val VkRect2D = struct(Module.VULKAN, "VkRect2D") {
    documentation =
        """
        Structure specifying a two-dimensional subregion.

        <h5>See Also</h5>
        ##VkBindImageMemoryDeviceGroupInfo, ##VkClearRect, ##VkCommandBufferInheritanceRenderPassTransformInfoQCOM, ##VkDeviceGroupRenderPassBeginInfo, ##VkDisplayPresentInfoKHR, ##VkExtent2D, ##VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM, ##VkOffset2D, ##VkOpticalFlowExecuteInfoNV, ##VkPipelineDiscardRectangleStateCreateInfoEXT, ##VkPipelineViewportExclusiveScissorStateCreateInfoNV, ##VkPipelineViewportStateCreateInfo, ##VkRenderPassBeginInfo, ##VkRenderPassStripeInfoARM, ##VkRenderingInfo, #CmdSetDiscardRectangleEXT(), #CmdSetExclusiveScissorNV(), #CmdSetScissor(), #CmdSetScissorWithCount(), #CmdSetScissorWithCountEXT(), #GetPhysicalDevicePresentRectanglesKHR()
        """

    VkOffset2D("offset", "a ##VkOffset2D specifying the rectangle offset.")
    VkExtent2D("extent", "a ##VkExtent2D specifying the rectangle extent.")
}

val _VkBaseInStructure = struct(Module.VULKAN, "VkBaseInStructure")
val VkBaseInStructure = struct(Module.VULKAN, "VkBaseInStructure") {
    documentation =
        """
        Base structure for a read-only pointer chain.

        <h5>Description</h5>
        ##VkBaseInStructure can be used to facilitate iterating through a read-only structure pointer chain.

        <h5>See Also</h5>
        ##VkBaseInStructure
        """

    VkStructureType("sType", "the structure type of the structure being iterated through.")
    nullable.._VkBaseInStructure.const.p("pNext", "{@code NULL} or a pointer to the next structure in a structure chain.")
}

val _VkBaseOutStructure = struct(Module.VULKAN, "VkBaseOutStructure")
val VkBaseOutStructure = struct(Module.VULKAN, "VkBaseOutStructure") {
    documentation =
        """
        Base structure for a read-only pointer chain.

        <h5>Description</h5>
        ##VkBaseOutStructure can be used to facilitate iterating through a structure pointer chain that returns data back to the application.

        <h5>See Also</h5>
        ##VkBaseOutStructure, #GetPipelinePropertiesEXT()
        """

    VkStructureType("sType", "the structure type of the structure being iterated through.")
    nullable.._VkBaseOutStructure.p("pNext", "{@code NULL} or a pointer to the next structure in a structure chain.")
}

val VkBufferMemoryBarrier = struct(Module.VULKAN, "VkBufferMemoryBarrier") {
    documentation =
        """
        Structure specifying a buffer memory barrier.

        <h5>Description</h5>
        The first <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-access-scopes">access scope</a> is limited to access to memory through the specified buffer range, via access types in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-masks">source access mask</a> specified by {@code srcAccessMask}. If {@code srcAccessMask} includes #ACCESS_HOST_WRITE_BIT, a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-available-and-visible">memory domain operation</a> is performed where available memory in the host domain is also made available to the device domain.

        The second <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-access-scopes">access scope</a> is limited to access to memory through the specified buffer range, via access types in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-masks">destination access mask</a> specified by {@code dstAccessMask}. If {@code dstAccessMask} includes #ACCESS_HOST_WRITE_BIT or #ACCESS_HOST_READ_BIT, a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-available-and-visible">memory domain operation</a> is performed where available memory in the device domain is also made available to the host domain.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        When #MEMORY_PROPERTY_HOST_COHERENT_BIT is used, available memory in host domain is automatically made visible to host domain, and any host write is automatically made available to host domain.
        </div>

        If {@code srcQueueFamilyIndex} is not equal to {@code dstQueueFamilyIndex}, and {@code srcQueueFamilyIndex} is equal to the current queue family, then the memory barrier defines a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers-release">queue family release operation</a> for the specified buffer range, and the second synchronization scope of the calling command does not apply to this operation.

        If {@code dstQueueFamilyIndex} is not equal to {@code srcQueueFamilyIndex}, and {@code dstQueueFamilyIndex} is equal to the current queue family, then the memory barrier defines a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers-acquire">queue family acquire operation</a> for the specified buffer range, and the first synchronization scope of the calling command does not apply to this operation.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code offset} <b>must</b> be less than the size of {@code buffer}</li>
            <li>If {@code size} is not equal to #WHOLE_SIZE, {@code size} <b>must</b> be greater than 0</li>
            <li>If {@code size} is not equal to #WHOLE_SIZE, {@code size} <b>must</b> be less than or equal to than the size of {@code buffer} minus {@code offset}</li>
            <li>If {@code buffer} is non-sparse then it <b>must</b> be bound completely and contiguously to a single {@code VkDeviceMemory} object</li>
            <li>If {@code buffer} was created with a sharing mode of #SHARING_MODE_EXCLUSIVE, and {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} are not equal, {@code srcQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_EXTERNAL, #QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family</li>
            <li>If {@code buffer} was created with a sharing mode of #SHARING_MODE_EXCLUSIVE, and {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} are not equal, {@code dstQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_EXTERNAL, #QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family</li>
            <li>If {@code srcQueueFamilyIndex} is not equal to {@code dstQueueFamilyIndex}, at least one of {@code srcQueueFamilyIndex} or {@code dstQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_EXTERNAL or #QUEUE_FAMILY_FOREIGN_EXT</li>
            <li>If the {@link KHRExternalMemory VK_KHR_external_memory} extension is not enabled, and the value of ##VkApplicationInfo{@code ::apiVersion} used to create the {@code VkInstance} is not greater than or equal to Version 1.1, {@code srcQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_EXTERNAL</li>
            <li>If the {@link KHRExternalMemory VK_KHR_external_memory} extension is not enabled, and the value of ##VkApplicationInfo{@code ::apiVersion} used to create the {@code VkInstance} is not greater than or equal to Version 1.1, {@code dstQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_EXTERNAL</li>
            <li>If the {@link EXTQueueFamilyForeign VK_EXT_queue_family_foreign} extension is not enabled {@code srcQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_FOREIGN_EXT</li>
            <li>If the {@link EXTQueueFamilyForeign VK_EXT_queue_family_foreign} extension is not enabled {@code dstQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_FOREIGN_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, and {@code buffer} was created with a sharing mode of #SHARING_MODE_CONCURRENT, at least one of {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_IGNORED</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, and {@code buffer} was created with a sharing mode of #SHARING_MODE_CONCURRENT, {@code srcQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_IGNORED or #QUEUE_FAMILY_EXTERNAL</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, and {@code buffer} was created with a sharing mode of #SHARING_MODE_CONCURRENT, {@code dstQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_IGNORED or #QUEUE_FAMILY_EXTERNAL</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkExternalMemoryAcquireUnmodifiedEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
        </ul>

        <h5>See Also</h5>
        #CmdPipelineBarrier(), #CmdWaitEvents()
        """

    Expression("#STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkExternalMemoryAcquireUnmodifiedEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccessFlags("srcAccessMask", "a bitmask of {@code VkAccessFlagBits} specifying a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-access-masks\">source access mask</a>.")
    VkAccessFlags("dstAccessMask", "a bitmask of {@code VkAccessFlagBits} specifying a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-access-masks\">destination access mask</a>.")
    uint32_t("srcQueueFamilyIndex", "the source queue family for a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-queue-transfers\">queue family ownership transfer</a>.")
    uint32_t("dstQueueFamilyIndex", "the destination queue family for a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-queue-transfers\">queue family ownership transfer</a>.")
    VkBuffer("buffer", "a handle to the buffer whose backing memory is affected by the barrier.")
    VkDeviceSize("offset", "an offset in bytes into the backing memory for {@code buffer}; this is relative to the base offset as bound to the buffer (see #BindBufferMemory()).")
    VkDeviceSize("size", "a size in bytes of the affected area of backing memory for {@code buffer}, or #WHOLE_SIZE to use the range from {@code offset} to the end of the buffer.")
}

val VkDispatchIndirectCommand = struct(Module.VULKAN, "VkDispatchIndirectCommand") {
    documentation =
        """
        Structure specifying an indirect dispatching command.

        <h5>Description</h5>
        The members of ##VkDispatchIndirectCommand have the same meaning as the corresponding parameters of #CmdDispatch().

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code x} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxComputeWorkGroupCount}[0]</li>
            <li>{@code y} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxComputeWorkGroupCount}[1]</li>
            <li>{@code z} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxComputeWorkGroupCount}[2]</li>
        </ul>

        <h5>See Also</h5>
        #CmdDispatchIndirect()
        """

    uint32_t("x", "the number of local workgroups to dispatch in the X dimension.")
    uint32_t("y", "the number of local workgroups to dispatch in the Y dimension.")
    uint32_t("z", "the number of local workgroups to dispatch in the Z dimension.")
}

val VkDrawIndexedIndirectCommand = struct(Module.VULKAN, "VkDrawIndexedIndirectCommand") {
    documentation =
        """
        Structure specifying an indexed indirect drawing command.

        <h5>Description</h5>
        The members of ##VkDrawIndexedIndirectCommand have the same meaning as the similarly named parameters of #CmdDrawIndexed().

        <h5>Valid Usage</h5>
        <ul>
            <li>If the bound graphics pipeline state was created with ##VkPipelineVertexInputDivisorStateCreateInfo in the {@code pNext} chain of ##VkGraphicsPipelineCreateInfo{@code ::pVertexInputState}, any member of ##VkPipelineVertexInputDivisorStateCreateInfo{@code ::pVertexBindingDivisors} has a value other than 1 in {@code divisor}, and ##VkPhysicalDeviceVertexAttributeDivisorProperties{@code ::supportsNonZeroFirstInstance} is #FALSE, then {@code firstInstance} <b>must</b> be 0</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#shaders-objects">shader objects</a> are used for drawing or the bound graphics pipeline state was created with the #DYNAMIC_STATE_VERTEX_INPUT_EXT dynamic state enabled, any member of the {@code pVertexBindingDescriptions} parameter to the #CmdSetVertexInputEXT() call that sets this dynamic state has a value other than 1 in {@code divisor}, and ##VkPhysicalDeviceVertexAttributeDivisorProperties{@code ::supportsNonZeroFirstInstance} is #FALSE, then {@code firstInstance} <b>must</b> be 0</li>
        </ul>

        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is not enabled, <code>(indexSize × (firstIndex + indexCount) + offset)</code> <b>must</b> be less than or equal to the size of the bound index buffer, with {@code indexSize} being based on the type specified by {@code indexType}, where the index buffer, {@code indexType}, and {@code offset} are specified via {@code vkCmdBindIndexBuffer} or {@code vkCmdBindIndexBuffer2}. If {@code vkCmdBindIndexBuffer2} is used to bind the index buffer, the size of the bound index buffer is #CmdBindIndexBuffer2(){@code ::size}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-drawIndirectFirstInstance">{@code drawIndirectFirstInstance}</a> feature is not enabled, {@code firstInstance} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CmdDrawIndexedIndirect()
        """

    uint32_t("indexCount", "the number of vertices to draw.")
    uint32_t("instanceCount", "the number of instances to draw.")
    uint32_t("firstIndex", "the base index within the index buffer.")
    int32_t("vertexOffset", "the value added to the vertex index before indexing into the vertex buffer.")
    uint32_t("firstInstance", "the instance ID of the first instance to draw.")
}

val VkDrawIndirectCommand = struct(Module.VULKAN, "VkDrawIndirectCommand") {
    documentation =
        """
        Structure specifying an indirect drawing command.

        <h5>Description</h5>
        The members of ##VkDrawIndirectCommand have the same meaning as the similarly named parameters of #CmdDraw().

        <h5>Valid Usage</h5>
        <ul>
            <li>If the bound graphics pipeline state was created with ##VkPipelineVertexInputDivisorStateCreateInfo in the {@code pNext} chain of ##VkGraphicsPipelineCreateInfo{@code ::pVertexInputState}, any member of ##VkPipelineVertexInputDivisorStateCreateInfo{@code ::pVertexBindingDivisors} has a value other than 1 in {@code divisor}, and ##VkPhysicalDeviceVertexAttributeDivisorProperties{@code ::supportsNonZeroFirstInstance} is #FALSE, then {@code firstInstance} <b>must</b> be 0</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#shaders-objects">shader objects</a> are used for drawing or the bound graphics pipeline state was created with the #DYNAMIC_STATE_VERTEX_INPUT_EXT dynamic state enabled, any member of the {@code pVertexBindingDescriptions} parameter to the #CmdSetVertexInputEXT() call that sets this dynamic state has a value other than 1 in {@code divisor}, and ##VkPhysicalDeviceVertexAttributeDivisorProperties{@code ::supportsNonZeroFirstInstance} is #FALSE, then {@code firstInstance} <b>must</b> be 0</li>
        </ul>

        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-drawIndirectFirstInstance">{@code drawIndirectFirstInstance}</a> feature is not enabled, {@code firstInstance} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CmdDrawIndirect()
        """

    uint32_t("vertexCount", "the number of vertices to draw.")
    uint32_t("instanceCount", "the number of instances to draw.")
    uint32_t("firstVertex", "the index of the first vertex to draw.")
    uint32_t("firstInstance", "the instance ID of the first instance to draw.")
}

val VkImageSubresourceRange = struct(Module.VULKAN, "VkImageSubresourceRange") {
    documentation =
        """
        Structure specifying an image subresource range.

        <h5>Description</h5>
        The number of mipmap levels and array layers <b>must</b> be a subset of the image subresources in the image. If an application wants to use all mip levels or layers in an image after the {@code baseMipLevel} or {@code baseArrayLayer}, it <b>can</b> set {@code levelCount} and {@code layerCount} to the special values #REMAINING_MIP_LEVELS and #REMAINING_ARRAY_LAYERS without knowing the exact number of mip levels or layers.

        For cube and cube array image views, the layers of the image view starting at {@code baseArrayLayer} correspond to faces in the order +X, -X, +Y, -Y, +Z, -Z. For cube arrays, each set of six sequential layers is a single cube, so the number of cube maps in a cube map array view is <em>{@code layerCount} / 6</em>, and image array layer <code>(baseArrayLayer + i)</code> is face index <code>(i mod 6)</code> of cube <em>i / 6</em>. If the number of layers in the view, whether set explicitly in {@code layerCount} or implied by #REMAINING_ARRAY_LAYERS, is not a multiple of 6, the last cube map in the array <b>must</b> not be accessed.

        {@code aspectMask} <b>must</b> be only #IMAGE_ASPECT_COLOR_BIT, #IMAGE_ASPECT_DEPTH_BIT or #IMAGE_ASPECT_STENCIL_BIT if {@code format} is a color, depth-only or stencil-only format, respectively, except if {@code format} is a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar format</a>. If using a depth/stencil format with both depth and stencil components, {@code aspectMask} <b>must</b> include at least one of #IMAGE_ASPECT_DEPTH_BIT and #IMAGE_ASPECT_STENCIL_BIT, and <b>can</b> include both.

        When the ##VkImageSubresourceRange structure is used to select a subset of the slices of a 3D image’s mip level in order to create a 2D or 2D array image view of a 3D image created with #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, {@code baseArrayLayer} and {@code layerCount} specify the first slice index and the number of slices to include in the created image view. Such an image view <b>can</b> be used as a framebuffer attachment that refers only to the specified range of slices of the selected mip level. However, any layout transitions performed on such an attachment view during a render pass instance still apply to the entire subresource referenced which includes all the slices of the selected mip level.

        When using an image view of a depth/stencil image to populate a descriptor set (e.g. for sampling in the shader, or for use as an input attachment), the {@code aspectMask} <b>must</b> only include one bit, which selects whether the image view is used for depth reads (i.e. using a floating-point sampler or input attachment in the shader) or stencil reads (i.e. using an unsigned integer sampler or input attachment in the shader). When an image view of a depth/stencil image is used as a depth/stencil framebuffer attachment, the {@code aspectMask} is ignored and both depth and stencil image subresources are used.

        When creating a {@code VkImageView}, if <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> is enabled in the sampler, the {@code aspectMask} of a {@code subresourceRange} used by the {@code VkImageView} <b>must</b> be #IMAGE_ASPECT_COLOR_BIT.

        When creating a {@code VkImageView}, if sampler Y′C<sub>B</sub>C<sub>R</sub> conversion is not enabled in the sampler and the image {@code format} is <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a>, the image <b>must</b> have been created with #IMAGE_CREATE_MUTABLE_FORMAT_BIT, and the {@code aspectMask} of the {@code VkImageView}’s {@code subresourceRange} <b>must</b> be #IMAGE_ASPECT_PLANE_0_BIT, #IMAGE_ASPECT_PLANE_1_BIT or #IMAGE_ASPECT_PLANE_2_BIT.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code levelCount} is not #REMAINING_MIP_LEVELS, it <b>must</b> be greater than 0</li>
            <li>If {@code layerCount} is not #REMAINING_ARRAY_LAYERS, it <b>must</b> be greater than 0</li>
            <li>If {@code aspectMask} includes #IMAGE_ASPECT_COLOR_BIT, then it <b>must</b> not include any of #IMAGE_ASPECT_PLANE_0_BIT, #IMAGE_ASPECT_PLANE_1_BIT, or #IMAGE_ASPECT_PLANE_2_BIT</li>
            <li>{@code aspectMask} <b>must</b> not include <code>VK_IMAGE_ASPECT_MEMORY_PLANE<em>_i_</em>BIT_EXT</code> for any index <em>i</em></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code aspectMask} <b>must</b> be a valid combination of {@code VkImageAspectFlagBits} values</li>
            <li>{@code aspectMask} <b>must</b> not be 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkHostImageLayoutTransitionInfo, ##VkImageMemoryBarrier, ##VkImageMemoryBarrier2, ##VkImageViewCreateInfo, #CmdClearColorImage(), #CmdClearDepthStencilImage()
        """

    VkImageAspectFlags("aspectMask", "a bitmask of {@code VkImageAspectFlagBits} specifying which aspect(s) of the image are included in the view.")
    uint32_t("baseMipLevel", "the first mipmap level accessible to the view.")
    uint32_t("levelCount", "the number of mipmap levels (starting from {@code baseMipLevel}) accessible to the view.")
    uint32_t("baseArrayLayer", "the first array layer accessible to the view.")
    uint32_t("layerCount", "the number of array layers (starting from {@code baseArrayLayer}) accessible to the view.")
}

val VkImageMemoryBarrier = struct(Module.VULKAN, "VkImageMemoryBarrier") {
    documentation =
        """
        Structure specifying the parameters of an image memory barrier.

        <h5>Description</h5>
        The first <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-access-scopes">access scope</a> is limited to access to memory through the specified image subresource range, via access types in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-masks">source access mask</a> specified by {@code srcAccessMask}. If {@code srcAccessMask} includes #ACCESS_HOST_WRITE_BIT, memory writes performed by that access type are also made visible, as that access type is not performed through a resource.

        The second <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-access-scopes">access scope</a> is limited to access to memory through the specified image subresource range, via access types in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-masks">destination access mask</a> specified by {@code dstAccessMask}. If {@code dstAccessMask} includes #ACCESS_HOST_WRITE_BIT or #ACCESS_HOST_READ_BIT, available memory writes are also made visible to accesses of those types, as those access types are not performed through a resource.

        If {@code srcQueueFamilyIndex} is not equal to {@code dstQueueFamilyIndex}, and {@code srcQueueFamilyIndex} is equal to the current queue family, then the memory barrier defines a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers-release">queue family release operation</a> for the specified image subresource range, and the second synchronization scope of the calling command does not apply to this operation.

        If {@code dstQueueFamilyIndex} is not equal to {@code srcQueueFamilyIndex}, and {@code dstQueueFamilyIndex} is equal to the current queue family, then the memory barrier defines a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers-acquire">queue family acquire operation</a> for the specified image subresource range, and the first synchronization scope of the calling command does not apply to this operation.

        If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled or {@code oldLayout} is not equal to {@code newLayout}, {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a> for the specified image subresource range.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is enabled, when the old and new layout are equal, the layout values are ignored - data is preserved no matter what values are specified, or what layout the image is currently in.
        </div>

        If {@code image} has a multi-planar format and the image is <em>disjoint</em>, then including #IMAGE_ASPECT_COLOR_BIT in the {@code aspectMask} member of {@code subresourceRange} is equivalent to including #IMAGE_ASPECT_PLANE_0_BIT, #IMAGE_ASPECT_PLANE_1_BIT, and (for three-plane formats only) #IMAGE_ASPECT_PLANE_2_BIT.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_COLOR_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_SAMPLED_BIT or #IMAGE_USAGE_INPUT_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_TRANSFER_SRC_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_TRANSFER_DST_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, {@code oldLayout} <b>must</b> be #IMAGE_LAYOUT_UNDEFINED or the current layout of the image subresources affected by the barrier</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, {@code newLayout} <b>must</b> not be #IMAGE_LAYOUT_UNDEFINED or #IMAGE_LAYOUT_PREINITIALIZED</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL then {@code image} <b>must</b> have been created with at least one of #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, #IMAGE_USAGE_SAMPLED_BIT, or #IMAGE_USAGE_INPUT_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL then {@code image} <b>must</b> have been created with at least one of #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, #IMAGE_USAGE_SAMPLED_BIT, or #IMAGE_USAGE_INPUT_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL then {@code image} <b>must</b> have been created with #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, {@code oldLayout} <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or #IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, {@code newLayout} <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or #IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_ATTACHMENT_OPTIMAL, {@code image} <b>must</b> have been created with #IMAGE_USAGE_COLOR_ATTACHMENT_BIT or #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_READ_ONLY_OPTIMAL, {@code image} <b>must</b> have been created with at least one of #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, #IMAGE_USAGE_SAMPLED_BIT, or #IMAGE_USAGE_INPUT_ATTACHMENT_BIT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR then {@code image} <b>must</b> have been created with #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR set</li>
            <li>If {@code image} was created with a sharing mode of #SHARING_MODE_EXCLUSIVE, and {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} are not equal, {@code srcQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_EXTERNAL, #QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family</li>
            <li>If {@code image} was created with a sharing mode of #SHARING_MODE_EXCLUSIVE, and {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} are not equal, {@code dstQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_EXTERNAL, #QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family</li>
            <li>If {@code srcQueueFamilyIndex} is not equal to {@code dstQueueFamilyIndex}, at least one of {@code srcQueueFamilyIndex} or {@code dstQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_EXTERNAL or #QUEUE_FAMILY_FOREIGN_EXT</li>
            <li>If the {@link KHRExternalMemory VK_KHR_external_memory} extension is not enabled, and the value of ##VkApplicationInfo{@code ::apiVersion} used to create the {@code VkInstance} is not greater than or equal to Version 1.1, {@code srcQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_EXTERNAL</li>
            <li>If the {@link KHRExternalMemory VK_KHR_external_memory} extension is not enabled, and the value of ##VkApplicationInfo{@code ::apiVersion} used to create the {@code VkInstance} is not greater than or equal to Version 1.1, {@code dstQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_EXTERNAL</li>
            <li>If the {@link EXTQueueFamilyForeign VK_EXT_queue_family_foreign} extension is not enabled {@code srcQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_FOREIGN_EXT</li>
            <li>If the {@link EXTQueueFamilyForeign VK_EXT_queue_family_foreign} extension is not enabled {@code dstQueueFamilyIndex} <b>must</b> not be #QUEUE_FAMILY_FOREIGN_EXT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR then {@code image} <b>must</b> have been created with #IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR then {@code image} <b>must</b> have been created with #IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR then {@code image} <b>must</b> have been created with #IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR then {@code image} <b>must</b> have been created with #IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR then {@code image} <b>must</b> have been created with #IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR then {@code image} <b>must</b> have been created with #IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_VIDEO_ENCODE_QUANTIZATION_MAP_KHR then {@code image} <b>must</b> have been created with #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT then {@code image} <b>must</b> have been created with either the #IMAGE_USAGE_COLOR_ATTACHMENT_BIT or #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT usage bits, and the #IMAGE_USAGE_INPUT_ATTACHMENT_BIT or #IMAGE_USAGE_SAMPLED_BIT usage bits, and the #IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT usage bit</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFeedbackLoopLayout">{@code attachmentFeedbackLoopLayout}</a> feature is not enabled, {@code newLayout} <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT</li>
            <li>If {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-queue-transfers">queue family ownership transfer</a> or {@code oldLayout} and {@code newLayout} define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-image-layout-transitions">image layout transition</a>, and {@code oldLayout} or {@code newLayout} is #IMAGE_LAYOUT_RENDERING_LOCAL_READ then {@code image} <b>must</b> have been created with either #IMAGE_USAGE_STORAGE_BIT, or with both #IMAGE_USAGE_INPUT_ATTACHMENT_BIT and either of #IMAGE_USAGE_COLOR_ATTACHMENT_BIT or #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRenderingLocalRead">{@code dynamicRenderingLocalRead}</a> feature is not enabled, {@code oldLayout} <b>must</b> not be #IMAGE_LAYOUT_RENDERING_LOCAL_READ</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRenderingLocalRead">{@code dynamicRenderingLocalRead}</a> feature is not enabled, {@code newLayout} <b>must</b> not be #IMAGE_LAYOUT_RENDERING_LOCAL_READ</li>
        </ul>

        <ul>
            <li>{@code subresourceRange.baseMipLevel} <b>must</b> be less than the {@code mipLevels} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>If {@code subresourceRange.levelCount} is not #REMAINING_MIP_LEVELS, <code>subresourceRange.baseMipLevel + subresourceRange.levelCount</code> <b>must</b> be less than or equal to the {@code mipLevels} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>{@code subresourceRange.baseArrayLayer} <b>must</b> be less than the {@code arrayLayers} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>If {@code subresourceRange.layerCount} is not #REMAINING_ARRAY_LAYERS, <code>subresourceRange.baseArrayLayer + subresourceRange.layerCount</code> <b>must</b> be less than or equal to the {@code arrayLayers} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>If {@code image} is non-sparse then it <b>must</b> be bound completely and contiguously to a single {@code VkDeviceMemory} object</li>
            <li>If {@code image} has a color format that is single-plane, then the {@code aspectMask} member of {@code subresourceRange} <b>must</b> be #IMAGE_ASPECT_COLOR_BIT</li>
            <li>If {@code image} has a color format and is not <em>disjoint</em>, then the {@code aspectMask} member of {@code subresourceRange} <b>must</b> be #IMAGE_ASPECT_COLOR_BIT</li>
            <li>If {@code image} has a multi-planar format and the image is <em>disjoint</em>, then the {@code aspectMask} member of {@code subresourceRange} <b>must</b> include at least one <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-planes-image-aspect">multi-planar aspect mask</a> bit or #IMAGE_ASPECT_COLOR_BIT</li>
            <li>If {@code image} has a depth/stencil format with both depth and stencil and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-separateDepthStencilLayouts">{@code separateDepthStencilLayouts}</a> feature is not enabled, then the {@code aspectMask} member of {@code subresourceRange} <b>must</b> include both #IMAGE_ASPECT_DEPTH_BIT and #IMAGE_ASPECT_STENCIL_BIT</li>
            <li>If {@code image} has a depth/stencil format with both depth and stencil and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-separateDepthStencilLayouts">{@code separateDepthStencilLayouts}</a> feature is enabled, then the {@code aspectMask} member of {@code subresourceRange} <b>must</b> include either or both #IMAGE_ASPECT_DEPTH_BIT and #IMAGE_ASPECT_STENCIL_BIT</li>
            <li>If the {@code aspectMask} member of {@code subresourceRange} includes #IMAGE_ASPECT_DEPTH_BIT, {@code oldLayout} and {@code newLayout} <b>must</b> not be one of #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If the {@code aspectMask} member of {@code subresourceRange} includes #IMAGE_ASPECT_STENCIL_BIT, {@code oldLayout} and {@code newLayout} <b>must</b> not be one of #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL</li>
            <li>{@code subresourceRange.aspectMask} <b>must</b> be valid for the {@code format} the {@code image} was created with</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, and {@code image} was created with a sharing mode of #SHARING_MODE_CONCURRENT, at least one of {@code srcQueueFamilyIndex} and {@code dstQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_IGNORED</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, and {@code image} was created with a sharing mode of #SHARING_MODE_CONCURRENT, {@code srcQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_IGNORED or #QUEUE_FAMILY_EXTERNAL</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, and {@code image} was created with a sharing mode of #SHARING_MODE_CONCURRENT, {@code dstQueueFamilyIndex} <b>must</b> be #QUEUE_FAMILY_IGNORED or #QUEUE_FAMILY_EXTERNAL</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkExternalMemoryAcquireUnmodifiedEXT or ##VkSampleLocationsInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code oldLayout} <b>must</b> be a valid {@code VkImageLayout} value</li>
            <li>{@code newLayout} <b>must</b> be a valid {@code VkImageLayout} value</li>
            <li>{@code image} <b>must</b> be a valid {@code VkImage} handle</li>
            <li>{@code subresourceRange} <b>must</b> be a valid ##VkImageSubresourceRange structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkImageSubresourceRange, #CmdPipelineBarrier(), #CmdWaitEvents()
        """

    Expression("#STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkExternalMemoryAcquireUnmodifiedEXT", "VkSampleLocationsInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccessFlags("srcAccessMask", "a bitmask of {@code VkAccessFlagBits} specifying a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-access-masks\">source access mask</a>.")
    VkAccessFlags("dstAccessMask", "a bitmask of {@code VkAccessFlagBits} specifying a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-access-masks\">destination access mask</a>.")
    VkImageLayout("oldLayout", "the old layout in an <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-image-layout-transitions\">image layout transition</a>.")
    VkImageLayout("newLayout", "the new layout in an <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-image-layout-transitions\">image layout transition</a>.")
    uint32_t("srcQueueFamilyIndex", "the source queue family for a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-queue-transfers\">queue family ownership transfer</a>.")
    uint32_t("dstQueueFamilyIndex", "the destination queue family for a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-queue-transfers\">queue family ownership transfer</a>.")
    VkImage("image", "a handle to the image affected by this barrier.")
    VkImageSubresourceRange("subresourceRange", "describes the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#resources-image-views\">image subresource range</a> within {@code image} that is affected by this barrier.")
}

val VkMemoryBarrier = struct(Module.VULKAN, "VkMemoryBarrier") {
    documentation =
        """
        Structure specifying a global memory barrier.

        <h5>Description</h5>
        The first <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-access-scopes">access scope</a> is limited to access types in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-masks">source access mask</a> specified by {@code srcAccessMask}.

        The second <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-access-scopes">access scope</a> is limited to access types in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-masks">destination access mask</a> specified by {@code dstAccessMask}.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MEMORY_BARRIER</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code srcAccessMask} <b>must</b> be a valid combination of {@code VkAccessFlagBits} values</li>
            <li>{@code dstAccessMask} <b>must</b> be a valid combination of {@code VkAccessFlagBits} values</li>
        </ul>

        <h5>See Also</h5>
        #CmdPipelineBarrier(), #CmdWaitEvents()
        """

    Expression("#STRUCTURE_TYPE_MEMORY_BARRIER")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccessFlags("srcAccessMask", "a bitmask of {@code VkAccessFlagBits} specifying a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-access-masks\">source access mask</a>.")
    VkAccessFlags("dstAccessMask", "a bitmask of {@code VkAccessFlagBits} specifying a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-access-masks\">destination access mask</a>.")
}

val VkPipelineCacheHeaderVersionOne = struct(Module.VULKAN, "VkPipelineCacheHeaderVersionOne") {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation =
        """
        Structure describing the layout of the pipeline cache header.

        <h5>Description</h5>
        Unlike most structures declared by the Vulkan API, all fields of this structure are written with the least significant byte first, regardless of host byte-order.

        The C language specification does not define the packing of structure members. This layout assumes tight structure member packing, with members laid out in the order listed in the structure, and the intended size of the structure is 32 bytes. If a compiler produces code that diverges from that pattern, applications <b>must</b> employ another method to set values at the correct offsets.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code headerSize} <b>must</b> be 32</li>
            <li>{@code headerVersion} <b>must</b> be #PIPELINE_CACHE_HEADER_VERSION_ONE</li>
            <li>{@code headerSize} <b>must</b> not exceed the size of the pipeline cache</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code headerVersion} <b>must</b> be a valid {@code VkPipelineCacheHeaderVersion} value</li>
        </ul>
        """

    uint32_t("headerSize", "the length in bytes of the pipeline cache header.")
    VkPipelineCacheHeaderVersion("headerVersion", "a {@code VkPipelineCacheHeaderVersion} value specifying the version of the header. A consumer of the pipeline cache <b>should</b> use the cache version to interpret the remainder of the cache header.")
    uint32_t("vendorID", "the ##VkPhysicalDeviceProperties{@code ::vendorID} of the implementation.")
    uint32_t("deviceID", "the ##VkPhysicalDeviceProperties{@code ::deviceID} of the implementation.")
    uint8_t("pipelineCacheUUID", "the ##VkPhysicalDeviceProperties{@code ::pipelineCacheUUID} of the implementation.")["VK_UUID_SIZE"]
}

val VkAllocationCallbacks = struct(Module.VULKAN, "VkAllocationCallbacks") {
    documentation =
        """
        Structure containing callback function pointers for memory allocation.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code pfnAllocation} <b>must</b> be a valid pointer to a valid application-defined ##VkAllocationFunction</li>
            <li>{@code pfnReallocation} <b>must</b> be a valid pointer to a valid application-defined ##VkReallocationFunction</li>
            <li>{@code pfnFree} <b>must</b> be a valid pointer to a valid application-defined ##VkFreeFunction</li>
            <li>If either of {@code pfnInternalAllocation} or {@code pfnInternalFree} is not {@code NULL}, both <b>must</b> be valid callbacks</li>
        </ul>

        <h5>See Also</h5>
        ##VkAllocationFunction, ##VkFreeFunction, ##VkInternalAllocationNotification, ##VkInternalFreeNotification, ##VkReallocationFunction, #AllocateMemory(), #CreateAccelerationStructureKHR(), #CreateAccelerationStructureNV(), #CreateAndroidSurfaceKHR(), #CreateBuffer(), #CreateBufferView(), #CreateCommandPool(), #CreateComputePipelines(), #CreateCuFunctionNVX(), #CreateCuModuleNVX(), #CreateCudaFunctionNV(), #CreateCudaModuleNV(), #CreateDebugReportCallbackEXT(), #CreateDebugUtilsMessengerEXT(), #CreateDeferredOperationKHR(), #CreateDescriptorPool(), #CreateDescriptorSetLayout(), #CreateDescriptorUpdateTemplate(), #CreateDescriptorUpdateTemplateKHR(), #CreateDevice(), #CreateDirectFBSurfaceEXT(), #CreateDisplayModeKHR(), #CreateDisplayPlaneSurfaceKHR(), #CreateEvent(), #CreateExecutionGraphPipelinesAMDX(), #CreateFence(), #CreateFramebuffer(), #CreateGraphicsPipelines(), #CreateHeadlessSurfaceEXT(), #CreateImage(), #CreateImageView(), #CreateIndirectCommandsLayoutEXT(), #CreateIndirectCommandsLayoutNV(), #CreateIndirectExecutionSetEXT(), #CreateInstance(), #CreateMacOSSurfaceMVK(), #CreateMetalSurfaceEXT(), #CreateMicromapEXT(), #CreateOpticalFlowSessionNV(), #CreatePipelineBinariesKHR(), #CreatePipelineCache(), #CreatePipelineLayout(), #CreatePrivateDataSlot(), #CreatePrivateDataSlotEXT(), #CreateQueryPool(), #CreateRayTracingPipelinesKHR(), #CreateRayTracingPipelinesNV(), #CreateRenderPass(), #CreateRenderPass2(), #CreateRenderPass2KHR(), #CreateSampler(), #CreateSamplerYcbcrConversion(), #CreateSamplerYcbcrConversionKHR(), #CreateSemaphore(), #CreateShaderModule(), #CreateShadersEXT(), #CreateSharedSwapchainsKHR(), #CreateSwapchainKHR(), #CreateValidationCacheEXT(), #CreateVideoSessionKHR(), #CreateVideoSessionParametersKHR(), #CreateWaylandSurfaceKHR(), #CreateWin32SurfaceKHR(), #CreateXcbSurfaceKHR(), #CreateXlibSurfaceKHR(), #DestroyAccelerationStructureKHR(), #DestroyAccelerationStructureNV(), #DestroyBuffer(), #DestroyBufferView(), #DestroyCommandPool(), #DestroyCuFunctionNVX(), #DestroyCuModuleNVX(), #DestroyCudaFunctionNV(), #DestroyCudaModuleNV(), #DestroyDebugReportCallbackEXT(), #DestroyDebugUtilsMessengerEXT(), #DestroyDeferredOperationKHR(), #DestroyDescriptorPool(), #DestroyDescriptorSetLayout(), #DestroyDescriptorUpdateTemplate(), #DestroyDescriptorUpdateTemplateKHR(), #DestroyDevice(), #DestroyEvent(), #DestroyFence(), #DestroyFramebuffer(), #DestroyImage(), #DestroyImageView(), #DestroyIndirectCommandsLayoutEXT(), #DestroyIndirectCommandsLayoutNV(), #DestroyIndirectExecutionSetEXT(), #DestroyInstance(), #DestroyMicromapEXT(), #DestroyOpticalFlowSessionNV(), #DestroyPipeline(), #DestroyPipelineBinaryKHR(), #DestroyPipelineCache(), #DestroyPipelineLayout(), #DestroyPrivateDataSlot(), #DestroyPrivateDataSlotEXT(), #DestroyQueryPool(), #DestroyRenderPass(), #DestroySampler(), #DestroySamplerYcbcrConversion(), #DestroySamplerYcbcrConversionKHR(), #DestroySemaphore(), #DestroyShaderEXT(), #DestroyShaderModule(), #DestroySurfaceKHR(), #DestroySwapchainKHR(), #DestroyValidationCacheEXT(), #DestroyVideoSessionKHR(), #DestroyVideoSessionParametersKHR(), #FreeMemory(), #RegisterDeviceEventEXT(), #RegisterDisplayEventEXT(), #ReleaseCapturedPipelineDataKHR()
        """

    nullable..opaque_p("pUserData", "a value to be interpreted by the implementation of the callbacks. When any of the callbacks in ##VkAllocationCallbacks are called, the Vulkan implementation will pass this value as the first parameter to the callback. This value <b>can</b> vary each time an allocator is passed into a command, even when the same object takes an allocator in multiple commands.")
    nullable..PFN_vkAllocationFunction("pfnAllocation", "a ##VkAllocationFunction pointer to an application-defined memory allocation function.")
    nullable..PFN_vkReallocationFunction("pfnReallocation", "a ##VkReallocationFunction pointer to an application-defined memory reallocation function.")
    nullable..PFN_vkFreeFunction("pfnFree", "a ##VkFreeFunction pointer to an application-defined memory free function.")
    nullable..PFN_vkInternalAllocationNotification("pfnInternalAllocation", "a ##VkInternalAllocationNotification pointer to an application-defined function that is called by the implementation when the implementation makes internal allocations.")
    nullable..PFN_vkInternalFreeNotification("pfnInternalFree", "a ##VkInternalFreeNotification pointer to an application-defined function that is called by the implementation when the implementation frees internal allocations.")
}

val VkApplicationInfo = struct(Module.VULKAN, "VkApplicationInfo") {
    documentation =
        """
        Structure specifying application information.

        <h5>Description</h5>
        Vulkan 1.0 implementations were required to return #ERROR_INCOMPATIBLE_DRIVER if {@code apiVersion} was larger than 1.0. Implementations that support Vulkan 1.1 or later <b>must</b> not return #ERROR_INCOMPATIBLE_DRIVER for any value of {@code apiVersion} .

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Because Vulkan 1.0 implementations <b>may</b> fail with #ERROR_INCOMPATIBLE_DRIVER, applications <b>should</b> determine the version of Vulkan available before calling #CreateInstance(). If the #GetInstanceProcAddr() returns {@code NULL} for #EnumerateInstanceVersion(), it is a Vulkan 1.0 implementation. Otherwise, the application <b>can</b> call #EnumerateInstanceVersion() to determine the version of Vulkan.
        </div>

        As long as the instance supports at least Vulkan 1.1, an application <b>can</b> use different versions of Vulkan with an instance than it does with a device or physical device.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The Khronos validation layers will treat {@code apiVersion} as the highest API version the application targets, and will validate API usage against the minimum of that version and the implementation version (instance or device, depending on context). If an application tries to use functionality from a greater version than this, a validation error will be triggered.

        For example, if the instance supports Vulkan 1.1 and three physical devices support Vulkan 1.0, Vulkan 1.1, and Vulkan 1.2, respectively, and if the application sets {@code apiVersion} to 1.2, the application <b>can</b> use the following versions of Vulkan:

        <ul>
            <li>Vulkan 1.0 <b>can</b> be used with the instance and with all physical devices.</li>
            <li>Vulkan 1.1 <b>can</b> be used with the instance and with the physical devices that support Vulkan 1.1 and Vulkan 1.2.</li>
            <li>Vulkan 1.2 <b>can</b> be used with the physical device that supports Vulkan 1.2.</li>
        </ul>

        If we modify the above example so that the application sets {@code apiVersion} to 1.1, then the application <b>must</b> not use Vulkan 1.2 functionality on the physical device that supports Vulkan 1.2.
        </div>

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Providing a {@code NULL} ##VkInstanceCreateInfo{@code ::pApplicationInfo} or providing an {@code apiVersion} of 0 is equivalent to providing an {@code apiVersion} of {@code VK_MAKE_API_VERSION(0,1,0,0)}.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code apiVersion} is not 0, then it <b>must</b> be greater than or equal to #API_VERSION_1_0</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_APPLICATION_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>If {@code pApplicationName} is not {@code NULL}, {@code pApplicationName} <b>must</b> be a null-terminated UTF-8 string</li>
            <li>If {@code pEngineName} is not {@code NULL}, {@code pEngineName} <b>must</b> be a null-terminated UTF-8 string</li>
        </ul>

        <h5>See Also</h5>
        ##VkInstanceCreateInfo
        """

    Expression("#STRUCTURE_TYPE_APPLICATION_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    nullable..charUTF8.const.p("pApplicationName", "{@code NULL} or is a pointer to a null-terminated UTF-8 string containing the name of the application.")
    uint32_t("applicationVersion", "an unsigned integer variable containing the developer-supplied version number of the application.")
    nullable..charUTF8.const.p("pEngineName", "{@code NULL} or is a pointer to a null-terminated UTF-8 string containing the name of the engine (if any) used to create the application.")
    uint32_t("engineVersion", "an unsigned integer variable containing the developer-supplied version number of the engine used to create the application.")
    uint32_t("apiVersion", "<b>must</b> be the highest version of Vulkan that the application is designed to use, encoded as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#extendingvulkan-coreversions-versionnumbers\">Version Numbers</a>. The patch version number specified in {@code apiVersion} is ignored when creating an instance object. The variant version of the instance <b>must</b> match that requested in {@code apiVersion}.")
}

val VkFormatProperties = struct(Module.VULKAN, "VkFormatProperties", mutable = false) {
    documentation =
        """
        Structure specifying image format properties.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        If no format feature flags are supported, the format itself is not supported, and images of that format cannot be created.
        </div>

        If {@code format} is a block-compressed format, then {@code bufferFeatures} <b>must</b> not support any features for the format.

        If {@code format} is not a multi-plane format then {@code linearTilingFeatures} and {@code optimalTilingFeatures} <b>must</b> not contain #FORMAT_FEATURE_DISJOINT_BIT.

        <h5>See Also</h5>
        ##VkFormatProperties2, #GetPhysicalDeviceFormatProperties()
        """

    VkFormatFeatureFlags("linearTilingFeatures", "a bitmask of {@code VkFormatFeatureFlagBits} specifying features supported by images created with a {@code tiling} parameter of #IMAGE_TILING_LINEAR.")
    VkFormatFeatureFlags("optimalTilingFeatures", "a bitmask of {@code VkFormatFeatureFlagBits} specifying features supported by images created with a {@code tiling} parameter of #IMAGE_TILING_OPTIMAL.")
    VkFormatFeatureFlags("bufferFeatures", "a bitmask of {@code VkFormatFeatureFlagBits} specifying features supported by buffers.")
}

val VkImageFormatProperties = struct(Module.VULKAN, "VkImageFormatProperties", mutable = false) {
    documentation =
        """
        Structure specifying an image format properties.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        There is no mechanism to query the size of an image before creating it, to compare that size against {@code maxResourceSize}. If an application attempts to create an image that exceeds this limit, the creation will fail and #CreateImage() will return #ERROR_OUT_OF_DEVICE_MEMORY. While the advertised limit <b>must</b> be at least 2<sup>31</sup>, it <b>may</b> not be possible to create an image that approaches that size, particularly for #IMAGE_TYPE_1D.
        </div>

        If the combination of parameters to {@code vkGetPhysicalDeviceImageFormatProperties} is not supported by the implementation for use in #CreateImage(), then all members of ##VkImageFormatProperties will be filled with zero.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Filling ##VkImageFormatProperties with zero for unsupported formats is an exception to the usual rule that output structures have undefined contents on error. This exception was unintentional, but is preserved for backwards compatibility.
        </div>

        <h5>See Also</h5>
        ##VkExtent3D, ##VkExternalImageFormatPropertiesNV, ##VkImageFormatProperties2, #GetPhysicalDeviceImageFormatProperties()
        """

    VkExtent3D("maxExtent", "are the maximum image dimensions. See the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-extentperimagetype\">Allowed Extent Values</a> section below for how these values are constrained by {@code type}.")
    uint32_t("maxMipLevels", """the maximum number of mipmap levels. {@code maxMipLevels} <b>must</b> be equal to the number of levels in the complete mipmap chain based on the <code>maxExtent.width</code>, <code>maxExtent.height</code>, and <code>maxExtent.depth</code>, except when one of the following conditions is true, in which case it <b>may</b> instead be 1:

        <ul>
            <li>{@code vkGetPhysicalDeviceImageFormatProperties}{@code ::tiling} was #IMAGE_TILING_LINEAR</li>
            <li>##VkPhysicalDeviceImageFormatInfo2{@code ::tiling} was #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT</li>
            <li>the ##VkPhysicalDeviceImageFormatInfo2{@code ::pNext} chain included a ##VkPhysicalDeviceExternalImageFormatInfo structure with a handle type included in the {@code handleTypes} member for which mipmap image support is not required</li>
            <li>image {@code format} is one of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">formats that require a sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a></li>
            <li>{@code flags} contains #IMAGE_CREATE_SUBSAMPLED_BIT_EXT</li>
        </ul>""")
    uint32_t("maxArrayLayers", """the maximum number of array layers. {@code maxArrayLayers} <b>must</b> be no less than ##VkPhysicalDeviceLimits{@code ::maxImageArrayLayers}, except when one of the following conditions is true, in which case it <b>may</b> instead be 1:

        <ul>
            <li>{@code tiling} is #IMAGE_TILING_LINEAR</li>
            <li>{@code tiling} is #IMAGE_TILING_OPTIMAL and {@code type} is #IMAGE_TYPE_3D</li>
            <li>{@code format} is one of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">formats that require a sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a></li>
            <li>If {@code tiling} is #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then {@code maxArrayLayers} <b>must</b> not be 0.</li>
        </ul>""")
    VkSampleCountFlags("sampleCounts", "a bitmask of {@code VkSampleCountFlagBits} specifying all the supported sample counts for this image as described <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-supported-sample-counts\">below</a>.")
    VkDeviceSize("maxResourceSize", "an upper bound on the total image size in bytes, inclusive of all image subresources. Implementations <b>may</b> have an address space limit on total size of a resource, which is advertised by this property. {@code maxResourceSize} <b>must</b> be at least 2<sup>31</sup>.")
}

val VkInstanceCreateInfo = struct(Module.VULKAN, "VkInstanceCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created instance.

        <h5>Description</h5>
        To capture events that occur while creating or destroying an instance, an application <b>can</b> link a ##VkDebugReportCallbackCreateInfoEXT structure or a ##VkDebugUtilsMessengerCreateInfoEXT structure to the {@code pNext} element of the ##VkInstanceCreateInfo structure given to {@code vkCreateInstance}. This callback is only valid for the duration of the #CreateInstance() and the #DestroyInstance() call. Use #CreateDebugReportCallbackEXT() or #CreateDebugUtilsMessengerEXT() to create persistent callback objects.

        An application can add additional drivers by including the ##VkDirectDriverLoadingListLUNARG struct to the {@code pNext} element of the ##VkInstanceCreateInfo structure given to {@code vkCreateInstance}.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        ##VkDirectDriverLoadingListLUNARG allows applications to ship drivers with themselves. Only drivers that are designed to work with it should be used, such as drivers that implement Vulkan in software or that implement Vulkan by translating it to a different API. Any driver that requires installation should not be used, such as hardware drivers.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain of ##VkInstanceCreateInfo includes a ##VkDebugReportCallbackCreateInfoEXT structure, the list of enabled extensions in {@code ppEnabledExtensionNames} <b>must</b> contain {@link EXTDebugReport VK_EXT_debug_report}</li>
            <li>If the {@code pNext} chain of ##VkInstanceCreateInfo includes a ##VkDebugUtilsMessengerCreateInfoEXT structure, the list of enabled extensions in {@code ppEnabledExtensionNames} <b>must</b> contain {@link EXTDebugUtils VK_EXT_debug_utils}</li>
            <li>If the {@code pNext} chain includes a ##VkExportMetalObjectCreateInfoEXT structure, its {@code exportObjectType} member <b>must</b> be either #EXPORT_METAL_OBJECT_TYPE_METAL_DEVICE_BIT_EXT or #EXPORT_METAL_OBJECT_TYPE_METAL_COMMAND_QUEUE_BIT_EXT</li>
            <li>If {@code flags} has the #INSTANCE_CREATE_ENUMERATE_PORTABILITY_BIT_KHR bit set, the list of enabled extensions in {@code ppEnabledExtensionNames} <b>must</b> contain {@link KHRPortabilityEnumeration VK_KHR_portability_enumeration}</li>
            <li>If the {@code pNext} chain of ##VkInstanceCreateInfo includes a ##VkDirectDriverLoadingListLUNARG structure, the list of enabled extensions in {@code ppEnabledExtensionNames} <b>must</b> contain {@link LUNARGDirectDriverLoading VK_LUNARG_direct_driver_loading}</li>
            <li>If the {@code pNext} chain of ##VkInstanceCreateInfo includes a ##VkLayerSettingsCreateInfoEXT structure, the list of enabled extensions in {@code ppEnabledExtensionNames} <b>must</b> contain {@link EXTLayerSettings VK_EXT_layer_settings}</li>
            <li>If the {@code pNext} chain of ##VkInstanceCreateInfo includes a ##VkValidationFeaturesEXT structure, the list of enabled extensions in {@code ppEnabledExtensionNames} <b>must</b> contain {@link EXTValidationFeatures VK_EXT_validation_features}</li>
            <li>If the {@code pNext} chain of ##VkInstanceCreateInfo includes a ##VkValidationFlagsEXT structure, the list of enabled extensions in {@code ppEnabledExtensionNames} <b>must</b> contain {@link EXTValidationFlags VK_EXT_validation_flags}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_INSTANCE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDebugReportCallbackCreateInfoEXT, ##VkDebugUtilsMessengerCreateInfoEXT, ##VkDirectDriverLoadingListLUNARG, ##VkExportMetalObjectCreateInfoEXT, ##VkLayerSettingsCreateInfoEXT, ##VkValidationFeaturesEXT, or ##VkValidationFlagsEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique, with the exception of structures of type ##VkDebugUtilsMessengerCreateInfoEXT, ##VkExportMetalObjectCreateInfoEXT, or ##VkLayerSettingsCreateInfoEXT</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkInstanceCreateFlagBits} values</li>
            <li>If {@code pApplicationInfo} is not {@code NULL}, {@code pApplicationInfo} <b>must</b> be a valid pointer to a valid ##VkApplicationInfo structure</li>
            <li>If {@code enabledLayerCount} is not 0, {@code ppEnabledLayerNames} <b>must</b> be a valid pointer to an array of {@code enabledLayerCount} null-terminated UTF-8 strings</li>
            <li>If {@code enabledExtensionCount} is not 0, {@code ppEnabledExtensionNames} <b>must</b> be a valid pointer to an array of {@code enabledExtensionCount} null-terminated UTF-8 strings</li>
        </ul>

        <h5>See Also</h5>
        ##VkApplicationInfo, #CreateInstance()
        """

    Expression("#STRUCTURE_TYPE_INSTANCE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDebugReportCallbackCreateInfoEXT", "VkDebugUtilsMessengerCreateInfoEXT", "VkDirectDriverLoadingListLUNARG", "VkExportMetalObjectCreateInfoEXT", "VkLayerSettingsCreateInfoEXT", "VkValidationFeaturesEXT", "VkValidationFlagsEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkInstanceCreateFlags("flags", "a bitmask of {@code VkInstanceCreateFlagBits} indicating the behavior of the instance.")
    nullable..VkApplicationInfo.const.p("pApplicationInfo", "{@code NULL} or a pointer to a ##VkApplicationInfo structure. If not {@code NULL}, this information helps implementations recognize behavior inherent to classes of applications. ##VkApplicationInfo is defined in detail below.")
    AutoSize("ppEnabledLayerNames", optional = true)..uint32_t("enabledLayerCount", "the number of global layers to enable.")
    charUTF8.const.p.const.p("ppEnabledLayerNames", "a pointer to an array of {@code enabledLayerCount} null-terminated UTF-8 strings containing the names of layers to enable for the created instance. The layers are loaded in the order they are listed in this array, with the first array element being the closest to the application, and the last array element being the closest to the driver. See the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#extendingvulkan-layers\">Layers</a> section for further details.")
    AutoSize("ppEnabledExtensionNames", optional = true)..uint32_t("enabledExtensionCount", "the number of global extensions to enable.")
    charUTF8.const.p.const.p("ppEnabledExtensionNames", "a pointer to an array of {@code enabledExtensionCount} null-terminated UTF-8 strings containing the names of extensions to enable.")
}

val VkMemoryHeap = struct(Module.VULKAN, "VkMemoryHeap", mutable = false) {
    documentation =
        """
        Structure specifying a memory heap.

        <h5>See Also</h5>
        ##VkPhysicalDeviceMemoryProperties
        """

    VkDeviceSize("size", "the total memory size in bytes in the heap.")
    VkMemoryHeapFlags("flags", "a bitmask of {@code VkMemoryHeapFlagBits} specifying attribute flags for the heap.")
}

val VkMemoryType = struct(Module.VULKAN, "VkMemoryType", mutable = false) {
    documentation =
        """
        Structure specifying memory type.

        <h5>See Also</h5>
        ##VkPhysicalDeviceMemoryProperties
        """

    VkMemoryPropertyFlags("propertyFlags", "a bitmask of {@code VkMemoryPropertyFlagBits} of properties for this memory type.")
    uint32_t("heapIndex", "describes which memory heap this memory type corresponds to, and <b>must</b> be less than {@code memoryHeapCount} from the ##VkPhysicalDeviceMemoryProperties structure.")
}

val VkPhysicalDeviceFeatures = struct(Module.VULKAN, "VkPhysicalDeviceFeatures") {
    documentation =
        """
        Structure describing the fine-grained features that can be supported by an implementation.

        <h5>See Also</h5>
        ##VkDeviceCreateInfo, ##VkPhysicalDeviceFeatures2, #GetPhysicalDeviceFeatures()
        """

    VkBool32("robustBufferAccess", """specifies that accesses to buffers are bounds-checked against the range of the buffer descriptor (as determined by ##VkDescriptorBufferInfo{@code ::range}, ##VkBufferViewCreateInfo{@code ::range}, or the size of the buffer). Out of bounds accesses <b>must</b> not cause application termination, and the effects of shader loads, stores, and atomics <b>must</b> conform to an implementation-dependent behavior as described below.

        <ul>
            <li>
                A buffer access is considered to be out of bounds if any of the following are true:
                <ul>
                    <li>The pointer was formed by {@code OpImageTexelPointer} and the coordinate is less than zero or greater than or equal to the number of whole elements in the bound range.</li>
                    <li>The pointer was not formed by {@code OpImageTexelPointer} and the object pointed to is not wholly contained within the bound range. This includes accesses performed via <em>variable pointers</em> where the buffer descriptor being accessed cannot be statically determined. Uninitialized pointers and pointers equal to {@code OpConstantNull} are treated as pointing to a zero-sized object, so all accesses through such pointers are considered to be out of bounds. Buffer accesses through buffer device addresses are not bounds-checked.</li>
                    <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-cooperativeMatrixRobustBufferAccessNV">##VkPhysicalDeviceCooperativeMatrixFeaturesNV{@code ::cooperativeMatrixRobustBufferAccess}</a> feature is not enabled, then accesses using {@code OpCooperativeMatrixLoadNV} and {@code OpCooperativeMatrixStoreNV} <b>may</b> not be bounds-checked.</li>
                    <li>
                        If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-cooperativeMatrixRobustBufferAccess">##VkPhysicalDeviceCooperativeMatrixFeaturesKHR{@code ::cooperativeMatrixRobustBufferAccess}</a> feature is not enabled, then accesses using {@code OpCooperativeMatrixLoadKHR} and {@code OpCooperativeMatrixStoreKHR} <b>may</b> not be bounds-checked.
                        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
                        If a SPIR-V {@code OpLoad} instruction loads a structure and the tail end of the structure is out of bounds, then all members of the structure are considered out of bounds even if the members at the end are not statically used.
                        </div>
                    </li>
                    <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is not enabled and any buffer access is determined to be out of bounds, then any other access of the same type (load, store, or atomic) to the same buffer that accesses an address less than 16 bytes away from the out of bounds address <b>may</b> also be considered out of bounds.</li>
                    <li>If the access is a load that reads from the same memory locations as a prior store in the same shader invocation, with no other intervening accesses to the same memory locations in that shader invocation, then the result of the load <b>may</b> be the value stored by the store instruction, even if the access is out of bounds. If the load is {@code Volatile}, then an out of bounds load <b>must</b> return the appropriate out of bounds value.</li>
                </ul>
            </li>
            <li>Accesses to descriptors written with a #NULL_HANDLE resource or view are not considered to be out of bounds. Instead, each type of descriptor access defines a specific behavior for accesses to a null descriptor.</li>
            <li>
                Out-of-bounds buffer loads will return any of the following values:
                <ul>
                    <li>If the access is to a uniform buffer and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is enabled, loads of offsets between the end of the descriptor range and the end of the descriptor range rounded up to a multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustUniformBufferAccessSizeAlignment">{@code robustUniformBufferAccessSizeAlignment}</a> bytes <b>must</b> return either zero values or the contents of the memory at the offset being loaded. Loads of offsets past the descriptor range rounded up to a multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustUniformBufferAccessSizeAlignment">{@code robustUniformBufferAccessSizeAlignment}</a> bytes <b>must</b> return zero values.</li>
                    <li>If the access is to a storage buffer and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is enabled, loads of offsets between the end of the descriptor range and the end of the descriptor range rounded up to a multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustStorageBufferAccessSizeAlignment">{@code robustStorageBufferAccessSizeAlignment}</a> bytes <b>must</b> return either zero values or the contents of the memory at the offset being loaded. Loads of offsets past the descriptor range rounded up to a multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustStorageBufferAccessSizeAlignment">{@code robustStorageBufferAccessSizeAlignment}</a> bytes <b>must</b> return zero values. Similarly, stores to addresses between the end of the descriptor range and the end of the descriptor range rounded up to a multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustStorageBufferAccessSizeAlignment">{@code robustStorageBufferAccessSizeAlignment}</a> bytes <b>may</b> be discarded.</li>
                    <li>Non-atomic accesses to storage buffers that are a multiple of 32 bits <b>may</b> be decomposed into 32-bit accesses that are individually bounds-checked.</li>
                    <li>If the access is to an index buffer and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is enabled, zero values <b>must</b> be returned.</li>
                    <li>If the access is to a uniform texel buffer or storage texel buffer and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is enabled, zero values <b>must</b> be returned, and then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#textures-conversion-to-rgba">Conversion to RGBA</a> is applied based on the buffer view’s format.</li>
                    <li>Values from anywhere within the memory range(s) bound to the buffer (possibly including bytes of memory past the end of the buffer, up to the end of the bound range).</li>
                    <li>
                        Zero values, or <code>(0,0,0,x)</code> vectors for vector reads where x is a valid value represented in the type of the vector components and <b>may</b> be any of:
                        <ul>
                            <li>0, 1, or the maximum representable positive integer value, for signed or unsigned integer components</li>
                            <li>0.0 or 1.0, for floating-point components</li>
                        </ul>
                    </li>
                </ul>
            </li>
            <li>
                Out-of-bounds writes <b>may</b> modify values within the memory range(s) bound to the buffer, but <b>must</b> not modify any other memory.
                <ul>
                    <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is enabled, out of bounds writes <b>must</b> not modify any memory.</li>
                </ul>
            </li>
            <li>
                Out-of-bounds atomics <b>may</b> modify values within the memory range(s) bound to the buffer, but <b>must</b> not modify any other memory, and return an undefined value.
                <ul>
                    <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is enabled, out of bounds atomics <b>must</b> not modify any memory, and return an undefined value.</li>
                </ul>
            </li>
            <li>
                If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is not enabled, vertex input attributes are considered out of bounds if the offset of the attribute in the bound vertex buffer range plus the size of the attribute is greater than either:
                <ul>
                    <li>{@code vertexBufferRangeSize}, if <code>bindingStride == 0</code>; or</li>
                    <li>
                        <code>(vertexBufferRangeSize - (vertexBufferRangeSize % bindingStride))</code>
                        where {@code vertexBufferRangeSize} is the byte size of the memory range bound to the vertex buffer binding and {@code bindingStride} is the byte stride of the corresponding vertex input binding. Further, if any vertex input attribute using a specific vertex input binding is out of bounds, then all vertex input attributes using that vertex input binding for that vertex shader invocation are considered out of bounds.
                    </li>
                    <li>
                        If a vertex input attribute is out of bounds, it will be assigned one of the following values:
                        <ul>
                            <li>Values from anywhere within the memory range(s) bound to the buffer, converted according to the format of the attribute.</li>
                            <li>Zero values, format converted according to the format of the attribute.</li>
                            <li>Zero values, or <code>(0,0,0,x)</code> vectors, as described above.</li>
                        </ul>
                    </li>
                </ul>
            </li>
            <li>
                If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess2">{@code robustBufferAccess2}</a> feature is enabled, vertex input attributes are considered out of bounds if the offset of the attribute in the bound vertex buffer range plus the size of the attribute is greater than the byte size of the memory range bound to the vertex buffer binding.
                <ul>
                    <li>If a vertex input attribute is out of bounds, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#fxvertex-input-extraction">raw data</a> extracted are zero values, and missing G, B, or A components are <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#fxvertex-input-extraction">filled with <code>(0,0,1)</code></a>.</li>
                </ul>
            </li>
            <li>If {@code robustBufferAccess} is not enabled, applications <b>must</b> not perform out of bounds accesses except under the conditions enabled by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineRobustness">{@code pipelineRobustness}</a> feature .</li>
        </ul>""")
    VkBool32("fullDrawIndexUint32", "specifies the full 32-bit range of indices is supported for indexed draw calls when using a {@code VkIndexType} of #INDEX_TYPE_UINT32. {@code maxDrawIndexedIndexValue} is the maximum index value that <b>may</b> be used (aside from the primitive restart index, which is always 2<sup>32</sup>-1 when the {@code VkIndexType} is #INDEX_TYPE_UINT32). If this feature is supported, {@code maxDrawIndexedIndexValue} <b>must</b> be 2<sup>32</sup>-1; otherwise it <b>must</b> be no smaller than 2<sup>24</sup>-1. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-maxDrawIndexedIndexValue\">{@code maxDrawIndexedIndexValue}</a>.")
    VkBool32("imageCubeArray", "specifies whether image views with a {@code VkImageViewType} of #IMAGE_VIEW_TYPE_CUBE_ARRAY <b>can</b> be created, and that the corresponding {@code SampledCubeArray} and {@code ImageCubeArray} SPIR-V capabilities <b>can</b> be used in shader code.")
    VkBool32("independentBlend", "specifies whether the ##VkPipelineColorBlendAttachmentState settings are controlled independently per-attachment. If this feature is not enabled, the ##VkPipelineColorBlendAttachmentState settings for all color attachments <b>must</b> be identical. Otherwise, a different ##VkPipelineColorBlendAttachmentState <b>can</b> be provided for each bound color attachment.")
    VkBool32("geometryShader", "specifies whether geometry shaders are supported. If this feature is not enabled, the #SHADER_STAGE_GEOMETRY_BIT and #PIPELINE_STAGE_GEOMETRY_SHADER_BIT enum values <b>must</b> not be used. This also specifies whether shader modules <b>can</b> declare the {@code Geometry} capability.")
    VkBool32("tessellationShader", "specifies whether tessellation control and evaluation shaders are supported. If this feature is not enabled, the #SHADER_STAGE_TESSELLATION_CONTROL_BIT, #SHADER_STAGE_TESSELLATION_EVALUATION_BIT, #PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT, #PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT, and #STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO enum values <b>must</b> not be used. This also specifies whether shader modules <b>can</b> declare the {@code Tessellation} capability.")
    VkBool32("sampleRateShading", "specifies whether <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-sampleshading\">Sample Shading</a> and multisample interpolation are supported. If this feature is not enabled, the {@code sampleShadingEnable} member of the ##VkPipelineMultisampleStateCreateInfo structure <b>must</b> be #FALSE and the {@code minSampleShading} member is ignored. This also specifies whether shader modules <b>can</b> declare the {@code SampleRateShading} capability.")
    VkBool32("dualSrcBlend", "specifies whether blend operations which take two sources are supported. If this feature is not enabled, the #BLEND_FACTOR_SRC1_COLOR, #BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, #BLEND_FACTOR_SRC1_ALPHA, and #BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA enum values <b>must</b> not be used as source or destination blending factors. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#framebuffer-dsb\">Dual-Source Blending</a>.")
    VkBool32("logicOp", "specifies whether logic operations are supported. If this feature is not enabled, the {@code logicOpEnable} member of the ##VkPipelineColorBlendStateCreateInfo structure <b>must</b> be #FALSE, and the {@code logicOp} member is ignored.")
    VkBool32("multiDrawIndirect", "specifies whether multiple draw indirect is supported. If this feature is not enabled, the {@code drawCount} parameter to the #CmdDrawIndirect() and #CmdDrawIndexedIndirect() commands <b>must</b> be 0 or 1. The {@code maxDrawIndirectCount} member of the ##VkPhysicalDeviceLimits structure <b>must</b> also be 1 if this feature is not supported. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-maxDrawIndirectCount\">{@code maxDrawIndirectCount}</a>.")
    VkBool32("drawIndirectFirstInstance", "specifies whether indirect drawing calls support the {@code firstInstance} parameter. If this feature is not enabled, the {@code firstInstance} member of all ##VkDrawIndirectCommand and ##VkDrawIndexedIndirectCommand structures that are provided to the #CmdDrawIndirect() and #CmdDrawIndexedIndirect() commands <b>must</b> be 0.")
    VkBool32("depthClamp", "specifies whether depth clamping is supported. If this feature is not enabled, the {@code depthClampEnable} member of the ##VkPipelineRasterizationStateCreateInfo structure <b>must</b> be #FALSE. Otherwise, setting {@code depthClampEnable} to #TRUE will enable depth clamping.")
    VkBool32("depthBiasClamp", "specifies whether depth bias clamping is supported. If this feature is not enabled, the {@code depthBiasClamp} member of the ##VkPipelineRasterizationStateCreateInfo structure <b>must</b> be 0.0 unless the #DYNAMIC_STATE_DEPTH_BIAS dynamic state is enabled, in which case the {@code depthBiasClamp} parameter to #CmdSetDepthBias() <b>must</b> be 0.0.")
    VkBool32("fillModeNonSolid", "specifies whether point and wireframe fill modes are supported. If this feature is not enabled, the #POLYGON_MODE_POINT and #POLYGON_MODE_LINE enum values <b>must</b> not be used.")
    VkBool32("depthBounds", "specifies whether depth bounds tests are supported. If this feature is not enabled, the {@code depthBoundsTestEnable} member of the ##VkPipelineDepthStencilStateCreateInfo structure <b>must</b> be #FALSE unless the #DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE dynamic state is enabled, in which case the {@code depthBoundsTestEnable} parameter to #CmdSetDepthBoundsTestEnable() <b>must</b> be #FALSE. When {@code depthBoundsTestEnable} is #FALSE, the {@code minDepthBounds} and {@code maxDepthBounds} members of the ##VkPipelineDepthStencilStateCreateInfo structure are ignored.")
    VkBool32("wideLines", "specifies whether lines with width other than 1.0 are supported. If this feature is not enabled, the {@code lineWidth} member of the ##VkPipelineRasterizationStateCreateInfo structure <b>must</b> be 1.0 unless the #DYNAMIC_STATE_LINE_WIDTH dynamic state is enabled, in which case the {@code lineWidth} parameter to #CmdSetLineWidth() <b>must</b> be 1.0. When this feature is supported, the range and granularity of supported line widths are indicated by the {@code lineWidthRange} and {@code lineWidthGranularity} members of the ##VkPhysicalDeviceLimits structure, respectively.")
    VkBool32("largePoints", "specifies whether points with size greater than 1.0 are supported. If this feature is not enabled, only a point size of 1.0 written by a shader is supported. The range and granularity of supported point sizes are indicated by the {@code pointSizeRange} and {@code pointSizeGranularity} members of the ##VkPhysicalDeviceLimits structure, respectively.")
    VkBool32("alphaToOne", "specifies whether the implementation is able to replace the alpha value of the fragment shader color output in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-covg\">Multisample Coverage</a> fragment operation. If this feature is not enabled, then the {@code alphaToOneEnable} member of the ##VkPipelineMultisampleStateCreateInfo structure <b>must</b> be #FALSE. Otherwise setting {@code alphaToOneEnable} to #TRUE will enable alpha-to-one behavior.")
    VkBool32("multiViewport", """specifies whether more than one viewport is supported. If this feature is not enabled:

        <ul>
            <li>The {@code viewportCount} and {@code scissorCount} members of the ##VkPipelineViewportStateCreateInfo structure <b>must</b> be 1.</li>
            <li>The {@code firstViewport} and {@code viewportCount} parameters to the #CmdSetViewport() command <b>must</b> be 0 and 1, respectively.</li>
            <li>The {@code firstScissor} and {@code scissorCount} parameters to the #CmdSetScissor() command <b>must</b> be 0 and 1, respectively.</li>
            <li>The {@code exclusiveScissorCount} member of the ##VkPipelineViewportExclusiveScissorStateCreateInfoNV structure <b>must</b> be 0 or 1.</li>
            <li>The {@code firstExclusiveScissor} and {@code exclusiveScissorCount} parameters to the #CmdSetExclusiveScissorNV() command <b>must</b> be 0 and 1, respectively.</li>
        </ul>""")
    VkBool32("samplerAnisotropy", "specifies whether anisotropic filtering is supported. If this feature is not enabled, the {@code anisotropyEnable} member of the ##VkSamplerCreateInfo structure <b>must</b> be #FALSE.")
    VkBool32("textureCompressionETC2", """specifies whether all of the ETC2 and EAC compressed texture formats are supported. If this feature is enabled, then the #FORMAT_FEATURE_SAMPLED_IMAGE_BIT, #FORMAT_FEATURE_BLIT_SRC_BIT and #FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT features <b>must</b> be supported in {@code optimalTilingFeatures} for the following formats:

        <ul>
            <li>#FORMAT_ETC2_R8G8B8_UNORM_BLOCK</li>
            <li>#FORMAT_ETC2_R8G8B8_SRGB_BLOCK</li>
            <li>#FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK</li>
            <li>#FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK</li>
            <li>#FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK</li>
            <li>#FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK</li>
            <li>#FORMAT_EAC_R11_UNORM_BLOCK</li>
            <li>#FORMAT_EAC_R11_SNORM_BLOCK</li>
            <li>#FORMAT_EAC_R11G11_UNORM_BLOCK</li>
            <li>
                #FORMAT_EAC_R11G11_SNORM_BLOCK
                To query for additional properties, or if the feature is not enabled, #GetPhysicalDeviceFormatProperties() and #GetPhysicalDeviceImageFormatProperties() <b>can</b> be used to check for supported properties of individual formats as normal.
            </li>
        </ul>""")
    VkBool32("textureCompressionASTC_LDR", """specifies whether all of the ASTC LDR compressed texture formats are supported. If this feature is enabled, then the #FORMAT_FEATURE_SAMPLED_IMAGE_BIT, #FORMAT_FEATURE_BLIT_SRC_BIT and #FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT features <b>must</b> be supported in {@code optimalTilingFeatures} for the following formats:

        <ul>
            <li>#FORMAT_ASTC_4x4_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_4x4_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_5x4_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_5x4_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_5x5_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_5x5_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_6x5_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_6x5_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_6x6_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_6x6_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_8x5_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_8x5_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_8x6_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_8x6_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_8x8_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_8x8_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_10x5_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_10x5_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_10x6_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_10x6_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_10x8_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_10x8_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_10x10_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_10x10_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_12x10_UNORM_BLOCK</li>
            <li>#FORMAT_ASTC_12x10_SRGB_BLOCK</li>
            <li>#FORMAT_ASTC_12x12_UNORM_BLOCK</li>
            <li>
                #FORMAT_ASTC_12x12_SRGB_BLOCK
                To query for additional properties, or if the feature is not enabled, #GetPhysicalDeviceFormatProperties() and #GetPhysicalDeviceImageFormatProperties() <b>can</b> be used to check for supported properties of individual formats as normal.
            </li>
        </ul>""")
    VkBool32("textureCompressionBC", """specifies whether all of the BC compressed texture formats are supported. If this feature is enabled, then the #FORMAT_FEATURE_SAMPLED_IMAGE_BIT, #FORMAT_FEATURE_BLIT_SRC_BIT and #FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT features <b>must</b> be supported in {@code optimalTilingFeatures} for the following formats:

        <ul>
            <li>#FORMAT_BC1_RGB_UNORM_BLOCK</li>
            <li>#FORMAT_BC1_RGB_SRGB_BLOCK</li>
            <li>#FORMAT_BC1_RGBA_UNORM_BLOCK</li>
            <li>#FORMAT_BC1_RGBA_SRGB_BLOCK</li>
            <li>#FORMAT_BC2_UNORM_BLOCK</li>
            <li>#FORMAT_BC2_SRGB_BLOCK</li>
            <li>#FORMAT_BC3_UNORM_BLOCK</li>
            <li>#FORMAT_BC3_SRGB_BLOCK</li>
            <li>#FORMAT_BC4_UNORM_BLOCK</li>
            <li>#FORMAT_BC4_SNORM_BLOCK</li>
            <li>#FORMAT_BC5_UNORM_BLOCK</li>
            <li>#FORMAT_BC5_SNORM_BLOCK</li>
            <li>#FORMAT_BC6H_UFLOAT_BLOCK</li>
            <li>#FORMAT_BC6H_SFLOAT_BLOCK</li>
            <li>#FORMAT_BC7_UNORM_BLOCK</li>
            <li>
                #FORMAT_BC7_SRGB_BLOCK
                To query for additional properties, or if the feature is not enabled, #GetPhysicalDeviceFormatProperties() and #GetPhysicalDeviceImageFormatProperties() <b>can</b> be used to check for supported properties of individual formats as normal.
            </li>
        </ul>""")
    VkBool32("occlusionQueryPrecise", "specifies whether occlusion queries returning actual sample counts are supported. Occlusion queries are created in a {@code VkQueryPool} by specifying the {@code queryType} of #QUERY_TYPE_OCCLUSION in the ##VkQueryPoolCreateInfo structure which is passed to #CreateQueryPool(). If this feature is enabled, queries of this type <b>can</b> enable #QUERY_CONTROL_PRECISE_BIT in the {@code flags} parameter to #CmdBeginQuery(). If this feature is not supported, the implementation supports only boolean occlusion queries. When any samples are passed, boolean queries will return a non-zero result value, otherwise a result value of zero is returned. When this feature is enabled and #QUERY_CONTROL_PRECISE_BIT is set, occlusion queries will report the actual number of samples passed.")
    VkBool32("pipelineStatisticsQuery", "specifies whether the pipeline statistics queries are supported. If this feature is not enabled, queries of type #QUERY_TYPE_PIPELINE_STATISTICS <b>cannot</b> be created, and none of the {@code VkQueryPipelineStatisticFlagBits} bits <b>can</b> be set in the {@code pipelineStatistics} member of the ##VkQueryPoolCreateInfo structure.")
    VkBool32("vertexPipelineStoresAndAtomics", "specifies whether storage buffers and images support stores and atomic operations in the vertex, tessellation, and geometry shader stages. If this feature is not enabled, all storage image, storage texel buffer, and storage buffer variables used by these stages in shader modules <b>must</b> be decorated with the {@code NonWritable} decoration (or the {@code readonly} memory qualifier in GLSL).")
    VkBool32("fragmentStoresAndAtomics", "specifies whether storage buffers and images support stores and atomic operations in the fragment shader stage. If this feature is not enabled, all storage image, storage texel buffer, and storage buffer variables used by the fragment stage in shader modules <b>must</b> be decorated with the {@code NonWritable} decoration (or the {@code readonly} memory qualifier in GLSL).")
    VkBool32("shaderTessellationAndGeometryPointSize", "specifies whether the {@code PointSize} built-in decoration is available in the tessellation control, tessellation evaluation, and geometry shader stages. If this feature is not enabled, members decorated with the {@code PointSize} built-in decoration <b>must</b> not be read from or written to and all points written from a tessellation or geometry shader will have a size of 1.0. This also specifies whether shader modules <b>can</b> declare the {@code TessellationPointSize} capability for tessellation control and evaluation shaders, or if the shader modules <b>can</b> declare the {@code GeometryPointSize} capability for geometry shaders. An implementation supporting this feature <b>must</b> also support one or both of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-tessellationShader\">{@code tessellationShader}</a> or <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-geometryShader\">{@code geometryShader}</a> features.")
    VkBool32("shaderImageGatherExtended", "specifies whether the extended set of image gather instructions are available in shader code. If this feature is not enabled, the {@code OpImage*Gather} instructions do not support the {@code Offset} and {@code ConstOffsets} operands. This also specifies whether shader modules <b>can</b> declare the {@code ImageGatherExtended} capability.")
    VkBool32("shaderStorageImageExtendedFormats", """specifies whether all the “storage image extended formats” below are supported; if this feature is supported, then the #FORMAT_FEATURE_STORAGE_IMAGE_BIT <b>must</b> be supported in {@code optimalTilingFeatures} for the following formats:

        <ul>
            <li>#FORMAT_R16G16_SFLOAT</li>
            <li>#FORMAT_B10G11R11_UFLOAT_PACK32</li>
            <li>#FORMAT_R16_SFLOAT</li>
            <li>#FORMAT_R16G16B16A16_UNORM</li>
            <li>#FORMAT_A2B10G10R10_UNORM_PACK32</li>
            <li>#FORMAT_R16G16_UNORM</li>
            <li>#FORMAT_R8G8_UNORM</li>
            <li>#FORMAT_R16_UNORM</li>
            <li>#FORMAT_R8_UNORM</li>
            <li>#FORMAT_R16G16B16A16_SNORM</li>
            <li>#FORMAT_R16G16_SNORM</li>
            <li>#FORMAT_R8G8_SNORM</li>
            <li>#FORMAT_R16_SNORM</li>
            <li>#FORMAT_R8_SNORM</li>
            <li>#FORMAT_R16G16_SINT</li>
            <li>#FORMAT_R8G8_SINT</li>
            <li>#FORMAT_R16_SINT</li>
            <li>#FORMAT_R8_SINT</li>
            <li>#FORMAT_A2B10G10R10_UINT_PACK32</li>
            <li>#FORMAT_R16G16_UINT</li>
            <li>#FORMAT_R8G8_UINT</li>
            <li>#FORMAT_R16_UINT</li>
            <li>
                #FORMAT_R8_UINT
                <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
                {@code shaderStorageImageExtendedFormats} feature only adds a guarantee of format support, which is specified for the whole physical device. Therefore enabling or disabling the feature via #CreateDevice() has no practical effect.

                To query for additional properties, or if the feature is not supported, #GetPhysicalDeviceFormatProperties() and #GetPhysicalDeviceImageFormatProperties() <b>can</b> be used to check for supported properties of individual formats, as usual rules allow.

                #FORMAT_R32G32_UINT, #FORMAT_R32G32_SINT, and #FORMAT_R32G32_SFLOAT from {@code StorageImageExtendedFormats} SPIR-V capability, are already covered by core Vulkan <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-mandatory-features-32bit">mandatory format support</a>.
                </div>
            </li>
        </ul>""")
    VkBool32("shaderStorageImageMultisample", "specifies whether multisampled storage images are supported. If this feature is not enabled, images that are created with a {@code usage} that includes #IMAGE_USAGE_STORAGE_BIT <b>must</b> be created with {@code samples} equal to #SAMPLE_COUNT_1_BIT. This also specifies whether shader modules <b>can</b> declare the {@code StorageImageMultisample} and {@code ImageMSArray} capabilities.")
    VkBool32("shaderStorageImageReadWithoutFormat", "specifies whether storage images and storage texel buffers require a format qualifier to be specified when reading. {@code shaderStorageImageReadWithoutFormat} applies only to formats listed in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#formats-without-shader-storage-format\">storage without format</a> list.")
    VkBool32("shaderStorageImageWriteWithoutFormat", "specifies whether storage images and storage texel buffers require a format qualifier to be specified when writing. {@code shaderStorageImageWriteWithoutFormat} applies only to formats listed in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#formats-without-shader-storage-format\">storage without format</a> list.")
    VkBool32("shaderUniformBufferArrayDynamicIndexing", "specifies whether arrays of uniform buffers <b>can</b> be indexed by integer expressions that are dynamically uniform within either the subgroup or the invocation group in shader code. If this feature is not enabled, resources with a descriptor type of #DESCRIPTOR_TYPE_UNIFORM_BUFFER or #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC <b>must</b> be indexed only by constant integral expressions when aggregated into arrays in shader code. This also specifies whether shader modules <b>can</b> declare the {@code UniformBufferArrayDynamicIndexing} capability.")
    VkBool32("shaderSampledImageArrayDynamicIndexing", "specifies whether arrays of samplers or sampled images <b>can</b> be indexed by integer expressions that are dynamically uniform within either the subgroup or the invocation group in shader code. If this feature is not enabled, resources with a descriptor type of #DESCRIPTOR_TYPE_SAMPLER, #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, or #DESCRIPTOR_TYPE_SAMPLED_IMAGE <b>must</b> be indexed only by constant integral expressions when aggregated into arrays in shader code. This also specifies whether shader modules <b>can</b> declare the {@code SampledImageArrayDynamicIndexing} capability.")
    VkBool32("shaderStorageBufferArrayDynamicIndexing", "specifies whether arrays of storage buffers <b>can</b> be indexed by integer expressions that are dynamically uniform within either the subgroup or the invocation group in shader code. If this feature is not enabled, resources with a descriptor type of #DESCRIPTOR_TYPE_STORAGE_BUFFER or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC <b>must</b> be indexed only by constant integral expressions when aggregated into arrays in shader code. This also specifies whether shader modules <b>can</b> declare the {@code StorageBufferArrayDynamicIndexing} capability.")
    VkBool32("shaderStorageImageArrayDynamicIndexing", "specifies whether arrays of storage images <b>can</b> be indexed by integer expressions that are dynamically uniform within either the subgroup or the invocation group in shader code. If this feature is not enabled, resources with a descriptor type of #DESCRIPTOR_TYPE_STORAGE_IMAGE <b>must</b> be indexed only by constant integral expressions when aggregated into arrays in shader code. This also specifies whether shader modules <b>can</b> declare the {@code StorageImageArrayDynamicIndexing} capability.")
    VkBool32("shaderClipDistance", "specifies whether clip distances are supported in shader code. If this feature is not enabled, any members decorated with the {@code ClipDistance} built-in decoration <b>must</b> not be read from or written to in shader modules. This also specifies whether shader modules <b>can</b> declare the {@code ClipDistance} capability.")
    VkBool32("shaderCullDistance", "specifies whether cull distances are supported in shader code. If this feature is not enabled, any members decorated with the {@code CullDistance} built-in decoration <b>must</b> not be read from or written to in shader modules. This also specifies whether shader modules <b>can</b> declare the {@code CullDistance} capability.")
    VkBool32("shaderFloat64", "specifies whether 64-bit floats (doubles) are supported in shader code. If this feature is not enabled, 64-bit floating-point types <b>must</b> not be used in shader code. This also specifies whether shader modules <b>can</b> declare the {@code Float64} capability. Declaring and using 64-bit floats is enabled for all storage classes that SPIR-V allows with the {@code Float64} capability.")
    VkBool32("shaderInt64", "specifies whether 64-bit integers (signed and unsigned) are supported in shader code. If this feature is not enabled, 64-bit integer types <b>must</b> not be used in shader code. This also specifies whether shader modules <b>can</b> declare the {@code Int64} capability. Declaring and using 64-bit integers is enabled for all storage classes that SPIR-V allows with the {@code Int64} capability.")
    VkBool32("shaderInt16", "specifies whether 16-bit integers (signed and unsigned) are supported in shader code. If this feature is not enabled, 16-bit integer types <b>must</b> not be used in shader code. This also specifies whether shader modules <b>can</b> declare the {@code Int16} capability. However, this only enables a subset of the storage classes that SPIR-V allows for the {@code Int16} SPIR-V capability: Declaring and using 16-bit integers in the {@code Private}, {@code Workgroup} (for non-Block variables), and {@code Function} storage classes is enabled, while declaring them in the interface storage classes (e.g., {@code UniformConstant}, {@code Uniform}, {@code StorageBuffer}, {@code Input}, {@code Output}, and {@code PushConstant}) is not enabled.")
    VkBool32("shaderResourceResidency", "specifies whether image operations that return resource residency information are supported in shader code. If this feature is not enabled, the {@code OpImageSparse*} instructions <b>must</b> not be used in shader code. This also specifies whether shader modules <b>can</b> declare the {@code SparseResidency} capability. The feature requires at least one of the {@code sparseResidency*} features to be supported.")
    VkBool32("shaderResourceMinLod", "specifies whether image operations specifying the minimum resource LOD are supported in shader code. If this feature is not enabled, the {@code MinLod} image operand <b>must</b> not be used in shader code. This also specifies whether shader modules <b>can</b> declare the {@code MinLod} capability.")
    VkBool32("sparseBinding", "specifies whether resource memory <b>can</b> be managed at opaque sparse block level instead of at the object level. If this feature is not enabled, resource memory <b>must</b> be bound only on a per-object basis using the #BindBufferMemory() and #BindImageMemory() commands. In this case, buffers and images <b>must</b> not be created with #BUFFER_CREATE_SPARSE_BINDING_BIT and #IMAGE_CREATE_SPARSE_BINDING_BIT set in the {@code flags} member of the ##VkBufferCreateInfo and ##VkImageCreateInfo structures, respectively. Otherwise resource memory <b>can</b> be managed as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#sparsememory-sparseresourcefeatures\">Sparse Resource Features</a>.")
    VkBool32("sparseResidencyBuffer", "specifies whether the device <b>can</b> access partially resident buffers. If this feature is not enabled, buffers <b>must</b> not be created with #BUFFER_CREATE_SPARSE_RESIDENCY_BIT set in the {@code flags} member of the ##VkBufferCreateInfo structure.")
    VkBool32("sparseResidencyImage2D", "specifies whether the device <b>can</b> access partially resident 2D images with 1 sample per pixel. If this feature is not enabled, images with an {@code imageType} of #IMAGE_TYPE_2D and {@code samples} set to #SAMPLE_COUNT_1_BIT <b>must</b> not be created with #IMAGE_CREATE_SPARSE_RESIDENCY_BIT set in the {@code flags} member of the ##VkImageCreateInfo structure.")
    VkBool32("sparseResidencyImage3D", "specifies whether the device <b>can</b> access partially resident 3D images. If this feature is not enabled, images with an {@code imageType} of #IMAGE_TYPE_3D <b>must</b> not be created with #IMAGE_CREATE_SPARSE_RESIDENCY_BIT set in the {@code flags} member of the ##VkImageCreateInfo structure.")
    VkBool32("sparseResidency2Samples", "specifies whether the physical device <b>can</b> access partially resident 2D images with 2 samples per pixel. If this feature is not enabled, images with an {@code imageType} of #IMAGE_TYPE_2D and {@code samples} set to #SAMPLE_COUNT_2_BIT <b>must</b> not be created with #IMAGE_CREATE_SPARSE_RESIDENCY_BIT set in the {@code flags} member of the ##VkImageCreateInfo structure.")
    VkBool32("sparseResidency4Samples", "specifies whether the physical device <b>can</b> access partially resident 2D images with 4 samples per pixel. If this feature is not enabled, images with an {@code imageType} of #IMAGE_TYPE_2D and {@code samples} set to #SAMPLE_COUNT_4_BIT <b>must</b> not be created with #IMAGE_CREATE_SPARSE_RESIDENCY_BIT set in the {@code flags} member of the ##VkImageCreateInfo structure.")
    VkBool32("sparseResidency8Samples", "specifies whether the physical device <b>can</b> access partially resident 2D images with 8 samples per pixel. If this feature is not enabled, images with an {@code imageType} of #IMAGE_TYPE_2D and {@code samples} set to #SAMPLE_COUNT_8_BIT <b>must</b> not be created with #IMAGE_CREATE_SPARSE_RESIDENCY_BIT set in the {@code flags} member of the ##VkImageCreateInfo structure.")
    VkBool32("sparseResidency16Samples", "specifies whether the physical device <b>can</b> access partially resident 2D images with 16 samples per pixel. If this feature is not enabled, images with an {@code imageType} of #IMAGE_TYPE_2D and {@code samples} set to #SAMPLE_COUNT_16_BIT <b>must</b> not be created with #IMAGE_CREATE_SPARSE_RESIDENCY_BIT set in the {@code flags} member of the ##VkImageCreateInfo structure.")
    VkBool32("sparseResidencyAliased", "specifies whether the physical device <b>can</b> correctly access data aliased into multiple locations. If this feature is not enabled, the #BUFFER_CREATE_SPARSE_ALIASED_BIT and #IMAGE_CREATE_SPARSE_ALIASED_BIT enum values <b>must</b> not be used in {@code flags} members of the ##VkBufferCreateInfo and ##VkImageCreateInfo structures, respectively.")
    VkBool32("variableMultisampleRate", "specifies whether all pipelines that will be bound to a command buffer during a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#renderpass-noattachments\">subpass which uses no attachments</a> <b>must</b> have the same value for ##VkPipelineMultisampleStateCreateInfo{@code ::rasterizationSamples}. If set to #TRUE, the implementation supports variable multisample rates in a subpass which uses no attachments. If set to #FALSE, then all pipelines bound in such a subpass <b>must</b> have the same multisample rate. This has no effect in situations where a subpass uses any attachments.")
    VkBool32("inheritedQueries", "specifies whether a secondary command buffer <b>may</b> be executed while a query is active.")
}

val VkPhysicalDeviceLimits = struct(Module.VULKAN, "VkPhysicalDeviceLimits", mutable = false) {
    documentation =
        """
        Structure reporting implementation-dependent physical device limits.

        <h5>Description</h5>
        <dl>
            <dt>1</dt>
            <dd>For all bitmasks of {@code VkSampleCountFlagBits}, the sample count limits defined above represent the minimum supported sample counts for each image type. Individual images <b>may</b> support additional sample counts, which are queried using #GetPhysicalDeviceImageFormatProperties() as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-supported-sample-counts">Supported Sample Counts</a>.</dd>
        </dl>

        <h5>See Also</h5>
        ##VkPhysicalDeviceProperties
        """

    uint32_t("maxImageDimension1D", "the largest dimension ({@code width}) that is guaranteed to be supported for all images created with an {@code imageType} of #IMAGE_TYPE_1D. Some combinations of image parameters (format, usage, etc.) <b>may</b> allow support for larger dimensions, which <b>can</b> be queried using #GetPhysicalDeviceImageFormatProperties().")
    uint32_t("maxImageDimension2D", "the largest dimension ({@code width} or {@code height}) that is guaranteed to be supported for all images created with an {@code imageType} of #IMAGE_TYPE_2D and without #IMAGE_CREATE_CUBE_COMPATIBLE_BIT set in {@code flags}. Some combinations of image parameters (format, usage, etc.) <b>may</b> allow support for larger dimensions, which <b>can</b> be queried using #GetPhysicalDeviceImageFormatProperties().")
    uint32_t("maxImageDimension3D", "the largest dimension ({@code width}, {@code height}, or {@code depth}) that is guaranteed to be supported for all images created with an {@code imageType} of #IMAGE_TYPE_3D. Some combinations of image parameters (format, usage, etc.) <b>may</b> allow support for larger dimensions, which <b>can</b> be queried using #GetPhysicalDeviceImageFormatProperties().")
    uint32_t("maxImageDimensionCube", "the largest dimension ({@code width} or {@code height}) that is guaranteed to be supported for all images created with an {@code imageType} of #IMAGE_TYPE_2D and with #IMAGE_CREATE_CUBE_COMPATIBLE_BIT set in {@code flags}. Some combinations of image parameters (format, usage, etc.) <b>may</b> allow support for larger dimensions, which <b>can</b> be queried using #GetPhysicalDeviceImageFormatProperties().")
    uint32_t("maxImageArrayLayers", "the maximum number of layers ({@code arrayLayers}) for an image.")
    uint32_t("maxTexelBufferElements", "the maximum number of addressable texels for a buffer view created on a buffer which was created with the #BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT or #BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT set in the {@code usage} member of the ##VkBufferCreateInfo structure.")
    uint32_t("maxUniformBufferRange", "the maximum value that <b>can</b> be specified in the {@code range} member of a ##VkDescriptorBufferInfo structure passed to #UpdateDescriptorSets() for descriptors of type #DESCRIPTOR_TYPE_UNIFORM_BUFFER or #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC.")
    uint32_t("maxStorageBufferRange", "the maximum value that <b>can</b> be specified in the {@code range} member of a ##VkDescriptorBufferInfo structure passed to #UpdateDescriptorSets() for descriptors of type #DESCRIPTOR_TYPE_STORAGE_BUFFER or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC.")
    uint32_t("maxPushConstantsSize", "the maximum size, in bytes, of the pool of push constant memory. For each of the push constant ranges indicated by the {@code pPushConstantRanges} member of the ##VkPipelineLayoutCreateInfo structure, <code>(offset + size)</code> <b>must</b> be less than or equal to this limit.")
    uint32_t("maxMemoryAllocationCount", "the maximum number of device memory allocations, as created by #AllocateMemory(), which <b>can</b> simultaneously exist.")
    uint32_t("maxSamplerAllocationCount", "the maximum number of sampler objects, as created by #CreateSampler(), which <b>can</b> simultaneously exist on a device.")
    VkDeviceSize("bufferImageGranularity", "the granularity, in bytes, at which buffer or linear image resources, and optimal image resources <b>can</b> be bound to adjacent offsets in the same {@code VkDeviceMemory} object without aliasing. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#resources-bufferimagegranularity\">Buffer-Image Granularity</a> for more details.")
    VkDeviceSize("sparseAddressSpaceSize", "the total amount of address space available, in bytes, for sparse memory resources. This is an upper bound on the sum of the sizes of all sparse resources, regardless of whether any memory is bound to them. If the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-extendedSparseAddressSpace\">{@code extendedSparseAddressSpace}</a> feature is enabled, then the difference between <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-extendedSparseAddressSpaceSize\">{@code extendedSparseAddressSpaceSize}</a> and {@code sparseAddressSpaceSize} can also be used, by {@code VkImage} created with the {@code usage} member of ##VkImageCreateInfo only containing bits in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-extendedSparseImageUsageFlags\">{@code extendedSparseImageUsageFlags}</a> and {@code VkBuffer} created with the {@code usage} member of ##VkBufferCreateInfo only containing bits in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-extendedSparseBufferUsageFlags\">{@code extendedSparseBufferUsageFlags}</a>.")
    uint32_t("maxBoundDescriptorSets", "the maximum number of descriptor sets that <b>can</b> be simultaneously used by a pipeline. All {@code DescriptorSet} decorations in shader modules <b>must</b> have a value less than {@code maxBoundDescriptorSets}. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-sets\">Descriptor Sets</a>.")
    uint32_t("maxPerStageDescriptorSamplers", "the maximum number of samplers that <b>can</b> be accessible to a single shader stage in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_SAMPLER or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. A descriptor is accessible to a shader stage when the {@code stageFlags} member of the ##VkDescriptorSetLayoutBinding structure has the bit for that shader stage set. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-sampler\">Sampler</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-combinedimagesampler\">Combined Image Sampler</a>.")
    uint32_t("maxPerStageDescriptorUniformBuffers", "the maximum number of uniform buffers that <b>can</b> be accessible to a single shader stage in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_UNIFORM_BUFFER or #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. A descriptor is accessible to a shader stage when the {@code stageFlags} member of the ##VkDescriptorSetLayoutBinding structure has the bit for that shader stage set. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-uniformbuffer\">Uniform Buffer</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-uniformbufferdynamic\">Dynamic Uniform Buffer</a>.")
    uint32_t("maxPerStageDescriptorStorageBuffers", "the maximum number of storage buffers that <b>can</b> be accessible to a single shader stage in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_STORAGE_BUFFER or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. A descriptor is accessible to a pipeline shader stage when the {@code stageFlags} member of the ##VkDescriptorSetLayoutBinding structure has the bit for that shader stage set. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-storagebuffer\">Storage Buffer</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-storagebufferdynamic\">Dynamic Storage Buffer</a>.")
    uint32_t("maxPerStageDescriptorSampledImages", "the maximum number of sampled images that <b>can</b> be accessible to a single shader stage in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, or #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. A descriptor is accessible to a pipeline shader stage when the {@code stageFlags} member of the ##VkDescriptorSetLayoutBinding structure has the bit for that shader stage set. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-combinedimagesampler\">Combined Image Sampler</a>, <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-sampledimage\">Sampled Image</a>, and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-uniformtexelbuffer\">Uniform Texel Buffer</a>.")
    uint32_t("maxPerStageDescriptorStorageImages", "the maximum number of storage images that <b>can</b> be accessible to a single shader stage in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_STORAGE_IMAGE, or #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. A descriptor is accessible to a pipeline shader stage when the {@code stageFlags} member of the ##VkDescriptorSetLayoutBinding structure has the bit for that shader stage set. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-storageimage\">Storage Image</a>, and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-storagetexelbuffer\">Storage Texel Buffer</a>.")
    uint32_t("maxPerStageDescriptorInputAttachments", "the maximum number of input attachments that <b>can</b> be accessible to a single shader stage in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_INPUT_ATTACHMENT count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. A descriptor is accessible to a pipeline shader stage when the {@code stageFlags} member of the ##VkDescriptorSetLayoutBinding structure has the bit for that shader stage set. These are only supported for the fragment stage. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-inputattachment\">Input Attachment</a>.")
    uint32_t("maxPerStageResources", "the maximum number of resources that <b>can</b> be accessible to a single shader stage in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, #DESCRIPTOR_TYPE_STORAGE_IMAGE, #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, #DESCRIPTOR_TYPE_UNIFORM_BUFFER, #DESCRIPTOR_TYPE_STORAGE_BUFFER, #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, or #DESCRIPTOR_TYPE_INPUT_ATTACHMENT count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. For the fragment shader stage the framebuffer color attachments also count against this limit.")
    uint32_t("maxDescriptorSetSamplers", "the maximum number of samplers that <b>can</b> be included in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_SAMPLER or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-sampler\">Sampler</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-combinedimagesampler\">Combined Image Sampler</a>.")
    uint32_t("maxDescriptorSetUniformBuffers", "the maximum number of uniform buffers that <b>can</b> be included in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_UNIFORM_BUFFER or #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-uniformbuffer\">Uniform Buffer</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-uniformbufferdynamic\">Dynamic Uniform Buffer</a>.")
    uint32_t("maxDescriptorSetUniformBuffersDynamic", "the maximum number of dynamic uniform buffers that <b>can</b> be included in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-uniformbufferdynamic\">Dynamic Uniform Buffer</a>.")
    uint32_t("maxDescriptorSetStorageBuffers", "the maximum number of storage buffers that <b>can</b> be included in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_STORAGE_BUFFER or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-storagebuffer\">Storage Buffer</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-storagebufferdynamic\">Dynamic Storage Buffer</a>.")
    uint32_t("maxDescriptorSetStorageBuffersDynamic", "the maximum number of dynamic storage buffers that <b>can</b> be included in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-storagebufferdynamic\">Dynamic Storage Buffer</a>.")
    uint32_t("maxDescriptorSetSampledImages", "the maximum number of sampled images that <b>can</b> be included in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, or #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-combinedimagesampler\">Combined Image Sampler</a>, <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-sampledimage\">Sampled Image</a>, and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-uniformtexelbuffer\">Uniform Texel Buffer</a>.")
    uint32_t("maxDescriptorSetStorageImages", "the maximum number of storage images that <b>can</b> be included in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_STORAGE_IMAGE, or #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-storageimage\">Storage Image</a>, and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-storagetexelbuffer\">Storage Texel Buffer</a>.")
    uint32_t("maxDescriptorSetInputAttachments", "the maximum number of input attachments that <b>can</b> be included in a pipeline layout. Descriptors with a type of #DESCRIPTOR_TYPE_INPUT_ATTACHMENT count against this limit. Only descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-inputattachment\">Input Attachment</a>.")
    uint32_t("maxVertexInputAttributes", "the maximum number of vertex input attributes that <b>can</b> be specified for a graphics pipeline. These are described in the array of ##VkVertexInputAttributeDescription structures that are provided at graphics pipeline creation time via the {@code pVertexAttributeDescriptions} member of the ##VkPipelineVertexInputStateCreateInfo structure. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fxvertex-attrib\">Vertex Attributes</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fxvertex-input\">Vertex Input Description</a>.")
    uint32_t("maxVertexInputBindings", "the maximum number of vertex buffers that <b>can</b> be specified for providing vertex attributes to a graphics pipeline. These are described in the array of ##VkVertexInputBindingDescription structures that are provided at graphics pipeline creation time via the {@code pVertexBindingDescriptions} member of the ##VkPipelineVertexInputStateCreateInfo structure. The {@code binding} member of ##VkVertexInputBindingDescription <b>must</b> be less than this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fxvertex-input\">Vertex Input Description</a>.")
    uint32_t("maxVertexInputAttributeOffset", "the maximum vertex input attribute offset that <b>can</b> be added to the vertex input binding stride. The {@code offset} member of the ##VkVertexInputAttributeDescription structure <b>must</b> be less than or equal to this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fxvertex-input\">Vertex Input Description</a>.")
    uint32_t("maxVertexInputBindingStride", "the maximum vertex input binding stride that <b>can</b> be specified in a vertex input binding. The {@code stride} member of the ##VkVertexInputBindingDescription structure <b>must</b> be less than or equal to this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fxvertex-input\">Vertex Input Description</a>.")
    uint32_t("maxVertexOutputComponents", "the maximum number of components of output variables which <b>can</b> be output by a vertex shader. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#shaders-vertex\">Vertex Shaders</a>.")
    uint32_t("maxTessellationGenerationLevel", "the maximum tessellation generation level supported by the fixed-function tessellation primitive generator. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#tessellation\">Tessellation</a>.")
    uint32_t("maxTessellationPatchSize", "the maximum patch size, in vertices, of patches that <b>can</b> be processed by the tessellation control shader and tessellation primitive generator. The {@code patchControlPoints} member of the ##VkPipelineTessellationStateCreateInfo structure specified at pipeline creation time and the value provided in the {@code OutputVertices} execution mode of shader modules <b>must</b> be less than or equal to this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#tessellation\">Tessellation</a>.")
    uint32_t("maxTessellationControlPerVertexInputComponents", "the maximum number of components of input variables which <b>can</b> be provided as per-vertex inputs to the tessellation control shader stage.")
    uint32_t("maxTessellationControlPerVertexOutputComponents", "the maximum number of components of per-vertex output variables which <b>can</b> be output from the tessellation control shader stage.")
    uint32_t("maxTessellationControlPerPatchOutputComponents", "the maximum number of components of per-patch output variables which <b>can</b> be output from the tessellation control shader stage.")
    uint32_t("maxTessellationControlTotalOutputComponents", "the maximum total number of components of per-vertex and per-patch output variables which <b>can</b> be output from the tessellation control shader stage.")
    uint32_t("maxTessellationEvaluationInputComponents", "the maximum number of components of input variables which <b>can</b> be provided as per-vertex inputs to the tessellation evaluation shader stage.")
    uint32_t("maxTessellationEvaluationOutputComponents", "the maximum number of components of per-vertex output variables which <b>can</b> be output from the tessellation evaluation shader stage.")
    uint32_t("maxGeometryShaderInvocations", "the maximum invocation count supported for instanced geometry shaders. The value provided in the {@code Invocations} execution mode of shader modules <b>must</b> be less than or equal to this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#geometry\">Geometry Shading</a>.")
    uint32_t("maxGeometryInputComponents", "the maximum number of components of input variables which <b>can</b> be provided as inputs to the geometry shader stage.")
    uint32_t("maxGeometryOutputComponents", "the maximum number of components of output variables which <b>can</b> be output from the geometry shader stage.")
    uint32_t("maxGeometryOutputVertices", "the maximum number of vertices which <b>can</b> be emitted by any geometry shader.")
    uint32_t("maxGeometryTotalOutputComponents", "the maximum total number of components of output variables, across all emitted vertices, which <b>can</b> be output from the geometry shader stage.")
    uint32_t("maxFragmentInputComponents", "the maximum number of components of input variables which <b>can</b> be provided as inputs to the fragment shader stage.")
    uint32_t("maxFragmentOutputAttachments", "the maximum number of output attachments which <b>can</b> be written to by the fragment shader stage.")
    uint32_t("maxFragmentDualSrcAttachments", "the maximum number of output attachments which <b>can</b> be written to by the fragment shader stage when blending is enabled and one of the dual source blend modes is in use. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#framebuffer-dsb\">Dual-Source Blending</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-dualSrcBlend\">{@code dualSrcBlend}</a>.")
    uint32_t("maxFragmentCombinedOutputResources", "the total number of storage buffers, storage images, and output {@code Location} decorated color attachments (described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#interfaces-fragmentoutput\">Fragment Output Interface</a>) which <b>can</b> be used in the fragment shader stage.")
    uint32_t("maxComputeSharedMemorySize", "the maximum total storage size, in bytes, available for variables declared with the {@code Workgroup} storage class in shader modules (or with the {@code shared} storage qualifier in GLSL) in the compute shader stage.")
    uint32_t("maxComputeWorkGroupCount", "the maximum number of local workgroups that <b>can</b> be dispatched by a single dispatching command. These three values represent the maximum number of local workgroups for the X, Y, and Z dimensions, respectively. The workgroup count parameters to the dispatching commands <b>must</b> be less than or equal to the corresponding limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#dispatch\">Dispatching Commands</a>.")[3]
    uint32_t("maxComputeWorkGroupInvocations", "the maximum total number of compute shader invocations in a single local workgroup. The product of the X, Y, and Z sizes, as specified by the {@code LocalSize} or {@code LocalSizeId} execution mode in shader modules or by the object decorated by the {@code WorkgroupSize} decoration, <b>must</b> be less than or equal to this limit.")
    uint32_t("maxComputeWorkGroupSize", "the maximum size of a local compute workgroup, per dimension. These three values represent the maximum local workgroup size in the X, Y, and Z dimensions, respectively. The {@code x}, {@code y}, and {@code z} sizes, as specified by the {@code LocalSize} or {@code LocalSizeId} execution mode or by the object decorated by the {@code WorkgroupSize} decoration in shader modules, <b>must</b> be less than or equal to the corresponding limit.")[3]
    uint32_t("subPixelPrecisionBits", "the number of bits of subpixel precision in framebuffer coordinates <code>x<sub>f</sub></code> and <code>y<sub>f</sub></code>. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast\">Rasterization</a>.")
    uint32_t("subTexelPrecisionBits", "the number of bits of precision in the division along an axis of an image used for minification and magnification filters. <code>2<sup>subTexelPrecisionBits</sup></code> is the actual number of divisions along each axis of the image represented. Sub-texel values calculated during image sampling will snap to these locations when generating the filtered results.")
    uint32_t("mipmapPrecisionBits", "the number of bits of division that the LOD calculation for mipmap fetching get snapped to when determining the contribution from each mip level to the mip filtered results. <code>2<sup>mipmapPrecisionBits</sup></code> is the actual number of divisions.")
    uint32_t("maxDrawIndexedIndexValue", "the maximum index value that <b>can</b> be used for indexed draw calls when using 32-bit indices. This excludes the primitive restart index value of 0xFFFFFFFF. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-fullDrawIndexUint32\">{@code fullDrawIndexUint32}</a>.")
    uint32_t("maxDrawIndirectCount", "the maximum draw count that is supported for indirect drawing calls. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-multiDrawIndirect\">{@code multiDrawIndirect}</a>.")
    float("maxSamplerLodBias", "the maximum absolute sampler LOD bias. The sum of the {@code mipLodBias} member of the ##VkSamplerCreateInfo structure and the {@code Bias} operand of image sampling operations in shader modules (or 0 if no {@code Bias} operand is provided to an image sampling operation) are clamped to the range <code>[-maxSamplerLodBias,+maxSamplerLodBias]</code>. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#samplers-mipLodBias\">samplers-mipLodBias</a>.")
    float("maxSamplerAnisotropy", "the maximum degree of sampler anisotropy. The maximum degree of anisotropic filtering used for an image sampling operation is the minimum of the {@code maxAnisotropy} member of the ##VkSamplerCreateInfo structure and this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#samplers-maxAnisotropy\">samplers-maxAnisotropy</a>.")
    uint32_t("maxViewports", "the maximum number of active viewports. The {@code viewportCount} member of the ##VkPipelineViewportStateCreateInfo structure that is provided at pipeline creation <b>must</b> be less than or equal to this limit.")
    uint32_t("maxViewportDimensions", "are the maximum viewport dimensions in the X (width) and Y (height) dimensions, respectively. The maximum viewport dimensions <b>must</b> be greater than or equal to the largest image which <b>can</b> be created and used as a framebuffer attachment. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#vertexpostproc-viewport\">Controlling the Viewport</a>.")[2]
    float("viewportBoundsRange", """the <code>[minimum, maximum]</code> range that the corners of a viewport <b>must</b> be contained in. This range <b>must</b> be at least <code>[-2 × size, 2 × size - 1]</code>, where <code>size = max(maxViewportDimensions[0], maxViewportDimensions[1])</code>. See <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#vertexpostproc-viewport">Controlling the Viewport</a>.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The intent of the {@code viewportBoundsRange} limit is to allow a maximum sized viewport to be arbitrarily shifted relative to the output target as long as at least some portion intersects. This would give a bounds limit of <code>[-size + 1, 2 × size - 1]</code> which would allow all possible non-empty-set intersections of the output target and the viewport. Since these numbers are typically powers of two, picking the signed number range using the smallest possible number of bits ends up with the specified range.
        </div>""")[2]
    uint32_t("viewportSubPixelBits", "the number of bits of subpixel precision for viewport bounds. The subpixel precision that floating-point viewport bounds are interpreted at is given by this limit.")
    size_t("minMemoryMapAlignment", "the minimum <b>required</b> alignment, in bytes, of host visible memory allocations within the host address space. When mapping a memory allocation with #MapMemory(), subtracting {@code offset} bytes from the returned pointer will always produce an integer multiple of this limit. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#memory-device-hostaccess\">Host Access to Device Memory Objects</a>. The value <b>must</b> be a power of two.")
    VkDeviceSize("minTexelBufferOffsetAlignment", "the minimum <b>required</b> alignment, in bytes, for the {@code offset} member of the ##VkBufferViewCreateInfo structure for texel buffers. The value <b>must</b> be a power of two. If the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-texelBufferAlignment\">{@code texelBufferAlignment}</a> feature is enabled, this limit is equivalent to the maximum of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-uniformTexelBufferOffsetAlignmentBytes\">{@code uniformTexelBufferOffsetAlignmentBytes}</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-storageTexelBufferOffsetAlignmentBytes\">{@code storageTexelBufferOffsetAlignmentBytes}</a> members of ##VkPhysicalDeviceTexelBufferAlignmentProperties, but smaller alignment is <b>optionally</b> allowed by <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-storageTexelBufferOffsetSingleTexelAlignment\">{@code storageTexelBufferOffsetSingleTexelAlignment}</a> and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-uniformTexelBufferOffsetSingleTexelAlignment\">{@code uniformTexelBufferOffsetSingleTexelAlignment}</a>. If the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-texelBufferAlignment\">{@code texelBufferAlignment}</a> feature is not enabled, ##VkBufferViewCreateInfo{@code ::offset} <b>must</b> be a multiple of this value.")
    VkDeviceSize("minUniformBufferOffsetAlignment", "the minimum <b>required</b> alignment, in bytes, for the {@code offset} member of the ##VkDescriptorBufferInfo structure for uniform buffers. When a descriptor of type #DESCRIPTOR_TYPE_UNIFORM_BUFFER or #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC is updated, the {@code offset} <b>must</b> be an integer multiple of this limit. Similarly, dynamic offsets for uniform buffers <b>must</b> be multiples of this limit. The value <b>must</b> be a power of two.")
    VkDeviceSize("minStorageBufferOffsetAlignment", "the minimum <b>required</b> alignment, in bytes, for the {@code offset} member of the ##VkDescriptorBufferInfo structure for storage buffers. When a descriptor of type #DESCRIPTOR_TYPE_STORAGE_BUFFER or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC is updated, the {@code offset} <b>must</b> be an integer multiple of this limit. Similarly, dynamic offsets for storage buffers <b>must</b> be multiples of this limit. The value <b>must</b> be a power of two.")
    int32_t("minTexelOffset", "the minimum offset value for the {@code ConstOffset} image operand of any of the {@code OpImageSample*} or {@code OpImageFetch*} image instructions.")
    uint32_t("maxTexelOffset", "the maximum offset value for the {@code ConstOffset} image operand of any of the {@code OpImageSample*} or {@code OpImageFetch*} image instructions.")
    int32_t("minTexelGatherOffset", "the minimum offset value for the {@code Offset}, {@code ConstOffset}, or {@code ConstOffsets} image operands of any of the {@code OpImage*Gather} image instructions.")
    uint32_t("maxTexelGatherOffset", "the maximum offset value for the {@code Offset}, {@code ConstOffset}, or {@code ConstOffsets} image operands of any of the {@code OpImage*Gather} image instructions.")
    float("minInterpolationOffset", "the base minimum (inclusive) negative offset value for the {@code Offset} operand of the {@code InterpolateAtOffset} extended instruction.")
    float("maxInterpolationOffset", "the base maximum (inclusive) positive offset value for the {@code Offset} operand of the {@code InterpolateAtOffset} extended instruction.")
    uint32_t("subPixelInterpolationOffsetBits", "the number of fractional bits that the {@code x} and {@code y} offsets to the {@code InterpolateAtOffset} extended instruction <b>may</b> be rounded to as fixed-point values.")
    uint32_t("maxFramebufferWidth", "the maximum width for a framebuffer. The {@code width} member of the ##VkFramebufferCreateInfo structure <b>must</b> be less than or equal to this limit.")
    uint32_t("maxFramebufferHeight", "the maximum height for a framebuffer. The {@code height} member of the ##VkFramebufferCreateInfo structure <b>must</b> be less than or equal to this limit.")
    uint32_t("maxFramebufferLayers", "the maximum layer count for a layered framebuffer. The {@code layers} member of the ##VkFramebufferCreateInfo structure <b>must</b> be less than or equal to this limit.")
    VkSampleCountFlags("framebufferColorSampleCounts", "a bitmask<sup>1</sup> of {@code VkSampleCountFlagBits} indicating the color sample counts that are supported for all framebuffer color attachments with floating- or fixed-point formats. For color attachments with integer formats, see <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-framebufferIntegerColorSampleCounts\">{@code framebufferIntegerColorSampleCounts}</a>.")
    VkSampleCountFlags("framebufferDepthSampleCounts", "a bitmask<sup>1</sup> of {@code VkSampleCountFlagBits} indicating the supported depth sample counts for all framebuffer depth/stencil attachments, when the format includes a depth component.")
    VkSampleCountFlags("framebufferStencilSampleCounts", "a bitmask<sup>1</sup> of {@code VkSampleCountFlagBits} indicating the supported stencil sample counts for all framebuffer depth/stencil attachments, when the format includes a stencil component.")
    VkSampleCountFlags("framebufferNoAttachmentsSampleCounts", "a bitmask<sup>1</sup> of {@code VkSampleCountFlagBits} indicating the supported sample counts for a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#renderpass-noattachments\">subpass which uses no attachments</a>.")
    uint32_t("maxColorAttachments", "the maximum number of color attachments that <b>can</b> be used by a subpass in a render pass. The {@code colorAttachmentCount} member of the ##VkSubpassDescription or ##VkSubpassDescription2 structure <b>must</b> be less than or equal to this limit.")
    VkSampleCountFlags("sampledImageColorSampleCounts", "a bitmask<sup>1</sup> of {@code VkSampleCountFlagBits} indicating the sample counts supported for all 2D images created with #IMAGE_TILING_OPTIMAL, {@code usage} containing #IMAGE_USAGE_SAMPLED_BIT, and a non-integer color format.")
    VkSampleCountFlags("sampledImageIntegerSampleCounts", "a bitmask<sup>1</sup> of {@code VkSampleCountFlagBits} indicating the sample counts supported for all 2D images created with #IMAGE_TILING_OPTIMAL, {@code usage} containing #IMAGE_USAGE_SAMPLED_BIT, and an integer color format.")
    VkSampleCountFlags("sampledImageDepthSampleCounts", "a bitmask<sup>1</sup> of {@code VkSampleCountFlagBits} indicating the sample counts supported for all 2D images created with #IMAGE_TILING_OPTIMAL, {@code usage} containing #IMAGE_USAGE_SAMPLED_BIT, and a depth format.")
    VkSampleCountFlags("sampledImageStencilSampleCounts", "a bitmask<sup>1</sup> of {@code VkSampleCountFlagBits} indicating the sample counts supported for all 2D images created with #IMAGE_TILING_OPTIMAL, {@code usage} containing #IMAGE_USAGE_SAMPLED_BIT, and a stencil format.")
    VkSampleCountFlags("storageImageSampleCounts", "a bitmask<sup>1</sup> of {@code VkSampleCountFlagBits} indicating the sample counts supported for all 2D images created with #IMAGE_TILING_OPTIMAL, and {@code usage} containing #IMAGE_USAGE_STORAGE_BIT.")
    uint32_t("maxSampleMaskWords", "the maximum number of array elements of a variable decorated with the {@code SampleMask} built-in decoration.")
    VkBool32("timestampComputeAndGraphics", "specifies support for timestamps on all graphics and compute queues. If this limit is #TRUE, all queues that advertise the #QUEUE_GRAPHICS_BIT or #QUEUE_COMPUTE_BIT in the ##VkQueueFamilyProperties{@code ::queueFlags} support ##VkQueueFamilyProperties{@code ::timestampValidBits} of at least 36. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#queries-timestamps\">Timestamp Queries</a>.")
    float("timestampPeriod", "the number of nanoseconds <b>required</b> for a timestamp query to be incremented by 1. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#queries-timestamps\">Timestamp Queries</a>.")
    uint32_t("maxClipDistances", "the maximum number of clip distances that <b>can</b> be used in a single shader stage. The size of any array declared with the {@code ClipDistance} built-in decoration in a shader module <b>must</b> be less than or equal to this limit.")
    uint32_t("maxCullDistances", "the maximum number of cull distances that <b>can</b> be used in a single shader stage. The size of any array declared with the {@code CullDistance} built-in decoration in a shader module <b>must</b> be less than or equal to this limit.")
    uint32_t("maxCombinedClipAndCullDistances", "the maximum combined number of clip and cull distances that <b>can</b> be used in a single shader stage. The sum of the sizes of all arrays declared with the {@code ClipDistance} and {@code CullDistance} built-in decoration used by a single shader stage in a shader module <b>must</b> be less than or equal to this limit.")
    uint32_t("discreteQueuePriorities", "the number of discrete priorities that <b>can</b> be assigned to a queue based on the value of each member of ##VkDeviceQueueCreateInfo{@code ::pQueuePriorities}. This <b>must</b> be at least 2, and levels <b>must</b> be spread evenly over the range, with at least one level at 1.0, and another at 0.0. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#devsandqueues-priority\">Queue Priority</a>.")
    float("pointSizeRange", "the range <code>[minimum,maximum]</code> of supported sizes for points. Values written to variables decorated with the {@code PointSize} built-in decoration are clamped to this range.")[2]
    float("lineWidthRange", "the range <code>[minimum,maximum]</code> of supported widths for lines. Values specified by the {@code lineWidth} member of the ##VkPipelineRasterizationStateCreateInfo or the {@code lineWidth} parameter to {@code vkCmdSetLineWidth} are clamped to this range.")[2]
    float("pointSizeGranularity", "the granularity of supported point sizes. Not all point sizes in the range defined by {@code pointSizeRange} are supported. This limit specifies the granularity (or increment) between successive supported point sizes.")
    float("lineWidthGranularity", "the granularity of supported line widths. Not all line widths in the range defined by {@code lineWidthRange} are supported. This limit specifies the granularity (or increment) between successive supported line widths.")
    VkBool32("strictLines", "specifies whether lines are rasterized according to the preferred method of rasterization. If set to #FALSE, lines <b>may</b> be rasterized under a relaxed set of rules. If set to #TRUE, lines are rasterized as per the strict definition. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-lines-basic\">Basic Line Segment Rasterization</a>.")
    VkBool32("standardSampleLocations", "specifies whether rasterization uses the standard sample locations as documented in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-multisampling\">Multisampling</a>. If set to #TRUE, the implementation uses the documented sample locations. If set to #FALSE, the implementation <b>may</b> use different sample locations.")
    VkDeviceSize("optimalBufferCopyOffsetAlignment", "the optimal buffer offset alignment in bytes for #CmdCopyBufferToImage2(), #CmdCopyBufferToImage(), #CmdCopyImageToBuffer2(), and #CmdCopyImageToBuffer(). This value is also the optimal host memory offset alignment in bytes for #CopyMemoryToImage() and #CopyImageToMemory(). The per texel alignment requirements are enforced, but applications <b>should</b> use the optimal alignment for optimal performance and power use. The value <b>must</b> be a power of two.")
    VkDeviceSize("optimalBufferCopyRowPitchAlignment", "the optimal buffer row pitch alignment in bytes for #CmdCopyBufferToImage2(), #CmdCopyBufferToImage(), #CmdCopyImageToBuffer2(), and #CmdCopyImageToBuffer(). This value is also the optimal host memory row pitch alignment in bytes for #CopyMemoryToImage() and #CopyImageToMemory(). Row pitch is the number of bytes between texels with the same X coordinate in adjacent rows (Y coordinates differ by one). The per texel alignment requirements are enforced, but applications <b>should</b> use the optimal alignment for optimal performance and power use. The value <b>must</b> be a power of two.")
    VkDeviceSize("nonCoherentAtomSize", "the size and alignment in bytes that bounds concurrent access to <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#memory-device-hostaccess\">host-mapped device memory</a>. The value <b>must</b> be a power of two.")
}

val VkPhysicalDeviceMemoryProperties = struct(Module.VULKAN, "VkPhysicalDeviceMemoryProperties", mutable = false) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation =
        """
        Structure specifying physical device memory properties.

        <h5>Description</h5>
        The ##VkPhysicalDeviceMemoryProperties structure describes a number of <em>memory heaps</em> as well as a number of <em>memory types</em> that <b>can</b> be used to access memory allocated in those heaps. Each heap describes a memory resource of a particular size, and each memory type describes a set of memory properties (e.g. host cached vs. uncached) that <b>can</b> be used with a given memory heap. Allocations using a particular memory type will consume resources from the heap indicated by that memory type’s heap index. More than one memory type <b>may</b> share each heap, and the heaps and memory types provide a mechanism to advertise an accurate size of the physical memory resources while allowing the memory to be used with a variety of different properties.

        The number of memory heaps is given by {@code memoryHeapCount} and is less than or equal to #MAX_MEMORY_HEAPS. Each heap is described by an element of the {@code memoryHeaps} array as a ##VkMemoryHeap structure. The number of memory types available across all memory heaps is given by {@code memoryTypeCount} and is less than or equal to #MAX_MEMORY_TYPES. Each memory type is described by an element of the {@code memoryTypes} array as a ##VkMemoryType structure.

        At least one heap <b>must</b> include #MEMORY_HEAP_DEVICE_LOCAL_BIT in ##VkMemoryHeap{@code ::flags}. If there are multiple heaps that all have similar performance characteristics, they <b>may</b> all include #MEMORY_HEAP_DEVICE_LOCAL_BIT. In a unified memory architecture (UMA) system there is often only a single memory heap which is considered to be equally “{@code local}” to the host and to the device, and such an implementation <b>must</b> advertise the heap as device-local.

        Each memory type returned by #GetPhysicalDeviceMemoryProperties() <b>must</b> have its {@code propertyFlags} set to one of the following values:

        <ul>
            <li>0</li>
            <li>#MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT</li>
            <li>#MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_CACHED_BIT</li>
            <li>#MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_CACHED_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_CACHED_BIT</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_CACHED_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT</li>
            <li>#MEMORY_PROPERTY_PROTECTED_BIT</li>
            <li>#MEMORY_PROPERTY_PROTECTED_BIT | #MEMORY_PROPERTY_DEVICE_LOCAL_BIT</li>
            <li>#MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_CACHED_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_CACHED_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD | #MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_CACHED_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD | #MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD | #MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD | #MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_CACHED_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT | #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD | #MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD</li>
            <li>#MEMORY_PROPERTY_DEVICE_LOCAL_BIT | #MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV</li>
        </ul>

        There <b>must</b> be at least one memory type with both the #MEMORY_PROPERTY_HOST_VISIBLE_BIT and #MEMORY_PROPERTY_HOST_COHERENT_BIT bits set in its {@code propertyFlags}. There <b>must</b> be at least one memory type with the #MEMORY_PROPERTY_DEVICE_LOCAL_BIT bit set in its {@code propertyFlags}. If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-deviceCoherentMemory">{@code deviceCoherentMemory}</a> feature is enabled, there <b>must</b> be at least one memory type with the #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD bit set in its {@code propertyFlags}.

        For each pair of elements <b>X</b> and <b>Y</b> returned in {@code memoryTypes}, <b>X</b> <b>must</b> be placed at a lower index position than <b>Y</b> if:

        <ul>
            <li>the set of bit flags returned in the {@code propertyFlags} member of <b>X</b> is a strict subset of the set of bit flags returned in the {@code propertyFlags} member of <b>Y</b>; or</li>
            <li>the {@code propertyFlags} members of <b>X</b> and <b>Y</b> are equal, and <b>X</b> belongs to a memory heap with greater performance (as determined in an implementation-specific manner) ; or</li>
            <li>the {@code propertyFlags} members of <b>Y</b> includes #MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD or #MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD and <b>X</b> does not</li>
        </ul>

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        There is no ordering requirement between <b>X</b> and <b>Y</b> elements for the case their {@code propertyFlags} members are not in a subset relation. That potentially allows more than one possible way to order the same set of memory types. Notice that the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-device-bitmask-list">list of all allowed memory property flag combinations</a> is written in a valid order. But if instead #MEMORY_PROPERTY_DEVICE_LOCAL_BIT was before #MEMORY_PROPERTY_HOST_VISIBLE_BIT | #MEMORY_PROPERTY_HOST_COHERENT_BIT, the list would still be in a valid order.

        There may be a performance penalty for using device coherent or uncached device memory types, and using these accidentally is undesirable. In order to avoid this, memory types with these properties always appear at the end of the list; but are subject to the same rules otherwise.
        </div>

        This ordering requirement enables applications to use a simple search loop to select the desired memory type along the lines of:

        <pre><code>
￿// Find a memory in `memoryTypeBitsRequirement` that includes all of `requiredProperties`
￿int32_t findProperties(const VkPhysicalDeviceMemoryProperties* pMemoryProperties,
￿                       uint32_t memoryTypeBitsRequirement,
￿                       VkMemoryPropertyFlags requiredProperties) {
￿    const uint32_t memoryCount = pMemoryProperties-&gt;memoryTypeCount;
￿    for (uint32_t memoryIndex = 0; memoryIndex &lt; memoryCount; ++memoryIndex) {
￿        const uint32_t memoryTypeBits = (1 &lt;&lt; memoryIndex);
￿        const bool isRequiredMemoryType = memoryTypeBitsRequirement &amp; memoryTypeBits;
￿
￿        const VkMemoryPropertyFlags properties =
￿            pMemoryProperties-&gt;memoryTypes[memoryIndex].propertyFlags;
￿        const bool hasRequiredProperties =
￿            (properties &amp; requiredProperties) == requiredProperties;
￿
￿        if (isRequiredMemoryType &amp;&amp; hasRequiredProperties)
￿            return static_cast&lt;int32_t&gt;(memoryIndex);
￿    }
￿
￿    // failed to find memory type
￿    return -1;
￿}
￿
￿// Try to find an optimal memory type, or if it does not exist try fallback memory type
￿// `device` is the VkDevice
￿// `image` is the VkImage that requires memory to be bound
￿// `memoryProperties` properties as returned by vkGetPhysicalDeviceMemoryProperties
￿// `requiredProperties` are the property flags that must be present
￿// `optimalProperties` are the property flags that are preferred by the application
￿VkMemoryRequirements memoryRequirements;
￿vkGetImageMemoryRequirements(device, image, &amp;memoryRequirements);
￿int32_t memoryType =
￿    findProperties(&amp;memoryProperties, memoryRequirements.memoryTypeBits, optimalProperties);
￿if (memoryType == -1) // not found; try fallback properties
￿    memoryType =
￿        findProperties(&amp;memoryProperties, memoryRequirements.memoryTypeBits, requiredProperties);</code></pre>

        <h5>See Also</h5>
        ##VkMemoryHeap, ##VkMemoryType, ##VkPhysicalDeviceMemoryProperties2, #GetPhysicalDeviceMemoryProperties()
        """

    AutoSize("memoryTypes")..uint32_t("memoryTypeCount", "the number of valid elements in the {@code memoryTypes} array.")
    VkMemoryType("memoryTypes", "an array of #MAX_MEMORY_TYPES ##VkMemoryType structures describing the <em>memory types</em> that <b>can</b> be used to access memory allocated from the heaps specified by {@code memoryHeaps}.")["VK_MAX_MEMORY_TYPES"]
    AutoSize("memoryHeaps")..uint32_t("memoryHeapCount", "the number of valid elements in the {@code memoryHeaps} array.")
    VkMemoryHeap("memoryHeaps", "an array of #MAX_MEMORY_HEAPS ##VkMemoryHeap structures describing the <em>memory heaps</em> from which memory <b>can</b> be allocated.")["VK_MAX_MEMORY_HEAPS"]
}

val VkPhysicalDeviceSparseProperties = struct(Module.VULKAN, "VkPhysicalDeviceSparseProperties", mutable = false) {
    documentation =
        """
        Structure specifying physical device sparse memory properties.

        <h5>See Also</h5>
        ##VkPhysicalDeviceProperties
        """

    VkBool32("residencyStandard2DBlockShape", "#TRUE if the physical device will access all single-sample 2D sparse resources using the standard sparse image block shapes (based on image format), as described in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#sparsememory-sparseblockshapessingle\">Standard Sparse Image Block Shapes (Single Sample)</a> table. If this property is not supported the value returned in the {@code imageGranularity} member of the ##VkSparseImageFormatProperties structure for single-sample 2D images is not <b>required</b> to match the standard sparse image block dimensions listed in the table.")
    VkBool32("residencyStandard2DMultisampleBlockShape", "#TRUE if the physical device will access all multisample 2D sparse resources using the standard sparse image block shapes (based on image format), as described in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#sparsememory-sparseblockshapesmsaa\">Standard Sparse Image Block Shapes (MSAA)</a> table. If this property is not supported, the value returned in the {@code imageGranularity} member of the ##VkSparseImageFormatProperties structure for multisample 2D images is not <b>required</b> to match the standard sparse image block dimensions listed in the table.")
    VkBool32("residencyStandard3DBlockShape", "#TRUE if the physical device will access all 3D sparse resources using the standard sparse image block shapes (based on image format), as described in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#sparsememory-sparseblockshapessingle\">Standard Sparse Image Block Shapes (Single Sample)</a> table. If this property is not supported, the value returned in the {@code imageGranularity} member of the ##VkSparseImageFormatProperties structure for 3D images is not <b>required</b> to match the standard sparse image block dimensions listed in the table.")
    VkBool32("residencyAlignedMipSize", "#TRUE if images with mip level dimensions that are not integer multiples of the corresponding dimensions of the sparse image block <b>may</b> be placed in the mip tail. If this property is not reported, only mip levels with dimensions smaller than the {@code imageGranularity} member of the ##VkSparseImageFormatProperties structure will be placed in the mip tail. If this property is reported the implementation is allowed to return #SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT in the {@code flags} member of ##VkSparseImageFormatProperties, indicating that mip level dimensions that are not integer multiples of the corresponding dimensions of the sparse image block will be placed in the mip tail.")
    VkBool32("residencyNonResidentStrict", "specifies whether the physical device <b>can</b> consistently access non-resident regions of a resource. If this property is #TRUE, access to non-resident regions of resources will be guaranteed to return values as if the resource was populated with 0; writes to non-resident regions will be discarded.")
}

val VkPhysicalDeviceProperties = struct(Module.VULKAN, "VkPhysicalDeviceProperties", mutable = false) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation =
        """
        Structure specifying physical device properties.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The value of {@code apiVersion} <b>may</b> be different than the version returned by #EnumerateInstanceVersion(); either higher or lower. In such cases, the application <b>must</b> not use functionality that exceeds the version of Vulkan associated with a given object. The {@code pApiVersion} parameter returned by #EnumerateInstanceVersion() is the version associated with a {@code VkInstance} and its children, except for a {@code VkPhysicalDevice} and its children. ##VkPhysicalDeviceProperties{@code ::apiVersion} is the version associated with a {@code VkPhysicalDevice} and its children.
        </div>

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The encoding of {@code driverVersion} is implementation-defined. It <b>may</b> not use the same encoding as {@code apiVersion}. Applications should follow information from the <em>vendor</em> on how to extract the version information from {@code driverVersion}.
        </div>

        On implementations that claim support for the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#roadmap-2022">Roadmap 2022</a> profile, the major and minor version expressed by {@code apiVersion} <b>must</b> be at least Vulkan 1.3.

        The {@code vendorID} and {@code deviceID} fields are provided to allow applications to adapt to device characteristics that are not adequately exposed by other Vulkan queries.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        These <b>may</b> include performance profiles, hardware errata, or other characteristics.
        </div>

        The <em>vendor</em> identified by {@code vendorID} is the entity responsible for the most salient characteristics of the underlying implementation of the {@code VkPhysicalDevice} being queried.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        For example, in the case of a discrete GPU implementation, this <b>should</b> be the GPU chipset vendor. In the case of a hardware accelerator integrated into a system-on-chip (SoC), this <b>should</b> be the supplier of the silicon IP used to create the accelerator.
        </div>

        If the vendor has a <a href="https://pcisig.com/membership/member-companies">PCI vendor ID</a>, the low 16 bits of {@code vendorID} <b>must</b> contain that PCI vendor ID, and the remaining bits <b>must</b> be zero. Otherwise, the value returned <b>must</b> be a valid Khronos vendor ID, obtained as described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#vulkan-styleguide">Vulkan Documentation and Extensions: Procedures and Conventions</a> document in the section “{@code Registering a Vendor ID with Khronos}”. Khronos vendor IDs are allocated starting at 0x10000, to distinguish them from the PCI vendor ID namespace. Khronos vendor IDs are symbolically defined in the {@code VkVendorId} type.

        The vendor is also responsible for the value returned in {@code deviceID}. If the implementation is driven primarily by a <a href="https://pcisig.com/">PCI device</a> with a <a href="https://pcisig.com/">PCI device ID</a>, the low 16 bits of {@code deviceID} <b>must</b> contain that PCI device ID, and the remaining bits <b>must</b> be zero. Otherwise, the choice of what values to return <b>may</b> be dictated by operating system or platform policies - but <b>should</b> uniquely identify both the device version and any major configuration options (for example, core count in the case of multicore devices).

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The same device ID <b>should</b> be used for all physical implementations of that device version and configuration. For example, all uses of a specific silicon IP GPU version and configuration <b>should</b> use the same device ID, even if those uses occur in different SoCs.
        </div>

        <h5>See Also</h5>
        ##VkPhysicalDeviceLimits, ##VkPhysicalDeviceProperties2, ##VkPhysicalDeviceSparseProperties, #GetPhysicalDeviceProperties()
        """

    uint32_t("apiVersion", "the version of Vulkan supported by the device, encoded as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#extendingvulkan-coreversions-versionnumbers\">Version Numbers</a>.")
    uint32_t("driverVersion", "the vendor-specified version of the driver.")
    uint32_t("vendorID", "a unique identifier for the <em>vendor</em> (see below) of the physical device.")
    uint32_t("deviceID", "a unique identifier for the physical device among devices available from the vendor.")
    VkPhysicalDeviceType("deviceType", "a {@code VkPhysicalDeviceType} specifying the type of device.")
    charUTF8("deviceName", "an array of #MAX_PHYSICAL_DEVICE_NAME_SIZE {@code char} containing a null-terminated UTF-8 string which is the name of the device.")["VK_MAX_PHYSICAL_DEVICE_NAME_SIZE"]
    uint8_t("pipelineCacheUUID", "an array of #UUID_SIZE {@code uint8_t} values representing a universally unique identifier for the device.")["VK_UUID_SIZE"]
    VkPhysicalDeviceLimits("limits", "the ##VkPhysicalDeviceLimits structure specifying device-specific limits of the physical device. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits\">Limits</a> for details.")
    VkPhysicalDeviceSparseProperties("sparseProperties", "the ##VkPhysicalDeviceSparseProperties structure specifying various sparse related properties of the physical device. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#sparsememory-physicalprops\">Sparse Properties</a> for details.")
}

val VkQueueFamilyProperties = struct(Module.VULKAN, "VkQueueFamilyProperties", mutable = false) {
    documentation =
        """
        Structure providing information about a queue family.

        <h5>Description</h5>
        The value returned in {@code minImageTransferGranularity} has a unit of compressed texel blocks for images having a block-compressed format, and a unit of texels otherwise.

        Possible values of {@code minImageTransferGranularity} are:

        <ul>
            <li>
                <code>(0,0,0)</code> specifies that only whole mip levels <b>must</b> be transferred using the image transfer operations on the corresponding queues. In this case, the following restrictions apply to all offset and extent parameters of image transfer operations:
                <ul>
                    <li>The {@code x}, {@code y}, and {@code z} members of a ##VkOffset3D parameter <b>must</b> always be zero.</li>
                    <li>The {@code width}, {@code height}, and {@code depth} members of a ##VkExtent3D parameter <b>must</b> always match the width, height, and depth of the image subresource corresponding to the parameter, respectively.</li>
                </ul>
            </li>
            <li>
                <code>(A<sub>x</sub>, A<sub>y</sub>, A<sub>z</sub>)</code> where <code>A<sub>x</sub></code>, <code>A<sub>y</sub></code>, and <code>A<sub>z</sub></code> are all integer powers of two. In this case the following restrictions apply to all image transfer operations:
                <ul>
                    <li>{@code x}, {@code y}, and {@code z} of a ##VkOffset3D parameter <b>must</b> be integer multiples of <code>A<sub>x</sub></code>, <code>A<sub>y</sub></code>, and <code>A<sub>z</sub></code>, respectively.</li>
                    <li>{@code width} of a ##VkExtent3D parameter <b>must</b> be an integer multiple of <code>A<sub>x</sub></code>, or else <code>x + width</code> <b>must</b> equal the width of the image subresource corresponding to the parameter.</li>
                    <li>{@code height} of a ##VkExtent3D parameter <b>must</b> be an integer multiple of <code>A<sub>y</sub></code>, or else <code>y + height</code> <b>must</b> equal the height of the image subresource corresponding to the parameter.</li>
                    <li>{@code depth} of a ##VkExtent3D parameter <b>must</b> be an integer multiple of <code>A<sub>z</sub></code>, or else <code>z + depth</code> <b>must</b> equal the depth of the image subresource corresponding to the parameter.</li>
                    <li>If the format of the image corresponding to the parameters is one of the block-compressed formats then for the purposes of the above calculations the granularity <b>must</b> be scaled up by the compressed texel block dimensions.</li>
                </ul>
            </li>
        </ul>

        Queues supporting graphics and/or compute operations <b>must</b> report <code>(1,1,1)</code> in {@code minImageTransferGranularity}, meaning that there are no additional restrictions on the granularity of image transfer operations for these queues. Other queues supporting image transfer operations are only <b>required</b> to support whole mip level transfers, thus {@code minImageTransferGranularity} for queues belonging to such queue families <b>may</b> be <code>(0,0,0)</code>.

        The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-device">Device Memory</a> section describes memory properties queried from the physical device.

        For physical device feature queries see the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features">Features</a> chapter.

        <h5>See Also</h5>
        ##VkExtent3D, ##VkQueueFamilyProperties2, #GetPhysicalDeviceQueueFamilyProperties()
        """

    VkQueueFlags("queueFlags", "a bitmask of {@code VkQueueFlagBits} indicating capabilities of the queues in this queue family.")
    uint32_t("queueCount", "the unsigned integer count of queues in this queue family. Each queue family <b>must</b> support at least one queue.")
    uint32_t("timestampValidBits", "the unsigned integer count of meaningful bits in the timestamps written via #CmdWriteTimestamp2() or #CmdWriteTimestamp(). The valid range for the count is 36 to 64 bits, or a value of 0, indicating no support for timestamps. Bits outside the valid range are guaranteed to be zeros.")
    VkExtent3D("minImageTransferGranularity", "the minimum granularity supported for image transfer operations on the queues in this queue family.")
}

val VkDeviceQueueCreateInfo = struct(Module.VULKAN, "VkDeviceQueueCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created device queue.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code queueFamilyIndex} <b>must</b> be less than {@code pQueueFamilyPropertyCount} returned by {@code vkGetPhysicalDeviceQueueFamilyProperties}</li>
            <li>{@code queueCount} <b>must</b> be less than or equal to the {@code queueCount} member of the ##VkQueueFamilyProperties structure, as returned by {@code vkGetPhysicalDeviceQueueFamilyProperties} in the {@code pQueueFamilyProperties}[queueFamilyIndex]</li>
            <li>Each element of {@code pQueuePriorities} <b>must</b> be between {@code 0.0} and {@code 1.0} inclusive</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-protectedMemory">{@code protectedMemory}</a> feature is not enabled, the #DEVICE_QUEUE_CREATE_PROTECTED_BIT bit of {@code flags} <b>must</b> not be set</li>
            <li>If {@code flags} includes #DEVICE_QUEUE_CREATE_PROTECTED_BIT, {@code queueFamilyIndex} <b>must</b> be the index of a queue family that includes the #QUEUE_PROTECTED_BIT capability</li>
            <li>If the {@code pNext} chain includes a ##VkDeviceQueueShaderCoreControlCreateInfoARM structure then ##VkPhysicalDeviceSchedulingControlsPropertiesARM{@code ::schedulingControlsFlags} <b>must</b> contain #PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDeviceQueueGlobalPriorityCreateInfo or ##VkDeviceQueueShaderCoreControlCreateInfoARM</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkDeviceQueueCreateFlagBits} values</li>
            <li>{@code pQueuePriorities} <b>must</b> be a valid pointer to an array of {@code queueCount} {@code float} values</li>
            <li>{@code queueCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkDeviceCreateInfo
        """

    Expression("#STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDeviceQueueGlobalPriorityCreateInfo", "VkDeviceQueueGlobalPriorityCreateInfoEXT", "VkDeviceQueueGlobalPriorityCreateInfoKHR", "VkDeviceQueueShaderCoreControlCreateInfoARM",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceQueueCreateFlags("flags", "a bitmask indicating behavior of the queues.")
    uint32_t("queueFamilyIndex", "an unsigned integer indicating the index of the queue family in which to create the queues on this device. This index corresponds to the index of an element of the {@code pQueueFamilyProperties} array that was returned by {@code vkGetPhysicalDeviceQueueFamilyProperties}.")
    AutoSize("pQueuePriorities")..uint32_t("queueCount", "an unsigned integer specifying the number of queues to create in the queue family indicated by {@code queueFamilyIndex}, and with the behavior specified by {@code flags}.")
    float.const.p("pQueuePriorities", "a pointer to an array of {@code queueCount} normalized floating-point values, specifying priorities of work that will be submitted to each created queue. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#devsandqueues-priority\">Queue Priority</a> for more information.")
}

val VkDeviceCreateInfo = struct(Module.VULKAN, "VkDeviceCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created device.

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code queueFamilyIndex} member of each element of {@code pQueueCreateInfos} <b>must</b> be unique within {@code pQueueCreateInfos} , except that two members can share the same {@code queueFamilyIndex} if one describes protected-capable queues and one describes queues that are not protected-capable</li>
            <li>If multiple elements of {@code pQueueCreateInfos} share the same {@code queueFamilyIndex}, the sum of their {@code queueCount} members <b>must</b> be less than or equal to the {@code queueCount} member of the ##VkQueueFamilyProperties structure, as returned by {@code vkGetPhysicalDeviceQueueFamilyProperties} in the {@code pQueueFamilyProperties}[queueFamilyIndex]</li>
            <li>If multiple elements of {@code pQueueCreateInfos} share the same {@code queueFamilyIndex}, then all of such elements <b>must</b> have the same global priority level, which <b>can</b> be specified explicitly by the including a ##VkDeviceQueueGlobalPriorityCreateInfo structure in the {@code pNext} chain, or by the implicit default value</li>
            <li>If the {@code pNext} chain includes a ##VkPhysicalDeviceFeatures2 structure, then {@code pEnabledFeatures} <b>must</b> be {@code NULL}</li>
            <li>If ##VkPhysicalDeviceProperties{@code ::apiVersion} advertises Vulkan 1.1 or later, {@code ppEnabledExtensionNames} <b>must</b> not contain {@link AMDNegativeViewportHeight VK_AMD_negative_viewport_height}</li>
            <li>{@code ppEnabledExtensionNames} <b>must</b> not contain both {@link KHRMaintenance1 VK_KHR_maintenance1} and {@link AMDNegativeViewportHeight VK_AMD_negative_viewport_height}</li>
            <li>{@code ppEnabledExtensionNames} <b>must</b> not contain both {@link KHRBufferDeviceAddress VK_KHR_buffer_device_address} and {@link EXTBufferDeviceAddress VK_EXT_buffer_device_address}</li>
            <li>If the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan12Features structure and ##VkPhysicalDeviceVulkan12Features{@code ::bufferDeviceAddress} is #TRUE, {@code ppEnabledExtensionNames} <b>must</b> not contain {@link EXTBufferDeviceAddress VK_EXT_buffer_device_address}</li>
            <li>If the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan11Features structure, then it <b>must</b> not include a ##VkPhysicalDevice16BitStorageFeatures, ##VkPhysicalDeviceMultiviewFeatures, ##VkPhysicalDeviceVariablePointersFeatures, ##VkPhysicalDeviceProtectedMemoryFeatures, ##VkPhysicalDeviceSamplerYcbcrConversionFeatures, or ##VkPhysicalDeviceShaderDrawParametersFeatures structure</li>
            <li>If the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan12Features structure, then it <b>must</b> not include a ##VkPhysicalDevice8BitStorageFeatures, ##VkPhysicalDeviceShaderAtomicInt64Features, ##VkPhysicalDeviceShaderFloat16Int8Features, ##VkPhysicalDeviceDescriptorIndexingFeatures, ##VkPhysicalDeviceScalarBlockLayoutFeatures, ##VkPhysicalDeviceImagelessFramebufferFeatures, ##VkPhysicalDeviceUniformBufferStandardLayoutFeatures, ##VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, ##VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, ##VkPhysicalDeviceHostQueryResetFeatures, ##VkPhysicalDeviceTimelineSemaphoreFeatures, ##VkPhysicalDeviceBufferDeviceAddressFeatures, or ##VkPhysicalDeviceVulkanMemoryModelFeatures structure</li>
            <li>If {@code ppEnabledExtensionNames} contains {@code "VK_KHR_shader_draw_parameters"} and the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan11Features structure, then ##VkPhysicalDeviceVulkan11Features{@code ::shaderDrawParameters} <b>must</b> be #TRUE</li>
            <li>If {@code ppEnabledExtensionNames} contains {@code "VK_KHR_draw_indirect_count"} and the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan12Features structure, then ##VkPhysicalDeviceVulkan12Features{@code ::drawIndirectCount} <b>must</b> be #TRUE</li>
            <li>If {@code ppEnabledExtensionNames} contains {@code "VK_KHR_sampler_mirror_clamp_to_edge"} and the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan12Features structure, then ##VkPhysicalDeviceVulkan12Features{@code ::samplerMirrorClampToEdge} <b>must</b> be #TRUE</li>
            <li>If {@code ppEnabledExtensionNames} contains {@code "VK_EXT_descriptor_indexing"} and the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan12Features structure, then ##VkPhysicalDeviceVulkan12Features{@code ::descriptorIndexing} <b>must</b> be #TRUE</li>
            <li>If {@code ppEnabledExtensionNames} contains {@code "VK_EXT_sampler_filter_minmax"} and the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan12Features structure, then ##VkPhysicalDeviceVulkan12Features{@code ::samplerFilterMinmax} <b>must</b> be #TRUE</li>
            <li>If {@code ppEnabledExtensionNames} contains {@code "VK_EXT_shader_viewport_index_layer"} and the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan12Features structure, then ##VkPhysicalDeviceVulkan12Features{@code ::shaderOutputViewportIndex} and ##VkPhysicalDeviceVulkan12Features{@code ::shaderOutputLayer} <b>must</b> both be #TRUE</li>
            <li>If the {@code pNext} chain includes a ##VkPhysicalDeviceVulkan13Features structure, then it <b>must</b> not include a ##VkPhysicalDeviceDynamicRenderingFeatures, ##VkPhysicalDeviceImageRobustnessFeatures, ##VkPhysicalDeviceInlineUniformBlockFeatures, ##VkPhysicalDeviceMaintenance4Features, ##VkPhysicalDevicePipelineCreationCacheControlFeatures, ##VkPhysicalDevicePrivateDataFeatures, ##VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, ##VkPhysicalDeviceShaderIntegerDotProductFeatures, ##VkPhysicalDeviceShaderTerminateInvocationFeatures, ##VkPhysicalDeviceSubgroupSizeControlFeatures, ##VkPhysicalDeviceSynchronization2Features, ##VkPhysicalDeviceTextureCompressionASTCHDRFeatures, or ##VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures structure</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is included in {@code pProperties} of #EnumerateDeviceExtensionProperties(), {@code ppEnabledExtensionNames} <b>must</b> include {@code "VK_KHR_portability_subset"}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shadingRateImage">{@code shadingRateImage}</a> feature is enabled, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineFragmentShadingRate">{@code pipelineFragmentShadingRate}</a> feature <b>must</b> not be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shadingRateImage">{@code shadingRateImage}</a> feature is enabled, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-primitiveFragmentShadingRate">{@code primitiveFragmentShadingRate}</a> feature <b>must</b> not be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shadingRateImage">{@code shadingRateImage}</a> feature is enabled, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFragmentShadingRate">{@code attachmentFragmentShadingRate}</a> feature <b>must</b> not be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMap">{@code fragmentDensityMap}</a> feature is enabled, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineFragmentShadingRate">{@code pipelineFragmentShadingRate}</a> feature <b>must</b> not be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMap">{@code fragmentDensityMap}</a> feature is enabled, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-primitiveFragmentShadingRate">{@code primitiveFragmentShadingRate}</a> feature <b>must</b> not be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMap">{@code fragmentDensityMap}</a> feature is enabled, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFragmentShadingRate">{@code attachmentFragmentShadingRate}</a> feature <b>must</b> not be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseImageInt64Atomics">{@code sparseImageInt64Atomics}</a> feature is enabled, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderImageInt64Atomics">{@code shaderImageInt64Atomics}</a> <b>must</b> be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseImageFloat32Atomics">{@code sparseImageFloat32Atomics}</a> feature is enabled, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderImageFloat32Atomics">{@code shaderImageFloat32Atomics}</a> <b>must</b> be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseImageFloat32AtomicAdd">{@code sparseImageFloat32AtomicAdd}</a> feature is enabled, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderImageFloat32AtomicAdd">{@code shaderImageFloat32AtomicAdd}</a> <b>must</b> be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseImageFloat32AtomicMinMax">{@code sparseImageFloat32AtomicMinMax}</a> feature is enabled, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderImageFloat32AtomicMinMax">{@code shaderImageFloat32AtomicMinMax}</a> <b>must</b> be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-robustBufferAccess">{@code robustBufferAccess}</a> feature is enabled, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustBufferAccessUpdateAfterBind">{@code robustBufferAccessUpdateAfterBind}</a> is #FALSE, then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBindingUniformBufferUpdateAfterBind">{@code descriptorBindingUniformBufferUpdateAfterBind}</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBindingStorageBufferUpdateAfterBind">{@code descriptorBindingStorageBufferUpdateAfterBind}</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBindingUniformTexelBufferUpdateAfterBind">{@code descriptorBindingUniformTexelBufferUpdateAfterBind}</a>, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBindingStorageTexelBufferUpdateAfterBind">{@code descriptorBindingStorageTexelBufferUpdateAfterBind}</a> <b>must</b> not be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBuffer">{@code descriptorBuffer}</a> feature is enabled, {@code ppEnabledExtensionNames} <b>must</b> not contain {@link AMDShaderFragmentMask VK_AMD_shader_fragment_mask}</li>
            <li>If the {@code pNext} chain includes a ##VkDeviceQueueShaderCoreControlCreateInfoARM structure, then it <b>must</b> not be included in the {@code pNext} chain of any of the ##VkDeviceQueueCreateInfo structures in {@code pQueueCreateInfos}</li>
            <li>If the {@code pNext} chain includes a ##VkDeviceQueueShaderCoreControlCreateInfoARM structure then ##VkPhysicalDeviceSchedulingControlsPropertiesARM{@code ::schedulingControlsFlags} <b>must</b> contain #PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEVICE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDeviceDeviceMemoryReportCreateInfoEXT, ##VkDeviceDiagnosticsConfigCreateInfoNV, ##VkDeviceGroupDeviceCreateInfo, ##VkDeviceMemoryOverallocationCreateInfoAMD, ##VkDevicePipelineBinaryInternalCacheControlKHR, ##VkDevicePrivateDataCreateInfo, ##VkDeviceQueueShaderCoreControlCreateInfoARM, ##VkPhysicalDevice16BitStorageFeatures, ##VkPhysicalDevice4444FormatsFeaturesEXT, ##VkPhysicalDevice8BitStorageFeatures, ##VkPhysicalDeviceASTCDecodeFeaturesEXT, ##VkPhysicalDeviceAccelerationStructureFeaturesKHR, ##VkPhysicalDeviceAddressBindingReportFeaturesEXT, ##VkPhysicalDeviceAmigoProfilingFeaturesSEC, ##VkPhysicalDeviceAntiLagFeaturesAMD, ##VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT, ##VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT, ##VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, ##VkPhysicalDeviceBorderColorSwizzleFeaturesEXT, ##VkPhysicalDeviceBufferDeviceAddressFeatures, ##VkPhysicalDeviceBufferDeviceAddressFeaturesEXT, ##VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI, ##VkPhysicalDeviceCoherentMemoryFeaturesAMD, ##VkPhysicalDeviceColorWriteEnableFeaturesEXT, ##VkPhysicalDeviceCommandBufferInheritanceFeaturesNV, ##VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR, ##VkPhysicalDeviceConditionalRenderingFeaturesEXT, ##VkPhysicalDeviceCooperativeMatrix2FeaturesNV, ##VkPhysicalDeviceCooperativeMatrixFeaturesKHR, ##VkPhysicalDeviceCooperativeMatrixFeaturesNV, ##VkPhysicalDeviceCopyMemoryIndirectFeaturesNV, ##VkPhysicalDeviceCornerSampledImageFeaturesNV, ##VkPhysicalDeviceCoverageReductionModeFeaturesNV, ##VkPhysicalDeviceCubicClampFeaturesQCOM, ##VkPhysicalDeviceCubicWeightsFeaturesQCOM, ##VkPhysicalDeviceCudaKernelLaunchFeaturesNV, ##VkPhysicalDeviceCustomBorderColorFeaturesEXT, ##VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV, ##VkPhysicalDeviceDepthBiasControlFeaturesEXT, ##VkPhysicalDeviceDepthClampControlFeaturesEXT, ##VkPhysicalDeviceDepthClampZeroOneFeaturesEXT, ##VkPhysicalDeviceDepthClipControlFeaturesEXT, ##VkPhysicalDeviceDepthClipEnableFeaturesEXT, ##VkPhysicalDeviceDescriptorBufferFeaturesEXT, ##VkPhysicalDeviceDescriptorIndexingFeatures, ##VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV, ##VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE, ##VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV, ##VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT, ##VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV, ##VkPhysicalDeviceDeviceMemoryReportFeaturesEXT, ##VkPhysicalDeviceDiagnosticsConfigFeaturesNV, ##VkPhysicalDeviceDisplacementMicromapFeaturesNV, ##VkPhysicalDeviceDynamicRenderingFeatures, ##VkPhysicalDeviceDynamicRenderingLocalReadFeatures, ##VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT, ##VkPhysicalDeviceExclusiveScissorFeaturesNV, ##VkPhysicalDeviceExtendedDynamicState2FeaturesEXT, ##VkPhysicalDeviceExtendedDynamicState3FeaturesEXT, ##VkPhysicalDeviceExtendedDynamicStateFeaturesEXT, ##VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV, ##VkPhysicalDeviceExternalFormatResolveFeaturesANDROID, ##VkPhysicalDeviceExternalMemoryRDMAFeaturesNV, ##VkPhysicalDeviceFaultFeaturesEXT, ##VkPhysicalDeviceFeatures2, ##VkPhysicalDeviceFragmentDensityMap2FeaturesEXT, ##VkPhysicalDeviceFragmentDensityMapFeaturesEXT, ##VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM, ##VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR, ##VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT, ##VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV, ##VkPhysicalDeviceFragmentShadingRateFeaturesKHR, ##VkPhysicalDeviceFrameBoundaryFeaturesEXT, ##VkPhysicalDeviceGlobalPriorityQueryFeatures, ##VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT, ##VkPhysicalDeviceHdrVividFeaturesHUAWEI, ##VkPhysicalDeviceHostImageCopyFeatures, ##VkPhysicalDeviceHostQueryResetFeatures, ##VkPhysicalDeviceImage2DViewOf3DFeaturesEXT, ##VkPhysicalDeviceImageAlignmentControlFeaturesMESA, ##VkPhysicalDeviceImageCompressionControlFeaturesEXT, ##VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT, ##VkPhysicalDeviceImageProcessing2FeaturesQCOM, ##VkPhysicalDeviceImageProcessingFeaturesQCOM, ##VkPhysicalDeviceImageRobustnessFeatures, ##VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT, ##VkPhysicalDeviceImageViewMinLodFeaturesEXT, ##VkPhysicalDeviceImagelessFramebufferFeatures, ##VkPhysicalDeviceIndexTypeUint8Features, ##VkPhysicalDeviceInheritedViewportScissorFeaturesNV, ##VkPhysicalDeviceInlineUniformBlockFeatures, ##VkPhysicalDeviceInvocationMaskFeaturesHUAWEI, ##VkPhysicalDeviceLegacyDitheringFeaturesEXT, ##VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT, ##VkPhysicalDeviceLineRasterizationFeatures, ##VkPhysicalDeviceLinearColorAttachmentFeaturesNV, ##VkPhysicalDeviceMaintenance4Features, ##VkPhysicalDeviceMaintenance5Features, ##VkPhysicalDeviceMaintenance6Features, ##VkPhysicalDeviceMaintenance7FeaturesKHR, ##VkPhysicalDeviceMapMemoryPlacedFeaturesEXT, ##VkPhysicalDeviceMemoryDecompressionFeaturesNV, ##VkPhysicalDeviceMemoryPriorityFeaturesEXT, ##VkPhysicalDeviceMeshShaderFeaturesEXT, ##VkPhysicalDeviceMeshShaderFeaturesNV, ##VkPhysicalDeviceMultiDrawFeaturesEXT, ##VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT, ##VkPhysicalDeviceMultiviewFeatures, ##VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM, ##VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM, ##VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT, ##VkPhysicalDeviceNestedCommandBufferFeaturesEXT, ##VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT, ##VkPhysicalDeviceOpacityMicromapFeaturesEXT, ##VkPhysicalDeviceOpticalFlowFeaturesNV, ##VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT, ##VkPhysicalDevicePerStageDescriptorSetFeaturesNV, ##VkPhysicalDevicePerformanceQueryFeaturesKHR, ##VkPhysicalDevicePipelineBinaryFeaturesKHR, ##VkPhysicalDevicePipelineCreationCacheControlFeatures, ##VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR, ##VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT, ##VkPhysicalDevicePipelinePropertiesFeaturesEXT, ##VkPhysicalDevicePipelineProtectedAccessFeatures, ##VkPhysicalDevicePipelineRobustnessFeatures, ##VkPhysicalDevicePortabilitySubsetFeaturesKHR, ##VkPhysicalDevicePresentBarrierFeaturesNV, ##VkPhysicalDevicePresentIdFeaturesKHR, ##VkPhysicalDevicePresentModeFifoLatestReadyFeaturesEXT, ##VkPhysicalDevicePresentWaitFeaturesKHR, ##VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT, ##VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT, ##VkPhysicalDevicePrivateDataFeatures, ##VkPhysicalDeviceProtectedMemoryFeatures, ##VkPhysicalDeviceProvokingVertexFeaturesEXT, ##VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT, ##VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT, ##VkPhysicalDeviceRawAccessChainsFeaturesNV, ##VkPhysicalDeviceRayQueryFeaturesKHR, ##VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV, ##VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR, ##VkPhysicalDeviceRayTracingMotionBlurFeaturesNV, ##VkPhysicalDeviceRayTracingPipelineFeaturesKHR, ##VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR, ##VkPhysicalDeviceRayTracingValidationFeaturesNV, ##VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG, ##VkPhysicalDeviceRenderPassStripedFeaturesARM, ##VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV, ##VkPhysicalDeviceRobustness2FeaturesEXT, ##VkPhysicalDeviceSamplerYcbcrConversionFeatures, ##VkPhysicalDeviceScalarBlockLayoutFeatures, ##VkPhysicalDeviceSchedulingControlsFeaturesARM, ##VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, ##VkPhysicalDeviceShaderAtomicFloat16VectorFeaturesNV, ##VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, ##VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, ##VkPhysicalDeviceShaderAtomicInt64Features, ##VkPhysicalDeviceShaderClockFeaturesKHR, ##VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM, ##VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, ##VkPhysicalDeviceShaderDrawParametersFeatures, ##VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD, ##VkPhysicalDeviceShaderEnqueueFeaturesAMDX, ##VkPhysicalDeviceShaderExpectAssumeFeatures, ##VkPhysicalDeviceShaderFloat16Int8Features, ##VkPhysicalDeviceShaderFloatControls2Features, ##VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT, ##VkPhysicalDeviceShaderImageFootprintFeaturesNV, ##VkPhysicalDeviceShaderIntegerDotProductFeatures, ##VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL, ##VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR, ##VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT, ##VkPhysicalDeviceShaderObjectFeaturesEXT, ##VkPhysicalDeviceShaderQuadControlFeaturesKHR, ##VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR, ##VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT, ##VkPhysicalDeviceShaderSMBuiltinsFeaturesNV, ##VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, ##VkPhysicalDeviceShaderSubgroupRotateFeatures, ##VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR, ##VkPhysicalDeviceShaderTerminateInvocationFeatures, ##VkPhysicalDeviceShaderTileImageFeaturesEXT, ##VkPhysicalDeviceShadingRateImageFeaturesNV, ##VkPhysicalDeviceSubgroupSizeControlFeatures, ##VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT, ##VkPhysicalDeviceSubpassShadingFeaturesHUAWEI, ##VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT, ##VkPhysicalDeviceSynchronization2Features, ##VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT, ##VkPhysicalDeviceTextureCompressionASTCHDRFeatures, ##VkPhysicalDeviceTilePropertiesFeaturesQCOM, ##VkPhysicalDeviceTimelineSemaphoreFeatures, ##VkPhysicalDeviceTransformFeedbackFeaturesEXT, ##VkPhysicalDeviceUniformBufferStandardLayoutFeatures, ##VkPhysicalDeviceVariablePointersFeatures, ##VkPhysicalDeviceVertexAttributeDivisorFeatures, ##VkPhysicalDeviceVertexAttributeRobustnessFeaturesEXT, ##VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT, ##VkPhysicalDeviceVideoEncodeAV1FeaturesKHR, ##VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR, ##VkPhysicalDeviceVideoMaintenance1FeaturesKHR, ##VkPhysicalDeviceVulkan11Features, ##VkPhysicalDeviceVulkan12Features, ##VkPhysicalDeviceVulkan13Features, ##VkPhysicalDeviceVulkan14Features, ##VkPhysicalDeviceVulkanMemoryModelFeatures, ##VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR, ##VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT, ##VkPhysicalDeviceYcbcrDegammaFeaturesQCOM, ##VkPhysicalDeviceYcbcrImageArraysFeaturesEXT, or ##VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique, with the exception of structures of type ##VkDeviceDeviceMemoryReportCreateInfoEXT or ##VkDevicePrivateDataCreateInfo</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code pQueueCreateInfos} <b>must</b> be a valid pointer to an array of {@code queueCreateInfoCount} valid ##VkDeviceQueueCreateInfo structures</li>
            <li>If {@code enabledLayerCount} is not 0, {@code ppEnabledLayerNames} <b>must</b> be a valid pointer to an array of {@code enabledLayerCount} null-terminated UTF-8 strings</li>
            <li>If {@code enabledExtensionCount} is not 0, {@code ppEnabledExtensionNames} <b>must</b> be a valid pointer to an array of {@code enabledExtensionCount} null-terminated UTF-8 strings</li>
            <li>If {@code pEnabledFeatures} is not {@code NULL}, {@code pEnabledFeatures} <b>must</b> be a valid pointer to a valid ##VkPhysicalDeviceFeatures structure</li>
            <li>{@code queueCreateInfoCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkDeviceQueueCreateInfo, ##VkPhysicalDeviceFeatures, #CreateDevice()
        """

    Expression("#STRUCTURE_TYPE_DEVICE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDeviceDeviceMemoryReportCreateInfoEXT", "VkDeviceDiagnosticsConfigCreateInfoNV", "VkDeviceGroupDeviceCreateInfo", "VkDeviceGroupDeviceCreateInfoKHR", "VkDeviceMemoryOverallocationCreateInfoAMD", "VkDevicePipelineBinaryInternalCacheControlKHR", "VkDevicePrivateDataCreateInfo", "VkDevicePrivateDataCreateInfoEXT", "VkDeviceQueueShaderCoreControlCreateInfoARM", "VkPhysicalDevice16BitStorageFeatures", "VkPhysicalDevice16BitStorageFeaturesKHR", "VkPhysicalDevice4444FormatsFeaturesEXT", "VkPhysicalDevice8BitStorageFeatures", "VkPhysicalDevice8BitStorageFeaturesKHR", "VkPhysicalDeviceASTCDecodeFeaturesEXT", "VkPhysicalDeviceAccelerationStructureFeaturesKHR", "VkPhysicalDeviceAddressBindingReportFeaturesEXT", "VkPhysicalDeviceAmigoProfilingFeaturesSEC", "VkPhysicalDeviceAntiLagFeaturesAMD", "VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT", "VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT", "VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT", "VkPhysicalDeviceBorderColorSwizzleFeaturesEXT", "VkPhysicalDeviceBufferAddressFeaturesEXT", "VkPhysicalDeviceBufferDeviceAddressFeatures", "VkPhysicalDeviceBufferDeviceAddressFeaturesEXT", "VkPhysicalDeviceBufferDeviceAddressFeaturesKHR", "VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI", "VkPhysicalDeviceCoherentMemoryFeaturesAMD", "VkPhysicalDeviceColorWriteEnableFeaturesEXT", "VkPhysicalDeviceCommandBufferInheritanceFeaturesNV", "VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR", "VkPhysicalDeviceComputeShaderDerivativesFeaturesNV", "VkPhysicalDeviceConditionalRenderingFeaturesEXT", "VkPhysicalDeviceCooperativeMatrix2FeaturesNV", "VkPhysicalDeviceCooperativeMatrixFeaturesKHR", "VkPhysicalDeviceCooperativeMatrixFeaturesNV", "VkPhysicalDeviceCopyMemoryIndirectFeaturesNV", "VkPhysicalDeviceCornerSampledImageFeaturesNV", "VkPhysicalDeviceCoverageReductionModeFeaturesNV", "VkPhysicalDeviceCubicClampFeaturesQCOM", "VkPhysicalDeviceCubicWeightsFeaturesQCOM", "VkPhysicalDeviceCudaKernelLaunchFeaturesNV", "VkPhysicalDeviceCustomBorderColorFeaturesEXT", "VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV", "VkPhysicalDeviceDepthBiasControlFeaturesEXT", "VkPhysicalDeviceDepthClampControlFeaturesEXT", "VkPhysicalDeviceDepthClampZeroOneFeaturesEXT", "VkPhysicalDeviceDepthClipControlFeaturesEXT", "VkPhysicalDeviceDepthClipEnableFeaturesEXT", "VkPhysicalDeviceDescriptorBufferFeaturesEXT", "VkPhysicalDeviceDescriptorIndexingFeatures", "VkPhysicalDeviceDescriptorIndexingFeaturesEXT", "VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV", "VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE", "VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV", "VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT", "VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV", "VkPhysicalDeviceDeviceMemoryReportFeaturesEXT", "VkPhysicalDeviceDiagnosticsConfigFeaturesNV", "VkPhysicalDeviceDisplacementMicromapFeaturesNV", "VkPhysicalDeviceDynamicRenderingFeatures", "VkPhysicalDeviceDynamicRenderingFeaturesKHR", "VkPhysicalDeviceDynamicRenderingLocalReadFeatures", "VkPhysicalDeviceDynamicRenderingLocalReadFeaturesKHR", "VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT", "VkPhysicalDeviceExclusiveScissorFeaturesNV", "VkPhysicalDeviceExtendedDynamicState2FeaturesEXT", "VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "VkPhysicalDeviceExtendedDynamicStateFeaturesEXT", "VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV", "VkPhysicalDeviceExternalFormatResolveFeaturesANDROID", "VkPhysicalDeviceExternalMemoryRDMAFeaturesNV", "VkPhysicalDeviceFaultFeaturesEXT", "VkPhysicalDeviceFeatures2", "VkPhysicalDeviceFeatures2KHR", "VkPhysicalDeviceFloat16Int8FeaturesKHR", "VkPhysicalDeviceFragmentDensityMap2FeaturesEXT", "VkPhysicalDeviceFragmentDensityMapFeaturesEXT", "VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM", "VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR", "VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV", "VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT", "VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV", "VkPhysicalDeviceFragmentShadingRateFeaturesKHR", "VkPhysicalDeviceFrameBoundaryFeaturesEXT", "VkPhysicalDeviceGlobalPriorityQueryFeatures", "VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT", "VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR", "VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT", "VkPhysicalDeviceHdrVividFeaturesHUAWEI", "VkPhysicalDeviceHostImageCopyFeatures", "VkPhysicalDeviceHostImageCopyFeaturesEXT", "VkPhysicalDeviceHostQueryResetFeatures", "VkPhysicalDeviceHostQueryResetFeaturesEXT", "VkPhysicalDeviceImage2DViewOf3DFeaturesEXT", "VkPhysicalDeviceImageAlignmentControlFeaturesMESA", "VkPhysicalDeviceImageCompressionControlFeaturesEXT", "VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT", "VkPhysicalDeviceImageProcessing2FeaturesQCOM", "VkPhysicalDeviceImageProcessingFeaturesQCOM", "VkPhysicalDeviceImageRobustnessFeatures", "VkPhysicalDeviceImageRobustnessFeaturesEXT", "VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT", "VkPhysicalDeviceImageViewMinLodFeaturesEXT", "VkPhysicalDeviceImagelessFramebufferFeatures", "VkPhysicalDeviceImagelessFramebufferFeaturesKHR", "VkPhysicalDeviceIndexTypeUint8Features", "VkPhysicalDeviceIndexTypeUint8FeaturesEXT", "VkPhysicalDeviceIndexTypeUint8FeaturesKHR", "VkPhysicalDeviceInheritedViewportScissorFeaturesNV", "VkPhysicalDeviceInlineUniformBlockFeatures", "VkPhysicalDeviceInlineUniformBlockFeaturesEXT", "VkPhysicalDeviceInvocationMaskFeaturesHUAWEI", "VkPhysicalDeviceLegacyDitheringFeaturesEXT", "VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT", "VkPhysicalDeviceLineRasterizationFeatures", "VkPhysicalDeviceLineRasterizationFeaturesEXT", "VkPhysicalDeviceLineRasterizationFeaturesKHR", "VkPhysicalDeviceLinearColorAttachmentFeaturesNV", "VkPhysicalDeviceMaintenance4Features", "VkPhysicalDeviceMaintenance4FeaturesKHR", "VkPhysicalDeviceMaintenance5Features", "VkPhysicalDeviceMaintenance5FeaturesKHR", "VkPhysicalDeviceMaintenance6Features", "VkPhysicalDeviceMaintenance6FeaturesKHR", "VkPhysicalDeviceMaintenance7FeaturesKHR", "VkPhysicalDeviceMapMemoryPlacedFeaturesEXT", "VkPhysicalDeviceMemoryDecompressionFeaturesNV", "VkPhysicalDeviceMemoryPriorityFeaturesEXT", "VkPhysicalDeviceMeshShaderFeaturesEXT", "VkPhysicalDeviceMeshShaderFeaturesNV", "VkPhysicalDeviceMultiDrawFeaturesEXT", "VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT", "VkPhysicalDeviceMultiviewFeatures", "VkPhysicalDeviceMultiviewFeaturesKHR", "VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM", "VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM", "VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT", "VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE", "VkPhysicalDeviceNestedCommandBufferFeaturesEXT", "VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT", "VkPhysicalDeviceOpacityMicromapFeaturesEXT", "VkPhysicalDeviceOpticalFlowFeaturesNV", "VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT", "VkPhysicalDevicePerStageDescriptorSetFeaturesNV", "VkPhysicalDevicePerformanceQueryFeaturesKHR", "VkPhysicalDevicePipelineBinaryFeaturesKHR", "VkPhysicalDevicePipelineCreationCacheControlFeatures", "VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT", "VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR", "VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT", "VkPhysicalDevicePipelinePropertiesFeaturesEXT", "VkPhysicalDevicePipelineProtectedAccessFeatures", "VkPhysicalDevicePipelineProtectedAccessFeaturesEXT", "VkPhysicalDevicePipelineRobustnessFeatures", "VkPhysicalDevicePipelineRobustnessFeaturesEXT", "VkPhysicalDevicePortabilitySubsetFeaturesKHR", "VkPhysicalDevicePresentBarrierFeaturesNV", "VkPhysicalDevicePresentIdFeaturesKHR", "VkPhysicalDevicePresentModeFifoLatestReadyFeaturesEXT", "VkPhysicalDevicePresentWaitFeaturesKHR", "VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT", "VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT", "VkPhysicalDevicePrivateDataFeatures", "VkPhysicalDevicePrivateDataFeaturesEXT", "VkPhysicalDeviceProtectedMemoryFeatures", "VkPhysicalDeviceProvokingVertexFeaturesEXT", "VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT", "VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesARM", "VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT", "VkPhysicalDeviceRawAccessChainsFeaturesNV", "VkPhysicalDeviceRayQueryFeaturesKHR", "VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV", "VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR", "VkPhysicalDeviceRayTracingMotionBlurFeaturesNV", "VkPhysicalDeviceRayTracingPipelineFeaturesKHR", "VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR", "VkPhysicalDeviceRayTracingValidationFeaturesNV", "VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG", "VkPhysicalDeviceRenderPassStripedFeaturesARM", "VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV", "VkPhysicalDeviceRobustness2FeaturesEXT", "VkPhysicalDeviceSamplerYcbcrConversionFeatures", "VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR", "VkPhysicalDeviceScalarBlockLayoutFeatures", "VkPhysicalDeviceScalarBlockLayoutFeaturesEXT", "VkPhysicalDeviceSchedulingControlsFeaturesARM", "VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures", "VkPhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR", "VkPhysicalDeviceShaderAtomicFloat16VectorFeaturesNV", "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "VkPhysicalDeviceShaderAtomicInt64Features", "VkPhysicalDeviceShaderAtomicInt64FeaturesKHR", "VkPhysicalDeviceShaderClockFeaturesKHR", "VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM", "VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures", "VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT", "VkPhysicalDeviceShaderDrawParameterFeatures", "VkPhysicalDeviceShaderDrawParametersFeatures", "VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD", "VkPhysicalDeviceShaderEnqueueFeaturesAMDX", "VkPhysicalDeviceShaderExpectAssumeFeatures", "VkPhysicalDeviceShaderExpectAssumeFeaturesKHR", "VkPhysicalDeviceShaderFloat16Int8Features", "VkPhysicalDeviceShaderFloat16Int8FeaturesKHR", "VkPhysicalDeviceShaderFloatControls2Features", "VkPhysicalDeviceShaderFloatControls2FeaturesKHR", "VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT", "VkPhysicalDeviceShaderImageFootprintFeaturesNV", "VkPhysicalDeviceShaderIntegerDotProductFeatures", "VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR", "VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL", "VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR", "VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT", "VkPhysicalDeviceShaderObjectFeaturesEXT", "VkPhysicalDeviceShaderQuadControlFeaturesKHR", "VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR", "VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT", "VkPhysicalDeviceShaderSMBuiltinsFeaturesNV", "VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures", "VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR", "VkPhysicalDeviceShaderSubgroupRotateFeatures", "VkPhysicalDeviceShaderSubgroupRotateFeaturesKHR", "VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR", "VkPhysicalDeviceShaderTerminateInvocationFeatures", "VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR", "VkPhysicalDeviceShaderTileImageFeaturesEXT", "VkPhysicalDeviceShadingRateImageFeaturesNV", "VkPhysicalDeviceSubgroupSizeControlFeatures", "VkPhysicalDeviceSubgroupSizeControlFeaturesEXT", "VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT", "VkPhysicalDeviceSubpassShadingFeaturesHUAWEI", "VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT", "VkPhysicalDeviceSynchronization2Features", "VkPhysicalDeviceSynchronization2FeaturesKHR", "VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT", "VkPhysicalDeviceTextureCompressionASTCHDRFeatures", "VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT", "VkPhysicalDeviceTilePropertiesFeaturesQCOM", "VkPhysicalDeviceTimelineSemaphoreFeatures", "VkPhysicalDeviceTimelineSemaphoreFeaturesKHR", "VkPhysicalDeviceTransformFeedbackFeaturesEXT", "VkPhysicalDeviceUniformBufferStandardLayoutFeatures", "VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR", "VkPhysicalDeviceVariablePointerFeatures", "VkPhysicalDeviceVariablePointerFeaturesKHR", "VkPhysicalDeviceVariablePointersFeatures", "VkPhysicalDeviceVariablePointersFeaturesKHR", "VkPhysicalDeviceVertexAttributeDivisorFeatures", "VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT", "VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR", "VkPhysicalDeviceVertexAttributeRobustnessFeaturesEXT", "VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT", "VkPhysicalDeviceVideoEncodeAV1FeaturesKHR", "VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR", "VkPhysicalDeviceVideoMaintenance1FeaturesKHR", "VkPhysicalDeviceVulkan11Features", "VkPhysicalDeviceVulkan12Features", "VkPhysicalDeviceVulkan13Features", "VkPhysicalDeviceVulkan14Features", "VkPhysicalDeviceVulkanMemoryModelFeatures", "VkPhysicalDeviceVulkanMemoryModelFeaturesKHR", "VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR", "VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT", "VkPhysicalDeviceYcbcrDegammaFeaturesQCOM", "VkPhysicalDeviceYcbcrImageArraysFeaturesEXT", "VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures", "VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceCreateFlags("flags", "reserved for future use.")
    AutoSize("pQueueCreateInfos")..uint32_t("queueCreateInfoCount", "the unsigned integer size of the {@code pQueueCreateInfos} array. Refer to the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#devsandqueues-queue-creation\">Queue Creation</a> section below for further details.")
    VkDeviceQueueCreateInfo.const.p("pQueueCreateInfos", "a pointer to an array of ##VkDeviceQueueCreateInfo structures describing the queues that are requested to be created along with the logical device. Refer to the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#devsandqueues-queue-creation\">Queue Creation</a> section below for further details.")
    AutoSize("ppEnabledLayerNames", optional = true)..uint32_t("enabledLayerCount", "deprecated and ignored.")
    charUTF8.const.p.const.p("ppEnabledLayerNames", "deprecated and ignored. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#extendingvulkan-layers-devicelayerdeprecation\">Device Layer Deprecation</a>.")
    AutoSize("ppEnabledExtensionNames", optional = true)..uint32_t("enabledExtensionCount", "the number of device extensions to enable.")
    charUTF8.const.p.const.p("ppEnabledExtensionNames", "a pointer to an array of {@code enabledExtensionCount} null-terminated UTF-8 strings containing the names of extensions to enable for the created device. See the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#extendingvulkan-extensions\">Extensions</a> section for further details.")
    nullable..VkPhysicalDeviceFeatures.const.p("pEnabledFeatures", "{@code NULL} or a pointer to a ##VkPhysicalDeviceFeatures structure containing boolean indicators of all the features to be enabled. Refer to the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features\">Features</a> section for further details.")
}

val VkExtensionProperties = struct(Module.VULKAN, "VkExtensionProperties", mutable = false) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation =
        """
        Structure specifying an extension properties.

        <h5>See Also</h5>
        ##VkVideoCapabilitiesKHR, ##VkVideoSessionCreateInfoKHR, #EnumerateDeviceExtensionProperties(), #EnumerateInstanceExtensionProperties()
        """

    charUTF8("extensionName", "an array of #MAX_EXTENSION_NAME_SIZE {@code char} containing a null-terminated UTF-8 string which is the name of the extension.")["VK_MAX_EXTENSION_NAME_SIZE"]
    uint32_t("specVersion", "the version of this extension. It is an integer, incremented with backward compatible changes.")
}

val VkLayerProperties = struct(Module.VULKAN, "VkLayerProperties", mutable = false) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation =
        """
        Structure specifying layer properties.

        <h5>See Also</h5>
        #EnumerateDeviceLayerProperties(), #EnumerateInstanceLayerProperties()
        """

    charUTF8("layerName", "an array of #MAX_EXTENSION_NAME_SIZE {@code char} containing a null-terminated UTF-8 string which is the name of the layer. Use this name in the {@code ppEnabledLayerNames} array passed in the ##VkInstanceCreateInfo structure to enable this layer for an instance.")["VK_MAX_EXTENSION_NAME_SIZE"]
    uint32_t("specVersion", "the Vulkan version the layer was written to, encoded as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#extendingvulkan-coreversions-versionnumbers\">Version Numbers</a>.")
    uint32_t("implementationVersion", "the version of this layer. It is an integer, increasing with backward compatible changes.")
    charUTF8("description", "an array of #MAX_DESCRIPTION_SIZE {@code char} containing a null-terminated UTF-8 string which provides additional details that <b>can</b> be used by the application to identify the layer.")["VK_MAX_DESCRIPTION_SIZE"]
}

val VkSubmitInfo = struct(Module.VULKAN, "VkSubmitInfo") {
    documentation =
        """
        Structure specifying a queue submit operation.

        <h5>Description</h5>
        The order that command buffers appear in {@code pCommandBuffers} is used to determine <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-submission-order">submission order</a>, and thus all the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-implicit">implicit ordering guarantees</a> that respect it. Other than these implicit ordering guarantees and any <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization">explicit synchronization primitives</a>, these command buffers <b>may</b> overlap or otherwise execute out of order.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-geometryShader">{@code geometryShader}</a> feature is not enabled, {@code pWaitDstStageMask} <b>must</b> not contain #PIPELINE_STAGE_GEOMETRY_SHADER_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-tessellationShader">{@code tessellationShader}</a> feature is not enabled, {@code pWaitDstStageMask} <b>must</b> not contain #PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or #PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-conditionalRendering">{@code conditionalRendering}</a> feature is not enabled, {@code pWaitDstStageMask} <b>must</b> not contain #PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMap">{@code fragmentDensityMap}</a> feature is not enabled, {@code pWaitDstStageMask} <b>must</b> not contain #PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-transformFeedback">{@code transformFeedback}</a> feature is not enabled, {@code pWaitDstStageMask} <b>must</b> not contain #PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-meshShader">{@code meshShader}</a> feature is not enabled, {@code pWaitDstStageMask} <b>must</b> not contain #PIPELINE_STAGE_MESH_SHADER_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-taskShader">{@code taskShader}</a> feature is not enabled, {@code pWaitDstStageMask} <b>must</b> not contain #PIPELINE_STAGE_TASK_SHADER_BIT_EXT</li>
            <li>If neither of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shadingRateImage">{@code shadingRateImage}</a> or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFragmentShadingRate">{@code attachmentFragmentShadingRate}</a> features are enabled, {@code pWaitDstStageMask} <b>must</b> not contain #PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, {@code pWaitDstStageMask} <b>must</b> not be 0</li>
            <li>If neither the {@link NVRayTracing VK_NV_ray_tracing} extension or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-rayTracingPipeline">{@code rayTracingPipeline}</a> feature are enabled, {@code pWaitDstStageMask} <b>must</b> not contain #PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR</li>
            <li>Each element of {@code pCommandBuffers} <b>must</b> not have been allocated with #COMMAND_BUFFER_LEVEL_SECONDARY</li>
            <li>Each element of {@code pWaitDstStageMask} <b>must</b> not include #PIPELINE_STAGE_HOST_BIT</li>
            <li>If any element of {@code pWaitSemaphores} or {@code pSignalSemaphores} was created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE, then the {@code pNext} chain <b>must</b> include a ##VkTimelineSemaphoreSubmitInfo structure</li>
            <li>If the {@code pNext} chain of this structure includes a ##VkTimelineSemaphoreSubmitInfo structure and any element of {@code pWaitSemaphores} was created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE, then its {@code waitSemaphoreValueCount} member <b>must</b> equal {@code waitSemaphoreCount}</li>
            <li>If the {@code pNext} chain of this structure includes a ##VkTimelineSemaphoreSubmitInfo structure and any element of {@code pSignalSemaphores} was created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE, then its {@code signalSemaphoreValueCount} member <b>must</b> equal {@code signalSemaphoreCount}</li>
            <li>For each element of {@code pSignalSemaphores} created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE the corresponding element of ##VkTimelineSemaphoreSubmitInfo{@code ::pSignalSemaphoreValues} <b>must</b> have a value greater than the current value of the semaphore when the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphores-signaling">semaphore signal operation</a> is executed</li>
            <li>For each element of {@code pWaitSemaphores} created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE the corresponding element of ##VkTimelineSemaphoreSubmitInfo{@code ::pWaitSemaphoreValues} <b>must</b> have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on that semaphore by more than <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxTimelineSemaphoreValueDifference">{@code maxTimelineSemaphoreValueDifference}</a></li>
            <li>For each element of {@code pSignalSemaphores} created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE the corresponding element of ##VkTimelineSemaphoreSubmitInfo{@code ::pSignalSemaphoreValues} <b>must</b> have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on that semaphore by more than <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxTimelineSemaphoreValueDifference">{@code maxTimelineSemaphoreValueDifference}</a></li>
            <li>If the {@code pNext} chain of this structure does not include a ##VkProtectedSubmitInfo structure with {@code protectedSubmit} set to #TRUE, then each element of the {@code pCommandBuffers} array <b>must</b> be an unprotected command buffer</li>
            <li>If the {@code pNext} chain of this structure includes a ##VkProtectedSubmitInfo structure with {@code protectedSubmit} set to #TRUE, then each element of the {@code pCommandBuffers} array <b>must</b> be a protected command buffer</li>
            <li>If {@code pCommandBuffers} contains any <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-suspension">resumed render pass instances</a>, they <b>must</b> be suspended by a render pass instance earlier in submission order within {@code pCommandBuffers}</li>
            <li>If {@code pCommandBuffers} contains any <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-suspension">suspended render pass instances</a>, they <b>must</b> be resumed by a render pass instance later in submission order within {@code pCommandBuffers}</li>
            <li>If {@code pCommandBuffers} contains any <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-suspension">suspended render pass instances</a>, there <b>must</b> be no action or synchronization commands executed in a primary or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#commandbuffers-secondary">secondary</a> command buffer between that render pass instance and the render pass instance that resumes it</li>
            <li>If {@code pCommandBuffers} contains any <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-suspension">suspended render pass instances</a>, there <b>must</b> be no render pass instances between that render pass instance and the render pass instance that resumes it</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-variableSampleLocations">{@code variableSampleLocations}</a> limit is not supported, and any element of {@code pCommandBuffers} contains any <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-suspension">suspended render pass instances</a>, where a graphics pipeline has been bound, any pipelines bound in the render pass instance that resumes it, or any subsequent render pass instances that resume from that one and so on, <b>must</b> use the same sample locations</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SUBMIT_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkAmigoProfilingSubmitInfoSEC, ##VkD3D12FenceSubmitInfoKHR, ##VkDeviceGroupSubmitInfo, ##VkFrameBoundaryEXT, ##VkLatencySubmissionPresentIdNV, ##VkPerformanceQuerySubmitInfoKHR, ##VkProtectedSubmitInfo, ##VkTimelineSemaphoreSubmitInfo, ##VkWin32KeyedMutexAcquireReleaseInfoKHR, or ##VkWin32KeyedMutexAcquireReleaseInfoNV</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>If {@code waitSemaphoreCount} is not 0, {@code pWaitSemaphores} <b>must</b> be a valid pointer to an array of {@code waitSemaphoreCount} valid {@code VkSemaphore} handles</li>
            <li>If {@code waitSemaphoreCount} is not 0, {@code pWaitDstStageMask} <b>must</b> be a valid pointer to an array of {@code waitSemaphoreCount} valid combinations of {@code VkPipelineStageFlagBits} values</li>
            <li>If {@code commandBufferCount} is not 0, {@code pCommandBuffers} <b>must</b> be a valid pointer to an array of {@code commandBufferCount} valid {@code VkCommandBuffer} handles</li>
            <li>If {@code signalSemaphoreCount} is not 0, {@code pSignalSemaphores} <b>must</b> be a valid pointer to an array of {@code signalSemaphoreCount} valid {@code VkSemaphore} handles</li>
            <li>Each of the elements of {@code pCommandBuffers}, the elements of {@code pSignalSemaphores}, and the elements of {@code pWaitSemaphores} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #QueueSubmit()
        """

    Expression("#STRUCTURE_TYPE_SUBMIT_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkAmigoProfilingSubmitInfoSEC", "VkD3D12FenceSubmitInfoKHR", "VkDeviceGroupSubmitInfo", "VkDeviceGroupSubmitInfoKHR", "VkFrameBoundaryEXT", "VkLatencySubmissionPresentIdNV", "VkPerformanceQuerySubmitInfoKHR", "VkProtectedSubmitInfo", "VkTimelineSemaphoreSubmitInfo", "VkTimelineSemaphoreSubmitInfoKHR", "VkWin32KeyedMutexAcquireReleaseInfoKHR", "VkWin32KeyedMutexAcquireReleaseInfoNV",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pWaitSemaphores", "pWaitDstStageMask", optional = true)..uint32_t("waitSemaphoreCount", "the number of semaphores upon which to wait before executing the command buffers for the batch.")
    VkSemaphore.const.p("pWaitSemaphores", "a pointer to an array of {@code VkSemaphore} handles upon which to wait before the command buffers for this batch begin execution. If semaphores to wait on are provided, they define a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-semaphores-waiting\">semaphore wait operation</a>.")
    nullable..VkPipelineStageFlags.const.p("pWaitDstStageMask", "a pointer to an array of pipeline stages at which each corresponding semaphore wait will occur.")
    AutoSize("pCommandBuffers", optional = true)..uint32_t("commandBufferCount", "the number of command buffers to execute in the batch.")
    VkCommandBuffer.const.p("pCommandBuffers", "a pointer to an array of {@code VkCommandBuffer} handles to execute in the batch.")
    AutoSize("pSignalSemaphores", optional = true)..uint32_t("signalSemaphoreCount", "the number of semaphores to be signaled once the commands specified in {@code pCommandBuffers} have completed execution.")
    VkSemaphore.const.p("pSignalSemaphores", "a pointer to an array of {@code VkSemaphore} handles which will be signaled when the command buffers for this batch have completed execution. If semaphores to be signaled are provided, they define a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-semaphores-signaling\">semaphore signal operation</a>.")
}

val VkMappedMemoryRange = struct(Module.VULKAN, "VkMappedMemoryRange") {
    documentation =
        """
        Structure specifying a mapped memory range.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code memory} <b>must</b> be currently host mapped</li>
            <li>If {@code size} is not equal to #WHOLE_SIZE, {@code offset} and {@code size} <b>must</b> specify a range contained within the currently mapped range of {@code memory}</li>
            <li>If {@code size} is equal to #WHOLE_SIZE, {@code offset} <b>must</b> be within the currently mapped range of {@code memory}</li>
            <li>{@code offset} <b>must</b> be a multiple of ##VkPhysicalDeviceLimits{@code ::nonCoherentAtomSize}</li>
            <li>If {@code size} is equal to #WHOLE_SIZE, the end of the current mapping of {@code memory} <b>must</b> either be a multiple of ##VkPhysicalDeviceLimits{@code ::nonCoherentAtomSize} bytes from the beginning of the memory object, or be equal to the end of the memory object</li>
            <li>If {@code size} is not equal to #WHOLE_SIZE, {@code size} <b>must</b> either be a multiple of ##VkPhysicalDeviceLimits{@code ::nonCoherentAtomSize}, or {@code offset} plus {@code size} <b>must</b> equal the size of {@code memory}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MAPPED_MEMORY_RANGE</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
        </ul>

        <h5>See Also</h5>
        #FlushMappedMemoryRanges(), #InvalidateMappedMemoryRanges()
        """

    Expression("#STRUCTURE_TYPE_MAPPED_MEMORY_RANGE")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceMemory("memory", "the memory object to which this range belongs.")
    VkDeviceSize("offset", "the zero-based byte offset from the beginning of the memory object.")
    VkDeviceSize("size", "either the size of range, or #WHOLE_SIZE to affect the range from {@code offset} to the end of the current mapping of the allocation.")
}

val VkMemoryAllocateInfo = struct(Module.VULKAN, "VkMemoryAllocateInfo") {
    documentation =
        """
        Structure containing parameters of a memory allocation.

        <h5>Description</h5>
        The internal data of an allocated device memory object <b>must</b> include a reference to implementation-specific resources, referred to as the memory object’s <em>payload</em>. Applications <b>can</b> also import and export that internal data to and from device memory objects to share data between Vulkan instances and other compatible APIs. A ##VkMemoryAllocateInfo structure defines a memory import operation if its {@code pNext} chain includes one of the following structures:

        <ul>
            <li>##VkImportMemoryWin32HandleInfoKHR with a non-zero {@code handleType} value</li>
            <li>##VkImportMemoryFdInfoKHR with a non-zero {@code handleType} value</li>
            <li>##VkImportMemoryHostPointerInfoEXT with a non-zero {@code handleType} value</li>
            <li>##VkImportAndroidHardwareBufferInfoANDROID with a non-{@code NULL} {@code buffer} value</li>
        </ul>

        If the parameters define an import operation and the external handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, #EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT, or #EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, {@code allocationSize} is ignored. The implementation <b>must</b> query the size of these allocations from the OS.

        Whether device memory objects constructed via a memory import operation hold a reference to their payload depends on the properties of the handle type used to perform the import, as defined below for each valid handle type. Importing memory <b>must</b> not modify the content of the memory. Implementations <b>must</b> ensure that importing memory does not enable the importing Vulkan instance to access any memory or resources in other Vulkan instances other than that corresponding to the memory object imported. Implementations <b>must</b> also ensure accessing imported memory which has not been initialized does not allow the importing Vulkan instance to obtain data from the exporting Vulkan instance or vice-versa.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        How exported and imported memory is isolated is left to the implementation, but applications should be aware that such isolation <b>may</b> prevent implementations from placing multiple exportable memory objects in the same physical or virtual page. Hence, applications <b>should</b> avoid creating many small external memory objects whenever possible.
        </div>

        Importing memory <b>must</b> not increase overall heap usage within a system. However, it <b>must</b> affect the following per-process values:

        <ul>
            <li>##VkPhysicalDeviceLimits{@code ::maxMemoryAllocationCount}</li>
            <li>##VkPhysicalDeviceMemoryBudgetPropertiesEXT{@code ::heapUsage}</li>
        </ul>

        When performing a memory import operation, it is the responsibility of the application to ensure the external handles and their associated payloads meet all valid usage requirements. However, implementations <b>must</b> perform sufficient validation of external handles and payloads to ensure that the operation results in a valid memory object which will not cause program termination, device loss, queue stalls, or corruption of other resources when used as allowed according to its allocation parameters. If the external handle provided does not meet these requirements, the implementation <b>must</b> fail the memory import operation with the error code #ERROR_INVALID_EXTERNAL_HANDLE. If the parameters define an export operation and the external handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, implementations <b>should</b> not strictly follow {@code memoryTypeIndex}. Instead, they <b>should</b> modify the allocation internally to use the required memory type for the application’s given usage. This is because for an export operation, there is currently no way for the application to know the memory type index before allocating.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the parameters do not define an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-import-operation">import or export operation</a>, {@code allocationSize} <b>must</b> be greater than 0</li>
            <li>The parameters <b>must</b> not define more than one <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-import-operation">import operation</a></li>
            <li>If the parameters define an export operation and the handle type is not #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID , {@code allocationSize} <b>must</b> be greater than 0</li>
            <li>If the {@code pNext} chain includes a ##VkExportMemoryAllocateInfo structure, and any of the handle types specified in ##VkExportMemoryAllocateInfo{@code ::handleTypes} require a dedicated allocation, as reported by #GetPhysicalDeviceImageFormatProperties2() in ##VkExternalImageFormatProperties{@code ::externalMemoryProperties.externalMemoryFeatures}, or by #GetPhysicalDeviceExternalBufferProperties() in ##VkExternalBufferProperties{@code ::externalMemoryProperties.externalMemoryFeatures}, the {@code pNext} chain <b>must</b> include a ##VkMemoryDedicatedAllocateInfo or ##VkDedicatedAllocationMemoryAllocateInfoNV structure with either its {@code image} or {@code buffer} member set to a value other than #NULL_HANDLE</li>
            <li>If the {@code pNext} chain includes a ##VkExportMemoryAllocateInfo structure, it <b>must</b> not include a ##VkExportMemoryAllocateInfoNV or ##VkExportMemoryWin32HandleInfoNV structure</li>
            <li>If the {@code pNext} chain includes a ##VkImportMemoryWin32HandleInfoKHR structure, it <b>must</b> not include a ##VkImportMemoryWin32HandleInfoNV structure</li>
            <li>If the parameters define an import operation, the external handle specified was created by the Vulkan API, and the external handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT, then the values of {@code allocationSize} and {@code memoryTypeIndex} <b>must</b> match those specified when the payload being imported was created</li>
            <li>If the parameters define an import operation and the external handle specified was created by the Vulkan API, the device mask specified by ##VkMemoryAllocateFlagsInfo <b>must</b> match the mask specified when the payload being imported was allocated</li>
            <li>If the parameters define an import operation and the external handle specified was created by the Vulkan API, the list of physical devices that comprise the logical device passed to #AllocateMemory() <b>must</b> match the list of physical devices that comprise the logical device on which the payload was originally allocated</li>
            <li>If the parameters define an import operation and the external handle is an NT handle or a global share handle created outside of the Vulkan API, the value of {@code memoryTypeIndex} <b>must</b> be one of those returned by #GetMemoryWin32HandlePropertiesKHR()</li>
            <li>If the parameters define an import operation, the external handle was created by the Vulkan API, and the external handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT or #EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, then the values of {@code allocationSize} and {@code memoryTypeIndex} <b>must</b> match those specified when the payload being imported was created</li>
            <li>If the parameters define an import operation and the external handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, {@code allocationSize} <b>must</b> match the size specified when creating the Direct3D 12 heap from which the payload was extracted</li>
            <li>If the parameters define an import operation and the external handle is a POSIX file descriptor created outside of the Vulkan API, the value of {@code memoryTypeIndex} <b>must</b> be one of those returned by #GetMemoryFdPropertiesKHR()</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-protectedMemory">{@code protectedMemory}</a> feature is not enabled, the ##VkMemoryAllocateInfo{@code ::memoryTypeIndex} <b>must</b> not indicate a memory type that reports #MEMORY_PROPERTY_PROTECTED_BIT</li>
            <li>If the parameters define an import operation and the external handle is a host pointer, the value of {@code memoryTypeIndex} <b>must</b> be one of those returned by #GetMemoryHostPointerPropertiesEXT()</li>
            <li>If the parameters define an import operation and the external handle is a host pointer, {@code allocationSize} <b>must</b> be an integer multiple of ##VkPhysicalDeviceExternalMemoryHostPropertiesEXT{@code ::minImportedHostPointerAlignment}</li>
            <li>If the parameters define an import operation and the external handle is a host pointer, the {@code pNext} chain <b>must</b> not include a ##VkDedicatedAllocationMemoryAllocateInfoNV structure with either its {@code image} or {@code buffer} field set to a value other than #NULL_HANDLE</li>
            <li>If the parameters define an import operation and the external handle is a host pointer, the {@code pNext} chain <b>must</b> not include a ##VkMemoryDedicatedAllocateInfo structure with either its {@code image} or {@code buffer} field set to a value other than #NULL_HANDLE</li>
            <li>If the parameters define an import operation and the external handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, {@code allocationSize} <b>must</b> be the size returned by #GetAndroidHardwareBufferPropertiesANDROID() for the Android hardware buffer</li>
            <li>If the parameters define an import operation and the external handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, and the {@code pNext} chain does not include a ##VkMemoryDedicatedAllocateInfo structure or ##VkMemoryDedicatedAllocateInfo{@code ::image} is #NULL_HANDLE, the Android hardware buffer <b>must</b> have a {@code AHardwareBuffer_Desc}{@code ::format} of {@code AHARDWAREBUFFER_FORMAT_BLOB} and a {@code AHardwareBuffer_Desc}{@code ::usage} that includes {@code AHARDWAREBUFFER_USAGE_GPU_DATA_BUFFER}</li>
            <li>If the parameters define an import operation and the external handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, {@code memoryTypeIndex} <b>must</b> be one of those returned by #GetAndroidHardwareBufferPropertiesANDROID() for the Android hardware buffer</li>
            <li>If the parameters do not define an import operation, and the {@code pNext} chain includes a ##VkExportMemoryAllocateInfo structure with #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID included in its {@code handleTypes} member, and the {@code pNext} chain includes a ##VkMemoryDedicatedAllocateInfo structure with {@code image} not equal to #NULL_HANDLE, then {@code allocationSize} <b>must</b> be 0</li>
            <li>If the parameters define an export operation, the handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, and the {@code pNext} does not include a ##VkMemoryDedicatedAllocateInfo structure, {@code allocationSize} <b>must</b> be greater than 0</li>
            <li>If the parameters define an export operation, the handle type is #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, and the {@code pNext} chain includes a ##VkMemoryDedicatedAllocateInfo structure with {@code buffer} set to a valid {@code VkBuffer} object, {@code allocationSize} <b>must</b> be greater than 0</li>
            <li>If the parameters define an import operation, the external handle is an Android hardware buffer, and the {@code pNext} chain includes a ##VkMemoryDedicatedAllocateInfo with {@code image} that is not #NULL_HANDLE, the Android hardware buffer’s {@code AHardwareBuffer}{@code ::usage} <b>must</b> include at least one of {@code AHARDWAREBUFFER_USAGE_GPU_FRAMEBUFFER}, {@code AHARDWAREBUFFER_USAGE_GPU_SAMPLED_IMAGE} or {@code AHARDWAREBUFFER_USAGE_GPU_DATA_BUFFER}</li>
            <li>If the parameters define an import operation, the external handle is an Android hardware buffer, and the {@code pNext} chain includes a ##VkMemoryDedicatedAllocateInfo with {@code image} that is not #NULL_HANDLE, the format of {@code image} <b>must</b> be #FORMAT_UNDEFINED or the format returned by #GetAndroidHardwareBufferPropertiesANDROID() in ##VkAndroidHardwareBufferFormatPropertiesANDROID{@code ::format} for the Android hardware buffer</li>
            <li>If the parameters define an import operation, the external handle is an Android hardware buffer, and the {@code pNext} chain includes a ##VkMemoryDedicatedAllocateInfo structure with {@code image} that is not #NULL_HANDLE, the width, height, and array layer dimensions of {@code image} and the Android hardware buffer’s {@code AHardwareBuffer_Desc} <b>must</b> be identical</li>
            <li>If the parameters define an import operation, the external handle is an Android hardware buffer, and the {@code pNext} chain includes a ##VkMemoryDedicatedAllocateInfo structure with {@code image} that is not #NULL_HANDLE, and the Android hardware buffer’s {@code AHardwareBuffer}{@code ::usage} includes {@code AHARDWAREBUFFER_USAGE_GPU_MIPMAP_COMPLETE}, the {@code image} <b>must</b> have a complete mipmap chain</li>
            <li>If the parameters define an import operation, the external handle is an Android hardware buffer, and the {@code pNext} chain includes a ##VkMemoryDedicatedAllocateInfo structure with {@code image} that is not #NULL_HANDLE, and the Android hardware buffer’s {@code AHardwareBuffer}{@code ::usage} does not include {@code AHARDWAREBUFFER_USAGE_GPU_MIPMAP_COMPLETE}, the {@code image} <b>must</b> have exactly one mipmap level</li>
            <li>If the parameters define an import operation, the external handle is an Android hardware buffer, and the {@code pNext} chain includes a ##VkMemoryDedicatedAllocateInfo structure with {@code image} that is not #NULL_HANDLE, each bit set in the usage of {@code image} <b>must</b> be listed in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-external-android-hardware-buffer-usage">AHardwareBuffer Usage Equivalence</a>, and if there is a corresponding {@code AHARDWAREBUFFER_USAGE} bit listed that bit <b>must</b> be included in the Android hardware buffer’s {@code AHardwareBuffer_Desc}{@code ::usage}</li>
            <li>If ##VkMemoryOpaqueCaptureAddressAllocateInfo{@code ::opaqueCaptureAddress} is not zero, ##VkMemoryAllocateFlagsInfo{@code ::flags} <b>must</b> include #MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT</li>
            <li>If ##VkMemoryAllocateFlagsInfo{@code ::flags} includes #MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-bufferDeviceAddressCaptureReplay">{@code bufferDeviceAddressCaptureReplay}</a> feature <b>must</b> be enabled</li>
            <li>If ##VkMemoryAllocateFlagsInfo{@code ::flags} includes #MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-bufferDeviceAddress">{@code bufferDeviceAddress}</a> feature <b>must</b> be enabled</li>
            <li>If the {@code pNext} chain includes a ##VkImportMemoryHostPointerInfoEXT structure, ##VkMemoryOpaqueCaptureAddressAllocateInfo{@code ::opaqueCaptureAddress} <b>must</b> be zero</li>
            <li>If the parameters define an import operation, ##VkMemoryOpaqueCaptureAddressAllocateInfo{@code ::opaqueCaptureAddress} <b>must</b> be zero</li>
            <li>If the {@code pNext} chain includes a ##VkExportMetalObjectCreateInfoEXT structure, its {@code exportObjectType} member <b>must</b> be #EXPORT_METAL_OBJECT_TYPE_METAL_BUFFER_BIT_EXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDedicatedAllocationMemoryAllocateInfoNV, ##VkExportMemoryAllocateInfo, ##VkExportMemoryAllocateInfoNV, ##VkExportMemoryWin32HandleInfoKHR, ##VkExportMemoryWin32HandleInfoNV, ##VkExportMetalObjectCreateInfoEXT, ##VkImportAndroidHardwareBufferInfoANDROID, ##VkImportMemoryFdInfoKHR, ##VkImportMemoryHostPointerInfoEXT, ##VkImportMemoryWin32HandleInfoKHR, ##VkImportMemoryWin32HandleInfoNV, ##VkImportMetalBufferInfoEXT, ##VkMemoryAllocateFlagsInfo, ##VkMemoryDedicatedAllocateInfo, ##VkMemoryOpaqueCaptureAddressAllocateInfo, or ##VkMemoryPriorityAllocateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique, with the exception of structures of type ##VkExportMetalObjectCreateInfoEXT</li>
        </ul>

        <h5>See Also</h5>
        #AllocateMemory()
        """

    Expression("#STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDedicatedAllocationMemoryAllocateInfoNV", "VkExportMemoryAllocateInfo", "VkExportMemoryAllocateInfoKHR", "VkExportMemoryAllocateInfoNV", "VkExportMemoryWin32HandleInfoKHR", "VkExportMemoryWin32HandleInfoNV", "VkExportMetalObjectCreateInfoEXT", "VkImportAndroidHardwareBufferInfoANDROID", "VkImportMemoryFdInfoKHR", "VkImportMemoryHostPointerInfoEXT", "VkImportMemoryWin32HandleInfoKHR", "VkImportMemoryWin32HandleInfoNV", "VkImportMetalBufferInfoEXT", "VkMemoryAllocateFlagsInfo", "VkMemoryAllocateFlagsInfoKHR", "VkMemoryDedicatedAllocateInfo", "VkMemoryDedicatedAllocateInfoKHR", "VkMemoryOpaqueCaptureAddressAllocateInfo", "VkMemoryOpaqueCaptureAddressAllocateInfoKHR", "VkMemoryPriorityAllocateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceSize("allocationSize", "the size of the allocation in bytes.")
    uint32_t("memoryTypeIndex", "an index identifying a memory type from the {@code memoryTypes} array of the ##VkPhysicalDeviceMemoryProperties structure.")
}

val VkMemoryRequirements = struct(Module.VULKAN, "VkMemoryRequirements", mutable = false) {
    documentation =
        """
        Structure specifying memory requirements.

        <h5>See Also</h5>
        ##VkMemoryRequirements2, ##VkVideoSessionMemoryRequirementsKHR, #GetBufferMemoryRequirements(), #GetImageMemoryRequirements()
        """

    VkDeviceSize("size", "the size, in bytes, of the memory allocation <b>required</b> for the resource.")
    VkDeviceSize("alignment", "the alignment, in bytes, of the offset within the allocation <b>required</b> for the resource.")
    uint32_t("memoryTypeBits", "a bitmask and contains one bit set for every supported memory type for the resource. Bit {@code i} is set if and only if the memory type {@code i} in the ##VkPhysicalDeviceMemoryProperties structure for the physical device is supported for the resource.")
}

val VkSparseMemoryBind = struct(Module.VULKAN, "VkSparseMemoryBind") {
    documentation =
        """
        Structure specifying a sparse memory bind operation.

        <h5>Description</h5>
        The <em>binding range</em> <code>[resourceOffset, resourceOffset + size)</code> has different constraints based on {@code flags}. If {@code flags} contains #SPARSE_MEMORY_BIND_METADATA_BIT, the binding range <b>must</b> be within the mip tail region of the metadata aspect. This metadata region is defined by:

        <dl>
            <dd><code>metadataRegion = [base, base + imageMipTailSize)</code></dd>

            <dd><code>base = imageMipTailOffset + imageMipTailStride × n</code></dd>
        </dl>

        and {@code imageMipTailOffset}, {@code imageMipTailSize}, and {@code imageMipTailStride} values are from the ##VkSparseImageMemoryRequirements corresponding to the metadata aspect of the image, and <code>n</code> is a valid array layer index for the image,

        {@code imageMipTailStride} is considered to be zero for aspects where ##VkSparseImageMemoryRequirements{@code ::formatProperties.flags} contains #SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT.

        If {@code flags} does not contain #SPARSE_MEMORY_BIND_METADATA_BIT, the binding range <b>must</b> be within the range <code>[0,##VkMemoryRequirements::size)</code>.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code memory} is not #NULL_HANDLE, {@code memory} and {@code memoryOffset} <b>must</b> match the memory requirements of the resource, as described in section <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-association">Resource Memory Association</a></li>
            <li>If the resource being bound is a {@code VkBuffer}, {@code resourceOffset}, {@code memoryOffset} and {@code size} <b>must</b> be an integer multiple of the {@code alignment} of the ##VkMemoryRequirements structure returned from a call to #GetBufferMemoryRequirements() with the buffer resource</li>
            <li>If the resource being bound is a {@code VkImage}, {@code resourceOffset} and {@code memoryOffset} <b>must</b> be an integer multiple of the {@code alignment} of the ##VkMemoryRequirements structure returned from a call to #GetImageMemoryRequirements() with the image resource</li>
            <li>If {@code memory} is not #NULL_HANDLE, {@code memory} <b>must</b> not have been created with a memory type that reports #MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT bit set</li>
            <li>{@code size} <b>must</b> be greater than 0</li>
            <li>{@code resourceOffset} <b>must</b> be less than the size of the resource</li>
            <li>{@code size} <b>must</b> be less than or equal to the size of the resource minus {@code resourceOffset}</li>
            <li>{@code memoryOffset} <b>must</b> be less than the size of {@code memory}</li>
            <li>{@code size} <b>must</b> be less than or equal to the size of {@code memory} minus {@code memoryOffset}</li>
            <li>If {@code memory} was created with ##VkExportMemoryAllocateInfo{@code ::handleTypes} not equal to 0, at least one handle type it contained <b>must</b> also have been set in ##VkExternalMemoryBufferCreateInfo{@code ::handleTypes} or ##VkExternalMemoryImageCreateInfo{@code ::handleTypes} when the resource was created</li>
            <li>If {@code memory} was created by a memory import operation, the external handle type of the imported memory <b>must</b> also have been set in ##VkExternalMemoryBufferCreateInfo{@code ::handleTypes} or ##VkExternalMemoryImageCreateInfo{@code ::handleTypes} when the resource was created</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>If {@code memory} is not #NULL_HANDLE, {@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkSparseMemoryBindFlagBits} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkSparseBufferMemoryBindInfo, ##VkSparseImageOpaqueMemoryBindInfo
        """

    VkDeviceSize("resourceOffset", "the offset into the resource.")
    VkDeviceSize("size", "the size of the memory region to be bound.")
    VkDeviceMemory("memory", "the {@code VkDeviceMemory} object that the range of the resource is bound to. If {@code memory} is #NULL_HANDLE, the range is unbound.")
    VkDeviceSize("memoryOffset", "the offset into the {@code VkDeviceMemory} object to bind the resource range to. If {@code memory} is #NULL_HANDLE, this value is ignored.")
    VkSparseMemoryBindFlags("flags", "a bitmask of {@code VkSparseMemoryBindFlagBits} specifying usage of the binding operation.")
}

val VkSparseBufferMemoryBindInfo = struct(Module.VULKAN, "VkSparseBufferMemoryBindInfo") {
    documentation =
        """
        Structure specifying a sparse buffer memory bind operation.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>{@code pBinds} <b>must</b> be a valid pointer to an array of {@code bindCount} valid ##VkSparseMemoryBind structures</li>
            <li>{@code bindCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkBindSparseInfo, ##VkSparseMemoryBind
        """

    VkBuffer("buffer", "the {@code VkBuffer} object to be bound.")
    AutoSize("pBinds")..uint32_t("bindCount", "the number of ##VkSparseMemoryBind structures in the {@code pBinds} array.")
    VkSparseMemoryBind.const.p("pBinds", "a pointer to an array of ##VkSparseMemoryBind structures.")
}

val VkSparseImageOpaqueMemoryBindInfo = struct(Module.VULKAN, "VkSparseImageOpaqueMemoryBindInfo") {
    documentation =
        """
        Structure specifying sparse image opaque memory bind information.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        This structure is normally used to bind memory to fully-resident sparse images or for mip tail regions of partially resident images. However, it <b>can</b> also be used to bind memory for the entire binding range of partially resident images.

        If the {@code pBinds}[i].flags of an element <em>i</em> of {@code pBinds} does not contain #SPARSE_MEMORY_BIND_METADATA_BIT, the {@code resourceOffset} is in the range <code>[0, ##VkMemoryRequirements::size)</code>, This range includes data from all aspects of the image, including metadata. For most implementations this will probably mean that the {@code resourceOffset} is a simple device address offset within the resource. It is possible for an application to bind a range of memory that includes both resource data and metadata. However, the application would not know what part of the image the memory is used for, or if any range is being used for metadata.

        If the {@code pBinds}[i].flags of an element <em>i</em> of {@code pBinds} contains #SPARSE_MEMORY_BIND_METADATA_BIT, the binding range specified <b>must</b> be within the mip tail region of the metadata aspect. In this case the {@code resourceOffset} is not <b>required</b> to be a simple device address offset within the resource. However, it <em>is</em> defined to be within <code>[imageMipTailOffset, imageMipTailOffset + imageMipTailSize)</code> for the metadata aspect. See ##VkSparseMemoryBind for the full constraints on binding region with this flag present.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code flags} member of any element of {@code pBinds} contains #SPARSE_MEMORY_BIND_METADATA_BIT, the binding range defined <b>must</b> be within the mip tail region of the metadata aspect of {@code image}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code image} <b>must</b> be a valid {@code VkImage} handle</li>
            <li>{@code pBinds} <b>must</b> be a valid pointer to an array of {@code bindCount} valid ##VkSparseMemoryBind structures</li>
            <li>{@code bindCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkBindSparseInfo, ##VkSparseMemoryBind
        """

    VkImage("image", "the {@code VkImage} object to be bound.")
    AutoSize("pBinds")..uint32_t("bindCount", "the number of ##VkSparseMemoryBind structures in the {@code pBinds} array.")
    VkSparseMemoryBind.const.p("pBinds", "a pointer to an array of ##VkSparseMemoryBind structures.")
}

val VkImageSubresource = struct(Module.VULKAN, "VkImageSubresource") {
    documentation =
        """
        Structure specifying an image subresource.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code aspectMask} <b>must</b> be a valid combination of {@code VkImageAspectFlagBits} values</li>
            <li>{@code aspectMask} <b>must</b> not be 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkImageSubresource2, ##VkSparseImageMemoryBind, #GetImageSubresourceLayout()
        """

    VkImageAspectFlags("aspectMask", "a {@code VkImageAspectFlags} value selecting the image <em>aspect</em>.")
    uint32_t("mipLevel", "selects the mipmap level.")
    uint32_t("arrayLayer", "selects the array layer.")
}

val VkSparseImageMemoryBind = struct(Module.VULKAN, "VkSparseImageMemoryBind") {
    documentation =
        """
        Structure specifying sparse image memory bind.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidencyAliased">{@code sparseResidencyAliased}</a> feature is not enabled, and if any other resources are bound to ranges of {@code memory}, the range of {@code memory} being bound <b>must</b> not overlap with those bound ranges</li>
            <li>{@code memory} and {@code memoryOffset} <b>must</b> match the memory requirements of the calling command’s {@code image}, as described in section <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-association">Resource Memory Association</a></li>
            <li>{@code offset.x} <b>must</b> be a multiple of the sparse image block width (##VkSparseImageFormatProperties{@code ::imageGranularity.width}) of the image</li>
            <li>{@code extent.width} <b>must</b> be greater than 0</li>
            <li>{@code extent.width} <b>must</b> either be a multiple of the sparse image block width of the image, or else <code>(extent.width + offset.x)</code> <b>must</b> equal the width of the image subresource</li>
            <li>{@code offset.y} <b>must</b> be a multiple of the sparse image block height (##VkSparseImageFormatProperties{@code ::imageGranularity.height}) of the image</li>
            <li>{@code extent.height} <b>must</b> be greater than 0</li>
            <li>{@code extent.height} <b>must</b> either be a multiple of the sparse image block height of the image, or else <code>(extent.height + offset.y)</code> <b>must</b> equal the height of the image subresource</li>
            <li>{@code offset.z} <b>must</b> be a multiple of the sparse image block depth (##VkSparseImageFormatProperties{@code ::imageGranularity.depth}) of the image</li>
            <li>{@code extent.depth} <b>must</b> be greater than 0</li>
            <li>{@code extent.depth} <b>must</b> either be a multiple of the sparse image block depth of the image, or else <code>(extent.depth + offset.z)</code> <b>must</b> equal the depth of the image subresource</li>
            <li>If {@code memory} was created with ##VkExportMemoryAllocateInfo{@code ::handleTypes} not equal to 0, at least one handle type it contained <b>must</b> also have been set in ##VkExternalMemoryImageCreateInfo{@code ::handleTypes} when the image was created</li>
            <li>If {@code memory} was created by a memory import operation, the external handle type of the imported memory <b>must</b> also have been set in ##VkExternalMemoryImageCreateInfo{@code ::handleTypes} when {@code image} was created</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code subresource} <b>must</b> be a valid ##VkImageSubresource structure</li>
            <li>If {@code memory} is not #NULL_HANDLE, {@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkSparseMemoryBindFlagBits} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent3D, ##VkImageSubresource, ##VkOffset3D, ##VkSparseImageMemoryBindInfo
        """

    VkImageSubresource("subresource", "the image <em>aspect</em> and region of interest in the image.")
    VkOffset3D("offset", "are the coordinates of the first texel within the image subresource to bind.")
    VkExtent3D("extent", "the size in texels of the region within the image subresource to bind. The extent <b>must</b> be a multiple of the sparse image block dimensions, except when binding sparse image blocks along the edge of an image subresource it <b>can</b> instead be such that any coordinate of <code>offset + extent</code> equals the corresponding dimensions of the image subresource.")
    VkDeviceMemory("memory", "the {@code VkDeviceMemory} object that the sparse image blocks of the image are bound to. If {@code memory} is #NULL_HANDLE, the sparse image blocks are unbound.")
    VkDeviceSize("memoryOffset", "an offset into {@code VkDeviceMemory} object. If {@code memory} is #NULL_HANDLE, this value is ignored.")
    VkSparseMemoryBindFlags("flags", "are sparse memory binding flags.")
}

val VkSparseImageMemoryBindInfo = struct(Module.VULKAN, "VkSparseImageMemoryBindInfo") {
    documentation =
        """
        Structure specifying sparse image memory bind information.

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code subresource.mipLevel} member of each element of {@code pBinds} <b>must</b> be less than the {@code mipLevels} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>The {@code subresource.arrayLayer} member of each element of {@code pBinds} <b>must</b> be less than the {@code arrayLayers} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>The {@code subresource.aspectMask} member of each element of {@code pBinds} <b>must</b> be valid for the {@code format} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>{@code image} <b>must</b> have been created with #IMAGE_CREATE_SPARSE_RESIDENCY_BIT set</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code image} <b>must</b> be a valid {@code VkImage} handle</li>
            <li>{@code pBinds} <b>must</b> be a valid pointer to an array of {@code bindCount} valid ##VkSparseImageMemoryBind structures</li>
            <li>{@code bindCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkBindSparseInfo, ##VkSparseImageMemoryBind
        """

    VkImage("image", "the {@code VkImage} object to be bound")
    AutoSize("pBinds")..uint32_t("bindCount", "the number of ##VkSparseImageMemoryBind structures in {@code pBinds} array")
    VkSparseImageMemoryBind.const.p("pBinds", "a pointer to an array of ##VkSparseImageMemoryBind structures")
}

val VkBindSparseInfo = struct(Module.VULKAN, "VkBindSparseInfo") {
    documentation =
        """
        Structure specifying a sparse binding operation.

        <h5>Valid Usage</h5>
        <ul>
            <li>If any element of {@code pWaitSemaphores} or {@code pSignalSemaphores} was created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE then the {@code pNext} chain <b>must</b> include a ##VkTimelineSemaphoreSubmitInfo structure</li>
            <li>If the {@code pNext} chain of this structure includes a ##VkTimelineSemaphoreSubmitInfo structure and any element of {@code pWaitSemaphores} was created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE then its {@code waitSemaphoreValueCount} member <b>must</b> equal {@code waitSemaphoreCount}</li>
            <li>If the {@code pNext} chain of this structure includes a ##VkTimelineSemaphoreSubmitInfo structure and any element of {@code pSignalSemaphores} was created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE then its {@code signalSemaphoreValueCount} member <b>must</b> equal {@code signalSemaphoreCount}</li>
            <li>For each element of {@code pSignalSemaphores} created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE the corresponding element of ##VkTimelineSemaphoreSubmitInfo{@code ::pSignalSemaphoreValues} <b>must</b> have a value greater than the current value of the semaphore when the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphores-signaling">semaphore signal operation</a> is executed</li>
            <li>For each element of {@code pWaitSemaphores} created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE the corresponding element of ##VkTimelineSemaphoreSubmitInfo{@code ::pWaitSemaphoreValues} <b>must</b> have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxTimelineSemaphoreValueDifference">{@code maxTimelineSemaphoreValueDifference}</a></li>
            <li>For each element of {@code pSignalSemaphores} created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE the corresponding element of ##VkTimelineSemaphoreSubmitInfo{@code ::pSignalSemaphoreValues} <b>must</b> have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxTimelineSemaphoreValueDifference">{@code maxTimelineSemaphoreValueDifference}</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_BIND_SPARSE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDeviceGroupBindSparseInfo, ##VkFrameBoundaryEXT, or ##VkTimelineSemaphoreSubmitInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>If {@code waitSemaphoreCount} is not 0, {@code pWaitSemaphores} <b>must</b> be a valid pointer to an array of {@code waitSemaphoreCount} valid {@code VkSemaphore} handles</li>
            <li>If {@code bufferBindCount} is not 0, {@code pBufferBinds} <b>must</b> be a valid pointer to an array of {@code bufferBindCount} valid ##VkSparseBufferMemoryBindInfo structures</li>
            <li>If {@code imageOpaqueBindCount} is not 0, {@code pImageOpaqueBinds} <b>must</b> be a valid pointer to an array of {@code imageOpaqueBindCount} valid ##VkSparseImageOpaqueMemoryBindInfo structures</li>
            <li>If {@code imageBindCount} is not 0, {@code pImageBinds} <b>must</b> be a valid pointer to an array of {@code imageBindCount} valid ##VkSparseImageMemoryBindInfo structures</li>
            <li>If {@code signalSemaphoreCount} is not 0, {@code pSignalSemaphores} <b>must</b> be a valid pointer to an array of {@code signalSemaphoreCount} valid {@code VkSemaphore} handles</li>
            <li>Both of the elements of {@code pSignalSemaphores}, and the elements of {@code pWaitSemaphores} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkSparseBufferMemoryBindInfo, ##VkSparseImageMemoryBindInfo, ##VkSparseImageOpaqueMemoryBindInfo, #QueueBindSparse()
        """

    Expression("#STRUCTURE_TYPE_BIND_SPARSE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDeviceGroupBindSparseInfo", "VkDeviceGroupBindSparseInfoKHR", "VkFrameBoundaryEXT", "VkTimelineSemaphoreSubmitInfo", "VkTimelineSemaphoreSubmitInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pWaitSemaphores", optional = true)..uint32_t("waitSemaphoreCount", "the number of semaphores upon which to wait before executing the sparse binding operations for the batch.")
    VkSemaphore.const.p("pWaitSemaphores", "a pointer to an array of semaphores upon which to wait on before the sparse binding operations for this batch begin execution. If semaphores to wait on are provided, they define a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-semaphores-waiting\">semaphore wait operation</a>.")
    AutoSize("pBufferBinds", optional = true)..uint32_t("bufferBindCount", "the number of sparse buffer bindings to perform in the batch.")
    VkSparseBufferMemoryBindInfo.const.p("pBufferBinds", "a pointer to an array of ##VkSparseBufferMemoryBindInfo structures.")
    AutoSize("pImageOpaqueBinds", optional = true)..uint32_t("imageOpaqueBindCount", "the number of opaque sparse image bindings to perform.")
    VkSparseImageOpaqueMemoryBindInfo.const.p("pImageOpaqueBinds", "a pointer to an array of ##VkSparseImageOpaqueMemoryBindInfo structures, indicating opaque sparse image bindings to perform.")
    AutoSize("pImageBinds", optional = true)..uint32_t("imageBindCount", "the number of sparse image bindings to perform.")
    VkSparseImageMemoryBindInfo.const.p("pImageBinds", "a pointer to an array of ##VkSparseImageMemoryBindInfo structures, indicating sparse image bindings to perform.")
    AutoSize("pSignalSemaphores", optional = true)..uint32_t("signalSemaphoreCount", "the number of semaphores to be signaled once the sparse binding operations specified by the structure have completed execution.")
    VkSemaphore.const.p("pSignalSemaphores", "a pointer to an array of semaphores which will be signaled when the sparse binding operations for this batch have completed execution. If semaphores to be signaled are provided, they define a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-semaphores-signaling\">semaphore signal operation</a>.")
}

val VkSparseImageFormatProperties = struct(Module.VULKAN, "VkSparseImageFormatProperties", mutable = false) {
    documentation =
        """
        Structure specifying sparse image format properties.

        <h5>See Also</h5>
        ##VkExtent3D, ##VkSparseImageFormatProperties2, ##VkSparseImageMemoryRequirements, #GetPhysicalDeviceSparseImageFormatProperties()
        """

    VkImageAspectFlags("aspectMask", "a bitmask {@code VkImageAspectFlagBits} specifying which aspects of the image the properties apply to.")
    VkExtent3D("imageGranularity", "the width, height, and depth of the sparse image block in texels or compressed texel blocks.")
    VkSparseImageFormatFlags("flags", "a bitmask of {@code VkSparseImageFormatFlagBits} specifying additional information about the sparse resource.")
}

val VkSparseImageMemoryRequirements = struct(Module.VULKAN, "VkSparseImageMemoryRequirements", mutable = false) {
    documentation =
        """
        Structure specifying sparse image memory requirements.

        <h5>See Also</h5>
        ##VkSparseImageFormatProperties, ##VkSparseImageMemoryRequirements2, #GetImageSparseMemoryRequirements()
        """

    VkSparseImageFormatProperties("formatProperties", "a ##VkSparseImageFormatProperties structure specifying properties of the image format.")
    uint32_t("imageMipTailFirstLod", "the first mip level at which image subresources are included in the mip tail region.")
    VkDeviceSize("imageMipTailSize", "the memory size (in bytes) of the mip tail region. If {@code formatProperties.flags} contains #SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT, this is the size of the whole mip tail, otherwise this is the size of the mip tail of a single array layer. This value is guaranteed to be a multiple of the sparse block size in bytes.")
    VkDeviceSize("imageMipTailOffset", "the opaque memory offset used with ##VkSparseImageOpaqueMemoryBindInfo to bind the mip tail region(s).")
    VkDeviceSize("imageMipTailStride", "the offset stride between each array-layer’s mip tail, if {@code formatProperties.flags} does not contain #SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT (otherwise the value is undefined).")
}

val VkFenceCreateInfo = struct(Module.VULKAN, "VkFenceCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created fence.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_FENCE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkExportFenceCreateInfo or ##VkExportFenceWin32HandleInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkFenceCreateFlagBits} values</li>
        </ul>

        <h5>See Also</h5>
        #CreateFence()
        """

    Expression("#STRUCTURE_TYPE_FENCE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkExportFenceCreateInfo", "VkExportFenceCreateInfoKHR", "VkExportFenceWin32HandleInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkFenceCreateFlags("flags", "a bitmask of {@code VkFenceCreateFlagBits} specifying the initial state and behavior of the fence.")
}

val VkSemaphoreCreateInfo = struct(Module.VULKAN, "VkSemaphoreCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created semaphore.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain includes a ##VkExportMetalObjectCreateInfoEXT structure, its {@code exportObjectType} member <b>must</b> be #EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkExportMetalObjectCreateInfoEXT, ##VkExportSemaphoreCreateInfo, ##VkExportSemaphoreWin32HandleInfoKHR, ##VkImportMetalSharedEventInfoEXT, ##VkQueryLowLatencySupportNV, or ##VkSemaphoreTypeCreateInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique, with the exception of structures of type ##VkExportMetalObjectCreateInfoEXT</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CreateSemaphore()
        """

    Expression("#STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkExportMetalObjectCreateInfoEXT", "VkExportSemaphoreCreateInfo", "VkExportSemaphoreCreateInfoKHR", "VkExportSemaphoreWin32HandleInfoKHR", "VkImportMetalSharedEventInfoEXT", "VkQueryLowLatencySupportNV", "VkSemaphoreTypeCreateInfo", "VkSemaphoreTypeCreateInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSemaphoreCreateFlags("flags", "reserved for future use.")
}

val VkEventCreateInfo = struct(Module.VULKAN, "VkEventCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created event.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain includes a ##VkExportMetalObjectCreateInfoEXT structure, its {@code exportObjectType} member <b>must</b> be #EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EVENT_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkExportMetalObjectCreateInfoEXT or ##VkImportMetalSharedEventInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique, with the exception of structures of type ##VkExportMetalObjectCreateInfoEXT</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkEventCreateFlagBits} values</li>
        </ul>

        <h5>See Also</h5>
        #CreateEvent()
        """

    Expression("#STRUCTURE_TYPE_EVENT_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkExportMetalObjectCreateInfoEXT", "VkImportMetalSharedEventInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkEventCreateFlags("flags", "a bitmask of {@code VkEventCreateFlagBits} defining additional creation parameters.")
}

val VkQueryPoolCreateInfo = struct(Module.VULKAN, "VkQueryPoolCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created query pool.

        <h5>Description</h5>
        {@code pipelineStatistics} is ignored if {@code queryType} is not #QUERY_TYPE_PIPELINE_STATISTICS.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineStatisticsQuery">{@code pipelineStatisticsQuery}</a> feature is not enabled, {@code queryType} <b>must</b> not be #QUERY_TYPE_PIPELINE_STATISTICS</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-meshShaderQueries">{@code meshShaderQueries}</a> feature is not enabled, {@code queryType} <b>must</b> not be #QUERY_TYPE_MESH_PRIMITIVES_GENERATED_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-meshShaderQueries">{@code meshShaderQueries}</a> feature is not enabled, and {@code queryType} is #QUERY_TYPE_PIPELINE_STATISTICS, {@code pipelineStatistics} <b>must</b> not contain #QUERY_PIPELINE_STATISTIC_TASK_SHADER_INVOCATIONS_BIT_EXT or #QUERY_PIPELINE_STATISTIC_MESH_SHADER_INVOCATIONS_BIT_EXT</li>
            <li>If {@code queryType} is #QUERY_TYPE_PIPELINE_STATISTICS, {@code pipelineStatistics} <b>must</b> be a valid combination of {@code VkQueryPipelineStatisticFlagBits} values</li>
            <li>If {@code queryType} is #QUERY_TYPE_PIPELINE_STATISTICS, {@code pipelineStatistics} <b>must</b> not be zero</li>
            <li>If {@code queryType} is #QUERY_TYPE_PERFORMANCE_QUERY_KHR, the {@code pNext} chain <b>must</b> include a ##VkQueryPoolPerformanceCreateInfoKHR structure</li>
            <li>{@code queryCount} <b>must</b> be greater than 0</li>
            <li>If {@code queryType} is #QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoProfileInfoKHR structure with {@code videoCodecOperation} specifying an encode operation</li>
            <li>If {@code queryType} is #QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR, then the {@code pNext} chain <b>must</b> include a ##VkQueryPoolVideoEncodeFeedbackCreateInfoKHR structure</li>
            <li>If {@code queryType} is #QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR, and the {@code pNext} chain includes a ##VkVideoProfileInfoKHR structure and a ##VkQueryPoolVideoEncodeFeedbackCreateInfoKHR structure, then ##VkQueryPoolVideoEncodeFeedbackCreateInfoKHR{@code ::encodeFeedbackFlags} <b>must</b> not contain any bits that are not set in ##VkVideoEncodeCapabilitiesKHR{@code ::supportedEncodeFeedbackFlags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-profiles">video profile</a> described by ##VkVideoProfileInfoKHR and its {@code pNext} chain</li>
            <li>If the {@code pNext} chain includes a ##VkVideoProfileInfoKHR structure and its {@code videoCodecOperation} member is #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-videoEncodeAV1">{@code videoEncodeAV1}</a> feature <b>must</b> be enabled</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkQueryPoolPerformanceCreateInfoKHR, ##VkQueryPoolPerformanceQueryCreateInfoINTEL, ##VkQueryPoolVideoEncodeFeedbackCreateInfoKHR, ##VkVideoDecodeAV1ProfileInfoKHR, ##VkVideoDecodeH264ProfileInfoKHR, ##VkVideoDecodeH265ProfileInfoKHR, ##VkVideoDecodeUsageInfoKHR, ##VkVideoEncodeAV1ProfileInfoKHR, ##VkVideoEncodeH264ProfileInfoKHR, ##VkVideoEncodeH265ProfileInfoKHR, ##VkVideoEncodeUsageInfoKHR, or ##VkVideoProfileInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code queryType} <b>must</b> be a valid {@code VkQueryType} value</li>
        </ul>

        <h5>See Also</h5>
        #CreateQueryPool()
        """

    Expression("#STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkQueryPoolCreateInfoINTEL", "VkQueryPoolPerformanceCreateInfoKHR", "VkQueryPoolPerformanceQueryCreateInfoINTEL", "VkQueryPoolVideoEncodeFeedbackCreateInfoKHR", "VkVideoDecodeAV1ProfileInfoKHR", "VkVideoDecodeH264ProfileInfoKHR", "VkVideoDecodeH265ProfileInfoKHR", "VkVideoDecodeUsageInfoKHR", "VkVideoEncodeAV1ProfileInfoKHR", "VkVideoEncodeH264ProfileInfoKHR", "VkVideoEncodeH265ProfileInfoKHR", "VkVideoEncodeUsageInfoKHR", "VkVideoProfileInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkQueryPoolCreateFlags("flags", "reserved for future use.")
    VkQueryType("queryType", "a {@code VkQueryType} value specifying the type of queries managed by the pool.")
    uint32_t("queryCount", "the number of queries managed by the pool.")
    VkQueryPipelineStatisticFlags("pipelineStatistics", "a bitmask of {@code VkQueryPipelineStatisticFlagBits} specifying which counters will be returned in queries on the new pool, as described below in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#queries-pipestats\">Pipeline Statistics Queries</a>.")
}

val VkBufferCreateInfo = struct(Module.VULKAN, "VkBufferCreateInfo") {
    documentation =
        """
        Structure specifying the parameters of a newly created buffer object.

        <h5>Description</h5>
        If the {@code pNext} chain includes a ##VkBufferUsageFlags2CreateInfo structure, ##VkBufferUsageFlags2CreateInfo{@code ::usage} from that structure is used instead of {@code usage} from this structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain does not include a ##VkBufferUsageFlags2CreateInfo structure, {@code usage} <b>must</b> be a valid combination of {@code VkBufferUsageFlagBits} values</li>
            <li>If the {@code pNext} chain does not include a ##VkBufferUsageFlags2CreateInfo structure, {@code usage} <b>must</b> not be 0</li>
            <li>{@code size} <b>must</b> be greater than 0</li>
            <li>If {@code sharingMode} is #SHARING_MODE_CONCURRENT, {@code pQueueFamilyIndices} <b>must</b> be a valid pointer to an array of {@code queueFamilyIndexCount} {@code uint32_t} values</li>
            <li>If {@code sharingMode} is #SHARING_MODE_CONCURRENT, {@code queueFamilyIndexCount} <b>must</b> be greater than 1</li>
            <li>If {@code sharingMode} is #SHARING_MODE_CONCURRENT, each element of {@code pQueueFamilyIndices} <b>must</b> be unique and <b>must</b> be less than {@code pQueueFamilyPropertyCount} returned by either #GetPhysicalDeviceQueueFamilyProperties2() or #GetPhysicalDeviceQueueFamilyProperties() for the {@code physicalDevice} that was used to create {@code device}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseBinding">{@code sparseBinding}</a> feature is not enabled, {@code flags} <b>must</b> not contain #BUFFER_CREATE_SPARSE_BINDING_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidencyBuffer">{@code sparseResidencyBuffer}</a> feature is not enabled, {@code flags} <b>must</b> not contain #BUFFER_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidencyAliased">{@code sparseResidencyAliased}</a> feature is not enabled, {@code flags} <b>must</b> not contain #BUFFER_CREATE_SPARSE_ALIASED_BIT</li>
            <li>If {@code flags} contains #BUFFER_CREATE_SPARSE_RESIDENCY_BIT or #BUFFER_CREATE_SPARSE_ALIASED_BIT, it <b>must</b> also contain #BUFFER_CREATE_SPARSE_BINDING_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkExternalMemoryBufferCreateInfo structure, its {@code handleTypes} member <b>must</b> only contain bits that are also in ##VkExternalBufferProperties{@code ::externalMemoryProperties.compatibleHandleTypes}, as returned by #GetPhysicalDeviceExternalBufferProperties() with {@code pExternalBufferInfo→handleType} equal to any one of the handle types specified in ##VkExternalMemoryBufferCreateInfo{@code ::handleTypes}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-protectedMemory">{@code protectedMemory}</a> feature is not enabled, {@code flags} <b>must</b> not contain #BUFFER_CREATE_PROTECTED_BIT</li>
            <li>If any of the bits #BUFFER_CREATE_SPARSE_BINDING_BIT, #BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or #BUFFER_CREATE_SPARSE_ALIASED_BIT are set, #BUFFER_CREATE_PROTECTED_BIT <b>must</b> not also be set</li>
            <li>If the {@code pNext} chain includes a ##VkDedicatedAllocationBufferCreateInfoNV structure, and the {@code dedicatedAllocation} member of the chained structure is #TRUE, then {@code flags} <b>must</b> not include #BUFFER_CREATE_SPARSE_BINDING_BIT, #BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or #BUFFER_CREATE_SPARSE_ALIASED_BIT</li>
            <li>If ##VkBufferDeviceAddressCreateInfoEXT{@code ::deviceAddress} is not zero, {@code flags} <b>must</b> include #BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT</li>
            <li>If ##VkBufferOpaqueCaptureAddressCreateInfo{@code ::opaqueCaptureAddress} is not zero, {@code flags} <b>must</b> include #BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT</li>
            <li>If {@code flags} includes #BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-bufferDeviceAddressCaptureReplayEXT">{@code bufferDeviceAddressCaptureReplay}</a> feature <b>must</b> be enabled</li>
            <li>If {@code usage} includes #BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR or #BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR, and {@code flags} does not include #BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoProfileListInfoKHR structure with {@code profileCount} greater than 0 and {@code pProfiles} including at least one ##VkVideoProfileInfoKHR structure with a {@code videoCodecOperation} member specifying a decode operation</li>
            <li>If {@code usage} includes #BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR or #BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR, and {@code flags} does not include #BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoProfileListInfoKHR structure with {@code profileCount} greater than 0 and {@code pProfiles} including at least one ##VkVideoProfileInfoKHR structure with a {@code videoCodecOperation} member specifying an encode operation</li>
            <li>If {@code flags} includes #BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-videoMaintenance1">{@code videoMaintenance1}</a> <b>must</b> be enabled</li>
            <li>If the {@code pNext} chain includes a ##VkVideoProfileListInfoKHR structure and for any element of its {@code pProfiles} member {@code videoCodecOperation} is #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-videoEncodeAV1">{@code videoEncodeAV1}</a> feature <b>must</b> be enabled</li>
            <li>{@code size} <b>must</b> be less than or equal to ##VkPhysicalDeviceMaintenance4Properties{@code ::maxBufferSize}</li>
            <li>If {@code usage} includes #BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT, creating this {@code VkBuffer} <b>must</b> not cause the total required space for all currently valid buffers using this flag on the device to exceed ##VkPhysicalDeviceDescriptorBufferPropertiesEXT{@code ::samplerDescriptorBufferAddressSpaceSize} or ##VkPhysicalDeviceDescriptorBufferPropertiesEXT{@code ::descriptorBufferAddressSpaceSize}</li>
            <li>If {@code usage} includes #BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT, creating this {@code VkBuffer} <b>must</b> not cause the total required space for all currently valid buffers using this flag on the device to exceed ##VkPhysicalDeviceDescriptorBufferPropertiesEXT{@code ::resourceDescriptorBufferAddressSpaceSize} or ##VkPhysicalDeviceDescriptorBufferPropertiesEXT{@code ::descriptorBufferAddressSpaceSize}</li>
            <li>If {@code flags} includes #BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBufferCaptureReplay">{@code descriptorBufferCaptureReplay}</a> feature <b>must</b> be enabled</li>
            <li>If the {@code pNext} chain includes a ##VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, {@code flags} <b>must</b> contain #BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT</li>
            <li>If {@code usage} includes #BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBufferPushDescriptors">{@code descriptorBufferPushDescriptors}</a> feature <b>must</b> be enabled</li>
            <li>If {@code usage} includes #BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-bufferlessPushDescriptors">##VkPhysicalDeviceDescriptorBufferPropertiesEXT{@code ::bufferlessPushDescriptors}</a> <b>must</b> be #FALSE</li>
            <li>If {@code usage} includes #BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, {@code usage} <b>must</b> contain at least one of #BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT or #BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT</li>
            <li>
                If {@code flags} includes #BUFFER_CREATE_PROTECTED_BIT, then {@code usage} <b>must</b> not contain any of the following bits
                <ul>
                    <li>#BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT</li>
                    <li>#BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT</li>
                    <li>#BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT</li>
                    <li>#BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR</li>
                    <li>#BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR</li>
                    <li>#BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR</li>
                    <li>#BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT</li>
                    <li>#BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT</li>
                    <li>#BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT</li>
                    <li>#BUFFER_USAGE_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT</li>
                    <li>#BUFFER_USAGE_MICROMAP_STORAGE_BIT_EXT</li>
                </ul>
            </li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_BUFFER_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkBufferDeviceAddressCreateInfoEXT, ##VkBufferOpaqueCaptureAddressCreateInfo, ##VkBufferUsageFlags2CreateInfo, ##VkDedicatedAllocationBufferCreateInfoNV, ##VkExternalMemoryBufferCreateInfo, ##VkOpaqueCaptureDescriptorDataCreateInfoEXT, or ##VkVideoProfileListInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkBufferCreateFlagBits} values</li>
            <li>{@code sharingMode} <b>must</b> be a valid {@code VkSharingMode} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkDeviceBufferMemoryRequirements, #CreateBuffer()
        """

    Expression("#STRUCTURE_TYPE_BUFFER_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkBufferDeviceAddressCreateInfoEXT", "VkBufferOpaqueCaptureAddressCreateInfo", "VkBufferOpaqueCaptureAddressCreateInfoKHR", "VkBufferUsageFlags2CreateInfo", "VkBufferUsageFlags2CreateInfoKHR", "VkDedicatedAllocationBufferCreateInfoNV", "VkExternalMemoryBufferCreateInfo", "VkExternalMemoryBufferCreateInfoKHR", "VkOpaqueCaptureDescriptorDataCreateInfoEXT", "VkVideoProfileListInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBufferCreateFlags("flags", "a bitmask of {@code VkBufferCreateFlagBits} specifying additional parameters of the buffer.")
    VkDeviceSize("size", "the size in bytes of the buffer to be created.")
    VkBufferUsageFlags("usage", "a bitmask of {@code VkBufferUsageFlagBits} specifying allowed usages of the buffer.")
    VkSharingMode("sharingMode", "a {@code VkSharingMode} value specifying the sharing mode of the buffer when it will be accessed by multiple queue families.")
    AutoSize("pQueueFamilyIndices", optional = true)..uint32_t("queueFamilyIndexCount", "the number of entries in the {@code pQueueFamilyIndices} array.")
    nullable..uint32_t.const.p("pQueueFamilyIndices", "a pointer to an array of queue families that will access this buffer. It is ignored if {@code sharingMode} is not #SHARING_MODE_CONCURRENT.")
}

val VkBufferViewCreateInfo = struct(Module.VULKAN, "VkBufferViewCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created buffer view.

        <h5>Description</h5>
        The buffer view has a <em>buffer view usage</em> identifying which descriptor types can be created from it. This usage <b>can</b> be defined by including the ##VkBufferUsageFlags2CreateInfo structure in the {@code pNext} chain, and specifying the {@code usage} value there. If this structure is not included, it is equal to the ##VkBufferCreateInfo{@code ::usage} value used to create {@code buffer}.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code offset} <b>must</b> be less than the size of {@code buffer}</li>
            <li>If {@code range} is not equal to #WHOLE_SIZE, {@code range} <b>must</b> be greater than 0</li>
            <li>If {@code range} is not equal to #WHOLE_SIZE, {@code range} <b>must</b> be an integer multiple of the texel block size of {@code format}</li>
            <li>If {@code range} is not equal to #WHOLE_SIZE, the number of texel buffer elements given by <code>(⌊range / (texel block size)⌋ × (texels per block))</code> where texel block size and texels per block are as defined in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-compatibility">Compatible Formats</a> table for {@code format}, <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxTexelBufferElements}</li>
            <li>If {@code range} is not equal to #WHOLE_SIZE, the sum of {@code offset} and {@code range} <b>must</b> be less than or equal to the size of {@code buffer}</li>
            <li>If {@code range} is equal to #WHOLE_SIZE, the number of texel buffer elements given by <code>(⌊(size - offset) / (texel block size)⌋ × (texels per block))</code> where size is the size of {@code buffer}, and texel block size and texels per block are as defined in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-compatibility">Compatible Formats</a> table for {@code format}, <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxTexelBufferElements}</li>
            <li>{@code buffer} <b>must</b> have been created with a {@code usage} value containing at least one of #BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT or #BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-buffer-views-usage">buffer view usage</a> contains #BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-buffer-view-format-features">format features</a> of {@code format} <b>must</b> contain #FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-buffer-views-usage">buffer view usage</a> contains #BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-buffer-view-format-features">format features</a> of {@code format} <b>must</b> contain #FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT</li>
            <li>If {@code buffer} is non-sparse then it <b>must</b> be bound completely and contiguously to a single {@code VkDeviceMemory} object</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-texelBufferAlignment">{@code texelBufferAlignment}</a> feature is not enabled, {@code offset} <b>must</b> be a multiple of ##VkPhysicalDeviceLimits{@code ::minTexelBufferOffsetAlignment}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-texelBufferAlignment">{@code texelBufferAlignment}</a> feature is enabled and if {@code buffer} was created with {@code usage} containing #BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, {@code offset} <b>must</b> be a multiple of the lesser of ##VkPhysicalDeviceTexelBufferAlignmentProperties{@code ::storageTexelBufferOffsetAlignmentBytes} or, if ##VkPhysicalDeviceTexelBufferAlignmentProperties{@code ::storageTexelBufferOffsetSingleTexelAlignment} is #TRUE, the size of a texel of the requested {@code format}. If the size of a texel is a multiple of three bytes, then the size of a single component of {@code format} is used instead</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-texelBufferAlignment">{@code texelBufferAlignment}</a> feature is enabled and if {@code buffer} was created with {@code usage} containing #BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, {@code offset} <b>must</b> be a multiple of the lesser of ##VkPhysicalDeviceTexelBufferAlignmentProperties{@code ::uniformTexelBufferOffsetAlignmentBytes} or, if ##VkPhysicalDeviceTexelBufferAlignmentProperties{@code ::uniformTexelBufferOffsetSingleTexelAlignment} is #TRUE, the size of a texel of the requested {@code format}. If the size of a texel is a multiple of three bytes, then the size of a single component of {@code format} is used instead</li>
            <li>If the {@code pNext} chain includes a ##VkExportMetalObjectCreateInfoEXT structure, its {@code exportObjectType} member <b>must</b> be #EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT</li>
            <li>If the {@code pNext} chain includes a ##VkBufferUsageFlags2CreateInfo, its {@code usage} <b>must</b> not contain any other bit than #BUFFER_USAGE_2_UNIFORM_TEXEL_BUFFER_BIT or #BUFFER_USAGE_2_STORAGE_TEXEL_BUFFER_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkBufferUsageFlags2CreateInfo, its {@code usage} <b>must</b> be a subset of the ##VkBufferCreateInfo{@code ::usage} specified or ##VkBufferUsageFlags2CreateInfo{@code ::usage} from ##VkBufferCreateInfo{@code ::pNext} when creating {@code buffer}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkBufferUsageFlags2CreateInfo or ##VkExportMetalObjectCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique, with the exception of structures of type ##VkExportMetalObjectCreateInfoEXT</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>{@code format} <b>must</b> be a valid {@code VkFormat} value</li>
        </ul>

        <h5>See Also</h5>
        #CreateBufferView()
        """

    Expression("#STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkBufferUsageFlags2CreateInfo", "VkBufferUsageFlags2CreateInfoKHR", "VkExportMetalObjectCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBufferViewCreateFlags("flags", "reserved for future use.")
    VkBuffer("buffer", "a {@code VkBuffer} on which the view will be created.")
    VkFormat("format", "a {@code VkFormat} describing the format of the data elements in the buffer.")
    VkDeviceSize("offset", "an offset in bytes from the base address of the buffer. Accesses to the buffer view from shaders use addressing that is relative to this starting offset.")
    VkDeviceSize("range", "a size in bytes of the buffer view. If {@code range} is equal to #WHOLE_SIZE, the range from {@code offset} to the end of the buffer is used. If #WHOLE_SIZE is used and the remaining size of the buffer is not a multiple of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#texel-block-size\">texel block size</a> of {@code format}, the nearest smaller multiple is used.")
}

val VkImageCreateInfo = struct(Module.VULKAN, "VkImageCreateInfo") {
    documentation =
        """
        Structure specifying the parameters of a newly created image object.

        <h5>Description</h5>
        Images created with {@code tiling} equal to #IMAGE_TILING_LINEAR have further restrictions on their limits and capabilities compared to images created with {@code tiling} equal to #IMAGE_TILING_OPTIMAL. Creation of images with tiling #IMAGE_TILING_LINEAR <b>may</b> not be supported unless other parameters meet all of the constraints:

        <ul>
            <li>{@code imageType} is #IMAGE_TYPE_2D</li>
            <li>{@code format} is not a depth/stencil format</li>
            <li>{@code mipLevels} is 1</li>
            <li>{@code arrayLayers} is 1</li>
            <li>{@code samples} is #SAMPLE_COUNT_1_BIT</li>
            <li>{@code usage} only includes #IMAGE_USAGE_TRANSFER_SRC_BIT and/or #IMAGE_USAGE_TRANSFER_DST_BIT</li>
        </ul>

        Images created with one of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">formats that require a sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a>, have further restrictions on their limits and capabilities compared to images created with other formats. Creation of images with a format requiring <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">Y′C<sub>B</sub>C<sub>R</sub> conversion</a> <b>may</b> not be supported unless other parameters meet all of the constraints:

        <ul>
            <li>{@code imageType} is #IMAGE_TYPE_2D</li>
            <li>{@code mipLevels} is 1</li>
            <li>{@code arrayLayers} is 1, unless the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-ycbcrImageArrays">{@code ycbcrImageArrays}</a> feature is enabled, or otherwise indicated by ##VkImageFormatProperties{@code ::maxArrayLayers}, as returned by #GetPhysicalDeviceImageFormatProperties()</li>
            <li>{@code samples} is #SAMPLE_COUNT_1_BIT</li>
        </ul>

        Implementations <b>may</b> support additional limits and capabilities beyond those listed above.

        To determine the set of valid {@code usage} bits for a given format, call #GetPhysicalDeviceFormatProperties().

        If the size of the resultant image would exceed {@code maxResourceSize}, then #CreateImage() <b>must</b> fail and return #ERROR_OUT_OF_DEVICE_MEMORY. This failure <b>may</b> occur even when all image creation parameters satisfy their valid usage requirements.

        If the implementation reports #TRUE in ##VkPhysicalDeviceHostImageCopyProperties{@code ::identicalMemoryTypeRequirements}, usage of #IMAGE_USAGE_HOST_TRANSFER_BIT <b>must</b> not affect the memory type requirements of the image as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#sparsememory-memory-requirements">Sparse Resource Memory Requirements</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-association">Resource Memory Association</a>.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        For images created without #IMAGE_CREATE_EXTENDED_USAGE_BIT a {@code usage} bit is valid if it is supported for the format the image is created with.

        For images created with #IMAGE_CREATE_EXTENDED_USAGE_BIT a {@code usage} bit is valid if it is supported for at least one of the formats a {@code VkImageView} created from the image <b>can</b> have (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-views">Image Views</a> for more detail).
        </div>

        <h5>Image Creation Limits</h5>
        Valid values for some image creation parameters are limited by a numerical upper bound or by inclusion in a bitset. For example, ##VkImageCreateInfo{@code ::arrayLayers} is limited by {@code imageCreateMaxArrayLayers}, defined below; and ##VkImageCreateInfo{@code ::samples} is limited by {@code imageCreateSampleCounts}, also defined below.

        Several limiting values are defined below, as well as assisting values from which the limiting values are derived. The limiting values are referenced by the relevant valid usage statements of ##VkImageCreateInfo.

        <ul>
            <li>
                Let {@code uint64_t imageCreateDrmFormatModifiers[]} be the set of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#glossary-drm-format-modifier">Linux DRM format modifiers</a> that the resultant image <b>may</b> have.
                <ul>
                    <li>If {@code tiling} is not #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then {@code imageCreateDrmFormatModifiers} is empty.</li>
                    <li>If ##VkImageCreateInfo{@code ::pNext} contains ##VkImageDrmFormatModifierExplicitCreateInfoEXT, then {@code imageCreateDrmFormatModifiers} contains exactly one modifier, ##VkImageDrmFormatModifierExplicitCreateInfoEXT{@code ::drmFormatModifier}.</li>
                    <li>If ##VkImageCreateInfo{@code ::pNext} contains ##VkImageDrmFormatModifierListCreateInfoEXT, then {@code imageCreateDrmFormatModifiers} contains the entire array ##VkImageDrmFormatModifierListCreateInfoEXT{@code ::pDrmFormatModifiers}.</li>
                </ul>
            </li>
            <li>
                Let {@code VkBool32 imageCreateMaybeLinear} indicate if the resultant image may be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#glossary-linear-resource">linear</a>.
                <ul>
                    <li>If {@code tiling} is #IMAGE_TILING_LINEAR, then {@code imageCreateMaybeLinear} is #TRUE.</li>
                    <li>If {@code tiling} is #IMAGE_TILING_OPTIMAL, then {@code imageCreateMaybeLinear} is #FALSE.</li>
                    <li>If {@code tiling} is #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then {@code imageCreateMaybeLinear} is #TRUE if and only if {@code imageCreateDrmFormatModifiers} contains {@code DRM_FORMAT_MOD_LINEAR}.</li>
                </ul>
            </li>
            <li>
                Let {@code VkFormatFeatureFlags imageCreateFormatFeatures} be the set of valid <em>format features</em> available during image creation.
                <ul>
                    <li>If {@code tiling} is #IMAGE_TILING_LINEAR, then {@code imageCreateFormatFeatures} is the value of ##VkFormatProperties{@code ::linearTilingFeatures} found by calling #GetPhysicalDeviceFormatProperties() with parameter {@code format} equal to ##VkImageCreateInfo{@code ::format}.</li>
                    <li>If {@code tiling} is #IMAGE_TILING_OPTIMAL, and if the {@code pNext} chain includes no ##VkExternalFormatANDROID structure with non-zero {@code externalFormat}, then {@code imageCreateFormatFeatures} is the value of ##VkFormatProperties{@code ::optimalTilingFeatures} found by calling #GetPhysicalDeviceFormatProperties() with parameter {@code format} equal to ##VkImageCreateInfo{@code ::format}.</li>
                    <li>If {@code tiling} is #IMAGE_TILING_OPTIMAL, and if the {@code pNext} chain includes a ##VkExternalFormatANDROID structure with non-zero {@code externalFormat}, then {@code imageCreateFormatFeatures} is the value of ##VkAndroidHardwareBufferFormatPropertiesANDROID{@code ::formatFeatures} obtained by #GetAndroidHardwareBufferPropertiesANDROID() with a matching {@code externalFormat} value.</li>
                    <li>If {@code tiling} is #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then the value of {@code imageCreateFormatFeatures} is found by calling #GetPhysicalDeviceFormatProperties2() with ##VkImageFormatProperties{@code ::format} equal to ##VkImageCreateInfo{@code ::format} and with ##VkDrmFormatModifierPropertiesListEXT chained into ##VkFormatProperties2; by collecting all members of the returned array ##VkDrmFormatModifierPropertiesListEXT{@code ::pDrmFormatModifierProperties} whose {@code drmFormatModifier} belongs to {@code imageCreateDrmFormatModifiers}; and by taking the bitwise intersection, over the collected array members, of {@code drmFormatModifierTilingFeatures}. (The resultant {@code imageCreateFormatFeatures} <b>may</b> be empty).</li>
                </ul>
            </li>
            <li>
                Let {@code VkImageFormatProperties2 imageCreateImageFormatPropertiesList[]} be defined as follows.
                <ul>
                    <li>
                        If ##VkImageCreateInfo{@code ::pNext} contains no ##VkExternalFormatANDROID structure with non-zero {@code externalFormat}, then {@code imageCreateImageFormatPropertiesList} is the list of structures obtained by calling #GetPhysicalDeviceImageFormatProperties2(), possibly multiple times, as follows:
                        <ul>
                            <li>The parameters ##VkPhysicalDeviceImageFormatInfo2{@code ::format}, {@code imageType}, {@code tiling}, {@code usage}, and {@code flags} <b>must</b> be equal to those in ##VkImageCreateInfo.</li>
                            <li>If ##VkImageCreateInfo{@code ::pNext} contains a ##VkExternalMemoryImageCreateInfo structure whose {@code handleTypes} is not 0, then ##VkPhysicalDeviceImageFormatInfo2{@code ::pNext} <b>must</b> contain a ##VkPhysicalDeviceExternalImageFormatInfo structure whose {@code handleType} is not 0; and #GetPhysicalDeviceImageFormatProperties2() <b>must</b> be called for each handle type in ##VkExternalMemoryImageCreateInfo{@code ::handleTypes}, successively setting ##VkPhysicalDeviceExternalImageFormatInfo{@code ::handleType} on each call.</li>
                            <li>If ##VkImageCreateInfo{@code ::pNext} contains no ##VkExternalMemoryImageCreateInfo structure, or contains a structure whose {@code handleTypes} is 0, then ##VkPhysicalDeviceImageFormatInfo2{@code ::pNext} <b>must</b> either contain no ##VkPhysicalDeviceExternalImageFormatInfo structure, or contain a structure whose {@code handleType} is 0.</li>
                            <li>If ##VkImageCreateInfo{@code ::pNext} contains a ##VkVideoProfileListInfoKHR structure then ##VkPhysicalDeviceImageFormatInfo2{@code ::pNext} <b>must</b> also contain the same ##VkVideoProfileListInfoKHR structure on each call.</li>
                            <li>
                                If {@code tiling} is #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then:
                                <ul>
                                    <li>##VkPhysicalDeviceImageFormatInfo2{@code ::pNext} <b>must</b> contain a ##VkPhysicalDeviceImageDrmFormatModifierInfoEXT structure where {@code sharingMode} is equal to ##VkImageCreateInfo{@code ::sharingMode};</li>
                                    <li>if {@code sharingMode} is #SHARING_MODE_CONCURRENT, then {@code queueFamilyIndexCount} and {@code pQueueFamilyIndices} <b>must</b> be equal to those in ##VkImageCreateInfo;</li>
                                    <li>if {@code flags} contains #IMAGE_CREATE_MUTABLE_FORMAT_BIT, then the ##VkImageFormatListCreateInfo structure included in the {@code pNext} chain of ##VkPhysicalDeviceImageFormatInfo2 <b>must</b> be equivalent to the one included in the {@code pNext} chain of ##VkImageCreateInfo;</li>
                                    <li>if ##VkImageCreateInfo{@code ::pNext} contains a ##VkImageCompressionControlEXT structure, then the ##VkPhysicalDeviceImageFormatInfo2{@code ::pNext} chain <b>must</b> contain an equivalent structure;</li>
                                    <li>#GetPhysicalDeviceImageFormatProperties2() <b>must</b> be called for each modifier in {@code imageCreateDrmFormatModifiers}, successively setting ##VkPhysicalDeviceImageDrmFormatModifierInfoEXT{@code ::drmFormatModifier} on each call.</li>
                                </ul>
                            </li>
                            <li>If {@code tiling} is not #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then ##VkPhysicalDeviceImageFormatInfo2{@code ::pNext} <b>must</b> contain no ##VkPhysicalDeviceImageDrmFormatModifierInfoEXT structure.</li>
                            <li>If any call to #GetPhysicalDeviceImageFormatProperties2() returns an error, then {@code imageCreateImageFormatPropertiesList} is defined to be the empty list.</li>
                        </ul>
                    </li>
                    <li>
                        If ##VkImageCreateInfo{@code ::pNext} contains a ##VkExternalFormatANDROID structure with non-zero {@code externalFormat}, then {@code imageCreateImageFormatPropertiesList} contains a single element where:
                        <ul>
                            <li>##VkImageFormatProperties{@code ::maxMipLevels} is <code>⌊log<sub>2</sub>(max(extent.width, extent.height, extent.depth))⌋ + 1</code>.</li>
                            <li>##VkImageFormatProperties{@code ::maxArrayLayers} is ##VkPhysicalDeviceLimits{@code ::maxImageArrayLayers}.</li>
                            <li>Each component of ##VkImageFormatProperties{@code ::maxExtent} is ##VkPhysicalDeviceLimits{@code ::maxImageDimension2D}.</li>
                            <li>##VkImageFormatProperties{@code ::sampleCounts} contains exactly #SAMPLE_COUNT_1_BIT.</li>
                        </ul>
                    </li>
                </ul>
            </li>
            <li>Let {@code uint32_t imageCreateMaxMipLevels} be the minimum value of ##VkImageFormatProperties{@code ::maxMipLevels} in {@code imageCreateImageFormatPropertiesList}. The value is undefined if {@code imageCreateImageFormatPropertiesList} is empty.</li>
            <li>Let {@code uint32_t imageCreateMaxArrayLayers} be the minimum value of ##VkImageFormatProperties{@code ::maxArrayLayers} in {@code imageCreateImageFormatPropertiesList}. The value is undefined if {@code imageCreateImageFormatPropertiesList} is empty.</li>
            <li>Let {@code VkExtent3D imageCreateMaxExtent} be the component-wise minimum over all ##VkImageFormatProperties{@code ::maxExtent} values in {@code imageCreateImageFormatPropertiesList}. The value is undefined if {@code imageCreateImageFormatPropertiesList} is empty.</li>
            <li>Let {@code VkSampleCountFlags imageCreateSampleCounts} be the intersection of each ##VkImageFormatProperties{@code ::sampleCounts} in {@code imageCreateImageFormatPropertiesList}. The value is undefined if {@code imageCreateImageFormatPropertiesList} is empty.</li>
            <li>
                Let {@code VkVideoFormatPropertiesKHR videoFormatProperties[]} be defined as follows.
                <ul>
                    <li>If ##VkImageCreateInfo{@code ::pNext} contains a ##VkVideoProfileListInfoKHR structure, then {@code videoFormatProperties} is the list of structures obtained by calling #GetPhysicalDeviceVideoFormatPropertiesKHR() with ##VkPhysicalDeviceVideoFormatInfoKHR{@code ::imageUsage} equal to the {@code usage} member of ##VkImageCreateInfo and ##VkPhysicalDeviceVideoFormatInfoKHR{@code ::pNext} containing the same ##VkVideoProfileListInfoKHR structure chained to ##VkImageCreateInfo.</li>
                    <li>If ##VkImageCreateInfo{@code ::pNext} contains no ##VkVideoProfileListInfoKHR structure, then {@code videoFormatProperties} is an empty list.</li>
                </ul>
            </li>
            <li>
                Let {@code VkBool32 supportedVideoFormat} indicate if the image parameters are supported by the specified video profiles.
                <ul>
                    <li>
                        {@code supportedVideoFormat} is #TRUE if there exists an element in the {@code videoFormatProperties} list for which all of the following conditions are true:
                        <ul>
                            <li>##VkImageCreateInfo{@code ::format} equals ##VkVideoFormatPropertiesKHR{@code ::format}.</li>
                            <li>##VkImageCreateInfo{@code ::flags} only contains #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and/or bits also set in ##VkVideoFormatPropertiesKHR{@code ::imageCreateFlags}.</li>
                            <li>##VkImageCreateInfo{@code ::imageType} equals ##VkVideoFormatPropertiesKHR{@code ::imageType}.</li>
                            <li>##VkImageCreateInfo{@code ::tiling} equals ##VkVideoFormatPropertiesKHR{@code ::imageTiling}.</li>
                            <li>##VkImageCreateInfo{@code ::usage} only contains bits also set in ##VkVideoFormatPropertiesKHR{@code ::imageUsageFlags}, or ##VkImageCreateInfo{@code ::flags} includes #IMAGE_CREATE_EXTENDED_USAGE_BIT.</li>
                        </ul>
                    </li>
                    <li>Otherwise {@code supportedVideoFormat} is #FALSE.</li>
                </ul>
            </li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>Each of the following values (as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>) <b>must</b> not be undefined : {@code imageCreateMaxMipLevels}, {@code imageCreateMaxArrayLayers}, {@code imageCreateMaxExtent}, and {@code imageCreateSampleCounts}</li>
            <li>If {@code sharingMode} is #SHARING_MODE_CONCURRENT, {@code pQueueFamilyIndices} <b>must</b> be a valid pointer to an array of {@code queueFamilyIndexCount} {@code uint32_t} values</li>
            <li>If {@code sharingMode} is #SHARING_MODE_CONCURRENT, {@code queueFamilyIndexCount} <b>must</b> be greater than 1</li>
            <li>If {@code sharingMode} is #SHARING_MODE_CONCURRENT, each element of {@code pQueueFamilyIndices} <b>must</b> be unique and <b>must</b> be less than {@code pQueueFamilyPropertyCount} returned by either #GetPhysicalDeviceQueueFamilyProperties() or #GetPhysicalDeviceQueueFamilyProperties2() for the {@code physicalDevice} that was used to create {@code device}</li>
            <li>If the {@code pNext} chain includes a ##VkExternalFormatANDROID structure, and its {@code externalFormat} member is non-zero the {@code format} <b>must</b> be #FORMAT_UNDEFINED</li>
            <li>If the {@code pNext} chain does not include a ##VkExternalFormatANDROID structure, or does and its {@code externalFormat} member is 0, the {@code format} <b>must</b> not be #FORMAT_UNDEFINED</li>
            <li>{@code extent.width} <b>must</b> be greater than 0</li>
            <li>{@code extent.height} <b>must</b> be greater than 0</li>
            <li>{@code extent.depth} <b>must</b> be greater than 0</li>
            <li>{@code mipLevels} <b>must</b> be greater than 0</li>
            <li>{@code arrayLayers} <b>must</b> be greater than 0</li>
            <li>If {@code flags} contains #IMAGE_CREATE_CUBE_COMPATIBLE_BIT, {@code imageType} <b>must</b> be #IMAGE_TYPE_2D</li>
            <li>If {@code flags} contains #IMAGE_CREATE_CUBE_COMPATIBLE_BIT, {@code extent.width} and {@code extent.height} <b>must</b> be equal</li>
            <li>If {@code flags} contains #IMAGE_CREATE_CUBE_COMPATIBLE_BIT, {@code arrayLayers} <b>must</b> be greater than or equal to 6</li>
            <li>If {@code flags} contains #IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, {@code imageType} <b>must</b> be #IMAGE_TYPE_2D</li>
            <li>If {@code flags} contains #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, {@code imageType} <b>must</b> be #IMAGE_TYPE_3D</li>
            <li>If {@code flags} contains #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, {@code flags} <b>must</b> not include #IMAGE_CREATE_SPARSE_ALIASED_BIT, #IMAGE_CREATE_SPARSE_BINDING_BIT, or #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If {@code flags} contains #IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT, {@code imageType} <b>must</b> be #IMAGE_TYPE_3D</li>
            <li>If {@code flags} contains #IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT, {@code flags} <b>must</b> not include #IMAGE_CREATE_SPARSE_ALIASED_BIT, #IMAGE_CREATE_SPARSE_BINDING_BIT, or #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>{@code extent.width} <b>must</b> be less than or equal to {@code imageCreateMaxExtent.width} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>)</li>
            <li>{@code extent.height} <b>must</b> be less than or equal to {@code imageCreateMaxExtent.height} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>)</li>
            <li>{@code extent.depth} <b>must</b> be less than or equal to {@code imageCreateMaxExtent.depth} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>)</li>
            <li>If {@code imageType} is #IMAGE_TYPE_1D, both {@code extent.height} and {@code extent.depth} <b>must</b> be 1</li>
            <li>If {@code imageType} is #IMAGE_TYPE_2D, {@code extent.depth} <b>must</b> be 1</li>
            <li>{@code mipLevels} <b>must</b> be less than or equal to the number of levels in the complete mipmap chain based on <code>extent.width</code>, <code>extent.height</code>, and <code>extent.depth</code></li>
            <li>{@code mipLevels} <b>must</b> be less than or equal to {@code imageCreateMaxMipLevels} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>)</li>
            <li>{@code arrayLayers} <b>must</b> be less than or equal to {@code imageCreateMaxArrayLayers} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>)</li>
            <li>If {@code imageType} is #IMAGE_TYPE_3D, {@code arrayLayers} <b>must</b> be 1</li>
            <li>If {@code samples} is not #SAMPLE_COUNT_1_BIT, then {@code imageType} <b>must</b> be #IMAGE_TYPE_2D, {@code flags} <b>must</b> not contain #IMAGE_CREATE_CUBE_COMPATIBLE_BIT, {@code mipLevels} <b>must</b> be equal to 1, and {@code imageCreateMaybeLinear} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>) <b>must</b> be #FALSE,</li>
            <li>If {@code samples} is not #SAMPLE_COUNT_1_BIT, {@code usage} <b>must</b> not contain #IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT</li>
            <li>If {@code usage} includes #IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, then bits other than #IMAGE_USAGE_COLOR_ATTACHMENT_BIT, #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and #IMAGE_USAGE_INPUT_ATTACHMENT_BIT <b>must</b> not be set</li>
            <li>If {@code usage} includes #IMAGE_USAGE_COLOR_ATTACHMENT_BIT, #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, #IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, or #IMAGE_USAGE_INPUT_ATTACHMENT_BIT, {@code extent.width} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxFramebufferWidth}</li>
            <li>If {@code usage} includes #IMAGE_USAGE_COLOR_ATTACHMENT_BIT, #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, #IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, or #IMAGE_USAGE_INPUT_ATTACHMENT_BIT, {@code extent.height} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxFramebufferHeight}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMapOffset">{@code fragmentDensityMapOffset}</a> feature is not enabled and {@code usage} includes #IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, {@code extent.width} <b>must</b> be less than or equal to <code>ceil(maxFramebufferWidth / minFragmentDensityTexelSize<sub>width</sub>)</code></li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMapOffset">{@code fragmentDensityMapOffset}</a> feature is not enabled and {@code usage} includes #IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, {@code extent.height} <b>must</b> be less than or equal to <code>ceil(maxFramebufferHeight / minFragmentDensityTexelSize<sub>height</sub>)</code></li>
            <li>If {@code usage} includes #IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, {@code usage} <b>must</b> also contain at least one of #IMAGE_USAGE_COLOR_ATTACHMENT_BIT, #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, or #IMAGE_USAGE_INPUT_ATTACHMENT_BIT</li>
            <li>{@code samples} <b>must</b> be a valid {@code VkSampleCountFlagBits} value that is set in {@code imageCreateSampleCounts} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>)</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderStorageImageMultisample">{@code shaderStorageImageMultisample}</a> feature is not enabled, and {@code usage} contains #IMAGE_USAGE_STORAGE_BIT, {@code samples} <b>must</b> be #SAMPLE_COUNT_1_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseBinding">{@code sparseBinding}</a> feature is not enabled, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_BINDING_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidencyAliased">{@code sparseResidencyAliased}</a> feature is not enabled, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_ALIASED_BIT</li>
            <li>If {@code tiling} is #IMAGE_TILING_LINEAR, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If {@code imageType} is #IMAGE_TYPE_1D, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidencyImage2D">{@code sparseResidencyImage2D}</a> feature is not enabled, and {@code imageType} is #IMAGE_TYPE_2D, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidencyImage3D">{@code sparseResidencyImage3D}</a> feature is not enabled, and {@code imageType} is #IMAGE_TYPE_3D, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidency2Samples">{@code sparseResidency2Samples}</a> feature is not enabled, {@code imageType} is #IMAGE_TYPE_2D, and {@code samples} is #SAMPLE_COUNT_2_BIT, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidency4Samples">{@code sparseResidency4Samples}</a> feature is not enabled, {@code imageType} is #IMAGE_TYPE_2D, and {@code samples} is #SAMPLE_COUNT_4_BIT, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidency8Samples">{@code sparseResidency8Samples}</a> feature is not enabled, {@code imageType} is #IMAGE_TYPE_2D, and {@code samples} is #SAMPLE_COUNT_8_BIT, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sparseResidency16Samples">{@code sparseResidency16Samples}</a> feature is not enabled, {@code imageType} is #IMAGE_TYPE_2D, and {@code samples} is #SAMPLE_COUNT_16_BIT, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>If {@code flags} contains #IMAGE_CREATE_SPARSE_RESIDENCY_BIT or #IMAGE_CREATE_SPARSE_ALIASED_BIT, it <b>must</b> also contain #IMAGE_CREATE_SPARSE_BINDING_BIT</li>
            <li>If any of the bits #IMAGE_CREATE_SPARSE_BINDING_BIT, #IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or #IMAGE_CREATE_SPARSE_ALIASED_BIT are set, #IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT <b>must</b> not also be set</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-protectedMemory">{@code protectedMemory}</a> feature is not enabled, {@code flags} <b>must</b> not contain #IMAGE_CREATE_PROTECTED_BIT</li>
            <li>If any of the bits #IMAGE_CREATE_SPARSE_BINDING_BIT, #IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or #IMAGE_CREATE_SPARSE_ALIASED_BIT are set, #IMAGE_CREATE_PROTECTED_BIT <b>must</b> not also be set</li>
            <li>If the {@code pNext} chain includes a ##VkExternalMemoryImageCreateInfoNV structure, it <b>must</b> not contain a ##VkExternalMemoryImageCreateInfo structure</li>
            <li>If the {@code pNext} chain includes a ##VkExternalMemoryImageCreateInfo structure, its {@code handleTypes} member <b>must</b> only contain bits that are also in ##VkExternalImageFormatProperties{@code ::externalMemoryProperties.compatibleHandleTypes}, as returned by #GetPhysicalDeviceImageFormatProperties2() with {@code format}, {@code imageType}, {@code tiling}, {@code usage}, and {@code flags} equal to those in this structure, and with a ##VkPhysicalDeviceExternalImageFormatInfo structure included in the {@code pNext} chain, with a {@code handleType} equal to any one of the handle types specified in ##VkExternalMemoryImageCreateInfo{@code ::handleTypes}</li>
            <li>If the {@code pNext} chain includes a ##VkExternalMemoryImageCreateInfoNV structure, its {@code handleTypes} member <b>must</b> only contain bits that are also in ##VkExternalImageFormatPropertiesNV{@code ::externalMemoryProperties.compatibleHandleTypes}, as returned by #GetPhysicalDeviceExternalImageFormatPropertiesNV() with {@code format}, {@code imageType}, {@code tiling}, {@code usage}, and {@code flags} equal to those in this structure, and with {@code externalHandleType} equal to any one of the handle types specified in ##VkExternalMemoryImageCreateInfoNV{@code ::handleTypes}</li>
            <li>If the logical device was created with ##VkDeviceGroupDeviceCreateInfo{@code ::physicalDeviceCount} equal to 1, {@code flags} <b>must</b> not contain #IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT</li>
            <li>If {@code flags} contains #IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT, then {@code mipLevels} <b>must</b> be one, {@code arrayLayers} <b>must</b> be one, {@code imageType} <b>must</b> be #IMAGE_TYPE_2D. and {@code imageCreateMaybeLinear} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>) <b>must</b> be #FALSE</li>
            <li>If {@code flags} contains #IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then {@code format} <b>must</b> be a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#compressed_image_formats">compressed image format</a></li>
            <li>If {@code flags} contains #IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then {@code flags} <b>must</b> also contain #IMAGE_CREATE_MUTABLE_FORMAT_BIT</li>
            <li>{@code initialLayout} <b>must</b> be #IMAGE_LAYOUT_UNDEFINED or #IMAGE_LAYOUT_PREINITIALIZED</li>
            <li>If the {@code pNext} chain includes a ##VkExternalMemoryImageCreateInfo or ##VkExternalMemoryImageCreateInfoNV structure whose {@code handleTypes} member is not 0, {@code initialLayout} <b>must</b> be #IMAGE_LAYOUT_UNDEFINED</li>
            <li>If the image {@code format} is one of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">formats that require a sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a>, {@code mipLevels} <b>must</b> be 1</li>
            <li>If the image {@code format} is one of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">formats that require a sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a>, {@code samples} <b>must</b> be #SAMPLE_COUNT_1_BIT</li>
            <li>If the image {@code format} is one of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">formats that require a sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a>, {@code imageType} <b>must</b> be #IMAGE_TYPE_2D</li>
            <li>If {@code format} is a <em>multi-planar</em> format, and if {@code imageCreateFormatFeatures} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>) does not contain #FORMAT_FEATURE_DISJOINT_BIT, then {@code flags} <b>must</b> not contain #IMAGE_CREATE_DISJOINT_BIT</li>
            <li>If {@code format} is not a <em>multi-planar</em> format, and {@code flags} does not include #IMAGE_CREATE_ALIAS_BIT, {@code flags} <b>must</b> not contain #IMAGE_CREATE_DISJOINT_BIT</li>
            <li>If {@code format} has a {@code _422} or {@code _420} suffix, {@code extent.width} <b>must</b> be a multiple of 2</li>
            <li>If {@code format} has a {@code _420} suffix, {@code extent.height} <b>must</b> be a multiple of 2</li>
            <li>If {@code format} is one of the {@code VK_FORMAT_PVTRC1_*_IMG} formats, {@code extent.width} <b>must</b> be a power of 2</li>
            <li>If {@code format} is one of the {@code VK_FORMAT_PVTRC1_*_IMG} formats, {@code extent.height} <b>must</b> be a power of 2</li>
            <li>If {@code tiling} is #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then the {@code pNext} chain <b>must</b> include exactly one of ##VkImageDrmFormatModifierListCreateInfoEXT or ##VkImageDrmFormatModifierExplicitCreateInfoEXT structures</li>
            <li>If the {@code pNext} chain includes a ##VkImageDrmFormatModifierListCreateInfoEXT or ##VkImageDrmFormatModifierExplicitCreateInfoEXT structure, then {@code tiling} <b>must</b> be #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT</li>
            <li>If {@code tiling} is #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT and {@code flags} contains #IMAGE_CREATE_MUTABLE_FORMAT_BIT, then the {@code pNext} chain <b>must</b> include a ##VkImageFormatListCreateInfo structure with non-zero {@code viewFormatCount}</li>
            <li>If {@code flags} contains #IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT {@code format} <b>must</b> be a depth or depth/stencil format</li>
            <li>If the {@code pNext} chain includes a ##VkExternalMemoryImageCreateInfo structure whose {@code handleTypes} member includes #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, {@code imageType} <b>must</b> be #IMAGE_TYPE_2D</li>
            <li>If the {@code pNext} chain includes a ##VkExternalMemoryImageCreateInfo structure whose {@code handleTypes} member includes #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, {@code mipLevels} <b>must</b> either be 1 or equal to the number of levels in the complete mipmap chain based on <code>extent.width</code>, <code>extent.height</code>, and <code>extent.depth</code></li>
            <li>If the {@code pNext} chain includes a ##VkExternalFormatANDROID structure whose {@code externalFormat} member is not 0, {@code flags} <b>must</b> not include #IMAGE_CREATE_MUTABLE_FORMAT_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkExternalFormatANDROID structure whose {@code externalFormat} member is not 0, {@code usage} <b>must</b> not include any usages except #IMAGE_USAGE_INPUT_ATTACHMENT_BIT, #IMAGE_USAGE_COLOR_ATTACHMENT_BIT, or #IMAGE_USAGE_SAMPLED_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkExternalFormatANDROID structure whose {@code externalFormat} member is not 0, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is not enabled, {@code usage} <b>must</b> not include #IMAGE_USAGE_INPUT_ATTACHMENT_BIT or #IMAGE_USAGE_COLOR_ATTACHMENT_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkExternalFormatANDROID structure whose {@code externalFormat} member is not 0, {@code tiling} <b>must</b> be #IMAGE_TILING_OPTIMAL</li>
            <li>If {@code format} is a depth-stencil format, {@code usage} includes #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the {@code pNext} chain includes a ##VkImageStencilUsageCreateInfo structure, then its ##VkImageStencilUsageCreateInfo{@code ::stencilUsage} member <b>must</b> also include #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code format} is a depth-stencil format, {@code usage} does not include #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the {@code pNext} chain includes a ##VkImageStencilUsageCreateInfo structure, then its ##VkImageStencilUsageCreateInfo{@code ::stencilUsage} member <b>must</b> also not include #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code format} is a depth-stencil format, {@code usage} includes #IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the {@code pNext} chain includes a ##VkImageStencilUsageCreateInfo structure, then its ##VkImageStencilUsageCreateInfo{@code ::stencilUsage} member <b>must</b> also include #IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT</li>
            <li>If {@code format} is a depth-stencil format, {@code usage} does not include #IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the {@code pNext} chain includes a ##VkImageStencilUsageCreateInfo structure, then its ##VkImageStencilUsageCreateInfo{@code ::stencilUsage} member <b>must</b> also not include #IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT</li>
            <li>If {@code Format} is a depth-stencil format and the {@code pNext} chain includes a ##VkImageStencilUsageCreateInfo structure with its {@code stencilUsage} member including #IMAGE_USAGE_INPUT_ATTACHMENT_BIT, {@code extent.width} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxFramebufferWidth}</li>
            <li>If {@code format} is a depth-stencil format and the {@code pNext} chain includes a ##VkImageStencilUsageCreateInfo structure with its {@code stencilUsage} member including #IMAGE_USAGE_INPUT_ATTACHMENT_BIT, {@code extent.height} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxFramebufferHeight}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderStorageImageMultisample">{@code shaderStorageImageMultisample}</a> feature is not enabled, {@code format} is a depth-stencil format and the {@code pNext} chain includes a ##VkImageStencilUsageCreateInfo structure with its {@code stencilUsage} including #IMAGE_USAGE_STORAGE_BIT, {@code samples} <b>must</b> be #SAMPLE_COUNT_1_BIT</li>
            <li>If {@code flags} contains #IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, {@code imageType} <b>must</b> be #IMAGE_TYPE_2D or #IMAGE_TYPE_3D</li>
            <li>If {@code flags} contains #IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, it <b>must</b> not contain #IMAGE_CREATE_CUBE_COMPATIBLE_BIT and the {@code format} <b>must</b> not be a depth/stencil format</li>
            <li>If {@code flags} contains #IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and {@code imageType} is #IMAGE_TYPE_2D, {@code extent.width} and {@code extent.height} <b>must</b> be greater than 1</li>
            <li>If {@code flags} contains #IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and {@code imageType} is #IMAGE_TYPE_3D, {@code extent.width}, {@code extent.height}, and {@code extent.depth} <b>must</b> be greater than 1</li>
            <li>If {@code usage} includes #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, {@code imageType} <b>must</b> be #IMAGE_TYPE_2D</li>
            <li>If {@code usage} includes #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, {@code samples} <b>must</b> be #SAMPLE_COUNT_1_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shadingRateImage">{@code shadingRateImage}</a> feature is enabled and {@code usage} includes #IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, {@code tiling} <b>must</b> be #IMAGE_TILING_OPTIMAL</li>
            <li>If {@code flags} contains #IMAGE_CREATE_SUBSAMPLED_BIT_EXT, {@code tiling} <b>must</b> be #IMAGE_TILING_OPTIMAL</li>
            <li>If {@code flags} contains #IMAGE_CREATE_SUBSAMPLED_BIT_EXT, {@code imageType} <b>must</b> be #IMAGE_TYPE_2D</li>
            <li>If {@code flags} contains #IMAGE_CREATE_SUBSAMPLED_BIT_EXT, {@code flags} <b>must</b> not contain #IMAGE_CREATE_CUBE_COMPATIBLE_BIT</li>
            <li>If {@code flags} contains #IMAGE_CREATE_SUBSAMPLED_BIT_EXT, {@code mipLevels} <b>must</b> be 1</li>
            <li>If {@code usage} includes #IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI, {@code tiling} <b>must</b> be #IMAGE_TILING_LINEAR</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::imageView2DOn3DImage} is #FALSE, {@code flags} <b>must</b> not contain #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::multisampleArrayImage} is #FALSE, and {@code samples} is not #SAMPLE_COUNT_1_BIT, then {@code arrayLayers} <b>must</b> be 1</li>
            <li>If a ##VkImageFormatListCreateInfo structure was included in the {@code pNext} chain and {@code format} is not a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> format and ##VkImageFormatListCreateInfo{@code ::viewFormatCount} is not zero, then each format in ##VkImageFormatListCreateInfo{@code ::pViewFormats} <b>must</b> either be compatible with the {@code format} as described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-compatibility">compatibility table</a> or, if {@code flags} contains #IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, be an uncompressed format that is size-compatible with {@code format}</li>
            <li>If a ##VkImageFormatListCreateInfo structure was included in the {@code pNext} chain and {@code format} is a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> format and {@code flags} contains #IMAGE_CREATE_MUTABLE_FORMAT_BIT and ##VkImageFormatListCreateInfo{@code ::viewFormatCount} is not zero, then each format in ##VkImageFormatListCreateInfo{@code ::pViewFormats} <b>must</b> be compatible with the {@code VkFormat} for the plane of the image format</li>
            <li>If {@code flags} does not contain #IMAGE_CREATE_MUTABLE_FORMAT_BIT and the {@code pNext} chain includes a ##VkImageFormatListCreateInfo structure, then ##VkImageFormatListCreateInfo{@code ::viewFormatCount} <b>must</b> be 0 or 1</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR, #IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, or #IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR, and {@code flags} does not include #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoProfileListInfoKHR structure with {@code profileCount} greater than 0 and {@code pProfiles} including at least one ##VkVideoProfileInfoKHR structure with a {@code videoCodecOperation} member specifying a decode operation</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, #IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR, or #IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR, and {@code flags} does not include #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoProfileListInfoKHR structure with {@code profileCount} greater than 0 and {@code pProfiles} including at least one ##VkVideoProfileInfoKHR structure with a {@code videoCodecOperation} member specifying an encode operation</li>
            <li>If {@code flags} includes #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-videoMaintenance1">{@code videoMaintenance1}</a> <b>must</b> be enabled</li>
            <li>If {@code flags} includes #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and {@code usage} does not include #IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, then {@code usage} <b>must</b> not include #IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR</li>
            <li>If {@code flags} includes #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then {@code usage} <b>must</b> not include #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR, #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, or #IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR</li>
            <li>If the {@code pNext} chain includes a ##VkVideoProfileListInfoKHR structure with {@code profileCount} greater than 0, then {@code supportedVideoFormat} <b>must</b> be #TRUE</li>
            <li>If the {@code pNext} chain includes a ##VkVideoProfileListInfoKHR structure and for any element of its {@code pProfiles} member {@code videoCodecOperation} is #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-videoEncodeAV1">{@code videoEncodeAV1}</a> feature <b>must</b> be enabled</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-videoEncodeQuantizationMap">{@code videoEncodeQuantizationMap}</a> feature <b>must</b> be enabled</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, {@code imageType} <b>must</b> be #IMAGE_TYPE_2D</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, {@code samples} <b>must</b> be #SAMPLE_COUNT_1_BIT</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoProfileListInfoKHR structure with {@code profileCount} equal to 1 and {@code pProfiles} pointing to a ##VkVideoProfileInfoKHR structure with a {@code videoCodecOperation} member specifying an encode operation</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR, then ##VkVideoEncodeCapabilitiesKHR{@code ::flags} <b>must</b> include #VIDEO_ENCODE_CAPABILITY_QUANTIZATION_DELTA_MAP_BIT_KHR, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified in the {@code pProfiles} member of the ##VkVideoProfileListInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, then ##VkVideoEncodeCapabilitiesKHR{@code ::flags} <b>must</b> include #VIDEO_ENCODE_CAPABILITY_EMPHASIS_MAP_BIT_KHR, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified in the {@code pProfiles} member of the ##VkVideoProfileListInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, {@code extent.width} <b>must</b> be less than or equal to ##VkVideoEncodeQuantizationMapCapabilitiesKHR{@code ::maxQuantizationMapExtent.width}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified in the {@code pProfiles} member of the ##VkVideoProfileListInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code usage} includes #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, {@code extent.height} <b>must</b> be less than or equal to ##VkVideoEncodeQuantizationMapCapabilitiesKHR{@code ::maxQuantizationMapExtent.height}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified in the {@code pProfiles} member of the ##VkVideoProfileListInfoKHR structure included in the {@code pNext} chain</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multisampledRenderToSingleSampled">{@code multisampledRenderToSingleSampled}</a> feature is not enabled, {@code flags} <b>must</b> not contain #IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT</li>
            <li>If {@code flags} contains #IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT, {@code samples} <b>must</b> be #SAMPLE_COUNT_1_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkImageCompressionControlEXT structure, {@code format} is a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> format, and ##VkImageCompressionControlEXT{@code ::flags} includes #IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, then ##VkImageCompressionControlEXT{@code ::compressionControlPlaneCount} <b>must</b> be equal to the number of planes in {@code format}</li>
            <li>If the {@code pNext} chain includes a ##VkImageCompressionControlEXT structure, {@code format} is not a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> format, and ##VkImageCompressionControlEXT{@code ::flags} includes #IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, then ##VkImageCompressionControlEXT{@code ::compressionControlPlaneCount} <b>must</b> be 1</li>
            <li>If the {@code pNext} chain includes a ##VkImageCompressionControlEXT structure, it <b>must</b> not contain a ##VkImageDrmFormatModifierExplicitCreateInfoEXT structure</li>
            <li>If {@code flags} includes #IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBufferCaptureReplay">{@code descriptorBufferCaptureReplay}</a> feature <b>must</b> be enabled</li>
            <li>If the {@code pNext} chain includes a ##VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, {@code flags} <b>must</b> contain #IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT</li>
            <li>If the {@code pNext} chain includes a ##VkExportMetalObjectCreateInfoEXT structure, its {@code exportObjectType} member <b>must</b> be either #EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT or #EXPORT_METAL_OBJECT_TYPE_METAL_IOSURFACE_BIT_EXT</li>
            <li>If the {@code pNext} chain includes a ##VkImportMetalTextureInfoEXT structure its {@code plane} member <b>must</b> be #IMAGE_ASPECT_PLANE_0_BIT, #IMAGE_ASPECT_PLANE_1_BIT, or #IMAGE_ASPECT_PLANE_2_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkImportMetalTextureInfoEXT structure and the image does not have a multi-planar format, then ##VkImportMetalTextureInfoEXT{@code ::plane} <b>must</b> be #IMAGE_ASPECT_PLANE_0_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkImportMetalTextureInfoEXT structure and the image has a multi-planar format with only two planes, then ##VkImportMetalTextureInfoEXT{@code ::plane} <b>must</b> not be #IMAGE_ASPECT_PLANE_2_BIT</li>
            <li>If {@code imageCreateFormatFeatures} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>) does not contain #FORMAT_FEATURE_2_HOST_IMAGE_TRANSFER_BIT, then {@code usage} <b>must</b> not contain #IMAGE_USAGE_HOST_TRANSFER_BIT</li>
            <li>If {@code usage} includes #IMAGE_USAGE_HOST_TRANSFER_BIT_EXT, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-hostImageCopy">{@code hostImageCopy}</a> feature <b>must</b> be enabled</li>
            <li>If the {@code pNext} chain contains a ##VkImageAlignmentControlCreateInfoMESA structure, {@code tiling} <b>must</b> be #IMAGE_TILING_OPTIMAL</li>
            <li>If the {@code pNext} chain contains a ##VkImageAlignmentControlCreateInfoMESA structure, it <b>must</b> not contain a ##VkExternalMemoryImageCreateInfo structure</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDedicatedAllocationImageCreateInfoNV, ##VkExportMetalObjectCreateInfoEXT, ##VkExternalFormatANDROID, ##VkExternalMemoryImageCreateInfo, ##VkExternalMemoryImageCreateInfoNV, ##VkImageAlignmentControlCreateInfoMESA, ##VkImageCompressionControlEXT, ##VkImageDrmFormatModifierExplicitCreateInfoEXT, ##VkImageDrmFormatModifierListCreateInfoEXT, ##VkImageFormatListCreateInfo, ##VkImageStencilUsageCreateInfo, ##VkImageSwapchainCreateInfoKHR, ##VkImportMetalIOSurfaceInfoEXT, ##VkImportMetalTextureInfoEXT, ##VkOpaqueCaptureDescriptorDataCreateInfoEXT, ##VkOpticalFlowImageFormatInfoNV, or ##VkVideoProfileListInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique, with the exception of structures of type ##VkExportMetalObjectCreateInfoEXT or ##VkImportMetalTextureInfoEXT</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkImageCreateFlagBits} values</li>
            <li>{@code imageType} <b>must</b> be a valid {@code VkImageType} value</li>
            <li>{@code format} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>{@code samples} <b>must</b> be a valid {@code VkSampleCountFlagBits} value</li>
            <li>{@code tiling} <b>must</b> be a valid {@code VkImageTiling} value</li>
            <li>{@code usage} <b>must</b> be a valid combination of {@code VkImageUsageFlagBits} values</li>
            <li>{@code usage} <b>must</b> not be 0</li>
            <li>{@code sharingMode} <b>must</b> be a valid {@code VkSharingMode} value</li>
            <li>{@code initialLayout} <b>must</b> be a valid {@code VkImageLayout} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkDeviceImageMemoryRequirements, ##VkDeviceImageSubresourceInfo, ##VkExtent3D, #CreateImage()
        """

    Expression("#STRUCTURE_TYPE_IMAGE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDedicatedAllocationImageCreateInfoNV", "VkExportMetalObjectCreateInfoEXT", "VkExternalFormatANDROID", "VkExternalMemoryImageCreateInfo", "VkExternalMemoryImageCreateInfoKHR", "VkExternalMemoryImageCreateInfoNV", "VkImageAlignmentControlCreateInfoMESA", "VkImageCompressionControlEXT", "VkImageDrmFormatModifierExplicitCreateInfoEXT", "VkImageDrmFormatModifierListCreateInfoEXT", "VkImageFormatListCreateInfo", "VkImageFormatListCreateInfoKHR", "VkImageStencilUsageCreateInfo", "VkImageStencilUsageCreateInfoEXT", "VkImageSwapchainCreateInfoKHR", "VkImportMetalIOSurfaceInfoEXT", "VkImportMetalTextureInfoEXT", "VkOpaqueCaptureDescriptorDataCreateInfoEXT", "VkOpticalFlowImageFormatInfoNV", "VkVideoProfileListInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkImageCreateFlags("flags", "a bitmask of {@code VkImageCreateFlagBits} describing additional parameters of the image.")
    VkImageType("imageType", "a {@code VkImageType} value specifying the basic dimensionality of the image. Layers in array textures do not count as a dimension for the purposes of the image type.")
    VkFormat("format", "a {@code VkFormat} describing the format and type of the texel blocks that will be contained in the image.")
    VkExtent3D("extent", "a ##VkExtent3D describing the number of data elements in each dimension of the base level.")
    uint32_t("mipLevels", "describes the number of levels of detail available for minified sampling of the image.")
    uint32_t("arrayLayers", "the number of layers in the image.")
    VkSampleCountFlagBits("samples", "a {@code VkSampleCountFlagBits} value specifying the number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-multisampling\">samples per texel</a>.")
    VkImageTiling("tiling", "a {@code VkImageTiling} value specifying the tiling arrangement of the texel blocks in memory.")
    VkImageUsageFlags("usage", "a bitmask of {@code VkImageUsageFlagBits} describing the intended usage of the image.")
    VkSharingMode("sharingMode", "a {@code VkSharingMode} value specifying the sharing mode of the image when it will be accessed by multiple queue families.")
    AutoSize("pQueueFamilyIndices", optional = true)..uint32_t("queueFamilyIndexCount", "the number of entries in the {@code pQueueFamilyIndices} array.")
    nullable..uint32_t.const.p("pQueueFamilyIndices", "a pointer to an array of queue families that will access this image. It is ignored if {@code sharingMode} is not #SHARING_MODE_CONCURRENT.")
    VkImageLayout("initialLayout", "a {@code VkImageLayout} value specifying the initial {@code VkImageLayout} of all image subresources of the image. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#resources-image-layouts\">Image Layouts</a>.")
}

val VkSubresourceLayout = struct(Module.VULKAN, "VkSubresourceLayout") {
    documentation =
        """
        Structure specifying subresource layout.

        <h5>Description</h5>
        If the image is <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#glossary-linear-resource">linear</a>, then {@code rowPitch}, {@code arrayPitch} and {@code depthPitch} describe the layout of the image subresource in linear memory. For uncompressed formats, {@code rowPitch} is the number of bytes between texels with the same x coordinate in adjacent rows (y coordinates differ by one). {@code arrayPitch} is the number of bytes between texels with the same x and y coordinate in adjacent array layers of the image (array layer values differ by one). {@code depthPitch} is the number of bytes between texels with the same x and y coordinate in adjacent slices of a 3D image (z coordinates differ by one). Expressed as an addressing formula, the starting byte of a texel in the image subresource has address:

        <pre><code>
￿// (x,y,z,layer) are in texel coordinates
￿address(x,y,z,layer) = layer*arrayPitch + z*depthPitch + y*rowPitch + x*elementSize + offset</code></pre>

        For compressed formats, the {@code rowPitch} is the number of bytes between compressed texel blocks in adjacent rows. {@code arrayPitch} is the number of bytes between compressed texel blocks in adjacent array layers. {@code depthPitch} is the number of bytes between compressed texel blocks in adjacent slices of a 3D image.

        <pre><code>
￿// (x,y,z,layer) are in compressed texel block coordinates
￿address(x,y,z,layer) = layer*arrayPitch + z*depthPitch + y*rowPitch + x*compressedTexelBlockByteSize + offset;</code></pre>

        The value of {@code arrayPitch} is undefined for images that were not created as arrays. {@code depthPitch} is defined only for 3D images.

        If the image has a <em>single-plane</em> color format and its tiling is #IMAGE_TILING_LINEAR , then the {@code aspectMask} member of ##VkImageSubresource <b>must</b> be #IMAGE_ASPECT_COLOR_BIT.

        If the image has a depth/stencil format and its tiling is #IMAGE_TILING_LINEAR , then {@code aspectMask} <b>must</b> be either #IMAGE_ASPECT_DEPTH_BIT or #IMAGE_ASPECT_STENCIL_BIT. On implementations that store depth and stencil aspects separately, querying each of these image subresource layouts will return a different {@code offset} and {@code size} representing the region of memory used for that aspect. On implementations that store depth and stencil aspects interleaved, the same {@code offset} and {@code size} are returned and represent the interleaved memory allocation.

        If the image has a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar format</a> and its tiling is #IMAGE_TILING_LINEAR , then the {@code aspectMask} member of ##VkImageSubresource <b>must</b> be #IMAGE_ASPECT_PLANE_0_BIT, #IMAGE_ASPECT_PLANE_1_BIT, or (for 3-plane formats only) #IMAGE_ASPECT_PLANE_2_BIT. Querying each of these image subresource layouts will return a different {@code offset} and {@code size} representing the region of memory used for that plane. If the image is <em>disjoint</em>, then the {@code offset} is relative to the base address of the plane. If the image is <em>non-disjoint</em>, then the {@code offset} is relative to the base address of the image.

        If the image’s tiling is #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then the {@code aspectMask} member of ##VkImageSubresource <b>must</b> be one of <code>VK_IMAGE_ASPECT_MEMORY_PLANE<em>_i_</em>BIT_EXT</code>, where the maximum allowed plane index <em>i</em> is defined by the ##VkDrmFormatModifierPropertiesEXT{@code ::drmFormatModifierPlaneCount} associated with the image’s ##VkImageCreateInfo{@code ::format} and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#glossary-drm-format-modifier">modifier</a>. The memory range used by the subresource is described by {@code offset} and {@code size}. If the image is <em>disjoint</em>, then the {@code offset} is relative to the base address of the <em>memory plane</em>. If the image is <em>non-disjoint</em>, then the {@code offset} is relative to the base address of the image. If the image is <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#glossary-linear-resource">non-linear</a>, then {@code rowPitch}, {@code arrayPitch}, and {@code depthPitch} have an implementation-dependent meaning.

        <h5>See Also</h5>
        ##VkImageDrmFormatModifierExplicitCreateInfoEXT, ##VkSubresourceLayout2, #GetImageSubresourceLayout()
        """

    VkDeviceSize("offset", "the byte offset from the start of the image or the plane where the image subresource begins.")
    VkDeviceSize("size", "the size in bytes of the image subresource. {@code size} includes any extra memory that is required based on {@code rowPitch}.")
    VkDeviceSize("rowPitch", "describes the number of bytes between each row of texels in an image.")
    VkDeviceSize("arrayPitch", "describes the number of bytes between each array layer of an image.")
    VkDeviceSize("depthPitch", "describes the number of bytes between each slice of 3D image.")
}

val VkComponentMapping = struct(Module.VULKAN, "VkComponentMapping") {
    documentation =
        """
        Structure specifying a color component mapping.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code r} <b>must</b> be a valid {@code VkComponentSwizzle} value</li>
            <li>{@code g} <b>must</b> be a valid {@code VkComponentSwizzle} value</li>
            <li>{@code b} <b>must</b> be a valid {@code VkComponentSwizzle} value</li>
            <li>{@code a} <b>must</b> be a valid {@code VkComponentSwizzle} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkAndroidHardwareBufferFormatProperties2ANDROID, ##VkAndroidHardwareBufferFormatPropertiesANDROID, ##VkImageViewCreateInfo, ##VkSamplerBorderColorComponentMappingCreateInfoEXT, ##VkSamplerYcbcrConversionCreateInfo, ##VkVideoFormatPropertiesKHR
        """

    VkComponentSwizzle("r", "a {@code VkComponentSwizzle} specifying the component value placed in the R component of the output vector.")
    VkComponentSwizzle("g", "a {@code VkComponentSwizzle} specifying the component value placed in the G component of the output vector.")
    VkComponentSwizzle("b", "a {@code VkComponentSwizzle} specifying the component value placed in the B component of the output vector.")
    VkComponentSwizzle("a", "a {@code VkComponentSwizzle} specifying the component value placed in the A component of the output vector.")
}

val VkImageViewCreateInfo = struct(Module.VULKAN, "VkImageViewCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created image view.

        <h5>Description</h5>
        Some of the {@code image} creation parameters are inherited by the view. In particular, image view creation inherits the implicit parameter {@code usage} specifying the allowed usages of the image view that, by default, takes the value of the corresponding {@code usage} parameter specified in ##VkImageCreateInfo at image creation time. The implicit {@code usage} <b>can</b> be overridden by adding a ##VkImageViewUsageCreateInfo structure to the {@code pNext} chain, but the view usage <b>must</b> be a subset of the image usage. If {@code image} has a depth-stencil format and was created with a ##VkImageStencilUsageCreateInfo structure included in the {@code pNext} chain of ##VkImageCreateInfo, the usage is calculated based on the {@code subresource.aspectMask} provided:

        <ul>
            <li>If {@code aspectMask} includes only #IMAGE_ASPECT_STENCIL_BIT, the implicit {@code usage} is equal to ##VkImageStencilUsageCreateInfo{@code ::stencilUsage}.</li>
            <li>If {@code aspectMask} includes only #IMAGE_ASPECT_DEPTH_BIT, the implicit {@code usage} is equal to ##VkImageCreateInfo{@code ::usage}.</li>
            <li>If both aspects are included in {@code aspectMask}, the implicit {@code usage} is equal to the intersection of ##VkImageCreateInfo{@code ::usage} and ##VkImageStencilUsageCreateInfo{@code ::stencilUsage}.</li>
        </ul>

        If {@code image} is a 3D image, its Z range <b>can</b> be restricted to a subset by adding a ##VkImageViewSlicedCreateInfoEXT to the {@code pNext} chain.

        If {@code image} was created with the #IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, and if the {@code format} of the image is not <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a>, {@code format} <b>can</b> be different from the image’s format, but if {@code image} was created without the #IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag and they are not equal they <b>must</b> be <em>compatible</em>. Image format compatibility is defined in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-compatibility-classes">Format Compatibility Classes</a> section. Views of compatible formats will have the same mapping between texel coordinates and memory locations irrespective of the {@code format}, with only the interpretation of the bit pattern changing.

        If {@code image} was created with a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> format, and the image view’s {@code aspectMask} is one of #IMAGE_ASPECT_PLANE_0_BIT, #IMAGE_ASPECT_PLANE_1_BIT or #IMAGE_ASPECT_PLANE_2_BIT, the view’s aspect mask is considered to be equivalent to #IMAGE_ASPECT_COLOR_BIT when used as a framebuffer attachment.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Values intended to be used with one view format <b>may</b> not be exactly preserved when written or read through a different format. For example, an integer value that happens to have the bit pattern of a floating-point denorm or NaN <b>may</b> be flushed or canonicalized when written or read through a view with a floating-point format. Similarly, a value written through a signed normalized format that has a bit pattern exactly equal to <code>-2<sup>b</sup></code> <b>may</b> be changed to <code>-2<sup>b</sup> + 1</code> as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#fundamentals-fixedfpconv">Conversion from Normalized Fixed-Point to Floating-Point</a>.
        </div>

        If {@code image} was created with the #IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, {@code format} <b>must</b> be <em>compatible</em> with the image’s format as described above; or <b>must</b> be an uncompressed format, in which case it <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-size-compatibility"><em>size-compatible</em></a> with the image’s format. In this case, the resulting image view’s texel dimensions equal the dimensions of the selected mip level divided by the compressed texel block size and rounded up.

        The ##VkComponentMapping {@code components} member describes a remapping from components of the image to components of the vector returned by shader image instructions. This remapping <b>must</b> be the identity swizzle for storage image descriptors, input attachment descriptors, framebuffer attachments, and any {@code VkImageView} used with a combined image sampler that enables <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a>.

        If the image view is to be used with a sampler which supports <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a>, an <em>identically defined object</em> of type {@code VkSamplerYcbcrConversion} to that used to create the sampler <b>must</b> be passed to #CreateImageView() in a ##VkSamplerYcbcrConversionInfo included in the {@code pNext} chain of ##VkImageViewCreateInfo. Conversely, if a {@code VkSamplerYcbcrConversion} object is passed to #CreateImageView(), an identically defined {@code VkSamplerYcbcrConversion} object <b>must</b> be used when sampling the image.

        If the image has a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> {@code format}, {@code subresourceRange.aspectMask} is #IMAGE_ASPECT_COLOR_BIT, and {@code usage} includes #IMAGE_USAGE_SAMPLED_BIT, then the {@code format} <b>must</b> be identical to the image {@code format} and the sampler to be used with the image view <b>must</b> enable <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a>.

        When such an image is used in a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-coding">video coding</a> operation, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> has no effect.

        If {@code image} was created with the #IMAGE_CREATE_MUTABLE_FORMAT_BIT and the image has a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> {@code format}, and if {@code subresourceRange.aspectMask} is #IMAGE_ASPECT_PLANE_0_BIT, #IMAGE_ASPECT_PLANE_1_BIT, or #IMAGE_ASPECT_PLANE_2_BIT, {@code format} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-compatible-planes">compatible</a> with the corresponding plane of the image, and the sampler to be used with the image view <b>must</b> not enable <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a>. The {@code width} and {@code height} of the single-plane image view <b>must</b> be derived from the multi-planar image’s dimensions in the manner listed for <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-compatible-planes">plane compatibility</a> for the plane.

        Any view of an image plane will have the same mapping between texel coordinates and memory locations as used by the components of the color aspect, subject to the formulae relating texel coordinates to lower-resolution planes as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#textures-chroma-reconstruction">Chroma Reconstruction</a>. That is, if an R or B plane has a reduced resolution relative to the G plane of the multi-planar image, the image view operates using the (<em>u<sub>plane</sub></em>, <em>v<sub>plane</sub></em>) unnormalized coordinates of the reduced-resolution plane, and these coordinates access the same memory locations as the (<em>u<sub>color</sub></em>, <em>v<sub>color</sub></em>) unnormalized coordinates of the color aspect for which chroma reconstruction operations operate on the same (<em>u<sub>plane</sub></em>, <em>v<sub>plane</sub></em>) or (<em>i<sub>plane</sub></em>, <em>j<sub>plane</sub></em>) coordinates.

        <h6>Image Type and Image View Type Compatibility Requirements</h6>
        <table class="lwjgl">
            <thead><tr><th>Image View Type</th><th>Compatible Image Types</th></tr></thead>
            <tbody>
                <tr><td>#IMAGE_VIEW_TYPE_1D</td><td>#IMAGE_TYPE_1D</td></tr>
                <tr><td>#IMAGE_VIEW_TYPE_1D_ARRAY</td><td>#IMAGE_TYPE_1D</td></tr>
                <tr><td>#IMAGE_VIEW_TYPE_2D</td><td>#IMAGE_TYPE_2D , #IMAGE_TYPE_3D</td></tr>
                <tr><td>#IMAGE_VIEW_TYPE_2D_ARRAY</td><td>#IMAGE_TYPE_2D , #IMAGE_TYPE_3D</td></tr>
                <tr><td>#IMAGE_VIEW_TYPE_CUBE</td><td>#IMAGE_TYPE_2D</td></tr>
                <tr><td>#IMAGE_VIEW_TYPE_CUBE_ARRAY</td><td>#IMAGE_TYPE_2D</td></tr>
                <tr><td>#IMAGE_VIEW_TYPE_3D</td><td>#IMAGE_TYPE_3D</td></tr>
            </tbody>
        </table>

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code image} was not created with #IMAGE_CREATE_CUBE_COMPATIBLE_BIT then {@code viewType} <b>must</b> not be #IMAGE_VIEW_TYPE_CUBE or #IMAGE_VIEW_TYPE_CUBE_ARRAY</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-imageCubeArray">{@code imageCubeArray}</a> feature is not enabled, {@code viewType} <b>must</b> not be #IMAGE_VIEW_TYPE_CUBE_ARRAY</li>
            <li>If {@code image} was created with #IMAGE_TYPE_3D but without #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set then {@code viewType} <b>must</b> not be #IMAGE_VIEW_TYPE_2D_ARRAY</li>
            <li>If {@code image} was created with #IMAGE_TYPE_3D but without #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT or #IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set, then {@code viewType} <b>must</b> not be #IMAGE_VIEW_TYPE_2D</li>
            <li>If {@code image} was created with #IMAGE_TYPE_3D and {@code viewType} is #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY then {@code subresourceRange.levelCount} <b>must</b> be 1</li>
            <li>If {@code image} was created with a {@code samples} value not equal to #SAMPLE_COUNT_1_BIT then {@code viewType} <b>must</b> be either #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY</li>
            <li>{@code image} <b>must</b> have been created with a {@code usage} value containing at least one of the usages defined in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#valid-imageview-imageusage">valid image usage</a> list for image views</li>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> of the resultant image view <b>must</b> contain at least one bit</li>
            <li>If {@code usage} contains #IMAGE_USAGE_SAMPLED_BIT, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> of the resultant image view <b>must</b> contain #FORMAT_FEATURE_SAMPLED_IMAGE_BIT</li>
            <li>If {@code usage} contains #IMAGE_USAGE_STORAGE_BIT, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_STORAGE_IMAGE_BIT</li>
            <li>If {@code usage} contains #IMAGE_USAGE_COLOR_ATTACHMENT_BIT, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or #FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV</li>
            <li>If {@code usage} contains #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code image} was created with #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and {@code usage} contains #IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR</li>
            <li>If {@code image} was created with #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and {@code usage} contains #IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR</li>
            <li>If {@code image} was created with #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then {@code usage} <b>must</b> not include #IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR</li>
            <li>If {@code image} was created with #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and {@code usage} contains #IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR</li>
            <li>If {@code image} was created with #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and {@code usage} contains #IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR</li>
            <li>If {@code image} was created with #IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then {@code usage} <b>must</b> not include #IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR</li>
            <li>If {@code usage} contains #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_2_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR</li>
            <li>If {@code usage} contains #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_2_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR</li>
            <li>
                If {@code usage} contains #IMAGE_USAGE_INPUT_ATTACHMENT_BIT, and any of the following is true:
                <ul>
                    <li>the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is not enabled</li>
                    <li>the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-nullColorAttachmentWithExternalFormatResolve">{@code nullColorAttachmentWithExternalFormatResolve}</a> property is #FALSE</li>
                    <li>{@code image} was created with an ##VkExternalFormatANDROID{@code ::externalFormat} value of 0</li>
                </ul>

                then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain at least one of #FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or #FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT or #FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV
            </li>
            <li>{@code subresourceRange.baseMipLevel} <b>must</b> be less than the {@code mipLevels} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>If {@code subresourceRange.levelCount} is not #REMAINING_MIP_LEVELS, <code>subresourceRange.baseMipLevel + subresourceRange.levelCount</code> <b>must</b> be less than or equal to the {@code mipLevels} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>If {@code image} was created with {@code usage} containing #IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, {@code subresourceRange.levelCount} <b>must</b> be 1</li>
            <li>If {@code image} is not a 3D image created with #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT or #IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set, or {@code viewType} is not #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY, {@code subresourceRange.baseArrayLayer} <b>must</b> be less than the {@code arrayLayers} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>If {@code subresourceRange.layerCount} is not #REMAINING_ARRAY_LAYERS, {@code image} is not a 3D image created with #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT or #IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set, or {@code viewType} is not #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY, {@code subresourceRange.layerCount} <b>must</b> be non-zero and <code>subresourceRange.baseArrayLayer + subresourceRange.layerCount</code> <b>must</b> be less than or equal to the {@code arrayLayers} specified in ##VkImageCreateInfo when {@code image} was created</li>
            <li>If {@code image} is a 3D image created with #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, and {@code viewType} is #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY, {@code subresourceRange.baseArrayLayer} <b>must</b> be less than the depth computed from {@code baseMipLevel} and {@code extent.depth} specified in ##VkImageCreateInfo when {@code image} was created, according to the formula defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-mip-level-sizing">Image Mip Level Sizing</a></li>
            <li>If {@code subresourceRange.layerCount} is not #REMAINING_ARRAY_LAYERS, {@code image} is a 3D image created with #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, and {@code viewType} is #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY, {@code subresourceRange.layerCount} <b>must</b> be non-zero and <code>subresourceRange.baseArrayLayer + subresourceRange.layerCount</code> <b>must</b> be less than or equal to the depth computed from {@code baseMipLevel} and {@code extent.depth} specified in ##VkImageCreateInfo when {@code image} was created, according to the formula defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-mip-level-sizing">Image Mip Level Sizing</a></li>
            <li>If {@code image} was created with the #IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, but without the #IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, and if the {@code format} of the {@code image} is not a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> format, {@code format} <b>must</b> be compatible with the {@code format} used to create {@code image}, as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-compatibility-classes">Format Compatibility Classes</a></li>
            <li>If {@code image} was created with the #IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, {@code format} <b>must</b> be compatible with, or <b>must</b> be an uncompressed format that is size-compatible with, the {@code format} used to create {@code image}</li>
            <li>If {@code image} was created with the #IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag and {@code format} is a non-compressed format, the {@code levelCount} member of {@code subresourceRange} <b>must</b> be 1</li>
            <li>If {@code image} was created with the #IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, the ##VkPhysicalDeviceMaintenance6Properties{@code ::blockTexelViewCompatibleMultipleLayers} property is not #TRUE, and {@code format} is a non-compressed format, then the {@code layerCount} member of {@code subresourceRange} <b>must</b> be 1</li>
            <li>If a ##VkImageFormatListCreateInfo structure was included in the {@code pNext} chain of the ##VkImageCreateInfo structure used when creating {@code image} and ##VkImageFormatListCreateInfo{@code ::viewFormatCount} is not zero then {@code format} <b>must</b> be one of the formats in ##VkImageFormatListCreateInfo{@code ::pViewFormats}</li>
            <li>If {@code image} was created with the #IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, if the {@code format} of the {@code image} is a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> format, and if {@code subresourceRange.aspectMask} is one of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-planes-image-aspect">multi-planar aspect mask</a> bits, then {@code format} <b>must</b> be compatible with the {@code VkFormat} for the plane of the {@code image} {@code format} indicated by {@code subresourceRange.aspectMask}, as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-compatible-planes">Compatible formats of planes of multi-planar formats</a></li>
            <li>{@code subresourceRange.aspectMask} <b>must</b> only have at most 1 valid <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-planes-image-aspect">multi-planar aspect mask</a> bit</li>
            <li>If {@code image} was not created with the #IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, or if the {@code format} of the {@code image} is a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> format and if {@code subresourceRange.aspectMask} is #IMAGE_ASPECT_COLOR_BIT, {@code format} <b>must</b> be identical to the {@code format} used to create {@code image}</li>
            <li>If the image view <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#image-views-requiring-sampler-ycbcr-conversion">requires a sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> and {@code usage} contains #IMAGE_USAGE_SAMPLED_BIT, then the {@code pNext} chain <b>must</b> include a ##VkSamplerYcbcrConversionInfo structure with a conversion value other than #NULL_HANDLE</li>
            <li>If {@code format} has a {@code _422} or {@code _420} suffix then {@code image} <b>must</b> have been created with a width that is a multiple of 2</li>
            <li>If {@code format} has a {@code _420} suffix then {@code image} <b>must</b> have been created with a height that is a multiple of 2</li>
            <li>If the {@code pNext} chain includes a ##VkSamplerYcbcrConversionInfo structure with a {@code conversion} value other than #NULL_HANDLE, all members of {@code components} <b>must</b> have the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-views-identity-mappings">identity swizzle</a></li>
            <li>If the {@code pNext} chain includes a ##VkSamplerYcbcrConversionInfo structure with a {@code conversion} value other than #NULL_HANDLE, {@code format} <b>must</b> be the same used in ##VkSamplerYcbcrConversionCreateInfo{@code ::format}</li>
            <li>If {@code image} is non-sparse then it <b>must</b> be bound completely and contiguously to a single {@code VkDeviceMemory} object</li>
            <li>{@code viewType} <b>must</b> be compatible with the type of {@code image} as shown in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-views-compatibility">view type compatibility table</a></li>
            <li>If {@code image} has an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-external-android-hardware-buffer-external-formats">Android external format</a>, {@code format} <b>must</b> be #FORMAT_UNDEFINED</li>
            <li>If {@code image} has an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-external-android-hardware-buffer-external-formats">Android external format</a>, the {@code pNext} chain <b>must</b> include a ##VkSamplerYcbcrConversionInfo structure with a {@code conversion} object created with the same external format as {@code image}</li>
            <li>If {@code image} has an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-external-android-hardware-buffer-external-formats">Android external format</a>, all members of {@code components} <b>must</b> be the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-views-identity-mappings">identity swizzle</a></li>
            <li>If {@code image} was created with {@code usage} containing #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, {@code viewType} <b>must</b> be #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shadingRateImage">{@code shadingRateImage}</a> feature is enabled, and If {@code image} was created with {@code usage} containing #IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, {@code format} <b>must</b> be #FORMAT_R8_UINT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFragmentShadingRate">{@code attachmentFragmentShadingRate}</a> feature is enabled, and the {@code usage} for the image view includes #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, then the image view’s <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-view-format-features">format features</a> <b>must</b> contain #FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFragmentShadingRate">{@code attachmentFragmentShadingRate}</a> feature is enabled, the {@code usage} for the image view includes #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-layeredShadingRateAttachments">{@code layeredShadingRateAttachments}</a> is #FALSE, {@code subresourceRange.layerCount} <b>must</b> be 1</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMapDynamic">{@code fragmentDensityMapDynamic}</a> feature is not enabled, {@code flags} <b>must</b> not contain #IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMapDeferred">{@code fragmentDensityMapDeferred}</a> feature is not enabled, {@code flags} <b>must</b> not contain #IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT</li>
            <li>If {@code flags} contains #IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT, {@code flags} <b>must</b> not contain #IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT</li>
            <li>If {@code image} was created with {@code flags} containing #IMAGE_CREATE_SUBSAMPLED_BIT_EXT and {@code usage} containing #IMAGE_USAGE_SAMPLED_BIT, {@code subresourceRange.layerCount} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxSubsampledArrayLayers">##VkPhysicalDeviceFragmentDensityMap2PropertiesEXT{@code ::maxSubsampledArrayLayers}</a></li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-invocationMask">{@code invocationMask}</a> feature is enabled, and if {@code image} was created with {@code usage} containing #IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI, {@code format} <b>must</b> be #FORMAT_R8_UINT</li>
            <li>If {@code flags} does not contain #IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT and {@code image} was created with {@code usage} containing #IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, its {@code flags} <b>must</b> not contain any of #IMAGE_CREATE_PROTECTED_BIT, #IMAGE_CREATE_SPARSE_BINDING_BIT, #IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or #IMAGE_CREATE_SPARSE_ALIASED_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkImageViewUsageCreateInfo structure, and {@code image} was not created with a ##VkImageStencilUsageCreateInfo structure included in the {@code pNext} chain of ##VkImageCreateInfo, its {@code usage} member <b>must</b> not include any bits that were not set in the {@code usage} member of the ##VkImageCreateInfo structure used to create {@code image}</li>
            <li>If the {@code pNext} chain includes a ##VkImageViewUsageCreateInfo structure, {@code image} was created with a ##VkImageStencilUsageCreateInfo structure included in the {@code pNext} chain of ##VkImageCreateInfo, and {@code subresourceRange.aspectMask} includes #IMAGE_ASPECT_STENCIL_BIT, the {@code usage} member of the ##VkImageViewUsageCreateInfo structure <b>must</b> not include any bits that were not set in the {@code usage} member of the ##VkImageStencilUsageCreateInfo structure used to create {@code image}</li>
            <li>If the {@code pNext} chain includes a ##VkImageViewUsageCreateInfo structure, {@code image} was created with a ##VkImageStencilUsageCreateInfo structure included in the {@code pNext} chain of ##VkImageCreateInfo, and {@code subresourceRange.aspectMask} includes bits other than #IMAGE_ASPECT_STENCIL_BIT, the {@code usage} member of the ##VkImageViewUsageCreateInfo structure <b>must</b> not include any bits that were not set in the {@code usage} member of the ##VkImageCreateInfo structure used to create {@code image}</li>
            <li>If {@code viewType} is #IMAGE_VIEW_TYPE_1D, #IMAGE_VIEW_TYPE_2D, or #IMAGE_VIEW_TYPE_3D; and {@code subresourceRange.layerCount} is not #REMAINING_ARRAY_LAYERS, then {@code subresourceRange.layerCount} <b>must</b> be 1</li>
            <li>If {@code viewType} is #IMAGE_VIEW_TYPE_1D, #IMAGE_VIEW_TYPE_2D, or #IMAGE_VIEW_TYPE_3D; and {@code subresourceRange.layerCount} is #REMAINING_ARRAY_LAYERS, then the remaining number of layers <b>must</b> be 1</li>
            <li>If {@code viewType} is #IMAGE_VIEW_TYPE_CUBE and {@code subresourceRange.layerCount} is not #REMAINING_ARRAY_LAYERS, {@code subresourceRange.layerCount} <b>must</b> be 6</li>
            <li>If {@code viewType} is #IMAGE_VIEW_TYPE_CUBE_ARRAY and {@code subresourceRange.layerCount} is not #REMAINING_ARRAY_LAYERS, {@code subresourceRange.layerCount} <b>must</b> be a multiple of 6</li>
            <li>If {@code viewType} is #IMAGE_VIEW_TYPE_CUBE and {@code subresourceRange.layerCount} is #REMAINING_ARRAY_LAYERS, the remaining number of layers <b>must</b> be 6</li>
            <li>If {@code viewType} is #IMAGE_VIEW_TYPE_CUBE_ARRAY and {@code subresourceRange.layerCount} is #REMAINING_ARRAY_LAYERS, the remaining number of layers <b>must</b> be a multiple of 6</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::imageViewFormatSwizzle} is #FALSE, all elements of {@code components} <b>must</b> have the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-views-identity-mappings">identity swizzle</a></li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::imageViewFormatReinterpretation} is #FALSE, the {@code VkFormat} in {@code format} <b>must</b> not contain a different number of components, or a different number of bits in each component, than the format of the {@code VkImage} in {@code image}</li>
            <li>If {@code image} was created with {@code usage} containing #IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, #IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR, or #IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR, then the {@code viewType} <b>must</b> be #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY</li>
            <li>If {@code image} was created with {@code usage} containing #IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR, #IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, or #IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR, then the {@code viewType} <b>must</b> be #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY</li>
            <li>If {@code image} was created with {@code usage} containing #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, then {@code viewType} <b>must</b> be #IMAGE_VIEW_TYPE_2D or #IMAGE_VIEW_TYPE_2D_ARRAY</li>
            <li>If {@code flags} includes #IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBufferCaptureReplay">{@code descriptorBufferCaptureReplay}</a> feature <b>must</b> be enabled</li>
            <li>If the {@code pNext} chain includes a ##VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, {@code flags} <b>must</b> contain #IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT</li>
            <li>If the {@code pNext} chain includes a ##VkExportMetalObjectCreateInfoEXT structure, its {@code exportObjectType} member <b>must</b> be #EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure, then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-textureSampleWeighted">{@code textureSampleWeighted}</a> feature <b>must</b> be enabled</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure, then {@code image} <b>must</b> have been created with {@code usage} containing #IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure, then {@code components} <b>must</b> be #COMPONENT_SWIZZLE_IDENTITY for all components</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure, then {@code subresourceRange.aspectMask} <b>must</b> be #IMAGE_ASPECT_COLOR_BIT</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure, then {@code subresourceRange.levelCount} <b>must</b> be 1</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure, then {@code viewType} <b>must</b> be #IMAGE_VIEW_TYPE_1D_ARRAY or #IMAGE_VIEW_TYPE_2D_ARRAY</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure and if {@code viewType} is #IMAGE_VIEW_TYPE_1D_ARRAY, then {@code image} <b>must</b> have been created with {@code imageType} #IMAGE_TYPE_1D</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure and {@code viewType} is #IMAGE_VIEW_TYPE_1D_ARRAY, then {@code subresourceRange.layerCount} <b>must</b> be equal to 2</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure and {@code viewType} is #IMAGE_VIEW_TYPE_1D_ARRAY, then {@code image} <b>must</b> have been created with {@code width} equal to or greater than <code>(numPhases &times; max(align(filterSize.width, 4), filterSize.height))</code></li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure and if {@code viewType} is #IMAGE_VIEW_TYPE_2D_ARRAY, then {@code image} <b>must</b> have been created with {@code imageType} #IMAGE_TYPE_2D</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure and {@code viewType} is #IMAGE_VIEW_TYPE_2D_ARRAY, then {@code subresourceRange.layerCount} <b>must</b> be equal or greater than <code>numPhases</code></li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure and {@code viewType} is #IMAGE_VIEW_TYPE_2D_ARRAY, then {@code image} <b>must</b> have been created with {@code width} equal to or greater than {@code filterSize.width}</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure and {@code viewType} is #IMAGE_VIEW_TYPE_2D_ARRAY, then {@code image} <b>must</b> have been created with {@code height} equal to or greater than {@code filterSize.height}</li>
            <li>If the {@code pNext} chain includes ##VkImageViewSampleWeightCreateInfoQCOM structure then ##VkImageViewSampleWeightCreateInfoQCOM{@code ::filterSize.height} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-weightfilter-maxdimension">##VkPhysicalDeviceImageProcessingPropertiesQCOM{@code ::maxWeightFilterDimension.height}</a></li>
            <li>{@code subresourceRange.aspectMask} <b>must</b> be valid for the {@code format} the {@code image} was created with</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkExportMetalObjectCreateInfoEXT, ##VkImageViewASTCDecodeModeEXT, ##VkImageViewMinLodCreateInfoEXT, ##VkImageViewSampleWeightCreateInfoQCOM, ##VkImageViewSlicedCreateInfoEXT, ##VkImageViewUsageCreateInfo, ##VkOpaqueCaptureDescriptorDataCreateInfoEXT, or ##VkSamplerYcbcrConversionInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique, with the exception of structures of type ##VkExportMetalObjectCreateInfoEXT</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkImageViewCreateFlagBits} values</li>
            <li>{@code image} <b>must</b> be a valid {@code VkImage} handle</li>
            <li>{@code viewType} <b>must</b> be a valid {@code VkImageViewType} value</li>
            <li>{@code format} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>{@code components} <b>must</b> be a valid ##VkComponentMapping structure</li>
            <li>{@code subresourceRange} <b>must</b> be a valid ##VkImageSubresourceRange structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkComponentMapping, ##VkImageSubresourceRange, #CreateImageView()
        """

    Expression("#STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkExportMetalObjectCreateInfoEXT", "VkImageViewASTCDecodeModeEXT", "VkImageViewMinLodCreateInfoEXT", "VkImageViewSampleWeightCreateInfoQCOM", "VkImageViewSlicedCreateInfoEXT", "VkImageViewUsageCreateInfo", "VkImageViewUsageCreateInfoKHR", "VkOpaqueCaptureDescriptorDataCreateInfoEXT", "VkSamplerYcbcrConversionInfo", "VkSamplerYcbcrConversionInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkImageViewCreateFlags("flags", "a bitmask of {@code VkImageViewCreateFlagBits} specifying additional parameters of the image view.")
    VkImage("image", "a {@code VkImage} on which the view will be created.")
    VkImageViewType("viewType", "a {@code VkImageViewType} value specifying the type of the image view.")
    VkFormat("format", "a {@code VkFormat} specifying the format and type used to interpret texel blocks of the image.")
    VkComponentMapping("components", "a ##VkComponentMapping structure specifying a remapping of color components (or of depth or stencil components after they have been converted into color components).")
    VkImageSubresourceRange("subresourceRange", "a ##VkImageSubresourceRange structure selecting the set of mipmap levels and array layers to be accessible to the view.")
}

val VkShaderModuleCreateInfo = struct(Module.VULKAN, "VkShaderModuleCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created shader module.

        <h5>Valid Usage</h5>
        <ul>
            <li>If pCode is a pointer to SPIR-V code, {@code codeSize} <b>must</b> be a multiple of 4</li>
            <li>If pCode is a pointer to SPIR-V code, {@code pCode} <b>must</b> point to valid SPIR-V code, formatted and packed as described by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirv-spec">Khronos SPIR-V Specification</a></li>
            <li>If pCode is a pointer to SPIR-V code, {@code pCode} <b>must</b> adhere to the validation rules described by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirvenv-module-validation">Validation Rules within a Module</a> section of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirvenv-capabilities">SPIR-V Environment</a> appendix</li>
            <li>If pCode is a pointer to SPIR-V code, {@code pCode} <b>must</b> declare the {@code Shader} capability for SPIR-V code</li>
            <li>If pCode is a pointer to SPIR-V code, {@code pCode} <b>must</b> not declare any capability that is not supported by the API, as described by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirvenv-module-validation">Capabilities</a> section of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirvenv-capabilities">SPIR-V Environment</a> appendix</li>
            <li>If pCode is a pointer to SPIR-V code, and {@code pCode} declares any of the capabilities listed in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirvenv-capabilities-table">SPIR-V Environment</a> appendix, one of the corresponding requirements <b>must</b> be satisfied</li>
            <li>If pCode is a pointer to SPIR-V code, {@code pCode} <b>must</b> not declare any SPIR-V extension that is not supported by the API, as described by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirvenv-extensions">Extension</a> section of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirvenv-capabilities">SPIR-V Environment</a> appendix</li>
            <li>If pCode is a pointer to SPIR-V code, and {@code pCode} declares any of the SPIR-V extensions listed in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirvenv-extensions-table">SPIR-V Environment</a> appendix, one of the corresponding requirements <b>must</b> be satisfied</li>
            <li>If the {@link NVGLSLShader VK_NV_glsl_shader} extension is not enabled, {@code pCode} <b>must</b> be a pointer to SPIR-V code</li>
            <li>If {@code pCode} is a pointer to GLSL code, it <b>must</b> be valid GLSL code written to the {@code GL_KHR_vulkan_glsl} GLSL extension specification</li>
            <li>{@code codeSize} <b>must</b> be greater than 0</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code pCode} <b>must</b> be a valid pointer to an array of {@code codeSize / 4} {@code uint32_t} values</li>
        </ul>

        <h5>See Also</h5>
        #CreateShaderModule(), #GetShaderModuleCreateInfoIdentifierEXT()
        """

    Expression("#STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkShaderModuleValidationCacheCreateInfoEXT", "VkValidationFeaturesEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkShaderModuleCreateFlags("flags", "reserved for future use.")
    size_t("codeSize", "the size, in bytes, of the code pointed to by {@code pCode}.")
    uint32_t.const.p("pCode", "a pointer to code that is used to create the shader module. The type and format of the code is determined from the content of the memory addressed by {@code pCode}.")
}

val VkPipelineCacheCreateInfo = struct(Module.VULKAN, "VkPipelineCacheCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline cache.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code initialDataSize} is not 0, it <b>must</b> be equal to the size of {@code pInitialData}, as returned by {@code vkGetPipelineCacheData} when {@code pInitialData} was originally retrieved</li>
            <li>If {@code initialDataSize} is not 0, {@code pInitialData} <b>must</b> have been retrieved from a previous call to {@code vkGetPipelineCacheData}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineCreationCacheControl">{@code pipelineCreationCacheControl}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkPipelineCacheCreateFlagBits} values</li>
            <li>If {@code initialDataSize} is not 0, {@code pInitialData} <b>must</b> be a valid pointer to an array of {@code initialDataSize} bytes</li>
        </ul>

        <h5>See Also</h5>
        #CreatePipelineCache()
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCacheCreateFlags("flags", "a bitmask of {@code VkPipelineCacheCreateFlagBits} specifying the behavior of the pipeline cache.")
    AutoSize("pInitialData", optional = true)..size_t("initialDataSize", "the number of bytes in {@code pInitialData}. If {@code initialDataSize} is zero, the pipeline cache will initially be empty.")
    void.const.p("pInitialData", "a pointer to previously retrieved pipeline cache data. If the pipeline cache data is incompatible (as defined below) with the device, the pipeline cache will be initially empty. If {@code initialDataSize} is zero, {@code pInitialData} is ignored.")
}

val VkSpecializationMapEntry = struct(Module.VULKAN, "VkSpecializationMapEntry") {
    documentation =
        """
        Structure specifying a specialization map entry.

        <h5>Description</h5>
        If a {@code constantID} value is not a specialization constant ID used in the shader, that map entry does not affect the behavior of the pipeline.

        <h5>Valid Usage</h5>
        <ul>
            <li>For a {@code constantID} specialization constant declared in a shader, {@code size} <b>must</b> match the byte size of the {@code constantID}. If the specialization constant is of type {@code boolean}, {@code size} <b>must</b> be the byte size of {@code VkBool32}</li>
        </ul>

        <h5>See Also</h5>
        ##VkSpecializationInfo
        """

    uint32_t("constantID", "the ID of the specialization constant in SPIR-V.")
    uint32_t("offset", "the byte offset of the specialization constant value within the supplied data buffer.")
    size_t("size", "the byte size of the specialization constant value within the supplied data buffer.")
}

val VkSpecializationInfo = struct(Module.VULKAN, "VkSpecializationInfo") {
    documentation =
        """
        Structure specifying specialization information.

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code offset} member of each element of {@code pMapEntries} <b>must</b> be less than {@code dataSize}</li>
            <li>The {@code size} member of each element of {@code pMapEntries} <b>must</b> be less than or equal to {@code dataSize} minus {@code offset}</li>
            <li>The {@code constantID} value of each element of {@code pMapEntries} <b>must</b> be unique within {@code pMapEntries}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>If {@code mapEntryCount} is not 0, {@code pMapEntries} <b>must</b> be a valid pointer to an array of {@code mapEntryCount} valid ##VkSpecializationMapEntry structures</li>
            <li>If {@code dataSize} is not 0, {@code pData} <b>must</b> be a valid pointer to an array of {@code dataSize} bytes</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineShaderStageCreateInfo, ##VkShaderCreateInfoEXT, ##VkSpecializationMapEntry
        """

    AutoSize("pMapEntries", optional = true)..uint32_t("mapEntryCount", "the number of entries in the {@code pMapEntries} array.")
    VkSpecializationMapEntry.const.p("pMapEntries", "a pointer to an array of ##VkSpecializationMapEntry structures, which map constant IDs to offsets in {@code pData}.")
    AutoSize("pData", optional = true)..size_t("dataSize", "the byte size of the {@code pData} buffer.")
    void.const.p("pData", "contains the actual constant values to specialize with.")
}

val VkPipelineShaderStageCreateInfo = struct(Module.VULKAN, "VkPipelineShaderStageCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline shader stage.

        <h5>Description</h5>
        If {@code module} is not #NULL_HANDLE, the shader code used by the pipeline is defined by {@code module}. If {@code module} is #NULL_HANDLE, the shader code is defined by the chained ##VkShaderModuleCreateInfo if present.

        If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderModuleIdentifier">{@code shaderModuleIdentifier}</a> feature is enabled, applications <b>can</b> omit shader code for {@code stage} and instead provide a module identifier. This is done by including a ##VkPipelineShaderStageModuleIdentifierCreateInfoEXT struct with {@code identifierSize} not equal to 0 in the {@code pNext} chain. A shader stage created in this way is equivalent to one created using a shader module with the same identifier. The identifier allows an implementation to look up a pipeline without consuming a valid SPIR-V module. If a pipeline is not found, pipeline compilation is not possible and the implementation <b>must</b> fail as specified by #PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT.

        When an identifier is used in lieu of a shader module, implementations <b>may</b> fail pipeline compilation with #PIPELINE_COMPILE_REQUIRED for any reason.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The rationale for the relaxed requirement on implementations to return a pipeline with ##VkPipelineShaderStageModuleIdentifierCreateInfoEXT is that layers or tools may intercept pipeline creation calls and require the full SPIR-V context to operate correctly. ICDs are not expected to fail pipeline compilation if the pipeline exists in a cache somewhere.
        </div>

        Applications <b>can</b> use identifiers when creating pipelines with #PIPELINE_CREATE_LIBRARY_BIT_KHR. When creating such pipelines, #SUCCESS <b>may</b> be returned, but subsequently fail when referencing the pipeline in a ##VkPipelineLibraryCreateInfoKHR struct. Applications <b>must</b> allow pipeline compilation to fail during link steps with #PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT as it <b>may</b> not be possible to determine if a pipeline <b>can</b> be created from identifiers until the link step.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-geometryShader">{@code geometryShader}</a> feature is not enabled, {@code stage} <b>must</b> not be #SHADER_STAGE_GEOMETRY_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-tessellationShader">{@code tessellationShader}</a> feature is not enabled, {@code stage} <b>must</b> not be #SHADER_STAGE_TESSELLATION_CONTROL_BIT or #SHADER_STAGE_TESSELLATION_EVALUATION_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-meshShader">{@code meshShaders}</a> feature is not enabled, {@code stage} <b>must</b> not be #SHADER_STAGE_MESH_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-taskShader">{@code taskShaders}</a> feature is not enabled, {@code stage} <b>must</b> not be #SHADER_STAGE_TASK_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-clustercullingShader">{@code clustercullingShader}</a> feature is not enabled, {@code stage} <b>must</b> not be #SHADER_STAGE_CLUSTER_CULLING_BIT_HUAWEI</li>
            <li>{@code stage} <b>must</b> not be #SHADER_STAGE_ALL_GRAPHICS, or #SHADER_STAGE_ALL</li>
            <li>{@code pName} <b>must</b> be the name of an {@code OpEntryPoint} in {@code module} with an execution model that matches {@code stage}</li>
            <li>If the identified entry point includes any variable in its interface that is declared with the {@code ClipDistance} {@code BuiltIn} decoration, that variable <b>must</b> not have an array size greater than ##VkPhysicalDeviceLimits{@code ::maxClipDistances}</li>
            <li>If the identified entry point includes any variable in its interface that is declared with the {@code CullDistance} {@code BuiltIn} decoration, that variable <b>must</b> not have an array size greater than ##VkPhysicalDeviceLimits{@code ::maxCullDistances}</li>
            <li>If the identified entry point includes variables in its interface that are declared with the {@code ClipDistance} {@code BuiltIn} decoration and variables in its interface that are declared with the {@code CullDistance} {@code BuiltIn} decoration, those variables <b>must</b> not have array sizes which sum to more than ##VkPhysicalDeviceLimits{@code ::maxCombinedClipAndCullDistances}</li>
            <li>If the identified entry point includes any variable in its interface that is declared with the {@code SampleMask} {@code BuiltIn} decoration, that variable <b>must</b> not have an array size greater than ##VkPhysicalDeviceLimits{@code ::maxSampleMaskWords}</li>
            <li>If {@code stage} is #SHADER_STAGE_TESSELLATION_CONTROL_BIT or #SHADER_STAGE_TESSELLATION_EVALUATION_BIT, and the identified entry point has an {@code OpExecutionMode} instruction specifying a patch size with {@code OutputVertices}, the patch size <b>must</b> be greater than 0 and less than or equal to ##VkPhysicalDeviceLimits{@code ::maxTessellationPatchSize}</li>
            <li>If {@code stage} is #SHADER_STAGE_GEOMETRY_BIT, the identified entry point <b>must</b> have an {@code OpExecutionMode} instruction specifying a maximum output vertex count that is greater than 0 and less than or equal to ##VkPhysicalDeviceLimits{@code ::maxGeometryOutputVertices}</li>
            <li>If {@code stage} is #SHADER_STAGE_GEOMETRY_BIT, the identified entry point <b>must</b> have an {@code OpExecutionMode} instruction specifying an invocation count that is greater than 0 and less than or equal to ##VkPhysicalDeviceLimits{@code ::maxGeometryShaderInvocations}</li>
            <li>If {@code stage} is either #SHADER_STAGE_VERTEX_BIT, #SHADER_STAGE_TESSELLATION_CONTROL_BIT, #SHADER_STAGE_TESSELLATION_EVALUATION_BIT, or #SHADER_STAGE_GEOMETRY_BIT, and the identified entry point writes to {@code Layer} for any primitive, it <b>must</b> write the same value to {@code Layer} for all vertices of a given primitive</li>
            <li>If {@code stage} is either #SHADER_STAGE_VERTEX_BIT, #SHADER_STAGE_TESSELLATION_CONTROL_BIT, #SHADER_STAGE_TESSELLATION_EVALUATION_BIT, or #SHADER_STAGE_GEOMETRY_BIT, and the identified entry point writes to {@code ViewportIndex} for any primitive, it <b>must</b> write the same value to {@code ViewportIndex} for all vertices of a given primitive</li>
            <li>If {@code stage} is #SHADER_STAGE_FRAGMENT_BIT, and the identified entry point writes to {@code FragDepth} in any execution path, all execution paths that are not exclusive to helper invocations <b>must</b> either discard the fragment, or write or initialize the value of {@code FragDepth}</li>
            <li>If {@code stage} is #SHADER_STAGE_FRAGMENT_BIT, and the identified entry point writes to {@code FragStencilRefEXT} in any execution path, all execution paths that are not exclusive to helper invocations <b>must</b> either discard the fragment, or write or initialize the value of {@code FragStencilRefEXT}</li>
            <li>If {@code flags} has the #PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT flag set, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-subgroupSizeControl">{@code subgroupSizeControl}</a> feature <b>must</b> be enabled</li>
            <li>If {@code flags} has the #PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT flag set, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-computeFullSubgroups">{@code computeFullSubgroups}</a> feature <b>must</b> be enabled</li>
            <li>If {@code flags} includes #PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT, {@code stage} <b>must</b> be one of #SHADER_STAGE_MESH_BIT_EXT, #SHADER_STAGE_TASK_BIT_EXT, or #SHADER_STAGE_COMPUTE_BIT</li>
            <li>If a ##VkPipelineShaderStageRequiredSubgroupSizeCreateInfo structure is included in the {@code pNext} chain, {@code flags} <b>must</b> not have the #PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT flag set</li>
            <li>If a ##VkPipelineShaderStageRequiredSubgroupSizeCreateInfo structure is included in the {@code pNext} chain, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-subgroupSizeControl">{@code subgroupSizeControl}</a> feature <b>must</b> be enabled, and {@code stage} <b>must</b> be a valid bit specified in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-requiredSubgroupSizeStages">{@code requiredSubgroupSizeStages}</a></li>
            <li>If a ##VkPipelineShaderStageRequiredSubgroupSizeCreateInfo structure is included in the {@code pNext} chain and {@code stage} is #SHADER_STAGE_COMPUTE_BIT, #SHADER_STAGE_MESH_BIT_EXT, or #SHADER_STAGE_TASK_BIT_EXT, the local workgroup size of the shader <b>must</b> be less than or equal to the product of ##VkPipelineShaderStageRequiredSubgroupSizeCreateInfo{@code ::requiredSubgroupSize} and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxComputeWorkgroupSubgroups">{@code maxComputeWorkgroupSubgroups}</a></li>
            <li>If a ##VkPipelineShaderStageRequiredSubgroupSizeCreateInfo structure is included in the {@code pNext} chain, and {@code flags} has the #PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT flag set, the local workgroup size in the X dimension of the pipeline <b>must</b> be a multiple of ##VkPipelineShaderStageRequiredSubgroupSizeCreateInfo{@code ::requiredSubgroupSize}</li>
            <li>If {@code flags} has both the #PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT and #PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT flags set, the local workgroup size in the X dimension of the pipeline <b>must</b> be a multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxSubgroupSize">{@code maxSubgroupSize}</a></li>
            <li>If {@code flags} has the #PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT flag set and {@code flags} does not have the #PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT flag set and no ##VkPipelineShaderStageRequiredSubgroupSizeCreateInfo structure is included in the {@code pNext} chain, the local workgroup size in the X dimension of the pipeline <b>must</b> be a multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-subgroupSize">{@code subgroupSize}</a></li>
            <li>If {@code module} uses the {@code OpTypeCooperativeMatrixKHR} instruction with a {@code Scope} equal to {@code Subgroup}, then the local workgroup size in the X dimension of the pipeline <b>must</b> be a multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-subgroupSize">{@code subgroupSize}</a></li>
            <li>If {@code module} uses the {@code OpTypeCooperativeMatrixKHR} instruction with a {@code Scope} equal to {@code Workgroup}, then the local workgroup size in the X dimension of the pipeline <b>must</b> be a multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-subgroupSize">{@code subgroupSize}</a> and the total local workgroup size <b>must</b> be a power of two multiple of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-subgroupSize">{@code subgroupSize}</a> and <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-cooperativeMatrixWorkgroupScopeMaxWorkgroupSize">cooperativeMatrixWorkgroupScopeMaxWorkgroupSize</a></li>
            <li>
                If a shader module identifier is not specified for this {@code stage}, {@code module} <b>must</b> be a valid {@code VkShaderModule} , or the {@code pNext} chain of the parent stext:Vk*CreateInfo structure <b>must</b> set ##VkPipelineBinaryInfoKHR{@code ::binaryCount} to a value greater than 0, if none of the following features are enabled:
                <ul>
                    <li><a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-graphicsPipelineLibrary">{@code graphicsPipelineLibrary}</a></li>
                    <li><a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance5">{@code maintenance5}</a></li>
                </ul>
            </li>
            <li>If a shader module identifier is not specified for this {@code stage}, {@code module} <b>must</b> be a valid {@code VkShaderModule}, or there <b>must</b> be a valid ##VkShaderModuleCreateInfo structure in the {@code pNext} chain , or the {@code pNext} chain of the parent stext:Vk*CreateInfo structure <b>must</b> set ##VkPipelineBinaryInfoKHR{@code ::binaryCount} to a value greater than 0,</li>
            <li>If a shader module identifier is specified for this {@code stage}, the {@code pNext} chain <b>must</b> not include a ##VkShaderModuleCreateInfo structure</li>
            <li>If a shader module identifier is specified for this {@code stage}, {@code module} <b>must</b> be #NULL_HANDLE</li>
            <li>If a shader module identifier is not specified, the shader code used by the pipeline <b>must</b> be valid as described by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#spirv-spec">Khronos SPIR-V Specification</a> after applying the specializations provided in {@code pSpecializationInfo}, if any, and then converting all specialization constants into fixed constants</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDebugUtilsObjectNameInfoEXT, ##VkPipelineRobustnessCreateInfo, ##VkPipelineShaderStageModuleIdentifierCreateInfoEXT, ##VkPipelineShaderStageNodeCreateInfoAMDX, ##VkPipelineShaderStageRequiredSubgroupSizeCreateInfo, ##VkShaderModuleCreateInfo, or ##VkShaderModuleValidationCacheCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkPipelineShaderStageCreateFlagBits} values</li>
            <li>{@code stage} <b>must</b> be a valid {@code VkShaderStageFlagBits} value</li>
            <li>If {@code module} is not #NULL_HANDLE, {@code module} <b>must</b> be a valid {@code VkShaderModule} handle</li>
            <li>{@code pName} <b>must</b> be a null-terminated UTF-8 string</li>
            <li>If {@code pSpecializationInfo} is not {@code NULL}, {@code pSpecializationInfo} <b>must</b> be a valid pointer to a valid ##VkSpecializationInfo structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkComputePipelineCreateInfo, ##VkExecutionGraphPipelineCreateInfoAMDX, ##VkGraphicsPipelineCreateInfo, ##VkGraphicsShaderGroupCreateInfoNV, ##VkRayTracingPipelineCreateInfoKHR, ##VkRayTracingPipelineCreateInfoNV, ##VkSpecializationInfo
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDebugUtilsObjectNameInfoEXT", "VkPipelineRobustnessCreateInfo", "VkPipelineRobustnessCreateInfoEXT", "VkPipelineShaderStageModuleIdentifierCreateInfoEXT", "VkPipelineShaderStageNodeCreateInfoAMDX", "VkPipelineShaderStageRequiredSubgroupSizeCreateInfo", "VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT", "VkShaderModuleCreateInfo", "VkShaderModuleValidationCacheCreateInfoEXT", "VkShaderRequiredSubgroupSizeCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineShaderStageCreateFlags("flags", "a bitmask of {@code VkPipelineShaderStageCreateFlagBits} specifying how the pipeline shader stage will be generated.")
    VkShaderStageFlagBits("stage", "a {@code VkShaderStageFlagBits} value specifying a single pipeline stage.")
    VkShaderModule("module", "optionally a {@code VkShaderModule} object containing the shader code for this stage.")
    charUTF8.const.p("pName", "a pointer to a null-terminated UTF-8 string specifying the entry point name of the shader for this stage.")
    nullable..VkSpecializationInfo.const.p("pSpecializationInfo", "a pointer to a ##VkSpecializationInfo structure, as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#pipelines-specialization-constants\">Specialization Constants</a>, or {@code NULL}.")
}

val VkComputePipelineCreateInfo = struct(Module.VULKAN, "VkComputePipelineCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created compute pipeline.

        <h5>Description</h5>
        The parameters {@code basePipelineHandle} and {@code basePipelineIndex} are described in more detail in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pipeline-derivatives">Pipeline Derivatives</a>.

        If the {@code pNext} chain includes a ##VkPipelineCreateFlags2CreateInfo structure, ##VkPipelineCreateFlags2CreateInfo{@code ::flags} from that structure is used instead of {@code flags} from this structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain does not include a ##VkPipelineCreateFlags2CreateInfo structure, {@code flags} <b>must</b> be a valid combination of {@code VkPipelineCreateFlagBits} values</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineIndex} is -1, {@code basePipelineHandle} <b>must</b> be a valid compute {@code VkPipeline} handle</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineHandle} is #NULL_HANDLE, {@code basePipelineIndex} <b>must</b> be a valid index into the calling command’s {@code pCreateInfos} parameter</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, {@code basePipelineIndex} <b>must</b> be -1 or {@code basePipelineHandle} <b>must</b> be #NULL_HANDLE</li>
            <li>If a push constant block is declared in a shader, a push constant range in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a push constant block is declared in a shader, the block must be contained inside the push constant range in {@code layout} that matches the stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, the corresponding descriptor set in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, and the descriptor type is not #DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor type</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader as an array, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor count</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variables</a> is declared in a shader as an array of descriptors, then the descriptor type of that variable <b>must</b> not be #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK</li>
        </ul>

        <ul>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-deviceGeneratedComputePipelines">##VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV{@code ::deviceGeneratedComputePipelines}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the {@code pNext} chain <b>must</b> include a pointer to a valid instance of ##VkComputePipelineIndirectBufferInfoNV specifying the address where the pipeline’s metadata will be saved</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-deviceGeneratedCommands">##VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT{@code ::deviceGeneratedCommands}</a> feature <b>must</b> be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineCreationCacheControl">{@code pipelineCreationCacheControl}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or #PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT</li>
            <li>The {@code stage} member of {@code stage} <b>must</b> be #SHADER_STAGE_COMPUTE_BIT</li>
            <li>The shader code for the entry point identified by {@code stage} and the rest of the state identified by this structure <b>must</b> adhere to the pipeline linking rules described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces">Shader Interfaces</a> chapter</li>
            <li>The number of resources in {@code layout} accessible to the compute shader stage <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageResources}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderEnqueue">{@code shaderEnqueue}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_LIBRARY_BIT_KHR</li>
            <li>If {@code flags} does not include #PIPELINE_CREATE_LIBRARY_BIT_KHR, the shader specified by {@code stage} <b>must</b> not declare the {@code ShaderEnqueueAMDX} capability</li>
            <li>If ##VkPipelineCreationFeedbackCreateInfo{@code ::pipelineStageCreationFeedbackCount} is not 0, it <b>must</b> be 1</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkComputePipelineIndirectBufferInfoNV, ##VkPipelineBinaryInfoKHR, ##VkPipelineCompilerControlCreateInfoAMD, ##VkPipelineCreateFlags2CreateInfo, ##VkPipelineCreationFeedbackCreateInfo, ##VkPipelineRobustnessCreateInfo, or ##VkSubpassShadingPipelineCreateInfoHUAWEI</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code stage} <b>must</b> be a valid ##VkPipelineShaderStageCreateInfo structure</li>
            <li>{@code layout} <b>must</b> be a valid {@code VkPipelineLayout} handle</li>
            <li>Both of {@code basePipelineHandle}, and {@code layout} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineShaderStageCreateInfo, #CreateComputePipelines(), #GetPipelineIndirectMemoryRequirementsNV()
        """

    Expression("#STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkComputePipelineIndirectBufferInfoNV", "VkPipelineBinaryInfoKHR", "VkPipelineCompilerControlCreateInfoAMD", "VkPipelineCreateFlags2CreateInfo", "VkPipelineCreateFlags2CreateInfoKHR", "VkPipelineCreationFeedbackCreateInfo", "VkPipelineCreationFeedbackCreateInfoEXT", "VkPipelineRobustnessCreateInfo", "VkPipelineRobustnessCreateInfoEXT", "VkSubpassShadingPipelineCreateInfoHUAWEI",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCreateFlags("flags", "a bitmask of {@code VkPipelineCreateFlagBits} specifying how the pipeline will be generated.")
    VkPipelineShaderStageCreateInfo("stage", "a ##VkPipelineShaderStageCreateInfo structure describing the compute shader.")
    VkPipelineLayout("layout", "the description of binding locations used by both the pipeline and descriptor sets used with the pipeline.")
    VkPipeline("basePipelineHandle", "a pipeline to derive from.")
    int32_t("basePipelineIndex", "an index into the {@code pCreateInfos} parameter to use as a pipeline to derive from.")
}

val VkVertexInputBindingDescription = struct(Module.VULKAN, "VkVertexInputBindingDescription") {
    documentation =
        """
        Structure specifying vertex input binding description.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code binding} <b>must</b> be less than ##VkPhysicalDeviceLimits{@code ::maxVertexInputBindings}</li>
            <li>{@code stride} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxVertexInputBindingStride}</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, {@code stride} <b>must</b> be a multiple of, and at least as large as, ##VkPhysicalDevicePortabilitySubsetPropertiesKHR{@code ::minVertexInputBindingStrideAlignment}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code inputRate} <b>must</b> be a valid {@code VkVertexInputRate} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineVertexInputStateCreateInfo
        """

    uint32_t("binding", "the binding number that this structure describes.")
    uint32_t("stride", "the byte stride between consecutive elements within the buffer.")
    VkVertexInputRate("inputRate", "a {@code VkVertexInputRate} value specifying whether vertex attribute addressing is a function of the vertex index or of the instance index.")
}

val VkVertexInputAttributeDescription = struct(Module.VULKAN, "VkVertexInputAttributeDescription") {
    documentation =
        """
        Structure specifying vertex input attribute description.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code location} <b>must</b> be less than ##VkPhysicalDeviceLimits{@code ::maxVertexInputAttributes}</li>
            <li>{@code binding} <b>must</b> be less than ##VkPhysicalDeviceLimits{@code ::maxVertexInputBindings}</li>
            <li>{@code offset} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxVertexInputAttributeOffset}</li>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-buffer-view-format-features">format features</a> of {@code format} <b>must</b> contain #FORMAT_FEATURE_VERTEX_BUFFER_BIT</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::vertexAttributeAccessBeyondStride} is #FALSE, the sum of {@code offset} plus the size of the vertex attribute data described by {@code format} <b>must</b> not be greater than {@code stride} in the ##VkVertexInputBindingDescription referenced in {@code binding}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code format} <b>must</b> be a valid {@code VkFormat} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineVertexInputStateCreateInfo
        """

    uint32_t("location", "the shader input location number for this attribute.")
    uint32_t("binding", "the binding number which this attribute takes its data from.")
    VkFormat("format", "the size and type of the vertex attribute data.")
    uint32_t("offset", "a byte offset of this attribute relative to the start of an element in the vertex input binding.")
}

val VkPipelineVertexInputStateCreateInfo = struct(Module.VULKAN, "VkPipelineVertexInputStateCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline vertex input state.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code vertexBindingDescriptionCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxVertexInputBindings}</li>
            <li>{@code vertexAttributeDescriptionCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxVertexInputAttributes}</li>
            <li>For every {@code binding} specified by each element of {@code pVertexAttributeDescriptions}, a ##VkVertexInputBindingDescription <b>must</b> exist in {@code pVertexBindingDescriptions} with the same value of {@code binding}</li>
            <li>All elements of {@code pVertexBindingDescriptions} <b>must</b> describe distinct binding numbers</li>
            <li>All elements of {@code pVertexAttributeDescriptions} <b>must</b> describe distinct attribute locations</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkPipelineVertexInputDivisorStateCreateInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>If {@code vertexBindingDescriptionCount} is not 0, {@code pVertexBindingDescriptions} <b>must</b> be a valid pointer to an array of {@code vertexBindingDescriptionCount} valid ##VkVertexInputBindingDescription structures</li>
            <li>If {@code vertexAttributeDescriptionCount} is not 0, {@code pVertexAttributeDescriptions} <b>must</b> be a valid pointer to an array of {@code vertexAttributeDescriptionCount} valid ##VkVertexInputAttributeDescription structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkGraphicsPipelineCreateInfo, ##VkGraphicsShaderGroupCreateInfoNV, ##VkVertexInputAttributeDescription, ##VkVertexInputBindingDescription
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkPipelineVertexInputDivisorStateCreateInfo", "VkPipelineVertexInputDivisorStateCreateInfoEXT", "VkPipelineVertexInputDivisorStateCreateInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineVertexInputStateCreateFlags("flags", "reserved for future use.")
    AutoSize("pVertexBindingDescriptions", optional = true)..uint32_t("vertexBindingDescriptionCount", "the number of vertex binding descriptions provided in {@code pVertexBindingDescriptions}.")
    VkVertexInputBindingDescription.const.p("pVertexBindingDescriptions", "a pointer to an array of ##VkVertexInputBindingDescription structures.")
    AutoSize("pVertexAttributeDescriptions", optional = true)..uint32_t("vertexAttributeDescriptionCount", "the number of vertex attribute descriptions provided in {@code pVertexAttributeDescriptions}.")
    VkVertexInputAttributeDescription.const.p("pVertexAttributeDescriptions", "a pointer to an array of ##VkVertexInputAttributeDescription structures.")
}

val VkPipelineInputAssemblyStateCreateInfo = struct(Module.VULKAN, "VkPipelineInputAssemblyStateCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline input assembly state.

        <h5>Description</h5>
        Restarting the assembly of primitives discards the most recent index values if those elements formed an incomplete primitive, and restarts the primitive assembly using the subsequent indices, but only assembling the immediately following element through the end of the originally specified elements. The primitive restart index value comparison is performed before adding the {@code vertexOffset} value to the index value.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-primitiveTopologyListRestart">{@code primitiveTopologyListRestart}</a> feature is not enabled, and {@code topology} is #PRIMITIVE_TOPOLOGY_POINT_LIST, #PRIMITIVE_TOPOLOGY_LINE_LIST, #PRIMITIVE_TOPOLOGY_TRIANGLE_LIST, #PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY, or #PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY, {@code primitiveRestartEnable} <b>must</b> be #FALSE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-primitiveTopologyPatchListRestart">{@code primitiveTopologyPatchListRestart}</a> feature is not enabled, and {@code topology} is #PRIMITIVE_TOPOLOGY_PATCH_LIST, {@code primitiveRestartEnable} <b>must</b> be #FALSE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-geometryShader">{@code geometryShader}</a> feature is not enabled, {@code topology} <b>must</b> not be any of #PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY, #PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY, #PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY or #PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-tessellationShader">{@code tessellationShader}</a> feature is not enabled, {@code topology} <b>must</b> not be #PRIMITIVE_TOPOLOGY_PATCH_LIST</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::triangleFans} is #FALSE, {@code topology} <b>must</b> not be #PRIMITIVE_TOPOLOGY_TRIANGLE_FAN</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code topology} <b>must</b> be a valid {@code VkPrimitiveTopology} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkGraphicsPipelineCreateInfo
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineInputAssemblyStateCreateFlags("flags", "reserved for future use.")
    VkPrimitiveTopology("topology", "a {@code VkPrimitiveTopology} defining the primitive topology, as described below.")
    VkBool32("primitiveRestartEnable", "controls whether a special vertex index value is treated as restarting the assembly of primitives. This enable only applies to indexed draws (#CmdDrawIndexed(), #CmdDrawMultiIndexedEXT(), and #CmdDrawIndexedIndirect()), and the special index value is either 0xFFFFFFFF when the {@code indexType} parameter of {@code vkCmdBindIndexBuffer2} or {@code vkCmdBindIndexBuffer} is equal to #INDEX_TYPE_UINT32; 0xFF when {@code indexType} is equal to #INDEX_TYPE_UINT8; or 0xFFFF when {@code indexType} is equal to #INDEX_TYPE_UINT16. Primitive restart is not allowed for “list” topologies, unless one of the features <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-primitiveTopologyPatchListRestart\">{@code primitiveTopologyPatchListRestart}</a> (for #PRIMITIVE_TOPOLOGY_PATCH_LIST) or <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-primitiveTopologyListRestart\">{@code primitiveTopologyListRestart}</a> (for all other list topologies) is enabled.")
}

val VkPipelineTessellationStateCreateInfo = struct(Module.VULKAN, "VkPipelineTessellationStateCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline tessellation state.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code patchControlPoints} <b>must</b> be greater than zero and less than or equal to ##VkPhysicalDeviceLimits{@code ::maxTessellationPatchSize}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkPipelineTessellationDomainOriginStateCreateInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkGraphicsPipelineCreateInfo, ##VkGraphicsShaderGroupCreateInfoNV
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkPipelineTessellationDomainOriginStateCreateInfo", "VkPipelineTessellationDomainOriginStateCreateInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineTessellationStateCreateFlags("flags", "reserved for future use.")
    uint32_t("patchControlPoints", "the number of control points per patch.")
}

val VkViewport = struct(Module.VULKAN, "VkViewport") {
    documentation =
        """
        Structure specifying a viewport.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Despite their names, {@code minDepth} <b>can</b> be less than, equal to, or greater than {@code maxDepth}.
        </div>

        The framebuffer depth coordinate <code>z<sub>f</sub></code> <b>may</b> be represented using either a fixed-point or floating-point representation. However, a floating-point representation <b>must</b> be used if the depth/stencil attachment has a floating-point depth component. If an <code>m</code>-bit fixed-point representation is used, we assume that it represents each value <code>k / (2<sup>m</sup> - 1)</code>, where <code>k ∈ { 0, 1, …​, 2<sup>m</sup>-1 }</code>, as <code>k</code> (e.g. 1.0 is represented in binary as a string of all ones).

        The viewport parameters shown in the above equations are found from these values as

        <dl>
            <dd><code>o<sub>x</sub> = x + width / 2</code></dd>

            <dd><code>o<sub>y</sub> = y + height / 2</code></dd>

            <dd><code>o<sub>z</sub> = minDepth</code> (or <code>(maxDepth + minDepth) / 2</code> if ##VkPipelineViewportDepthClipControlCreateInfoEXT{@code ::negativeOneToOne} is #TRUE)</dd>

            <dd><code>p<sub>x</sub> = width</code></dd>

            <dd><code>p<sub>y</sub> = height</code></dd>

            <dd><code>p<sub>z</sub> = maxDepth - minDepth</code> (or <code>(maxDepth - minDepth) / 2</code> if ##VkPipelineViewportDepthClipControlCreateInfoEXT{@code ::negativeOneToOne} is #TRUE)</dd>
        </dl>

        If a render pass transform is enabled, the values <code>(p<sub>x</sub>,p<sub>y</sub>)</code> and <code>(o<sub>x</sub>, o<sub>y</sub>)</code> defining the viewport are transformed as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#vertexpostproc-renderpass-transform">render pass transform</a> before participating in the viewport transform.

        The application <b>can</b> specify a negative term for {@code height}, which has the effect of negating the y coordinate in clip space before performing the transform. When using a negative {@code height}, the application <b>should</b> also adjust the {@code y} value to point to the lower left corner of the viewport instead of the upper left corner. Using the negative {@code height} allows the application to avoid having to negate the y component of the {@code Position} output from the last <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader stage</a>.

        The width and height of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxViewportDimensions">implementation-dependent maximum viewport dimensions</a> <b>must</b> be greater than or equal to the width and height of the largest image which <b>can</b> be created and attached to a framebuffer.

        The floating-point viewport bounds are represented with an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-viewportSubPixelBits">implementation-dependent precision</a>.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code width} <b>must</b> be greater than {@code 0.0}</li>
            <li>{@code width} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxViewportDimensions}[0]</li>
            <li>If the {@link KHRMaintenance1 VK_KHR_maintenance1} extension is not enabled, the {@link AMDNegativeViewportHeight VK_AMD_negative_viewport_height} extension is not enabled, and ##VkPhysicalDeviceProperties{@code ::apiVersion} is less than Vulkan 1.1, {@code height} <b>must</b> be greater than {@code 0.0}</li>
            <li>The absolute value of {@code height} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxViewportDimensions}[1]</li>
            <li>{@code x} <b>must</b> be greater than or equal to {@code viewportBoundsRange}[0]</li>
            <li><code>(x + width)</code> <b>must</b> be less than or equal to {@code viewportBoundsRange}[1]</li>
            <li>{@code y} <b>must</b> be greater than or equal to {@code viewportBoundsRange}[0]</li>
            <li>{@code y} <b>must</b> be less than or equal to {@code viewportBoundsRange}[1]</li>
            <li><code>(y + height)</code> <b>must</b> be greater than or equal to {@code viewportBoundsRange}[0]</li>
            <li><code>(y + height)</code> <b>must</b> be less than or equal to {@code viewportBoundsRange}[1]</li>
            <li>If the {@link EXTDepthRangeUnrestricted VK_EXT_depth_range_unrestricted} extension is not enabled, {@code minDepth} <b>must</b> be between {@code 0.0} and {@code 1.0}, inclusive</li>
            <li>If the {@link EXTDepthRangeUnrestricted VK_EXT_depth_range_unrestricted} extension is not enabled, {@code maxDepth} <b>must</b> be between {@code 0.0} and {@code 1.0}, inclusive</li>
        </ul>

        <h5>See Also</h5>
        ##VkCommandBufferInheritanceViewportScissorInfoNV, ##VkPipelineViewportStateCreateInfo, #CmdSetViewport(), #CmdSetViewportWithCount(), #CmdSetViewportWithCountEXT()
        """

    float("x", "{@code x} and {@code y} are the viewport’s upper left corner <code>(x,y)</code>.")
    float("y", "see {@code x}")
    float("width", "{@code width} and {@code height} are the viewport’s width and height, respectively.")
    float("height", "see {@code width}")
    float("minDepth", "{@code minDepth} and {@code maxDepth} are the depth range for the viewport.")
    float("maxDepth", "see {@code minDepth}")
}

val VkPipelineViewportStateCreateInfo = struct(Module.VULKAN, "VkPipelineViewportStateCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline viewport state.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiViewport">{@code multiViewport}</a> feature is not enabled, {@code viewportCount} <b>must</b> not be greater than 1</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiViewport">{@code multiViewport}</a> feature is not enabled, {@code scissorCount} <b>must</b> not be greater than 1</li>
            <li>{@code viewportCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxViewports}</li>
            <li>{@code scissorCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxViewports}</li>
            <li>The {@code x} and {@code y} members of {@code offset} member of any element of {@code pScissors} <b>must</b> be greater than or equal to 0</li>
            <li>Evaluation of <code>(offset.x + extent.width)</code> <b>must</b> not cause a signed integer addition overflow for any element of {@code pScissors}</li>
            <li>Evaluation of <code>(offset.y + extent.height)</code> <b>must</b> not cause a signed integer addition overflow for any element of {@code pScissors}</li>
            <li>If {@code scissorCount} and {@code viewportCount} are both not dynamic, then {@code scissorCount} and {@code viewportCount} <b>must</b> be identical</li>
            <li>If the graphics pipeline is being created with #DYNAMIC_STATE_VIEWPORT_WITH_COUNT set then {@code viewportCount} <b>must</b> be 0, otherwise {@code viewportCount} <b>must</b> be greater than 0</li>
            <li>If the graphics pipeline is being created with #DYNAMIC_STATE_SCISSOR_WITH_COUNT set then {@code scissorCount} <b>must</b> be 0, otherwise {@code scissorCount} <b>must</b> be greater than 0</li>
            <li>If the {@code viewportWScalingEnable} member of a ##VkPipelineViewportWScalingStateCreateInfoNV structure included in the {@code pNext} chain is #TRUE, the {@code viewportCount} member of the ##VkPipelineViewportWScalingStateCreateInfoNV structure <b>must</b> be greater than or equal to ##VkPipelineViewportStateCreateInfo{@code ::viewportCount}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkPipelineViewportCoarseSampleOrderStateCreateInfoNV, ##VkPipelineViewportDepthClampControlCreateInfoEXT, ##VkPipelineViewportDepthClipControlCreateInfoEXT, ##VkPipelineViewportExclusiveScissorStateCreateInfoNV, ##VkPipelineViewportShadingRateImageStateCreateInfoNV, ##VkPipelineViewportSwizzleStateCreateInfoNV, or ##VkPipelineViewportWScalingStateCreateInfoNV</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkGraphicsPipelineCreateInfo, ##VkRect2D, ##VkViewport
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkPipelineViewportCoarseSampleOrderStateCreateInfoNV", "VkPipelineViewportDepthClampControlCreateInfoEXT", "VkPipelineViewportDepthClipControlCreateInfoEXT", "VkPipelineViewportExclusiveScissorStateCreateInfoNV", "VkPipelineViewportShadingRateImageStateCreateInfoNV", "VkPipelineViewportSwizzleStateCreateInfoNV", "VkPipelineViewportWScalingStateCreateInfoNV",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineViewportStateCreateFlags("flags", "reserved for future use.")
    AutoSize("pViewports", optional = true)..uint32_t("viewportCount", "the number of viewports used by the pipeline.")
    nullable..VkViewport.const.p("pViewports", "a pointer to an array of ##VkViewport structures, defining the viewport transforms. If the viewport state is dynamic, this member is ignored.")
    AutoSize("pScissors", optional = true)..uint32_t("scissorCount", "the number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-scissor\">scissors</a> and <b>must</b> match the number of viewports.")
    nullable..VkRect2D.const.p("pScissors", "a pointer to an array of ##VkRect2D structures defining the rectangular bounds of the scissor for the corresponding viewport. If the scissor state is dynamic, this member is ignored.")
}

val VkPipelineRasterizationStateCreateInfo = struct(Module.VULKAN, "VkPipelineRasterizationStateCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline rasterization state.

        <h5>Description</h5>
        The application <b>can</b> also add a ##VkPipelineRasterizationStateRasterizationOrderAMD structure to the {@code pNext} chain of a ##VkPipelineRasterizationStateCreateInfo structure. This structure enables selecting the rasterization order to use when rendering with the corresponding graphics pipeline as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-order">Rasterization Order</a>.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-depthClamp">{@code depthClamp}</a> feature is not enabled, {@code depthClampEnable} <b>must</b> be #FALSE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fillModeNonSolid">{@code fillModeNonSolid}</a> feature is not enabled, {@code polygonMode} <b>must</b> be #POLYGON_MODE_FILL or #POLYGON_MODE_FILL_RECTANGLE_NV</li>
            <li>If the {@link NVFillRectangle VK_NV_fill_rectangle} extension is not enabled, {@code polygonMode} <b>must</b> not be #POLYGON_MODE_FILL_RECTANGLE_NV</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::pointPolygons} is #FALSE, and {@code rasterizerDiscardEnable} is #FALSE, {@code polygonMode} <b>must</b> not be #POLYGON_MODE_POINT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDepthBiasRepresentationInfoEXT, ##VkPipelineRasterizationConservativeStateCreateInfoEXT, ##VkPipelineRasterizationDepthClipStateCreateInfoEXT, ##VkPipelineRasterizationLineStateCreateInfo, ##VkPipelineRasterizationProvokingVertexStateCreateInfoEXT, ##VkPipelineRasterizationStateRasterizationOrderAMD, or ##VkPipelineRasterizationStateStreamCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code polygonMode} <b>must</b> be a valid {@code VkPolygonMode} value</li>
            <li>{@code cullMode} <b>must</b> be a valid combination of {@code VkCullModeFlagBits} values</li>
            <li>{@code frontFace} <b>must</b> be a valid {@code VkFrontFace} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkGraphicsPipelineCreateInfo
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDepthBiasRepresentationInfoEXT", "VkPipelineRasterizationConservativeStateCreateInfoEXT", "VkPipelineRasterizationDepthClipStateCreateInfoEXT", "VkPipelineRasterizationLineStateCreateInfo", "VkPipelineRasterizationLineStateCreateInfoEXT", "VkPipelineRasterizationLineStateCreateInfoKHR", "VkPipelineRasterizationProvokingVertexStateCreateInfoEXT", "VkPipelineRasterizationStateRasterizationOrderAMD", "VkPipelineRasterizationStateStreamCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineRasterizationStateCreateFlags("flags", "reserved for future use.")
    VkBool32("depthClampEnable", "controls whether to clamp the fragment’s depth values as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-depth\">Depth Test</a>. If the pipeline is not created with ##VkPipelineRasterizationDepthClipStateCreateInfoEXT present then enabling depth clamp will also disable clipping primitives to the z planes of the frustum as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#vertexpostproc-clipping\">Primitive Clipping</a>. Otherwise depth clipping is controlled by the state set in ##VkPipelineRasterizationDepthClipStateCreateInfoEXT.")
    VkBool32("rasterizerDiscardEnable", "controls whether primitives are discarded immediately before the rasterization stage.")
    VkPolygonMode("polygonMode", "the triangle rendering mode. See {@code VkPolygonMode}.")
    VkCullModeFlags("cullMode", "the triangle facing direction used for primitive culling. See {@code VkCullModeFlagBits}.")
    VkFrontFace("frontFace", "a {@code VkFrontFace} value specifying the front-facing triangle orientation to be used for culling.")
    VkBool32("depthBiasEnable", "controls whether to bias fragment depth values.")
    float("depthBiasConstantFactor", "a scalar factor controlling the constant depth value added to each fragment.")
    float("depthBiasClamp", "the maximum (or minimum) depth bias of a fragment.")
    float("depthBiasSlopeFactor", "a scalar factor applied to a fragment’s slope in depth bias calculations.")
    float("lineWidth", "the width of rasterized line segments.")
}

val VkPipelineMultisampleStateCreateInfo = struct(Module.VULKAN, "VkPipelineMultisampleStateCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline multisample state.

        <h5>Description</h5>
        Each bit in the sample mask is associated with a unique <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-multisampling-coverage-mask">sample index</a> as defined for the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-multisampling-coverage-mask">coverage mask</a>. Each bit <code>b</code> for mask word <code>w</code> in the sample mask corresponds to sample index <code>i</code>, where <code>i = 32 × w + b</code>. {@code pSampleMask} has a length equal to <code>⌈ rasterizationSamples / 32 ⌉</code> words.

        If {@code pSampleMask} is {@code NULL}, it is treated as if the mask has all bits set to 1.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sampleRateShading">{@code sampleRateShading}</a> feature is not enabled, {@code sampleShadingEnable} <b>must</b> be #FALSE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-alphaToOne">{@code alphaToOne}</a> feature is not enabled, {@code alphaToOneEnable} <b>must</b> be #FALSE</li>
            <li>{@code minSampleShading} <b>must</b> be in the range <code>[0,1]</code></li>
            <li>If the {@link NVFramebufferMixedSamples VK_NV_framebuffer_mixed_samples} extension is enabled, and if the subpass has any color attachments and {@code rasterizationSamples} is greater than the number of color samples, then {@code sampleShadingEnable} <b>must</b> be #FALSE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkPipelineCoverageModulationStateCreateInfoNV, ##VkPipelineCoverageReductionStateCreateInfoNV, ##VkPipelineCoverageToColorStateCreateInfoNV, or ##VkPipelineSampleLocationsStateCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code rasterizationSamples} <b>must</b> be a valid {@code VkSampleCountFlagBits} value</li>
            <li>If {@code pSampleMask} is not {@code NULL}, {@code pSampleMask} <b>must</b> be a valid pointer to an array of {@code ceil(rasterizationSamples / 32)} {@code VkSampleMask} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkGraphicsPipelineCreateInfo
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkPipelineCoverageModulationStateCreateInfoNV", "VkPipelineCoverageReductionStateCreateInfoNV", "VkPipelineCoverageToColorStateCreateInfoNV", "VkPipelineSampleLocationsStateCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineMultisampleStateCreateFlags("flags", "reserved for future use.")
    VkSampleCountFlagBits("rasterizationSamples", "a {@code VkSampleCountFlagBits} value specifying the number of samples used in rasterization. This value is ignored for the purposes of setting the number of samples used in rasterization if the pipeline is created with the #DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT dynamic state set, but if #DYNAMIC_STATE_SAMPLE_MASK_EXT dynamic state is not set, it is still used to define the size of the {@code pSampleMask} array as described below.")
    VkBool32("sampleShadingEnable", "<b>can</b> be used to enable <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-sampleshading\">Sample Shading</a>.")
    float("minSampleShading", "specifies a minimum fraction of sample shading if {@code sampleShadingEnable} is #TRUE.")
    nullable..VkSampleMask.const.p("pSampleMask", "a pointer to an array of {@code VkSampleMask} values used in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-samplemask\">sample mask test</a>.")
    VkBool32("alphaToCoverageEnable", "controls whether a temporary coverage value is generated based on the alpha component of the fragment’s first color output as specified in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-covg\">Multisample Coverage</a> section.")
    VkBool32("alphaToOneEnable", "controls whether the alpha component of the fragment’s first color output is replaced with one as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-covg\">Multisample Coverage</a>.")
}

val VkStencilOpState = struct(Module.VULKAN, "VkStencilOpState") {
    documentation =
        """
        Structure specifying stencil operation state.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code failOp} <b>must</b> be a valid {@code VkStencilOp} value</li>
            <li>{@code passOp} <b>must</b> be a valid {@code VkStencilOp} value</li>
            <li>{@code depthFailOp} <b>must</b> be a valid {@code VkStencilOp} value</li>
            <li>{@code compareOp} <b>must</b> be a valid {@code VkCompareOp} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineDepthStencilStateCreateInfo
        """

    VkStencilOp("failOp", "a {@code VkStencilOp} value specifying the action performed on samples that fail the stencil test.")
    VkStencilOp("passOp", "a {@code VkStencilOp} value specifying the action performed on samples that pass both the depth and stencil tests.")
    VkStencilOp("depthFailOp", "a {@code VkStencilOp} value specifying the action performed on samples that pass the stencil test and fail the depth test.")
    VkCompareOp("compareOp", "a {@code VkCompareOp} value specifying the comparison operator used in the stencil test.")
    uint32_t("compareMask", "selects the bits of the unsigned integer stencil values participating in the stencil test.")
    uint32_t("writeMask", "selects the bits of the unsigned integer stencil values updated by the stencil test in the stencil framebuffer attachment.")
    uint32_t("reference", "an integer stencil reference value that is used in the unsigned stencil comparison.")
}

val VkPipelineDepthStencilStateCreateInfo = struct(Module.VULKAN, "VkPipelineDepthStencilStateCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline depth stencil state.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-depthBounds">{@code depthBounds}</a> feature is not enabled, {@code depthBoundsTestEnable} <b>must</b> be #FALSE</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::separateStencilMaskRef} is #FALSE, and the value of ##VkPipelineDepthStencilStateCreateInfo{@code ::stencilTestEnable} is #TRUE, and the value of ##VkPipelineRasterizationStateCreateInfo{@code ::cullMode} is #CULL_MODE_NONE, the value of {@code reference} in each of the ##VkStencilOpState structs in {@code front} and {@code back} <b>must</b> be the same</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-rasterizationOrderDepthAttachmentAccess">{@code rasterizationOrderDepthAttachmentAccess}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-rasterizationOrderStencilAttachmentAccess">{@code rasterizationOrderStencilAttachmentAccess}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkPipelineDepthStencilStateCreateFlagBits} values</li>
            <li>{@code depthCompareOp} <b>must</b> be a valid {@code VkCompareOp} value</li>
            <li>{@code front} <b>must</b> be a valid ##VkStencilOpState structure</li>
            <li>{@code back} <b>must</b> be a valid ##VkStencilOpState structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkGraphicsPipelineCreateInfo, ##VkStencilOpState
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineDepthStencilStateCreateFlags("flags", "a bitmask of {@code VkPipelineDepthStencilStateCreateFlagBits} specifying additional depth/stencil state information.")
    VkBool32("depthTestEnable", "controls whether <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-depth\">depth testing</a> is enabled.")
    VkBool32("depthWriteEnable", "controls whether <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-depth-write\">depth writes</a> are enabled when {@code depthTestEnable} is #TRUE. Depth writes are always disabled when {@code depthTestEnable} is #FALSE.")
    VkCompareOp("depthCompareOp", "a {@code VkCompareOp} value specifying the comparison operator to use in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-depth-comparison\">Depth Comparison</a> step of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-depth\">depth test</a>.")
    VkBool32("depthBoundsTestEnable", "controls whether <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-dbt\">depth bounds testing</a> is enabled.")
    VkBool32("stencilTestEnable", "controls whether <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-stencil\">stencil testing</a> is enabled.")
    VkStencilOpState("front", "{@code front} and {@code back} are ##VkStencilOpState values controlling the corresponding parameters of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-stencil\">stencil test</a>.")
    VkStencilOpState("back", "see {@code front}")
    float("minDepthBounds", "the minimum depth bound used in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-dbt\">depth bounds test</a>.")
    float("maxDepthBounds", "the maximum depth bound used in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-dbt\">depth bounds test</a>.")
}

val VkPipelineColorBlendAttachmentState = struct(Module.VULKAN, "VkPipelineColorBlendAttachmentState") {
    documentation =
        """
        Structure specifying a pipeline color blend attachment state.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dualSrcBlend">{@code dualSrcBlend}</a> feature is not enabled, {@code srcColorBlendFactor} <b>must</b> not be #BLEND_FACTOR_SRC1_COLOR, #BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, #BLEND_FACTOR_SRC1_ALPHA, or #BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dualSrcBlend">{@code dualSrcBlend}</a> feature is not enabled, {@code dstColorBlendFactor} <b>must</b> not be #BLEND_FACTOR_SRC1_COLOR, #BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, #BLEND_FACTOR_SRC1_ALPHA, or #BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dualSrcBlend">{@code dualSrcBlend}</a> feature is not enabled, {@code srcAlphaBlendFactor} <b>must</b> not be #BLEND_FACTOR_SRC1_COLOR, #BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, #BLEND_FACTOR_SRC1_ALPHA, or #BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dualSrcBlend">{@code dualSrcBlend}</a> feature is not enabled, {@code dstAlphaBlendFactor} <b>must</b> not be #BLEND_FACTOR_SRC1_COLOR, #BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, #BLEND_FACTOR_SRC1_ALPHA, or #BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA</li>
            <li>If either of {@code colorBlendOp} or {@code alphaBlendOp} is an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#framebuffer-blend-advanced">advanced blend operation</a>, then {@code colorBlendOp} <b>must</b> equal {@code alphaBlendOp}</li>
            <li>If ##VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT{@code ::advancedBlendIndependentBlend} is #FALSE and {@code colorBlendOp} is an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#framebuffer-blend-advanced">advanced blend operation</a>, then {@code colorBlendOp} <b>must</b> be the same for all attachments</li>
            <li>If ##VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT{@code ::advancedBlendIndependentBlend} is #FALSE and {@code alphaBlendOp} is an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#framebuffer-blend-advanced">advanced blend operation</a>, then {@code alphaBlendOp} <b>must</b> be the same for all attachments</li>
            <li>If ##VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT{@code ::advancedBlendAllOperations} is #FALSE, then {@code colorBlendOp} <b>must</b> not be #BLEND_OP_ZERO_EXT, #BLEND_OP_SRC_EXT, #BLEND_OP_DST_EXT, #BLEND_OP_SRC_OVER_EXT, #BLEND_OP_DST_OVER_EXT, #BLEND_OP_SRC_IN_EXT, #BLEND_OP_DST_IN_EXT, #BLEND_OP_SRC_OUT_EXT, #BLEND_OP_DST_OUT_EXT, #BLEND_OP_SRC_ATOP_EXT, #BLEND_OP_DST_ATOP_EXT, #BLEND_OP_XOR_EXT, #BLEND_OP_INVERT_EXT, #BLEND_OP_INVERT_RGB_EXT, #BLEND_OP_LINEARDODGE_EXT, #BLEND_OP_LINEARBURN_EXT, #BLEND_OP_VIVIDLIGHT_EXT, #BLEND_OP_LINEARLIGHT_EXT, #BLEND_OP_PINLIGHT_EXT, #BLEND_OP_HARDMIX_EXT, #BLEND_OP_PLUS_EXT, #BLEND_OP_PLUS_CLAMPED_EXT, #BLEND_OP_PLUS_CLAMPED_ALPHA_EXT, #BLEND_OP_PLUS_DARKER_EXT, #BLEND_OP_MINUS_EXT, #BLEND_OP_MINUS_CLAMPED_EXT, #BLEND_OP_CONTRAST_EXT, #BLEND_OP_INVERT_OVG_EXT, #BLEND_OP_RED_EXT, #BLEND_OP_GREEN_EXT, or #BLEND_OP_BLUE_EXT</li>
            <li>If {@code colorBlendOp} or {@code alphaBlendOp} is an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#framebuffer-blend-advanced">advanced blend operation</a>, then {@code colorAttachmentCount} of the subpass this pipeline is compiled against <b>must</b> be less than or equal to ##VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT{@code ::advancedBlendMaxColorAttachments}</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::constantAlphaColorBlendFactors} is #FALSE, {@code srcColorBlendFactor} <b>must</b> not be #BLEND_FACTOR_CONSTANT_ALPHA or #BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::constantAlphaColorBlendFactors} is #FALSE, {@code dstColorBlendFactor} <b>must</b> not be #BLEND_FACTOR_CONSTANT_ALPHA or #BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code srcColorBlendFactor} <b>must</b> be a valid {@code VkBlendFactor} value</li>
            <li>{@code dstColorBlendFactor} <b>must</b> be a valid {@code VkBlendFactor} value</li>
            <li>{@code colorBlendOp} <b>must</b> be a valid {@code VkBlendOp} value</li>
            <li>{@code srcAlphaBlendFactor} <b>must</b> be a valid {@code VkBlendFactor} value</li>
            <li>{@code dstAlphaBlendFactor} <b>must</b> be a valid {@code VkBlendFactor} value</li>
            <li>{@code alphaBlendOp} <b>must</b> be a valid {@code VkBlendOp} value</li>
            <li>{@code colorWriteMask} <b>must</b> be a valid combination of {@code VkColorComponentFlagBits} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineColorBlendStateCreateInfo
        """

    VkBool32("blendEnable", "controls whether blending is enabled for the corresponding color attachment. If blending is not enabled, the source fragment’s color for that attachment is passed through unmodified.")
    VkBlendFactor("srcColorBlendFactor", "selects which blend factor is used to determine the source factors <code>(S<sub>r</sub>,S<sub>g</sub>,S<sub>b</sub>)</code>.")
    VkBlendFactor("dstColorBlendFactor", "selects which blend factor is used to determine the destination factors <code>(D<sub>r</sub>,D<sub>g</sub>,D<sub>b</sub>)</code>.")
    VkBlendOp("colorBlendOp", "selects which blend operation is used to calculate the RGB values to write to the color attachment.")
    VkBlendFactor("srcAlphaBlendFactor", "selects which blend factor is used to determine the source factor <code>S<sub>a</sub></code>.")
    VkBlendFactor("dstAlphaBlendFactor", "selects which blend factor is used to determine the destination factor <code>D<sub>a</sub></code>.")
    VkBlendOp("alphaBlendOp", "selects which blend operation is used to calculate the alpha values to write to the color attachment.")
    VkColorComponentFlags("colorWriteMask", "a bitmask of {@code VkColorComponentFlagBits} specifying which of the R, G, B, and/or A components are enabled for writing, as described for the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#framebuffer-color-write-mask\">Color Write Mask</a>.")
}

val VkPipelineColorBlendStateCreateInfo = struct(Module.VULKAN, "VkPipelineColorBlendStateCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline color blend state.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-independentBlend">{@code independentBlend}</a> feature is not enabled, all elements of {@code pAttachments} <b>must</b> be identical</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-logicOp">{@code logicOp}</a> feature is not enabled, {@code logicOpEnable} <b>must</b> be #FALSE</li>
            <li>If {@code logicOpEnable} is #TRUE, {@code logicOp} <b>must</b> be a valid {@code VkLogicOp} value</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-rasterizationOrderColorAttachmentAccess">{@code rasterizationOrderColorAttachmentAccess}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT</li>
            <li>If {@code attachmentCount} is not 0 , and any of #DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT, #DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT, #DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT, or #DYNAMIC_STATE_COLOR_WRITE_MASK_EXT are not set, {@code pAttachments} <b>must</b> be a valid pointer to an array of {@code attachmentCount} valid ##VkPipelineColorBlendAttachmentState structures</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkPipelineColorBlendAdvancedStateCreateInfoEXT or ##VkPipelineColorWriteCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkPipelineColorBlendStateCreateFlagBits} values</li>
            <li>If {@code attachmentCount} is not 0, and {@code pAttachments} is not {@code NULL}, {@code pAttachments} <b>must</b> be a valid pointer to an array of {@code attachmentCount} valid ##VkPipelineColorBlendAttachmentState structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkGraphicsPipelineCreateInfo, ##VkPipelineColorBlendAttachmentState
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkPipelineColorBlendAdvancedStateCreateInfoEXT", "VkPipelineColorWriteCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineColorBlendStateCreateFlags("flags", "a bitmask of {@code VkPipelineColorBlendStateCreateFlagBits} specifying additional color blending information.")
    VkBool32("logicOpEnable", "controls whether to apply <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#framebuffer-logicop\">Logical Operations</a>.")
    VkLogicOp("logicOp", "selects which logical operation to apply.")
    AutoSize("pAttachments", optional = true)..uint32_t("attachmentCount", "the number of ##VkPipelineColorBlendAttachmentState elements in {@code pAttachments}. It is ignored if the pipeline is created with #DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT, #DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT, and #DYNAMIC_STATE_COLOR_WRITE_MASK_EXT dynamic states set, and either #DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT set or the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-advancedBlendCoherentOperations\">advancedBlendCoherentOperations</a> feature is not enabled.")
    nullable..VkPipelineColorBlendAttachmentState.const.p("pAttachments", "a pointer to an array of ##VkPipelineColorBlendAttachmentState structures defining blend state for each color attachment. It is ignored if the pipeline is created with #DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT, #DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT, and #DYNAMIC_STATE_COLOR_WRITE_MASK_EXT dynamic states set, and either #DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT set or the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-advancedBlendCoherentOperations\">advancedBlendCoherentOperations</a> feature is not enabled.")
    float("blendConstants", "a pointer to an array of four values used as the R, G, B, and A components of the blend constant that are used in blending, depending on the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#framebuffer-blendfactors\">blend factor</a>.")[4]
}

val VkPipelineDynamicStateCreateInfo = struct(Module.VULKAN, "VkPipelineDynamicStateCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline dynamic state.

        <h5>Valid Usage</h5>
        <ul>
            <li>Each element of {@code pDynamicStates} <b>must</b> be unique</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>If {@code dynamicStateCount} is not 0, {@code pDynamicStates} <b>must</b> be a valid pointer to an array of {@code dynamicStateCount} valid {@code VkDynamicState} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkGraphicsPipelineCreateInfo, ##VkRayTracingPipelineCreateInfoKHR
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineDynamicStateCreateFlags("flags", "reserved for future use.")
    AutoSize("pDynamicStates", optional = true)..uint32_t("dynamicStateCount", "the number of elements in the {@code pDynamicStates} array.")
    VkDynamicState.const.p("pDynamicStates", "a pointer to an array of {@code VkDynamicState} values specifying which pieces of pipeline state will use the values from dynamic state commands rather than from pipeline state creation information.")
}

val VkGraphicsPipelineCreateInfo = struct(Module.VULKAN, "VkGraphicsPipelineCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created graphics pipeline.

        <h5>Description</h5>
        The parameters {@code basePipelineHandle} and {@code basePipelineIndex} are described in more detail in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pipeline-derivatives">Pipeline Derivatives</a>.

        If any shader stage fails to compile, the compile log will be reported back to the application, and #ERROR_INVALID_SHADER_NV will be generated.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        With {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3}, it is possible that many of the ##VkGraphicsPipelineCreateInfo members above <b>can</b> be {@code NULL} because all their state is dynamic and therefore ignored. This is optional so the application <b>can</b> still use a valid pointer if it needs to set the {@code pNext} or {@code flags} fields to specify state for other extensions.
        </div>

        The state required for a graphics pipeline is divided into <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output state</a>.

        Vertex input state is defined by:

        <ul>
            <li>##VkPipelineVertexInputStateCreateInfo</li>
            <li>##VkPipelineInputAssemblyStateCreateInfo</li>
        </ul>

        If this pipeline specifies <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization state</a> either directly or by including it as a pipeline library and its {@code pStages} includes a vertex shader, this state <b>must</b> be specified to create a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete graphics pipeline</a>.

        If a pipeline includes #GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT in ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} either explicitly or as a default, and either the conditions requiring this state for a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete graphics pipeline</a> are met or this pipeline does not specify <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization state</a> in any way, that pipeline <b>must</b> specify this state directly.

        Pre-rasterization shader state is defined by:

        <ul>
            <li>
                ##VkPipelineShaderStageCreateInfo entries for:
                <ul>
                    <li>Vertex shaders</li>
                    <li>Tessellation control shaders</li>
                    <li>Tessellation evaluation shaders</li>
                    <li>Geometry shaders</li>
                    <li>Task shaders</li>
                    <li>Mesh shaders</li>
                </ul>
            </li>
            <li>
                Within the {@code VkPipelineLayout}, all descriptor sets with pre-rasterization shader bindings if #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT was specified.
                <ul>
                    <li>If #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT was not specified, the full pipeline layout <b>must</b> be specified.</li>
                </ul>
            </li>
            <li>##VkPipelineViewportStateCreateInfo</li>
            <li>##VkPipelineRasterizationStateCreateInfo</li>
            <li>##VkPipelineTessellationStateCreateInfo</li>
            <li>{@code VkRenderPass} and {@code subpass} parameter</li>
            <li>The {@code viewMask} parameter of ##VkPipelineRenderingCreateInfo (formats are ignored)</li>
            <li>##VkPipelineDiscardRectangleStateCreateInfoEXT</li>
            <li>##VkPipelineFragmentShadingRateStateCreateInfoKHR</li>
        </ul>

        This state <b>must</b> be specified to create a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete graphics pipeline</a>.

        If either the {@code pNext} chain includes a ##VkGraphicsPipelineLibraryCreateInfoEXT structure with #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT included in {@code flags}, or it is not specified and would default to include that value, this state <b>must</b> be specified in the pipeline.

        Fragment shader state is defined by:

        <ul>
            <li>A ##VkPipelineShaderStageCreateInfo entry for the fragment shader</li>
            <li>
                Within the {@code VkPipelineLayout}, all descriptor sets with fragment shader bindings if #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT was specified.
                <ul>
                    <li>If #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT was not specified, the full pipeline layout <b>must</b> be specified.</li>
                </ul>
            </li>
            <li>##VkPipelineMultisampleStateCreateInfo if <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-sampleshading">sample shading</a> is enabled or {@code renderpass} is not #NULL_HANDLE</li>
            <li>##VkPipelineDepthStencilStateCreateInfo</li>
            <li>{@code VkRenderPass} and {@code subpass} parameter</li>
            <li>The {@code viewMask} parameter of ##VkPipelineRenderingCreateInfo (formats are ignored)</li>
            <li>##VkPipelineFragmentShadingRateStateCreateInfoKHR</li>
            <li>##VkPipelineFragmentShadingRateEnumStateCreateInfoNV</li>
            <li>##VkPipelineRepresentativeFragmentTestStateCreateInfoNV</li>
            <li>Inclusion/omission of the #PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR flag</li>
            <li>Inclusion/omission of the #PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT flag</li>
            <li>##VkRenderingInputAttachmentIndexInfo</li>
        </ul>

        If a pipeline specifies <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization state</a> either directly or by including it as a pipeline library and {@code rasterizerDiscardEnable} is #FALSE or #DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE is used, this state <b>must</b> be specified to create a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete graphics pipeline</a>.

        If a pipeline includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT in ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} either explicitly or as a default, and either the conditions requiring this state for a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete graphics pipeline</a> are met or this pipeline does not specify <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization state</a> in any way, that pipeline <b>must</b> specify this state directly.

        Fragment output state is defined by:

        <ul>
            <li>##VkPipelineColorBlendStateCreateInfo</li>
            <li>{@code VkRenderPass} and {@code subpass} parameter</li>
            <li>##VkPipelineMultisampleStateCreateInfo</li>
            <li>##VkPipelineRenderingCreateInfo</li>
            <li>##VkAttachmentSampleCountInfoAMD</li>
            <li>##VkAttachmentSampleCountInfoNV</li>
            <li>##VkExternalFormatANDROID</li>
            <li>Inclusion/omission of the #PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT and #PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT flags</li>
            <li>Inclusion/omission of the #PIPELINE_CREATE_2_ENABLE_LEGACY_DITHERING_BIT_EXT flag</li>
            <li>##VkRenderingAttachmentLocationInfo</li>
        </ul>

        If a pipeline specifies <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization state</a> either directly or by including it as a pipeline library and {@code rasterizerDiscardEnable} is #FALSE or #DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE is used, this state <b>must</b> be specified to create a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete graphics pipeline</a>.

        If a pipeline includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT in ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} either explicitly or as a default, and either the conditions requiring this state for a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete graphics pipeline</a> are met or this pipeline does not specify <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization state</a> in any way, that pipeline <b>must</b> specify this state directly.

        Dynamic state values set via {@code pDynamicState} <b>must</b> be ignored if the state they correspond to is not otherwise statically set by one of the state subsets used to create the pipeline. Additionally, setting dynamic state values <b>must</b> not modify whether state in a linked library is static or dynamic; this is set and unchangeable when the library is created. For example, if a pipeline only included <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, then any dynamic state value corresponding to depth or stencil testing has no effect. Any linked library that has dynamic state enabled that same dynamic state <b>must</b> also be enabled in all the other linked libraries to which that dynamic state applies.

        A complete graphics pipeline always includes <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, with other subsets included depending on that state as specified in the above sections.

        If different subsets are linked together with pipeline layouts created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, the final effective pipeline layout is effectively the union of the linked pipeline layouts. When binding descriptor sets for this pipeline, the pipeline layout used <b>must</b> be compatible with this union. This pipeline layout <b>can</b> be overridden when linking with #PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT by providing a {@code VkPipelineLayout} that is <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-compatibility">compatible</a> with this union other than #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, or when linking without #PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT by providing a {@code VkPipelineLayout} that is fully <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-compatibility">compatible</a> with this union.

        If the {@code pNext} chain includes a ##VkPipelineCreateFlags2CreateInfo structure, ##VkPipelineCreateFlags2CreateInfo{@code ::flags} from that structure is used instead of {@code flags} from this structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain does not include a ##VkPipelineCreateFlags2CreateInfo structure, {@code flags} <b>must</b> be a valid combination of {@code VkPipelineCreateFlagBits} values</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineIndex} is -1, {@code basePipelineHandle} <b>must</b> be a valid graphics {@code VkPipeline} handle</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineHandle} is #NULL_HANDLE, {@code basePipelineIndex} <b>must</b> be a valid index into the calling command’s {@code pCreateInfos} parameter</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, {@code basePipelineIndex} <b>must</b> be -1 or {@code basePipelineHandle} <b>must</b> be #NULL_HANDLE</li>
            <li>If a push constant block is declared in a shader, a push constant range in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a push constant block is declared in a shader, the block must be contained inside the push constant range in {@code layout} that matches the stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, the corresponding descriptor set in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, and the descriptor type is not #DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor type</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader as an array, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor count</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variables</a> is declared in a shader as an array of descriptors, then the descriptor type of that variable <b>must</b> not be #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> the {@code stage} member of one element of {@code pStages} <b>must</b> be #SHADER_STAGE_VERTEX_BIT or #SHADER_STAGE_MESH_BIT_EXT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> the geometric shader stages provided in {@code pStages} <b>must</b> be either from the mesh shading pipeline ({@code stage} is #SHADER_STAGE_TASK_BIT_EXT or #SHADER_STAGE_MESH_BIT_EXT) or from the primitive shading pipeline ({@code stage} is #SHADER_STAGE_VERTEX_BIT, #SHADER_STAGE_TESSELLATION_CONTROL_BIT, #SHADER_STAGE_TESSELLATION_EVALUATION_BIT, or #SHADER_STAGE_GEOMETRY_BIT)</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} contains both #SHADER_STAGE_TASK_BIT_EXT and #SHADER_STAGE_MESH_BIT_EXT, then the mesh shader’s entry point <b>must</b> not declare a variable with a {@code DrawIndex} {@code BuiltIn} decoration</li>
            <li>The shader stages for #SHADER_STAGE_TASK_BIT_EXT or #SHADER_STAGE_MESH_BIT_EXT <b>must</b> use either the {@code TaskNV} and {@code MeshNV} {@code Execution} {@code Model} or the {@code TaskEXT} and {@code MeshEXT} {@code Execution} {@code Model}, but <b>must</b> not use both</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} includes a tessellation control shader stage, it <b>must</b> include a tessellation evaluation shader stage</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} includes a tessellation evaluation shader stage, it <b>must</b> include a tessellation control shader stage</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} includes a tessellation control shader stage, and the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is not enabled or the #DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT dynamic state is not set, {@code pTessellationState} <b>must</b> be a valid pointer to a valid ##VkPipelineTessellationStateCreateInfo structure</li>
            <li>If {@code pTessellationState} is not {@code NULL} it <b>must</b> be a pointer to a valid ##VkPipelineTessellationStateCreateInfo structure</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} includes tessellation shader stages, the shader code of at least one stage <b>must</b> contain an {@code OpExecutionMode} instruction specifying the type of subdivision in the pipeline</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} includes tessellation shader stages, and the shader code of both stages contain an {@code OpExecutionMode} instruction specifying the type of subdivision in the pipeline, they <b>must</b> both specify the same subdivision mode</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} includes tessellation shader stages, the shader code of at least one stage <b>must</b> contain an {@code OpExecutionMode} instruction specifying the output patch size in the pipeline</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} includes tessellation shader stages, and the shader code of both contain an {@code OpExecutionMode} instruction specifying the out patch size in the pipeline, they <b>must</b> both specify the same patch size</li>
            <li>If the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a> and {@code pStages} includes tessellation shader stages, and either #DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-dynamicPrimitiveTopologyUnrestricted">{@code dynamicPrimitiveTopologyUnrestricted}</a> is #FALSE, the {@code topology} member of {@code pInputAssembly} <b>must</b> be #PRIMITIVE_TOPOLOGY_PATCH_LIST</li>
            <li>If the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a> and the {@code topology} member of {@code pInputAssembly} is #PRIMITIVE_TOPOLOGY_PATCH_LIST, and either #DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-dynamicPrimitiveTopologyUnrestricted">{@code dynamicPrimitiveTopologyUnrestricted}</a> is #FALSE, then {@code pStages} <b>must</b> include tessellation shader stages</li>
            <li>If the pipeline is being created with a {@code TessellationEvaluation} {@code Execution} {@code Model}, no {@code Geometry} {@code Execution} {@code Model}, uses the {@code PointMode} {@code Execution} {@code Mode}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderTessellationAndGeometryPointSize">{@code shaderTessellationAndGeometryPointSize}</a> feature is enabled, a {@code PointSize} decorated variable <b>must</b> be written to if the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance5">{@code maintenance5}</a> feature is not enabled</li>
            <li>If the pipeline is being created with a {@code Vertex} {@code Execution} {@code Model} and no {@code TessellationEvaluation} or {@code Geometry} {@code Execution} {@code Model}, and the {@code topology} member of {@code pInputAssembly} is #PRIMITIVE_TOPOLOGY_POINT_LIST, and either #DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-dynamicPrimitiveTopologyUnrestricted">{@code dynamicPrimitiveTopologyUnrestricted}</a> is #FALSE, a {@code PointSize} decorated variable <b>must</b> be written to if the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance5">{@code maintenance5}</a> feature is not enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance5">{@code maintenance5}</a> feature is enabled and a {@code PointSize} decorated variable is written to, all execution paths <b>must</b> write to a {@code PointSize} decorated variable</li>
            <li>If the pipeline is being created with a {@code TessellationEvaluation} {@code Execution} {@code Model}, no {@code Geometry} {@code Execution} {@code Model}, uses the {@code PointMode} {@code Execution} {@code Mode}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderTessellationAndGeometryPointSize">{@code shaderTessellationAndGeometryPointSize}</a> feature is not enabled, a {@code PointSize} decorated variable <b>must</b> not be written to</li>
            <li>If the pipeline is being created with a {@code Geometry} {@code Execution} {@code Model}, uses the {@code OutputPoints} {@code Execution} {@code Mode}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderTessellationAndGeometryPointSize">{@code shaderTessellationAndGeometryPointSize}</a> feature is enabled, a {@code PointSize} decorated variable <b>must</b> be written to for every vertex emitted if the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance5">{@code maintenance5}</a> feature is not enabled</li>
            <li>If the pipeline is being created with a {@code Geometry} {@code Execution} {@code Model}, uses the {@code OutputPoints} {@code Execution} {@code Mode}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderTessellationAndGeometryPointSize">{@code shaderTessellationAndGeometryPointSize}</a> feature is not enabled, a {@code PointSize} decorated variable <b>must</b> not be written to</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} includes a geometry shader stage, and does not include any tessellation shader stages, its shader code <b>must</b> contain an {@code OpExecutionMode} instruction specifying an input primitive type that is <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#shaders-geometry-execution">compatible</a> with the primitive topology specified in {@code pInputAssembly}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code pStages} includes a geometry shader stage, and also includes tessellation shader stages, its shader code <b>must</b> contain an {@code OpExecutionMode} instruction specifying an input primitive type that is <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#shaders-geometry-execution">compatible</a> with the primitive topology that is output by the tessellation stages</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, it includes both a fragment shader and a geometry shader, and the fragment shader code reads from an input variable that is decorated with {@code PrimitiveId}, then the geometry shader code <b>must</b> write to a matching output variable, decorated with {@code PrimitiveId}, in all execution paths</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, it includes a mesh shader and the fragment shader code reads from an input variable that is decorated with {@code PrimitiveId}, then the mesh shader code <b>must</b> write to a matching output variable, decorated with {@code PrimitiveId}, in all execution paths</li>
            <li>If {@code renderPass} is not #NULL_HANDLE and the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> the fragment shader <b>must</b> not read from any input attachment that is defined as #ATTACHMENT_UNUSED in {@code subpass}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and multiple pre-rasterization shader stages are included in {@code pStages}, the shader code for the entry points identified by those {@code pStages} and the rest of the state identified by this structure <b>must</b> adhere to the pipeline linking rules described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces">Shader Interfaces</a> chapter</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, the fragment shader and last <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader stage</a> and any relevant state <b>must</b> adhere to the pipeline linking rules described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces">Shader Interfaces</a> chapter</li>
            <li>If {@code renderPass} is not #NULL_HANDLE, and the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, then for each color attachment in the subpass, if the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> of the format of the corresponding attachment description do not contain #FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT, then the {@code blendEnable} member of the corresponding element of the {@code pAttachments} member of {@code pColorBlendState} <b>must</b> be #FALSE</li>
            <li>If {@code renderPass} is not #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, the {@code pColorBlendState} pointer is not {@code NULL}, the {@code attachmentCount} member of {@code pColorBlendState} is not ignored, and the subpass uses color attachments, the {@code attachmentCount} member of {@code pColorBlendState} <b>must</b> be equal to the {@code colorAttachmentCount} used to create {@code subpass}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and {@code pViewportState→pViewports} is not dynamic, then {@code pViewportState→pViewports} <b>must</b> be a valid pointer to an array of {@code pViewportState→viewportCount} valid ##VkViewport structures</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and {@code pViewportState→pScissors} is not dynamic, then {@code pViewportState→pScissors} <b>must</b> be a valid pointer to an array of {@code pViewportState→scissorCount} ##VkRect2D structures</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-wideLines">{@code wideLines}</a> feature is not enabled, and no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_LINE_WIDTH, the {@code lineWidth} member of {@code pRasterizationState} <b>must</b> be {@code 1.0}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and the #DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE dynamic state is enabled or the {@code rasterizerDiscardEnable} member of {@code pRasterizationState} is #FALSE, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pViewportState-null">related dynamic state is not set</a>, {@code pViewportState} <b>must</b> be a valid pointer to a valid ##VkPipelineViewportStateCreateInfo structure</li>
            <li>If {@code pViewportState} is not {@code NULL} it <b>must</b> be a valid pointer to a valid ##VkPipelineViewportStateCreateInfo structure</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is not enabled or any of the #DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, #DYNAMIC_STATE_SAMPLE_MASK_EXT, or #DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states is not set, or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-alphaToOne">alphaToOne</a> feature is enabled and #DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is not set, {@code pMultisampleState} <b>must</b> be a valid pointer to a valid ##VkPipelineMultisampleStateCreateInfo structure</li>
            <li>If {@code pMultisampleState} is not {@code NULL} it <b>must</b> be a valid pointer to a valid ##VkPipelineMultisampleStateCreateInfo structure</li>
            <li>If the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, the ##VkPipelineMultisampleStateCreateInfo{@code ::alphaToCoverageEnable} is not ignored and is #TRUE, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-fragmentoutput">Fragment Output Interface</a> <b>must</b> contain a variable for the alpha {@code Component} word in {@code Location} 0 at {@code Index} 0</li>
            <li>If {@code renderPass} is not #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and {@code subpass} uses a depth/stencil attachment, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pDepthStencilState-null">related dynamic state is not set</a>, {@code pDepthStencilState} <b>must</b> be a valid pointer to a valid ##VkPipelineDepthStencilStateCreateInfo structure</li>
            <li>If {@code pDepthStencilState} is not {@code NULL} it <b>must</b> be a valid pointer to a valid ##VkPipelineDepthStencilStateCreateInfo structure</li>
            <li>If {@code renderPass} is not #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code subpass} uses color attachments, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pColorBlendState-null">related dynamic state is not set</a>, {@code pColorBlendState} <b>must</b> be a valid pointer to a valid ##VkPipelineColorBlendStateCreateInfo structure</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-depthBiasClamp">{@code depthBiasClamp}</a> feature is not enabled, no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_DEPTH_BIAS, and the {@code depthBiasEnable} member of {@code pRasterizationState} is #TRUE, the {@code depthBiasClamp} member of {@code pRasterizationState} <b>must</b> be {@code 0.0}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, the {@link EXTDepthRangeUnrestricted VK_EXT_depth_range_unrestricted} extension is not enabled and no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_DEPTH_BOUNDS, and the {@code depthBoundsTestEnable} member of {@code pDepthStencilState} is #TRUE, the {@code minDepthBounds} and {@code maxDepthBounds} members of {@code pDepthStencilState} <b>must</b> be between {@code 0.0} and {@code 1.0}, inclusive</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code rasterizationSamples} and {@code sampleLocationsInfo} are not dynamic, and ##VkPipelineSampleLocationsStateCreateInfoEXT{@code ::sampleLocationsEnable} included in the {@code pNext} chain of {@code pMultisampleState} is #TRUE, {@code sampleLocationsInfo.sampleLocationGridSize.width} <b>must</b> evenly divide ##VkMultisamplePropertiesEXT{@code ::sampleLocationGridSize.width} as returned by #GetPhysicalDeviceMultisamplePropertiesEXT() with a {@code samples} parameter equaling {@code rasterizationSamples}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code rasterizationSamples} and {@code sampleLocationsInfo} are not dynamic, and ##VkPipelineSampleLocationsStateCreateInfoEXT{@code ::sampleLocationsEnable} the included in the {@code pNext} chain of {@code pMultisampleState} is #TRUE or #DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT is used, {@code sampleLocationsInfo.sampleLocationGridSize.height} <b>must</b> evenly divide ##VkMultisamplePropertiesEXT{@code ::sampleLocationGridSize.height} as returned by #GetPhysicalDeviceMultisamplePropertiesEXT() with a {@code samples} parameter equaling {@code rasterizationSamples}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code rasterizationSamples} and {@code sampleLocationsInfo} are not dynamic, and ##VkPipelineSampleLocationsStateCreateInfoEXT{@code ::sampleLocationsEnable} included in the {@code pNext} chain of {@code pMultisampleState} is #TRUE or #DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT is used, {@code sampleLocationsInfo.sampleLocationsPerPixel} <b>must</b> equal {@code rasterizationSamples}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and the {@code sampleLocationsEnable} member of a ##VkPipelineSampleLocationsStateCreateInfoEXT structure included in the {@code pNext} chain of {@code pMultisampleState} is #TRUE, the fragment shader code <b>must</b> not statically use the extended instruction {@code InterpolateAtSample}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and none of the {@link AMDMixedAttachmentSamples VK_AMD_mixed_attachment_samples} extension, the {@link NVFramebufferMixedSamples VK_NV_framebuffer_mixed_samples} extension, or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multisampledRenderToSingleSampled">{@code multisampledRenderToSingleSampled}</a> feature are enabled, {@code rasterizationSamples} is not dynamic, and if {@code subpass} uses color and/or depth/stencil attachments, then the {@code rasterizationSamples} member of {@code pMultisampleState} <b>must</b> be the same as the sample count for those subpass attachments</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and the {@link AMDMixedAttachmentSamples VK_AMD_mixed_attachment_samples} extension is enabled, {@code rasterizationSamples} is not dynamic, and if {@code subpass} uses color and/or depth/stencil attachments, then the {@code rasterizationSamples} member of {@code pMultisampleState} <b>must</b> equal the maximum of the sample counts of those subpass attachments</li>
            <li>If {@code renderPass} is not #NULL_HANDLE, the {@link EXTMultisampledRenderToSingleSampled VK_EXT_multisampled_render_to_single_sampled} extension is enabled, {@code rasterizationSamples} is not dynamic, and {@code subpass} has a ##VkMultisampledRenderToSingleSampledInfoEXT structure included in the ##VkSubpassDescription2{@code ::pNext} chain with {@code multisampledRenderToSingleSampledEnable} equal to #TRUE, then the {@code rasterizationSamples} member of {@code pMultisampleState} <b>must</b> be equal to ##VkMultisampledRenderToSingleSampledInfoEXT{@code ::rasterizationSamples}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, the {@link NVFramebufferMixedSamples VK_NV_framebuffer_mixed_samples} extension is enabled, {@code rasterizationSamples} is not dynamic, and if {@code subpass} has a depth/stencil attachment and depth test, stencil test, or depth bounds test are enabled, then the {@code rasterizationSamples} member of {@code pMultisampleState} <b>must</b> be the same as the sample count of the depth/stencil attachment</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, the {@link NVFramebufferMixedSamples VK_NV_framebuffer_mixed_samples} extension is enabled, {@code rasterizationSamples} is not dynamic, and if {@code subpass} has any color attachments, then the {@code rasterizationSamples} member of {@code pMultisampleState} <b>must</b> be greater than or equal to the sample count for those subpass attachments</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, the {@link NVCoverageReductionMode VK_NV_coverage_reduction_mode} extension is enabled, and {@code rasterizationSamples} is not dynamic, the coverage reduction mode specified by ##VkPipelineCoverageReductionStateCreateInfoNV{@code ::coverageReductionMode}, the {@code rasterizationSamples} member of {@code pMultisampleState} and the sample counts for the color and depth/stencil attachments (if the subpass has them) <b>must</b> be a valid combination returned by {@code vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code rasterizationSamples} is not dynamic, and {@code subpass} does not use any color and/or depth/stencil attachments, then the {@code rasterizationSamples} member of {@code pMultisampleState} <b>must</b> follow the rules for a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-noattachments">zero-attachment subpass</a></li>
            <li>If {@code renderPass} is not #NULL_HANDLE, {@code subpass} <b>must</b> be a valid subpass within {@code renderPass}</li>
            <li>If {@code renderPass} is not #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, {@code subpass} viewMask is not 0, and {@code multiviewTessellationShader} is not enabled, then {@code pStages} <b>must</b> not include tessellation shaders</li>
            <li>If {@code renderPass} is not #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, {@code subpass} viewMask is not 0, and {@code multiviewGeometryShader} is not enabled, then {@code pStages} <b>must</b> not include a geometry shader</li>
            <li>If {@code renderPass} is not #NULL_HANDLE and the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and {@code subpass} viewMask is not 0, then all of the shaders in the pipeline <b>must</b> not include variables decorated with the {@code Layer} built-in decoration in their interfaces</li>
            <li>If {@code renderPass} is not #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, {@code subpass} viewMask is not 0, and {@code multiviewMeshShader} is not enabled, then {@code pStages} <b>must</b> not include a mesh shader</li>
            <li>{@code flags} <b>must</b> not contain the #PIPELINE_CREATE_DISPATCH_BASE flag</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and an input attachment was referenced by an {@code aspectMask} at {@code renderPass} creation time, the fragment shader <b>must</b> only read from the aspects that were specified for that input attachment</li>
            <li>The number of resources in {@code layout} accessible to each shader stage that is used by the pipeline <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageResources}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_VIEWPORT_W_SCALING_NV, and the {@code viewportWScalingEnable} member of a ##VkPipelineViewportWScalingStateCreateInfoNV structure, included in the {@code pNext} chain of {@code pViewportState}, is #TRUE, the {@code pViewportWScalings} member of the ##VkPipelineViewportWScalingStateCreateInfoNV <b>must</b> be a pointer to an array of ##VkPipelineViewportWScalingStateCreateInfoNV{@code ::viewportCount} valid ##VkViewportWScalingNV structures</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV, and if {@code pViewportState→pNext} chain includes a ##VkPipelineViewportExclusiveScissorStateCreateInfoNV structure, and if its {@code exclusiveScissorCount} member is not 0, then its {@code pExclusiveScissors} member <b>must</b> be a valid pointer to an array of {@code exclusiveScissorCount} ##VkRect2D structures</li>
            <li>If #DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV is included in the {@code pDynamicStates} array then the implementation <b>must</b> support at least {@code specVersion} 2 of the {@link NVScissorExclusive VK_NV_scissor_exclusive} extension</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV, and if {@code pViewportState→pNext} chain includes a ##VkPipelineViewportShadingRateImageStateCreateInfoNV structure, then its {@code pShadingRatePalettes} member <b>must</b> be a valid pointer to an array of {@code viewportCount} valid ##VkShadingRatePaletteNV structures</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_DISCARD_RECTANGLE_EXT, and if {@code pNext} chain includes a ##VkPipelineDiscardRectangleStateCreateInfoEXT structure, and if its {@code discardRectangleCount} member is not 0, then its {@code pDiscardRectangles} member <b>must</b> be a valid pointer to an array of {@code discardRectangleCount} ##VkRect2D structures</li>
            <li>If #DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT is included in the {@code pDynamicStates} array then the implementation <b>must</b> support at least {@code specVersion} 2 of the {@link EXTDiscardRectangles VK_EXT_discard_rectangles} extension</li>
            <li>If #DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT is included in the {@code pDynamicStates} array then the implementation <b>must</b> support at least {@code specVersion} 2 of the {@link EXTDiscardRectangles VK_EXT_discard_rectangles} extension</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a>, and {@code pVertexInputState} is not dynamic, then {@code pVertexInputState} <b>must</b> be a valid pointer to a valid ##VkPipelineVertexInputStateCreateInfo structure</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-vertexAttributeRobustness">{@code vertexAttributeRobustness}</a> is not enabled and the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a> and {@code pVertexInputState} is not dynamic, then all variables with the {@code Input} storage class decorated with {@code Location} in the {@code Vertex} {@code Execution} {@code Model} {@code OpEntryPoint} <b>must</b> contain a location in ##VkVertexInputAttributeDescription{@code ::location}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a> and {@code pVertexInputState} is not dynamic, then the numeric type associated with all {@code Input} variables of the corresponding {@code Location} in the {@code Vertex} {@code Execution} {@code Model} {@code OpEntryPoint} <b>must</b> be the same as ##VkVertexInputAttributeDescription{@code ::format}</li>
            <li>If the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a> and {@code pVertexInputState} is not dynamic, and ##VkVertexInputAttributeDescription{@code ::format} has a 64-bit component, then the scalar width associated with all {@code Input} variables of the corresponding {@code Location} in the {@code Vertex} {@code Execution} {@code Model} {@code OpEntryPoint} <b>must</b> be 64-bit</li>
            <li>If the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a> and {@code pVertexInputState} is not dynamic, and the scalar width associated with a {@code Location} decorated {@code Input} variable in the {@code Vertex} {@code Execution} {@code Model} {@code OpEntryPoint} is 64-bit, then the corresponding ##VkVertexInputAttributeDescription{@code ::format} <b>must</b> have a 64-bit component</li>
            <li>If the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a> and {@code pVertexInputState} is not dynamic, and ##VkVertexInputAttributeDescription{@code ::format} has a 64-bit component, then all {@code Input} variables at the corresponding {@code Location} in the {@code Vertex} {@code Execution} {@code Model} {@code OpEntryPoint} <b>must</b> not use components that are not present in the format</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a>, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pInputAssemblyState-null">related dynamic state is not set</a>, {@code pInputAssemblyState} <b>must</b> be a valid pointer to a valid ##VkPipelineInputAssemblyStateCreateInfo structure</li>
            <li>If {@code pInputAssemblyState} is not {@code NULL} it <b>must</b> be a valid pointer to a valid ##VkPipelineInputAssemblyStateCreateInfo structure</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, the {@code Xfb} execution mode <b>can</b> be specified by no more than one shader stage in {@code pStages}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and any shader stage in {@code pStages} specifies {@code Xfb} execution mode it <b>must</b> be the last <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader stage</a></li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and a ##VkPipelineRasterizationStateStreamCreateInfoEXT{@code ::rasterizationStream} value other than zero is specified, all variables in the output interface of the entry point being compiled decorated with {@code Position}, {@code PointSize}, {@code ClipDistance}, or {@code CullDistance} <b>must</b> be decorated with identical {@code Stream} values that match the {@code rasterizationStream}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and ##VkPipelineRasterizationStateStreamCreateInfoEXT{@code ::rasterizationStream} is zero, or not specified, all variables in the output interface of the entry point being compiled decorated with {@code Position}, {@code PointSize}, {@code ClipDistance}, or {@code CullDistance} <b>must</b> be decorated with a {@code Stream} value of zero, or <b>must</b> not specify the {@code Stream} decoration</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and the last <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader stage</a> is a geometry shader, and that geometry shader uses the {@code GeometryStreams} capability, then ##VkPhysicalDeviceTransformFeedbackFeaturesEXT{@code ::geometryStreams} feature <b>must</b> be enabled</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and there are any mesh shader stages in the pipeline there <b>must</b> not be any shader stage in the pipeline with a {@code Xfb} execution mode</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and at least one of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and {@code pMultisampleState} is not {@code NULL}, the {@code lineRasterizationMode} member of a ##VkPipelineRasterizationLineStateCreateInfo structure included in the {@code pNext} chain of {@code pRasterizationState} is #LINE_RASTERIZATION_MODE_BRESENHAM or #LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH, then the {@code alphaToCoverageEnable}, {@code alphaToOneEnable}, and {@code sampleShadingEnable} members of {@code pMultisampleState} <b>must</b> all be #FALSE</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, the {@code stippledLineEnable} member of ##VkPipelineRasterizationLineStateCreateInfo is #TRUE, and no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_LINE_STIPPLE, then the {@code lineStippleFactor} member of ##VkPipelineRasterizationLineStateCreateInfo <b>must</b> be in the range <code>[1,256]</code></li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderMeshEnqueue">{@code shaderMeshEnqueue}</a> feature is not enabled, shaders specified by {@code pStages} <b>must</b> not declare the {@code ShaderEnqueueAMDX} capability</li>
            <li>If {@code flags} does not include #PIPELINE_CREATE_LIBRARY_BIT_KHR, shaders specified by {@code pStages} <b>must</b> not declare the {@code ShaderEnqueueAMDX} capability</li>
            <li>If any shader stages in {@code pStages} declare the {@code ShaderEnqueueAMDX} capability, #PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX and #PIPELINE_CREATE_2_LIBRARY_BIT_KHR <b>must</b> be included in {@code flags}</li>
            <li>If #PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX is included in {@code flags}, and the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, there <b>must</b> not be a task or vertex shader specified in {@code pStages}</li>
            <li>If #PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX is included in {@code flags}, all elements of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} <b>must</b> have been created with #PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState">{@code extendedDynamicState}</a> feature is not enabled, and the minimum value of ##VkApplicationInfo{@code ::apiVersion} used to create the {@code VkInstance} and {@code apiVersion} supported by the physical device is less than Version 1.3 there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_CULL_MODE, #DYNAMIC_STATE_FRONT_FACE, #DYNAMIC_STATE_PRIMITIVE_TOPOLOGY, #DYNAMIC_STATE_VIEWPORT_WITH_COUNT, #DYNAMIC_STATE_SCISSOR_WITH_COUNT, #DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE, #DYNAMIC_STATE_DEPTH_TEST_ENABLE, #DYNAMIC_STATE_DEPTH_WRITE_ENABLE, #DYNAMIC_STATE_DEPTH_COMPARE_OP, #DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, #DYNAMIC_STATE_STENCIL_TEST_ENABLE, or #DYNAMIC_STATE_STENCIL_OP</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and #DYNAMIC_STATE_VIEWPORT_WITH_COUNT is included in the {@code pDynamicStates} array then {@code viewportCount} <b>must</b> be zero</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and #DYNAMIC_STATE_SCISSOR_WITH_COUNT is included in the {@code pDynamicStates} array then {@code scissorCount} <b>must</b> be zero</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and #DYNAMIC_STATE_VIEWPORT_WITH_COUNT is included in the {@code pDynamicStates} array then #DYNAMIC_STATE_VIEWPORT <b>must</b> not be present</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and #DYNAMIC_STATE_SCISSOR_WITH_COUNT is included in the {@code pDynamicStates} array then #DYNAMIC_STATE_SCISSOR <b>must</b> not be present</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and includes a mesh shader, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_PRIMITIVE_TOPOLOGY, or #DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState2">{@code extendedDynamicState2}</a> feature is not enabled, and the minimum value of ##VkApplicationInfo{@code ::apiVersion} used to create the {@code VkInstance} and {@code apiVersion} supported by the physical device is less than Version 1.3 there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_DEPTH_BIAS_ENABLE, #DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE, or #DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState2LogicOp">{@code extendedDynamicState2LogicOp}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_LOGIC_OP_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState2PatchControlPoints">{@code extendedDynamicState2PatchControlPoints}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and includes a mesh shader, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE, or #DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-deviceGeneratedCommandsNV">##VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV{@code ::deviceGeneratedCommands}</a> feature <b>must</b> be enabled</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code flags} includes #PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then all stages <b>must</b> not specify {@code Xfb} execution mode</li>
            <li>If the pipeline is not created with a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete set of state</a>, or ##VkPipelineLibraryCreateInfoKHR{@code ::libraryCount} is not 0, ##VkGraphicsPipelineShaderGroupsCreateInfoNV{@code ::groupCount} and ##VkGraphicsPipelineShaderGroupsCreateInfoNV{@code ::pipelineCount} <b>must</b> be 0</li>
            <li>If the pipeline is created with a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete set of state</a>, and ##VkPipelineLibraryCreateInfoKHR{@code ::libraryCount} is 0, and the {@code pNext} chain includes an instance of ##VkGraphicsPipelineShaderGroupsCreateInfoNV, ##VkGraphicsPipelineShaderGroupsCreateInfoNV{@code ::groupCount} <b>must</b> be greater than 0</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-deviceGeneratedCommands">##VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT{@code ::deviceGeneratedCommands}</a> feature <b>must</b> be enabled</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and {@code flags} includes #PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then all stages <b>must</b> not specify {@code Xfb} execution mode</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineCreationCacheControl">{@code pipelineCreationCacheControl}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or #PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineProtectedAccess">{@code pipelineProtectedAccess}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT or #PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT</li>
            <li>{@code flags} <b>must</b> not include both #PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT and #PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::fragmentSize.width} <b>must</b> be greater than or equal to 1</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::fragmentSize.height} <b>must</b> be greater than or equal to 1</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::fragmentSize.width} <b>must</b> be a power-of-two value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::fragmentSize.height} <b>must</b> be a power-of-two value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::fragmentSize.width} <b>must</b> be less than or equal to 4</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::fragmentSize.height} <b>must</b> be less than or equal to 4</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineFragmentShadingRate">{@code pipelineFragmentShadingRate}</a> feature is not enabled, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::fragmentSize.width} and ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::fragmentSize.height} <b>must</b> both be equal to 1</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::combinerOps}[0] <b>must</b> be a valid {@code VkFragmentShadingRateCombinerOpKHR} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::combinerOps}[1] <b>must</b> be a valid {@code VkFragmentShadingRateCombinerOpKHR} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-primitiveFragmentShadingRate">{@code primitiveFragmentShadingRate}</a> feature is not enabled, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::combinerOps}[0] <b>must</b> be #FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFragmentShadingRate">{@code attachmentFragmentShadingRate}</a> feature is not enabled, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::combinerOps}[1] <b>must</b> be #FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-primitiveFragmentShadingRateWithMultipleViewports">{@code primitiveFragmentShadingRateWithMultipleViewports}</a> limit is not supported, #DYNAMIC_STATE_VIEWPORT_WITH_COUNT is not included in {@code pDynamicState→pDynamicStates}, and ##VkPipelineViewportStateCreateInfo{@code ::viewportCount} is greater than 1, entry points specified in {@code pStages} <b>must</b> not write to the {@code PrimitiveShadingRateKHR} built-in</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-primitiveFragmentShadingRateWithMultipleViewports">{@code primitiveFragmentShadingRateWithMultipleViewports}</a> limit is not supported, and entry points specified in {@code pStages} write to the {@code ViewportIndex} built-in, they <b>must</b> not also write to the {@code PrimitiveShadingRateKHR} built-in</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-primitiveFragmentShadingRateWithMultipleViewports">{@code primitiveFragmentShadingRateWithMultipleViewports}</a> limit is not supported, and entry points specified in {@code pStages} write to the {@code ViewportMaskNV} built-in, they <b>must</b> not also write to the {@code PrimitiveShadingRateKHR} built-in</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-fragmentShadingRateNonTrivialCombinerOps">{@code fragmentShadingRateNonTrivialCombinerOps}</a> limit is not supported, and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, elements of ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::combinerOps} <b>must</b> be #FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR or #FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::shadingRateType} <b>must</b> be a valid {@code VkFragmentShadingRateTypeNV} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::shadingRate} <b>must</b> be a valid {@code VkFragmentShadingRateNV} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::combinerOps}[0] <b>must</b> be a valid {@code VkFragmentShadingRateCombinerOpKHR} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::combinerOps}[1] <b>must</b> be a valid {@code VkFragmentShadingRateCombinerOpKHR} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentShadingRateEnums">{@code fragmentShadingRateEnums}</a> feature is not enabled, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::shadingRateType} <b>must</b> be equal to #FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineFragmentShadingRate">{@code pipelineFragmentShadingRate}</a> feature is not enabled, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::shadingRate} <b>must</b> be equal to #FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-primitiveFragmentShadingRate">{@code primitiveFragmentShadingRate}</a> feature is not enabled, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::combinerOps}[0] <b>must</b> be #FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFragmentShadingRate">{@code attachmentFragmentShadingRate}</a> feature is not enabled, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::combinerOps}[1] <b>must</b> be #FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-fragmentShadingRateNonTrivialCombinerOps">{@code fragmentShadingRateNonTrivialCombinerOps}</a> limit is not supported and #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in {@code pDynamicState→pDynamicStates}, elements of ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::combinerOps} <b>must</b> be #FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR or #FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-supersampleFragmentShadingRates">{@code supersampleFragmentShadingRates}</a> feature is not enabled, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::shadingRate} <b>must</b> not be equal to #FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV, #FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV, #FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV, or #FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-noInvocationFragmentShadingRates">{@code noInvocationFragmentShadingRates}</a> feature is not enabled, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV{@code ::shadingRate} <b>must</b> not be equal to #FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV</li>
            <li>All elements of the {@code pDynamicStates} member of {@code pDynamicState} <b>must</b> not be #DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-vertexInputDynamicState">{@code vertexInputDynamicState}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_VERTEX_INPUT_EXT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and includes a mesh shader, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_VERTEX_INPUT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-colorWriteEnable">{@code colorWriteEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and the {@link QCOMRenderPassShaderResolve VK_QCOM_render_pass_shader_resolve} extension is enabled, {@code rasterizationSamples} is not dynamic, and if subpass has any input attachments, and if the subpass description contains #SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then the sample count of the input attachments <b>must</b> equal {@code rasterizationSamples}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and the {@link QCOMRenderPassShaderResolve VK_QCOM_render_pass_shader_resolve} extension is enabled, and if the subpass description contains #SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then {@code sampleShadingEnable} <b>must</b> be false</li>
            <li>If {@code flags} includes #SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, then the subpass <b>must</b> be the last subpass in a subpass dependency chain</li>
            <li>If {@code flags} includes #SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and if {@code pResolveAttachments} is not {@code NULL}, then each resolve attachment <b>must</b> be #ATTACHMENT_UNUSED</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRendering">{@code dynamicRendering}</a> feature is not enabled and the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} <b>must</b> not be #NULL_HANDLE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiview">{@code multiview}</a> feature is not enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code renderPass} is #NULL_HANDLE, ##VkPipelineRenderingCreateInfo{@code ::viewMask} <b>must</b> be 0</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code renderPass} is #NULL_HANDLE, the index of the most significant bit in ##VkPipelineRenderingCreateInfo{@code ::viewMask} <b>must</b> be less than <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxMultiviewViewCount">{@code maxMultiviewViewCount}</a></li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code renderPass} is #NULL_HANDLE, and ##VkPipelineRenderingCreateInfo{@code ::colorAttachmentCount} is not 0, ##VkPipelineRenderingCreateInfo{@code ::pColorAttachmentFormats} <b>must</b> be a valid pointer to an array of {@code colorAttachmentCount} valid {@code VkFormat} values</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code renderPass} is #NULL_HANDLE, each element of ##VkPipelineRenderingCreateInfo{@code ::pColorAttachmentFormats} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and any element of ##VkPipelineRenderingCreateInfo{@code ::pColorAttachmentFormats} is not #FORMAT_UNDEFINED, that format <b>must</b> be a format with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> that include #FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or #FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code renderPass} is #NULL_HANDLE, ##VkPipelineRenderingCreateInfo{@code ::depthAttachmentFormat} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and {@code renderPass} is #NULL_HANDLE, ##VkPipelineRenderingCreateInfo{@code ::stencilAttachmentFormat} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkPipelineRenderingCreateInfo{@code ::depthAttachmentFormat} is not #FORMAT_UNDEFINED, it <b>must</b> be a format with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> that include #FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkPipelineRenderingCreateInfo{@code ::stencilAttachmentFormat} is not #FORMAT_UNDEFINED, it <b>must</b> be a format with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> that include #FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkPipelineRenderingCreateInfo{@code ::depthAttachmentFormat} is not #FORMAT_UNDEFINED, it <b>must</b> be a format that includes a depth component</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkPipelineRenderingCreateInfo{@code ::stencilAttachmentFormat} is not #FORMAT_UNDEFINED, it <b>must</b> be a format that includes a stencil component</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, ##VkPipelineRenderingCreateInfo{@code ::depthAttachmentFormat} is not #FORMAT_UNDEFINED, and ##VkPipelineRenderingCreateInfo{@code ::stencilAttachmentFormat} is not #FORMAT_UNDEFINED, {@code depthAttachmentFormat} <b>must</b> equal {@code stencilAttachmentFormat}</li>
            <li>If {@code renderPass} is #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and either of ##VkPipelineRenderingCreateInfo{@code ::depthAttachmentFormat} or ##VkPipelineRenderingCreateInfo{@code ::stencilAttachmentFormat} are not #FORMAT_UNDEFINED, and the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is not enabled or any of the #DYNAMIC_STATE_DEPTH_TEST_ENABLE, #DYNAMIC_STATE_DEPTH_WRITE_ENABLE, #DYNAMIC_STATE_DEPTH_COMPARE_OP, #DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, #DYNAMIC_STATE_STENCIL_TEST_ENABLE, #DYNAMIC_STATE_STENCIL_OP, or #DYNAMIC_STATE_DEPTH_BOUNDS dynamic states are not set, {@code pDepthStencilState} <b>must</b> be a valid pointer to a valid ##VkPipelineDepthStencilStateCreateInfo structure</li>
            <li>If {@code pDepthStencilState} is not {@code NULL} it <b>must</b> be a valid pointer to a valid ##VkPipelineDepthStencilStateCreateInfo structure</li>
            <li>If {@code renderPass} is #NULL_HANDLE and the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> but not <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is not enabled, or any of the #DYNAMIC_STATE_DEPTH_TEST_ENABLE, #DYNAMIC_STATE_DEPTH_WRITE_ENABLE, #DYNAMIC_STATE_DEPTH_COMPARE_OP, #DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, #DYNAMIC_STATE_STENCIL_TEST_ENABLE, #DYNAMIC_STATE_STENCIL_OP, or #DYNAMIC_STATE_DEPTH_BOUNDS dynamic states are not set, {@code pDepthStencilState} <b>must</b> be a valid pointer to a valid ##VkPipelineDepthStencilStateCreateInfo structure</li>
            <li>If {@code pDepthStencilState} is not {@code NULL} it <b>must</b> be a valid pointer to a valid ##VkPipelineDepthStencilStateCreateInfo structure</li>
            <li>If {@code renderPass} is #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and any element of ##VkPipelineRenderingCreateInfo{@code ::pColorAttachmentFormats} is not #FORMAT_UNDEFINED, and the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is not enabled, or any of the #DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT, #DYNAMIC_STATE_LOGIC_OP_EXT, #DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT, #DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT, #DYNAMIC_STATE_COLOR_WRITE_MASK_EXT, or #DYNAMIC_STATE_BLEND_CONSTANTS dynamic states are not set, {@code pColorBlendState} <b>must</b> be a valid pointer to a valid ##VkPipelineColorBlendStateCreateInfo structure</li>
            <li>If {@code pColorBlendState} is not {@code NULL} it <b>must</b> be a valid pointer to a valid ##VkPipelineColorBlendStateCreateInfo structure</li>
            <li>If {@code renderPass} is #NULL_HANDLE, {@code pColorBlendState} is not dynamic, and the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code pColorBlendState→attachmentCount} <b>must</b> be equal to ##VkPipelineRenderingCreateInfo{@code ::colorAttachmentCount}</li>
            <li>If {@code renderPass} is #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, ##VkPipelineRenderingCreateInfo{@code ::viewMask} is not 0, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiview-tess">{@code multiviewTessellationShader}</a> feature is not enabled, then {@code pStages} <b>must</b> not include tessellation shaders</li>
            <li>If {@code renderPass} is #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, ##VkPipelineRenderingCreateInfo{@code ::viewMask} is not 0, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiview-gs">{@code multiviewGeometryShader}</a> feature is not enabled, then {@code pStages} <b>must</b> not include a geometry shader</li>
            <li>If {@code renderPass} is #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and ##VkPipelineRenderingCreateInfo{@code ::viewMask} is not 0, all of the shaders in the pipeline <b>must</b> not include variables decorated with the {@code Layer} built-in decoration in their interfaces</li>
            <li>If {@code renderPass} is #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and ##VkPipelineRenderingCreateInfo{@code ::viewMask} is not 0, and {@code multiviewMeshShader} is not enabled, then {@code pStages} <b>must</b> not include a mesh shader</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRenderingLocalRead">{@code dynamicRenderingLocalRead}</a> feature is not enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and {@code renderPass} is #NULL_HANDLE, fragment shaders in {@code pStages} <b>must</b> not include the {@code InputAttachment} capability</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and {@code renderPass} is not #NULL_HANDLE, fragment shaders in {@code pStages} <b>must</b> not include any of the {@code TileImageColorReadAccessEXT}, {@code TileImageDepthReadAccessEXT}, or {@code TileImageStencilReadAccessEXT} capabilities</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a> and {@code renderPass} is #NULL_HANDLE, for each color attachment format defined by the {@code pColorAttachmentFormats} member of ##VkPipelineRenderingCreateInfo, if its <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> do not contain #FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT, then the {@code blendEnable} member of the corresponding element of the {@code pAttachments} member of {@code pColorBlendState} <b>must</b> be #FALSE</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a> and {@code renderPass} is #NULL_HANDLE, if the {@code pNext} chain includes ##VkAttachmentSampleCountInfoAMD or ##VkAttachmentSampleCountInfoNV, the {@code colorAttachmentCount} member of that structure <b>must</b> be equal to the value of ##VkPipelineRenderingCreateInfo{@code ::colorAttachmentCount}</li>
            <li>If {@code pStages} includes a fragment shader stage, and the fragment shader declares the {@code EarlyFragmentTests} execution mode, the {@code flags} member of ##VkPipelineDepthStencilStateCreateInfo <b>must</b> not include #PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT or #PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRenderingLocalRead">{@code dynamicRenderingLocalRead}</a> feature is not enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and the {@code flags} member of ##VkPipelineColorBlendStateCreateInfo includes #PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT, {@code renderPass} <b>must</b> not be #NULL_HANDLE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRenderingLocalRead">{@code dynamicRenderingLocalRead}</a> feature is not enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, and the {@code flags} member of ##VkPipelineDepthStencilStateCreateInfo includes #PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT or #PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT, {@code renderPass} <b>must</b> not be #NULL_HANDLE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, elements of the {@code pColorAttachmentSamples} member of ##VkAttachmentSampleCountInfoAMD or ##VkAttachmentSampleCountInfoNV <b>must</b> be valid {@code VkSampleCountFlagBits} values</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a> and the {@code depthStencilAttachmentSamples} member of ##VkAttachmentSampleCountInfoAMD or ##VkAttachmentSampleCountInfoNV is not 0, it <b>must</b> be a valid {@code VkSampleCountFlagBits} value</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is not #NULL_HANDLE, and the {@code flags} member of ##VkPipelineColorBlendStateCreateInfo includes #PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT {@code subpass} <b>must</b> have been created with #SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_EXT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, {@code renderPass} is not #NULL_HANDLE, and the {@code flags} member of ##VkPipelineDepthStencilStateCreateInfo includes #PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT, {@code subpass} <b>must</b> have been created with #SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, {@code renderPass} is not #NULL_HANDLE, and the {@code flags} member of ##VkPipelineDepthStencilStateCreateInfo includes #PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT, {@code subpass} <b>must</b> have been created with #SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT</li>
            <li>If ##VkPipelineCreationFeedbackCreateInfo{@code ::pipelineStageCreationFeedbackCount} is not 0, it <b>must</b> be equal to {@code stageCount}</li>
            <li>If {@code renderPass} is #NULL_HANDLE, the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and ##VkMultiviewPerViewAttributesInfoNVX{@code ::perViewAttributesPositionXOnly} is #TRUE then ##VkMultiviewPerViewAttributesInfoNVX{@code ::perViewAttributes} <b>must</b> also be #TRUE</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other flag, the value of ##VkMultiviewPerViewAttributesInfoNVX{@code ::perViewAttributes} specified in both this pipeline and the library <b>must</b> be equal</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, the value of ##VkMultiviewPerViewAttributesInfoNVX{@code ::perViewAttributes} specified in both libraries <b>must</b> be equal</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other flag, the value of ##VkMultiviewPerViewAttributesInfoNVX{@code ::perViewAttributesPositionXOnly} specified in both this pipeline and the library <b>must</b> be equal</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, the value of ##VkMultiviewPerViewAttributesInfoNVX{@code ::perViewAttributesPositionXOnly} specified in both libraries <b>must</b> be equal</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, {@code pStages} <b>must</b> be a valid pointer to an array of {@code stageCount} valid ##VkPipelineShaderStageCreateInfo structures</li>
            <li>If the pipeline does not require <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, {@code stageCount} <b>must</b> be zero</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pRasterizationState-null">related dynamic state is not set</a>, {@code pRasterizationState} <b>must</b> be a valid pointer to a valid ##VkPipelineRasterizationStateCreateInfo structure</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pMultisampleState-null">related dynamic state is not set</a>, then {@code pMultisampleState} <b>must</b> be a valid pointer to a valid ##VkPipelineMultisampleStateCreateInfo structure</li>
            <li>If {@code pRasterizationState} is not {@code NULL} it <b>must</b> be a valid pointer to a valid ##VkPipelineRasterizationStateCreateInfo structure</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, {@code layout} <b>must</b> be a valid {@code VkPipelineLayout} handle</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output state</a>, and {@code renderPass} is not #NULL_HANDLE, {@code renderPass} <b>must</b> be a valid {@code VkRenderPass} handle</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, {@code stageCount} <b>must</b> be greater than 0</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-graphicsPipelineLibrary">{@code graphicsPipelineLibrary}</a> feature is not enabled, and if the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderMeshEnqueue">{@code shaderMeshEnqueue}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_LIBRARY_BIT_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderMeshEnqueue">{@code shaderMeshEnqueue}</a> feature is not enabled, and the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">all possible state subsets</a>, {@code flags} <b>must</b> not include #PIPELINE_CREATE_LIBRARY_BIT_KHR</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT, pipeline libraries included via ##VkPipelineLibraryCreateInfoKHR <b>must</b> have been created with #PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT, {@code flags} <b>must</b> also include #PIPELINE_CREATE_LIBRARY_BIT_KHR</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT, pipeline libraries included via ##VkPipelineLibraryCreateInfoKHR <b>must</b> have been created with #PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT</li>
            <li>Any pipeline libraries included via ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} <b>must</b> not include any <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets">state subset</a> already defined by this structure or defined by any other pipeline library in ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries}</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other flag, and {@code layout} was not created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the {@code layout} used by this pipeline and the library <b>must</b> be <em>identically defined</em></li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and the {@code layout} specified by either library was not created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the {@code layout} used by each library <b>must</b> be <em>identically defined</em></li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other subset, and {@code layout} was created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the {@code layout} used by the library <b>must</b> also have been created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and the {@code layout} specified by either library was created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the {@code layout} used by both libraries <b>must</b> have been created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other subset, and {@code layout} was created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, elements of the {@code pSetLayouts} array which {@code layout} was created with that are not #NULL_HANDLE <b>must</b> be <em>identically defined</em> to the element at the same index of {@code pSetLayouts} used to create the library’s {@code layout}</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and the {@code layout} specified by either library was created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, elements of the {@code pSetLayouts} array which either {@code layout} was created with that are not #NULL_HANDLE <b>must</b> be <em>identically defined</em> to the element at the same index of {@code pSetLayouts} used to create the other library’s {@code layout}</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other flag, any descriptor set layout <em>N</em> specified by {@code layout} in both this pipeline and the library which include bindings accessed by shader stages in each <b>must</b> be <em>identically defined</em></li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, any descriptor set layout <em>N</em> specified by {@code layout} in both libraries which include bindings accessed by shader stages in each <b>must</b> be <em>identically defined</em></li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other flag, push constants specified in {@code layout} in both this pipeline and the library which are available to shader stages in each <b>must</b> be <em>identically defined</em></li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, push constants specified in {@code layout} in both this pipeline and the library which are available to shader stages in each <b>must</b> be <em>identically defined</em></li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other subset, any element of the {@code pSetLayouts} array when {@code layout} was created and the corresponding element of the {@code pSetLayouts} array used to create the library’s {@code layout} <b>must</b> not both be #NULL_HANDLE</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and any element of the {@code pSetLayouts} array used to create each library’s {@code layout} was #NULL_HANDLE, then the corresponding element of the {@code pSetLayouts} array used to create the other library’s {@code layout} <b>must</b> not be #NULL_HANDLE</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other subset, and any element of the {@code pSetLayouts} array which {@code layout} was created with was #NULL_HANDLE, then the corresponding element of the {@code pSetLayouts} array used to create the library’s {@code layout} <b>must</b> not have shader bindings for shaders in the other subset</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other subset, and any element of the {@code pSetLayouts} array used to create the library’s {@code layout} was #NULL_HANDLE, then the corresponding element of the {@code pSetLayouts} array used to create this pipeline’s {@code layout} <b>must</b> not have shader bindings for shaders in the other subset</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and any element of the {@code pSetLayouts} array used to create each library’s {@code layout} was #NULL_HANDLE, then the corresponding element of the {@code pSetLayouts} array used to create the other library’s {@code layout} <b>must</b> not have shader bindings for shaders in the other subset</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes both #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, {@code layout} <b>must</b> have been created with no elements of the {@code pSetLayouts} array set to #NULL_HANDLE</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and {@code pRasterizationState→rasterizerDiscardEnable} is #TRUE, {@code layout} <b>must</b> have been created with no elements of the {@code pSetLayouts} array set to #NULL_HANDLE</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes at least one of and no more than two of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes one of the other flags, the value of {@code subpass} <b>must</b> be equal to that used to create the library</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes at least one of and no more than two of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and another element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes one of the other flags, the value of {@code subpass} used to create each library <b>must</b> be identical</li>
            <li>If {@code renderpass} is not #NULL_HANDLE, ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes at least one of and no more than two of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes one of the other flags, {@code renderPass} <b>must</b> be compatible with that used to create the library</li>
            <li>If {@code renderpass} is #NULL_HANDLE, ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes at least one of and no more than two of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes one of the other flags, the value of {@code renderPass} used to create that library <b>must</b> also be #NULL_HANDLE</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes at least one of and no more than two of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes one of the other flags, and {@code renderPass} is #NULL_HANDLE, the value of ##VkPipelineRenderingCreateInfo{@code ::viewMask} used by this pipeline and that specified by the library <b>must</b> be identical</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes at least one of and no more than two of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, another element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes one of the other flags, and {@code renderPass} was #NULL_HANDLE for both libraries, the value of ##VkPipelineRenderingCreateInfo{@code ::viewMask} set by each library <b>must</b> be identical</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes at least one of and no more than two of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and another element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes one of the other flags, the {@code renderPass} objects used to create each library <b>must</b> be compatible or all equal to #NULL_HANDLE</li>
            <li>If {@code renderPass} is not #NULL_HANDLE, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, and the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is not enabled or any of the #DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, #DYNAMIC_STATE_SAMPLE_MASK_EXT, or #DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states is not set, or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-alphaToOne">alphaToOne</a> feature is enabled and #DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is not set, then {@code pMultisampleState} <b>must</b> be a valid pointer to a valid ##VkPipelineMultisampleStateCreateInfo structure</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> with a fragment shader that either enables <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-sampleshading">sample shading</a> or decorates any variable in the {@code Input} storage class with {@code Sample}, and the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is not enabled or any of the #DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, #DYNAMIC_STATE_SAMPLE_MASK_EXT, or #DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states is not set, or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-alphaToOne">alphaToOne</a> feature is enabled and #DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is not set, then {@code pMultisampleState} <b>must</b> be a valid pointer to a valid ##VkPipelineMultisampleStateCreateInfo structure</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT with a {@code pMultisampleState} that was not {@code NULL}, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} was created with #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, {@code pMultisampleState} <b>must</b> be <em>identically defined</em> to that used to create the library</li>
            <li>If an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} was created with #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT with a {@code pMultisampleState} that was not {@code NULL}, and if ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, {@code pMultisampleState} <b>must</b> be <em>identically defined</em> to that used to create the library</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} was created with #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT with a {@code pMultisampleState} that was not {@code NULL}, and if a different element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} was created with #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, the {@code pMultisampleState} used to create each library <b>must</b> be <em>identically defined</em></li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} was created with #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT and a value of {@code pMultisampleState→sampleShadingEnable} equal #TRUE, and if a different element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} was created with #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, the {@code pMultisampleState} used to create each library <b>must</b> be <em>identically defined</em></li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, {@code pMultisampleState→sampleShadingEnable} is #TRUE, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} was created with #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, {@code pMultisampleState} <b>must</b> be <em>identically defined</em> to that used to create the library</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} was created with #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT and a value of {@code pMultisampleState→sampleShadingEnable} equal #TRUE, and if ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, {@code pMultisampleState} <b>must</b> be <em>identically defined</em> to that used to create the library</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes only one of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes the other flag, values specified in ##VkPipelineFragmentShadingRateStateCreateInfoKHR for both this pipeline and that library <b>must</b> be identical</li>
            <li>If one element of ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, values specified in ##VkPipelineFragmentShadingRateStateCreateInfoKHR for both this pipeline and that library <b>must</b> be identical</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, {@code pStages} <b>must</b> be a valid pointer to an array of {@code stageCount} valid ##VkPipelineShaderStageCreateInfo structures</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, {@code layout} <b>must</b> be a valid {@code VkPipelineLayout} handle</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and {@code renderPass} is not #NULL_HANDLE, {@code renderPass} <b>must</b> be a valid {@code VkRenderPass} handle</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, {@code stageCount} <b>must</b> be greater than 0</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} is non-zero, if {@code flags} includes #PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, any libraries <b>must</b> have also been created with #PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR</li>
            <li>If ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes more than one library, and any library was created with #PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, all libraries <b>must</b> have also been created with #PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR</li>
            <li>If ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries} includes at least one library, ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} is non-zero, and any library was created with #PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, {@code flags} <b>must</b> include #PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR</li>
            <li>If the pipeline includes a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete set of state</a>, and there are no libraries included in ##VkPipelineLibraryCreateInfoKHR{@code ::pLibraries}, then {@code VkPipelineLayout} <b>must</b> be a valid pipeline layout</li>
            <li>If the pipeline includes a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete set of state</a> specified entirely by libraries, and each library was created with a {@code VkPipelineLayout} created without #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then {@code layout} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-compatibility">compatible</a> with the layouts in those libraries</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT, the pipeline includes a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete set of state</a> specified entirely by libraries, and each library was created with a {@code VkPipelineLayout} created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then {@code layout} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-compatibility">compatible</a> with the union of the libraries' pipeline layouts other than the inclusion/exclusion of #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT</li>
            <li>If {@code flags} does not include #PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT, the pipeline includes a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">complete set of state</a> specified entirely by libraries, and each library was created with a {@code VkPipelineLayout} created with #PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then {@code layout} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-compatibility">compatible</a> with the union of the libraries' pipeline layouts</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-conservativePointAndLineRasterization">{@code conservativePointAndLineRasterization}</a> is not supported; the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>; the pipeline does not include a geometry shader; and the value of ##VkPipelineInputAssemblyStateCreateInfo{@code ::topology} is #PRIMITIVE_TOPOLOGY_POINT_LIST, #PRIMITIVE_TOPOLOGY_LINE_LIST, or #PRIMITIVE_TOPOLOGY_LINE_STRIP, and either #DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-dynamicPrimitiveTopologyUnrestricted">{@code dynamicPrimitiveTopologyUnrestricted}</a> is #FALSE, then ##VkPipelineRasterizationConservativeStateCreateInfoEXT{@code ::conservativeRasterizationMode} <b>must</b> be #CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-conservativePointAndLineRasterization">{@code conservativePointAndLineRasterization}</a> is not supported, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and the pipeline includes a geometry shader with either the {@code OutputPoints} or {@code OutputLineStrip} execution modes, ##VkPipelineRasterizationConservativeStateCreateInfoEXT{@code ::conservativeRasterizationMode} <b>must</b> be #CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-conservativePointAndLineRasterization">{@code conservativePointAndLineRasterization}</a> is not supported, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and the pipeline includes a mesh shader with either the {@code OutputPoints} or {@code OutputLinesNV} execution modes, ##VkPipelineRasterizationConservativeStateCreateInfoEXT{@code ::conservativeRasterizationMode} <b>must</b> be #CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> but not <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, elements of {@code pStages} <b>must</b> not have {@code stage} set to #SHADER_STAGE_FRAGMENT_BIT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> but not <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, elements of {@code pStages} <b>must</b> not have {@code stage} set to a shader stage which participates in pre-rasterization</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, all elements of {@code pStages} <b>must</b> have a {@code stage} set to a shader stage which participates in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a></li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and/or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, any value of {@code stage} <b>must</b> not be set in more than one element of {@code pStages}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3TessellationDomainOrigin">{@code extendedDynamicState3TessellationDomainOrigin}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3DepthClampEnable">{@code extendedDynamicState3DepthClampEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3PolygonMode">{@code extendedDynamicState3PolygonMode}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_POLYGON_MODE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3RasterizationSamples">{@code extendedDynamicState3RasterizationSamples}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3SampleMask">{@code extendedDynamicState3SampleMask}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_SAMPLE_MASK_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3AlphaToCoverageEnable">{@code extendedDynamicState3AlphaToCoverageEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3AlphaToOneEnable">{@code extendedDynamicState3AlphaToOneEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3LogicOpEnable">{@code extendedDynamicState3LogicOpEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ColorBlendEnable">{@code extendedDynamicState3ColorBlendEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ColorBlendEquation">{@code extendedDynamicState3ColorBlendEquation}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ColorWriteMask">{@code extendedDynamicState3ColorWriteMask}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COLOR_WRITE_MASK_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3RasterizationStream">{@code extendedDynamicState3RasterizationStream}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_RASTERIZATION_STREAM_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ConservativeRasterizationMode">{@code extendedDynamicState3ConservativeRasterizationMode}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ExtraPrimitiveOverestimationSize">{@code extendedDynamicState3ExtraPrimitiveOverestimationSize}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, {@code pDynamicState} includes #DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT, and {@code pDynamicState} does not include #DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT, {@code pRasterizationState} <b>must</b> include a ##VkPipelineRasterizationConservativeStateCreateInfoEXT in its {@code pNext} chain</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3DepthClipEnable">{@code extendedDynamicState3DepthClipEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3SampleLocationsEnable">{@code extendedDynamicState3SampleLocationsEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ColorBlendAdvanced">{@code extendedDynamicState3ColorBlendAdvanced}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ProvokingVertexMode">{@code extendedDynamicState3ProvokingVertexMode}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3LineRasterizationMode">{@code extendedDynamicState3LineRasterizationMode}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3LineStippleEnable">{@code extendedDynamicState3LineStippleEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3DepthClipNegativeOneToOne">{@code extendedDynamicState3DepthClipNegativeOneToOne}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ViewportWScalingEnable">{@code extendedDynamicState3ViewportWScalingEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ViewportSwizzle">{@code extendedDynamicState3ViewportSwizzle}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3CoverageToColorEnable">{@code extendedDynamicState3CoverageToColorEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3CoverageToColorLocation">{@code extendedDynamicState3CoverageToColorLocation}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3CoverageModulationMode">{@code extendedDynamicState3CoverageModulationMode}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3CoverageModulationTableEnable">{@code extendedDynamicState3CoverageModulationTableEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3CoverageModulationTable">{@code extendedDynamicState3CoverageModulationTable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3CoverageReductionMode">{@code extendedDynamicState3CoverageReductionMode}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3RepresentativeFragmentTestEnable">{@code extendedDynamicState3RepresentativeFragmentTestEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-extendedDynamicState3ShadingRateImageEnable">{@code extendedDynamicState3ShadingRateImageEnable}</a> feature is not enabled, there <b>must</b> be no element of the {@code pDynamicStates} member of {@code pDynamicState} set to #DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_VIEWPORT or #DYNAMIC_STATE_VIEWPORT_WITH_COUNT, and if the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiviewPerViewViewports">{@code multiviewPerViewViewports}</a> feature is enabled, then the index of the most significant bit in each element of ##VkRenderPassMultiviewCreateInfo{@code ::pViewMasks} <b>must</b> be less than {@code pViewportState→viewportCount}</li>
            <li>If the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a>, and no element of the {@code pDynamicStates} member of {@code pDynamicState} is #DYNAMIC_STATE_SCISSOR or #DYNAMIC_STATE_SCISSOR_WITH_COUNT, and if the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiviewPerViewViewports">{@code multiviewPerViewViewports}</a> feature is enabled, then the index of the most significant bit in each element of ##VkRenderPassMultiviewCreateInfo{@code ::pViewMasks} <b>must</b> be less than {@code pViewportState→scissorCount}</li>
            <li>If {@code pStages} includes a fragment shader stage, #DYNAMIC_STATE_DEPTH_WRITE_ENABLE is not set in ##VkPipelineDynamicStateCreateInfo{@code ::pDynamicStates}, and the fragment shader declares the {@code EarlyFragmentTests} execution mode and uses {@code OpDepthAttachmentReadEXT}, the {@code depthWriteEnable} member of ##VkPipelineDepthStencilStateCreateInfo <b>must</b> be #FALSE</li>
            <li>If {@code pStages} includes a fragment shader stage, #DYNAMIC_STATE_STENCIL_WRITE_MASK is not set in ##VkPipelineDynamicStateCreateInfo{@code ::pDynamicStates}, and the fragment shader declares the {@code EarlyFragmentTests} execution mode and uses {@code OpStencilAttachmentReadEXT}, the value of ##VkStencilOpState{@code ::writeMask} for both {@code front} and {@code back} in ##VkPipelineDepthStencilStateCreateInfo <b>must</b> be 0</li>
            <li>If {@code renderPass} is #NULL_HANDLE, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output state</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a>, the pipeline enables <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-sampleshading">sample shading</a>, {@code rasterizationSamples} is not dynamic, and the {@code pNext} chain includes a ##VkPipelineRenderingCreateInfo structure, {@code rasterizationSamples} <b>must</b> be a valid {@code VkSampleCountFlagBits} value that is set in {@code imageCreateSampleCounts} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>) for every element of {@code depthAttachmentFormat}, {@code stencilAttachmentFormat} and the {@code pColorAttachmentFormats} array which is not #FORMAT_UNDEFINED</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> is specified either in a library or by the inclusion of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state includes a vertex shader stage in {@code pStages}, the pipeline <b>must</b> define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a></li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> is not specified, the pipeline <b>must</b> define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a></li>
            <li>If {@code flags} does not include #PIPELINE_CREATE_LIBRARY_BIT_KHR, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> is specified either in a library or by the inclusion of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state includes a vertex shader stage in {@code pStages}, the pipeline <b>must</b> either define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-vertex-input">vertex input state</a> or include that state in a linked pipeline library</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT the pipeline <b>must</b> define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a></li>
            <li>If {@code flags} does not include #PIPELINE_CREATE_LIBRARY_BIT_KHR, the pipeline <b>must</b> either define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> or include that state in a linked pipeline library</li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> is specified either in a library or by the inclusion of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state either includes #DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE or has {@code pRasterizationState→rasterizerDiscardEnable} set to #FALSE, the pipeline <b>must</b> define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a></li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> is not specified, the pipeline <b>must</b> define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a></li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> is specified either in a library or by the inclusion of #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and that state either includes #DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE or has {@code pRasterizationState→rasterizerDiscardEnable} set to #FALSE, the pipeline <b>must</b> define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a></li>
            <li>If ##VkGraphicsPipelineLibraryCreateInfoEXT{@code ::flags} includes #GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> is not specified, the pipeline <b>must</b> define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a></li>
            <li>If {@code flags} does not include #PIPELINE_CREATE_LIBRARY_BIT_KHR, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader state</a> is specified either in a library or by the inclusion of #GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state either includes #DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE or has {@code pRasterizationState→rasterizerDiscardEnable} set to #FALSE, the pipeline <b>must</b> define <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> or include those states in linked pipeline libraries</li>
            <li>If {@code pDynamicState→pDynamicStates} does not include #DYNAMIC_STATE_COLOR_WRITE_MASK_EXT, and the format of any color attachment is #FORMAT_E5B9G9R9_UFLOAT_PACK32, the {@code colorWriteMask} member of the corresponding element of {@code pColorBlendState→pAttachments} <b>must</b> either include all of #COLOR_COMPONENT_R_BIT, #COLOR_COMPONENT_G_BIT, and #COLOR_COMPONENT_B_BIT, or none of them</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkExternalFormatANDROID{@code ::externalFormat} is not 0, ##VkPipelineRenderingCreateInfo{@code ::viewMask} <b>must</b> be 0</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, ##VkExternalFormatANDROID{@code ::externalFormat} is not 0, and {@code rasterizationSamples} is not dynamic, ##VkPipelineMultisampleStateCreateInfo{@code ::rasterizationSamples} <b>must</b> be 1</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkExternalFormatANDROID{@code ::externalFormat} is not 0, and {@code blendEnable} is not dynamic, the {@code blendEnable} member of each element of {@code pColorBlendState→pAttachments} <b>must</b> be #FALSE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkExternalFormatANDROID{@code ::externalFormat} is not 0, and {@code pDynamicState→pDynamicStates} does not include #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::width} <b>must</b> be 1</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkExternalFormatANDROID{@code ::externalFormat} is not 0, and {@code pDynamicState→pDynamicStates} does not include #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::height} <b>must</b> be 1</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">pre-rasterization shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkExternalFormatANDROID{@code ::externalFormat} is not 0, the last <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader stage</a> <b>must</b> not statically use a variable with the {@code PrimitiveShadingRateKHR} built-in</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkExternalFormatANDROID{@code ::externalFormat} is not 0, ##VkPipelineRenderingCreateInfo{@code ::colorAttachmentCount} <b>must</b> be 1</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is #NULL_HANDLE, and ##VkExternalFormatANDROID{@code ::externalFormat} is not 0, the fragment shader <b>must</b> not declare the {@code DepthReplacing} or {@code StencilRefReplacingEXT} execution modes</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is not #NULL_HANDLE, {@code subpass} includes an external format resolve attachment, and {@code rasterizationSamples} is not dynamic, ##VkPipelineMultisampleStateCreateInfo{@code ::rasterizationSamples} <b>must</b> be #SAMPLE_COUNT_1_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is not #NULL_HANDLE, {@code subpass} includes an external format resolve attachment, and {@code blendEnable} is not dynamic, the {@code blendEnable} member of each element of {@code pColorBlendState→pAttachments} <b>must</b> be #FALSE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is not #NULL_HANDLE, {@code subpass} includes an external format resolve attachment, and {@code pDynamicState→pDynamicStates} does not include #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::width} <b>must</b> be 1</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is not #NULL_HANDLE, {@code subpass} includes an external format resolve attachment, and {@code pDynamicState→pDynamicStates} does not include #DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, ##VkPipelineFragmentShadingRateStateCreateInfoKHR{@code ::height} <b>must</b> be 1</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-externalFormatResolve">{@code externalFormatResolve}</a> feature is enabled, the pipeline requires <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">pre-rasterization shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output interface state</a>, {@code renderPass} is not #NULL_HANDLE, and {@code subpass} includes an external format resolve attachment, the last <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader stage</a> <b>must</b> not statically use a variable with the {@code PrimitiveShadingRateKHR} built-in</li>
            <li>If the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output state</a>, the value of {@code renderPass} is #NULL_HANDLE, and ##VkRenderingInputAttachmentIndexInfo is included, ##VkRenderingInputAttachmentIndexInfo{@code ::colorAttachmentCount} <b>must</b> be equal to ##VkPipelineRenderingCreateInfo{@code ::colorAttachmentCount}</li>
            <li>If the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-shader">fragment shader state</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output state</a>, the value of {@code renderPass} is #NULL_HANDLE, and ##VkRenderingInputAttachmentIndexInfo is not included, the fragment shader <b>must</b> not contain any input attachments with a {@code InputAttachmentIndex} greater than or equal to ##VkPipelineRenderingCreateInfo{@code ::colorAttachmentCount}</li>
            <li>If the pipeline is being created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-fragment-output">fragment output state</a>, and the value of {@code renderPass} is #NULL_HANDLE, ##VkRenderingAttachmentLocationInfo{@code ::colorAttachmentCount} <b>must</b> be equal to ##VkPipelineRenderingCreateInfo{@code ::colorAttachmentCount}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkAttachmentSampleCountInfoAMD, ##VkExternalFormatANDROID, ##VkGraphicsPipelineLibraryCreateInfoEXT, ##VkGraphicsPipelineShaderGroupsCreateInfoNV, ##VkMultiviewPerViewAttributesInfoNVX, ##VkPipelineBinaryInfoKHR, ##VkPipelineCompilerControlCreateInfoAMD, ##VkPipelineCreateFlags2CreateInfo, ##VkPipelineCreationFeedbackCreateInfo, ##VkPipelineDiscardRectangleStateCreateInfoEXT, ##VkPipelineFragmentShadingRateEnumStateCreateInfoNV, ##VkPipelineFragmentShadingRateStateCreateInfoKHR, ##VkPipelineLibraryCreateInfoKHR, ##VkPipelineRenderingCreateInfo, ##VkPipelineRepresentativeFragmentTestStateCreateInfoNV, ##VkPipelineRobustnessCreateInfo, ##VkRenderingAttachmentLocationInfo, or ##VkRenderingInputAttachmentIndexInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>If {@code pDynamicState} is not {@code NULL}, {@code pDynamicState} <b>must</b> be a valid pointer to a valid ##VkPipelineDynamicStateCreateInfo structure</li>
            <li>Each of {@code basePipelineHandle}, {@code layout}, and {@code renderPass} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineColorBlendStateCreateInfo, ##VkPipelineDepthStencilStateCreateInfo, ##VkPipelineDynamicStateCreateInfo, ##VkPipelineInputAssemblyStateCreateInfo, ##VkPipelineMultisampleStateCreateInfo, ##VkPipelineRasterizationStateCreateInfo, ##VkPipelineShaderStageCreateInfo, ##VkPipelineTessellationStateCreateInfo, ##VkPipelineVertexInputStateCreateInfo, ##VkPipelineViewportStateCreateInfo, #CreateGraphicsPipelines()
        """

    Expression("#STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkAttachmentSampleCountInfoAMD", "VkAttachmentSampleCountInfoNV", "VkExternalFormatANDROID", "VkGraphicsPipelineLibraryCreateInfoEXT", "VkGraphicsPipelineShaderGroupsCreateInfoNV", "VkMultiviewPerViewAttributesInfoNVX", "VkPipelineBinaryInfoKHR", "VkPipelineCompilerControlCreateInfoAMD", "VkPipelineCreateFlags2CreateInfo", "VkPipelineCreateFlags2CreateInfoKHR", "VkPipelineCreationFeedbackCreateInfo", "VkPipelineCreationFeedbackCreateInfoEXT", "VkPipelineDiscardRectangleStateCreateInfoEXT", "VkPipelineFragmentShadingRateEnumStateCreateInfoNV", "VkPipelineFragmentShadingRateStateCreateInfoKHR", "VkPipelineLibraryCreateInfoKHR", "VkPipelineRenderingCreateInfo", "VkPipelineRenderingCreateInfoKHR", "VkPipelineRepresentativeFragmentTestStateCreateInfoNV", "VkPipelineRobustnessCreateInfo", "VkPipelineRobustnessCreateInfoEXT", "VkRenderingAttachmentLocationInfo", "VkRenderingAttachmentLocationInfoKHR", "VkRenderingInputAttachmentIndexInfo", "VkRenderingInputAttachmentIndexInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCreateFlags("flags", "a bitmask of {@code VkPipelineCreateFlagBits} specifying how the pipeline will be generated.")
    AutoSize("pStages", optional = true)..uint32_t("stageCount", "the number of entries in the {@code pStages} array.")
    nullable..VkPipelineShaderStageCreateInfo.const.p("pStages", "a pointer to an array of {@code stageCount} ##VkPipelineShaderStageCreateInfo structures describing the set of the shader stages to be included in the graphics pipeline.")
    nullable..VkPipelineVertexInputStateCreateInfo.const.p("pVertexInputState", "a pointer to a ##VkPipelineVertexInputStateCreateInfo structure. It is ignored if the pipeline includes a mesh shader stage. It <b>can</b> be {@code NULL} if the pipeline is created with the #DYNAMIC_STATE_VERTEX_INPUT_EXT dynamic state set.")
    nullable..VkPipelineInputAssemblyStateCreateInfo.const.p("pInputAssemblyState", "a pointer to a ##VkPipelineInputAssemblyStateCreateInfo structure which determines input assembly behavior for vertex shading, as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#drawing\">Drawing Commands</a>. If the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is enabled, it <b>can</b> be {@code NULL} if the pipeline is created with both #DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE, and #DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic states set and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#limits-dynamicPrimitiveTopologyUnrestricted\">{@code dynamicPrimitiveTopologyUnrestricted}</a> is #TRUE. It is ignored if the pipeline includes a mesh shader stage.")
    nullable..VkPipelineTessellationStateCreateInfo.const.p("pTessellationState", "a pointer to a ##VkPipelineTessellationStateCreateInfo structure defining tessellation state used by tessellation shaders. It <b>can</b> be {@code NULL} if the pipeline is created with the #DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT dynamic state set.")
    nullable..VkPipelineViewportStateCreateInfo.const.p("pViewportState", "a pointer to a ##VkPipelineViewportStateCreateInfo structure defining viewport state used when rasterization is enabled. If the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is enabled, it <b>can</b> be {@code NULL} if the pipeline is created with both #DYNAMIC_STATE_VIEWPORT_WITH_COUNT, and #DYNAMIC_STATE_SCISSOR_WITH_COUNT dynamic states set.")
    nullable..VkPipelineRasterizationStateCreateInfo.const.p("pRasterizationState", "a pointer to a ##VkPipelineRasterizationStateCreateInfo structure defining rasterization state. If the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is enabled, it <b>can</b> be {@code NULL} if the pipeline is created with all of #DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT, #DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE, #DYNAMIC_STATE_POLYGON_MODE_EXT, #DYNAMIC_STATE_CULL_MODE, #DYNAMIC_STATE_FRONT_FACE, #DYNAMIC_STATE_DEPTH_BIAS_ENABLE, #DYNAMIC_STATE_DEPTH_BIAS, and #DYNAMIC_STATE_LINE_WIDTH dynamic states set.")
    nullable..VkPipelineMultisampleStateCreateInfo.const.p("pMultisampleState", "a pointer to a ##VkPipelineMultisampleStateCreateInfo structure defining multisample state used when rasterization is enabled. If the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is enabled, it <b>can</b> be {@code NULL} if the pipeline is created with all of #DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, #DYNAMIC_STATE_SAMPLE_MASK_EXT, and #DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states set, and either the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-alphaToOne\">alphaToOne</a> feature is not enabled or #DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is set, in which case ##VkPipelineMultisampleStateCreateInfo{@code ::sampleShadingEnable} is assumed to be #FALSE.")
    nullable..VkPipelineDepthStencilStateCreateInfo.const.p("pDepthStencilState", "a pointer to a ##VkPipelineDepthStencilStateCreateInfo structure defining depth/stencil state used when rasterization is enabled for depth or stencil attachments accessed during rendering. If the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is enabled, it <b>can</b> be {@code NULL} if the pipeline is created with all of #DYNAMIC_STATE_DEPTH_TEST_ENABLE, #DYNAMIC_STATE_DEPTH_WRITE_ENABLE, #DYNAMIC_STATE_DEPTH_COMPARE_OP, #DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, #DYNAMIC_STATE_STENCIL_TEST_ENABLE, #DYNAMIC_STATE_STENCIL_OP, and #DYNAMIC_STATE_DEPTH_BOUNDS dynamic states set.")
    nullable..VkPipelineColorBlendStateCreateInfo.const.p("pColorBlendState", "a pointer to a ##VkPipelineColorBlendStateCreateInfo structure defining color blend state used when rasterization is enabled for any color attachments accessed during rendering. If the {@link EXTExtendedDynamicState3 VK_EXT_extended_dynamic_state3} extension is enabled, it <b>can</b> be {@code NULL} if the pipeline is created with all of #DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT, #DYNAMIC_STATE_LOGIC_OP_EXT, #DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT, #DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT, #DYNAMIC_STATE_COLOR_WRITE_MASK_EXT, and #DYNAMIC_STATE_BLEND_CONSTANTS dynamic states set.")
    nullable..VkPipelineDynamicStateCreateInfo.const.p("pDynamicState", "a pointer to a ##VkPipelineDynamicStateCreateInfo structure defining which properties of the pipeline state object are dynamic and <b>can</b> be changed independently of the pipeline state. This <b>can</b> be {@code NULL}, which means no state in the pipeline is considered dynamic.")
    VkPipelineLayout("layout", "the description of binding locations used by both the pipeline and descriptor sets used with the pipeline.")
    VkRenderPass("renderPass", "a handle to a render pass object describing the environment in which the pipeline will be used. The pipeline <b>must</b> only be used with a render pass instance compatible with the one provided. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#renderpass-compatibility\">Render Pass Compatibility</a> for more information.")
    uint32_t("subpass", "the index of the subpass in the render pass where this pipeline will be used.")
    VkPipeline("basePipelineHandle", "a pipeline to derive from.")
    int32_t("basePipelineIndex", "an index into the {@code pCreateInfos} parameter to use as a pipeline to derive from.")
}

val VkPushConstantRange = struct(Module.VULKAN, "VkPushConstantRange") {
    documentation =
        """
        Structure specifying a push constant range.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code offset} <b>must</b> be less than ##VkPhysicalDeviceLimits{@code ::maxPushConstantsSize}</li>
            <li>{@code offset} <b>must</b> be a multiple of 4</li>
            <li>{@code size} <b>must</b> be greater than 0</li>
            <li>{@code size} <b>must</b> be a multiple of 4</li>
            <li>{@code size} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPushConstantsSize} minus {@code offset}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code stageFlags} <b>must</b> be a valid combination of {@code VkShaderStageFlagBits} values</li>
            <li>{@code stageFlags} <b>must</b> not be 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkIndirectCommandsPushConstantTokenEXT, ##VkIndirectExecutionSetShaderInfoEXT, ##VkPipelineLayoutCreateInfo, ##VkShaderCreateInfoEXT
        """

    VkShaderStageFlags("stageFlags", "a set of stage flags describing the shader stages that will access a range of push constants. If a particular stage is not included in the range, then accessing members of that range of push constants from the corresponding shader stage will return undefined values.")
    uint32_t("offset", "{@code offset} and {@code size} are the start offset and size, respectively, consumed by the range. Both {@code offset} and {@code size} are in units of bytes and <b>must</b> be a multiple of 4. The layout of the push constant variables is specified in the shader.")
    uint32_t("size", "see {@code offset}")
}

val VkPipelineLayoutCreateInfo = struct(Module.VULKAN, "VkPipelineLayoutCreateInfo") {
    documentation =
        """
        Structure specifying the parameters of a newly created pipeline layout object.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code setLayoutCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxBoundDescriptorSets}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_SAMPLER and #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageDescriptorSamplers}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_UNIFORM_BUFFER and #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageDescriptorUniformBuffers}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_STORAGE_BUFFER and #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageDescriptorStorageBuffers}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, #DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM, #DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM, and #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageDescriptorSampledImages}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_STORAGE_IMAGE, and #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageDescriptorStorageImages}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageDescriptorInputAttachments}</li>
            <li>The total number of bindings in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set and with a {@code descriptorType} of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK accessible to any given shader stage across all elements of {@code pSetLayouts}, <b>must</b> be less than or equal to ##VkPhysicalDeviceInlineUniformBlockProperties{@code ::maxPerStageDescriptorInlineUniformBlocks}</li>
            <li>The total number of descriptors with a {@code descriptorType} of #DESCRIPTOR_TYPE_SAMPLER and #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxPerStageDescriptorUpdateAfterBindSamplers}</li>
            <li>The total number of descriptors with a {@code descriptorType} of #DESCRIPTOR_TYPE_UNIFORM_BUFFER and #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxPerStageDescriptorUpdateAfterBindUniformBuffers}</li>
            <li>The total number of descriptors with a {@code descriptorType} of #DESCRIPTOR_TYPE_STORAGE_BUFFER and #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxPerStageDescriptorUpdateAfterBindStorageBuffers}</li>
            <li>The total number of descriptors with a {@code descriptorType} of #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, and #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxPerStageDescriptorUpdateAfterBindSampledImages}</li>
            <li>The total number of descriptors with a {@code descriptorType} of #DESCRIPTOR_TYPE_STORAGE_IMAGE, and #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxPerStageDescriptorUpdateAfterBindStorageImages}</li>
            <li>The total number of descriptors with a {@code descriptorType} of #DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxPerStageDescriptorUpdateAfterBindInputAttachments}</li>
            <li>The total number of bindings with a {@code descriptorType} of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceInlineUniformBlockProperties{@code ::maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_SAMPLER and #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetSamplers}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_UNIFORM_BUFFER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetUniformBuffers}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is not enabled, the total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetUniformBuffersDynamic}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is enabled, the total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxDescriptorSetTotalUniformBuffersDynamic">##VkPhysicalDeviceMaintenance7PropertiesKHR{@code ::maxDescriptorSetTotalUniformBuffersDynamic}</a></li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_STORAGE_BUFFER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetStorageBuffers}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is not enabled, the total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetStorageBuffersDynamic}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is enabled, the total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxDescriptorSetTotalStorageBuffersDynamic">##VkPhysicalDeviceMaintenance7PropertiesKHR{@code ::maxDescriptorSetTotalStorageBuffersDynamic}</a></li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxDescriptorSetTotalBuffersDynamic">##VkPhysicalDeviceMaintenance7PropertiesKHR{@code ::maxDescriptorSetTotalBuffersDynamic}</a></li>
            <li>The total number of descriptors of the type #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxDescriptorSetUpdateAfterBindTotalBuffersDynamic">##VkPhysicalDeviceMaintenance7PropertiesKHR{@code ::maxDescriptorSetUpdateAfterBindTotalBuffersDynamic}</a></li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, and #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetSampledImages}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_STORAGE_IMAGE, and #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetStorageImages}</li>
            <li>The total number of descriptors in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetInputAttachments}</li>
            <li>The total number of bindings in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceInlineUniformBlockProperties{@code ::maxDescriptorSetInlineUniformBlocks}</li>
            <li>The total number of descriptors of the type #DESCRIPTOR_TYPE_SAMPLER and #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxDescriptorSetUpdateAfterBindSamplers}</li>
            <li>The total number of descriptors of the type #DESCRIPTOR_TYPE_UNIFORM_BUFFER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxDescriptorSetUpdateAfterBindUniformBuffers}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is not enabled, the total number of descriptors of the type #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetUpdateAfterBindUniformBuffersDynamic}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is enabled, the total number of descriptors of the type #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxDescriptorSetUpdateAfterBindTotalUniformBuffersDynamic">##VkPhysicalDeviceMaintenance7PropertiesKHR{@code ::maxDescriptorSetUpdateAfterBindTotalUniformBuffersDynamic}</a></li>
            <li>The total number of descriptors of the type #DESCRIPTOR_TYPE_STORAGE_BUFFER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxDescriptorSetUpdateAfterBindStorageBuffers}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is not enabled, the total number of descriptors of the type #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxDescriptorSetUpdateAfterBindStorageBuffersDynamic}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is enabled, the total number of descriptors of the type #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxDescriptorSetUpdateAfterBindTotalStorageBuffersDynamic">##VkPhysicalDeviceMaintenance7PropertiesKHR{@code ::maxDescriptorSetUpdateAfterBindTotalStorageBuffersDynamic}</a></li>
            <li>The total number of descriptors of the type #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, and #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxDescriptorSetUpdateAfterBindSampledImages}</li>
            <li>The total number of descriptors of the type #DESCRIPTOR_TYPE_STORAGE_IMAGE, and #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxDescriptorSetUpdateAfterBindStorageImages}</li>
            <li>The total number of descriptors of the type #DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceDescriptorIndexingProperties{@code ::maxDescriptorSetUpdateAfterBindInputAttachments}</li>
            <li>The total number of bindings with a {@code descriptorType} of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceInlineUniformBlockProperties{@code ::maxDescriptorSetUpdateAfterBindInlineUniformBlocks}</li>
            <li>The total number of descriptors with a {@code descriptorType} of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceVulkan13Properties{@code ::maxInlineUniformTotalSize}</li>
            <li>Any two elements of {@code pPushConstantRanges} <b>must</b> not include the same stage in {@code stageFlags}</li>
            <li>{@code pSetLayouts} <b>must</b> not contain more than one descriptor set layout that was created with #DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT set</li>
            <li>The total number of bindings in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceAccelerationStructurePropertiesKHR{@code ::maxPerStageDescriptorAccelerationStructures}</li>
            <li>The total number of bindings with a {@code descriptorType} of #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR accessible to any given shader stage across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceAccelerationStructurePropertiesKHR{@code ::maxPerStageDescriptorUpdateAfterBindAccelerationStructures}</li>
            <li>The total number of bindings in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a {@code descriptorType} of #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceAccelerationStructurePropertiesKHR{@code ::maxDescriptorSetAccelerationStructures}</li>
            <li>The total number of bindings with a {@code descriptorType} of #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceAccelerationStructurePropertiesKHR{@code ::maxDescriptorSetUpdateAfterBindAccelerationStructures}</li>
            <li>The total number of bindings with a {@code descriptorType} of #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV accessible across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to ##VkPhysicalDeviceRayTracingPropertiesNV{@code ::maxDescriptorSetAccelerationStructures}</li>
            <li>The total number of {@code pImmutableSamplers} created with {@code flags} containing #SAMPLER_CREATE_SUBSAMPLED_BIT_EXT or #SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT across all shader stages and across all elements of {@code pSetLayouts} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxDescriptorSetSubsampledSamplers">##VkPhysicalDeviceFragmentDensityMap2PropertiesEXT{@code ::maxDescriptorSetSubsampledSamplers}</a></li>
            <li>Any element of {@code pSetLayouts} <b>must</b> not have been created with the #DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT bit set</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-graphicsPipelineLibrary">{@code graphicsPipelineLibrary}</a> feature is not enabled, elements of {@code pSetLayouts} <b>must</b> be valid {@code VkDescriptorSetLayout} objects</li>
            <li>If any element of {@code pSetLayouts} was created with the #DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT bit set, all elements of {@code pSetLayouts} <b>must</b> have been created with the #DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT bit set</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkPipelineLayoutCreateFlagBits} values</li>
            <li>If {@code setLayoutCount} is not 0, {@code pSetLayouts} <b>must</b> be a valid pointer to an array of {@code setLayoutCount} valid or #NULL_HANDLE {@code VkDescriptorSetLayout} handles</li>
            <li>If {@code pushConstantRangeCount} is not 0, {@code pPushConstantRanges} <b>must</b> be a valid pointer to an array of {@code pushConstantRangeCount} valid ##VkPushConstantRange structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkPushConstantRange, #CreatePipelineLayout()
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineLayoutCreateFlags("flags", "a bitmask of {@code VkPipelineLayoutCreateFlagBits} specifying options for pipeline layout creation.")
    AutoSize("pSetLayouts", optional = true)..uint32_t("setLayoutCount", "the number of descriptor sets included in the pipeline layout.")
    nullable..VkDescriptorSetLayout.const.p("pSetLayouts", "a pointer to an array of {@code VkDescriptorSetLayout} objects.")
    AutoSize("pPushConstantRanges", optional = true)..uint32_t("pushConstantRangeCount", "the number of push constant ranges included in the pipeline layout.")
    VkPushConstantRange.const.p("pPushConstantRanges", """a pointer to an array of ##VkPushConstantRange structures defining a set of push constant ranges for use in a single pipeline layout. In addition to descriptor set layouts, a pipeline layout also describes how many push constants <b>can</b> be accessed by each stage of the pipeline.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Push constants represent a high speed path to modify constant data in pipelines that is expected to outperform memory-backed resource updates.
        </div>""")
}

val VkSamplerCreateInfo = struct(Module.VULKAN, "VkSamplerCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created sampler.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Mapping of OpenGL to Vulkan Filter Modes</h5>
        {@code magFilter} values of #FILTER_NEAREST and #FILTER_LINEAR directly correspond to {@code GL_NEAREST} and {@code GL_LINEAR} magnification filters. {@code minFilter} and {@code mipmapMode} combine to correspond to the similarly named OpenGL minification filter of {@code GL_minFilter_MIPMAP_mipmapMode} (e.g. {@code minFilter} of #FILTER_LINEAR and {@code mipmapMode} of #SAMPLER_MIPMAP_MODE_NEAREST correspond to {@code GL_LINEAR_MIPMAP_NEAREST}).

        There are no Vulkan filter modes that directly correspond to OpenGL minification filters of {@code GL_LINEAR} or {@code GL_NEAREST}, but they <b>can</b> be emulated using #SAMPLER_MIPMAP_MODE_NEAREST, {@code minLod} = 0, and {@code maxLod} = 0.25, and using {@code minFilter} = #FILTER_LINEAR or {@code minFilter} = #FILTER_NEAREST, respectively.

        Note that using a {@code maxLod} of zero would cause <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#textures-texel-filtering">magnification</a> to always be performed, and the {@code magFilter} to always be used. This is valid, just not an exact match for OpenGL behavior. Clamping the maximum LOD to 0.25 allows the <code>λ</code> value to be non-zero and minification to be performed, while still always rounding down to the base level. If the {@code minFilter} and {@code magFilter} are equal, then using a {@code maxLod} of zero also works.
        </div>

        The maximum number of sampler objects which <b>can</b> be simultaneously created on a device is implementation-dependent and specified by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxSamplerAllocationCount">{@code maxSamplerAllocationCount}</a> member of the ##VkPhysicalDeviceLimits structure.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        For historical reasons, if {@code maxSamplerAllocationCount} is exceeded, some implementations may return #ERROR_TOO_MANY_OBJECTS. Exceeding this limit will result in undefined behavior, and an application should not rely on the use of the returned error code in order to identify when the limit is reached.
        </div>

        Since {@code VkSampler} is a non-dispatchable handle type, implementations <b>may</b> return the same handle for sampler state vectors that are identical. In such cases, all such objects would only count once against the {@code maxSamplerAllocationCount} limit.

        <h5>Valid Usage</h5>
        <ul>
            <li>The absolute value of {@code mipLodBias} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxSamplerLodBias}</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::samplerMipLodBias} is #FALSE, {@code mipLodBias} <b>must</b> be zero</li>
            <li>{@code maxLod} <b>must</b> be greater than or equal to {@code minLod}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-samplerAnisotropy">{@code samplerAnisotropy}</a> feature is not enabled, {@code anisotropyEnable} <b>must</b> be #FALSE</li>
            <li>If {@code anisotropyEnable} is #TRUE, {@code maxAnisotropy} <b>must</b> be between {@code 1.0} and ##VkPhysicalDeviceLimits{@code ::maxSamplerAnisotropy}, inclusive</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> is enabled and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> of the sampler Y′C<sub>B</sub>C<sub>R</sub> conversion do not support #FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT, {@code minFilter} and {@code magFilter} <b>must</b> be equal to the sampler Y′C<sub>B</sub>C<sub>R</sub> conversion’s {@code chromaFilter}</li>
            <li>If {@code unnormalizedCoordinates} is #TRUE, {@code minFilter} and {@code magFilter} <b>must</b> be equal</li>
            <li>If {@code unnormalizedCoordinates} is #TRUE, {@code mipmapMode} <b>must</b> be #SAMPLER_MIPMAP_MODE_NEAREST</li>
            <li>If {@code unnormalizedCoordinates} is #TRUE, {@code minLod} and {@code maxLod} <b>must</b> be zero</li>
            <li>If {@code unnormalizedCoordinates} is #TRUE, {@code addressModeU} and {@code addressModeV} <b>must</b> each be either #SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE or #SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER</li>
            <li>If {@code unnormalizedCoordinates} is #TRUE, {@code anisotropyEnable} <b>must</b> be #FALSE</li>
            <li>If {@code unnormalizedCoordinates} is #TRUE, {@code compareEnable} <b>must</b> be #FALSE</li>
            <li>If any of {@code addressModeU}, {@code addressModeV} or {@code addressModeW} are #SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER, {@code borderColor} <b>must</b> be a valid {@code VkBorderColor} value</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> is enabled, {@code addressModeU}, {@code addressModeV}, and {@code addressModeW} <b>must</b> be #SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE, {@code anisotropyEnable} <b>must</b> be #FALSE, and {@code unnormalizedCoordinates} <b>must</b> be #FALSE</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> is enabled and the {@code pNext} chain includes a ##VkSamplerReductionModeCreateInfo structure, then the sampler reduction mode <b>must</b> be #SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-samplerFilterMinmax">{@code samplerFilterMinmax}</a> feature is not enabled and the {@code pNext} chain includes a ##VkSamplerReductionModeCreateInfo structure, then the sampler reduction mode <b>must</b> be #SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-samplerMirrorClampToEdge">{@code samplerMirrorClampToEdge}</a> feature is not enabled, and if the {@link KHRSamplerMirrorClampToEdge VK_KHR_sampler_mirror_clamp_to_edge} extension is not enabled, {@code addressModeU}, {@code addressModeV} and {@code addressModeW} <b>must</b> not be #SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE</li>
            <li>If {@code compareEnable} is #TRUE, {@code compareOp} <b>must</b> be a valid {@code VkCompareOp} value</li>
            <li>If either {@code magFilter} or {@code minFilter} is #FILTER_CUBIC_EXT, {@code anisotropyEnable} <b>must</b> be #FALSE</li>
            <li>If the {@link EXTFilterCubic VK_EXT_filter_cubic} extension is not enabled and either {@code magFilter} or {@code minFilter} is #FILTER_CUBIC_IMG, the {@code reductionMode} member of ##VkSamplerReductionModeCreateInfo <b>must</b> be #SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE</li>
            <li>If {@code compareEnable} is #TRUE, the {@code reductionMode} member of ##VkSamplerReductionModeCreateInfo <b>must</b> be #SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then {@code minFilter} and {@code magFilter} <b>must</b> be equal</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then {@code mipmapMode} <b>must</b> be #SAMPLER_MIPMAP_MODE_NEAREST</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then {@code minLod} and {@code maxLod} <b>must</b> be zero</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then {@code addressModeU} and {@code addressModeV} <b>must</b> each be either #SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE or #SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then {@code anisotropyEnable} <b>must</b> be #FALSE</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then {@code compareEnable} <b>must</b> be #FALSE</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then {@code unnormalizedCoordinates} <b>must</b> be #FALSE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-nonSeamlessCubeMap">{@code nonSeamlessCubeMap}</a> feature is not enabled, {@code flags} <b>must</b> not include #SAMPLER_CREATE_NON_SEAMLESS_CUBE_MAP_BIT_EXT</li>
            <li>If {@code borderColor} is one of #BORDER_COLOR_FLOAT_CUSTOM_EXT or #BORDER_COLOR_INT_CUSTOM_EXT, then a ##VkSamplerCustomBorderColorCreateInfoEXT <b>must</b> be included in the {@code pNext} chain</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-customBorderColors">{@code customBorderColors}</a> feature is not enabled, {@code borderColor} <b>must</b> not be #BORDER_COLOR_FLOAT_CUSTOM_EXT or #BORDER_COLOR_INT_CUSTOM_EXT</li>
            <li>If {@code borderColor} is one of #BORDER_COLOR_FLOAT_CUSTOM_EXT or #BORDER_COLOR_INT_CUSTOM_EXT, and ##VkSamplerCustomBorderColorCreateInfoEXT{@code ::format} is not #FORMAT_UNDEFINED, ##VkSamplerCustomBorderColorCreateInfoEXT{@code ::customBorderColor} <b>must</b> be within the range of values representable in {@code format}</li>
            <li>The maximum number of samplers with custom border colors which <b>can</b> be simultaneously created on a device is implementation-dependent and specified by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxCustomBorderColorSamplers">{@code maxCustomBorderColorSamplers}</a> member of the ##VkPhysicalDeviceCustomBorderColorPropertiesEXT structure</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBufferCaptureReplay">{@code descriptorBufferCaptureReplay}</a> feature <b>must</b> be enabled</li>
            <li>If the {@code pNext} chain includes a ##VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, {@code flags} <b>must</b> contain #SAMPLER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM, then {@code minFilter} and {@code magFilter} <b>must</b> be #FILTER_NEAREST</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM, then {@code mipmapMode} <b>must</b> be #SAMPLER_MIPMAP_MODE_NEAREST</li>
            <li>[If {@code flags} includes #SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM, then {@code minLod} and {@code maxLod} <b>must</b> be zero</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM, then {@code addressModeU} and {@code addressModeV} <b>must</b> each be either #SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE or #SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM, and if {@code addressModeU} or {@code addressModeV} is #SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER, then {@code borderColor} <b>must</b> be #BORDER_COLOR_FLOAT_TRANSPARENT_BLACK</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM, then {@code anisotropyEnable} <b>must</b> be #FALSE</li>
            <li>If {@code flags} includes #SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM, then {@code compareEnable} <b>must</b> be #FALSE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SAMPLER_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkOpaqueCaptureDescriptorDataCreateInfoEXT, ##VkSamplerBlockMatchWindowCreateInfoQCOM, ##VkSamplerBorderColorComponentMappingCreateInfoEXT, ##VkSamplerCubicWeightsCreateInfoQCOM, ##VkSamplerCustomBorderColorCreateInfoEXT, ##VkSamplerReductionModeCreateInfo, or ##VkSamplerYcbcrConversionInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkSamplerCreateFlagBits} values</li>
            <li>{@code magFilter} <b>must</b> be a valid {@code VkFilter} value</li>
            <li>{@code minFilter} <b>must</b> be a valid {@code VkFilter} value</li>
            <li>{@code mipmapMode} <b>must</b> be a valid {@code VkSamplerMipmapMode} value</li>
            <li>{@code addressModeU} <b>must</b> be a valid {@code VkSamplerAddressMode} value</li>
            <li>{@code addressModeV} <b>must</b> be a valid {@code VkSamplerAddressMode} value</li>
            <li>{@code addressModeW} <b>must</b> be a valid {@code VkSamplerAddressMode} value</li>
        </ul>

        <h5>See Also</h5>
        #CreateSampler()
        """

    Expression("#STRUCTURE_TYPE_SAMPLER_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkOpaqueCaptureDescriptorDataCreateInfoEXT", "VkSamplerBlockMatchWindowCreateInfoQCOM", "VkSamplerBorderColorComponentMappingCreateInfoEXT", "VkSamplerCubicWeightsCreateInfoQCOM", "VkSamplerCustomBorderColorCreateInfoEXT", "VkSamplerReductionModeCreateInfo", "VkSamplerReductionModeCreateInfoEXT", "VkSamplerYcbcrConversionInfo", "VkSamplerYcbcrConversionInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSamplerCreateFlags("flags", "a bitmask of {@code VkSamplerCreateFlagBits} describing additional parameters of the sampler.")
    VkFilter("magFilter", "a {@code VkFilter} value specifying the magnification filter to apply to lookups.")
    VkFilter("minFilter", "a {@code VkFilter} value specifying the minification filter to apply to lookups.")
    VkSamplerMipmapMode("mipmapMode", "a {@code VkSamplerMipmapMode} value specifying the mipmap filter to apply to lookups.")
    VkSamplerAddressMode("addressModeU", "a {@code VkSamplerAddressMode} value specifying the addressing mode for U coordinates outside <code>[0,1)</code>.")
    VkSamplerAddressMode("addressModeV", "a {@code VkSamplerAddressMode} value specifying the addressing mode for V coordinates outside <code>[0,1)</code>.")
    VkSamplerAddressMode("addressModeW", "a {@code VkSamplerAddressMode} value specifying the addressing mode for W coordinates outside <code>[0,1)</code>.")
    float("mipLodBias", "the bias to be added to mipmap LOD calculation and bias provided by image sampling functions in SPIR-V, as described in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#textures-level-of-detail-operation\">LOD Operation</a> section.")
    VkBool32("anisotropyEnable", "#TRUE to enable anisotropic filtering, as described in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#textures-texel-anisotropic-filtering\">Texel Anisotropic Filtering</a> section, or #FALSE otherwise.")
    float("maxAnisotropy", "the anisotropy value clamp used by the sampler when {@code anisotropyEnable} is #TRUE. If {@code anisotropyEnable} is #FALSE, {@code maxAnisotropy} is ignored.")
    VkBool32("compareEnable", """#TRUE to enable comparison against a reference value during lookups, or #FALSE otherwise.

        <ul>
            <li>Note: Some implementations will default to shader state if this member does not match.</li>
        </ul>""")
    VkCompareOp("compareOp", "a {@code VkCompareOp} value specifying the comparison operator to apply to fetched data before filtering as described in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#textures-depth-compare-operation\">Depth Compare Operation</a> section.")
    float("minLod", "used to clamp the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#textures-level-of-detail-operation\">minimum of the computed LOD value</a>.")
    float("maxLod", "used to clamp the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#textures-level-of-detail-operation\">maximum of the computed LOD value</a>. To avoid clamping the maximum value, set {@code maxLod} to the constant #LOD_CLAMP_NONE.")
    VkBorderColor("borderColor", "a {@code VkBorderColor} value specifying the predefined border color to use.")
    VkBool32("unnormalizedCoordinates", """controls whether to use unnormalized or normalized texel coordinates to address texels of the image. When {@code unnormalizedCoordinates} is #TRUE, the range of the image coordinates used to lookup the texel is in the range of zero to the image size in each dimension. When {@code unnormalizedCoordinates} is #FALSE, the range of image coordinates is zero to one.

        When {@code unnormalizedCoordinates} is #TRUE, images the sampler is used with in the shader have the following requirements:

        <ul>
            <li>The {@code viewType} <b>must</b> be either #IMAGE_VIEW_TYPE_1D or #IMAGE_VIEW_TYPE_2D.</li>
            <li>
                The image view <b>must</b> have a single layer and a single mip level.
                When {@code unnormalizedCoordinates} is #TRUE, image built-in functions in the shader that use the sampler have the following requirements:
            </li>
            <li>The functions <b>must</b> not use projection.</li>
            <li>The functions <b>must</b> not use offsets.</li>
        </ul>""")
}

val VkCopyDescriptorSet = struct(Module.VULKAN, "VkCopyDescriptorSet") {
    documentation =
        """
        Structure specifying a copy descriptor set operation.

        <h5>Description</h5>
        If the ##VkDescriptorSetLayoutBinding for {@code dstBinding} is #DESCRIPTOR_TYPE_MUTABLE_EXT and {@code srcBinding} is not #DESCRIPTOR_TYPE_MUTABLE_EXT, the new active descriptor type becomes the descriptor type of {@code srcBinding}. If both ##VkDescriptorSetLayoutBinding for {@code srcBinding} and {@code dstBinding} are #DESCRIPTOR_TYPE_MUTABLE_EXT, the active descriptor type in each source descriptor is copied into the corresponding destination descriptor. The active descriptor type <b>can</b> be different for each source descriptor.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The intention is that copies to and from mutable descriptors is a simple memcpy. Copies between non-mutable and mutable descriptors are expected to require one memcpy per descriptor to handle the difference in size, but this use case with more than one {@code descriptorCount} is considered rare.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code srcBinding} <b>must</b> be a valid binding within {@code srcSet}</li>
            <li>The sum of {@code srcArrayElement} and {@code descriptorCount} <b>must</b> be less than or equal to the number of array elements in the descriptor set binding specified by {@code srcBinding}, and all applicable <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-updates-consecutive">consecutive bindings</a></li>
            <li>{@code dstBinding} <b>must</b> be a valid binding within {@code dstSet}</li>
            <li>The sum of {@code dstArrayElement} and {@code descriptorCount} <b>must</b> be less than or equal to the number of array elements in the descriptor set binding specified by {@code dstBinding}, and all applicable <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-updates-consecutive">consecutive bindings</a></li>
            <li>The type of {@code dstBinding} within {@code dstSet} <b>must</b> be equal to the type of {@code srcBinding} within {@code srcSet}</li>
            <li>If {@code srcSet} is equal to {@code dstSet}, then the source and destination ranges of descriptors <b>must</b> not overlap, where the ranges <b>may</b> include array elements from <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-updates-consecutive">consecutive bindings</a></li>
            <li>If the descriptor type of the descriptor set binding specified by {@code srcBinding} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, {@code srcArrayElement} <b>must</b> be an integer multiple of 4</li>
            <li>If the descriptor type of the descriptor set binding specified by {@code dstBinding} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, {@code dstArrayElement} <b>must</b> be an integer multiple of 4</li>
            <li>If the descriptor type of the descriptor set binding specified by either {@code srcBinding} or {@code dstBinding} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, {@code descriptorCount} <b>must</b> be an integer multiple of 4</li>
            <li>If {@code srcSet}’s layout was created with the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then {@code dstSet}’s layout <b>must</b> also have been created with the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set</li>
            <li>If {@code srcSet}’s layout was created without either the #DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT flag or the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then {@code dstSet}’s layout <b>must</b> have been created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set</li>
            <li>If the descriptor pool from which {@code srcSet} was allocated was created with the #DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which {@code dstSet} was allocated <b>must</b> also have been created with the #DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set</li>
            <li>If the descriptor pool from which {@code srcSet} was allocated was created without either the #DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag or the #DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which {@code dstSet} was allocated <b>must</b> have been created without the #DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set</li>
            <li>If the descriptor type of the descriptor set binding specified by {@code dstBinding} is #DESCRIPTOR_TYPE_SAMPLER, then {@code dstSet} <b>must</b> not have been allocated with a layout that included immutable samplers for {@code dstBinding}</li>
            <li>If ##VkDescriptorSetLayoutBinding for {@code dstSet} at {@code dstBinding} is #DESCRIPTOR_TYPE_MUTABLE_EXT, the new active descriptor type <b>must</b> exist in the corresponding {@code pMutableDescriptorTypeLists} list for {@code dstBinding} if the new active descriptor type is not #DESCRIPTOR_TYPE_MUTABLE_EXT</li>
            <li>If ##VkDescriptorSetLayoutBinding for {@code srcSet} at {@code srcBinding} is #DESCRIPTOR_TYPE_MUTABLE_EXT and the ##VkDescriptorSetLayoutBinding for {@code dstSet} at {@code dstBinding} is not #DESCRIPTOR_TYPE_MUTABLE_EXT, the active descriptor type for the source descriptor <b>must</b> match the descriptor type of {@code dstBinding}</li>
            <li>If ##VkDescriptorSetLayoutBinding for {@code dstSet} at {@code dstBinding} is #DESCRIPTOR_TYPE_MUTABLE_EXT, and the new active descriptor type is #DESCRIPTOR_TYPE_MUTABLE_EXT, the {@code pMutableDescriptorTypeLists} for {@code srcBinding} and {@code dstBinding} <b>must</b> match exactly</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COPY_DESCRIPTOR_SET</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code srcSet} <b>must</b> be a valid {@code VkDescriptorSet} handle</li>
            <li>{@code dstSet} <b>must</b> be a valid {@code VkDescriptorSet} handle</li>
            <li>Both of {@code dstSet}, and {@code srcSet} <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #UpdateDescriptorSets()
        """

    Expression("#STRUCTURE_TYPE_COPY_DESCRIPTOR_SET")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDescriptorSet("srcSet", "{@code srcSet}, {@code srcBinding}, and {@code srcArrayElement} are the source set, binding, and array element, respectively. If the descriptor binding identified by {@code srcSet} and {@code srcBinding} has a descriptor type of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then {@code srcArrayElement} specifies the starting byte offset within the binding to copy from.")
    uint32_t("srcBinding", "see {@code srcSet}")
    uint32_t("srcArrayElement", "see {@code srcSet}")
    VkDescriptorSet("dstSet", "{@code dstSet}, {@code dstBinding}, and {@code dstArrayElement} are the destination set, binding, and array element, respectively. If the descriptor binding identified by {@code dstSet} and {@code dstBinding} has a descriptor type of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then {@code dstArrayElement} specifies the starting byte offset within the binding to copy to.")
    uint32_t("dstBinding", "see {@code dstSet}")
    uint32_t("dstArrayElement", "see {@code dstSet}")
    uint32_t("descriptorCount", "the number of descriptors to copy from the source to destination. If {@code descriptorCount} is greater than the number of remaining array elements in the source or destination binding, those affect consecutive bindings in a manner similar to ##VkWriteDescriptorSet above. If the descriptor binding identified by {@code srcSet} and {@code srcBinding} has a descriptor type of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then {@code descriptorCount} specifies the number of bytes to copy and the remaining array elements in the source or destination binding refer to the remaining number of bytes in those.")
}

val VkDescriptorBufferInfo = struct(Module.VULKAN, "VkDescriptorBufferInfo") {
    documentation =
        """
        Structure specifying descriptor buffer information.

        <h5>Description</h5>
        For #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC and #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC descriptor types, {@code offset} is the base offset from which the dynamic offset is applied and {@code range} is the static size used for all dynamic offsets.

        When {@code range} is #WHOLE_SIZE the effective range is calculated at #UpdateDescriptorSets() is by taking the size of {@code buffer} minus the {@code offset}.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code offset} <b>must</b> be less than the size of {@code buffer}</li>
            <li>If {@code range} is not equal to #WHOLE_SIZE, {@code range} <b>must</b> be greater than 0</li>
            <li>If {@code range} is not equal to #WHOLE_SIZE, {@code range} <b>must</b> be less than or equal to the size of {@code buffer} minus {@code offset}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-nullDescriptor">{@code nullDescriptor}</a> feature is not enabled, {@code buffer} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code buffer} is #NULL_HANDLE, {@code offset} <b>must</b> be zero and {@code range} <b>must</b> be #WHOLE_SIZE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>If {@code buffer} is not #NULL_HANDLE, {@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
        </ul>

        <h5>See Also</h5>
        ##VkWriteDescriptorSet
        """

    VkBuffer("buffer", "#NULL_HANDLE or the buffer resource.")
    VkDeviceSize("offset", "the offset in bytes from the start of {@code buffer}. Access to buffer memory via this descriptor uses addressing that is relative to this starting offset.")
    VkDeviceSize("range", """the size in bytes that is used for this descriptor update, or #WHOLE_SIZE to use the range from {@code offset} to the end of the buffer.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        When setting {@code range} to #WHOLE_SIZE, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#buffer-info-effective-range">effective range</a> <b>must</b> not be larger than the maximum range for the descriptor type (<a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxUniformBufferRange">{@code maxUniformBufferRange}</a> or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxStorageBufferRange">{@code maxStorageBufferRange}</a>). This means that #WHOLE_SIZE is not typically useful in the common case where uniform buffer descriptors are suballocated from a buffer that is much larger than {@code maxUniformBufferRange}.
        </div>""")
}

val VkDescriptorImageInfo = struct(Module.VULKAN, "VkDescriptorImageInfo") {
    documentation =
        """
        Structure specifying descriptor image information.

        <h5>Description</h5>
        Members of ##VkDescriptorImageInfo that are not used in an update (as described above) are ignored.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code imageView} <b>must</b> not be a 2D array image view created from a 3D image</li>
            <li>If {@code imageView} is a 2D view created from a 3D image, then {@code descriptorType} <b>must</b> be #DESCRIPTOR_TYPE_STORAGE_IMAGE, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER</li>
            <li>If {@code imageView} is a 2D view created from a 3D image, then the image <b>must</b> have been created with #IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-image2DViewOf3D">{@code image2DViewOf3D}</a> feature is not enabled or {@code descriptorType} is not #DESCRIPTOR_TYPE_STORAGE_IMAGE then {@code imageView} <b>must</b> not be a 2D view created from a 3D image</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-sampler2DViewOf3D">{@code sampler2DViewOf3D}</a> feature is not enabled or {@code descriptorType} is not #DESCRIPTOR_TYPE_SAMPLED_IMAGE or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER then {@code imageView} <b>must</b> not be a 2D view created from a 3D image</li>
            <li>If {@code imageView} is created from a depth/stencil image, the {@code aspectMask} used to create the {@code imageView} <b>must</b> include either #IMAGE_ASPECT_DEPTH_BIT or #IMAGE_ASPECT_STENCIL_BIT but not both</li>
            <li>If {@code imageLayout} is #IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, then the {@code aspectMask} used to create {@code imageView} <b>must</b> not include either #IMAGE_ASPECT_DEPTH_BIT or #IMAGE_ASPECT_STENCIL_BIT</li>
            <li>If {@code imageLayout} is #IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, then the {@code aspectMask} used to create {@code imageView} <b>must</b> not include #IMAGE_ASPECT_COLOR_BIT</li>
            <li>{@code imageLayout} <b>must</b> match the actual {@code VkImageLayout} of each subresource accessible from {@code imageView} at the time this descriptor is accessed as defined by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-layouts-matching-rule">image layout matching rules</a></li>
            <li>If {@code sampler} is used and the {@code VkFormat} of the image is a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar format</a>, the image <b>must</b> have been created with #IMAGE_CREATE_MUTABLE_FORMAT_BIT, and the {@code aspectMask} of the {@code imageView} <b>must</b> be a valid <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-planes-image-aspect">multi-planar aspect mask</a> bit</li>
            <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and ##VkPhysicalDevicePortabilitySubsetFeaturesKHR{@code ::mutableComparisonSamplers} is #FALSE, then {@code sampler} <b>must</b> have been created with ##VkSamplerCreateInfo{@code ::compareEnable} set to #FALSE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>Both of {@code imageView}, and {@code sampler} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkDescriptorDataEXT, ##VkWriteDescriptorSet
        """

    VkSampler("sampler", "a sampler handle, and is used in descriptor updates for types #DESCRIPTOR_TYPE_SAMPLER and #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER if the binding being updated does not use immutable samplers.")
    VkImageView("imageView", "#NULL_HANDLE or an image view handle, and is used in descriptor updates for types #DESCRIPTOR_TYPE_SAMPLED_IMAGE, #DESCRIPTOR_TYPE_STORAGE_IMAGE, #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and #DESCRIPTOR_TYPE_INPUT_ATTACHMENT.")
    VkImageLayout("imageLayout", "the layout that the image subresources accessible from {@code imageView} will be in at the time this descriptor is accessed. {@code imageLayout} is used in descriptor updates for types #DESCRIPTOR_TYPE_SAMPLED_IMAGE, #DESCRIPTOR_TYPE_STORAGE_IMAGE, #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and #DESCRIPTOR_TYPE_INPUT_ATTACHMENT.")
}

val VkDescriptorPoolSize = struct(Module.VULKAN, "VkDescriptorPoolSize") {
    documentation =
        """
        Structure specifying descriptor pool size.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        When creating a descriptor pool that will contain descriptors for combined image samplers of multi-planar formats, an application needs to account for non-trivial descriptor consumption when choosing the {@code descriptorCount} value, as indicated by ##VkSamplerYcbcrConversionImageFormatProperties{@code ::combinedImageSamplerDescriptorCount}.

        For simplicity the application <b>can</b> use the ##VkPhysicalDeviceMaintenance6Properties{@code ::maxCombinedImageSamplerDescriptorCount} property, which is sized to accommodate any and all <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">formats that require a sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> supported by the implementation.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code descriptorCount} <b>must</b> be greater than 0</li>
            <li>If {@code type} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then {@code descriptorCount} <b>must</b> be a multiple of 4</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code type} <b>must</b> be a valid {@code VkDescriptorType} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkDescriptorPoolCreateInfo
        """

    VkDescriptorType("type", "the type of descriptor.")
    uint32_t("descriptorCount", "the number of descriptors of that type to allocate. If {@code type} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then {@code descriptorCount} is the number of bytes to allocate for descriptors of this type.")
}

val VkDescriptorPoolCreateInfo = struct(Module.VULKAN, "VkDescriptorPoolCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created descriptor pool.

        <h5>Description</h5>
        If multiple ##VkDescriptorPoolSize structures containing the same descriptor type appear in the {@code pPoolSizes} array then the pool will be created with enough storage for the total number of descriptors of each type.

        Fragmentation of a descriptor pool is possible and <b>may</b> lead to descriptor set allocation failures. A failure due to fragmentation is defined as failing a descriptor set allocation despite the sum of all outstanding descriptor set allocations from the pool plus the requested allocation requiring no more than the total number of descriptors requested at pool creation. Implementations provide certain guarantees of when fragmentation <b>must</b> not cause allocation failure, as described below.

        If a descriptor pool has not had any descriptor sets freed since it was created or most recently reset then fragmentation <b>must</b> not cause an allocation failure (note that this is always the case for a pool created without the #DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT bit set). Additionally, if all sets allocated from the pool since it was created or most recently reset use the same number of descriptors (of each type) and the requested allocation also uses that same number of descriptors (of each type), then fragmentation <b>must</b> not cause an allocation failure.

        If an allocation failure occurs due to fragmentation, an application <b>can</b> create an additional descriptor pool to perform further descriptor set allocations.

        If {@code flags} has the #DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT bit set, descriptor pool creation <b>may</b> fail with the error #ERROR_FRAGMENTATION if the total number of descriptors across all pools (including this one) created with this bit set exceeds {@code maxUpdateAfterBindDescriptorsInAllPools}, or if fragmentation of the underlying hardware resources occurs.

        If a {@code pPoolSizes}[i]{@code ::type} is #DESCRIPTOR_TYPE_MUTABLE_EXT, a ##VkMutableDescriptorTypeCreateInfoEXT struct in the {@code pNext} chain <b>can</b> be used to specify which mutable descriptor types <b>can</b> be allocated from the pool. If included in the {@code pNext} chain, ##VkMutableDescriptorTypeCreateInfoEXT{@code ::pMutableDescriptorTypeLists}[i] specifies which kind of #DESCRIPTOR_TYPE_MUTABLE_EXT descriptors <b>can</b> be allocated from this pool entry. If ##VkMutableDescriptorTypeCreateInfoEXT does not exist in the {@code pNext} chain, or ##VkMutableDescriptorTypeCreateInfoEXT{@code ::pMutableDescriptorTypeLists}[i] is out of range, the descriptor pool allocates enough memory to be able to allocate a #DESCRIPTOR_TYPE_MUTABLE_EXT descriptor with any supported {@code VkDescriptorType} as a mutable descriptor. A mutable descriptor <b>can</b> be allocated from a pool entry if the type list in ##VkDescriptorSetLayoutCreateInfo is a subset of the type list declared in the descriptor pool, or if the pool entry is created without a descriptor type list. Multiple {@code pPoolSizes} entries with #DESCRIPTOR_TYPE_MUTABLE_EXT <b>can</b> be declared. When multiple such pool entries are present in {@code pPoolSizes}, they specify sets of supported descriptor types which either fully overlap, partially overlap, or are disjoint. Two sets fully overlap if the sets of supported descriptor types are equal. If the sets are not disjoint they partially overlap. A pool entry without a ##VkMutableDescriptorTypeListEXT assigned to it is considered to partially overlap any other pool entry which has a ##VkMutableDescriptorTypeListEXT assigned to it. The application <b>must</b> ensure that partial overlap does not exist in {@code pPoolSizes}.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The requirement of no partial overlap is intended to resolve ambiguity for validation as there is no confusion which {@code pPoolSizes} entries will be allocated from. An implementation is not expected to depend on this requirement.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorPoolOverallocation">{@code descriptorPoolOverallocation}</a> feature is not enabled, or {@code flags} does not have #DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV set, {@code maxSets} <b>must</b> be greater than 0</li>
            <li>If {@code flags} has the #DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV or #DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV bits set, then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorPoolOverallocation">{@code descriptorPoolOverallocation}</a> <b>must</b> be enabled</li>
            <li>If {@code flags} has the #DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT bit set, then the #DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT bit <b>must</b> not be set</li>
            <li>If ##VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT{@code ::mutableDescriptorType} is not enabled, {@code pPoolSizes} <b>must</b> not contain a {@code descriptorType} of #DESCRIPTOR_TYPE_MUTABLE_EXT</li>
            <li>If {@code flags} has the #DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT bit set, ##VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT{@code ::mutableDescriptorType} <b>must</b> be enabled</li>
            <li>If {@code pPoolSizes} contains a {@code descriptorType} of #DESCRIPTOR_TYPE_MUTABLE_EXT, any other #DESCRIPTOR_TYPE_MUTABLE_EXT element in {@code pPoolSizes} <b>must</b> not have sets of supported descriptor types which partially overlap</li>
            <li>If {@code pPoolSizes} contains a {@code descriptorType} of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, the {@code pNext} chain <b>must</b> include a ##VkDescriptorPoolInlineUniformBlockCreateInfo structure whose {@code maxInlineUniformBlockBindings} member is not zero</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDescriptorPoolInlineUniformBlockCreateInfo or ##VkMutableDescriptorTypeCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkDescriptorPoolCreateFlagBits} values</li>
            <li>If {@code poolSizeCount} is not 0, {@code pPoolSizes} <b>must</b> be a valid pointer to an array of {@code poolSizeCount} valid ##VkDescriptorPoolSize structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkDescriptorPoolSize, #CreateDescriptorPool()
        """

    Expression("#STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDescriptorPoolInlineUniformBlockCreateInfo", "VkDescriptorPoolInlineUniformBlockCreateInfoEXT", "VkMutableDescriptorTypeCreateInfoEXT", "VkMutableDescriptorTypeCreateInfoVALVE",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDescriptorPoolCreateFlags("flags", "a bitmask of {@code VkDescriptorPoolCreateFlagBits} specifying certain supported operations on the pool.")
    uint32_t("maxSets", "the maximum number of descriptor sets that <b>can</b> be allocated from the pool.")
    AutoSize("pPoolSizes", optional = true)..uint32_t("poolSizeCount", "the number of elements in {@code pPoolSizes}.")
    VkDescriptorPoolSize.const.p("pPoolSizes", "a pointer to an array of ##VkDescriptorPoolSize structures, each containing a descriptor type and number of descriptors of that type to be allocated in the pool.")
}

val VkDescriptorSetAllocateInfo = struct(Module.VULKAN, "VkDescriptorSetAllocateInfo") {
    documentation =
        """
        Structure specifying the allocation parameters for descriptor sets.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@link KHRMaintenance1 VK_KHR_maintenance1} extension is not enabled and ##VkPhysicalDeviceProperties{@code ::apiVersion} is less than Vulkan 1.1, {@code descriptorSetCount} <b>must</b> not be greater than the number of sets that are currently available for allocation in {@code descriptorPool}</li>
            <li>If the {@link KHRMaintenance1 VK_KHR_maintenance1} extension is not enabled and ##VkPhysicalDeviceProperties{@code ::apiVersion} is less than Vulkan 1.1, {@code descriptorPool} <b>must</b> have enough free descriptor capacity remaining to allocate the descriptor sets of the specified layouts</li>
            <li>Each element of {@code pSetLayouts} <b>must</b> not have been created with #DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT set</li>
            <li>If any element of {@code pSetLayouts} was created with the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set, {@code descriptorPool} <b>must</b> have been created with the #DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set</li>
            <li>If {@code pSetLayouts}[i] was created with an element of {@code pBindingFlags} that includes #DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, and ##VkDescriptorSetVariableDescriptorCountAllocateInfo is included in the {@code pNext} chain, and ##VkDescriptorSetVariableDescriptorCountAllocateInfo{@code ::descriptorSetCount} is not zero, then ##VkDescriptorSetVariableDescriptorCountAllocateInfo{@code ::pDescriptorCounts}[i] <b>must</b> be less than or equal to ##VkDescriptorSetLayoutBinding{@code ::descriptorCount} for the corresponding binding used to create {@code pSetLayouts}[i]</li>
            <li>If any element of {@code pSetLayouts} was created with the #DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT bit set, {@code descriptorPool} <b>must</b> have been created with the #DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag set</li>
            <li>Each element of {@code pSetLayouts} <b>must</b> not have been created with the #DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT bit set</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkDescriptorSetVariableDescriptorCountAllocateInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code descriptorPool} <b>must</b> be a valid {@code VkDescriptorPool} handle</li>
            <li>{@code pSetLayouts} <b>must</b> be a valid pointer to an array of {@code descriptorSetCount} valid {@code VkDescriptorSetLayout} handles</li>
            <li>{@code descriptorSetCount} <b>must</b> be greater than 0</li>
            <li>Both of {@code descriptorPool}, and the elements of {@code pSetLayouts} <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #AllocateDescriptorSets()
        """

    Expression("#STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDescriptorSetVariableDescriptorCountAllocateInfo", "VkDescriptorSetVariableDescriptorCountAllocateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDescriptorPool("descriptorPool", "the pool which the sets will be allocated from.")
    AutoSize("pSetLayouts")..uint32_t("descriptorSetCount", "determines the number of descriptor sets to be allocated from the pool.")
    VkDescriptorSetLayout.const.p("pSetLayouts", "a pointer to an array of descriptor set layouts, with each member specifying how the corresponding descriptor set is allocated.")
}

val VkDescriptorSetLayoutBinding = struct(Module.VULKAN, "VkDescriptorSetLayoutBinding") {
    documentation =
        """
        Structure specifying a descriptor set layout binding.

        <h5>Description</h5>
        The above layout definition allows the descriptor bindings to be specified sparsely such that not all binding numbers between 0 and the maximum binding number need to be specified in the {@code pBindings} array. Bindings that are not specified have a {@code descriptorCount} and {@code stageFlags} of zero, and the value of {@code descriptorType} is undefined. However, all binding numbers between 0 and the maximum binding number in the ##VkDescriptorSetLayoutCreateInfo{@code ::pBindings} array <b>may</b> consume memory in the descriptor set layout even if not all descriptor bindings are used, though it <b>should</b> not consume additional memory from the descriptor pool.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The maximum binding number specified <b>should</b> be as compact as possible to avoid wasted memory.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_SAMPLER or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and {@code descriptorCount} is not 0 and {@code pImmutableSamplers} is not {@code NULL}, {@code pImmutableSamplers} <b>must</b> be a valid pointer to an array of {@code descriptorCount} valid {@code VkSampler} handles</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-inlineUniformBlock">{@code inlineUniformBlock}</a> feature is not enabled, {@code descriptorType} <b>must</b> not be #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then {@code descriptorCount} <b>must</b> be a multiple of 4</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK and ##VkDescriptorSetLayoutCreateInfo{@code ::flags} does not contain #DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT then {@code descriptorCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceInlineUniformBlockProperties{@code ::maxInlineUniformBlockSize}</li>
            <li>If ##VkDescriptorSetLayoutCreateInfo{@code ::flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, {@code descriptorType} <b>must</b> be #DESCRIPTOR_TYPE_SAMPLER</li>
            <li>If ##VkDescriptorSetLayoutCreateInfo{@code ::flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, {@code descriptorCount} <b>must</b> less than or equal to 1</li>
            <li>If ##VkDescriptorSetLayoutCreateInfo{@code ::flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, and {@code descriptorCount} is equal to 1, {@code pImmutableSamplers} <b>must</b> not be {@code NULL}</li>
            <li>If {@code descriptorCount} is not 0, {@code stageFlags} <b>must</b> be #SHADER_STAGE_ALL or a valid combination of other {@code VkShaderStageFlagBits} values</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INPUT_ATTACHMENT and {@code descriptorCount} is not 0, then {@code stageFlags} <b>must</b> be 0 or #SHADER_STAGE_FRAGMENT_BIT</li>
            <li>The sampler objects indicated by {@code pImmutableSamplers} <b>must</b> not have a {@code borderColor} with one of the values #BORDER_COLOR_FLOAT_CUSTOM_EXT or #BORDER_COLOR_INT_CUSTOM_EXT</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_MUTABLE_EXT, then {@code pImmutableSamplers} <b>must</b> be {@code NULL}</li>
            <li>If ##VkDescriptorSetLayoutCreateInfo{@code ::flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, and {@code descriptorCount} is not 0, then {@code stageFlags} <b>must</b> be a valid combination of #SHADER_STAGE_VERTEX_BIT, #SHADER_STAGE_TESSELLATION_CONTROL_BIT, #SHADER_STAGE_TESSELLATION_EVALUATION_BIT, #SHADER_STAGE_GEOMETRY_BIT, #SHADER_STAGE_FRAGMENT_BIT and #SHADER_STAGE_COMPUTE_BIT values</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code descriptorType} <b>must</b> be a valid {@code VkDescriptorType} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkDescriptorSetLayoutCreateInfo
        """

    uint32_t("binding", "the binding number of this entry and corresponds to a resource of the same binding number in the shader stages.")
    VkDescriptorType("descriptorType", "a {@code VkDescriptorType} specifying which type of resource descriptors are used for this binding.")
    AutoSize("pImmutableSamplers", optional = true)..uint32_t("descriptorCount", "the number of descriptors contained in the binding, accessed in a shader as an array, except if {@code descriptorType} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK in which case {@code descriptorCount} is the size in bytes of the inline uniform block. If {@code descriptorCount} is zero this binding entry is reserved and the resource <b>must</b> not be accessed from any stage via this binding within any pipeline using the set layout.")
    VkShaderStageFlags("stageFlags", """member is a bitmask of {@code VkShaderStageFlagBits} specifying which pipeline shader stages <b>can</b> access a resource for this binding. #SHADER_STAGE_ALL is a shorthand specifying that all defined shader stages, including any additional stages defined by extensions, <b>can</b> access the resource.

        If a shader stage is not included in {@code stageFlags}, then a resource <b>must</b> not be accessed from that stage via this binding within any pipeline using the set layout. Other than input attachments which are limited to the fragment shader, there are no limitations on what combinations of stages <b>can</b> use a descriptor binding, and in particular a binding <b>can</b> be used by both graphics stages and the compute stage.""")
    nullable..VkSampler.const.p("pImmutableSamplers", "affects initialization of samplers. If {@code descriptorType} specifies a #DESCRIPTOR_TYPE_SAMPLER or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER type descriptor, then {@code pImmutableSamplers} <b>can</b> be used to initialize a set of <em>immutable samplers</em>. Immutable samplers are permanently bound into the set layout and <b>must</b> not be changed; updating a #DESCRIPTOR_TYPE_SAMPLER descriptor with immutable samplers is not allowed and updates to a #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER descriptor with immutable samplers does not modify the samplers (the image views are updated, but the sampler updates are ignored). If {@code pImmutableSamplers} is not {@code NULL}, then it is a pointer to an array of sampler handles that will be copied into the set layout and used for the corresponding binding. Only the sampler handles are copied; the sampler objects <b>must</b> not be destroyed before the final use of the set layout and any descriptor pools and sets created using it. If {@code pImmutableSamplers} is {@code NULL}, then the sampler slots are dynamic and sampler handles <b>must</b> be bound into descriptor sets using this layout. If {@code descriptorType} is not one of these descriptor types, then {@code pImmutableSamplers} is ignored.")
}

val VkDescriptorSetLayoutCreateInfo = struct(Module.VULKAN, "VkDescriptorSetLayoutCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created descriptor set layout.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-perStageDescriptorSet">{@code perStageDescriptorSet}</a> feature is not enabled, or {@code flags} does not contain #DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then the ##VkDescriptorSetLayoutBinding{@code ::binding} members of the elements of the {@code pBindings} array <b>must</b> each have different values</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then all elements of {@code pBindings} <b>must</b> not have a {@code descriptorType} of #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then all elements of {@code pBindings} <b>must</b> not have a {@code descriptorType} of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then the total number of elements of all bindings <b>must</b> be less than or equal to ##VkPhysicalDevicePushDescriptorProperties{@code ::maxPushDescriptors}</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, {@code flags} <b>must</b> not contain #DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, {@code pBindings} <b>must</b> not have a {@code descriptorType} of #DESCRIPTOR_TYPE_MUTABLE_EXT</li>
            <li>If any binding has the #DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, {@code flags} <b>must</b> include #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT</li>
            <li>If any binding has the #DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, then all bindings <b>must</b> not have {@code descriptorType} of #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT, {@code flags} <b>must</b> not contain #DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT</li>
            <li>If any element {@code pBindings}[i] has a {@code descriptorType} of #DESCRIPTOR_TYPE_MUTABLE_EXT, then the {@code pNext} chain <b>must</b> include a ##VkMutableDescriptorTypeCreateInfoEXT structure, and {@code mutableDescriptorTypeListCount} <b>must</b> be greater than i</li>
            <li>If a binding has a {@code descriptorType} value of #DESCRIPTOR_TYPE_MUTABLE_EXT, then {@code pImmutableSamplers} <b>must</b> be {@code NULL}</li>
            <li>If ##VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT{@code ::mutableDescriptorType} is not enabled, {@code pBindings} <b>must</b> not contain a {@code descriptorType} of #DESCRIPTOR_TYPE_MUTABLE_EXT</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT, ##VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT{@code ::mutableDescriptorType} <b>must</b> be enabled</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then all elements of {@code pBindings} <b>must</b> not have a {@code descriptorType} of #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, {@code flags} <b>must</b> also contain #DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then {@code flags} <b>must</b> not contain #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then {@code flags} <b>must</b> not contain #DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-perStageDescriptorSet">{@code perStageDescriptorSet}</a> <b>must</b> be enabled</li>
            <li>If {@code flags} contains #DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then there <b>must</b> not be any two elements of the {@code pBindings} array with the same ##VkDescriptorSetLayoutBinding{@code ::binding} value and their ##VkDescriptorSetLayoutBinding{@code ::stageFlags} containing the same bit</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDescriptorSetLayoutBindingFlagsCreateInfo or ##VkMutableDescriptorTypeCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkDescriptorSetLayoutCreateFlagBits} values</li>
            <li>If {@code bindingCount} is not 0, {@code pBindings} <b>must</b> be a valid pointer to an array of {@code bindingCount} valid ##VkDescriptorSetLayoutBinding structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkDescriptorSetLayoutBinding, #CreateDescriptorSetLayout(), #GetDescriptorSetLayoutSupport(), #GetDescriptorSetLayoutSupportKHR()
        """

    Expression("#STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDescriptorSetLayoutBindingFlagsCreateInfo", "VkDescriptorSetLayoutBindingFlagsCreateInfoEXT", "VkMutableDescriptorTypeCreateInfoEXT", "VkMutableDescriptorTypeCreateInfoVALVE",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDescriptorSetLayoutCreateFlags("flags", "a bitmask of {@code VkDescriptorSetLayoutCreateFlagBits} specifying options for descriptor set layout creation.")
    AutoSize("pBindings", optional = true)..uint32_t("bindingCount", "the number of elements in {@code pBindings}.")
    VkDescriptorSetLayoutBinding.const.p("pBindings", "a pointer to an array of ##VkDescriptorSetLayoutBinding structures.")
}

val VkWriteDescriptorSet = struct(Module.VULKAN, "VkWriteDescriptorSet") {
    documentation =
        """
        Structure specifying the parameters of a descriptor set write operation.

        <h5>Description</h5>
        Only one of {@code pImageInfo}, {@code pBufferInfo}, or {@code pTexelBufferView} members is used according to the descriptor type specified in the {@code descriptorType} member of the containing ##VkWriteDescriptorSet structure, or none of them in case {@code descriptorType} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, in which case the source data for the descriptor writes is taken from the ##VkWriteDescriptorSetInlineUniformBlock structure included in the {@code pNext} chain of ##VkWriteDescriptorSet, or if {@code descriptorType} is #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR, in which case the source data for the descriptor writes is taken from the ##VkWriteDescriptorSetAccelerationStructureKHR structure in the {@code pNext} chain of ##VkWriteDescriptorSet, or if {@code descriptorType} is #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV, in which case the source data for the descriptor writes is taken from the ##VkWriteDescriptorSetAccelerationStructureNV structure in the {@code pNext} chain of ##VkWriteDescriptorSet, as specified below.

        If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-nullDescriptor">{@code nullDescriptor}</a> feature is enabled, the buffer, acceleration structure, imageView, or bufferView <b>can</b> be #NULL_HANDLE. Loads from a null descriptor return zero values and stores and atomics to a null descriptor are discarded. A null acceleration structure descriptor results in the miss shader being invoked.

        If the destination descriptor is a mutable descriptor, the active descriptor type for the destination descriptor becomes {@code descriptorType}.

        If the {@code dstBinding} has fewer than {@code descriptorCount} array elements remaining starting from {@code dstArrayElement}, then the remainder will be used to update the subsequent binding - <code>dstBinding+1</code> starting at array element zero. If a binding has a {@code descriptorCount} of zero, it is skipped. This behavior applies recursively, with the update affecting consecutive bindings as needed to update all {@code descriptorCount} descriptors. Consecutive bindings <b>must</b> have identical {@code VkDescriptorType}, {@code VkShaderStageFlags}, {@code VkDescriptorBindingFlagBits}, and immutable samplers references. In addition, if the {@code VkDescriptorType} is #DESCRIPTOR_TYPE_MUTABLE_EXT, the supported descriptor types in ##VkMutableDescriptorTypeCreateInfoEXT <b>must</b> be equally defined.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The same behavior applies to bindings with a descriptor type of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK where {@code descriptorCount} specifies the number of bytes to update while {@code dstArrayElement} specifies the starting byte offset, thus in this case if the {@code dstBinding} has a smaller byte size than the sum of {@code dstArrayElement} and {@code descriptorCount}, then the remainder will be used to update the subsequent binding - <code>dstBinding+1</code> starting at offset zero. This falls out as a special case of the above rule.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code dstBinding} <b>must</b> be less than or equal to the maximum value of {@code binding} of all ##VkDescriptorSetLayoutBinding structures specified when {@code dstSet}’s descriptor set layout was created</li>
            <li>{@code dstBinding} <b>must</b> be a binding with a non-zero {@code descriptorCount}</li>
            <li>{@code dstBinding} <b>must</b> be a binding with a non-zero ##VkDescriptorSetLayoutCreateInfo{@code ::bindingCount}</li>
            <li>All consecutive bindings updated via a single ##VkWriteDescriptorSet structure, except those with a {@code descriptorCount} of zero, <b>must</b> have identical {@code descriptorType} and {@code stageFlags}</li>
            <li>All consecutive bindings updated via a single ##VkWriteDescriptorSet structure, except those with a {@code descriptorCount} of zero, <b>must</b> all either use immutable samplers or <b>must</b> all not use immutable samplers</li>
            <li>{@code descriptorType} <b>must</b> match the type of {@code dstBinding} within {@code dstSet}</li>
            <li>{@code dstSet} <b>must</b> be a valid {@code VkDescriptorSet} handle</li>
            <li>The sum of {@code dstArrayElement} and {@code descriptorCount} <b>must</b> be less than or equal to the number of array elements in the descriptor set binding specified by {@code dstBinding}, and all applicable <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-updates-consecutive">consecutive bindings</a></li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, {@code dstArrayElement} <b>must</b> be an integer multiple of 4</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, {@code descriptorCount} <b>must</b> be an integer multiple of 4</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER or #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, each element of {@code pTexelBufferView} <b>must</b> be either a valid {@code VkBufferView} handle or #NULL_HANDLE</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER or #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-nullDescriptor">{@code nullDescriptor}</a> feature is not enabled, each element of {@code pTexelBufferView} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_UNIFORM_BUFFER, #DESCRIPTOR_TYPE_STORAGE_BUFFER, #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, {@code pBufferInfo} <b>must</b> be a valid pointer to an array of {@code descriptorCount} valid ##VkDescriptorBufferInfo structures</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_SAMPLER or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and {@code dstSet} was not allocated with a layout that included immutable samplers for {@code dstBinding} with {@code descriptorType}, the {@code sampler} member of each element of {@code pImageInfo} <b>must</b> be a valid {@code VkSampler} object</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, or #DESCRIPTOR_TYPE_STORAGE_IMAGE, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> be either a valid {@code VkImageView} handle or #NULL_HANDLE</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, #DESCRIPTOR_TYPE_SAMPLED_IMAGE, or #DESCRIPTOR_TYPE_STORAGE_IMAGE, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-nullDescriptor">{@code nullDescriptor}</a> feature is not enabled, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, the {@code pNext} chain <b>must</b> include a ##VkWriteDescriptorSetInlineUniformBlock structure whose {@code dataSize} member equals {@code descriptorCount}</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR, the {@code pNext} chain <b>must</b> include a ##VkWriteDescriptorSetAccelerationStructureKHR structure whose {@code accelerationStructureCount} member equals {@code descriptorCount}</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV, the {@code pNext} chain <b>must</b> include a ##VkWriteDescriptorSetAccelerationStructureNV structure whose {@code accelerationStructureCount} member equals {@code descriptorCount}</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_SAMPLED_IMAGE, then the {@code imageView} member of each {@code pImageInfo} element <b>must</b> have been created without a ##VkSamplerYcbcrConversionInfo structure in its {@code pNext} chain</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and if any element of {@code pImageInfo} has an {@code imageView} member that was created with a ##VkSamplerYcbcrConversionInfo structure in its {@code pNext} chain, then {@code dstSet} <b>must</b> have been allocated with a layout that included immutable samplers for {@code dstBinding}, and the corresponding immutable sampler <b>must</b> have been created with an <em>identically defined</em> ##VkSamplerYcbcrConversionInfo object</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and {@code dstSet} was allocated with a layout that included immutable samplers for {@code dstBinding}, then the {@code imageView} member of each element of {@code pImageInfo} which corresponds to an immutable sampler that enables <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> <b>must</b> have been created with a ##VkSamplerYcbcrConversionInfo structure in its {@code pNext} chain with an <em>identically defined</em> ##VkSamplerYcbcrConversionInfo to the corresponding immutable sampler</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, {@code dstSet} was allocated with a layout that included immutable samplers for {@code dstBinding}, and those samplers enable <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a>, then {@code imageView} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_UNIFORM_BUFFER or #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, the {@code offset} member of each element of {@code pBufferInfo} <b>must</b> be a multiple of ##VkPhysicalDeviceLimits{@code ::minUniformBufferOffsetAlignment}</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_STORAGE_BUFFER or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, the {@code offset} member of each element of {@code pBufferInfo} <b>must</b> be a multiple of ##VkPhysicalDeviceLimits{@code ::minStorageBufferOffsetAlignment}</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_UNIFORM_BUFFER, #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, #DESCRIPTOR_TYPE_STORAGE_BUFFER, or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, and the {@code buffer} member of any element of {@code pBufferInfo} is the handle of a non-sparse buffer, then that buffer <b>must</b> be bound completely and contiguously to a single {@code VkDeviceMemory} object</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_UNIFORM_BUFFER or #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, the {@code buffer} member of each element of {@code pBufferInfo} <b>must</b> have been created with #BUFFER_USAGE_UNIFORM_BUFFER_BIT set</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_STORAGE_BUFFER or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, the {@code buffer} member of each element of {@code pBufferInfo} <b>must</b> have been created with #BUFFER_USAGE_STORAGE_BUFFER_BIT set</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_UNIFORM_BUFFER or #DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, the {@code range} member of each element of {@code pBufferInfo}, or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#buffer-info-effective-range">effective range</a> if {@code range} is #WHOLE_SIZE, <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxUniformBufferRange}</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_STORAGE_BUFFER or #DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, the {@code range} member of each element of {@code pBufferInfo}, or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#buffer-info-effective-range">effective range</a> if {@code range} is #WHOLE_SIZE, <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxStorageBufferRange}</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, the {@code pTexelBufferView} <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-buffer-views-usage">buffer view usage</a> <b>must</b> include #BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, the {@code pTexelBufferView} <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-buffer-views-usage">buffer view usage</a> <b>must</b> include #BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_STORAGE_IMAGE or #DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> have been created with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-views-identity-mappings">identity swizzle</a></li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_SAMPLED_IMAGE or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> have been created with #IMAGE_USAGE_SAMPLED_BIT set</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_SAMPLED_IMAGE the {@code imageLayout} member of each element of {@code pImageInfo} <b>must</b> be a member of the list given in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-sampledimage">Sampled Image</a></li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER the {@code imageLayout} member of each element of {@code pImageInfo} <b>must</b> be a member of the list given in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-combinedimagesampler">Combined Image Sampler</a></li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INPUT_ATTACHMENT the {@code imageLayout} member of each element of {@code pImageInfo} <b>must</b> be a member of the list given in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-inputattachment">Input Attachment</a></li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_STORAGE_IMAGE the {@code imageLayout} member of each element of {@code pImageInfo} <b>must</b> be a member of the list given in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-storageimage">Storage Image</a></li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> have been created with #IMAGE_USAGE_INPUT_ATTACHMENT_BIT set</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_STORAGE_IMAGE, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> have been created with #IMAGE_USAGE_STORAGE_BIT set</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_SAMPLER, then {@code dstSet} <b>must</b> not have been allocated with a layout that included immutable samplers for {@code dstBinding}</li>
            <li>If the ##VkDescriptorSetLayoutBinding for {@code dstSet} at {@code dstBinding} is #DESCRIPTOR_TYPE_MUTABLE_EXT, the new active descriptor type {@code descriptorType} <b>must</b> exist in the corresponding {@code pMutableDescriptorTypeLists} list for {@code dstBinding}</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> have either been created without a ##VkImageViewMinLodCreateInfoEXT included in the {@code pNext} chain or with a ##VkImageViewMinLodCreateInfoEXT{@code ::minLod} of {@code 0.0}</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> have been created with a view created with an {@code image} created with #IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM</li>
            <li>If {@code descriptorType} is #DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM, the {@code imageView} member of each element of {@code pImageInfo} <b>must</b> have been created with a view created with an {@code image} created with #IMAGE_USAGE_SAMPLE_BLOCK_MATCH_BIT_QCOM</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkWriteDescriptorSetAccelerationStructureKHR, ##VkWriteDescriptorSetAccelerationStructureNV, or ##VkWriteDescriptorSetInlineUniformBlock</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code descriptorType} <b>must</b> be a valid {@code VkDescriptorType} value</li>
            <li>{@code descriptorCount} <b>must</b> be greater than 0</li>
            <li>Both of {@code dstSet}, and the elements of {@code pTexelBufferView} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkDescriptorBufferInfo, ##VkDescriptorImageInfo, ##VkPushDescriptorSetInfo, #CmdPushDescriptorSet(), #CmdPushDescriptorSetKHR(), #UpdateDescriptorSets()
        """

    Expression("#STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkWriteDescriptorSetAccelerationStructureKHR", "VkWriteDescriptorSetAccelerationStructureNV", "VkWriteDescriptorSetInlineUniformBlock", "VkWriteDescriptorSetInlineUniformBlockEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDescriptorSet("dstSet", "the destination descriptor set to update.")
    uint32_t("dstBinding", "the descriptor binding within that set.")
    uint32_t("dstArrayElement", "the starting element in that array. If the descriptor binding identified by {@code dstSet} and {@code dstBinding} has a descriptor type of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then {@code dstArrayElement} specifies the starting byte offset within the binding.")
    AutoSize("pImageInfo", "pBufferInfo", "pTexelBufferView", optional = true)..uint32_t("descriptorCount", """the number of descriptors to update. If the descriptor binding identified by {@code dstSet} and {@code dstBinding} has a descriptor type of #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, then {@code descriptorCount} specifies the number of bytes to update. Otherwise, {@code descriptorCount} is one of

        <ul>
            <li>the number of elements in {@code pImageInfo}</li>
            <li>the number of elements in {@code pBufferInfo}</li>
            <li>the number of elements in {@code pTexelBufferView}</li>
            <li>a value matching the {@code dataSize} member of a ##VkWriteDescriptorSetInlineUniformBlock structure in the {@code pNext} chain</li>
            <li>a value matching the {@code accelerationStructureCount} of a ##VkWriteDescriptorSetAccelerationStructureKHR or ##VkWriteDescriptorSetAccelerationStructureNV structure in the {@code pNext} chain</li>
        </ul>""")
    VkDescriptorType("descriptorType", "a {@code VkDescriptorType} specifying the type of each descriptor in {@code pImageInfo}, {@code pBufferInfo}, or {@code pTexelBufferView}, as described below. If ##VkDescriptorSetLayoutBinding for {@code dstSet} at {@code dstBinding} is not equal to #DESCRIPTOR_TYPE_MUTABLE_EXT, {@code descriptorType} <b>must</b> be the same type as the {@code descriptorType} specified in ##VkDescriptorSetLayoutBinding for {@code dstSet} at {@code dstBinding}. The type of the descriptor also controls which array the descriptors are taken from.")
    nullable..VkDescriptorImageInfo.const.p("pImageInfo", "a pointer to an array of ##VkDescriptorImageInfo structures or is ignored, as described below.")
    nullable..VkDescriptorBufferInfo.const.p("pBufferInfo", "a pointer to an array of ##VkDescriptorBufferInfo structures or is ignored, as described below.")
    nullable..VkBufferView.const.p("pTexelBufferView", "a pointer to an array of {@code VkBufferView} handles as described in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#resources-buffer-views\">Buffer Views</a> section or is ignored, as described below.")
}

val VkAttachmentDescription = struct(Module.VULKAN, "VkAttachmentDescription") {
    documentation =
        """
        Structure specifying an attachment description.

        <h5>Description</h5>
        If the attachment uses a color format, then {@code loadOp} and {@code storeOp} are used, and {@code stencilLoadOp} and {@code stencilStoreOp} are ignored. If the format has depth and/or stencil components, {@code loadOp} and {@code storeOp} apply only to the depth data, while {@code stencilLoadOp} and {@code stencilStoreOp} define how the stencil data is handled. {@code loadOp} and {@code stencilLoadOp} define the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-load-operations">load operations</a> for the attachment. {@code storeOp} and {@code stencilStoreOp} define the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-store-operations">store operations</a> for the attachment. If an attachment is not used by any subpass, {@code loadOp}, {@code storeOp}, {@code stencilStoreOp}, and {@code stencilLoadOp} will be ignored for that attachment, and no load or store ops will be performed. However, any transition specified by {@code initialLayout} and {@code finalLayout} will still be executed.

        If {@code flags} includes #ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT, then the attachment is treated as if it shares physical memory with another attachment in the same render pass. This information limits the ability of the implementation to reorder certain operations (like layout transitions and the {@code loadOp}) such that it is not improperly reordered against other uses of the same physical memory via a different attachment. This is described in more detail below.

        If a render pass uses multiple attachments that alias the same device memory, those attachments <b>must</b> each include the #ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT bit in their attachment description flags. Attachments aliasing the same memory occurs in multiple ways:

        <ul>
            <li>Multiple attachments being assigned the same image view as part of framebuffer creation.</li>
            <li>Attachments using distinct image views that correspond to the same image subresource of an image.</li>
            <li>Attachments using views of distinct image subresources which are bound to overlapping memory ranges.</li>
        </ul>

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Render passes <b>must</b> include subpass dependencies (either directly or via a subpass dependency chain) between any two subpasses that operate on the same attachment or aliasing attachments and those subpass dependencies <b>must</b> include execution and memory dependencies separating uses of the aliases, if at least one of those subpasses writes to one of the aliases. These dependencies <b>must</b> not include the #DEPENDENCY_BY_REGION_BIT if the aliases are views of distinct image subresources which overlap in memory.
        </div>

        Multiple attachments that alias the same memory <b>must</b> not be used in a single subpass. A given attachment index <b>must</b> not be used multiple times in a single subpass, with one exception: two subpass attachments <b>can</b> use the same attachment index if at least one use is as an input attachment and neither use is as a resolve or preserve attachment. In other words, the same view <b>can</b> be used simultaneously as an input and color or depth/stencil attachment, but <b>must</b> not be used as multiple color or depth/stencil attachments nor as resolve or preserve attachments.

        If a set of attachments alias each other, then all except the first to be used in the render pass <b>must</b> use an {@code initialLayout} of #IMAGE_LAYOUT_UNDEFINED, since the earlier uses of the other aliases make their contents undefined. Once an alias has been used and a different alias has been used after it, the first alias <b>must</b> not be used in any later subpasses. However, an application <b>can</b> assign the same image view to multiple aliasing attachment indices, which allows that image view to be used multiple times even if other aliases are used in between.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Once an attachment needs the #ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT bit, there <b>should</b> be no additional cost of introducing additional aliases, and using these additional aliases <b>may</b> allow more efficient clearing of the attachments on multiple uses via #ATTACHMENT_LOAD_OP_CLEAR.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code format} includes a color or depth component and {@code loadOp} is #ATTACHMENT_LOAD_OP_LOAD, then {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_UNDEFINED</li>
            <li>{@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_UNDEFINED or #IMAGE_LAYOUT_PREINITIALIZED</li>
            <li>If {@code format} is a color format, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a depth/stencil format, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL</li>
            <li>If {@code format} is a color format, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a depth/stencil format, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL</li>
            <li>If {@code format} is a color format, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or #IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL</li>
            <li>If {@code format} is a color format, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or #IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-separateDepthStencilLayouts">{@code separateDepthStencilLayouts}</a> feature is not enabled, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-separateDepthStencilLayouts">{@code separateDepthStencilLayouts}</a> feature is not enabled, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,</li>
            <li>If {@code format} is a color format, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a color format, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a depth/stencil format which includes both depth and stencil components, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a depth/stencil format which includes both depth and stencil components, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a depth/stencil format which includes only the depth component, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a depth/stencil format which includes only the depth component, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or #IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or #IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFeedbackLoopLayout">{@code attachmentFeedbackLoopLayout}</a> feature is not enabled, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFeedbackLoopLayout">{@code attachmentFeedbackLoopLayout}</a> feature is not enabled, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT</li>
            <li>{@code samples} <b>must</b> be a valid {@code VkSampleCountFlagBits} value that is set in {@code imageCreateSampleCounts} (as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-creation-limits">Image Creation Limits</a>) for the given {@code format}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRenderingLocalRead">{@code dynamicRenderingLocalRead}</a> feature is not enabled, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_RENDERING_LOCAL_READ</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRenderingLocalRead">{@code dynamicRenderingLocalRead}</a> feature is not enabled, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_RENDERING_LOCAL_READ</li>
            <li>{@code format} <b>must</b> not be VK_FORMAT_UNDEFINED</li>
            <li>If {@code format} includes a stencil component and {@code stencilLoadOp} is #ATTACHMENT_LOAD_OP_LOAD, then {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_UNDEFINED</li>
            <li>If {@code format} is a depth/stencil format which includes only the stencil component, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a depth/stencil format which includes only the stencil component, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a depth/stencil format which includes both depth and stencil components, {@code initialLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL</li>
            <li>If {@code format} is a depth/stencil format which includes both depth and stencil components, {@code finalLayout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkAttachmentDescriptionFlagBits} values</li>
            <li>{@code format} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>{@code samples} <b>must</b> be a valid {@code VkSampleCountFlagBits} value</li>
            <li>{@code loadOp} <b>must</b> be a valid {@code VkAttachmentLoadOp} value</li>
            <li>{@code storeOp} <b>must</b> be a valid {@code VkAttachmentStoreOp} value</li>
            <li>{@code stencilLoadOp} <b>must</b> be a valid {@code VkAttachmentLoadOp} value</li>
            <li>{@code stencilStoreOp} <b>must</b> be a valid {@code VkAttachmentStoreOp} value</li>
            <li>{@code initialLayout} <b>must</b> be a valid {@code VkImageLayout} value</li>
            <li>{@code finalLayout} <b>must</b> be a valid {@code VkImageLayout} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkRenderPassCreateInfo
        """

    VkAttachmentDescriptionFlags("flags", "a bitmask of {@code VkAttachmentDescriptionFlagBits} specifying additional properties of the attachment.")
    VkFormat("format", "a {@code VkFormat} value specifying the format of the image view that will be used for the attachment.")
    VkSampleCountFlagBits("samples", "a {@code VkSampleCountFlagBits} value specifying the number of samples of the image.")
    VkAttachmentLoadOp("loadOp", "a {@code VkAttachmentLoadOp} value specifying how the contents of color and depth components of the attachment are treated at the beginning of the subpass where it is first used.")
    VkAttachmentStoreOp("storeOp", "a {@code VkAttachmentStoreOp} value specifying how the contents of color and depth components of the attachment are treated at the end of the subpass where it is last used.")
    VkAttachmentLoadOp("stencilLoadOp", "a {@code VkAttachmentLoadOp} value specifying how the contents of stencil components of the attachment are treated at the beginning of the subpass where it is first used.")
    VkAttachmentStoreOp("stencilStoreOp", "a {@code VkAttachmentStoreOp} value specifying how the contents of stencil components of the attachment are treated at the end of the last subpass where it is used.")
    VkImageLayout("initialLayout", "the layout the attachment image subresource will be in when a render pass instance begins.")
    VkImageLayout("finalLayout", "the layout the attachment image subresource will be transitioned to when a render pass instance ends.")
}

val VkAttachmentReference = struct(Module.VULKAN, "VkAttachmentReference") {
    documentation =
        """
        Structure specifying an attachment reference.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code attachment} is not #ATTACHMENT_UNUSED, {@code layout} <b>must</b> not be #IMAGE_LAYOUT_UNDEFINED, #IMAGE_LAYOUT_PREINITIALIZED, or #IMAGE_LAYOUT_PRESENT_SRC_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-separateDepthStencilLayouts">{@code separateDepthStencilLayouts}</a> feature is not enabled, and {@code attachment} is not #ATTACHMENT_UNUSED, {@code layout} <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, {@code layout} <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or #IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFeedbackLoopLayout">{@code attachmentFeedbackLoopLayout}</a> feature is not enabled, {@code layout} <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRenderingLocalRead">{@code dynamicRenderingLocalRead}</a> feature is not enabled, {@code layout} <b>must</b> not be #IMAGE_LAYOUT_RENDERING_LOCAL_READ</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code layout} <b>must</b> be a valid {@code VkImageLayout} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkRenderPassFragmentDensityMapCreateInfoEXT, ##VkSubpassDescription
        """

    uint32_t("attachment", "either an integer value identifying an attachment at the corresponding index in ##VkRenderPassCreateInfo{@code ::pAttachments}, or #ATTACHMENT_UNUSED to signify that this attachment is not used.")
    VkImageLayout("layout", "a {@code VkImageLayout} value specifying the layout the attachment uses during the subpass.")
}

val VkFramebufferCreateInfo = struct(Module.VULKAN, "VkFramebufferCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created framebuffer.

        <h5>Description</h5>
        It is legal for a subpass to use no color or depth/stencil attachments, either because it has no attachment references or because all of them are #ATTACHMENT_UNUSED. This kind of subpass <b>can</b> use shader side effects such as image stores and atomics to produce an output. In this case, the subpass continues to use the {@code width}, {@code height}, and {@code layers} of the framebuffer to define the dimensions of the rendering area, and the {@code rasterizationSamples} from each pipeline’s ##VkPipelineMultisampleStateCreateInfo to define the number of samples used in rasterization; however, if ##VkPhysicalDeviceFeatures{@code ::variableMultisampleRate} is #FALSE, then all pipelines to be bound with the subpass <b>must</b> have the same value for ##VkPipelineMultisampleStateCreateInfo{@code ::rasterizationSamples}. In all such cases, {@code rasterizationSamples} <b>must</b> be a valid {@code VkSampleCountFlagBits} value that is set in ##VkPhysicalDeviceLimits{@code ::framebufferNoAttachmentsSampleCounts}.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code attachmentCount} <b>must</b> be equal to the attachment count specified in {@code renderPass}</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT and {@code attachmentCount} is not 0, {@code pAttachments} <b>must</b> be a valid pointer to an array of {@code attachmentCount} valid {@code VkImageView} handles</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} that is used as a color attachment or resolve attachment by {@code renderPass} <b>must</b> have been created with a {@code usage} value including #IMAGE_USAGE_COLOR_ATTACHMENT_BIT</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} that is used as a depth/stencil attachment by {@code renderPass} <b>must</b> have been created with a {@code usage} value including #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} that is used as a depth/stencil resolve attachment by {@code renderPass} <b>must</b> have been created with a {@code usage} value including #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code renderpass} is not #NULL_HANDLE, {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} that is used as an input attachment by {@code renderPass} <b>must</b> have been created with a {@code usage} value including #IMAGE_USAGE_INPUT_ATTACHMENT_BIT</li>
            <li>Each element of {@code pAttachments} that is used as a fragment density map attachment by {@code renderPass} <b>must</b> not have been created with a {@code flags} value including #IMAGE_CREATE_SUBSAMPLED_BIT_EXT</li>
            <li>If {@code renderPass} has a fragment density map attachment and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMapNonSubsampledImages">{@code fragmentDensityMapNonSubsampledImages}</a> feature is not enabled, each element of {@code pAttachments} <b>must</b> have been created with a {@code flags} value including #IMAGE_CREATE_SUBSAMPLED_BIT_EXT unless that element is the fragment density map attachment</li>
            <li>If {@code renderPass} was created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-fragmentdensitymapoffsets">fragment density map offsets</a> other than <code>(0,0)</code>, each element of {@code pAttachments} <b>must</b> have been created with a {@code flags} value including #IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} <b>must</b> have been created with a {@code VkFormat} value that matches the {@code VkFormat} specified by the corresponding ##VkAttachmentDescription in {@code renderPass}</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} <b>must</b> have been created with a {@code samples} value that matches the {@code samples} value specified by the corresponding ##VkAttachmentDescription in {@code renderPass}</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} that is used as an input, color, resolve, or depth/stencil attachment by {@code renderPass} <b>must</b> have been created with a ##VkImageCreateInfo{@code ::extent.width} greater than or equal to {@code width}</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} that is used as an input, color, resolve, or depth/stencil attachment by {@code renderPass} <b>must</b> have been created with a ##VkImageCreateInfo{@code ::extent.height} greater than or equal to {@code height}</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} that is used as an input, color, resolve, or depth/stencil attachment by {@code renderPass} <b>must</b> have been created with a ##VkImageViewCreateInfo{@code ::subresourceRange.layerCount} greater than or equal to {@code layers}</li>
            <li>If {@code renderPass} was specified with non-zero view masks, each element of {@code pAttachments} that is used as an input, color, resolve, or depth/stencil attachment by {@code renderPass} <b>must</b> have a {@code layerCount} greater than the index of the most significant bit set in any of those view masks</li>
            <li>Each element of {@code pAttachments} that is referenced by {@code fragmentDensityMapAttachment} <b>must</b> have a {@code layerCount} equal to 1 or if {@code renderPass} was specified with non-zero view masks, greater than the index of the most significant bit set in any of those view masks</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of {@code pAttachments} that is referenced by {@code fragmentDensityMapAttachment} <b>must</b> have a width at least as large as <code>ceil(width / maxFragmentDensityTexelSize<sub>width</sub>)</code></li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of {@code pAttachments} that is referenced by {@code fragmentDensityMapAttachment} <b>must</b> have a height at least as large as <code>ceil(height / maxFragmentDensityTexelSize<sub>height</sub>)</code></li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, and {@code renderPass} was specified with non-zero view masks, each element of {@code pAttachments} that is used as a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> by {@code renderPass} <b>must</b> have a {@code layerCount} that is either 1, or greater than the index of the most significant bit set in any of those view masks</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, and {@code renderPass} was not specified with non-zero view masks, each element of {@code pAttachments} that is used as a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> by {@code renderPass} <b>must</b> have a {@code layerCount} that is either 1, or greater than {@code layers}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is not enabled or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustFragmentShadingRateAttachmentAccess">{@code robustFragmentShadingRateAttachmentAccess}</a> limit is #FALSE or the {@code imageView} member of a ##VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with ##VkImageSubresourceRange{@code ::baseMipLevel} greater than 0, {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of {@code pAttachments} that is used as a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> <b>must</b> have a width at least as large as <code>⌈width / texelWidth⌉</code>, where {@code texelWidth} is the largest value of {@code shadingRateAttachmentTexelSize.width} in a ##VkFragmentShadingRateAttachmentInfoKHR which references that attachment</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is not enabled or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustFragmentShadingRateAttachmentAccess">{@code robustFragmentShadingRateAttachmentAccess}</a> limit is #FALSE or the {@code imageView} member of a ##VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with ##VkImageSubresourceRange{@code ::baseMipLevel} greater than 0, {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of {@code pAttachments} that is used as a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> <b>must</b> have a height at least as large as <code>⌈height / texelHeight⌉</code>, where {@code texelHeight} is the largest value of {@code shadingRateAttachmentTexelSize.height} in a ##VkFragmentShadingRateAttachmentInfoKHR which references that attachment</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} <b>must</b> only specify a single mip level</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} <b>must</b> have been created with the identity swizzle</li>
            <li>{@code width} <b>must</b> be greater than 0</li>
            <li>{@code width} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFramebufferWidth">{@code maxFramebufferWidth}</a></li>
            <li>{@code height} <b>must</b> be greater than 0</li>
            <li>{@code height} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFramebufferHeight">{@code maxFramebufferHeight}</a></li>
            <li>{@code layers} <b>must</b> be greater than 0</li>
            <li>{@code layers} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFramebufferLayers">{@code maxFramebufferLayers}</a></li>
            <li>If {@code renderPass} was specified with non-zero view masks, {@code layers} <b>must</b> be 1</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} that is a 2D or 2D array image view taken from a 3D image <b>must</b> not be a depth/stencil format</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-imagelessFramebuffer">{@code imagelessFramebuffer}</a> feature is not enabled, {@code flags} <b>must</b> not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code pNext} chain <b>must</b> include a ##VkFramebufferAttachmentsCreateInfo structure</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code attachmentImageInfoCount} member of a ##VkFramebufferAttachmentsCreateInfo structure in the {@code pNext} chain <b>must</b> be equal to either zero or {@code attachmentCount}</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code width} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure in the {@code pNext} chain that is used as an input, color, resolve or depth/stencil attachment in {@code renderPass} <b>must</b> be greater than or equal to {@code width}</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code height} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure in the {@code pNext} chain that is used as an input, color, resolve or depth/stencil attachment in {@code renderPass} <b>must</b> be greater than or equal to {@code height}</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code width} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure in the {@code pNext} chain that is referenced by ##VkRenderPassFragmentDensityMapCreateInfoEXT{@code ::fragmentDensityMapAttachment} in {@code renderPass} <b>must</b> be greater than or equal to <code>ceil(width / maxFragmentDensityTexelSize<sub>width</sub>)</code></li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code height} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure included in the {@code pNext} chain that is referenced by ##VkRenderPassFragmentDensityMapCreateInfoEXT{@code ::fragmentDensityMapAttachment} in {@code renderPass} <b>must</b> be greater than or equal to <code>ceil(height / maxFragmentDensityTexelSize<sub>height</sub>)</code></li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is not enabled or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustFragmentShadingRateAttachmentAccess">{@code robustFragmentShadingRateAttachmentAccess}</a> limit is #FALSE or the {@code imageView} member of a ##VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with ##VkImageSubresourceRange{@code ::baseMipLevel} greater than 0, and {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code width} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure in the {@code pNext} chain that is used as a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> <b>must</b> be greater than or equal to <code>⌈width / texelWidth⌉</code>, where {@code texelWidth} is the largest value of {@code shadingRateAttachmentTexelSize.width} in a ##VkFragmentShadingRateAttachmentInfoKHR which references that attachment</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance7">{@code maintenance7}</a> feature is not enabled or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-robustFragmentShadingRateAttachmentAccess">{@code robustFragmentShadingRateAttachmentAccess}</a> limit is #FALSE or the {@code imageView} member of a ##VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with ##VkImageSubresourceRange{@code ::baseMipLevel} greater than 0, and {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code height} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure in the {@code pNext} chain that is used as a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> <b>must</b> be greater than or equal to <code>⌈height / texelHeight⌉</code>, where {@code texelHeight} is the largest value of {@code shadingRateAttachmentTexelSize.height} in a ##VkFragmentShadingRateAttachmentInfoKHR which references that attachment</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code layerCount} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure in the {@code pNext} chain that is used as a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> <b>must</b> be either 1, or greater than or equal to {@code layers}</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT and {@code renderPass} was specified with non-zero view masks, the {@code layerCount} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure in the {@code pNext} chain that is used as a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> <b>must</b> be either 1, or greater than the index of the most significant bit set in any of those view masks</li>
            <li>If multiview is enabled for {@code renderPass} and {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code layerCount} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure included in the {@code pNext} chain used as an input, color, resolve, or depth/stencil attachment in {@code renderPass} <b>must</b> be greater than the maximum bit index set in the view mask in the subpasses in which it is used in {@code renderPass}</li>
            <li>If multiview is not enabled for {@code renderPass} and {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code layerCount} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure included in the {@code pNext} chain used as an input, color, resolve, or depth/stencil attachment in {@code renderPass} <b>must</b> be greater than or equal to {@code layers}</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code usage} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure included in the {@code pNext} chain that refers to an attachment used as a color attachment or resolve attachment by {@code renderPass} <b>must</b> include #IMAGE_USAGE_COLOR_ATTACHMENT_BIT</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code usage} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure included in the {@code pNext} chain that refers to an attachment used as a depth/stencil attachment by {@code renderPass} <b>must</b> include #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code usage} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure included in the {@code pNext} chain that refers to an attachment used as a depth/stencil resolve attachment by {@code renderPass} <b>must</b> include #IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code usage} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure included in the {@code pNext} chain that refers to an attachment used as an input attachment by {@code renderPass} <b>must</b> include #IMAGE_USAGE_INPUT_ATTACHMENT_BIT</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, at least one element of the {@code pViewFormats} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure included in the {@code pNext} chain <b>must</b> be equal to the corresponding value of ##VkAttachmentDescription{@code ::format} used to create {@code renderPass}</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} <b>must</b> have been created with ##VkImageViewCreateInfo{@code ::viewType} not equal to #IMAGE_VIEW_TYPE_3D</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of {@code pAttachments} that is used as a fragment shading rate attachment by {@code renderPass} <b>must</b> have been created with a {@code usage} value including #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR</li>
            <li>If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code usage} member of any element of the {@code pAttachmentImageInfos} member of a ##VkFramebufferAttachmentsCreateInfo structure included in the {@code pNext} chain that refers to an attachment used as a fragment shading rate attachment by {@code renderPass} <b>must</b> include #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#subpass-multisampledrendertosinglesampled">multisampled-render-to-single-sampled</a> is enabled for any subpass, all color, depth/stencil and input attachments used in that subpass which have ##VkAttachmentDescription{@code ::samples} or ##VkAttachmentDescription2{@code ::samples} equal to #SAMPLE_COUNT_1_BIT <b>must</b> have been created with #IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT in their ##VkImageCreateInfo{@code ::flags}</li>
            <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#subpass-multisampledrendertosinglesampled">multisampled-render-to-single-sampled</a> is enabled for any subpass, all color, depth/stencil and input attachments used in that subpass which have ##VkAttachmentDescription{@code ::samples} or ##VkAttachmentDescription2{@code ::samples} equal to #SAMPLE_COUNT_1_BIT <b>must</b> have a format that supports the sample count specified in ##VkMultisampledRenderToSingleSampledInfoEXT{@code ::rasterizationSamples}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-nullColorAttachmentWithExternalFormatResolve">{@code nullColorAttachmentWithExternalFormatResolve}</a> is #FALSE, and {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the format of the color attachment for each subpass in {@code renderPass} that includes an external format image as a resolve attachment <b>must</b> have a format equal to the value of ##VkAndroidHardwareBufferFormatResolvePropertiesANDROID{@code ::colorAttachmentFormat} as returned by a call to #GetAndroidHardwareBufferPropertiesANDROID() for the Android hardware buffer that was used to create the image view use as its resolve attachment</li>
            <li>If {@code flags} does not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, then if an element of {@code pAttachments} has a format of #FORMAT_UNDEFINED, it <b>must</b> have been created with a ##VkExternalFormatANDROID{@code ::externalFormat} value identical to that provided in the ##VkExternalFormatANDROID{@code ::externalFormat} specified by the corresponding ##VkAttachmentDescription2 in {@code renderPass}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkFramebufferAttachmentsCreateInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkFramebufferCreateFlagBits} values</li>
            <li>{@code renderPass} <b>must</b> be a valid {@code VkRenderPass} handle</li>
            <li>Both of {@code renderPass}, and the elements of {@code pAttachments} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #CreateFramebuffer()
        """

    Expression("#STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkFramebufferAttachmentsCreateInfo", "VkFramebufferAttachmentsCreateInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkFramebufferCreateFlags("flags", "a bitmask of {@code VkFramebufferCreateFlagBits}")
    VkRenderPass("renderPass", "a render pass defining what render passes the framebuffer will be compatible with. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#renderpass-compatibility\">Render Pass Compatibility</a> for details.")
    AutoSize("pAttachments", optional = true)..uint32_t("attachmentCount", "the number of attachments.")
    nullable..VkImageView.const.p("pAttachments", "a pointer to an array of {@code VkImageView} handles, each of which will be used as the corresponding attachment in a render pass instance. If {@code flags} includes #FRAMEBUFFER_CREATE_IMAGELESS_BIT, this parameter is ignored.")
    uint32_t("width", "{@code width}, {@code height} and {@code layers} define the dimensions of the framebuffer. If the render pass uses multiview, then {@code layers} <b>must</b> be one and each attachment requires a number of layers that is greater than the maximum bit index set in the view mask in the subpasses in which it is used.")
    uint32_t("height", "see {@code width}")
    uint32_t("layers", "see {@code width}")
}

val VkSubpassDescription = struct(Module.VULKAN, "VkSubpassDescription") {
    documentation =
        """
        Structure specifying a subpass description.

        <h5>Description</h5>
        Each element of the {@code pInputAttachments} array corresponds to an input attachment index in a fragment shader, i.e. if a shader declares an image variable decorated with a {@code InputAttachmentIndex} value of <b>X</b>, then it uses the attachment provided in {@code pInputAttachments}[<b>X</b>]. Input attachments <b>must</b> also be bound to the pipeline in a descriptor set. If the {@code attachment} member of any element of {@code pInputAttachments} is #ATTACHMENT_UNUSED, the application <b>must</b> not read from the corresponding input attachment index. Fragment shaders <b>can</b> use subpass input variables to access the contents of an input attachment at the fragment’s <code>(x<sub>f</sub>,y<sub>f</sub>)</code> framebuffer coordinates and layer. Input attachments <b>must</b> not be used by any subpasses within a render pass that enables <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#vertexpostproc-renderpass-transform">render pass transform</a>.

        Each element of the {@code pColorAttachments} array corresponds to an output location in the shader, i.e. if the shader declares an output variable decorated with a {@code Location} value of <b>X</b>, then it uses the attachment provided in {@code pColorAttachments}[<b>X</b>]. If the {@code attachment} member of any element of {@code pColorAttachments} is #ATTACHMENT_UNUSED, or if <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#framebuffer-color-write-enable">Color Write Enable</a> has been disabled for the corresponding attachment index, then writes to the corresponding location by a fragment shader are discarded.

        If {@code flags} does not include #SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and if {@code pResolveAttachments} is not {@code NULL}, each of its elements corresponds to a color attachment (the element in {@code pColorAttachments} at the same index), and a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-resolve-operations">multisample resolve operation</a> is defined for each attachment unless the resolve attachment index is #ATTACHMENT_UNUSED.

        Similarly, if {@code flags} does not include #SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and ##VkSubpassDescriptionDepthStencilResolve{@code ::pDepthStencilResolveAttachment} is not {@code NULL} and does not have the value #ATTACHMENT_UNUSED, it corresponds to the depth/stencil attachment in {@code pDepthStencilAttachment}, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-resolve-operations">multisample resolve operation</a> for depth and stencil are defined by ##VkSubpassDescriptionDepthStencilResolve{@code ::depthResolveMode} and ##VkSubpassDescriptionDepthStencilResolve{@code ::stencilResolveMode}, respectively. If ##VkSubpassDescriptionDepthStencilResolve{@code ::depthResolveMode} is #RESOLVE_MODE_NONE or the {@code pDepthStencilResolveAttachment} does not have a depth aspect, no resolve operation is performed for the depth attachment. If ##VkSubpassDescriptionDepthStencilResolve{@code ::stencilResolveMode} is #RESOLVE_MODE_NONE or the {@code pDepthStencilResolveAttachment} does not have a stencil aspect, no resolve operation is performed for the stencil attachment.

        If the image subresource range referenced by the depth/stencil attachment is created with #IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-resolve-operations">multisample resolve operation</a> uses the sample locations state specified in the {@code sampleLocationsInfo} member of the element of the ##VkRenderPassSampleLocationsBeginInfoEXT{@code ::pPostSubpassSampleLocations} for the subpass.

        If {@code pDepthStencilAttachment} is {@code NULL}, or if its attachment index is #ATTACHMENT_UNUSED, it indicates that no depth/stencil attachment will be used in the subpass.

        The contents of an attachment within the render area become undefined at the start of a subpass <b>S</b> if all of the following conditions are true:

        <ul>
            <li>The attachment is used as a color, depth/stencil, or resolve attachment in any subpass in the render pass.</li>
            <li>There is a subpass <b>S<sub>1</sub></b> that uses or preserves the attachment, and a subpass dependency from <b>S<sub>1</sub></b> to <b>S</b>.</li>
            <li>The attachment is not used or preserved in subpass <b>S</b>.</li>
        </ul>

        In addition, the contents of an attachment within the render area become undefined at the start of a subpass <b>S</b> if all of the following conditions are true:

        <ul>
            <li>#SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM is set.</li>
            <li>The attachment is used as a color or depth/stencil in the subpass.</li>
        </ul>

        Once the contents of an attachment become undefined in subpass <b>S</b>, they remain undefined for subpasses in subpass dependency chains starting with subpass <b>S</b> until they are written again. However, they remain valid for subpasses in other subpass dependency chains starting with subpass <b>S<sub>1</sub></b> if those subpasses use or preserve the attachment.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code attachment} member of an element of {@code pInputAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL</li>
            <li>If the {@code attachment} member of an element of {@code pColorAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL</li>
            <li>If the {@code attachment} member of an element of {@code pResolveAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL</li>
            <li>If the {@code attachment} member of {@code pDepthStencilAttachment} is not #ATTACHMENT_UNUSED, ts {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL</li>
            <li>If the {@code attachment} member of an element of {@code pColorAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or #IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL</li>
            <li>If the {@code attachment} member of an element of {@code pResolveAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or #IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL</li>
            <li>If the {@code attachment} member of an element of {@code pInputAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL</li>
            <li>If the {@code attachment} member of an element of {@code pColorAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If the {@code attachment} member of an element of {@code pResolveAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, #IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, #IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or #IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If the {@code attachment} member of an element of {@code pInputAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR</li>
            <li>If the {@code attachment} member of an element of {@code pColorAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR</li>
            <li>If the {@code attachment} member of an element of {@code pResolveAttachments} is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> not be #IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR</li>
            <li>{@code pipelineBindPoint} <b>must</b> be #PIPELINE_BIND_POINT_GRAPHICS or #PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI</li>
            <li>{@code colorAttachmentCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxColorAttachments}</li>
            <li>If the first use of an attachment in this render pass is as an input attachment, and the attachment is not also used as a color or depth/stencil attachment in the same subpass, then {@code loadOp} <b>must</b> not be #ATTACHMENT_LOAD_OP_CLEAR</li>
            <li>If {@code pResolveAttachments} is not {@code NULL}, for each resolve attachment that is not #ATTACHMENT_UNUSED, the corresponding color attachment <b>must</b> not be #ATTACHMENT_UNUSED</li>
            <li>If {@code pResolveAttachments} is not {@code NULL}, for each resolve attachment that is not #ATTACHMENT_UNUSED, the corresponding color attachment <b>must</b> not have a sample count of #SAMPLE_COUNT_1_BIT</li>
            <li>If {@code pResolveAttachments} is not {@code NULL}, each resolve attachment that is not #ATTACHMENT_UNUSED <b>must</b> have a sample count of #SAMPLE_COUNT_1_BIT</li>
            <li>If {@code pResolveAttachments} is not {@code NULL}, each resolve attachment that is not #ATTACHMENT_UNUSED <b>must</b> have the same {@code VkFormat} as its corresponding color attachment</li>
            <li>All attachments in {@code pColorAttachments} that are not #ATTACHMENT_UNUSED <b>must</b> have the same sample count</li>
            <li>All attachments in {@code pInputAttachments} that are not #ATTACHMENT_UNUSED <b>must</b> have image formats whose <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> contain at least #FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or #FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>All attachments in {@code pColorAttachments} that are not #ATTACHMENT_UNUSED <b>must</b> have image formats whose <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> contain #FORMAT_FEATURE_COLOR_ATTACHMENT_BIT</li>
            <li>All attachments in {@code pResolveAttachments} that are not #ATTACHMENT_UNUSED <b>must</b> have image formats whose <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> contain #FORMAT_FEATURE_COLOR_ATTACHMENT_BIT</li>
            <li>If {@code pDepthStencilAttachment} is not {@code NULL} and the attachment is not #ATTACHMENT_UNUSED then it <b>must</b> have an image format whose <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> contain #FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-linearColorAttachment">{@code linearColorAttachment}</a> feature is enabled and the image is created with #IMAGE_TILING_LINEAR, all attachments in {@code pInputAttachments} that are not #ATTACHMENT_UNUSED <b>must</b> have image formats whose <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> <b>must</b> contain #FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-linearColorAttachment">{@code linearColorAttachment}</a> feature is enabled and the image is created with #IMAGE_TILING_LINEAR, all attachments in {@code pColorAttachments} that are not #ATTACHMENT_UNUSED <b>must</b> have image formats whose <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> <b>must</b> contain #FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-linearColorAttachment">{@code linearColorAttachment}</a> feature is enabled and the image is created with #IMAGE_TILING_LINEAR, all attachments in {@code pResolveAttachments} that are not #ATTACHMENT_UNUSED <b>must</b> have image formats whose <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#potential-format-features">potential format features</a> <b>must</b> contain #FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV</li>
            <li>
                If either of the following is enabled:
                <ul>
                    <li>The {@link AMDMixedAttachmentSamples VK_AMD_mixed_attachment_samples} extension</li>
                    <li>The {@link NVFramebufferMixedSamples VK_NV_framebuffer_mixed_samples} extension</li>
                </ul>

                all attachments in {@code pColorAttachments} that are not #ATTACHMENT_UNUSED <b>must</b> have a sample count that is smaller than or equal to the sample count of {@code pDepthStencilAttachment} if it is not #ATTACHMENT_UNUSED
            </li>
            <li>
                If {@code pDepthStencilAttachment} is not #ATTACHMENT_UNUSED and any attachments in {@code pColorAttachments} are not #ATTACHMENT_UNUSED, they <b>must</b> have the same sample count , if none of the following are enabled:
                <ul>
                    <li>The {@link AMDMixedAttachmentSamples VK_AMD_mixed_attachment_samples} extension</li>
                    <li>The {@link NVFramebufferMixedSamples VK_NV_framebuffer_mixed_samples} extension</li>
                </ul>
            </li>
            <li>Each element of {@code pPreserveAttachments} <b>must</b> not be #ATTACHMENT_UNUSED</li>
            <li>Each element of {@code pPreserveAttachments} <b>must</b> not also be an element of any other member of the subpass description</li>
            <li>If any attachment is used by more than one ##VkAttachmentReference member, then each use <b>must</b> use the same {@code layout}</li>
            <li>If {@code flags} includes #SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX, it <b>must</b> also include #SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX</li>
            <li>If {@code flags} includes #SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and if {@code pResolveAttachments} is not {@code NULL}, then each resolve attachment <b>must</b> be #ATTACHMENT_UNUSED</li>
            <li>If {@code flags} includes #SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, then the subpass <b>must</b> be the last subpass in a subpass dependency chain</li>
            <li>If the render pass is created with #RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM each of the elements of {@code pInputAttachments} <b>must</b> be #ATTACHMENT_UNUSED</li>
            <li>{@code pDepthStencilAttachment} and {@code pColorAttachments} <b>must</b> not contain references to the same attachment</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkSubpassDescriptionFlagBits} values</li>
            <li>{@code pipelineBindPoint} <b>must</b> be a valid {@code VkPipelineBindPoint} value</li>
            <li>If {@code inputAttachmentCount} is not 0, {@code pInputAttachments} <b>must</b> be a valid pointer to an array of {@code inputAttachmentCount} valid ##VkAttachmentReference structures</li>
            <li>If {@code colorAttachmentCount} is not 0, {@code pColorAttachments} <b>must</b> be a valid pointer to an array of {@code colorAttachmentCount} valid ##VkAttachmentReference structures</li>
            <li>If {@code colorAttachmentCount} is not 0, and {@code pResolveAttachments} is not {@code NULL}, {@code pResolveAttachments} <b>must</b> be a valid pointer to an array of {@code colorAttachmentCount} valid ##VkAttachmentReference structures</li>
            <li>If {@code pDepthStencilAttachment} is not {@code NULL}, {@code pDepthStencilAttachment} <b>must</b> be a valid pointer to a valid ##VkAttachmentReference structure</li>
            <li>If {@code preserveAttachmentCount} is not 0, {@code pPreserveAttachments} <b>must</b> be a valid pointer to an array of {@code preserveAttachmentCount} {@code uint32_t} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkAttachmentReference, ##VkRenderPassCreateInfo
        """

    VkSubpassDescriptionFlags("flags", "a bitmask of {@code VkSubpassDescriptionFlagBits} specifying usage of the subpass.")
    VkPipelineBindPoint("pipelineBindPoint", "a {@code VkPipelineBindPoint} value specifying the pipeline type supported for this subpass.")
    AutoSize("pInputAttachments", optional = true)..uint32_t("inputAttachmentCount", "the number of input attachments.")
    VkAttachmentReference.const.p("pInputAttachments", "a pointer to an array of ##VkAttachmentReference structures defining the input attachments for this subpass and their layouts.")
    AutoSize("pColorAttachments", "pResolveAttachments", optional = true)..uint32_t("colorAttachmentCount", "the number of color attachments.")
    VkAttachmentReference.const.p("pColorAttachments", "a pointer to an array of {@code colorAttachmentCount} ##VkAttachmentReference structures defining the color attachments for this subpass and their layouts.")
    nullable..VkAttachmentReference.const.p("pResolveAttachments", "{@code NULL} or a pointer to an array of {@code colorAttachmentCount} ##VkAttachmentReference structures defining the resolve attachments for this subpass and their layouts.")
    nullable..VkAttachmentReference.const.p("pDepthStencilAttachment", "a pointer to a ##VkAttachmentReference structure specifying the depth/stencil attachment for this subpass and its layout.")
    AutoSize("pPreserveAttachments", optional = true)..uint32_t("preserveAttachmentCount", "the number of preserved attachments.")
    uint32_t.const.p("pPreserveAttachments", "a pointer to an array of {@code preserveAttachmentCount} render pass attachment indices identifying attachments that are not used by this subpass, but whose contents <b>must</b> be preserved throughout the subpass.")
}

val VkSubpassDependency = struct(Module.VULKAN, "VkSubpassDependency") {
    documentation =
        """
        Structure specifying a subpass dependency.

        <h5>Description</h5>
        If {@code srcSubpass} is equal to {@code dstSubpass} then the ##VkSubpassDependency does not directly define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies">dependency</a>. Instead, it enables pipeline barriers to be used in a render pass instance within the identified subpass, where the scopes of one pipeline barrier <b>must</b> be a subset of those described by one subpass dependency. Subpass dependencies specified in this way that include <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-framebuffer-regions">framebuffer-space stages</a> in the {@code srcStageMask} <b>must</b> only include <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-framebuffer-regions">framebuffer-space stages</a> in {@code dstStageMask}, and <b>must</b> include #DEPENDENCY_BY_REGION_BIT. When a subpass dependency is specified in this way for a subpass that has more than one view in its view mask, its {@code dependencyFlags} <b>must</b> include #DEPENDENCY_VIEW_LOCAL_BIT.

        If {@code srcSubpass} and {@code dstSubpass} are not equal, when a render pass instance which includes a subpass dependency is submitted to a queue, it defines a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies">dependency</a> between the subpasses identified by {@code srcSubpass} and {@code dstSubpass}.

        If {@code srcSubpass} is equal to #SUBPASS_EXTERNAL, the first <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-scopes">synchronization scope</a> includes commands that occur earlier in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-submission-order">submission order</a> than the #CmdBeginRenderPass() used to begin the render pass instance. Otherwise, the first set of commands includes all commands submitted as part of the subpass instance identified by {@code srcSubpass} and any <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-load-operations">load</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-store-operations">store</a>, or <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-resolve-operations">multisample resolve</a> operations on attachments used in {@code srcSubpass}. In either case, the first synchronization scope is limited to operations on the pipeline stages determined by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-pipeline-stages-masks">source stage mask</a> specified by {@code srcStageMask}.

        If {@code dstSubpass} is equal to #SUBPASS_EXTERNAL, the second <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-scopes">synchronization scope</a> includes commands that occur later in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-submission-order">submission order</a> than the #CmdEndRenderPass() used to end the render pass instance. Otherwise, the second set of commands includes all commands submitted as part of the subpass instance identified by {@code dstSubpass} and any <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-load-operations">load</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-store-operations">store</a>, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-resolve-operations">multisample resolve</a> operations on attachments used in {@code dstSubpass}. In either case, the second synchronization scope is limited to operations on the pipeline stages determined by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-pipeline-stages-masks">destination stage mask</a> specified by {@code dstStageMask}.

        The first <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-access-scopes">access scope</a> is limited to accesses in the pipeline stages determined by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-pipeline-stages-masks">source stage mask</a> specified by {@code srcStageMask}. It is also limited to access types in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-masks">source access mask</a> specified by {@code srcAccessMask}.

        The second <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-access-scopes">access scope</a> is limited to accesses in the pipeline stages determined by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-pipeline-stages-masks">destination stage mask</a> specified by {@code dstStageMask}. It is also limited to access types in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-masks">destination access mask</a> specified by {@code dstAccessMask}.

        The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-dependencies-available-and-visible">availability and visibility operations</a> defined by a subpass dependency affect the execution of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-layout-transitions">image layout transitions</a> within the render pass.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        For non-attachment resources, the memory dependency expressed by subpass dependency is nearly identical to that of a ##VkMemoryBarrier (with matching {@code srcAccessMask} and {@code dstAccessMask} parameters) submitted as a part of a #CmdPipelineBarrier() (with matching {@code srcStageMask} and {@code dstStageMask} parameters). The only difference being that its scopes are limited to the identified subpasses rather than potentially affecting everything before and after.

        For attachments however, subpass dependencies work more like a ##VkImageMemoryBarrier defined similarly to the ##VkMemoryBarrier above, the queue family indices set to #QUEUE_FAMILY_IGNORED, and layouts as follows:

        <ul>
            <li>The equivalent to {@code oldLayout} is the attachment’s layout according to the subpass description for {@code srcSubpass}.</li>
            <li>The equivalent to {@code newLayout} is the attachment’s layout according to the subpass description for {@code dstSubpass}.</li>
        </ul>
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-geometryShader">{@code geometryShader}</a> feature is not enabled, {@code srcStageMask} <b>must</b> not contain #PIPELINE_STAGE_GEOMETRY_SHADER_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-tessellationShader">{@code tessellationShader}</a> feature is not enabled, {@code srcStageMask} <b>must</b> not contain #PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or #PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-conditionalRendering">{@code conditionalRendering}</a> feature is not enabled, {@code srcStageMask} <b>must</b> not contain #PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMap">{@code fragmentDensityMap}</a> feature is not enabled, {@code srcStageMask} <b>must</b> not contain #PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-transformFeedback">{@code transformFeedback}</a> feature is not enabled, {@code srcStageMask} <b>must</b> not contain #PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-meshShader">{@code meshShader}</a> feature is not enabled, {@code srcStageMask} <b>must</b> not contain #PIPELINE_STAGE_MESH_SHADER_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-taskShader">{@code taskShader}</a> feature is not enabled, {@code srcStageMask} <b>must</b> not contain #PIPELINE_STAGE_TASK_SHADER_BIT_EXT</li>
            <li>If neither of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shadingRateImage">{@code shadingRateImage}</a> or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFragmentShadingRate">{@code attachmentFragmentShadingRate}</a> features are enabled, {@code srcStageMask} <b>must</b> not contain #PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, {@code srcStageMask} <b>must</b> not be 0</li>
            <li>If neither the {@link NVRayTracing VK_NV_ray_tracing} extension or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-rayTracingPipeline">{@code rayTracingPipeline}</a> feature are enabled, {@code srcStageMask} <b>must</b> not contain #PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR</li>
        </ul>

        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-geometryShader">{@code geometryShader}</a> feature is not enabled, {@code dstStageMask} <b>must</b> not contain #PIPELINE_STAGE_GEOMETRY_SHADER_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-tessellationShader">{@code tessellationShader}</a> feature is not enabled, {@code dstStageMask} <b>must</b> not contain #PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or #PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-conditionalRendering">{@code conditionalRendering}</a> feature is not enabled, {@code dstStageMask} <b>must</b> not contain #PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-fragmentDensityMap">{@code fragmentDensityMap}</a> feature is not enabled, {@code dstStageMask} <b>must</b> not contain #PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-transformFeedback">{@code transformFeedback}</a> feature is not enabled, {@code dstStageMask} <b>must</b> not contain #PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-meshShader">{@code meshShader}</a> feature is not enabled, {@code dstStageMask} <b>must</b> not contain #PIPELINE_STAGE_MESH_SHADER_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-taskShader">{@code taskShader}</a> feature is not enabled, {@code dstStageMask} <b>must</b> not contain #PIPELINE_STAGE_TASK_SHADER_BIT_EXT</li>
            <li>If neither of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shadingRateImage">{@code shadingRateImage}</a> or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-attachmentFragmentShadingRate">{@code attachmentFragmentShadingRate}</a> features are enabled, {@code dstStageMask} <b>must</b> not contain #PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-synchronization2">{@code synchronization2}</a> feature is not enabled, {@code dstStageMask} <b>must</b> not be 0</li>
            <li>If neither the {@link NVRayTracing VK_NV_ray_tracing} extension or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-rayTracingPipeline">{@code rayTracingPipeline}</a> feature are enabled, {@code dstStageMask} <b>must</b> not contain #PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR</li>
            <li>{@code srcSubpass} <b>must</b> be less than or equal to {@code dstSubpass}, unless one of them is #SUBPASS_EXTERNAL, to avoid cyclic dependencies and ensure a valid execution order</li>
            <li>{@code srcSubpass} and {@code dstSubpass} <b>must</b> not both be equal to #SUBPASS_EXTERNAL</li>
            <li>If {@code srcSubpass} is equal to {@code dstSubpass} and {@code srcStageMask} includes a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-framebuffer-regions">framebuffer-space stage</a>, {@code dstStageMask} <b>must</b> only contain <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-framebuffer-regions">framebuffer-space stages</a></li>
            <li>Any access flag included in {@code srcAccessMask} <b>must</b> be supported by one of the pipeline stages in {@code srcStageMask}, as specified in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-types-supported">table of supported access types</a></li>
            <li>Any access flag included in {@code dstAccessMask} <b>must</b> be supported by one of the pipeline stages in {@code dstStageMask}, as specified in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-access-types-supported">table of supported access types</a></li>
            <li>If {@code srcSubpass} equals {@code dstSubpass}, and {@code srcStageMask} and {@code dstStageMask} both include a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-framebuffer-regions">framebuffer-space stage</a>, then {@code dependencyFlags} <b>must</b> include #DEPENDENCY_BY_REGION_BIT</li>
            <li>If {@code dependencyFlags} includes #DEPENDENCY_VIEW_LOCAL_BIT, {@code srcSubpass} <b>must</b> not be equal to #SUBPASS_EXTERNAL</li>
            <li>If {@code dependencyFlags} includes #DEPENDENCY_VIEW_LOCAL_BIT, {@code dstSubpass} <b>must</b> not be equal to #SUBPASS_EXTERNAL</li>
            <li>If {@code srcSubpass} equals {@code dstSubpass} and that subpass has more than one bit set in the view mask, then {@code dependencyFlags} <b>must</b> include #DEPENDENCY_VIEW_LOCAL_BIT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code srcStageMask} <b>must</b> be a valid combination of {@code VkPipelineStageFlagBits} values</li>
            <li>{@code dstStageMask} <b>must</b> be a valid combination of {@code VkPipelineStageFlagBits} values</li>
            <li>{@code srcAccessMask} <b>must</b> be a valid combination of {@code VkAccessFlagBits} values</li>
            <li>{@code dstAccessMask} <b>must</b> be a valid combination of {@code VkAccessFlagBits} values</li>
            <li>{@code dependencyFlags} <b>must</b> be a valid combination of {@code VkDependencyFlagBits} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkRenderPassCreateInfo
        """

    uint32_t("srcSubpass", "the subpass index of the first subpass in the dependency, or #SUBPASS_EXTERNAL.")
    uint32_t("dstSubpass", "the subpass index of the second subpass in the dependency, or #SUBPASS_EXTERNAL.")
    VkPipelineStageFlags("srcStageMask", "a bitmask of {@code VkPipelineStageFlagBits} specifying the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-pipeline-stages-masks\">source stage mask</a>.")
    VkPipelineStageFlags("dstStageMask", "a bitmask of {@code VkPipelineStageFlagBits} specifying the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-pipeline-stages-masks\">destination stage mask</a>")
    VkAccessFlags("srcAccessMask", "a bitmask of {@code VkAccessFlagBits} specifying a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-access-masks\">source access mask</a>.")
    VkAccessFlags("dstAccessMask", "a bitmask of {@code VkAccessFlagBits} specifying a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-access-masks\">destination access mask</a>.")
    VkDependencyFlags("dependencyFlags", "a bitmask of {@code VkDependencyFlagBits}.")
}

val VkRenderPassCreateInfo = struct(Module.VULKAN, "VkRenderPassCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created render pass.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Care should be taken to avoid a data race here; if any subpasses access attachments with overlapping memory locations, and one of those accesses is a write, a subpass dependency needs to be included between them.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code attachment} member of any element of {@code pInputAttachments}, {@code pColorAttachments}, {@code pResolveAttachments} or {@code pDepthStencilAttachment}, or any element of {@code pPreserveAttachments} in any element of {@code pSubpasses} is not #ATTACHMENT_UNUSED, then it <b>must</b> be less than {@code attachmentCount}</li>
            <li>If the pNext chain includes a ##VkRenderPassFragmentDensityMapCreateInfoEXT structure and the {@code fragmentDensityMapAttachment} member is not #ATTACHMENT_UNUSED, then {@code attachment} <b>must</b> be less than {@code attachmentCount}</li>
            <li>For any member of {@code pAttachments} with a {@code loadOp} equal to #ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment <b>must</b> not specify a {@code layout} equal to #IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL or #IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>For any member of {@code pAttachments} with a {@code stencilLoadOp} equal to #ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment <b>must</b> not specify a {@code layout} equal to #IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL or #IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>For any member of {@code pAttachments} with a {@code loadOp} equal to #ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment <b>must</b> not specify a {@code layout} equal to #IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL</li>
            <li>For any member of {@code pAttachments} with a {@code stencilLoadOp} equal to #ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment <b>must</b> not specify a {@code layout} equal to #IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassInputAttachmentAspectCreateInfo structure, the {@code subpass} member of each element of its {@code pAspectReferences} member <b>must</b> be less than {@code subpassCount}</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassInputAttachmentAspectCreateInfo structure, the {@code inputAttachmentIndex} member of each element of its {@code pAspectReferences} member <b>must</b> be less than the value of {@code inputAttachmentCount} in the element of {@code pSubpasses} identified by its {@code subpass} member</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassInputAttachmentAspectCreateInfo structure, for any element of the {@code pInputAttachments} member of any element of {@code pSubpasses} where the {@code attachment} member is not #ATTACHMENT_UNUSED, the {@code aspectMask} member of the corresponding element of ##VkRenderPassInputAttachmentAspectCreateInfo{@code ::pAspectReferences} <b>must</b> only include aspects that are present in images of the format specified by the element of {@code pAttachments} at {@code attachment}</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassMultiviewCreateInfo structure, and its {@code subpassCount} member is not zero, that member <b>must</b> be equal to the value of {@code subpassCount}</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassMultiviewCreateInfo structure, if its {@code dependencyCount} member is not zero, it <b>must</b> be equal to {@code dependencyCount}</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassMultiviewCreateInfo structure, for each non-zero element of {@code pViewOffsets}, the {@code srcSubpass} and {@code dstSubpass} members of {@code pDependencies} at the same index <b>must</b> not be equal</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassMultiviewCreateInfo structure, for any element of {@code pDependencies} with a {@code dependencyFlags} member that does not include #DEPENDENCY_VIEW_LOCAL_BIT, the corresponding element of the {@code pViewOffsets} member of that ##VkRenderPassMultiviewCreateInfo instance <b>must</b> be 0</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassMultiviewCreateInfo structure, elements of its {@code pViewMasks} member <b>must</b> either all be 0, or all not be 0</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassMultiviewCreateInfo structure, and each element of its {@code pViewMasks} member is 0, the {@code dependencyFlags} member of each element of {@code pDependencies} <b>must</b> not include #DEPENDENCY_VIEW_LOCAL_BIT</li>
            <li>If the {@code pNext} chain includes a ##VkRenderPassMultiviewCreateInfo structure, and each element of its {@code pViewMasks} member is 0, its {@code correlationMaskCount} member <b>must</b> be 0</li>
            <li>For any element of {@code pDependencies}, if the {@code srcSubpass} is not #SUBPASS_EXTERNAL, all stage flags included in the {@code srcStageMask} member of that dependency <b>must</b> be a pipeline stage supported by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-pipeline-stages-types">pipeline</a> identified by the {@code pipelineBindPoint} member of the source subpass</li>
            <li>For any element of {@code pDependencies}, if the {@code dstSubpass} is not #SUBPASS_EXTERNAL, all stage flags included in the {@code dstStageMask} member of that dependency <b>must</b> be a pipeline stage supported by the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-pipeline-stages-types">pipeline</a> identified by the {@code pipelineBindPoint} member of the destination subpass</li>
            <li>For any element of {@code pDependencies}, if its {@code srcSubpass} is not #SUBPASS_EXTERNAL, it <b>must</b> be less than {@code subpassCount}</li>
            <li>For any element of {@code pDependencies}, if its {@code dstSubpass} is not #SUBPASS_EXTERNAL, it <b>must</b> be less than {@code subpassCount}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkRenderPassFragmentDensityMapCreateInfoEXT, ##VkRenderPassInputAttachmentAspectCreateInfo, or ##VkRenderPassMultiviewCreateInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkRenderPassCreateFlagBits} values</li>
            <li>If {@code attachmentCount} is not 0, {@code pAttachments} <b>must</b> be a valid pointer to an array of {@code attachmentCount} valid ##VkAttachmentDescription structures</li>
            <li>{@code pSubpasses} <b>must</b> be a valid pointer to an array of {@code subpassCount} valid ##VkSubpassDescription structures</li>
            <li>If {@code dependencyCount} is not 0, {@code pDependencies} <b>must</b> be a valid pointer to an array of {@code dependencyCount} valid ##VkSubpassDependency structures</li>
            <li>{@code subpassCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkAttachmentDescription, ##VkSubpassDependency, ##VkSubpassDescription, #CreateRenderPass()
        """

    Expression("#STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkRenderPassFragmentDensityMapCreateInfoEXT", "VkRenderPassInputAttachmentAspectCreateInfo", "VkRenderPassInputAttachmentAspectCreateInfoKHR", "VkRenderPassMultiviewCreateInfo", "VkRenderPassMultiviewCreateInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkRenderPassCreateFlags("flags", "a bitmask of {@code VkRenderPassCreateFlagBits}")
    AutoSize("pAttachments", optional = true)..uint32_t("attachmentCount", "the number of attachments used by this render pass.")
    VkAttachmentDescription.const.p("pAttachments", "a pointer to an array of {@code attachmentCount} ##VkAttachmentDescription structures describing the attachments used by the render pass.")
    AutoSize("pSubpasses")..uint32_t("subpassCount", "the number of subpasses to create.")
    VkSubpassDescription.const.p("pSubpasses", "a pointer to an array of {@code subpassCount} ##VkSubpassDescription structures describing each subpass.")
    AutoSize("pDependencies", optional = true)..uint32_t("dependencyCount", "the number of memory dependencies between pairs of subpasses.")
    VkSubpassDependency.const.p("pDependencies", "a pointer to an array of {@code dependencyCount} ##VkSubpassDependency structures describing dependencies between pairs of subpasses.")
}

val VkCommandPoolCreateInfo = struct(Module.VULKAN, "VkCommandPoolCreateInfo") {
    documentation =
        """
        Structure specifying parameters of a newly created command pool.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-protectedMemory">{@code protectedMemory}</a> feature is not enabled, the #COMMAND_POOL_CREATE_PROTECTED_BIT bit of {@code flags} <b>must</b> not be set</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkCommandPoolCreateFlagBits} values</li>
        </ul>

        <h5>See Also</h5>
        #CreateCommandPool()
        """

    Expression("#STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkCommandPoolCreateFlags("flags", "a bitmask of {@code VkCommandPoolCreateFlagBits} indicating usage behavior for the pool and command buffers allocated from it.")
    uint32_t("queueFamilyIndex", "designates a queue family as described in section <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#devsandqueues-queueprops\">Queue Family Properties</a>. All command buffers allocated from this command pool <b>must</b> be submitted on queues from the same queue family.")
}

val VkCommandBufferAllocateInfo = struct(Module.VULKAN, "VkCommandBufferAllocateInfo") {
    documentation =
        """
        Structure specifying the allocation parameters for command buffer object.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code commandPool} <b>must</b> be a valid {@code VkCommandPool} handle</li>
            <li>{@code level} <b>must</b> be a valid {@code VkCommandBufferLevel} value</li>
        </ul>

        <h5>See Also</h5>
        #AllocateCommandBuffers()
        """

    Expression("#STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkCommandPool("commandPool", "the command pool from which the command buffers are allocated.")
    VkCommandBufferLevel("level", "a {@code VkCommandBufferLevel} value specifying the command buffer level.")
    uint32_t("commandBufferCount", "the number of command buffers to allocate from the pool.")
}

val VkCommandBufferInheritanceInfo = struct(Module.VULKAN, "VkCommandBufferInheritanceInfo") {
    documentation =
        """
        Structure specifying command buffer inheritance information.

        <h5>Description</h5>
        If the {@code VkCommandBuffer} will not be executed within a render pass instance, or if the render pass instance was begun with #CmdBeginRendering(), {@code renderPass}, {@code subpass}, and {@code framebuffer} are ignored.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-inheritedQueries">{@code inheritedQueries}</a> feature is not enabled, {@code occlusionQueryEnable} <b>must</b> be #FALSE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-inheritedQueries">{@code inheritedQueries}</a> feature is enabled, {@code queryFlags} <b>must</b> be a valid combination of {@code VkQueryControlFlagBits} values</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-inheritedQueries">{@code inheritedQueries}</a> feature is not enabled, {@code queryFlags} <b>must</b> be 0</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineStatisticsQuery">{@code pipelineStatisticsQuery}</a> feature is enabled, {@code pipelineStatistics} <b>must</b> be a valid combination of {@code VkQueryPipelineStatisticFlagBits} values</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineStatisticsQuery">{@code pipelineStatisticsQuery}</a> feature is not enabled, {@code pipelineStatistics} <b>must</b> be 0</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkAttachmentSampleCountInfoAMD, ##VkCommandBufferInheritanceConditionalRenderingInfoEXT, ##VkCommandBufferInheritanceRenderPassTransformInfoQCOM, ##VkCommandBufferInheritanceRenderingInfo, ##VkCommandBufferInheritanceViewportScissorInfoNV, ##VkExternalFormatANDROID, ##VkMultiviewPerViewAttributesInfoNVX, ##VkRenderingAttachmentLocationInfo, or ##VkRenderingInputAttachmentIndexInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>Both of {@code framebuffer}, and {@code renderPass} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkCommandBufferBeginInfo
        """

    Expression("#STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkAttachmentSampleCountInfoAMD", "VkAttachmentSampleCountInfoNV", "VkCommandBufferInheritanceConditionalRenderingInfoEXT", "VkCommandBufferInheritanceRenderPassTransformInfoQCOM", "VkCommandBufferInheritanceRenderingInfo", "VkCommandBufferInheritanceRenderingInfoKHR", "VkCommandBufferInheritanceViewportScissorInfoNV", "VkExternalFormatANDROID", "VkMultiviewPerViewAttributesInfoNVX", "VkRenderingAttachmentLocationInfo", "VkRenderingAttachmentLocationInfoKHR", "VkRenderingInputAttachmentIndexInfo", "VkRenderingInputAttachmentIndexInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkRenderPass("renderPass", "a {@code VkRenderPass} object defining which render passes the {@code VkCommandBuffer} will be <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#renderpass-compatibility\">compatible</a> with and <b>can</b> be executed within.")
    uint32_t("subpass", "the index of the subpass within the render pass instance that the {@code VkCommandBuffer} will be executed within.")
    VkFramebuffer("framebuffer", """<b>can</b> refer to the {@code VkFramebuffer} object that the {@code VkCommandBuffer} will be rendering to if it is executed within a render pass instance. It <b>can</b> be #NULL_HANDLE if the framebuffer is not known.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Specifying the exact framebuffer that the secondary command buffer will be executed with <b>may</b> result in better performance at command buffer execution time.
        </div>""")
    VkBool32("occlusionQueryEnable", "specifies whether the command buffer <b>can</b> be executed while an occlusion query is active in the primary command buffer. If this is #TRUE, then this command buffer <b>can</b> be executed whether the primary command buffer has an occlusion query active or not. If this is #FALSE, then the primary command buffer <b>must</b> not have an occlusion query active.")
    VkQueryControlFlags("queryFlags", "specifies the query flags that <b>can</b> be used by an active occlusion query in the primary command buffer when this secondary command buffer is executed. If this value includes the #QUERY_CONTROL_PRECISE_BIT bit, then the active query <b>can</b> return boolean results or actual sample counts. If this bit is not set, then the active query <b>must</b> not use the #QUERY_CONTROL_PRECISE_BIT bit.")
    VkQueryPipelineStatisticFlags("pipelineStatistics", "a bitmask of {@code VkQueryPipelineStatisticFlagBits} specifying the set of pipeline statistics that <b>can</b> be counted by an active query in the primary command buffer when this secondary command buffer is executed. If this value includes a given bit, then this command buffer <b>can</b> be executed whether the primary command buffer has a pipeline statistics query active that includes this bit or not. If this value excludes a given bit, then the active pipeline statistics query <b>must</b> not be from a query pool that counts that statistic.")
}

val VkCommandBufferBeginInfo = struct(Module.VULKAN, "VkCommandBufferBeginInfo") {
    documentation =
        """
        Structure specifying a command buffer begin operation.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code flags} contains #COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics operations</li>
            <li>If {@code flags} contains #COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the {@code framebuffer} member of {@code pInheritanceInfo} <b>must</b> be either #NULL_HANDLE, or a valid {@code VkFramebuffer} that is compatible with the {@code renderPass} member of {@code pInheritanceInfo}</li>
            <li>If {@code flags} contains #COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dynamicRendering">{@code dynamicRendering}</a> feature is not enabled, the {@code renderPass} member of {@code pInheritanceInfo} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code flags} contains #COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the {@code renderPass} member of {@code pInheritanceInfo} is #NULL_HANDLE, the {@code pNext} chain of {@code pInheritanceInfo} <b>must</b> include a ##VkCommandBufferInheritanceRenderingInfo structure</li>
            <li>If {@code flags} contains #COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the {@code renderPass} member of {@code pInheritanceInfo} is #NULL_HANDLE, and the {@code pNext} chain of {@code pInheritanceInfo} includes a ##VkAttachmentSampleCountInfoAMD or ##VkAttachmentSampleCountInfoNV structure, the {@code colorAttachmentCount} member of that structure <b>must</b> be equal to the value of ##VkCommandBufferInheritanceRenderingInfo{@code ::colorAttachmentCount}</li>
            <li>If {@code flags} contains #COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the {@code renderPass} member of {@code pInheritanceInfo} is not #NULL_HANDLE, the {@code renderPass} member of {@code pInheritanceInfo} <b>must</b> be a valid {@code VkRenderPass}</li>
            <li>If {@code flags} contains #COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the {@code renderPass} member of {@code pInheritanceInfo} is not #NULL_HANDLE, the {@code subpass} member of {@code pInheritanceInfo} <b>must</b> be a valid subpass index within the {@code renderPass} member of {@code pInheritanceInfo}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkDeviceGroupCommandBufferBeginInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkCommandBufferUsageFlagBits} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkCommandBufferInheritanceInfo, #BeginCommandBuffer()
        """

    Expression("#STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDeviceGroupCommandBufferBeginInfo", "VkDeviceGroupCommandBufferBeginInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkCommandBufferUsageFlags("flags", "a bitmask of {@code VkCommandBufferUsageFlagBits} specifying usage behavior for the command buffer.")
    nullable..VkCommandBufferInheritanceInfo.const.p("pInheritanceInfo", "a pointer to a ##VkCommandBufferInheritanceInfo structure, used if {@code commandBuffer} is a secondary command buffer. If this is a primary command buffer, then this value is ignored.")
}

val VkBufferCopy = struct(Module.VULKAN, "VkBufferCopy") {
    documentation =
        """
        Structure specifying a buffer copy operation.

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code size} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        #CmdCopyBuffer()
        """

    VkDeviceSize("srcOffset", "the starting offset in bytes from the start of {@code srcBuffer}.")
    VkDeviceSize("dstOffset", "the starting offset in bytes from the start of {@code dstBuffer}.")
    VkDeviceSize("size", "the number of bytes to copy.")
}

val VkImageSubresourceLayers = struct(Module.VULKAN, "VkImageSubresourceLayers") {
    documentation =
        """
        Structure specifying an image subresource layers.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code aspectMask} contains #IMAGE_ASPECT_COLOR_BIT, it <b>must</b> not contain either of #IMAGE_ASPECT_DEPTH_BIT or #IMAGE_ASPECT_STENCIL_BIT</li>
            <li>{@code aspectMask} <b>must</b> not contain #IMAGE_ASPECT_METADATA_BIT</li>
            <li>{@code aspectMask} <b>must</b> not include <code>VK_IMAGE_ASPECT_MEMORY_PLANE<em>_i_</em>BIT_EXT</code> for any index <em>i</em></li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-maintenance5">{@code maintenance5}</a> feature is not enabled, {@code layerCount} <b>must</b> not be #REMAINING_ARRAY_LAYERS</li>
            <li>If {@code layerCount} is not #REMAINING_ARRAY_LAYERS, it <b>must</b> be greater than 0</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code aspectMask} <b>must</b> be a valid combination of {@code VkImageAspectFlagBits} values</li>
            <li>{@code aspectMask} <b>must</b> not be 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkBufferImageCopy, ##VkBufferImageCopy2, ##VkCopyMemoryToImageIndirectCommandNV, ##VkImageBlit, ##VkImageBlit2, ##VkImageCopy, ##VkImageCopy2, ##VkImageResolve, ##VkImageResolve2, ##VkImageToMemoryCopy, ##VkMemoryToImageCopy, #CmdCopyMemoryToImageIndirectNV()
        """

    VkImageAspectFlags("aspectMask", "a combination of {@code VkImageAspectFlagBits}, selecting the color, depth and/or stencil aspects to be copied.")
    uint32_t("mipLevel", "the mipmap level to copy")
    uint32_t("baseArrayLayer", "{@code baseArrayLayer} and {@code layerCount} are the starting layer and number of layers to copy.")
    uint32_t("layerCount", "see {@code baseArrayLayer}")
}

val VkBufferImageCopy = struct(Module.VULKAN, "VkBufferImageCopy") {
    documentation =
        """
        Structure specifying a buffer image copy operation.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code bufferRowLength} <b>must</b> be 0, or greater than or equal to the {@code width} member of {@code imageExtent}</li>
            <li>{@code bufferImageHeight} <b>must</b> be 0, or greater than or equal to the {@code height} member of {@code imageExtent}</li>
            <li>The {@code aspectMask} member of {@code imageSubresource} <b>must</b> only have a single bit set</li>
            <li>{@code imageExtent.width} <b>must</b> not be 0</li>
            <li>{@code imageExtent.height} <b>must</b> not be 0</li>
            <li>{@code imageExtent.depth} <b>must</b> not be 0</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code imageSubresource} <b>must</b> be a valid ##VkImageSubresourceLayers structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent3D, ##VkImageSubresourceLayers, ##VkOffset3D, #CmdCopyBufferToImage(), #CmdCopyImageToBuffer()
        """

    VkDeviceSize("bufferOffset", "the offset in bytes from the start of the buffer object where the image data is copied from or to.")
    uint32_t("bufferRowLength", "{@code bufferRowLength} and {@code bufferImageHeight} specify in texels a subregion of a larger two- or three-dimensional image in buffer memory, and control the addressing calculations. If either of these values is zero, that aspect of the buffer memory is considered to be tightly packed according to the {@code imageExtent}.")
    uint32_t("bufferImageHeight", "see {@code bufferRowLength}")
    VkImageSubresourceLayers("imageSubresource", "a ##VkImageSubresourceLayers used to specify the specific image subresources of the image used for the source or destination image data.")
    VkOffset3D("imageOffset", "selects the initial {@code x}, {@code y}, {@code z} offsets in texels of the sub-region of the source or destination image data.")
    VkExtent3D("imageExtent", "the size in texels of the image to copy in {@code width}, {@code height} and {@code depth}.")
}

val VkClearColorValue = union(Module.VULKAN, "VkClearColorValue") {
    documentation =
        """
        Structure specifying a clear color value.

        <h5>Description</h5>
        The four array elements of the clear color map to R, G, B, and A components of image formats, in order.

        If the image has more than one sample, the same value is written to all samples for any pixels being cleared.

        If the image or attachment format has a 64-bit component width, the first 2 array elements of each of the arrays above are reinterpreted as a single 64-bit element for the R component. The next 2 array elements are used in the same way for the G component. In other words, the union behaves as if it had the following additional members:

        <pre><code>
￿double float64[2];
￿int64_t int64[2];
￿uint64_t uint64[2];</code></pre>

        <h5>See Also</h5>
        ##VkClearValue, ##VkSamplerCustomBorderColorCreateInfoEXT, #CmdClearColorImage()
        """

    float("float32", "are the color clear values when the format of the image or attachment is one of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#formats-numericformat\">numeric formats</a> with a numeric type that is floating-point. Floating-point values are automatically converted to the format of the image, with the clear value being treated as linear if the image is sRGB.")[4]
    int32_t("int32", "are the color clear values when the format of the image or attachment has a numeric type that is signed integer ({@code SINT}). Signed integer values are converted to the format of the image by casting to the smaller type (with negative 32-bit values mapping to negative values in the smaller type). If the integer clear value is not representable in the target type (e.g. would overflow in conversion to that type), the clear value is undefined.")[4]
    uint32_t("uint32", "are the color clear values when the format of the image or attachment has a numeric type that is unsigned integer ({@code UINT}). Unsigned integer values are converted to the format of the image by casting to the integer type with fewer bits.")[4]
}

val VkClearDepthStencilValue = struct(Module.VULKAN, "VkClearDepthStencilValue") {
    documentation =
        """
        Structure specifying a clear depth stencil value.

        <h5>Valid Usage</h5>
        <ul>
            <li>Unless the {@link EXTDepthRangeUnrestricted VK_EXT_depth_range_unrestricted} extension is enabled {@code depth} <b>must</b> be between {@code 0.0} and {@code 1.0}, inclusive</li>
        </ul>

        <h5>See Also</h5>
        ##VkClearValue, #CmdClearDepthStencilImage()
        """

    float("depth", "the clear value for the depth aspect of the depth/stencil attachment. It is a floating-point value which is automatically converted to the attachment’s format.")
    uint32_t("stencil", "the clear value for the stencil aspect of the depth/stencil attachment. It is a 32-bit integer value which is converted to the attachment’s format by taking the appropriate number of LSBs.")
}

val VkClearValue = union(Module.VULKAN, "VkClearValue") {
    documentation =
        """
        Structure specifying a clear value.

        <h5>Description</h5>
        This union is used where part of the API requires either color or depth/stencil clear values, depending on the attachment, and defines the initial clear values in the ##VkRenderPassBeginInfo structure.

        <h5>See Also</h5>
        ##VkClearAttachment, ##VkClearColorValue, ##VkClearDepthStencilValue, ##VkRenderPassBeginInfo, ##VkRenderingAttachmentInfo
        """

    VkClearColorValue("color", "specifies the color image clear values to use when clearing a color image or attachment.")
    VkClearDepthStencilValue("depthStencil", "specifies the depth and stencil clear values to use when clearing a depth/stencil image or attachment.")
}

val VkClearAttachment = struct(Module.VULKAN, "VkClearAttachment") {
    documentation =
        """
        Structure specifying a clear attachment.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code aspectMask} includes #IMAGE_ASPECT_COLOR_BIT, it <b>must</b> not include #IMAGE_ASPECT_DEPTH_BIT or #IMAGE_ASPECT_STENCIL_BIT</li>
            <li>{@code aspectMask} <b>must</b> not include #IMAGE_ASPECT_METADATA_BIT</li>
            <li>{@code aspectMask} <b>must</b> not include <code>VK_IMAGE_ASPECT_MEMORY_PLANE<em>_i_</em>BIT_EXT</code> for any index <em>i</em></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code aspectMask} <b>must</b> be a valid combination of {@code VkImageAspectFlagBits} values</li>
            <li>{@code aspectMask} <b>must</b> not be 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkClearValue, #CmdClearAttachments()
        """

    VkImageAspectFlags("aspectMask", "a mask selecting the color, depth and/or stencil aspects of the attachment to be cleared.")
    uint32_t("colorAttachment", "only meaningful if #IMAGE_ASPECT_COLOR_BIT is set in {@code aspectMask}, in which case it is an index into the bound color attachments.")
    VkClearValue("clearValue", "the color or depth/stencil value to clear the attachment to, as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#clears-values\">Clear Values</a> below.")
}

val VkClearRect = struct(Module.VULKAN, "VkClearRect") {
    documentation =
        """
        Structure specifying a clear rectangle.

        <h5>Description</h5>
        The layers <code>[baseArrayLayer, baseArrayLayer + layerCount)</code> counting from the base layer of the attachment image view are cleared.

        <h5>See Also</h5>
        ##VkRect2D, #CmdClearAttachments()
        """

    VkRect2D("rect", "the two-dimensional region to be cleared.")
    uint32_t("baseArrayLayer", "the first layer to be cleared.")
    uint32_t("layerCount", "the number of layers to clear.")
}

val VkImageBlit = struct(Module.VULKAN, "VkImageBlit") {
    documentation =
        """
        Structure specifying an image blit operation.

        <h5>Description</h5>
        For each element of the {@code pRegions} array, a blit operation is performed for the specified source and destination regions.

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code aspectMask} member of {@code srcSubresource} and {@code dstSubresource} <b>must</b> match</li>
            <li>If neither of the {@code layerCount} members of {@code srcSubresource} or {@code dstSubresource} are #REMAINING_ARRAY_LAYERS, the {@code layerCount} members of {@code srcSubresource} or {@code dstSubresource} <b>must</b> match</li>
            <li>If one of the {@code layerCount} members of {@code srcSubresource} or {@code dstSubresource} is #REMAINING_ARRAY_LAYERS, the other member <b>must</b> be either #REMAINING_ARRAY_LAYERS or equal to the {@code arrayLayers} member of the ##VkImageCreateInfo used to create the image minus {@code baseArrayLayer}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code srcSubresource} <b>must</b> be a valid ##VkImageSubresourceLayers structure</li>
            <li>{@code dstSubresource} <b>must</b> be a valid ##VkImageSubresourceLayers structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkImageSubresourceLayers, ##VkOffset3D, #CmdBlitImage()
        """

    VkImageSubresourceLayers("srcSubresource", "the subresource to blit from.")
    VkOffset3D("srcOffsets", "a pointer to an array of two ##VkOffset3D structures specifying the bounds of the source region within {@code srcSubresource}.")[2]
    VkImageSubresourceLayers("dstSubresource", "the subresource to blit into.")
    VkOffset3D("dstOffsets", "a pointer to an array of two ##VkOffset3D structures specifying the bounds of the destination region within {@code dstSubresource}.")[2]
}

val VkImageCopy = struct(Module.VULKAN, "VkImageCopy") {
    documentation =
        """
        Structure specifying an image copy operation.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@link KHRSamplerYcbcrConversion VK_KHR_sampler_ycbcr_conversion} extension is not enabled, and ##VkPhysicalDeviceProperties{@code ::apiVersion} is less than Vulkan 1.1, the {@code aspectMask} member of {@code srcSubresource} and {@code dstSubresource} <b>must</b> match</li>
            <li>If the {@link KHRMaintenance1 VK_KHR_maintenance1} extension is not enabled, and ##VkPhysicalDeviceProperties{@code ::apiVersion} is less than Vulkan 1.1, the {@code layerCount} member of {@code srcSubresource} and {@code dstSubresource} <b>must</b> match</li>
            <li>{@code extent.width} <b>must</b> not be 0</li>
            <li>{@code extent.height} <b>must</b> not be 0</li>
            <li>{@code extent.depth} <b>must</b> not be 0</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code srcSubresource} <b>must</b> be a valid ##VkImageSubresourceLayers structure</li>
            <li>{@code dstSubresource} <b>must</b> be a valid ##VkImageSubresourceLayers structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent3D, ##VkImageSubresourceLayers, ##VkOffset3D, #CmdCopyImage()
        """

    VkImageSubresourceLayers("srcSubresource", "{@code srcSubresource} and {@code dstSubresource} are ##VkImageSubresourceLayers structures specifying the image subresources of the images used for the source and destination image data, respectively.")
    VkOffset3D("srcOffset", "{@code srcOffset} and {@code dstOffset} select the initial {@code x}, {@code y}, and {@code z} offsets in texels of the sub-regions of the source and destination image data.")
    VkImageSubresourceLayers("dstSubresource", "see {@code srcSubresource}")
    VkOffset3D("dstOffset", "see {@code srcOffset}")
    VkExtent3D("extent", "the size in texels of the image to copy in {@code width}, {@code height} and {@code depth}.")
}

val VkImageResolve = struct(Module.VULKAN, "VkImageResolve") {
    documentation =
        """
        Structure specifying an image resolve operation.

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code aspectMask} member of {@code srcSubresource} and {@code dstSubresource} <b>must</b> only contain #IMAGE_ASPECT_COLOR_BIT</li>
            <li>If neither of the {@code layerCount} members of {@code srcSubresource} or {@code dstSubresource} are #REMAINING_ARRAY_LAYERS, the {@code layerCount} member of {@code srcSubresource} and {@code dstSubresource} <b>must</b> match</li>
            <li>If one of the {@code layerCount} members of {@code srcSubresource} or {@code dstSubresource} is #REMAINING_ARRAY_LAYERS, the other member <b>must</b> be either #REMAINING_ARRAY_LAYERS or equal to the {@code arrayLayers} member of the ##VkImageCreateInfo used to create the image minus {@code baseArrayLayer}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code srcSubresource} <b>must</b> be a valid ##VkImageSubresourceLayers structure</li>
            <li>{@code dstSubresource} <b>must</b> be a valid ##VkImageSubresourceLayers structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent3D, ##VkImageSubresourceLayers, ##VkOffset3D, #CmdResolveImage()
        """

    VkImageSubresourceLayers("srcSubresource", "{@code srcSubresource} and {@code dstSubresource} are ##VkImageSubresourceLayers structures specifying the image subresources of the images used for the source and destination image data, respectively. Resolve of depth/stencil images is not supported.")
    VkOffset3D("srcOffset", "{@code srcOffset} and {@code dstOffset} select the initial {@code x}, {@code y}, and {@code z} offsets in texels of the sub-regions of the source and destination image data.")
    VkImageSubresourceLayers("dstSubresource", "see {@code srcSubresource}")
    VkOffset3D("dstOffset", "see {@code srcOffset}")
    VkExtent3D("extent", "the size in texels of the source image to resolve in {@code width}, {@code height} and {@code depth}.")
}

val VkRenderPassBeginInfo = struct(Module.VULKAN, "VkRenderPassBeginInfo") {
    documentation =
        """
        Structure specifying render pass begin information.

        <h5>Description</h5>
        {@code renderArea} is the render area that is affected by the render pass instance. The effects of attachment load, store and multisample resolve operations are restricted to the pixels whose x and y coordinates fall within the render area on all attachments. The render area extends to all layers of {@code framebuffer}. The application <b>must</b> ensure (using scissor if necessary) that all rendering is contained within the render area. The render area, after any transform specified by ##VkRenderPassTransformBeginInfoQCOM{@code ::transform} is applied, <b>must</b> be contained within the framebuffer dimensions.

        If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#vertexpostproc-renderpass-transform">render pass transform</a> is enabled, then {@code renderArea} <b>must</b> equal the framebuffer pre-transformed dimensions. After {@code renderArea} has been transformed by ##VkRenderPassTransformBeginInfoQCOM{@code ::transform}, the resulting render area <b>must</b> be equal to the framebuffer dimensions.

        If multiview is enabled in {@code renderPass}, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiviewPerViewRenderAreas">{@code multiviewPerViewRenderAreas}</a> feature is enabled, and there is an instance of ##VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM included in the {@code pNext} chain with {@code perViewRenderAreaCount} not equal to 0, then the elements of ##VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM{@code ::pPerViewRenderAreas} override {@code renderArea} and define a render area for each view. In this case, {@code renderArea} <b>must</b> be an area at least as large as the union of all the per-view render areas.

        If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-subpassShading">{@code subpassShading}</a> feature is enabled, then {@code renderArea} <b>must</b> equal the framebuffer dimensions.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        There <b>may</b> be a performance cost for using a render area smaller than the framebuffer, unless it matches the render area granularity for the render pass.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code clearValueCount} <b>must</b> be greater than the largest attachment index in {@code renderPass} specifying a {@code loadOp} (or {@code stencilLoadOp}, if the attachment has a depth/stencil format) of #ATTACHMENT_LOAD_OP_CLEAR</li>
            <li>If {@code clearValueCount} is not 0, {@code pClearValues} <b>must</b> be a valid pointer to an array of {@code clearValueCount} ##VkClearValue unions</li>
            <li>{@code renderPass} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#renderpass-compatibility">compatible</a> with the {@code renderPass} member of the ##VkFramebufferCreateInfo structure specified when creating {@code framebuffer}</li>
            <li>If the {@code pNext} chain does not contain ##VkDeviceGroupRenderPassBeginInfo or its {@code deviceRenderAreaCount} member is equal to 0, {@code renderArea.extent.width} <b>must</b> be greater than 0</li>
            <li>If the {@code pNext} chain does not contain ##VkDeviceGroupRenderPassBeginInfo or its {@code deviceRenderAreaCount} member is equal to 0, {@code renderArea.extent.height} <b>must</b> be greater than 0</li>
            <li>If the {@code pNext} chain does not contain ##VkDeviceGroupRenderPassBeginInfo or its {@code deviceRenderAreaCount} member is equal to 0, {@code renderArea.offset.x} <b>must</b> be greater than or equal to 0</li>
            <li>If the {@code pNext} chain does not contain ##VkDeviceGroupRenderPassBeginInfo or its {@code deviceRenderAreaCount} member is equal to 0, {@code renderArea.offset.y} <b>must</b> be greater than or equal to 0</li>
            <li>If the {@code pNext} chain does not contain ##VkDeviceGroupRenderPassBeginInfo or its {@code deviceRenderAreaCount} member is equal to 0, <code>renderArea.offset.x + renderArea.extent.width</code> <b>must</b> be less than or equal to ##VkFramebufferCreateInfo{@code ::width} the {@code framebuffer} was created with</li>
            <li>If the {@code pNext} chain does not contain ##VkDeviceGroupRenderPassBeginInfo or its {@code deviceRenderAreaCount} member is equal to 0, <code>renderArea.offset.y + renderArea.extent.height</code> <b>must</b> be less than or equal to ##VkFramebufferCreateInfo{@code ::height} the {@code framebuffer} was created with</li>
            <li>If the {@code pNext} chain contains ##VkDeviceGroupRenderPassBeginInfo, <code>offset.x + extent.width</code> of each element of {@code pDeviceRenderAreas} <b>must</b> be less than or equal to ##VkFramebufferCreateInfo{@code ::width} the {@code framebuffer} was created with</li>
            <li>If the {@code pNext} chain contains ##VkDeviceGroupRenderPassBeginInfo, <code>offset.y + extent.height</code> of each element of {@code pDeviceRenderAreas} <b>must</b> be less than or equal to ##VkFramebufferCreateInfo{@code ::height} the {@code framebuffer} was created with</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that did not include #FRAMEBUFFER_CREATE_IMAGELESS_BIT, and the {@code pNext} chain includes a ##VkRenderPassAttachmentBeginInfo structure, its {@code attachmentCount} <b>must</b> be zero</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, the {@code attachmentCount} of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be equal to the value of ##VkFramebufferAttachmentsCreateInfo{@code ::attachmentImageInfoCount} used to create {@code framebuffer}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> have been created on the same {@code VkDevice} as {@code framebuffer} and {@code renderPass}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} of an image created with a value of ##VkImageCreateInfo{@code ::flags} equal to the {@code flags} member of the corresponding element of ##VkFramebufferAttachmentsCreateInfo{@code ::pAttachmentImageInfos} used to create {@code framebuffer}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-inherited-usage">an inherited usage</a> equal to the {@code usage} member of the corresponding element of ##VkFramebufferAttachmentsCreateInfo{@code ::pAttachmentImageInfos} used to create {@code framebuffer}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} with a width equal to the {@code width} member of the corresponding element of ##VkFramebufferAttachmentsCreateInfo{@code ::pAttachmentImageInfos} used to create {@code framebuffer}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} with a height equal to the {@code height} member of the corresponding element of ##VkFramebufferAttachmentsCreateInfo{@code ::pAttachmentImageInfos} used to create {@code framebuffer}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} of an image created with a value of ##VkImageViewCreateInfo{@code ::subresourceRange.layerCount} equal to the {@code layerCount} member of the corresponding element of ##VkFramebufferAttachmentsCreateInfo{@code ::pAttachmentImageInfos} used to create {@code framebuffer}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} of an image created with a value of ##VkImageFormatListCreateInfo{@code ::viewFormatCount} equal to the {@code viewFormatCount} member of the corresponding element of ##VkFramebufferAttachmentsCreateInfo{@code ::pAttachmentImageInfos} used to create {@code framebuffer}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} of an image created with a set of elements in ##VkImageFormatListCreateInfo{@code ::pViewFormats} equal to the set of elements in the {@code pViewFormats} member of the corresponding element of ##VkFramebufferAttachmentsCreateInfo{@code ::pAttachmentImageInfos} used to create {@code framebuffer}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} of an image created with a value of ##VkImageViewCreateInfo{@code ::format} equal to the corresponding value of ##VkAttachmentDescription{@code ::format} in {@code renderPass}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-nullColorAttachmentWithExternalFormatResolve">{@code nullColorAttachmentWithExternalFormatResolve}</a> is #FALSE, the format of the color attachment for each subpass that includes an external format image as a resolve attachment <b>must</b> have a format equal to the value of ##VkAndroidHardwareBufferFormatResolvePropertiesANDROID{@code ::colorAttachmentFormat} as returned by a call to #GetAndroidHardwareBufferPropertiesANDROID() for the Android hardware buffer that was used to create the image view use as its resolve attachment</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} of an image created with a value of ##VkExternalFormatANDROID{@code ::externalFormat} equal to ##VkExternalFormatANDROID{@code ::externalFormat} in the {@code pNext} chain of the corresponding ##VkAttachmentDescription2 structure used to create {@code renderPass}</li>
            <li>If {@code framebuffer} was created with a ##VkFramebufferCreateInfo{@code ::flags} value that included #FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the {@code pAttachments} member of a ##VkRenderPassAttachmentBeginInfo structure included in the {@code pNext} chain <b>must</b> be a {@code VkImageView} of an image created with a value of ##VkImageCreateInfo{@code ::samples} equal to the corresponding value of ##VkAttachmentDescription{@code ::samples} in {@code renderPass} , or #SAMPLE_COUNT_1_BIT if {@code renderPass} was created with ##VkMultisampledRenderToSingleSampledInfoEXT structure in the {@code pNext} chain with {@code multisampledRenderToSingleSampledEnable} equal to #TRUE</li>
            <li>If the {@code pNext} chain includes ##VkRenderPassTransformBeginInfoQCOM, {@code renderArea.offset} <b>must</b> equal <code>(0,0)</code></li>
            <li>If the {@code pNext} chain includes ##VkRenderPassTransformBeginInfoQCOM, {@code renderArea.extent} transformed by ##VkRenderPassTransformBeginInfoQCOM{@code ::transform} <b>must</b> equal the {@code framebuffer} dimensions</li>
            <li>If the {@code perViewRenderAreaCount} member of a ##VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM structure included in the {@code pNext} chain is not 0, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiviewPerViewRenderAreas">{@code multiviewPerViewRenderAreas}</a> feature <b>must</b> be enabled</li>
            <li>If the {@code perViewRenderAreaCount} member of a ##VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM structure included in the {@code pNext} chain is not 0, then {@code renderArea} <b>must</b> specify a render area that includes the union of all per view render areas</li>
            <li>If the {@code pNext} chain contains a ##VkRenderPassStripeBeginInfoARM structure, the union of stripe areas defined by the elements of ##VkRenderPassStripeInfoARM{@code ::pStripeInfos} <b>must</b> cover the {@code renderArea}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDeviceGroupRenderPassBeginInfo, ##VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM, ##VkRenderPassAttachmentBeginInfo, ##VkRenderPassSampleLocationsBeginInfoEXT, ##VkRenderPassStripeBeginInfoARM, or ##VkRenderPassTransformBeginInfoQCOM</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code renderPass} <b>must</b> be a valid {@code VkRenderPass} handle</li>
            <li>{@code framebuffer} <b>must</b> be a valid {@code VkFramebuffer} handle</li>
            <li>Both of {@code framebuffer}, and {@code renderPass} <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkClearValue, ##VkRect2D, #CmdBeginRenderPass(), #CmdBeginRenderPass2(), #CmdBeginRenderPass2KHR()
        """

    Expression("#STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDeviceGroupRenderPassBeginInfo", "VkDeviceGroupRenderPassBeginInfoKHR", "VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM", "VkRenderPassAttachmentBeginInfo", "VkRenderPassAttachmentBeginInfoKHR", "VkRenderPassSampleLocationsBeginInfoEXT", "VkRenderPassStripeBeginInfoARM", "VkRenderPassTransformBeginInfoQCOM",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkRenderPass("renderPass", "the render pass to begin an instance of.")
    VkFramebuffer("framebuffer", "the framebuffer containing the attachments that are used with the render pass.")
    VkRect2D("renderArea", "the render area that is affected by the render pass instance, and is described in more detail below.")
    AutoSize("pClearValues", optional = true)..uint32_t("clearValueCount", "the number of elements in {@code pClearValues}.")
    nullable..VkClearValue.const.p("pClearValues", "a pointer to an array of {@code clearValueCount} ##VkClearValue structures containing clear values for each attachment, if the attachment uses a {@code loadOp} value of #ATTACHMENT_LOAD_OP_CLEAR or if the attachment has a depth/stencil format and uses a {@code stencilLoadOp} value of #ATTACHMENT_LOAD_OP_CLEAR. The array is indexed by attachment number. Only elements corresponding to cleared attachments are used. Other elements of {@code pClearValues} are ignored.")
}

val VkPhysicalDeviceSubgroupProperties = struct(Module.VULKAN, "VkPhysicalDeviceSubgroupProperties", mutable = false) {
    documentation =
        """
        Structure describing subgroup support for an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceSubgroupProperties structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        If {@code supportedOperations} includes <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-subgroup-quad">#SUBGROUP_FEATURE_QUAD_BIT</a>, or the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderSubgroupUniformControlFlow">{@code shaderSubgroupUniformControlFlow}</a> feature is enabled, {@code subgroupSize} <b>must</b> be greater than or equal to 4.

        If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderQuadControl">{@code shaderQuadControl}</a> feature is supported, {@code supportedOperations} <b>must</b> include <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-subgroup-quad">#SUBGROUP_FEATURE_QUAD_BIT</a>.

        If {@link KHRShaderSubgroupRotate VK_KHR_shader_subgroup_rotate} is supported, and the implementation advertises support with a ##VkExtensionProperties{@code ::specVersion} greater than or equal to 2, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderSubgroupRotate">{@code shaderSubgroupRotate}</a> feature is supported, #SUBGROUP_FEATURE_ROTATE_BIT <b>must</b> be returned in ##VkPhysicalDeviceVulkan11Properties{@code ::subgroupSupportedOperations} and ##VkPhysicalDeviceSubgroupProperties{@code ::supportedOperations}. If {@link KHRShaderSubgroupRotate VK_KHR_shader_subgroup_rotate} is supported, and the implementation advertises support with a ##VkExtensionProperties{@code ::specVersion} greater than or equal to 2, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderSubgroupRotateClustered">{@code shaderSubgroupRotateClustered}</a> feature is supported, #SUBGROUP_FEATURE_ROTATE_CLUSTERED_BIT <b>must</b> be returned in ##VkPhysicalDeviceVulkan11Properties{@code ::subgroupSupportedOperations} and ##VkPhysicalDeviceSubgroupProperties{@code ::supportedOperations}.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        #SUBGROUP_FEATURE_ROTATE_BIT and #SUBGROUP_FEATURE_ROTATE_CLUSTERED_BIT were added in version 2 of the {@link KHRShaderSubgroupRotate VK_KHR_shader_subgroup_rotate} extension, after the initial release, so there are implementations that do not advertise these bits. Applications should use the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderSubgroupRotate">{@code shaderSubgroupRotate}</a> and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderSubgroupRotateClustered">{@code shaderSubgroupRotateClustered}</a> features to determine and enable support. These bits are advertised here for consistency and for future dependencies.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("subgroupSize", "the default number of invocations in each subgroup. {@code subgroupSize} is at least 1 if any of the physical device’s queues support #QUEUE_GRAPHICS_BIT or #QUEUE_COMPUTE_BIT. {@code subgroupSize} is a power-of-two.")
    VkShaderStageFlags("supportedStages", "a bitfield of {@code VkShaderStageFlagBits} describing the shader stages that <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#shaders-group-operations\">group operations</a> with <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#shaders-scope-subgroup\">subgroup scope</a> are supported in. {@code supportedStages} will have the #SHADER_STAGE_COMPUTE_BIT bit set if any of the physical device’s queues support #QUEUE_COMPUTE_BIT.")
    VkSubgroupFeatureFlags("supportedOperations", "a bitmask of {@code VkSubgroupFeatureFlagBits} specifying the sets of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#shaders-group-operations\">group operations</a> with <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#shaders-scope-subgroup\">subgroup scope</a> supported on this device. {@code supportedOperations} will have the #SUBGROUP_FEATURE_BASIC_BIT bit set if any of the physical device’s queues support #QUEUE_GRAPHICS_BIT or #QUEUE_COMPUTE_BIT.")
    VkBool32("quadOperationsInAllStages", "a boolean specifying whether <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#shaders-quad-operations\">quad group operations</a> are available in all stages, or are restricted to fragment and compute stages.")
}

val VkBindBufferMemoryInfo = struct(Module.VULKAN, "VkBindBufferMemoryInfo") {
    documentation =
        """
        Structure specifying how to bind a buffer to memory.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code buffer} <b>must</b> not have been bound to a memory object</li>
            <li>{@code buffer} <b>must</b> not have been created with any sparse memory binding flags</li>
            <li>{@code memoryOffset} <b>must</b> be less than the size of {@code memory}</li>
            <li>{@code memory} <b>must</b> have been allocated using one of the memory types allowed in the {@code memoryTypeBits} member of the ##VkMemoryRequirements structure returned from a call to {@code vkGetBufferMemoryRequirements} with {@code buffer}</li>
            <li>{@code memoryOffset} <b>must</b> be an integer multiple of the {@code alignment} member of the ##VkMemoryRequirements structure returned from a call to {@code vkGetBufferMemoryRequirements} with {@code buffer}</li>
            <li>The {@code size} member of the ##VkMemoryRequirements structure returned from a call to {@code vkGetBufferMemoryRequirements} with {@code buffer} <b>must</b> be less than or equal to the size of {@code memory} minus {@code memoryOffset}</li>
            <li>If {@code buffer} requires a dedicated allocation (as reported by #GetBufferMemoryRequirements2() in ##VkMemoryDedicatedRequirements{@code ::requiresDedicatedAllocation} for {@code buffer}), {@code memory} <b>must</b> have been allocated with ##VkMemoryDedicatedAllocateInfo{@code ::buffer} equal to {@code buffer}</li>
            <li>If the ##VkMemoryAllocateInfo provided when {@code memory} was allocated included a ##VkMemoryDedicatedAllocateInfo structure in its {@code pNext} chain, and ##VkMemoryDedicatedAllocateInfo{@code ::buffer} was not #NULL_HANDLE, then {@code buffer} <b>must</b> equal ##VkMemoryDedicatedAllocateInfo{@code ::buffer}, and {@code memoryOffset} <b>must</b> be zero</li>
            <li>If {@code buffer} was created with the #BUFFER_CREATE_PROTECTED_BIT bit set, the buffer <b>must</b> be bound to a memory object allocated with a memory type that reports #MEMORY_PROPERTY_PROTECTED_BIT</li>
            <li>If {@code buffer} was created with the #BUFFER_CREATE_PROTECTED_BIT bit not set, the buffer <b>must</b> not be bound to a memory object allocated with a memory type that reports #MEMORY_PROPERTY_PROTECTED_BIT</li>
            <li>If {@code buffer} was created with ##VkDedicatedAllocationBufferCreateInfoNV{@code ::dedicatedAllocation} equal to #TRUE, {@code memory} <b>must</b> have been allocated with ##VkDedicatedAllocationMemoryAllocateInfoNV{@code ::buffer} equal to a buffer handle created with identical creation parameters to {@code buffer} and {@code memoryOffset} <b>must</b> be zero</li>
            <li>If the {@link KHRDedicatedAllocation VK_KHR_dedicated_allocation} extension is not enabled, ##VkPhysicalDeviceProperties{@code ::apiVersion} is less than Vulkan 1.1, and {@code buffer} was not created with ##VkDedicatedAllocationBufferCreateInfoNV{@code ::dedicatedAllocation} equal to #TRUE, {@code memory} <b>must</b> not have been allocated dedicated for a specific buffer or image</li>
            <li>If the value of ##VkExportMemoryAllocateInfo{@code ::handleTypes} used to allocate {@code memory} is not 0, it <b>must</b> include at least one of the handles set in ##VkExternalMemoryBufferCreateInfo{@code ::handleTypes} when {@code buffer} was created</li>
            <li>If {@code memory} was allocated by a memory import operation, that is not ##VkImportAndroidHardwareBufferInfoANDROID with a non-{@code NULL} {@code buffer} value, the external handle type of the imported memory <b>must</b> also have been set in ##VkExternalMemoryBufferCreateInfo{@code ::handleTypes} when {@code buffer} was created</li>
            <li>If {@code memory} was allocated with the ##VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-{@code NULL} {@code buffer} value, #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID <b>must</b> also have been set in ##VkExternalMemoryBufferCreateInfo{@code ::handleTypes} when {@code buffer} was created</li>
            <li>If the ##VkPhysicalDeviceBufferDeviceAddressFeatures{@code ::bufferDeviceAddress} feature is enabled and {@code buffer} was created with the #BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT bit set, {@code memory} <b>must</b> have been allocated with the #MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set</li>
            <li>If the ##VkPhysicalDeviceBufferDeviceAddressFeatures{@code ::bufferDeviceAddressCaptureReplay} feature is enabled and {@code buffer} was created with the #BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set, {@code memory} <b>must</b> have been allocated with the #MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set</li>
            <li>If the {@code buffer} was created with the #BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, {@code memory} <b>must</b> have been allocated with the #MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set</li>
            <li>If the {@code buffer} was created with the #BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, {@code memory} <b>must</b> have been allocated with the #MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set</li>
            <li>If the {@code pNext} chain includes a ##VkBindBufferMemoryDeviceGroupInfo structure, all instances of {@code memory} specified by ##VkBindBufferMemoryDeviceGroupInfo{@code ::pDeviceIndices} <b>must</b> have been allocated</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkBindBufferMemoryDeviceGroupInfo or ##VkBindMemoryStatus</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
            <li>Both of {@code buffer}, and {@code memory} <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #BindBufferMemory2(), #BindBufferMemory2KHR()
        """

    Expression("#STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkBindBufferMemoryDeviceGroupInfo", "VkBindBufferMemoryDeviceGroupInfoKHR", "VkBindMemoryStatus", "VkBindMemoryStatusKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBuffer("buffer", "the buffer to be attached to memory.")
    VkDeviceMemory("memory", "a {@code VkDeviceMemory} object describing the device memory to attach.")
    VkDeviceSize("memoryOffset", "the start offset of the region of {@code memory} which is to be bound to the buffer. The number of bytes returned in the ##VkMemoryRequirements{@code ::size} member in {@code memory}, starting from {@code memoryOffset} bytes, will be bound to the specified buffer.")
}

val VkBindImageMemoryInfo = struct(Module.VULKAN, "VkBindImageMemoryInfo") {
    documentation =
        """
        Structure specifying how to bind an image to memory.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code image} <b>must</b> not have been bound to a memory object</li>
            <li>{@code image} <b>must</b> not have been created with any sparse memory binding flags</li>
            <li>{@code memoryOffset} <b>must</b> be less than the size of {@code memory}</li>
            <li>If {@code image} requires a dedicated allocation (as reported by #GetImageMemoryRequirements2() in ##VkMemoryDedicatedRequirements{@code ::requiresDedicatedAllocation} for {@code image}), {@code memory} <b>must</b> have been created with ##VkMemoryDedicatedAllocateInfo{@code ::image} equal to {@code image}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dedicatedAllocationImageAliasing">{@code dedicatedAllocationImageAliasing}</a> feature is not enabled, and the ##VkMemoryAllocateInfo provided when {@code memory} was allocated included a ##VkMemoryDedicatedAllocateInfo structure in its {@code pNext} chain, and ##VkMemoryDedicatedAllocateInfo{@code ::image} was not #NULL_HANDLE, then {@code image} <b>must</b> equal ##VkMemoryDedicatedAllocateInfo{@code ::image} and {@code memoryOffset} <b>must</b> be zero</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-dedicatedAllocationImageAliasing">{@code dedicatedAllocationImageAliasing}</a> feature is enabled, and the ##VkMemoryAllocateInfo provided when {@code memory} was allocated included a ##VkMemoryDedicatedAllocateInfo structure in its {@code pNext} chain, and ##VkMemoryDedicatedAllocateInfo{@code ::image} was not #NULL_HANDLE, then {@code memoryOffset} <b>must</b> be zero, and {@code image} <b>must</b> be either equal to ##VkMemoryDedicatedAllocateInfo{@code ::image} or an image that was created using the same parameters in ##VkImageCreateInfo, with the exception that {@code extent} and {@code arrayLayers} <b>may</b> differ subject to the following restrictions: every dimension in the {@code extent} parameter of the image being bound <b>must</b> be equal to or smaller than the original image for which the allocation was created; and the {@code arrayLayers} parameter of the image being bound <b>must</b> be equal to or smaller than the original image for which the allocation was created</li>
            <li>If image was created with the #IMAGE_CREATE_PROTECTED_BIT bit set, the image <b>must</b> be bound to a memory object allocated with a memory type that reports #MEMORY_PROPERTY_PROTECTED_BIT</li>
            <li>If image was created with the #IMAGE_CREATE_PROTECTED_BIT bit not set, the image <b>must</b> not be bound to a memory object created with a memory type that reports #MEMORY_PROPERTY_PROTECTED_BIT</li>
            <li>If {@code image} was created with ##VkDedicatedAllocationImageCreateInfoNV{@code ::dedicatedAllocation} equal to #TRUE, {@code memory} <b>must</b> have been created with ##VkDedicatedAllocationMemoryAllocateInfoNV{@code ::image} equal to an image handle created with identical creation parameters to {@code image} and {@code memoryOffset} <b>must</b> be zero</li>
            <li>If the {@link KHRDedicatedAllocation VK_KHR_dedicated_allocation} extension is not enabled, ##VkPhysicalDeviceProperties{@code ::apiVersion} is less than Vulkan 1.1, and {@code image} was not created with ##VkDedicatedAllocationImageCreateInfoNV{@code ::dedicatedAllocation} equal to #TRUE, {@code memory} <b>must</b> not have been allocated dedicated for a specific buffer or image</li>
            <li>If the value of ##VkExportMemoryAllocateInfo{@code ::handleTypes} used to allocate {@code memory} is not 0, it <b>must</b> include at least one of the handles set in ##VkExternalMemoryImageCreateInfo{@code ::handleTypes} when {@code image} was created</li>
            <li>If {@code memory} was created by a memory import operation, that is not ##VkImportAndroidHardwareBufferInfoANDROID with a non-{@code NULL} {@code buffer} value, the external handle type of the imported memory <b>must</b> also have been set in ##VkExternalMemoryImageCreateInfo{@code ::handleTypes} when {@code image} was created</li>
            <li>If {@code memory} was created with the ##VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-{@code NULL} {@code buffer} value, #EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_AND