/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package vulkan

import org.lwjgl.generator.*
import core.linux.*
import core.macos.*
import core.windows.*

// Handle types
val VkSurfaceKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkSurfaceKHR")
val VkSwapchainKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkSwapchainKHR")
val VkDisplayKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDisplayKHR")
val VkDisplayModeKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDisplayModeKHR")
val VkDebugReportCallbackEXT = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDebugReportCallbackEXT")
val VkVideoSessionKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkVideoSessionKHR")
val VkVideoSessionParametersKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkVideoSessionParametersKHR")
val VkCuModuleNVX = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkCuModuleNVX")
val VkCuFunctionNVX = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkCuFunctionNVX")
val VkDescriptorUpdateTemplateKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDescriptorUpdateTemplateKHR")
val VkDebugUtilsMessengerEXT = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDebugUtilsMessengerEXT")
val VkAccelerationStructureKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkAccelerationStructureKHR")
val VkDeferredOperationKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkDeferredOperationKHR")
val VkSamplerYcbcrConversionKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkSamplerYcbcrConversionKHR")
val VkValidationCacheEXT = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkValidationCacheEXT")
val VkAccelerationStructureNV = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkAccelerationStructureNV")
val VkPerformanceConfigurationINTEL = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkPerformanceConfigurationINTEL")
val VkIndirectCommandsLayoutNV = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkIndirectCommandsLayoutNV")
val VkPrivateDataSlotEXT = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkPrivateDataSlotEXT")
val VkCudaModuleNV = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkCudaModuleNV")
val VkCudaFunctionNV = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkCudaFunctionNV")
val VkMicromapEXT = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkMicromapEXT")
val VkOpticalFlowSessionNV = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkOpticalFlowSessionNV")
val VkShaderEXT = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkShaderEXT")
val VkPipelineBinaryKHR = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkPipelineBinaryKHR")
val VkIndirectExecutionSetEXT = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkIndirectExecutionSetEXT")
val VkIndirectCommandsLayoutEXT = VK_DEFINE_NON_DISPATCHABLE_HANDLE("VkIndirectCommandsLayoutEXT")

// Enum types
val VkSurfaceTransformFlagBitsKHR = "VkSurfaceTransformFlagBitsKHR".enumType
val VkPresentModeKHR = "VkPresentModeKHR".enumType
val VkColorSpaceKHR = "VkColorSpaceKHR".enumType
val VkCompositeAlphaFlagBitsKHR = "VkCompositeAlphaFlagBitsKHR".enumType
val VkSwapchainCreateFlagBitsKHR = "VkSwapchainCreateFlagBitsKHR".enumType
val VkDeviceGroupPresentModeFlagBitsKHR = "VkDeviceGroupPresentModeFlagBitsKHR".enumType
val VkDisplayPlaneAlphaFlagBitsKHR = "VkDisplayPlaneAlphaFlagBitsKHR".enumType
val VkDebugReportObjectTypeEXT = "VkDebugReportObjectTypeEXT".enumType
val VkDebugReportFlagBitsEXT = "VkDebugReportFlagBitsEXT".enumType
val VkRasterizationOrderAMD = "VkRasterizationOrderAMD".enumType
val VkVideoCodecOperationFlagBitsKHR = "VkVideoCodecOperationFlagBitsKHR".enumType
val VkVideoChromaSubsamplingFlagBitsKHR = "VkVideoChromaSubsamplingFlagBitsKHR".enumType
val VkVideoComponentBitDepthFlagBitsKHR = "VkVideoComponentBitDepthFlagBitsKHR".enumType
val VkVideoCapabilityFlagBitsKHR = "VkVideoCapabilityFlagBitsKHR".enumType
val VkVideoSessionCreateFlagBitsKHR = "VkVideoSessionCreateFlagBitsKHR".enumType
val VkVideoCodingControlFlagBitsKHR = "VkVideoCodingControlFlagBitsKHR".enumType
val VkQueryResultStatusKHR = "VkQueryResultStatusKHR".enumType
val VkVideoDecodeCapabilityFlagBitsKHR = "VkVideoDecodeCapabilityFlagBitsKHR".enumType
val VkVideoDecodeUsageFlagBitsKHR = "VkVideoDecodeUsageFlagBitsKHR".enumType
val VkVideoEncodeH264CapabilityFlagBitsKHR = "VkVideoEncodeH264CapabilityFlagBitsKHR".enumType
val VkVideoEncodeH264StdFlagBitsKHR = "VkVideoEncodeH264StdFlagBitsKHR".enumType
val VkVideoEncodeH264RateControlFlagBitsKHR = "VkVideoEncodeH264RateControlFlagBitsKHR".enumType
val VkVideoEncodeH265CapabilityFlagBitsKHR = "VkVideoEncodeH265CapabilityFlagBitsKHR".enumType
val VkVideoEncodeH265StdFlagBitsKHR = "VkVideoEncodeH265StdFlagBitsKHR".enumType
val VkVideoEncodeH265CtbSizeFlagBitsKHR = "VkVideoEncodeH265CtbSizeFlagBitsKHR".enumType
val VkVideoEncodeH265TransformBlockSizeFlagBitsKHR = "VkVideoEncodeH265TransformBlockSizeFlagBitsKHR".enumType
val VkVideoEncodeH265RateControlFlagBitsKHR = "VkVideoEncodeH265RateControlFlagBitsKHR".enumType
val VkVideoDecodeH264PictureLayoutFlagBitsKHR = "VkVideoDecodeH264PictureLayoutFlagBitsKHR".enumType
val VkShaderInfoTypeAMD = "VkShaderInfoTypeAMD".enumType
val VkRenderingFlagBitsKHR = "VkRenderingFlagBitsKHR".enumType
val VkExternalMemoryHandleTypeFlagBitsNV = "VkExternalMemoryHandleTypeFlagBitsNV".enumType
val VkExternalMemoryFeatureFlagBitsNV = "VkExternalMemoryFeatureFlagBitsNV".enumType
val VkPeerMemoryFeatureFlagBitsKHR = "VkPeerMemoryFeatureFlagBitsKHR".enumType
val VkMemoryAllocateFlagBitsKHR = "VkMemoryAllocateFlagBitsKHR".enumType
val VkValidationCheckEXT = "VkValidationCheckEXT".enumType
val VkPipelineRobustnessBufferBehaviorEXT = "VkPipelineRobustnessBufferBehaviorEXT".enumType
val VkPipelineRobustnessImageBehaviorEXT = "VkPipelineRobustnessImageBehaviorEXT".enumType
val VkExternalMemoryHandleTypeFlagBitsKHR = "VkExternalMemoryHandleTypeFlagBitsKHR".enumType
val VkExternalMemoryFeatureFlagBitsKHR = "VkExternalMemoryFeatureFlagBitsKHR".enumType
val VkExternalSemaphoreHandleTypeFlagBitsKHR = "VkExternalSemaphoreHandleTypeFlagBitsKHR".enumType
val VkExternalSemaphoreFeatureFlagBitsKHR = "VkExternalSemaphoreFeatureFlagBitsKHR".enumType
val VkSemaphoreImportFlagBitsKHR = "VkSemaphoreImportFlagBitsKHR".enumType
val VkConditionalRenderingFlagBitsEXT = "VkConditionalRenderingFlagBitsEXT".enumType
val VkDescriptorUpdateTemplateTypeKHR = "VkDescriptorUpdateTemplateTypeKHR".enumType
val VkSurfaceCounterFlagBitsEXT = "VkSurfaceCounterFlagBitsEXT".enumType
val VkDisplayPowerStateEXT = "VkDisplayPowerStateEXT".enumType
val VkDeviceEventTypeEXT = "VkDeviceEventTypeEXT".enumType
val VkDisplayEventTypeEXT = "VkDisplayEventTypeEXT".enumType
val VkViewportCoordinateSwizzleNV = "VkViewportCoordinateSwizzleNV".enumType
val VkDiscardRectangleModeEXT = "VkDiscardRectangleModeEXT".enumType
val VkConservativeRasterizationModeEXT = "VkConservativeRasterizationModeEXT".enumType
val VkExternalFenceHandleTypeFlagBitsKHR = "VkExternalFenceHandleTypeFlagBitsKHR".enumType
val VkExternalFenceFeatureFlagBitsKHR = "VkExternalFenceFeatureFlagBitsKHR".enumType
val VkFenceImportFlagBitsKHR = "VkFenceImportFlagBitsKHR".enumType
val VkPerformanceCounterUnitKHR = "VkPerformanceCounterUnitKHR".enumType
val VkPerformanceCounterScopeKHR = "VkPerformanceCounterScopeKHR".enumType
val VkPerformanceCounterStorageKHR = "VkPerformanceCounterStorageKHR".enumType
val VkPerformanceCounterDescriptionFlagBitsKHR = "VkPerformanceCounterDescriptionFlagBitsKHR".enumType
val VkAcquireProfilingLockFlagBitsKHR = "VkAcquireProfilingLockFlagBitsKHR".enumType
val VkPointClippingBehaviorKHR = "VkPointClippingBehaviorKHR".enumType
val VkTessellationDomainOriginKHR = "VkTessellationDomainOriginKHR".enumType
val VkDebugUtilsMessageSeverityFlagBitsEXT = "VkDebugUtilsMessageSeverityFlagBitsEXT".enumType
val VkDebugUtilsMessageTypeFlagBitsEXT = "VkDebugUtilsMessageTypeFlagBitsEXT".enumType
val VkSamplerReductionModeEXT = "VkSamplerReductionModeEXT".enumType
val VkBlendOverlapEXT = "VkBlendOverlapEXT".enumType
val VkAccelerationStructureTypeKHR = "VkAccelerationStructureTypeKHR".enumType
val VkBuildAccelerationStructureModeKHR = "VkBuildAccelerationStructureModeKHR".enumType
val VkGeometryTypeKHR = "VkGeometryTypeKHR".enumType
val VkAccelerationStructureBuildTypeKHR = "VkAccelerationStructureBuildTypeKHR".enumType
val VkGeometryFlagBitsKHR = "VkGeometryFlagBitsKHR".enumType
val VkGeometryInstanceFlagBitsKHR = "VkGeometryInstanceFlagBitsKHR".enumType
val VkBuildAccelerationStructureFlagBitsKHR = "VkBuildAccelerationStructureFlagBitsKHR".enumType
val VkCopyAccelerationStructureModeKHR = "VkCopyAccelerationStructureModeKHR".enumType
val VkAccelerationStructureCompatibilityKHR = "VkAccelerationStructureCompatibilityKHR".enumType
val VkAccelerationStructureCreateFlagBitsKHR = "VkAccelerationStructureCreateFlagBitsKHR".enumType
val VkRayTracingShaderGroupTypeKHR = "VkRayTracingShaderGroupTypeKHR".enumType
val VkShaderGroupShaderKHR = "VkShaderGroupShaderKHR".enumType
val VkCoverageModulationModeNV = "VkCoverageModulationModeNV".enumType
val VkSamplerYcbcrModelConversionKHR = "VkSamplerYcbcrModelConversionKHR".enumType
val VkSamplerYcbcrRangeKHR = "VkSamplerYcbcrRangeKHR".enumType
val VkChromaLocationKHR = "VkChromaLocationKHR".enumType
val VkValidationCacheHeaderVersionEXT = "VkValidationCacheHeaderVersionEXT".enumType
val VkDescriptorBindingFlagBitsEXT = "VkDescriptorBindingFlagBitsEXT".enumType
val VkShadingRatePaletteEntryNV = "VkShadingRatePaletteEntryNV".enumType
val VkCoarseSampleOrderTypeNV = "VkCoarseSampleOrderTypeNV".enumType
val VkRayTracingShaderGroupTypeNV = "VkRayTracingShaderGroupTypeNV".enumType
val VkGeometryTypeNV = "VkGeometryTypeNV".enumType
val VkAccelerationStructureTypeNV = "VkAccelerationStructureTypeNV".enumType
val VkGeometryFlagBitsNV = "VkGeometryFlagBitsNV".enumType
val VkGeometryInstanceFlagBitsNV = "VkGeometryInstanceFlagBitsNV".enumType
val VkBuildAccelerationStructureFlagBitsNV = "VkBuildAccelerationStructureFlagBitsNV".enumType
val VkCopyAccelerationStructureModeNV = "VkCopyAccelerationStructureModeNV".enumType
val VkAccelerationStructureMemoryRequirementsTypeNV = "VkAccelerationStructureMemoryRequirementsTypeNV".enumType
val VkQueueGlobalPriorityEXT = "VkQueueGlobalPriorityEXT".enumType
val VkPipelineCompilerControlFlagBitsAMD = "VkPipelineCompilerControlFlagBitsAMD".enumType
val VkTimeDomainEXT = "VkTimeDomainEXT".enumType
val VkTimeDomainKHR = "VkTimeDomainKHR".enumType
val VkQueueGlobalPriorityKHR = "VkQueueGlobalPriorityKHR".enumType
val VkMemoryOverallocationBehaviorAMD = "VkMemoryOverallocationBehaviorAMD".enumType
val VkPipelineCreationFeedbackFlagBitsEXT = "VkPipelineCreationFeedbackFlagBitsEXT".enumType
val VkDriverIdKHR = "VkDriverIdKHR".enumType
val VkShaderFloatControlsIndependenceKHR = "VkShaderFloatControlsIndependenceKHR".enumType
val VkResolveModeFlagBitsKHR = "VkResolveModeFlagBitsKHR".enumType
val VkSemaphoreTypeKHR = "VkSemaphoreTypeKHR".enumType
val VkSemaphoreWaitFlagBitsKHR = "VkSemaphoreWaitFlagBitsKHR".enumType
val VkPerformanceConfigurationTypeINTEL = "VkPerformanceConfigurationTypeINTEL".enumType
val VkQueryPoolSamplingModeINTEL = "VkQueryPoolSamplingModeINTEL".enumType
val VkPerformanceOverrideTypeINTEL = "VkPerformanceOverrideTypeINTEL".enumType
val VkPerformanceParameterTypeINTEL = "VkPerformanceParameterTypeINTEL".enumType
val VkPerformanceValueTypeINTEL = "VkPerformanceValueTypeINTEL".enumType
val VkFragmentShadingRateCombinerOpKHR = "VkFragmentShadingRateCombinerOpKHR".enumType
val VkShaderCorePropertiesFlagBitsAMD = "VkShaderCorePropertiesFlagBitsAMD".enumType
val VkToolPurposeFlagBitsEXT = "VkToolPurposeFlagBitsEXT".enumType
val VkValidationFeatureEnableEXT = "VkValidationFeatureEnableEXT".enumType
val VkValidationFeatureDisableEXT = "VkValidationFeatureDisableEXT".enumType
val VkComponentTypeNV = "VkComponentTypeNV".enumType
val VkScopeNV = "VkScopeNV".enumType
val VkCoverageReductionModeNV = "VkCoverageReductionModeNV".enumType
val VkProvokingVertexModeEXT = "VkProvokingVertexModeEXT".enumType
val VkFullScreenExclusiveEXT = "VkFullScreenExclusiveEXT".enumType
val VkLineRasterizationModeEXT = "VkLineRasterizationModeEXT".enumType
val VkPipelineExecutableStatisticFormatKHR = "VkPipelineExecutableStatisticFormatKHR".enumType
val VkHostImageCopyFlagBitsEXT = "VkHostImageCopyFlagBitsEXT".enumType
val VkMemoryUnmapFlagBitsKHR = "VkMemoryUnmapFlagBitsKHR".enumType
val VkPresentScalingFlagBitsEXT = "VkPresentScalingFlagBitsEXT".enumType
val VkPresentGravityFlagBitsEXT = "VkPresentGravityFlagBitsEXT".enumType
val VkIndirectStateFlagBitsNV = "VkIndirectStateFlagBitsNV".enumType
val VkIndirectCommandsTokenTypeNV = "VkIndirectCommandsTokenTypeNV".enumType
val VkIndirectCommandsLayoutUsageFlagBitsNV = "VkIndirectCommandsLayoutUsageFlagBitsNV".enumType
val VkDepthBiasRepresentationEXT = "VkDepthBiasRepresentationEXT".enumType
val VkDeviceMemoryReportEventTypeEXT = "VkDeviceMemoryReportEventTypeEXT".enumType
val VkPipelineCacheCreateFlagBits = "VkPipelineCacheCreateFlagBits".enumType
val VkVideoEncodeCapabilityFlagBitsKHR = "VkVideoEncodeCapabilityFlagBitsKHR".enumType
val VkVideoEncodeFeedbackFlagBitsKHR = "VkVideoEncodeFeedbackFlagBitsKHR".enumType
val VkVideoEncodeUsageFlagBitsKHR = "VkVideoEncodeUsageFlagBitsKHR".enumType
val VkVideoEncodeContentFlagBitsKHR = "VkVideoEncodeContentFlagBitsKHR".enumType
val VkVideoEncodeTuningModeKHR = "VkVideoEncodeTuningModeKHR".enumType
val VkVideoEncodeRateControlModeFlagBitsKHR = "VkVideoEncodeRateControlModeFlagBitsKHR".enumType
val VkDeviceDiagnosticsConfigFlagBitsNV = "VkDeviceDiagnosticsConfigFlagBitsNV".enumType
val VkExportMetalObjectTypeFlagBitsEXT = "VkExportMetalObjectTypeFlagBitsEXT".enumType
val VkPipelineStageFlagBits2KHR = "VkPipelineStageFlagBits2KHR".enumType
val VkAccessFlagBits2KHR = "VkAccessFlagBits2KHR".enumType
val VkSubmitFlagBitsKHR = "VkSubmitFlagBitsKHR".enumType
val VkGraphicsPipelineLibraryFlagBitsEXT = "VkGraphicsPipelineLibraryFlagBitsEXT".enumType
val VkPipelineLayoutCreateFlagBits = "VkPipelineLayoutCreateFlagBits".enumType
val VkFragmentShadingRateTypeNV = "VkFragmentShadingRateTypeNV".enumType
val VkFragmentShadingRateNV = "VkFragmentShadingRateNV".enumType
val VkAccelerationStructureMotionInstanceTypeNV = "VkAccelerationStructureMotionInstanceTypeNV".enumType
val VkImageCompressionFlagBitsEXT = "VkImageCompressionFlagBitsEXT".enumType
val VkImageCompressionFixedRateFlagBitsEXT = "VkImageCompressionFixedRateFlagBitsEXT".enumType
val VkDeviceFaultAddressTypeEXT = "VkDeviceFaultAddressTypeEXT".enumType
val VkDeviceFaultVendorBinaryHeaderVersionEXT = "VkDeviceFaultVendorBinaryHeaderVersionEXT".enumType
val VkDeviceAddressBindingTypeEXT = "VkDeviceAddressBindingTypeEXT".enumType
val VkDeviceAddressBindingFlagBitsEXT = "VkDeviceAddressBindingFlagBitsEXT".enumType
val VkFormatFeatureFlagBits2KHR = "VkFormatFeatureFlagBits2KHR".enumType
val VkFrameBoundaryFlagBitsEXT = "VkFrameBoundaryFlagBitsEXT".enumType
val VkMicromapTypeEXT = "VkMicromapTypeEXT".enumType
val VkBuildMicromapModeEXT = "VkBuildMicromapModeEXT".enumType
val VkBuildMicromapFlagBitsEXT = "VkBuildMicromapFlagBitsEXT".enumType
val VkCopyMicromapModeEXT = "VkCopyMicromapModeEXT".enumType
val VkMicromapCreateFlagBitsEXT = "VkMicromapCreateFlagBitsEXT".enumType
val VkOpacityMicromapFormatEXT = "VkOpacityMicromapFormatEXT".enumType
val VkOpacityMicromapSpecialIndexEXT = "VkOpacityMicromapSpecialIndexEXT".enumType
val VkDisplacementMicromapFormatNV = "VkDisplacementMicromapFormatNV".enumType
val VkPhysicalDeviceSchedulingControlsFlagBitsARM = "VkPhysicalDeviceSchedulingControlsFlagBitsARM".enumType
val VkMemoryDecompressionMethodFlagBitsNV = "VkMemoryDecompressionMethodFlagBitsNV".enumType
val VkSubpassMergeStatusEXT = "VkSubpassMergeStatusEXT".enumType
val VkDirectDriverLoadingModeLUNARG = "VkDirectDriverLoadingModeLUNARG".enumType
val VkPipelineColorBlendStateCreateFlagBits = "VkPipelineColorBlendStateCreateFlagBits".enumType
val VkPipelineDepthStencilStateCreateFlagBits = "VkPipelineDepthStencilStateCreateFlagBits".enumType
val VkOpticalFlowUsageFlagBitsNV = "VkOpticalFlowUsageFlagBitsNV".enumType
val VkOpticalFlowGridSizeFlagBitsNV = "VkOpticalFlowGridSizeFlagBitsNV".enumType
val VkOpticalFlowPerformanceLevelNV = "VkOpticalFlowPerformanceLevelNV".enumType
val VkOpticalFlowSessionBindingPointNV = "VkOpticalFlowSessionBindingPointNV".enumType
val VkOpticalFlowSessionCreateFlagBitsNV = "VkOpticalFlowSessionCreateFlagBitsNV".enumType
val VkOpticalFlowExecuteFlagBitsNV = "VkOpticalFlowExecuteFlagBitsNV".enumType
val VkPipelineCreateFlagBits2KHR = "VkPipelineCreateFlagBits2KHR".enumType
val VkBufferUsageFlagBits2KHR = "VkBufferUsageFlagBits2KHR".enumType
val VkAntiLagModeAMD = "VkAntiLagModeAMD".enumType
val VkAntiLagStageAMD = "VkAntiLagStageAMD".enumType
val VkShaderCreateFlagBitsEXT = "VkShaderCreateFlagBitsEXT".enumType
val VkShaderCodeTypeEXT = "VkShaderCodeTypeEXT".enumType
val VkDepthClampModeEXT = "VkDepthClampModeEXT".enumType
val VkRayTracingInvocationReorderModeNV = "VkRayTracingInvocationReorderModeNV".enumType
val VkLayerSettingTypeEXT = "VkLayerSettingTypeEXT".enumType
val VkLatencyMarkerNV = "VkLatencyMarkerNV".enumType
val VkOutOfBandQueueTypeNV = "VkOutOfBandQueueTypeNV".enumType
val VkComponentTypeKHR = "VkComponentTypeKHR".enumType
val VkScopeKHR = "VkScopeKHR".enumType
val VkVideoEncodeAV1PredictionModeKHR = "VkVideoEncodeAV1PredictionModeKHR".enumType
val VkVideoEncodeAV1RateControlGroupKHR = "VkVideoEncodeAV1RateControlGroupKHR".enumType
val VkVideoEncodeAV1CapabilityFlagBitsKHR = "VkVideoEncodeAV1CapabilityFlagBitsKHR".enumType
val VkVideoEncodeAV1StdFlagBitsKHR = "VkVideoEncodeAV1StdFlagBitsKHR".enumType
val VkVideoEncodeAV1SuperblockSizeFlagBitsKHR = "VkVideoEncodeAV1SuperblockSizeFlagBitsKHR".enumType
val VkVideoEncodeAV1RateControlFlagBitsKHR = "VkVideoEncodeAV1RateControlFlagBitsKHR".enumType
val VkBlockMatchWindowCompareModeQCOM = "VkBlockMatchWindowCompareModeQCOM".enumType
val VkCubicFilterWeightsQCOM = "VkCubicFilterWeightsQCOM".enumType
val VkLayeredDriverUnderlyingApiMSFT = "VkLayeredDriverUnderlyingApiMSFT".enumType
val VkLineRasterizationModeKHR = "VkLineRasterizationModeKHR".enumType
val VkDisplaySurfaceStereoTypeNV = "VkDisplaySurfaceStereoTypeNV".enumType
val VkVideoEncodeFlagBitsKHR = "VkVideoEncodeFlagBitsKHR".enumType
val VkVideoSessionParametersCreateFlagBitsKHR = "VkVideoSessionParametersCreateFlagBitsKHR".enumType
val VkPhysicalDeviceLayeredApiKHR = "VkPhysicalDeviceLayeredApiKHR".enumType
val VkIndirectExecutionSetInfoTypeEXT = "VkIndirectExecutionSetInfoTypeEXT".enumType
val VkIndirectCommandsTokenTypeEXT = "VkIndirectCommandsTokenTypeEXT".enumType
val VkIndirectCommandsInputModeFlagBitsEXT = "VkIndirectCommandsInputModeFlagBitsEXT".enumType
val VkIndirectCommandsLayoutUsageFlagBitsEXT = "VkIndirectCommandsLayoutUsageFlagBitsEXT".enumType

// Bitmask types
val VkCompositeAlphaFlagsKHR = typedef(VkFlags, "VkCompositeAlphaFlagsKHR")
val VkSurfaceTransformFlagsKHR = typedef(VkFlags, "VkSurfaceTransformFlagsKHR")
val VkSwapchainCreateFlagsKHR = typedef(VkFlags, "VkSwapchainCreateFlagsKHR")
val VkDeviceGroupPresentModeFlagsKHR = typedef(VkFlags, "VkDeviceGroupPresentModeFlagsKHR")
val VkDisplayModeCreateFlagsKHR = typedef(VkFlags, "VkDisplayModeCreateFlagsKHR")
val VkDisplayPlaneAlphaFlagsKHR = typedef(VkFlags, "VkDisplayPlaneAlphaFlagsKHR")
val VkDisplaySurfaceCreateFlagsKHR = typedef(VkFlags, "VkDisplaySurfaceCreateFlagsKHR")
val VkXlibSurfaceCreateFlagsKHR = typedef(VkFlags, "VkXlibSurfaceCreateFlagsKHR")
val VkXcbSurfaceCreateFlagsKHR = typedef(VkFlags, "VkXcbSurfaceCreateFlagsKHR")
val VkWaylandSurfaceCreateFlagsKHR = typedef(VkFlags, "VkWaylandSurfaceCreateFlagsKHR")
val VkAndroidSurfaceCreateFlagsKHR = typedef(VkFlags, "VkAndroidSurfaceCreateFlagsKHR")
val VkWin32SurfaceCreateFlagsKHR = typedef(VkFlags, "VkWin32SurfaceCreateFlagsKHR")
val VkDebugReportFlagsEXT = typedef(VkFlags, "VkDebugReportFlagsEXT")
val VkVideoCodecOperationFlagsKHR = typedef(VkFlags, "VkVideoCodecOperationFlagsKHR")
val VkVideoChromaSubsamplingFlagsKHR = typedef(VkFlags, "VkVideoChromaSubsamplingFlagsKHR")
val VkVideoComponentBitDepthFlagsKHR = typedef(VkFlags, "VkVideoComponentBitDepthFlagsKHR")
val VkVideoCapabilityFlagsKHR = typedef(VkFlags, "VkVideoCapabilityFlagsKHR")
val VkVideoSessionCreateFlagsKHR = typedef(VkFlags, "VkVideoSessionCreateFlagsKHR")
val VkVideoSessionParametersCreateFlagsKHR = typedef(VkFlags, "VkVideoSessionParametersCreateFlagsKHR")
val VkVideoBeginCodingFlagsKHR = typedef(VkFlags, "VkVideoBeginCodingFlagsKHR")
val VkVideoEndCodingFlagsKHR = typedef(VkFlags, "VkVideoEndCodingFlagsKHR")
val VkVideoCodingControlFlagsKHR = typedef(VkFlags, "VkVideoCodingControlFlagsKHR")
val VkVideoDecodeCapabilityFlagsKHR = typedef(VkFlags, "VkVideoDecodeCapabilityFlagsKHR")
val VkVideoDecodeUsageFlagsKHR = typedef(VkFlags, "VkVideoDecodeUsageFlagsKHR")
val VkVideoDecodeFlagsKHR = typedef(VkFlags, "VkVideoDecodeFlagsKHR")
val VkPipelineRasterizationStateStreamCreateFlagsEXT = typedef(VkFlags, "VkPipelineRasterizationStateStreamCreateFlagsEXT")
val VkVideoEncodeH264CapabilityFlagsKHR = typedef(VkFlags, "VkVideoEncodeH264CapabilityFlagsKHR")
val VkVideoEncodeH264StdFlagsKHR = typedef(VkFlags, "VkVideoEncodeH264StdFlagsKHR")
val VkVideoEncodeH264RateControlFlagsKHR = typedef(VkFlags, "VkVideoEncodeH264RateControlFlagsKHR")
val VkVideoEncodeH265CapabilityFlagsKHR = typedef(VkFlags, "VkVideoEncodeH265CapabilityFlagsKHR")
val VkVideoEncodeH265StdFlagsKHR = typedef(VkFlags, "VkVideoEncodeH265StdFlagsKHR")
val VkVideoEncodeH265CtbSizeFlagsKHR = typedef(VkFlags, "VkVideoEncodeH265CtbSizeFlagsKHR")
val VkVideoEncodeH265TransformBlockSizeFlagsKHR = typedef(VkFlags, "VkVideoEncodeH265TransformBlockSizeFlagsKHR")
val VkVideoEncodeH265RateControlFlagsKHR = typedef(VkFlags, "VkVideoEncodeH265RateControlFlagsKHR")
val VkVideoDecodeH264PictureLayoutFlagsKHR = typedef(VkFlags, "VkVideoDecodeH264PictureLayoutFlagsKHR")
val VkRenderingFlagsKHR = typedef(VkFlags, "VkRenderingFlagsKHR")
val VkExternalMemoryHandleTypeFlagsNV = typedef(VkFlags, "VkExternalMemoryHandleTypeFlagsNV")
val VkExternalMemoryFeatureFlagsNV = typedef(VkFlags, "VkExternalMemoryFeatureFlagsNV")
val VkPeerMemoryFeatureFlagsKHR = typedef(VkFlags, "VkPeerMemoryFeatureFlagsKHR")
val VkMemoryAllocateFlagsKHR = typedef(VkFlags, "VkMemoryAllocateFlagsKHR")
val VkCommandPoolTrimFlagsKHR = typedef(VkFlags, "VkCommandPoolTrimFlagsKHR")
val VkExternalMemoryHandleTypeFlagsKHR = typedef(VkFlags, "VkExternalMemoryHandleTypeFlagsKHR")
val VkExternalMemoryFeatureFlagsKHR = typedef(VkFlags, "VkExternalMemoryFeatureFlagsKHR")
val VkExternalSemaphoreHandleTypeFlagsKHR = typedef(VkFlags, "VkExternalSemaphoreHandleTypeFlagsKHR")
val VkExternalSemaphoreFeatureFlagsKHR = typedef(VkFlags, "VkExternalSemaphoreFeatureFlagsKHR")
val VkSemaphoreImportFlagsKHR = typedef(VkFlags, "VkSemaphoreImportFlagsKHR")
val VkConditionalRenderingFlagsEXT = typedef(VkFlags, "VkConditionalRenderingFlagsEXT")
val VkDescriptorUpdateTemplateCreateFlagsKHR = typedef(VkFlags, "VkDescriptorUpdateTemplateCreateFlagsKHR")
val VkSurfaceCounterFlagsEXT = typedef(VkFlags, "VkSurfaceCounterFlagsEXT")
val VkPipelineViewportSwizzleStateCreateFlagsNV = typedef(VkFlags, "VkPipelineViewportSwizzleStateCreateFlagsNV")
val VkPipelineDiscardRectangleStateCreateFlagsEXT = typedef(VkFlags, "VkPipelineDiscardRectangleStateCreateFlagsEXT")
val VkPipelineRasterizationConservativeStateCreateFlagsEXT = typedef(VkFlags, "VkPipelineRasterizationConservativeStateCreateFlagsEXT")
val VkPipelineRasterizationDepthClipStateCreateFlagsEXT = typedef(VkFlags, "VkPipelineRasterizationDepthClipStateCreateFlagsEXT")
val VkExternalFenceHandleTypeFlagsKHR = typedef(VkFlags, "VkExternalFenceHandleTypeFlagsKHR")
val VkExternalFenceFeatureFlagsKHR = typedef(VkFlags, "VkExternalFenceFeatureFlagsKHR")
val VkFenceImportFlagsKHR = typedef(VkFlags, "VkFenceImportFlagsKHR")
val VkPerformanceCounterDescriptionFlagsKHR = typedef(VkFlags, "VkPerformanceCounterDescriptionFlagsKHR")
val VkAcquireProfilingLockFlagsKHR = typedef(VkFlags, "VkAcquireProfilingLockFlagsKHR")
val VkMacOSSurfaceCreateFlagsMVK = typedef(VkFlags, "VkMacOSSurfaceCreateFlagsMVK")
val VkDebugUtilsMessageTypeFlagsEXT = typedef(VkFlags, "VkDebugUtilsMessageTypeFlagsEXT")
val VkDebugUtilsMessengerCallbackDataFlagsEXT = typedef(VkFlags, "VkDebugUtilsMessengerCallbackDataFlagsEXT")
val VkDebugUtilsMessageSeverityFlagsEXT = typedef(VkFlags, "VkDebugUtilsMessageSeverityFlagsEXT")
val VkDebugUtilsMessengerCreateFlagsEXT = typedef(VkFlags, "VkDebugUtilsMessengerCreateFlagsEXT")
val VkPipelineCoverageToColorStateCreateFlagsNV = typedef(VkFlags, "VkPipelineCoverageToColorStateCreateFlagsNV")
val VkBuildAccelerationStructureFlagsKHR = typedef(VkFlags, "VkBuildAccelerationStructureFlagsKHR")
val VkGeometryFlagsKHR = typedef(VkFlags, "VkGeometryFlagsKHR")
val VkGeometryInstanceFlagsKHR = typedef(VkFlags, "VkGeometryInstanceFlagsKHR")
val VkAccelerationStructureCreateFlagsKHR = typedef(VkFlags, "VkAccelerationStructureCreateFlagsKHR")
val VkPipelineCoverageModulationStateCreateFlagsNV = typedef(VkFlags, "VkPipelineCoverageModulationStateCreateFlagsNV")
val VkValidationCacheCreateFlagsEXT = typedef(VkFlags, "VkValidationCacheCreateFlagsEXT")
val VkDescriptorBindingFlagsEXT = typedef(VkFlags, "VkDescriptorBindingFlagsEXT")
val VkGeometryFlagsNV = typedef(VkFlags, "VkGeometryFlagsNV")
val VkGeometryInstanceFlagsNV = typedef(VkFlags, "VkGeometryInstanceFlagsNV")
val VkBuildAccelerationStructureFlagsNV = typedef(VkFlags, "VkBuildAccelerationStructureFlagsNV")
val VkPipelineCompilerControlFlagsAMD = typedef(VkFlags, "VkPipelineCompilerControlFlagsAMD")
val VkPipelineCreationFeedbackFlagsEXT = typedef(VkFlags, "VkPipelineCreationFeedbackFlagsEXT")
val VkResolveModeFlagsKHR = typedef(VkFlags, "VkResolveModeFlagsKHR")
val VkSemaphoreWaitFlagsKHR = typedef(VkFlags, "VkSemaphoreWaitFlagsKHR")
val VkMetalSurfaceCreateFlagsEXT = typedef(VkFlags, "VkMetalSurfaceCreateFlagsEXT")
val VkShaderCorePropertiesFlagsAMD = typedef(VkFlags, "VkShaderCorePropertiesFlagsAMD")
val VkToolPurposeFlagsEXT = typedef(VkFlags, "VkToolPurposeFlagsEXT")
val VkPipelineCoverageReductionStateCreateFlagsNV = typedef(VkFlags, "VkPipelineCoverageReductionStateCreateFlagsNV")
val VkHeadlessSurfaceCreateFlagsEXT = typedef(VkFlags, "VkHeadlessSurfaceCreateFlagsEXT")
val VkHostImageCopyFlagsEXT = typedef(VkFlags, "VkHostImageCopyFlagsEXT")
val VkMemoryUnmapFlagsKHR = typedef(VkFlags, "VkMemoryUnmapFlagsKHR")
val VkPresentScalingFlagsEXT = typedef(VkFlags, "VkPresentScalingFlagsEXT")
val VkPresentGravityFlagsEXT = typedef(VkFlags, "VkPresentGravityFlagsEXT")
val VkIndirectStateFlagsNV = typedef(VkFlags, "VkIndirectStateFlagsNV")
val VkIndirectCommandsLayoutUsageFlagsNV = typedef(VkFlags, "VkIndirectCommandsLayoutUsageFlagsNV")
val VkDeviceMemoryReportFlagsEXT = typedef(VkFlags, "VkDeviceMemoryReportFlagsEXT")
val VkPrivateDataSlotCreateFlagsEXT = typedef(VkFlags, "VkPrivateDataSlotCreateFlagsEXT")
val VkVideoEncodeFlagsKHR = typedef(VkFlags, "VkVideoEncodeFlagsKHR")
val VkVideoEncodeCapabilityFlagsKHR = typedef(VkFlags, "VkVideoEncodeCapabilityFlagsKHR")
val VkVideoEncodeRateControlModeFlagsKHR = typedef(VkFlags, "VkVideoEncodeRateControlModeFlagsKHR")
val VkVideoEncodeFeedbackFlagsKHR = typedef(VkFlags, "VkVideoEncodeFeedbackFlagsKHR")
val VkVideoEncodeUsageFlagsKHR = typedef(VkFlags, "VkVideoEncodeUsageFlagsKHR")
val VkVideoEncodeContentFlagsKHR = typedef(VkFlags, "VkVideoEncodeContentFlagsKHR")
val VkVideoEncodeRateControlFlagsKHR = typedef(VkFlags, "VkVideoEncodeRateControlFlagsKHR")
val VkDeviceDiagnosticsConfigFlagsNV = typedef(VkFlags, "VkDeviceDiagnosticsConfigFlagsNV")
val VkExportMetalObjectTypeFlagsEXT = typedef(VkFlags, "VkExportMetalObjectTypeFlagsEXT")
val VkPipelineStageFlags2KHR = typedef(VkFlags64, "VkPipelineStageFlags2KHR")
val VkAccessFlags2KHR = typedef(VkFlags64, "VkAccessFlags2KHR")
val VkSubmitFlagsKHR = typedef(VkFlags, "VkSubmitFlagsKHR")
val VkGraphicsPipelineLibraryFlagsEXT = typedef(VkFlags, "VkGraphicsPipelineLibraryFlagsEXT")
val VkAccelerationStructureMotionInfoFlagsNV = typedef(VkFlags, "VkAccelerationStructureMotionInfoFlagsNV")
val VkAccelerationStructureMotionInstanceFlagsNV = typedef(VkFlags, "VkAccelerationStructureMotionInstanceFlagsNV")
val VkImageCompressionFlagsEXT = typedef(VkFlags, "VkImageCompressionFlagsEXT")
val VkImageCompressionFixedRateFlagsEXT = typedef(VkFlags, "VkImageCompressionFixedRateFlagsEXT")
val VkDirectFBSurfaceCreateFlagsEXT = typedef(VkFlags, "VkDirectFBSurfaceCreateFlagsEXT")
val VkDeviceAddressBindingFlagsEXT = typedef(VkFlags, "VkDeviceAddressBindingFlagsEXT")
val VkFormatFeatureFlags2KHR = typedef(VkFlags64, "VkFormatFeatureFlags2KHR")
val VkFrameBoundaryFlagsEXT = typedef(VkFlags, "VkFrameBoundaryFlagsEXT")
val VkBuildMicromapFlagsEXT = typedef(VkFlags, "VkBuildMicromapFlagsEXT")
val VkMicromapCreateFlagsEXT = typedef(VkFlags, "VkMicromapCreateFlagsEXT")
val VkPhysicalDeviceSchedulingControlsFlagsARM = typedef(VkFlags64, "VkPhysicalDeviceSchedulingControlsFlagsARM")
val VkMemoryDecompressionMethodFlagsNV = typedef(VkFlags64, "VkMemoryDecompressionMethodFlagsNV")
val VkDirectDriverLoadingFlagsLUNARG = typedef(VkFlags, "VkDirectDriverLoadingFlagsLUNARG")
val VkOpticalFlowGridSizeFlagsNV = typedef(VkFlags, "VkOpticalFlowGridSizeFlagsNV")
val VkOpticalFlowUsageFlagsNV = typedef(VkFlags, "VkOpticalFlowUsageFlagsNV")
val VkOpticalFlowSessionCreateFlagsNV = typedef(VkFlags, "VkOpticalFlowSessionCreateFlagsNV")
val VkOpticalFlowExecuteFlagsNV = typedef(VkFlags, "VkOpticalFlowExecuteFlagsNV")
val VkPipelineCreateFlags2KHR = typedef(VkFlags64, "VkPipelineCreateFlags2KHR")
val VkBufferUsageFlags2KHR = typedef(VkFlags64, "VkBufferUsageFlags2KHR")
val VkShaderCreateFlagsEXT = typedef(VkFlags, "VkShaderCreateFlagsEXT")
val VkVideoEncodeAV1CapabilityFlagsKHR = typedef(VkFlags, "VkVideoEncodeAV1CapabilityFlagsKHR")
val VkVideoEncodeAV1StdFlagsKHR = typedef(VkFlags, "VkVideoEncodeAV1StdFlagsKHR")
val VkVideoEncodeAV1SuperblockSizeFlagsKHR = typedef(VkFlags, "VkVideoEncodeAV1SuperblockSizeFlagsKHR")
val VkVideoEncodeAV1RateControlFlagsKHR = typedef(VkFlags, "VkVideoEncodeAV1RateControlFlagsKHR")
val VkIndirectCommandsInputModeFlagsEXT = typedef(VkFlags, "VkIndirectCommandsInputModeFlagsEXT")
val VkIndirectCommandsLayoutUsageFlagsEXT = typedef(VkFlags, "VkIndirectCommandsLayoutUsageFlagsEXT")

// Function pointer types
val PFN_vkDebugReportCallbackEXT = Module.VULKAN.callback {
    VkBool32(
        "VkDebugReportCallbackEXT",
        "Application-defined debug report callback function.",

        VkDebugReportFlagsEXT("flags", "specifies the {@code VkDebugReportFlagBitsEXT} that triggered this callback."),
        VkDebugReportObjectTypeEXT("objectType", "a {@code VkDebugReportObjectTypeEXT} value specifying the type of object being used or created at the time the event was triggered."),
        uint64_t("object", "the object where the issue was detected. If {@code objectType} is #DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT, {@code object} is undefined."),
        size_t("location", "a component (layer, driver, loader) defined value specifying the <em>location</em> of the trigger. This is an <b>optional</b> value."),
        int32_t("messageCode", "a layer-defined value indicating what test triggered this callback."),
        charUTF8.const.p("pLayerPrefix", "a null-terminated UTF-8 string that is an abbreviation of the name of the component making the callback. {@code pLayerPrefix} is only valid for the duration of the callback."),
        charUTF8.const.p("pMessage", "a null-terminated UTF-8 string detailing the trigger conditions. {@code pMessage} is only valid for the duration of the callback."),
        opaque_p("pUserData", "the user data given when the {@code VkDebugReportCallbackEXT} was created."),

        nativeType = "PFN_vkDebugReportCallbackEXT"
    ) {
        documentation =
        """
        Application-defined debug report callback function.

        <h5>C Specification</h5>
        The prototype for the ##VkDebugReportCallbackCreateInfoEXT{@code ::pfnCallback} function implemented by the application is:

        <pre><code>
￿typedef VkBool32 (VKAPI_PTR *PFN_vkDebugReportCallbackEXT)(
￿    VkDebugReportFlagsEXT                       flags,
￿    VkDebugReportObjectTypeEXT                  objectType,
￿    uint64_t                                    object,
￿    size_t                                      location,
￿    int32_t                                     messageCode,
￿    const char*                                 pLayerPrefix,
￿    const char*                                 pMessage,
￿    void*                                       pUserData);</code></pre>

        <h5>Description</h5>
        The callback <b>must</b> not call {@code vkDestroyDebugReportCallbackEXT}.

        The callback returns a {@code VkBool32}, which is interpreted in a layer-specified manner. The application <b>should</b> always return #FALSE. The #TRUE value is reserved for use in layer development.

        {@code object} <b>must</b> be a Vulkan object or #NULL_HANDLE. If {@code objectType} is not #DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT and {@code object} is not #NULL_HANDLE, {@code object} <b>must</b> be a Vulkan object of the corresponding type associated with {@code objectType} as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#debug-report-object-types">{@code VkDebugReportObjectTypeEXT} and Vulkan Handle Relationship</a>.

        <h5>See Also</h5>
        ##VkDebugReportCallbackCreateInfoEXT
        """
    }
}

val _VkDebugUtilsMessengerCallbackDataEXT = struct(Module.VULKAN, "VkDebugUtilsMessengerCallbackDataEXT")
val PFN_vkDebugUtilsMessengerCallbackEXT = Module.VULKAN.callback {
    VkBool32(
        "VkDebugUtilsMessengerCallbackEXT",
        "Application-defined debug messenger callback function.",

        VkDebugUtilsMessageSeverityFlagBitsEXT("messageSeverity", "specifies the {@code VkDebugUtilsMessageSeverityFlagBitsEXT} that triggered this callback."),
        VkDebugUtilsMessageTypeFlagsEXT("messageTypes", "a bitmask of {@code VkDebugUtilsMessageTypeFlagBitsEXT} specifying which type of event(s) triggered this callback."),
        _VkDebugUtilsMessengerCallbackDataEXT.const.p("pCallbackData", "contains all the callback related data in the ##VkDebugUtilsMessengerCallbackDataEXT structure."),
        opaque_p("pUserData", "the user data provided when the {@code VkDebugUtilsMessengerEXT} was created."),

        nativeType = "PFN_vkDebugUtilsMessengerCallbackEXT"
    ) {
        documentation =
        """
        Application-defined debug messenger callback function.

        <h5>C Specification</h5>
        The prototype for the ##VkDebugUtilsMessengerCreateInfoEXT{@code ::pfnUserCallback} function implemented by the application is:

        <pre><code>
￿typedef VkBool32 (VKAPI_PTR *PFN_vkDebugUtilsMessengerCallbackEXT)(
￿    VkDebugUtilsMessageSeverityFlagBitsEXT           messageSeverity,
￿    VkDebugUtilsMessageTypeFlagsEXT                  messageTypes,
￿    const VkDebugUtilsMessengerCallbackDataEXT*      pCallbackData,
￿    void*                                            pUserData);</code></pre>

        <h5>Description</h5>
        The callback returns a {@code VkBool32}, which is interpreted in a layer-specified manner. The application <b>should</b> always return #FALSE. The #TRUE value is reserved for use in layer development.

        <h5>Valid Usage</h5>
        <ul>
            <li>The callback <b>must</b> not make calls to any Vulkan commands</li>
        </ul>

        <h5>See Also</h5>
        ##VkDebugUtilsMessengerCallbackDataEXT, ##VkDebugUtilsMessengerCreateInfoEXT
        """
    }
}

val _VkDeviceMemoryReportCallbackDataEXT = struct(Module.VULKAN, "VkDeviceMemoryReportCallbackDataEXT")
val PFN_vkDeviceMemoryReportCallbackEXT = Module.VULKAN.callback {
    void(
        "VkDeviceMemoryReportCallbackEXT",
        "Application-defined device memory report callback function.",

        _VkDeviceMemoryReportCallbackDataEXT.const.p("pCallbackData", "contains all the callback related data in the ##VkDeviceMemoryReportCallbackDataEXT structure."),
        opaque_p("pUserData", "the user data provided when the ##VkDeviceDeviceMemoryReportCreateInfoEXT was created."),

        nativeType = "PFN_vkDeviceMemoryReportCallbackEXT"
    ) {
        documentation =
        """
        Application-defined device memory report callback function.

        <h5>C Specification</h5>
        The prototype for the ##VkDeviceDeviceMemoryReportCreateInfoEXT{@code ::pfnUserCallback} function implemented by the application is:

        <pre><code>
￿typedef void (VKAPI_PTR *PFN_vkDeviceMemoryReportCallbackEXT)(
￿    const VkDeviceMemoryReportCallbackDataEXT*  pCallbackData,
￿    void*                                       pUserData);</code></pre>

        <h5>Description</h5>
        The callback <b>must</b> not make calls to any Vulkan commands.

        <h5>See Also</h5>
        ##VkDeviceDeviceMemoryReportCreateInfoEXT, ##VkDeviceMemoryReportCallbackDataEXT
        """
    }
}

// Struct types
val VkSurfaceCapabilitiesKHR = struct(Module.VULKAN, "VkSurfaceCapabilitiesKHR", mutable = false) {
    documentation =
        """
        Structure describing capabilities of a surface.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Supported usage flags of a presentable image when using #PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR or #PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR presentation mode are provided by ##VkSharedPresentSurfaceCapabilitiesKHR{@code ::sharedPresentSupportedUsageFlags}.
        </div>

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Formulas such as <code>min(N, maxImageCount)</code> are not correct, since {@code maxImageCount} <b>may</b> be zero.
        </div>

        <h5>See Also</h5>
        ##VkExtent2D, ##VkSurfaceCapabilities2KHR, #GetPhysicalDeviceSurfaceCapabilitiesKHR()
        """

    uint32_t("minImageCount", "the minimum number of images the specified device supports for a swapchain created for the surface, and will be at least one.")
    uint32_t("maxImageCount", "the maximum number of images the specified device supports for a swapchain created for the surface, and will be either 0, or greater than or equal to {@code minImageCount}. A value of 0 means that there is no limit on the number of images, though there <b>may</b> be limits related to the total amount of memory used by presentable images.")
    VkExtent2D("currentExtent", "the current width and height of the surface, or the special value <code>(0xFFFFFFFF, 0xFFFFFFFF)</code> indicating that the surface size will be determined by the extent of a swapchain targeting the surface.")
    VkExtent2D("minImageExtent", "contains the smallest valid swapchain extent for the surface on the specified device. The {@code width} and {@code height} of the extent will each be less than or equal to the corresponding {@code width} and {@code height} of {@code currentExtent}, unless {@code currentExtent} has the special value described above.")
    VkExtent2D("maxImageExtent", "contains the largest valid swapchain extent for the surface on the specified device. The {@code width} and {@code height} of the extent will each be greater than or equal to the corresponding {@code width} and {@code height} of {@code minImageExtent}. The {@code width} and {@code height} of the extent will each be greater than or equal to the corresponding {@code width} and {@code height} of {@code currentExtent}, unless {@code currentExtent} has the special value described above.")
    uint32_t("maxImageArrayLayers", "the maximum number of layers presentable images <b>can</b> have for a swapchain created for this device and surface, and will be at least one.")
    VkSurfaceTransformFlagsKHR("supportedTransforms", "a bitmask of {@code VkSurfaceTransformFlagBitsKHR} indicating the presentation transforms supported for the surface on the specified device. At least one bit will be set.")
    VkSurfaceTransformFlagBitsKHR("currentTransform", "{@code VkSurfaceTransformFlagBitsKHR} value indicating the surface’s current transform relative to the presentation engine’s natural orientation.")
    VkCompositeAlphaFlagsKHR("supportedCompositeAlpha", "a bitmask of {@code VkCompositeAlphaFlagBitsKHR}, representing the alpha compositing modes supported by the presentation engine for the surface on the specified device, and at least one bit will be set. Opaque composition <b>can</b> be achieved in any alpha compositing mode by either using an image format that has no alpha component, or by ensuring that all pixels in the presentable images have an alpha value of 1.0.")
    VkImageUsageFlags("supportedUsageFlags", "a bitmask of {@code VkImageUsageFlagBits} representing the ways the application <b>can</b> use the presentable images of a swapchain created with {@code VkPresentModeKHR} set to #PRESENT_MODE_FIFO_LATEST_READY_EXT, #PRESENT_MODE_IMMEDIATE_KHR, #PRESENT_MODE_MAILBOX_KHR, #PRESENT_MODE_FIFO_KHR or #PRESENT_MODE_FIFO_RELAXED_KHR for the surface on the specified device. #IMAGE_USAGE_COLOR_ATTACHMENT_BIT <b>must</b> be included in the set. Implementations <b>may</b> support additional usages.")
}

val VkSurfaceFormatKHR = struct(Module.VULKAN, "VkSurfaceFormatKHR", mutable = false) {
    documentation =
        """
        Structure describing a supported swapchain format-color space pair.

        <h5>See Also</h5>
        ##VkSurfaceFormat2KHR, #GetPhysicalDeviceSurfaceFormatsKHR()
        """

    VkFormat("format", "a {@code VkFormat} that is compatible with the specified surface.")
    VkColorSpaceKHR("colorSpace", "a presentation {@code VkColorSpaceKHR} that is compatible with the surface.")
}

val VkSwapchainCreateInfoKHR = struct(Module.VULKAN, "VkSwapchainCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created swapchain object.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code surface} <b>must</b> be a surface that is supported by the device as determined using #GetPhysicalDeviceSurfaceSupportKHR()</li>
            <li>{@code minImageCount} <b>must</b> be less than or equal to the value returned in the {@code maxImageCount} member of the ##VkSurfaceCapabilitiesKHR structure returned by {@code vkGetPhysicalDeviceSurfaceCapabilitiesKHR} for the surface if the returned {@code maxImageCount} is not zero</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-swapchainMaintenance1">{@code swapchainMaintenance1}</a> feature is not enabled, then the {@code pNext} chain <b>must</b> not include a ##VkSwapchainPresentModesCreateInfoEXT structure</li>
            <li>If {@code presentMode} is not #PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR nor #PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR, then {@code minImageCount} <b>must</b> be greater than or equal to the value returned in the {@code minImageCount} member of the ##VkSurfaceCapabilitiesKHR structure returned by #GetPhysicalDeviceSurfaceCapabilitiesKHR() for the surface</li>
            <li>{@code minImageCount} <b>must</b> be 1 if {@code presentMode} is either #PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR or #PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR</li>
            <li>{@code imageFormat} and {@code imageColorSpace} <b>must</b> match the {@code format} and {@code colorSpace} members, respectively, of one of the ##VkSurfaceFormatKHR structures returned by {@code vkGetPhysicalDeviceSurfaceFormatsKHR} for the surface</li>
            <li>If a ##VkSwapchainPresentScalingCreateInfoEXT structure was not included in the {@code pNext} chain, or it is included and ##VkSwapchainPresentScalingCreateInfoEXT{@code ::scalingBehavior} is zero then {@code imageExtent} <b>must</b> be between {@code minImageExtent} and {@code maxImageExtent}, inclusive, where {@code minImageExtent} and {@code maxImageExtent} are members of the ##VkSurfaceCapabilitiesKHR structure returned by {@code vkGetPhysicalDeviceSurfaceCapabilitiesKHR} for the surface</li>
            <li>If a ##VkSwapchainPresentScalingCreateInfoEXT structure was included in the {@code pNext} chain and ##VkSwapchainPresentScalingCreateInfoEXT{@code ::scalingBehavior} is not zero then {@code imageExtent} <b>must</b> be between {@code minScaledImageExtent} and {@code maxScaledImageExtent}, inclusive, where {@code minScaledImageExtent} and {@code maxScaledImageExtent} are members of the ##VkSurfacePresentScalingCapabilitiesEXT structure returned by {@code vkGetPhysicalDeviceSurfaceCapabilities2KHR} for the surface and {@code presentMode}</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-swapchainMaintenance1">{@code swapchainMaintenance1}</a> feature is not enabled, then {@code flags} <b>must</b> not include #SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_EXT</li>
            <li>{@code imageExtent} members {@code width} and {@code height} <b>must</b> both be non-zero</li>
            <li>{@code imageArrayLayers} <b>must</b> be greater than 0 and less than or equal to the {@code maxImageArrayLayers} member of the ##VkSurfaceCapabilitiesKHR structure returned by {@code vkGetPhysicalDeviceSurfaceCapabilitiesKHR} for the surface</li>
            <li>If {@code presentMode} is #PRESENT_MODE_FIFO_LATEST_READY_EXT, #PRESENT_MODE_IMMEDIATE_KHR, #PRESENT_MODE_MAILBOX_KHR, #PRESENT_MODE_FIFO_KHR or #PRESENT_MODE_FIFO_RELAXED_KHR, {@code imageUsage} <b>must</b> be a subset of the supported usage flags present in the {@code supportedUsageFlags} member of the ##VkSurfaceCapabilitiesKHR structure returned by #GetPhysicalDeviceSurfaceCapabilitiesKHR() for {@code surface}</li>
            <li>If {@code presentMode} is #PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR or #PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR, {@code imageUsage} <b>must</b> be a subset of the supported usage flags present in the {@code sharedPresentSupportedUsageFlags} member of the ##VkSharedPresentSurfaceCapabilitiesKHR structure returned by #GetPhysicalDeviceSurfaceCapabilities2KHR() for {@code surface}</li>
            <li>If {@code imageSharingMode} is #SHARING_MODE_CONCURRENT, {@code pQueueFamilyIndices} <b>must</b> be a valid pointer to an array of {@code queueFamilyIndexCount} {@code uint32_t} values</li>
            <li>If {@code imageSharingMode} is #SHARING_MODE_CONCURRENT, {@code queueFamilyIndexCount} <b>must</b> be greater than 1</li>
            <li>If {@code imageSharingMode} is #SHARING_MODE_CONCURRENT, each element of {@code pQueueFamilyIndices} <b>must</b> be unique and <b>must</b> be less than {@code pQueueFamilyPropertyCount} returned by either #GetPhysicalDeviceQueueFamilyProperties() or #GetPhysicalDeviceQueueFamilyProperties2() for the {@code physicalDevice} that was used to create {@code device}</li>
            <li>{@code preTransform} <b>must</b> be one of the bits present in the {@code supportedTransforms} member of the ##VkSurfaceCapabilitiesKHR structure returned by {@code vkGetPhysicalDeviceSurfaceCapabilitiesKHR} for the surface</li>
            <li>{@code compositeAlpha} <b>must</b> be one of the bits present in the {@code supportedCompositeAlpha} member of the ##VkSurfaceCapabilitiesKHR structure returned by {@code vkGetPhysicalDeviceSurfaceCapabilitiesKHR} for the surface</li>
            <li>{@code presentMode} <b>must</b> be one of the {@code VkPresentModeKHR} values returned by {@code vkGetPhysicalDeviceSurfacePresentModesKHR} for the surface</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-presentModeFifoLatestReady">{@code presentModeFifoLatestReady}</a> feature is not enabled, {@code presentMode} <b>must</b> not be #PRESENT_MODE_FIFO_LATEST_READY_EXT</li>
            <li>If the logical device was created with ##VkDeviceGroupDeviceCreateInfo{@code ::physicalDeviceCount} equal to 1, {@code flags} <b>must</b> not contain #SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR</li>
            <li>If {@code oldSwapchain} is not #NULL_HANDLE, {@code oldSwapchain} <b>must</b> be a non-retired swapchain associated with native window referred to by {@code surface}</li>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#swapchain-wsi-image-create-info">implied image creation parameters</a> of the swapchain <b>must</b> be supported as reported by #GetPhysicalDeviceImageFormatProperties()</li>
            <li>If {@code flags} contains #SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR then the {@code pNext} chain <b>must</b> include a ##VkImageFormatListCreateInfo structure with a {@code viewFormatCount} greater than zero and {@code pViewFormats} <b>must</b> have an element equal to {@code imageFormat}</li>
            <li>If a ##VkImageFormatListCreateInfo structure was included in the {@code pNext} chain and ##VkImageFormatListCreateInfo{@code ::viewFormatCount} is not zero then all of the formats in ##VkImageFormatListCreateInfo{@code ::pViewFormats} <b>must</b> be compatible with the {@code format} as described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-compatibility">compatibility table</a></li>
            <li>If {@code flags} does not contain #SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR and the {@code pNext} chain include a ##VkImageFormatListCreateInfo structure then ##VkImageFormatListCreateInfo{@code ::viewFormatCount} <b>must</b> be 0 or 1</li>
            <li>If {@code flags} contains #SWAPCHAIN_CREATE_PROTECTED_BIT_KHR, then ##VkSurfaceProtectedCapabilitiesKHR{@code ::supportsProtected} <b>must</b> be #TRUE in the ##VkSurfaceProtectedCapabilitiesKHR structure returned by #GetPhysicalDeviceSurfaceCapabilities2KHR() for {@code surface}</li>
            <li>If the {@code pNext} chain includes a ##VkSurfaceFullScreenExclusiveInfoEXT structure with its {@code fullScreenExclusive} member set to #FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT, and {@code surface} was created using #CreateWin32SurfaceKHR(), a ##VkSurfaceFullScreenExclusiveWin32InfoEXT structure <b>must</b> be included in the {@code pNext} chain</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-imageCompressionControlSwapchain">{@code imageCompressionControlSwapchain}</a> feature is not enabled, the {@code pNext} chain <b>must</b> not include an ##VkImageCompressionControlEXT structure</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDeviceGroupSwapchainCreateInfoKHR, ##VkImageCompressionControlEXT, ##VkImageFormatListCreateInfo, ##VkSurfaceFullScreenExclusiveInfoEXT, ##VkSurfaceFullScreenExclusiveWin32InfoEXT, ##VkSwapchainCounterCreateInfoEXT, ##VkSwapchainDisplayNativeHdrCreateInfoAMD, ##VkSwapchainLatencyCreateInfoNV, ##VkSwapchainPresentBarrierCreateInfoNV, ##VkSwapchainPresentModesCreateInfoEXT, or ##VkSwapchainPresentScalingCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkSwapchainCreateFlagBitsKHR} values</li>
            <li>{@code surface} <b>must</b> be a valid {@code VkSurfaceKHR} handle</li>
            <li>{@code imageFormat} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>{@code imageColorSpace} <b>must</b> be a valid {@code VkColorSpaceKHR} value</li>
            <li>{@code imageUsage} <b>must</b> be a valid combination of {@code VkImageUsageFlagBits} values</li>
            <li>{@code imageUsage} <b>must</b> not be 0</li>
            <li>{@code imageSharingMode} <b>must</b> be a valid {@code VkSharingMode} value</li>
            <li>{@code preTransform} <b>must</b> be a valid {@code VkSurfaceTransformFlagBitsKHR} value</li>
            <li>{@code compositeAlpha} <b>must</b> be a valid {@code VkCompositeAlphaFlagBitsKHR} value</li>
            <li>{@code presentMode} <b>must</b> be a valid {@code VkPresentModeKHR} value</li>
            <li>If {@code oldSwapchain} is not #NULL_HANDLE, {@code oldSwapchain} <b>must</b> be a valid {@code VkSwapchainKHR} handle</li>
            <li>Both of {@code oldSwapchain}, and {@code surface} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkInstance}</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D, #CreateSharedSwapchainsKHR(), #CreateSwapchainKHR()
        """

    Expression("#STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDeviceGroupSwapchainCreateInfoKHR", "VkImageCompressionControlEXT", "VkImageFormatListCreateInfo", "VkImageFormatListCreateInfoKHR", "VkSurfaceFullScreenExclusiveInfoEXT", "VkSurfaceFullScreenExclusiveWin32InfoEXT", "VkSwapchainCounterCreateInfoEXT", "VkSwapchainDisplayNativeHdrCreateInfoAMD", "VkSwapchainLatencyCreateInfoNV", "VkSwapchainPresentBarrierCreateInfoNV", "VkSwapchainPresentModesCreateInfoEXT", "VkSwapchainPresentScalingCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSwapchainCreateFlagsKHR("flags", "a bitmask of {@code VkSwapchainCreateFlagBitsKHR} indicating parameters of the swapchain creation.")
    VkSurfaceKHR("surface", "the surface onto which the swapchain will present images. If the creation succeeds, the swapchain becomes associated with {@code surface}.")
    uint32_t("minImageCount", "the minimum number of presentable images that the application needs. The implementation will either create the swapchain with at least that many images, or it will fail to create the swapchain.")
    VkFormat("imageFormat", "a {@code VkFormat} value specifying the format the swapchain image(s) will be created with.")
    VkColorSpaceKHR("imageColorSpace", "a {@code VkColorSpaceKHR} value specifying the way the swapchain interprets image data.")
    VkExtent2D("imageExtent", """the size (in pixels) of the swapchain image(s). The behavior is platform-dependent if the image extent does not match the surface’s {@code currentExtent} as returned by {@code vkGetPhysicalDeviceSurfaceCapabilitiesKHR}.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        On some platforms, it is normal that {@code maxImageExtent} <b>may</b> become {@code (0, 0)}, for example when the window is minimized. In such a case, it is not possible to create a swapchain due to the Valid Usage requirements , unless scaling is selected through ##VkSwapchainPresentScalingCreateInfoEXT, if supported .
        </div>""")
    uint32_t("imageArrayLayers", "the number of views in a multiview/stereo surface. For non-stereoscopic-3D applications, this value is 1.")
    VkImageUsageFlags("imageUsage", "a bitmask of {@code VkImageUsageFlagBits} describing the intended usage of the (acquired) swapchain images.")
    VkSharingMode("imageSharingMode", "the sharing mode used for the image(s) of the swapchain.")
    AutoSize("pQueueFamilyIndices", optional = true)..uint32_t("queueFamilyIndexCount", "the number of queue families having access to the image(s) of the swapchain when {@code imageSharingMode} is #SHARING_MODE_CONCURRENT.")
    nullable..uint32_t.const.p("pQueueFamilyIndices", "a pointer to an array of queue family indices having access to the images(s) of the swapchain when {@code imageSharingMode} is #SHARING_MODE_CONCURRENT.")
    VkSurfaceTransformFlagBitsKHR("preTransform", "a {@code VkSurfaceTransformFlagBitsKHR} value describing the transform, relative to the presentation engine’s natural orientation, applied to the image content prior to presentation. If it does not match the {@code currentTransform} value returned by {@code vkGetPhysicalDeviceSurfaceCapabilitiesKHR}, the presentation engine will transform the image content as part of the presentation operation.")
    VkCompositeAlphaFlagBitsKHR("compositeAlpha", "a {@code VkCompositeAlphaFlagBitsKHR} value indicating the alpha compositing mode to use when this surface is composited together with other surfaces on certain window systems.")
    VkPresentModeKHR("presentMode", "the presentation mode the swapchain will use. A swapchain’s present mode determines how incoming present requests will be processed and queued internally.")
    VkBool32("clipped", """specifies whether the Vulkan implementation is allowed to discard rendering operations that affect regions of the surface that are not visible.

        <ul>
            <li>If {@code clipped} is #TRUE, the presentable images associated with the swapchain <b>may</b> not own all of their pixels. Pixels in the presentable images that correspond to regions of the target surface obscured by another window on the desktop, or subject to some other clipping mechanism will have undefined content when read back. Fragment shaders <b>may</b> not execute for these pixels, and thus any side effects they would have had will not occur. Setting #TRUE does not guarantee any clipping will occur, but allows more efficient presentation methods to be used on some platforms.</li>
            <li>
                If {@code clipped} is #FALSE, presentable images associated with the swapchain will own all of the pixels they contain.
                <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
                Applications <b>should</b> set this value to #TRUE if they do not expect to read back the content of presentable images before presenting them or after reacquiring them, and if their fragment shaders do not have any side effects that require them to run for all pixels in the presentable image.
                </div>
            </li>
        </ul>""")
    VkSwapchainKHR("oldSwapchain", """#NULL_HANDLE, or the existing non-retired swapchain currently associated with {@code surface}. Providing a valid {@code oldSwapchain} <b>may</b> aid in the resource reuse, and also allows the application to still present any images that are already acquired from it.

        Upon calling {@code vkCreateSwapchainKHR} with an {@code oldSwapchain} that is not #NULL_HANDLE, {@code oldSwapchain} is retired — even if creation of the new swapchain fails. The new swapchain is created in the non-retired state whether or not {@code oldSwapchain} is #NULL_HANDLE.

        Upon calling {@code vkCreateSwapchainKHR} with an {@code oldSwapchain} that is not #NULL_HANDLE, any images from {@code oldSwapchain} that are not acquired by the application <b>may</b> be freed by the implementation, which <b>may</b> occur even if creation of the new swapchain fails. The application <b>can</b> destroy {@code oldSwapchain} to free all memory associated with {@code oldSwapchain}.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Multiple retired swapchains <b>can</b> be associated with the same {@code VkSurfaceKHR} through multiple uses of {@code oldSwapchain} that outnumber calls to #DestroySwapchainKHR().

        After {@code oldSwapchain} is retired, the application <b>can</b> pass to #QueuePresentKHR() any images it had already acquired from {@code oldSwapchain}. E.g., an application may present an image from the old swapchain before an image from the new swapchain is ready to be presented. As usual, #QueuePresentKHR() <b>may</b> fail if {@code oldSwapchain} has entered a state that causes #ERROR_OUT_OF_DATE_KHR to be returned.

        The application <b>can</b> continue to use a shared presentable image obtained from {@code oldSwapchain} until a presentable image is acquired from the new swapchain, as long as it has not entered a state that causes it to return #ERROR_OUT_OF_DATE_KHR.
        </div>""")
}

val VkPresentInfoKHR = struct(Module.VULKAN, "VkPresentInfoKHR") {
    documentation =
        """
        Structure describing parameters of a queue presentation.

        <h5>Description</h5>
        Before an application <b>can</b> present an image, the image’s layout <b>must</b> be transitioned to the #IMAGE_LAYOUT_PRESENT_SRC_KHR layout, or for a shared presentable image the #IMAGE_LAYOUT_SHARED_PRESENT_KHR layout.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        When transitioning the image to #IMAGE_LAYOUT_SHARED_PRESENT_KHR or #IMAGE_LAYOUT_PRESENT_SRC_KHR, there is no need to delay subsequent processing, or perform any visibility operations (as #QueuePresentKHR() performs automatic visibility operations). To achieve this, the {@code dstAccessMask} member of the ##VkImageMemoryBarrier <b>should</b> be 0, and the {@code dstStageMask} parameter <b>should</b> be #PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>Elements of {@code pSwapchain} <b>must</b> be unique</li>
            <li>Each element of {@code pImageIndices} <b>must</b> be the index of a presentable image acquired from the swapchain specified by the corresponding element of the {@code pSwapchains} array, and the presented image subresource <b>must</b> be in the #IMAGE_LAYOUT_PRESENT_SRC_KHR or #IMAGE_LAYOUT_SHARED_PRESENT_KHR layout at the time the operation is executed on a {@code VkDevice}</li>
            <li>If a ##VkPresentIdKHR structure is included in the {@code pNext} chain, and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-presentId">{@code presentId}</a> feature is not enabled, each {@code presentIds} entry in that structure <b>must</b> be NULL</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-swapchainMaintenance1">{@code swapchainMaintenance1}</a> feature is not enabled, then the {@code pNext} chain <b>must</b> not include a ##VkSwapchainPresentFenceInfoEXT structure</li>
            <li>If any element of the {@code pSwapchains} array has been created with ##VkSwapchainPresentModesCreateInfoEXT, all of the elements of this array <b>must</b> be created with ##VkSwapchainPresentModesCreateInfoEXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PRESENT_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDeviceGroupPresentInfoKHR, ##VkDisplayPresentInfoKHR, ##VkFrameBoundaryEXT, ##VkPresentIdKHR, ##VkPresentRegionsKHR, ##VkPresentTimesInfoGOOGLE, ##VkSwapchainPresentFenceInfoEXT, or ##VkSwapchainPresentModeInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>If {@code waitSemaphoreCount} is not 0, {@code pWaitSemaphores} <b>must</b> be a valid pointer to an array of {@code waitSemaphoreCount} valid {@code VkSemaphore} handles</li>
            <li>{@code pSwapchains} <b>must</b> be a valid pointer to an array of {@code swapchainCount} valid {@code VkSwapchainKHR} handles</li>
            <li>{@code pImageIndices} <b>must</b> be a valid pointer to an array of {@code swapchainCount} {@code uint32_t} values</li>
            <li>If {@code pResults} is not {@code NULL}, {@code pResults} <b>must</b> be a valid pointer to an array of {@code swapchainCount} {@code VkResult} values</li>
            <li>{@code swapchainCount} <b>must</b> be greater than 0</li>
            <li>Both of the elements of {@code pSwapchains}, and the elements of {@code pWaitSemaphores} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #QueuePresentKHR()
        """

    Expression("#STRUCTURE_TYPE_PRESENT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDeviceGroupPresentInfoKHR", "VkDisplayPresentInfoKHR", "VkFrameBoundaryEXT", "VkPresentIdKHR", "VkPresentRegionsKHR", "VkPresentTimesInfoGOOGLE", "VkSwapchainPresentFenceInfoEXT", "VkSwapchainPresentModeInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pWaitSemaphores", optional = true)..uint32_t("waitSemaphoreCount", "the number of semaphores to wait for before issuing the present request. The number <b>may</b> be zero.")
    VkSemaphore.const.p("pWaitSemaphores", "{@code NULL} or a pointer to an array of {@code VkSemaphore} objects with {@code waitSemaphoreCount} entries, and specifies the semaphores to wait for before issuing the present request.")
    AutoSize("pSwapchains", "pImageIndices", "pResults")..uint32_t("swapchainCount", "the number of swapchains being presented to by this command.")
    VkSwapchainKHR.const.p("pSwapchains", "a pointer to an array of {@code VkSwapchainKHR} objects with {@code swapchainCount} entries.")
    uint32_t.const.p("pImageIndices", "a pointer to an array of indices into the array of each swapchain’s presentable images, with {@code swapchainCount} entries. Each entry in this array identifies the image to present on the corresponding entry in the {@code pSwapchains} array.")
    nullable..VkResult.p("pResults", "a pointer to an array of {@code VkResult} typed elements with {@code swapchainCount} entries. Applications that do not need per-swapchain results <b>can</b> use {@code NULL} for {@code pResults}. If non-{@code NULL}, each entry in {@code pResults} will be set to the {@code VkResult} for presenting the swapchain corresponding to the same index in {@code pSwapchains}.")
}

val VkImageSwapchainCreateInfoKHR = struct(Module.VULKAN, "VkImageSwapchainCreateInfoKHR") {
    documentation =
        """
        Specify that an image will be bound to swapchain memory.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code swapchain} is not #NULL_HANDLE, the fields of ##VkImageCreateInfo <b>must</b> match the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#swapchain-wsi-image-create-info">implied image creation parameters</a> of the swapchain</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR</li>
            <li>If {@code swapchain} is not #NULL_HANDLE, {@code swapchain} <b>must</b> be a valid {@code VkSwapchainKHR} handle</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSwapchainKHR("swapchain", "#NULL_HANDLE or a handle of a swapchain that the image will be bound to.")
}

val VkBindImageMemorySwapchainInfoKHR = struct(Module.VULKAN, "VkBindImageMemorySwapchainInfoKHR") {
    documentation =
        """
        Structure specifying swapchain image memory to bind to.

        <h5>Description</h5>
        If {@code swapchain} is not {@code NULL}, the {@code swapchain} and {@code imageIndex} are used to determine the memory that the image is bound to, instead of {@code memory} and {@code memoryOffset}.

        Memory <b>can</b> be bound to a swapchain and use the {@code pDeviceIndices} or {@code pSplitInstanceBindRegions} members of ##VkBindImageMemoryDeviceGroupInfo.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code imageIndex} <b>must</b> be less than the number of images in {@code swapchain}</li>
            <li>If the {@code swapchain} has been created with #SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_EXT, {@code imageIndex} <b>must</b> be one that has previously been returned by #AcquireNextImageKHR() or #AcquireNextImage2KHR()</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR</li>
            <li>{@code swapchain} <b>must</b> be a valid {@code VkSwapchainKHR} handle</li>
        </ul>

        <h5>Host Synchronization</h5>
        <ul>
            <li>Host access to {@code swapchain} <b>must</b> be externally synchronized</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSwapchainKHR("swapchain", "#NULL_HANDLE or a swapchain handle.")
    uint32_t("imageIndex", "an image index within {@code swapchain}.")
}

val VkAcquireNextImageInfoKHR = struct(Module.VULKAN, "VkAcquireNextImageInfoKHR") {
    documentation =
        """
        Structure specifying parameters of the acquire.

        <h5>Description</h5>
        If #AcquireNextImageKHR() is used, the device mask is considered to include all physical devices in the logical device.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        #AcquireNextImage2KHR() signals at most one semaphore, even if the application requests waiting for multiple physical devices to be ready via the {@code deviceMask}. However, only a single physical device <b>can</b> wait on that semaphore, since the semaphore becomes unsignaled when the wait succeeds. For other physical devices to wait for the image to be ready, it is necessary for the application to submit semaphore signal operation(s) to that first physical device to signal additional semaphore(s) after the wait succeeds, which the other physical device(s) <b>can</b> wait upon.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code swapchain} <b>must</b> not be in the retired state</li>
            <li>If {@code semaphore} is not #NULL_HANDLE, it <b>must</b> be unsignaled</li>
            <li>If {@code semaphore} is not #NULL_HANDLE, it <b>must</b> not have any uncompleted signal or wait operations pending</li>
            <li>If {@code fence} is not #NULL_HANDLE, {@code fence} <b>must</b> be unsignaled</li>
            <li>If {@code fence} is not #NULL_HANDLE, {@code fence} <b>must</b> not be associated with any other queue command that has not yet completed execution on that queue</li>
            <li>{@code semaphore} and {@code fence} <b>must</b> not both be equal to #NULL_HANDLE</li>
            <li>{@code deviceMask} <b>must</b> be a valid device mask</li>
            <li>{@code deviceMask} <b>must</b> not be zero</li>
            <li>{@code semaphore} <b>must</b> have a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_BINARY</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code swapchain} <b>must</b> be a valid {@code VkSwapchainKHR} handle</li>
            <li>If {@code semaphore} is not #NULL_HANDLE, {@code semaphore} <b>must</b> be a valid {@code VkSemaphore} handle</li>
            <li>If {@code fence} is not #NULL_HANDLE, {@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
            <li>Each of {@code fence}, {@code semaphore}, and {@code swapchain} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>Host Synchronization</h5>
        <ul>
            <li>Host access to {@code swapchain} <b>must</b> be externally synchronized</li>
            <li>Host access to {@code semaphore} <b>must</b> be externally synchronized</li>
            <li>Host access to {@code fence} <b>must</b> be externally synchronized</li>
        </ul>

        <h5>See Also</h5>
        #AcquireNextImage2KHR()
        """

    Expression("#STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSwapchainKHR("swapchain", "a non-retired swapchain from which an image is acquired.")
    uint64_t("timeout", "specifies how long the function waits, in nanoseconds, if no image is available.")
    VkSemaphore("semaphore", "#NULL_HANDLE or a semaphore to signal.")
    VkFence("fence", "#NULL_HANDLE or a fence to signal.")
    uint32_t("deviceMask", "a mask of physical devices for which the swapchain image will be ready to use when the semaphore or fence is signaled.")
}

val VkDeviceGroupPresentCapabilitiesKHR = struct(Module.VULKAN, "VkDeviceGroupPresentCapabilitiesKHR", mutable = false) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation =
        """
        Present capabilities from other physical devices.

        <h5>Description</h5>
        {@code modes} always has #DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR set.

        The present mode flags are also used when presenting an image, in ##VkDeviceGroupPresentInfoKHR{@code ::mode}.

        If a device group only includes a single physical device, then {@code modes} <b>must</b> equal #DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetDeviceGroupPresentCapabilitiesKHR()
        """

    Expression("#STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("presentMask", "an array of #MAX_DEVICE_GROUP_SIZE {@code uint32_t} masks, where the mask at element <code>i</code> is non-zero if physical device <code>i</code> has a presentation engine, and where bit <code>j</code> is set in element <code>i</code> if physical device <code>i</code> <b>can</b> present swapchain images from physical device <code>j</code>. If element <code>i</code> is non-zero, then bit <code>i</code> <b>must</b> be set.")["VK_MAX_DEVICE_GROUP_SIZE"]
    VkDeviceGroupPresentModeFlagsKHR("modes", "a bitmask of {@code VkDeviceGroupPresentModeFlagBitsKHR} indicating which device group presentation modes are supported.")
}

val VkDeviceGroupPresentInfoKHR = struct(Module.VULKAN, "VkDeviceGroupPresentInfoKHR") {
    documentation =
        """
        Mode and mask controlling which physical devices' images are presented.

        <h5>Description</h5>
        If {@code mode} is #DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR, then each element of {@code pDeviceMasks} selects which instance of the swapchain image is presented. Each element of {@code pDeviceMasks} <b>must</b> have exactly one bit set, and the corresponding physical device <b>must</b> have a presentation engine as reported by ##VkDeviceGroupPresentCapabilitiesKHR.

        If {@code mode} is #DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR, then each element of {@code pDeviceMasks} selects which instance of the swapchain image is presented. Each element of {@code pDeviceMasks} <b>must</b> have exactly one bit set, and some physical device in the logical device <b>must</b> include that bit in its ##VkDeviceGroupPresentCapabilitiesKHR{@code ::presentMask}.

        If {@code mode} is #DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR, then each element of {@code pDeviceMasks} selects which instances of the swapchain image are component-wise summed and the sum of those images is presented. If the sum in any component is outside the representable range, the value of that component is undefined. Each element of {@code pDeviceMasks} <b>must</b> have a value for which all set bits are set in one of the elements of ##VkDeviceGroupPresentCapabilitiesKHR{@code ::presentMask}.

        If {@code mode} is #DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR, then each element of {@code pDeviceMasks} selects which instance(s) of the swapchain images are presented. For each bit set in each element of {@code pDeviceMasks}, the corresponding physical device <b>must</b> have a presentation engine as reported by ##VkDeviceGroupPresentCapabilitiesKHR.

        If ##VkDeviceGroupPresentInfoKHR is not provided or {@code swapchainCount} is zero then the masks are considered to be 1. If ##VkDeviceGroupPresentInfoKHR is not provided, {@code mode} is considered to be #DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code swapchainCount} <b>must</b> equal 0 or ##VkPresentInfoKHR{@code ::swapchainCount}</li>
            <li>If {@code mode} is #DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR, then each element of {@code pDeviceMasks} <b>must</b> have exactly one bit set, and the corresponding element of ##VkDeviceGroupPresentCapabilitiesKHR{@code ::presentMask} <b>must</b> be non-zero</li>
            <li>If {@code mode} is #DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR, then each element of {@code pDeviceMasks} <b>must</b> have exactly one bit set, and some physical device in the logical device <b>must</b> include that bit in its ##VkDeviceGroupPresentCapabilitiesKHR{@code ::presentMask}</li>
            <li>If {@code mode} is #DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR, then each element of {@code pDeviceMasks} <b>must</b> have a value for which all set bits are set in one of the elements of ##VkDeviceGroupPresentCapabilitiesKHR{@code ::presentMask}</li>
            <li>If {@code mode} is #DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR, then for each bit set in each element of {@code pDeviceMasks}, the corresponding element of ##VkDeviceGroupPresentCapabilitiesKHR{@code ::presentMask} <b>must</b> be non-zero</li>
            <li>The value of each element of {@code pDeviceMasks} <b>must</b> be equal to the device mask passed in ##VkAcquireNextImageInfoKHR{@code ::deviceMask} when the image index was last acquired</li>
            <li>{@code mode} <b>must</b> have exactly one bit set, and that bit <b>must</b> have been included in ##VkDeviceGroupSwapchainCreateInfoKHR{@code ::modes}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR</li>
            <li>If {@code swapchainCount} is not 0, {@code pDeviceMasks} <b>must</b> be a valid pointer to an array of {@code swapchainCount} {@code uint32_t} values</li>
            <li>{@code mode} <b>must</b> be a valid {@code VkDeviceGroupPresentModeFlagBitsKHR} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pDeviceMasks", optional = true)..uint32_t("swapchainCount", "zero or the number of elements in {@code pDeviceMasks}.")
    uint32_t.const.p("pDeviceMasks", "a pointer to an array of device masks, one for each element of ##VkPresentInfoKHR{@code ::pSwapchains}.")
    VkDeviceGroupPresentModeFlagBitsKHR("mode", "a {@code VkDeviceGroupPresentModeFlagBitsKHR} value specifying the device group present mode that will be used for this present.")
}

val VkDeviceGroupSwapchainCreateInfoKHR = struct(Module.VULKAN, "VkDeviceGroupSwapchainCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created swapchain object.

        <h5>Description</h5>
        If this structure is not present, {@code modes} is considered to be #DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR</li>
            <li>{@code modes} <b>must</b> be a valid combination of {@code VkDeviceGroupPresentModeFlagBitsKHR} values</li>
            <li>{@code modes} <b>must</b> not be 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceGroupPresentModeFlagsKHR("modes", "a bitfield of modes that the swapchain <b>can</b> be used with.")
}

val VkDisplayModeParametersKHR = struct(Module.VULKAN, "VkDisplayModeParametersKHR") {
    documentation =
        """
        Structure describing display parameters associated with a display mode.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        For example, a 60Hz display mode would report a {@code refreshRate} of 60,000.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code width} member of {@code visibleRegion} <b>must</b> be greater than 0</li>
            <li>The {@code height} member of {@code visibleRegion} <b>must</b> be greater than 0</li>
            <li>{@code refreshRate} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkDisplayModeCreateInfoKHR, ##VkDisplayModePropertiesKHR, ##VkExtent2D
        """

    VkExtent2D("visibleRegion", "the 2D extents of the visible region.")
    uint32_t("refreshRate", "a {@code uint32_t} that is the number of times the display is refreshed each second multiplied by 1000.")
}

val VkDisplayModeCreateInfoKHR = struct(Module.VULKAN, "VkDisplayModeCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created display mode object.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code parameters} <b>must</b> be a valid ##VkDisplayModeParametersKHR structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkDisplayModeParametersKHR, #CreateDisplayModeKHR()
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDisplayModeCreateFlagsKHR("flags", "reserved for future use, and <b>must</b> be zero.")
    VkDisplayModeParametersKHR("parameters", "a ##VkDisplayModeParametersKHR structure describing the display parameters to use in creating the new mode. If the parameters are not compatible with the specified display, the implementation <b>must</b> return #ERROR_INITIALIZATION_FAILED.")
}

val VkDisplayModePropertiesKHR = struct(Module.VULKAN, "VkDisplayModePropertiesKHR", mutable = false) {
    documentation =
        """
        Structure describing display mode properties.

        <h5>See Also</h5>
        ##VkDisplayModeParametersKHR, ##VkDisplayModeProperties2KHR, #GetDisplayModePropertiesKHR()
        """

    VkDisplayModeKHR("displayMode", "a handle to the display mode described in this structure. This handle will be valid for the lifetime of the Vulkan instance.")
    VkDisplayModeParametersKHR("parameters", "a ##VkDisplayModeParametersKHR structure describing the display parameters associated with {@code displayMode}.")
}

val VkDisplayPlaneCapabilitiesKHR = struct(Module.VULKAN, "VkDisplayPlaneCapabilitiesKHR", mutable = false) {
    documentation =
        """
        Structure describing capabilities of a mode and plane combination.

        <h5>Description</h5>
        The minimum and maximum position and extent fields describe the implementation limits, if any, as they apply to the specified display mode and plane. Vendors <b>may</b> support displaying a subset of a swapchain’s presentable images on the specified display plane. This is expressed by returning {@code minSrcPosition}, {@code maxSrcPosition}, {@code minSrcExtent}, and {@code maxSrcExtent} values that indicate a range of possible positions and sizes which <b>may</b> be used to specify the region within the presentable images that source pixels will be read from when creating a swapchain on the specified display mode and plane.

        Vendors <b>may</b> also support mapping the presentable images’ content to a subset or superset of the visible region in the specified display mode. This is expressed by returning {@code minDstPosition}, {@code maxDstPosition}, {@code minDstExtent} and {@code maxDstExtent} values that indicate a range of possible positions and sizes which <b>may</b> be used to describe the region within the display mode that the source pixels will be mapped to.

        Other vendors <b>may</b> support only a 1-1 mapping between pixels in the presentable images and the display mode. This <b>may</b> be indicated by returning <code>(0,0)</code> for {@code minSrcPosition}, {@code maxSrcPosition}, {@code minDstPosition}, and {@code maxDstPosition}, and (display mode width, display mode height) for {@code minSrcExtent}, {@code maxSrcExtent}, {@code minDstExtent}, and {@code maxDstExtent}.

        The value {@code supportedAlpha} <b>must</b> contain at least one valid {@code VkDisplayPlaneAlphaFlagBitsKHR} bit.

        These values indicate the limits of the implementation’s individual fields. Not all combinations of values within the offset and extent ranges returned in ##VkDisplayPlaneCapabilitiesKHR are guaranteed to be supported. Presentation requests specifying unsupported combinations <b>may</b> fail.

        <h5>See Also</h5>
        ##VkDisplayPlaneCapabilities2KHR, ##VkExtent2D, ##VkOffset2D, #GetDisplayPlaneCapabilitiesKHR()
        """

    VkDisplayPlaneAlphaFlagsKHR("supportedAlpha", "a bitmask of {@code VkDisplayPlaneAlphaFlagBitsKHR} describing the supported alpha blending modes.")
    VkOffset2D("minSrcPosition", "the minimum source rectangle offset supported by this plane using the specified mode.")
    VkOffset2D("maxSrcPosition", "the maximum source rectangle offset supported by this plane using the specified mode. The {@code x} and {@code y} components of {@code maxSrcPosition} <b>must</b> each be greater than or equal to the {@code x} and {@code y} components of {@code minSrcPosition}, respectively.")
    VkExtent2D("minSrcExtent", "the minimum source rectangle size supported by this plane using the specified mode.")
    VkExtent2D("maxSrcExtent", "the maximum source rectangle size supported by this plane using the specified mode.")
    VkOffset2D("minDstPosition", "{@code minDstPosition}, {@code maxDstPosition}, {@code minDstExtent}, {@code maxDstExtent} all have similar semantics to their corresponding {@code *Src*} equivalents, but apply to the output region within the mode rather than the input region within the source image. Unlike the {@code *Src*} offsets, {@code minDstPosition} and {@code maxDstPosition} <b>may</b> contain negative values.")
    VkOffset2D("maxDstPosition", "see {@code minDstPosition}")
    VkExtent2D("minDstExtent", "see {@code minDstPosition}")
    VkExtent2D("maxDstExtent", "see {@code minDstPosition}")
}

val VkDisplayPlanePropertiesKHR = struct(Module.VULKAN, "VkDisplayPlanePropertiesKHR", mutable = false) {
    documentation =
        """
        Structure describing display plane properties.

        <h5>See Also</h5>
        ##VkDisplayPlaneProperties2KHR, #GetPhysicalDeviceDisplayPlanePropertiesKHR()
        """

    VkDisplayKHR("currentDisplay", "the handle of the display the plane is currently associated with. If the plane is not currently attached to any displays, this will be #NULL_HANDLE.")
    uint32_t("currentStackIndex", "the current z-order of the plane. This will be between 0 and the value returned by {@code vkGetPhysicalDeviceDisplayPlanePropertiesKHR} in {@code pPropertyCount}.")
}

val VkDisplayPropertiesKHR = struct(Module.VULKAN, "VkDisplayPropertiesKHR", mutable = false) {
    documentation =
        """
        Structure describing an available display device.

        <h5>See Also</h5>
        ##VkDisplayProperties2KHR, ##VkExtent2D, #GetPhysicalDeviceDisplayPropertiesKHR()
        """

    VkDisplayKHR("display", "a handle that is used to refer to the display described here. This handle will be valid for the lifetime of the Vulkan instance.")
    charUTF8.const.p("displayName", "{@code NULL} or a pointer to a null-terminated UTF-8 string containing the name of the display. Generally, this will be the name provided by the display’s EDID. If {@code NULL}, no suitable name is available. If not {@code NULL}, the string pointed to <b>must</b> remain accessible and unmodified as long as {@code display} is valid.")
    VkExtent2D("physicalDimensions", "describes the physical width and height of the visible portion of the display, in millimeters.")
    VkExtent2D("physicalResolution", """describes the physical, native, or preferred resolution of the display.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        For devices which have no natural value to return here, implementations <b>should</b> return the maximum resolution supported.
        </div>""")
    VkSurfaceTransformFlagsKHR("supportedTransforms", "a bitmask of {@code VkSurfaceTransformFlagBitsKHR} describing which transforms are supported by this display.")
    VkBool32("planeReorderPossible", "tells whether the planes on this display <b>can</b> have their z order changed. If this is #TRUE, the application <b>can</b> re-arrange the planes on this display in any order relative to each other.")
    VkBool32("persistentContent", """tells whether the display supports self-refresh/internal buffering. If this is true, the application <b>can</b> submit persistent present operations on swapchains created against this display.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Persistent presents <b>may</b> have higher latency, and <b>may</b> use less power when the screen content is updated infrequently, or when only a portion of the screen needs to be updated in most frames.
        </div>""")
}

val VkDisplaySurfaceCreateInfoKHR = struct(Module.VULKAN, "VkDisplaySurfaceCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created display plane surface object.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Creating a display surface <b>must</b> not modify the state of the displays, planes, or other resources it names. For example, it <b>must</b> not apply the specified mode to be set on the associated display. Application of display configuration occurs as a side effect of presenting to a display surface.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code planeIndex} <b>must</b> be less than the number of display planes supported by the device as determined by calling {@code vkGetPhysicalDeviceDisplayPlanePropertiesKHR}</li>
            <li>If the {@code planeReorderPossible} member of the ##VkDisplayPropertiesKHR structure returned by {@code vkGetPhysicalDeviceDisplayPropertiesKHR} for the display corresponding to {@code displayMode} is #TRUE then {@code planeStackIndex} <b>must</b> be less than the number of display planes supported by the device as determined by calling {@code vkGetPhysicalDeviceDisplayPlanePropertiesKHR}; otherwise {@code planeStackIndex} <b>must</b> equal the {@code currentStackIndex} member of ##VkDisplayPlanePropertiesKHR returned by {@code vkGetPhysicalDeviceDisplayPlanePropertiesKHR} for the display plane corresponding to {@code displayMode}</li>
            <li>If {@code alphaMode} is #DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR then {@code globalAlpha} <b>must</b> be between 0 and 1, inclusive</li>
            <li>{@code alphaMode} <b>must</b> be one of the bits present in the {@code supportedAlpha} member of ##VkDisplayPlaneCapabilitiesKHR for the display plane corresponding to {@code displayMode}</li>
            <li>{@code transform} <b>must</b> be one of the bits present in the {@code supportedTransforms} member of ##VkDisplayPropertiesKHR for the display corresponding to {@code displayMode}</li>
            <li>The {@code width} and {@code height} members of {@code imageExtent} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxImageDimension2D}</li>
            <li>If the {@code pNext} chain includes a ##VkDisplaySurfaceStereoCreateInfoNV structure whose {@code stereoType} member is #DISPLAY_SURFACE_STEREO_TYPE_HDMI_3D_NV, then the {@code hdmi3DSupported} member of the ##VkDisplayModeStereoPropertiesNV structure in the {@code pNext} chain of the ##VkDisplayModeProperties2KHR structure returned by #GetDisplayModeProperties2KHR() for the display mode corresponding to {@code displayMode} <b>must</b> be #TRUE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkDisplaySurfaceStereoCreateInfoNV</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code displayMode} <b>must</b> be a valid {@code VkDisplayModeKHR} handle</li>
            <li>{@code transform} <b>must</b> be a valid {@code VkSurfaceTransformFlagBitsKHR} value</li>
            <li>{@code alphaMode} <b>must</b> be a valid {@code VkDisplayPlaneAlphaFlagBitsKHR} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D, #CreateDisplayPlaneSurfaceKHR()
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDisplaySurfaceStereoCreateInfoNV",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDisplaySurfaceCreateFlagsKHR("flags", "reserved for future use, and <b>must</b> be zero.")
    VkDisplayModeKHR("displayMode", "a {@code VkDisplayModeKHR} handle specifying the mode to use when displaying this surface.")
    uint32_t("planeIndex", "the plane on which this surface appears.")
    uint32_t("planeStackIndex", "the z-order of the plane.")
    VkSurfaceTransformFlagBitsKHR("transform", "a {@code VkSurfaceTransformFlagBitsKHR} value specifying the transformation to apply to images as part of the scanout operation.")
    float("globalAlpha", "the global alpha value. This value is ignored if {@code alphaMode} is not #DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR.")
    VkDisplayPlaneAlphaFlagBitsKHR("alphaMode", "a {@code VkDisplayPlaneAlphaFlagBitsKHR} value specifying the type of alpha blending to use.")
    VkExtent2D("imageExtent", "the size of the presentable images to use with the surface.")
}

val VkDisplayPresentInfoKHR = struct(Module.VULKAN, "VkDisplayPresentInfoKHR") {
    documentation =
        """
        Structure describing parameters of a queue presentation to a swapchain.

        <h5>Description</h5>
        If the extent of the {@code srcRect} and {@code dstRect} are not equal, the presented pixels will be scaled accordingly.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code srcRect} <b>must</b> specify a rectangular region that is a subset of the image being presented</li>
            <li>{@code dstRect} <b>must</b> specify a rectangular region that is a subset of the {@code visibleRegion} parameter of the display mode the swapchain being presented uses</li>
            <li>If the {@code persistentContent} member of the ##VkDisplayPropertiesKHR structure returned by {@code vkGetPhysicalDeviceDisplayPropertiesKHR} for the display the present operation targets is #FALSE, then {@code persistent} <b>must</b> be #FALSE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR</li>
        </ul>

        <h5>See Also</h5>
        ##VkRect2D
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkRect2D("srcRect", "a rectangular region of pixels to present. It <b>must</b> be a subset of the image being presented. If ##VkDisplayPresentInfoKHR is not specified, this region will be assumed to be the entire presentable image.")
    VkRect2D("dstRect", "a rectangular region within the visible region of the swapchain’s display mode. If ##VkDisplayPresentInfoKHR is not specified, this region will be assumed to be the entire visible region of the swapchain’s mode. If the specified rectangle is a subset of the display mode’s visible region, content from display planes below the swapchain’s plane will be visible outside the rectangle. If there are no planes below the swapchain’s, the area outside the specified rectangle will be black. If portions of the specified rectangle are outside of the display’s visible region, pixels mapping only to those portions of the rectangle will be discarded.")
    VkBool32("persistent", "If this is #TRUE, the display engine will enable buffered mode on displays that support it. This allows the display engine to stop sending content to the display until a new image is presented. The display will instead maintain a copy of the last presented image. This allows less power to be used, but <b>may</b> increase presentation latency. If ##VkDisplayPresentInfoKHR is not specified, persistent mode will not be used.")
}

val VkXlibSurfaceCreateInfoKHR = struct(Module.VULKAN, "VkXlibSurfaceCreateInfoKHR") {
    javaImport("org.lwjgl.system.linux.*")
    documentation =
        """
        Structure specifying parameters of a newly created Xlib surface object.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code dpy} <b>must</b> point to a valid Xlib {@code Display}</li>
            <li>{@code window} <b>must</b> be a valid Xlib {@code Window}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CreateXlibSurfaceKHR()
        """

    Expression("#STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkXlibSurfaceCreateFlagsKHR("flags", "reserved for future use.")
    nullable..Display.p("dpy", "a pointer to an Xlib {@code Display} connection to the X server.")
    Window("window", "an Xlib {@code Window} to associate the surface with.")
}

val VkXcbSurfaceCreateInfoKHR = struct(Module.VULKAN, "VkXcbSurfaceCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created Xcb surface object.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code connection} <b>must</b> point to a valid X11 {@code xcb_connection_t}</li>
            <li>{@code window} <b>must</b> be a valid X11 {@code xcb_window_t}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CreateXcbSurfaceKHR()
        """

    Expression("#STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkXcbSurfaceCreateFlagsKHR("flags", "reserved for future use.")
    nullable..xcb_connection_t.p("connection", "a pointer to an {@code xcb_connection_t} to the X server.")
    xcb_window_t("window", "the {@code xcb_window_t} for the X11 window to associate the surface with.")
}

val VkWaylandSurfaceCreateInfoKHR = struct(Module.VULKAN, "VkWaylandSurfaceCreateInfoKHR") {
    javaImport("org.lwjgl.system.linux.*")
    documentation =
        """
        Structure specifying parameters of a newly created Wayland surface object.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code display} <b>must</b> point to a valid Wayland {@code wl_display}</li>
            <li>{@code surface} <b>must</b> point to a valid Wayland {@code wl_surface}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CreateWaylandSurfaceKHR()
        """

    Expression("#STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkWaylandSurfaceCreateFlagsKHR("flags", "reserved for future use.")
    nullable..wl_display.p("display", "{@code display} and {@code surface} are pointers to the Wayland {@code wl_display} and {@code wl_surface} to associate the surface with.")
    nullable..wl_surface.p("surface", "see {@code display}")
}

val VkAndroidSurfaceCreateInfoKHR = struct(Module.VULKAN, "VkAndroidSurfaceCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created Android surface object.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code window} <b>must</b> point to a valid Android {@code ANativeWindow}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CreateAndroidSurfaceKHR()
        """

    Expression("#STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAndroidSurfaceCreateFlagsKHR("flags", "reserved for future use.")
    nullable..ANativeWindow.p("window", "a pointer to the {@code ANativeWindow} to associate the surface with.")
}

val VkWin32SurfaceCreateInfoKHR = struct(Module.VULKAN, "VkWin32SurfaceCreateInfoKHR") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        Structure specifying parameters of a newly created Win32 surface object.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code hinstance} <b>must</b> be a valid Win32 {@code HINSTANCE}</li>
            <li>{@code hwnd} <b>must</b> be a valid Win32 {@code HWND}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CreateWin32SurfaceKHR()
        """

    Expression("#STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkWin32SurfaceCreateFlagsKHR("flags", "reserved for future use.")
    HINSTANCE("hinstance", "the Win32 {@code HINSTANCE} for the window to associate the surface with.")
    HWND("hwnd", "the Win32 {@code HWND} for the window to associate the surface with.")
}

val VkDebugReportCallbackCreateInfoEXT = struct(Module.VULKAN, "VkDebugReportCallbackCreateInfoEXT") {
    documentation =
        """
        Structure specifying parameters of a newly created debug report callback.

        <h5>Description</h5>
        For each {@code VkDebugReportCallbackEXT} that is created the ##VkDebugReportCallbackCreateInfoEXT{@code ::flags} determine when that ##VkDebugReportCallbackCreateInfoEXT{@code ::pfnCallback} is called. When an event happens, the implementation will do a bitwise AND of the event’s {@code VkDebugReportFlagBitsEXT} flags to each {@code VkDebugReportCallbackEXT} object’s flags. For each non-zero result the corresponding callback will be called. The callback will come directly from the component that detected the event, unless some other layer intercepts the calls for its own purposes (filter them in a different way, log to a system error log, etc.).

        An application <b>may</b> receive multiple callbacks if multiple {@code VkDebugReportCallbackEXT} objects were created. A callback will always be executed in the same thread as the originating Vulkan call.

        A callback may be called from multiple threads simultaneously (if the application is making Vulkan calls from multiple threads).

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkDebugReportFlagBitsEXT} values</li>
            <li>{@code pfnCallback} <b>must</b> be a valid ##VkDebugReportCallbackEXT value</li>
        </ul>

        <h5>See Also</h5>
        ##VkDebugReportCallbackEXT, #CreateDebugReportCallbackEXT()
        """

    Expression("#STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDebugReportFlagsEXT("flags", "a bitmask of {@code VkDebugReportFlagBitsEXT} specifying which event(s) will cause this callback to be called.")
    PFN_vkDebugReportCallbackEXT("pfnCallback", "the application callback function to call.")
    nullable..opaque_p("pUserData", "user data to be passed to the callback.")
}

val VkPipelineRasterizationStateRasterizationOrderAMD = struct(Module.VULKAN, "VkPipelineRasterizationStateRasterizationOrderAMD") {
    documentation =
        """
        Structure defining rasterization order for a graphics pipeline.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD</li>
            <li>{@code rasterizationOrder} <b>must</b> be a valid {@code VkRasterizationOrderAMD} value</li>
        </ul>

        If the {@link AMDRasterizationOrder VK_AMD_rasterization_order} device extension is not enabled or the application does not request a particular rasterization order through specifying a ##VkPipelineRasterizationStateRasterizationOrderAMD structure then the rasterization order used by the graphics pipeline defaults to #RASTERIZATION_ORDER_STRICT_AMD.
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkRasterizationOrderAMD("rasterizationOrder", "a {@code VkRasterizationOrderAMD} value specifying the primitive rasterization order to use.")
}

val VkDebugMarkerObjectNameInfoEXT = struct(Module.VULKAN, "VkDebugMarkerObjectNameInfoEXT") {
    documentation =
        """
        Specify parameters of a name to give to an object.

        <h5>Description</h5>
        Applications <b>may</b> change the name associated with an object simply by calling {@code vkDebugMarkerSetObjectNameEXT} again with a new string. To remove a previously set name, {@code pObjectName} <b>should</b> be an empty string.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code objectType} <b>must</b> not be #DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT</li>
            <li>{@code object} <b>must</b> not be #NULL_HANDLE</li>
            <li>{@code object} <b>must</b> be a Vulkan object of the type associated with {@code objectType} as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#debug-report-object-types">{@code VkDebugReportObjectTypeEXT} and Vulkan Handle Relationship</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code objectType} <b>must</b> be a valid {@code VkDebugReportObjectTypeEXT} value</li>
            <li>{@code pObjectName} <b>must</b> be a null-terminated UTF-8 string</li>
        </ul>

        <h5>See Also</h5>
        #DebugMarkerSetObjectNameEXT()
        """

    Expression("#STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDebugReportObjectTypeEXT("objectType", "a {@code VkDebugReportObjectTypeEXT} specifying the type of the object to be named.")
    uint64_t("object", "the object to be named.")
    charUTF8.const.p("pObjectName", "a null-terminated UTF-8 string specifying the name to apply to {@code object}.")
}

val VkDebugMarkerObjectTagInfoEXT = struct(Module.VULKAN, "VkDebugMarkerObjectTagInfoEXT") {
    documentation =
        """
        Specify parameters of a tag to attach to an object.

        <h5>Description</h5>
        The {@code tagName} parameter gives a name or identifier to the type of data being tagged. This can be used by debugging layers to easily filter for only data that can be used by that implementation.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code objectType} <b>must</b> not be #DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT</li>
            <li>{@code object} <b>must</b> not be #NULL_HANDLE</li>
            <li>{@code object} <b>must</b> be a Vulkan object of the type associated with {@code objectType} as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#debug-report-object-types">{@code VkDebugReportObjectTypeEXT} and Vulkan Handle Relationship</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code objectType} <b>must</b> be a valid {@code VkDebugReportObjectTypeEXT} value</li>
            <li>{@code pTag} <b>must</b> be a valid pointer to an array of {@code tagSize} bytes</li>
            <li>{@code tagSize} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        #DebugMarkerSetObjectTagEXT()
        """

    Expression("#STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDebugReportObjectTypeEXT("objectType", "a {@code VkDebugReportObjectTypeEXT} specifying the type of the object to be named.")
    uint64_t("object", "the object to be tagged.")
    uint64_t("tagName", "a numerical identifier of the tag.")
    AutoSize("pTag")..size_t("tagSize", "the number of bytes of data to attach to the object.")
    void.const.p("pTag", "a pointer to an array of {@code tagSize} bytes containing the data to be associated with the object.")
}

val VkDebugMarkerMarkerInfoEXT = struct(Module.VULKAN, "VkDebugMarkerMarkerInfoEXT") {
    documentation =
        """
        Specify parameters of a command buffer marker region.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code pMarkerName} <b>must</b> be a null-terminated UTF-8 string</li>
        </ul>

        <h5>See Also</h5>
        #CmdDebugMarkerBeginEXT(), #CmdDebugMarkerInsertEXT()
        """

    Expression("#STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    charUTF8.const.p("pMarkerName", "a pointer to a null-terminated UTF-8 string containing the name of the marker.")
    float("color", "an <b>optional</b> RGBA color value that can be associated with the marker. A particular implementation <b>may</b> choose to ignore this color value. The values contain RGBA values in order, in the range 0.0 to 1.0. If all elements in {@code color} are 0.0, then it is ignored.")[4]
}

val VkQueueFamilyQueryResultStatusPropertiesKHR = struct(Module.VULKAN, "VkQueueFamilyQueryResultStatusPropertiesKHR", mutable = false) {
    documentation =
        """
        Structure specifying support for result status query.

        <h5>Description</h5>
        If this structure is included in the {@code pNext} chain of the ##VkQueueFamilyProperties2 structure passed to #GetPhysicalDeviceQueueFamilyProperties2(), then it is filled with information about whether <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#queries-result-status-only">result status queries</a> are supported by the specified queue family.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkBool32("queryResultStatusSupport", "reports #TRUE if query type #QUERY_TYPE_RESULT_STATUS_ONLY_KHR and use of #QUERY_RESULT_WITH_STATUS_BIT_KHR are supported.")
}

val VkQueueFamilyVideoPropertiesKHR = struct(Module.VULKAN, "VkQueueFamilyVideoPropertiesKHR", mutable = false) {
    documentation =
        """
        Structure describing video codec operations supported by a queue family.

        <h5>Description</h5>
        If this structure is included in the {@code pNext} chain of the ##VkQueueFamilyProperties2 structure passed to #GetPhysicalDeviceQueueFamilyProperties2(), then it is filled with the set of video codec operations supported by the specified queue family.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkVideoCodecOperationFlagsKHR("videoCodecOperations", "a bitmask of {@code VkVideoCodecOperationFlagBitsKHR} that indicates the set of video codec operations supported by the queue family.")
}

val VkVideoProfileInfoKHR = struct(Module.VULKAN, "VkVideoProfileInfoKHR") {
    documentation =
        """
        Structure specifying a video profile.

        <h5>Description</h5>
        Video profiles are provided as input to video capability queries such as #GetPhysicalDeviceVideoCapabilitiesKHR() or #GetPhysicalDeviceVideoFormatPropertiesKHR(), as well as when creating resources to be used by video coding operations such as images, buffers, query pools, and video sessions.

        The full description of a video profile is specified by an instance of this structure, and the codec-specific and auxiliary structures provided in its {@code pNext} chain.

        When this structure is specified as an input parameter to #GetPhysicalDeviceVideoCapabilitiesKHR(), or through the {@code pProfiles} member of a ##VkVideoProfileListInfoKHR structure in the {@code pNext} chain of the input parameter of a query command such as #GetPhysicalDeviceVideoFormatPropertiesKHR() or #GetPhysicalDeviceImageFormatProperties2(), the following error codes indicate specific causes of the failure of the query operation:

        <ul>
            <li>#ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR specifies that the requested video picture layout (e.g. through the {@code pictureLayout} member of a ##VkVideoDecodeH264ProfileInfoKHR structure included in the {@code pNext} chain of ##VkVideoProfileInfoKHR) is not supported.</li>
            <li>#ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR specifies that a video profile operation specified by {@code videoCodecOperation} is not supported.</li>
            <li>#ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR specifies that video format parameters specified by {@code chromaSubsampling}, {@code lumaBitDepth}, or {@code chromaBitDepth} are not supported.</li>
            <li>#ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR specifies that the codec-specific parameters corresponding to the video codec operation are not supported.</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code chromaSubsampling} <b>must</b> have a single bit set</li>
            <li>{@code lumaBitDepth} <b>must</b> have a single bit set</li>
            <li>If {@code chromaSubsampling} is not #VIDEO_CHROMA_SUBSAMPLING_MONOCHROME_BIT_KHR, then {@code chromaBitDepth} <b>must</b> have a single bit set</li>
            <li>If {@code videoCodecOperation} is #VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoDecodeH264ProfileInfoKHR structure</li>
            <li>If {@code videoCodecOperation} is #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoDecodeH265ProfileInfoKHR structure</li>
            <li>If {@code videoCodecOperation} is #VIDEO_CODEC_OPERATION_DECODE_AV1_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoDecodeAV1ProfileInfoKHR structure</li>
            <li>If {@code videoCodecOperation} is #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoEncodeH264ProfileInfoKHR structure</li>
            <li>If {@code videoCodecOperation} is #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoEncodeH265ProfileInfoKHR structure</li>
            <li>If {@code videoCodecOperation} is #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoEncodeAV1ProfileInfoKHR structure</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR</li>
            <li>{@code videoCodecOperation} <b>must</b> be a valid {@code VkVideoCodecOperationFlagBitsKHR} value</li>
            <li>{@code chromaSubsampling} <b>must</b> be a valid combination of {@code VkVideoChromaSubsamplingFlagBitsKHR} values</li>
            <li>{@code chromaSubsampling} <b>must</b> not be 0</li>
            <li>{@code lumaBitDepth} <b>must</b> be a valid combination of {@code VkVideoComponentBitDepthFlagBitsKHR} values</li>
            <li>{@code lumaBitDepth} <b>must</b> not be 0</li>
            <li>{@code chromaBitDepth} <b>must</b> be a valid combination of {@code VkVideoComponentBitDepthFlagBitsKHR} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR, ##VkVideoProfileListInfoKHR, ##VkVideoSessionCreateInfoKHR, #GetPhysicalDeviceVideoCapabilitiesKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkVideoDecodeAV1ProfileInfoKHR", "VkVideoDecodeH264ProfileInfoKHR", "VkVideoDecodeH265ProfileInfoKHR", "VkVideoDecodeUsageInfoKHR", "VkVideoEncodeAV1ProfileInfoKHR", "VkVideoEncodeH264ProfileInfoKHR", "VkVideoEncodeH265ProfileInfoKHR", "VkVideoEncodeUsageInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkVideoCodecOperationFlagBitsKHR("videoCodecOperation", "a {@code VkVideoCodecOperationFlagBitsKHR} value specifying a video codec operation.")
    VkVideoChromaSubsamplingFlagsKHR("chromaSubsampling", "a bitmask of {@code VkVideoChromaSubsamplingFlagBitsKHR} specifying video chroma subsampling information.")
    VkVideoComponentBitDepthFlagsKHR("lumaBitDepth", "a bitmask of {@code VkVideoComponentBitDepthFlagBitsKHR} specifying video luma bit depth information.")
    VkVideoComponentBitDepthFlagsKHR("chromaBitDepth", "a bitmask of {@code VkVideoComponentBitDepthFlagBitsKHR} specifying video chroma bit depth information.")
}

val VkVideoProfileListInfoKHR = struct(Module.VULKAN, "VkVideoProfileListInfoKHR") {
    documentation =
        """
        Structure specifying one or more video profiles used in conjunction.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Video transcoding is an example of a use case that necessitates the specification of multiple profiles in various contexts.
        </div>

        When the application provides a video decode profile and one or more video encode profiles in the profile list, the implementation ensures that any capabilitities returned or resources created are suitable for the video transcoding use cases without the need for manual data transformations.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code pProfiles} <b>must</b> not contain more than one element whose {@code videoCodecOperation} member specifies a decode operation</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR</li>
            <li>If {@code profileCount} is not 0, {@code pProfiles} <b>must</b> be a valid pointer to an array of {@code profileCount} valid ##VkVideoProfileInfoKHR structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoProfileInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pProfiles", optional = true)..uint32_t("profileCount", "the number of elements in the {@code pProfiles} array.")
    VkVideoProfileInfoKHR.const.p("pProfiles", "a pointer to an array of ##VkVideoProfileInfoKHR structures.")
}

val VkVideoCapabilitiesKHR = struct(Module.VULKAN, "VkVideoCapabilitiesKHR", mutable = false) {
    documentation =
        """
        Structure describing general video capabilities for a video profile.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        It is common for video compression standards to allow using all reference pictures associated with active DPB slots as active reference pictures, hence for video decode profiles the values returned in {@code maxDpbSlots} and {@code maxActiveReferencePictures} are often equal. Similarly, in case of video decode profiles supporting field pictures the value of {@code maxActiveReferencePictures} often equals <code>maxDpbSlots × 2</code>.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkVideoDecodeAV1CapabilitiesKHR, ##VkVideoDecodeCapabilitiesKHR, ##VkVideoDecodeH264CapabilitiesKHR, ##VkVideoDecodeH265CapabilitiesKHR, ##VkVideoEncodeAV1CapabilitiesKHR, ##VkVideoEncodeAV1QuantizationMapCapabilitiesKHR, ##VkVideoEncodeCapabilitiesKHR, ##VkVideoEncodeH264CapabilitiesKHR, ##VkVideoEncodeH264QuantizationMapCapabilitiesKHR, ##VkVideoEncodeH265CapabilitiesKHR, ##VkVideoEncodeH265QuantizationMapCapabilitiesKHR, or ##VkVideoEncodeQuantizationMapCapabilitiesKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtensionProperties, ##VkExtent2D, #GetPhysicalDeviceVideoCapabilitiesKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    PointerSetter(
        "VkVideoDecodeAV1CapabilitiesKHR", "VkVideoDecodeCapabilitiesKHR", "VkVideoDecodeH264CapabilitiesKHR", "VkVideoDecodeH265CapabilitiesKHR", "VkVideoEncodeAV1CapabilitiesKHR", "VkVideoEncodeAV1QuantizationMapCapabilitiesKHR", "VkVideoEncodeCapabilitiesKHR", "VkVideoEncodeH264CapabilitiesKHR", "VkVideoEncodeH264QuantizationMapCapabilitiesKHR", "VkVideoEncodeH265CapabilitiesKHR", "VkVideoEncodeH265QuantizationMapCapabilitiesKHR", "VkVideoEncodeQuantizationMapCapabilitiesKHR",
        prepend = true
    )..nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkVideoCapabilityFlagsKHR("flags", "a bitmask of {@code VkVideoCapabilityFlagBitsKHR} specifying capability flags.")
    VkDeviceSize("minBitstreamBufferOffsetAlignment", "the minimum alignment for bitstream buffer offsets.")
    VkDeviceSize("minBitstreamBufferSizeAlignment", "the minimum alignment for bitstream buffer range sizes.")
    VkExtent2D("pictureAccessGranularity", "the granularity at which image access to video picture resources happen.")
    VkExtent2D("minCodedExtent", "the minimum width and height of the coded frames.")
    VkExtent2D("maxCodedExtent", "the maximum width and height of the coded frames.")
    uint32_t("maxDpbSlots", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#dpb-slot\">DPB slots</a> supported by a single video session.")
    uint32_t("maxActiveReferencePictures", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#active-reference-pictures\">active reference pictures</a> a single video coding operation <b>can</b> use.")
    VkExtensionProperties("stdHeaderVersion", "a ##VkExtensionProperties structure reporting the Video Std header name and version supported for the video profile.")
}

val VkPhysicalDeviceVideoFormatInfoKHR = struct(Module.VULKAN, "VkPhysicalDeviceVideoFormatInfoKHR") {
    documentation =
        """
        Structure specifying the codec video format.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkVideoProfileListInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code imageUsage} <b>must</b> be a valid combination of {@code VkImageUsageFlagBits} values</li>
            <li>{@code imageUsage} <b>must</b> not be 0</li>
        </ul>

        <h5>See Also</h5>
        #GetPhysicalDeviceVideoFormatPropertiesKHR()
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkVideoProfileListInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkImageUsageFlags("imageUsage", "a bitmask of {@code VkImageUsageFlagBits} specifying the intended usage of the video images.")
}

val VkVideoFormatPropertiesKHR = struct(Module.VULKAN, "VkVideoFormatPropertiesKHR", mutable = false) {
    documentation =
        """
        Structure enumerating the video image formats.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkVideoFormatAV1QuantizationMapPropertiesKHR, ##VkVideoFormatH265QuantizationMapPropertiesKHR, or ##VkVideoFormatQuantizationMapPropertiesKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
        </ul>

        <h5>See Also</h5>
        ##VkComponentMapping, #GetPhysicalDeviceVideoFormatPropertiesKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    PointerSetter(
        "VkVideoFormatAV1QuantizationMapPropertiesKHR", "VkVideoFormatH265QuantizationMapPropertiesKHR", "VkVideoFormatQuantizationMapPropertiesKHR",
        prepend = true
    )..nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkFormat("format", "a {@code VkFormat} that specifies the format that <b>can</b> be used with the specified video profiles and image usages.")
    VkComponentMapping("componentMapping", "defines the color channel order used for the format. {@code format} along with {@code componentMapping} describe how the color channels are ordered when producing video decoder output or are expected to be ordered in video encoder input, when applicable. If the {@code format} reported does not require component swizzling then all members of {@code componentMapping} will be set to #COMPONENT_SWIZZLE_IDENTITY.")
    VkImageCreateFlags("imageCreateFlags", "a bitmask of {@code VkImageCreateFlagBits} specifying the supported image creation flags for the format.")
    VkImageType("imageType", "a {@code VkImageType} that specifies the image type the format <b>can</b> be used with.")
    VkImageTiling("imageTiling", "a {@code VkImageTiling} that specifies the image tiling the format <b>can</b> be used with.")
    VkImageUsageFlags("imageUsageFlags", "a bitmask of {@code VkImageUsageFlagBits} specifying the supported image usage flags for the format.")
}

val VkVideoPictureResourceInfoKHR = struct(Module.VULKAN, "VkVideoPictureResourceInfoKHR") {
    documentation =
        """
        Structure specifying the parameters of a video picture resource.

        <h5>Description</h5>
        The image subresource referred to by such a structure is defined as the image array layer index specified in {@code baseArrayLayer} relative to the image subresource range the image view specified in {@code imageViewBinding} was created with.

        The meaning of the {@code codedOffset} and {@code codedExtent} depends on the command and context the video picture resource is used in, as well as on the used <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-profiles">video profile</a> and corresponding codec-specific semantics, as described later.

        A video picture resource is uniquely defined by the image subresource referred to by an instance of this structure, together with the {@code codedOffset} and {@code codedExtent} members that identify the image subregion within the image subresource referenced corresponding to the video picture resource according to the particular codec-specific semantics.

        Accesses to image data within a video picture resource happen at the granularity indicated by ##VkVideoCapabilitiesKHR{@code ::pictureAccessGranularity}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-profiles">video profile</a>. As a result, given an effective image subregion corresponding to a video picture resource, the actual image subregion accessed <b>may</b> be larger than that as it <b>may</b> include additional padding texels due to the picture access granularity. Any writes performed by video coding operations to such padding texels will result in undefined texel values.

        Two video picture resources match if they refer to the same image subresource and they specify identical {@code codedOffset} and {@code codedExtent} values.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code baseArrayLayer} <b>must</b> be less than the ##VkImageViewCreateInfo{@code ::subresourceRange.layerCount} specified when the image view {@code imageViewBinding} was created</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code imageViewBinding} <b>must</b> be a valid {@code VkImageView} handle</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D, ##VkOffset2D, ##VkVideoDecodeInfoKHR, ##VkVideoEncodeInfoKHR, ##VkVideoReferenceSlotInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkOffset2D("codedOffset", "the offset in texels of the image subregion to use.")
    VkExtent2D("codedExtent", "the size in pixels of the coded image data.")
    uint32_t("baseArrayLayer", "the array layer of the image view specified in {@code imageViewBinding} to use as the video picture resource.")
    VkImageView("imageViewBinding", "an image view representing the video picture resource.")
}

val VkVideoReferenceSlotInfoKHR = struct(Module.VULKAN, "VkVideoReferenceSlotInfoKHR") {
    documentation =
        """
        Structure specifying information about a reference picture slot.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkVideoDecodeAV1DpbSlotInfoKHR, ##VkVideoDecodeH264DpbSlotInfoKHR, ##VkVideoDecodeH265DpbSlotInfoKHR, ##VkVideoEncodeAV1DpbSlotInfoKHR, ##VkVideoEncodeH264DpbSlotInfoKHR, or ##VkVideoEncodeH265DpbSlotInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>If {@code pPictureResource} is not {@code NULL}, {@code pPictureResource} <b>must</b> be a valid pointer to a valid ##VkVideoPictureResourceInfoKHR structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoBeginCodingInfoKHR, ##VkVideoDecodeInfoKHR, ##VkVideoEncodeInfoKHR, ##VkVideoPictureResourceInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkVideoDecodeAV1DpbSlotInfoKHR", "VkVideoDecodeH264DpbSlotInfoKHR", "VkVideoDecodeH265DpbSlotInfoKHR", "VkVideoEncodeAV1DpbSlotInfoKHR", "VkVideoEncodeH264DpbSlotInfoKHR", "VkVideoEncodeH265DpbSlotInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    int32_t("slotIndex", "the index of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#dpb-slot\">DPB slot</a> or a negative integer value.")
    nullable..VkVideoPictureResourceInfoKHR.const.p("pPictureResource", "{@code NULL} or a pointer to a ##VkVideoPictureResourceInfoKHR structure describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#video-picture-resources\">video picture resource</a> associated with the DPB slot index specified by {@code slotIndex}.")
}

val VkVideoSessionMemoryRequirementsKHR = struct(Module.VULKAN, "VkVideoSessionMemoryRequirementsKHR", mutable = false) {
    documentation =
        """
        Structure describing video session memory requirements.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkMemoryRequirements, #GetVideoSessionMemoryRequirementsKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("memoryBindIndex", "the index of the memory binding.")
    VkMemoryRequirements("memoryRequirements", "a ##VkMemoryRequirements structure in which the requested memory binding requirements for the binding index specified by {@code memoryBindIndex} are returned.")
}

val VkBindVideoSessionMemoryInfoKHR = struct(Module.VULKAN, "VkBindVideoSessionMemoryInfoKHR") {
    documentation =
        """
        Structure specifying memory bindings for a video session object.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code memoryOffset} <b>must</b> be less than the size of {@code memory}</li>
            <li>{@code memorySize} <b>must</b> be less than or equal to the size of {@code memory} minus {@code memoryOffset}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
        </ul>

        <h5>See Also</h5>
        #BindVideoSessionMemoryKHR()
        """

    Expression("#STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("memoryBindIndex", "the memory binding index to bind memory to.")
    VkDeviceMemory("memory", "the allocated device memory to be bound to the video session’s memory binding with index {@code memoryBindIndex}.")
    VkDeviceSize("memoryOffset", "the start offset of the region of {@code memory} which is to be bound.")
    VkDeviceSize("memorySize", "the size in bytes of the region of {@code memory}, starting from {@code memoryOffset} bytes, to be bound.")
}

val VkVideoSessionCreateInfoKHR = struct(Module.VULKAN, "VkVideoSessionCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created video session.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-protectedMemory">{@code protectedMemory}</a> feature is not enabled or if ##VkVideoCapabilitiesKHR{@code ::flags} does not include #VIDEO_CAPABILITY_PROTECTED_CONTENT_BIT_KHR, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified by {@code pVideoProfile}, then {@code flags} <b>must</b> not include #VIDEO_SESSION_CREATE_PROTECTED_CONTENT_BIT_KHR</li>
            <li>If {@code flags} includes #VIDEO_SESSION_CREATE_INLINE_QUERIES_BIT_KHR, then <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-videoMaintenance1">{@code videoMaintenance1}</a> <b>must</b> be enabled</li>
            <li>If {@code flags} includes #VIDEO_SESSION_CREATE_ALLOW_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #VIDEO_SESSION_CREATE_ALLOW_ENCODE_EMPHASIS_MAP_BIT_KHR, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-videoEncodeQuantizationMap">{@code videoEncodeQuantizationMap}</a> feature <b>must</b> be enabled</li>
            <li>If {@code flags} includes #VIDEO_SESSION_CREATE_ALLOW_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #VIDEO_SESSION_CREATE_ALLOW_ENCODE_EMPHASIS_MAP_BIT_KHR, then {@code pVideoProfile→videoCodecOperation} <b>must</b> specify an encode operation</li>
            <li>If {@code flags} includes #VIDEO_SESSION_CREATE_ALLOW_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR, then it <b>must</b> not also include #VIDEO_SESSION_CREATE_ALLOW_ENCODE_EMPHASIS_MAP_BIT_KHR</li>
            <li>If ##VkVideoEncodeCapabilitiesKHR{@code ::flags} does not include #VIDEO_ENCODE_CAPABILITY_QUANTIZATION_DELTA_MAP_BIT_KHR, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified by {@code pVideoProfile}, then {@code flags} <b>must</b> not include #VIDEO_SESSION_CREATE_ALLOW_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR</li>
            <li>If ##VkVideoEncodeCapabilitiesKHR{@code ::flags} does not include #VIDEO_ENCODE_CAPABILITY_EMPHASIS_MAP_BIT_KHR, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified by {@code pVideoProfile}, then {@code flags} <b>must</b> not include #VIDEO_SESSION_CREATE_ALLOW_ENCODE_EMPHASIS_MAP_BIT_KHR</li>
            <li>{@code pVideoProfile} <b>must</b> be a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-profile-support">supported video profile</a></li>
            <li>{@code maxDpbSlots} <b>must</b> be less than or equal to ##VkVideoCapabilitiesKHR{@code ::maxDpbSlots}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified by {@code pVideoProfile}</li>
            <li>{@code maxActiveReferencePictures} <b>must</b> be less than or equal to ##VkVideoCapabilitiesKHR{@code ::maxActiveReferencePictures}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified by {@code pVideoProfile}</li>
            <li>If either {@code maxDpbSlots} or {@code maxActiveReferencePictures} is 0, then both <b>must</b> be 0</li>
            <li>{@code maxCodedExtent} <b>must</b> be between ##VkVideoCapabilitiesKHR{@code ::minCodedExtent} and ##VkVideoCapabilitiesKHR{@code ::maxCodedExtent}, inclusive, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified by {@code pVideoProfile}</li>
            <li>If {@code pVideoProfile→videoCodecOperation} specifies a decode operation and {@code maxActiveReferencePictures} is greater than 0, then {@code referencePictureFormat} <b>must</b> be one of the supported decode DPB formats, as returned by #GetPhysicalDeviceVideoFormatPropertiesKHR() in ##VkVideoFormatPropertiesKHR{@code ::format} when called with the {@code imageUsage} member of its {@code pVideoFormatInfo} parameter containing #IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR, and with a ##VkVideoProfileListInfoKHR structure specified in the {@code pNext} chain of its {@code pVideoFormatInfo} parameter whose {@code pProfiles} member contains an element matching {@code pVideoProfile}</li>
            <li>If {@code pVideoProfile→videoCodecOperation} specifies an encode operation and {@code maxActiveReferencePictures} is greater than 0, then {@code referencePictureFormat} <b>must</b> be one of the supported decode DPB formats, as returned by then {@code referencePictureFormat} <b>must</b> be one of the supported encode DPB formats, as returned by #GetPhysicalDeviceVideoFormatPropertiesKHR() in ##VkVideoFormatPropertiesKHR{@code ::format} when called with the {@code imageUsage} member of its {@code pVideoFormatInfo} parameter containing #IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR, and with a ##VkVideoProfileListInfoKHR structure specified in the {@code pNext} chain of its {@code pVideoFormatInfo} parameter whose {@code pProfiles} member contains an element matching {@code pVideoProfile}</li>
            <li>If {@code pVideoProfile→videoCodecOperation} specifies a decode operation, then {@code pictureFormat} <b>must</b> be one of the supported decode output formats, as returned by #GetPhysicalDeviceVideoFormatPropertiesKHR() in ##VkVideoFormatPropertiesKHR{@code ::format} when called with the {@code imageUsage} member of its {@code pVideoFormatInfo} parameter containing #IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, and with a ##VkVideoProfileListInfoKHR structure specified in the {@code pNext} chain of its {@code pVideoFormatInfo} parameter whose {@code pProfiles} member contains an element matching {@code pVideoProfile}</li>
            <li>If {@code pVideoProfile→videoCodecOperation} specifies an encode operation, then {@code pictureFormat} <b>must</b> be one of the supported encode input formats, as returned by #GetPhysicalDeviceVideoFormatPropertiesKHR() in ##VkVideoFormatPropertiesKHR{@code ::format} when called with the {@code imageUsage} member of its {@code pVideoFormatInfo} parameter containing #IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, and with a ##VkVideoProfileListInfoKHR structure specified in the {@code pNext} chain of its {@code pVideoFormatInfo} parameter whose {@code pProfiles} member contains an element matching {@code pVideoProfile}</li>
            <li>{@code pStdHeaderVersion→extensionName} <b>must</b> match ##VkVideoCapabilitiesKHR{@code ::stdHeaderVersion.extensionName}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified by {@code pVideoProfile}</li>
            <li>{@code pStdHeaderVersion→specVersion} <b>must</b> be less than or equal to ##VkVideoCapabilitiesKHR{@code ::stdHeaderVersion.specVersion}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified by {@code pVideoProfile}</li>
            <li>If {@code pVideoProfile→videoCodecOperation} is #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR and the {@code pNext} chain of this structure includes a ##VkVideoEncodeH264SessionCreateInfoKHR structure, then its {@code maxLevelIdc} member <b>must</b> be less than or equal to ##VkVideoEncodeH264CapabilitiesKHR{@code ::maxLevelIdc}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified in {@code pVideoProfile}</li>
            <li>If {@code pVideoProfile→videoCodecOperation} is #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR and the {@code pNext} chain of this structure includes a ##VkVideoEncodeH265SessionCreateInfoKHR structure, then its {@code maxLevelIdc} member <b>must</b> be less than or equal to ##VkVideoEncodeH265CapabilitiesKHR{@code ::maxLevelIdc}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified in {@code pVideoProfile}</li>
            <li>If {@code pVideoProfile→videoCodecOperation} is #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-videoEncodeAV1">{@code videoEncodeAV1}</a> feature <b>must</b> be enabled</li>
            <li>If {@code pVideoProfile→videoCodecOperation} is #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR and the {@code pNext} chain of this structure includes a ##VkVideoEncodeAV1SessionCreateInfoKHR structure, then its {@code maxLevel} member <b>must</b> be less than or equal to ##VkVideoEncodeAV1CapabilitiesKHR{@code ::maxLevel}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile specified in {@code pVideoProfile}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkVideoEncodeAV1SessionCreateInfoKHR, ##VkVideoEncodeH264SessionCreateInfoKHR, or ##VkVideoEncodeH265SessionCreateInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkVideoSessionCreateFlagBitsKHR} values</li>
            <li>{@code pVideoProfile} <b>must</b> be a valid pointer to a valid ##VkVideoProfileInfoKHR structure</li>
            <li>{@code pictureFormat} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>{@code referencePictureFormat} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>{@code pStdHeaderVersion} <b>must</b> be a valid pointer to a valid ##VkExtensionProperties structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtensionProperties, ##VkExtent2D, ##VkVideoProfileInfoKHR, #CreateVideoSessionKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkVideoEncodeAV1SessionCreateInfoKHR", "VkVideoEncodeH264SessionCreateInfoKHR", "VkVideoEncodeH265SessionCreateInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("queueFamilyIndex", "the index of the queue family the created video session will be used with.")
    VkVideoSessionCreateFlagsKHR("flags", "a bitmask of {@code VkVideoSessionCreateFlagBitsKHR} specifying creation flags.")
    VkVideoProfileInfoKHR.const.p("pVideoProfile", "a pointer to a ##VkVideoProfileInfoKHR structure specifying the video profile the created video session will be used with.")
    VkFormat("pictureFormat", "the image format the created video session will be used with. If {@code pVideoProfile→videoCodecOperation} specifies a decode operation, then {@code pictureFormat} is the image format of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-output-picture\">decode output pictures</a> usable with the created video session. If {@code pVideoProfile→videoCodecOperation} specifies an encode operation, then {@code pictureFormat} is the image format of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-input-picture\">encode input pictures</a> usable with the created video session.")
    VkExtent2D("maxCodedExtent", "the maximum width and height of the coded frames the created video session will be used with.")
    VkFormat("referencePictureFormat", "the image format of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#reference-picture\">reference pictures</a> stored in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#dpb\">DPB</a> the created video session will be used with.")
    uint32_t("maxDpbSlots", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#dpb-slot\">DPB Slots</a> that <b>can</b> be used with the created video session.")
    uint32_t("maxActiveReferencePictures", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#active-reference-pictures\">active reference pictures</a> that <b>can</b> be used in a single video coding operation using the created video session.")
    VkExtensionProperties.const.p("pStdHeaderVersion", "a pointer to a ##VkExtensionProperties structure requesting the Video Std header version to use for the {@code videoCodecOperation} specified in {@code pVideoProfile}.")
}

val VkVideoSessionParametersCreateInfoKHR = struct(Module.VULKAN, "VkVideoSessionParametersCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created video session parameters object.

        <h5>Description</h5>
        Limiting values are defined below that are referenced by the relevant valid usage statements of this structure.

        <ul>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR, then let {@code StdVideoH264SequenceParameterSet spsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-sps">H.264 SPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoDecodeH264SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH264SequenceParameterSet} entries specified in {@code pParametersAddInfo→pStdSPSs} are added to {@code spsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH264SequenceParameterSet} entry stored in it with {@code seq_parameter_set_id} not matching any of the entries already in {@code spsAddList} is added to {@code spsAddList}.</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR, then let {@code StdVideoH264PictureParameterSet ppsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-pps">H.264 PPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoDecodeH264SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH264PictureParameterSet} entries specified in {@code pParametersAddInfo→pStdPPSs} are added to {@code ppsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH264PictureParameterSet} entry stored in it with {@code seq_parameter_set_id} or {@code pic_parameter_set_id} not matching any of the entries already in {@code ppsAddList} is added to {@code ppsAddList}.</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then let {@code StdVideoH265VideoParameterSet vpsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-vps">H.265 VPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoDecodeH265SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH265VideoParameterSet} entries specified in {@code pParametersAddInfo→pStdVPSs} are added to {@code vpsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH265VideoParameterSet} entry stored in it with {@code vps_video_parameter_set_id} not matching any of the entries already in {@code vpsAddList} is added to {@code vpsAddList}.</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then let {@code StdVideoH265SequenceParameterSet spsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-sps">H.265 SPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoDecodeH265SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH265SequenceParameterSet} entries specified in {@code pParametersAddInfo→pStdSPSs} are added to {@code spsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH265SequenceParameterSet} entry stored in it with {@code sps_video_parameter_set_id} or {@code sps_seq_parameter_set_id} not matching any of the entries already in {@code spsAddList} is added to {@code spsAddList}.</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then let {@code StdVideoH265PictureParameterSet ppsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-pps">H.265 PPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoDecodeH265SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH265PictureParameterSet} entries specified in {@code pParametersAddInfo→pStdPPSs} are added to {@code ppsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH265PictureParameterSet} entry stored in it with {@code sps_video_parameter_set_id}, {@code pps_seq_parameter_set_id}, or {@code pps_pic_parameter_set_id} not matching any of the entries already in {@code ppsAddList} is added to {@code ppsAddList}.</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with an encode operation, then let {@code uint32_t qualityLevel} be the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-quality-level">video encode quality level</a> of the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pNext} chain of this structure includes a ##VkVideoEncodeQualityLevelInfoKHR structure, then {@code qualityLevel} is equal to ##VkVideoEncodeQualityLevelInfoKHR{@code ::qualityLevel}.</li>
                    <li>Otherwise {@code qualityLevel} is 0</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, then let {@code StdVideoH264SequenceParameterSet spsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-sps">H.264 SPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoEncodeH264SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH264SequenceParameterSet} entries specified in {@code pParametersAddInfo→pStdSPSs} are added to {@code spsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH264SequenceParameterSet} entry stored in it with {@code seq_parameter_set_id} not matching any of the entries already in {@code spsAddList} is added to {@code spsAddList}.</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, then let {@code StdVideoH264PictureParameterSet ppsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-pps">H.264 PPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoEncodeH264SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH264PictureParameterSet} entries specified in {@code pParametersAddInfo→pStdPPSs} are added to {@code ppsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH264PictureParameterSet} entry stored in it with {@code seq_parameter_set_id} or {@code pic_parameter_set_id} not matching any of the entries already in {@code ppsAddList} is added to {@code ppsAddList}.</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then let {@code StdVideoH265VideoParameterSet vpsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-vps">H.265 VPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoEncodeH265SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH265VideoParameterSet} entries specified in {@code pParametersAddInfo→pStdVPSs} are added to {@code vpsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH265VideoParameterSet} entry stored in it with {@code vps_video_parameter_set_id} not matching any of the entries already in {@code vpsAddList} is added to {@code vpsAddList}.</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then let {@code StdVideoH265SequenceParameterSet spsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-sps">H.265 SPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoEncodeH265SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH265SequenceParameterSet} entries specified in {@code pParametersAddInfo→pStdSPSs} are added to {@code spsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH265SequenceParameterSet} entry stored in it with {@code sps_video_parameter_set_id} or {@code sps_seq_parameter_set_id} not matching any of the entries already in {@code spsAddList} is added to {@code spsAddList}.</li>
                </ul>
            </li>
            <li>
                If {@code videoSession} was created with the codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then let {@code StdVideoH265PictureParameterSet ppsAddList[]} be the list of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-pps">H.265 PPS</a> entries to add to the created video session parameters object, defined as follows:
                <ul>
                    <li>If the {@code pParametersAddInfo} member of the ##VkVideoEncodeH265SessionParametersCreateInfoKHR structure provided in the {@code pNext} chain is not {@code NULL}, then the set of {@code StdVideoH265PictureParameterSet} entries specified in {@code pParametersAddInfo→pStdPPSs} are added to {@code ppsAddList};</li>
                    <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, then each {@code StdVideoH265PictureParameterSet} entry stored in it with {@code sps_video_parameter_set_id}, {@code pps_seq_parameter_set_id}, or {@code pps_pic_parameter_set_id} not matching any of the entries already in {@code ppsAddList} is added to {@code ppsAddList}.</li>
                </ul>
            </li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, it <b>must</b> have been created against {@code videoSession}</li>
            <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE and {@code videoSession} was created with an encode operation, then {@code qualityLevel} <b>must</b> equal the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-quality-level">video encode quality</a> level {@code videoSessionParametersTemplate} was created with</li>
            <li>If {@code flags} includes #VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR, then {@code videoSession} <b>must</b> have been created with #VIDEO_SESSION_CREATE_ALLOW_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR or #VIDEO_SESSION_CREATE_ALLOW_ENCODE_EMPHASIS_MAP_BIT_KHR</li>
            <li>If {@code flags} includes #VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR structure</li>
            <li>If {@code flags} includes #VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR and {@code videoSession} was created with #VIDEO_SESSION_CREATE_ALLOW_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#supported-video-format-properties">list of video format properties</a> supported for the image usage flag #IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR <b>must</b> have an element for which ##VkVideoFormatQuantizationMapPropertiesKHR{@code ::quantizationMapTexelSize} equals the {@code quantizationMapTexelSize} member of the ##VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code flags} includes #VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR and {@code videoSession} was created with #VIDEO_SESSION_CREATE_ALLOW_ENCODE_EMPHASIS_MAP_BIT_KHR, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#supported-video-format-properties">list of video format properties</a> supported for the image usage flag #IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR <b>must</b> have an element for which ##VkVideoFormatQuantizationMapPropertiesKHR{@code ::quantizationMapTexelSize} equals the {@code quantizationMapTexelSize} member of the ##VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE and {@code flags} includes #VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR, then {@code videoSessionParametersTemplate} <b>must</b> have been created with #VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR</li>
            <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE and {@code flags} includes #VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR, then {@code videoSessionParametersTemplate} <b>must</b> have been created with the same <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-quantization-map-texel-size">quantization map texel size</a> as the one specified in the {@code quantizationMapTexelSize} member of the ##VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE and {@code flags} does not include #VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR, then {@code videoSessionParametersTemplate} <b>must</b> have been created without #VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoDecodeH264SessionParametersCreateInfoKHR structure</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR, then the number of elements of {@code spsAddList} <b>must</b> be less than or equal to the {@code maxStdSPSCount} specified in the ##VkVideoDecodeH264SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR, then the number of elements of {@code ppsAddList} <b>must</b> be less than or equal to the {@code maxStdPPSCount} specified in the ##VkVideoDecodeH264SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoDecodeH265SessionParametersCreateInfoKHR structure</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then the number of elements of {@code vpsAddList} <b>must</b> be less than or equal to the {@code maxStdVPSCount} specified in the ##VkVideoDecodeH265SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then the number of elements of {@code spsAddList} <b>must</b> be less than or equal to the {@code maxStdSPSCount} specified in the ##VkVideoDecodeH265SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then the number of elements of {@code ppsAddList} <b>must</b> be less than or equal to the {@code maxStdPPSCount} specified in the ##VkVideoDecodeH265SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_AV1_BIT_KHR, then {@code videoSessionParametersTemplate} <b>must</b> be #NULL_HANDLE</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_AV1_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoDecodeAV1SessionParametersCreateInfoKHR structure</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoEncodeH264SessionParametersCreateInfoKHR structure</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, then the number of elements of {@code spsAddList} <b>must</b> be less than or equal to the {@code maxStdSPSCount} specified in the ##VkVideoEncodeH264SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, then the number of elements of {@code ppsAddList} <b>must</b> be less than or equal to the {@code maxStdPPSCount} specified in the ##VkVideoEncodeH264SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoEncodeH265SessionParametersCreateInfoKHR structure</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then the number of elements of {@code vpsAddList} <b>must</b> be less than or equal to the {@code maxStdVPSCount} specified in the ##VkVideoEncodeH265SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then the number of elements of {@code spsAddList} <b>must</b> be less than or equal to the {@code maxStdSPSCount} specified in the ##VkVideoEncodeH265SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then the number of elements of {@code ppsAddList} <b>must</b> be less than or equal to the {@code maxStdPPSCount} specified in the ##VkVideoEncodeH265SessionParametersCreateInfoKHR structure included in the {@code pNext} chain</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then {@code num_tile_columns_minus1} <b>must</b> be less than ##VkVideoEncodeH265CapabilitiesKHR{@code ::maxTiles.width}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile {@code videoSession} was created with, for each element of {@code ppsAddList}</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then {@code num_tile_rows_minus1} <b>must</b> be less than ##VkVideoEncodeH265CapabilitiesKHR{@code ::maxTiles.height}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile {@code videoSession} was created with, for each element of {@code ppsAddList}</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then {@code videoSessionParametersTemplate} <b>must</b> be #NULL_HANDLE</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoEncodeAV1SessionParametersCreateInfoKHR structure</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then the {@code stdOperatingPointCount} member of the ##VkVideoEncodeAV1SessionParametersCreateInfoKHR structure included in the {@code pNext} chain <b>must</b> be less than or equal to ##VkVideoEncodeAV1CapabilitiesKHR{@code ::maxOperatingPoints}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile {@code videoSession} was created with</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkVideoDecodeAV1SessionParametersCreateInfoKHR, ##VkVideoDecodeH264SessionParametersCreateInfoKHR, ##VkVideoDecodeH265SessionParametersCreateInfoKHR, ##VkVideoEncodeAV1SessionParametersCreateInfoKHR, ##VkVideoEncodeH264SessionParametersCreateInfoKHR, ##VkVideoEncodeH265SessionParametersCreateInfoKHR, ##VkVideoEncodeQualityLevelInfoKHR, or ##VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkVideoSessionParametersCreateFlagBitsKHR} values</li>
            <li>If {@code videoSessionParametersTemplate} is not #NULL_HANDLE, {@code videoSessionParametersTemplate} <b>must</b> be a valid {@code VkVideoSessionParametersKHR} handle</li>
            <li>{@code videoSession} <b>must</b> be a valid {@code VkVideoSessionKHR} handle</li>
            <li>If {@code videoSessionParametersTemplate} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code videoSession}</li>
            <li>Both of {@code videoSession}, and {@code videoSessionParametersTemplate} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #CreateVideoSessionParametersKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkVideoDecodeAV1SessionParametersCreateInfoKHR", "VkVideoDecodeH264SessionParametersCreateInfoKHR", "VkVideoDecodeH265SessionParametersCreateInfoKHR", "VkVideoEncodeAV1SessionParametersCreateInfoKHR", "VkVideoEncodeH264SessionParametersCreateInfoKHR", "VkVideoEncodeH265SessionParametersCreateInfoKHR", "VkVideoEncodeQualityLevelInfoKHR", "VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkVideoSessionParametersCreateFlagsKHR("flags", "a bitmask of {@code VkVideoSessionParametersCreateFlagBitsKHR} specifying create flags.")
    VkVideoSessionParametersKHR("videoSessionParametersTemplate", "#NULL_HANDLE or a valid handle to a {@code VkVideoSessionParametersKHR} object used as a template for constructing the new video session parameters object.")
    VkVideoSessionKHR("videoSession", "the video session object against which the video session parameters object is going to be created.")
}

val VkVideoSessionParametersUpdateInfoKHR = struct(Module.VULKAN, "VkVideoSessionParametersUpdateInfoKHR") {
    documentation =
        """
        Structure specifying video session parameters update information.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkVideoDecodeH264SessionParametersAddInfoKHR, ##VkVideoDecodeH265SessionParametersAddInfoKHR, ##VkVideoEncodeH264SessionParametersAddInfoKHR, or ##VkVideoEncodeH265SessionParametersAddInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
        </ul>

        <h5>See Also</h5>
        #UpdateVideoSessionParametersKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkVideoDecodeH264SessionParametersAddInfoKHR", "VkVideoDecodeH265SessionParametersAddInfoKHR", "VkVideoEncodeH264SessionParametersAddInfoKHR", "VkVideoEncodeH265SessionParametersAddInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("updateSequenceCount", "the new <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#video-session-parameters\">update sequence count</a> to set for the video session parameters object.")
}

val VkVideoBeginCodingInfoKHR = struct(Module.VULKAN, "VkVideoBeginCodingInfoKHR") {
    documentation =
        """
        Structure specifying video coding scope begin information.

        <h5>Description</h5>
        Limiting values are defined below that are referenced by the relevant valid usage statements of this structure.

        <ul>
            <li>
                Let {@code VkOffset2D codedOffsetGranularity} be the minimum alignment requirement for the coded offset of video picture resources. Unless otherwise defined, the value of the {@code x} and {@code y} members of {@code codedOffsetGranularity} are 0.
                <ul>
                    <li>If {@code videoSession} was created with an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-profile">H.264 decode profile</a> with a ##VkVideoDecodeH264ProfileInfoKHR{@code ::pictureLayout} of #VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_SEPARATE_PLANES_BIT_KHR, then {@code codedOffsetGranularity} is equal to ##VkVideoDecodeH264CapabilitiesKHR{@code ::fieldOffsetGranularity}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for that video profile.</li>
                </ul>
            </li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code videoSession} <b>must</b> have memory bound to all of its memory bindings returned by #GetVideoSessionMemoryRequirementsKHR() for {@code videoSession}</li>
            <li>Each non-negative ##VkVideoReferenceSlotInfoKHR{@code ::slotIndex} specified in the elements of {@code pReferenceSlots} <b>must</b> be less than the ##VkVideoSessionCreateInfoKHR{@code ::maxDpbSlots} specified when {@code videoSession} was created</li>
            <li>Each video picture resource corresponding to any non-{@code NULL} {@code pPictureResource} member specified in the elements of {@code pReferenceSlots} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-picture-resource-uniqueness">unique</a> within {@code pReferenceSlots}</li>
            <li>If the {@code pPictureResource} member of any element of {@code pReferenceSlots} is not {@code NULL}, then the image view specified in {@code pPictureResource→imageViewBinding} for that element <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-profile-compatibility">compatible</a> with the video profile {@code videoSession} was created with</li>
            <li>If the {@code pPictureResource} member of any element of {@code pReferenceSlots} is not {@code NULL}, then the format of the image view specified in {@code pPictureResource→imageViewBinding} for that element <b>must</b> match the ##VkVideoSessionCreateInfoKHR{@code ::referencePictureFormat} {@code videoSession} was created with</li>
            <li>If the {@code pPictureResource} member of any element of {@code pReferenceSlots} is not {@code NULL}, then its {@code codedOffset} member <b>must</b> be an integer multiple of {@code codedOffsetGranularity}</li>
            <li>If the {@code pPictureResource} member of any element of {@code pReferenceSlots} is not {@code NULL}, then its {@code codedExtent} member <b>must</b> be between {@code minCodedExtent} and {@code maxCodedExtent}, inclusive, {@code videoSession} was created with</li>
            <li>If ##VkVideoCapabilitiesKHR{@code ::flags} does not include #VIDEO_CAPABILITY_SEPARATE_REFERENCE_IMAGES_BIT_KHR, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile {@code videoSession} was created with, then {@code pPictureResource→imageViewBinding} of all elements of {@code pReferenceSlots} with a non-{@code NULL} {@code pPictureResource} member <b>must</b> specify image views created from the same image</li>
            <li>If {@code videoSession} was created with a decode operation and the {@code slotIndex} member of any element of {@code pReferenceSlots} is not negative, then the image view specified in {@code pPictureResource→imageViewBinding} for that element <b>must</b> have been created with #IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR</li>
            <li>If {@code videoSession} was created with an encode operation and the {@code slotIndex} member of any element of {@code pReferenceSlots} is not negative, then the image view specified in {@code pPictureResource→imageViewBinding} for that element <b>must</b> have been created with #IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR, then {@code videoSessionParameters} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then {@code videoSessionParameters} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_DECODE_AV1_BIT_KHR, then {@code videoSessionParameters} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, then {@code videoSessionParameters} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then {@code videoSessionParameters} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code videoSession} was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then {@code videoSessionParameters} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code videoSessionParameters} is not #NULL_HANDLE, it <b>must</b> have been created with {@code videoSession} specified in ##VkVideoSessionParametersCreateInfoKHR{@code ::videoSession}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkVideoEncodeAV1GopRemainingFrameInfoKHR, ##VkVideoEncodeAV1RateControlInfoKHR, ##VkVideoEncodeH264GopRemainingFrameInfoKHR, ##VkVideoEncodeH264RateControlInfoKHR, ##VkVideoEncodeH265GopRemainingFrameInfoKHR, ##VkVideoEncodeH265RateControlInfoKHR, or ##VkVideoEncodeRateControlInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code videoSession} <b>must</b> be a valid {@code VkVideoSessionKHR} handle</li>
            <li>If {@code videoSessionParameters} is not #NULL_HANDLE, {@code videoSessionParameters} <b>must</b> be a valid {@code VkVideoSessionParametersKHR} handle</li>
            <li>If {@code referenceSlotCount} is not 0, {@code pReferenceSlots} <b>must</b> be a valid pointer to an array of {@code referenceSlotCount} valid ##VkVideoReferenceSlotInfoKHR structures</li>
            <li>If {@code videoSessionParameters} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code videoSession}</li>
            <li>Both of {@code videoSession}, and {@code videoSessionParameters} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoReferenceSlotInfoKHR, #CmdBeginVideoCodingKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkVideoEncodeAV1GopRemainingFrameInfoKHR", "VkVideoEncodeAV1RateControlInfoKHR", "VkVideoEncodeH264GopRemainingFrameInfoKHR", "VkVideoEncodeH264RateControlInfoKHR", "VkVideoEncodeH265GopRemainingFrameInfoKHR", "VkVideoEncodeH265RateControlInfoKHR", "VkVideoEncodeRateControlInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkVideoBeginCodingFlagsKHR("flags", "reserved for future use.")
    VkVideoSessionKHR("videoSession", "the video session object to be bound for the processing of the video commands.")
    VkVideoSessionParametersKHR("videoSessionParameters", "#NULL_HANDLE or a handle of a {@code VkVideoSessionParametersKHR} object to be used for the processing of the video commands. If #NULL_HANDLE, then no video session parameters object is bound for the duration of the video coding scope.")
    AutoSize("pReferenceSlots", optional = true)..uint32_t("referenceSlotCount", "the number of elements in the {@code pReferenceSlots} array.")
    VkVideoReferenceSlotInfoKHR.const.p("pReferenceSlots", "a pointer to an array of ##VkVideoReferenceSlotInfoKHR structures specifying the information used to determine the set of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#bound-reference-picture-resources\">bound reference picture resources</a> for the video coding scope and their initial association with <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#dpb-slot\">DPB slot</a> indices.")
}

val VkVideoEndCodingInfoKHR = struct(Module.VULKAN, "VkVideoEndCodingInfoKHR") {
    documentation =
        """
        Structure specifying video coding scope end information.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CmdEndVideoCodingKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkVideoEndCodingFlagsKHR("flags", "reserved for future use.")
}

val VkVideoCodingControlInfoKHR = struct(Module.VULKAN, "VkVideoCodingControlInfoKHR") {
    documentation =
        """
        Structure specifying video coding control parameters.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code flags} includes #VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoEncodeRateControlInfoKHR structure</li>
            <li>If {@code flags} includes #VIDEO_CODING_CONTROL_ENCODE_QUALITY_LEVEL_BIT_KHR, then the {@code pNext} chain <b>must</b> include a ##VkVideoEncodeQualityLevelInfoKHR structure</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkVideoEncodeAV1RateControlInfoKHR, ##VkVideoEncodeH264RateControlInfoKHR, ##VkVideoEncodeH265RateControlInfoKHR, ##VkVideoEncodeQualityLevelInfoKHR, or ##VkVideoEncodeRateControlInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkVideoCodingControlFlagBitsKHR} values</li>
            <li>{@code flags} <b>must</b> not be 0</li>
        </ul>

        <h5>See Also</h5>
        #CmdControlVideoCodingKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkVideoEncodeAV1RateControlInfoKHR", "VkVideoEncodeH264RateControlInfoKHR", "VkVideoEncodeH265RateControlInfoKHR", "VkVideoEncodeQualityLevelInfoKHR", "VkVideoEncodeRateControlInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkVideoCodingControlFlagsKHR("flags", "a bitmask of {@code VkVideoCodingControlFlagsKHR} specifying control flags.")
}

val VkVideoDecodeCapabilitiesKHR = struct(Module.VULKAN, "VkVideoDecodeCapabilitiesKHR", mutable = false) {
    documentation =
        """
        Structure describing general video decode capabilities for a video profile.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkVideoDecodeCapabilityFlagsKHR("flags", "a bitmask of {@code VkVideoDecodeCapabilityFlagBitsKHR} describing the supported video decoding capabilities.")
}

val VkVideoDecodeUsageInfoKHR = struct(Module.VULKAN, "VkVideoDecodeUsageInfoKHR") {
    documentation =
        """
        Structure specifying video decode usage information.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR</li>
            <li>{@code videoUsageHints} <b>must</b> be a valid combination of {@code VkVideoDecodeUsageFlagBitsKHR} values</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkVideoDecodeUsageFlagsKHR("videoUsageHints", "a bitmask of {@code VkVideoDecodeUsageFlagBitsKHR} specifying hints about the intended use of the video decode profile.")
}

val VkVideoDecodeInfoKHR = struct(Module.VULKAN, "VkVideoDecodeInfoKHR") {
    documentation =
        """
        Structure specifying video decode parameters.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code srcBuffer} <b>must</b> have been created with #BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR set</li>
            <li>{@code srcBufferOffset} <b>must</b> be less than the size of {@code srcBuffer}</li>
            <li>{@code srcBufferRange} <b>must</b> be less than or equal to the size of {@code srcBuffer} minus {@code srcBufferOffset}</li>
            <li>If {@code pSetupReferenceSlot} is not {@code NULL}, then its {@code slotIndex} member <b>must</b> not be negative</li>
            <li>If {@code pSetupReferenceSlot} is not {@code NULL}, then its {@code pPictureResource} <b>must</b> not be {@code NULL}</li>
            <li>The {@code slotIndex} member of each element of {@code pReferenceSlots} <b>must</b> not be negative</li>
            <li>The {@code pPictureResource} member of each element of {@code pReferenceSlots} <b>must</b> not be {@code NULL}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkVideoDecodeAV1PictureInfoKHR, ##VkVideoDecodeH264PictureInfoKHR, ##VkVideoDecodeH265PictureInfoKHR, or ##VkVideoInlineQueryInfoKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code srcBuffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>{@code dstPictureResource} <b>must</b> be a valid ##VkVideoPictureResourceInfoKHR structure</li>
            <li>If {@code pSetupReferenceSlot} is not {@code NULL}, {@code pSetupReferenceSlot} <b>must</b> be a valid pointer to a valid ##VkVideoReferenceSlotInfoKHR structure</li>
            <li>If {@code referenceSlotCount} is not 0, {@code pReferenceSlots} <b>must</b> be a valid pointer to an array of {@code referenceSlotCount} valid ##VkVideoReferenceSlotInfoKHR structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoPictureResourceInfoKHR, ##VkVideoReferenceSlotInfoKHR, #CmdDecodeVideoKHR()
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkVideoDecodeAV1PictureInfoKHR", "VkVideoDecodeH264PictureInfoKHR", "VkVideoDecodeH265PictureInfoKHR", "VkVideoInlineQueryInfoKHR",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkVideoDecodeFlagsKHR("flags", "reserved for future use.")
    VkBuffer("srcBuffer", "the source video bitstream buffer to read the encoded bitstream from.")
    VkDeviceSize("srcBufferOffset", "the starting offset in bytes from the start of {@code srcBuffer} to read the encoded bitstream from.")
    VkDeviceSize("srcBufferRange", "the size in bytes of the encoded bitstream to decode from {@code srcBuffer}, starting from {@code srcBufferOffset}.")
    VkVideoPictureResourceInfoKHR("dstPictureResource", "the video picture resource to use as the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-output-picture\">decode output picture</a>.")
    nullable..VkVideoReferenceSlotInfoKHR.const.p("pSetupReferenceSlot", "{@code NULL} or a pointer to a ##VkVideoReferenceSlotInfoKHR structure specifying the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-reconstructed-picture-info\">reconstructed picture information</a>.")
    AutoSize("pReferenceSlots", optional = true)..uint32_t("referenceSlotCount", "the number of elements in the {@code pReferenceSlots} array.")
    VkVideoReferenceSlotInfoKHR.const.p("pReferenceSlots", "{@code NULL} or a pointer to an array of ##VkVideoReferenceSlotInfoKHR structures describing the DPB slots and corresponding <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#reference-picture\">reference picture</a> resources to use in this video decode operation (the set of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#active-reference-pictures\">active reference pictures</a>).")
}

val VkDedicatedAllocationImageCreateInfoNV = struct(Module.VULKAN, "VkDedicatedAllocationImageCreateInfoNV") {
    documentation =
        """
        Specify that an image is bound to a dedicated memory resource.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Using a dedicated allocation for color and depth/stencil attachments or other large images <b>may</b> improve performance on some devices.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code dedicatedAllocation} is #TRUE, ##VkImageCreateInfo{@code ::flags} <b>must</b> not include #IMAGE_CREATE_SPARSE_BINDING_BIT, #IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or #IMAGE_CREATE_SPARSE_ALIASED_BIT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("dedicatedAllocation", "specifies whether the image will have a dedicated allocation bound to it.")
}

val VkDedicatedAllocationBufferCreateInfoNV = struct(Module.VULKAN, "VkDedicatedAllocationBufferCreateInfoNV") {
    documentation =
        """
        Specify that a buffer is bound to a dedicated memory resource.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("dedicatedAllocation", "specifies whether the buffer will have a dedicated allocation bound to it.")
}

val VkDedicatedAllocationMemoryAllocateInfoNV = struct(Module.VULKAN, "VkDedicatedAllocationMemoryAllocateInfoNV") {
    documentation =
        """
        Specify a dedicated memory allocation resource.

        <h5>Valid Usage</h5>
        <ul>
            <li>At least one of {@code image} and {@code buffer} <b>must</b> be #NULL_HANDLE</li>
            <li>If {@code image} is not #NULL_HANDLE, the image <b>must</b> have been created with ##VkDedicatedAllocationImageCreateInfoNV{@code ::dedicatedAllocation} equal to #TRUE</li>
            <li>If {@code buffer} is not #NULL_HANDLE, the buffer <b>must</b> have been created with ##VkDedicatedAllocationBufferCreateInfoNV{@code ::dedicatedAllocation} equal to #TRUE</li>
            <li>If {@code image} is not #NULL_HANDLE, ##VkMemoryAllocateInfo{@code ::allocationSize} <b>must</b> equal the ##VkMemoryRequirements{@code ::size} of the image</li>
            <li>If {@code buffer} is not #NULL_HANDLE, ##VkMemoryAllocateInfo{@code ::allocationSize} <b>must</b> equal the ##VkMemoryRequirements{@code ::size} of the buffer</li>
            <li>If {@code image} is not #NULL_HANDLE and ##VkMemoryAllocateInfo defines a memory import operation, the memory being imported <b>must</b> also be a dedicated image allocation and {@code image} <b>must</b> be identical to the image associated with the imported memory</li>
            <li>If {@code buffer} is not #NULL_HANDLE and ##VkMemoryAllocateInfo defines a memory import operation, the memory being imported <b>must</b> also be a dedicated buffer allocation and {@code buffer} <b>must</b> be identical to the buffer associated with the imported memory</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV</li>
            <li>If {@code image} is not #NULL_HANDLE, {@code image} <b>must</b> be a valid {@code VkImage} handle</li>
            <li>If {@code buffer} is not #NULL_HANDLE, {@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>Both of {@code buffer}, and {@code image} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkImage("image", "#NULL_HANDLE or a handle of an image which this memory will be bound to.")
    VkBuffer("buffer", "#NULL_HANDLE or a handle of a buffer which this memory will be bound to.")
}

val VkPhysicalDeviceTransformFeedbackFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceTransformFeedbackFeaturesEXT") {
    documentation =
        """
        Structure describing transform feedback features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceTransformFeedbackFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceTransformFeedbackFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("transformFeedback", "indicates whether the implementation supports transform feedback and shader modules <b>can</b> declare the {@code TransformFeedback} capability.")
    VkBool32("geometryStreams", "indicates whether the implementation supports the {@code GeometryStreams} SPIR-V capability.")
}

val VkPhysicalDeviceTransformFeedbackPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceTransformFeedbackPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure describing transform feedback properties that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceTransformFeedbackPropertiesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("maxTransformFeedbackStreams", "the maximum number of vertex streams that can be output from geometry shaders declared with the {@code GeometryStreams} capability. If the implementation does not support ##VkPhysicalDeviceTransformFeedbackFeaturesEXT{@code ::geometryStreams} then {@code maxTransformFeedbackStreams} <b>must</b> be 1.")
    uint32_t("maxTransformFeedbackBuffers", "the maximum number of transform feedback buffers that can be bound for capturing shader outputs from the last <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#pipelines-graphics-subsets-pre-rasterization\">pre-rasterization shader stage</a>.")
    VkDeviceSize("maxTransformFeedbackBufferSize", "the maximum size that can be specified when binding a buffer for transform feedback in #CmdBindTransformFeedbackBuffersEXT().")
    uint32_t("maxTransformFeedbackStreamDataSize", "the maximum amount of data in bytes for each vertex that captured to one or more transform feedback buffers associated with a specific vertex stream.")
    uint32_t("maxTransformFeedbackBufferDataSize", "the maximum amount of data in bytes for each vertex that can be captured to a specific transform feedback buffer.")
    uint32_t("maxTransformFeedbackBufferDataStride", "the maximum stride between each capture of vertex data to the buffer.")
    VkBool32("transformFeedbackQueries", "#TRUE if the implementation supports the #QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT query type. {@code transformFeedbackQueries} is #FALSE if queries of this type <b>cannot</b> be created.")
    VkBool32("transformFeedbackStreamsLinesTriangles", "#TRUE if the implementation supports the geometry shader {@code OpExecutionMode} of {@code OutputLineStrip} and {@code OutputTriangleStrip} in addition to {@code OutputPoints} when more than one vertex stream is output. If {@code transformFeedbackStreamsLinesTriangles} is #FALSE the implementation only supports an {@code OpExecutionMode} of {@code OutputPoints} when more than one vertex stream is output from the geometry shader.")
    VkBool32("transformFeedbackRasterizationStreamSelect", "#TRUE if the implementation supports the {@code GeometryStreams} SPIR-V capability and the application can use ##VkPipelineRasterizationStateStreamCreateInfoEXT to modify which vertex stream output is used for rasterization. Otherwise vertex stream 0 <b>must</b> always be used for rasterization.")
    VkBool32("transformFeedbackDraw", "#TRUE if the implementation supports the #CmdDrawIndirectByteCountEXT() function otherwise the function <b>must</b> not be called.")
}

val VkPipelineRasterizationStateStreamCreateInfoEXT = struct(Module.VULKAN, "VkPipelineRasterizationStateStreamCreateInfoEXT") {
    documentation =
        """
        Structure defining the geometry stream used for rasterization.

        <h5>Description</h5>
        If this structure is not present, {@code rasterizationStream} is assumed to be zero.

        <h5>Valid Usage</h5>
        <ul>
            <li>##VkPhysicalDeviceTransformFeedbackFeaturesEXT{@code ::geometryStreams} <b>must</b> be enabled</li>
            <li>{@code rasterizationStream} <b>must</b> be less than ##VkPhysicalDeviceTransformFeedbackPropertiesEXT{@code ::maxTransformFeedbackStreams}</li>
            <li>{@code rasterizationStream} <b>must</b> be zero if ##VkPhysicalDeviceTransformFeedbackPropertiesEXT{@code ::transformFeedbackRasterizationStreamSelect} is #FALSE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineRasterizationStateStreamCreateFlagsEXT("flags", "reserved for future use.")
    uint32_t("rasterizationStream", "the vertex stream selected for rasterization.")
}

val VkCuModuleCreateInfoNVX = struct(Module.VULKAN, "VkCuModuleCreateInfoNVX") {
    documentation =
        """
        Stub description of VkCuModuleCreateInfoNVX.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkCuModuleTexturingModeCreateInfoNVX</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>If {@code dataSize} is not 0, {@code pData} <b>must</b> be a valid pointer to an array of {@code dataSize} bytes</li>
        </ul>

        <h5>See Also</h5>
        #CreateCuModuleNVX()
        """

    Expression("#STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX")..VkStructureType("sType", "")
    PointerSetter(
        "VkCuModuleTexturingModeCreateInfoNVX",
        prepend = true
    )..nullable..opaque_const_p("pNext", "")
    AutoSize("pData", optional = true)..size_t("dataSize", "")
    void.const.p("pData", "")
}

val VkCuModuleTexturingModeCreateInfoNVX = struct(Module.VULKAN, "VkCuModuleTexturingModeCreateInfoNVX") {
    documentation =
        """
        Stub description of VkCuModuleTexturingModeCreateInfoNVX.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_CU_MODULE_TEXTURING_MODE_CREATE_INFO_NVX</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_CU_MODULE_TEXTURING_MODE_CREATE_INFO_NVX")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkBool32("use64bitTexturing", "")
}

val VkCuFunctionCreateInfoNVX = struct(Module.VULKAN, "VkCuFunctionCreateInfoNVX") {
    documentation =
        """
        Stub description of VkCuFunctionCreateInfoNVX.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code module} <b>must</b> be a valid {@code VkCuModuleNVX} handle</li>
            <li>{@code pName} <b>must</b> be a null-terminated UTF-8 string</li>
        </ul>

        <h5>See Also</h5>
        #CreateCuFunctionNVX()
        """

    Expression("#STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkCuModuleNVX("module", "")
    charUTF8.const.p("pName", "")
}

val VkCuLaunchInfoNVX = struct(Module.VULKAN, "VkCuLaunchInfoNVX") {
    documentation =
        """
        Stub description of VkCuLaunchInfoNVX.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code function} <b>must</b> be a valid {@code VkCuFunctionNVX} handle</li>
            <li>If {@code paramCount} is not 0, {@code pParams} <b>must</b> be a valid pointer to an array of {@code paramCount} bytes</li>
            <li>If {@code extraCount} is not 0, {@code pExtras} <b>must</b> be a valid pointer to an array of {@code extraCount} bytes</li>
        </ul>

        <h5>See Also</h5>
        #CmdCuLaunchKernelNVX()
        """

    Expression("#STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkCuFunctionNVX("function", "")
    uint32_t("gridDimX", "")
    uint32_t("gridDimY", "")
    uint32_t("gridDimZ", "")
    uint32_t("blockDimX", "")
    uint32_t("blockDimY", "")
    uint32_t("blockDimZ", "")
    uint32_t("sharedMemBytes", "")
    AutoSize("pParams", optional = true)..size_t("paramCount", "")
    void.const.p.const.p("pParams", "")
    AutoSize("pExtras", optional = true)..size_t("extraCount", "")
    void.const.p.const.p("pExtras", "")
}

val VkImageViewHandleInfoNVX = struct(Module.VULKAN, "VkImageViewHandleInfoNVX") {
    documentation =
        """
        Structure specifying the image view for handle queries.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code descriptorType} <b>must</b> be #DESCRIPTOR_TYPE_SAMPLED_IMAGE, #DESCRIPTOR_TYPE_STORAGE_IMAGE, or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER</li>
            <li>{@code sampler} <b>must</b> be a valid {@code VkSampler} if {@code descriptorType} is #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER</li>
            <li>If descriptorType is #DESCRIPTOR_TYPE_SAMPLED_IMAGE or #DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the image that {@code imageView} was created from <b>must</b> have been created with the #IMAGE_USAGE_SAMPLED_BIT usage bit set</li>
            <li>If descriptorType is #DESCRIPTOR_TYPE_STORAGE_IMAGE, the image that {@code imageView} was created from <b>must</b> have been created with the #IMAGE_USAGE_STORAGE_BIT usage bit set</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code imageView} <b>must</b> be a valid {@code VkImageView} handle</li>
            <li>{@code descriptorType} <b>must</b> be a valid {@code VkDescriptorType} value</li>
            <li>If {@code sampler} is not #NULL_HANDLE, {@code sampler} <b>must</b> be a valid {@code VkSampler} handle</li>
            <li>Both of {@code imageView}, and {@code sampler} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #GetImageViewHandle64NVX(), #GetImageViewHandleNVX()
        """

    Expression("#STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkImageView("imageView", "the image view to query.")
    VkDescriptorType("descriptorType", "the type of descriptor for which to query a handle.")
    VkSampler("sampler", "the sampler to combine with the image view when generating the handle.")
}

val VkImageViewAddressPropertiesNVX = struct(Module.VULKAN, "VkImageViewAddressPropertiesNVX", mutable = false) {
    documentation =
        """
        Structure specifying the image view for handle queries.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetImageViewAddressNVX()
        """

    Expression("#STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkDeviceAddress("deviceAddress", "the device address of the image view.")
    VkDeviceSize("size", "the size in bytes of the image view device memory.")
}

val VkVideoEncodeH264CapabilitiesKHR = struct(Module.VULKAN, "VkVideoEncodeH264CapabilitiesKHR", mutable = false) {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure describing H.264 encode capabilities.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkVideoEncodeH264CapabilityFlagsKHR("flags", "a bitmask of {@code VkVideoEncodeH264CapabilityFlagBitsKHR} indicating supported H.264 encoding capabilities.")
    StdVideoH264LevelIdc("maxLevelIdc", "a {@code StdVideoH264LevelIdc} value indicating the maximum H.264 level supported by the profile, where enum constant {@code STD_VIDEO_H264_LEVEL_IDC_&lt;major&gt;_&lt;minor&gt;} identifies H.264 level {@code &lt;major&gt;.&lt;minor&gt;} as defined in section A.3 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h264\">ITU-T H.264 Specification</a>.")
    uint32_t("maxSliceCount", "indicates the maximum number of slices that <b>can</b> be encoded for a single picture. Further restrictions <b>may</b> apply to the number of slices that <b>can</b> be encoded for a single picture depending on other capabilities and codec-specific rules.")
    uint32_t("maxPPictureL0ReferenceCount", """indicates the maximum number of reference pictures the implementation supports in the reference list L0 for <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-p-pic">P pictures</a>.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        As implementations <b>may</b> <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-overrides">override</a> the reference lists, {@code maxPPictureL0ReferenceCount} does not limit the number of elements that the application <b>can</b> specify in the L0 reference list for P pictures. However, if {@code maxPPictureL0ReferenceCount} is zero, then the use of P pictures is not allowed.
        </div>""")
    uint32_t("maxBPictureL0ReferenceCount", "indicates the maximum number of reference pictures the implementation supports in the reference list L0 for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-b-pic\">B pictures</a>.")
    uint32_t("maxL1ReferenceCount", """indicates the maximum number of reference pictures the implementation supports in the reference list L1 if encoding of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-b-pic">B pictures</a> is supported.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        As implementations <b>may</b> <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-overrides">override</a> the reference lists, {@code maxBPictureL0ReferenceCount} and {@code maxL1ReferenceCount} does not limit the number of elements that the application <b>can</b> specify in the L0 and L1 reference lists for B pictures. However, if {@code maxBPictureL0ReferenceCount} and {@code maxL1ReferenceCount} are both zero, then the use of B pictures is not allowed.
        </div>""")
    uint32_t("maxTemporalLayerCount", "indicates the maximum number of H.264 temporal layers supported by the implementation.")
    VkBool32("expectDyadicTemporalLayerPattern", "indicates that the implementation’s rate control algorithms expect the application to use a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-layer-pattern-dyadic\">dyadic temporal layer pattern</a> when encoding multiple temporal layers.")
    int32_t("minQp", "indicates the minimum QP value supported.")
    int32_t("maxQp", "indicates the maximum QP value supported.")
    VkBool32("prefersGopRemainingFrames", "indicates that the implementation’s rate control algorithm prefers the application to specify the number of frames of each type <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-gop-remaining-frames\">remaining</a> in the current <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-gop\">group of pictures</a> when beginning a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#video-coding-scope\">video coding scope</a>.")
    VkBool32("requiresGopRemainingFrames", "indicates that the implementation’s rate control algorithm requires the application to specify the number of frames of each type <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-gop-remaining-frames\">remaining</a> in the current <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-gop\">group of pictures</a> when beginning a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#video-coding-scope\">video coding scope</a>.")
    VkVideoEncodeH264StdFlagsKHR("stdSyntaxFlags", "a bitmask of {@code VkVideoEncodeH264StdFlagBitsKHR} indicating capabilities related to H.264 syntax elements.")
}

val VkVideoEncodeH264QpKHR = struct(Module.VULKAN, "VkVideoEncodeH264QpKHR") {
    documentation =
        """
        Structure describing H.264 QP values per picture type.

        <h5>See Also</h5>
        ##VkVideoEncodeH264QualityLevelPropertiesKHR, ##VkVideoEncodeH264RateControlLayerInfoKHR
        """

    int32_t("qpI", "the QP to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-i-pic\">I pictures</a>.")
    int32_t("qpP", "the QP to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-p-pic\">P pictures</a>.")
    int32_t("qpB", "the QP to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-b-pic\">B pictures</a>.")
}

val VkVideoEncodeH264QualityLevelPropertiesKHR = struct(Module.VULKAN, "VkVideoEncodeH264QualityLevelPropertiesKHR", mutable = false) {
    documentation =
        """
        Structure describing the H.264 encode quality level properties.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUALITY_LEVEL_PROPERTIES_KHR</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH264QpKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUALITY_LEVEL_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkVideoEncodeH264RateControlFlagsKHR("preferredRateControlFlags", "a bitmask of {@code VkVideoEncodeH264RateControlFlagBitsKHR} values indicating the preferred flags to use for ##VkVideoEncodeH264RateControlInfoKHR{@code ::flags}.")
    uint32_t("preferredGopFrameCount", "indicates the preferred value to use for ##VkVideoEncodeH264RateControlInfoKHR{@code ::gopFrameCount}.")
    uint32_t("preferredIdrPeriod", "indicates the preferred value to use for ##VkVideoEncodeH264RateControlInfoKHR{@code ::idrPeriod}.")
    uint32_t("preferredConsecutiveBFrameCount", "indicates the preferred value to use for ##VkVideoEncodeH264RateControlInfoKHR{@code ::consecutiveBFrameCount}.")
    uint32_t("preferredTemporalLayerCount", "indicates the preferred value to use for ##VkVideoEncodeH264RateControlInfoKHR{@code ::temporalLayerCount}.")
    VkVideoEncodeH264QpKHR("preferredConstantQp", "indicates the preferred values to use for ##VkVideoEncodeH264NaluSliceInfoKHR{@code ::constantQp} for each picture type when using <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-rate-control-modes\">rate control mode</a> #VIDEO_ENCODE_RATE_CONTROL_MODE_DISABLED_BIT_KHR.")
    uint32_t("preferredMaxL0ReferenceCount", "indicates the preferred maximum number of reference pictures to use in the reference list L0.")
    uint32_t("preferredMaxL1ReferenceCount", "indicates the preferred maximum number of reference pictures to use in the reference list L1.")
    VkBool32("preferredStdEntropyCodingModeFlag", "indicates the preferred value to use for {@code entropy_coding_mode_flag} in {@code StdVideoH264PpsFlags}.")
}

val VkVideoEncodeH264SessionCreateInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264SessionCreateInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.264 encode session parameters.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("useMaxLevelIdc", "indicates whether the value of {@code maxLevelIdc} should be used by the implementation. When it is #FALSE, the implementation ignores the value of {@code maxLevelIdc} and uses the value of ##VkVideoEncodeH264CapabilitiesKHR{@code ::maxLevelIdc}, as reported by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile.")
    StdVideoH264LevelIdc("maxLevelIdc", "a {@code StdVideoH264LevelIdc} value specifying the upper bound on the H.264 level for the video bitstreams produced by the created video session, where enum constant {@code STD_VIDEO_H264_LEVEL_IDC_&lt;major&gt;_&lt;minor&gt;} identifies H.264 level {@code &lt;major&gt;.&lt;minor&gt;} as defined in section A.3 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h264\">ITU-T H.264 Specification</a>.")
}

val VkVideoEncodeH264SessionParametersAddInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264SessionParametersAddInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.264 encoder parameter set information.

        <h5>Description</h5>
        This structure <b>can</b> be specified in the following places:

        <ul>
            <li>In the {@code pParametersAddInfo} member of the ##VkVideoEncodeH264SessionParametersCreateInfoKHR structure specified in the {@code pNext} chain of ##VkVideoSessionParametersCreateInfoKHR used to create a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters">video session parameters</a> object. In this case, if the video codec operation the video session parameters object is created with is #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, then it defines the set of initial parameters to add to the created object (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#creating-video-session-parameters">Creating Video Session Parameters</a>).</li>
            <li>In the {@code pNext} chain of ##VkVideoSessionParametersUpdateInfoKHR. In this case, if the video codec operation the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters">video session parameters</a> object to be updated was created with is #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, then it defines the set of parameters to add to it (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters-update">Updating Video Session Parameters</a>).</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code seq_parameter_set_id} member of each {@code StdVideoH264SequenceParameterSet} structure specified in the elements of {@code pStdSPSs} <b>must</b> be unique within {@code pStdSPSs}</li>
            <li>The pair constructed from the {@code seq_parameter_set_id} and {@code pic_parameter_set_id} members of each {@code StdVideoH264PictureParameterSet} structure specified in the elements of {@code pStdPPSs} <b>must</b> be unique within {@code pStdPPSs}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR</li>
            <li>If {@code stdSPSCount} is not 0, and {@code pStdSPSs} is not {@code NULL}, {@code pStdSPSs} <b>must</b> be a valid pointer to an array of {@code stdSPSCount} {@code StdVideoH264SequenceParameterSet} values</li>
            <li>If {@code stdPPSCount} is not 0, and {@code pStdPPSs} is not {@code NULL}, {@code pStdPPSs} <b>must</b> be a valid pointer to an array of {@code stdPPSCount} {@code StdVideoH264PictureParameterSet} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH264SessionParametersCreateInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pStdSPSs", optional = true)..uint32_t("stdSPSCount", "the number of elements in the {@code pStdSPSs} array.")
    nullable..StdVideoH264SequenceParameterSet.const.p("pStdSPSs", "a pointer to an array of {@code StdVideoH264SequenceParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-sps\">H.264 SPS</a> entries to add.")
    AutoSize("pStdPPSs", optional = true)..uint32_t("stdPPSCount", "the number of elements in the {@code pStdPPSs} array.")
    nullable..StdVideoH264PictureParameterSet.const.p("pStdPPSs", "a pointer to an array of {@code StdVideoH264PictureParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-pps\">H.264 PPS</a> entries to add.")
}

val VkVideoEncodeH264SessionParametersCreateInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264SessionParametersCreateInfoKHR") {
    documentation =
        """
        Structure specifies H.264 encoder parameter set information.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR</li>
            <li>If {@code pParametersAddInfo} is not {@code NULL}, {@code pParametersAddInfo} <b>must</b> be a valid pointer to a valid ##VkVideoEncodeH264SessionParametersAddInfoKHR structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH264SessionParametersAddInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("maxStdSPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-sps\">H.264 SPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    uint32_t("maxStdPPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-pps\">H.264 PPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    nullable..VkVideoEncodeH264SessionParametersAddInfoKHR.const.p("pParametersAddInfo", "{@code NULL} or a pointer to a ##VkVideoEncodeH264SessionParametersAddInfoKHR structure specifying H.264 parameters to add upon object creation.")
}

val VkVideoEncodeH264SessionParametersGetInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264SessionParametersGetInfoKHR") {
    documentation =
        """
        Structure specifying parameters for retrieving encoded H.264 parameter set data.

        <h5>Description</h5>
        When this structure is specified in the {@code pNext} chain of the ##VkVideoEncodeSessionParametersGetInfoKHR structure passed to #GetEncodedVideoSessionParametersKHR(), the command will write encoded parameter data to the output buffer in the following order:

        <ul>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-sps">H.264 sequence parameter set</a> identified by {@code stdSPSId}, if {@code writeStdSPS} is #TRUE.</li>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-pps">H.264 picture parameter set</a> identified by the pair constructed from {@code stdSPSId} and {@code stdPPSId}, if {@code writeStdPPS} is #TRUE.</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>At least one of {@code writeStdSPS} and {@code writeStdPPS} <b>must</b> be #TRUE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("writeStdSPS", "indicates whether the encoded <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-sps\">H.264 sequence parameter set</a> identified by {@code stdSPSId} is requested to be retrieved.")
    VkBool32("writeStdPPS", "indicates whether the encoded <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-pps\">H.264 picture parameter set</a> identified by the pair constructed from {@code stdSPSId} and {@code stdPPSId} is requested to be retrieved.")
    uint32_t("stdSPSId", "specifies the H.264 sequence parameter set ID used to identify the retrieved H.264 sequence and/or picture parameter set(s).")
    uint32_t("stdPPSId", "specifies the H.264 picture parameter set ID used to identify the retrieved H.264 picture parameter set when {@code writeStdPPS} is #TRUE.")
}

val VkVideoEncodeH264SessionParametersFeedbackInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264SessionParametersFeedbackInfoKHR", mutable = false) {
    documentation =
        """
        Structure providing feedback about the requested H.264 video session parameters.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_FEEDBACK_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_FEEDBACK_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkBool32("hasStdSPSOverrides", "indicates whether any of the parameters of the requested <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-sps\">H.264 sequence parameter set</a>, if one was requested via ##VkVideoEncodeH264SessionParametersGetInfoKHR{@code ::writeStdSPS}, were <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-overrides\">overridden</a> by the implementation.")
    VkBool32("hasStdPPSOverrides", "indicates whether any of the parameters of the requested <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-pps\">H.264 picture parameter set</a>, if one was requested via ##VkVideoEncodeH264SessionParametersGetInfoKHR{@code ::writeStdPPS}, were <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-overrides\">overridden</a> by the implementation.")
}

val VkVideoEncodeH264NaluSliceInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264NaluSliceInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.264 encode slice NALU parameters.

        <h5>Description</h5>
        <dl>
            <dt>Std Slice Header Parameters</dt>
            <dd><ul>
                <li>{@code flags.reserved} and {@code reserved1} are used only for padding purposes and are otherwise ignored;</li>
                <li>
                    if {@code pWeightTable} is not {@code NULL}, then it is a pointer to a {@code StdVideoEncodeH264WeightTable} that is interpreted as follows:
                    <ul>
                        <li>{@code flags.reserved} is used only for padding purposes and is otherwise ignored;</li>
                        <li>all other members of {@code StdVideoEncodeH264WeightTable} are interpreted as defined in section 7.4.3.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                    </ul>
                </li>
                <li>all other members are interpreted as defined in section 7.4.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>.</li>
            </ul></dd>
        </dl>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code pStdSliceHeader} <b>must</b> be a valid pointer to a valid {@code StdVideoEncodeH264SliceHeader} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH264PictureInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    int32_t("constantQp", "the QP to use for the slice if the current <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-rate-control-modes\">rate control mode</a> configured for the video session is #VIDEO_ENCODE_RATE_CONTROL_MODE_DISABLED_BIT_KHR.")
    StdVideoEncodeH264SliceHeader.const.p("pStdSliceHeader", "a pointer to a {@code StdVideoEncodeH264SliceHeader} structure specifying <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-slice-header-params\">H.264 slice header parameters</a> for the slice.")
}

val VkVideoEncodeH264PictureInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264PictureInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.264 encode frame parameters.

        <h5>Description</h5>
        This structure is specified in the {@code pNext} chain of the ##VkVideoEncodeInfoKHR structure passed to #CmdEncodeVideoKHR() to specify the codec-specific picture information for an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264">H.264 encode operation</a>.

        <dl>
            <dt>Encode Input Picture Information</dt>
            <dd><ul>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-picture-data-access">H.264 Encode Picture Data Access</a> section.</li>
                <li>The encode input picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-picture-info">H.264 picture information</a> provided in {@code pStdPictureInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Std Picture Information</dt>
            <dd><ul>
                <li>{@code flags.reserved} and {@code reserved1} are used only for padding purposes and are otherwise ignored;</li>
                <li>{@code flags.IdrPicFlag} as defined in section 7.4.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code flags.is_reference} as defined in section 3.136 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code seq_parameter_set_id} and {@code pic_parameter_set_id} are used to identify the active parameter sets, as described below;</li>
                <li>{@code primary_pic_type} as defined in section 7.4.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code PicOrderCnt} as defined in section 8.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code temporal_id} as defined in section G.7.4.1.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>
                    if {@code pRefLists} is not {@code NULL}, then it is a pointer to a {@code StdVideoEncodeH264ReferenceListsInfo} structure that is interpreted as follows:
                    <ul>
                        <li>{@code flags.reserved} is used only for padding purposes and is otherwise ignored;</li>
                        <li>{@code ref_pic_list_modification_flag_l0} and {@code ref_pic_list_modification_flag_l1} as defined in section 7.4.3.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                        <li>{@code num_ref_idx_l0_active_minus1} and {@code num_ref_idx_l1_active_minus1} as defined in section 7.4.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                        <li>{@code RefPicList0} and {@code RefPicList1} as defined in section 8.2.4 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a> where each element of these arrays either identifies an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-active-reference-picture-info">active reference picture</a> using its <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> index or contains the value {@code STD_VIDEO_H264_NO_REFERENCE_PICTURE} to indicate “no reference picture”;</li>
                        <li>if {@code refList0ModOpCount} is not zero, then {@code pRefList0ModOperations} is a pointer to an array of {@code refList0ModOpCount} number of {@code StdVideoEncodeH264RefListModEntry} structures specifying the modification parameters for the reference list L0 as defined in section 7.4.3.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                        <li>if {@code refList1ModOpCount} is not zero, then {@code pRefList1ModOperations} is a pointer to an array of {@code refList1ModOpCount} number of {@code StdVideoEncodeH264RefListModEntry} structures specifying the modification parameters for the reference list L1 as defined in section 7.4.3.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                        <li>if {@code refPicMarkingOpCount} is not zero, then {@code refPicMarkingOperations} is a pointer to an array of {@code refPicMarkingOpCount} number of {@code StdVideoEncodeH264RefPicMarkingEntry} structures specifying the reference picture marking parameters as defined in section 7.4.3.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                    </ul>
                </li>
                <li>all other members are interpreted as defined in section 7.4.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>.</li>
            </ul></dd>
        </dl>

        Reference picture setup is controlled by the value of {@code StdVideoEncodeH264PictureInfo}{@code ::flags.is_reference}. If it is set and a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-reconstructed-picture-info">reconstructed picture</a> is specified, then the latter is used as the target of picture reconstruction to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">activate</a> the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> specified in {@code pEncodeInfo→pSetupReferenceSlot→slotIndex}. If {@code StdVideoEncodeH264PictureInfo}{@code ::flags.is_reference} is not set, but a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-reconstructed-picture-info">reconstructed picture</a> is specified, then the corresponding picture reference associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> is invalidated, as described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">DPB Slot States</a> section.

        <dl>
            <dt>Active Parameter Sets</dt>
            <dd><ul>
                <li>The <em>active SPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-sps">SPS</a> identified by the key specified in {@code StdVideoEncodeH264PictureInfo}{@code ::seq_parameter_set_id}.</li>
                <li>The <em>active PPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-pps">PPS</a> identified by the key specified by the pair constructed from {@code StdVideoEncodeH264PictureInfo}{@code ::seq_parameter_set_id} and {@code StdVideoEncodeH264PictureInfo}{@code ::pic_parameter_set_id}.</li>
            </ul></dd>
        </dl>

        H.264 encoding uses <em>explicit weighted sample prediction</em> for a slice, as defined in section 8.4.2.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>, if any of the following conditions are true for the active <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-pps">PPS</a> and the {@code pStdSliceHeader} member of the corresponding element of {@code pNaluSliceEntries}:

        <ul>
            <li>{@code pStdSliceHeader→slice_type} is {@code STD_VIDEO_H264_SLICE_TYPE_P} and {@code weighted_pred_flag} is enabled in the active PPS.</li>
            <li>{@code pStdSliceHeader→slice_type} is {@code STD_VIDEO_H264_SLICE_TYPE_B} and {@code weighted_bipred_idc} in the active PPS equals {@code STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_EXPLICIT}.</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code naluSliceEntryCount} <b>must</b> be between 1 and ##VkVideoEncodeH264CapabilitiesKHR{@code ::maxSliceCount}, inclusive, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile</li>
            <li>If ##VkVideoEncodeH264CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H264_CAPABILITY_GENERATE_PREFIX_NALU_BIT_KHR, then {@code generatePrefixNalu} <b>must</b> be #FALSE</li>
            <li>If ##VkVideoEncodeH264CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H264_CAPABILITY_PREDICTION_WEIGHT_TABLE_GENERATED_BIT_KHR and the slice corresponding to any element of {@code pNaluSliceEntries} uses <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-weighted-pred">explicit weighted sample prediction</a>, then ##VkVideoEncodeH264NaluSliceInfoKHR{@code ::pStdSliceHeader→pWeightTable} <b>must</b> not be {@code NULL} for that element of {@code pNaluSliceEntries}</li>
            <li>If ##VkVideoEncodeH264CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H264_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_KHR, then ##VkVideoEncodeH264NaluSliceInfoKHR{@code ::pStdSliceHeader→slice_type} <b>must</b> be identical for all elements of {@code pNaluSliceEntries}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR</li>
            <li>{@code pNaluSliceEntries} <b>must</b> be a valid pointer to an array of {@code naluSliceEntryCount} valid ##VkVideoEncodeH264NaluSliceInfoKHR structures</li>
            <li>{@code pStdPictureInfo} <b>must</b> be a valid pointer to a valid {@code StdVideoEncodeH264PictureInfo} value</li>
            <li>{@code naluSliceEntryCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH264NaluSliceInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pNaluSliceEntries")..uint32_t("naluSliceEntryCount", "the number of elements in {@code pNaluSliceEntries}.")
    VkVideoEncodeH264NaluSliceInfoKHR.const.p("pNaluSliceEntries", "a pointer to an array of {@code naluSliceEntryCount} ##VkVideoEncodeH264NaluSliceInfoKHR structures specifying the parameters of the individual H.264 slices to encode for the input picture.")
    StdVideoEncodeH264PictureInfo.const.p("pStdPictureInfo", "a pointer to a {@code StdVideoEncodeH264PictureInfo} structure specifying <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-picture-info\">H.264 picture information</a>.")
    VkBool32("generatePrefixNalu", "controls whether prefix NALUs are generated before slice NALUs into the target bitstream, as defined in sections 7.3.2.12 and 7.4.2.12 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h264\">ITU-T H.264 Specification</a>.")
}

val VkVideoEncodeH264DpbSlotInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264DpbSlotInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.264 encode DPB picture information.

        <h5>Description</h5>
        This structure is specified in the {@code pNext} chain of ##VkVideoEncodeInfoKHR{@code ::pSetupReferenceSlot}, if not {@code NULL}, and the {@code pNext} chain of the elements of ##VkVideoEncodeInfoKHR{@code ::pReferenceSlots} to specify the codec-specific reference picture information for an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264">H.264 encode operation</a>.

        <dl>
            <dt>Active Reference Picture Information</dt>
            <dd><ul>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-picture-data-access">H.264 Encode Picture Data Access</a> section.</li>
                <li>The reference picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> index specified in the {@code slotIndex} member of the corresponding element of ##VkVideoEncodeInfoKHR{@code ::pReferenceSlots}.</li>
                <li>The reference picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-reference-info">H.264 reference information</a> provided in {@code pStdReferenceInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Reconstructed Picture Information</dt>
            <dd><ul>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-picture-data-access">H.264 Encode Picture Data Access</a> section.</li>
                <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-ref-pic-setup">reference picture setup</a> is requested, then the reconstructed picture is used to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">activate</a> the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> with the index specified in ##VkVideoEncodeInfoKHR{@code ::pSetupReferenceSlot→slotIndex}.</li>
                <li>The reconstructed picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-reference-info">H.264 reference information</a> provided in {@code pStdReferenceInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Std Reference Information</dt>
            <dd><ul>
                <li>{@code flags.reserved} is used only for padding purposes and is otherwise ignored;</li>
                <li>{@code flags.used_for_long_term_reference} is used to indicate whether the picture is marked as “used for long-term reference” as defined in section 8.2.5.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code primary_pic_type} as defined in section 7.4.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code long_term_pic_num} and {@code long_term_frame_idx} as defined in section 7.4.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code temporal_id} as defined in section G.7.4.1.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>all other members are interpreted as defined in section 8.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>.</li>
            </ul></dd>
        </dl>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR</li>
            <li>{@code pStdReferenceInfo} <b>must</b> be a valid pointer to a valid {@code StdVideoEncodeH264ReferenceInfo} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoEncodeH264ReferenceInfo.const.p("pStdReferenceInfo", "a pointer to a {@code StdVideoEncodeH264ReferenceInfo} structure specifying <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-reference-info\">H.264 reference information</a>.")
}

val VkVideoEncodeH264ProfileInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264ProfileInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifying H.264 encode-specific video profile parameters.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoH264ProfileIdc("stdProfileIdc", "a {@code StdVideoH264ProfileIdc} value specifying the H.264 codec profile IDC, as defined in section A.2 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h264\">ITU-T H.264 Specification</a>.")
}

val VkVideoEncodeH264RateControlInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264RateControlInfoKHR") {
    documentation =
        """
        Structure describing H.264 stream rate control parameters.

        <h5>Description</h5>
        When an instance of this structure is included in the {@code pNext} chain of the ##VkVideoCodingControlInfoKHR structure passed to the #CmdControlVideoCodingKHR() command, and ##VkVideoCodingControlInfoKHR{@code ::flags} includes #VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_BIT_KHR, the parameters in this structure are used as guidance for the implementation’s rate control algorithm (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-coding-control">Video Coding Control</a>).

        If {@code flags} includes #VIDEO_ENCODE_H264_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR, then the rate control state is reset to an initial state to meet HRD compliance requirements. Otherwise the new rate control state <b>may</b> be applied without a reset depending on the implementation and the specified rate control parameters.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        It would be possible to infer the picture type to be used when encoding a frame, on the basis of the values provided for {@code consecutiveBFrameCount}, {@code idrPeriod}, and {@code gopFrameCount}, but this inferred picture type will not be used by implementations to override the picture type provided to the video encode operation.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If ##VkVideoEncodeH264CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H264_CAPABILITY_HRD_COMPLIANCE_BIT_KHR, then {@code flags} <b>must</b> not contain #VIDEO_ENCODE_H264_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR</li>
            <li>If {@code flags} contains #VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR or #VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR, then it <b>must</b> also contain #VIDEO_ENCODE_H264_RATE_CONTROL_REGULAR_GOP_BIT_KHR</li>
            <li>If {@code flags} contains #VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR, then it <b>must</b> not also contain #VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR</li>
            <li>If {@code flags} contains #VIDEO_ENCODE_H264_RATE_CONTROL_REGULAR_GOP_BIT_KHR, then {@code gopFrameCount} <b>must</b> be greater than 0</li>
            <li>If {@code idrPeriod} is not 0, then it <b>must</b> be greater than or equal to {@code gopFrameCount}</li>
            <li>If {@code consecutiveBFrameCount} is not 0, then it <b>must</b> be less than {@code gopFrameCount}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkVideoEncodeH264RateControlFlagBitsKHR} values</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkVideoEncodeH264RateControlFlagsKHR("flags", "a bitmask of {@code VkVideoEncodeH264RateControlFlagBitsKHR} specifying H.264 rate control flags.")
    uint32_t("gopFrameCount", "the number of frames within a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-gop\">group of pictures (GOP)</a> intended to be used by the application. If it is 0, the rate control algorithm <b>may</b> assume an implementation-dependent GOP length. If it is {@code UINT32_MAX}, the GOP length is treated as infinite.")
    uint32_t("idrPeriod", "the interval, in terms of number of frames, between two <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-idr-pic\">IDR frames</a> (see <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-idr-period\">IDR period</a>). If it is 0, the rate control algorithm <b>may</b> assume an implementation-dependent IDR period. If it is {@code UINT32_MAX}, the IDR period is treated as infinite.")
    uint32_t("consecutiveBFrameCount", "the number of consecutive B frames between I and/or P frames within the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-gop\">GOP</a>.")
    uint32_t("temporalLayerCount", "specifies the number of H.264 temporal layers that the application intends to use.")
}

val VkVideoEncodeH264FrameSizeKHR = struct(Module.VULKAN, "VkVideoEncodeH264FrameSizeKHR") {
    documentation =
        """
        Structure describing frame size values per H.264 picture type.

        <h5>See Also</h5>
        ##VkVideoEncodeH264RateControlLayerInfoKHR
        """

    uint32_t("frameISize", "the size in bytes to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-i-pic\">I pictures</a>.")
    uint32_t("framePSize", "the size in bytes to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-p-pic\">P pictures</a>.")
    uint32_t("frameBSize", "the size in bytes to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-b-pic\">B pictures</a>.")
}

val VkVideoEncodeH264RateControlLayerInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264RateControlLayerInfoKHR") {
    documentation =
        """
        Structure describing H.264 per-layer rate control parameters.

        <h5>Description</h5>
        When used, the values in {@code minQp} and {@code maxQp} guarantee that the effective QP values used by the implementation will respect those lower and upper bounds, respectively. However, limiting the range of QP values that the implementation is able to use will also limit the capabilities of the implementation’s rate control algorithm to comply to other constraints. In particular, the implementation <b>may</b> not be able to comply to the following:

        <ul>
            <li>The average and/or peak <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-bitrate">bitrate</a> values to be used for the encoded bitstream specified in the {@code averageBitrate} and {@code maxBitrate} members of the ##VkVideoEncodeRateControlLayerInfoKHR structure.</li>
            <li>The upper bounds on the encoded frame size, for each picture type, specified in the {@code maxFrameSize} member of ##VkVideoEncodeH264RateControlLayerInfoKHR.</li>
        </ul>

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        In general, applications need to configure rate control parameters appropriately in order to be able to get the desired rate control behavior, as described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-rate-control">Video Encode Rate Control</a> section.
        </div>

        When an instance of this structure is included in the {@code pNext} chain of a ##VkVideoEncodeRateControlLayerInfoKHR structure specified in one of the elements of the {@code pLayers} array member of the ##VkVideoEncodeRateControlInfoKHR structure passed to the #CmdControlVideoCodingKHR() command, ##VkVideoCodingControlInfoKHR{@code ::flags} includes #VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_BIT_KHR, and the bound video session was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR, it specifies the H.264-specific rate control parameters of the rate control layer corresponding to that element of {@code pLayers}.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code useMinQp} is #TRUE, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code minQp} <b>must</b> all be between ##VkVideoEncodeH264CapabilitiesKHR{@code ::minQp} and ##VkVideoEncodeH264CapabilitiesKHR{@code ::maxQp}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile</li>
            <li>If {@code useMaxQp} is #TRUE, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code maxQp} <b>must</b> all be between ##VkVideoEncodeH264CapabilitiesKHR{@code ::minQp} and ##VkVideoEncodeH264CapabilitiesKHR{@code ::maxQp}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile</li>
            <li>If {@code useMinQp} is #TRUE and ##VkVideoEncodeH264CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H264_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code minQp} <b>must</b> all specify the same value</li>
            <li>If {@code useMaxQp} is #TRUE and ##VkVideoEncodeH264CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H264_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code maxQp} <b>must</b> all specify the same value</li>
            <li>If {@code useMinQp} and {@code useMaxQp} are both #TRUE, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code minQp} <b>must</b> all be less than or equal to the respective members of {@code maxQp}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR</li>
            <li>{@code minQp} <b>must</b> be a valid ##VkVideoEncodeH264QpKHR structure</li>
            <li>{@code maxQp} <b>must</b> be a valid ##VkVideoEncodeH264QpKHR structure</li>
            <li>{@code maxFrameSize} <b>must</b> be a valid ##VkVideoEncodeH264FrameSizeKHR structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH264FrameSizeKHR, ##VkVideoEncodeH264QpKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("useMinQp", "indicates whether the QP values determined by rate control will be clamped to the lower bounds on the QP values specified in {@code minQp}.")
    VkVideoEncodeH264QpKHR("minQp", "specifies the lower bounds on the QP values, for each picture type, that the implementation’s rate control algorithm will use when {@code useMinQp} is #TRUE.")
    VkBool32("useMaxQp", "indicates whether the QP values determined by rate control will be clamped to the upper bounds on the QP values specified in {@code maxQp}.")
    VkVideoEncodeH264QpKHR("maxQp", "specifies the upper bounds on the QP values, for each picture type, that the implementation’s rate control algorithm will use when {@code useMaxQp} is #TRUE.")
    VkBool32("useMaxFrameSize", "indicates whether the implementation’s rate control algorithm <b>should</b> use the values specified in {@code maxFrameSize} as the upper bounds on the encoded frame size for each picture type.")
    VkVideoEncodeH264FrameSizeKHR("maxFrameSize", "specifies the upper bounds on the encoded frame size, for each picture type, when {@code useMaxFrameSize} is #TRUE.")
}

val VkVideoEncodeH264GopRemainingFrameInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH264GopRemainingFrameInfoKHR") {
    documentation =
        """
        Structure specifying H.264 encode rate control GOP remaining frame counts.

        <h5>Description</h5>
        Setting {@code useGopRemainingFrames} to #TRUE and including this structure in the {@code pNext} chain of ##VkVideoBeginCodingInfoKHR is only mandatory if the ##VkVideoEncodeH264CapabilitiesKHR{@code ::requiresGopRemainingFrames} reported for the used <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-profiles">video profile</a> is #TRUE. However, implementations <b>may</b> use these remaining frame counts, when specified, even when it is not required. In particular, when the application does not use a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h264-regular-gop">regular GOP structure</a>, these values <b>may</b> provide additional guidance for the implementation’s rate control algorithm.

        The ##VkVideoEncodeH264CapabilitiesKHR{@code ::prefersGopRemainingFrames} capability is also used to indicate that the implementation’s rate control algorithm <b>may</b> operate more accurately if the application specifies the remaining frame counts using this structure.

        As with other rate control guidance values, if the effective order and number of frames encoded by the application are not in line with the remaining frame counts specified in this structure at any given point, then the behavior of the implementation’s rate control algorithm <b>may</b> deviate from the one expected by the application.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("useGopRemainingFrames", "indicates whether the implementation’s rate control algorithm <b>should</b> use the values specified in {@code gopRemainingI}, {@code gopRemainingP}, and {@code gopRemainingB}. If {@code useGopRemainingFrames} is #FALSE, then the values of {@code gopRemainingI}, {@code gopRemainingP}, and {@code gopRemainingB} are ignored.")
    uint32_t("gopRemainingI", "specifies the number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-i-pic\">I frames</a> the implementation’s rate control algorithm <b>should</b> assume to be remaining in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-gop\">GOP</a> prior to executing the video encode operation.")
    uint32_t("gopRemainingP", "specifies the number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-p-pic\">P frames</a> the implementation’s rate control algorithm <b>should</b> assume to be remaining in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-gop\">GOP</a> prior to executing the video encode operation.")
    uint32_t("gopRemainingB", "specifies the number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-b-pic\">B frames</a> the implementation’s rate control algorithm <b>should</b> assume to be remaining in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h264-gop\">GOP</a> prior to executing the video encode operation.")
}

val VkVideoEncodeH265CapabilitiesKHR = struct(Module.VULKAN, "VkVideoEncodeH265CapabilitiesKHR", mutable = false) {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure describing H.265 encode capabilities.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_KHR</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkVideoEncodeH265CapabilityFlagsKHR("flags", "a bitmask of {@code VkVideoEncodeH265CapabilityFlagBitsKHR} indicating supported H.265 encoding capabilities.")
    StdVideoH265LevelIdc("maxLevelIdc", "a {@code StdVideoH265LevelIdc} value indicating the maximum H.265 level supported by the profile, where enum constant {@code STD_VIDEO_H265_LEVEL_IDC_&lt;major&gt;_&lt;minor&gt;} identifies H.265 level {@code &lt;major&gt;.&lt;minor&gt;} as defined in section A.4 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h265\">ITU-T H.265 Specification</a>.")
    uint32_t("maxSliceSegmentCount", "indicates the maximum number of slice segments that <b>can</b> be encoded for a single picture. Further restrictions <b>may</b> apply to the number of slice segments that <b>can</b> be encoded for a single picture depending on other capabilities and codec-specific rules.")
    VkExtent2D("maxTiles", "indicates the maximum number of H.265 tile columns and rows, as defined in sections 3.175 and 3.176 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h265\">ITU-T H.265 Specification</a> that <b>can</b> be encoded for a single picture. Further restrictions <b>may</b> apply to the number of H.265 tiles that <b>can</b> be encoded for a single picture depending on other capabilities and codec-specific rules.")
    VkVideoEncodeH265CtbSizeFlagsKHR("ctbSizes", "a bitmask of {@code VkVideoEncodeH265CtbSizeFlagBitsKHR} describing the supported CTB sizes.")
    VkVideoEncodeH265TransformBlockSizeFlagsKHR("transformBlockSizes", "a bitmask of {@code VkVideoEncodeH265TransformBlockSizeFlagBitsKHR} describing the supported transform block sizes.")
    uint32_t("maxPPictureL0ReferenceCount", """indicates the maximum number of reference pictures the implementation supports in the reference list L0 for <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-p-pic">P pictures</a>.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        As implementations <b>may</b> <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-overrides">override</a> the reference lists, {@code maxPPictureL0ReferenceCount} does not limit the number of elements that the application <b>can</b> specify in the L0 reference list for P pictures. However, if {@code maxPPictureL0ReferenceCount} is zero, then the use of P pictures is not allowed. In case of H.265 encoding, pictures <b>can</b> be encoded using only forward prediction even if P pictures are not supported, as the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a> supports <em>generalized P &amp; B frames</em> (also known as low delay B frames) whereas B frames <b>can</b> refer to past frames through both the L0 and L1 reference lists.
        </div>""")
    uint32_t("maxBPictureL0ReferenceCount", "indicates the maximum number of reference pictures the implementation supports in the reference list L0 for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-b-pic\">B pictures</a>.")
    uint32_t("maxL1ReferenceCount", """indicates the maximum number of reference pictures the implementation supports in the reference list L1 if encoding of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-b-pic">B pictures</a> is supported.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        As implementations <b>may</b> <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-overrides">override</a> the reference lists, {@code maxBPictureL0ReferenceCount} and {@code maxL1ReferenceCount} does not limit the number of elements that the application <b>can</b> specify in the L0 and L1 reference lists for B pictures. However, if {@code maxBPictureL0ReferenceCount} and {@code maxL1ReferenceCount} are both zero, then the use of B pictures is not allowed.
        </div>""")
    uint32_t("maxSubLayerCount", "indicates the maximum number of H.265 sub-layers supported by the implementation.")
    VkBool32("expectDyadicTemporalSubLayerPattern", "indicates that the implementation’s rate control algorithms expect the application to use a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-layer-pattern-dyadic\">dyadic temporal sub-layer pattern</a> when encoding multiple temporal sub-layers.")
    int32_t("minQp", "indicates the minimum QP value supported.")
    int32_t("maxQp", "indicates the maximum QP value supported.")
    VkBool32("prefersGopRemainingFrames", "indicates that the implementation’s rate control algorithm prefers the application to specify the number of frames of each type <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-gop-remaining-frames\">remaining</a> in the current <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-gop\">group of pictures</a> when beginning a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#video-coding-scope\">video coding scope</a>.")
    VkBool32("requiresGopRemainingFrames", "indicates that the implementation’s rate control algorithm requires the application to specify the number of frames of each type <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-gop-remaining-frames\">remaining</a> in the current <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-gop\">group of pictures</a> when beginning a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#video-coding-scope\">video coding scope</a>.")
    VkVideoEncodeH265StdFlagsKHR("stdSyntaxFlags", "a bitmask of {@code VkVideoEncodeH265StdFlagBitsKHR} indicating capabilities related to H.265 syntax elements.")
}

val VkVideoEncodeH265SessionCreateInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265SessionCreateInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.265 encode session parameters.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("useMaxLevelIdc", "indicates whether the value of {@code maxLevelIdc} should be used by the implementation. When it is #FALSE, the implementation ignores the value of {@code maxLevelIdc} and uses the value of ##VkVideoEncodeH265CapabilitiesKHR{@code ::maxLevelIdc}, as reported by #GetPhysicalDeviceVideoCapabilitiesKHR() for the video profile.")
    StdVideoH265LevelIdc("maxLevelIdc", "a {@code StdVideoH265LevelIdc} value specifying the upper bound on the H.265 level for the video bitstreams produced by the created video session, where enum constant {@code STD_VIDEO_H265_LEVEL_IDC_&lt;major&gt;_&lt;minor&gt;} identifies H.265 level {@code &lt;major&gt;.&lt;minor&gt;} as defined in section A.4 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h265\">ITU-T H.265 Specification</a>.")
}

val VkVideoEncodeH265QpKHR = struct(Module.VULKAN, "VkVideoEncodeH265QpKHR") {
    documentation =
        """
        Structure describing H.265 QP values per picture type.

        <h5>See Also</h5>
        ##VkVideoEncodeH265QualityLevelPropertiesKHR, ##VkVideoEncodeH265RateControlLayerInfoKHR
        """

    int32_t("qpI", "the QP to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-i-pic\">I pictures</a>.")
    int32_t("qpP", "the QP to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-p-pic\">P pictures</a>.")
    int32_t("qpB", "the QP to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-b-pic\">B pictures</a>.")
}

val VkVideoEncodeH265QualityLevelPropertiesKHR = struct(Module.VULKAN, "VkVideoEncodeH265QualityLevelPropertiesKHR", mutable = false) {
    documentation =
        """
        Structure describing the H.265 encode quality level properties.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUALITY_LEVEL_PROPERTIES_KHR</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH265QpKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUALITY_LEVEL_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkVideoEncodeH265RateControlFlagsKHR("preferredRateControlFlags", "a bitmask of {@code VkVideoEncodeH265RateControlFlagBitsKHR} values indicating the preferred flags to use for ##VkVideoEncodeH265RateControlInfoKHR{@code ::flags}.")
    uint32_t("preferredGopFrameCount", "indicates the preferred value to use for ##VkVideoEncodeH265RateControlInfoKHR{@code ::gopFrameCount}.")
    uint32_t("preferredIdrPeriod", "indicates the preferred value to use for ##VkVideoEncodeH265RateControlInfoKHR{@code ::idrPeriod}.")
    uint32_t("preferredConsecutiveBFrameCount", "indicates the preferred value to use for ##VkVideoEncodeH265RateControlInfoKHR{@code ::consecutiveBFrameCount}.")
    uint32_t("preferredSubLayerCount", "indicates the preferred value to use for ##VkVideoEncodeH265RateControlInfoKHR{@code ::subLayerCount}.")
    VkVideoEncodeH265QpKHR("preferredConstantQp", "indicates the preferred values to use for ##VkVideoEncodeH265NaluSliceSegmentInfoKHR{@code ::constantQp} for each picture type when using <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-rate-control-modes\">rate control mode</a> #VIDEO_ENCODE_RATE_CONTROL_MODE_DISABLED_BIT_KHR.")
    uint32_t("preferredMaxL0ReferenceCount", "indicates the preferred maximum number of reference pictures to use in the reference list L0.")
    uint32_t("preferredMaxL1ReferenceCount", "indicates the preferred maximum number of reference pictures to use in the reference list L1.")
}

val VkVideoEncodeH265SessionParametersAddInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265SessionParametersAddInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.265 encoder parameter set information.

        <h5>Description</h5>
        This structure <b>can</b> be specified in the following places:

        <ul>
            <li>In the {@code pParametersAddInfo} member of the ##VkVideoEncodeH265SessionParametersCreateInfoKHR structure specified in the {@code pNext} chain of ##VkVideoSessionParametersCreateInfoKHR used to create a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters">video session parameters</a> object. In this case, if the video codec operation the video session parameters object is created with is #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then it defines the set of initial parameters to add to the created object (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#creating-video-session-parameters">Creating Video Session Parameters</a>).</li>
            <li>In the {@code pNext} chain of ##VkVideoSessionParametersUpdateInfoKHR. In this case, if the video codec operation the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters">video session parameters</a> object to be updated was created with is #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, then it defines the set of parameters to add to it (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters-update">Updating Video Session Parameters</a>).</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR</li>
            <li>If {@code stdVPSCount} is not 0, and {@code pStdVPSs} is not {@code NULL}, {@code pStdVPSs} <b>must</b> be a valid pointer to an array of {@code stdVPSCount} {@code StdVideoH265VideoParameterSet} values</li>
            <li>If {@code stdSPSCount} is not 0, and {@code pStdSPSs} is not {@code NULL}, {@code pStdSPSs} <b>must</b> be a valid pointer to an array of {@code stdSPSCount} {@code StdVideoH265SequenceParameterSet} values</li>
            <li>If {@code stdPPSCount} is not 0, and {@code pStdPPSs} is not {@code NULL}, {@code pStdPPSs} <b>must</b> be a valid pointer to an array of {@code stdPPSCount} {@code StdVideoH265PictureParameterSet} values</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code vps_video_parameter_set_id} member of each {@code StdVideoH265VideoParameterSet} structure specified in the elements of {@code pStdVPSs} <b>must</b> be unique within {@code pStdVPSs}</li>
            <li>The pair constructed from the {@code sps_video_parameter_set_id} and {@code sps_seq_parameter_set_id} members of each {@code StdVideoH265SequenceParameterSet} structure specified in the elements of {@code pStdSPSs} <b>must</b> be unique within {@code pStdSPSs}</li>
            <li>The triplet constructed from the {@code sps_video_parameter_set_id}, {@code pps_seq_parameter_set_id}, and {@code pps_pic_parameter_set_id} members of each {@code StdVideoH265PictureParameterSet} structure specified in the elements of {@code pStdPPSs} <b>must</b> be unique within {@code pStdPPSs}</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH265SessionParametersCreateInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pStdVPSs", optional = true)..uint32_t("stdVPSCount", "the number of elements in the {@code pStdVPSs} array.")
    nullable..StdVideoH265VideoParameterSet.const.p("pStdVPSs", "a pointer to an array of {@code StdVideoH265VideoParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-vps\">H.265 VPS</a> entries to add.")
    AutoSize("pStdSPSs", optional = true)..uint32_t("stdSPSCount", "the number of elements in the {@code pStdSPSs} array.")
    nullable..StdVideoH265SequenceParameterSet.const.p("pStdSPSs", "a pointer to an array of {@code StdVideoH265SequenceParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-sps\">H.265 SPS</a> entries to add.")
    AutoSize("pStdPPSs", optional = true)..uint32_t("stdPPSCount", "the number of elements in the {@code pStdPPSs} array.")
    nullable..StdVideoH265PictureParameterSet.const.p("pStdPPSs", "a pointer to an array of {@code StdVideoH265PictureParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-pps\">H.265 PPS</a> entries to add.")
}

val VkVideoEncodeH265SessionParametersCreateInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265SessionParametersCreateInfoKHR") {
    documentation =
        """
        Structure specifies H.265 encoder parameter set information.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR</li>
            <li>If {@code pParametersAddInfo} is not {@code NULL}, {@code pParametersAddInfo} <b>must</b> be a valid pointer to a valid ##VkVideoEncodeH265SessionParametersAddInfoKHR structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH265SessionParametersAddInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("maxStdVPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-vps\">H.265 VPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    uint32_t("maxStdSPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-sps\">H.265 SPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    uint32_t("maxStdPPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-pps\">H.265 PPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    nullable..VkVideoEncodeH265SessionParametersAddInfoKHR.const.p("pParametersAddInfo", "{@code NULL} or a pointer to a ##VkVideoEncodeH265SessionParametersAddInfoKHR structure specifying H.265 parameters to add upon object creation.")
}

val VkVideoEncodeH265SessionParametersGetInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265SessionParametersGetInfoKHR") {
    documentation =
        """
        Structure specifying parameters for retrieving encoded H.265 parameter set data.

        <h5>Description</h5>
        When this structure is specified in the {@code pNext} chain of the ##VkVideoEncodeSessionParametersGetInfoKHR structure passed to #GetEncodedVideoSessionParametersKHR(), the command will write encoded parameter data to the output buffer in the following order:

        <ul>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-vps">H.265 video parameter set</a> identified by {@code stdVPSId}, if {@code writeStdVPS} is #TRUE.</li>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-sps">H.265 sequence parameter set</a> identified by the pair constructed from {@code stdVPSId} and {@code stdSPSId}, if {@code writeStdSPS} is #TRUE.</li>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-pps">H.265 picture parameter set</a> identified by the triplet constructed from {@code stdVPSId}, {@code stdSPSId}, and {@code stdPPSId}, if {@code writeStdPPS} is #TRUE.</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>At least one of {@code writeStdVPS}, {@code writeStdSPS}, and {@code writeStdPPS} <b>must</b> be #TRUE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("writeStdVPS", "indicates whether the encoded <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-vps\">H.265 video parameter set</a> identified by {@code stdVPSId} is requested to be retrieved.")
    VkBool32("writeStdSPS", "indicates whether the encoded <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-sps\">H.265 sequence parameter set</a> identified by the pair constructed from {@code stdVPSId} and {@code stdSPSId} is requested to be retrieved.")
    VkBool32("writeStdPPS", "indicates whether the encoded <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-pps\">H.265 picture parameter set</a> identified by the triplet constructed from {@code stdVPSId}, {@code stdSPSId}, and {@code stdPPSId} is requested to be retrieved.")
    uint32_t("stdVPSId", "specifies the H.265 video parameter set ID used to identify the retrieved H.265 video, sequence, and/or picture parameter set(s).")
    uint32_t("stdSPSId", "specifies the H.265 sequence parameter set ID used to identify the retrieved H.265 sequence and/or picture parameter set(s) when {@code writeStdSPS} and/or {@code writeStdPPS} is #TRUE.")
    uint32_t("stdPPSId", "specifies the H.265 picture parameter set ID used to identify the retrieved H.265 picture parameter set when {@code writeStdPPS} is #TRUE.")
}

val VkVideoEncodeH265SessionParametersFeedbackInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265SessionParametersFeedbackInfoKHR", mutable = false) {
    documentation =
        """
        Structure providing feedback about the requested H.265 video session parameters.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_FEEDBACK_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_FEEDBACK_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkBool32("hasStdVPSOverrides", "indicates whether any of the parameters of the requested <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-vps\">H.265 video parameter set</a>, if one was requested via ##VkVideoEncodeH265SessionParametersGetInfoKHR{@code ::writeStdVPS}, were <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-overrides\">overridden</a> by the implementation.")
    VkBool32("hasStdSPSOverrides", "indicates whether any of the parameters of the requested <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-sps\">H.265 sequence parameter set</a>, if one was requested via ##VkVideoEncodeH265SessionParametersGetInfoKHR{@code ::writeStdSPS}, were <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-overrides\">overridden</a> by the implementation.")
    VkBool32("hasStdPPSOverrides", "indicates whether any of the parameters of the requested <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-pps\">H.265 picture parameter set</a>, if one was requested via ##VkVideoEncodeH265SessionParametersGetInfoKHR{@code ::writeStdPPS}, were <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-overrides\">overridden</a> by the implementation.")
}

val VkVideoEncodeH265NaluSliceSegmentInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265NaluSliceSegmentInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.265 encode slice segment NALU parameters.

        <h5>Description</h5>
        <dl>
            <dt>Std Slice Segment Header Parameters</dt>
            <dd><ul>
                <li>{@code flags.reserved} and {@code reserved1} are used only for padding purposes and are otherwise ignored;</li>
                <li>
                    if {@code pWeightTable} is not {@code NULL}, then it is a pointer to a {@code StdVideoEncodeH265WeightTable} that is interpreted as follows:
                    <ul>
                        <li>{@code flags.luma_weight_l0_flag}, {@code flags.chroma_weight_l0_flag}, {@code flags.luma_weight_l1_flag}, and {@code flags.chroma_weight_l1_flag} are bitmasks where bit index <code>i</code> corresponds to {@code luma_weight_l0_flag[i]}, {@code chroma_weight_l0_flag[i]}, {@code luma_weight_l1_flag[i]}, and {@code chroma_weight_l1_flag[i]}, respectively, as defined in section 7.4.7.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                        <li>all other members of {@code StdVideoEncodeH265WeightTable} are interpreted as defined in section 7.4.7.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                    </ul>
                </li>
                <li>all other members are interpreted as defined in section 7.4.7.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>.</li>
            </ul></dd>
        </dl>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code pStdSliceSegmentHeader} <b>must</b> be a valid pointer to a valid {@code StdVideoEncodeH265SliceSegmentHeader} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH265PictureInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    int32_t("constantQp", "the QP to use for the slice segment if the current <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-rate-control-modes\">rate control mode</a> configured for the video session is #VIDEO_ENCODE_RATE_CONTROL_MODE_DISABLED_BIT_KHR.")
    StdVideoEncodeH265SliceSegmentHeader.const.p("pStdSliceSegmentHeader", "a pointer to a {@code StdVideoEncodeH265SliceSegmentHeader} structure specifying <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-slice-segment-header-params\">H.265 slice segment header parameters</a> for the slice segment.")
}

val VkVideoEncodeH265PictureInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265PictureInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.265 encode frame parameters.

        <h5>Description</h5>
        This structure is specified in the {@code pNext} chain of the ##VkVideoEncodeInfoKHR structure passed to #CmdEncodeVideoKHR() to specify the codec-specific picture information for an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265">H.265 encode operation</a>.

        <dl>
            <dt>Encode Input Picture Information</dt>
            <dd><ul>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-picture-data-access">H.265 Encode Picture Data Access</a> section.</li>
                <li>The encode input picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-picture-info">H.265 picture information</a> provided in {@code pStdPictureInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Std Picture Information</dt>
            <dd><ul>
                <li>{@code flags.reserved} and {@code reserved1} are used only for padding purposes and are otherwise ignored;</li>
                <li>{@code flags.is_reference} as defined in section 3.132 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code flags.IrapPicFlag} as defined in section 3.73 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code flags.used_for_long_term_reference} is used to indicate whether the picture is marked as “used for long-term reference” as defined in section 8.3.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code flags.discardable_flag} and {@code cross_layer_bla_flag} as defined in section F.7.4.7.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code pic_type} as defined in section 7.4.3.5 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code sps_video_parameter_set_id}, {@code pps_seq_parameter_set_id}, and {@code pps_pic_parameter_set_id} are used to identify the active parameter sets, as described below;</li>
                <li>{@code PicOrderCntVal} as defined in section 8.3.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code TemporalId} as defined in section 7.4.2.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>
                    if {@code pRefLists} is not {@code NULL}, then it is a pointer to a {@code StdVideoEncodeH265ReferenceListsInfo} structure that is interpreted as follows:
                    <ul>
                        <li>{@code flags.reserved} is used only for padding purposes and is otherwise ignored;</li>
                        <li>{@code ref_pic_list_modification_flag_l0} and {@code ref_pic_list_modification_flag_l1} as defined in section 7.4.7.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                        <li>{@code num_ref_idx_l0_active_minus1} and {@code num_ref_idx_l1_active_minus1} as defined in section 7.4.7.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                        <li>{@code RefPicList0} and {@code RefPicList1} as defined in section 8.3.4 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a> where each element of these arrays either identifies an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-active-reference-picture-info">active reference picture</a> using its <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> index or contains the value {@code STD_VIDEO_H265_NO_REFERENCE_PICTURE} to indicate “no reference picture”;</li>
                        <li>{@code list_entry_l0} and {@code list_entry_l1} as defined in section 7.4.7.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                    </ul>
                </li>
                <li>if {@code flags.short_term_ref_pic_set_sps_flag} is set, then the {@code StdVideoH265ShortTermRefPicSet} structure pointed to by {@code pShortTermRefPicSet} is interpreted as defined for the elements of the {@code pShortTermRefPicSet} array specified in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-sps">H.265 sequence parameter sets</a>.</li>
                <li>
                    if {@code flags.long_term_ref_pics_present_flag} is set in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-active-sps">active SPS</a>, then the {@code StdVideoEncodeH265LongTermRefPics} structure pointed to by {@code pLongTermRefPics} is interpreted as follows:
                    <ul>
                        <li>{@code used_by_curr_pic_lt_flag} is a bitmask where bit index <code>i</code> corresponds to {@code used_by_curr_pic_lt_flag[i]} as defined in section 7.4.7.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                        <li>all other members of {@code StdVideoEncodeH265LongTermRefPics} are interpreted as defined in section 7.4.7.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                    </ul>
                </li>
                <li>all other members are interpreted as defined in section 7.4.7.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>.</li>
            </ul></dd>
        </dl>

        Reference picture setup is controlled by the value of {@code StdVideoEncodeH265PictureInfo}{@code ::flags.is_reference}. If it is set and a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-reconstructed-picture-info">reconstructed picture</a> is specified, then the latter is used as the target of picture reconstruction to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">activate</a> the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> specified in {@code pEncodeInfo→pSetupReferenceSlot→slotIndex}. If {@code StdVideoEncodeH265PictureInfo}{@code ::flags.is_reference} is not set, but a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-reconstructed-picture-info">reconstructed picture</a> is specified, then the corresponding picture reference associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> is invalidated, as described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">DPB Slot States</a> section.

        <dl>
            <dt>Active Parameter Sets</dt>
            <dd><ul>
                <li>The <em>active VPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-vps">VPS</a> identified by the key specified in {@code StdVideoEncodeH265PictureInfo}{@code ::sps_video_parameter_set_id}.</li>
                <li>The <em>active SPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-sps">SPS</a> identified by the key specified by the pair constructed from {@code StdVideoEncodeH265PictureInfo}{@code ::sps_video_parameter_set_id} and {@code StdVideoEncodeH265PictureInfo}{@code ::pps_seq_parameter_set_id}.</li>
                <li>The <em>active PPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-pps">PPS</a> identified by the key specified by the triplet constructed from {@code StdVideoEncodeH265PictureInfo}{@code ::sps_video_parameter_set_id}, {@code StdVideoEncodeH265PictureInfo}{@code ::pps_seq_parameter_set_id}, and {@code StdVideoEncodeH265PictureInfo}{@code ::pps_pic_parameter_set_id}.</li>
            </ul></dd>
        </dl>

        H.265 encoding uses <em>explicit weighted sample prediction</em> for a slice segment, as defined in section 8.5.3.3.4 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>, if any of the following conditions are true for the active <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-pps">PPS</a> and the {@code pStdSliceSegmentHeader} member of the corresponding element of {@code pNaluSliceSegmentEntries}:

        <ul>
            <li>{@code pStdSliceSegmentHeader→slice_type} is {@code STD_VIDEO_H265_SLICE_TYPE_P} and {@code weighted_pred_flag} is enabled in the active PPS.</li>
            <li>{@code pStdSliceSegmentHeader→slice_type} is {@code STD_VIDEO_H265_SLICE_TYPE_B} and {@code weighted_bipred_flag} is enabled in the active PPS.</li>
        </ul>

        The number of H.265 tiles, as defined in section 3.174 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>, is derived from the {@code num_tile_columns_minus1} and {@code num_tile_rows_minus1} members of the active <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-pps">PPS</a> as follows:

        <dl>
            <dd><code>(num_tile_columns_minus1 + 1) × (num_tile_rows_minus1 + 1)</code></dd>
        </dl>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code naluSliceSegmentEntryCount} <b>must</b> be between 1 and ##VkVideoEncodeH265CapabilitiesKHR{@code ::maxSliceSegmentCount}, inclusive, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile</li>
            <li>If ##VkVideoEncodeH265CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILES_PER_SLICE_SEGMENT_BIT_KHR, then {@code naluSliceSegmentEntryCount} <b>must</b> be greater than or equal to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-tile-count">number of H.265 tiles in the picture</a></li>
            <li>If ##VkVideoEncodeH265CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_SLICE_SEGMENTS_PER_TILE_BIT_KHR, then {@code naluSliceSegmentEntryCount} <b>must</b> be less than or equal to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-tile-count">number of H.265 tiles in the picture</a></li>
            <li>If ##VkVideoEncodeH265CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H265_CAPABILITY_PREDICTION_WEIGHT_TABLE_GENERATED_BIT_KHR and the slice segment corresponding to any element of {@code pNaluSliceSegmentEntries} uses <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-weighted-pred">explicit weighted sample prediction</a>, then ##VkVideoEncodeH265NaluSliceSegmentInfoKHR{@code ::pStdSliceSegmentHeader→pWeightTable} <b>must</b> not be {@code NULL} for that element of {@code pNaluSliceSegmentEntries}</li>
            <li>If ##VkVideoEncodeH265CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H265_CAPABILITY_DIFFERENT_SLICE_SEGMENT_TYPE_BIT_KHR, then ##VkVideoEncodeH265NaluSliceSegmentInfoKHR{@code ::pStdSliceSegmentHeader→slice_type} <b>must</b> be identical for all elements of {@code pNaluSliceSegmentEntries}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR</li>
            <li>{@code pNaluSliceSegmentEntries} <b>must</b> be a valid pointer to an array of {@code naluSliceSegmentEntryCount} valid ##VkVideoEncodeH265NaluSliceSegmentInfoKHR structures</li>
            <li>{@code pStdPictureInfo} <b>must</b> be a valid pointer to a valid {@code StdVideoEncodeH265PictureInfo} value</li>
            <li>{@code naluSliceSegmentEntryCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH265NaluSliceSegmentInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pNaluSliceSegmentEntries")..uint32_t("naluSliceSegmentEntryCount", "the number of elements in {@code pNaluSliceSegmentEntries}.")
    VkVideoEncodeH265NaluSliceSegmentInfoKHR.const.p("pNaluSliceSegmentEntries", "a pointer to an array of {@code naluSliceSegmentEntryCount} ##VkVideoEncodeH265NaluSliceSegmentInfoKHR structures specifying the parameters of the individual H.265 slice segments to encode for the input picture.")
    StdVideoEncodeH265PictureInfo.const.p("pStdPictureInfo", "a pointer to a {@code StdVideoEncodeH265PictureInfo} structure specifying <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-picture-info\">H.265 picture information</a>.")
}

val VkVideoEncodeH265DpbSlotInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265DpbSlotInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.265 encode DPB picture information.

        <h5>Description</h5>
        This structure is specified in the {@code pNext} chain of ##VkVideoEncodeInfoKHR{@code ::pSetupReferenceSlot}, if not {@code NULL}, and the {@code pNext} chain of the elements of ##VkVideoEncodeInfoKHR{@code ::pReferenceSlots} to specify the codec-specific reference picture information for an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265">H.265 encode operation</a>.

        <dl>
            <dt>Active Reference Picture Information</dt>
            <dd><ul>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-picture-data-access">H.265 Encode Picture Data Access</a> section.</li>
                <li>The reference picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> index specified in the {@code slotIndex} member of the corresponding element of ##VkVideoEncodeInfoKHR{@code ::pReferenceSlots}.</li>
                <li>The reference picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-reference-info">H.265 reference information</a> provided in {@code pStdReferenceInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Reconstructed Picture Information</dt>
            <dd><ul>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-picture-data-access">H.265 Encode Picture Data Access</a> section.</li>
                <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-ref-pic-setup">reference picture setup</a> is requested, then the reconstructed picture is used to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">activate</a> the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> with the index specified in ##VkVideoEncodeInfoKHR{@code ::pSetupReferenceSlot→slotIndex}.</li>
                <li>The reconstructed picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-reference-info">H.265 reference information</a> provided in {@code pStdReferenceInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Std Reference Information</dt>
            <dd><ul>
                <li>{@code flags.reserved} is used only for padding purposes and is otherwise ignored;</li>
                <li>{@code flags.used_for_long_term_reference} is used to indicate whether the picture is marked as “used for long-term reference” as defined in section 8.3.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code flags.unused_for_reference} is used to indicate whether the picture is marked as “unused for reference” as defined in section 8.3.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code pic_type} as defined in section 7.4.3.5 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code PicOrderCntVal} as defined in section 8.3.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code TemporalId} as defined in section 7.4.2.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>.</li>
            </ul></dd>
        </dl>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR</li>
            <li>{@code pStdReferenceInfo} <b>must</b> be a valid pointer to a valid {@code StdVideoEncodeH265ReferenceInfo} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoEncodeH265ReferenceInfo.const.p("pStdReferenceInfo", "a pointer to a {@code StdVideoEncodeH265ReferenceInfo} structure specifying <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-reference-info\">H.265 reference information</a>.")
}

val VkVideoEncodeH265ProfileInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265ProfileInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifying H.265 encode-specific video profile parameters.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoH265ProfileIdc("stdProfileIdc", "a {@code StdVideoH265ProfileIdc} value specifying the H.265 codec profile IDC, as defined in section A.3 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h265\">ITU-T H.265 Specification</a>.")
}

val VkVideoEncodeH265RateControlInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265RateControlInfoKHR") {
    documentation =
        """
        Structure describing H.265 stream rate control parameters.

        <h5>Description</h5>
        When an instance of this structure is included in the {@code pNext} chain of the ##VkVideoCodingControlInfoKHR structure passed to the #CmdControlVideoCodingKHR() command, and ##VkVideoCodingControlInfoKHR{@code ::flags} includes #VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_BIT_KHR, the parameters in this structure are used as guidance for the implementation’s rate control algorithm (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-coding-control">Video Coding Control</a>).

        If {@code flags} includes #VIDEO_ENCODE_H265_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR, then the rate control state is reset to an initial state to meet HRD compliance requirements. Otherwise the new rate control state <b>may</b> be applied without a reset depending on the implementation and the specified rate control parameters.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        It would be possible to infer the picture type to be used when encoding a frame, on the basis of the values provided for {@code consecutiveBFrameCount}, {@code idrPeriod}, and {@code gopFrameCount}, but this inferred picture type will not be used by implementations to override the picture type provided to the video encode operation.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If ##VkVideoEncodeH265CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H265_CAPABILITY_HRD_COMPLIANCE_BIT_KHR, then {@code flags} <b>must</b> not contain #VIDEO_ENCODE_H265_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR</li>
            <li>If {@code flags} contains #VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR or #VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR, then it <b>must</b> also contain #VIDEO_ENCODE_H265_RATE_CONTROL_REGULAR_GOP_BIT_KHR</li>
            <li>If {@code flags} contains #VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR, then it <b>must</b> not also contain #VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR</li>
            <li>If {@code flags} contains #VIDEO_ENCODE_H265_RATE_CONTROL_REGULAR_GOP_BIT_KHR, then {@code gopFrameCount} <b>must</b> be greater than 0</li>
            <li>If {@code idrPeriod} is not 0, then it <b>must</b> be greater than or equal to {@code gopFrameCount}</li>
            <li>If {@code consecutiveBFrameCount} is not 0, then it <b>must</b> be less than {@code gopFrameCount}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkVideoEncodeH265RateControlFlagBitsKHR} values</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkVideoEncodeH265RateControlFlagsKHR("flags", "a bitmask of {@code VkVideoEncodeH265RateControlFlagBitsKHR} specifying H.265 rate control flags.")
    uint32_t("gopFrameCount", "the number of frames within a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-gop\">group of pictures (GOP)</a> intended to be used by the application. If it is 0, the rate control algorithm <b>may</b> assume an implementation-dependent GOP length. If it is {@code UINT32_MAX}, the GOP length is treated as infinite.")
    uint32_t("idrPeriod", "the interval, in terms of number of frames, between two <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-idr-pic\">IDR frames</a> (see <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-idr-period\">IDR period</a>). If it is 0, the rate control algorithm <b>may</b> assume an implementation-dependent IDR period. If it is {@code UINT32_MAX}, the IDR period is treated as infinite.")
    uint32_t("consecutiveBFrameCount", "the number of consecutive B frames between I and/or P frames within the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-gop\">GOP</a>.")
    uint32_t("subLayerCount", "specifies the number of H.265 sub-layers that the application intends to use.")
}

val VkVideoEncodeH265FrameSizeKHR = struct(Module.VULKAN, "VkVideoEncodeH265FrameSizeKHR") {
    documentation =
        """
        Structure describing frame size values per H.265 picture type.

        <h5>See Also</h5>
        ##VkVideoEncodeH265RateControlLayerInfoKHR
        """

    uint32_t("frameISize", "the size in bytes to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-i-pic\">I frames</a>.")
    uint32_t("framePSize", "the size in bytes to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-p-pic\">P frames</a>.")
    uint32_t("frameBSize", "the size in bytes to be used for <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-b-pic\">B frames</a>.")
}

val VkVideoEncodeH265RateControlLayerInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265RateControlLayerInfoKHR") {
    documentation =
        """
        Structure describing H.265 per-layer rate control parameters.

        <h5>Description</h5>
        When used, the values in {@code minQp} and {@code maxQp} guarantee that the effective QP values used by the implementation will respect those lower and upper bounds, respectively. However, limiting the range of QP values that the implementation is able to use will also limit the capabilities of the implementation’s rate control algorithm to comply to other constraints. In particular, the implementation <b>may</b> not be able to comply to the following:

        <ul>
            <li>The average and/or peak <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-bitrate">bitrate</a> values to be used for the encoded bitstream specified in the {@code averageBitrate} and {@code maxBitrate} members of the ##VkVideoEncodeRateControlLayerInfoKHR structure.</li>
            <li>The upper bounds on the encoded frame size, for each picture type, specified in the {@code maxFrameSize} member of ##VkVideoEncodeH265RateControlLayerInfoKHR.</li>
        </ul>

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        In general, applications need to configure rate control parameters appropriately in order to be able to get the desired rate control behavior, as described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-rate-control">Video Encode Rate Control</a> section.
        </div>

        When an instance of this structure is included in the {@code pNext} chain of a ##VkVideoEncodeRateControlLayerInfoKHR structure specified in one of the elements of the {@code pLayers} array member of the ##VkVideoEncodeRateControlInfoKHR structure passed to the #CmdControlVideoCodingKHR() command, ##VkVideoCodingControlInfoKHR{@code ::flags} includes #VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_BIT_KHR, and the bound video session was created with the video codec operation #VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR, it specifies the H.265-specific rate control parameters of the rate control layer corresponding to that element of {@code pLayers}.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code useMinQp} is #TRUE, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code minQp} <b>must</b> all be between ##VkVideoEncodeH265CapabilitiesKHR{@code ::minQp} and ##VkVideoEncodeH265CapabilitiesKHR{@code ::maxQp}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile</li>
            <li>If {@code useMaxQp} is #TRUE, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code maxQp} <b>must</b> all be between ##VkVideoEncodeH265CapabilitiesKHR{@code ::minQp} and ##VkVideoEncodeH265CapabilitiesKHR{@code ::maxQp}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile</li>
            <li>If {@code useMinQp} is #TRUE and ##VkVideoEncodeH265CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H265_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code minQp} <b>must</b> all specify the same value</li>
            <li>If {@code useMaxQp} is #TRUE and ##VkVideoEncodeH265CapabilitiesKHR{@code ::flags}, as returned by #GetPhysicalDeviceVideoCapabilitiesKHR() for the used video profile, does not include #VIDEO_ENCODE_H265_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code maxQp} <b>must</b> all specify the same value</li>
            <li>If {@code useMinQp} and {@code useMaxQp} are both #TRUE, then the {@code qpI}, {@code qpP}, and {@code qpB} members of {@code minQp} <b>must</b> all be less than or equal to the respective members of {@code maxQp}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR</li>
            <li>{@code minQp} <b>must</b> be a valid ##VkVideoEncodeH265QpKHR structure</li>
            <li>{@code maxQp} <b>must</b> be a valid ##VkVideoEncodeH265QpKHR structure</li>
            <li>{@code maxFrameSize} <b>must</b> be a valid ##VkVideoEncodeH265FrameSizeKHR structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoEncodeH265FrameSizeKHR, ##VkVideoEncodeH265QpKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("useMinQp", "indicates whether the QP values determined by rate control will be clamped to the lower bounds on the QP values specified in {@code minQp}.")
    VkVideoEncodeH265QpKHR("minQp", "specifies the lower bounds on the QP values, for each picture type, that the implementation’s rate control algorithm will use when {@code useMinQp} is #TRUE.")
    VkBool32("useMaxQp", "indicates whether the QP values determined by rate control will be clamped to the upper bounds on the QP values specified in {@code maxQp}.")
    VkVideoEncodeH265QpKHR("maxQp", "specifies the upper bounds on the QP values, for each picture type, that the implementation’s rate control algorithm will use when {@code useMaxQp} is #TRUE.")
    VkBool32("useMaxFrameSize", "indicates whether the implementation’s rate control algorithm <b>should</b> use the values specified in {@code maxFrameSize} as the upper bounds on the encoded frame size for each picture type.")
    VkVideoEncodeH265FrameSizeKHR("maxFrameSize", "specifies the upper bounds on the encoded frame size, for each picture type, when {@code useMaxFrameSize} is #TRUE.")
}

val VkVideoEncodeH265GopRemainingFrameInfoKHR = struct(Module.VULKAN, "VkVideoEncodeH265GopRemainingFrameInfoKHR") {
    documentation =
        """
        Structure specifying H.265 encode rate control GOP remaining frame counts.

        <h5>Description</h5>
        Setting {@code useGopRemainingFrames} to #TRUE and including this structure in the {@code pNext} chain of ##VkVideoBeginCodingInfoKHR is only mandatory if the ##VkVideoEncodeH265CapabilitiesKHR{@code ::requiresGopRemainingFrames} reported for the used <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-profiles">video profile</a> is #TRUE. However, implementations <b>may</b> use these remaining frame counts, when specified, even when it is not required. In particular, when the application does not use a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#encode-h265-regular-gop">regular GOP structure</a>, these values <b>may</b> provide additional guidance for the implementation’s rate control algorithm.

        The ##VkVideoEncodeH265CapabilitiesKHR{@code ::prefersGopRemainingFrames} capability is also used to indicate that the implementation’s rate control algorithm <b>may</b> operate more accurately if the application specifies the remaining frame counts using this structure.

        As with other rate control guidance values, if the effective order and number of frames encoded by the application are not in line with the remaining frame counts specified in this structure at any given point, then the behavior of the implementation’s rate control algorithm <b>may</b> deviate from the one expected by the application.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("useGopRemainingFrames", "indicates whether the implementation’s rate control algorithm <b>should</b> use the values specified in {@code gopRemainingI}, {@code gopRemainingP}, and {@code gopRemainingB}. If {@code useGopRemainingFrames} is #FALSE, then the values of {@code gopRemainingI}, {@code gopRemainingP}, and {@code gopRemainingB} are ignored.")
    uint32_t("gopRemainingI", "specifies the number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-i-pic\">I frames</a> the implementation’s rate control algorithm <b>should</b> assume to be remaining in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-gop\">GOP</a> prior to executing the video encode operation.")
    uint32_t("gopRemainingP", "specifies the number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-p-pic\">P frames</a> the implementation’s rate control algorithm <b>should</b> assume to be remaining in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-gop\">GOP</a> prior to executing the video encode operation.")
    uint32_t("gopRemainingB", "specifies the number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-b-pic\">B frames</a> the implementation’s rate control algorithm <b>should</b> assume to be remaining in the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#encode-h265-gop\">GOP</a> prior to executing the video encode operation.")
}

val VkVideoDecodeH264ProfileInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH264ProfileInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifying H.264 decode-specific video profile parameters.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR</li>
            <li>If {@code pictureLayout} is not 0, {@code pictureLayout} <b>must</b> be a valid {@code VkVideoDecodeH264PictureLayoutFlagBitsKHR} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoH264ProfileIdc("stdProfileIdc", "a {@code StdVideoH264ProfileIdc} value specifying the H.264 codec profile IDC, as defined in section A.2 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h264\">ITU-T H.264 Specification</a>.")
    VkVideoDecodeH264PictureLayoutFlagBitsKHR("pictureLayout", "a {@code VkVideoDecodeH264PictureLayoutFlagBitsKHR} value specifying the picture layout used by the H.264 video sequence to be decoded.")
}

val VkVideoDecodeH264CapabilitiesKHR = struct(Module.VULKAN, "VkVideoDecodeH264CapabilitiesKHR", mutable = false) {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure describing H.264 decode capabilities.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR</li>
        </ul>

        <h5>See Also</h5>
        ##VkOffset2D
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    StdVideoH264LevelIdc("maxLevelIdc", "a {@code StdVideoH264LevelIdc} value indicating the maximum H.264 level supported by the profile, where enum constant {@code STD_VIDEO_H264_LEVEL_IDC_&lt;major&gt;_&lt;minor&gt;} identifies H.264 level {@code &lt;major&gt;.&lt;minor&gt;} as defined in section A.3 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h264\">ITU-T H.264 Specification</a>.")
    VkOffset2D("fieldOffsetGranularity", "the minimum alignment for ##VkVideoPictureResourceInfoKHR{@code ::codedOffset} specified for a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#video-picture-resources\">video picture resource</a> when using the picture layout #VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_SEPARATE_PLANES_BIT_KHR.")
}

val VkVideoDecodeH264SessionParametersAddInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH264SessionParametersAddInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.264 decoder parameter set information.

        <h5>Description</h5>
        This structure <b>can</b> be specified in the following places:

        <ul>
            <li>In the {@code pParametersAddInfo} member of the ##VkVideoDecodeH264SessionParametersCreateInfoKHR structure specified in the {@code pNext} chain of ##VkVideoSessionParametersCreateInfoKHR used to create a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters">video session parameters</a> object. In this case, if the video codec operation the video session parameters object is created with is #VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR, then it defines the set of initial parameters to add to the created object (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#creating-video-session-parameters">Creating Video Session Parameters</a>).</li>
            <li>In the {@code pNext} chain of ##VkVideoSessionParametersUpdateInfoKHR. In this case, if the video codec operation the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters">video session parameters</a> object to be updated was created with is #VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR, then it defines the set of parameters to add to it (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters-update">Updating Video Session Parameters</a>).</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code seq_parameter_set_id} member of each {@code StdVideoH264SequenceParameterSet} structure specified in the elements of {@code pStdSPSs} <b>must</b> be unique within {@code pStdSPSs}</li>
            <li>The pair constructed from the {@code seq_parameter_set_id} and {@code pic_parameter_set_id} members of each {@code StdVideoH264PictureParameterSet} structure specified in the elements of {@code pStdPPSs} <b>must</b> be unique within {@code pStdPPSs}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR</li>
            <li>If {@code stdSPSCount} is not 0, {@code pStdSPSs} <b>must</b> be a valid pointer to an array of {@code stdSPSCount} {@code StdVideoH264SequenceParameterSet} values</li>
            <li>If {@code stdPPSCount} is not 0, {@code pStdPPSs} <b>must</b> be a valid pointer to an array of {@code stdPPSCount} {@code StdVideoH264PictureParameterSet} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoDecodeH264SessionParametersCreateInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pStdSPSs", optional = true)..uint32_t("stdSPSCount", "the number of elements in the {@code pStdSPSs} array.")
    StdVideoH264SequenceParameterSet.const.p("pStdSPSs", "a pointer to an array of {@code StdVideoH264SequenceParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h264-sps\">H.264 SPS</a> entries to add.")
    AutoSize("pStdPPSs", optional = true)..uint32_t("stdPPSCount", "the number of elements in the {@code pStdPPSs} array.")
    StdVideoH264PictureParameterSet.const.p("pStdPPSs", "a pointer to an array of {@code StdVideoH264PictureParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h264-pps\">H.264 PPS</a> entries to add.")
}

val VkVideoDecodeH264SessionParametersCreateInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH264SessionParametersCreateInfoKHR") {
    documentation =
        """
        Structure specifies H.264 decoder parameter set information.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR</li>
            <li>If {@code pParametersAddInfo} is not {@code NULL}, {@code pParametersAddInfo} <b>must</b> be a valid pointer to a valid ##VkVideoDecodeH264SessionParametersAddInfoKHR structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoDecodeH264SessionParametersAddInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("maxStdSPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h264-sps\">H.264 SPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    uint32_t("maxStdPPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h264-pps\">H.264 PPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    nullable..VkVideoDecodeH264SessionParametersAddInfoKHR.const.p("pParametersAddInfo", "{@code NULL} or a pointer to a ##VkVideoDecodeH264SessionParametersAddInfoKHR structure specifying H.264 parameters to add upon object creation.")
}

val VkVideoDecodeH264PictureInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH264PictureInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.264 decode picture parameters when decoding a picture.

        <h5>Description</h5>
        This structure is specified in the {@code pNext} chain of the ##VkVideoDecodeInfoKHR structure passed to #CmdDecodeVideoKHR() to specify the codec-specific picture information for an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264">H.264 decode operation</a>.

        <dl>
            <dt>Decode Output Picture Information</dt>
            <dd><ul>
                <li>If {@code pStdPictureInfo→flags.field_pic_flag} is not set, then the picture represents a frame.</li>
                <li>
                    If {@code pStdPictureInfo→flags.field_pic_flag} is set, then the picture represents a field. Specifically:
                    <ul>
                        <li>If {@code pStdPictureInfo→flags.bottom_field_flag} is not set, then the picture represents the top field of the frame.</li>
                        <li>If {@code pStdPictureInfo→flags.bottom_field_flag} is set, then the picture represents the bottom field of the frame.</li>
                    </ul>
                </li>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-picture-data-access">H.264 Decode Picture Data Access</a> section.</li>
                <li>The decode output picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-picture-info">H.264 picture information</a> provided in {@code pStdPictureInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Std Picture Information</dt>
            <dd><ul>
                <li>{@code reserved1} and {@code reserved2} are used only for padding purposes and are otherwise ignored;</li>
                <li>{@code flags.is_intra} as defined in section 3.73 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code flags.is_reference} as defined in section 3.136 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code flags.complementary_field_pair} as defined in section 3.35 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code seq_parameter_set_id} and {@code pic_parameter_set_id} are used to identify the active parameter sets, as described below;</li>
                <li>all other members are interpreted as defined in section 7.4.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>.</li>
            </ul></dd>
        </dl>

        Reference picture setup is controlled by the value of {@code StdVideoDecodeH264PictureInfo}{@code ::flags.is_reference}. If it is set and a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-reconstructed-picture-info">reconstructed picture</a> is specified, then the latter is used as the target of picture reconstruction to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">activate</a> the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> specified in {@code pDecodeInfo→pSetupReferenceSlot→slotIndex}. If {@code StdVideoDecodeH264PictureInfo}{@code ::flags.is_reference} is not set, but a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-reconstructed-picture-info">reconstructed picture</a> is specified, then the corresponding picture reference associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> is invalidated, as described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">DPB Slot States</a> section.

        <dl>
            <dt>Active Parameter Sets</dt>
            <dd><ul>
                <li>The <em>active SPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-sps">SPS</a> identified by the key specified in {@code StdVideoDecodeH264PictureInfo}{@code ::seq_parameter_set_id}.</li>
                <li>The <em>active PPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-pps">PPS</a> identified by the key specified by the pair constructed from {@code StdVideoDecodeH264PictureInfo}{@code ::seq_parameter_set_id} and {@code StdVideoDecodeH264PictureInfo}{@code ::pic_parameter_set_id}.</li>
            </ul></dd>
        </dl>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR</li>
            <li>{@code pStdPictureInfo} <b>must</b> be a valid pointer to a valid {@code StdVideoDecodeH264PictureInfo} value</li>
            <li>{@code pSliceOffsets} <b>must</b> be a valid pointer to an array of {@code sliceCount} {@code uint32_t} values</li>
            <li>{@code sliceCount} <b>must</b> be greater than 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoDecodeH264PictureInfo.const.p("pStdPictureInfo", "a pointer to a {@code StdVideoDecodeH264PictureInfo} structure specifying <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h264-picture-info\">H.264 picture information</a>.")
    AutoSize("pSliceOffsets")..uint32_t("sliceCount", "the number of elements in {@code pSliceOffsets}.")
    uint32_t.const.p("pSliceOffsets", "a pointer to an array of {@code sliceCount} offsets specifying the start offset of the slices of the picture within the video bitstream buffer range specified in ##VkVideoDecodeInfoKHR.")
}

val VkVideoDecodeH264DpbSlotInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH264DpbSlotInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.264 decode DPB picture information.

        <h5>Description</h5>
        This structure is specified in the {@code pNext} chain of ##VkVideoDecodeInfoKHR{@code ::pSetupReferenceSlot}, if not {@code NULL}, and the {@code pNext} chain of the elements of ##VkVideoDecodeInfoKHR{@code ::pReferenceSlots} to specify the codec-specific reference picture information for an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264">H.264 decode operation</a>.

        <dl>
            <dt>Active Reference Picture Information</dt>
            <dd><ul>
                <li>If neither {@code pStdReferenceInfo→flags.top_field_flag} nor {@code pStdReferenceInfo→flags.bottom_field_flag} is set, then the picture is added as a frame reference to the list of active reference pictures.</li>
                <li>If {@code pStdReferenceInfo→flags.top_field_flag} is set, then the picture is added as a top field reference to the list of active reference pictures.</li>
                <li>If {@code pStdReferenceInfo→flags.bottom_field_flag} is set, then the picture is added as a bottom field reference to the list of active reference pictures.</li>
                <li>For each added reference picture, the corresponding image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-picture-data-access">H.264 Decode Picture Data Access</a> section.</li>
                <li>Each added reference picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> index specified in the {@code slotIndex} member of the corresponding element of ##VkVideoDecodeInfoKHR{@code ::pReferenceSlots}.</li>
                <li>Each added reference picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-reference-info">H.264 reference information</a> provided in {@code pStdReferenceInfo}.</li>
            </ul></dd>
        </dl>

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        When both the top and bottom field of an interlaced frame currently associated with a DPB slot is intended to be used as an active reference picture and both fields are stored in the same image subregion (which is the case when using #VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_INTERLEAVED_LINES_BIT_KHR which stores the two fields at even and odd scanlines of the same image subregion), both references have to be provided through a single ##VkVideoReferenceSlotInfoKHR structure that has both {@code flags.top_field_flag} and {@code flags.bottom_field_flag} set in the {@code StdVideoDecodeH264ReferenceInfo} structure pointed to by the {@code pStdReferenceInfo} member of the ##VkVideoDecodeH264DpbSlotInfoKHR structure included in the corresponding ##VkVideoReferenceSlotInfoKHR structure’s {@code pNext} chain. However, this approach can only be used when both fields are stored in the same image subregion. If that is not the case (e.g. when using #VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_SEPARATE_PLANES_BIT_KHR which requires separate {@code codedOffset} values for the two fields and also allows storing the two fields of a frame in separate image layers or entirely separate images), then a separate ##VkVideoReferenceSlotInfoKHR structure needs to be provided for referencing the two fields, each only setting one of {@code flags.top_field_flag} or {@code flags.bottom_field_flag}, and providing the appropriate video picture resource information in ##VkVideoReferenceSlotInfoKHR{@code ::pPictureResource}.
        </div>

        <dl>
            <dt>Reconstructed Picture Information</dt>
            <dd><ul>
                <li>If neither {@code pStdReferenceInfo→flags.top_field_flag} nor {@code pStdReferenceInfo→flags.bottom_field_flag} is set, then the picture represents a frame.</li>
                <li>If {@code pStdReferenceInfo→flags.top_field_flag} is set, then the picture represents a field, specifically, the top field of the frame.</li>
                <li>If {@code pStdReferenceInfo→flags.bottom_field_flag} is set, then the picture represents a field, specifically, the bottom field of the frame.</li>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-picture-data-access">H.264 Decode Picture Data Access</a> section.</li>
                <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-ref-pic-setup">reference picture setup</a> is requested, then the reconstructed picture is used to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">activate</a> the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> with the index specified in ##VkVideoDecodeInfoKHR{@code ::pSetupReferenceSlot→slotIndex}.</li>
                <li>The reconstructed picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h264-reference-info">H.264 reference information</a> provided in {@code pStdReferenceInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Std Reference Information</dt>
            <dd><ul>
                <li>{@code flags.top_field_flag} is used to indicate whether the reference is used as top field reference;</li>
                <li>{@code flags.bottom_field_flag} is used to indicate whether the reference is used as bottom field reference;</li>
                <li>{@code flags.used_for_long_term_reference} is used to indicate whether the picture is marked as “used for long-term reference” as defined in section 8.2.5.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>{@code flags.is_non_existing} is used to indicate whether the picture is marked as “non-existing” as defined in section 8.2.5.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>;</li>
                <li>all other members are interpreted as defined in section 8.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h264">ITU-T H.264 Specification</a>.</li>
            </ul></dd>
        </dl>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR</li>
            <li>{@code pStdReferenceInfo} <b>must</b> be a valid pointer to a valid {@code StdVideoDecodeH264ReferenceInfo} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoDecodeH264ReferenceInfo.const.p("pStdReferenceInfo", "a pointer to a {@code StdVideoDecodeH264ReferenceInfo} structure specifying <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h264-reference-info\">H.264 reference information</a>.")
}

val VkTextureLODGatherFormatPropertiesAMD = struct(Module.VULKAN, "VkTextureLODGatherFormatPropertiesAMD", mutable = false) {
    documentation =
        """
        Structure informing whether or not texture gather bias/LOD functionality is supported for a given image format and a given physical device.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkBool32("supportsTextureGatherLODBiasAMD", "tells if the image format can be used with texture gather bias/LOD functions, as introduced by the {@link AMDTextureGatherBiasLod VK_AMD_texture_gather_bias_lod} extension. This field is set by the implementation. An application-specified value is ignored.")
}

val VkShaderResourceUsageAMD = struct(Module.VULKAN, "VkShaderResourceUsageAMD", mutable = false) {
    documentation =
        """
        Resource usage information about a particular shader within a pipeline.

        <h5>See Also</h5>
        ##VkShaderStatisticsInfoAMD
        """

    uint32_t("numUsedVgprs", "the number of vector instruction general-purpose registers used by this shader.")
    uint32_t("numUsedSgprs", "the number of scalar instruction general-purpose registers used by this shader.")
    uint32_t("ldsSizePerLocalWorkGroup", "the maximum local data store size per work group in bytes.")
    size_t("ldsUsageSizeInBytes", "the LDS usage size in bytes per work group by this shader.")
    size_t("scratchMemUsageInBytes", "the scratch memory usage in bytes by this shader.")
}

val VkShaderStatisticsInfoAMD = struct(Module.VULKAN, "VkShaderStatisticsInfoAMD", mutable = false) {
    documentation =
        """
        Statistical information about a particular shader within a pipeline.

        <h5>Description</h5>
        Some implementations may merge multiple logical shader stages together in a single shader. In such cases, {@code shaderStageMask} will contain a bitmask of all of the stages that are active within that shader. Consequently, if specifying those stages as input to #GetShaderInfoAMD(), the same output information <b>may</b> be returned for all such shader stage queries.

        The number of available VGPRs and SGPRs ({@code numAvailableVgprs} and {@code numAvailableSgprs} respectively) are the shader-addressable subset of physical registers that is given as a limit to the compiler for register assignment. These values <b>may</b> further be limited by implementations due to performance optimizations where register pressure is a bottleneck.

        <h5>See Also</h5>
        ##VkShaderResourceUsageAMD
        """

    VkShaderStageFlags("shaderStageMask", "are the combination of logical shader stages contained within this shader.")
    VkShaderResourceUsageAMD("resourceUsage", "a ##VkShaderResourceUsageAMD structure describing internal physical device resources used by this shader.")
    uint32_t("numPhysicalVgprs", "the maximum number of vector instruction general-purpose registers (VGPRs) available to the physical device.")
    uint32_t("numPhysicalSgprs", "the maximum number of scalar instruction general-purpose registers (SGPRs) available to the physical device.")
    uint32_t("numAvailableVgprs", "the maximum limit of VGPRs made available to the shader compiler.")
    uint32_t("numAvailableSgprs", "the maximum limit of SGPRs made available to the shader compiler.")
    uint32_t("computeWorkGroupSize", "the local workgroup size of this shader in { X, Y, Z } dimensions.")[3]
}

val VkRenderingInfoKHR = struct(Module.VULKAN, "VkRenderingInfoKHR", alias = VkRenderingInfo) {
    documentation = "See ##VkRenderingInfo."

    Expression("#STRUCTURE_TYPE_RENDERING_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkRenderingFlags("flags", "")
    VkRect2D("renderArea", "")
    uint32_t("layerCount", "")
    uint32_t("viewMask", "")
    AutoSize("pColorAttachments", optional = true)..uint32_t("colorAttachmentCount", "")
    VkRenderingAttachmentInfo.const.p("pColorAttachments", "")
    nullable..VkRenderingAttachmentInfo.const.p("pDepthAttachment", "")
    nullable..VkRenderingAttachmentInfo.const.p("pStencilAttachment", "")
}

val VkRenderingAttachmentInfoKHR = struct(Module.VULKAN, "VkRenderingAttachmentInfoKHR", alias = VkRenderingAttachmentInfo) {
    documentation = "See ##VkRenderingAttachmentInfo."

    Expression("#STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImageView("imageView", "")
    VkImageLayout("imageLayout", "")
    VkResolveModeFlagBits("resolveMode", "")
    VkImageView("resolveImageView", "")
    VkImageLayout("resolveImageLayout", "")
    VkAttachmentLoadOp("loadOp", "")
    VkAttachmentStoreOp("storeOp", "")
    VkClearValue("clearValue", "")
}

val VkPipelineRenderingCreateInfoKHR = struct(Module.VULKAN, "VkPipelineRenderingCreateInfoKHR", alias = VkPipelineRenderingCreateInfo) {
    documentation = "See ##VkPipelineRenderingCreateInfo."

    Expression("#STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    uint32_t("viewMask", "")
    AutoSize("pColorAttachmentFormats", optional = true)..uint32_t("colorAttachmentCount", "")
    nullable..VkFormat.const.p("pColorAttachmentFormats", "")
    VkFormat("depthAttachmentFormat", "")
    VkFormat("stencilAttachmentFormat", "")
}

val VkPhysicalDeviceDynamicRenderingFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceDynamicRenderingFeaturesKHR", alias = VkPhysicalDeviceDynamicRenderingFeatures) {
    documentation = "See ##VkPhysicalDeviceDynamicRenderingFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("dynamicRendering", "")
}

val VkCommandBufferInheritanceRenderingInfoKHR = struct(Module.VULKAN, "VkCommandBufferInheritanceRenderingInfoKHR", alias = VkCommandBufferInheritanceRenderingInfo) {
    documentation = "See ##VkCommandBufferInheritanceRenderingInfo."

    Expression("#STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkRenderingFlags("flags", "")
    uint32_t("viewMask", "")
    AutoSize("pColorAttachmentFormats", optional = true)..uint32_t("colorAttachmentCount", "")
    VkFormat.const.p("pColorAttachmentFormats", "")
    VkFormat("depthAttachmentFormat", "")
    VkFormat("stencilAttachmentFormat", "")
    VkSampleCountFlagBits("rasterizationSamples", "")
}

val VkPhysicalDeviceCornerSampledImageFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceCornerSampledImageFeaturesNV") {
    documentation =
        """
        Structure describing corner sampled image features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceCornerSampledImageFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceCornerSampledImageFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("cornerSampledImage", "specifies whether images can be created with a ##VkImageCreateInfo{@code ::flags} containing #IMAGE_CREATE_CORNER_SAMPLED_BIT_NV. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#resources-images-corner-sampled\">Corner-Sampled Images</a>.")
}

val VkRenderPassMultiviewCreateInfoKHR = struct(Module.VULKAN, "VkRenderPassMultiviewCreateInfoKHR", alias = VkRenderPassMultiviewCreateInfo) {
    documentation = "See ##VkRenderPassMultiviewCreateInfo."

    Expression("#STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pViewMasks", optional = true)..uint32_t("subpassCount", "")
    uint32_t.const.p("pViewMasks", "")
    AutoSize("pViewOffsets", optional = true)..uint32_t("dependencyCount", "")
    int32_t.const.p("pViewOffsets", "")
    AutoSize("pCorrelationMasks", optional = true)..uint32_t("correlationMaskCount", "")
    uint32_t.const.p("pCorrelationMasks", "")
}

val VkPhysicalDeviceMultiviewFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceMultiviewFeaturesKHR", alias = VkPhysicalDeviceMultiviewFeatures) {
    documentation = "See ##VkPhysicalDeviceMultiviewFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("multiview", "")
    VkBool32("multiviewGeometryShader", "")
    VkBool32("multiviewTessellationShader", "")
}

val VkPhysicalDeviceMultiviewPropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceMultiviewPropertiesKHR", mutable = false, alias = VkPhysicalDeviceMultiviewProperties) {
    documentation = "See ##VkPhysicalDeviceMultiviewProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint32_t("maxMultiviewViewCount", "")
    uint32_t("maxMultiviewInstanceIndex", "")
}

val VkExternalImageFormatPropertiesNV = struct(Module.VULKAN, "VkExternalImageFormatPropertiesNV", mutable = false) {
    documentation =
        """
        Structure specifying external image format properties.

        <h5>See Also</h5>
        ##VkImageFormatProperties, #GetPhysicalDeviceExternalImageFormatPropertiesNV()
        """

    VkImageFormatProperties("imageFormatProperties", "will be filled in as when calling #GetPhysicalDeviceImageFormatProperties(), but the values returned <b>may</b> vary depending on the external handle type requested.")
    VkExternalMemoryFeatureFlagsNV("externalMemoryFeatures", "a bitmask of {@code VkExternalMemoryFeatureFlagBitsNV}, indicating properties of the external memory handle type (#GetPhysicalDeviceExternalImageFormatPropertiesNV(){@code ::externalHandleType}) being queried, or 0 if the external memory handle type is 0.")
    VkExternalMemoryHandleTypeFlagsNV("exportFromImportedHandleTypes", "a bitmask of {@code VkExternalMemoryHandleTypeFlagBitsNV} containing a bit set for every external handle type that <b>may</b> be used to create memory from which the handles of the type specified in #GetPhysicalDeviceExternalImageFormatPropertiesNV(){@code ::externalHandleType} <b>can</b> be exported, or 0 if the external memory handle type is 0.")
    VkExternalMemoryHandleTypeFlagsNV("compatibleHandleTypes", "a bitmask of {@code VkExternalMemoryHandleTypeFlagBitsNV} containing a bit set for every external handle type that <b>may</b> be specified simultaneously with the handle type specified by #GetPhysicalDeviceExternalImageFormatPropertiesNV(){@code ::externalHandleType} when calling #AllocateMemory(), or 0 if the external memory handle type is 0. {@code compatibleHandleTypes} will always contain #GetPhysicalDeviceExternalImageFormatPropertiesNV(){@code ::externalHandleType}")
}

val VkExternalMemoryImageCreateInfoNV = struct(Module.VULKAN, "VkExternalMemoryImageCreateInfoNV") {
    documentation =
        """
        Specify that an image may be backed by external memory.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV</li>
            <li>{@code handleTypes} <b>must</b> be a valid combination of {@code VkExternalMemoryHandleTypeFlagBitsNV} values</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkExternalMemoryHandleTypeFlagsNV("handleTypes", "zero or a bitmask of {@code VkExternalMemoryHandleTypeFlagBitsNV} specifying one or more external memory handle types.")
}

val VkExportMemoryAllocateInfoNV = struct(Module.VULKAN, "VkExportMemoryAllocateInfoNV") {
    documentation =
        """
        Specify memory handle types that may be exported.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV</li>
            <li>{@code handleTypes} <b>must</b> be a valid combination of {@code VkExternalMemoryHandleTypeFlagBitsNV} values</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkExternalMemoryHandleTypeFlagsNV("handleTypes", "a bitmask of {@code VkExternalMemoryHandleTypeFlagBitsNV} specifying one or more memory handle types that <b>may</b> be exported. Multiple handle types <b>may</b> be requested for the same allocation as long as they are compatible, as reported by #GetPhysicalDeviceExternalImageFormatPropertiesNV().")
}

val VkImportMemoryWin32HandleInfoNV = struct(Module.VULKAN, "VkImportMemoryWin32HandleInfoNV") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        Import Win32 memory created on the same physical device.

        <h5>Description</h5>
        If {@code handleType} is 0, this structure is ignored by consumers of the ##VkMemoryAllocateInfo structure it is chained from.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> not have more than one bit set</li>
            <li>{@code handle} <b>must</b> be a valid handle to memory, obtained as specified by {@code handleType}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV</li>
            <li>{@code handleType} <b>must</b> be a valid combination of {@code VkExternalMemoryHandleTypeFlagBitsNV} values</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkExternalMemoryHandleTypeFlagsNV("handleType", "0 or a {@code VkExternalMemoryHandleTypeFlagBitsNV} value specifying the type of memory handle in {@code handle}.")
    HANDLE("handle", "a Windows {@code HANDLE} referring to the memory.")
}

val VkExportMemoryWin32HandleInfoNV = struct(Module.VULKAN, "VkExportMemoryWin32HandleInfoNV") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        Specify security attributes and access rights for Win32 memory handles.

        <h5>Description</h5>
        If this structure is not present, or if {@code pAttributes} is {@code NULL}, default security descriptor values will be used, and child processes created by the application will not inherit the handle, as described in the MSDN documentation for “{@code Synchronization Object Security and Access Rights}”<sup>1</sup>. Further, if the structure is not present, the access rights will be

        {@code DXGI_SHARED_RESOURCE_READ} | {@code DXGI_SHARED_RESOURCE_WRITE}

        <dl>
            <dt>1</dt>
            <dd><a href="https://docs.microsoft.com/en-us/windows/win32/sync/synchronization-object-security-and-access-rights">https://docs.microsoft.com/en-us/windows/win32/sync/synchronization-object-security-and-access-rights</a></dd>
        </dl>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV</li>
            <li>If {@code pAttributes} is not {@code NULL}, {@code pAttributes} <b>must</b> be a valid pointer to a valid {@code SECURITY_ATTRIBUTES} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    nullable..SECURITY_ATTRIBUTES.const.p("pAttributes", "a pointer to a Windows {@code SECURITY_ATTRIBUTES} structure specifying security attributes of the handle.")
    DWORD("dwAccess", "a {@code DWORD} specifying access rights of the handle.")
}

val VkWin32KeyedMutexAcquireReleaseInfoNV = struct(Module.VULKAN, "VkWin32KeyedMutexAcquireReleaseInfoNV") {
    documentation =
        """
        Use Windows keyex mutex mechanism to synchronize work.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV</li>
            <li>If {@code acquireCount} is not 0, {@code pAcquireSyncs} <b>must</b> be a valid pointer to an array of {@code acquireCount} valid {@code VkDeviceMemory} handles</li>
            <li>If {@code acquireCount} is not 0, {@code pAcquireKeys} <b>must</b> be a valid pointer to an array of {@code acquireCount} {@code uint64_t} values</li>
            <li>If {@code acquireCount} is not 0, {@code pAcquireTimeoutMilliseconds} <b>must</b> be a valid pointer to an array of {@code acquireCount} {@code uint32_t} values</li>
            <li>If {@code releaseCount} is not 0, {@code pReleaseSyncs} <b>must</b> be a valid pointer to an array of {@code releaseCount} valid {@code VkDeviceMemory} handles</li>
            <li>If {@code releaseCount} is not 0, {@code pReleaseKeys} <b>must</b> be a valid pointer to an array of {@code releaseCount} {@code uint64_t} values</li>
            <li>Both of the elements of {@code pAcquireSyncs}, and the elements of {@code pReleaseSyncs} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pAcquireSyncs", "pAcquireKeys", "pAcquireTimeoutMilliseconds", optional = true)..uint32_t("acquireCount", "the number of entries in the {@code pAcquireSyncs}, {@code pAcquireKeys}, and {@code pAcquireTimeoutMilliseconds} arrays.")
    VkDeviceMemory.const.p("pAcquireSyncs", "a pointer to an array of {@code VkDeviceMemory} objects which were imported from Direct3D 11 resources.")
    uint64_t.const.p("pAcquireKeys", "a pointer to an array of mutex key values to wait for prior to beginning the submitted work. Entries refer to the keyed mutex associated with the corresponding entries in {@code pAcquireSyncs}.")
    uint32_t.const.p("pAcquireTimeoutMilliseconds", "a pointer to an array of timeout values, in millisecond units, for each acquire specified in {@code pAcquireKeys}.")
    AutoSize("pReleaseSyncs", "pReleaseKeys", optional = true)..uint32_t("releaseCount", "the number of entries in the {@code pReleaseSyncs} and {@code pReleaseKeys} arrays.")
    VkDeviceMemory.const.p("pReleaseSyncs", "a pointer to an array of {@code VkDeviceMemory} objects which were imported from Direct3D 11 resources.")
    uint64_t.const.p("pReleaseKeys", "a pointer to an array of mutex key values to set when the submitted work has completed. Entries refer to the keyed mutex associated with the corresponding entries in {@code pReleaseSyncs}.")
}

val VkPhysicalDeviceFeatures2KHR = struct(Module.VULKAN, "VkPhysicalDeviceFeatures2KHR", alias = VkPhysicalDeviceFeatures2) {
    documentation = "See ##VkPhysicalDeviceFeatures2."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkPhysicalDeviceFeatures("features", "")
}

val VkPhysicalDeviceProperties2KHR = struct(Module.VULKAN, "VkPhysicalDeviceProperties2KHR", mutable = false, alias = VkPhysicalDeviceProperties2) {
    documentation = "See ##VkPhysicalDeviceProperties2."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkPhysicalDeviceProperties("properties", "")
}

val VkFormatProperties2KHR = struct(Module.VULKAN, "VkFormatProperties2KHR", mutable = false, alias = VkFormatProperties2) {
    documentation = "See ##VkFormatProperties2."

    Expression("#STRUCTURE_TYPE_FORMAT_PROPERTIES_2")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkFormatProperties("formatProperties", "")
}

val VkImageFormatProperties2KHR = struct(Module.VULKAN, "VkImageFormatProperties2KHR", mutable = false, alias = VkImageFormatProperties2) {
    documentation = "See ##VkImageFormatProperties2."

    Expression("#STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkImageFormatProperties("imageFormatProperties", "")
}

val VkPhysicalDeviceImageFormatInfo2KHR = struct(Module.VULKAN, "VkPhysicalDeviceImageFormatInfo2KHR", alias = VkPhysicalDeviceImageFormatInfo2) {
    documentation = "See ##VkPhysicalDeviceImageFormatInfo2."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkFormat("format", "")
    VkImageType("type", "")
    VkImageTiling("tiling", "")
    VkImageUsageFlags("usage", "")
    VkImageCreateFlags("flags", "")
}

val VkQueueFamilyProperties2KHR = struct(Module.VULKAN, "VkQueueFamilyProperties2KHR", mutable = false, alias = VkQueueFamilyProperties2) {
    documentation = "See ##VkQueueFamilyProperties2."

    Expression("#STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkQueueFamilyProperties("queueFamilyProperties", "")
}

val VkPhysicalDeviceMemoryProperties2KHR = struct(Module.VULKAN, "VkPhysicalDeviceMemoryProperties2KHR", mutable = false, alias = VkPhysicalDeviceMemoryProperties2) {
    documentation = "See ##VkPhysicalDeviceMemoryProperties2."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkPhysicalDeviceMemoryProperties("memoryProperties", "")
}

val VkSparseImageFormatProperties2KHR = struct(Module.VULKAN, "VkSparseImageFormatProperties2KHR", mutable = false, alias = VkSparseImageFormatProperties2) {
    documentation = "See ##VkSparseImageFormatProperties2."

    Expression("#STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkSparseImageFormatProperties("properties", "")
}

val VkPhysicalDeviceSparseImageFormatInfo2KHR = struct(Module.VULKAN, "VkPhysicalDeviceSparseImageFormatInfo2KHR", alias = VkPhysicalDeviceSparseImageFormatInfo2) {
    documentation = "See ##VkPhysicalDeviceSparseImageFormatInfo2."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkFormat("format", "")
    VkImageType("type", "")
    VkSampleCountFlagBits("samples", "")
    VkImageUsageFlags("usage", "")
    VkImageTiling("tiling", "")
}

val VkMemoryAllocateFlagsInfoKHR = struct(Module.VULKAN, "VkMemoryAllocateFlagsInfoKHR", alias = VkMemoryAllocateFlagsInfo) {
    documentation = "See ##VkMemoryAllocateFlagsInfo."

    Expression("#STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkMemoryAllocateFlags("flags", "")
    uint32_t("deviceMask", "")
}

val VkDeviceGroupRenderPassBeginInfoKHR = struct(Module.VULKAN, "VkDeviceGroupRenderPassBeginInfoKHR", alias = VkDeviceGroupRenderPassBeginInfo) {
    documentation = "See ##VkDeviceGroupRenderPassBeginInfo."

    Expression("#STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    uint32_t("deviceMask", "")
    AutoSize("pDeviceRenderAreas", optional = true)..uint32_t("deviceRenderAreaCount", "")
    VkRect2D.const.p("pDeviceRenderAreas", "")
}

val VkDeviceGroupCommandBufferBeginInfoKHR = struct(Module.VULKAN, "VkDeviceGroupCommandBufferBeginInfoKHR", alias = VkDeviceGroupCommandBufferBeginInfo) {
    documentation = "See ##VkDeviceGroupCommandBufferBeginInfo."

    Expression("#STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    uint32_t("deviceMask", "")
}

val VkDeviceGroupSubmitInfoKHR = struct(Module.VULKAN, "VkDeviceGroupSubmitInfoKHR", alias = VkDeviceGroupSubmitInfo) {
    documentation = "See ##VkDeviceGroupSubmitInfo."

    Expression("#STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pWaitSemaphoreDeviceIndices", optional = true)..uint32_t("waitSemaphoreCount", "")
    uint32_t.const.p("pWaitSemaphoreDeviceIndices", "")
    AutoSize("pCommandBufferDeviceMasks", optional = true)..uint32_t("commandBufferCount", "")
    uint32_t.const.p("pCommandBufferDeviceMasks", "")
    AutoSize("pSignalSemaphoreDeviceIndices", optional = true)..uint32_t("signalSemaphoreCount", "")
    uint32_t.const.p("pSignalSemaphoreDeviceIndices", "")
}

val VkDeviceGroupBindSparseInfoKHR = struct(Module.VULKAN, "VkDeviceGroupBindSparseInfoKHR", alias = VkDeviceGroupBindSparseInfo) {
    documentation = "See ##VkDeviceGroupBindSparseInfo."

    Expression("#STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    uint32_t("resourceDeviceIndex", "")
    uint32_t("memoryDeviceIndex", "")
}

val VkBindBufferMemoryDeviceGroupInfoKHR = struct(Module.VULKAN, "VkBindBufferMemoryDeviceGroupInfoKHR", alias = VkBindBufferMemoryDeviceGroupInfo) {
    documentation = "See ##VkBindBufferMemoryDeviceGroupInfo."

    Expression("#STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pDeviceIndices", optional = true)..uint32_t("deviceIndexCount", "")
    uint32_t.const.p("pDeviceIndices", "")
}

val VkBindImageMemoryDeviceGroupInfoKHR = struct(Module.VULKAN, "VkBindImageMemoryDeviceGroupInfoKHR", alias = VkBindImageMemoryDeviceGroupInfo) {
    documentation = "See ##VkBindImageMemoryDeviceGroupInfo."

    Expression("#STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pDeviceIndices", optional = true)..uint32_t("deviceIndexCount", "")
    uint32_t.const.p("pDeviceIndices", "")
    AutoSize("pSplitInstanceBindRegions", optional = true)..uint32_t("splitInstanceBindRegionCount", "")
    VkRect2D.const.p("pSplitInstanceBindRegions", "")
}

val VkValidationFlagsEXT = struct(Module.VULKAN, "VkValidationFlagsEXT") {
    documentation =
        """
        Specify validation checks to disable for a Vulkan instance.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VALIDATION_FLAGS_EXT</li>
            <li>{@code pDisabledValidationChecks} <b>must</b> be a valid pointer to an array of {@code disabledValidationCheckCount} valid {@code VkValidationCheckEXT} values</li>
            <li>{@code disabledValidationCheckCount} <b>must</b> be greater than 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VALIDATION_FLAGS_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pDisabledValidationChecks")..uint32_t("disabledValidationCheckCount", "the number of checks to disable.")
    VkValidationCheckEXT.const.p("pDisabledValidationChecks", "a pointer to an array of {@code VkValidationCheckEXT} values specifying the validation checks to be disabled.")
}

val VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT", alias = VkPhysicalDeviceTextureCompressionASTCHDRFeatures) {
    documentation = "See ##VkPhysicalDeviceTextureCompressionASTCHDRFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("textureCompressionASTC_HDR", "")
}

val VkImageViewASTCDecodeModeEXT = struct(Module.VULKAN, "VkImageViewASTCDecodeModeEXT") {
    documentation =
        """
        Structure describing the ASTC decode mode for an image view.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code decodeMode} <b>must</b> be one of #FORMAT_R16G16B16A16_SFLOAT, #FORMAT_R8G8B8A8_UNORM, or #FORMAT_E5B9G9R9_UFLOAT_PACK32</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-astc-decodeModeSharedExponent">{@code decodeModeSharedExponent}</a> feature is not enabled, {@code decodeMode} <b>must</b> not be #FORMAT_E5B9G9R9_UFLOAT_PACK32</li>
            <li>If {@code decodeMode} is #FORMAT_R8G8B8A8_UNORM the image view <b>must</b> not include blocks using any of the ASTC HDR modes</li>
            <li>{@code format} of the image view <b>must</b> be one of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#appendix-compressedtex-astc">ASTC Compressed Image Formats</a></li>
        </ul>

        If {@code format} uses sRGB encoding then the {@code decodeMode} has no effect.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT</li>
            <li>{@code decodeMode} <b>must</b> be a valid {@code VkFormat} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkFormat("decodeMode", "the intermediate format used to decode ASTC compressed formats.")
}

val VkPhysicalDeviceASTCDecodeFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceASTCDecodeFeaturesEXT") {
    documentation =
        """
        Structure describing ASTC decode mode features.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceASTCDecodeFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceASTCDecodeFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("decodeModeSharedExponent", "indicates whether the implementation supports decoding ASTC compressed formats to #FORMAT_E5B9G9R9_UFLOAT_PACK32 internal precision.")
}

val VkPhysicalDevicePipelineRobustnessFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDevicePipelineRobustnessFeaturesEXT", alias = VkPhysicalDevicePipelineRobustnessFeatures) {
    documentation = "See ##VkPhysicalDevicePipelineRobustnessFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("pipelineRobustness", "")
}

val VkPhysicalDevicePipelineRobustnessPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDevicePipelineRobustnessPropertiesEXT", mutable = false, alias = VkPhysicalDevicePipelineRobustnessProperties) {
    documentation = "See ##VkPhysicalDevicePipelineRobustnessProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkPipelineRobustnessBufferBehavior("defaultRobustnessStorageBuffers", "")
    VkPipelineRobustnessBufferBehavior("defaultRobustnessUniformBuffers", "")
    VkPipelineRobustnessBufferBehavior("defaultRobustnessVertexInputs", "")
    VkPipelineRobustnessImageBehavior("defaultRobustnessImages", "")
}

val VkPipelineRobustnessCreateInfoEXT = struct(Module.VULKAN, "VkPipelineRobustnessCreateInfoEXT", alias = VkPipelineRobustnessCreateInfo) {
    documentation = "See ##VkPipelineRobustnessCreateInfo."

    Expression("#STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkPipelineRobustnessBufferBehavior("storageBuffers", "")
    VkPipelineRobustnessBufferBehavior("uniformBuffers", "")
    VkPipelineRobustnessBufferBehavior("vertexInputs", "")
    VkPipelineRobustnessImageBehavior("images", "")
}

val VkPhysicalDeviceGroupPropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceGroupPropertiesKHR", mutable = false, alias = VkPhysicalDeviceGroupProperties) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation = "See ##VkPhysicalDeviceGroupProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    AutoSize("physicalDevices")..uint32_t("physicalDeviceCount", "")
    VkPhysicalDevice("physicalDevices", "")["VK_MAX_DEVICE_GROUP_SIZE"]
    VkBool32("subsetAllocation", "")
}

val VkDeviceGroupDeviceCreateInfoKHR = struct(Module.VULKAN, "VkDeviceGroupDeviceCreateInfoKHR", alias = VkDeviceGroupDeviceCreateInfo) {
    documentation = "See ##VkDeviceGroupDeviceCreateInfo."

    Expression("#STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pPhysicalDevices", optional = true)..uint32_t("physicalDeviceCount", "")
    VkPhysicalDevice.const.p("pPhysicalDevices", "")
}

val VkExternalMemoryPropertiesKHR = struct(Module.VULKAN, "VkExternalMemoryPropertiesKHR", mutable = false, alias = VkExternalMemoryProperties) {
    documentation = "See ##VkExternalMemoryProperties."

    VkExternalMemoryFeatureFlags("externalMemoryFeatures", "")
    VkExternalMemoryHandleTypeFlags("exportFromImportedHandleTypes", "")
    VkExternalMemoryHandleTypeFlags("compatibleHandleTypes", "")
}

val VkPhysicalDeviceExternalImageFormatInfoKHR = struct(Module.VULKAN, "VkPhysicalDeviceExternalImageFormatInfoKHR", alias = VkPhysicalDeviceExternalImageFormatInfo) {
    documentation = "See ##VkPhysicalDeviceExternalImageFormatInfo."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkExternalMemoryHandleTypeFlagBits("handleType", "")
}

val VkExternalImageFormatPropertiesKHR = struct(Module.VULKAN, "VkExternalImageFormatPropertiesKHR", mutable = false, alias = VkExternalImageFormatProperties) {
    documentation = "See ##VkExternalImageFormatProperties."

    Expression("#STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkExternalMemoryProperties("externalMemoryProperties", "")
}

val VkPhysicalDeviceExternalBufferInfoKHR = struct(Module.VULKAN, "VkPhysicalDeviceExternalBufferInfoKHR", alias = VkPhysicalDeviceExternalBufferInfo) {
    documentation = "See ##VkPhysicalDeviceExternalBufferInfo."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkBufferCreateFlags("flags", "")
    VkBufferUsageFlags("usage", "")
    VkExternalMemoryHandleTypeFlagBits("handleType", "")
}

val VkExternalBufferPropertiesKHR = struct(Module.VULKAN, "VkExternalBufferPropertiesKHR", mutable = false, alias = VkExternalBufferProperties) {
    documentation = "See ##VkExternalBufferProperties."

    Expression("#STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkExternalMemoryProperties("externalMemoryProperties", "")
}

val VkPhysicalDeviceIDPropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceIDPropertiesKHR", mutable = false, alias = VkPhysicalDeviceIDProperties) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation = "See ##VkPhysicalDeviceIDProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint8_t("deviceUUID", "")["VK_UUID_SIZE"]
    uint8_t("driverUUID", "")["VK_UUID_SIZE"]
    uint8_t("deviceLUID", "")["VK_LUID_SIZE"]
    uint32_t("deviceNodeMask", "")
    VkBool32("deviceLUIDValid", "")
}

val VkExternalMemoryImageCreateInfoKHR = struct(Module.VULKAN, "VkExternalMemoryImageCreateInfoKHR", alias = VkExternalMemoryImageCreateInfo) {
    documentation = "See ##VkExternalMemoryImageCreateInfo."

    Expression("#STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkExternalMemoryHandleTypeFlags("handleTypes", "")
}

val VkExternalMemoryBufferCreateInfoKHR = struct(Module.VULKAN, "VkExternalMemoryBufferCreateInfoKHR", alias = VkExternalMemoryBufferCreateInfo) {
    documentation = "See ##VkExternalMemoryBufferCreateInfo."

    Expression("#STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkExternalMemoryHandleTypeFlags("handleTypes", "")
}

val VkExportMemoryAllocateInfoKHR = struct(Module.VULKAN, "VkExportMemoryAllocateInfoKHR", alias = VkExportMemoryAllocateInfo) {
    documentation = "See ##VkExportMemoryAllocateInfo."

    Expression("#STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkExternalMemoryHandleTypeFlags("handleTypes", "")
}

val VkImportMemoryWin32HandleInfoKHR = struct(Module.VULKAN, "VkImportMemoryWin32HandleInfoKHR") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        Import Win32 memory created on the same physical device.

        <h5>Description</h5>
        Importing memory object payloads from Windows handles does not transfer ownership of the handle to the Vulkan implementation. For handle types defined as NT handles, the application <b>must</b> release handle ownership using the {@code CloseHandle} system call when the handle is no longer needed. For handle types defined as NT handles, the imported memory object holds a reference to its payload.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Non-NT handle import operations do not add a reference to their associated payload. If the original object owning the payload is destroyed, all resources and handles sharing that payload will become invalid.
        </div>

        Applications <b>can</b> import the same payload into multiple instances of Vulkan, into the same instance from which it was exported, and multiple times into a given Vulkan instance. In all cases, each import operation <b>must</b> create a distinct {@code VkDeviceMemory} object.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code handleType} is not 0, it <b>must</b> be supported for import, as reported by ##VkExternalImageFormatProperties or ##VkExternalBufferProperties</li>
            <li>The memory from which {@code handle} was exported, or the memory named by {@code name} <b>must</b> have been created on the same underlying physical device as {@code device}</li>
            <li>If {@code handleType} is not 0, it <b>must</b> be defined as an NT handle or a global share handle</li>
            <li>If {@code handleType} is not #EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, #EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, #EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or #EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, {@code name} <b>must</b> be {@code NULL}</li>
            <li>If {@code handleType} is not 0 and {@code handle} is {@code NULL}, {@code name} <b>must</b> name a valid memory resource of the type specified by {@code handleType}</li>
            <li>If {@code handleType} is not 0 and {@code name} is {@code NULL}, {@code handle} <b>must</b> be a valid handle of the type specified by {@code handleType}</li>
            <li>If {@code handle} is not {@code NULL}, {@code name} <b>must</b> be {@code NULL}</li>
            <li>If {@code handle} is not {@code NULL}, it <b>must</b> obey any requirements listed for {@code handleType} in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-memory-handle-types-compatibility">external memory handle types compatibility</a></li>
            <li>If {@code name} is not {@code NULL}, it <b>must</b> obey any requirements listed for {@code handleType} in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-memory-handle-types-compatibility">external memory handle types compatibility</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR</li>
            <li>If {@code handleType} is not 0, {@code handleType} <b>must</b> be a valid {@code VkExternalMemoryHandleTypeFlagBits} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkExternalMemoryHandleTypeFlagBits("handleType", "a {@code VkExternalMemoryHandleTypeFlagBits} value specifying the type of {@code handle} or {@code name}.")
    HANDLE("handle", "{@code NULL} or the external handle to import.")
    LPCWSTR("name", "{@code NULL} or a null-terminated UTF-16 string naming the payload to import.")
}

val VkExportMemoryWin32HandleInfoKHR = struct(Module.VULKAN, "VkExportMemoryWin32HandleInfoKHR") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        Structure specifying additional attributes of Windows handles exported from a memory.

        <h5>Description</h5>
        If ##VkExportMemoryAllocateInfo is not included in the same {@code pNext} chain, this structure is ignored.

        If ##VkExportMemoryAllocateInfo is included in the {@code pNext} chain of ##VkMemoryAllocateInfo with a Windows {@code handleType}, but either ##VkExportMemoryWin32HandleInfoKHR is not included in the {@code pNext} chain, or it is included but {@code pAttributes} is set to {@code NULL}, default security descriptor values will be used, and child processes created by the application will not inherit the handle, as described in the MSDN documentation for “{@code Synchronization Object Security and Access Rights}”<sup>1</sup>. Further, if the structure is not present, the access rights used depend on the handle type.

        For handles of the following types:

        <ul>
            <li>#EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT</li>
        </ul>

        The implementation <b>must</b> ensure the access rights allow read and write access to the memory.

        <dl>
            <dt>1</dt>
            <dd><a href="https://docs.microsoft.com/en-us/windows/win32/sync/synchronization-object-security-and-access-rights">https://docs.microsoft.com/en-us/windows/win32/sync/synchronization-object-security-and-access-rights</a></dd>
        </dl>

        <h5>Valid Usage</h5>
        <ul>
            <li>If ##VkExportMemoryAllocateInfo{@code ::handleTypes} does not include #EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, a ##VkExportMemoryWin32HandleInfoKHR structure <b>must</b> not be included in the {@code pNext} chain of ##VkMemoryAllocateInfo</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR</li>
            <li>If {@code pAttributes} is not {@code NULL}, {@code pAttributes} <b>must</b> be a valid pointer to a valid {@code SECURITY_ATTRIBUTES} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    nullable..SECURITY_ATTRIBUTES.const.p("pAttributes", "a pointer to a Windows {@code SECURITY_ATTRIBUTES} structure specifying security attributes of the handle.")
    DWORD("dwAccess", "a {@code DWORD} specifying access rights of the handle.")
    LPCWSTR("name", "a null-terminated UTF-16 string to associate with the payload referenced by NT handles exported from the created memory.")
}

val VkMemoryWin32HandlePropertiesKHR = struct(Module.VULKAN, "VkMemoryWin32HandlePropertiesKHR", mutable = false) {
    documentation =
        """
        Properties of External Memory Windows Handles.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetMemoryWin32HandlePropertiesKHR()
        """

    Expression("#STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("memoryTypeBits", "a bitmask containing one bit set for every memory type which the specified windows handle <b>can</b> be imported as.")
}

val VkMemoryGetWin32HandleInfoKHR = struct(Module.VULKAN, "VkMemoryGetWin32HandleInfoKHR") {
    documentation =
        """
        Structure describing a Win32 handle memory export operation.

        <h5>Description</h5>
        The properties of the handle returned depend on the value of {@code handleType}. See {@code VkExternalMemoryHandleTypeFlagBits} for a description of the properties of the defined external memory handle types.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> have been included in ##VkExportMemoryAllocateInfo{@code ::handleTypes} when {@code memory} was created</li>
            <li>If {@code handleType} is defined as an NT handle, #GetMemoryWin32HandleKHR() <b>must</b> be called no more than once for each valid unique combination of {@code memory} and {@code handleType}</li>
            <li>{@code handleType} <b>must</b> be defined as an NT handle or a global share handle</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
            <li>{@code handleType} <b>must</b> be a valid {@code VkExternalMemoryHandleTypeFlagBits} value</li>
        </ul>

        <h5>See Also</h5>
        #GetMemoryWin32HandleKHR()
        """

    Expression("#STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceMemory("memory", "the memory object from which the handle will be exported.")
    VkExternalMemoryHandleTypeFlagBits("handleType", "a {@code VkExternalMemoryHandleTypeFlagBits} value specifying the type of handle requested.")
}

val VkImportMemoryFdInfoKHR = struct(Module.VULKAN, "VkImportMemoryFdInfoKHR") {
    documentation =
        """
        Import memory created on the same physical device from a file descriptor.

        <h5>Description</h5>
        Importing memory from a file descriptor transfers ownership of the file descriptor from the application to the Vulkan implementation. The application <b>must</b> not perform any operations on the file descriptor after a successful import. The imported memory object holds a reference to its payload.

        Applications <b>can</b> import the same payload into multiple instances of Vulkan, into the same instance from which it was exported, and multiple times into a given Vulkan instance. In all cases, each import operation <b>must</b> create a distinct {@code VkDeviceMemory} object.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code handleType} is not 0, it <b>must</b> be supported for import, as reported by ##VkExternalImageFormatProperties or ##VkExternalBufferProperties</li>
            <li>The memory from which {@code fd} was exported <b>must</b> have been created on the same underlying physical device as {@code device}</li>
            <li>If {@code handleType} is not 0, it <b>must</b> be #EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT or #EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT</li>
            <li>If {@code handleType} is not 0, {@code fd} <b>must</b> be a valid handle of the type specified by {@code handleType}</li>
            <li>The memory represented by {@code fd} <b>must</b> have been created from a physical device and driver that is compatible with {@code device} and {@code handleType}, as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-memory-handle-types-compatibility">External memory handle types compatibility</a></li>
            <li>{@code fd} <b>must</b> obey any requirements listed for {@code handleType} in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-memory-handle-types-compatibility">external memory handle types compatibility</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR</li>
            <li>If {@code handleType} is not 0, {@code handleType} <b>must</b> be a valid {@code VkExternalMemoryHandleTypeFlagBits} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkExternalMemoryHandleTypeFlagBits("handleType", "a {@code VkExternalMemoryHandleTypeFlagBits} value specifying the handle type of {@code fd}.")
    int("fd", "the external handle to import.")
}

val VkMemoryFdPropertiesKHR = struct(Module.VULKAN, "VkMemoryFdPropertiesKHR", mutable = false) {
    documentation =
        """
        Properties of External Memory File Descriptors.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetMemoryFdPropertiesKHR()
        """

    Expression("#STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("memoryTypeBits", "a bitmask containing one bit set for every memory type which the specified file descriptor <b>can</b> be imported as.")
}

val VkMemoryGetFdInfoKHR = struct(Module.VULKAN, "VkMemoryGetFdInfoKHR") {
    documentation =
        """
        Structure describing a POSIX FD memory export operation.

        <h5>Description</h5>
        The properties of the file descriptor exported depend on the value of {@code handleType}. See {@code VkExternalMemoryHandleTypeFlagBits} for a description of the properties of the defined external memory handle types.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The size of the exported file <b>may</b> be larger than the size requested by ##VkMemoryAllocateInfo{@code ::allocationSize}. If {@code handleType} is #EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT, then the application <b>can</b> query the file’s actual size with <a href="https://man7.org/linux/man-pages/man2/lseek.2.html">{@code lseek}</a>.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> have been included in ##VkExportMemoryAllocateInfo{@code ::handleTypes} when {@code memory} was created</li>
            <li>{@code handleType} <b>must</b> be #EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT or #EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
            <li>{@code handleType} <b>must</b> be a valid {@code VkExternalMemoryHandleTypeFlagBits} value</li>
        </ul>

        <h5>See Also</h5>
        #GetMemoryFdKHR()
        """

    Expression("#STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceMemory("memory", "the memory object from which the handle will be exported.")
    VkExternalMemoryHandleTypeFlagBits("handleType", "a {@code VkExternalMemoryHandleTypeFlagBits} value specifying the type of handle requested.")
}

val VkWin32KeyedMutexAcquireReleaseInfoKHR = struct(Module.VULKAN, "VkWin32KeyedMutexAcquireReleaseInfoKHR") {
    documentation =
        """
        Use the Windows keyed mutex mechanism to synchronize work.

        <h5>Valid Usage</h5>
        <ul>
            <li>Each member of {@code pAcquireSyncs} and {@code pReleaseSyncs} <b>must</b> be a device memory object imported by setting ##VkImportMemoryWin32HandleInfoKHR{@code ::handleType} to #EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT or #EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR</li>
            <li>If {@code acquireCount} is not 0, {@code pAcquireSyncs} <b>must</b> be a valid pointer to an array of {@code acquireCount} valid {@code VkDeviceMemory} handles</li>
            <li>If {@code acquireCount} is not 0, {@code pAcquireKeys} <b>must</b> be a valid pointer to an array of {@code acquireCount} {@code uint64_t} values</li>
            <li>If {@code acquireCount} is not 0, {@code pAcquireTimeouts} <b>must</b> be a valid pointer to an array of {@code acquireCount} {@code uint32_t} values</li>
            <li>If {@code releaseCount} is not 0, {@code pReleaseSyncs} <b>must</b> be a valid pointer to an array of {@code releaseCount} valid {@code VkDeviceMemory} handles</li>
            <li>If {@code releaseCount} is not 0, {@code pReleaseKeys} <b>must</b> be a valid pointer to an array of {@code releaseCount} {@code uint64_t} values</li>
            <li>Both of the elements of {@code pAcquireSyncs}, and the elements of {@code pReleaseSyncs} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pAcquireSyncs", "pAcquireKeys", "pAcquireTimeouts", optional = true)..uint32_t("acquireCount", "the number of entries in the {@code pAcquireSyncs}, {@code pAcquireKeys}, and {@code pAcquireTimeouts} arrays.")
    VkDeviceMemory.const.p("pAcquireSyncs", "a pointer to an array of {@code VkDeviceMemory} objects which were imported from Direct3D 11 resources.")
    uint64_t.const.p("pAcquireKeys", "a pointer to an array of mutex key values to wait for prior to beginning the submitted work. Entries refer to the keyed mutex associated with the corresponding entries in {@code pAcquireSyncs}.")
    uint32_t.const.p("pAcquireTimeouts", "a pointer to an array of timeout values, in millisecond units, for each acquire specified in {@code pAcquireKeys}.")
    AutoSize("pReleaseSyncs", "pReleaseKeys", optional = true)..uint32_t("releaseCount", "the number of entries in the {@code pReleaseSyncs} and {@code pReleaseKeys} arrays.")
    VkDeviceMemory.const.p("pReleaseSyncs", "a pointer to an array of {@code VkDeviceMemory} objects which were imported from Direct3D 11 resources.")
    uint64_t.const.p("pReleaseKeys", "a pointer to an array of mutex key values to set when the submitted work has completed. Entries refer to the keyed mutex associated with the corresponding entries in {@code pReleaseSyncs}.")
}

val VkPhysicalDeviceExternalSemaphoreInfoKHR = struct(Module.VULKAN, "VkPhysicalDeviceExternalSemaphoreInfoKHR", alias = VkPhysicalDeviceExternalSemaphoreInfo) {
    documentation = "See ##VkPhysicalDeviceExternalSemaphoreInfo."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkExternalSemaphoreHandleTypeFlagBits("handleType", "")
}

val VkExternalSemaphorePropertiesKHR = struct(Module.VULKAN, "VkExternalSemaphorePropertiesKHR", mutable = false, alias = VkExternalSemaphoreProperties) {
    documentation = "See ##VkExternalSemaphoreProperties."

    Expression("#STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkExternalSemaphoreHandleTypeFlags("exportFromImportedHandleTypes", "")
    VkExternalSemaphoreHandleTypeFlags("compatibleHandleTypes", "")
    VkExternalSemaphoreFeatureFlags("externalSemaphoreFeatures", "")
}

val VkExportSemaphoreCreateInfoKHR = struct(Module.VULKAN, "VkExportSemaphoreCreateInfoKHR", alias = VkExportSemaphoreCreateInfo) {
    documentation = "See ##VkExportSemaphoreCreateInfo."

    Expression("#STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkExternalSemaphoreHandleTypeFlags("handleTypes", "")
}

val VkImportSemaphoreWin32HandleInfoKHR = struct(Module.VULKAN, "VkImportSemaphoreWin32HandleInfoKHR") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        Structure specifying Windows handle to import to a semaphore.

        <h5>Description</h5>
        The handle types supported by {@code handleType} are:

        <h6>Handle Types Supported by ##VkImportSemaphoreWin32HandleInfoKHR</h6>
        <table class="lwjgl">
            <thead><tr><th>Handle Type</th><th>Transference</th><th>Permanence Supported</th></tr></thead>
            <tbody>
                <tr><td>#EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT</td><td>Reference</td><td>Temporary,Permanent</td></tr>
                <tr><td>#EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT</td><td>Reference</td><td>Temporary,Permanent</td></tr>
                <tr><td>#EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT</td><td>Reference</td><td>Temporary,Permanent</td></tr>
            </tbody>
        </table>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> be a value included in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphore-handletypes-win32">Handle Types Supported by ##VkImportSemaphoreWin32HandleInfoKHR</a> table</li>
            <li>If {@code handleType} is not #EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or #EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, {@code name} <b>must</b> be {@code NULL}</li>
            <li>If {@code handle} is {@code NULL}, {@code name} <b>must</b> name a valid synchronization primitive of the type specified by {@code handleType}</li>
            <li>If {@code name} is {@code NULL}, {@code handle} <b>must</b> be a valid handle of the type specified by {@code handleType}</li>
            <li>If {@code handle} is not {@code NULL}, {@code name} <b>must</b> be {@code NULL}</li>
            <li>If {@code handle} is not {@code NULL}, it <b>must</b> obey any requirements listed for {@code handleType} in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-semaphore-handle-types-compatibility">external semaphore handle types compatibility</a></li>
            <li>If {@code name} is not {@code NULL}, it <b>must</b> obey any requirements listed for {@code handleType} in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-semaphore-handle-types-compatibility">external semaphore handle types compatibility</a></li>
            <li>If {@code handleType} is #EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or #EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, the ##VkSemaphoreCreateInfo{@code ::flags} field <b>must</b> match that of the semaphore from which {@code handle} or {@code name} was exported</li>
            <li>If {@code handleType} is #EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or #EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, the ##VkSemaphoreTypeCreateInfo{@code ::semaphoreType} field <b>must</b> match that of the semaphore from which {@code handle} or {@code name} was exported</li>
            <li>If {@code flags} contains #SEMAPHORE_IMPORT_TEMPORARY_BIT, the ##VkSemaphoreTypeCreateInfo{@code ::semaphoreType} field of the semaphore from which {@code handle} or {@code name} was exported <b>must</b> not be #SEMAPHORE_TYPE_TIMELINE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code semaphore} <b>must</b> be a valid {@code VkSemaphore} handle</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkSemaphoreImportFlagBits} values</li>
        </ul>

        <h5>Host Synchronization</h5>
        <ul>
            <li>Host access to {@code semaphore} <b>must</b> be externally synchronized</li>
        </ul>

        <h5>See Also</h5>
        #ImportSemaphoreWin32HandleKHR()
        """

    Expression("#STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSemaphore("semaphore", "the semaphore into which the payload will be imported.")
    VkSemaphoreImportFlags("flags", "a bitmask of {@code VkSemaphoreImportFlagBits} specifying additional parameters for the semaphore payload import operation.")
    VkExternalSemaphoreHandleTypeFlagBits("handleType", "a {@code VkExternalSemaphoreHandleTypeFlagBits} value specifying the type of {@code handle}.")
    HANDLE("handle", "{@code NULL} or the external handle to import.")
    LPCWSTR("name", "{@code NULL} or a null-terminated UTF-16 string naming the underlying synchronization primitive to import.")
}

val VkExportSemaphoreWin32HandleInfoKHR = struct(Module.VULKAN, "VkExportSemaphoreWin32HandleInfoKHR") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        Structure specifying additional attributes of Windows handles exported from a semaphore.

        <h5>Description</h5>
        If ##VkExportSemaphoreCreateInfo is not included in the same {@code pNext} chain, this structure is ignored.

        If ##VkExportSemaphoreCreateInfo is included in the {@code pNext} chain of ##VkSemaphoreCreateInfo with a Windows {@code handleType}, but either ##VkExportSemaphoreWin32HandleInfoKHR is not included in the {@code pNext} chain, or it is included but {@code pAttributes} is {@code NULL}, default security descriptor values will be used, and child processes created by the application will not inherit the handle, as described in the MSDN documentation for “{@code Synchronization Object Security and Access Rights}”<sup>1</sup>. Further, if the structure is not present, the access rights used depend on the handle type.

        For handles of the following types:

        #EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT

        The implementation <b>must</b> ensure the access rights allow both signal and wait operations on the semaphore.

        For handles of the following types:

        #EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT

        The access rights <b>must</b> be:

        {@code GENERIC_ALL}

        <dl>
            <dt>1</dt>
            <dd><a href="https://docs.microsoft.com/en-us/windows/win32/sync/synchronization-object-security-and-access-rights">https://docs.microsoft.com/en-us/windows/win32/sync/synchronization-object-security-and-access-rights</a></dd>
        </dl>

        <h5>Valid Usage</h5>
        <ul>
            <li>If ##VkExportSemaphoreCreateInfo{@code ::handleTypes} does not include #EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or #EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, ##VkExportSemaphoreWin32HandleInfoKHR <b>must</b> not be included in the {@code pNext} chain of ##VkSemaphoreCreateInfo</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR</li>
            <li>If {@code pAttributes} is not {@code NULL}, {@code pAttributes} <b>must</b> be a valid pointer to a valid {@code SECURITY_ATTRIBUTES} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    nullable..SECURITY_ATTRIBUTES.const.p("pAttributes", "a pointer to a Windows {@code SECURITY_ATTRIBUTES} structure specifying security attributes of the handle.")
    DWORD("dwAccess", "a {@code DWORD} specifying access rights of the handle.")
    LPCWSTR("name", "a null-terminated UTF-16 string to associate with the underlying synchronization primitive referenced by NT handles exported from the created semaphore.")
}

val VkD3D12FenceSubmitInfoKHR = struct(Module.VULKAN, "VkD3D12FenceSubmitInfoKHR") {
    documentation =
        """
        Structure specifying values for Direct3D 12 fence-backed semaphores.

        <h5>Description</h5>
        If the semaphore in ##VkSubmitInfo{@code ::pWaitSemaphores} or ##VkSubmitInfo{@code ::pSignalSemaphores} corresponding to an entry in {@code pWaitSemaphoreValues} or {@code pSignalSemaphoreValues} respectively does not currently have a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphores-payloads">payload</a> referring to a Direct3D 12 fence, the implementation <b>must</b> ignore the value in the {@code pWaitSemaphoreValues} or {@code pSignalSemaphoreValues} entry.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        As the introduction of the external semaphore handle type #EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT predates that of timeline semaphores, support for importing semaphore payloads from external handles of that type into semaphores created (implicitly or explicitly) with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_BINARY is preserved for backwards compatibility. However, applications <b>should</b> prefer importing such handle types into semaphores created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_TIMELINE, and use the ##VkTimelineSemaphoreSubmitInfo structure instead of the ##VkD3D12FenceSubmitInfoKHR structure to specify the values to use when waiting for and signaling such semaphores.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code waitSemaphoreValuesCount} <b>must</b> be the same value as ##VkSubmitInfo{@code ::waitSemaphoreCount}, where this structure is in the {@code pNext} chain of a ##VkSubmitInfo structure</li>
            <li>{@code signalSemaphoreValuesCount} <b>must</b> be the same value as ##VkSubmitInfo{@code ::signalSemaphoreCount}, where this structure is in the {@code pNext} chain of a ##VkSubmitInfo structure</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR</li>
            <li>If {@code waitSemaphoreValuesCount} is not 0, and {@code pWaitSemaphoreValues} is not {@code NULL}, {@code pWaitSemaphoreValues} <b>must</b> be a valid pointer to an array of {@code waitSemaphoreValuesCount} {@code uint64_t} values</li>
            <li>If {@code signalSemaphoreValuesCount} is not 0, and {@code pSignalSemaphoreValues} is not {@code NULL}, {@code pSignalSemaphoreValues} <b>must</b> be a valid pointer to an array of {@code signalSemaphoreValuesCount} {@code uint64_t} values</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pWaitSemaphoreValues", optional = true)..uint32_t("waitSemaphoreValuesCount", "the number of semaphore wait values specified in {@code pWaitSemaphoreValues}.")
    nullable..uint64_t.const.p("pWaitSemaphoreValues", "a pointer to an array of {@code waitSemaphoreValuesCount} values for the corresponding semaphores in ##VkSubmitInfo{@code ::pWaitSemaphores} to wait for.")
    AutoSize("pSignalSemaphoreValues", optional = true)..uint32_t("signalSemaphoreValuesCount", "the number of semaphore signal values specified in {@code pSignalSemaphoreValues}.")
    nullable..uint64_t.const.p("pSignalSemaphoreValues", "a pointer to an array of {@code signalSemaphoreValuesCount} values for the corresponding semaphores in ##VkSubmitInfo{@code ::pSignalSemaphores} to set when signaled.")
}

val VkSemaphoreGetWin32HandleInfoKHR = struct(Module.VULKAN, "VkSemaphoreGetWin32HandleInfoKHR") {
    documentation =
        """
        Structure describing a Win32 handle semaphore export operation.

        <h5>Description</h5>
        The properties of the handle returned depend on the value of {@code handleType}. See {@code VkExternalSemaphoreHandleTypeFlagBits} for a description of the properties of the defined external semaphore handle types.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> have been included in ##VkExportSemaphoreCreateInfo{@code ::handleTypes} when the {@code semaphore}’s current payload was created</li>
            <li>If {@code handleType} is defined as an NT handle, #GetSemaphoreWin32HandleKHR() <b>must</b> be called no more than once for each valid unique combination of {@code semaphore} and {@code handleType}</li>
            <li>{@code semaphore} <b>must</b> not currently have its payload replaced by an imported payload as described below in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphores-importing">Importing Semaphore Payloads</a> unless that imported payload’s handle type was included in ##VkExternalSemaphoreProperties{@code ::exportFromImportedHandleTypes} for {@code handleType}</li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, as defined below in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphores-importing">Importing Semaphore Payloads</a>, there <b>must</b> be no queue waiting on {@code semaphore}</li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, {@code semaphore} <b>must</b> be signaled, or have an associated <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphores-signaling">semaphore signal operation</a> pending execution</li>
            <li>{@code handleType} <b>must</b> be defined as an NT handle or a global share handle</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code semaphore} <b>must</b> be a valid {@code VkSemaphore} handle</li>
            <li>{@code handleType} <b>must</b> be a valid {@code VkExternalSemaphoreHandleTypeFlagBits} value</li>
        </ul>

        <h5>See Also</h5>
        #GetSemaphoreWin32HandleKHR()
        """

    Expression("#STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSemaphore("semaphore", "the semaphore from which state will be exported.")
    VkExternalSemaphoreHandleTypeFlagBits("handleType", "a {@code VkExternalSemaphoreHandleTypeFlagBits} value specifying the type of handle requested.")
}

val VkImportSemaphoreFdInfoKHR = struct(Module.VULKAN, "VkImportSemaphoreFdInfoKHR") {
    documentation =
        """
        Structure specifying POSIX file descriptor to import to a semaphore.

        <h5>Description</h5>
        The handle types supported by {@code handleType} are:

        <h6>Handle Types Supported by ##VkImportSemaphoreFdInfoKHR</h6>
        <table class="lwjgl">
            <thead><tr><th>Handle Type</th><th>Transference</th><th>Permanence Supported</th></tr></thead>
            <tbody>
                <tr><td>#EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT</td><td>Reference</td><td>Temporary,Permanent</td></tr>
                <tr><td>#EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT</td><td>Copy</td><td>Temporary</td></tr>
            </tbody>
        </table>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> be a value included in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphore-handletypes-fd">Handle Types Supported by ##VkImportSemaphoreFdInfoKHR</a> table</li>
            <li>{@code fd} <b>must</b> obey any requirements listed for {@code handleType} in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-semaphore-handle-types-compatibility">external semaphore handle types compatibility</a></li>
            <li>If {@code handleType} is #EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT, the ##VkSemaphoreCreateInfo{@code ::flags} field <b>must</b> match that of the semaphore from which {@code fd} was exported</li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, {@code flags} <b>must</b> contain #SEMAPHORE_IMPORT_TEMPORARY_BIT</li>
            <li>If {@code handleType} is #EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT, the ##VkSemaphoreTypeCreateInfo{@code ::semaphoreType} field <b>must</b> match that of the semaphore from which {@code fd} was exported</li>
            <li>If {@code flags} contains #SEMAPHORE_IMPORT_TEMPORARY_BIT, the ##VkSemaphoreTypeCreateInfo{@code ::semaphoreType} field of the semaphore from which {@code fd} was exported <b>must</b> not be #SEMAPHORE_TYPE_TIMELINE</li>
        </ul>

        If {@code handleType} is #EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT, the special value {@code -1} for {@code fd} is treated like a valid sync file descriptor referring to an object that has already signaled. The import operation will succeed and the {@code VkSemaphore} will have a temporarily imported payload as if a valid file descriptor had been provided.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        This special behavior for importing an invalid sync file descriptor allows easier interoperability with other system APIs which use the convention that an invalid sync file descriptor represents work that has already completed and does not need to be waited for. It is consistent with the option for implementations to return a {@code -1} file descriptor when exporting a #EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT from a {@code VkSemaphore} which is signaled.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code semaphore} <b>must</b> be a valid {@code VkSemaphore} handle</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkSemaphoreImportFlagBits} values</li>
            <li>{@code handleType} <b>must</b> be a valid {@code VkExternalSemaphoreHandleTypeFlagBits} value</li>
        </ul>

        <h5>Host Synchronization</h5>
        <ul>
            <li>Host access to {@code semaphore} <b>must</b> be externally synchronized</li>
        </ul>

        <h5>See Also</h5>
        #ImportSemaphoreFdKHR()
        """

    Expression("#STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSemaphore("semaphore", "the semaphore into which the payload will be imported.")
    VkSemaphoreImportFlags("flags", "a bitmask of {@code VkSemaphoreImportFlagBits} specifying additional parameters for the semaphore payload import operation.")
    VkExternalSemaphoreHandleTypeFlagBits("handleType", "a {@code VkExternalSemaphoreHandleTypeFlagBits} value specifying the type of {@code fd}.")
    int("fd", "the external handle to import.")
}

val VkSemaphoreGetFdInfoKHR = struct(Module.VULKAN, "VkSemaphoreGetFdInfoKHR") {
    documentation =
        """
        Structure describing a POSIX FD semaphore export operation.

        <h5>Description</h5>
        The properties of the file descriptor returned depend on the value of {@code handleType}. See {@code VkExternalSemaphoreHandleTypeFlagBits} for a description of the properties of the defined external semaphore handle types.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> have been included in ##VkExportSemaphoreCreateInfo{@code ::handleTypes} when {@code semaphore}’s current payload was created</li>
            <li>{@code semaphore} <b>must</b> not currently have its payload replaced by an imported payload as described below in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphores-importing">Importing Semaphore Payloads</a> unless that imported payload’s handle type was included in ##VkExternalSemaphoreProperties{@code ::exportFromImportedHandleTypes} for {@code handleType}</li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, as defined below in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphores-importing">Importing Semaphore Payloads</a>, there <b>must</b> be no queue waiting on {@code semaphore}</li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, {@code semaphore} <b>must</b> be signaled, or have an associated <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-semaphores-signaling">semaphore signal operation</a> pending execution</li>
            <li>{@code handleType} <b>must</b> be defined as a POSIX file descriptor handle</li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, {@code semaphore} <b>must</b> have been created with a {@code VkSemaphoreType} of #SEMAPHORE_TYPE_BINARY</li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, {@code semaphore} <b>must</b> have an associated semaphore signal operation that has been submitted for execution and any semaphore signal operations on which it depends <b>must</b> have also been submitted for execution</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code semaphore} <b>must</b> be a valid {@code VkSemaphore} handle</li>
            <li>{@code handleType} <b>must</b> be a valid {@code VkExternalSemaphoreHandleTypeFlagBits} value</li>
        </ul>

        <h5>See Also</h5>
        #GetSemaphoreFdKHR()
        """

    Expression("#STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSemaphore("semaphore", "the semaphore from which state will be exported.")
    VkExternalSemaphoreHandleTypeFlagBits("handleType", "a {@code VkExternalSemaphoreHandleTypeFlagBits} value specifying the type of handle requested.")
}

val VkPhysicalDevicePushDescriptorPropertiesKHR = struct(Module.VULKAN, "VkPhysicalDevicePushDescriptorPropertiesKHR", mutable = false, alias = VkPhysicalDevicePushDescriptorProperties) {
    documentation = "See ##VkPhysicalDevicePushDescriptorProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint32_t("maxPushDescriptors", "")
}

val VkConditionalRenderingBeginInfoEXT = struct(Module.VULKAN, "VkConditionalRenderingBeginInfoEXT") {
    documentation =
        """
        Structure specifying conditional rendering begin information.

        <h5>Description</h5>
        If the 32-bit value at {@code offset} in {@code buffer} memory is zero, then the rendering commands are discarded, otherwise they are executed as normal. If the value of the predicate in buffer memory changes while conditional rendering is active, the rendering commands <b>may</b> be discarded in an implementation-dependent way. Some implementations may latch the value of the predicate upon beginning conditional rendering while others may read it before every rendering command.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code buffer} is non-sparse then it <b>must</b> be bound completely and contiguously to a single {@code VkDeviceMemory} object</li>
            <li>{@code buffer} <b>must</b> have been created with the #BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT bit set</li>
            <li>{@code offset} <b>must</b> be less than the size of {@code buffer} by at least 32 bits</li>
            <li>{@code offset} <b>must</b> be a multiple of 4</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkConditionalRenderingFlagBitsEXT} values</li>
        </ul>

        <h5>See Also</h5>
        #CmdBeginConditionalRenderingEXT()
        """

    Expression("#STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBuffer("buffer", "a buffer containing the predicate for conditional rendering.")
    VkDeviceSize("offset", "the byte offset into {@code buffer} where the predicate is located.")
    VkConditionalRenderingFlagsEXT("flags", "a bitmask of {@code VkConditionalRenderingFlagsEXT} specifying the behavior of conditional rendering.")
}

val VkPhysicalDeviceConditionalRenderingFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceConditionalRenderingFeaturesEXT") {
    documentation =
        """
        Structure describing if a secondary command buffer can be executed if conditional rendering is active in the primary command buffer.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceConditionalRenderingFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceConditionalRenderingFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("conditionalRendering", "specifies whether conditional rendering is supported.")
    VkBool32("inheritedConditionalRendering", "specifies whether a secondary command buffer <b>can</b> be executed while conditional rendering is active in the primary command buffer.")
}

val VkCommandBufferInheritanceConditionalRenderingInfoEXT = struct(Module.VULKAN, "VkCommandBufferInheritanceConditionalRenderingInfoEXT") {
    documentation =
        """
        Structure specifying command buffer inheritance information.

        <h5>Description</h5>
        If this structure is not present, the behavior is as if {@code conditionalRenderingEnable} is #FALSE.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-inheritedConditionalRendering">{@code inheritedConditionalRendering}</a> feature is not enabled, {@code conditionalRenderingEnable} <b>must</b> be #FALSE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("conditionalRenderingEnable", "specifies whether the command buffer <b>can</b> be executed while conditional rendering is active in the primary command buffer. If this is #TRUE, then this command buffer <b>can</b> be executed whether the primary command buffer has active conditional rendering or not. If this is #FALSE, then the primary command buffer <b>must</b> not have conditional rendering active.")
}

val VkPhysicalDeviceShaderFloat16Int8FeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceShaderFloat16Int8FeaturesKHR", alias = VkPhysicalDeviceShaderFloat16Int8Features) {
    documentation = "See ##VkPhysicalDeviceShaderFloat16Int8Features."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("shaderFloat16", "")
    VkBool32("shaderInt8", "")
}

val VkPhysicalDeviceFloat16Int8FeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceFloat16Int8FeaturesKHR", alias = VkPhysicalDeviceShaderFloat16Int8Features) {
    documentation = "See ##VkPhysicalDeviceShaderFloat16Int8Features."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("shaderFloat16", "")
    VkBool32("shaderInt8", "")
}

val VkPhysicalDevice16BitStorageFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDevice16BitStorageFeaturesKHR", alias = VkPhysicalDevice16BitStorageFeatures) {
    documentation = "See ##VkPhysicalDevice16BitStorageFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("storageBuffer16BitAccess", "")
    VkBool32("uniformAndStorageBuffer16BitAccess", "")
    VkBool32("storagePushConstant16", "")
    VkBool32("storageInputOutput16", "")
}

val VkRectLayerKHR = struct(Module.VULKAN, "VkRectLayerKHR") {
    documentation =
        """
        Structure containing a rectangle, including layer, changed by vkQueuePresentKHR for a given VkImage.

        <h5>Description</h5>
        Some platforms allow the size of a surface to change, and then scale the pixels of the image to fit the surface. ##VkRectLayerKHR specifies pixels of the swapchain’s image(s), which will be constant for the life of the swapchain.

        <h5>Valid Usage</h5>
        <ul>
            <li>The sum of {@code offset} and {@code extent}, after being transformed according to the {@code preTransform} member of the ##VkSwapchainCreateInfoKHR structure, <b>must</b> be no greater than the {@code imageExtent} member of the ##VkSwapchainCreateInfoKHR structure passed to #CreateSwapchainKHR()</li>
            <li>{@code layer} <b>must</b> be less than the {@code imageArrayLayers} member of the ##VkSwapchainCreateInfoKHR structure passed to #CreateSwapchainKHR()</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D, ##VkOffset2D, ##VkPresentRegionKHR
        """

    VkOffset2D("offset", "the origin of the rectangle, in pixels.")
    VkExtent2D("extent", "the size of the rectangle, in pixels.")
    uint32_t("layer", "the layer of the image. For images with only one layer, the value of {@code layer} <b>must</b> be 0.")
}

val VkPresentRegionKHR = struct(Module.VULKAN, "VkPresentRegionKHR") {
    documentation =
        """
        Structure containing rectangular region changed by vkQueuePresentKHR for a given VkImage.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>If {@code rectangleCount} is not 0, and {@code pRectangles} is not {@code NULL}, {@code pRectangles} <b>must</b> be a valid pointer to an array of {@code rectangleCount} valid ##VkRectLayerKHR structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkPresentRegionsKHR, ##VkRectLayerKHR
        """

    AutoSize("pRectangles", optional = true)..uint32_t("rectangleCount", "the number of rectangles in {@code pRectangles}, or zero if the entire image has changed and should be presented.")
    nullable..VkRectLayerKHR.const.p("pRectangles", "either {@code NULL} or a pointer to an array of ##VkRectLayerKHR structures. The ##VkRectLayerKHR structure is the framebuffer coordinates, plus layer, of a portion of a presentable image that has changed and <b>must</b> be presented. If non-{@code NULL}, each entry in {@code pRectangles} is a rectangle of the given image that has changed since the last image was presented to the given swapchain. The rectangles <b>must</b> be specified relative to ##VkSurfaceCapabilitiesKHR{@code ::currentTransform}, regardless of the swapchain’s {@code preTransform}. The presentation engine will apply the {@code preTransform} transformation to the rectangles, along with any further transformation it applies to the image content.")
}

val VkPresentRegionsKHR = struct(Module.VULKAN, "VkPresentRegionsKHR") {
    documentation =
        """
        Structure hint of rectangular regions changed by vkQueuePresentKHR.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code swapchainCount} <b>must</b> be the same value as ##VkPresentInfoKHR{@code ::swapchainCount}, where ##VkPresentInfoKHR is included in the {@code pNext} chain of this ##VkPresentRegionsKHR structure</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PRESENT_REGIONS_KHR</li>
            <li>If {@code pRegions} is not {@code NULL}, {@code pRegions} <b>must</b> be a valid pointer to an array of {@code swapchainCount} valid ##VkPresentRegionKHR structures</li>
            <li>{@code swapchainCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkPresentRegionKHR
        """

    Expression("#STRUCTURE_TYPE_PRESENT_REGIONS_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pRegions", optional = true)..uint32_t("swapchainCount", "the number of swapchains being presented to by this command.")
    nullable..VkPresentRegionKHR.const.p("pRegions", "{@code NULL} or a pointer to an array of ##VkPresentRegionKHR elements with {@code swapchainCount} entries. If not {@code NULL}, each element of {@code pRegions} contains the region that has changed since the last present to the swapchain in the corresponding entry in the ##VkPresentInfoKHR{@code ::pSwapchains} array.")
}

val VkDescriptorUpdateTemplateEntryKHR = struct(Module.VULKAN, "VkDescriptorUpdateTemplateEntryKHR", alias = VkDescriptorUpdateTemplateEntry) {
    documentation = "See ##VkDescriptorUpdateTemplateEntry."

    uint32_t("dstBinding", "")
    uint32_t("dstArrayElement", "")
    uint32_t("descriptorCount", "")
    VkDescriptorType("descriptorType", "")
    size_t("offset", "")
    size_t("stride", "")
}

val VkDescriptorUpdateTemplateCreateInfoKHR = struct(Module.VULKAN, "VkDescriptorUpdateTemplateCreateInfoKHR", alias = VkDescriptorUpdateTemplateCreateInfo) {
    documentation = "See ##VkDescriptorUpdateTemplateCreateInfo."

    Expression("#STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkDescriptorUpdateTemplateCreateFlags("flags", "")
    AutoSize("pDescriptorUpdateEntries")..uint32_t("descriptorUpdateEntryCount", "")
    VkDescriptorUpdateTemplateEntry.const.p("pDescriptorUpdateEntries", "")
    VkDescriptorUpdateTemplateType("templateType", "")
    VkDescriptorSetLayout("descriptorSetLayout", "")
    VkPipelineBindPoint("pipelineBindPoint", "")
    VkPipelineLayout("pipelineLayout", "")
    uint32_t("set", "")
}

val VkViewportWScalingNV = struct(Module.VULKAN, "VkViewportWScalingNV") {
    documentation =
        """
        Structure specifying a viewport.

        <h5>See Also</h5>
        ##VkPipelineViewportWScalingStateCreateInfoNV, #CmdSetViewportWScalingNV()
        """

    float("xcoeff", "{@code xcoeff} and {@code ycoeff} are the viewport’s W scaling factor for x and y respectively.")
    float("ycoeff", "see {@code xcoeff}")
}

val VkPipelineViewportWScalingStateCreateInfoNV = struct(Module.VULKAN, "VkPipelineViewportWScalingStateCreateInfoNV") {
    documentation =
        """
        Structure specifying parameters of a newly created pipeline viewport W scaling state.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV</li>
            <li>{@code viewportCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkViewportWScalingNV
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("viewportWScalingEnable", "controls whether viewport <b>W</b> scaling is enabled.")
    AutoSize("pViewportWScalings", optional = true)..uint32_t("viewportCount", "the number of viewports used by <b>W</b> scaling, and <b>must</b> match the number of viewports in the pipeline if viewport <b>W</b> scaling is enabled.")
    nullable..VkViewportWScalingNV.const.p("pViewportWScalings", "a pointer to an array of ##VkViewportWScalingNV structures defining the <b>W</b> scaling parameters for the corresponding viewports. If the viewport <b>W</b> scaling state is dynamic, this member is ignored.")
}

val VkSurfaceCapabilities2EXT = struct(Module.VULKAN, "VkSurfaceCapabilities2EXT", mutable = false) {
    documentation =
        """
        Structure describing capabilities of a surface.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code supportedSurfaceCounters} <b>must</b> not include #SURFACE_COUNTER_VBLANK_BIT_EXT unless the surface queried is a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#wsi-display-surfaces">display surface</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D, #GetPhysicalDeviceSurfaceCapabilities2EXT()
        """

    Expression("#STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("minImageCount", "the minimum number of images the specified device supports for a swapchain created for the surface, and will be at least one.")
    uint32_t("maxImageCount", "the maximum number of images the specified device supports for a swapchain created for the surface, and will be either 0, or greater than or equal to {@code minImageCount}. A value of 0 means that there is no limit on the number of images, though there <b>may</b> be limits related to the total amount of memory used by presentable images.")
    VkExtent2D("currentExtent", "the current width and height of the surface, or the special value <code>(0xFFFFFFFF, 0xFFFFFFFF)</code> indicating that the surface size will be determined by the extent of a swapchain targeting the surface.")
    VkExtent2D("minImageExtent", "contains the smallest valid swapchain extent for the surface on the specified device. The {@code width} and {@code height} of the extent will each be less than or equal to the corresponding {@code width} and {@code height} of {@code currentExtent}, unless {@code currentExtent} has the special value described above.")
    VkExtent2D("maxImageExtent", "contains the largest valid swapchain extent for the surface on the specified device. The {@code width} and {@code height} of the extent will each be greater than or equal to the corresponding {@code width} and {@code height} of {@code minImageExtent}. The {@code width} and {@code height} of the extent will each be greater than or equal to the corresponding {@code width} and {@code height} of {@code currentExtent}, unless {@code currentExtent} has the special value described above.")
    uint32_t("maxImageArrayLayers", "the maximum number of layers presentable images <b>can</b> have for a swapchain created for this device and surface, and will be at least one.")
    VkSurfaceTransformFlagsKHR("supportedTransforms", "a bitmask of {@code VkSurfaceTransformFlagBitsKHR} indicating the presentation transforms supported for the surface on the specified device. At least one bit will be set.")
    VkSurfaceTransformFlagBitsKHR("currentTransform", "{@code VkSurfaceTransformFlagBitsKHR} value indicating the surface’s current transform relative to the presentation engine’s natural orientation.")
    VkCompositeAlphaFlagsKHR("supportedCompositeAlpha", "a bitmask of {@code VkCompositeAlphaFlagBitsKHR}, representing the alpha compositing modes supported by the presentation engine for the surface on the specified device, and at least one bit will be set. Opaque composition <b>can</b> be achieved in any alpha compositing mode by either using an image format that has no alpha component, or by ensuring that all pixels in the presentable images have an alpha value of 1.0.")
    VkImageUsageFlags("supportedUsageFlags", "a bitmask of {@code VkImageUsageFlagBits} representing the ways the application <b>can</b> use the presentable images of a swapchain created with {@code VkPresentModeKHR} set to #PRESENT_MODE_FIFO_LATEST_READY_EXT, #PRESENT_MODE_IMMEDIATE_KHR, #PRESENT_MODE_MAILBOX_KHR, #PRESENT_MODE_FIFO_KHR or #PRESENT_MODE_FIFO_RELAXED_KHR for the surface on the specified device. #IMAGE_USAGE_COLOR_ATTACHMENT_BIT <b>must</b> be included in the set. Implementations <b>may</b> support additional usages.")
    VkSurfaceCounterFlagsEXT("supportedSurfaceCounters", "a bitmask of {@code VkSurfaceCounterFlagBitsEXT} indicating the supported surface counter types.")
}

val VkDisplayPowerInfoEXT = struct(Module.VULKAN, "VkDisplayPowerInfoEXT") {
    documentation =
        """
        Describe the power state of a display.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code powerState} <b>must</b> be a valid {@code VkDisplayPowerStateEXT} value</li>
        </ul>

        <h5>See Also</h5>
        #DisplayPowerControlEXT()
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDisplayPowerStateEXT("powerState", "a {@code VkDisplayPowerStateEXT} value specifying the new power state of the display.")
}

val VkDeviceEventInfoEXT = struct(Module.VULKAN, "VkDeviceEventInfoEXT") {
    documentation =
        """
        Describe a device event to create.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code deviceEvent} <b>must</b> be a valid {@code VkDeviceEventTypeEXT} value</li>
        </ul>

        <h5>See Also</h5>
        #RegisterDeviceEventEXT()
        """

    Expression("#STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceEventTypeEXT("deviceEvent", "")
}

val VkDisplayEventInfoEXT = struct(Module.VULKAN, "VkDisplayEventInfoEXT") {
    documentation =
        """
        Describe a display event to create.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code displayEvent} <b>must</b> be a valid {@code VkDisplayEventTypeEXT} value</li>
        </ul>

        <h5>See Also</h5>
        #RegisterDisplayEventEXT()
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDisplayEventTypeEXT("displayEvent", "a {@code VkDisplayEventTypeEXT} specifying when the fence will be signaled.")
}

val VkSwapchainCounterCreateInfoEXT = struct(Module.VULKAN, "VkSwapchainCounterCreateInfoEXT") {
    documentation =
        """
        Specify the surface counters desired.

        <h5>Valid Usage</h5>
        <ul>
            <li>The bits in {@code surfaceCounters} <b>must</b> be supported by ##VkSwapchainCreateInfoKHR{@code ::surface}, as reported by #GetPhysicalDeviceSurfaceCapabilities2EXT()</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT</li>
            <li>{@code surfaceCounters} <b>must</b> be a valid combination of {@code VkSurfaceCounterFlagBitsEXT} values</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSurfaceCounterFlagsEXT("surfaceCounters", "a bitmask of {@code VkSurfaceCounterFlagBitsEXT} specifying surface counters to enable for the swapchain.")
}

val VkRefreshCycleDurationGOOGLE = struct(Module.VULKAN, "VkRefreshCycleDurationGOOGLE", mutable = false) {
    documentation =
        """
        Structure containing the RC duration of a display.

        <h5>See Also</h5>
        #GetRefreshCycleDurationGOOGLE()
        """

    uint64_t("refreshDuration", "the number of nanoseconds from the start of one refresh cycle to the next.")
}

val VkPastPresentationTimingGOOGLE = struct(Module.VULKAN, "VkPastPresentationTimingGOOGLE", mutable = false) {
    documentation =
        """
        Structure containing timing information about a previously-presented image.

        <h5>Description</h5>
        The results for a given {@code swapchain} and {@code presentID} are only returned once from {@code vkGetPastPresentationTimingGOOGLE}.

        The application <b>can</b> use the ##VkPastPresentationTimingGOOGLE values to occasionally adjust its timing. For example, if {@code actualPresentTime} is later than expected (e.g. one {@code refreshDuration} late), the application may increase its target IPD to a higher multiple of {@code refreshDuration} (e.g. decrease its frame rate from 60Hz to 30Hz). If {@code actualPresentTime} and {@code earliestPresentTime} are consistently different, and if {@code presentMargin} is consistently large enough, the application may decrease its target IPD to a smaller multiple of {@code refreshDuration} (e.g. increase its frame rate from 30Hz to 60Hz). If {@code actualPresentTime} and {@code earliestPresentTime} are same, and if {@code presentMargin} is consistently high, the application may delay the start of its input-render-present loop in order to decrease the latency between user input and the corresponding present (always leaving some margin in case a new image takes longer to render than the previous image). An application that desires its target IPD to always be the same as {@code refreshDuration}, can also adjust features until {@code actualPresentTime} is never late and {@code presentMargin} is satisfactory.

        <h5>See Also</h5>
        #GetPastPresentationTimingGOOGLE()
        """

    uint32_t("presentID", "an application-provided value that was given to a previous {@code vkQueuePresentKHR} command via ##VkPresentTimeGOOGLE{@code ::presentID} (see below). It <b>can</b> be used to uniquely identify a previous present with the #QueuePresentKHR() command.")
    uint64_t("desiredPresentTime", "an application-provided value that was given to a previous #QueuePresentKHR() command via ##VkPresentTimeGOOGLE{@code ::desiredPresentTime}. If non-zero, it was used by the application to indicate that an image not be presented any sooner than {@code desiredPresentTime}.")
    uint64_t("actualPresentTime", "the time when the image of the {@code swapchain} was actually displayed.")
    uint64_t("earliestPresentTime", "the time when the image of the {@code swapchain} could have been displayed. This <b>may</b> differ from {@code actualPresentTime} if the application requested that the image be presented no sooner than ##VkPresentTimeGOOGLE{@code ::desiredPresentTime}.")
    uint64_t("presentMargin", "an indication of how early the {@code vkQueuePresentKHR} command was processed compared to how soon it needed to be processed, and still be presented at {@code earliestPresentTime}.")
}

val VkPresentTimeGOOGLE = struct(Module.VULKAN, "VkPresentTimeGOOGLE") {
    documentation =
        """
        The earliest time image should be presented.

        <h5>See Also</h5>
        ##VkPresentTimesInfoGOOGLE
        """

    uint32_t("presentID", "an application-provided identification value, that <b>can</b> be used with the results of #GetPastPresentationTimingGOOGLE(), in order to uniquely identify this present. In order to be useful to the application, it <b>should</b> be unique within some period of time that is meaningful to the application.")
    uint64_t("desiredPresentTime", "specifies that the image given <b>should</b> not be displayed to the user any earlier than this time. {@code desiredPresentTime} is a time in nanoseconds, relative to a monotonically-increasing clock (e.g. {@code CLOCK_MONOTONIC} (see clock_gettime(2)) on Android and Linux). A value of zero specifies that the presentation engine <b>may</b> display the image at any time. This is useful when the application desires to provide {@code presentID}, but does not need a specific {@code desiredPresentTime}.")
}

val VkPresentTimesInfoGOOGLE = struct(Module.VULKAN, "VkPresentTimesInfoGOOGLE") {
    documentation =
        """
        The earliest time each image should be presented.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code swapchainCount} <b>must</b> be the same value as ##VkPresentInfoKHR{@code ::swapchainCount}, where ##VkPresentInfoKHR is included in the {@code pNext} chain of this ##VkPresentTimesInfoGOOGLE structure</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE</li>
            <li>If {@code pTimes} is not {@code NULL}, {@code pTimes} <b>must</b> be a valid pointer to an array of {@code swapchainCount} ##VkPresentTimeGOOGLE structures</li>
            <li>{@code swapchainCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkPresentTimeGOOGLE
        """

    Expression("#STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pTimes", optional = true)..uint32_t("swapchainCount", "the number of swapchains being presented to by this command.")
    nullable..VkPresentTimeGOOGLE.const.p("pTimes", "{@code NULL} or a pointer to an array of ##VkPresentTimeGOOGLE elements with {@code swapchainCount} entries. If not {@code NULL}, each element of {@code pTimes} contains the earliest time to present the image corresponding to the entry in the ##VkPresentInfoKHR{@code ::pImageIndices} array.")
}

val VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX = struct(Module.VULKAN, "VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX", mutable = false) {
    documentation =
        """
        Structure describing multiview limits that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkBool32("perViewPositionAllComponents", "#TRUE if the implementation supports per-view position values that differ in components other than the X component.")
}

val VkMultiviewPerViewAttributesInfoNVX = struct(Module.VULKAN, "VkMultiviewPerViewAttributesInfoNVX") {
    documentation =
        """
        Structure specifying the multiview per-attribute properties.

        <h5>Description</h5>
        When dynamic render pass instances are being used, instead of specifying #SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX or #SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX in the subpass description flags, the per-attribute properties of the render pass instance <b>must</b> be specified by the ##VkMultiviewPerViewAttributesInfoNVX structure Include the ##VkMultiviewPerViewAttributesInfoNVX structure in the {@code pNext} chain of ##VkGraphicsPipelineCreateInfo when creating a graphics pipeline for dynamic rendering, ##VkRenderingInfo when starting a dynamic render pass instance, and ##VkCommandBufferInheritanceInfo when specifying the dynamic render pass instance parameters for secondary command buffers.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("perViewAttributes", "specifies that shaders compiled for this pipeline write the attributes for all views in a single invocation of each vertex processing stage. All pipelines executed within a render pass instance that includes this bit <b>must</b> write per-view attributes to the {@code *PerViewNV[]} shader outputs, in addition to the non-per-view (e.g. {@code Position}) outputs.")
    VkBool32("perViewAttributesPositionXOnly", "specifies that shaders compiled for this pipeline use per-view positions which only differ in value in the x component. Per-view viewport mask <b>can</b> also be used.")
}

val VkViewportSwizzleNV = struct(Module.VULKAN, "VkViewportSwizzleNV") {
    documentation =
        """
        Structure specifying a viewport swizzle.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code x} <b>must</b> be a valid {@code VkViewportCoordinateSwizzleNV} value</li>
            <li>{@code y} <b>must</b> be a valid {@code VkViewportCoordinateSwizzleNV} value</li>
            <li>{@code z} <b>must</b> be a valid {@code VkViewportCoordinateSwizzleNV} value</li>
            <li>{@code w} <b>must</b> be a valid {@code VkViewportCoordinateSwizzleNV} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineViewportSwizzleStateCreateInfoNV, #CmdSetViewportSwizzleNV()
        """

    VkViewportCoordinateSwizzleNV("x", "a {@code VkViewportCoordinateSwizzleNV} value specifying the swizzle operation to apply to the x component of the primitive")
    VkViewportCoordinateSwizzleNV("y", "a {@code VkViewportCoordinateSwizzleNV} value specifying the swizzle operation to apply to the y component of the primitive")
    VkViewportCoordinateSwizzleNV("z", "a {@code VkViewportCoordinateSwizzleNV} value specifying the swizzle operation to apply to the z component of the primitive")
    VkViewportCoordinateSwizzleNV("w", "a {@code VkViewportCoordinateSwizzleNV} value specifying the swizzle operation to apply to the w component of the primitive")
}

val VkPipelineViewportSwizzleStateCreateInfoNV = struct(Module.VULKAN, "VkPipelineViewportSwizzleStateCreateInfoNV") {
    documentation =
        """
        Structure specifying swizzle applied to primitive clip coordinates.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code viewportCount} <b>must</b> be greater than or equal to the {@code viewportCount} set in ##VkPipelineViewportStateCreateInfo</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code pViewportSwizzles} <b>must</b> be a valid pointer to an array of {@code viewportCount} valid ##VkViewportSwizzleNV structures</li>
            <li>{@code viewportCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkViewportSwizzleNV
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineViewportSwizzleStateCreateFlagsNV("flags", "reserved for future use.")
    AutoSize("pViewportSwizzles")..uint32_t("viewportCount", "the number of viewport swizzles used by the pipeline.")
    VkViewportSwizzleNV.const.p("pViewportSwizzles", "a pointer to an array of ##VkViewportSwizzleNV structures, defining the viewport swizzles.")
}

val VkPhysicalDeviceDiscardRectanglePropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceDiscardRectanglePropertiesEXT", mutable = false) {
    documentation =
        """
        Structure describing discard rectangle limits that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceDiscardRectanglePropertiesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("maxDiscardRectangles", "the maximum number of active discard rectangles that <b>can</b> be specified.")
}

val VkPipelineDiscardRectangleStateCreateInfoEXT = struct(Module.VULKAN, "VkPipelineDiscardRectangleStateCreateInfoEXT") {
    documentation =
        """
        Structure specifying discard rectangle.

        <h5>Description</h5>
        If the #DYNAMIC_STATE_DISCARD_RECTANGLE_EXT dynamic state is enabled for a pipeline, the {@code pDiscardRectangles} member is ignored. If the #DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT dynamic state is not enabled for the pipeline the presence of this structure in the ##VkGraphicsPipelineCreateInfo chain, and a {@code discardRectangleCount} greater than zero, implicitly enables discard rectangles in the pipeline, otherwise discard rectangles <b>must</b> enabled or disabled by #CmdSetDiscardRectangleEnableEXT(). If the #DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT dynamic state is enabled for the pipeline, the {@code discardRectangleMode} member is ignored, and the discard rectangle mode <b>must</b> be set by #CmdSetDiscardRectangleModeEXT().

        When this structure is included in the {@code pNext} chain of ##VkGraphicsPipelineCreateInfo, it defines parameters of the discard rectangle test. If the #DYNAMIC_STATE_DISCARD_RECTANGLE_EXT dynamic state is not enabled, and this structure is not included in the {@code pNext} chain, it is equivalent to specifying this structure with a {@code discardRectangleCount} of 0.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code discardRectangleCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceDiscardRectanglePropertiesEXT{@code ::maxDiscardRectangles}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code discardRectangleMode} <b>must</b> be a valid {@code VkDiscardRectangleModeEXT} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkRect2D
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineDiscardRectangleStateCreateFlagsEXT("flags", "reserved for future use.")
    VkDiscardRectangleModeEXT("discardRectangleMode", "a {@code VkDiscardRectangleModeEXT} value determining whether the discard rectangle test is inclusive or exclusive.")
    AutoSize("pDiscardRectangles", optional = true)..uint32_t("discardRectangleCount", "the number of discard rectangles to use.")
    nullable..VkRect2D.const.p("pDiscardRectangles", "a pointer to an array of ##VkRect2D structures defining discard rectangles.")
}

val VkPhysicalDeviceConservativeRasterizationPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceConservativeRasterizationPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure describing conservative raster properties that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceConservativeRasterizationPropertiesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    float("primitiveOverestimationSize", "the size in pixels the generating primitive is increased at each of its edges during conservative rasterization overestimation mode. Even with a size of 0.0, conservative rasterization overestimation rules still apply and if any part of the pixel rectangle is covered by the generating primitive, fragments are generated for the entire pixel. However implementations <b>may</b> make the pixel coverage area even more conservative by increasing the size of the generating primitive.")
    float("maxExtraPrimitiveOverestimationSize", "the maximum size in pixels of extra overestimation the implementation supports in the pipeline state. A value of 0.0 means the implementation does not support any additional overestimation of the generating primitive during conservative rasterization. A value above 0.0 allows the application to further increase the size of the generating primitive during conservative rasterization overestimation.")
    float("extraPrimitiveOverestimationSizeGranularity", "the granularity of extra overestimation that can be specified in the pipeline state between 0.0 and {@code maxExtraPrimitiveOverestimationSize} inclusive. A value of 0.0 means the implementation can use the smallest representable non-zero value in the screen space pixel fixed-point grid.")
    VkBool32("primitiveUnderestimation", "#TRUE if the implementation supports the #CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT conservative rasterization mode in addition to #CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT. Otherwise the implementation only supports #CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT.")
    VkBool32("conservativePointAndLineRasterization", "#TRUE if the implementation supports conservative rasterization of point and line primitives as well as triangle primitives. Otherwise the implementation only supports triangle primitives.")
    VkBool32("degenerateTrianglesRasterized", "#FALSE if the implementation culls primitives generated from triangles that become zero area after they are quantized to the fixed-point rasterization pixel grid. {@code degenerateTrianglesRasterized} is #TRUE if these primitives are not culled and the provoking vertex attributes and depth value are used for the fragments. The primitive area calculation is done on the primitive generated from the clipped triangle if applicable. Zero area primitives are backfacing and the application <b>can</b> enable backface culling if desired.")
    VkBool32("degenerateLinesRasterized", "#FALSE if the implementation culls lines that become zero length after they are quantized to the fixed-point rasterization pixel grid. {@code degenerateLinesRasterized} is #TRUE if zero length lines are not culled and the provoking vertex attributes and depth value are used for the fragments.")
    VkBool32("fullyCoveredFragmentShaderInputVariable", "#TRUE if the implementation supports the SPIR-V builtin fragment shader input variable {@code FullyCoveredEXT} specifying that conservative rasterization is enabled and the fragment area is fully covered by the generating primitive.")
    VkBool32("conservativeRasterizationPostDepthCoverage", "#TRUE if the implementation supports conservative rasterization with the {@code PostDepthCoverage} execution mode enabled. Otherwise the {@code PostDepthCoverage} execution mode <b>must</b> not be used when conservative rasterization is enabled.")
}

val VkPipelineRasterizationConservativeStateCreateInfoEXT = struct(Module.VULKAN, "VkPipelineRasterizationConservativeStateCreateInfoEXT") {
    documentation =
        """
        Structure specifying conservative raster state.

        <h5>Description</h5>
        If this structure is not included in the {@code pNext} chain, {@code conservativeRasterizationMode} is considered to be #CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT, and conservative rasterization is disabled.

        Polygon rasterization <b>can</b> be made conservative by setting {@code conservativeRasterizationMode} to #CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT or #CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT in ##VkPipelineRasterizationConservativeStateCreateInfoEXT.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-conservativePointAndLineRasterization">{@code conservativePointAndLineRasterization}</a> is supported, conservative rasterization can be applied to line and point primitives, otherwise it must be disabled.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code extraPrimitiveOverestimationSize} <b>must</b> be in the range of {@code 0.0} to ##VkPhysicalDeviceConservativeRasterizationPropertiesEXT{@code ::maxExtraPrimitiveOverestimationSize} inclusive</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code conservativeRasterizationMode} <b>must</b> be a valid {@code VkConservativeRasterizationModeEXT} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineRasterizationConservativeStateCreateFlagsEXT("flags", "reserved for future use.")
    VkConservativeRasterizationModeEXT("conservativeRasterizationMode", "the conservative rasterization mode to use.")
    float("extraPrimitiveOverestimationSize", "the extra size in pixels to increase the generating primitive during conservative rasterization at each of its edges in {@code X} and {@code Y} equally in screen space beyond the base overestimation specified in ##VkPhysicalDeviceConservativeRasterizationPropertiesEXT{@code ::primitiveOverestimationSize}. If {@code conservativeRasterizationMode} is not #CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT, this value is ignored.")
}

val VkPhysicalDeviceDepthClipEnableFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceDepthClipEnableFeaturesEXT") {
    documentation =
        """
        Structure indicating support for explicit enable of depth clip.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceDepthClipEnableFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceDepthClipEnableFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("depthClipEnable", "indicates that the implementation supports setting the depth clipping operation explicitly via the ##VkPipelineRasterizationDepthClipStateCreateInfoEXT pipeline state. Otherwise depth clipping is only enabled when ##VkPipelineRasterizationStateCreateInfo{@code ::depthClampEnable} is #FALSE.")
}

val VkPipelineRasterizationDepthClipStateCreateInfoEXT = struct(Module.VULKAN, "VkPipelineRasterizationDepthClipStateCreateInfoEXT") {
    documentation =
        """
        Structure specifying depth clipping state.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineRasterizationDepthClipStateCreateFlagsEXT("flags", "reserved for future use.")
    VkBool32("depthClipEnable", "controls whether depth clipping is enabled as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#vertexpostproc-clipping\">Primitive Clipping</a>.")
}

val VkXYColorEXT = struct(Module.VULKAN, "VkXYColorEXT") {
    documentation =
        """
        Specify X,Y chromaticity coordinates.

        <h5>Description</h5>
        Chromaticity coordinates are as specified in CIE 15:2004 “{@code Calculation of chromaticity coordinates}” (Section 7.3) and are limited to between 0 and 1 for real colors.

        <h5>See Also</h5>
        ##VkHdrMetadataEXT
        """

    float("x", "the <code>x</code> chromaticity coordinate.")
    float("y", "the <code>y</code> chromaticity coordinate.")
}

val VkHdrMetadataEXT = struct(Module.VULKAN, "VkHdrMetadataEXT") {
    documentation =
        """
        Specify HDR metadata.

        <h5>Description</h5>
        If any of the above values are unknown, they <b>can</b> be set to 0.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The meta-data provided here is intended to be used as defined in the SMPTE 2086, CTA 861.3 and CIE 15:2004 specifications. The validity and use of this data is outside the scope of Vulkan.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_HDR_METADATA_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkHdrVividDynamicMetadataHUAWEI</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
        </ul>

        <h5>See Also</h5>
        ##VkXYColorEXT, #SetHdrMetadataEXT()
        """

    Expression("#STRUCTURE_TYPE_HDR_METADATA_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkHdrVividDynamicMetadataHUAWEI",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkXYColorEXT("displayPrimaryRed", "a ##VkXYColorEXT structure specifying the red primary of the display used to optimize the content")
    VkXYColorEXT("displayPrimaryGreen", "a ##VkXYColorEXT structure specifying the green primary of the display used to optimize the content")
    VkXYColorEXT("displayPrimaryBlue", "a ##VkXYColorEXT structure specifying the blue primary of the display used to optimize the content")
    VkXYColorEXT("whitePoint", "a ##VkXYColorEXT structure specifying the white-point of the display used to optimize the content")
    float("maxLuminance", "the maximum luminance of the display used to optimize the content in nits")
    float("minLuminance", "the minimum luminance of the display used to optimize the content in nits")
    float("maxContentLightLevel", "the value in nits of the desired luminance for the brightest pixels in the displayed image.")
    float("maxFrameAverageLightLevel", "the value in nits of the average luminance of the frame which has the brightest average luminance anywhere in the content.")
}

val VkPhysicalDeviceImagelessFramebufferFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceImagelessFramebufferFeaturesKHR", alias = VkPhysicalDeviceImagelessFramebufferFeatures) {
    documentation = "See ##VkPhysicalDeviceImagelessFramebufferFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("imagelessFramebuffer", "")
}

val VkFramebufferAttachmentsCreateInfoKHR = struct(Module.VULKAN, "VkFramebufferAttachmentsCreateInfoKHR", alias = VkFramebufferAttachmentsCreateInfo) {
    documentation = "See ##VkFramebufferAttachmentsCreateInfo."

    Expression("#STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pAttachmentImageInfos", optional = true)..uint32_t("attachmentImageInfoCount", "")
    VkFramebufferAttachmentImageInfo.const.p("pAttachmentImageInfos", "")
}

val VkFramebufferAttachmentImageInfoKHR = struct(Module.VULKAN, "VkFramebufferAttachmentImageInfoKHR", alias = VkFramebufferAttachmentImageInfo) {
    documentation = "See ##VkFramebufferAttachmentImageInfo."

    Expression("#STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImageCreateFlags("flags", "")
    VkImageUsageFlags("usage", "")
    uint32_t("width", "")
    uint32_t("height", "")
    uint32_t("layerCount", "")
    AutoSize("pViewFormats", optional = true)..uint32_t("viewFormatCount", "")
    VkFormat.const.p("pViewFormats", "")
}

val VkRenderPassAttachmentBeginInfoKHR = struct(Module.VULKAN, "VkRenderPassAttachmentBeginInfoKHR", alias = VkRenderPassAttachmentBeginInfo) {
    documentation = "See ##VkRenderPassAttachmentBeginInfo."

    Expression("#STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pAttachments", optional = true)..uint32_t("attachmentCount", "")
    VkImageView.const.p("pAttachments", "")
}

val VkRenderPassCreateInfo2KHR = struct(Module.VULKAN, "VkRenderPassCreateInfo2KHR", alias = VkRenderPassCreateInfo2) {
    documentation = "See ##VkRenderPassCreateInfo2."

    Expression("#STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkRenderPassCreateFlags("flags", "")
    AutoSize("pAttachments", optional = true)..uint32_t("attachmentCount", "")
    VkAttachmentDescription2.const.p("pAttachments", "")
    AutoSize("pSubpasses")..uint32_t("subpassCount", "")
    VkSubpassDescription2.const.p("pSubpasses", "")
    AutoSize("pDependencies", optional = true)..uint32_t("dependencyCount", "")
    VkSubpassDependency2.const.p("pDependencies", "")
    AutoSize("pCorrelatedViewMasks", optional = true)..uint32_t("correlatedViewMaskCount", "")
    uint32_t.const.p("pCorrelatedViewMasks", "")
}

val VkAttachmentDescription2KHR = struct(Module.VULKAN, "VkAttachmentDescription2KHR", alias = VkAttachmentDescription2) {
    documentation = "See ##VkAttachmentDescription2."

    Expression("#STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkAttachmentDescriptionFlags("flags", "")
    VkFormat("format", "")
    VkSampleCountFlagBits("samples", "")
    VkAttachmentLoadOp("loadOp", "")
    VkAttachmentStoreOp("storeOp", "")
    VkAttachmentLoadOp("stencilLoadOp", "")
    VkAttachmentStoreOp("stencilStoreOp", "")
    VkImageLayout("initialLayout", "")
    VkImageLayout("finalLayout", "")
}

val VkAttachmentReference2KHR = struct(Module.VULKAN, "VkAttachmentReference2KHR", alias = VkAttachmentReference2) {
    documentation = "See ##VkAttachmentReference2."

    Expression("#STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    uint32_t("attachment", "")
    VkImageLayout("layout", "")
    VkImageAspectFlags("aspectMask", "")
}

val VkSubpassDescription2KHR = struct(Module.VULKAN, "VkSubpassDescription2KHR", alias = VkSubpassDescription2) {
    documentation = "See ##VkSubpassDescription2."

    Expression("#STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkSubpassDescriptionFlags("flags", "")
    VkPipelineBindPoint("pipelineBindPoint", "")
    uint32_t("viewMask", "")
    AutoSize("pInputAttachments", optional = true)..uint32_t("inputAttachmentCount", "")
    VkAttachmentReference2.const.p("pInputAttachments", "")
    AutoSize("pColorAttachments", "pResolveAttachments", optional = true)..uint32_t("colorAttachmentCount", "")
    VkAttachmentReference2.const.p("pColorAttachments", "")
    nullable..VkAttachmentReference2.const.p("pResolveAttachments", "")
    nullable..VkAttachmentReference2.const.p("pDepthStencilAttachment", "")
    AutoSize("pPreserveAttachments", optional = true)..uint32_t("preserveAttachmentCount", "")
    uint32_t.const.p("pPreserveAttachments", "")
}

val VkSubpassDependency2KHR = struct(Module.VULKAN, "VkSubpassDependency2KHR", alias = VkSubpassDependency2) {
    documentation = "See ##VkSubpassDependency2."

    Expression("#STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    uint32_t("srcSubpass", "")
    uint32_t("dstSubpass", "")
    VkPipelineStageFlags("srcStageMask", "")
    VkPipelineStageFlags("dstStageMask", "")
    VkAccessFlags("srcAccessMask", "")
    VkAccessFlags("dstAccessMask", "")
    VkDependencyFlags("dependencyFlags", "")
    int32_t("viewOffset", "")
}

val VkSubpassBeginInfoKHR = struct(Module.VULKAN, "VkSubpassBeginInfoKHR", alias = VkSubpassBeginInfo) {
    documentation = "See ##VkSubpassBeginInfo."

    Expression("#STRUCTURE_TYPE_SUBPASS_BEGIN_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkSubpassContents("contents", "")
}

val VkSubpassEndInfoKHR = struct(Module.VULKAN, "VkSubpassEndInfoKHR", alias = VkSubpassEndInfo) {
    documentation = "See ##VkSubpassEndInfo."

    Expression("#STRUCTURE_TYPE_SUBPASS_END_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
}

val VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG = struct(Module.VULKAN, "VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG") {
    documentation =
        """
        Structure describing relaxed line rasterization features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("relaxedLineRasterization", "indicates that the implementation supports relaxed line rasterization control.")
}

val VkSharedPresentSurfaceCapabilitiesKHR = struct(Module.VULKAN, "VkSharedPresentSurfaceCapabilitiesKHR", mutable = false) {
    documentation =
        """
        Structure describing capabilities of a surface for shared presentation.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkImageUsageFlags("sharedPresentSupportedUsageFlags", "a bitmask of {@code VkImageUsageFlagBits} representing the ways the application <b>can</b> use the shared presentable image from a swapchain created with {@code VkPresentModeKHR} set to #PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR or #PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR for the surface on the specified device. #IMAGE_USAGE_COLOR_ATTACHMENT_BIT <b>must</b> be included in the set but implementations <b>may</b> support additional usages.")
}

val VkPhysicalDeviceExternalFenceInfoKHR = struct(Module.VULKAN, "VkPhysicalDeviceExternalFenceInfoKHR", alias = VkPhysicalDeviceExternalFenceInfo) {
    documentation = "See ##VkPhysicalDeviceExternalFenceInfo."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkExternalFenceHandleTypeFlagBits("handleType", "")
}

val VkExternalFencePropertiesKHR = struct(Module.VULKAN, "VkExternalFencePropertiesKHR", mutable = false, alias = VkExternalFenceProperties) {
    documentation = "See ##VkExternalFenceProperties."

    Expression("#STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkExternalFenceHandleTypeFlags("exportFromImportedHandleTypes", "")
    VkExternalFenceHandleTypeFlags("compatibleHandleTypes", "")
    VkExternalFenceFeatureFlags("externalFenceFeatures", "")
}

val VkExportFenceCreateInfoKHR = struct(Module.VULKAN, "VkExportFenceCreateInfoKHR", alias = VkExportFenceCreateInfo) {
    documentation = "See ##VkExportFenceCreateInfo."

    Expression("#STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkExternalFenceHandleTypeFlags("handleTypes", "")
}

val VkImportFenceWin32HandleInfoKHR = struct(Module.VULKAN, "VkImportFenceWin32HandleInfoKHR") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        (None).

        <h5>Description</h5>
        The handle types supported by {@code handleType} are:

        <h6>Handle Types Supported by ##VkImportFenceWin32HandleInfoKHR</h6>
        <table class="lwjgl">
            <thead><tr><th>Handle Type</th><th>Transference</th><th>Permanence Supported</th></tr></thead>
            <tbody>
                <tr><td>#EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT</td><td>Reference</td><td>Temporary,Permanent</td></tr>
                <tr><td>#EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT</td><td>Reference</td><td>Temporary,Permanent</td></tr>
            </tbody>
        </table>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> be a value included in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-fence-handletypes-win32">Handle Types Supported by ##VkImportFenceWin32HandleInfoKHR</a> table</li>
            <li>If {@code handleType} is not #EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, {@code name} <b>must</b> be {@code NULL}</li>
            <li>If {@code handle} is {@code NULL}, {@code name} <b>must</b> name a valid synchronization primitive of the type specified by {@code handleType}</li>
            <li>If {@code name} is {@code NULL}, {@code handle} <b>must</b> be a valid handle of the type specified by {@code handleType}</li>
            <li>If {@code handle} is not {@code NULL}, {@code name} <b>must</b> be {@code NULL}</li>
            <li>If {@code handle} is not {@code NULL}, it <b>must</b> obey any requirements listed for {@code handleType} in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-fence-handle-types-compatibility">external fence handle types compatibility</a></li>
            <li>If {@code name} is not {@code NULL}, it <b>must</b> obey any requirements listed for {@code handleType} in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-fence-handle-types-compatibility">external fence handle types compatibility</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkFenceImportFlagBits} values</li>
        </ul>

        <h5>Host Synchronization</h5>
        <ul>
            <li>Host access to {@code fence} <b>must</b> be externally synchronized</li>
        </ul>

        <h5>See Also</h5>
        #ImportFenceWin32HandleKHR()
        """

    Expression("#STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkFence("fence", "the fence into which the state will be imported.")
    VkFenceImportFlags("flags", "a bitmask of {@code VkFenceImportFlagBits} specifying additional parameters for the fence payload import operation.")
    VkExternalFenceHandleTypeFlagBits("handleType", "a {@code VkExternalFenceHandleTypeFlagBits} value specifying the type of {@code handle}.")
    HANDLE("handle", "{@code NULL} or the external handle to import.")
    LPCWSTR("name", "{@code NULL} or a null-terminated UTF-16 string naming the underlying synchronization primitive to import.")
}

val VkExportFenceWin32HandleInfoKHR = struct(Module.VULKAN, "VkExportFenceWin32HandleInfoKHR") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        Structure specifying additional attributes of Windows handles exported from a fence.

        <h5>Description</h5>
        If ##VkExportFenceCreateInfo is not included in the same {@code pNext} chain, this structure is ignored.

        If ##VkExportFenceCreateInfo is included in the {@code pNext} chain of ##VkFenceCreateInfo with a Windows {@code handleType}, but either ##VkExportFenceWin32HandleInfoKHR is not included in the {@code pNext} chain, or it is included but {@code pAttributes} is {@code NULL}, default security descriptor values will be used, and child processes created by the application will not inherit the handle, as described in the MSDN documentation for “{@code Synchronization Object Security and Access Rights}”<sup>1</sup>. Further, if the structure is not present, the access rights will be

        {@code DXGI_SHARED_RESOURCE_READ} | {@code DXGI_SHARED_RESOURCE_WRITE}

        for handles of the following types:

        #EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT

        <dl>
            <dt>1</dt>
            <dd><a href="https://docs.microsoft.com/en-us/windows/win32/sync/synchronization-object-security-and-access-rights">https://docs.microsoft.com/en-us/windows/win32/sync/synchronization-object-security-and-access-rights</a></dd>
        </dl>

        <h5>Valid Usage</h5>
        <ul>
            <li>If ##VkExportFenceCreateInfo{@code ::handleTypes} does not include #EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, a ##VkExportFenceWin32HandleInfoKHR structure <b>must</b> not be included in the {@code pNext} chain of ##VkFenceCreateInfo</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR</li>
            <li>If {@code pAttributes} is not {@code NULL}, {@code pAttributes} <b>must</b> be a valid pointer to a valid {@code SECURITY_ATTRIBUTES} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    nullable..SECURITY_ATTRIBUTES.const.p("pAttributes", "a pointer to a Windows {@code SECURITY_ATTRIBUTES} structure specifying security attributes of the handle.")
    DWORD("dwAccess", "a {@code DWORD} specifying access rights of the handle.")
    LPCWSTR("name", "a null-terminated UTF-16 string to associate with the underlying synchronization primitive referenced by NT handles exported from the created fence.")
}

val VkFenceGetWin32HandleInfoKHR = struct(Module.VULKAN, "VkFenceGetWin32HandleInfoKHR") {
    documentation =
        """
        Structure describing a Win32 handle fence export operation.

        <h5>Description</h5>
        The properties of the handle returned depend on the value of {@code handleType}. See {@code VkExternalFenceHandleTypeFlagBits} for a description of the properties of the defined external fence handle types.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> have been included in ##VkExportFenceCreateInfo{@code ::handleTypes} when the {@code fence}’s current payload was created</li>
            <li>If {@code handleType} is defined as an NT handle, #GetFenceWin32HandleKHR() <b>must</b> be called no more than once for each valid unique combination of {@code fence} and {@code handleType}</li>
            <li>{@code fence} <b>must</b> not currently have its payload replaced by an imported payload as described below in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-fences-importing">Importing Fence Payloads</a> unless that imported payload’s handle type was included in ##VkExternalFenceProperties{@code ::exportFromImportedHandleTypes} for {@code handleType}</li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, {@code fence} <b>must</b> be signaled, or have an associated <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-fences-signaling">fence signal operation</a> pending execution</li>
            <li>{@code handleType} <b>must</b> be defined as an NT handle or a global share handle</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
            <li>{@code handleType} <b>must</b> be a valid {@code VkExternalFenceHandleTypeFlagBits} value</li>
        </ul>

        <h5>See Also</h5>
        #GetFenceWin32HandleKHR()
        """

    Expression("#STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkFence("fence", "the fence from which state will be exported.")
    VkExternalFenceHandleTypeFlagBits("handleType", "a {@code VkExternalFenceHandleTypeFlagBits} value specifying the type of handle requested.")
}

val VkImportFenceFdInfoKHR = struct(Module.VULKAN, "VkImportFenceFdInfoKHR") {
    documentation =
        """
        (None).

        <h5>Description</h5>
        The handle types supported by {@code handleType} are:

        <h6>Handle Types Supported by ##VkImportFenceFdInfoKHR</h6>
        <table class="lwjgl">
            <thead><tr><th>Handle Type</th><th>Transference</th><th>Permanence Supported</th></tr></thead>
            <tbody>
                <tr><td>#EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT</td><td>Reference</td><td>Temporary,Permanent</td></tr>
                <tr><td>#EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT</td><td>Copy</td><td>Temporary</td></tr>
            </tbody>
        </table>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> be a value included in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-fence-handletypes-fd">Handle Types Supported by ##VkImportFenceFdInfoKHR</a> table</li>
            <li>{@code fd} <b>must</b> obey any requirements listed for {@code handleType} in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#external-fence-handle-types-compatibility">external fence handle types compatibility</a></li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, {@code flags} <b>must</b> contain #FENCE_IMPORT_TEMPORARY_BIT</li>
        </ul>

        If {@code handleType} is #EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT, the special value {@code -1} for {@code fd} is treated like a valid sync file descriptor referring to an object that has already signaled. The import operation will succeed and the {@code VkFence} will have a temporarily imported payload as if a valid file descriptor had been provided.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        This special behavior for importing an invalid sync file descriptor allows easier interoperability with other system APIs which use the convention that an invalid sync file descriptor represents work that has already completed and does not need to be waited for. It is consistent with the option for implementations to return a {@code -1} file descriptor when exporting a #EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT from a {@code VkFence} which is signaled.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkFenceImportFlagBits} values</li>
            <li>{@code handleType} <b>must</b> be a valid {@code VkExternalFenceHandleTypeFlagBits} value</li>
        </ul>

        <h5>Host Synchronization</h5>
        <ul>
            <li>Host access to {@code fence} <b>must</b> be externally synchronized</li>
        </ul>

        <h5>See Also</h5>
        #ImportFenceFdKHR()
        """

    Expression("#STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkFence("fence", "the fence into which the payload will be imported.")
    VkFenceImportFlags("flags", "a bitmask of {@code VkFenceImportFlagBits} specifying additional parameters for the fence payload import operation.")
    VkExternalFenceHandleTypeFlagBits("handleType", "a {@code VkExternalFenceHandleTypeFlagBits} value specifying the type of {@code fd}.")
    int("fd", "the external handle to import.")
}

val VkFenceGetFdInfoKHR = struct(Module.VULKAN, "VkFenceGetFdInfoKHR") {
    documentation =
        """
        Structure describing a POSIX FD fence export operation.

        <h5>Description</h5>
        The properties of the file descriptor returned depend on the value of {@code handleType}. See {@code VkExternalFenceHandleTypeFlagBits} for a description of the properties of the defined external fence handle types.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code handleType} <b>must</b> have been included in ##VkExportFenceCreateInfo{@code ::handleTypes} when {@code fence}’s current payload was created</li>
            <li>If {@code handleType} refers to a handle type with copy payload transference semantics, {@code fence} <b>must</b> be signaled, or have an associated <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-fences-signaling">fence signal operation</a> pending execution</li>
            <li>{@code fence} <b>must</b> not currently have its payload replaced by an imported payload as described below in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#synchronization-fences-importing">Importing Fence Payloads</a> unless that imported payload’s handle type was included in ##VkExternalFenceProperties{@code ::exportFromImportedHandleTypes} for {@code handleType}</li>
            <li>{@code handleType} <b>must</b> be defined as a POSIX file descriptor handle</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
            <li>{@code handleType} <b>must</b> be a valid {@code VkExternalFenceHandleTypeFlagBits} value</li>
        </ul>

        <h5>See Also</h5>
        #GetFenceFdKHR()
        """

    Expression("#STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkFence("fence", "the fence from which state will be exported.")
    VkExternalFenceHandleTypeFlagBits("handleType", "a {@code VkExternalFenceHandleTypeFlagBits} value specifying the type of handle requested.")
}

val VkPhysicalDevicePerformanceQueryFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDevicePerformanceQueryFeaturesKHR") {
    documentation =
        """
        Structure describing performance query support for an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDevicePerformanceQueryFeaturesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDevicePerformanceQueryFeaturesKHR <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("performanceCounterQueryPools", "indicates whether the implementation supports performance counter query pools.")
    VkBool32("performanceCounterMultipleQueryPools", "indicates whether the implementation supports using multiple performance query pools in a primary command buffer and secondary command buffers executed within it.")
}

val VkPhysicalDevicePerformanceQueryPropertiesKHR = struct(Module.VULKAN, "VkPhysicalDevicePerformanceQueryPropertiesKHR", mutable = false) {
    documentation =
        """
        Structure describing performance query properties for an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDevicePerformanceQueryPropertiesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkBool32("allowCommandBufferQueryCopies", "#TRUE if the performance query pools are allowed to be used with #CmdCopyQueryPoolResults().")
}

val VkPerformanceCounterKHR = struct(Module.VULKAN, "VkPerformanceCounterKHR", mutable = false) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation =
        """
        Structure providing information about a counter.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR()
        """

    Expression("#STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkPerformanceCounterUnitKHR("unit", "a {@code VkPerformanceCounterUnitKHR} specifying the unit that the counter data will record.")
    VkPerformanceCounterScopeKHR("scope", "a {@code VkPerformanceCounterScopeKHR} specifying the scope that the counter belongs to.")
    VkPerformanceCounterStorageKHR("storage", "a {@code VkPerformanceCounterStorageKHR} specifying the storage type that the counter’s data uses.")
    uint8_t("uuid", "an array of size #UUID_SIZE, containing 8-bit values that represent a universally unique identifier for the counter of the physical device.")["VK_UUID_SIZE"]
}

val VkPerformanceCounterDescriptionKHR = struct(Module.VULKAN, "VkPerformanceCounterDescriptionKHR", mutable = false) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation =
        """
        Structure providing more detailed information about a counter.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR()
        """

    Expression("#STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkPerformanceCounterDescriptionFlagsKHR("flags", "a bitmask of {@code VkPerformanceCounterDescriptionFlagBitsKHR} indicating the usage behavior for the counter.")
    charUTF8("name", "an array of size #MAX_DESCRIPTION_SIZE, containing a null-terminated UTF-8 string specifying the name of the counter.")["VK_MAX_DESCRIPTION_SIZE"]
    charUTF8("category", "an array of size #MAX_DESCRIPTION_SIZE, containing a null-terminated UTF-8 string specifying the category of the counter.")["VK_MAX_DESCRIPTION_SIZE"]
    charUTF8("description", "an array of size #MAX_DESCRIPTION_SIZE, containing a null-terminated UTF-8 string specifying the description of the counter.")["VK_MAX_DESCRIPTION_SIZE"]
}

val VkQueryPoolPerformanceCreateInfoKHR = struct(Module.VULKAN, "VkQueryPoolPerformanceCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created performance query pool.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code queueFamilyIndex} <b>must</b> be a valid queue family index of the device</li>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-performanceCounterQueryPools">{@code performanceCounterQueryPools}</a> feature <b>must</b> be enabled</li>
            <li>Each element of {@code pCounterIndices} <b>must</b> be in the range of counters reported by {@code vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR} for the queue family specified in {@code queueFamilyIndex}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR</li>
            <li>{@code pCounterIndices} <b>must</b> be a valid pointer to an array of {@code counterIndexCount} {@code uint32_t} values</li>
            <li>{@code counterIndexCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        #GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR()
        """

    Expression("#STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("queueFamilyIndex", "the queue family index to create this performance query pool for.")
    AutoSize("pCounterIndices")..uint32_t("counterIndexCount", "the length of the {@code pCounterIndices} array.")
    uint32_t.const.p("pCounterIndices", "a pointer to an array of indices into the #EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(){@code ::pCounters} to enable in this performance query pool.")
}

val VkPerformanceCounterResultKHR = union(Module.VULKAN, "VkPerformanceCounterResultKHR") {
    documentation =
        """
        Union containing a performance counter result.
        """

    int32_t("int32", "")
    int64_t("int64", "")
    uint32_t("uint32", "")
    uint64_t("uint64", "")
    float("float32", "")
    double("float64", "")
}

val VkAcquireProfilingLockInfoKHR = struct(Module.VULKAN, "VkAcquireProfilingLockInfoKHR") {
    documentation =
        """
        Structure specifying parameters to acquire the profiling lock.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        If {@code timeout} is 0, {@code vkAcquireProfilingLockKHR} will not block while attempting to acquire the profiling lock. If {@code timeout} is {@code UINT64_MAX}, the function will not return until the profiling lock was acquired.

        <h5>See Also</h5>
        #AcquireProfilingLockKHR()
        """

    Expression("#STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAcquireProfilingLockFlagsKHR("flags", "reserved for future use.")
    uint64_t("timeout", "indicates how long the function waits, in nanoseconds, if the profiling lock is not available.")
}

val VkPerformanceQuerySubmitInfoKHR = struct(Module.VULKAN, "VkPerformanceQuerySubmitInfoKHR") {
    documentation =
        """
        Structure indicating which counter pass index is active for performance queries.

        <h5>Description</h5>
        If the ##VkSubmitInfo{@code ::pNext} chain does not include this structure, the batch defaults to use counter pass index 0.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code counterPassIndex} <b>must</b> be less than the number of counter passes required by any queries within the batch. The required number of counter passes for a performance query is obtained by calling #GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR()</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("counterPassIndex", "specifies which counter pass index is active.")
}

val VkPhysicalDevicePointClippingPropertiesKHR = struct(Module.VULKAN, "VkPhysicalDevicePointClippingPropertiesKHR", mutable = false, alias = VkPhysicalDevicePointClippingProperties) {
    documentation = "See ##VkPhysicalDevicePointClippingProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkPointClippingBehavior("pointClippingBehavior", "")
}

val VkRenderPassInputAttachmentAspectCreateInfoKHR = struct(Module.VULKAN, "VkRenderPassInputAttachmentAspectCreateInfoKHR", alias = VkRenderPassInputAttachmentAspectCreateInfo) {
    documentation = "See ##VkRenderPassInputAttachmentAspectCreateInfo."

    Expression("#STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pAspectReferences")..uint32_t("aspectReferenceCount", "")
    VkInputAttachmentAspectReference.const.p("pAspectReferences", "")
}

val VkInputAttachmentAspectReferenceKHR = struct(Module.VULKAN, "VkInputAttachmentAspectReferenceKHR", alias = VkInputAttachmentAspectReference) {
    documentation = "See ##VkInputAttachmentAspectReference."

    uint32_t("subpass", "")
    uint32_t("inputAttachmentIndex", "")
    VkImageAspectFlags("aspectMask", "")
}

val VkImageViewUsageCreateInfoKHR = struct(Module.VULKAN, "VkImageViewUsageCreateInfoKHR", alias = VkImageViewUsageCreateInfo) {
    documentation = "See ##VkImageViewUsageCreateInfo."

    Expression("#STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImageUsageFlags("usage", "")
}

val VkPipelineTessellationDomainOriginStateCreateInfoKHR = struct(Module.VULKAN, "VkPipelineTessellationDomainOriginStateCreateInfoKHR", alias = VkPipelineTessellationDomainOriginStateCreateInfo) {
    documentation = "See ##VkPipelineTessellationDomainOriginStateCreateInfo."

    Expression("#STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkTessellationDomainOrigin("domainOrigin", "")
}

val VkPhysicalDeviceSurfaceInfo2KHR = struct(Module.VULKAN, "VkPhysicalDeviceSurfaceInfo2KHR") {
    documentation =
        """
        Structure specifying a surface and related swapchain creation parameters.

        <h5>Description</h5>
        The members of ##VkPhysicalDeviceSurfaceInfo2KHR correspond to the arguments to #GetPhysicalDeviceSurfaceCapabilitiesKHR(), with {@code sType} and {@code pNext} added for extensibility.

        Additional capabilities of a surface <b>may</b> be available to swapchains created with different full-screen exclusive settings - particularly if exclusive full-screen access is application controlled. These additional capabilities <b>can</b> be queried by adding a ##VkSurfaceFullScreenExclusiveInfoEXT structure to the {@code pNext} chain of this structure when used to query surface properties. Additionally, for Win32 surfaces with application controlled exclusive full-screen access, chaining a ##VkSurfaceFullScreenExclusiveWin32InfoEXT structure <b>may</b> also report additional surface capabilities. These additional capabilities only apply to swapchains created with the same parameters included in the {@code pNext} chain of ##VkSwapchainCreateInfoKHR.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain includes a ##VkSurfaceFullScreenExclusiveInfoEXT structure with its {@code fullScreenExclusive} member set to #FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT, and {@code surface} was created using #CreateWin32SurfaceKHR(), a ##VkSurfaceFullScreenExclusiveWin32InfoEXT structure <b>must</b> be included in the {@code pNext} chain</li>
            <li>If surface is not VK_NULL_HANDLE, and the {@link GOOGLESurfacelessQuery VK_GOOGLE_surfaceless_query} extension is not enabled, {@code surface} <b>must</b> be a valid {@code VkSurfaceKHR} handle</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkSurfaceFullScreenExclusiveInfoEXT, ##VkSurfaceFullScreenExclusiveWin32InfoEXT, or ##VkSurfacePresentModeEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
        </ul>

        <h5>See Also</h5>
        #GetDeviceGroupSurfacePresentModes2EXT(), #GetPhysicalDeviceSurfaceCapabilities2KHR(), #GetPhysicalDeviceSurfaceFormats2KHR(), #GetPhysicalDeviceSurfacePresentModes2EXT()
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkSurfaceFullScreenExclusiveInfoEXT", "VkSurfaceFullScreenExclusiveWin32InfoEXT", "VkSurfacePresentModeEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSurfaceKHR("surface", "the surface that will be associated with the swapchain.")
}

val VkSurfaceCapabilities2KHR = struct(Module.VULKAN, "VkSurfaceCapabilities2KHR", mutable = false) {
    documentation =
        """
        Structure describing capabilities of a surface.

        <h5>Description</h5>
        If the {@link GOOGLESurfacelessQuery VK_GOOGLE_surfaceless_query} extension is enabled and ##VkPhysicalDeviceSurfaceInfo2KHR{@code ::surface} in the #GetPhysicalDeviceSurfaceCapabilities2KHR() call is #NULL_HANDLE, the values returned in {@code minImageCount}, {@code maxImageCount}, {@code currentExtent}, and {@code currentTransform} will not reflect that of any surface and will instead be as such:

        <ul>
            <li>{@code minImageCount} and {@code maxImageCount} will be <code>0xFFFFFFFF</code></li>
            <li>{@code currentExtent} will be <code>(0xFFFFFFFF, 0xFFFFFFFF)</code></li>
            <li>{@code currentTransform} will be #SURFACE_TRANSFORM_INHERIT_BIT_KHR</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkDisplayNativeHdrSurfaceCapabilitiesAMD, ##VkLatencySurfaceCapabilitiesNV, ##VkSharedPresentSurfaceCapabilitiesKHR, ##VkSurfaceCapabilitiesFullScreenExclusiveEXT, ##VkSurfaceCapabilitiesPresentBarrierNV, ##VkSurfacePresentModeCompatibilityEXT, ##VkSurfacePresentScalingCapabilitiesEXT, or ##VkSurfaceProtectedCapabilitiesKHR</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
        </ul>

        <h5>See Also</h5>
        ##VkSurfaceCapabilitiesKHR, #GetPhysicalDeviceSurfaceCapabilities2KHR()
        """

    Expression("#STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    PointerSetter(
        "VkDisplayNativeHdrSurfaceCapabilitiesAMD", "VkLatencySurfaceCapabilitiesNV", "VkSharedPresentSurfaceCapabilitiesKHR", "VkSurfaceCapabilitiesFullScreenExclusiveEXT", "VkSurfaceCapabilitiesPresentBarrierNV", "VkSurfacePresentModeCompatibilityEXT", "VkSurfacePresentScalingCapabilitiesEXT", "VkSurfaceProtectedCapabilitiesKHR",
        prepend = true
    )..nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkSurfaceCapabilitiesKHR("surfaceCapabilities", "a ##VkSurfaceCapabilitiesKHR structure describing the capabilities of the specified surface.")
}

val VkSurfaceFormat2KHR = struct(Module.VULKAN, "VkSurfaceFormat2KHR", mutable = false) {
    documentation =
        """
        Structure describing a supported swapchain format tuple.

        <h5>Description</h5>
        If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-imageCompressionControlSwapchain">{@code imageCompressionControlSwapchain}</a> feature is supported and a ##VkImageCompressionPropertiesEXT structure is included in the {@code pNext} chain of this structure, then it will be filled with the compression properties that are supported for the {@code surfaceFormat}.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-imageCompressionControlSwapchain">{@code imageCompressionControlSwapchain}</a> feature is not enabled, the {@code pNext} chain <b>must</b> not include an ##VkImageCompressionPropertiesEXT structure</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkImageCompressionPropertiesEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
        </ul>

        <h5>See Also</h5>
        ##VkSurfaceFormatKHR, #GetPhysicalDeviceSurfaceFormats2KHR()
        """

    Expression("#STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    PointerSetter(
        "VkImageCompressionPropertiesEXT",
        prepend = true
    )..nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkSurfaceFormatKHR("surfaceFormat", "a ##VkSurfaceFormatKHR structure describing a format-color space pair that is compatible with the specified surface.")
}

val VkPhysicalDeviceVariablePointerFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceVariablePointerFeaturesKHR", alias = VkPhysicalDeviceVariablePointersFeatures) {
    documentation = "See ##VkPhysicalDeviceVariablePointersFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("variablePointersStorageBuffer", "")
    VkBool32("variablePointers", "")
}

val VkPhysicalDeviceVariablePointersFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceVariablePointersFeaturesKHR", alias = VkPhysicalDeviceVariablePointersFeatures) {
    documentation = "See ##VkPhysicalDeviceVariablePointersFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("variablePointersStorageBuffer", "")
    VkBool32("variablePointers", "")
}

val VkDisplayProperties2KHR = struct(Module.VULKAN, "VkDisplayProperties2KHR", mutable = false) {
    documentation =
        """
        Structure describing an available display device.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkDisplayPropertiesKHR, #GetPhysicalDeviceDisplayProperties2KHR()
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkDisplayPropertiesKHR("displayProperties", "a ##VkDisplayPropertiesKHR structure.")
}

val VkDisplayPlaneProperties2KHR = struct(Module.VULKAN, "VkDisplayPlaneProperties2KHR", mutable = false) {
    documentation =
        """
        Structure describing an available display plane.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkDisplayPlanePropertiesKHR, #GetPhysicalDeviceDisplayPlaneProperties2KHR()
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkDisplayPlanePropertiesKHR("displayPlaneProperties", "a ##VkDisplayPlanePropertiesKHR structure.")
}

val VkDisplayModeProperties2KHR = struct(Module.VULKAN, "VkDisplayModeProperties2KHR", mutable = false) {
    documentation =
        """
        Structure describing an available display mode.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkDisplayModeStereoPropertiesNV</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
        </ul>

        <h5>See Also</h5>
        ##VkDisplayModePropertiesKHR, #GetDisplayModeProperties2KHR()
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    PointerSetter(
        "VkDisplayModeStereoPropertiesNV",
        prepend = true
    )..nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkDisplayModePropertiesKHR("displayModeProperties", "a ##VkDisplayModePropertiesKHR structure.")
}

val VkDisplayPlaneInfo2KHR = struct(Module.VULKAN, "VkDisplayPlaneInfo2KHR") {
    documentation =
        """
        Structure defining the intended configuration of a display plane.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        This parameter also implicitly specifies a display.
        </div>

        <ul>
            <li>{@code planeIndex} is the plane which the application intends to use with the display.</li>
        </ul>

        The members of ##VkDisplayPlaneInfo2KHR correspond to the arguments to #GetDisplayPlaneCapabilitiesKHR(), with {@code sType} and {@code pNext} added for extensibility.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code mode} <b>must</b> be a valid {@code VkDisplayModeKHR} handle</li>
        </ul>

        <h5>Host Synchronization</h5>
        <ul>
            <li>Host access to {@code mode} <b>must</b> be externally synchronized</li>
        </ul>

        <h5>See Also</h5>
        #GetDisplayPlaneCapabilities2KHR()
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDisplayModeKHR("mode", "the display mode the application intends to program when using the specified plane.")
    uint32_t("planeIndex", "")
}

val VkDisplayPlaneCapabilities2KHR = struct(Module.VULKAN, "VkDisplayPlaneCapabilities2KHR", mutable = false) {
    documentation =
        """
        Structure describing the capabilities of a mode and plane combination.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkDisplayPlaneCapabilitiesKHR, #GetDisplayPlaneCapabilities2KHR()
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkDisplayPlaneCapabilitiesKHR("capabilities", "a ##VkDisplayPlaneCapabilitiesKHR structure.")
}

val VkMacOSSurfaceCreateInfoMVK = struct(Module.VULKAN, "VkMacOSSurfaceCreateInfoMVK") {
    documentation =
        """
        Structure specifying parameters of a newly created macOS surface object.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code pView} is a {@code CAMetalLayer} object, it <b>must</b> be a valid {@code CAMetalLayer}</li>
            <li>If {@code pView} is an {@code NSView} object, it <b>must</b> be a valid {@code NSView}, <b>must</b> be backed by a {@code CALayer} object of type {@code CAMetalLayer}, and #CreateMacOSSurfaceMVK() <b>must</b> be called on the main thread</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CreateMacOSSurfaceMVK()
        """

    Expression("#STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkMacOSSurfaceCreateFlagsMVK("flags", "reserved for future use.")
    nullable..opaque_const_p("pView", "a reference to either a {@code CAMetalLayer} object or an {@code NSView} object.")
}

val VkMemoryDedicatedRequirementsKHR = struct(Module.VULKAN, "VkMemoryDedicatedRequirementsKHR", mutable = false, alias = VkMemoryDedicatedRequirements) {
    documentation = "See ##VkMemoryDedicatedRequirements."

    Expression("#STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkBool32("prefersDedicatedAllocation", "")
    VkBool32("requiresDedicatedAllocation", "")
}

val VkMemoryDedicatedAllocateInfoKHR = struct(Module.VULKAN, "VkMemoryDedicatedAllocateInfoKHR", alias = VkMemoryDedicatedAllocateInfo) {
    documentation = "See ##VkMemoryDedicatedAllocateInfo."

    Expression("#STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImage("image", "")
    VkBuffer("buffer", "")
}

val VkDebugUtilsLabelEXT = struct(Module.VULKAN, "VkDebugUtilsLabelEXT") {
    documentation =
        """
        Specify parameters of a label region.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code pLabelName} <b>must</b> be a null-terminated UTF-8 string</li>
        </ul>

        <h5>See Also</h5>
        ##VkDebugUtilsMessengerCallbackDataEXT, #CmdBeginDebugUtilsLabelEXT(), #CmdInsertDebugUtilsLabelEXT(), #QueueBeginDebugUtilsLabelEXT(), #QueueInsertDebugUtilsLabelEXT()
        """

    Expression("#STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    charUTF8.const.p("pLabelName", "a pointer to a null-terminated UTF-8 string containing the name of the label.")
    float("color", "an optional RGBA color value that can be associated with the label. A particular implementation <b>may</b> choose to ignore this color value. The values contain RGBA values in order, in the range 0.0 to 1.0. If all elements in {@code color} are 0.0, then it is ignored.")[4]
}

val VkDebugUtilsObjectNameInfoEXT = struct(Module.VULKAN, "VkDebugUtilsObjectNameInfoEXT") {
    documentation =
        """
        Specify parameters of a name to give to an object.

        <h5>Description</h5>
        Applications <b>may</b> change the name associated with an object simply by calling {@code vkSetDebugUtilsObjectNameEXT} again with a new string. If {@code pObjectName} is either {@code NULL} or an empty string, then any previously set name is removed.

        The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-graphicsPipelineLibrary">{@code graphicsPipelineLibrary}</a> feature allows the specification of pipelines without the creation of {@code VkShaderModule} objects beforehand. In order to continue to allow naming these shaders independently, ##VkDebugUtilsObjectNameInfoEXT <b>can</b> be included in the {@code pNext} chain of ##VkPipelineShaderStageCreateInfo, which associates a static name with that particular shader.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code objectType} is #OBJECT_TYPE_UNKNOWN, {@code objectHandle} <b>must</b> not be #NULL_HANDLE</li>
            <li>If {@code objectType} is not #OBJECT_TYPE_UNKNOWN, {@code objectHandle} <b>must</b> be #NULL_HANDLE or a valid Vulkan handle of the type associated with {@code objectType} as defined in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#debugging-object-types">{@code VkObjectType} and Vulkan Handle Relationship</a> table</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT</li>
            <li>{@code objectType} <b>must</b> be a valid {@code VkObjectType} value</li>
            <li>If {@code pObjectName} is not {@code NULL}, {@code pObjectName} <b>must</b> be a null-terminated UTF-8 string</li>
        </ul>

        <h5>See Also</h5>
        ##VkDebugUtilsMessengerCallbackDataEXT, #SetDebugUtilsObjectNameEXT()
        """

    Expression("#STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkObjectType("objectType", "a {@code VkObjectType} specifying the type of the object to be named.")
    uint64_t("objectHandle", "the object to be named.")
    nullable..charUTF8.const.p("pObjectName", "either {@code NULL} or a null-terminated UTF-8 string specifying the name to apply to {@code objectHandle}.")
}

val VkDebugUtilsMessengerCallbackDataEXT = struct(Module.VULKAN, "VkDebugUtilsMessengerCallbackDataEXT") {
    documentation =
        """
        Structure specifying parameters returned to the callback.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        This structure should only be considered valid during the lifetime of the triggered callback.
        </div>

        Since adding queue and command buffer labels behaves like pushing and popping onto a stack, the order of both {@code pQueueLabels} and {@code pCmdBufLabels} is based on the order the labels were defined. The result is that the first label in either {@code pQueueLabels} or {@code pCmdBufLabels} will be the first defined (and therefore the oldest) while the last label in each list will be the most recent.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        {@code pQueueLabels} will only be non-{@code NULL} if one of the objects in {@code pObjects} can be related directly to a defined {@code VkQueue} which has had one or more labels associated with it.

        Likewise, {@code pCmdBufLabels} will only be non-{@code NULL} if one of the objects in {@code pObjects} can be related directly to a defined {@code VkCommandBuffer} which has had one or more labels associated with it. Additionally, while command buffer labels allow for beginning and ending across different command buffers, the debug messaging framework <b>cannot</b> guarantee that labels in {@code pCmdBufLables} will contain those defined outside of the associated command buffer. This is partially due to the fact that the association of one command buffer with another may not have been defined at the time the debug message is triggered.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkDeviceAddressBindingCallbackDataEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>If {@code pMessageIdName} is not {@code NULL}, {@code pMessageIdName} <b>must</b> be a null-terminated UTF-8 string</li>
            <li>If {@code pMessage} is not {@code NULL}, {@code pMessage} <b>must</b> be a null-terminated UTF-8 string</li>
            <li>If {@code queueLabelCount} is not 0, {@code pQueueLabels} <b>must</b> be a valid pointer to an array of {@code queueLabelCount} valid ##VkDebugUtilsLabelEXT structures</li>
            <li>If {@code cmdBufLabelCount} is not 0, {@code pCmdBufLabels} <b>must</b> be a valid pointer to an array of {@code cmdBufLabelCount} valid ##VkDebugUtilsLabelEXT structures</li>
            <li>If {@code objectCount} is not 0, {@code pObjects} <b>must</b> be a valid pointer to an array of {@code objectCount} valid ##VkDebugUtilsObjectNameInfoEXT structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkDebugUtilsMessengerCallbackEXT, ##VkDebugUtilsLabelEXT, ##VkDebugUtilsObjectNameInfoEXT, #SubmitDebugUtilsMessageEXT()
        """

    Expression("#STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkDeviceAddressBindingCallbackDataEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDebugUtilsMessengerCallbackDataFlagsEXT("flags", "0 and is reserved for future use.")
    nullable..charUTF8.const.p("pMessageIdName", "{@code NULL} or a null-terminated UTF-8 string that identifies the particular message ID that is associated with the provided message. If the message corresponds to a validation layer message, then this string may contain the portion of the Vulkan specification that is believed to have been violated.")
    int32_t("messageIdNumber", "the ID number of the triggering message. If the message corresponds to a validation layer message, then this number is related to the internal number associated with the message being triggered.")
    nullable..charUTF8.const.p("pMessage", "{@code NULL} if {@code messageTypes} is equal to #DEBUG_UTILS_MESSAGE_TYPE_DEVICE_ADDRESS_BINDING_BIT_EXT, or a null-terminated UTF-8 string detailing the trigger conditions.")
    AutoSize("pQueueLabels", optional = true)..uint32_t("queueLabelCount", "a count of items contained in the {@code pQueueLabels} array.")
    VkDebugUtilsLabelEXT.const.p("pQueueLabels", "{@code NULL} or a pointer to an array of ##VkDebugUtilsLabelEXT active in the current {@code VkQueue} at the time the callback was triggered. Refer to <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#debugging-queue-labels\">Queue Labels</a> for more information.")
    AutoSize("pCmdBufLabels", optional = true)..uint32_t("cmdBufLabelCount", "a count of items contained in the {@code pCmdBufLabels} array.")
    VkDebugUtilsLabelEXT.const.p("pCmdBufLabels", "{@code NULL} or a pointer to an array of ##VkDebugUtilsLabelEXT active in the current {@code VkCommandBuffer} at the time the callback was triggered. Refer to <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#debugging-command-buffer-labels\">Command Buffer Labels</a> for more information.")
    AutoSize("pObjects", optional = true)..uint32_t("objectCount", "a count of items contained in the {@code pObjects} array.")
    VkDebugUtilsObjectNameInfoEXT.const.p("pObjects", "a pointer to an array of ##VkDebugUtilsObjectNameInfoEXT objects related to the detected issue. The array is roughly in order or importance, but the 0th element is always guaranteed to be the most important object for this message.")
}

val VkDebugUtilsMessengerCreateInfoEXT = struct(Module.VULKAN, "VkDebugUtilsMessengerCreateInfoEXT") {
    documentation =
        """
        Structure specifying parameters of a newly created debug messenger.

        <h5>Description</h5>
        For each {@code VkDebugUtilsMessengerEXT} that is created the ##VkDebugUtilsMessengerCreateInfoEXT{@code ::messageSeverity} and ##VkDebugUtilsMessengerCreateInfoEXT{@code ::messageType} determine when that ##VkDebugUtilsMessengerCreateInfoEXT{@code ::pfnUserCallback} is called. The process to determine if the user’s {@code pfnUserCallback} is triggered when an event occurs is as follows:

        <ul>
            <li>
                The implementation will perform a bitwise AND of the event’s {@code VkDebugUtilsMessageSeverityFlagBitsEXT} with the {@code messageSeverity} provided during creation of the {@code VkDebugUtilsMessengerEXT} object.
                <ul>
                    <li>If the value is 0, the message is skipped.</li>
                </ul>
            </li>
            <li>
                The implementation will perform bitwise AND of the event’s {@code VkDebugUtilsMessageTypeFlagBitsEXT} with the {@code messageType} provided during the creation of the {@code VkDebugUtilsMessengerEXT} object.
                <ul>
                    <li>If the value is 0, the message is skipped.</li>
                </ul>
            </li>
            <li>The callback will trigger a debug message for the current event</li>
        </ul>

        The callback will come directly from the component that detected the event, unless some other layer intercepts the calls for its own purposes (filter them in a different way, log to a system error log, etc.).

        An application <b>can</b> receive multiple callbacks if multiple {@code VkDebugUtilsMessengerEXT} objects are created. A callback will always be executed in the same thread as the originating Vulkan call.

        A callback <b>can</b> be called from multiple threads simultaneously (if the application is making Vulkan calls from multiple threads).

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code messageSeverity} <b>must</b> be a valid combination of {@code VkDebugUtilsMessageSeverityFlagBitsEXT} values</li>
            <li>{@code messageSeverity} <b>must</b> not be 0</li>
            <li>{@code messageType} <b>must</b> be a valid combination of {@code VkDebugUtilsMessageTypeFlagBitsEXT} values</li>
            <li>{@code messageType} <b>must</b> not be 0</li>
            <li>{@code pfnUserCallback} <b>must</b> be a valid ##VkDebugUtilsMessengerCallbackEXT value</li>
        </ul>

        <h5>See Also</h5>
        ##VkDebugUtilsMessengerCallbackEXT, #CreateDebugUtilsMessengerEXT()
        """

    Expression("#STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDebugUtilsMessengerCreateFlagsEXT("flags", "0 and is reserved for future use.")
    VkDebugUtilsMessageSeverityFlagsEXT("messageSeverity", "a bitmask of {@code VkDebugUtilsMessageSeverityFlagBitsEXT} specifying which severity of event(s) will cause this callback to be called.")
    VkDebugUtilsMessageTypeFlagsEXT("messageType", "a bitmask of {@code VkDebugUtilsMessageTypeFlagBitsEXT} specifying which type of event(s) will cause this callback to be called.")
    PFN_vkDebugUtilsMessengerCallbackEXT("pfnUserCallback", "the application callback function to call.")
    nullable..opaque_p("pUserData", "user data to be passed to the callback.")
}

val VkDebugUtilsObjectTagInfoEXT = struct(Module.VULKAN, "VkDebugUtilsObjectTagInfoEXT") {
    documentation =
        """
        Specify parameters of a tag to attach to an object.

        <h5>Description</h5>
        The {@code tagName} parameter gives a name or identifier to the type of data being tagged. This can be used by debugging layers to easily filter for only data that can be used by that implementation.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code objectType} <b>must</b> not be #OBJECT_TYPE_UNKNOWN</li>
            <li>{@code objectHandle} <b>must</b> be a valid Vulkan handle of the type associated with {@code objectType} as defined in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#debugging-object-types">{@code VkObjectType} and Vulkan Handle Relationship</a> table</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code objectType} <b>must</b> be a valid {@code VkObjectType} value</li>
            <li>{@code pTag} <b>must</b> be a valid pointer to an array of {@code tagSize} bytes</li>
            <li>{@code tagSize} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        #SetDebugUtilsObjectTagEXT()
        """

    Expression("#STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkObjectType("objectType", "a {@code VkObjectType} specifying the type of the object to be named.")
    uint64_t("objectHandle", "the object to be tagged.")
    uint64_t("tagName", "a numerical identifier of the tag.")
    AutoSize("pTag")..size_t("tagSize", "the number of bytes of data to attach to the object.")
    void.const.p("pTag", "a pointer to an array of {@code tagSize} bytes containing the data to be associated with the object.")
}

val VkAndroidHardwareBufferUsageANDROID = struct(Module.VULKAN, "VkAndroidHardwareBufferUsageANDROID", mutable = false) {
    documentation =
        """
        Struct containing Android hardware buffer usage flags.

        <h5>Description</h5>
        The {@code androidHardwareBufferUsage} field <b>must</b> include Android hardware buffer usage flags listed in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-external-android-hardware-buffer-usage">AHardwareBuffer Usage Equivalence</a> table when the corresponding Vulkan image usage or image creation flags are included in the {@code usage} or {@code flags} fields of ##VkPhysicalDeviceImageFormatInfo2. It <b>must</b> include at least one GPU usage flag ({@code AHARDWAREBUFFER_USAGE_GPU_*}), even if none of the corresponding Vulkan usages or flags are requested.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Requiring at least one GPU usage flag ensures that Android hardware buffer memory will be allocated in a memory pool accessible to the Vulkan implementation, and that specializing the memory layout based on usage flags does not prevent it from being compatible with Vulkan. Implementations <b>may</b> avoid unnecessary restrictions caused by this requirement by using vendor usage flags to indicate that only the Vulkan uses indicated in ##VkImageFormatProperties2 are required.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint64_t("androidHardwareBufferUsage", "returns the Android hardware buffer usage flags.")
}

val VkAndroidHardwareBufferPropertiesANDROID = struct(Module.VULKAN, "VkAndroidHardwareBufferPropertiesANDROID", mutable = false) {
    documentation =
        """
        Properties of External Memory Android Hardware Buffers.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkAndroidHardwareBufferFormatProperties2ANDROID, ##VkAndroidHardwareBufferFormatPropertiesANDROID, or ##VkAndroidHardwareBufferFormatResolvePropertiesANDROID</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
        </ul>

        <h5>See Also</h5>
        #GetAndroidHardwareBufferPropertiesANDROID()
        """

    Expression("#STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    PointerSetter(
        "VkAndroidHardwareBufferFormatProperties2ANDROID", "VkAndroidHardwareBufferFormatPropertiesANDROID", "VkAndroidHardwareBufferFormatResolvePropertiesANDROID",
        prepend = true
    )..nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkDeviceSize("allocationSize", "the size of the external memory")
    uint32_t("memoryTypeBits", "a bitmask containing one bit set for every memory type which the specified Android hardware buffer <b>can</b> be imported as.")
}

val VkAndroidHardwareBufferFormatPropertiesANDROID = struct(Module.VULKAN, "VkAndroidHardwareBufferFormatPropertiesANDROID", mutable = false) {
    documentation =
        """
        Structure describing the image format properties of an Android hardware buffer.

        <h5>Description</h5>
        If the Android hardware buffer has one of the formats listed in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-external-android-hardware-buffer-formats">Format Equivalence table</a>, then {@code format} <b>must</b> have the equivalent Vulkan format listed in the table. Otherwise, {@code format} <b>may</b> be #FORMAT_UNDEFINED, indicating the Android hardware buffer <b>can</b> only be used with an external format.

        The {@code formatFeatures} member <b>must</b> include #FORMAT_FEATURE_SAMPLED_IMAGE_BIT and at least one of #FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT or #FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT, and <b>should</b> include #FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT and #FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The {@code formatFeatures} member only indicates the features available when using an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-external-android-hardware-buffer-external-formats">external-format image</a> created from the Android hardware buffer. Images from Android hardware buffers with a format other than #FORMAT_UNDEFINED are subject to the format capabilities obtained from #GetPhysicalDeviceFormatProperties2(), and #GetPhysicalDeviceImageFormatProperties2() with appropriate parameters. These sets of features are independent of each other, e.g. the external format will support sampler Y′C<sub>B</sub>C<sub>R</sub> conversion even if the non-external format does not, and rendering directly to the external format will not be supported even if the non-external format does support this.
        </div>

        Android hardware buffers with the same external format <b>must</b> have the same support for #FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT, #FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT, #FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT, #FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT, #FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT, and #FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT. in {@code formatFeatures}. Other format features <b>may</b> differ between Android hardware buffers that have the same external format. This allows applications to use the same {@code VkSamplerYcbcrConversion} object (and samplers and pipelines created from them) for any Android hardware buffers that have the same external format.

        If {@code format} is not #FORMAT_UNDEFINED, then the value of {@code samplerYcbcrConversionComponents} <b>must</b> be valid when used as the {@code components} member of ##VkSamplerYcbcrConversionCreateInfo with that format. If {@code format} is #FORMAT_UNDEFINED, all members of {@code samplerYcbcrConversionComponents} <b>must</b> be the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-image-views-identity-mappings">identity swizzle</a>.

        Implementations <b>may</b> not always be able to determine the color model, numerical range, or chroma offsets of the image contents, so the values in ##VkAndroidHardwareBufferFormatPropertiesANDROID are only suggestions. Applications <b>should</b> treat these values as sensible defaults to use in the absence of more reliable information obtained through some other means. If the underlying physical device is also usable via OpenGL ES with the <a href="https://registry.khronos.org/OpenGL/extensions/OES/OES_EGL_image_external.txt">{@code GL_OES_EGL_image_external}</a> extension, the implementation <b>should</b> suggest values that will produce similar sampled values as would be obtained by sampling the same external image via {@code samplerExternalOES} in OpenGL ES using equivalent sampler parameters.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Since <a href="https://registry.khronos.org/OpenGL/extensions/OES/OES_EGL_image_external.txt">{@code GL_OES_EGL_image_external}</a> does not require the same sampling and conversion calculations as Vulkan does, achieving identical results between APIs <b>may</b> not be possible on some implementations.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID</li>
        </ul>

        <h5>See Also</h5>
        ##VkComponentMapping
        """

    Expression("#STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkFormat("format", "the Vulkan format corresponding to the Android hardware buffer’s format, or #FORMAT_UNDEFINED if there is not an equivalent Vulkan format.")
    uint64_t("externalFormat", "an implementation-defined external format identifier for use with ##VkExternalFormatANDROID. It <b>must</b> not be zero.")
    VkFormatFeatureFlags("formatFeatures", "describes the capabilities of this external format when used with an image bound to memory imported from {@code buffer}.")
    VkComponentMapping("samplerYcbcrConversionComponents", "the component swizzle that <b>should</b> be used in ##VkSamplerYcbcrConversionCreateInfo.")
    VkSamplerYcbcrModelConversion("suggestedYcbcrModel", "a suggested color model to use in the ##VkSamplerYcbcrConversionCreateInfo.")
    VkSamplerYcbcrRange("suggestedYcbcrRange", "a suggested numerical value range to use in ##VkSamplerYcbcrConversionCreateInfo.")
    VkChromaLocation("suggestedXChromaOffset", "a suggested X chroma offset to use in ##VkSamplerYcbcrConversionCreateInfo.")
    VkChromaLocation("suggestedYChromaOffset", "a suggested Y chroma offset to use in ##VkSamplerYcbcrConversionCreateInfo.")
}

val VkImportAndroidHardwareBufferInfoANDROID = struct(Module.VULKAN, "VkImportAndroidHardwareBufferInfoANDROID") {
    documentation =
        """
        Import memory from an Android hardware buffer.

        <h5>Description</h5>
        If the #AllocateMemory() command succeeds, the implementation <b>must</b> acquire a reference to the imported hardware buffer, which it <b>must</b> release when the device memory object is freed. If the command fails, the implementation <b>must</b> not retain a reference.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code buffer} is not {@code NULL}, Android hardware buffers <b>must</b> be supported for import, as reported by ##VkExternalImageFormatProperties or ##VkExternalBufferProperties</li>
            <li>If {@code buffer} is not {@code NULL}, it <b>must</b> be a valid Android hardware buffer object with {@code AHardwareBuffer_Desc}{@code ::usage} compatible with Vulkan as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-external-android-hardware-buffer">Android Hardware Buffers</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID</li>
            <li>{@code buffer} <b>must</b> be a valid pointer to an {@code AHardwareBuffer} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AHardwareBuffer.p("buffer", "the Android hardware buffer to import.")
}

val VkMemoryGetAndroidHardwareBufferInfoANDROID = struct(Module.VULKAN, "VkMemoryGetAndroidHardwareBufferInfoANDROID") {
    documentation =
        """
        Structure describing an Android hardware buffer memory export operation.

        <h5>Valid Usage</h5>
        <ul>
            <li>#EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID <b>must</b> have been included in ##VkExportMemoryAllocateInfo{@code ::handleTypes} when {@code memory} was created</li>
            <li>If the {@code pNext} chain of the ##VkMemoryAllocateInfo used to allocate {@code memory} included a ##VkMemoryDedicatedAllocateInfo with non-{@code NULL} {@code image} member, then that {@code image} <b>must</b> already be bound to {@code memory}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
        </ul>

        <h5>See Also</h5>
        #GetMemoryAndroidHardwareBufferANDROID()
        """

    Expression("#STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceMemory("memory", "the memory object from which the Android hardware buffer will be exported.")
}

val VkExternalFormatANDROID = struct(Module.VULKAN, "VkExternalFormatANDROID") {
    documentation =
        """
        Structure containing an Android hardware buffer external format.

        <h5>Description</h5>
        When included in the {@code pNext} chain of another structure, it indicates <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-external-android-hardware-buffer-external-formats">additional format information</a> beyond what is provided by {@code VkFormat} values for an Android hardware buffer. If {@code externalFormat} is zero, it indicates that no external format is used, and implementations should rely only on other format information. If this structure is not present, it is equivalent to setting {@code externalFormat} to zero.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code externalFormat} <b>must</b> be 0 or a value returned in the {@code externalFormat} member of ##VkAndroidHardwareBufferFormatPropertiesANDROID by an earlier call to #GetAndroidHardwareBufferPropertiesANDROID()</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint64_t("externalFormat", "an implementation-defined identifier for the external format")
}

val VkAndroidHardwareBufferFormatProperties2ANDROID = struct(Module.VULKAN, "VkAndroidHardwareBufferFormatProperties2ANDROID", mutable = false) {
    documentation =
        """
        Structure describing the image format properties of an Android hardware buffer.

        <h5>Description</h5>
        The bits reported in {@code formatFeatures} <b>must</b> include the bits reported in the corresponding fields of ##VkAndroidHardwareBufferFormatPropertiesANDROID{@code ::formatFeatures}.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID</li>
        </ul>

        <h5>See Also</h5>
        ##VkComponentMapping
        """

    Expression("#STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkFormat("format", "the Vulkan format corresponding to the Android hardware buffer’s format, or #FORMAT_UNDEFINED if there is not an equivalent Vulkan format.")
    uint64_t("externalFormat", "an implementation-defined external format identifier for use with ##VkExternalFormatANDROID. It <b>must</b> not be zero.")
    VkFormatFeatureFlags2("formatFeatures", "describes the capabilities of this external format when used with an image bound to memory imported from {@code buffer}.")
    VkComponentMapping("samplerYcbcrConversionComponents", "the component swizzle that <b>should</b> be used in ##VkSamplerYcbcrConversionCreateInfo.")
    VkSamplerYcbcrModelConversion("suggestedYcbcrModel", "a suggested color model to use in the ##VkSamplerYcbcrConversionCreateInfo.")
    VkSamplerYcbcrRange("suggestedYcbcrRange", "a suggested numerical value range to use in ##VkSamplerYcbcrConversionCreateInfo.")
    VkChromaLocation("suggestedXChromaOffset", "a suggested X chroma offset to use in ##VkSamplerYcbcrConversionCreateInfo.")
    VkChromaLocation("suggestedYChromaOffset", "a suggested Y chroma offset to use in ##VkSamplerYcbcrConversionCreateInfo.")
}

val VkSamplerReductionModeCreateInfoEXT = struct(Module.VULKAN, "VkSamplerReductionModeCreateInfoEXT", alias = VkSamplerReductionModeCreateInfo) {
    documentation = "See ##VkSamplerReductionModeCreateInfo."

    Expression("#STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkSamplerReductionMode("reductionMode", "")
}

val VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT", mutable = false, alias = VkPhysicalDeviceSamplerFilterMinmaxProperties) {
    documentation = "See ##VkPhysicalDeviceSamplerFilterMinmaxProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkBool32("filterMinmaxSingleComponentFormats", "")
    VkBool32("filterMinmaxImageComponentMapping", "")
}

val VkPhysicalDeviceShaderEnqueueFeaturesAMDX = struct(Module.VULKAN, "VkPhysicalDeviceShaderEnqueueFeaturesAMDX") {
    documentation =
        """
        Structure describing whether shader enqueue within execution graphs are supported by the implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceShaderEnqueueFeaturesAMDX structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceShaderEnqueueFeaturesAMDX <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_FEATURES_AMDX</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_FEATURES_AMDX")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("shaderEnqueue", "indicates whether the implementation supports <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#executiongraphs\">execution graphs</a>.")
    VkBool32("shaderMeshEnqueue", "indicates whether the implementation supports <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#executiongraphs-meshnodes\">mesh nodes in execution graphs</a>.")
}

val VkPhysicalDeviceShaderEnqueuePropertiesAMDX = struct(Module.VULKAN, "VkPhysicalDeviceShaderEnqueuePropertiesAMDX") {
    documentation =
        """
        Structure describing shader enqueue limits of an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceShaderEnqueuePropertiesAMDX structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_PROPERTIES_AMDX</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_PROPERTIES_AMDX")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("maxExecutionGraphDepth", "defines the maximum node chain depth in the graph. The dispatched node is at depth 1 and the node enqueued by it is at depth 2, and so on. If a node enqueues itself, each recursive enqueue increases the depth by 1 as well.")
    uint32_t("maxExecutionGraphShaderOutputNodes", "specifies the maximum number of unique nodes that can be dispatched from a single shader, and <b>must</b> be at least 256.")
    uint32_t("maxExecutionGraphShaderPayloadSize", "specifies the maximum total size of payload declarations in a shader. For any payload declarations that share resources, indicated by {@code NodeSharesPayloadLimitsWithAMDX} decorations, the maximum size of each set of shared payload declarations is taken. The sum of each shared set’s maximum size and the size of each unshared payload is counted against this limit.")
    uint32_t("maxExecutionGraphShaderPayloadCount", "specifies the maximum number of output payloads that can be initialized in a single workgroup.")
    uint32_t("executionGraphDispatchAddressAlignment", "specifies the alignment of non-scratch {@code VkDeviceAddress} arguments consumed by graph dispatch commands.")
    uint32_t("maxExecutionGraphWorkgroupCount", "the maximum number of local workgroups that a shader <b>can</b> be dispatched with in X, Y, and Z dimensions, respectively.")[3]
    uint32_t("maxExecutionGraphWorkgroups", "the total number of local workgroups that a shader <b>can</b> be dispatched with.")
}

val VkExecutionGraphPipelineScratchSizeAMDX = struct(Module.VULKAN, "VkExecutionGraphPipelineScratchSizeAMDX") {
    documentation =
        """
        Structure describing the scratch space required to dispatch an execution graph.

        <h5>Description</h5>
        Applications <b>can</b> use any amount of scratch memory greater than {@code minSize} for dispatching a graph, however only the values equal to {@code minSize} + an integer multiple of {@code sizeGranularity} will be used. Greater values <b>may</b> result in higher performance, up to {@code maxSize} which indicates the most memory that an implementation can use effectively.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX</li>
        </ul>

        <h5>See Also</h5>
        #GetExecutionGraphPipelineScratchSizeAMDX()
        """

    Expression("#STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceSize("minSize", "indicates the minimum scratch space required for dispatching the queried execution graph.")
    VkDeviceSize("maxSize", "indicates the maximum scratch space that can be used for dispatching the queried execution graph.")
    VkDeviceSize("sizeGranularity", "indicates the granularity at which the scratch space can be increased from {@code minSize}.")
}

val VkPipelineLibraryCreateInfoKHR = struct(Module.VULKAN, "VkPipelineLibraryCreateInfoKHR") {
    documentation =
        """
        Structure specifying pipeline libraries to use when creating a pipeline.

        <h5>Valid Usage</h5>
        <ul>
            <li>Each element of {@code pLibraries} <b>must</b> have been created with #PIPELINE_CREATE_LIBRARY_BIT_KHR</li>
            <li>If any library in {@code pLibraries} was created with a shader stage with ##VkPipelineShaderStageModuleIdentifierCreateInfoEXT and {@code identifierSize} not equal to 0, the pipeline <b>must</b> be created with the #PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT flag set</li>
            <li>If any element of {@code pLibraries} was created with #PIPELINE_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, all elements <b>must</b> have been created with #PIPELINE_CREATE_DESCRIPTOR_BUFFER_BIT_EXT</li>
            <li>If {@code pipeline} is being created with #PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT, every element of {@code pLibraries} <b>must</b> have been created with #PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT</li>
            <li>If {@code pipeline} is being created without #PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT, every element of {@code pLibraries} <b>must</b> have been created without #PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT</li>
            <li>If {@code pipeline} is being created with #PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT, every element of {@code pLibraries} <b>must</b> have been created with #PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT</li>
            <li>If {@code pipeline} is being created without #PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT, every element of {@code pLibraries} <b>must</b> have been created without #PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR</li>
            <li>If {@code libraryCount} is not 0, {@code pLibraries} <b>must</b> be a valid pointer to an array of {@code libraryCount} valid {@code VkPipeline} handles</li>
        </ul>

        <h5>See Also</h5>
        ##VkExecutionGraphPipelineCreateInfoAMDX, ##VkRayTracingPipelineCreateInfoKHR
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pLibraries", optional = true)..uint32_t("libraryCount", "the number of pipeline libraries in {@code pLibraries}.")
    VkPipeline.const.p("pLibraries", "a pointer to an array of {@code VkPipeline} structures specifying pipeline libraries to use when creating a pipeline.")
}

val VkExecutionGraphPipelineCreateInfoAMDX = struct(Module.VULKAN, "VkExecutionGraphPipelineCreateInfoAMDX") {
    documentation =
        """
        Structure specifying parameters of a newly created execution graph pipeline.

        <h5>Description</h5>
        The parameters {@code basePipelineHandle} and {@code basePipelineIndex} are described in more detail in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pipeline-derivatives">Pipeline Derivatives</a>.

        Each shader stage provided when creating an execution graph pipeline (including those in libraries) is associated with a name and an index, determined by the inclusion or omission of a ##VkPipelineShaderStageNodeCreateInfoAMDX structure in its {@code pNext} chain. For any graphics pipeline libraries, only the name and index of the vertex or mesh shader stage is linked directly to the graph as a node - other shader stages in the pipeline will be executed after those shader stages as normal. Task shaders cannot be included in a graphics pipeline used for a draw node.

        In addition to the shader name and index, an internal "node index" is also generated for each node, which can be queried with #GetExecutionGraphPipelineNodeIndexAMDX(), and is used exclusively for initial dispatch of an execution graph.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain does not include a ##VkPipelineCreateFlags2CreateInfo structure, {@code flags} <b>must</b> be a valid combination of {@code VkPipelineCreateFlagBits} values</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineIndex} is -1, {@code basePipelineHandle} <b>must</b> be a valid execution graph {@code VkPipeline} handle</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineHandle} is #NULL_HANDLE, {@code basePipelineIndex} <b>must</b> be a valid index into the calling command’s {@code pCreateInfos} parameter</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, {@code basePipelineIndex} <b>must</b> be -1 or {@code basePipelineHandle} <b>must</b> be #NULL_HANDLE</li>
            <li>If a push constant block is declared in a shader, a push constant range in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a push constant block is declared in a shader, the block must be contained inside the push constant range in {@code layout} that matches the stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, the corresponding descriptor set in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, and the descriptor type is not #DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor type</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader as an array, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor count</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variables</a> is declared in a shader as an array of descriptors, then the descriptor type of that variable <b>must</b> not be #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK</li>
        </ul>

        <ul>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-deviceGeneratedComputePipelines">##VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV{@code ::deviceGeneratedComputePipelines}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the {@code pNext} chain <b>must</b> include a pointer to a valid instance of ##VkComputePipelineIndirectBufferInfoNV specifying the address where the pipeline’s metadata will be saved</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-deviceGeneratedCommands">##VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT{@code ::deviceGeneratedCommands}</a> feature <b>must</b> be enabled</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineCreationCacheControl">{@code pipelineCreationCacheControl}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or #PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT</li>
            <li>The {@code stage} member of any element of {@code pStages} <b>must</b> be #SHADER_STAGE_COMPUTE_BIT</li>
            <li>The shader code for the entry point identified by each element of {@code pStages} and the rest of the state identified by this structure <b>must</b> adhere to the pipeline linking rules described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces">Shader Interfaces</a> chapter</li>
            <li>{@code layout} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#descriptorsets-pipelinelayout-consistency">consistent</a> with the layout of the shaders specified in {@code pStages}</li>
            <li>If {@code pLibraryInfo} is not {@code NULL}, each element of its {@code pLibraries} member <b>must</b> have been created with a {@code layout} that is compatible with the {@code layout} in this pipeline</li>
            <li>The number of resources in {@code layout} accessible to each shader stage that is used by the pipeline <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageResources}</li>
            <li>If {@code pLibraryInfo} is not {@code NULL}, each element of {@code pLibraryInfo→pLibraries} <b>must</b> be either a compute pipeline, an execution graph pipeline, or a graphics pipeline</li>
            <li>If {@code pLibraryInfo} is not {@code NULL}, each element of {@code pLibraryInfo→pLibraries} that is a compute pipeline or a graphics pipeline <b>must</b> have been created with #PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX set</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-shaderMeshEnqueue">{@code shaderMeshEnqueue}</a> feature is not enabled, and {@code pLibraryInfo→pLibraries} is not {@code NULL}, {@code pLibraryInfo→pLibraries} <b>must</b> not contain any graphics pipelines</li>
            <li>Any element of {@code pLibraryInfo→pLibraries} identifying a graphics pipeline <b>must</b> have been created with <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-graphics-subsets-complete">all possible state subsets</a></li>
            <li>There <b>must</b> be no two nodes in the pipeline that share both the same shader name and index, as specified by ##VkPipelineShaderStageNodeCreateInfoAMDX</li>
            <li>There <b>must</b> be no two nodes in the pipeline that share the same shader name and have input payload declarations with different sizes</li>
            <li>There <b>must</b> be no two nodes in the pipeline that share the same name but have different execution models</li>
            <li>There <b>must</b> be no two nodes in the pipeline that share the same name where one includes {@code CoalescedInputCountAMDX} and the other does not</li>
            <li>There <b>must</b> be no two nodes in the pipeline that share the same name where one includes {@code StaticNumWorkgroupsAMDX} and the other does not</li>
            <li>If an output payload declared in any shader in the pipeline has a {@code PayloadNodeNameAMDX} decoration with a {@code Node} {@code Name} that matches the shader name of any other node in the graph, the size of the output payload <b>must</b> match the size of the input payload in the matching node</li>
            <li>If {@code flags} does not include #PIPELINE_CREATE_LIBRARY_BIT_KHR, and an output payload declared in any shader in the pipeline does not have a {@code PayloadNodeSparseArrayAMDX} decoration, there <b>must</b> be a node in the graph corresponding to every index from 0 to its {@code PayloadNodeArraySizeAMDX} decoration</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkPipelineCompilerControlCreateInfoAMD or ##VkPipelineCreationFeedbackCreateInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>If {@code stageCount} is not 0, and {@code pStages} is not {@code NULL}, {@code pStages} <b>must</b> be a valid pointer to an array of {@code stageCount} valid ##VkPipelineShaderStageCreateInfo structures</li>
            <li>If {@code pLibraryInfo} is not {@code NULL}, {@code pLibraryInfo} <b>must</b> be a valid pointer to a valid ##VkPipelineLibraryCreateInfoKHR structure</li>
            <li>{@code layout} <b>must</b> be a valid {@code VkPipelineLayout} handle</li>
            <li>Both of {@code basePipelineHandle}, and {@code layout} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineLibraryCreateInfoKHR, ##VkPipelineShaderStageCreateInfo, #CreateExecutionGraphPipelinesAMDX()
        """

    Expression("#STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkPipelineCompilerControlCreateInfoAMD", "VkPipelineCreationFeedbackCreateInfo", "VkPipelineCreationFeedbackCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCreateFlags("flags", "a bitmask of {@code VkPipelineCreateFlagBits} specifying how the pipeline will be generated.")
    AutoSize("pStages", optional = true)..uint32_t("stageCount", "the number of entries in the {@code pStages} array.")
    nullable..VkPipelineShaderStageCreateInfo.const.p("pStages", "a pointer to an array of {@code stageCount} ##VkPipelineShaderStageCreateInfo structures describing the set of the shader stages to be included in the execution graph pipeline.")
    nullable..VkPipelineLibraryCreateInfoKHR.const.p("pLibraryInfo", "a pointer to a ##VkPipelineLibraryCreateInfoKHR structure defining pipeline libraries to include.")
    VkPipelineLayout("layout", "the description of binding locations used by both the pipeline and descriptor sets used with the pipeline.")
    VkPipeline("basePipelineHandle", "a pipeline to derive from")
    int32_t("basePipelineIndex", "an index into the {@code pCreateInfos} parameter to use as a pipeline to derive from")
}

val VkDeviceOrHostAddressConstAMDX = union(Module.VULKAN, "VkDeviceOrHostAddressConstAMDX") {
    documentation =
        """
        Union specifying a const device or host address.

        <h5>See Also</h5>
        ##VkDispatchGraphCountInfoAMDX, ##VkDispatchGraphInfoAMDX
        """

    VkDeviceAddress("deviceAddress", "a buffer device address as returned by the #GetBufferDeviceAddressKHR() command.")
    nullable..opaque_const_p("hostAddress", "a const host memory address.")
}

val VkDispatchGraphInfoAMDX = struct(Module.VULKAN, "VkDispatchGraphInfoAMDX") {
    documentation =
        """
        Structure specifying node parameters for execution graph dispatch.

        <h5>Description</h5>
        Whether {@code payloads} is consumed as a device or host pointer is defined by the command this structure is used in.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code payloadCount} <b>must</b> be no greater than <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxExecutionGraphShaderPayloadCount">{@code maxExecutionGraphShaderPayloadCount}</a></li>
        </ul>

        <h5>See Also</h5>
        ##VkDeviceOrHostAddressConstAMDX, ##VkDispatchGraphCountInfoAMDX
        """

    uint32_t("nodeIndex", "the index of a node in an execution graph to be dispatched.")
    uint32_t("payloadCount", "the number of payloads to dispatch for the specified node.")
    VkDeviceOrHostAddressConstAMDX("payloads", "a device or host address pointer to a flat array of payloads with size equal to the product of {@code payloadCount} and {@code payloadStride}")
    uint64_t("payloadStride", "the byte stride between successive payloads in {@code payloads}")
}

val VkDispatchGraphCountInfoAMDX = struct(Module.VULKAN, "VkDispatchGraphCountInfoAMDX") {
    documentation =
        """
        Structure specifying count parameters for execution graph dispatch.

        <h5>Description</h5>
        Whether {@code infos} is consumed as a device or host pointer is defined by the command this structure is used in.

        <h5>See Also</h5>
        ##VkDeviceOrHostAddressConstAMDX, #CmdDispatchGraphAMDX(), #CmdDispatchGraphIndirectAMDX(), #CmdDispatchGraphIndirectCountAMDX()
        """

    uint32_t("count", "the number of dispatches to perform.")
    VkDeviceOrHostAddressConstAMDX("infos", "the device or host address of a flat array of ##VkDispatchGraphInfoAMDX structures")
    uint64_t("stride", "the byte stride between successive ##VkDispatchGraphInfoAMDX structures in {@code infos}")
}

val VkPipelineShaderStageNodeCreateInfoAMDX = struct(Module.VULKAN, "VkPipelineShaderStageNodeCreateInfoAMDX") {
    documentation =
        """
        Structure specifying the shader name and index with an execution graph.

        <h5>Description</h5>
        When included in the {@code pNext} chain of a ##VkPipelineShaderStageCreateInfo structure, this structure specifies the shader name and shader index of a node when creating an execution graph pipeline. If this structure is omitted, the shader name is set to the name of the entry point in SPIR-V and the shader index is set to 0.

        When dispatching a node from another shader, the name is fixed at pipeline creation, but the index <b>can</b> be set dynamically. By associating multiple shaders with the same name but different indexes, applications can dynamically select different nodes to execute. Applications <b>must</b> ensure each node has a unique name and index.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Shaders with the same name <b>must</b> be of the same type - e.g. a compute and graphics shader, or even two compute shaders where one is coalescing and the other is not, cannot share the same name.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_NODE_CREATE_INFO_AMDX</li>
            <li>If {@code pName} is not {@code NULL}, {@code pName} <b>must</b> be a null-terminated UTF-8 string</li>
        </ul>

        <h5>See Also</h5>
        #GetExecutionGraphPipelineNodeIndexAMDX()
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_NODE_CREATE_INFO_AMDX")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    nullable..charUTF8.const.p("pName", "the shader name to use when creating a node in an execution graph. If {@code pName} is {@code NULL}, the name of the entry point specified in SPIR-V is used as the shader name.")
    uint32_t("index", "the shader index to use when creating a node in an execution graph. If {@code index} is #SHADER_INDEX_UNUSED_AMDX then the original index is used, either as specified by the {@code ShaderIndexAMDX} execution mode, or 0 if that too is not specified.")
}

val VkAttachmentSampleCountInfoAMD = struct(Module.VULKAN, "VkAttachmentSampleCountInfoAMD") {
    documentation =
        """
        Structure specifying command buffer inheritance info for dynamic render pass instances.

        <h5>Description</h5>
        If ##VkCommandBufferInheritanceInfo{@code ::renderPass} is #NULL_HANDLE, #COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT is specified in ##VkCommandBufferBeginInfo{@code ::flags}, and the {@code pNext} chain of ##VkCommandBufferInheritanceInfo includes ##VkAttachmentSampleCountInfoAMD, then this structure defines the sample counts of each attachment within the render pass instance. If ##VkAttachmentSampleCountInfoAMD is not included, the value of ##VkCommandBufferInheritanceRenderingInfo{@code ::rasterizationSamples} is used as the sample count for each attachment. If ##VkCommandBufferInheritanceInfo{@code ::renderPass} is not #NULL_HANDLE, or #COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT is not specified in ##VkCommandBufferBeginInfo{@code ::flags}, parameters of this structure are ignored.

        ##VkAttachmentSampleCountInfoAMD <b>can</b> also be included in the {@code pNext} chain of ##VkGraphicsPipelineCreateInfo. When a graphics pipeline is created without a {@code VkRenderPass}, if this structure is included in the {@code pNext} chain of ##VkGraphicsPipelineCreateInfo, it specifies the sample count of attachments used for rendering. If this structure is not specified, and the pipeline does not include a {@code VkRenderPass}, the value of ##VkPipelineMultisampleStateCreateInfo{@code ::rasterizationSamples} is used as the sample count for each attachment. If a graphics pipeline is created with a valid {@code VkRenderPass}, parameters of this structure are ignored.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure")
    AutoSize("pColorAttachmentSamples", optional = true)..uint32_t("colorAttachmentCount", "the number of color attachments specified in a render pass instance.")
    nullable..VkSampleCountFlagBits.const.p("pColorAttachmentSamples", "a pointer to an array of {@code VkSampleCountFlagBits} values defining the sample count of color attachments.")
    VkSampleCountFlagBits("depthStencilAttachmentSamples", "a {@code VkSampleCountFlagBits} value defining the sample count of a depth/stencil attachment.")
}

val VkPhysicalDeviceInlineUniformBlockFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceInlineUniformBlockFeaturesEXT", alias = VkPhysicalDeviceInlineUniformBlockFeatures) {
    documentation = "See ##VkPhysicalDeviceInlineUniformBlockFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("inlineUniformBlock", "")
    VkBool32("descriptorBindingInlineUniformBlockUpdateAfterBind", "")
}

val VkPhysicalDeviceInlineUniformBlockPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceInlineUniformBlockPropertiesEXT", mutable = false, alias = VkPhysicalDeviceInlineUniformBlockProperties) {
    documentation = "See ##VkPhysicalDeviceInlineUniformBlockProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint32_t("maxInlineUniformBlockSize", "")
    uint32_t("maxPerStageDescriptorInlineUniformBlocks", "")
    uint32_t("maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks", "")
    uint32_t("maxDescriptorSetInlineUniformBlocks", "")
    uint32_t("maxDescriptorSetUpdateAfterBindInlineUniformBlocks", "")
}

val VkWriteDescriptorSetInlineUniformBlockEXT = struct(Module.VULKAN, "VkWriteDescriptorSetInlineUniformBlockEXT", alias = VkWriteDescriptorSetInlineUniformBlock) {
    documentation = "See ##VkWriteDescriptorSetInlineUniformBlock."

    Expression("#STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pData")..uint32_t("dataSize", "")
    void.const.p("pData", "")
}

val VkDescriptorPoolInlineUniformBlockCreateInfoEXT = struct(Module.VULKAN, "VkDescriptorPoolInlineUniformBlockCreateInfoEXT", alias = VkDescriptorPoolInlineUniformBlockCreateInfo) {
    documentation = "See ##VkDescriptorPoolInlineUniformBlockCreateInfo."

    Expression("#STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    uint32_t("maxInlineUniformBlockBindings", "")
}

val VkSampleLocationEXT = struct(Module.VULKAN, "VkSampleLocationEXT") {
    documentation =
        """
        Structure specifying the coordinates of a sample location.

        <h5>Description</h5>
        The domain space of the sample location coordinates has an upper-left origin within the pixel in framebuffer space.

        The values specified in a ##VkSampleLocationEXT structure are always clamped to the implementation-dependent sample location coordinate range <code>[sampleLocationCoordinateRange[0],sampleLocationCoordinateRange[1]]</code> that <b>can</b> be queried using ##VkPhysicalDeviceSampleLocationsPropertiesEXT.

        <h5>See Also</h5>
        ##VkSampleLocationsInfoEXT
        """

    float("x", "the horizontal coordinate of the sample’s location.")
    float("y", "the vertical coordinate of the sample’s location.")
}

val VkSampleLocationsInfoEXT = struct(Module.VULKAN, "VkSampleLocationsInfoEXT") {
    documentation =
        """
        Structure specifying a set of sample locations.

        <h5>Description</h5>
        This structure <b>can</b> be used either to specify the sample locations to be used for rendering or to specify the set of sample locations an image subresource has been last rendered with for the purposes of layout transitions of depth/stencil images created with #IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT.

        The sample locations in {@code pSampleLocations} specify {@code sampleLocationsPerPixel} number of sample locations for each pixel in the grid of the size specified in {@code sampleLocationGridSize}. The sample location for sample <code>i</code> at the pixel grid location <code>(x,y)</code> is taken from <code>pSampleLocations[(x + y × sampleLocationGridSize.width) × sampleLocationsPerPixel + i]</code>.

        If the render pass has a fragment density map, the implementation will choose the sample locations for the fragment and the contents of {@code pSampleLocations} <b>may</b> be ignored.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code sampleLocationsPerPixel} <b>must</b> be a valid {@code VkSampleCountFlagBits} value that is set in ##VkPhysicalDeviceSampleLocationsPropertiesEXT{@code ::sampleLocationSampleCounts}</li>
            <li>{@code sampleLocationsCount} <b>must</b> equal <code>sampleLocationsPerPixel × sampleLocationGridSize.width × sampleLocationGridSize.height</code></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT</li>
            <li>If {@code sampleLocationsCount} is not 0, {@code pSampleLocations} <b>must</b> be a valid pointer to an array of {@code sampleLocationsCount} ##VkSampleLocationEXT structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkAttachmentSampleLocationsEXT, ##VkExtent2D, ##VkPipelineSampleLocationsStateCreateInfoEXT, ##VkSampleLocationEXT, ##VkSubpassSampleLocationsEXT, #CmdSetSampleLocationsEXT()
        """

    Expression("#STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkSampleCountFlagBits("sampleLocationsPerPixel", "a {@code VkSampleCountFlagBits} value specifying the number of sample locations per pixel.")
    VkExtent2D("sampleLocationGridSize", "the size of the sample location grid to select custom sample locations for.")
    AutoSize("pSampleLocations", optional = true)..uint32_t("sampleLocationsCount", "the number of sample locations in {@code pSampleLocations}.")
    VkSampleLocationEXT.const.p("pSampleLocations", "a pointer to an array of {@code sampleLocationsCount} ##VkSampleLocationEXT structures.")
}

val VkAttachmentSampleLocationsEXT = struct(Module.VULKAN, "VkAttachmentSampleLocationsEXT") {
    documentation =
        """
        Structure specifying the sample locations state to use in the initial layout transition of attachments.

        <h5>Description</h5>
        If the image referenced by the framebuffer attachment at index {@code attachmentIndex} was not created with #IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT then the values specified in {@code sampleLocationsInfo} are ignored.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code attachmentIndex} <b>must</b> be less than the {@code attachmentCount} specified in ##VkRenderPassCreateInfo the render pass specified by ##VkRenderPassBeginInfo{@code ::renderPass} was created with</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sampleLocationsInfo} <b>must</b> be a valid ##VkSampleLocationsInfoEXT structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkRenderPassSampleLocationsBeginInfoEXT, ##VkSampleLocationsInfoEXT
        """

    uint32_t("attachmentIndex", "the index of the attachment for which the sample locations state is provided.")
    VkSampleLocationsInfoEXT("sampleLocationsInfo", "the sample locations state to use for the layout transition of the given attachment from the initial layout of the attachment to the image layout specified for the attachment in the first subpass using it.")
}

val VkSubpassSampleLocationsEXT = struct(Module.VULKAN, "VkSubpassSampleLocationsEXT") {
    documentation =
        """
        Structure specifying the sample locations state to use for layout transitions of attachments performed after a given subpass.

        <h5>Description</h5>
        If the image referenced by the depth/stencil attachment used in the subpass identified by {@code subpassIndex} was not created with #IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT or if the subpass does not use a depth/stencil attachment, and ##VkPhysicalDeviceSampleLocationsPropertiesEXT{@code ::variableSampleLocations} is #TRUE then the values specified in {@code sampleLocationsInfo} are ignored.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code subpassIndex} <b>must</b> be less than the {@code subpassCount} specified in ##VkRenderPassCreateInfo the render pass specified by ##VkRenderPassBeginInfo{@code ::renderPass} was created with</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sampleLocationsInfo} <b>must</b> be a valid ##VkSampleLocationsInfoEXT structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkRenderPassSampleLocationsBeginInfoEXT, ##VkSampleLocationsInfoEXT
        """

    uint32_t("subpassIndex", "the index of the subpass for which the sample locations state is provided.")
    VkSampleLocationsInfoEXT("sampleLocationsInfo", "the sample locations state to use for the layout transition of the depth/stencil attachment away from the image layout the attachment is used with in the subpass specified in {@code subpassIndex}.")
}

val VkRenderPassSampleLocationsBeginInfoEXT = struct(Module.VULKAN, "VkRenderPassSampleLocationsBeginInfoEXT") {
    documentation =
        """
        Structure specifying sample locations to use for the layout transition of custom sample locations compatible depth/stencil attachments.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT</li>
            <li>If {@code attachmentInitialSampleLocationsCount} is not 0, {@code pAttachmentInitialSampleLocations} <b>must</b> be a valid pointer to an array of {@code attachmentInitialSampleLocationsCount} valid ##VkAttachmentSampleLocationsEXT structures</li>
            <li>If {@code postSubpassSampleLocationsCount} is not 0, {@code pPostSubpassSampleLocations} <b>must</b> be a valid pointer to an array of {@code postSubpassSampleLocationsCount} valid ##VkSubpassSampleLocationsEXT structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkAttachmentSampleLocationsEXT, ##VkSubpassSampleLocationsEXT
        """

    Expression("#STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pAttachmentInitialSampleLocations", optional = true)..uint32_t("attachmentInitialSampleLocationsCount", "the number of elements in the {@code pAttachmentInitialSampleLocations} array.")
    VkAttachmentSampleLocationsEXT.const.p("pAttachmentInitialSampleLocations", "a pointer to an array of {@code attachmentInitialSampleLocationsCount} ##VkAttachmentSampleLocationsEXT structures specifying the attachment indices and their corresponding sample location state. Each element of {@code pAttachmentInitialSampleLocations} <b>can</b> specify the sample location state to use in the automatic layout transition performed to transition a depth/stencil attachment from the initial layout of the attachment to the image layout specified for the attachment in the first subpass using it.")
    AutoSize("pPostSubpassSampleLocations", optional = true)..uint32_t("postSubpassSampleLocationsCount", "the number of elements in the {@code pPostSubpassSampleLocations} array.")
    VkSubpassSampleLocationsEXT.const.p("pPostSubpassSampleLocations", "a pointer to an array of {@code postSubpassSampleLocationsCount} ##VkSubpassSampleLocationsEXT structures specifying the subpass indices and their corresponding sample location state. Each element of {@code pPostSubpassSampleLocations} <b>can</b> specify the sample location state to use in the automatic layout transition performed to transition the depth/stencil attachment used by the specified subpass to the image layout specified in a dependent subpass or to the final layout of the attachment in case the specified subpass is the last subpass using that attachment. In addition, if ##VkPhysicalDeviceSampleLocationsPropertiesEXT{@code ::variableSampleLocations} is #FALSE, each element of {@code pPostSubpassSampleLocations} <b>must</b> specify the sample location state that matches the sample locations used by all pipelines that will be bound to a command buffer during the specified subpass. If {@code variableSampleLocations} is #TRUE, the sample locations used for rasterization do not depend on {@code pPostSubpassSampleLocations}.")
}

val VkPipelineSampleLocationsStateCreateInfoEXT = struct(Module.VULKAN, "VkPipelineSampleLocationsStateCreateInfoEXT") {
    documentation =
        """
        Structure specifying sample locations for a pipeline.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT</li>
            <li>{@code sampleLocationsInfo} <b>must</b> be a valid ##VkSampleLocationsInfoEXT structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkSampleLocationsInfoEXT
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("sampleLocationsEnable", "controls whether custom sample locations are used. If {@code sampleLocationsEnable} is #FALSE, the default sample locations are used and the values specified in {@code sampleLocationsInfo} are ignored.")
    VkSampleLocationsInfoEXT("sampleLocationsInfo", "the sample locations to use during rasterization if {@code sampleLocationsEnable} is #TRUE and the graphics pipeline is not created with #DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT.")
}

val VkPhysicalDeviceSampleLocationsPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceSampleLocationsPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure describing sample location limits that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceSampleLocationsPropertiesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkSampleCountFlags("sampleLocationSampleCounts", "a bitmask of {@code VkSampleCountFlagBits} indicating the sample counts supporting custom sample locations.")
    VkExtent2D("maxSampleLocationGridSize", "the maximum size of the pixel grid in which sample locations <b>can</b> vary that is supported for all sample counts in {@code sampleLocationSampleCounts}.")
    float("sampleLocationCoordinateRange", "the range of supported sample location coordinates.")[2]
    uint32_t("sampleLocationSubPixelBits", "the number of bits of subpixel precision for sample locations.")
    VkBool32("variableSampleLocations", "specifies whether the sample locations used by all pipelines that will be bound to a command buffer during a subpass <b>must</b> match. If set to #TRUE, the implementation supports variable sample locations in a subpass. If set to #FALSE, then the sample locations <b>must</b> stay constant in each subpass.")
}

val VkMultisamplePropertiesEXT = struct(Module.VULKAN, "VkMultisamplePropertiesEXT", mutable = false) {
    documentation =
        """
        Structure returning information about sample count specific additional multisampling capabilities.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D, #GetPhysicalDeviceMultisamplePropertiesEXT()
        """

    Expression("#STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkExtent2D("maxSampleLocationGridSize", "the maximum size of the pixel grid in which sample locations <b>can</b> vary.")
}

val VkBufferMemoryRequirementsInfo2KHR = struct(Module.VULKAN, "VkBufferMemoryRequirementsInfo2KHR", alias = VkBufferMemoryRequirementsInfo2) {
    documentation = "See ##VkBufferMemoryRequirementsInfo2."

    Expression("#STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkBuffer("buffer", "")
}

val VkImageMemoryRequirementsInfo2KHR = struct(Module.VULKAN, "VkImageMemoryRequirementsInfo2KHR", alias = VkImageMemoryRequirementsInfo2) {
    documentation = "See ##VkImageMemoryRequirementsInfo2."

    Expression("#STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImage("image", "")
}

val VkImageSparseMemoryRequirementsInfo2KHR = struct(Module.VULKAN, "VkImageSparseMemoryRequirementsInfo2KHR", alias = VkImageSparseMemoryRequirementsInfo2) {
    documentation = "See ##VkImageSparseMemoryRequirementsInfo2."

    Expression("#STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImage("image", "")
}

val VkMemoryRequirements2KHR = struct(Module.VULKAN, "VkMemoryRequirements2KHR", mutable = false, alias = VkMemoryRequirements2) {
    documentation = "See ##VkMemoryRequirements2."

    Expression("#STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkMemoryRequirements("memoryRequirements", "")
}

val VkSparseImageMemoryRequirements2KHR = struct(Module.VULKAN, "VkSparseImageMemoryRequirements2KHR", mutable = false, alias = VkSparseImageMemoryRequirements2) {
    documentation = "See ##VkSparseImageMemoryRequirements2."

    Expression("#STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkSparseImageMemoryRequirements("memoryRequirements", "")
}

val VkImageFormatListCreateInfoKHR = struct(Module.VULKAN, "VkImageFormatListCreateInfoKHR", alias = VkImageFormatListCreateInfo) {
    documentation = "See ##VkImageFormatListCreateInfo."

    Expression("#STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pViewFormats", optional = true)..uint32_t("viewFormatCount", "")
    VkFormat.const.p("pViewFormats", "")
}

val VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT") {
    documentation =
        """
        Structure describing advanced blending features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("advancedBlendCoherentOperations", "specifies whether blending using <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#framebuffer-blend-advanced\">advanced blend operations</a> is guaranteed to execute atomically and in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#drawing-primitive-order\">primitive order</a>. If this is #TRUE, #ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT is treated the same as #ACCESS_COLOR_ATTACHMENT_READ_BIT, and advanced blending needs no additional synchronization over basic blending. If this is #FALSE, then memory dependencies are required to guarantee order between two advanced blending operations that occur on the same sample.")
}

val VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure describing advanced blending limits that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("advancedBlendMaxColorAttachments", "one greater than the highest color attachment index that <b>can</b> be used in a subpass, for a pipeline that uses an <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#framebuffer-blend-advanced\">advanced blend operation</a>.")
    VkBool32("advancedBlendIndependentBlend", "specifies whether advanced blend operations <b>can</b> vary per-attachment.")
    VkBool32("advancedBlendNonPremultipliedSrcColor", "specifies whether the source color <b>can</b> be treated as non-premultiplied. If this is #FALSE, then ##VkPipelineColorBlendAdvancedStateCreateInfoEXT{@code ::srcPremultiplied} <b>must</b> be #TRUE.")
    VkBool32("advancedBlendNonPremultipliedDstColor", "specifies whether the destination color <b>can</b> be treated as non-premultiplied. If this is #FALSE, then ##VkPipelineColorBlendAdvancedStateCreateInfoEXT{@code ::dstPremultiplied} <b>must</b> be #TRUE.")
    VkBool32("advancedBlendCorrelatedOverlap", "specifies whether the overlap mode <b>can</b> be treated as correlated. If this is #FALSE, then ##VkPipelineColorBlendAdvancedStateCreateInfoEXT{@code ::blendOverlap} <b>must</b> be #BLEND_OVERLAP_UNCORRELATED_EXT.")
    VkBool32("advancedBlendAllOperations", "specifies whether all advanced blend operation enums are supported. See the valid usage of ##VkPipelineColorBlendAttachmentState.")
}

val VkPipelineColorBlendAdvancedStateCreateInfoEXT = struct(Module.VULKAN, "VkPipelineColorBlendAdvancedStateCreateInfoEXT") {
    documentation =
        """
        Structure specifying parameters that affect advanced blend operations.

        <h5>Description</h5>
        If this structure is not present, {@code srcPremultiplied} and {@code dstPremultiplied} are both considered to be #TRUE, and {@code blendOverlap} is considered to be #BLEND_OVERLAP_UNCORRELATED_EXT.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-advancedBlendNonPremultipliedSrcColor">non-premultiplied source color</a> property is not supported, {@code srcPremultiplied} <b>must</b> be #TRUE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-advancedBlendNonPremultipliedDstColor">non-premultiplied destination color</a> property is not supported, {@code dstPremultiplied} <b>must</b> be #TRUE</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-advancedBlendCorrelatedOverlap">correlated overlap</a> property is not supported, {@code blendOverlap} <b>must</b> be #BLEND_OVERLAP_UNCORRELATED_EXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT</li>
            <li>{@code blendOverlap} <b>must</b> be a valid {@code VkBlendOverlapEXT} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("srcPremultiplied", "specifies whether the source color of the blend operation is treated as premultiplied.")
    VkBool32("dstPremultiplied", "specifies whether the destination color of the blend operation is treated as premultiplied.")
    VkBlendOverlapEXT("blendOverlap", "a {@code VkBlendOverlapEXT} value specifying how the source and destination sample’s coverage is correlated.")
}

val VkPipelineCoverageToColorStateCreateInfoNV = struct(Module.VULKAN, "VkPipelineCoverageToColorStateCreateInfoNV") {
    documentation =
        """
        Structure specifying whether fragment coverage replaces a color.

        <h5>Description</h5>
        If the {@code pNext} chain of ##VkPipelineMultisampleStateCreateInfo includes a ##VkPipelineCoverageToColorStateCreateInfoNV structure, then that structure controls whether the fragment coverage is substituted for a fragment color output and, if so, which output is replaced.

        If {@code coverageToColorEnable} is #TRUE, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-multisampling-coverage-mask">coverage mask</a> replaces the first component of the color value corresponding to the fragment shader output location with {@code Location} equal to {@code coverageToColorLocation} and {@code Index} equal to zero. If the color attachment format has fewer bits than the coverage mask, the low bits of the sample coverage mask are taken without any clamping. If the color attachment format has more bits than the coverage mask, the high bits of the sample coverage mask are filled with zeros.

        If {@code coverageToColorEnable} is #FALSE, these operations are skipped. If this structure is not included in the {@code pNext} chain, it is as if {@code coverageToColorEnable} is #FALSE.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code coverageToColorEnable} is #TRUE, then the render pass subpass indicated by ##VkGraphicsPipelineCreateInfo{@code ::renderPass} and ##VkGraphicsPipelineCreateInfo{@code ::subpass} <b>must</b> have a color attachment at the location selected by {@code coverageToColorLocation}, with a {@code VkFormat} of #FORMAT_R8_UINT, #FORMAT_R8_SINT, #FORMAT_R16_UINT, #FORMAT_R16_SINT, #FORMAT_R32_UINT, or #FORMAT_R32_SINT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCoverageToColorStateCreateFlagsNV("flags", "reserved for future use.")
    VkBool32("coverageToColorEnable", "controls whether the fragment coverage value replaces a fragment color output.")
    uint32_t("coverageToColorLocation", "controls which fragment shader color output value is replaced.")
}

val VkDeviceOrHostAddressKHR = union(Module.VULKAN, "VkDeviceOrHostAddressKHR") {
    documentation =
        """
        Union specifying a device or host address.

        <h5>See Also</h5>
        ##VkAccelerationStructureBuildGeometryInfoKHR, ##VkCopyAccelerationStructureToMemoryInfoKHR, ##VkCopyMicromapToMemoryInfoEXT, ##VkMicromapBuildInfoEXT
        """

    VkDeviceAddress("deviceAddress", "a buffer device address as returned by the #GetBufferDeviceAddressKHR() command.")
    nullable..opaque_p("hostAddress", "a host memory address.")
}

val VkDeviceOrHostAddressConstKHR = union(Module.VULKAN, "VkDeviceOrHostAddressConstKHR") {
    documentation =
        """
        Union specifying a const device or host address.

        <h5>See Also</h5>
        ##VkAccelerationStructureGeometryAabbsDataKHR, ##VkAccelerationStructureGeometryInstancesDataKHR, ##VkAccelerationStructureGeometryMotionTrianglesDataNV, ##VkAccelerationStructureGeometryTrianglesDataKHR, ##VkAccelerationStructureTrianglesDisplacementMicromapNV, ##VkAccelerationStructureTrianglesOpacityMicromapEXT, ##VkCopyMemoryToAccelerationStructureInfoKHR, ##VkCopyMemoryToMicromapInfoEXT, ##VkMicromapBuildInfoEXT
        """

    VkDeviceAddress("deviceAddress", "a buffer device address as returned by the #GetBufferDeviceAddressKHR() command.")
    nullable..opaque_const_p("hostAddress", "a const host memory address.")
}

val VkAccelerationStructureBuildRangeInfoKHR = struct(Module.VULKAN, "VkAccelerationStructureBuildRangeInfoKHR") {
    documentation =
        """
        Structure specifying build offsets and counts for acceleration structure builds.

        <h5>Description</h5>
        The primitive count and primitive offset are interpreted differently depending on the {@code VkGeometryTypeKHR} used:

        <ul>
            <li>
                For geometries of type #GEOMETRY_TYPE_TRIANGLES_KHR, {@code primitiveCount} is the number of triangles to be built, where each triangle is treated as 3 vertices.
                <ul>
                    <li>If the geometry uses indices, <code>primitiveCount × 3</code> indices are consumed from ##VkAccelerationStructureGeometryTrianglesDataKHR{@code ::indexData}, starting at an offset of {@code primitiveOffset}. The value of {@code firstVertex} is added to the index values before fetching vertices.</li>
                    <li>If the geometry does not use indices, <code>primitiveCount × 3</code> vertices are consumed from ##VkAccelerationStructureGeometryTrianglesDataKHR{@code ::vertexData}, starting at an offset of <code>primitiveOffset + ##VkAccelerationStructureGeometryTrianglesDataKHR::vertexStride × firstVertex</code>.</li>
                    <li>If ##VkAccelerationStructureGeometryTrianglesDataKHR{@code ::transformData} is not {@code NULL}, a single ##VkTransformMatrixKHR structure is consumed from ##VkAccelerationStructureGeometryTrianglesDataKHR{@code ::transformData}, at an offset of {@code transformOffset}. This matrix describes a transformation from the space in which the vertices for all triangles in this geometry are described to the space in which the acceleration structure is defined.</li>
                </ul>
            </li>
            <li>For geometries of type #GEOMETRY_TYPE_AABBS_KHR, {@code primitiveCount} is the number of axis-aligned bounding boxes. {@code primitiveCount} ##VkAabbPositionsKHR structures are consumed from ##VkAccelerationStructureGeometryAabbsDataKHR{@code ::data}, starting at an offset of {@code primitiveOffset}.</li>
            <li>For geometries of type #GEOMETRY_TYPE_INSTANCES_KHR, {@code primitiveCount} is the number of acceleration structures. {@code primitiveCount} ##VkAccelerationStructureInstanceKHR or ##VkAccelerationStructureMotionInstanceNV structures are consumed from ##VkAccelerationStructureGeometryInstancesDataKHR{@code ::data}, starting at an offset of {@code primitiveOffset}.</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>For geometries of type #GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry uses indices, the offset {@code primitiveOffset} from ##VkAccelerationStructureGeometryTrianglesDataKHR{@code ::indexData} <b>must</b> be a multiple of the element size of ##VkAccelerationStructureGeometryTrianglesDataKHR{@code ::indexType}</li>
            <li>For geometries of type #GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry does not use indices, the offset {@code primitiveOffset} from ##VkAccelerationStructureGeometryTrianglesDataKHR{@code ::vertexData} <b>must</b> be a multiple of the component size of ##VkAccelerationStructureGeometryTrianglesDataKHR{@code ::vertexFormat}</li>
            <li>For geometries of type #GEOMETRY_TYPE_TRIANGLES_KHR, the offset {@code transformOffset} from ##VkAccelerationStructureGeometryTrianglesDataKHR{@code ::transformData} <b>must</b> be a multiple of 16</li>
            <li>For geometries of type #GEOMETRY_TYPE_AABBS_KHR, the offset {@code primitiveOffset} from ##VkAccelerationStructureGeometryAabbsDataKHR{@code ::data} <b>must</b> be a multiple of 8</li>
            <li>For geometries of type #GEOMETRY_TYPE_INSTANCES_KHR, the offset {@code primitiveOffset} from ##VkAccelerationStructureGeometryInstancesDataKHR{@code ::data} <b>must</b> be a multiple of 16</li>
        </ul>

        <h5>See Also</h5>
        #BuildAccelerationStructuresKHR(), #CmdBuildAccelerationStructuresKHR()
        """

    uint32_t("primitiveCount", "defines the number of primitives for a corresponding acceleration structure geometry.")
    uint32_t("primitiveOffset", "defines an offset in bytes into the memory where primitive data is defined.")
    uint32_t("firstVertex", "the index of the first vertex to build from for triangle geometry.")
    uint32_t("transformOffset", "defines an offset in bytes into the memory where a transform matrix is defined.")
}

val VkAabbPositionsKHR = struct(Module.VULKAN, "VkAabbPositionsKHR") {
    documentation =
        """
        Structure specifying two opposing corners of an axis-aligned bounding box.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code minX} <b>must</b> be less than or equal to {@code maxX}</li>
            <li>{@code minY} <b>must</b> be less than or equal to {@code maxY}</li>
            <li>{@code minZ} <b>must</b> be less than or equal to {@code maxZ}</li>
        </ul>
        """

    float("minX", "the x position of one opposing corner of a bounding box.")
    float("minY", "the y position of one opposing corner of a bounding box.")
    float("minZ", "the z position of one opposing corner of a bounding box.")
    float("maxX", "the x position of the other opposing corner of a bounding box.")
    float("maxY", "the y position of the other opposing corner of a bounding box.")
    float("maxZ", "the z position of the other opposing corner of a bounding box.")
}

val VkAccelerationStructureGeometryTrianglesDataKHR = struct(Module.VULKAN, "VkAccelerationStructureGeometryTrianglesDataKHR") {
    documentation =
        """
        Structure specifying a triangle geometry in a bottom-level acceleration structure.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Unlike the stride for vertex buffers in ##VkVertexInputBindingDescription for graphics pipelines which must not exceed {@code maxVertexInputBindingStride}, {@code vertexStride} for acceleration structure geometry is instead restricted to being a 32-bit value.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code vertexStride} <b>must</b> be a multiple of the size in bytes of the smallest component of {@code vertexFormat}</li>
            <li>{@code vertexStride} <b>must</b> be less than or equal to <code>2<sup>32</sup>-1</code></li>
            <li>The <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#resources-buffer-view-format-features">format features</a> of {@code vertexFormat} <b>must</b> contain #FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR</li>
            <li>{@code indexType} <b>must</b> be #INDEX_TYPE_UINT16, #INDEX_TYPE_UINT32, or #INDEX_TYPE_NONE_KHR</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkAccelerationStructureGeometryMotionTrianglesDataNV, ##VkAccelerationStructureTrianglesDisplacementMicromapNV, or ##VkAccelerationStructureTrianglesOpacityMicromapEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code vertexFormat} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>{@code indexType} <b>must</b> be a valid {@code VkIndexType} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureGeometryDataKHR, ##VkDeviceOrHostAddressConstKHR
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkAccelerationStructureGeometryMotionTrianglesDataNV", "VkAccelerationStructureTrianglesDisplacementMicromapNV", "VkAccelerationStructureTrianglesOpacityMicromapEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkFormat("vertexFormat", "the {@code VkFormat} of each vertex element.")
    VkDeviceOrHostAddressConstKHR("vertexData", "a device or host address to memory containing vertex data for this geometry.")
    VkDeviceSize("vertexStride", "the stride in bytes between each vertex.")
    uint32_t("maxVertex", "the number of vertices in {@code vertexData} minus one.")
    VkIndexType("indexType", "the {@code VkIndexType} of each index element.")
    VkDeviceOrHostAddressConstKHR("indexData", "a device or host address to memory containing index data for this geometry.")
    VkDeviceOrHostAddressConstKHR("transformData", "a device or host address to memory containing an optional reference to a ##VkTransformMatrixKHR structure describing a transformation from the space in which the vertices in this geometry are described to the space in which the acceleration structure is defined.")
}

val VkTransformMatrixKHR = struct(Module.VULKAN, "VkTransformMatrixKHR") {
    documentation =
        """
        Structure specifying a 3x4 affine transformation matrix.

        <h5>Valid Usage</h5>
        <ul>
            <li>The first three columns of {@code matrix} <b>must</b> define an invertible 3x3 matrix</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureInstanceKHR, ##VkAccelerationStructureMatrixMotionInstanceNV
        """

    float("matrix", "a 3x4 row-major affine transformation matrix.")[3][4]
}

val VkAccelerationStructureGeometryAabbsDataKHR = struct(Module.VULKAN, "VkAccelerationStructureGeometryAabbsDataKHR") {
    documentation =
        """
        Structure specifying axis-aligned bounding box geometry in a bottom-level acceleration structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code stride} <b>must</b> be a multiple of 8</li>
            <li>{@code stride} <b>must</b> be less than or equal to <code>2<sup>32</sup>-1</code></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureGeometryDataKHR, ##VkDeviceOrHostAddressConstKHR
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceOrHostAddressConstKHR("data", "a device or host address to memory containing ##VkAabbPositionsKHR structures containing position data for each axis-aligned bounding box in the geometry.")
    VkDeviceSize("stride", "the stride in bytes between each entry in {@code data}. The stride <b>must</b> be a multiple of 8.")
}

val VkAccelerationStructureGeometryInstancesDataKHR = struct(Module.VULKAN, "VkAccelerationStructureGeometryInstancesDataKHR") {
    documentation =
        """
        Structure specifying a geometry consisting of instances of other acceleration structures.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureGeometryDataKHR, ##VkDeviceOrHostAddressConstKHR
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("arrayOfPointers", "specifies whether {@code data} is used as an array of addresses or just an array.")
    VkDeviceOrHostAddressConstKHR("data", "either the address of an array of device or host addresses referencing individual ##VkAccelerationStructureInstanceKHR structures or packed motion instance information as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#acceleration-structure-motion-instances\">motion instances</a> if {@code arrayOfPointers} is #TRUE, or the address of an array of ##VkAccelerationStructureInstanceKHR or ##VkAccelerationStructureMotionInstanceNV structures. Addresses and ##VkAccelerationStructureInstanceKHR structures are tightly packed. ##VkAccelerationStructureMotionInstanceNV structures have a stride of 160 bytes.")
}

val VkAccelerationStructureGeometryDataKHR = union(Module.VULKAN, "VkAccelerationStructureGeometryDataKHR") {
    documentation =
        """
        Union specifying acceleration structure geometry data.

        <h5>See Also</h5>
        ##VkAccelerationStructureGeometryAabbsDataKHR, ##VkAccelerationStructureGeometryInstancesDataKHR, ##VkAccelerationStructureGeometryKHR, ##VkAccelerationStructureGeometryTrianglesDataKHR
        """

    VkAccelerationStructureGeometryTrianglesDataKHR("triangles", "a ##VkAccelerationStructureGeometryTrianglesDataKHR structure.")
    VkAccelerationStructureGeometryAabbsDataKHR("aabbs", "a ##VkAccelerationStructureGeometryAabbsDataKHR structure.")
    VkAccelerationStructureGeometryInstancesDataKHR("instances", "a ##VkAccelerationStructureGeometryInstancesDataKHR structure.")
}

val VkAccelerationStructureGeometryKHR = struct(Module.VULKAN, "VkAccelerationStructureGeometryKHR") {
    documentation =
        """
        Structure specifying geometries to be built into an acceleration structure.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code geometryType} <b>must</b> be a valid {@code VkGeometryTypeKHR} value</li>
            <li>If {@code geometryType} is #GEOMETRY_TYPE_TRIANGLES_KHR, the {@code triangles} member of {@code geometry} <b>must</b> be a valid ##VkAccelerationStructureGeometryTrianglesDataKHR structure</li>
            <li>If {@code geometryType} is #GEOMETRY_TYPE_AABBS_KHR, the {@code aabbs} member of {@code geometry} <b>must</b> be a valid ##VkAccelerationStructureGeometryAabbsDataKHR structure</li>
            <li>If {@code geometryType} is #GEOMETRY_TYPE_INSTANCES_KHR, the {@code instances} member of {@code geometry} <b>must</b> be a valid ##VkAccelerationStructureGeometryInstancesDataKHR structure</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkGeometryFlagBitsKHR} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureBuildGeometryInfoKHR, ##VkAccelerationStructureGeometryDataKHR
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkGeometryTypeKHR("geometryType", "describes which type of geometry this ##VkAccelerationStructureGeometryKHR refers to.")
    VkAccelerationStructureGeometryDataKHR("geometry", "a ##VkAccelerationStructureGeometryDataKHR union describing the geometry data for the relevant geometry type.")
    VkGeometryFlagsKHR("flags", "a bitmask of {@code VkGeometryFlagBitsKHR} values describing additional properties of how the geometry should be built.")
}

val VkAccelerationStructureBuildGeometryInfoKHR = struct(Module.VULKAN, "VkAccelerationStructureBuildGeometryInfoKHR") {
    documentation =
        """
        Structure specifying the geometry data used to build an acceleration structure.

        <h5>Description</h5>
        Only one of {@code pGeometries} or {@code ppGeometries} <b>can</b> be a valid pointer, the other <b>must</b> be {@code NULL}. Each element of the non-{@code NULL} array describes the data used to build each acceleration structure geometry.

        The index of each element of the {@code pGeometries} or {@code ppGeometries} members of ##VkAccelerationStructureBuildGeometryInfoKHR is used as the <em>geometry index</em> during ray traversal. The geometry index is available in ray shaders via the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-builtin-variables-raygeometryindex">{@code RayGeometryIndexKHR} built-in</a>, and is <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#shader-binding-table-hit-shader-indexing">used to determine hit and intersection shaders executed during traversal</a>. The geometry index is available to ray queries via the {@code OpRayQueryGetIntersectionGeometryIndexKHR} instruction.

        Setting #BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in {@code flags} indicates that this build is a motion top level acceleration structure. A motion top level uses instances of format ##VkAccelerationStructureMotionInstanceNV if ##VkAccelerationStructureGeometryInstancesDataKHR{@code ::arrayOfPointers} is #FALSE.

        If ##VkAccelerationStructureGeometryInstancesDataKHR{@code ::arrayOfPointers} is #TRUE, the pointer for each element of the array of instance pointers consists of 4 bits of {@code VkAccelerationStructureMotionInstanceTypeNV} in the low 4 bits of the pointer identifying the type of structure at the pointer. The device address accessed is the value in the array with the low 4 bits set to zero. The structure at the pointer is one of ##VkAccelerationStructureInstanceKHR, ##VkAccelerationStructureMatrixMotionInstanceNV or ##VkAccelerationStructureSRTMotionInstanceNV, depending on the type value encoded in the low 4 bits.

        A top level acceleration structure with either motion instances or vertex motion in its instances <b>must</b> set #BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in {@code flags}.

        Members {@code srcAccelerationStructure} and {@code dstAccelerationStructure} <b>may</b> be the same or different for an update operation (when {@code mode} is #BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR). If they are the same, the update happens in-place. Otherwise, the target acceleration structure is updated and the source is not modified.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code type} <b>must</b> not be #ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR</li>
            <li>If {@code geometryCount} is not 0, exactly one of {@code pGeometries} or {@code ppGeometries} <b>must</b> be a valid pointer, the other <b>must</b> be {@code NULL}</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, the {@code geometryType} member of elements of either {@code pGeometries} or {@code ppGeometries} <b>must</b> be #GEOMETRY_TYPE_INSTANCES_KHR</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, {@code geometryCount} <b>must</b> be 1</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR the {@code geometryType} member of elements of either {@code pGeometries} or {@code ppGeometries} <b>must</b> not be #GEOMETRY_TYPE_INSTANCES_KHR</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then the {@code geometryType} member of each geometry in either {@code pGeometries} or {@code ppGeometries} <b>must</b> be the same</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then {@code geometryCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceAccelerationStructurePropertiesKHR{@code ::maxGeometryCount}</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the {@code geometryType} member of either {@code pGeometries} or {@code ppGeometries} is #GEOMETRY_TYPE_AABBS_KHR, the total number of AABBs in all geometries <b>must</b> be less than or equal to ##VkPhysicalDeviceAccelerationStructurePropertiesKHR{@code ::maxPrimitiveCount}</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the {@code geometryType} member of either {@code pGeometries} or {@code ppGeometries} is #GEOMETRY_TYPE_TRIANGLES_KHR, the total number of triangles in all geometries <b>must</b> be less than or equal to ##VkPhysicalDeviceAccelerationStructurePropertiesKHR{@code ::maxPrimitiveCount}</li>
            <li>If {@code flags} has the #BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR bit set, then it <b>must</b> not have the #BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR bit set</li>
            <li>If {@code dstAccelerationStructure} was created with #ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in ##VkAccelerationStructureCreateInfoKHR{@code ::flags}, #BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV <b>must</b> be set in {@code flags}</li>
            <li>If #BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in {@code flags}, {@code dstAccelerationStructure} <b>must</b> have been created with #ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in ##VkAccelerationStructureCreateInfoKHR{@code ::flags}</li>
            <li>If #BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in {@code flags}, {@code type} <b>must</b> not be #ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR</li>
            <li>If {@code flags} has the #BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_UPDATE_EXT bit set then it <b>must</b> not have the #BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_DATA_UPDATE_EXT bit set</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code type} <b>must</b> be a valid {@code VkAccelerationStructureTypeKHR} value</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkBuildAccelerationStructureFlagBitsKHR} values</li>
            <li>If {@code geometryCount} is not 0, and {@code pGeometries} is not {@code NULL}, {@code pGeometries} <b>must</b> be a valid pointer to an array of {@code geometryCount} valid ##VkAccelerationStructureGeometryKHR structures</li>
            <li>If {@code geometryCount} is not 0, and {@code ppGeometries} is not {@code NULL}, {@code ppGeometries} <b>must</b> be a valid pointer to an array of {@code geometryCount} valid pointers to valid ##VkAccelerationStructureGeometryKHR structures</li>
            <li>Both of {@code dstAccelerationStructure}, and {@code srcAccelerationStructure} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureGeometryKHR, ##VkDeviceOrHostAddressKHR, #BuildAccelerationStructuresKHR(), #CmdBuildAccelerationStructuresIndirectKHR(), #CmdBuildAccelerationStructuresKHR(), #GetAccelerationStructureBuildSizesKHR()
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccelerationStructureTypeKHR("type", "a {@code VkAccelerationStructureTypeKHR} value specifying the type of acceleration structure being built.")
    VkBuildAccelerationStructureFlagsKHR("flags", "a bitmask of {@code VkBuildAccelerationStructureFlagBitsKHR} specifying additional parameters of the acceleration structure.")
    VkBuildAccelerationStructureModeKHR("mode", "a {@code VkBuildAccelerationStructureModeKHR} value specifying the type of operation to perform.")
    VkAccelerationStructureKHR("srcAccelerationStructure", "a pointer to an existing acceleration structure that is to be used to update the {@code dstAccelerationStructure} acceleration structure when {@code mode} is #BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR.")
    VkAccelerationStructureKHR("dstAccelerationStructure", "a pointer to the target acceleration structure for the build.")
    AutoSize("pGeometries", "ppGeometries", optional = true)..uint32_t("geometryCount", "specifies the number of geometries that will be built into {@code dstAccelerationStructure}.")
    nullable..VkAccelerationStructureGeometryKHR.const.p("pGeometries", "a pointer to an array of ##VkAccelerationStructureGeometryKHR structures.")
    nullable..VkAccelerationStructureGeometryKHR.const.p.const.p("ppGeometries", "a pointer to an array of pointers to ##VkAccelerationStructureGeometryKHR structures.")
    VkDeviceOrHostAddressKHR("scratchData", "the device or host address to memory that will be used as scratch memory for the build.")
}

val VkAccelerationStructureInstanceKHR = struct(Module.VULKAN, "VkAccelerationStructureInstanceKHR") {
    documentation =
        """
        Structure specifying a single acceleration structure instance for building into an acceleration structure geometry.

        <h5>Description</h5>
        The C language specification does not define the ordering of bit-fields, but in practice, this struct produces the correct layout with existing compilers. The intended bit pattern is for the following:

        <ul>
            <li>
                {@code instanceCustomIndex} and {@code mask} occupy the same memory as if a single {@code uint32_t} was specified in their place
                <ul>
                    <li>{@code instanceCustomIndex} occupies the 24 least significant bits of that memory</li>
                    <li>{@code mask} occupies the 8 most significant bits of that memory</li>
                </ul>
            </li>
            <li>
                {@code instanceShaderBindingTableRecordOffset} and {@code flags} occupy the same memory as if a single {@code uint32_t} was specified in their place
                <ul>
                    <li>{@code instanceShaderBindingTableRecordOffset} occupies the 24 least significant bits of that memory</li>
                    <li>{@code flags} occupies the 8 most significant bits of that memory</li>
                </ul>
            </li>
        </ul>

        If a compiler produces code that diverges from that pattern, applications <b>must</b> employ another method to set values according to the correct bit pattern.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkGeometryInstanceFlagBitsKHR} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureMotionInstanceDataNV, ##VkTransformMatrixKHR
        """

    VkTransformMatrixKHR("transform", "a ##VkTransformMatrixKHR structure describing a transformation to be applied to the acceleration structure.")
    uint32_t("instanceCustomIndex", "a 24-bit application-specified index value accessible to ray shaders in the {@code InstanceCustomIndexKHR} built-in.", bits = 24)
    uint32_t("mask", "an 8-bit visibility mask for the geometry. The instance <b>may</b> only be hit if {@code Cull Mask &amp; instance.mask != 0}", bits = 8)
    uint32_t("instanceShaderBindingTableRecordOffset", "a 24-bit offset used in calculating the hit shader binding table index.", bits = 24)
    VkGeometryInstanceFlagsKHR("flags", "an 8-bit mask of {@code VkGeometryInstanceFlagBitsKHR} values to apply to this instance.", bits = 8)
    uint64_t("accelerationStructureReference", """either :

        <ul>
            <li>a device address containing the value obtained from #GetAccelerationStructureDeviceAddressKHR() or #GetAccelerationStructureHandleNV() (used by device operations which reference acceleration structures) or,</li>
            <li>a {@code VkAccelerationStructureKHR} object (used by host operations which reference acceleration structures).</li>
        </ul>""")
}

val VkAccelerationStructureCreateInfoKHR = struct(Module.VULKAN, "VkAccelerationStructureCreateInfoKHR") {
    documentation =
        """
        Structure specifying the parameters of a newly created acceleration structure object.

        <h5>Description</h5>
        Applications <b>should</b> avoid creating acceleration structures with application-provided addresses and implementation-provided addresses in the same process, to reduce the likelihood of #ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR errors.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The expected usage for this is that a trace capture/replay tool will add the #BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT flag to all buffers that use #BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT, and will add #BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT to all buffers used as storage for an acceleration structure where {@code deviceAddress} is not zero. This also means that the tool will need to add #MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT to memory allocations to allow the flag to be set where the application may not have otherwise required it. During capture the tool will save the queried opaque device addresses in the trace. During replay, the buffers will be created specifying the original address so any address values stored in the trace data will remain valid.

        Implementations are expected to separate such buffers in the GPU address space so normal allocations will avoid using these addresses. Applications and tools should avoid mixing application-provided and implementation-provided addresses for buffers created with #BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, to avoid address space allocation conflicts.
        </div>

        Applications <b>should</b> create an acceleration structure with a specific {@code VkAccelerationStructureTypeKHR} other than #ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        #ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR is intended to be used by API translation layers. This can be used at acceleration structure creation time in cases where the actual acceleration structure type (top or bottom) is not yet known. The actual acceleration structure type must be specified as #ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR or #ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR when the build is performed.
        </div>

        If the acceleration structure will be the target of a build operation, the required size for an acceleration structure <b>can</b> be queried with #GetAccelerationStructureBuildSizesKHR(). If the acceleration structure is going to be the target of a compacting copy, #CmdWriteAccelerationStructuresPropertiesKHR() or #WriteAccelerationStructuresPropertiesKHR() <b>can</b> be used to obtain the compacted size required.

        If the acceleration structure will be the target of a build operation with #BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV it <b>must</b> include #ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV in {@code createFlags} and include ##VkAccelerationStructureMotionInfoNV as an extension structure in {@code pNext} with the number of instances as metadata for the object.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code deviceAddress} is not zero, {@code createFlags} <b>must</b> include #ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR</li>
            <li>If {@code deviceAddress} is not zero, it <b>must</b> have been retrieved from an identically created acceleration structure, except for {@code buffer} and {@code deviceAddress}</li>
            <li>If {@code deviceAddress} is not zero, {@code buffer} <b>must</b> have been created identically to the {@code buffer} used to create the acceleration structure from which {@code deviceAddress} was retrieved, except for ##VkBufferOpaqueCaptureAddressCreateInfo{@code ::opaqueCaptureAddress}</li>
            <li>If {@code deviceAddress} is not zero, {@code buffer} <b>must</b> have been created with a ##VkBufferOpaqueCaptureAddressCreateInfo{@code ::opaqueCaptureAddress} that was retrieved from #GetBufferOpaqueCaptureAddress() for the {@code buffer} that was used to create the acceleration structure from which {@code deviceAddress} was retrieved</li>
            <li>If {@code createFlags} includes #ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR, ##VkPhysicalDeviceAccelerationStructureFeaturesKHR{@code ::accelerationStructureCaptureReplay} <b>must</b> be #TRUE</li>
            <li>{@code buffer} <b>must</b> have been created with a {@code usage} value containing #BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR</li>
            <li>{@code buffer} <b>must</b> not have been created with #BUFFER_CREATE_SPARSE_RESIDENCY_BIT</li>
            <li>The sum of {@code offset} and {@code size} <b>must</b> be less than the size of {@code buffer}</li>
            <li>{@code offset} <b>must</b> be a multiple of 256 bytes</li>
            <li>If #ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV is set in {@code createFlags} and {@code type} is #ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, one member of the {@code pNext} chain <b>must</b> be a pointer to a valid instance of ##VkAccelerationStructureMotionInfoNV</li>
            <li>If any geometry includes ##VkAccelerationStructureGeometryMotionTrianglesDataNV then {@code createFlags} <b>must</b> contain #ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV</li>
            <li>If {@code createFlags} includes #ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-descriptorBufferCaptureReplay">{@code descriptorBufferCaptureReplay}</a> feature <b>must</b> be enabled</li>
            <li>If the {@code pNext} chain includes a ##VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, {@code createFlags} <b>must</b> contain #ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkAccelerationStructureMotionInfoNV or ##VkOpaqueCaptureDescriptorDataCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code createFlags} <b>must</b> be a valid combination of {@code VkAccelerationStructureCreateFlagBitsKHR} values</li>
            <li>{@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>{@code type} <b>must</b> be a valid {@code VkAccelerationStructureTypeKHR} value</li>
        </ul>

        <h5>See Also</h5>
        #CreateAccelerationStructureKHR()
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkAccelerationStructureMotionInfoNV", "VkOpaqueCaptureDescriptorDataCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccelerationStructureCreateFlagsKHR("createFlags", "a bitmask of {@code VkAccelerationStructureCreateFlagBitsKHR} specifying additional creation parameters of the acceleration structure.")
    VkBuffer("buffer", "the buffer on which the acceleration structure will be stored.")
    VkDeviceSize("offset", "an offset in bytes from the base address of the buffer at which the acceleration structure will be stored, and <b>must</b> be a multiple of 256.")
    VkDeviceSize("size", "the size required for the acceleration structure.")
    VkAccelerationStructureTypeKHR("type", "a {@code VkAccelerationStructureTypeKHR} value specifying the type of acceleration structure that will be created.")
    VkDeviceAddress("deviceAddress", "the device address requested for the acceleration structure if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-accelerationStructureCaptureReplay\">{@code accelerationStructureCaptureReplay}</a> feature is being used. If {@code deviceAddress} is zero, no specific address is requested.")
}

val VkWriteDescriptorSetAccelerationStructureKHR = struct(Module.VULKAN, "VkWriteDescriptorSetAccelerationStructureKHR") {
    documentation =
        """
        Structure specifying acceleration structure descriptor information.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code accelerationStructureCount} <b>must</b> be equal to {@code descriptorCount} in the extended structure</li>
            <li>Each acceleration structure in {@code pAccelerationStructures} <b>must</b> have been created with a {@code type} of #ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR or #ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-nullDescriptor">{@code nullDescriptor}</a> feature is not enabled, each element of {@code pAccelerationStructures} <b>must</b> not be #NULL_HANDLE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR</li>
            <li>{@code pAccelerationStructures} <b>must</b> be a valid pointer to an array of {@code accelerationStructureCount} valid or #NULL_HANDLE {@code VkAccelerationStructureKHR} handles</li>
            <li>{@code accelerationStructureCount} <b>must</b> be greater than 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pAccelerationStructures", optional = true)..uint32_t("accelerationStructureCount", "the number of elements in {@code pAccelerationStructures}.")
    nullable..VkAccelerationStructureKHR.const.p("pAccelerationStructures", "a pointer to an array of {@code VkAccelerationStructureKHR} structures specifying the acceleration structures to update.")
}

val VkPhysicalDeviceAccelerationStructureFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceAccelerationStructureFeaturesKHR") {
    documentation =
        """
        Structure describing the acceleration structure features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceAccelerationStructureFeaturesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceAccelerationStructureFeaturesKHR <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("accelerationStructure", "indicates whether the implementation supports the acceleration structure functionality. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#acceleration-structure\">Acceleration Structures</a>.")
    VkBool32("accelerationStructureCaptureReplay", "indicates whether the implementation supports saving and reusing acceleration structure device addresses, e.g. for trace capture and replay.")
    VkBool32("accelerationStructureIndirectBuild", "indicates whether the implementation supports indirect acceleration structure build commands, e.g. #CmdBuildAccelerationStructuresIndirectKHR().")
    VkBool32("accelerationStructureHostCommands", "indicates whether the implementation supports host side acceleration structure commands, e.g. #BuildAccelerationStructuresKHR(), #CopyAccelerationStructureKHR(), #CopyAccelerationStructureToMemoryKHR(), #CopyMemoryToAccelerationStructureKHR(), #WriteAccelerationStructuresPropertiesKHR().")
    VkBool32("descriptorBindingAccelerationStructureUpdateAfterBind", "indicates whether the implementation supports updating acceleration structure descriptors after a set is bound. If this feature is not enabled, #DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT <b>must</b> not be used with #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR.")
}

val VkPhysicalDeviceAccelerationStructurePropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceAccelerationStructurePropertiesKHR", mutable = false) {
    documentation =
        """
        Properties of the physical device for acceleration structure.

        <h5>Description</h5>
        Due to the fact that the geometry, instance, and primitive counts are specified at acceleration structure creation as 32-bit values, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxGeometryCount">{@code maxGeometryCount}</a>, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxInstanceCount">{@code maxInstanceCount}</a>, and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxPrimitiveCount">{@code maxPrimitiveCount}</a> <b>must</b> not exceed <code>2<sup>32</sup>-1</code>.

        If the ##VkPhysicalDeviceAccelerationStructurePropertiesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        Limits specified by this structure <b>must</b> match those specified with the same name in ##VkPhysicalDeviceRayTracingPropertiesNV.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint64_t("maxGeometryCount", "the maximum number of geometries in the bottom level acceleration structure.")
    uint64_t("maxInstanceCount", "the maximum number of instances in the top level acceleration structure.")
    uint64_t("maxPrimitiveCount", "the maximum number of triangles or AABBs in all geometries in the bottom level acceleration structure.")
    uint32_t("maxPerStageDescriptorAccelerationStructures", "the maximum number of acceleration structure bindings that <b>can</b> be accessible to a single shader stage in a pipeline layout. Descriptor bindings with a descriptor type of #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR count against this limit. Only descriptor bindings in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit.")
    uint32_t("maxPerStageDescriptorUpdateAfterBindAccelerationStructures", "similar to {@code maxPerStageDescriptorAccelerationStructures} but counts descriptor bindings from descriptor sets created with or without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set.")
    uint32_t("maxDescriptorSetAccelerationStructures", "the maximum number of acceleration structure descriptors that <b>can</b> be included in descriptor bindings in a pipeline layout across all pipeline shader stages and descriptor set numbers. Descriptor bindings with a descriptor type of #DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR count against this limit. Only descriptor bindings in descriptor set layouts created without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set count against this limit.")
    uint32_t("maxDescriptorSetUpdateAfterBindAccelerationStructures", "similar to {@code maxDescriptorSetAccelerationStructures} but counts descriptor bindings from descriptor sets created with or without the #DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set.")
    uint32_t("minAccelerationStructureScratchOffsetAlignment", "the minimum <b>required</b> alignment, in bytes, for scratch data passed in to an acceleration structure build command. The value <b>must</b> be a power of two.")
}

val VkAccelerationStructureDeviceAddressInfoKHR = struct(Module.VULKAN, "VkAccelerationStructureDeviceAddressInfoKHR") {
    documentation =
        """
        Structure specifying the acceleration structure to query an address for.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code accelerationStructure} <b>must</b> be a valid {@code VkAccelerationStructureKHR} handle</li>
        </ul>

        <h5>See Also</h5>
        #GetAccelerationStructureDeviceAddressKHR()
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccelerationStructureKHR("accelerationStructure", "specifies the acceleration structure whose address is being queried.")
}

val VkAccelerationStructureVersionInfoKHR = struct(Module.VULKAN, "VkAccelerationStructureVersionInfoKHR") {
    documentation =
        """
        Acceleration structure version information.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        {@code pVersionData} is a <em>pointer</em> to an array of 2×#UUID_SIZE {@code uint8_t} values instead of two #UUID_SIZE arrays as the expected use case for this member is to be pointed at the header of a previously serialized acceleration structure (via #CmdCopyAccelerationStructureToMemoryKHR() or #CopyAccelerationStructureToMemoryKHR()) that is loaded in memory. Using arrays would necessitate extra memory copies of the UUIDs.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code pVersionData} <b>must</b> be a valid pointer to an array of 2 &times; {@code VK_UUID_SIZE} {@code uint8_t} values</li>
        </ul>

        <h5>See Also</h5>
        #GetDeviceAccelerationStructureCompatibilityKHR()
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint8_t.const.p("pVersionData", "a pointer to the version header of an acceleration structure as defined in #CmdCopyAccelerationStructureToMemoryKHR()")
}

val VkCopyAccelerationStructureToMemoryInfoKHR = struct(Module.VULKAN, "VkCopyAccelerationStructureToMemoryInfoKHR") {
    documentation =
        """
        Parameters for serializing an acceleration structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>The source acceleration structure {@code src} <b>must</b> have been constructed prior to the execution of this command</li>
            <li>The memory pointed to by {@code dst} <b>must</b> be at least as large as the serialization size of {@code src}, as reported by #WriteAccelerationStructuresPropertiesKHR() or #CmdWriteAccelerationStructuresPropertiesKHR() with a query type of #QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR</li>
            <li>{@code mode} <b>must</b> be #COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code src} <b>must</b> be a valid {@code VkAccelerationStructureKHR} handle</li>
            <li>{@code mode} <b>must</b> be a valid {@code VkCopyAccelerationStructureModeKHR} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkDeviceOrHostAddressKHR, #CmdCopyAccelerationStructureToMemoryKHR(), #CopyAccelerationStructureToMemoryKHR()
        """

    Expression("#STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccelerationStructureKHR("src", "the source acceleration structure for the copy")
    VkDeviceOrHostAddressKHR("dst", "the device or host address to memory which is the target for the copy")
    VkCopyAccelerationStructureModeKHR("mode", "a {@code VkCopyAccelerationStructureModeKHR} value specifying additional operations to perform during the copy.")
}

val VkCopyMemoryToAccelerationStructureInfoKHR = struct(Module.VULKAN, "VkCopyMemoryToAccelerationStructureInfoKHR") {
    documentation =
        """
        Parameters for deserializing an acceleration structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>The source memory pointed to by {@code src} <b>must</b> contain data previously serialized using #CmdCopyAccelerationStructureToMemoryKHR(), potentially modified to relocate acceleration structure references as described in that command</li>
            <li>{@code mode} <b>must</b> be #COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR</li>
            <li>The data in {@code src} <b>must</b> have a format compatible with the destination physical device as returned by #GetDeviceAccelerationStructureCompatibilityKHR()</li>
            <li>{@code dst} <b>must</b> have been created with a {@code size} greater than or equal to that used to serialize the data in {@code src}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code dst} <b>must</b> be a valid {@code VkAccelerationStructureKHR} handle</li>
            <li>{@code mode} <b>must</b> be a valid {@code VkCopyAccelerationStructureModeKHR} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkDeviceOrHostAddressConstKHR, #CmdCopyMemoryToAccelerationStructureKHR(), #CopyMemoryToAccelerationStructureKHR()
        """

    Expression("#STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceOrHostAddressConstKHR("src", "the device or host address to memory containing the source data for the copy.")
    VkAccelerationStructureKHR("dst", "the target acceleration structure for the copy.")
    VkCopyAccelerationStructureModeKHR("mode", "a {@code VkCopyAccelerationStructureModeKHR} value specifying additional operations to perform during the copy.")
}

val VkCopyAccelerationStructureInfoKHR = struct(Module.VULKAN, "VkCopyAccelerationStructureInfoKHR") {
    documentation =
        """
        Parameters for copying an acceleration structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code mode} <b>must</b> be #COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR or #COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR</li>
            <li>The source acceleration structure {@code src} <b>must</b> have been constructed prior to the execution of this command</li>
            <li>If {@code mode} is #COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR, {@code src} <b>must</b> have been constructed with #BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR in the build</li>
            <li>The {@code buffer} used to create {@code src} <b>must</b> be bound to device memory</li>
            <li>The {@code buffer} used to create {@code dst} <b>must</b> be bound to device memory</li>
            <li>The range of memory backing {@code dst} that is accessed by this command <b>must</b> not overlap the memory backing {@code src} that is accessed by this command</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code src} <b>must</b> be a valid {@code VkAccelerationStructureKHR} handle</li>
            <li>{@code dst} <b>must</b> be a valid {@code VkAccelerationStructureKHR} handle</li>
            <li>{@code mode} <b>must</b> be a valid {@code VkCopyAccelerationStructureModeKHR} value</li>
            <li>Both of {@code dst}, and {@code src} <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #CmdCopyAccelerationStructureKHR(), #CopyAccelerationStructureKHR()
        """

    Expression("#STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccelerationStructureKHR("src", "the source acceleration structure for the copy.")
    VkAccelerationStructureKHR("dst", "the target acceleration structure for the copy.")
    VkCopyAccelerationStructureModeKHR("mode", "a {@code VkCopyAccelerationStructureModeKHR} value specifying additional operations to perform during the copy.")
}

val VkAccelerationStructureBuildSizesInfoKHR = struct(Module.VULKAN, "VkAccelerationStructureBuildSizesInfoKHR", mutable = false) {
    documentation =
        """
        Structure specifying build sizes for an acceleration structure.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetAccelerationStructureBuildSizesKHR()
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkDeviceSize("accelerationStructureSize", "the size in bytes required in a {@code VkAccelerationStructureKHR} for a build or update operation.")
    VkDeviceSize("updateScratchSize", "the size in bytes required in a scratch buffer for an update operation.")
    VkDeviceSize("buildScratchSize", "the size in bytes required in a scratch buffer for a build operation.")
}

val VkRayTracingShaderGroupCreateInfoKHR = struct(Module.VULKAN, "VkRayTracingShaderGroupCreateInfoKHR") {
    documentation =
        """
        Structure specifying shaders in a shader group.

        <h5>Description</h5>
        If the pipeline is created with #PIPELINE_CREATE_LIBRARY_BIT_KHR and the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineLibraryGroupHandles">pipelineLibraryGroupHandles</a> feature is enabled, {@code pShaderGroupCaptureReplayHandle} is inherited by all pipelines which link against this pipeline and remains bitwise identical for any pipeline which references this pipeline library.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code type} is #RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR then {@code generalShader} <b>must</b> be a valid index into ##VkRayTracingPipelineCreateInfoKHR{@code ::pStages} referring to a shader of #SHADER_STAGE_RAYGEN_BIT_KHR, #SHADER_STAGE_MISS_BIT_KHR, or #SHADER_STAGE_CALLABLE_BIT_KHR</li>
            <li>If {@code type} is #RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR then {@code closestHitShader}, {@code anyHitShader}, and {@code intersectionShader} <b>must</b> be #SHADER_UNUSED_KHR</li>
            <li>If {@code type} is #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR then {@code intersectionShader} <b>must</b> be a valid index into ##VkRayTracingPipelineCreateInfoKHR{@code ::pStages} referring to a shader of #SHADER_STAGE_INTERSECTION_BIT_KHR</li>
            <li>If {@code type} is #RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR then {@code intersectionShader} <b>must</b> be #SHADER_UNUSED_KHR</li>
            <li>{@code closestHitShader} <b>must</b> be either #SHADER_UNUSED_KHR or a valid index into ##VkRayTracingPipelineCreateInfoKHR{@code ::pStages} referring to a shader of #SHADER_STAGE_CLOSEST_HIT_BIT_KHR</li>
            <li>{@code anyHitShader} <b>must</b> be either #SHADER_UNUSED_KHR or a valid index into ##VkRayTracingPipelineCreateInfoKHR{@code ::pStages} referring to a shader of #SHADER_STAGE_ANY_HIT_BIT_KHR</li>
            <li>If ##VkPhysicalDeviceRayTracingPipelineFeaturesKHR{@code ::rayTracingPipelineShaderGroupHandleCaptureReplayMixed} is #FALSE then {@code pShaderGroupCaptureReplayHandle} <b>must</b> not be provided if it has not been provided on a previous call to ray tracing pipeline creation</li>
            <li>If ##VkPhysicalDeviceRayTracingPipelineFeaturesKHR{@code ::rayTracingPipelineShaderGroupHandleCaptureReplayMixed} is #FALSE then the caller <b>must</b> guarantee that no ray tracing pipeline creation commands with {@code pShaderGroupCaptureReplayHandle} provided execute simultaneously with ray tracing pipeline creation commands without {@code pShaderGroupCaptureReplayHandle} provided</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code type} <b>must</b> be a valid {@code VkRayTracingShaderGroupTypeKHR} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkRayTracingPipelineCreateInfoKHR
        """

    Expression("#STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkRayTracingShaderGroupTypeKHR("type", "the type of hit group specified in this structure.")
    uint32_t("generalShader", "the index of the ray generation, miss, or callable shader from ##VkRayTracingPipelineCreateInfoKHR{@code ::pStages} in the group if the shader group has {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR, and #SHADER_UNUSED_KHR otherwise.")
    uint32_t("closestHitShader", "the optional index of the closest hit shader from ##VkRayTracingPipelineCreateInfoKHR{@code ::pStages} in the group if the shader group has {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR or #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR, and #SHADER_UNUSED_KHR otherwise.")
    uint32_t("anyHitShader", "the optional index of the any-hit shader from ##VkRayTracingPipelineCreateInfoKHR{@code ::pStages} in the group if the shader group has {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR or #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR, and #SHADER_UNUSED_KHR otherwise.")
    uint32_t("intersectionShader", "the index of the intersection shader from ##VkRayTracingPipelineCreateInfoKHR{@code ::pStages} in the group if the shader group has {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR, and #SHADER_UNUSED_KHR otherwise.")
    nullable..opaque_const_p("pShaderGroupCaptureReplayHandle", "{@code NULL} or a pointer to replay information for this shader group queried from #GetRayTracingCaptureReplayShaderGroupHandlesKHR(), as described in <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#ray-tracing-capture-replay\">Ray Tracing Capture Replay</a>. Ignored if ##VkPhysicalDeviceRayTracingPipelineFeaturesKHR{@code ::rayTracingPipelineShaderGroupHandleCaptureReplay} is #FALSE.")
}

val VkRayTracingPipelineInterfaceCreateInfoKHR = struct(Module.VULKAN, "VkRayTracingPipelineInterfaceCreateInfoKHR") {
    documentation =
        """
        Structure specifying additional interface information when using libraries.

        <h5>Description</h5>
        {@code maxPipelineRayPayloadSize} is calculated as the maximum size of the block (in bytes) declared in the {@code RayPayloadKHR} or {@code IncomingRayPayloadKHR} storage classes. {@code maxPipelineRayHitAttributeSize} is calculated as the maximum size of any block (in bytes) declared in the {@code HitAttributeKHR} storage class. As variables in these storage classes do not have explicit offsets, the size should be calculated as if each variable has a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-alignment-requirements">scalar alignment</a> equal to the largest scalar alignment of any of the block’s members.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        There is no explicit upper limit for {@code maxPipelineRayPayloadSize}, but in practice it should be kept as small as possible. Similar to invocation local memory, it must be allocated for each shader invocation and for devices which support many simultaneous invocations, this storage can rapidly be exhausted, resulting in failure.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code maxPipelineRayHitAttributeSize} <b>must</b> be less than or equal to ##VkPhysicalDeviceRayTracingPipelinePropertiesKHR{@code ::maxRayHitAttributeSize}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkRayTracingPipelineCreateInfoKHR
        """

    Expression("#STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("maxPipelineRayPayloadSize", "the maximum payload size in bytes used by any shader in the pipeline.")
    uint32_t("maxPipelineRayHitAttributeSize", "the maximum attribute structure size in bytes used by any shader in the pipeline.")
}

val VkRayTracingPipelineCreateInfoKHR = struct(Module.VULKAN, "VkRayTracingPipelineCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters of a newly created ray tracing pipeline.

        <h5>Description</h5>
        The parameters {@code basePipelineHandle} and {@code basePipelineIndex} are described in more detail in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pipeline-derivatives">Pipeline Derivatives</a>.

        When #PIPELINE_CREATE_LIBRARY_BIT_KHR is specified, this pipeline defines a <em>pipeline library</em> which <b>cannot</b> be bound as a ray tracing pipeline directly. Instead, pipeline libraries define common shaders and shader groups which <b>can</b> be included in future pipeline creation.

        If pipeline libraries are included in {@code pLibraryInfo}, shaders defined in those libraries are treated as if they were defined as additional entries in {@code pStages}, appended in the order they appear in the {@code pLibraries} array and in the {@code pStages} array when those libraries were defined.

        When referencing shader groups in order to obtain a shader group handle, groups defined in those libraries are treated as if they were defined as additional entries in {@code pGroups}, appended in the order they appear in the {@code pLibraries} array and in the {@code pGroups} array when those libraries were defined. The shaders these groups reference are set when the pipeline library is created, referencing those specified in the pipeline library, not in the pipeline that includes it.

        The default stack size for a pipeline if #DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR is not provided is computed as described in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#ray-tracing-pipeline-stack">Ray Tracing Pipeline Stack</a>.

        If the {@code pNext} chain includes a ##VkPipelineCreateFlags2CreateInfo structure, ##VkPipelineCreateFlags2CreateInfo{@code ::flags} from that structure is used instead of {@code flags} from this structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain does not include a ##VkPipelineCreateFlags2CreateInfo structure, {@code flags} <b>must</b> be a valid combination of {@code VkPipelineCreateFlagBits} values</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineIndex} is -1, {@code basePipelineHandle} <b>must</b> be a valid ray tracing {@code VkPipeline} handle</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineHandle} is #NULL_HANDLE, {@code basePipelineIndex} <b>must</b> be a valid index into the calling command’s {@code pCreateInfos} parameter</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, {@code basePipelineIndex} <b>must</b> be -1 or {@code basePipelineHandle} <b>must</b> be #NULL_HANDLE</li>
            <li>If a push constant block is declared in a shader, a push constant range in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a push constant block is declared in a shader, the block must be contained inside the push constant range in {@code layout} that matches the stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, the corresponding descriptor set in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, and the descriptor type is not #DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor type</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader as an array, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor count</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variables</a> is declared in a shader as an array of descriptors, then the descriptor type of that variable <b>must</b> not be #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK</li>
        </ul>

        <ul>
            <li>The shader code for the entry points identified by {@code pStages}, and the rest of the state identified by this structure <b>must</b> adhere to the pipeline linking rules described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces">Shader Interfaces</a> chapter</li>
            <li>The number of resources in {@code layout} accessible to each shader stage that is used by the pipeline <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageResources}</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineCreationCacheControl">{@code pipelineCreationCacheControl}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or #PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT</li>
            <li>If {@code flags} does not include #PIPELINE_CREATE_LIBRARY_BIT_KHR, the {@code stage} member of at least one element of {@code pStages}, including those implicitly added by {@code pLibraryInfo}, <b>must</b> be #SHADER_STAGE_RAYGEN_BIT_KHR</li>
            <li>{@code maxPipelineRayRecursionDepth} <b>must</b> be less than or equal to ##VkPhysicalDeviceRayTracingPipelinePropertiesKHR{@code ::maxRayRecursionDepth}</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_LIBRARY_BIT_KHR, {@code pLibraryInterface} <b>must</b> not be {@code NULL}</li>
            <li>If {@code pLibraryInfo} is not {@code NULL} and its {@code libraryCount} member is greater than 0, {@code pLibraryInterface} <b>must</b> not be {@code NULL}</li>
            <li>Each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the value of {@code maxPipelineRayRecursionDepth} equal to that in this pipeline</li>
            <li>If {@code pLibraryInfo} is not {@code NULL}, each element of its {@code pLibraries} member <b>must</b> have been created with a {@code layout} that is compatible with the {@code layout} in this pipeline</li>
            <li>If {@code pLibraryInfo} is not {@code NULL}, each element of its {@code pLibraries} member <b>must</b> have been created with values of the {@code maxPipelineRayPayloadSize} and {@code maxPipelineRayHitAttributeSize} members of {@code pLibraryInterface} equal to those in this pipeline</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR, each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the #PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR bit set</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR, each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the #PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR bit set</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR, each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the #PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR bit set</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR, each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the #PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR bit set</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR, each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the #PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR bit set</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR, each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the #PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR bit set</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR, each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the #PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR bit set</li>
            <li>If the {@link KHRPipelineLibrary VK_KHR_pipeline_library} extension is not enabled, {@code pLibraryInfo} and {@code pLibraryInterface} <b>must</b> be {@code NULL}</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR, for any element of {@code pGroups} with a {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR or #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR, the {@code anyHitShader} of that element <b>must</b> not be #SHADER_UNUSED_KHR</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR, for any element of {@code pGroups} with a {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR or #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR, the {@code closestHitShader} of that element <b>must</b> not be #SHADER_UNUSED_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-rayTraversalPrimitiveCulling">{@code rayTraversalPrimitiveCulling}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-rayTraversalPrimitiveCulling">{@code rayTraversalPrimitiveCulling}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include both #PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR and #PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR, <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-rayTracingPipelineShaderGroupHandleCaptureReplay">{@code rayTracingPipelineShaderGroupHandleCaptureReplay}</a> <b>must</b> be enabled</li>
            <li>If ##VkPhysicalDeviceRayTracingPipelineFeaturesKHR{@code ::rayTracingPipelineShaderGroupHandleCaptureReplay} is #TRUE and the {@code pShaderGroupCaptureReplayHandle} member of any element of {@code pGroups} is not {@code NULL}, {@code flags} <b>must</b> include #PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR</li>
            <li>If {@code pLibraryInfo} is {@code NULL} or its {@code libraryCount} is 0, {@code stageCount} <b>must</b> not be 0</li>
            <li>If {@code flags} does not include #PIPELINE_CREATE_LIBRARY_BIT_KHR and either {@code pLibraryInfo} is {@code NULL} or its {@code libraryCount} is 0, {@code groupCount} <b>must</b> not be 0</li>
            <li>Any element of the {@code pDynamicStates} member of {@code pDynamicState} <b>must</b> be #DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR</li>
            <li>If ##VkPipelineCreationFeedbackCreateInfo{@code ::pipelineStageCreationFeedbackCount} is not 0, it <b>must</b> be equal to {@code stageCount}</li>
            <li>The {@code stage} value in all {@code pStages} elements <b>must</b> be one of #SHADER_STAGE_RAYGEN_BIT_KHR, #SHADER_STAGE_ANY_HIT_BIT_KHR, #SHADER_STAGE_CLOSEST_HIT_BIT_KHR, #SHADER_STAGE_MISS_BIT_KHR, #SHADER_STAGE_INTERSECTION_BIT_KHR, or #SHADER_STAGE_CALLABLE_BIT_KHR</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT, each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the #PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT bit set</li>
            <li>If {@code flags} includes #PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV, each element of {@code pLibraryInfo→pLibraries} <b>must</b> have been created with the #PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV bit set</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkPipelineBinaryInfoKHR, ##VkPipelineCreateFlags2CreateInfo, ##VkPipelineCreationFeedbackCreateInfo, or ##VkPipelineRobustnessCreateInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>If {@code stageCount} is not 0, {@code pStages} <b>must</b> be a valid pointer to an array of {@code stageCount} valid ##VkPipelineShaderStageCreateInfo structures</li>
            <li>If {@code groupCount} is not 0, {@code pGroups} <b>must</b> be a valid pointer to an array of {@code groupCount} valid ##VkRayTracingShaderGroupCreateInfoKHR structures</li>
            <li>If {@code pLibraryInfo} is not {@code NULL}, {@code pLibraryInfo} <b>must</b> be a valid pointer to a valid ##VkPipelineLibraryCreateInfoKHR structure</li>
            <li>If {@code pLibraryInterface} is not {@code NULL}, {@code pLibraryInterface} <b>must</b> be a valid pointer to a valid ##VkRayTracingPipelineInterfaceCreateInfoKHR structure</li>
            <li>If {@code pDynamicState} is not {@code NULL}, {@code pDynamicState} <b>must</b> be a valid pointer to a valid ##VkPipelineDynamicStateCreateInfo structure</li>
            <li>{@code layout} <b>must</b> be a valid {@code VkPipelineLayout} handle</li>
            <li>Both of {@code basePipelineHandle}, and {@code layout} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineDynamicStateCreateInfo, ##VkPipelineLibraryCreateInfoKHR, ##VkPipelineShaderStageCreateInfo, ##VkRayTracingPipelineInterfaceCreateInfoKHR, ##VkRayTracingShaderGroupCreateInfoKHR, #CreateRayTracingPipelinesKHR()
        """

    Expression("#STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkPipelineBinaryInfoKHR", "VkPipelineCreateFlags2CreateInfo", "VkPipelineCreateFlags2CreateInfoKHR", "VkPipelineCreationFeedbackCreateInfo", "VkPipelineCreationFeedbackCreateInfoEXT", "VkPipelineRobustnessCreateInfo", "VkPipelineRobustnessCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCreateFlags("flags", "a bitmask of {@code VkPipelineCreateFlagBits} specifying how the pipeline will be generated.")
    AutoSize("pStages", optional = true)..uint32_t("stageCount", "the number of entries in the {@code pStages} array.")
    VkPipelineShaderStageCreateInfo.const.p("pStages", "a pointer to an array of {@code stageCount} ##VkPipelineShaderStageCreateInfo structures describing the set of the shader stages to be included in the ray tracing pipeline.")
    AutoSize("pGroups", optional = true)..uint32_t("groupCount", "the number of entries in the {@code pGroups} array.")
    VkRayTracingShaderGroupCreateInfoKHR.const.p("pGroups", "a pointer to an array of {@code groupCount} ##VkRayTracingShaderGroupCreateInfoKHR structures describing the set of the shader stages to be included in each shader group in the ray tracing pipeline.")
    uint32_t("maxPipelineRayRecursionDepth", "the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#ray-tracing-recursion-depth\">maximum recursion depth</a> of shaders executed by this pipeline.")
    nullable..VkPipelineLibraryCreateInfoKHR.const.p("pLibraryInfo", "a pointer to a ##VkPipelineLibraryCreateInfoKHR structure defining pipeline libraries to include.")
    nullable..VkRayTracingPipelineInterfaceCreateInfoKHR.const.p("pLibraryInterface", "a pointer to a ##VkRayTracingPipelineInterfaceCreateInfoKHR structure defining additional information when using pipeline libraries.")
    nullable..VkPipelineDynamicStateCreateInfo.const.p("pDynamicState", "a pointer to a ##VkPipelineDynamicStateCreateInfo structure, and is used to indicate which properties of the pipeline state object are dynamic and <b>can</b> be changed independently of the pipeline state. This <b>can</b> be {@code NULL}, which means no state in the pipeline is considered dynamic.")
    VkPipelineLayout("layout", "the description of binding locations used by both the pipeline and descriptor sets used with the pipeline.")
    VkPipeline("basePipelineHandle", "a pipeline to derive from.")
    int32_t("basePipelineIndex", "an index into the {@code pCreateInfos} parameter to use as a pipeline to derive from.")
}

val VkPhysicalDeviceRayTracingPipelineFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceRayTracingPipelineFeaturesKHR") {
    documentation =
        """
        Structure describing the ray tracing features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceRayTracingPipelineFeaturesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceRayTracingPipelineFeaturesKHR <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code rayTracingPipelineShaderGroupHandleCaptureReplayMixed} is #TRUE, {@code rayTracingPipelineShaderGroupHandleCaptureReplay} <b>must</b> also be #TRUE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("rayTracingPipeline", "indicates whether the implementation supports the ray tracing pipeline functionality. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#ray-tracing\">Ray Tracing</a>.")
    VkBool32("rayTracingPipelineShaderGroupHandleCaptureReplay", "indicates whether the implementation supports saving and reusing shader group handles, e.g. for trace capture and replay.")
    VkBool32("rayTracingPipelineShaderGroupHandleCaptureReplayMixed", "indicates whether the implementation supports reuse of shader group handles being arbitrarily mixed with creation of non-reused shader group handles. If this is #FALSE, all reused shader group handles <b>must</b> be specified before any non-reused handles <b>may</b> be created.")
    VkBool32("rayTracingPipelineTraceRaysIndirect", "indicates whether the implementation supports indirect ray tracing commands, e.g. #CmdTraceRaysIndirectKHR().")
    VkBool32("rayTraversalPrimitiveCulling", "indicates whether the implementation supports <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#ray-traversal-culling-primitive\">primitive culling during ray traversal</a>.")
}

val VkPhysicalDeviceRayTracingPipelinePropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceRayTracingPipelinePropertiesKHR", mutable = false) {
    documentation =
        """
        Properties of the physical device for ray tracing.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceRayTracingPipelinePropertiesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        Limits specified by this structure <b>must</b> match those specified with the same name in ##VkPhysicalDeviceRayTracingPropertiesNV.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("shaderGroupHandleSize", "the size in bytes of the shader header.")
    uint32_t("maxRayRecursionDepth", "the maximum number of levels of ray recursion allowed in a trace command.")
    uint32_t("maxShaderGroupStride", "the maximum stride in bytes allowed between shader groups in the shader binding table.")
    uint32_t("shaderGroupBaseAlignment", "the <b>required</b> alignment in bytes for the base of the shader binding table.")
    uint32_t("shaderGroupHandleCaptureReplaySize", "the number of bytes for the information required to do capture and replay for shader group handles.")
    uint32_t("maxRayDispatchInvocationCount", "the maximum number of ray generation shader invocations which <b>may</b> be produced by a single #CmdTraceRaysIndirectKHR() or #CmdTraceRaysKHR() command.")
    uint32_t("shaderGroupHandleAlignment", "the <b>required</b> alignment in bytes for each entry in a shader binding table. The value <b>must</b> be a power of two.")
    uint32_t("maxRayHitAttributeSize", "the maximum size in bytes for a ray attribute structure")
}

val VkStridedDeviceAddressRegionKHR = struct(Module.VULKAN, "VkStridedDeviceAddressRegionKHR") {
    documentation =
        """
        Structure specifying a region of device addresses with a stride.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code size} is not zero, all addresses between {@code deviceAddress} and <code>deviceAddress + size - 1</code> <b>must</b> be in the buffer device address range of the same buffer</li>
            <li>If {@code size} is not zero, {@code stride} <b>must</b> be less than or equal to the size of the buffer from which {@code deviceAddress} was queried</li>
        </ul>

        <h5>See Also</h5>
        #CmdTraceRaysIndirectKHR(), #CmdTraceRaysKHR()
        """

    VkDeviceAddress("deviceAddress", "the device address (as returned by the #GetBufferDeviceAddress() command) at which the region starts, or zero if the region is unused.")
    VkDeviceSize("stride", "the byte stride between consecutive elements.")
    VkDeviceSize("size", "the size in bytes of the region starting at {@code deviceAddress}.")
}

val VkTraceRaysIndirectCommandKHR = struct(Module.VULKAN, "VkTraceRaysIndirectCommandKHR") {
    documentation =
        """
        Structure specifying the parameters of an indirect ray tracing command.

        <h5>Description</h5>
        The members of ##VkTraceRaysIndirectCommandKHR have the same meaning as the similarly named parameters of #CmdTraceRaysKHR().

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code width} <b>must</b> be less than or equal to <code>##VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0] × ##VkPhysicalDeviceLimits::maxComputeWorkGroupSize[0]</code></li>
            <li>{@code height} <b>must</b> be less than or equal to <code>##VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1] × ##VkPhysicalDeviceLimits::maxComputeWorkGroupSize[1]</code></li>
            <li>{@code depth} <b>must</b> be less than or equal to <code>##VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2] × ##VkPhysicalDeviceLimits::maxComputeWorkGroupSize[2]</code></li>
            <li><code>width × height × depth</code> <b>must</b> be less than or equal to ##VkPhysicalDeviceRayTracingPipelinePropertiesKHR{@code ::maxRayDispatchInvocationCount}</li>
        </ul>
        """

    uint32_t("width", "the width of the ray trace query dimensions.")
    uint32_t("height", "height of the ray trace query dimensions.")
    uint32_t("depth", "depth of the ray trace query dimensions.")
}

val VkPhysicalDeviceRayQueryFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceRayQueryFeaturesKHR") {
    documentation =
        """
        Structure describing the ray query features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceRayQueryFeaturesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceRayQueryFeaturesKHR <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("rayQuery", "indicates whether the implementation supports ray query ({@code OpRayQueryProceedKHR}) functionality.")
}

val VkPipelineCoverageModulationStateCreateInfoNV = struct(Module.VULKAN, "VkPipelineCoverageModulationStateCreateInfoNV") {
    documentation =
        """
        Structure specifying parameters controlling coverage modulation.

        <h5>Description</h5>
        If {@code coverageModulationTableEnable} is #FALSE, then for each color sample the associated bits of the pixel coverage are counted and divided by the number of associated bits to produce a modulation factor <code>R</code> in the range <code>(0,1]</code> (a value of zero would have been killed due to a color coverage of 0). Specifically:

        <ul>
            <li><code>N</code> = value of {@code rasterizationSamples}</li>
            <li><code>M</code> = value of ##VkAttachmentDescription{@code ::samples} for any color attachments</li>
            <li><code>R = popcount(associated coverage bits) / (N / M)</code></li>
        </ul>

        If {@code coverageModulationTableEnable} is #TRUE, the value <code>R</code> is computed using a programmable lookup table. The lookup table has <code>N / M</code> elements, and the element of the table is selected by:

        <ul>
            <li><code>R = pCoverageModulationTable[popcount(associated coverage bits)-1]</code></li>
        </ul>

        Note that the table does not have an entry for <code>popcount(associated coverage bits) = 0</code>, because such samples would have been killed.

        The values of {@code pCoverageModulationTable} <b>may</b> be rounded to an implementation-dependent precision, which is at least as fine as <code>1 / N</code>, and clamped to <code>[0,1]</code>.

        For each color attachment with a floating-point or normalized color format, each fragment output color value is replicated to <code>M</code> values which <b>can</b> each be modulated (multiplied) by that color sample’s associated value of <code>R</code>. Which components are modulated is controlled by {@code coverageModulationMode}.

        If this structure is not included in the {@code pNext} chain, it is as if {@code coverageModulationMode} is #COVERAGE_MODULATION_MODE_NONE_NV.

        If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#fragops-coverage-reduction">coverage reduction mode</a> is #COVERAGE_REDUCTION_MODE_TRUNCATE_NV, each color sample is associated with only a single coverage sample. In this case, it is as if {@code coverageModulationMode} is #COVERAGE_MODULATION_MODE_NONE_NV.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code coverageModulationTableEnable} is #TRUE, {@code coverageModulationTableCount} <b>must</b> be equal to the number of rasterization samples divided by the number of color samples in the subpass</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code coverageModulationMode} <b>must</b> be a valid {@code VkCoverageModulationModeNV} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCoverageModulationStateCreateFlagsNV("flags", "reserved for future use.")
    VkCoverageModulationModeNV("coverageModulationMode", "a {@code VkCoverageModulationModeNV} value controlling which color components are modulated.")
    VkBool32("coverageModulationTableEnable", "controls whether the modulation factor is looked up from a table in {@code pCoverageModulationTable}.")
    AutoSize("pCoverageModulationTable", optional = true)..uint32_t("coverageModulationTableCount", "the number of elements in {@code pCoverageModulationTable}.")
    nullable..float.const.p("pCoverageModulationTable", "a table of modulation factors containing a value for each number of covered samples.")
}

val VkAttachmentSampleCountInfoNV = struct(Module.VULKAN, "VkAttachmentSampleCountInfoNV", alias = VkAttachmentSampleCountInfoAMD) {
    documentation = "See ##VkAttachmentSampleCountInfoAMD."

    Expression("#STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pColorAttachmentSamples", optional = true)..uint32_t("colorAttachmentCount", "")
    nullable..VkSampleCountFlagBits.const.p("pColorAttachmentSamples", "")
    VkSampleCountFlagBits("depthStencilAttachmentSamples", "")
}

val VkPhysicalDeviceShaderSMBuiltinsPropertiesNV = struct(Module.VULKAN, "VkPhysicalDeviceShaderSMBuiltinsPropertiesNV", mutable = false) {
    documentation =
        """
        Structure describing shader SM Builtins properties supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceShaderSMBuiltinsPropertiesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("shaderSMCount", "the number of SMs on the device.")
    uint32_t("shaderWarpsPerSM", "the maximum number of simultaneously executing warps on an SM.")
}

val VkPhysicalDeviceShaderSMBuiltinsFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceShaderSMBuiltinsFeaturesNV") {
    documentation =
        """
        Structure describing the shader SM Builtins features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceShaderSMBuiltinsFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceShaderSMBuiltinsFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("shaderSMBuiltins", "indicates whether the implementation supports the SPIR-V {@code ShaderSMBuiltinsNV} capability.")
}

val VkSamplerYcbcrConversionCreateInfoKHR = struct(Module.VULKAN, "VkSamplerYcbcrConversionCreateInfoKHR", alias = VkSamplerYcbcrConversionCreateInfo) {
    documentation = "See ##VkSamplerYcbcrConversionCreateInfo."

    Expression("#STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkFormat("format", "")
    VkSamplerYcbcrModelConversion("ycbcrModel", "")
    VkSamplerYcbcrRange("ycbcrRange", "")
    VkComponentMapping("components", "")
    VkChromaLocation("xChromaOffset", "")
    VkChromaLocation("yChromaOffset", "")
    VkFilter("chromaFilter", "")
    VkBool32("forceExplicitReconstruction", "")
}

val VkSamplerYcbcrConversionInfoKHR = struct(Module.VULKAN, "VkSamplerYcbcrConversionInfoKHR", alias = VkSamplerYcbcrConversionInfo) {
    documentation = "See ##VkSamplerYcbcrConversionInfo."

    Expression("#STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkSamplerYcbcrConversion("conversion", "")
}

val VkBindImagePlaneMemoryInfoKHR = struct(Module.VULKAN, "VkBindImagePlaneMemoryInfoKHR", alias = VkBindImagePlaneMemoryInfo) {
    documentation = "See ##VkBindImagePlaneMemoryInfo."

    Expression("#STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImageAspectFlagBits("planeAspect", "")
}

val VkImagePlaneMemoryRequirementsInfoKHR = struct(Module.VULKAN, "VkImagePlaneMemoryRequirementsInfoKHR", alias = VkImagePlaneMemoryRequirementsInfo) {
    documentation = "See ##VkImagePlaneMemoryRequirementsInfo."

    Expression("#STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImageAspectFlagBits("planeAspect", "")
}

val VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR", alias = VkPhysicalDeviceSamplerYcbcrConversionFeatures) {
    documentation = "See ##VkPhysicalDeviceSamplerYcbcrConversionFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("samplerYcbcrConversion", "")
}

val VkSamplerYcbcrConversionImageFormatPropertiesKHR = struct(Module.VULKAN, "VkSamplerYcbcrConversionImageFormatPropertiesKHR", mutable = false, alias = VkSamplerYcbcrConversionImageFormatProperties) {
    documentation = "See ##VkSamplerYcbcrConversionImageFormatProperties."

    Expression("#STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint32_t("combinedImageSamplerDescriptorCount", "")
}

val VkBindBufferMemoryInfoKHR = struct(Module.VULKAN, "VkBindBufferMemoryInfoKHR", alias = VkBindBufferMemoryInfo) {
    documentation = "See ##VkBindBufferMemoryInfo."

    Expression("#STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkBuffer("buffer", "")
    VkDeviceMemory("memory", "")
    VkDeviceSize("memoryOffset", "")
}

val VkBindImageMemoryInfoKHR = struct(Module.VULKAN, "VkBindImageMemoryInfoKHR", alias = VkBindImageMemoryInfo) {
    documentation = "See ##VkBindImageMemoryInfo."

    Expression("#STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImage("image", "")
    VkDeviceMemory("memory", "")
    VkDeviceSize("memoryOffset", "")
}

val VkDrmFormatModifierPropertiesEXT = struct(Module.VULKAN, "VkDrmFormatModifierPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure specifying properties of a format when combined with a DRM format modifier.

        <h5>Description</h5>
        The returned {@code drmFormatModifierTilingFeatures} <b>must</b> contain at least one bit.

        The implementation <b>must</b> not return {@code DRM_FORMAT_MOD_INVALID} in {@code drmFormatModifier}.

        An image’s <em>memory planecount</em> (as returned by {@code drmFormatModifierPlaneCount}) is distinct from its <em>format planecount</em> (in the sense of <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> Y′C<sub>B</sub>C<sub>R</sub> formats). In {@code VkImageAspectFlags}, each <code>VK_IMAGE_ASPECT_MEMORY_PLANE<em>_i_</em>BIT_EXT</code> represents a <em>memory plane</em> and each <code>VK_IMAGE_ASPECT_PLANE<em>_i_</em>BIT</code> a <em>format plane</em>.

        An image’s set of <em>format planes</em> is an ordered partition of the image’s <b>content</b> into separable groups of format components. The ordered partition is encoded in the name of each {@code VkFormat}. For example, #FORMAT_G8_B8R8_2PLANE_420_UNORM contains two <em>format planes</em>; the first plane contains the green component and the second plane contains the blue component and red component. If the format name does not contain {@code PLANE}, then the format contains a single plane; for example, #FORMAT_R8G8B8A8_UNORM. Some commands, such as #CmdCopyBufferToImage(), do not operate on all format components in the image, but instead operate only on the <em>format planes</em> explicitly chosen by the application and operate on each <em>format plane</em> independently.

        An image’s set of <em>memory planes</em> is an ordered partition of the image’s <b>memory</b> rather than the image’s <b>content</b>. Each <em>memory plane</em> is a contiguous range of memory. The union of an image’s <em>memory planes</em> is not necessarily contiguous.

        If an image is <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#glossary-linear-resource">linear</a>, then the partition is the same for <em>memory planes</em> and for <em>format planes</em>. Therefore, if the returned {@code drmFormatModifier} is {@code DRM_FORMAT_MOD_LINEAR}, then {@code drmFormatModifierPlaneCount} <b>must</b> equal the <em>format planecount</em>, and {@code drmFormatModifierTilingFeatures} <b>must</b> be identical to the ##VkFormatProperties2{@code ::linearTilingFeatures} returned in the same {@code pNext} chain.

        If an image is <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#glossary-linear-resource">non-linear</a>, then the partition of the image’s <b>memory</b> into <em>memory planes</em> is implementation-specific and <b>may</b> be unrelated to the partition of the image’s <b>content</b> into <em>format planes</em>. For example, consider an image whose {@code format} is #FORMAT_G8_B8_R8_3PLANE_420_UNORM, {@code tiling} is #IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, whose {@code drmFormatModifier} is not {@code DRM_FORMAT_MOD_LINEAR}, and {@code flags} lacks #IMAGE_CREATE_DISJOINT_BIT. The image has 3 <em>format planes</em>, and commands such #CmdCopyBufferToImage() act on each <em>format plane</em> independently as if the data of each <em>format plane</em> were separable from the data of the other planes. In a straightforward implementation, the implementation <b>may</b> store the image’s content in 3 adjacent <em>memory planes</em> where each <em>memory plane</em> corresponds exactly to a <em>format plane</em>. However, the implementation <b>may</b> also store the image’s content in a single <em>memory plane</em> where all format components are combined using an implementation-private block-compressed format; or the implementation <b>may</b> store the image’s content in a collection of 7 adjacent <em>memory planes</em> using an implementation-private sharding technique. Because the image is non-linear and non-disjoint, the implementation has much freedom when choosing the image’s placement in memory.

        The <em>memory planecount</em> applies to function parameters and structures only when the API specifies an explicit requirement on {@code drmFormatModifierPlaneCount}. In all other cases, the <em>memory planecount</em> is ignored.

        <h5>See Also</h5>
        ##VkDrmFormatModifierPropertiesListEXT
        """

    uint64_t("drmFormatModifier", "a <em>Linux DRM format modifier</em>.")
    uint32_t("drmFormatModifierPlaneCount", "the number of <em>memory planes</em> in any image created with {@code format} and {@code drmFormatModifier}. An image’s <em>memory planecount</em> is distinct from its <em>format planecount</em>, as explained below.")
    VkFormatFeatureFlags("drmFormatModifierTilingFeatures", "a bitmask of {@code VkFormatFeatureFlagBits} that are supported by any image created with {@code format} and {@code drmFormatModifier}.")
}

val VkDrmFormatModifierPropertiesListEXT = struct(Module.VULKAN, "VkDrmFormatModifierPropertiesListEXT", mutable = false) {
    documentation =
        """
        Structure specifying the list of DRM format modifiers supported for a format.

        <h5>Description</h5>
        If {@code pDrmFormatModifierProperties} is {@code NULL}, then the function returns in {@code drmFormatModifierCount} the number of modifiers compatible with the queried {@code format}. Otherwise, the application <b>must</b> set {@code drmFormatModifierCount} to the length of the array {@code pDrmFormatModifierProperties}; the function will write at most {@code drmFormatModifierCount} elements to the array, and will return in {@code drmFormatModifierCount} the number of elements written.

        Among the elements in array {@code pDrmFormatModifierProperties}, each returned {@code drmFormatModifier} <b>must</b> be unique.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT</li>
        </ul>

        <h5>See Also</h5>
        ##VkDrmFormatModifierPropertiesEXT
        """

    Expression("#STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    AutoSize("pDrmFormatModifierProperties", optional = true)..uint32_t("drmFormatModifierCount", "an inout parameter related to the number of modifiers compatible with the {@code format}, as described below.")
    nullable..VkDrmFormatModifierPropertiesEXT.p("pDrmFormatModifierProperties", "either {@code NULL} or a pointer to an array of ##VkDrmFormatModifierPropertiesEXT structures.")
}

val VkPhysicalDeviceImageDrmFormatModifierInfoEXT = struct(Module.VULKAN, "VkPhysicalDeviceImageDrmFormatModifierInfoEXT") {
    documentation =
        """
        Structure specifying a DRM format modifier as image creation parameter.

        <h5>Description</h5>
        If the {@code drmFormatModifier} is incompatible with the parameters specified in ##VkPhysicalDeviceImageFormatInfo2 and its {@code pNext} chain, then #GetPhysicalDeviceImageFormatProperties2() returns #ERROR_FORMAT_NOT_SUPPORTED. The implementation <b>must</b> support the query of any {@code drmFormatModifier}, including unknown and invalid modifier values.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code sharingMode} is #SHARING_MODE_CONCURRENT, then {@code pQueueFamilyIndices} <b>must</b> be a valid pointer to an array of {@code queueFamilyIndexCount} {@code uint32_t} values</li>
            <li>If {@code sharingMode} is #SHARING_MODE_CONCURRENT, then {@code queueFamilyIndexCount} <b>must</b> be greater than 1</li>
            <li>If {@code sharingMode} is #SHARING_MODE_CONCURRENT, each element of {@code pQueueFamilyIndices} <b>must</b> be unique and <b>must</b> be less than the {@code pQueueFamilyPropertyCount} returned by #GetPhysicalDeviceQueueFamilyProperties2() for the {@code physicalDevice} that was used to create {@code device}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT</li>
            <li>{@code sharingMode} <b>must</b> be a valid {@code VkSharingMode} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint64_t("drmFormatModifier", "the image’s <em>Linux DRM format modifier</em>, corresponding to ##VkImageDrmFormatModifierExplicitCreateInfoEXT{@code ::modifier} or to ##VkImageDrmFormatModifierListCreateInfoEXT{@code ::pModifiers}.")
    VkSharingMode("sharingMode", "specifies how the image will be accessed by multiple queue families.")
    AutoSize("pQueueFamilyIndices", optional = true)..uint32_t("queueFamilyIndexCount", "the number of entries in the {@code pQueueFamilyIndices} array.")
    nullable..uint32_t.const.p("pQueueFamilyIndices", "a pointer to an array of queue families that will access the image. It is ignored if {@code sharingMode} is not #SHARING_MODE_CONCURRENT.")
}

val VkImageDrmFormatModifierListCreateInfoEXT = struct(Module.VULKAN, "VkImageDrmFormatModifierListCreateInfoEXT") {
    documentation =
        """
        Specify that an image must be created with a DRM format modifier from the provided list.

        <h5>Valid Usage</h5>
        <ul>
            <li>Each <em>modifier</em> in {@code pDrmFormatModifiers} <b>must</b> be compatible with the parameters in ##VkImageCreateInfo and its {@code pNext} chain, as determined by querying ##VkPhysicalDeviceImageFormatInfo2 extended with ##VkPhysicalDeviceImageDrmFormatModifierInfoEXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT</li>
            <li>{@code pDrmFormatModifiers} <b>must</b> be a valid pointer to an array of {@code drmFormatModifierCount} {@code uint64_t} values</li>
            <li>{@code drmFormatModifierCount} <b>must</b> be greater than 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pDrmFormatModifiers")..uint32_t("drmFormatModifierCount", "the length of the {@code pDrmFormatModifiers} array.")
    uint64_t.const.p("pDrmFormatModifiers", "a pointer to an array of <em>Linux DRM format modifiers</em>.")
}

val VkImageDrmFormatModifierExplicitCreateInfoEXT = struct(Module.VULKAN, "VkImageDrmFormatModifierExplicitCreateInfoEXT") {
    documentation =
        """
        Specify that an image be created with the provided DRM format modifier and explicit memory layout.

        <h5>Description</h5>
        The {@code i}<sup>th</sup> member of {@code pPlaneLayouts} describes the layout of the image’s {@code i}<sup>th</sup> <em>memory plane</em> (that is, <code>VK_IMAGE_ASPECT_MEMORY_PLANE<em>_i_</em>BIT_EXT</code>). In each element of {@code pPlaneLayouts}, the implementation <b>must</b> ignore {@code size}. The implementation calculates the size of each plane, which the application <b>can</b> query with #GetImageSubresourceLayout().

        When creating an image with ##VkImageDrmFormatModifierExplicitCreateInfoEXT, it is the application’s responsibility to satisfy all valid usage requirements. However, the implementation <b>must</b> validate that the provided {@code pPlaneLayouts}, when combined with the provided {@code drmFormatModifier} and other creation parameters in ##VkImageCreateInfo and its {@code pNext} chain, produce a valid image. (This validation is necessarily implementation-dependent and outside the scope of Vulkan, and therefore not described by valid usage requirements). If this validation fails, then #CreateImage() returns #ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code drmFormatModifier} <b>must</b> be compatible with the parameters in ##VkImageCreateInfo and its {@code pNext} chain, as determined by querying ##VkPhysicalDeviceImageFormatInfo2 extended with ##VkPhysicalDeviceImageDrmFormatModifierInfoEXT</li>
            <li>{@code drmFormatModifierPlaneCount} <b>must</b> be equal to the ##VkDrmFormatModifierPropertiesEXT{@code ::drmFormatModifierPlaneCount} associated with ##VkImageCreateInfo{@code ::format} and {@code drmFormatModifier}, as found by querying ##VkDrmFormatModifierPropertiesListEXT</li>
            <li>For each element of {@code pPlaneLayouts}, {@code size} <b>must</b> be 0</li>
            <li>For each element of {@code pPlaneLayouts}, {@code arrayPitch} <b>must</b> be 0 if ##VkImageCreateInfo{@code ::arrayLayers} is 1</li>
            <li>For each element of {@code pPlaneLayouts}, {@code depthPitch} <b>must</b> be 0 if ##VkImageCreateInfo{@code ::extent.depth} is 1</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT</li>
            <li>{@code pPlaneLayouts} <b>must</b> be a valid pointer to an array of {@code drmFormatModifierPlaneCount} ##VkSubresourceLayout structures</li>
            <li>{@code drmFormatModifierPlaneCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkSubresourceLayout
        """

    Expression("#STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint64_t("drmFormatModifier", "the <em>Linux DRM format modifier</em> with which the image will be created.")
    AutoSize("pPlaneLayouts")..uint32_t("drmFormatModifierPlaneCount", "the number of <em>memory planes</em> in the image (as reported by ##VkDrmFormatModifierPropertiesEXT) as well as the length of the {@code pPlaneLayouts} array.")
    VkSubresourceLayout.const.p("pPlaneLayouts", "a pointer to an array of ##VkSubresourceLayout structures describing the image’s <em>memory planes</em>.")
}

val VkImageDrmFormatModifierPropertiesEXT = struct(Module.VULKAN, "VkImageDrmFormatModifierPropertiesEXT", mutable = false) {
    documentation =
        """
        Properties of an image’s Linux DRM format modifier.

        <h5>Description</h5>
        If the {@code image} was created with ##VkImageDrmFormatModifierListCreateInfoEXT, then the returned {@code drmFormatModifier} <b>must</b> belong to the list of modifiers provided at time of image creation in ##VkImageDrmFormatModifierListCreateInfoEXT{@code ::pDrmFormatModifiers}. If the {@code image} was created with ##VkImageDrmFormatModifierExplicitCreateInfoEXT, then the returned {@code drmFormatModifier} <b>must</b> be the modifier provided at time of image creation in ##VkImageDrmFormatModifierExplicitCreateInfoEXT{@code ::drmFormatModifier}.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetImageDrmFormatModifierPropertiesEXT()
        """

    Expression("#STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint64_t("drmFormatModifier", "returns the image’s <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#glossary-drm-format-modifier\">Linux DRM format modifier</a>.")
}

val VkDrmFormatModifierProperties2EXT = struct(Module.VULKAN, "VkDrmFormatModifierProperties2EXT", mutable = false) {
    documentation =
        """
        Structure specifying properties of a format when combined with a DRM format modifier.

        <h5>See Also</h5>
        ##VkDrmFormatModifierPropertiesList2EXT
        """

    uint64_t("drmFormatModifier", "a <em>Linux DRM format modifier</em>.")
    uint32_t("drmFormatModifierPlaneCount", "the number of <em>memory planes</em> in any image created with {@code format} and {@code drmFormatModifier}. An image’s <em>memory planecount</em> is distinct from its <em>format planecount</em>, as explained below.")
    VkFormatFeatureFlags2("drmFormatModifierTilingFeatures", "a bitmask of {@code VkFormatFeatureFlagBits2} that are supported by any image created with {@code format} and {@code drmFormatModifier}.")
}

val VkDrmFormatModifierPropertiesList2EXT = struct(Module.VULKAN, "VkDrmFormatModifierPropertiesList2EXT", mutable = false) {
    documentation =
        """
        Structure specifying the list of DRM format modifiers supported for a format.

        <h5>Description</h5>
        If {@code pDrmFormatModifierProperties} is {@code NULL}, the number of modifiers compatible with the queried {@code format} is returned in {@code drmFormatModifierCount}. Otherwise, the application <b>must</b> set {@code drmFormatModifierCount} to the length of the array {@code pDrmFormatModifierProperties}; the function will write at most {@code drmFormatModifierCount} elements to the array, and will return in {@code drmFormatModifierCount} the number of elements written.

        Among the elements in array {@code pDrmFormatModifierProperties}, each returned {@code drmFormatModifier} <b>must</b> be unique.

        Among the elements in array {@code pDrmFormatModifierProperties}, the bits reported in {@code drmFormatModifierTilingFeatures} <b>must</b> include the bits reported in the corresponding element of ##VkDrmFormatModifierPropertiesListEXT{@code ::pDrmFormatModifierProperties}.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT</li>
        </ul>

        <h5>See Also</h5>
        ##VkDrmFormatModifierProperties2EXT
        """

    Expression("#STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    AutoSize("pDrmFormatModifierProperties", optional = true)..uint32_t("drmFormatModifierCount", "an inout parameter related to the number of modifiers compatible with the {@code format}, as described below.")
    nullable..VkDrmFormatModifierProperties2EXT.p("pDrmFormatModifierProperties", "either {@code NULL} or a pointer to an array of ##VkDrmFormatModifierProperties2EXT structures.")
}

val VkValidationCacheCreateInfoEXT = struct(Module.VULKAN, "VkValidationCacheCreateInfoEXT") {
    documentation =
        """
        Structure specifying parameters of a newly created validation cache.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code initialDataSize} is not 0, it <b>must</b> be equal to the size of {@code pInitialData}, as returned by {@code vkGetValidationCacheDataEXT} when {@code pInitialData} was originally retrieved</li>
            <li>If {@code initialDataSize} is not 0, {@code pInitialData} <b>must</b> have been retrieved from a previous call to {@code vkGetValidationCacheDataEXT}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>If {@code initialDataSize} is not 0, {@code pInitialData} <b>must</b> be a valid pointer to an array of {@code initialDataSize} bytes</li>
        </ul>

        <h5>See Also</h5>
        #CreateValidationCacheEXT()
        """

    Expression("#STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkValidationCacheCreateFlagsEXT("flags", "reserved for future use.")
    AutoSize("pInitialData", optional = true)..size_t("initialDataSize", "the number of bytes in {@code pInitialData}. If {@code initialDataSize} is zero, the validation cache will initially be empty.")
    void.const.p("pInitialData", "a pointer to previously retrieved validation cache data. If the validation cache data is incompatible (as defined below) with the device, the validation cache will be initially empty. If {@code initialDataSize} is zero, {@code pInitialData} is ignored.")
}

val VkShaderModuleValidationCacheCreateInfoEXT = struct(Module.VULKAN, "VkShaderModuleValidationCacheCreateInfoEXT") {
    documentation =
        """
        Specify validation cache to use during shader module creation.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT</li>
            <li>{@code validationCache} <b>must</b> be a valid {@code VkValidationCacheEXT} handle</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkValidationCacheEXT("validationCache", "the validation cache object from which the results of prior validation attempts will be written, and to which new validation results for this {@code VkShaderModule} will be written (if not already present).")
}

val VkDescriptorSetLayoutBindingFlagsCreateInfoEXT = struct(Module.VULKAN, "VkDescriptorSetLayoutBindingFlagsCreateInfoEXT", alias = VkDescriptorSetLayoutBindingFlagsCreateInfo) {
    documentation = "See ##VkDescriptorSetLayoutBindingFlagsCreateInfo."

    Expression("#STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pBindingFlags", optional = true)..uint32_t("bindingCount", "")
    nullable..VkDescriptorBindingFlags.const.p("pBindingFlags", "")
}

val VkPhysicalDeviceDescriptorIndexingFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceDescriptorIndexingFeaturesEXT", alias = VkPhysicalDeviceDescriptorIndexingFeatures) {
    documentation = "See ##VkPhysicalDeviceDescriptorIndexingFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("shaderInputAttachmentArrayDynamicIndexing", "")
    VkBool32("shaderUniformTexelBufferArrayDynamicIndexing", "")
    VkBool32("shaderStorageTexelBufferArrayDynamicIndexing", "")
    VkBool32("shaderUniformBufferArrayNonUniformIndexing", "")
    VkBool32("shaderSampledImageArrayNonUniformIndexing", "")
    VkBool32("shaderStorageBufferArrayNonUniformIndexing", "")
    VkBool32("shaderStorageImageArrayNonUniformIndexing", "")
    VkBool32("shaderInputAttachmentArrayNonUniformIndexing", "")
    VkBool32("shaderUniformTexelBufferArrayNonUniformIndexing", "")
    VkBool32("shaderStorageTexelBufferArrayNonUniformIndexing", "")
    VkBool32("descriptorBindingUniformBufferUpdateAfterBind", "")
    VkBool32("descriptorBindingSampledImageUpdateAfterBind", "")
    VkBool32("descriptorBindingStorageImageUpdateAfterBind", "")
    VkBool32("descriptorBindingStorageBufferUpdateAfterBind", "")
    VkBool32("descriptorBindingUniformTexelBufferUpdateAfterBind", "")
    VkBool32("descriptorBindingStorageTexelBufferUpdateAfterBind", "")
    VkBool32("descriptorBindingUpdateUnusedWhilePending", "")
    VkBool32("descriptorBindingPartiallyBound", "")
    VkBool32("descriptorBindingVariableDescriptorCount", "")
    VkBool32("runtimeDescriptorArray", "")
}

val VkPhysicalDeviceDescriptorIndexingPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceDescriptorIndexingPropertiesEXT", mutable = false, alias = VkPhysicalDeviceDescriptorIndexingProperties) {
    documentation = "See ##VkPhysicalDeviceDescriptorIndexingProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint32_t("maxUpdateAfterBindDescriptorsInAllPools", "")
    VkBool32("shaderUniformBufferArrayNonUniformIndexingNative", "")
    VkBool32("shaderSampledImageArrayNonUniformIndexingNative", "")
    VkBool32("shaderStorageBufferArrayNonUniformIndexingNative", "")
    VkBool32("shaderStorageImageArrayNonUniformIndexingNative", "")
    VkBool32("shaderInputAttachmentArrayNonUniformIndexingNative", "")
    VkBool32("robustBufferAccessUpdateAfterBind", "")
    VkBool32("quadDivergentImplicitLod", "")
    uint32_t("maxPerStageDescriptorUpdateAfterBindSamplers", "")
    uint32_t("maxPerStageDescriptorUpdateAfterBindUniformBuffers", "")
    uint32_t("maxPerStageDescriptorUpdateAfterBindStorageBuffers", "")
    uint32_t("maxPerStageDescriptorUpdateAfterBindSampledImages", "")
    uint32_t("maxPerStageDescriptorUpdateAfterBindStorageImages", "")
    uint32_t("maxPerStageDescriptorUpdateAfterBindInputAttachments", "")
    uint32_t("maxPerStageUpdateAfterBindResources", "")
    uint32_t("maxDescriptorSetUpdateAfterBindSamplers", "")
    uint32_t("maxDescriptorSetUpdateAfterBindUniformBuffers", "")
    uint32_t("maxDescriptorSetUpdateAfterBindUniformBuffersDynamic", "")
    uint32_t("maxDescriptorSetUpdateAfterBindStorageBuffers", "")
    uint32_t("maxDescriptorSetUpdateAfterBindStorageBuffersDynamic", "")
    uint32_t("maxDescriptorSetUpdateAfterBindSampledImages", "")
    uint32_t("maxDescriptorSetUpdateAfterBindStorageImages", "")
    uint32_t("maxDescriptorSetUpdateAfterBindInputAttachments", "")
}

val VkDescriptorSetVariableDescriptorCountAllocateInfoEXT = struct(Module.VULKAN, "VkDescriptorSetVariableDescriptorCountAllocateInfoEXT", alias = VkDescriptorSetVariableDescriptorCountAllocateInfo) {
    documentation = "See ##VkDescriptorSetVariableDescriptorCountAllocateInfo."

    Expression("#STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pDescriptorCounts", optional = true)..uint32_t("descriptorSetCount", "")
    uint32_t.const.p("pDescriptorCounts", "")
}

val VkDescriptorSetVariableDescriptorCountLayoutSupportEXT = struct(Module.VULKAN, "VkDescriptorSetVariableDescriptorCountLayoutSupportEXT", mutable = false, alias = VkDescriptorSetVariableDescriptorCountLayoutSupport) {
    documentation = "See ##VkDescriptorSetVariableDescriptorCountLayoutSupport."

    Expression("#STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint32_t("maxVariableDescriptorCount", "")
}

val VkPhysicalDevicePortabilitySubsetFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDevicePortabilitySubsetFeaturesKHR") {
    documentation =
        """
        Structure describing the features that may not be supported by an implementation of the Vulkan 1.0 Portability Subset.

        <h5>Description</h5>
        If the ##VkPhysicalDevicePortabilitySubsetFeaturesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDevicePortabilitySubsetFeaturesKHR <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("constantAlphaColorBlendFactors", "indicates whether this implementation supports constant <em>alpha</em> <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#framebuffer-blendfactors\">Blend Factors</a> used as source or destination <em>color</em> <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#framebuffer-blending\">Blending</a>.")
    VkBool32("events", "indicates whether this implementation supports synchronization using <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#synchronization-events\">Events</a>.")
    VkBool32("imageViewFormatReinterpretation", "indicates whether this implementation supports a {@code VkImageView} being created with a texel format containing a different number of components, or a different number of bits in each component, than the texel format of the underlying {@code VkImage}.")
    VkBool32("imageViewFormatSwizzle", "indicates whether this implementation supports remapping format components using ##VkImageViewCreateInfo{@code ::components}.")
    VkBool32("imageView2DOn3DImage", "indicates whether this implementation supports a {@code VkImage} being created with the #IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT flag set, permitting a 2D or 2D array image view to be created on a 3D {@code VkImage}.")
    VkBool32("multisampleArrayImage", "indicates whether this implementation supports a {@code VkImage} being created as a 2D array with multiple samples per texel.")
    VkBool32("mutableComparisonSamplers", "indicates whether this implementation allows descriptors with comparison samplers to be <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#descriptorsets-updates\">updated</a>.")
    VkBool32("pointPolygons", "indicates whether this implementation supports <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast\">Rasterization</a> using a <em>point</em> <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-polygonmode\">Polygon Mode</a>.")
    VkBool32("samplerMipLodBias", "indicates whether this implementation supports setting a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#samplers-mipLodBias\">mipmap LOD bias value</a> when <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#samplers\">creating a sampler</a>.")
    VkBool32("separateStencilMaskRef", "indicates whether this implementation supports separate front and back <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-stencil\">Stencil Test</a> reference values.")
    VkBool32("shaderSampleRateInterpolationFunctions", "indicates whether this implementation supports fragment shaders which use the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#spirvenv-capabilities-table-InterpolationFunction\">{@code InterpolationFunction}</a> capability and the extended instructions {@code InterpolateAtCentroid}, {@code InterpolateAtOffset}, and {@code InterpolateAtSample} from the {@code GLSL.std.450} extended instruction set. This member is only meaningful if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-sampleRateShading\">{@code sampleRateShading}</a> feature is supported.")
    VkBool32("tessellationIsolines", "indicates whether this implementation supports <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#tessellation-isoline-tessellation\">isoline output</a> from the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#tessellation\">Tessellation</a> stage of a graphics pipeline. This member is only meaningful if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-tessellationShader\">{@code tessellationShader}</a> feature is supported.")
    VkBool32("tessellationPointMode", "indicates whether this implementation supports <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#tessellation-point-mode\">point output</a> from the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#tessellation\">Tessellation</a> stage of a graphics pipeline. This member is only meaningful if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-tessellationShader\">{@code tessellationShader}</a> feature is supported.")
    VkBool32("triangleFans", "indicates whether this implementation supports <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#drawing-triangle-fans\">Triangle Fans</a> primitive topology.")
    VkBool32("vertexAttributeAccessBeyondStride", "indicates whether this implementation supports accessing a vertex input attribute beyond the stride of the corresponding vertex input binding.")
}

val VkPhysicalDevicePortabilitySubsetPropertiesKHR = struct(Module.VULKAN, "VkPhysicalDevicePortabilitySubsetPropertiesKHR") {
    documentation =
        """
        Structure describing additional properties supported by a portable implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDevicePortabilitySubsetPropertiesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("minVertexInputBindingStrideAlignment", "indicates the minimum alignment for vertex input strides. ##VkVertexInputBindingDescription{@code ::stride} <b>must</b> be a multiple of, and at least as large as, this value. The value <b>must</b> be a power of two.")
}

val VkShadingRatePaletteNV = struct(Module.VULKAN, "VkShadingRatePaletteNV") {
    documentation =
        """
        Structure specifying a single shading rate palette.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code shadingRatePaletteEntryCount} <b>must</b> be between 1 and ##VkPhysicalDeviceShadingRateImagePropertiesNV{@code ::shadingRatePaletteSize}, inclusive</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code pShadingRatePaletteEntries} <b>must</b> be a valid pointer to an array of {@code shadingRatePaletteEntryCount} valid {@code VkShadingRatePaletteEntryNV} values</li>
            <li>{@code shadingRatePaletteEntryCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineViewportShadingRateImageStateCreateInfoNV, #CmdSetViewportShadingRatePaletteNV()
        """

    AutoSize("pShadingRatePaletteEntries")..uint32_t("shadingRatePaletteEntryCount", "specifies the number of entries in the shading rate image palette.")
    VkShadingRatePaletteEntryNV.const.p("pShadingRatePaletteEntries", "a pointer to an array of {@code VkShadingRatePaletteEntryNV} enums defining the shading rate for each palette entry.")
}

val VkPipelineViewportShadingRateImageStateCreateInfoNV = struct(Module.VULKAN, "VkPipelineViewportShadingRateImageStateCreateInfoNV") {
    documentation =
        """
        Structure specifying parameters controlling shading rate image usage.

        <h5>Description</h5>
        If this structure is not present, {@code shadingRateImageEnable} is considered to be #FALSE, and the shading rate image and palettes are not used.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiViewport">{@code multiViewport}</a> feature is not enabled, {@code viewportCount} <b>must</b> be 0 or 1</li>
            <li>{@code viewportCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxViewports}</li>
            <li>If {@code shadingRateImageEnable} is #TRUE, {@code viewportCount} <b>must</b> be greater or equal to the {@code viewportCount} member of ##VkPipelineViewportStateCreateInfo</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV</li>
        </ul>

        <h5>See Also</h5>
        ##VkShadingRatePaletteNV
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("shadingRateImageEnable", "specifies whether shading rate image and palettes are used during rasterization.")
    AutoSize("pShadingRatePalettes", optional = true)..uint32_t("viewportCount", "specifies the number of per-viewport palettes used to translate values stored in shading rate images.")
    nullable..VkShadingRatePaletteNV.const.p("pShadingRatePalettes", "a pointer to an array of ##VkShadingRatePaletteNV structures defining the palette for each viewport. If the shading rate palette state is dynamic, this member is ignored.")
}

val VkPhysicalDeviceShadingRateImageFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceShadingRateImageFeaturesNV") {
    documentation =
        """
        Structure describing shading rate image features that can be supported by an implementation.

        <h5>Description</h5>
        See <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-shading-rate-image">Shading Rate Image</a> for more information.

        If the ##VkPhysicalDeviceShadingRateImageFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceShadingRateImageFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("shadingRateImage", "indicates that the implementation supports the use of a shading rate image to derive an effective shading rate for fragment processing. It also indicates that the implementation supports the {@code ShadingRateNV} SPIR-V execution mode.")
    VkBool32("shadingRateCoarseSampleOrder", "indicates that the implementation supports an application-configurable ordering of coverage samples in fragments larger than one pixel.")
}

val VkPhysicalDeviceShadingRateImagePropertiesNV = struct(Module.VULKAN, "VkPhysicalDeviceShadingRateImagePropertiesNV", mutable = false) {
    documentation =
        """
        Structure describing shading rate image limits that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceShadingRateImagePropertiesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        These properties are related to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-shading-rate-image">shading rate image</a> feature.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkExtent2D("shadingRateTexelSize", "indicates the width and height of the portion of the framebuffer corresponding to each texel in the shading rate image.")
    uint32_t("shadingRatePaletteSize", "indicates the maximum number of palette entries supported for the shading rate image.")
    uint32_t("shadingRateMaxCoarseSamples", "specifies the maximum number of coverage samples supported in a single fragment. If the product of the fragment size derived from the base shading rate and the number of coverage samples per pixel exceeds this limit, the final shading rate will be adjusted so that its product does not exceed the limit.")
}

val VkCoarseSampleLocationNV = struct(Module.VULKAN, "VkCoarseSampleLocationNV") {
    documentation =
        """
        Structure specifying parameters controlling shading rate image usage.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code pixelX} <b>must</b> be less than the width (in pixels) of the fragment</li>
            <li>{@code pixelY} <b>must</b> be less than the height (in pixels) of the fragment</li>
            <li>{@code sample} <b>must</b> be less than the number of coverage samples in each pixel belonging to the fragment</li>
        </ul>

        <h5>See Also</h5>
        ##VkCoarseSampleOrderCustomNV
        """

    uint32_t("pixelX", "added to the x coordinate of the upper-leftmost pixel of each fragment to identify the pixel containing the coverage sample.")
    uint32_t("pixelY", "added to the y coordinate of the upper-leftmost pixel of each fragment to identify the pixel containing the coverage sample.")
    uint32_t("sample", "the number of the coverage sample in the pixel identified by {@code pixelX} and {@code pixelY}.")
}

val VkCoarseSampleOrderCustomNV = struct(Module.VULKAN, "VkCoarseSampleOrderCustomNV") {
    documentation =
        """
        Structure specifying parameters controlling shading rate image usage.

        <h5>Description</h5>
        The ##VkCoarseSampleOrderCustomNV structure is used with a coverage sample ordering type of #COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV to specify the order of coverage samples for one combination of fragment width, fragment height, and coverage sample count.

        When using a custom sample ordering, element <em>j</em> in {@code pSampleLocations} specifies a specific pixel location and <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-multisampling-coverage-mask">sample index</a> that corresponds to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-multisampling-coverage-mask">coverage index</a> <em>j</em> in the multi-pixel fragment.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code shadingRate} <b>must</b> be a shading rate that generates fragments with more than one pixel</li>
            <li>{@code sampleCount} <b>must</b> correspond to a sample count enumerated in {@code VkSampleCountFlags} whose corresponding bit is set in ##VkPhysicalDeviceLimits{@code ::framebufferNoAttachmentsSampleCounts}</li>
            <li>{@code sampleLocationCount} <b>must</b> be equal to the product of {@code sampleCount}, the fragment width for {@code shadingRate}, and the fragment height for {@code shadingRate}</li>
            <li>{@code sampleLocationCount} <b>must</b> be less than or equal to the value of ##VkPhysicalDeviceShadingRateImagePropertiesNV{@code ::shadingRateMaxCoarseSamples}</li>
            <li>The array {@code pSampleLocations} <b>must</b> contain exactly one entry for every combination of valid values for {@code pixelX}, {@code pixelY}, and {@code sample} in the structure ##VkCoarseSampleOrderCustomNV</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code shadingRate} <b>must</b> be a valid {@code VkShadingRatePaletteEntryNV} value</li>
            <li>{@code pSampleLocations} <b>must</b> be a valid pointer to an array of {@code sampleLocationCount} ##VkCoarseSampleLocationNV structures</li>
            <li>{@code sampleLocationCount} <b>must</b> be greater than 0</li>
        </ul>

        <h5>See Also</h5>
        ##VkCoarseSampleLocationNV, ##VkPipelineViewportCoarseSampleOrderStateCreateInfoNV, #CmdSetCoarseSampleOrderNV()
        """

    VkShadingRatePaletteEntryNV("shadingRate", "a shading rate palette entry that identifies the fragment width and height for the combination of fragment area and per-pixel coverage sample count to control.")
    uint32_t("sampleCount", "identifies the per-pixel coverage sample count for the combination of fragment area and coverage sample count to control.")
    AutoSize("pSampleLocations")..uint32_t("sampleLocationCount", "specifies the number of sample locations in the custom ordering.")
    VkCoarseSampleLocationNV.const.p("pSampleLocations", "a pointer to an array of ##VkCoarseSampleLocationNV structures specifying the location of each sample in the custom ordering.")
}

val VkPipelineViewportCoarseSampleOrderStateCreateInfoNV = struct(Module.VULKAN, "VkPipelineViewportCoarseSampleOrderStateCreateInfoNV") {
    documentation =
        """
        Structure specifying parameters controlling sample order in coarse fragments.

        <h5>Description</h5>
        If this structure is not present, {@code sampleOrderType} is considered to be #COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV.

        If {@code sampleOrderType} is #COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV, the coverage sample order used for any combination of fragment area and coverage sample count not enumerated in {@code pCustomSampleOrders} will be identical to that used for #COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV.

        If the pipeline was created with #DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV, the contents of this structure (if present) are ignored, and the coverage sample order is instead specified by #CmdSetCoarseSampleOrderNV().

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code sampleOrderType} is not #COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV, {@code customSamplerOrderCount} <b>must</b> be 0</li>
            <li>The array {@code pCustomSampleOrders} <b>must</b> not contain two structures with matching values for both the {@code shadingRate} and {@code sampleCount} members</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV</li>
            <li>{@code sampleOrderType} <b>must</b> be a valid {@code VkCoarseSampleOrderTypeNV} value</li>
            <li>If {@code customSampleOrderCount} is not 0, {@code pCustomSampleOrders} <b>must</b> be a valid pointer to an array of {@code customSampleOrderCount} valid ##VkCoarseSampleOrderCustomNV structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkCoarseSampleOrderCustomNV
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkCoarseSampleOrderTypeNV("sampleOrderType", "specifies the mechanism used to order coverage samples in fragments larger than one pixel.")
    AutoSize("pCustomSampleOrders", optional = true)..uint32_t("customSampleOrderCount", "specifies the number of custom sample orderings to use when ordering coverage samples.")
    VkCoarseSampleOrderCustomNV.const.p("pCustomSampleOrders", "a pointer to an array of {@code customSampleOrderCount} ##VkCoarseSampleOrderCustomNV structures, each structure specifying the coverage sample order for a single combination of fragment area and coverage sample count.")
}

val VkRayTracingShaderGroupCreateInfoNV = struct(Module.VULKAN, "VkRayTracingShaderGroupCreateInfoNV") {
    documentation =
        """
        Structure specifying shaders in a shader group.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code type} is #RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV then {@code generalShader} <b>must</b> be a valid index into ##VkRayTracingPipelineCreateInfoNV{@code ::pStages} referring to a shader of #SHADER_STAGE_RAYGEN_BIT_NV, #SHADER_STAGE_MISS_BIT_NV, or #SHADER_STAGE_CALLABLE_BIT_NV</li>
            <li>If {@code type} is #RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV then {@code closestHitShader}, {@code anyHitShader}, and {@code intersectionShader} <b>must</b> be #SHADER_UNUSED_NV</li>
            <li>If {@code type} is #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV then {@code intersectionShader} <b>must</b> be a valid index into ##VkRayTracingPipelineCreateInfoNV{@code ::pStages} referring to a shader of #SHADER_STAGE_INTERSECTION_BIT_NV</li>
            <li>If {@code type} is #RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV then {@code intersectionShader} <b>must</b> be #SHADER_UNUSED_NV</li>
            <li>{@code closestHitShader} <b>must</b> be either #SHADER_UNUSED_NV or a valid index into ##VkRayTracingPipelineCreateInfoNV{@code ::pStages} referring to a shader of #SHADER_STAGE_CLOSEST_HIT_BIT_NV</li>
            <li>{@code anyHitShader} <b>must</b> be either #SHADER_UNUSED_NV or a valid index into ##VkRayTracingPipelineCreateInfoNV{@code ::pStages} referring to a shader of #SHADER_STAGE_ANY_HIT_BIT_NV</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code type} <b>must</b> be a valid {@code VkRayTracingShaderGroupTypeKHR} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkRayTracingPipelineCreateInfoNV
        """

    Expression("#STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkRayTracingShaderGroupTypeKHR("type", "the type of hit group specified in this structure.")
    uint32_t("generalShader", "the index of the ray generation, miss, or callable shader from ##VkRayTracingPipelineCreateInfoNV{@code ::pStages} in the group if the shader group has {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV, and #SHADER_UNUSED_NV otherwise.")
    uint32_t("closestHitShader", "the optional index of the closest hit shader from ##VkRayTracingPipelineCreateInfoNV{@code ::pStages} in the group if the shader group has {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV or #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV, and #SHADER_UNUSED_NV otherwise.")
    uint32_t("anyHitShader", "the optional index of the any-hit shader from ##VkRayTracingPipelineCreateInfoNV{@code ::pStages} in the group if the shader group has {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV or #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV, and #SHADER_UNUSED_NV otherwise.")
    uint32_t("intersectionShader", "the index of the intersection shader from ##VkRayTracingPipelineCreateInfoNV{@code ::pStages} in the group if the shader group has {@code type} of #RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV, and #SHADER_UNUSED_NV otherwise.")
}

val VkRayTracingPipelineCreateInfoNV = struct(Module.VULKAN, "VkRayTracingPipelineCreateInfoNV") {
    documentation =
        """
        Structure specifying parameters of a newly created ray tracing pipeline.

        <h5>Description</h5>
        The parameters {@code basePipelineHandle} and {@code basePipelineIndex} are described in more detail in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#pipelines-pipeline-derivatives">Pipeline Derivatives</a>.

        If the {@code pNext} chain includes a ##VkPipelineCreateFlags2CreateInfo structure, ##VkPipelineCreateFlags2CreateInfo{@code ::flags} from that structure is used instead of {@code flags} from this structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain does not include a ##VkPipelineCreateFlags2CreateInfo structure, {@code flags} <b>must</b> be a valid combination of {@code VkPipelineCreateFlagBits} values</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineIndex} is -1, {@code basePipelineHandle} <b>must</b> be a valid ray tracing {@code VkPipeline} handle</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, and {@code basePipelineHandle} is #NULL_HANDLE, {@code basePipelineIndex} <b>must</b> be a valid index into the calling command’s {@code pCreateInfos} parameter</li>
            <li>If {@code flags} contains the #PIPELINE_CREATE_DERIVATIVE_BIT flag, {@code basePipelineIndex} <b>must</b> be -1 or {@code basePipelineHandle} <b>must</b> be #NULL_HANDLE</li>
            <li>If a push constant block is declared in a shader, a push constant range in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a push constant block is declared in a shader, the block must be contained inside the push constant range in {@code layout} that matches the stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, the corresponding descriptor set in {@code layout} <b>must</b> match the shader stage</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader, and the descriptor type is not #DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor type</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variable</a> is declared in a shader as an array, the corresponding descriptor set in {@code layout} <b>must</b> match the descriptor count</li>
            <li>If a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces-resources">resource variables</a> is declared in a shader as an array of descriptors, then the descriptor type of that variable <b>must</b> not be #DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK</li>
        </ul>

        <ul>
            <li>The shader code for the entry points identified by {@code pStages}, and the rest of the state identified by this structure <b>must</b> adhere to the pipeline linking rules described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#interfaces">Shader Interfaces</a> chapter</li>
            <li>The number of resources in {@code layout} accessible to each shader stage that is used by the pipeline <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxPerStageResources}</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-pipelineCreationCacheControl">{@code pipelineCreationCacheControl}</a> feature is not enabled, {@code flags} <b>must</b> not include #PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or #PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT</li>
            <li>The {@code stage} member of at least one element of {@code pStages} <b>must</b> be #SHADER_STAGE_RAYGEN_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_LIBRARY_BIT_KHR</li>
            <li>{@code maxRecursionDepth} <b>must</b> be less than or equal to ##VkPhysicalDeviceRayTracingPropertiesNV{@code ::maxRecursionDepth}</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV</li>
            <li>{@code flags} <b>must</b> not include both #PIPELINE_CREATE_DEFER_COMPILE_BIT_NV and #PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT at the same time</li>
            <li>If ##VkPipelineCreationFeedbackCreateInfo{@code ::pipelineStageCreationFeedbackCount} is not 0, it <b>must</b> be equal to {@code stageCount}</li>
            <li>The {@code stage} value in all {@code pStages} elements <b>must</b> be one of #SHADER_STAGE_RAYGEN_BIT_KHR, #SHADER_STAGE_ANY_HIT_BIT_KHR, #SHADER_STAGE_CLOSEST_HIT_BIT_KHR, #SHADER_STAGE_MISS_BIT_KHR, #SHADER_STAGE_INTERSECTION_BIT_KHR, or #SHADER_STAGE_CALLABLE_BIT_KHR</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV</li>
            <li>{@code flags} <b>must</b> not include #PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV</li>
            <li>Each {@code pNext} member of any structure (including this one) in the {@code pNext} chain <b>must</b> be either {@code NULL} or a pointer to a valid instance of ##VkPipelineCreateFlags2CreateInfo or ##VkPipelineCreationFeedbackCreateInfo</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code pStages} <b>must</b> be a valid pointer to an array of {@code stageCount} valid ##VkPipelineShaderStageCreateInfo structures</li>
            <li>{@code pGroups} <b>must</b> be a valid pointer to an array of {@code groupCount} valid ##VkRayTracingShaderGroupCreateInfoNV structures</li>
            <li>{@code layout} <b>must</b> be a valid {@code VkPipelineLayout} handle</li>
            <li>{@code stageCount} <b>must</b> be greater than 0</li>
            <li>{@code groupCount} <b>must</b> be greater than 0</li>
            <li>Both of {@code basePipelineHandle}, and {@code layout} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkPipelineShaderStageCreateInfo, ##VkRayTracingShaderGroupCreateInfoNV, #CreateRayTracingPipelinesNV()
        """

    Expression("#STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkPipelineCreateFlags2CreateInfo", "VkPipelineCreateFlags2CreateInfoKHR", "VkPipelineCreationFeedbackCreateInfo", "VkPipelineCreationFeedbackCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCreateFlags("flags", "a bitmask of {@code VkPipelineCreateFlagBits} specifying how the pipeline will be generated.")
    AutoSize("pStages")..uint32_t("stageCount", "the number of entries in the {@code pStages} array.")
    VkPipelineShaderStageCreateInfo.const.p("pStages", "a pointer to an array of ##VkPipelineShaderStageCreateInfo structures specifying the set of the shader stages to be included in the ray tracing pipeline.")
    AutoSize("pGroups")..uint32_t("groupCount", "the number of entries in the {@code pGroups} array.")
    VkRayTracingShaderGroupCreateInfoNV.const.p("pGroups", "a pointer to an array of ##VkRayTracingShaderGroupCreateInfoNV structures describing the set of the shader stages to be included in each shader group in the ray tracing pipeline.")
    uint32_t("maxRecursionDepth", "the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#ray-tracing-recursion-depth\">maximum recursion depth</a> of shaders executed by this pipeline.")
    VkPipelineLayout("layout", "the description of binding locations used by both the pipeline and descriptor sets used with the pipeline.")
    VkPipeline("basePipelineHandle", "a pipeline to derive from.")
    int32_t("basePipelineIndex", "an index into the {@code pCreateInfos} parameter to use as a pipeline to derive from.")
}

val VkGeometryTrianglesNV = struct(Module.VULKAN, "VkGeometryTrianglesNV") {
    documentation =
        """
        Structure specifying a triangle geometry in a bottom-level acceleration structure.

        <h5>Description</h5>
        If {@code indexType} is #INDEX_TYPE_NONE_NV, then this structure describes a set of triangles determined by {@code vertexCount}. Otherwise, this structure describes a set of indexed triangles determined by {@code indexCount}.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code vertexOffset} <b>must</b> be less than the size of {@code vertexData}</li>
            <li>{@code vertexOffset} <b>must</b> be a multiple of the component size of {@code vertexFormat}</li>
            <li>{@code vertexFormat} <b>must</b> be one of #FORMAT_R32G32B32_SFLOAT, #FORMAT_R32G32_SFLOAT, #FORMAT_R16G16B16_SFLOAT, #FORMAT_R16G16_SFLOAT, #FORMAT_R16G16_SNORM, or #FORMAT_R16G16B16_SNORM</li>
            <li>{@code vertexStride} <b>must</b> be less than or equal to <code>2<sup>32</sup>-1</code></li>
            <li>{@code indexOffset} <b>must</b> be less than the size of {@code indexData}</li>
            <li>{@code indexOffset} <b>must</b> be a multiple of the element size of {@code indexType}</li>
            <li>{@code indexType} <b>must</b> be #INDEX_TYPE_UINT16, #INDEX_TYPE_UINT32, or #INDEX_TYPE_NONE_NV</li>
            <li>{@code indexData} <b>must</b> be #NULL_HANDLE if {@code indexType} is #INDEX_TYPE_NONE_NV</li>
            <li>{@code indexData} <b>must</b> be a valid {@code VkBuffer} handle if {@code indexType} is not #INDEX_TYPE_NONE_NV</li>
            <li>{@code indexCount} <b>must</b> be 0 if {@code indexType} is #INDEX_TYPE_NONE_NV</li>
            <li>{@code transformOffset} <b>must</b> be less than the size of {@code transformData}</li>
            <li>{@code transformOffset} <b>must</b> be a multiple of 16</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>If {@code vertexData} is not #NULL_HANDLE, {@code vertexData} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>{@code vertexFormat} <b>must</b> be a valid {@code VkFormat} value</li>
            <li>If {@code indexData} is not #NULL_HANDLE, {@code indexData} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>{@code indexType} <b>must</b> be a valid {@code VkIndexType} value</li>
            <li>If {@code transformData} is not #NULL_HANDLE, {@code transformData} <b>must</b> be a valid {@code VkBuffer} handle</li>
            <li>Each of {@code indexData}, {@code transformData}, and {@code vertexData} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        ##VkGeometryDataNV
        """

    Expression("#STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBuffer("vertexData", "the buffer containing vertex data for this geometry.")
    VkDeviceSize("vertexOffset", "the offset in bytes within {@code vertexData} containing vertex data for this geometry.")
    uint32_t("vertexCount", "the number of valid vertices.")
    VkDeviceSize("vertexStride", "the stride in bytes between each vertex.")
    VkFormat("vertexFormat", "a {@code VkFormat} describing the format of each vertex element.")
    VkBuffer("indexData", "the buffer containing index data for this geometry.")
    VkDeviceSize("indexOffset", "the offset in bytes within {@code indexData} containing index data for this geometry.")
    uint32_t("indexCount", "the number of indices to include in this geometry.")
    VkIndexType("indexType", "a {@code VkIndexType} describing the format of each index.")
    VkBuffer("transformData", "an optional buffer containing an ##VkTransformMatrixNV structure defining a transformation to be applied to this geometry.")
    VkDeviceSize("transformOffset", "the offset in bytes in {@code transformData} of the transform information described above.")
}

val VkGeometryAABBNV = struct(Module.VULKAN, "VkGeometryAABBNV") {
    documentation =
        """
        Structure specifying axis-aligned bounding box geometry in a bottom-level acceleration structure.

        <h5>Description</h5>
        The AABB data in memory is six 32-bit floats consisting of the minimum x, y, and z values followed by the maximum x, y, and z values.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code offset} <b>must</b> be less than the size of {@code aabbData}</li>
            <li>{@code offset} <b>must</b> be a multiple of 8</li>
            <li>{@code stride} <b>must</b> be a multiple of 8</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_GEOMETRY_AABB_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>If {@code aabbData} is not #NULL_HANDLE, {@code aabbData} <b>must</b> be a valid {@code VkBuffer} handle</li>
        </ul>

        <h5>See Also</h5>
        ##VkGeometryDataNV
        """

    Expression("#STRUCTURE_TYPE_GEOMETRY_AABB_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBuffer("aabbData", "the buffer containing axis-aligned bounding box data.")
    uint32_t("numAABBs", "the number of AABBs in this geometry.")
    uint32_t("stride", "the stride in bytes between AABBs in {@code aabbData}.")
    VkDeviceSize("offset", "the offset in bytes of the first AABB in {@code aabbData}.")
}

val VkGeometryDataNV = struct(Module.VULKAN, "VkGeometryDataNV") {
    documentation =
        """
        Structure specifying geometry in a bottom-level acceleration structure.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code triangles} <b>must</b> be a valid ##VkGeometryTrianglesNV structure</li>
            <li>{@code aabbs} <b>must</b> be a valid ##VkGeometryAABBNV structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkGeometryAABBNV, ##VkGeometryNV, ##VkGeometryTrianglesNV
        """

    VkGeometryTrianglesNV("triangles", "contains triangle data if ##VkGeometryNV{@code ::geometryType} is #GEOMETRY_TYPE_TRIANGLES_NV.")
    VkGeometryAABBNV("aabbs", "contains axis-aligned bounding box data if ##VkGeometryNV{@code ::geometryType} is #GEOMETRY_TYPE_AABBS_NV.")
}

val VkGeometryNV = struct(Module.VULKAN, "VkGeometryNV") {
    documentation =
        """
        Structure specifying a geometry in a bottom-level acceleration structure.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code geometryType} <b>must</b> be #GEOMETRY_TYPE_TRIANGLES_NV or #GEOMETRY_TYPE_AABBS_NV</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_GEOMETRY_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code geometryType} <b>must</b> be a valid {@code VkGeometryTypeKHR} value</li>
            <li>{@code geometry} <b>must</b> be a valid ##VkGeometryDataNV structure</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkGeometryFlagBitsKHR} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureInfoNV, ##VkGeometryDataNV
        """

    Expression("#STRUCTURE_TYPE_GEOMETRY_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkGeometryTypeKHR("geometryType", "specifies the {@code VkGeometryTypeKHR} which this geometry refers to.")
    VkGeometryDataNV("geometry", "contains the geometry data as described in ##VkGeometryDataNV.")
    VkGeometryFlagsKHR("flags", "has {@code VkGeometryFlagBitsKHR} describing options for this geometry.")
}

val VkAccelerationStructureInfoNV = struct(Module.VULKAN, "VkAccelerationStructureInfoNV") {
    documentation =
        """
        Structure specifying the parameters of acceleration structure object.

        <h5>Description</h5>
        ##VkAccelerationStructureInfoNV contains information that is used both for acceleration structure creation with #CreateAccelerationStructureNV() and in combination with the actual geometric data to build the acceleration structure with #CmdBuildAccelerationStructureNV().

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code geometryCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceRayTracingPropertiesNV{@code ::maxGeometryCount}</li>
            <li>{@code instanceCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceRayTracingPropertiesNV{@code ::maxInstanceCount}</li>
            <li>The total number of triangles in all geometries <b>must</b> be less than or equal to ##VkPhysicalDeviceRayTracingPropertiesNV{@code ::maxTriangleCount}</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV then {@code geometryCount} <b>must</b> be 0</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then {@code instanceCount} <b>must</b> be 0</li>
            <li>If {@code type} is #ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then the {@code geometryType} member of each geometry in {@code pGeometries} <b>must</b> be the same</li>
            <li>{@code type} <b>must</b> not be #ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR</li>
            <li>If {@code flags} has the #BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV bit set, then it <b>must</b> not have the #BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV bit set</li>
            <li>{@code scratch} <b>must</b> have been created with #BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag</li>
            <li>If {@code instanceData} is not #NULL_HANDLE, {@code instanceData} <b>must</b> have been created with #BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code type} <b>must</b> be a valid {@code VkAccelerationStructureTypeKHR} value</li>
            <li>{@code flags} <b>must</b> be a valid combination of {@code VkBuildAccelerationStructureFlagBitsNV} values</li>
            <li>If {@code geometryCount} is not 0, {@code pGeometries} <b>must</b> be a valid pointer to an array of {@code geometryCount} valid ##VkGeometryNV structures</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureCreateInfoNV, ##VkGeometryNV, #CmdBuildAccelerationStructureNV()
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccelerationStructureTypeKHR("type", "a {@code VkAccelerationStructureTypeNV} value specifying the type of acceleration structure that will be created.")
    VkBuildAccelerationStructureFlagsNV("flags", "a bitmask of {@code VkBuildAccelerationStructureFlagBitsNV} specifying additional parameters of the acceleration structure.")
    uint32_t("instanceCount", "specifies the number of instances that will be in the new acceleration structure.")
    AutoSize("pGeometries", optional = true)..uint32_t("geometryCount", "specifies the number of geometries that will be in the new acceleration structure.")
    VkGeometryNV.const.p("pGeometries", "a pointer to an array of {@code geometryCount} ##VkGeometryNV structures containing the scene data being passed into the acceleration structure.")
}

val VkAccelerationStructureCreateInfoNV = struct(Module.VULKAN, "VkAccelerationStructureCreateInfoNV") {
    documentation =
        """
        Structure specifying the parameters of a newly created acceleration structure object.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code compactedSize} is not 0 then both {@code info.geometryCount} and {@code info.instanceCount} <b>must</b> be 0</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of ##VkOpaqueCaptureDescriptorDataCreateInfoEXT</li>
            <li>The {@code sType} value of each struct in the {@code pNext} chain <b>must</b> be unique</li>
            <li>{@code info} <b>must</b> be a valid ##VkAccelerationStructureInfoNV structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkAccelerationStructureInfoNV, #CreateAccelerationStructureNV()
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    PointerSetter(
        "VkOpaqueCaptureDescriptorDataCreateInfoEXT",
        prepend = true
    )..nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceSize("compactedSize", "the size from the result of #CmdWriteAccelerationStructuresPropertiesNV() if this acceleration structure is going to be the target of a compacting copy.")
    VkAccelerationStructureInfoNV("info", "the ##VkAccelerationStructureInfoNV structure specifying further parameters of the created acceleration structure.")
}

val VkBindAccelerationStructureMemoryInfoNV = struct(Module.VULKAN, "VkBindAccelerationStructureMemoryInfoNV") {
    documentation =
        """
        Structure specifying acceleration structure memory binding.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code accelerationStructure} <b>must</b> not already be backed by a memory object</li>
            <li>{@code memoryOffset} <b>must</b> be less than the size of {@code memory}</li>
            <li>{@code memory} <b>must</b> have been allocated using one of the memory types allowed in the {@code memoryTypeBits} member of the ##VkMemoryRequirements structure returned from a call to #GetAccelerationStructureMemoryRequirementsNV() with {@code accelerationStructure} and {@code type} of #ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV</li>
            <li>{@code memoryOffset} <b>must</b> be an integer multiple of the {@code alignment} member of the ##VkMemoryRequirements structure returned from a call to #GetAccelerationStructureMemoryRequirementsNV() with {@code accelerationStructure} and {@code type} of #ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV</li>
            <li>The {@code size} member of the ##VkMemoryRequirements structure returned from a call to #GetAccelerationStructureMemoryRequirementsNV() with {@code accelerationStructure} and {@code type} of #ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV <b>must</b> be less than or equal to the size of {@code memory} minus {@code memoryOffset}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code accelerationStructure} <b>must</b> be a valid {@code VkAccelerationStructureNV} handle</li>
            <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
            <li>If {@code deviceIndexCount} is not 0, {@code pDeviceIndices} <b>must</b> be a valid pointer to an array of {@code deviceIndexCount} {@code uint32_t} values</li>
            <li>Both of {@code accelerationStructure}, and {@code memory} <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
        </ul>

        <h5>See Also</h5>
        #BindAccelerationStructureMemoryNV()
        """

    Expression("#STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccelerationStructureNV("accelerationStructure", "the acceleration structure to be attached to memory.")
    VkDeviceMemory("memory", "a {@code VkDeviceMemory} object describing the device memory to attach.")
    VkDeviceSize("memoryOffset", "the start offset of the region of memory that is to be bound to the acceleration structure. The number of bytes returned in the ##VkMemoryRequirements{@code ::size} member in {@code memory}, starting from {@code memoryOffset} bytes, will be bound to the specified acceleration structure.")
    AutoSize("pDeviceIndices", optional = true)..uint32_t("deviceIndexCount", "the number of elements in {@code pDeviceIndices}.")
    uint32_t.const.p("pDeviceIndices", "a pointer to an array of device indices.")
}

val VkWriteDescriptorSetAccelerationStructureNV = struct(Module.VULKAN, "VkWriteDescriptorSetAccelerationStructureNV") {
    documentation =
        """
        Structure specifying acceleration structure descriptor information.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code accelerationStructureCount} <b>must</b> be equal to {@code descriptorCount} in the extended structure</li>
            <li>Each acceleration structure in {@code pAccelerationStructures} <b>must</b> have been created with #ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-nullDescriptor">{@code nullDescriptor}</a> feature is not enabled, each member of {@code pAccelerationStructures} <b>must</b> not be #NULL_HANDLE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV</li>
            <li>{@code pAccelerationStructures} <b>must</b> be a valid pointer to an array of {@code accelerationStructureCount} valid or #NULL_HANDLE {@code VkAccelerationStructureNV} handles</li>
            <li>{@code accelerationStructureCount} <b>must</b> be greater than 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pAccelerationStructures", optional = true)..uint32_t("accelerationStructureCount", "the number of elements in {@code pAccelerationStructures}.")
    nullable..VkAccelerationStructureNV.const.p("pAccelerationStructures", "a pointer to an array of {@code VkAccelerationStructureNV} structures specifying the acceleration structures to update.")
}

val VkAccelerationStructureMemoryRequirementsInfoNV = struct(Module.VULKAN, "VkAccelerationStructureMemoryRequirementsInfoNV") {
    documentation =
        """
        Structure specifying acceleration to query for memory requirements.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code type} <b>must</b> be a valid {@code VkAccelerationStructureMemoryRequirementsTypeNV} value</li>
            <li>{@code accelerationStructure} <b>must</b> be a valid {@code VkAccelerationStructureNV} handle</li>
        </ul>

        <h5>See Also</h5>
        #GetAccelerationStructureMemoryRequirementsNV()
        """

    Expression("#STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAccelerationStructureMemoryRequirementsTypeNV("type", "selects the type of memory requirement being queried. #ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV returns the memory requirements for the object itself. #ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV returns the memory requirements for the scratch memory when doing a build. #ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV returns the memory requirements for the scratch memory when doing an update.")
    VkAccelerationStructureNV("accelerationStructure", "the acceleration structure to be queried for memory requirements.")
}

val VkPhysicalDeviceRayTracingPropertiesNV = struct(Module.VULKAN, "VkPhysicalDeviceRayTracingPropertiesNV", mutable = false) {
    documentation =
        """
        Properties of the physical device for ray tracing.

        <h5>Description</h5>
        Due to the fact that the geometry, instance, and triangle counts are specified at acceleration structure creation as 32-bit values, {@code maxGeometryCount}, {@code maxInstanceCount}, and {@code maxTriangleCount} <b>must</b> not exceed <code>2<sup>32</sup>-1</code>.

        If the ##VkPhysicalDeviceRayTracingPropertiesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        Limits specified by this structure <b>must</b> match those specified with the same name in ##VkPhysicalDeviceAccelerationStructurePropertiesKHR and ##VkPhysicalDeviceRayTracingPipelinePropertiesKHR.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("shaderGroupHandleSize", "the size in bytes of the shader header.")
    uint32_t("maxRecursionDepth", "the maximum number of levels of recursion allowed in a trace command.")
    uint32_t("maxShaderGroupStride", "the maximum stride in bytes allowed between shader groups in the shader binding table.")
    uint32_t("shaderGroupBaseAlignment", "the <b>required</b> alignment in bytes for the base of the shader binding table.")
    uint64_t("maxGeometryCount", "the maximum number of geometries in the bottom level acceleration structure.")
    uint64_t("maxInstanceCount", "the maximum number of instances in the top level acceleration structure.")
    uint64_t("maxTriangleCount", "the maximum number of triangles in all geometries in the bottom level acceleration structure.")
    uint32_t("maxDescriptorSetAccelerationStructures", "the maximum number of acceleration structure descriptors that are allowed in a descriptor set.")
}

val VkTransformMatrixNV = struct(Module.VULKAN, "VkTransformMatrixNV", alias = VkTransformMatrixKHR) {
    documentation = "See ##VkTransformMatrixKHR."

    float("matrix", "")[3][4]
}

val VkAabbPositionsNV = struct(Module.VULKAN, "VkAabbPositionsNV", alias = VkAabbPositionsKHR) {
    documentation = "See ##VkAabbPositionsKHR."

    float("minX", "")
    float("minY", "")
    float("minZ", "")
    float("maxX", "")
    float("maxY", "")
    float("maxZ", "")
}

val VkAccelerationStructureInstanceNV = struct(Module.VULKAN, "VkAccelerationStructureInstanceNV", alias = VkAccelerationStructureInstanceKHR) {
    documentation = "See ##VkAccelerationStructureInstanceKHR."

    VkTransformMatrixKHR("transform", "")
    uint32_t("instanceCustomIndex", "", bits = 24)
    uint32_t("mask", "", bits = 8)
    uint32_t("instanceShaderBindingTableRecordOffset", "", bits = 24)
    VkGeometryInstanceFlagsKHR("flags", "", bits = 8)
    uint64_t("accelerationStructureReference", "")
}

val VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV") {
    documentation =
        """
        Structure describing the representative fragment test features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("representativeFragmentTest", "indicates whether the implementation supports the representative fragment test. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-rep-frag-test\">Representative Fragment Test</a>.")
}

val VkPipelineRepresentativeFragmentTestStateCreateInfoNV = struct(Module.VULKAN, "VkPipelineRepresentativeFragmentTestStateCreateInfoNV") {
    documentation =
        """
        Structure specifying representative fragment test.

        <h5>Description</h5>
        If this structure is not included in the {@code pNext} chain, {@code representativeFragmentTestEnable} is considered to be #FALSE, and the representative fragment test is disabled.

        If the active fragment shader does not specify the {@code EarlyFragmentTests} execution mode, the representative fragment shader test has no effect, even if enabled.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("representativeFragmentTestEnable", "controls whether the representative fragment test is enabled.")
}

val VkPhysicalDeviceMaintenance3PropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceMaintenance3PropertiesKHR", mutable = false, alias = VkPhysicalDeviceMaintenance3Properties) {
    documentation = "See ##VkPhysicalDeviceMaintenance3Properties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint32_t("maxPerSetDescriptors", "")
    VkDeviceSize("maxMemoryAllocationSize", "")
}

val VkDescriptorSetLayoutSupportKHR = struct(Module.VULKAN, "VkDescriptorSetLayoutSupportKHR", mutable = false, alias = VkDescriptorSetLayoutSupport) {
    documentation = "See ##VkDescriptorSetLayoutSupport."

    Expression("#STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkBool32("supported", "")
}

val VkPhysicalDeviceImageViewImageFormatInfoEXT = struct(Module.VULKAN, "VkPhysicalDeviceImageViewImageFormatInfoEXT") {
    documentation =
        """
        Structure for providing image view type.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT</li>
            <li>{@code imageViewType} <b>must</b> be a valid {@code VkImageViewType} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkImageViewType("imageViewType", "a {@code VkImageViewType} value specifying the type of the image view.")
}

val VkFilterCubicImageViewImageFormatPropertiesEXT = struct(Module.VULKAN, "VkFilterCubicImageViewImageFormatPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure for querying cubic filtering capabilities of an image view type.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pNext} chain of the ##VkImageFormatProperties2 structure includes a ##VkFilterCubicImageViewImageFormatPropertiesEXT structure, the {@code pNext} chain of the ##VkPhysicalDeviceImageFormatInfo2 structure <b>must</b> include a ##VkPhysicalDeviceImageViewImageFormatInfoEXT structure with an {@code imageViewType} that is compatible with {@code imageType}</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkBool32("filterCubic", "tells if image format, image type and image view type <b>can</b> be used with cubic filtering. This field is set by the implementation. An application-specified value is ignored.")
    VkBool32("filterCubicMinmax", "tells if image format, image type and image view type <b>can</b> be used with cubic filtering and minmax filtering. This field is set by the implementation. An application-specified value is ignored.")
}

val VkDeviceQueueGlobalPriorityCreateInfoEXT = struct(Module.VULKAN, "VkDeviceQueueGlobalPriorityCreateInfoEXT", alias = VkDeviceQueueGlobalPriorityCreateInfo) {
    documentation = "See ##VkDeviceQueueGlobalPriorityCreateInfo."

    Expression("#STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkQueueGlobalPriority("globalPriority", "")
}

val VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR", alias = VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures) {
    documentation = "See ##VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("shaderSubgroupExtendedTypes", "")
}

val VkPhysicalDevice8BitStorageFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDevice8BitStorageFeaturesKHR", alias = VkPhysicalDevice8BitStorageFeatures) {
    documentation = "See ##VkPhysicalDevice8BitStorageFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("storageBuffer8BitAccess", "")
    VkBool32("uniformAndStorageBuffer8BitAccess", "")
    VkBool32("storagePushConstant8", "")
}

val VkImportMemoryHostPointerInfoEXT = struct(Module.VULKAN, "VkImportMemoryHostPointerInfoEXT") {
    documentation =
        """
        Import memory from a host pointer.

        <h5>Description</h5>
        Importing memory from a host pointer shares ownership of the memory between the host and the Vulkan implementation. The application <b>can</b> continue to access the memory through the host pointer but it is the application’s responsibility to synchronize device and non-device access to the payload as defined in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#memory-device-hostaccess">Host Access to Device Memory Objects</a>.

        Applications <b>can</b> import the same payload into multiple instances of Vulkan and multiple times into a given Vulkan instance. However, implementations <b>may</b> fail to import the same payload multiple times into a given physical device due to platform constraints.

        Importing memory from a particular host pointer <b>may</b> not be possible due to additional platform-specific restrictions beyond the scope of this specification in which case the implementation <b>must</b> fail the memory import operation with the error code #ERROR_INVALID_EXTERNAL_HANDLE_KHR.

        Whether device memory objects imported from a host pointer hold a reference to their payload is undefined. As such, the application <b>must</b> ensure that the imported memory range remains valid and accessible for the lifetime of the imported memory object.

        Implementations <b>may</b> support importing host pointers for memory types which are not host-visible. In this case, after a successful call to #AllocateMemory(), the memory range imported from {@code pHostPointer} <b>must</b> not be accessed by the application until the {@code VkDeviceMemory} has been destroyed. Memory contents for the host memory becomes undefined on import, and is left undefined after the {@code VkDeviceMemory} has been destroyed. Applications <b>must</b> also not access host memory which is mapped to the same physical memory as {@code pHostPointer}, but mapped to a different host pointer while the {@code VkDeviceMemory} handle is valid. Implementations running on general-purpose operating systems <b>should</b> not support importing host pointers for memory types which are not host-visible.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Using host pointers to back non-host visible allocations is a platform-specific use case, and applications should not attempt to do this unless instructed by the platform.
        </div>

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code handleType} is not 0, it <b>must</b> be supported for import, as reported in ##VkExternalMemoryProperties</li>
            <li>If {@code handleType} is not 0, it <b>must</b> be #EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT or #EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT</li>
            <li>{@code pHostPointer} <b>must</b> be a pointer aligned to an integer multiple of ##VkPhysicalDeviceExternalMemoryHostPropertiesEXT{@code ::minImportedHostPointerAlignment}</li>
            <li>If {@code handleType} is #EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT, {@code pHostPointer} <b>must</b> be a pointer to {@code allocationSize} number of bytes of host memory, where {@code allocationSize} is the member of the ##VkMemoryAllocateInfo structure this structure is chained to</li>
            <li>If {@code handleType} is #EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT, {@code pHostPointer} <b>must</b> be a pointer to {@code allocationSize} number of bytes of host mapped foreign memory, where {@code allocationSize} is the member of the ##VkMemoryAllocateInfo structure this structure is chained to</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT</li>
            <li>{@code handleType} <b>must</b> be a valid {@code VkExternalMemoryHandleTypeFlagBits} value</li>
            <li>{@code pHostPointer} <b>must</b> be a pointer value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkExternalMemoryHandleTypeFlagBits("handleType", "a {@code VkExternalMemoryHandleTypeFlagBits} value specifying the handle type.")
    opaque_p("pHostPointer", "the host pointer to import from.")
}

val VkMemoryHostPointerPropertiesEXT = struct(Module.VULKAN, "VkMemoryHostPointerPropertiesEXT", mutable = false) {
    documentation =
        """
        Properties of external memory host pointer.

        <h5>Description</h5>
        The value returned by {@code memoryTypeBits} <b>should</b> only include bits that identify memory types which are host visible. Implementations <b>may</b> include bits that identify memory types which are not host visible. Behavior for imported pointers of such types is defined by <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#host-memory-import-non-visible-type">##VkImportMemoryHostPointerInfoEXT</a>.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetMemoryHostPointerPropertiesEXT()
        """

    Expression("#STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("memoryTypeBits", "a bitmask containing one bit set for every memory type which the specified host pointer <b>can</b> be imported as.")
}

val VkPhysicalDeviceExternalMemoryHostPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceExternalMemoryHostPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure describing external memory host pointer limits that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceExternalMemoryHostPropertiesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkDeviceSize("minImportedHostPointerAlignment", "the minimum <b>required</b> alignment, in bytes, for the base address and size of host pointers that <b>can</b> be imported to a Vulkan memory object. The value <b>must</b> be a power of two.")
}

val VkPhysicalDeviceShaderAtomicInt64FeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceShaderAtomicInt64FeaturesKHR", alias = VkPhysicalDeviceShaderAtomicInt64Features) {
    documentation = "See ##VkPhysicalDeviceShaderAtomicInt64Features."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("shaderBufferInt64Atomics", "")
    VkBool32("shaderSharedInt64Atomics", "")
}

val VkPhysicalDeviceShaderClockFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceShaderClockFeaturesKHR") {
    documentation =
        """
        Structure describing features supported by VK_KHR_shader_clock.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceShaderClockFeaturesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceShaderClockFeaturesKHR <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("shaderSubgroupClock", "indicates whether shaders <b>can</b> perform {@code Subgroup} scoped clock reads.")
    VkBool32("shaderDeviceClock", "indicates whether shaders <b>can</b> perform {@code Device} scoped clock reads.")
}

val VkPipelineCompilerControlCreateInfoAMD = struct(Module.VULKAN, "VkPipelineCompilerControlCreateInfoAMD") {
    documentation =
        """
        Structure used to pass compilation control flags to a pipeline.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD</li>
            <li>{@code compilerControlFlags} <b>must</b> be 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCompilerControlFlagsAMD("compilerControlFlags", "a bitmask of {@code VkPipelineCompilerControlFlagBitsAMD} affecting how the pipeline will be compiled.")
}

val _VkCalibratedTimestampInfoKHR = struct(Module.VULKAN, "VkCalibratedTimestampInfoKHR")
val VkCalibratedTimestampInfoEXT = struct(Module.VULKAN, "VkCalibratedTimestampInfoEXT", alias = _VkCalibratedTimestampInfoKHR) {
    documentation = "See ##VkCalibratedTimestampInfoKHR."

    Expression("#STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkTimeDomainKHR("timeDomain", "")
}

val VkCalibratedTimestampInfoKHR = struct(Module.VULKAN, "VkCalibratedTimestampInfoKHR") {
    documentation =
        """
        Structure specifying the input parameters of a calibrated timestamp query.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code timeDomain} <b>must</b> be one of the {@code VkTimeDomainKHR} values returned by #GetPhysicalDeviceCalibrateableTimeDomainsKHR()</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code timeDomain} <b>must</b> be a valid {@code VkTimeDomainKHR} value</li>
        </ul>

        <h5>See Also</h5>
        #GetCalibratedTimestampsEXT(), #GetCalibratedTimestampsKHR()
        """

    Expression("#STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkTimeDomainKHR("timeDomain", "a {@code VkTimeDomainKHR} value specifying the time domain from which the calibrated timestamp value should be returned.")
}

val VkPhysicalDeviceShaderCorePropertiesAMD = struct(Module.VULKAN, "VkPhysicalDeviceShaderCorePropertiesAMD", mutable = false) {
    documentation =
        """
        Structure describing shader core properties that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceShaderCorePropertiesAMD structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("shaderEngineCount", "an unsigned integer value indicating the number of shader engines found inside the shader core of the physical device.")
    uint32_t("shaderArraysPerEngineCount", "an unsigned integer value indicating the number of shader arrays inside a shader engine. Each shader array has its own scan converter, set of compute units, and a render back end (color and depth attachments). Shader arrays within a shader engine share shader processor input (wave launcher) and shader export (export buffer) units. Currently, a shader engine can have one or two shader arrays.")
    uint32_t("computeUnitsPerShaderArray", "an unsigned integer value indicating the physical number of compute units within a shader array. The active number of compute units in a shader array <b>may</b> be lower. A compute unit houses a set of SIMDs along with a sequencer module and a local data store.")
    uint32_t("simdPerComputeUnit", "an unsigned integer value indicating the number of SIMDs inside a compute unit. Each SIMD processes a single instruction at a time.")
    uint32_t("wavefrontsPerSimd", "")
    uint32_t("wavefrontSize", "an unsigned integer value indicating the maximum size of a subgroup.")
    uint32_t("sgprsPerSimd", "an unsigned integer value indicating the number of physical Scalar General-Purpose Registers (SGPRs) per SIMD.")
    uint32_t("minSgprAllocation", "an unsigned integer value indicating the minimum number of SGPRs allocated for a wave.")
    uint32_t("maxSgprAllocation", "an unsigned integer value indicating the maximum number of SGPRs allocated for a wave.")
    uint32_t("sgprAllocationGranularity", "an unsigned integer value indicating the granularity of SGPR allocation for a wave.")
    uint32_t("vgprsPerSimd", "an unsigned integer value indicating the number of physical Vector General-Purpose Registers (VGPRs) per SIMD.")
    uint32_t("minVgprAllocation", "an unsigned integer value indicating the minimum number of VGPRs allocated for a wave.")
    uint32_t("maxVgprAllocation", "an unsigned integer value indicating the maximum number of VGPRs allocated for a wave.")
    uint32_t("vgprAllocationGranularity", "an unsigned integer value indicating the granularity of VGPR allocation for a wave.")
}

val VkVideoDecodeH265ProfileInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH265ProfileInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifying H.265 decode profile.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoH265ProfileIdc("stdProfileIdc", "a {@code StdVideoH265ProfileIdc} value specifying the H.265 codec profile IDC, as defined in section A.3 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h265\">ITU-T H.265 Specification</a>.")
}

val VkVideoDecodeH265CapabilitiesKHR = struct(Module.VULKAN, "VkVideoDecodeH265CapabilitiesKHR", mutable = false) {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure describing H.265 decode capabilities.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    StdVideoH265LevelIdc("maxLevelIdc", "a {@code StdVideoH265LevelIdc} value indicating the maximum H.265 level supported by the profile, where enum constant {@code STD_VIDEO_H265_LEVEL_IDC_&lt;major&gt;_&lt;minor&gt;} identifies H.265 level {@code &lt;major&gt;.&lt;minor&gt;} as defined in section A.4 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h265\">ITU-T H.265 Specification</a>.")
}

val VkVideoDecodeH265SessionParametersAddInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH265SessionParametersAddInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.265 decoder parameter set information.

        <h5>Description</h5>
        This structure <b>can</b> be specified in the following places:

        <ul>
            <li>In the {@code pParametersAddInfo} member of the ##VkVideoDecodeH265SessionParametersCreateInfoKHR structure specified in the {@code pNext} chain of ##VkVideoSessionParametersCreateInfoKHR used to create a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters">video session parameters</a> object. In this case, if the video codec operation the video session parameters object is created with is #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then it defines the set of initial parameters to add to the created object (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#creating-video-session-parameters">Creating Video Session Parameters</a>).</li>
            <li>In the {@code pNext} chain of ##VkVideoSessionParametersUpdateInfoKHR. In this case, if the video codec operation the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters">video session parameters</a> object to be updated was created with is #VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR, then it defines the set of parameters to add to it (see <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#video-session-parameters-update">Updating Video Session Parameters</a>).</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>The {@code vps_video_parameter_set_id} member of each {@code StdVideoH265VideoParameterSet} structure specified in the elements of {@code pStdVPSs} <b>must</b> be unique within {@code pStdVPSs}</li>
            <li>The pair constructed from the {@code sps_video_parameter_set_id} and {@code sps_seq_parameter_set_id} members of each {@code StdVideoH265SequenceParameterSet} structure specified in the elements of {@code pStdSPSs} <b>must</b> be unique within {@code pStdSPSs}</li>
            <li>The triplet constructed from the {@code sps_video_parameter_set_id}, {@code pps_seq_parameter_set_id}, and {@code pps_pic_parameter_set_id} members of each {@code StdVideoH265PictureParameterSet} structure specified in the elements of {@code pStdPPSs} <b>must</b> be unique within {@code pStdPPSs}</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR</li>
            <li>If {@code stdVPSCount} is not 0, {@code pStdVPSs} <b>must</b> be a valid pointer to an array of {@code stdVPSCount} {@code StdVideoH265VideoParameterSet} values</li>
            <li>If {@code stdSPSCount} is not 0, {@code pStdSPSs} <b>must</b> be a valid pointer to an array of {@code stdSPSCount} {@code StdVideoH265SequenceParameterSet} values</li>
            <li>If {@code stdPPSCount} is not 0, {@code pStdPPSs} <b>must</b> be a valid pointer to an array of {@code stdPPSCount} {@code StdVideoH265PictureParameterSet} values</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoDecodeH265SessionParametersCreateInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pStdVPSs", optional = true)..uint32_t("stdVPSCount", "the number of elements in the {@code pStdVPSs} array.")
    StdVideoH265VideoParameterSet.const.p("pStdVPSs", "a pointer to an array of {@code StdVideoH265VideoParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h265-vps\">H.265 VPS</a> entries to add.")
    AutoSize("pStdSPSs", optional = true)..uint32_t("stdSPSCount", "the number of elements in the {@code pStdSPSs} array.")
    StdVideoH265SequenceParameterSet.const.p("pStdSPSs", "a pointer to an array of {@code StdVideoH265SequenceParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h265-sps\">H.265 SPS</a> entries to add.")
    AutoSize("pStdPPSs", optional = true)..uint32_t("stdPPSCount", "the number of elements in the {@code pStdPPSs} array.")
    StdVideoH265PictureParameterSet.const.p("pStdPPSs", "a pointer to an array of {@code StdVideoH265PictureParameterSet} structures describing the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h265-pps\">H.265 PPS</a> entries to add.")
}

val VkVideoDecodeH265SessionParametersCreateInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH265SessionParametersCreateInfoKHR") {
    documentation =
        """
        Structure specifies H.265 decoder parameter set information.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR</li>
            <li>If {@code pParametersAddInfo} is not {@code NULL}, {@code pParametersAddInfo} <b>must</b> be a valid pointer to a valid ##VkVideoDecodeH265SessionParametersAddInfoKHR structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkVideoDecodeH265SessionParametersAddInfoKHR
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("maxStdVPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h265-vps\">H.265 VPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    uint32_t("maxStdSPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h265-sps\">H.265 SPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    uint32_t("maxStdPPSCount", "the maximum number of <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h265-pps\">H.265 PPS</a> entries the created {@code VkVideoSessionParametersKHR} <b>can</b> contain.")
    nullable..VkVideoDecodeH265SessionParametersAddInfoKHR.const.p("pParametersAddInfo", "{@code NULL} or a pointer to a ##VkVideoDecodeH265SessionParametersAddInfoKHR structure specifying H.265 parameters to add upon object creation.")
}

val VkVideoDecodeH265PictureInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH265PictureInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.265 picture information when decoding a frame.

        <h5>Description</h5>
        This structure is specified in the {@code pNext} chain of the ##VkVideoDecodeInfoKHR structure passed to #CmdDecodeVideoKHR() to specify the codec-specific picture information for an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265">H.265 decode operation</a>.

        <dl>
            <dt>Decode Output Picture Information</dt>
            <dd><ul>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-picture-data-access">H.265 Decode Picture Data Access</a> section.</li>
                <li>The decode output picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-picture-info">H.265 picture information</a> provided in {@code pStdPictureInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Std Picture Information</dt>
            <dd><ul>
                <li>{@code reserved} is used only for padding purposes and is otherwise ignored;</li>
                <li>{@code flags.IrapPicFlag} as defined in section 3.73 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code flags.IdrPicFlag} as defined in section 3.67 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code flags.IsReference} as defined in section 3.132 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code sps_video_parameter_set_id}, {@code pps_seq_parameter_set_id}, and {@code pps_pic_parameter_set_id} are used to identify the active parameter sets, as described below;</li>
                <li>{@code PicOrderCntVal} as defined in section 8.3.1 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code NumBitsForSTRefPicSetInSlice} is the number of bits used in {@code st_ref_pic_set} when {@code short_term_ref_pic_set_sps_flag} is 0, or 0 otherwise, as defined in sections 7.4.7 and 7.4.8 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code NumDeltaPocsOfRefRpsIdx} is the value of {@code NumDeltaPocs[RefRpsIdx]} when {@code short_term_ref_pic_set_sps_flag} is 1, or 0 otherwise, as defined in sections 7.4.7 and 7.4.8 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code RefPicSetStCurrBefore}, {@code RefPicSetStCurrAfter}, and {@code RefPicSetLtCurr} are interpreted as defined in section 8.3.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a> where each element of these arrays either identifies an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-active-reference-picture-info">active reference picture</a> using its <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> index or contains the value {@code STD_VIDEO_H265_NO_REFERENCE_PICTURE} to indicate “no reference picture”;</li>
                <li>all other members are interpreted as defined in section 8.3.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>.</li>
            </ul></dd>
        </dl>

        Reference picture setup is controlled by the value of {@code StdVideoDecodeH265PictureInfo}{@code ::flags.IsReference}. If it is set and a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-reconstructed-picture-info">reconstructed picture</a> is specified, then the latter is used as the target of picture reconstruction to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">activate</a> the corresponding <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a>. If {@code StdVideoDecodeH265PictureInfo}{@code ::flags.IsReference} is not set, but a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-reconstructed-picture-info">reconstructed picture</a> is specified, then the corresponding picture reference associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> is invalidated, as described in the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">DPB Slot States</a> section.

        <dl>
            <dt>Active Parameter Sets</dt>
            <dd><ul>
                <li>The <em>active VPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-vps">VPS</a> identified by the key specified in {@code StdVideoDecodeH265PictureInfo}{@code ::sps_video_parameter_set_id}.</li>
                <li>The <em>active SPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-sps">SPS</a> identified by the key specified by the pair constructed from {@code StdVideoDecodeH265PictureInfo}{@code ::sps_video_parameter_set_id} and {@code StdVideoDecodeH265PictureInfo}{@code ::pps_seq_parameter_set_id}.</li>
                <li>The <em>active PPS</em> is the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-pps">PPS</a> identified by the key specified by the triplet constructed from {@code StdVideoDecodeH265PictureInfo}{@code ::sps_video_parameter_set_id}, {@code StdVideoDecodeH265PictureInfo}{@code ::pps_seq_parameter_set_id}, and {@code StdVideoDecodeH265PictureInfo}{@code ::pps_pic_parameter_set_id}.</li>
            </ul></dd>
        </dl>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR</li>
            <li>{@code pStdPictureInfo} <b>must</b> be a valid pointer to a valid {@code StdVideoDecodeH265PictureInfo} value</li>
            <li>{@code pSliceSegmentOffsets} <b>must</b> be a valid pointer to an array of {@code sliceSegmentCount} {@code uint32_t} values</li>
            <li>{@code sliceSegmentCount} <b>must</b> be greater than 0</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoDecodeH265PictureInfo.const.p("pStdPictureInfo", "a pointer to a {@code StdVideoDecodeH265PictureInfo} structure specifying <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#decode-h265-picture-info\">H.265 picture information</a>.")
    AutoSize("pSliceSegmentOffsets")..uint32_t("sliceSegmentCount", "the number of elements in {@code pSliceSegmentOffsets}.")
    uint32_t.const.p("pSliceSegmentOffsets", "a pointer to an array of {@code sliceSegmentCount} offsets specifying the start offset of the slice segments of the picture within the video bitstream buffer range specified in ##VkVideoDecodeInfoKHR.")
}

val VkVideoDecodeH265DpbSlotInfoKHR = struct(Module.VULKAN, "VkVideoDecodeH265DpbSlotInfoKHR") {
    javaImport("org.lwjgl.vulkan.video.*")
    documentation =
        """
        Structure specifies H.265 DPB information when decoding a frame.

        <h5>Description</h5>
        This structure is specified in the {@code pNext} chain of ##VkVideoDecodeInfoKHR{@code ::pSetupReferenceSlot}, if not {@code NULL}, and the {@code pNext} chain of the elements of ##VkVideoDecodeInfoKHR{@code ::pReferenceSlots} to specify the codec-specific reference picture information for an <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265">H.265 decode operation</a>.

        <dl>
            <dt>Active Reference Picture Information</dt>
            <dd><ul>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-picture-data-access">H.265 Decode Picture Data Access</a> section.</li>
                <li>The reference picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> index specified in the {@code slotIndex} member of the corresponding element of ##VkVideoDecodeInfoKHR{@code ::pReferenceSlots}.</li>
                <li>The reference picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-reference-info">H.265 reference information</a> provided in {@code pStdReferenceInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Reconstructed Picture Information</dt>
            <dd><ul>
                <li>The image subregion used is determined according to the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-picture-data-access">H.265 Decode Picture Data Access</a> section.</li>
                <li>If <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-ref-pic-setup">reference picture setup</a> is requested, then the reconstructed picture is used to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot-states">activate</a> the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#dpb-slot">DPB slot</a> with the index specified in ##VkVideoDecodeInfoKHR{@code ::pSetupReferenceSlot→slotIndex}.</li>
                <li>The reconstructed picture is associated with the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#decode-h265-reference-info">H.265 reference information</a> provided in {@code pStdReferenceInfo}.</li>
            </ul></dd>
        </dl>

        <dl>
            <dt>Std Reference Information</dt>
            <dd><ul>
                <li>{@code flags.used_for_long_term_reference} is used to indicate whether the picture is marked as “used for long-term reference” as defined in section 8.3.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>{@code flags.unused_for_reference} is used to indicate whether the picture is marked as “unused for reference” as defined in section 8.3.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>;</li>
                <li>all other members are interpreted as defined in section 8.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#itu-t-h265">ITU-T H.265 Specification</a>.</li>
            </ul></dd>
        </dl>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR</li>
            <li>{@code pStdReferenceInfo} <b>must</b> be a valid pointer to a valid {@code StdVideoDecodeH265ReferenceInfo} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    StdVideoDecodeH265ReferenceInfo.const.p("pStdReferenceInfo", "a pointer to a {@code StdVideoDecodeH265ReferenceInfo} structure specifying reference picture information described in section 8.3 of the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#itu-t-h265\">ITU-T H.265 Specification</a>.")
}

val VkDeviceQueueGlobalPriorityCreateInfoKHR = struct(Module.VULKAN, "VkDeviceQueueGlobalPriorityCreateInfoKHR", alias = VkDeviceQueueGlobalPriorityCreateInfo) {
    documentation = "See ##VkDeviceQueueGlobalPriorityCreateInfo."

    Expression("#STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkQueueGlobalPriority("globalPriority", "")
}

val VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR", alias = VkPhysicalDeviceGlobalPriorityQueryFeatures) {
    documentation = "See ##VkPhysicalDeviceGlobalPriorityQueryFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("globalPriorityQuery", "")
}

val VkQueueFamilyGlobalPriorityPropertiesKHR = struct(Module.VULKAN, "VkQueueFamilyGlobalPriorityPropertiesKHR", mutable = false, alias = VkQueueFamilyGlobalPriorityProperties) {
    javaImport("static org.lwjgl.vulkan.VK14.*")
    documentation = "See ##VkQueueFamilyGlobalPriorityProperties."

    Expression("#STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    AutoSize("priorities")..uint32_t("priorityCount", "")
    VkQueueGlobalPriority("priorities", "")["VK_MAX_GLOBAL_PRIORITY_SIZE"]
}

val VkDeviceMemoryOverallocationCreateInfoAMD = struct(Module.VULKAN, "VkDeviceMemoryOverallocationCreateInfoAMD") {
    documentation =
        """
        Specify memory overallocation behavior for a Vulkan device.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD</li>
            <li>{@code overallocationBehavior} <b>must</b> be a valid {@code VkMemoryOverallocationBehaviorAMD} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkMemoryOverallocationBehaviorAMD("overallocationBehavior", "the desired overallocation behavior.")
}

val VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure describing max value of vertex attribute divisor that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("maxVertexAttribDivisor", "the maximum value of the number of instances that will repeat the value of vertex attribute data when instanced rendering is enabled.")
}

val VkVertexInputBindingDivisorDescriptionEXT = struct(Module.VULKAN, "VkVertexInputBindingDivisorDescriptionEXT", alias = VkVertexInputBindingDivisorDescription) {
    documentation = "See ##VkVertexInputBindingDivisorDescription."

    uint32_t("binding", "")
    uint32_t("divisor", "")
}

val VkPipelineVertexInputDivisorStateCreateInfoEXT = struct(Module.VULKAN, "VkPipelineVertexInputDivisorStateCreateInfoEXT", alias = VkPipelineVertexInputDivisorStateCreateInfo) {
    documentation = "See ##VkPipelineVertexInputDivisorStateCreateInfo."

    Expression("#STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pVertexBindingDivisors")..uint32_t("vertexBindingDivisorCount", "")
    VkVertexInputBindingDivisorDescription.const.p("pVertexBindingDivisors", "")
}

val VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT", alias = VkPhysicalDeviceVertexAttributeDivisorFeatures) {
    documentation = "See ##VkPhysicalDeviceVertexAttributeDivisorFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("vertexAttributeInstanceRateDivisor", "")
    VkBool32("vertexAttributeInstanceRateZeroDivisor", "")
}

val VkPipelineCreationFeedbackCreateInfoEXT = struct(Module.VULKAN, "VkPipelineCreationFeedbackCreateInfoEXT", alias = VkPipelineCreationFeedbackCreateInfo) {
    documentation = "See ##VkPipelineCreationFeedbackCreateInfo."

    Expression("#STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkPipelineCreationFeedback.p("pPipelineCreationFeedback", "")
    AutoSize("pPipelineStageCreationFeedbacks", optional = true)..uint32_t("pipelineStageCreationFeedbackCount", "")
    VkPipelineCreationFeedback.p("pPipelineStageCreationFeedbacks", "")
}

val VkPipelineCreationFeedbackEXT = struct(Module.VULKAN, "VkPipelineCreationFeedbackEXT", mutable = false, alias = VkPipelineCreationFeedback) {
    documentation = "See ##VkPipelineCreationFeedback."

    VkPipelineCreationFeedbackFlags("flags", "")
    uint64_t("duration", "")
}

val VkConformanceVersionKHR = struct(Module.VULKAN, "VkConformanceVersionKHR", alias = VkConformanceVersion) {
    documentation = "See ##VkConformanceVersion."

    uint8_t("major", "")
    uint8_t("minor", "")
    uint8_t("subminor", "")
    uint8_t("patch", "")
}

val VkPhysicalDeviceDriverPropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceDriverPropertiesKHR", mutable = false, alias = VkPhysicalDeviceDriverProperties) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation = "See ##VkPhysicalDeviceDriverProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkDriverId("driverID", "")
    charUTF8("driverName", "")["VK_MAX_DRIVER_NAME_SIZE"]
    charUTF8("driverInfo", "")["VK_MAX_DRIVER_INFO_SIZE"]
    VkConformanceVersion("conformanceVersion", "")
}

val VkPhysicalDeviceFloatControlsPropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceFloatControlsPropertiesKHR", mutable = false, alias = VkPhysicalDeviceFloatControlsProperties) {
    documentation = "See ##VkPhysicalDeviceFloatControlsProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkShaderFloatControlsIndependence("denormBehaviorIndependence", "")
    VkShaderFloatControlsIndependence("roundingModeIndependence", "")
    VkBool32("shaderSignedZeroInfNanPreserveFloat16", "")
    VkBool32("shaderSignedZeroInfNanPreserveFloat32", "")
    VkBool32("shaderSignedZeroInfNanPreserveFloat64", "")
    VkBool32("shaderDenormPreserveFloat16", "")
    VkBool32("shaderDenormPreserveFloat32", "")
    VkBool32("shaderDenormPreserveFloat64", "")
    VkBool32("shaderDenormFlushToZeroFloat16", "")
    VkBool32("shaderDenormFlushToZeroFloat32", "")
    VkBool32("shaderDenormFlushToZeroFloat64", "")
    VkBool32("shaderRoundingModeRTEFloat16", "")
    VkBool32("shaderRoundingModeRTEFloat32", "")
    VkBool32("shaderRoundingModeRTEFloat64", "")
    VkBool32("shaderRoundingModeRTZFloat16", "")
    VkBool32("shaderRoundingModeRTZFloat32", "")
    VkBool32("shaderRoundingModeRTZFloat64", "")
}

val VkSubpassDescriptionDepthStencilResolveKHR = struct(Module.VULKAN, "VkSubpassDescriptionDepthStencilResolveKHR", alias = VkSubpassDescriptionDepthStencilResolve) {
    documentation = "See ##VkSubpassDescriptionDepthStencilResolve."

    Expression("#STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkResolveModeFlagBits("depthResolveMode", "")
    VkResolveModeFlagBits("stencilResolveMode", "")
    nullable..VkAttachmentReference2.const.p("pDepthStencilResolveAttachment", "")
}

val VkPhysicalDeviceDepthStencilResolvePropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceDepthStencilResolvePropertiesKHR", mutable = false, alias = VkPhysicalDeviceDepthStencilResolveProperties) {
    documentation = "See ##VkPhysicalDeviceDepthStencilResolveProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    VkResolveModeFlags("supportedDepthResolveModes", "")
    VkResolveModeFlags("supportedStencilResolveModes", "")
    VkBool32("independentResolveNone", "")
    VkBool32("independentResolve", "")
}

val _VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR")
val VkPhysicalDeviceComputeShaderDerivativesFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceComputeShaderDerivativesFeaturesNV", alias = _VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR) {
    documentation = "See ##VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("computeDerivativeGroupQuads", "")
    VkBool32("computeDerivativeGroupLinear", "")
}

val VkPhysicalDeviceMeshShaderFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceMeshShaderFeaturesNV") {
    documentation =
        """
        Structure describing mesh shading features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceMeshShaderFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceMeshShaderFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("taskShader", "specifies whether task shaders are supported. If this feature is not enabled, the #SHADER_STAGE_TASK_BIT_NV and #PIPELINE_STAGE_TASK_SHADER_BIT_NV enum values <b>must</b> not be used.")
    VkBool32("meshShader", "specifies whether mesh shaders are supported. If this feature is not enabled, the #SHADER_STAGE_MESH_BIT_NV and #PIPELINE_STAGE_MESH_SHADER_BIT_NV enum values <b>must</b> not be used.")
}

val VkPhysicalDeviceMeshShaderPropertiesNV = struct(Module.VULKAN, "VkPhysicalDeviceMeshShaderPropertiesNV", mutable = false) {
    documentation =
        """
        Structure describing mesh shading properties.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceMeshShaderPropertiesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("maxDrawMeshTasksCount", "the maximum number of local workgroups that <b>can</b> be launched by a single draw mesh tasks command. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#drawing-mesh-shading\">Programmable Mesh Shading</a>.")
    uint32_t("maxTaskWorkGroupInvocations", "the maximum total number of task shader invocations in a single local workgroup. The product of the X, Y, and Z sizes, as specified by the {@code LocalSize} or {@code LocalSizeId} execution mode in shader modules or by the object decorated by the {@code WorkgroupSize} decoration, <b>must</b> be less than or equal to this limit.")
    uint32_t("maxTaskWorkGroupSize", "the maximum size of a local task workgroup. These three values represent the maximum local workgroup size in the X, Y, and Z dimensions, respectively. The {@code x}, {@code y}, and {@code z} sizes, as specified by the {@code LocalSize} or {@code LocalSizeId} execution mode or by the object decorated by the {@code WorkgroupSize} decoration in shader modules, <b>must</b> be less than or equal to the corresponding limit.")[3]
    uint32_t("maxTaskTotalMemorySize", "the maximum number of bytes that the task shader can use in total for shared and output memory combined.")
    uint32_t("maxTaskOutputCount", "the maximum number of output tasks a single task shader workgroup can emit.")
    uint32_t("maxMeshWorkGroupInvocations", "the maximum total number of mesh shader invocations in a single local workgroup. The product of the X, Y, and Z sizes, as specified by the {@code LocalSize} or {@code LocalSizeId} execution mode in shader modules or by the object decorated by the {@code WorkgroupSize} decoration, <b>must</b> be less than or equal to this limit.")
    uint32_t("maxMeshWorkGroupSize", "the maximum size of a local mesh workgroup. These three values represent the maximum local workgroup size in the X, Y, and Z dimensions, respectively. The {@code x}, {@code y}, and {@code z} sizes, as specified by the {@code LocalSize} or {@code LocalSizeId} execution mode or by the object decorated by the {@code WorkgroupSize} decoration in shader modules, <b>must</b> be less than or equal to the corresponding limit.")[3]
    uint32_t("maxMeshTotalMemorySize", "the maximum number of bytes that the mesh shader can use in total for shared and output memory combined.")
    uint32_t("maxMeshOutputVertices", "the maximum number of vertices a mesh shader output can store.")
    uint32_t("maxMeshOutputPrimitives", "the maximum number of primitives a mesh shader output can store.")
    uint32_t("maxMeshMultiviewViewCount", "the maximum number of multiview views a mesh shader can use.")
    uint32_t("meshOutputPerVertexGranularity", "the granularity with which mesh vertex outputs are allocated. The value can be used to compute the memory size used by the mesh shader, which <b>must</b> be less than or equal to {@code maxMeshTotalMemorySize}.")
    uint32_t("meshOutputPerPrimitiveGranularity", "the granularity with which mesh outputs qualified as per-primitive are allocated. The value can be used to compute the memory size used by the mesh shader, which <b>must</b> be less than or equal to {@code maxMeshTotalMemorySize}.")
}

val VkDrawMeshTasksIndirectCommandNV = struct(Module.VULKAN, "VkDrawMeshTasksIndirectCommandNV") {
    documentation =
        """
        Structure specifying a mesh tasks draw indirect command.

        <h5>Description</h5>
        The members of ##VkDrawMeshTasksIndirectCommandNV have the same meaning as the similarly named parameters of #CmdDrawMeshTasksNV().

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code taskCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceMeshShaderPropertiesNV{@code ::maxDrawMeshTasksCount}</li>
        </ul>

        <h5>See Also</h5>
        #CmdDrawMeshTasksIndirectNV()
        """

    uint32_t("taskCount", "the number of local workgroups to dispatch in the X dimension. Y and Z dimension are implicitly set to one.")
    uint32_t("firstTask", "the X component of the first workgroup ID.")
}

val _VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR")
val VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV", alias = _VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR) {
    documentation = "See ##VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("fragmentShaderBarycentric", "")
}

val VkPhysicalDeviceShaderImageFootprintFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceShaderImageFootprintFeaturesNV") {
    documentation =
        """
        Structure describing shader image footprint features that can be supported by an implementation.

        <h5>Description</h5>
        See <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#textures-footprint">Texel Footprint Evaluation</a> for more information.

        If the ##VkPhysicalDeviceShaderImageFootprintFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceShaderImageFootprintFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("imageFootprint", "specifies whether the implementation supports the {@code ImageFootprintNV} SPIR-V capability.")
}

val VkPipelineViewportExclusiveScissorStateCreateInfoNV = struct(Module.VULKAN, "VkPipelineViewportExclusiveScissorStateCreateInfoNV") {
    documentation =
        """
        Structure specifying parameters controlling exclusive scissor testing.

        <h5>Description</h5>
        If the #DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV dynamic state is enabled for a pipeline, the {@code pExclusiveScissors} member is ignored.

        When this structure is included in the {@code pNext} chain of ##VkGraphicsPipelineCreateInfo, it defines parameters of the exclusive scissor test. If this structure is not included in the {@code pNext} chain, it is equivalent to specifying this structure with an {@code exclusiveScissorCount} of 0.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiViewport">{@code multiViewport}</a> feature is not enabled, {@code exclusiveScissorCount} <b>must</b> be 0 or 1</li>
            <li>{@code exclusiveScissorCount} <b>must</b> be less than or equal to ##VkPhysicalDeviceLimits{@code ::maxViewports}</li>
            <li>{@code exclusiveScissorCount} <b>must</b> be 0 or greater than or equal to the {@code viewportCount} member of ##VkPipelineViewportStateCreateInfo</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV</li>
        </ul>

        <h5>See Also</h5>
        ##VkRect2D
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pExclusiveScissors", optional = true)..uint32_t("exclusiveScissorCount", "the number of exclusive scissor rectangles.")
    nullable..VkRect2D.const.p("pExclusiveScissors", "a pointer to an array of ##VkRect2D structures defining exclusive scissor rectangles.")
}

val VkPhysicalDeviceExclusiveScissorFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceExclusiveScissorFeaturesNV") {
    documentation =
        """
        Structure describing exclusive scissor features that can be supported by an implementation.

        <h5>Description</h5>
        See <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#fragops-exclusive-scissor">Exclusive Scissor Test</a> for more information.

        If the ##VkPhysicalDeviceExclusiveScissorFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceExclusiveScissorFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("exclusiveScissor", "indicates that the implementation supports the exclusive scissor test.")
}

val VkQueueFamilyCheckpointPropertiesNV = struct(Module.VULKAN, "VkQueueFamilyCheckpointPropertiesNV", mutable = false) {
    documentation =
        """
        Return structure for queue family checkpoint information query.

        <h5>Description</h5>
        Additional queue family information can be queried by setting ##VkQueueFamilyProperties2{@code ::pNext} to point to a ##VkQueueFamilyCheckpointPropertiesNV structure.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkPipelineStageFlags("checkpointExecutionStageMask", "a mask indicating which pipeline stages the implementation can execute checkpoint markers in.")
}

val VkCheckpointDataNV = struct(Module.VULKAN, "VkCheckpointDataNV", mutable = false) {
    documentation =
        """
        Return structure for command buffer checkpoint data.

        <h5>Description</h5>
        The stages at which a checkpoint marker <b>can</b> be executed are implementation-defined and <b>can</b> be queried by calling #GetPhysicalDeviceQueueFamilyProperties2().

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_CHECKPOINT_DATA_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetQueueCheckpointDataNV()
        """

    Expression("#STRUCTURE_TYPE_CHECKPOINT_DATA_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkPipelineStageFlagBits("stage", "a {@code VkPipelineStageFlagBits} value specifying which pipeline stage the checkpoint marker data refers to.")
    nullable..opaque_p("pCheckpointMarker", "contains the value of the last checkpoint marker executed in the stage that {@code stage} refers to.")
}

val VkQueueFamilyCheckpointProperties2NV = struct(Module.VULKAN, "VkQueueFamilyCheckpointProperties2NV", mutable = false) {
    documentation =
        """
        Return structure for queue family checkpoint information query.

        <h5>Description</h5>
        Additional queue family information can be queried by setting ##VkQueueFamilyProperties2{@code ::pNext} to point to a ##VkQueueFamilyCheckpointProperties2NV structure.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkPipelineStageFlags2("checkpointExecutionStageMask", "a mask indicating which pipeline stages the implementation can execute checkpoint markers in.")
}

val VkCheckpointData2NV = struct(Module.VULKAN, "VkCheckpointData2NV", mutable = false) {
    documentation =
        """
        Return structure for command buffer checkpoint data.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        The stages at which a checkpoint marker <b>can</b> be executed are implementation-defined and <b>can</b> be queried by calling #GetPhysicalDeviceQueueFamilyProperties2().

        <h5>See Also</h5>
        #GetQueueCheckpointData2NV()
        """

    Expression("#STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkPipelineStageFlags2("stage", "indicates a single pipeline stage which the checkpoint marker data refers to.")
    nullable..opaque_p("pCheckpointMarker", "contains the value of the last checkpoint marker executed in the stage that {@code stage} refers to.")
}

val VkPhysicalDeviceTimelineSemaphoreFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceTimelineSemaphoreFeaturesKHR", alias = VkPhysicalDeviceTimelineSemaphoreFeatures) {
    documentation = "See ##VkPhysicalDeviceTimelineSemaphoreFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("timelineSemaphore", "")
}

val VkPhysicalDeviceTimelineSemaphorePropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceTimelineSemaphorePropertiesKHR", mutable = false, alias = VkPhysicalDeviceTimelineSemaphoreProperties) {
    documentation = "See ##VkPhysicalDeviceTimelineSemaphoreProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint64_t("maxTimelineSemaphoreValueDifference", "")
}

val VkSemaphoreTypeCreateInfoKHR = struct(Module.VULKAN, "VkSemaphoreTypeCreateInfoKHR", alias = VkSemaphoreTypeCreateInfo) {
    documentation = "See ##VkSemaphoreTypeCreateInfo."

    Expression("#STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkSemaphoreType("semaphoreType", "")
    uint64_t("initialValue", "")
}

val VkTimelineSemaphoreSubmitInfoKHR = struct(Module.VULKAN, "VkTimelineSemaphoreSubmitInfoKHR", alias = VkTimelineSemaphoreSubmitInfo) {
    documentation = "See ##VkTimelineSemaphoreSubmitInfo."

    Expression("#STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pWaitSemaphoreValues", optional = true)..uint32_t("waitSemaphoreValueCount", "")
    nullable..uint64_t.const.p("pWaitSemaphoreValues", "")
    AutoSize("pSignalSemaphoreValues", optional = true)..uint32_t("signalSemaphoreValueCount", "")
    nullable..uint64_t.const.p("pSignalSemaphoreValues", "")
}

val VkSemaphoreWaitInfoKHR = struct(Module.VULKAN, "VkSemaphoreWaitInfoKHR", alias = VkSemaphoreWaitInfo) {
    documentation = "See ##VkSemaphoreWaitInfo."

    Expression("#STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkSemaphoreWaitFlags("flags", "")
    AutoSize("pSemaphores", "pValues")..uint32_t("semaphoreCount", "")
    VkSemaphore.const.p("pSemaphores", "")
    uint64_t.const.p("pValues", "")
}

val VkSemaphoreSignalInfoKHR = struct(Module.VULKAN, "VkSemaphoreSignalInfoKHR", alias = VkSemaphoreSignalInfo) {
    documentation = "See ##VkSemaphoreSignalInfo."

    Expression("#STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkSemaphore("semaphore", "")
    uint64_t("value", "")
}

val VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL = struct(Module.VULKAN, "VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL") {
    documentation =
        """
        Structure describing shader integer functions that can be supported by an implementation.

        <h5>Description</h5>
        If the {@code VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTELfeatures}. structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. {@code VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTELfeatures}. <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("shaderIntegerFunctions2", "indicates that the implementation supports the {@code IntegerFunctions2INTEL} SPIR-V capability.")
}

val VkPerformanceValueDataINTEL = union(Module.VULKAN, "VkPerformanceValueDataINTEL") {
    documentation =
        """
        Values returned for the parameters.

        <h5>Description</h5>
        The correct member of the union is determined by the associated {@code VkPerformanceValueTypeINTEL} value.

        <h5>See Also</h5>
        ##VkPerformanceValueINTEL
        """

    uint32_t("value32", "represents 32-bit integer data.")
    uint64_t("value64", "represents 64-bit integer data.")
    float("valueFloat", "represents floating-point data.")
    VkBool32("valueBool", "represents {@code VkBool32} data.")
    charUTF8.const.p("valueString", "represents a pointer to a null-terminated UTF-8 string.")
}

val VkPerformanceValueINTEL = struct(Module.VULKAN, "VkPerformanceValueINTEL", mutable = false) {
    documentation =
        """
        Container for value and types of parameters that can be queried.

        <h5>See Also</h5>
        ##VkPerformanceValueDataINTEL, #GetPerformanceParameterINTEL()
        """

    VkPerformanceValueTypeINTEL("type", "a {@code VkPerformanceValueTypeINTEL} value specifying the type of the returned data.")
    VkPerformanceValueDataINTEL("data", "a ##VkPerformanceValueDataINTEL union specifying the value of the returned data.")
}

val VkInitializePerformanceApiInfoINTEL = struct(Module.VULKAN, "VkInitializePerformanceApiInfoINTEL") {
    documentation =
        """
        Structure specifying parameters of initialize of the device.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #InitializePerformanceApiINTEL()
        """

    Expression("#STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    nullable..opaque_p("pUserData", "a pointer for application data.")
}

val _VkQueryPoolPerformanceQueryCreateInfoINTEL = struct(Module.VULKAN, "VkQueryPoolPerformanceQueryCreateInfoINTEL")
val VkQueryPoolCreateInfoINTEL = struct(Module.VULKAN, "VkQueryPoolCreateInfoINTEL", alias = _VkQueryPoolPerformanceQueryCreateInfoINTEL) {
    documentation = "See ##VkQueryPoolPerformanceQueryCreateInfoINTEL."

    Expression("#STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkQueryPoolSamplingModeINTEL("performanceCountersSampling", "")
}

val VkQueryPoolPerformanceQueryCreateInfoINTEL = struct(Module.VULKAN, "VkQueryPoolPerformanceQueryCreateInfoINTEL") {
    documentation =
        """
        Structure specifying parameters to create a pool of performance queries.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL</li>
            <li>{@code performanceCountersSampling} <b>must</b> be a valid {@code VkQueryPoolSamplingModeINTEL} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkQueryPoolSamplingModeINTEL("performanceCountersSampling", "describe how performance queries should be captured.")
}

val VkPerformanceMarkerInfoINTEL = struct(Module.VULKAN, "VkPerformanceMarkerInfoINTEL") {
    documentation =
        """
        Structure specifying performance markers.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #CmdSetPerformanceMarkerINTEL()
        """

    Expression("#STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint64_t("marker", "the marker value that will be recorded into the opaque query results.")
}

val VkPerformanceStreamMarkerInfoINTEL = struct(Module.VULKAN, "VkPerformanceStreamMarkerInfoINTEL") {
    documentation =
        """
        Structure specifying stream performance markers.

        <h5>Valid Usage</h5>
        <ul>
            <li>The value written by the application into {@code marker} <b>must</b> only used the valid bits as reported by #GetPerformanceParameterINTEL() with the #PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #CmdSetPerformanceStreamMarkerINTEL()
        """

    Expression("#STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    uint32_t("marker", "the marker value that will be recorded into the reports consumed by an external application.")
}

val VkPerformanceOverrideInfoINTEL = struct(Module.VULKAN, "VkPerformanceOverrideInfoINTEL") {
    documentation =
        """
        Performance override information.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code type} <b>must</b> be a valid {@code VkPerformanceOverrideTypeINTEL} value</li>
        </ul>

        <h5>See Also</h5>
        #CmdSetPerformanceOverrideINTEL()
        """

    Expression("#STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkPerformanceOverrideTypeINTEL("type", "the particular {@code VkPerformanceOverrideTypeINTEL} to set.")
    VkBool32("enable", "defines whether the override is enabled.")
    uint64_t("parameter", "a potential required parameter for the override.")
}

val VkPerformanceConfigurationAcquireInfoINTEL = struct(Module.VULKAN, "VkPerformanceConfigurationAcquireInfoINTEL") {
    documentation =
        """
        Acquire a configuration to capture performance data.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code type} <b>must</b> be a valid {@code VkPerformanceConfigurationTypeINTEL} value</li>
        </ul>

        <h5>See Also</h5>
        #AcquirePerformanceConfigurationINTEL()
        """

    Expression("#STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPerformanceConfigurationTypeINTEL("type", "one of the {@code VkPerformanceConfigurationTypeINTEL} type of performance configuration that will be acquired.")
}

val VkPhysicalDeviceVulkanMemoryModelFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceVulkanMemoryModelFeaturesKHR", alias = VkPhysicalDeviceVulkanMemoryModelFeatures) {
    documentation = "See ##VkPhysicalDeviceVulkanMemoryModelFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("vulkanMemoryModel", "")
    VkBool32("vulkanMemoryModelDeviceScope", "")
    VkBool32("vulkanMemoryModelAvailabilityVisibilityChains", "")
}

val VkPhysicalDevicePCIBusInfoPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDevicePCIBusInfoPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure containing PCI bus information of a physical device.

        <h5>Description</h5>
        If the ##VkPhysicalDevicePCIBusInfoPropertiesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        These are properties of the PCI bus information of a physical device.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("pciDomain", "the PCI bus domain.")
    uint32_t("pciBus", "the PCI bus identifier.")
    uint32_t("pciDevice", "the PCI device identifier.")
    uint32_t("pciFunction", "the PCI device function identifier.")
}

val VkDisplayNativeHdrSurfaceCapabilitiesAMD = struct(Module.VULKAN, "VkDisplayNativeHdrSurfaceCapabilitiesAMD", mutable = false) {
    documentation =
        """
        Structure describing display native HDR specific capabilities of a surface.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkBool32("localDimmingSupport", "specifies whether the surface supports local dimming. If this is #TRUE, ##VkSwapchainDisplayNativeHdrCreateInfoAMD <b>can</b> be used to explicitly enable or disable local dimming for the surface. Local dimming may also be overridden by #SetLocalDimmingAMD() during the lifetime of the swapchain.")
}

val VkSwapchainDisplayNativeHdrCreateInfoAMD = struct(Module.VULKAN, "VkSwapchainDisplayNativeHdrCreateInfoAMD") {
    documentation =
        """
        Structure specifying display native HDR parameters of a newly created swapchain object.

        <h5>Description</h5>
        If the {@code pNext} chain of ##VkSwapchainCreateInfoKHR does not include this structure, the default value for {@code localDimmingEnable} is #TRUE, meaning local dimming is initially enabled for the swapchain.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD</li>
        </ul>

        <h5>Valid Usage</h5>
        <ul>
            <li>It is only valid to set {@code localDimmingEnable} to #TRUE if ##VkDisplayNativeHdrSurfaceCapabilitiesAMD{@code ::localDimmingSupport} is supported</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("localDimmingEnable", "specifies whether local dimming is enabled for the swapchain.")
}

val VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR", alias = VkPhysicalDeviceShaderTerminateInvocationFeatures) {
    documentation = "See ##VkPhysicalDeviceShaderTerminateInvocationFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("shaderTerminateInvocation", "")
}

val VkMetalSurfaceCreateInfoEXT = struct(Module.VULKAN, "VkMetalSurfaceCreateInfoEXT") {
    documentation =
        """
        Structure specifying parameters of a newly created Metal surface object.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
            <li>{@code flags} <b>must</b> be 0</li>
        </ul>

        <h5>See Also</h5>
        #CreateMetalSurfaceEXT()
        """

    Expression("#STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkMetalSurfaceCreateFlagsEXT("flags", "reserved for future use.")
    nullable..CAMetalLayer.const.p("pLayer", "a reference to a {@code CAMetalLayer} object representing a renderable surface.")
}

val VkPhysicalDeviceFragmentDensityMapFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceFragmentDensityMapFeaturesEXT") {
    documentation =
        """
        Structure describing fragment density map features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceFragmentDensityMapFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceFragmentDensityMapFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("fragmentDensityMap", "specifies whether the implementation supports render passes with a fragment density map attachment. If this feature is not enabled and the {@code pNext} chain of ##VkRenderPassCreateInfo includes a ##VkRenderPassFragmentDensityMapCreateInfoEXT structure, {@code fragmentDensityMapAttachment} <b>must</b> be #ATTACHMENT_UNUSED.")
    VkBool32("fragmentDensityMapDynamic", "specifies whether the implementation supports dynamic fragment density map image views. If this feature is not enabled, #IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT <b>must</b> not be included in ##VkImageViewCreateInfo{@code ::flags}.")
    VkBool32("fragmentDensityMapNonSubsampledImages", "specifies whether the implementation supports regular non-subsampled image attachments with fragment density map render passes. If this feature is not enabled, render passes with a <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#renderpass-fragmentdensitymapattachment\">fragment density map attachment</a> <b>must</b> only have <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#samplers-subsamplesampler\">subsampled attachments</a> bound.")
}

val VkPhysicalDeviceFragmentDensityMapPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceFragmentDensityMapPropertiesEXT", mutable = false) {
    documentation =
        """
        Structure describing fragment density map properties that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceFragmentDensityMapPropertiesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkExtent2D("minFragmentDensityTexelSize", "the minimum <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#glossary-fragment-density-texel-size\">fragment density texel size</a>.")
    VkExtent2D("maxFragmentDensityTexelSize", "the maximum fragment density texel size.")
    VkBool32("fragmentDensityInvocations", "specifies whether the implementation <b>may</b> invoke additional fragment shader invocations for each covered sample.")
}

val VkRenderPassFragmentDensityMapCreateInfoEXT = struct(Module.VULKAN, "VkRenderPassFragmentDensityMapCreateInfoEXT") {
    documentation =
        """
        Structure containing fragment density map attachment for render pass.

        <h5>Description</h5>
        The fragment density map is read at an implementation-dependent time with the following constraints determined by the attachment’s image view {@code flags}:

        <ul>
            <li>#IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT specifies that the fragment density map will be read by the device during #PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT</li>
            <li>#IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT specifies that the fragment density map will be read by the host during #EndCommandBuffer() of the primary command buffer that the render pass is recorded into</li>
            <li>Otherwise the fragment density map will be read by the host during #CmdBeginRenderPass()</li>
        </ul>

        The fragment density map <b>may</b> additionally be read by the device during #PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT for any mode.

        If this structure is not present, it is as if {@code fragmentDensityMapAttachment} was given as #ATTACHMENT_UNUSED.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code fragmentDensityMapAttachment} is not #ATTACHMENT_UNUSED, {@code fragmentDensityMapAttachment} <b>must</b> not be an element of ##VkSubpassDescription{@code ::pInputAttachments}, ##VkSubpassDescription{@code ::pColorAttachments}, ##VkSubpassDescription{@code ::pResolveAttachments}, ##VkSubpassDescription{@code ::pDepthStencilAttachment}, or ##VkSubpassDescription{@code ::pPreserveAttachments} for any subpass</li>
            <li>If {@code fragmentDensityMapAttachment} is not #ATTACHMENT_UNUSED, {@code layout} <b>must</b> be equal to #IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT, or #IMAGE_LAYOUT_GENERAL</li>
            <li>If {@code fragmentDensityMapAttachment} is not #ATTACHMENT_UNUSED, {@code fragmentDensityMapAttachment} <b>must</b> reference an attachment with a {@code loadOp} equal to #ATTACHMENT_LOAD_OP_LOAD or #ATTACHMENT_LOAD_OP_DONT_CARE</li>
            <li>If {@code fragmentDensityMapAttachment} is not #ATTACHMENT_UNUSED, {@code fragmentDensityMapAttachment} <b>must</b> reference an attachment with a {@code storeOp} equal to #ATTACHMENT_STORE_OP_DONT_CARE</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT</li>
            <li>{@code fragmentDensityMapAttachment} <b>must</b> be a valid ##VkAttachmentReference structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkAttachmentReference
        """

    Expression("#STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkAttachmentReference("fragmentDensityMapAttachment", "the fragment density map to use for the render pass.")
}

val VkRenderingFragmentDensityMapAttachmentInfoEXT = struct(Module.VULKAN, "VkRenderingFragmentDensityMapAttachmentInfoEXT") {
    documentation =
        """
        Structure specifying fragment shading rate attachment information.

        <h5>Description</h5>
        This structure can be included in the {@code pNext} chain of ##VkRenderingInfo to define a fragment density map. If this structure is not included in the {@code pNext} chain, {@code imageView} is treated as #NULL_HANDLE.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code imageView} is not #NULL_HANDLE, {@code imageLayout} <b>must</b> be #IMAGE_LAYOUT_GENERAL or #IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT</li>
            <li>If {@code imageView} is not #NULL_HANDLE, it <b>must</b> have been created with #IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT</li>
            <li>If {@code imageView} is not #NULL_HANDLE, it <b>must</b> not have been created with #IMAGE_CREATE_SUBSAMPLED_BIT_EXT</li>
            <li>If the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#features-multiview">{@code multiview}</a> feature is not enabled, ##VkPhysicalDeviceProperties{@code ::apiVersion} is less than Vulkan 1.1, and {@code imageView} is not #NULL_HANDLE, it <b>must</b> have a {@code layerCount} equal to 1</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT</li>
            <li>{@code imageView} <b>must</b> be a valid {@code VkImageView} handle</li>
            <li>{@code imageLayout} <b>must</b> be a valid {@code VkImageLayout} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkImageView("imageView", "the image view that will be used as a fragment density map attachment.")
    VkImageLayout("imageLayout", "the layout that {@code imageView} will be in during rendering.")
}

val VkPhysicalDeviceScalarBlockLayoutFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceScalarBlockLayoutFeaturesEXT", alias = VkPhysicalDeviceScalarBlockLayoutFeatures) {
    documentation = "See ##VkPhysicalDeviceScalarBlockLayoutFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("scalarBlockLayout", "")
}

val VkPhysicalDeviceSubgroupSizeControlFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceSubgroupSizeControlFeaturesEXT", alias = VkPhysicalDeviceSubgroupSizeControlFeatures) {
    documentation = "See ##VkPhysicalDeviceSubgroupSizeControlFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("subgroupSizeControl", "")
    VkBool32("computeFullSubgroups", "")
}

val VkPhysicalDeviceSubgroupSizeControlPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceSubgroupSizeControlPropertiesEXT", mutable = false, alias = VkPhysicalDeviceSubgroupSizeControlProperties) {
    documentation = "See ##VkPhysicalDeviceSubgroupSizeControlProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint32_t("minSubgroupSize", "")
    uint32_t("maxSubgroupSize", "")
    uint32_t("maxComputeWorkgroupSubgroups", "")
    VkShaderStageFlags("requiredSubgroupSizeStages", "")
}

val VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT = struct(Module.VULKAN, "VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT", mutable = false, alias = VkPipelineShaderStageRequiredSubgroupSizeCreateInfo) {
    documentation = "See ##VkPipelineShaderStageRequiredSubgroupSizeCreateInfo."

    Expression("#STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    uint32_t("requiredSubgroupSize", "")
}

val VkFragmentShadingRateAttachmentInfoKHR = struct(Module.VULKAN, "VkFragmentShadingRateAttachmentInfoKHR") {
    documentation =
        """
        Structure specifying a fragment shading rate attachment for a subpass.

        <h5>Description</h5>
        If no shading rate attachment is specified, or if this structure is not specified, the implementation behaves as if a valid shading rate attachment was specified with all texels specifying a single pixel per fragment.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL} and its {@code attachment} member is not #ATTACHMENT_UNUSED, its {@code layout} member <b>must</b> be equal to #IMAGE_LAYOUT_GENERAL or #IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR</li>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL} and its {@code attachment} member is not #ATTACHMENT_UNUSED, {@code shadingRateAttachmentTexelSize.width} <b>must</b> be a power of two value</li>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL} and its {@code attachment} member is not #ATTACHMENT_UNUSED, {@code shadingRateAttachmentTexelSize.width} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFragmentShadingRateAttachmentTexelSize">{@code maxFragmentShadingRateAttachmentTexelSize.width}</a></li>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL} and its {@code attachment} member is not #ATTACHMENT_UNUSED, {@code shadingRateAttachmentTexelSize.width} <b>must</b> be greater than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-minFragmentShadingRateAttachmentTexelSize">{@code minFragmentShadingRateAttachmentTexelSize.width}</a></li>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL} and its {@code attachment} member is not #ATTACHMENT_UNUSED, {@code shadingRateAttachmentTexelSize.height} <b>must</b> be a power of two value</li>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL} and its {@code attachment} member is not #ATTACHMENT_UNUSED, {@code shadingRateAttachmentTexelSize.height} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFragmentShadingRateAttachmentTexelSize">{@code maxFragmentShadingRateAttachmentTexelSize.height}</a></li>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL} and its {@code attachment} member is not #ATTACHMENT_UNUSED, {@code shadingRateAttachmentTexelSize.height} <b>must</b> be greater than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-minFragmentShadingRateAttachmentTexelSize">{@code minFragmentShadingRateAttachmentTexelSize.height}</a></li>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL} and its {@code attachment} member is not #ATTACHMENT_UNUSED, the quotient of {@code shadingRateAttachmentTexelSize.width} and {@code shadingRateAttachmentTexelSize.height} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFragmentShadingRateAttachmentTexelSizeAspectRatio">{@code maxFragmentShadingRateAttachmentTexelSizeAspectRatio}</a></li>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL} and its {@code attachment} member is not #ATTACHMENT_UNUSED, the quotient of {@code shadingRateAttachmentTexelSize.height} and {@code shadingRateAttachmentTexelSize.width} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFragmentShadingRateAttachmentTexelSizeAspectRatio">{@code maxFragmentShadingRateAttachmentTexelSizeAspectRatio}</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR</li>
            <li>If {@code pFragmentShadingRateAttachment} is not {@code NULL}, {@code pFragmentShadingRateAttachment} <b>must</b> be a valid pointer to a valid ##VkAttachmentReference2 structure</li>
        </ul>

        <h5>See Also</h5>
        ##VkAttachmentReference2, ##VkExtent2D
        """

    Expression("#STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    nullable..VkAttachmentReference2.const.p("pFragmentShadingRateAttachment", "{@code NULL} or a pointer to a ##VkAttachmentReference2 structure defining the fragment shading rate attachment for this subpass.")
    VkExtent2D("shadingRateAttachmentTexelSize", "specifies the size of the portion of the framebuffer corresponding to each texel in {@code pFragmentShadingRateAttachment}.")
}

val VkPipelineFragmentShadingRateStateCreateInfoKHR = struct(Module.VULKAN, "VkPipelineFragmentShadingRateStateCreateInfoKHR") {
    documentation =
        """
        Structure specifying parameters controlling the fragment shading rate.

        <h5>Description</h5>
        If the {@code pNext} chain of ##VkGraphicsPipelineCreateInfo includes a ##VkPipelineFragmentShadingRateStateCreateInfoKHR structure, then that structure includes parameters controlling the pipeline fragment shading rate.

        If this structure is not present, {@code fragmentSize} is considered to be equal to <code>(1,1)</code>, and both elements of {@code combinerOps} are considered to be equal to #FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkExtent2D("fragmentSize", "specifies a ##VkExtent2D structure containing the fragment size used to define the pipeline fragment shading rate for drawing commands using this pipeline.")
    VkFragmentShadingRateCombinerOpKHR("combinerOps", "specifies a {@code VkFragmentShadingRateCombinerOpKHR} value determining how the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-fragment-shading-rate-pipeline\">pipeline</a>, <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-fragment-shading-rate-primitive\">primitive</a>, and <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-fragment-shading-rate-attachment\">attachment shading rates</a> are <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-fragment-shading-rate-combining\">combined</a> for fragments generated by drawing commands using the created pipeline.")[2]
}

val VkPhysicalDeviceFragmentShadingRateFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceFragmentShadingRateFeaturesKHR") {
    documentation =
        """
        Structure indicating support for variable rate fragment shading.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceFragmentShadingRateFeaturesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceFragmentShadingRateFeaturesKHR <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("pipelineFragmentShadingRate", "indicates that the implementation supports the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-fragment-shading-rate-pipeline\">pipeline fragment shading rate</a>.")
    VkBool32("primitiveFragmentShadingRate", "indicates that the implementation supports the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-fragment-shading-rate-primitive\">primitive fragment shading rate</a>.")
    VkBool32("attachmentFragmentShadingRate", "indicates that the implementation supports the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-fragment-shading-rate-attachment\">attachment fragment shading rate</a>.")
}

val VkPhysicalDeviceFragmentShadingRatePropertiesKHR = struct(Module.VULKAN, "VkPhysicalDeviceFragmentShadingRatePropertiesKHR", mutable = false) {
    documentation =
        """
        Structure describing variable fragment shading rate limits that can be supported by an implementation.

        <h5>Description</h5>
        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        Multiplication of the combiner rates using the fragment width/height in linear space is equivalent to an addition of those values in log2 space. Some implementations inadvertently implemented an addition in linear space due to unclear requirements originating outside of this specification. This resulted in <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-fragmentShadingRateStrictMultiplyCombiner">{@code fragmentShadingRateStrictMultiplyCombiner}</a> being added. Fortunately, this only affects situations where a rate of 1 in either dimension is combined with another rate of 1. All other combinations result in the exact same result as if multiplication was performed in linear space due to the clamping logic, and the fact that both the sum and product of 2 and 2 are equal. In many cases, this limit will not affect the correct operation of applications.
        </div>

        If the ##VkPhysicalDeviceFragmentShadingRatePropertiesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        These properties are related to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate">fragment shading rates</a>.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkExtent2D("minFragmentShadingRateAttachmentTexelSize", "indicates minimum supported width and height of the portion of the framebuffer corresponding to each texel in a fragment shading rate attachment. Each value <b>must</b> be less than or equal to the values in {@code maxFragmentShadingRateAttachmentTexelSize}. Each value <b>must</b> be a power-of-two. It <b>must</b> be <code>(0,0)</code> if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-attachmentFragmentShadingRate\">{@code attachmentFragmentShadingRate}</a> feature is not supported.")
    VkExtent2D("maxFragmentShadingRateAttachmentTexelSize", "indicates maximum supported width and height of the portion of the framebuffer corresponding to each texel in a fragment shading rate attachment. Each value <b>must</b> be greater than or equal to the values in {@code minFragmentShadingRateAttachmentTexelSize}. Each value <b>must</b> be a power-of-two. It <b>must</b> be <code>(0,0)</code> if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-attachmentFragmentShadingRate\">{@code attachmentFragmentShadingRate}</a> feature is not supported.")
    uint32_t("maxFragmentShadingRateAttachmentTexelSizeAspectRatio", "indicates the maximum ratio between the width and height of the portion of the framebuffer corresponding to each texel in a fragment shading rate attachment. {@code maxFragmentShadingRateAttachmentTexelSizeAspectRatio} <b>must</b> be a power-of-two value, and <b>must</b> be less than or equal to <code>max(maxFragmentShadingRateAttachmentTexelSize.width / minFragmentShadingRateAttachmentTexelSize.height, maxFragmentShadingRateAttachmentTexelSize.height / minFragmentShadingRateAttachmentTexelSize.width)</code>. It <b>must</b> be 0 if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-attachmentFragmentShadingRate\">{@code attachmentFragmentShadingRate}</a> feature is not supported.")
    VkBool32("primitiveFragmentShadingRateWithMultipleViewports", "specifies whether the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-fragment-shading-rate-primitive\">primitive fragment shading rate</a> <b>can</b> be used when multiple viewports are used. If this value is #FALSE, only a single viewport <b>must</b> be used, and applications <b>must</b> not write to the {@code ViewportMaskNV} or {@code ViewportIndex} built-in when setting {@code PrimitiveShadingRateKHR}. It <b>must</b> be #FALSE if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-shaderOutputViewportIndex\">{@code shaderOutputViewportIndex}</a> feature, the {@link EXTShaderViewportIndexLayer VK_EXT_shader_viewport_index_layer} extension, or the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-geometryShader\">{@code geometryShader}</a> feature is not supported, or if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-primitiveFragmentShadingRate\">{@code primitiveFragmentShadingRate}</a> feature is not supported.")
    VkBool32("layeredShadingRateAttachments", "specifies whether a shading rate attachment image view <b>can</b> be created with multiple layers. If this value is #FALSE, when creating an image view with a {@code usage} that includes #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, {@code layerCount} <b>must</b> be 1. It <b>must</b> be #FALSE if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-multiview\">{@code multiview}</a> feature, the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-shaderOutputViewportIndex\">{@code shaderOutputViewportIndex}</a> feature, the {@link EXTShaderViewportIndexLayer VK_EXT_shader_viewport_index_layer} extension, or the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-geometryShader\">{@code geometryShader}</a> feature is not supported, or if the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-attachmentFragmentShadingRate\">{@code attachmentFragmentShadingRate}</a> feature is not supported.")
    VkBool32("fragmentShadingRateNonTrivialCombinerOps", "specifies whether {@code VkFragmentShadingRateCombinerOpKHR} enums other than #FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR or #FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR <b>can</b> be used. It <b>must</b> be #FALSE unless either the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-primitiveFragmentShadingRate\">{@code primitiveFragmentShadingRate}</a> or <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-attachmentFragmentShadingRate\">{@code attachmentFragmentShadingRate}</a> feature is supported.")
    VkExtent2D("maxFragmentSize", "indicates the maximum supported width and height of a fragment. Its {@code width} and {@code height} members <b>must</b> both be power-of-two values. This limit is purely informational, and is not validated.")
    uint32_t("maxFragmentSizeAspectRatio", "indicates the maximum ratio between the width and height of a fragment. {@code maxFragmentSizeAspectRatio} <b>must</b> be a power-of-two value, and <b>must</b> be less than or equal to the maximum of the {@code width} and {@code height} members of {@code maxFragmentSize}. This limit is purely informational, and is not validated.")
    uint32_t("maxFragmentShadingRateCoverageSamples", "specifies the maximum number of coverage samples supported in a single fragment. {@code maxFragmentShadingRateCoverageSamples} <b>must</b> be less than or equal to the product of the {@code width} and {@code height} members of {@code maxFragmentSize}, and the sample count reported by {@code maxFragmentShadingRateRasterizationSamples}. {@code maxFragmentShadingRateCoverageSamples} <b>must</b> be less than or equal to <code>maxSampleMaskWords × 32</code> if {@code fragmentShadingRateWithShaderSampleMask} is supported. This limit is purely informational, and is not validated.")
    VkSampleCountFlagBits("maxFragmentShadingRateRasterizationSamples", "a {@code VkSampleCountFlagBits} value specifying the maximum sample rate supported when a fragment covers multiple pixels. This limit is purely informational, and is not validated.")
    VkBool32("fragmentShadingRateWithShaderDepthStencilWrites", "specifies whether the implementation supports writing {@code FragDepth} or {@code FragStencilRefEXT} from a fragment shader for multi-pixel fragments. If this value is #FALSE, writing to those built-ins will clamp the fragment shading rate to <code>(1,1)</code>.")
    VkBool32("fragmentShadingRateWithSampleMask", "specifies whether the implementation supports setting valid bits of ##VkPipelineMultisampleStateCreateInfo{@code ::pSampleMask} to 0 for multi-pixel fragments. If this value is #FALSE, zeroing valid bits in the sample mask will clamp the fragment shading rate to <code>(1,1)</code>.")
    VkBool32("fragmentShadingRateWithShaderSampleMask", "specifies whether the implementation supports reading or writing {@code SampleMask} for multi-pixel fragments. If this value is #FALSE, using that built-in will clamp the fragment shading rate to <code>(1,1)</code>.")
    VkBool32("fragmentShadingRateWithConservativeRasterization", "specifies whether <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-conservativeraster\">conservative rasterization</a> is supported for multi-pixel fragments. It <b>must</b> be #FALSE if {@link EXTConservativeRasterization VK_EXT_conservative_rasterization} is not supported. If this value is #FALSE, using <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-conservativeraster\">conservative rasterization</a> will clamp the fragment shading rate to <code>(1,1)</code>.")
    VkBool32("fragmentShadingRateWithFragmentShaderInterlock", "specifies whether <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-shader-interlock\">fragment shader interlock</a> is supported for multi-pixel fragments. It <b>must</b> be #FALSE if {@link EXTFragmentShaderInterlock VK_EXT_fragment_shader_interlock} is not supported. If this value is #FALSE, using <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-shader-interlock\">fragment shader interlock</a> will clamp the fragment shading rate to <code>(1,1)</code>.")
    VkBool32("fragmentShadingRateWithCustomSampleLocations", "specifies whether <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-samplelocations\">custom sample locations</a> are supported for multi-pixel fragments. It <b>must</b> be #FALSE if {@link EXTSampleLocations VK_EXT_sample_locations} is not supported. If this value is #FALSE, using <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#primsrast-samplelocations\">custom sample locations</a> will clamp the fragment shading rate to <code>(1,1)</code>.")
    VkBool32("fragmentShadingRateStrictMultiplyCombiner", "specifies whether #FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR accurately performs a multiplication or not. Implementations where this value is #FALSE will instead combine rates with an addition. If {@code fragmentShadingRateNonTrivialCombinerOps} is #FALSE, implementations <b>must</b> report this as #FALSE. If {@code fragmentShadingRateNonTrivialCombinerOps} is #TRUE, implementations <b>should</b> report this as #TRUE.")
}

val VkPhysicalDeviceFragmentShadingRateKHR = struct(Module.VULKAN, "VkPhysicalDeviceFragmentShadingRateKHR", mutable = false) {
    documentation =
        """
        Structure returning information about sample count specific additional multisampling capabilities.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D, #GetPhysicalDeviceFragmentShadingRatesKHR()
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkSampleCountFlags("sampleCounts", "a bitmask of sample counts for which the shading rate described by {@code fragmentSize} is supported.")
    VkExtent2D("fragmentSize", "a ##VkExtent2D describing the width and height of a supported shading rate.")
}

val VkRenderingFragmentShadingRateAttachmentInfoKHR = struct(Module.VULKAN, "VkRenderingFragmentShadingRateAttachmentInfoKHR") {
    documentation =
        """
        Structure specifying fragment shading rate attachment information.

        <h5>Description</h5>
        This structure can be included in the {@code pNext} chain of ##VkRenderingInfo to define a <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a>. If {@code imageView} is #NULL_HANDLE, or if this structure is not specified, the implementation behaves as if a valid shading rate attachment was specified with all texels specifying a single pixel per fragment.

        <h5>Valid Usage</h5>
        <ul>
            <li>If {@code imageView} is not #NULL_HANDLE, {@code layout} <b>must</b> be #IMAGE_LAYOUT_GENERAL or #IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR</li>
            <li>If {@code imageView} is not #NULL_HANDLE, it <b>must</b> have been created with #IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR</li>
            <li>If {@code imageView} is not #NULL_HANDLE, {@code shadingRateAttachmentTexelSize.width} <b>must</b> be a power of two value</li>
            <li>If {@code imageView} is not #NULL_HANDLE, {@code shadingRateAttachmentTexelSize.width} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFragmentShadingRateAttachmentTexelSize">{@code maxFragmentShadingRateAttachmentTexelSize.width}</a></li>
            <li>If {@code imageView} is not #NULL_HANDLE, {@code shadingRateAttachmentTexelSize.width} <b>must</b> be greater than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-minFragmentShadingRateAttachmentTexelSize">{@code minFragmentShadingRateAttachmentTexelSize.width}</a></li>
            <li>If {@code imageView} is not #NULL_HANDLE, {@code shadingRateAttachmentTexelSize.height} <b>must</b> be a power of two value</li>
            <li>If {@code imageView} is not #NULL_HANDLE, {@code shadingRateAttachmentTexelSize.height} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFragmentShadingRateAttachmentTexelSize">{@code maxFragmentShadingRateAttachmentTexelSize.height}</a></li>
            <li>If {@code imageView} is not #NULL_HANDLE, {@code shadingRateAttachmentTexelSize.height} <b>must</b> be greater than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-minFragmentShadingRateAttachmentTexelSize">{@code minFragmentShadingRateAttachmentTexelSize.height}</a></li>
            <li>If {@code imageView} is not #NULL_HANDLE, the quotient of {@code shadingRateAttachmentTexelSize.width} and {@code shadingRateAttachmentTexelSize.height} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFragmentShadingRateAttachmentTexelSizeAspectRatio">{@code maxFragmentShadingRateAttachmentTexelSizeAspectRatio}</a></li>
            <li>If {@code imageView} is not #NULL_HANDLE, the quotient of {@code shadingRateAttachmentTexelSize.height} and {@code shadingRateAttachmentTexelSize.width} <b>must</b> be less than or equal to <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\#limits-maxFragmentShadingRateAttachmentTexelSizeAspectRatio">{@code maxFragmentShadingRateAttachmentTexelSizeAspectRatio}</a></li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR</li>
            <li>If {@code imageView} is not #NULL_HANDLE, {@code imageView} <b>must</b> be a valid {@code VkImageView} handle</li>
            <li>{@code imageLayout} <b>must</b> be a valid {@code VkImageLayout} value</li>
        </ul>

        <h5>See Also</h5>
        ##VkExtent2D
        """

    Expression("#STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkImageView("imageView", "the image view that will be used as a fragment shading rate attachment.")
    VkImageLayout("imageLayout", "the layout that {@code imageView} will be in during rendering.")
    VkExtent2D("shadingRateAttachmentTexelSize", "specifies the number of pixels corresponding to each texel in {@code imageView}.")
}

val VkPhysicalDeviceShaderCoreProperties2AMD = struct(Module.VULKAN, "VkPhysicalDeviceShaderCoreProperties2AMD", mutable = false) {
    documentation =
        """
        Structure describing shader core properties that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceShaderCoreProperties2AMD structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkShaderCorePropertiesFlagsAMD("shaderCoreFeatures", "a bitmask of {@code VkShaderCorePropertiesFlagBitsAMD} indicating the set of features supported by the shader core.")
    uint32_t("activeComputeUnitCount", "an unsigned integer value indicating the number of compute units that have been enabled.")
}

val VkPhysicalDeviceCoherentMemoryFeaturesAMD = struct(Module.VULKAN, "VkPhysicalDeviceCoherentMemoryFeaturesAMD") {
    documentation =
        """
        Structure describing whether device coherent memory can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceCoherentMemoryFeaturesAMD structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceCoherentMemoryFeaturesAMD <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("deviceCoherentMemory", "indicates that the implementation supports device coherent memory ({@code VkMemoryPropertyFlagBits}).")
}

val VkPhysicalDeviceDynamicRenderingLocalReadFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceDynamicRenderingLocalReadFeaturesKHR", alias = VkPhysicalDeviceDynamicRenderingLocalReadFeatures) {
    documentation = "See ##VkPhysicalDeviceDynamicRenderingLocalReadFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("dynamicRenderingLocalRead", "")
}

val VkRenderingAttachmentLocationInfoKHR = struct(Module.VULKAN, "VkRenderingAttachmentLocationInfoKHR", alias = VkRenderingAttachmentLocationInfo) {
    documentation = "See ##VkRenderingAttachmentLocationInfo."

    Expression("#STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pColorAttachmentLocations", optional = true)..uint32_t("colorAttachmentCount", "")
    nullable..uint32_t.const.p("pColorAttachmentLocations", "")
}

val VkRenderingInputAttachmentIndexInfoKHR = struct(Module.VULKAN, "VkRenderingInputAttachmentIndexInfoKHR", alias = VkRenderingInputAttachmentIndexInfo) {
    documentation = "See ##VkRenderingInputAttachmentIndexInfo."

    Expression("#STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    AutoSize("pColorAttachmentInputIndices", optional = true)..uint32_t("colorAttachmentCount", "")
    nullable..uint32_t.const.p("pColorAttachmentInputIndices", "")
    nullable..uint32_t.const.p("pDepthInputAttachmentIndex", "")
    nullable..uint32_t.const.p("pStencilInputAttachmentIndex", "")
}

val VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT") {
    documentation =
        """
        Structure describing features supported by VK_EXT_shader_image_atomic_int64.

        <h5>Description</h5>
        If the {@code VkPhysicalDeviceShaderAtomicInt64FeaturesEXT} structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. {@code VkPhysicalDeviceShaderAtomicInt64FeaturesEXT} <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("shaderImageInt64Atomics", "indicates whether shaders <b>can</b> support 64-bit unsigned and signed integer atomic operations on images.")
    VkBool32("sparseImageInt64Atomics", "indicates whether 64-bit integer atomics <b>can</b> be used on sparse images.")
}

val VkPhysicalDeviceShaderQuadControlFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceShaderQuadControlFeaturesKHR") {
    documentation =
        """
        Structure describing whether quad scopes are supported by the implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceShaderQuadControlFeaturesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceShaderQuadControlFeaturesKHR <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("shaderQuadControl", "indicates whether the implementation supports shaders with the {@code QuadControlKHR} capability.")
}

val VkPhysicalDeviceMemoryBudgetPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceMemoryBudgetPropertiesEXT", mutable = false) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation =
        """
        Structure specifying physical device memory budget and usage.

        <h5>Description</h5>
        The values returned in this structure are not invariant. The {@code heapBudget} and {@code heapUsage} values <b>must</b> be zero for array elements greater than or equal to ##VkPhysicalDeviceMemoryProperties{@code ::memoryHeapCount}. The {@code heapBudget} value <b>must</b> be non-zero for array elements less than ##VkPhysicalDeviceMemoryProperties{@code ::memoryHeapCount}. The {@code heapBudget} value <b>must</b> be less than or equal to ##VkMemoryHeap{@code ::size} for each heap.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkDeviceSize("heapBudget", "an array of #MAX_MEMORY_HEAPS {@code VkDeviceSize} values in which memory budgets are returned, with one element for each memory heap. A heap’s budget is a rough estimate of how much memory the process <b>can</b> allocate from that heap before allocations <b>may</b> fail or cause performance degradation. The budget includes any currently allocated device memory.")["VK_MAX_MEMORY_HEAPS"]
    VkDeviceSize("heapUsage", "an array of #MAX_MEMORY_HEAPS {@code VkDeviceSize} values in which memory usages are returned, with one element for each memory heap. A heap’s usage is an estimate of how much memory the process is currently using in that heap.")["VK_MAX_MEMORY_HEAPS"]
}

val VkPhysicalDeviceMemoryPriorityFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceMemoryPriorityFeaturesEXT") {
    documentation =
        """
        Structure describing memory priority features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceMemoryPriorityFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceMemoryPriorityFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("memoryPriority", "indicates that the implementation supports memory priorities specified at memory allocation time via ##VkMemoryPriorityAllocateInfoEXT.")
}

val VkMemoryPriorityAllocateInfoEXT = struct(Module.VULKAN, "VkMemoryPriorityAllocateInfoEXT") {
    documentation =
        """
        Specify a memory allocation priority.

        <h5>Description</h5>
        Memory allocations with higher priority <b>may</b> be more likely to stay in device-local memory when the system is under memory pressure.

        If this structure is not included, it is as if the {@code priority} value were {@code 0.5}.

        <h5>Valid Usage</h5>
        <ul>
            <li>{@code priority} <b>must</b> be between 0 and 1, inclusive</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    float("priority", "a floating-point value between 0 and 1, indicating the priority of the allocation relative to other memory allocations. Larger values are higher priority. The granularity of the priorities is implementation-dependent.")
}

val VkSurfaceProtectedCapabilitiesKHR = struct(Module.VULKAN, "VkSurfaceProtectedCapabilitiesKHR", mutable = false) {
    documentation =
        """
        Structure describing capability of a surface to be protected.

        <h5>Description</h5>
        If the {@link GOOGLESurfacelessQuery VK_GOOGLE_surfaceless_query} extension is enabled, the value returned in {@code supportsProtected} will be identical for every valid surface created on this physical device, and so in the #GetPhysicalDeviceSurfaceCapabilities2KHR() call, ##VkPhysicalDeviceSurfaceInfo2KHR{@code ::surface} <b>can</b> be #NULL_HANDLE. In that case, the contents of ##VkSurfaceCapabilities2KHR{@code ::surfaceCapabilities} as well as any other struct chained to it will be undefined.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkBool32("supportsProtected", "specifies whether a protected swapchain created from ##VkPhysicalDeviceSurfaceInfo2KHR{@code ::surface} for a particular windowing system <b>can</b> be displayed on screen or not. If {@code supportsProtected} is #TRUE, then creation of swapchains with the #SWAPCHAIN_CREATE_PROTECTED_BIT_KHR flag set <b>must</b> be supported for {@code surface}.")
}

val VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV") {
    documentation =
        """
        Structure describing dedicated allocation image aliasing features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("dedicatedAllocationImageAliasing", "indicates that the implementation supports aliasing of compatible image objects on a dedicated allocation.")
}

val VkPhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR", alias = VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures) {
    documentation = "See ##VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("separateDepthStencilLayouts", "")
}

val VkAttachmentReferenceStencilLayoutKHR = struct(Module.VULKAN, "VkAttachmentReferenceStencilLayoutKHR", alias = VkAttachmentReferenceStencilLayout) {
    documentation = "See ##VkAttachmentReferenceStencilLayout."

    Expression("#STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkImageLayout("stencilLayout", "")
}

val VkAttachmentDescriptionStencilLayoutKHR = struct(Module.VULKAN, "VkAttachmentDescriptionStencilLayoutKHR", alias = VkAttachmentDescriptionStencilLayout) {
    documentation = "See ##VkAttachmentDescriptionStencilLayout."

    Expression("#STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkImageLayout("stencilInitialLayout", "")
    VkImageLayout("stencilFinalLayout", "")
}

val _VkPhysicalDeviceBufferDeviceAddressFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceBufferDeviceAddressFeaturesEXT")
val VkPhysicalDeviceBufferAddressFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceBufferAddressFeaturesEXT", alias = _VkPhysicalDeviceBufferDeviceAddressFeaturesEXT) {
    documentation = "See ##VkPhysicalDeviceBufferDeviceAddressFeaturesEXT."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT")..VkStructureType("sType", "")
    nullable..opaque_p("pNext", "")
    VkBool32("bufferDeviceAddress", "")
    VkBool32("bufferDeviceAddressCaptureReplay", "")
    VkBool32("bufferDeviceAddressMultiDevice", "")
}

val VkPhysicalDeviceBufferDeviceAddressFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceBufferDeviceAddressFeaturesEXT") {
    documentation =
        """
        Structure describing buffer address features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceBufferDeviceAddressFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceBufferDeviceAddressFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
        The ##VkPhysicalDeviceBufferDeviceAddressFeaturesEXT structure has the same members as the ##VkPhysicalDeviceBufferDeviceAddressFeatures structure, but the functionality indicated by the members is expressed differently. The features indicated by the ##VkPhysicalDeviceBufferDeviceAddressFeatures structure requires additional flags to be passed at memory allocation time, and the capture and replay mechanism is built around opaque capture addresses for buffer and memory objects.
        </div>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("bufferDeviceAddress", "indicates that the implementation supports accessing buffer memory in shaders as storage buffers via an address queried from #GetBufferDeviceAddressEXT().")
    VkBool32("bufferDeviceAddressCaptureReplay", "indicates that the implementation supports saving and reusing buffer addresses, e.g. for trace capture and replay.")
    VkBool32("bufferDeviceAddressMultiDevice", "indicates that the implementation supports the <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#features-bufferDeviceAddressEXT\">{@code bufferDeviceAddress}</a> feature for logical devices created with multiple physical devices. If this feature is not supported, buffer addresses <b>must</b> not be queried on a logical device created with more than one physical device.")
}

val VkBufferDeviceAddressInfoEXT = struct(Module.VULKAN, "VkBufferDeviceAddressInfoEXT", alias = VkBufferDeviceAddressInfo) {
    documentation = "See ##VkBufferDeviceAddressInfo."

    Expression("#STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkBuffer("buffer", "")
}

val VkBufferDeviceAddressCreateInfoEXT = struct(Module.VULKAN, "VkBufferDeviceAddressCreateInfoEXT") {
    documentation =
        """
        Request a specific address for a buffer.

        <h5>Description</h5>
        If {@code deviceAddress} is zero, no specific address is requested.

        If {@code deviceAddress} is not zero, then it <b>must</b> be an address retrieved from an identically created buffer on the same implementation. The buffer <b>must</b> also be bound to an identically created {@code VkDeviceMemory} object.

        If this structure is not present, it is as if {@code deviceAddress} is zero.

        Applications <b>should</b> avoid creating buffers with application-provided addresses and implementation-provided addresses in the same process, to reduce the likelihood of #ERROR_INVALID_DEVICE_ADDRESS_EXT errors.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkDeviceAddress("deviceAddress", "the device address requested for the buffer.")
}

val VkPhysicalDeviceToolPropertiesEXT = struct(Module.VULKAN, "VkPhysicalDeviceToolPropertiesEXT", mutable = false, alias = VkPhysicalDeviceToolProperties) {
    javaImport("static org.lwjgl.vulkan.VK10.*")
    documentation = "See ##VkPhysicalDeviceToolProperties."

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES")..VkStructureType("sType", "").mutable()
    nullable..opaque_p("pNext", "").mutable()
    charUTF8("name", "")["VK_MAX_EXTENSION_NAME_SIZE"]
    charUTF8("version", "")["VK_MAX_EXTENSION_NAME_SIZE"]
    VkToolPurposeFlags("purposes", "")
    charUTF8("description", "")["VK_MAX_DESCRIPTION_SIZE"]
    charUTF8("layer", "")["VK_MAX_EXTENSION_NAME_SIZE"]
}

val VkImageStencilUsageCreateInfoEXT = struct(Module.VULKAN, "VkImageStencilUsageCreateInfoEXT", alias = VkImageStencilUsageCreateInfo) {
    documentation = "See ##VkImageStencilUsageCreateInfo."

    Expression("#STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO")..VkStructureType("sType", "")
    nullable..opaque_const_p("pNext", "")
    VkImageUsageFlags("stencilUsage", "")
}

val VkValidationFeaturesEXT = struct(Module.VULKAN, "VkValidationFeaturesEXT") {
    documentation =
        """
        Specify validation features to enable or disable for a Vulkan instance.

        <h5>Valid Usage</h5>
        <ul>
            <li>If the {@code pEnabledValidationFeatures} array contains #VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT, then it <b>must</b> also contain #VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT or #VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_VALIDATION_FEATURES_EXT</li>
            <li>If {@code enabledValidationFeatureCount} is not 0, {@code pEnabledValidationFeatures} <b>must</b> be a valid pointer to an array of {@code enabledValidationFeatureCount} valid {@code VkValidationFeatureEnableEXT} values</li>
            <li>If {@code disabledValidationFeatureCount} is not 0, {@code pDisabledValidationFeatures} <b>must</b> be a valid pointer to an array of {@code disabledValidationFeatureCount} valid {@code VkValidationFeatureDisableEXT} values</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_VALIDATION_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    AutoSize("pEnabledValidationFeatures", optional = true)..uint32_t("enabledValidationFeatureCount", "the number of features to enable.")
    VkValidationFeatureEnableEXT.const.p("pEnabledValidationFeatures", "a pointer to an array of {@code VkValidationFeatureEnableEXT} values specifying the validation features to be enabled.")
    AutoSize("pDisabledValidationFeatures", optional = true)..uint32_t("disabledValidationFeatureCount", "the number of features to disable.")
    VkValidationFeatureDisableEXT.const.p("pDisabledValidationFeatures", "a pointer to an array of {@code VkValidationFeatureDisableEXT} values specifying the validation features to be disabled.")
}

val VkPhysicalDevicePresentWaitFeaturesKHR = struct(Module.VULKAN, "VkPhysicalDevicePresentWaitFeaturesKHR") {
    documentation =
        """
        Structure indicating support for present wait.

        <h5>Description</h5>
        If the ##VkPhysicalDevicePresentWaitFeaturesKHR structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDevicePresentWaitFeaturesKHR <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("presentWait", "indicates that the implementation supports {@code vkWaitForPresentKHR}.")
}

val VkCooperativeMatrixPropertiesNV = struct(Module.VULKAN, "VkCooperativeMatrixPropertiesNV", mutable = false) {
    documentation =
        """
        Structure specifying cooperative matrix properties.

        <h5>Description</h5>
        If some types are preferred over other types (e.g. for performance), they <b>should</b> appear earlier in the list enumerated by #GetPhysicalDeviceCooperativeMatrixPropertiesNV().

        At least one entry in the list <b>must</b> have power of two values for all of {@code MSize}, {@code KSize}, and {@code NSize}.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetPhysicalDeviceCooperativeMatrixPropertiesNV()
        """

    Expression("#STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    uint32_t("MSize", "the number of rows in matrices A, C, and D.")
    uint32_t("NSize", "the number of columns in matrices B, C, D.")
    uint32_t("KSize", "the number of columns in matrix A and rows in matrix B.")
    VkComponentTypeNV("AType", "the component type of matrix A, of type {@code VkComponentTypeNV}.")
    VkComponentTypeNV("BType", "the component type of matrix B, of type {@code VkComponentTypeNV}.")
    VkComponentTypeNV("CType", "the component type of matrix C, of type {@code VkComponentTypeNV}.")
    VkComponentTypeNV("DType", "the component type of matrix D, of type {@code VkComponentTypeNV}.")
    VkScopeNV("scope", "the scope of all the matrix types, of type {@code VkScopeNV}.")
}

val VkPhysicalDeviceCooperativeMatrixFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceCooperativeMatrixFeaturesNV") {
    documentation =
        """
        Structure describing cooperative matrix features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceCooperativeMatrixFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceCooperativeMatrixFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("cooperativeMatrix", "indicates that the implementation supports the {@code CooperativeMatrixNV} SPIR-V capability.")
    VkBool32("cooperativeMatrixRobustBufferAccess", "indicates that the implementation supports robust buffer access for SPIR-V {@code OpCooperativeMatrixLoadNV} and {@code OpCooperativeMatrixStoreNV} instructions.")
}

val VkPhysicalDeviceCooperativeMatrixPropertiesNV = struct(Module.VULKAN, "VkPhysicalDeviceCooperativeMatrixPropertiesNV", mutable = false) {
    documentation =
        """
        Structure describing cooperative matrix properties supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceCooperativeMatrixPropertiesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceProperties2 structure passed to #GetPhysicalDeviceProperties2(), it is filled in with each corresponding implementation-dependent property.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkShaderStageFlags("cooperativeMatrixSupportedStages", "a bitfield of {@code VkShaderStageFlagBits} describing the shader stages that cooperative matrix instructions are supported in. {@code cooperativeMatrixSupportedStages} will have the #SHADER_STAGE_COMPUTE_BIT bit set if any of the physical device’s queues support #QUEUE_COMPUTE_BIT.")
}

val VkPhysicalDeviceCoverageReductionModeFeaturesNV = struct(Module.VULKAN, "VkPhysicalDeviceCoverageReductionModeFeaturesNV") {
    documentation =
        """
        Structure describing the coverage reduction mode features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceCoverageReductionModeFeaturesNV structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceCoverageReductionModeFeaturesNV <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("coverageReductionMode", "indicates whether the implementation supports coverage reduction modes. See <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#fragops-coverage-reduction\">Coverage Reduction</a>.")
}

val VkPipelineCoverageReductionStateCreateInfoNV = struct(Module.VULKAN, "VkPipelineCoverageReductionStateCreateInfoNV") {
    documentation =
        """
        Structure specifying parameters controlling coverage reduction.

        <h5>Description</h5>
        If this structure is not included in the {@code pNext} chain, or if the extension is not enabled, the default coverage reduction mode is inferred as follows:

        <ul>
            <li>If the {@link NVFramebufferMixedSamples VK_NV_framebuffer_mixed_samples} extension is enabled, then it is as if the {@code coverageReductionMode} is #COVERAGE_REDUCTION_MODE_MERGE_NV.</li>
            <li>If the {@link AMDMixedAttachmentSamples VK_AMD_mixed_attachment_samples} extension is enabled, then it is as if the {@code coverageReductionMode} is #COVERAGE_REDUCTION_MODE_TRUNCATE_NV.</li>
            <li>If both {@link NVFramebufferMixedSamples VK_NV_framebuffer_mixed_samples} and {@link AMDMixedAttachmentSamples VK_AMD_mixed_attachment_samples} are enabled, then the default coverage reduction mode is implementation-dependent.</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV</li>
            <li>{@code flags} <b>must</b> be 0</li>
            <li>{@code coverageReductionMode} <b>must</b> be a valid {@code VkCoverageReductionModeNV} value</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_const_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkPipelineCoverageReductionStateCreateFlagsNV("flags", "reserved for future use.")
    VkCoverageReductionModeNV("coverageReductionMode", "a {@code VkCoverageReductionModeNV} value controlling how color sample coverage is generated from pixel coverage.")
}

val VkFramebufferMixedSamplesCombinationNV = struct(Module.VULKAN, "VkFramebufferMixedSamplesCombinationNV", mutable = false) {
    documentation =
        """
        Structure specifying a supported sample count combination.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV</li>
            <li>{@code pNext} <b>must</b> be {@code NULL}</li>
        </ul>

        <h5>See Also</h5>
        #GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV()
        """

    Expression("#STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.").mutable()
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.").mutable()
    VkCoverageReductionModeNV("coverageReductionMode", "a {@code VkCoverageReductionModeNV} value specifying the coverage reduction mode.")
    VkSampleCountFlagBits("rasterizationSamples", "a {@code VkSampleCountFlagBits} specifying the number of rasterization samples in the supported combination.")
    VkSampleCountFlags("depthStencilSamples", "specifies the number of samples in the depth stencil attachment in the supported combination. A value of 0 indicates the combination does not have a depth stencil attachment.")
    VkSampleCountFlags("colorSamples", "specifies the number of color samples in a color attachment in the supported combination. A value of 0 indicates the combination does not have a color attachment.")
}

val VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT") {
    documentation =
        """
        Structure describing fragment shader interlock features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("fragmentShaderSampleInterlock", "indicates that the implementation supports the {@code FragmentShaderSampleInterlockEXT} SPIR-V capability.")
    VkBool32("fragmentShaderPixelInterlock", "indicates that the implementation supports the {@code FragmentShaderPixelInterlockEXT} SPIR-V capability.")
    VkBool32("fragmentShaderShadingRateInterlock", "indicates that the implementation supports the {@code FragmentShaderShadingRateInterlockEXT} SPIR-V capability.")
}

val VkPhysicalDeviceYcbcrImageArraysFeaturesEXT = struct(Module.VULKAN, "VkPhysicalDeviceYcbcrImageArraysFeaturesEXT") {
    documentation =
        """
        Structure describing extended Y′C<sub>B</sub>C<sub>R</sub> image creation features that can be supported by an implementation.

        <h5>Description</h5>
        If the ##VkPhysicalDeviceYcbcrImageArraysFeaturesEXT structure is included in the {@code pNext} chain of the ##VkPhysicalDeviceFeatures2 structure passed to #GetPhysicalDeviceFeatures2(), it is filled in to indicate whether each corresponding feature is supported. ##VkPhysicalDeviceYcbcrImageArraysFeaturesEXT <b>can</b> also be used in the {@code pNext} chain of ##VkDeviceCreateInfo to selectively enable these features.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>{@code sType} <b>must</b> be #STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT</li>
        </ul>
        """

    Expression("#STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT")..VkStructureType("sType", "a {@code VkStructureType} value identifying this structure.")
    nullable..opaque_p("pNext", "{@code NULL} or a pointer to a structure extending this structure.")
    VkBool32("ycbcrImageArrays", "indicates that the implementation supports creating images with a format that requires <a href=\"https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html\\#formats-requiring