/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.vulkan.video;

import static org.lwjgl.vulkan.video.STDVulkanVideo.*;

public final class STDVulkanVideoCodecAV1 {

    public static final int
        STD_VIDEO_AV1_NUM_REF_FRAMES              = 8,
        STD_VIDEO_AV1_REFS_PER_FRAME              = 7,
        STD_VIDEO_AV1_TOTAL_REFS_PER_FRAME        = 8,
        STD_VIDEO_AV1_MAX_TILE_COLS               = 64,
        STD_VIDEO_AV1_MAX_TILE_ROWS               = 64,
        STD_VIDEO_AV1_MAX_SEGMENTS                = 8,
        STD_VIDEO_AV1_SEG_LVL_MAX                 = 8,
        STD_VIDEO_AV1_PRIMARY_REF_NONE            = 7,
        STD_VIDEO_AV1_SELECT_INTEGER_MV           = 2,
        STD_VIDEO_AV1_SELECT_SCREEN_CONTENT_TOOLS = 2,
        STD_VIDEO_AV1_SKIP_MODE_FRAMES            = 2,
        STD_VIDEO_AV1_MAX_LOOP_FILTER_STRENGTHS   = 4,
        STD_VIDEO_AV1_LOOP_FILTER_ADJUSTMENTS     = 2,
        STD_VIDEO_AV1_MAX_CDEF_FILTER_STRENGTHS   = 8,
        STD_VIDEO_AV1_MAX_NUM_PLANES              = 3,
        STD_VIDEO_AV1_GLOBAL_MOTION_PARAMS        = 6,
        STD_VIDEO_AV1_MAX_NUM_Y_POINTS            = 14,
        STD_VIDEO_AV1_MAX_NUM_CB_POINTS           = 10,
        STD_VIDEO_AV1_MAX_NUM_CR_POINTS           = 10,
        STD_VIDEO_AV1_MAX_NUM_POS_LUMA            = 24,
        STD_VIDEO_AV1_MAX_NUM_POS_CHROMA          = 25;

    /**
     * {@code StdVideoAV1Profile}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_PROFILE_MAIN AV1_PROFILE_MAIN}</li>
     * <li>{@link #STD_VIDEO_AV1_PROFILE_HIGH AV1_PROFILE_HIGH}</li>
     * <li>{@link #STD_VIDEO_AV1_PROFILE_PROFESSIONAL AV1_PROFILE_PROFESSIONAL}</li>
     * <li>{@link #STD_VIDEO_AV1_PROFILE_INVALID AV1_PROFILE_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_PROFILE_MAIN         = 0,
        STD_VIDEO_AV1_PROFILE_HIGH         = 1,
        STD_VIDEO_AV1_PROFILE_PROFESSIONAL = 2,
        STD_VIDEO_AV1_PROFILE_INVALID      = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1Level}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_2_0 AV1_LEVEL_2_0}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_2_1 AV1_LEVEL_2_1}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_2_2 AV1_LEVEL_2_2}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_2_3 AV1_LEVEL_2_3}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_3_0 AV1_LEVEL_3_0}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_3_1 AV1_LEVEL_3_1}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_3_2 AV1_LEVEL_3_2}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_3_3 AV1_LEVEL_3_3}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_4_0 AV1_LEVEL_4_0}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_4_1 AV1_LEVEL_4_1}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_4_2 AV1_LEVEL_4_2}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_4_3 AV1_LEVEL_4_3}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_5_0 AV1_LEVEL_5_0}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_5_1 AV1_LEVEL_5_1}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_5_2 AV1_LEVEL_5_2}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_5_3 AV1_LEVEL_5_3}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_6_0 AV1_LEVEL_6_0}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_6_1 AV1_LEVEL_6_1}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_6_2 AV1_LEVEL_6_2}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_6_3 AV1_LEVEL_6_3}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_7_0 AV1_LEVEL_7_0}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_7_1 AV1_LEVEL_7_1}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_7_2 AV1_LEVEL_7_2}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_7_3 AV1_LEVEL_7_3}</li>
     * <li>{@link #STD_VIDEO_AV1_LEVEL_INVALID AV1_LEVEL_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_LEVEL_2_0     = 0,
        STD_VIDEO_AV1_LEVEL_2_1     = 1,
        STD_VIDEO_AV1_LEVEL_2_2     = 2,
        STD_VIDEO_AV1_LEVEL_2_3     = 3,
        STD_VIDEO_AV1_LEVEL_3_0     = 4,
        STD_VIDEO_AV1_LEVEL_3_1     = 5,
        STD_VIDEO_AV1_LEVEL_3_2     = 6,
        STD_VIDEO_AV1_LEVEL_3_3     = 7,
        STD_VIDEO_AV1_LEVEL_4_0     = 8,
        STD_VIDEO_AV1_LEVEL_4_1     = 9,
        STD_VIDEO_AV1_LEVEL_4_2     = 10,
        STD_VIDEO_AV1_LEVEL_4_3     = 11,
        STD_VIDEO_AV1_LEVEL_5_0     = 12,
        STD_VIDEO_AV1_LEVEL_5_1     = 13,
        STD_VIDEO_AV1_LEVEL_5_2     = 14,
        STD_VIDEO_AV1_LEVEL_5_3     = 15,
        STD_VIDEO_AV1_LEVEL_6_0     = 16,
        STD_VIDEO_AV1_LEVEL_6_1     = 17,
        STD_VIDEO_AV1_LEVEL_6_2     = 18,
        STD_VIDEO_AV1_LEVEL_6_3     = 19,
        STD_VIDEO_AV1_LEVEL_7_0     = 20,
        STD_VIDEO_AV1_LEVEL_7_1     = 21,
        STD_VIDEO_AV1_LEVEL_7_2     = 22,
        STD_VIDEO_AV1_LEVEL_7_3     = 23,
        STD_VIDEO_AV1_LEVEL_INVALID = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1FrameType}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_FRAME_TYPE_KEY AV1_FRAME_TYPE_KEY}</li>
     * <li>{@link #STD_VIDEO_AV1_FRAME_TYPE_INTER AV1_FRAME_TYPE_INTER}</li>
     * <li>{@link #STD_VIDEO_AV1_FRAME_TYPE_INTRA_ONLY AV1_FRAME_TYPE_INTRA_ONLY}</li>
     * <li>{@link #STD_VIDEO_AV1_FRAME_TYPE_SWITCH AV1_FRAME_TYPE_SWITCH}</li>
     * <li>{@link #STD_VIDEO_AV1_FRAME_TYPE_INVALID AV1_FRAME_TYPE_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_FRAME_TYPE_KEY        = 0,
        STD_VIDEO_AV1_FRAME_TYPE_INTER      = 1,
        STD_VIDEO_AV1_FRAME_TYPE_INTRA_ONLY = 2,
        STD_VIDEO_AV1_FRAME_TYPE_SWITCH     = 3,
        STD_VIDEO_AV1_FRAME_TYPE_INVALID    = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1ReferenceName}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_REFERENCE_NAME_INTRA_FRAME AV1_REFERENCE_NAME_INTRA_FRAME}</li>
     * <li>{@link #STD_VIDEO_AV1_REFERENCE_NAME_LAST_FRAME AV1_REFERENCE_NAME_LAST_FRAME}</li>
     * <li>{@link #STD_VIDEO_AV1_REFERENCE_NAME_LAST2_FRAME AV1_REFERENCE_NAME_LAST2_FRAME}</li>
     * <li>{@link #STD_VIDEO_AV1_REFERENCE_NAME_LAST3_FRAME AV1_REFERENCE_NAME_LAST3_FRAME}</li>
     * <li>{@link #STD_VIDEO_AV1_REFERENCE_NAME_GOLDEN_FRAME AV1_REFERENCE_NAME_GOLDEN_FRAME}</li>
     * <li>{@link #STD_VIDEO_AV1_REFERENCE_NAME_BWDREF_FRAME AV1_REFERENCE_NAME_BWDREF_FRAME}</li>
     * <li>{@link #STD_VIDEO_AV1_REFERENCE_NAME_ALTREF2_FRAME AV1_REFERENCE_NAME_ALTREF2_FRAME}</li>
     * <li>{@link #STD_VIDEO_AV1_REFERENCE_NAME_ALTREF_FRAME AV1_REFERENCE_NAME_ALTREF_FRAME}</li>
     * <li>{@link #STD_VIDEO_AV1_REFERENCE_NAME_INVALID AV1_REFERENCE_NAME_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_REFERENCE_NAME_INTRA_FRAME   = 0,
        STD_VIDEO_AV1_REFERENCE_NAME_LAST_FRAME    = 1,
        STD_VIDEO_AV1_REFERENCE_NAME_LAST2_FRAME   = 2,
        STD_VIDEO_AV1_REFERENCE_NAME_LAST3_FRAME   = 3,
        STD_VIDEO_AV1_REFERENCE_NAME_GOLDEN_FRAME  = 4,
        STD_VIDEO_AV1_REFERENCE_NAME_BWDREF_FRAME  = 5,
        STD_VIDEO_AV1_REFERENCE_NAME_ALTREF2_FRAME = 6,
        STD_VIDEO_AV1_REFERENCE_NAME_ALTREF_FRAME  = 7,
        STD_VIDEO_AV1_REFERENCE_NAME_INVALID       = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1InterpolationFilter}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP AV1_INTERPOLATION_FILTER_EIGHTTAP}</li>
     * <li>{@link #STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH AV1_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH}</li>
     * <li>{@link #STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SHARP AV1_INTERPOLATION_FILTER_EIGHTTAP_SHARP}</li>
     * <li>{@link #STD_VIDEO_AV1_INTERPOLATION_FILTER_BILINEAR AV1_INTERPOLATION_FILTER_BILINEAR}</li>
     * <li>{@link #STD_VIDEO_AV1_INTERPOLATION_FILTER_SWITCHABLE AV1_INTERPOLATION_FILTER_SWITCHABLE}</li>
     * <li>{@link #STD_VIDEO_AV1_INTERPOLATION_FILTER_INVALID AV1_INTERPOLATION_FILTER_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP        = 0,
        STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH = 1,
        STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SHARP  = 2,
        STD_VIDEO_AV1_INTERPOLATION_FILTER_BILINEAR        = 3,
        STD_VIDEO_AV1_INTERPOLATION_FILTER_SWITCHABLE      = 4,
        STD_VIDEO_AV1_INTERPOLATION_FILTER_INVALID         = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1TxMode}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_TX_MODE_ONLY_4X4 AV1_TX_MODE_ONLY_4X4}</li>
     * <li>{@link #STD_VIDEO_AV1_TX_MODE_LARGEST AV1_TX_MODE_LARGEST}</li>
     * <li>{@link #STD_VIDEO_AV1_TX_MODE_SELECT AV1_TX_MODE_SELECT}</li>
     * <li>{@link #STD_VIDEO_AV1_TX_MODE_INVALID AV1_TX_MODE_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_TX_MODE_ONLY_4X4 = 0,
        STD_VIDEO_AV1_TX_MODE_LARGEST  = 1,
        STD_VIDEO_AV1_TX_MODE_SELECT   = 2,
        STD_VIDEO_AV1_TX_MODE_INVALID  = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1FrameRestorationType}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_NONE AV1_FRAME_RESTORATION_TYPE_NONE}</li>
     * <li>{@link #STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_WIENER AV1_FRAME_RESTORATION_TYPE_WIENER}</li>
     * <li>{@link #STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SGRPROJ AV1_FRAME_RESTORATION_TYPE_SGRPROJ}</li>
     * <li>{@link #STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SWITCHABLE AV1_FRAME_RESTORATION_TYPE_SWITCHABLE}</li>
     * <li>{@link #STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_INVALID AV1_FRAME_RESTORATION_TYPE_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_NONE       = 0,
        STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_WIENER     = 1,
        STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SGRPROJ    = 2,
        STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SWITCHABLE = 3,
        STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_INVALID    = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1ColorPrimaries}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_BT_709 AV1_COLOR_PRIMARIES_BT_709}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_UNSPECIFIED AV1_COLOR_PRIMARIES_UNSPECIFIED}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_M AV1_COLOR_PRIMARIES_BT_470_M}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_B_G AV1_COLOR_PRIMARIES_BT_470_B_G}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_BT_601 AV1_COLOR_PRIMARIES_BT_601}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_240 AV1_COLOR_PRIMARIES_SMPTE_240}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_GENERIC_FILM AV1_COLOR_PRIMARIES_GENERIC_FILM}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_BT_2020 AV1_COLOR_PRIMARIES_BT_2020}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_XYZ AV1_COLOR_PRIMARIES_XYZ}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_431 AV1_COLOR_PRIMARIES_SMPTE_431}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_432 AV1_COLOR_PRIMARIES_SMPTE_432}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_EBU_3213 AV1_COLOR_PRIMARIES_EBU_3213}</li>
     * <li>{@link #STD_VIDEO_AV1_COLOR_PRIMARIES_INVALID AV1_COLOR_PRIMARIES_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_COLOR_PRIMARIES_BT_709       = 1,
        STD_VIDEO_AV1_COLOR_PRIMARIES_UNSPECIFIED  = 2,
        STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_M     = 3,
        STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_B_G   = 4,
        STD_VIDEO_AV1_COLOR_PRIMARIES_BT_601       = 5,
        STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_240    = 6,
        STD_VIDEO_AV1_COLOR_PRIMARIES_GENERIC_FILM = 7,
        STD_VIDEO_AV1_COLOR_PRIMARIES_BT_2020      = 8,
        STD_VIDEO_AV1_COLOR_PRIMARIES_XYZ          = 9,
        STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_431    = 10,
        STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_432    = 11,
        STD_VIDEO_AV1_COLOR_PRIMARIES_EBU_3213     = 12,
        STD_VIDEO_AV1_COLOR_PRIMARIES_INVALID      = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1TransferCharacteristics}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_0 AV1_TRANSFER_CHARACTERISTICS_RESERVED_0}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_709 AV1_TRANSFER_CHARACTERISTICS_BT_709}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_UNSPECIFIED AV1_TRANSFER_CHARACTERISTICS_UNSPECIFIED}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_3 AV1_TRANSFER_CHARACTERISTICS_RESERVED_3}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_M AV1_TRANSFER_CHARACTERISTICS_BT_470_M}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_B_G AV1_TRANSFER_CHARACTERISTICS_BT_470_B_G}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_601 AV1_TRANSFER_CHARACTERISTICS_BT_601}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_240 AV1_TRANSFER_CHARACTERISTICS_SMPTE_240}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LINEAR AV1_TRANSFER_CHARACTERISTICS_LINEAR}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100 AV1_TRANSFER_CHARACTERISTICS_LOG_100}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100_SQRT10 AV1_TRANSFER_CHARACTERISTICS_LOG_100_SQRT10}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_IEC_61966 AV1_TRANSFER_CHARACTERISTICS_IEC_61966}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_1361 AV1_TRANSFER_CHARACTERISTICS_BT_1361}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SRGB AV1_TRANSFER_CHARACTERISTICS_SRGB}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_10_BIT AV1_TRANSFER_CHARACTERISTICS_BT_2020_10_BIT}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_12_BIT AV1_TRANSFER_CHARACTERISTICS_BT_2020_12_BIT}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_2084 AV1_TRANSFER_CHARACTERISTICS_SMPTE_2084}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_428 AV1_TRANSFER_CHARACTERISTICS_SMPTE_428}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_HLG AV1_TRANSFER_CHARACTERISTICS_HLG}</li>
     * <li>{@link #STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_INVALID AV1_TRANSFER_CHARACTERISTICS_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_0     = 0,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_709         = 1,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_UNSPECIFIED    = 2,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_3     = 3,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_M       = 4,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_B_G     = 5,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_601         = 6,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_240      = 7,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LINEAR         = 8,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100        = 9,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100_SQRT10 = 10,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_IEC_61966      = 11,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_1361        = 12,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SRGB           = 13,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_10_BIT = 14,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_12_BIT = 15,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_2084     = 16,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_428      = 17,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_HLG            = 18,
        STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_INVALID        = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1MatrixCoefficients}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_IDENTITY AV1_MATRIX_COEFFICIENTS_IDENTITY}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_709 AV1_MATRIX_COEFFICIENTS_BT_709}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_UNSPECIFIED AV1_MATRIX_COEFFICIENTS_UNSPECIFIED}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_RESERVED_3 AV1_MATRIX_COEFFICIENTS_RESERVED_3}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_FCC AV1_MATRIX_COEFFICIENTS_FCC}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_470_B_G AV1_MATRIX_COEFFICIENTS_BT_470_B_G}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_601 AV1_MATRIX_COEFFICIENTS_BT_601}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_240 AV1_MATRIX_COEFFICIENTS_SMPTE_240}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_YCGCO AV1_MATRIX_COEFFICIENTS_SMPTE_YCGCO}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_NCL AV1_MATRIX_COEFFICIENTS_BT_2020_NCL}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_CL AV1_MATRIX_COEFFICIENTS_BT_2020_CL}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_2085 AV1_MATRIX_COEFFICIENTS_SMPTE_2085}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_NCL AV1_MATRIX_COEFFICIENTS_CHROMAT_NCL}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_CL AV1_MATRIX_COEFFICIENTS_CHROMAT_CL}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_ICTCP AV1_MATRIX_COEFFICIENTS_ICTCP}</li>
     * <li>{@link #STD_VIDEO_AV1_MATRIX_COEFFICIENTS_INVALID AV1_MATRIX_COEFFICIENTS_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_IDENTITY    = 0,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_709      = 1,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_UNSPECIFIED = 2,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_RESERVED_3  = 3,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_FCC         = 4,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_470_B_G  = 5,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_601      = 6,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_240   = 7,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_YCGCO = 8,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_NCL = 9,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_CL  = 10,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_2085  = 11,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_NCL = 12,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_CL  = 13,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_ICTCP       = 14,
        STD_VIDEO_AV1_MATRIX_COEFFICIENTS_INVALID     = 0x7FFFFFFF;

    /**
     * {@code StdVideoAV1ChromaSamplePosition}
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_UNKNOWN AV1_CHROMA_SAMPLE_POSITION_UNKNOWN}</li>
     * <li>{@link #STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_VERTICAL AV1_CHROMA_SAMPLE_POSITION_VERTICAL}</li>
     * <li>{@link #STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_COLOCATED AV1_CHROMA_SAMPLE_POSITION_COLOCATED}</li>
     * <li>{@link #STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_RESERVED AV1_CHROMA_SAMPLE_POSITION_RESERVED}</li>
     * <li>{@link #STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_INVALID AV1_CHROMA_SAMPLE_POSITION_INVALID}</li>
     * </ul>
     */
    public static final int
        STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_UNKNOWN   = 0,
        STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_VERTICAL  = 1,
        STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_COLOCATED = 2,
        STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_RESERVED  = 3,
        STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_INVALID   = 0x7FFFFFFF;

    /** The extension specification version. */
    public static final int VK_STD_VULKAN_VIDEO_CODEC_AV1_DECODE_SPEC_VERSION = VK_MAKE_VIDEO_STD_VERSION(1, 0, 0);

    /** The extension name. */
    public static final String VK_STD_VULKAN_VIDEO_CODEC_AV1_DECODE_EXTENSION_NAME = "VK_STD_vulkan_video_codec_av1_decode";

    private STDVulkanVideoCodecAV1() {}

}