/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.vulkan;

import org.jspecify.annotations.*;

import java.nio.*;

import org.lwjgl.*;
import org.lwjgl.system.*;

import static org.lwjgl.system.MemoryUtil.*;
import static org.lwjgl.system.MemoryStack.*;

/**
 * Structure describing additional properties supported by a portable implementation.
 * 
 * <h5>Description</h5>
 * 
 * <p>If the {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR} structure is included in the {@code pNext} chain of the {@link VkPhysicalDeviceProperties2} structure passed to {@link VK11#vkGetPhysicalDeviceProperties2 GetPhysicalDeviceProperties2}, it is filled in with each corresponding implementation-dependent property.</p>
 * 
 * <h5>Valid Usage (Implicit)</h5>
 * 
 * <ul>
 * <li>{@code sType} <b>must</b> be {@link KHRPortabilitySubset#VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR}</li>
 * </ul>
 * 
 * <h3>Layout</h3>
 * 
 * <pre><code>
 * struct VkPhysicalDevicePortabilitySubsetPropertiesKHR {
 *     VkStructureType {@link #sType};
 *     void * {@link #pNext};
 *     uint32_t {@link #minVertexInputBindingStrideAlignment};
 * }</code></pre>
 */
public class VkPhysicalDevicePortabilitySubsetPropertiesKHR extends Struct<VkPhysicalDevicePortabilitySubsetPropertiesKHR> implements NativeResource {

    /** The struct size in bytes. */
    public static final int SIZEOF;

    /** The struct alignment in bytes. */
    public static final int ALIGNOF;

    /** The struct member offsets. */
    public static final int
        STYPE,
        PNEXT,
        MINVERTEXINPUTBINDINGSTRIDEALIGNMENT;

    static {
        Layout layout = __struct(
            __member(4),
            __member(POINTER_SIZE),
            __member(4)
        );

        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();

        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MINVERTEXINPUTBINDINGSTRIDEALIGNMENT = layout.offsetof(2);
    }

    protected VkPhysicalDevicePortabilitySubsetPropertiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDevicePortabilitySubsetPropertiesKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDevicePortabilitySubsetPropertiesKHR(address, container);
    }

    /**
     * Creates a {@code VkPhysicalDevicePortabilitySubsetPropertiesKHR} instance at the current position of the specified {@link ByteBuffer} container. Changes to the buffer's content will be
     * visible to the struct instance and vice versa.
     *
     * <p>The created instance holds a strong reference to the container object.</p>
     */
    public VkPhysicalDevicePortabilitySubsetPropertiesKHR(ByteBuffer container) {
        super(memAddress(container), __checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() { return SIZEOF; }

    /** a {@code VkStructureType} value identifying this structure. */
    @NativeType("VkStructureType")
    public int sType() { return nsType(address()); }
    /** {@code NULL} or a pointer to a structure extending this structure. */
    @NativeType("void *")
    public long pNext() { return npNext(address()); }
    /** indicates the minimum alignment for vertex input strides. {@link VkVertexInputBindingDescription}{@code ::stride} <b>must</b> be a multiple of, and at least as large as, this value. The value <b>must</b> be a power of two. */
    @NativeType("uint32_t")
    public int minVertexInputBindingStrideAlignment() { return nminVertexInputBindingStrideAlignment(address()); }

    /** Sets the specified value to the {@link #sType} field. */
    public VkPhysicalDevicePortabilitySubsetPropertiesKHR sType(@NativeType("VkStructureType") int value) { nsType(address(), value); return this; }
    /** Sets the {@link KHRPortabilitySubset#VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR} value to the {@link #sType} field. */
    public VkPhysicalDevicePortabilitySubsetPropertiesKHR sType$Default() { return sType(KHRPortabilitySubset.VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR); }
    /** Sets the specified value to the {@link #pNext} field. */
    public VkPhysicalDevicePortabilitySubsetPropertiesKHR pNext(@NativeType("void *") long value) { npNext(address(), value); return this; }
    /** Sets the specified value to the {@link #minVertexInputBindingStrideAlignment} field. */
    public VkPhysicalDevicePortabilitySubsetPropertiesKHR minVertexInputBindingStrideAlignment(@NativeType("uint32_t") int value) { nminVertexInputBindingStrideAlignment(address(), value); return this; }

    /** Initializes this struct with the specified values. */
    public VkPhysicalDevicePortabilitySubsetPropertiesKHR set(
        int sType,
        long pNext,
        int minVertexInputBindingStrideAlignment
    ) {
        sType(sType);
        pNext(pNext);
        minVertexInputBindingStrideAlignment(minVertexInputBindingStrideAlignment);

        return this;
    }

    /**
     * Copies the specified struct data to this struct.
     *
     * @param src the source struct
     *
     * @return this struct
     */
    public VkPhysicalDevicePortabilitySubsetPropertiesKHR set(VkPhysicalDevicePortabilitySubsetPropertiesKHR src) {
        memCopy(src.address(), address(), SIZEOF);
        return this;
    }

    // -----------------------------------

    /** Returns a new {@code VkPhysicalDevicePortabilitySubsetPropertiesKHR} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed. */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR malloc() {
        return new VkPhysicalDevicePortabilitySubsetPropertiesKHR(nmemAllocChecked(SIZEOF), null);
    }

    /** Returns a new {@code VkPhysicalDevicePortabilitySubsetPropertiesKHR} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed. */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR calloc() {
        return new VkPhysicalDevicePortabilitySubsetPropertiesKHR(nmemCallocChecked(1, SIZEOF), null);
    }

    /** Returns a new {@code VkPhysicalDevicePortabilitySubsetPropertiesKHR} instance allocated with {@link BufferUtils}. */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDevicePortabilitySubsetPropertiesKHR(memAddress(container), container);
    }

    /** Returns a new {@code VkPhysicalDevicePortabilitySubsetPropertiesKHR} instance for the specified memory address. */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR create(long address) {
        return new VkPhysicalDevicePortabilitySubsetPropertiesKHR(address, null);
    }

    /** Like {@link #create(long) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    public static @Nullable VkPhysicalDevicePortabilitySubsetPropertiesKHR createSafe(long address) {
        return address == NULL ? null : new VkPhysicalDevicePortabilitySubsetPropertiesKHR(address, null);
    }

    /**
     * Returns a new {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer malloc(int capacity) {
        return new Buffer(nmemAllocChecked(__checkMalloc(capacity, SIZEOF)), capacity);
    }

    /**
     * Returns a new {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer calloc(int capacity) {
        return new Buffer(nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    /**
     * Returns a new {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer} instance allocated with {@link BufferUtils}.
     *
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer create(int capacity) {
        ByteBuffer container = __create(capacity, SIZEOF);
        return new Buffer(memAddress(container), container, -1, 0, capacity, capacity);
    }

    /**
     * Create a {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer} instance at the specified memory.
     *
     * @param address  the memory address
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    /** Like {@link #create(long, int) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR.@Nullable Buffer createSafe(long address, int capacity) {
        return address == NULL ? null : new Buffer(address, capacity);
    }

    /**
     * Returns a new {@code VkPhysicalDevicePortabilitySubsetPropertiesKHR} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack the stack from which to allocate
     */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR malloc(MemoryStack stack) {
        return new VkPhysicalDevicePortabilitySubsetPropertiesKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    /**
     * Returns a new {@code VkPhysicalDevicePortabilitySubsetPropertiesKHR} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack the stack from which to allocate
     */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR calloc(MemoryStack stack) {
        return new VkPhysicalDevicePortabilitySubsetPropertiesKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    /**
     * Returns a new {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    /**
     * Returns a new {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    // -----------------------------------

    /** Unsafe version of {@link #sType}. */
    public static int nsType(long struct) { return memGetInt(struct + VkPhysicalDevicePortabilitySubsetPropertiesKHR.STYPE); }
    /** Unsafe version of {@link #pNext}. */
    public static long npNext(long struct) { return memGetAddress(struct + VkPhysicalDevicePortabilitySubsetPropertiesKHR.PNEXT); }
    /** Unsafe version of {@link #minVertexInputBindingStrideAlignment}. */
    public static int nminVertexInputBindingStrideAlignment(long struct) { return memGetInt(struct + VkPhysicalDevicePortabilitySubsetPropertiesKHR.MINVERTEXINPUTBINDINGSTRIDEALIGNMENT); }

    /** Unsafe version of {@link #sType(int) sType}. */
    public static void nsType(long struct, int value) { memPutInt(struct + VkPhysicalDevicePortabilitySubsetPropertiesKHR.STYPE, value); }
    /** Unsafe version of {@link #pNext(long) pNext}. */
    public static void npNext(long struct, long value) { memPutAddress(struct + VkPhysicalDevicePortabilitySubsetPropertiesKHR.PNEXT, value); }
    /** Unsafe version of {@link #minVertexInputBindingStrideAlignment(int) minVertexInputBindingStrideAlignment}. */
    public static void nminVertexInputBindingStrideAlignment(long struct, int value) { memPutInt(struct + VkPhysicalDevicePortabilitySubsetPropertiesKHR.MINVERTEXINPUTBINDINGSTRIDEALIGNMENT, value); }

    // -----------------------------------

    /** An array of {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR} structs. */
    public static class Buffer extends StructBuffer<VkPhysicalDevicePortabilitySubsetPropertiesKHR, Buffer> implements NativeResource {

        private static final VkPhysicalDevicePortabilitySubsetPropertiesKHR ELEMENT_FACTORY = VkPhysicalDevicePortabilitySubsetPropertiesKHR.create(-1L);

        /**
         * Creates a new {@code VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer} instance backed by the specified container.
         *
         * <p>Changes to the container's content will be visible to the struct buffer instance and vice versa. The two buffers' position, limit, and mark values
         * will be independent. The new buffer's position will be zero, its capacity and its limit will be the number of bytes remaining in this buffer divided
         * by {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR#SIZEOF}, and its mark will be undefined.</p>
         *
         * <p>The created buffer instance holds a strong reference to the container object.</p>
         */
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPhysicalDevicePortabilitySubsetPropertiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        /** @return the value of the {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR#sType} field. */
        @NativeType("VkStructureType")
        public int sType() { return VkPhysicalDevicePortabilitySubsetPropertiesKHR.nsType(address()); }
        /** @return the value of the {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR#pNext} field. */
        @NativeType("void *")
        public long pNext() { return VkPhysicalDevicePortabilitySubsetPropertiesKHR.npNext(address()); }
        /** @return the value of the {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR#minVertexInputBindingStrideAlignment} field. */
        @NativeType("uint32_t")
        public int minVertexInputBindingStrideAlignment() { return VkPhysicalDevicePortabilitySubsetPropertiesKHR.nminVertexInputBindingStrideAlignment(address()); }

        /** Sets the specified value to the {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR#sType} field. */
        public VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer sType(@NativeType("VkStructureType") int value) { VkPhysicalDevicePortabilitySubsetPropertiesKHR.nsType(address(), value); return this; }
        /** Sets the {@link KHRPortabilitySubset#VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR} value to the {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR#sType} field. */
        public VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer sType$Default() { return sType(KHRPortabilitySubset.VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR); }
        /** Sets the specified value to the {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR#pNext} field. */
        public VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer pNext(@NativeType("void *") long value) { VkPhysicalDevicePortabilitySubsetPropertiesKHR.npNext(address(), value); return this; }
        /** Sets the specified value to the {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR#minVertexInputBindingStrideAlignment} field. */
        public VkPhysicalDevicePortabilitySubsetPropertiesKHR.Buffer minVertexInputBindingStrideAlignment(@NativeType("uint32_t") int value) { VkPhysicalDevicePortabilitySubsetPropertiesKHR.nminVertexInputBindingStrideAlignment(address(), value); return this; }

    }

}