/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 */
package spvc.templates

import org.lwjgl.generator.*

val Spv = "Spv".nativeClass(Module.SPVC, prefix = "Spv", prefixConstant = "Spv", prefixMethod = "Spv") {
    documentation = "Enumeration tokens for SPIR-V."

    IntConstant("", "SPV_VERSION".."0x10600").noPrefix()
    IntConstant("", "SPV_REVISION".."1").noPrefix()

    IntConstant("", "MagicNumber".."0x07230203")
    IntConstant("", "Version".."0x00010600")
    IntConstant("", "Revision".."1")
    IntConstant("", "OpCodeMask".."0xffff")
    IntConstant("", "WordCountShift".."16")

    EnumConstant(
        "{@code SpvSourceLanguage}",

        "SourceLanguageUnknown".."0",
        "SourceLanguageESSL".."1",
        "SourceLanguageGLSL".."2",
        "SourceLanguageOpenCL_C".."3",
        "SourceLanguageOpenCL_CPP".."4",
        "SourceLanguageHLSL".."5",
        "SourceLanguageCPP_for_OpenCL".."6",
        "SourceLanguageSYCL".."7",
        "SourceLanguageMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvExecutionModel}",

        "ExecutionModelVertex".."0",
        "ExecutionModelTessellationControl".."1",
        "ExecutionModelTessellationEvaluation".."2",
        "ExecutionModelGeometry".."3",
        "ExecutionModelFragment".."4",
        "ExecutionModelGLCompute".."5",
        "ExecutionModelKernel".."6",
        "ExecutionModelTaskNV".."5267",
        "ExecutionModelMeshNV".."5268",
        "ExecutionModelRayGenerationKHR".."5313",
        "ExecutionModelRayGenerationNV".."5313",
        "ExecutionModelIntersectionKHR".."5314",
        "ExecutionModelIntersectionNV".."5314",
        "ExecutionModelAnyHitKHR".."5315",
        "ExecutionModelAnyHitNV".."5315",
        "ExecutionModelClosestHitKHR".."5316",
        "ExecutionModelClosestHitNV".."5316",
        "ExecutionModelMissKHR".."5317",
        "ExecutionModelMissNV".."5317",
        "ExecutionModelCallableKHR".."5318",
        "ExecutionModelCallableNV".."5318",
        "ExecutionModelTaskEXT".."5364",
        "ExecutionModelMeshEXT".."5365",
        "ExecutionModelMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvAddressingModel}",

        "AddressingModelLogical".."0",
        "AddressingModelPhysical32".."1",
        "AddressingModelPhysical64".."2",
        "AddressingModelPhysicalStorageBuffer64".."5348",
        "AddressingModelPhysicalStorageBuffer64EXT".."5348",
        "AddressingModelMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvMemoryModel}",

        "MemoryModelSimple".."0",
        "MemoryModelGLSL450".."1",
        "MemoryModelOpenCL".."2",
        "MemoryModelVulkan".."3",
        "MemoryModelVulkanKHR".."3",
        "MemoryModelMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvExecutionMode}",

        "ExecutionModeInvocations".."0",
        "ExecutionModeSpacingEqual".."1",
        "ExecutionModeSpacingFractionalEven".."2",
        "ExecutionModeSpacingFractionalOdd".."3",
        "ExecutionModeVertexOrderCw".."4",
        "ExecutionModeVertexOrderCcw".."5",
        "ExecutionModePixelCenterInteger".."6",
        "ExecutionModeOriginUpperLeft".."7",
        "ExecutionModeOriginLowerLeft".."8",
        "ExecutionModeEarlyFragmentTests".."9",
        "ExecutionModePointMode".."10",
        "ExecutionModeXfb".."11",
        "ExecutionModeDepthReplacing".."12",
        "ExecutionModeDepthGreater".."14",
        "ExecutionModeDepthLess".."15",
        "ExecutionModeDepthUnchanged".."16",
        "ExecutionModeLocalSize".."17",
        "ExecutionModeLocalSizeHint".."18",
        "ExecutionModeInputPoints".."19",
        "ExecutionModeInputLines".."20",
        "ExecutionModeInputLinesAdjacency".."21",
        "ExecutionModeTriangles".."22",
        "ExecutionModeInputTrianglesAdjacency".."23",
        "ExecutionModeQuads".."24",
        "ExecutionModeIsolines".."25",
        "ExecutionModeOutputVertices".."26",
        "ExecutionModeOutputPoints".."27",
        "ExecutionModeOutputLineStrip".."28",
        "ExecutionModeOutputTriangleStrip".."29",
        "ExecutionModeVecTypeHint".."30",
        "ExecutionModeContractionOff".."31",
        "ExecutionModeInitializer".."33",
        "ExecutionModeFinalizer".."34",
        "ExecutionModeSubgroupSize".."35",
        "ExecutionModeSubgroupsPerWorkgroup".."36",
        "ExecutionModeSubgroupsPerWorkgroupId".."37",
        "ExecutionModeLocalSizeId".."38",
        "ExecutionModeLocalSizeHintId".."39",
        "ExecutionModeSubgroupUniformControlFlowKHR".."4421",
        "ExecutionModePostDepthCoverage".."4446",
        "ExecutionModeDenormPreserve".."4459",
        "ExecutionModeDenormFlushToZero".."4460",
        "ExecutionModeSignedZeroInfNanPreserve".."4461",
        "ExecutionModeRoundingModeRTE".."4462",
        "ExecutionModeRoundingModeRTZ".."4463",
        "ExecutionModeEarlyAndLateFragmentTestsAMD".."5017",
        "ExecutionModeStencilRefReplacingEXT".."5027",
        "ExecutionModeStencilRefUnchangedFrontAMD".."5079",
        "ExecutionModeStencilRefGreaterFrontAMD".."5080",
        "ExecutionModeStencilRefLessFrontAMD".."5081",
        "ExecutionModeStencilRefUnchangedBackAMD".."5082",
        "ExecutionModeStencilRefGreaterBackAMD".."5083",
        "ExecutionModeStencilRefLessBackAMD".."5084",
        "ExecutionModeOutputLinesEXT".."5269",
        "ExecutionModeOutputLinesNV".."5269",
        "ExecutionModeOutputPrimitivesEXT".."5270",
        "ExecutionModeOutputPrimitivesNV".."5270",
        "ExecutionModeDerivativeGroupQuadsNV".."5289",
        "ExecutionModeDerivativeGroupLinearNV".."5290",
        "ExecutionModeOutputTrianglesEXT".."5298",
        "ExecutionModeOutputTrianglesNV".."5298",
        "ExecutionModePixelInterlockOrderedEXT".."5366",
        "ExecutionModePixelInterlockUnorderedEXT".."5367",
        "ExecutionModeSampleInterlockOrderedEXT".."5368",
        "ExecutionModeSampleInterlockUnorderedEXT".."5369",
        "ExecutionModeShadingRateInterlockOrderedEXT".."5370",
        "ExecutionModeShadingRateInterlockUnorderedEXT".."5371",
        "ExecutionModeSharedLocalMemorySizeINTEL".."5618",
        "ExecutionModeRoundingModeRTPINTEL".."5620",
        "ExecutionModeRoundingModeRTNINTEL".."5621",
        "ExecutionModeFloatingPointModeALTINTEL".."5622",
        "ExecutionModeFloatingPointModeIEEEINTEL".."5623",
        "ExecutionModeMaxWorkgroupSizeINTEL".."5893",
        "ExecutionModeMaxWorkDimINTEL".."5894",
        "ExecutionModeNoGlobalOffsetINTEL".."5895",
        "ExecutionModeNumSIMDWorkitemsINTEL".."5896",
        "ExecutionModeSchedulerTargetFmaxMhzINTEL".."5903",
        "ExecutionModeNamedBarrierCountINTEL".."6417",
        "ExecutionModeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvStorageClass}",

        "StorageClassUniformConstant".."0",
        "StorageClassInput".."1",
        "StorageClassUniform".."2",
        "StorageClassOutput".."3",
        "StorageClassWorkgroup".."4",
        "StorageClassCrossWorkgroup".."5",
        "StorageClassPrivate".."6",
        "StorageClassFunction".."7",
        "StorageClassGeneric".."8",
        "StorageClassPushConstant".."9",
        "StorageClassAtomicCounter".."10",
        "StorageClassImage".."11",
        "StorageClassStorageBuffer".."12",
        "StorageClassCallableDataKHR".."5328",
        "StorageClassCallableDataNV".."5328",
        "StorageClassIncomingCallableDataKHR".."5329",
        "StorageClassIncomingCallableDataNV".."5329",
        "StorageClassRayPayloadKHR".."5338",
        "StorageClassRayPayloadNV".."5338",
        "StorageClassHitAttributeKHR".."5339",
        "StorageClassHitAttributeNV".."5339",
        "StorageClassIncomingRayPayloadKHR".."5342",
        "StorageClassIncomingRayPayloadNV".."5342",
        "StorageClassShaderRecordBufferKHR".."5343",
        "StorageClassShaderRecordBufferNV".."5343",
        "StorageClassPhysicalStorageBuffer".."5349",
        "StorageClassPhysicalStorageBufferEXT".."5349",
        "StorageClassTaskPayloadWorkgroupEXT".."5402",
        "StorageClassCodeSectionINTEL".."5605",
        "StorageClassDeviceOnlyINTEL".."5936",
        "StorageClassHostOnlyINTEL".."5937",
        "StorageClassMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvDim}",

        "Dim1D".."0",
        "Dim2D".."1",
        "Dim3D".."2",
        "DimCube".."3",
        "DimRect".."4",
        "DimBuffer".."5",
        "DimSubpassData".."6",
        "DimMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvSamplerAddressingMode}",

        "SamplerAddressingModeNone".."0",
        "SamplerAddressingModeClampToEdge".."1",
        "SamplerAddressingModeClamp".."2",
        "SamplerAddressingModeRepeat".."3",
        "SamplerAddressingModeRepeatMirrored".."4",
        "SamplerAddressingModeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvSamplerFilterMode}",

        "SamplerFilterModeNearest".."0",
        "SamplerFilterModeLinear".."1",
        "SamplerFilterModeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvImageFormat}",

        "ImageFormatUnknown".."0",
        "ImageFormatRgba32f".."1",
        "ImageFormatRgba16f".."2",
        "ImageFormatR32f".."3",
        "ImageFormatRgba8".."4",
        "ImageFormatRgba8Snorm".."5",
        "ImageFormatRg32f".."6",
        "ImageFormatRg16f".."7",
        "ImageFormatR11fG11fB10f".."8",
        "ImageFormatR16f".."9",
        "ImageFormatRgba16".."10",
        "ImageFormatRgb10A2".."11",
        "ImageFormatRg16".."12",
        "ImageFormatRg8".."13",
        "ImageFormatR16".."14",
        "ImageFormatR8".."15",
        "ImageFormatRgba16Snorm".."16",
        "ImageFormatRg16Snorm".."17",
        "ImageFormatRg8Snorm".."18",
        "ImageFormatR16Snorm".."19",
        "ImageFormatR8Snorm".."20",
        "ImageFormatRgba32i".."21",
        "ImageFormatRgba16i".."22",
        "ImageFormatRgba8i".."23",
        "ImageFormatR32i".."24",
        "ImageFormatRg32i".."25",
        "ImageFormatRg16i".."26",
        "ImageFormatRg8i".."27",
        "ImageFormatR16i".."28",
        "ImageFormatR8i".."29",
        "ImageFormatRgba32ui".."30",
        "ImageFormatRgba16ui".."31",
        "ImageFormatRgba8ui".."32",
        "ImageFormatR32ui".."33",
        "ImageFormatRgb10a2ui".."34",
        "ImageFormatRg32ui".."35",
        "ImageFormatRg16ui".."36",
        "ImageFormatRg8ui".."37",
        "ImageFormatR16ui".."38",
        "ImageFormatR8ui".."39",
        "ImageFormatR64ui".."40",
        "ImageFormatR64i".."41",
        "ImageFormatMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvImageChannelOrder}",

        "ImageChannelOrderR".."0",
        "ImageChannelOrderA".."1",
        "ImageChannelOrderRG".."2",
        "ImageChannelOrderRA".."3",
        "ImageChannelOrderRGB".."4",
        "ImageChannelOrderRGBA".."5",
        "ImageChannelOrderBGRA".."6",
        "ImageChannelOrderARGB".."7",
        "ImageChannelOrderIntensity".."8",
        "ImageChannelOrderLuminance".."9",
        "ImageChannelOrderRx".."10",
        "ImageChannelOrderRGx".."11",
        "ImageChannelOrderRGBx".."12",
        "ImageChannelOrderDepth".."13",
        "ImageChannelOrderDepthStencil".."14",
        "ImageChannelOrdersRGB".."15",
        "ImageChannelOrdersRGBx".."16",
        "ImageChannelOrdersRGBA".."17",
        "ImageChannelOrdersBGRA".."18",
        "ImageChannelOrderABGR".."19",
        "ImageChannelOrderMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvImageChannelDataType}",

        "ImageChannelDataTypeSnormInt8".."0",
        "ImageChannelDataTypeSnormInt16".."1",
        "ImageChannelDataTypeUnormInt8".."2",
        "ImageChannelDataTypeUnormInt16".."3",
        "ImageChannelDataTypeUnormShort565".."4",
        "ImageChannelDataTypeUnormShort555".."5",
        "ImageChannelDataTypeUnormInt101010".."6",
        "ImageChannelDataTypeSignedInt8".."7",
        "ImageChannelDataTypeSignedInt16".."8",
        "ImageChannelDataTypeSignedInt32".."9",
        "ImageChannelDataTypeUnsignedInt8".."10",
        "ImageChannelDataTypeUnsignedInt16".."11",
        "ImageChannelDataTypeUnsignedInt32".."12",
        "ImageChannelDataTypeHalfFloat".."13",
        "ImageChannelDataTypeFloat".."14",
        "ImageChannelDataTypeUnormInt24".."15",
        "ImageChannelDataTypeUnormInt101010_2".."16",
        "ImageChannelDataTypeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvImageOperandsShift}",

        "ImageOperandsBiasShift".."0",
        "ImageOperandsLodShift".."1",
        "ImageOperandsGradShift".."2",
        "ImageOperandsConstOffsetShift".."3",
        "ImageOperandsOffsetShift".."4",
        "ImageOperandsConstOffsetsShift".."5",
        "ImageOperandsSampleShift".."6",
        "ImageOperandsMinLodShift".."7",
        "ImageOperandsMakeTexelAvailableShift".."8",
        "ImageOperandsMakeTexelAvailableKHRShift".."8",
        "ImageOperandsMakeTexelVisibleShift".."9",
        "ImageOperandsMakeTexelVisibleKHRShift".."9",
        "ImageOperandsNonPrivateTexelShift".."10",
        "ImageOperandsNonPrivateTexelKHRShift".."10",
        "ImageOperandsVolatileTexelShift".."11",
        "ImageOperandsVolatileTexelKHRShift".."11",
        "ImageOperandsSignExtendShift".."12",
        "ImageOperandsZeroExtendShift".."13",
        "ImageOperandsNontemporalShift".."14",
        "ImageOperandsOffsetsShift".."16",
        "ImageOperandsMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvImageOperandsMask}",

        "ImageOperandsMaskNone".."0",
        "ImageOperandsBiasMask".."0x00000001",
        "ImageOperandsLodMask".."0x00000002",
        "ImageOperandsGradMask".."0x00000004",
        "ImageOperandsConstOffsetMask".."0x00000008",
        "ImageOperandsOffsetMask".."0x00000010",
        "ImageOperandsConstOffsetsMask".."0x00000020",
        "ImageOperandsSampleMask".."0x00000040",
        "ImageOperandsMinLodMask".."0x00000080",
        "ImageOperandsMakeTexelAvailableMask".."0x00000100",
        "ImageOperandsMakeTexelAvailableKHRMask".."0x00000100",
        "ImageOperandsMakeTexelVisibleMask".."0x00000200",
        "ImageOperandsMakeTexelVisibleKHRMask".."0x00000200",
        "ImageOperandsNonPrivateTexelMask".."0x00000400",
        "ImageOperandsNonPrivateTexelKHRMask".."0x00000400",
        "ImageOperandsVolatileTexelMask".."0x00000800",
        "ImageOperandsVolatileTexelKHRMask".."0x00000800",
        "ImageOperandsSignExtendMask".."0x00001000",
        "ImageOperandsZeroExtendMask".."0x00002000",
        "ImageOperandsNontemporalMask".."0x00004000",
        "ImageOperandsOffsetsMask".."0x00010000"
    )

    EnumConstant(
        "{@code SpvFPFastMathModeShift}",

        "FPFastMathModeNotNaNShift".."0",
        "FPFastMathModeNotInfShift".."1",
        "FPFastMathModeNSZShift".."2",
        "FPFastMathModeAllowRecipShift".."3",
        "FPFastMathModeFastShift".."4",
        "FPFastMathModeAllowContractFastINTELShift".."16",
        "FPFastMathModeAllowReassocINTELShift".."17",
        "FPFastMathModeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvFPFastMathModeMask}",

        "FPFastMathModeMaskNone".."0",
        "FPFastMathModeNotNaNMask".."0x00000001",
        "FPFastMathModeNotInfMask".."0x00000002",
        "FPFastMathModeNSZMask".."0x00000004",
        "FPFastMathModeAllowRecipMask".."0x00000008",
        "FPFastMathModeFastMask".."0x00000010",
        "FPFastMathModeAllowContractFastINTELMask".."0x00010000",
        "FPFastMathModeAllowReassocINTELMask".."0x00020000"
    )

    EnumConstant(
        "{@code SpvFPRoundingMode}",

        "FPRoundingModeRTE".."0",
        "FPRoundingModeRTZ".."1",
        "FPRoundingModeRTP".."2",
        "FPRoundingModeRTN".."3",
        "FPRoundingModeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvLinkageType}",

        "LinkageTypeExport".."0",
        "LinkageTypeImport".."1",
        "LinkageTypeLinkOnceODR".."2",
        "LinkageTypeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvAccessQualifier}",

        "AccessQualifierReadOnly".."0",
        "AccessQualifierWriteOnly".."1",
        "AccessQualifierReadWrite".."2",
        "AccessQualifierMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvFunctionParameterAttribute}",

        "FunctionParameterAttributeZext".."0",
        "FunctionParameterAttributeSext".."1",
        "FunctionParameterAttributeByVal".."2",
        "FunctionParameterAttributeSret".."3",
        "FunctionParameterAttributeNoAlias".."4",
        "FunctionParameterAttributeNoCapture".."5",
        "FunctionParameterAttributeNoWrite".."6",
        "FunctionParameterAttributeNoReadWrite".."7",
        "FunctionParameterAttributeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvDecoration}",

        "DecorationRelaxedPrecision".."0",
        "DecorationSpecId".."1",
        "DecorationBlock".."2",
        "DecorationBufferBlock".."3",
        "DecorationRowMajor".."4",
        "DecorationColMajor".."5",
        "DecorationArrayStride".."6",
        "DecorationMatrixStride".."7",
        "DecorationGLSLShared".."8",
        "DecorationGLSLPacked".."9",
        "DecorationCPacked".."10",
        "DecorationBuiltIn".."11",
        "DecorationNoPerspective".."13",
        "DecorationFlat".."14",
        "DecorationPatch".."15",
        "DecorationCentroid".."16",
        "DecorationSample".."17",
        "DecorationInvariant".."18",
        "DecorationRestrict".."19",
        "DecorationAliased".."20",
        "DecorationVolatile".."21",
        "DecorationConstant".."22",
        "DecorationCoherent".."23",
        "DecorationNonWritable".."24",
        "DecorationNonReadable".."25",
        "DecorationUniform".."26",
        "DecorationUniformId".."27",
        "DecorationSaturatedConversion".."28",
        "DecorationStream".."29",
        "DecorationLocation".."30",
        "DecorationComponent".."31",
        "DecorationIndex".."32",
        "DecorationBinding".."33",
        "DecorationDescriptorSet".."34",
        "DecorationOffset".."35",
        "DecorationXfbBuffer".."36",
        "DecorationXfbStride".."37",
        "DecorationFuncParamAttr".."38",
        "DecorationFPRoundingMode".."39",
        "DecorationFPFastMathMode".."40",
        "DecorationLinkageAttributes".."41",
        "DecorationNoContraction".."42",
        "DecorationInputAttachmentIndex".."43",
        "DecorationAlignment".."44",
        "DecorationMaxByteOffset".."45",
        "DecorationAlignmentId".."46",
        "DecorationMaxByteOffsetId".."47",
        "DecorationNoSignedWrap".."4469",
        "DecorationNoUnsignedWrap".."4470",
        "DecorationWeightTextureQCOM".."4487",
        "DecorationBlockMatchTextureQCOM".."4488",
        "DecorationBlockMatchSamplerQCOM".."4499",
        "DecorationExplicitInterpAMD".."4999",
        "DecorationOverrideCoverageNV".."5248",
        "DecorationPassthroughNV".."5250",
        "DecorationViewportRelativeNV".."5252",
        "DecorationSecondaryViewportRelativeNV".."5256",
        "DecorationPerPrimitiveEXT".."5271",
        "DecorationPerPrimitiveNV".."5271",
        "DecorationPerViewNV".."5272",
        "DecorationPerTaskNV".."5273",
        "DecorationPerVertexKHR".."5285",
        "DecorationPerVertexNV".."5285",
        "DecorationNonUniform".."5300",
        "DecorationNonUniformEXT".."5300",
        "DecorationRestrictPointer".."5355",
        "DecorationRestrictPointerEXT".."5355",
        "DecorationAliasedPointer".."5356",
        "DecorationAliasedPointerEXT".."5356",
        "DecorationBindlessSamplerNV".."5398",
        "DecorationBindlessImageNV".."5399",
        "DecorationBoundSamplerNV".."5400",
        "DecorationBoundImageNV".."5401",
        "DecorationSIMTCallINTEL".."5599",
        "DecorationReferencedIndirectlyINTEL".."5602",
        "DecorationClobberINTEL".."5607",
        "DecorationSideEffectsINTEL".."5608",
        "DecorationVectorComputeVariableINTEL".."5624",
        "DecorationFuncParamIOKindINTEL".."5625",
        "DecorationVectorComputeFunctionINTEL".."5626",
        "DecorationStackCallINTEL".."5627",
        "DecorationGlobalVariableOffsetINTEL".."5628",
        "DecorationCounterBuffer".."5634",
        "DecorationHlslCounterBufferGOOGLE".."5634",
        "DecorationHlslSemanticGOOGLE".."5635",
        "DecorationUserSemantic".."5635",
        "DecorationUserTypeGOOGLE".."5636",
        "DecorationFunctionRoundingModeINTEL".."5822",
        "DecorationFunctionDenormModeINTEL".."5823",
        "DecorationRegisterINTEL".."5825",
        "DecorationMemoryINTEL".."5826",
        "DecorationNumbanksINTEL".."5827",
        "DecorationBankwidthINTEL".."5828",
        "DecorationMaxPrivateCopiesINTEL".."5829",
        "DecorationSinglepumpINTEL".."5830",
        "DecorationDoublepumpINTEL".."5831",
        "DecorationMaxReplicatesINTEL".."5832",
        "DecorationSimpleDualPortINTEL".."5833",
        "DecorationMergeINTEL".."5834",
        "DecorationBankBitsINTEL".."5835",
        "DecorationForcePow2DepthINTEL".."5836",
        "DecorationBurstCoalesceINTEL".."5899",
        "DecorationCacheSizeINTEL".."5900",
        "DecorationDontStaticallyCoalesceINTEL".."5901",
        "DecorationPrefetchINTEL".."5902",
        "DecorationStallEnableINTEL".."5905",
        "DecorationFuseLoopsInFunctionINTEL".."5907",
        "DecorationAliasScopeINTEL".."5914",
        "DecorationNoAliasINTEL".."5915",
        "DecorationBufferLocationINTEL".."5921",
        "DecorationIOPipeStorageINTEL".."5944",
        "DecorationFunctionFloatingPointModeINTEL".."6080",
        "DecorationSingleElementVectorINTEL".."6085",
        "DecorationVectorComputeCallableFunctionINTEL".."6087",
        "DecorationMediaBlockIOINTEL".."6140",
        "DecorationMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvBuiltIn}",

        "BuiltInPosition".."0",
        "BuiltInPointSize".."1",
        "BuiltInClipDistance".."3",
        "BuiltInCullDistance".."4",
        "BuiltInVertexId".."5",
        "BuiltInInstanceId".."6",
        "BuiltInPrimitiveId".."7",
        "BuiltInInvocationId".."8",
        "BuiltInLayer".."9",
        "BuiltInViewportIndex".."10",
        "BuiltInTessLevelOuter".."11",
        "BuiltInTessLevelInner".."12",
        "BuiltInTessCoord".."13",
        "BuiltInPatchVertices".."14",
        "BuiltInFragCoord".."15",
        "BuiltInPointCoord".."16",
        "BuiltInFrontFacing".."17",
        "BuiltInSampleId".."18",
        "BuiltInSamplePosition".."19",
        "BuiltInSampleMask".."20",
        "BuiltInFragDepth".."22",
        "BuiltInHelperInvocation".."23",
        "BuiltInNumWorkgroups".."24",
        "BuiltInWorkgroupSize".."25",
        "BuiltInWorkgroupId".."26",
        "BuiltInLocalInvocationId".."27",
        "BuiltInGlobalInvocationId".."28",
        "BuiltInLocalInvocationIndex".."29",
        "BuiltInWorkDim".."30",
        "BuiltInGlobalSize".."31",
        "BuiltInEnqueuedWorkgroupSize".."32",
        "BuiltInGlobalOffset".."33",
        "BuiltInGlobalLinearId".."34",
        "BuiltInSubgroupSize".."36",
        "BuiltInSubgroupMaxSize".."37",
        "BuiltInNumSubgroups".."38",
        "BuiltInNumEnqueuedSubgroups".."39",
        "BuiltInSubgroupId".."40",
        "BuiltInSubgroupLocalInvocationId".."41",
        "BuiltInVertexIndex".."42",
        "BuiltInInstanceIndex".."43",
        "BuiltInSubgroupEqMask".."4416",
        "BuiltInSubgroupEqMaskKHR".."4416",
        "BuiltInSubgroupGeMask".."4417",
        "BuiltInSubgroupGeMaskKHR".."4417",
        "BuiltInSubgroupGtMask".."4418",
        "BuiltInSubgroupGtMaskKHR".."4418",
        "BuiltInSubgroupLeMask".."4419",
        "BuiltInSubgroupLeMaskKHR".."4419",
        "BuiltInSubgroupLtMask".."4420",
        "BuiltInSubgroupLtMaskKHR".."4420",
        "BuiltInBaseVertex".."4424",
        "BuiltInBaseInstance".."4425",
        "BuiltInDrawIndex".."4426",
        "BuiltInPrimitiveShadingRateKHR".."4432",
        "BuiltInDeviceIndex".."4438",
        "BuiltInViewIndex".."4440",
        "BuiltInShadingRateKHR".."4444",
        "BuiltInBaryCoordNoPerspAMD".."4992",
        "BuiltInBaryCoordNoPerspCentroidAMD".."4993",
        "BuiltInBaryCoordNoPerspSampleAMD".."4994",
        "BuiltInBaryCoordSmoothAMD".."4995",
        "BuiltInBaryCoordSmoothCentroidAMD".."4996",
        "BuiltInBaryCoordSmoothSampleAMD".."4997",
        "BuiltInBaryCoordPullModelAMD".."4998",
        "BuiltInFragStencilRefEXT".."5014",
        "BuiltInViewportMaskNV".."5253",
        "BuiltInSecondaryPositionNV".."5257",
        "BuiltInSecondaryViewportMaskNV".."5258",
        "BuiltInPositionPerViewNV".."5261",
        "BuiltInViewportMaskPerViewNV".."5262",
        "BuiltInFullyCoveredEXT".."5264",
        "BuiltInTaskCountNV".."5274",
        "BuiltInPrimitiveCountNV".."5275",
        "BuiltInPrimitiveIndicesNV".."5276",
        "BuiltInClipDistancePerViewNV".."5277",
        "BuiltInCullDistancePerViewNV".."5278",
        "BuiltInLayerPerViewNV".."5279",
        "BuiltInMeshViewCountNV".."5280",
        "BuiltInMeshViewIndicesNV".."5281",
        "BuiltInBaryCoordKHR".."5286",
        "BuiltInBaryCoordNV".."5286",
        "BuiltInBaryCoordNoPerspKHR".."5287",
        "BuiltInBaryCoordNoPerspNV".."5287",
        "BuiltInFragSizeEXT".."5292",
        "BuiltInFragmentSizeNV".."5292",
        "BuiltInFragInvocationCountEXT".."5293",
        "BuiltInInvocationsPerPixelNV".."5293",
        "BuiltInPrimitivePointIndicesEXT".."5294",
        "BuiltInPrimitiveLineIndicesEXT".."5295",
        "BuiltInPrimitiveTriangleIndicesEXT".."5296",
        "BuiltInCullPrimitiveEXT".."5299",
        "BuiltInLaunchIdKHR".."5319",
        "BuiltInLaunchIdNV".."5319",
        "BuiltInLaunchSizeKHR".."5320",
        "BuiltInLaunchSizeNV".."5320",
        "BuiltInWorldRayOriginKHR".."5321",
        "BuiltInWorldRayOriginNV".."5321",
        "BuiltInWorldRayDirectionKHR".."5322",
        "BuiltInWorldRayDirectionNV".."5322",
        "BuiltInObjectRayOriginKHR".."5323",
        "BuiltInObjectRayOriginNV".."5323",
        "BuiltInObjectRayDirectionKHR".."5324",
        "BuiltInObjectRayDirectionNV".."5324",
        "BuiltInRayTminKHR".."5325",
        "BuiltInRayTminNV".."5325",
        "BuiltInRayTmaxKHR".."5326",
        "BuiltInRayTmaxNV".."5326",
        "BuiltInInstanceCustomIndexKHR".."5327",
        "BuiltInInstanceCustomIndexNV".."5327",
        "BuiltInObjectToWorldKHR".."5330",
        "BuiltInObjectToWorldNV".."5330",
        "BuiltInWorldToObjectKHR".."5331",
        "BuiltInWorldToObjectNV".."5331",
        "BuiltInHitTNV".."5332",
        "BuiltInHitKindKHR".."5333",
        "BuiltInHitKindNV".."5333",
        "BuiltInCurrentRayTimeNV".."5334",
        "BuiltInIncomingRayFlagsKHR".."5351",
        "BuiltInIncomingRayFlagsNV".."5351",
        "BuiltInRayGeometryIndexKHR".."5352",
        "BuiltInWarpsPerSMNV".."5374",
        "BuiltInSMCountNV".."5375",
        "BuiltInWarpIDNV".."5376",
        "BuiltInSMIDNV".."5377",
        "BuiltInCullMaskKHR".."6021",
        "BuiltInMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvSelectionControlShift}",

        "SelectionControlFlattenShift".."0",
        "SelectionControlDontFlattenShift".."1",
        "SelectionControlMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvSelectionControlMask}",

        "SelectionControlMaskNone".."0",
        "SelectionControlFlattenMask".."0x00000001",
        "SelectionControlDontFlattenMask".."0x00000002"
    )

    EnumConstant(
        "{@code SpvLoopControlShift}",

        "LoopControlUnrollShift".."0",
        "LoopControlDontUnrollShift".."1",
        "LoopControlDependencyInfiniteShift".."2",
        "LoopControlDependencyLengthShift".."3",
        "LoopControlMinIterationsShift".."4",
        "LoopControlMaxIterationsShift".."5",
        "LoopControlIterationMultipleShift".."6",
        "LoopControlPeelCountShift".."7",
        "LoopControlPartialCountShift".."8",
        "LoopControlInitiationIntervalINTELShift".."16",
        "LoopControlMaxConcurrencyINTELShift".."17",
        "LoopControlDependencyArrayINTELShift".."18",
        "LoopControlPipelineEnableINTELShift".."19",
        "LoopControlLoopCoalesceINTELShift".."20",
        "LoopControlMaxInterleavingINTELShift".."21",
        "LoopControlSpeculatedIterationsINTELShift".."22",
        "LoopControlNoFusionINTELShift".."23",
        "LoopControlMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvLoopControlMask}",

        "LoopControlMaskNone".."0",
        "LoopControlUnrollMask".."0x00000001",
        "LoopControlDontUnrollMask".."0x00000002",
        "LoopControlDependencyInfiniteMask".."0x00000004",
        "LoopControlDependencyLengthMask".."0x00000008",
        "LoopControlMinIterationsMask".."0x00000010",
        "LoopControlMaxIterationsMask".."0x00000020",
        "LoopControlIterationMultipleMask".."0x00000040",
        "LoopControlPeelCountMask".."0x00000080",
        "LoopControlPartialCountMask".."0x00000100",
        "LoopControlInitiationIntervalINTELMask".."0x00010000",
        "LoopControlMaxConcurrencyINTELMask".."0x00020000",
        "LoopControlDependencyArrayINTELMask".."0x00040000",
        "LoopControlPipelineEnableINTELMask".."0x00080000",
        "LoopControlLoopCoalesceINTELMask".."0x00100000",
        "LoopControlMaxInterleavingINTELMask".."0x00200000",
        "LoopControlSpeculatedIterationsINTELMask".."0x00400000",
        "LoopControlNoFusionINTELMask".."0x00800000"
    )

    EnumConstant(
        "{@code SpvFunctionControlShift}",

        "FunctionControlInlineShift".."0",
        "FunctionControlDontInlineShift".."1",
        "FunctionControlPureShift".."2",
        "FunctionControlConstShift".."3",
        "FunctionControlOptNoneINTELShift".."16",
        "FunctionControlMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvFunctionControlMask}",

        "FunctionControlMaskNone".."0",
        "FunctionControlInlineMask".."0x00000001",
        "FunctionControlDontInlineMask".."0x00000002",
        "FunctionControlPureMask".."0x00000004",
        "FunctionControlConstMask".."0x00000008",
        "FunctionControlOptNoneINTELMask".."0x00010000"
    )

    EnumConstant(
        "{@code SpvMemorySemanticsShift}",

        "MemorySemanticsAcquireShift".."1",
        "MemorySemanticsReleaseShift".."2",
        "MemorySemanticsAcquireReleaseShift".."3",
        "MemorySemanticsSequentiallyConsistentShift".."4",
        "MemorySemanticsUniformMemoryShift".."6",
        "MemorySemanticsSubgroupMemoryShift".."7",
        "MemorySemanticsWorkgroupMemoryShift".."8",
        "MemorySemanticsCrossWorkgroupMemoryShift".."9",
        "MemorySemanticsAtomicCounterMemoryShift".."10",
        "MemorySemanticsImageMemoryShift".."11",
        "MemorySemanticsOutputMemoryShift".."12",
        "MemorySemanticsOutputMemoryKHRShift".."12",
        "MemorySemanticsMakeAvailableShift".."13",
        "MemorySemanticsMakeAvailableKHRShift".."13",
        "MemorySemanticsMakeVisibleShift".."14",
        "MemorySemanticsMakeVisibleKHRShift".."14",
        "MemorySemanticsVolatileShift".."15",
        "MemorySemanticsMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvMemorySemanticsMask}",

        "MemorySemanticsMaskNone".."0",
        "MemorySemanticsAcquireMask".."0x00000002",
        "MemorySemanticsReleaseMask".."0x00000004",
        "MemorySemanticsAcquireReleaseMask".."0x00000008",
        "MemorySemanticsSequentiallyConsistentMask".."0x00000010",
        "MemorySemanticsUniformMemoryMask".."0x00000040",
        "MemorySemanticsSubgroupMemoryMask".."0x00000080",
        "MemorySemanticsWorkgroupMemoryMask".."0x00000100",
        "MemorySemanticsCrossWorkgroupMemoryMask".."0x00000200",
        "MemorySemanticsAtomicCounterMemoryMask".."0x00000400",
        "MemorySemanticsImageMemoryMask".."0x00000800",
        "MemorySemanticsOutputMemoryMask".."0x00001000",
        "MemorySemanticsOutputMemoryKHRMask".."0x00001000",
        "MemorySemanticsMakeAvailableMask".."0x00002000",
        "MemorySemanticsMakeAvailableKHRMask".."0x00002000",
        "MemorySemanticsMakeVisibleMask".."0x00004000",
        "MemorySemanticsMakeVisibleKHRMask".."0x00004000",
        "MemorySemanticsVolatileMask".."0x00008000"
    )

    EnumConstant(
        "{@code SpvMemoryAccessShift}",

        "MemoryAccessVolatileShift".."0",
        "MemoryAccessAlignedShift".."1",
        "MemoryAccessNontemporalShift".."2",
        "MemoryAccessMakePointerAvailableShift".."3",
        "MemoryAccessMakePointerAvailableKHRShift".."3",
        "MemoryAccessMakePointerVisibleShift".."4",
        "MemoryAccessMakePointerVisibleKHRShift".."4",
        "MemoryAccessNonPrivatePointerShift".."5",
        "MemoryAccessNonPrivatePointerKHRShift".."5",
        "MemoryAccessAliasScopeINTELMaskShift".."16",
        "MemoryAccessNoAliasINTELMaskShift".."17",
        "MemoryAccessMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvMemoryAccessMask}",

        "MemoryAccessMaskNone".."0",
        "MemoryAccessVolatileMask".."0x00000001",
        "MemoryAccessAlignedMask".."0x00000002",
        "MemoryAccessNontemporalMask".."0x00000004",
        "MemoryAccessMakePointerAvailableMask".."0x00000008",
        "MemoryAccessMakePointerAvailableKHRMask".."0x00000008",
        "MemoryAccessMakePointerVisibleMask".."0x00000010",
        "MemoryAccessMakePointerVisibleKHRMask".."0x00000010",
        "MemoryAccessNonPrivatePointerMask".."0x00000020",
        "MemoryAccessNonPrivatePointerKHRMask".."0x00000020",
        "MemoryAccessAliasScopeINTELMaskMask".."0x00010000",
        "MemoryAccessNoAliasINTELMaskMask".."0x00020000"
    )

    EnumConstant(
        "{@code SpvScope}",

        "ScopeCrossDevice".."0",
        "ScopeDevice".."1",
        "ScopeWorkgroup".."2",
        "ScopeSubgroup".."3",
        "ScopeInvocation".."4",
        "ScopeQueueFamily".."5",
        "ScopeQueueFamilyKHR".."5",
        "ScopeShaderCallKHR".."6",
        "ScopeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvGroupOperation}",

        "GroupOperationReduce".."0",
        "GroupOperationInclusiveScan".."1",
        "GroupOperationExclusiveScan".."2",
        "GroupOperationClusteredReduce".."3",
        "GroupOperationPartitionedReduceNV".."6",
        "GroupOperationPartitionedInclusiveScanNV".."7",
        "GroupOperationPartitionedExclusiveScanNV".."8",
        "GroupOperationMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvKernelEnqueueFlags}",

        "KernelEnqueueFlagsNoWait".."0",
        "KernelEnqueueFlagsWaitKernel".."1",
        "KernelEnqueueFlagsWaitWorkGroup".."2",
        "KernelEnqueueFlagsMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvKernelProfilingInfoShift}",

        "KernelProfilingInfoCmdExecTimeShift".."0",
        "KernelProfilingInfoMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvKernelProfilingInfoMask}",

        "KernelProfilingInfoMaskNone".."0",
        "KernelProfilingInfoCmdExecTimeMask".."0x00000001"
    )

    EnumConstant(
        "{@code SpvCapability}",

        "CapabilityMatrix".."0",
        "CapabilityShader".."1",
        "CapabilityGeometry".."2",
        "CapabilityTessellation".."3",
        "CapabilityAddresses".."4",
        "CapabilityLinkage".."5",
        "CapabilityKernel".."6",
        "CapabilityVector16".."7",
        "CapabilityFloat16Buffer".."8",
        "CapabilityFloat16".."9",
        "CapabilityFloat64".."10",
        "CapabilityInt64".."11",
        "CapabilityInt64Atomics".."12",
        "CapabilityImageBasic".."13",
        "CapabilityImageReadWrite".."14",
        "CapabilityImageMipmap".."15",
        "CapabilityPipes".."17",
        "CapabilityGroups".."18",
        "CapabilityDeviceEnqueue".."19",
        "CapabilityLiteralSampler".."20",
        "CapabilityAtomicStorage".."21",
        "CapabilityInt16".."22",
        "CapabilityTessellationPointSize".."23",
        "CapabilityGeometryPointSize".."24",
        "CapabilityImageGatherExtended".."25",
        "CapabilityStorageImageMultisample".."27",
        "CapabilityUniformBufferArrayDynamicIndexing".."28",
        "CapabilitySampledImageArrayDynamicIndexing".."29",
        "CapabilityStorageBufferArrayDynamicIndexing".."30",
        "CapabilityStorageImageArrayDynamicIndexing".."31",
        "CapabilityClipDistance".."32",
        "CapabilityCullDistance".."33",
        "CapabilityImageCubeArray".."34",
        "CapabilitySampleRateShading".."35",
        "CapabilityImageRect".."36",
        "CapabilitySampledRect".."37",
        "CapabilityGenericPointer".."38",
        "CapabilityInt8".."39",
        "CapabilityInputAttachment".."40",
        "CapabilitySparseResidency".."41",
        "CapabilityMinLod".."42",
        "CapabilitySampled1D".."43",
        "CapabilityImage1D".."44",
        "CapabilitySampledCubeArray".."45",
        "CapabilitySampledBuffer".."46",
        "CapabilityImageBuffer".."47",
        "CapabilityImageMSArray".."48",
        "CapabilityStorageImageExtendedFormats".."49",
        "CapabilityImageQuery".."50",
        "CapabilityDerivativeControl".."51",
        "CapabilityInterpolationFunction".."52",
        "CapabilityTransformFeedback".."53",
        "CapabilityGeometryStreams".."54",
        "CapabilityStorageImageReadWithoutFormat".."55",
        "CapabilityStorageImageWriteWithoutFormat".."56",
        "CapabilityMultiViewport".."57",
        "CapabilitySubgroupDispatch".."58",
        "CapabilityNamedBarrier".."59",
        "CapabilityPipeStorage".."60",
        "CapabilityGroupNonUniform".."61",
        "CapabilityGroupNonUniformVote".."62",
        "CapabilityGroupNonUniformArithmetic".."63",
        "CapabilityGroupNonUniformBallot".."64",
        "CapabilityGroupNonUniformShuffle".."65",
        "CapabilityGroupNonUniformShuffleRelative".."66",
        "CapabilityGroupNonUniformClustered".."67",
        "CapabilityGroupNonUniformQuad".."68",
        "CapabilityShaderLayer".."69",
        "CapabilityShaderViewportIndex".."70",
        "CapabilityUniformDecoration".."71",
        "CapabilityFragmentShadingRateKHR".."4422",
        "CapabilitySubgroupBallotKHR".."4423",
        "CapabilityDrawParameters".."4427",
        "CapabilityWorkgroupMemoryExplicitLayoutKHR".."4428",
        "CapabilityWorkgroupMemoryExplicitLayout8BitAccessKHR".."4429",
        "CapabilityWorkgroupMemoryExplicitLayout16BitAccessKHR".."4430",
        "CapabilitySubgroupVoteKHR".."4431",
        "CapabilityStorageBuffer16BitAccess".."4433",
        "CapabilityStorageUniformBufferBlock16".."4433",
        "CapabilityStorageUniform16".."4434",
        "CapabilityUniformAndStorageBuffer16BitAccess".."4434",
        "CapabilityStoragePushConstant16".."4435",
        "CapabilityStorageInputOutput16".."4436",
        "CapabilityDeviceGroup".."4437",
        "CapabilityMultiView".."4439",
        "CapabilityVariablePointersStorageBuffer".."4441",
        "CapabilityVariablePointers".."4442",
        "CapabilityAtomicStorageOps".."4445",
        "CapabilitySampleMaskPostDepthCoverage".."4447",
        "CapabilityStorageBuffer8BitAccess".."4448",
        "CapabilityUniformAndStorageBuffer8BitAccess".."4449",
        "CapabilityStoragePushConstant8".."4450",
        "CapabilityDenormPreserve".."4464",
        "CapabilityDenormFlushToZero".."4465",
        "CapabilitySignedZeroInfNanPreserve".."4466",
        "CapabilityRoundingModeRTE".."4467",
        "CapabilityRoundingModeRTZ".."4468",
        "CapabilityRayQueryProvisionalKHR".."4471",
        "CapabilityRayQueryKHR".."4472",
        "CapabilityRayTraversalPrimitiveCullingKHR".."4478",
        "CapabilityRayTracingKHR".."4479",
        "CapabilityTextureSampleWeightedQCOM".."4484",
        "CapabilityTextureBoxFilterQCOM".."4485",
        "CapabilityTextureBlockMatchQCOM".."4486",
        "CapabilityTextureBlockMatch2QCOM".."4498",
        "CapabilityFloat16ImageAMD".."5008",
        "CapabilityImageGatherBiasLodAMD".."5009",
        "CapabilityFragmentMaskAMD".."5010",
        "CapabilityStencilExportEXT".."5013",
        "CapabilityImageReadWriteLodAMD".."5015",
        "CapabilityInt64ImageEXT".."5016",
        "CapabilityShaderClockKHR".."5055",
        "CapabilitySampleMaskOverrideCoverageNV".."5249",
        "CapabilityGeometryShaderPassthroughNV".."5251",
        "CapabilityShaderViewportIndexLayerEXT".."5254",
        "CapabilityShaderViewportIndexLayerNV".."5254",
        "CapabilityShaderViewportMaskNV".."5255",
        "CapabilityShaderStereoViewNV".."5259",
        "CapabilityPerViewAttributesNV".."5260",
        "CapabilityFragmentFullyCoveredEXT".."5265",
        "CapabilityMeshShadingNV".."5266",
        "CapabilityImageFootprintNV".."5282",
        "CapabilityMeshShadingEXT".."5283",
        "CapabilityFragmentBarycentricKHR".."5284",
        "CapabilityFragmentBarycentricNV".."5284",
        "CapabilityComputeDerivativeGroupQuadsNV".."5288",
        "CapabilityFragmentDensityEXT".."5291",
        "CapabilityShadingRateNV".."5291",
        "CapabilityGroupNonUniformPartitionedNV".."5297",
        "CapabilityShaderNonUniform".."5301",
        "CapabilityShaderNonUniformEXT".."5301",
        "CapabilityRuntimeDescriptorArray".."5302",
        "CapabilityRuntimeDescriptorArrayEXT".."5302",
        "CapabilityInputAttachmentArrayDynamicIndexing".."5303",
        "CapabilityInputAttachmentArrayDynamicIndexingEXT".."5303",
        "CapabilityUniformTexelBufferArrayDynamicIndexing".."5304",
        "CapabilityUniformTexelBufferArrayDynamicIndexingEXT".."5304",
        "CapabilityStorageTexelBufferArrayDynamicIndexing".."5305",
        "CapabilityStorageTexelBufferArrayDynamicIndexingEXT".."5305",
        "CapabilityUniformBufferArrayNonUniformIndexing".."5306",
        "CapabilityUniformBufferArrayNonUniformIndexingEXT".."5306",
        "CapabilitySampledImageArrayNonUniformIndexing".."5307",
        "CapabilitySampledImageArrayNonUniformIndexingEXT".."5307",
        "CapabilityStorageBufferArrayNonUniformIndexing".."5308",
        "CapabilityStorageBufferArrayNonUniformIndexingEXT".."5308",
        "CapabilityStorageImageArrayNonUniformIndexing".."5309",
        "CapabilityStorageImageArrayNonUniformIndexingEXT".."5309",
        "CapabilityInputAttachmentArrayNonUniformIndexing".."5310",
        "CapabilityInputAttachmentArrayNonUniformIndexingEXT".."5310",
        "CapabilityUniformTexelBufferArrayNonUniformIndexing".."5311",
        "CapabilityUniformTexelBufferArrayNonUniformIndexingEXT".."5311",
        "CapabilityStorageTexelBufferArrayNonUniformIndexing".."5312",
        "CapabilityStorageTexelBufferArrayNonUniformIndexingEXT".."5312",
        "CapabilityRayTracingNV".."5340",
        "CapabilityRayTracingMotionBlurNV".."5341",
        "CapabilityVulkanMemoryModel".."5345",
        "CapabilityVulkanMemoryModelKHR".."5345",
        "CapabilityVulkanMemoryModelDeviceScope".."5346",
        "CapabilityVulkanMemoryModelDeviceScopeKHR".."5346",
        "CapabilityPhysicalStorageBufferAddresses".."5347",
        "CapabilityPhysicalStorageBufferAddressesEXT".."5347",
        "CapabilityComputeDerivativeGroupLinearNV".."5350",
        "CapabilityRayTracingProvisionalKHR".."5353",
        "CapabilityCooperativeMatrixNV".."5357",
        "CapabilityFragmentShaderSampleInterlockEXT".."5363",
        "CapabilityFragmentShaderShadingRateInterlockEXT".."5372",
        "CapabilityShaderSMBuiltinsNV".."5373",
        "CapabilityFragmentShaderPixelInterlockEXT".."5378",
        "CapabilityDemoteToHelperInvocation".."5379",
        "CapabilityDemoteToHelperInvocationEXT".."5379",
        "CapabilityBindlessTextureNV".."5390",
        "CapabilitySubgroupShuffleINTEL".."5568",
        "CapabilitySubgroupBufferBlockIOINTEL".."5569",
        "CapabilitySubgroupImageBlockIOINTEL".."5570",
        "CapabilitySubgroupImageMediaBlockIOINTEL".."5579",
        "CapabilityRoundToInfinityINTEL".."5582",
        "CapabilityFloatingPointModeINTEL".."5583",
        "CapabilityIntegerFunctions2INTEL".."5584",
        "CapabilityFunctionPointersINTEL".."5603",
        "CapabilityIndirectReferencesINTEL".."5604",
        "CapabilityAsmINTEL".."5606",
        "CapabilityAtomicFloat32MinMaxEXT".."5612",
        "CapabilityAtomicFloat64MinMaxEXT".."5613",
        "CapabilityAtomicFloat16MinMaxEXT".."5616",
        "CapabilityVectorComputeINTEL".."5617",
        "CapabilityVectorAnyINTEL".."5619",
        "CapabilityExpectAssumeKHR".."5629",
        "CapabilitySubgroupAvcMotionEstimationINTEL".."5696",
        "CapabilitySubgroupAvcMotionEstimationIntraINTEL".."5697",
        "CapabilitySubgroupAvcMotionEstimationChromaINTEL".."5698",
        "CapabilityVariableLengthArrayINTEL".."5817",
        "CapabilityFunctionFloatControlINTEL".."5821",
        "CapabilityFPGAMemoryAttributesINTEL".."5824",
        "CapabilityFPFastMathModeINTEL".."5837",
        "CapabilityArbitraryPrecisionIntegersINTEL".."5844",
        "CapabilityArbitraryPrecisionFloatingPointINTEL".."5845",
        "CapabilityUnstructuredLoopControlsINTEL".."5886",
        "CapabilityFPGALoopControlsINTEL".."5888",
        "CapabilityKernelAttributesINTEL".."5892",
        "CapabilityFPGAKernelAttributesINTEL".."5897",
        "CapabilityFPGAMemoryAccessesINTEL".."5898",
        "CapabilityFPGAClusterAttributesINTEL".."5904",
        "CapabilityLoopFuseINTEL".."5906",
        "CapabilityMemoryAccessAliasingINTEL".."5910",
        "CapabilityFPGABufferLocationINTEL".."5920",
        "CapabilityArbitraryPrecisionFixedPointINTEL".."5922",
        "CapabilityUSMStorageClassesINTEL".."5935",
        "CapabilityIOPipesINTEL".."5943",
        "CapabilityBlockingPipesINTEL".."5945",
        "CapabilityFPGARegINTEL".."5948",
        "CapabilityDotProductInputAll".."6016",
        "CapabilityDotProductInputAllKHR".."6016",
        "CapabilityDotProductInput4x8Bit".."6017",
        "CapabilityDotProductInput4x8BitKHR".."6017",
        "CapabilityDotProductInput4x8BitPacked".."6018",
        "CapabilityDotProductInput4x8BitPackedKHR".."6018",
        "CapabilityDotProduct".."6019",
        "CapabilityDotProductKHR".."6019",
        "CapabilityRayCullMaskKHR".."6020",
        "CapabilityBitInstructions".."6025",
        "CapabilityGroupNonUniformRotateKHR".."6026",
        "CapabilityAtomicFloat32AddEXT".."6033",
        "CapabilityAtomicFloat64AddEXT".."6034",
        "CapabilityLongConstantCompositeINTEL".."6089",
        "CapabilityOptNoneINTEL".."6094",
        "CapabilityAtomicFloat16AddEXT".."6095",
        "CapabilityDebugInfoModuleINTEL".."6114",
        "CapabilitySplitBarrierINTEL".."6141",
        "CapabilityGroupUniformArithmeticKHR".."6400",
        "CapabilityMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvRayFlagsShift}",

        "RayFlagsOpaqueKHRShift".."0",
        "RayFlagsNoOpaqueKHRShift".."1",
        "RayFlagsTerminateOnFirstHitKHRShift".."2",
        "RayFlagsSkipClosestHitShaderKHRShift".."3",
        "RayFlagsCullBackFacingTrianglesKHRShift".."4",
        "RayFlagsCullFrontFacingTrianglesKHRShift".."5",
        "RayFlagsCullOpaqueKHRShift".."6",
        "RayFlagsCullNoOpaqueKHRShift".."7",
        "RayFlagsSkipTrianglesKHRShift".."8",
        "RayFlagsSkipAABBsKHRShift".."9",
        "RayFlagsMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvRayFlagsMask}",

        "RayFlagsMaskNone".."0",
        "RayFlagsOpaqueKHRMask".."0x00000001",
        "RayFlagsNoOpaqueKHRMask".."0x00000002",
        "RayFlagsTerminateOnFirstHitKHRMask".."0x00000004",
        "RayFlagsSkipClosestHitShaderKHRMask".."0x00000008",
        "RayFlagsCullBackFacingTrianglesKHRMask".."0x00000010",
        "RayFlagsCullFrontFacingTrianglesKHRMask".."0x00000020",
        "RayFlagsCullOpaqueKHRMask".."0x00000040",
        "RayFlagsCullNoOpaqueKHRMask".."0x00000080",
        "RayFlagsSkipTrianglesKHRMask".."0x00000100",
        "RayFlagsSkipAABBsKHRMask".."0x00000200"
    )

    EnumConstant(
        "{@code SpvRayQueryIntersection}",

        "RayQueryIntersectionRayQueryCandidateIntersectionKHR".."0",
        "RayQueryIntersectionRayQueryCommittedIntersectionKHR".."1",
        "RayQueryIntersectionMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvRayQueryCommittedIntersectionType}",

        "RayQueryCommittedIntersectionTypeRayQueryCommittedIntersectionNoneKHR".."0",
        "RayQueryCommittedIntersectionTypeRayQueryCommittedIntersectionTriangleKHR".."1",
        "RayQueryCommittedIntersectionTypeRayQueryCommittedIntersectionGeneratedKHR".."2",
        "RayQueryCommittedIntersectionTypeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvRayQueryCandidateIntersectionType}",

        "RayQueryCandidateIntersectionTypeRayQueryCandidateIntersectionTriangleKHR".."0",
        "RayQueryCandidateIntersectionTypeRayQueryCandidateIntersectionAABBKHR".."1",
        "RayQueryCandidateIntersectionTypeMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvFragmentShadingRateShift}",

        "FragmentShadingRateVertical2PixelsShift".."0",
        "FragmentShadingRateVertical4PixelsShift".."1",
        "FragmentShadingRateHorizontal2PixelsShift".."2",
        "FragmentShadingRateHorizontal4PixelsShift".."3",
        "FragmentShadingRateMax".."0x7fffffff",
    )

    EnumConstant(
        "{@code SpvFragmentShadingRateMask}",

        "FragmentShadingRateMaskNone".."0",
        "FragmentShadingRateVertical2PixelsMask".."0x00000001",
        "FragmentShadingRateVertical4PixelsMask".."0x00000002",
        "FragmentShadingRateHorizontal2PixelsMask".."0x00000004",
        "FragmentShadingRateHorizontal4PixelsMask".."0x00000008"
    )

    EnumConstant(
        "{@code SpvFPDenormMode}",

        "FPDenormModePreserve".."0",
        "FPDenormModeFlushToZero".."1",
        "FPDenormModeMax".."0x7fffffff"
    )

    EnumConstant(
        "{@code SpvFPOperationMode}",

        "FPOperationModeIEEE".."0",
        "FPOperationModeALT".."1",
        "FPOperationModeMax".."0x7fffffff"
    )

    EnumConstant(
        "{@code SpvQuantizationModes}",

        "QuantizationModesTRN".."0",
        "QuantizationModesTRN_ZERO".."1",
        "QuantizationModesRND".."2",
        "QuantizationModesRND_ZERO".."3",
        "QuantizationModesRND_INF".."4",
        "QuantizationModesRND_MIN_INF".."5",
        "QuantizationModesRND_CONV".."6",
        "QuantizationModesRND_CONV_ODD".."7",
        "QuantizationModesMax".."0x7fffffff"
    )

    EnumConstant(
        "{@code SpvOverflowModes}",

        "OverflowModesWRAP".."0",
        "OverflowModesSAT".."1",
        "OverflowModesSAT_ZERO".."2",
        "OverflowModesSAT_SYM".."3",
        "OverflowModesMax".."0x7fffffff"
    )

    EnumConstant(
        "{@code SpvPackedVectorFormat}",

        "PackedVectorFormatPackedVectorFormat4x8Bit".."0",
        "PackedVectorFormatPackedVectorFormat4x8BitKHR".."0",
        "PackedVectorFormatMax".."0x7fffffff"
    )

    EnumConstant(
        "{@code SpvOp}",

        "OpNop".."0",
        "OpUndef".."1",
        "OpSourceContinued".."2",
        "OpSource".."3",
        "OpSourceExtension".."4",
        "OpName".."5",
        "OpMemberName".."6",
        "OpString".."7",
        "OpLine".."8",
        "OpExtension".."10",
        "OpExtInstImport".."11",
        "OpExtInst".."12",
        "OpMemoryModel".."14",
        "OpEntryPoint".."15",
        "OpExecutionMode".."16",
        "OpCapability".."17",
        "OpTypeVoid".."19",
        "OpTypeBool".."20",
        "OpTypeInt".."21",
        "OpTypeFloat".."22",
        "OpTypeVector".."23",
        "OpTypeMatrix".."24",
        "OpTypeImage".."25",
        "OpTypeSampler".."26",
        "OpTypeSampledImage".."27",
        "OpTypeArray".."28",
        "OpTypeRuntimeArray".."29",
        "OpTypeStruct".."30",
        "OpTypeOpaque".."31",
        "OpTypePointer".."32",
        "OpTypeFunction".."33",
        "OpTypeEvent".."34",
        "OpTypeDeviceEvent".."35",
        "OpTypeReserveId".."36",
        "OpTypeQueue".."37",
        "OpTypePipe".."38",
        "OpTypeForwardPointer".."39",
        "OpConstantTrue".."41",
        "OpConstantFalse".."42",
        "OpConstant".."43",
        "OpConstantComposite".."44",
        "OpConstantSampler".."45",
        "OpConstantNull".."46",
        "OpSpecConstantTrue".."48",
        "OpSpecConstantFalse".."49",
        "OpSpecConstant".."50",
        "OpSpecConstantComposite".."51",
        "OpSpecConstantOp".."52",
        "OpFunction".."54",
        "OpFunctionParameter".."55",
        "OpFunctionEnd".."56",
        "OpFunctionCall".."57",
        "OpVariable".."59",
        "OpImageTexelPointer".."60",
        "OpLoad".."61",
        "OpStore".."62",
        "OpCopyMemory".."63",
        "OpCopyMemorySized".."64",
        "OpAccessChain".."65",
        "OpInBoundsAccessChain".."66",
        "OpPtrAccessChain".."67",
        "OpArrayLength".."68",
        "OpGenericPtrMemSemantics".."69",
        "OpInBoundsPtrAccessChain".."70",
        "OpDecorate".."71",
        "OpMemberDecorate".."72",
        "OpDecorationGroup".."73",
        "OpGroupDecorate".."74",
        "OpGroupMemberDecorate".."75",
        "OpVectorExtractDynamic".."77",
        "OpVectorInsertDynamic".."78",
        "OpVectorShuffle".."79",
        "OpCompositeConstruct".."80",
        "OpCompositeExtract".."81",
        "OpCompositeInsert".."82",
        "OpCopyObject".."83",
        "OpTranspose".."84",
        "OpSampledImage".."86",
        "OpImageSampleImplicitLod".."87",
        "OpImageSampleExplicitLod".."88",
        "OpImageSampleDrefImplicitLod".."89",
        "OpImageSampleDrefExplicitLod".."90",
        "OpImageSampleProjImplicitLod".."91",
        "OpImageSampleProjExplicitLod".."92",
        "OpImageSampleProjDrefImplicitLod".."93",
        "OpImageSampleProjDrefExplicitLod".."94",
        "OpImageFetch".."95",
        "OpImageGather".."96",
        "OpImageDrefGather".."97",
        "OpImageRead".."98",
        "OpImageWrite".."99",
        "OpImage".."100",
        "OpImageQueryFormat".."101",
        "OpImageQueryOrder".."102",
        "OpImageQuerySizeLod".."103",
        "OpImageQuerySize".."104",
        "OpImageQueryLod".."105",
        "OpImageQueryLevels".."106",
        "OpImageQuerySamples".."107",
        "OpConvertFToU".."109",
        "OpConvertFToS".."110",
        "OpConvertSToF".."111",
        "OpConvertUToF".."112",
        "OpUConvert".."113",
        "OpSConvert".."114",
        "OpFConvert".."115",
        "OpQuantizeToF16".."116",
        "OpConvertPtrToU".."117",
        "OpSatConvertSToU".."118",
        "OpSatConvertUToS".."119",
        "OpConvertUToPtr".."120",
        "OpPtrCastToGeneric".."121",
        "OpGenericCastToPtr".."122",
        "OpGenericCastToPtrExplicit".."123",
        "OpBitcast".."124",
        "OpSNegate".."126",
        "OpFNegate".."127",
        "OpIAdd".."128",
        "OpFAdd".."129",
        "OpISub".."130",
        "OpFSub".."131",
        "OpIMul".."132",
        "OpFMul".."133",
        "OpUDiv".."134",
        "OpSDiv".."135",
        "OpFDiv".."136",
        "OpUMod".."137",
        "OpSRem".."138",
        "OpSMod".."139",
        "OpFRem".."140",
        "OpFMod".."141",
        "OpVectorTimesScalar".."142",
        "OpMatrixTimesScalar".."143",
        "OpVectorTimesMatrix".."144",
        "OpMatrixTimesVector".."145",
        "OpMatrixTimesMatrix".."146",
        "OpOuterProduct".."147",
        "OpDot".."148",
        "OpIAddCarry".."149",
        "OpISubBorrow".."150",
        "OpUMulExtended".."151",
        "OpSMulExtended".."152",
        "OpAny".."154",
        "OpAll".."155",
        "OpIsNan".."156",
        "OpIsInf".."157",
        "OpIsFinite".."158",
        "OpIsNormal".."159",
        "OpSignBitSet".."160",
        "OpLessOrGreater".."161",
        "OpOrdered".."162",
        "OpUnordered".."163",
        "OpLogicalEqual".."164",
        "OpLogicalNotEqual".."165",
        "OpLogicalOr".."166",
        "OpLogicalAnd".."167",
        "OpLogicalNot".."168",
        "OpSelect".."169",
        "OpIEqual".."170",
        "OpINotEqual".."171",
        "OpUGreaterThan".."172",
        "OpSGreaterThan".."173",
        "OpUGreaterThanEqual".."174",
        "OpSGreaterThanEqual".."175",
        "OpULessThan".."176",
        "OpSLessThan".."177",
        "OpULessThanEqual".."178",
        "OpSLessThanEqual".."179",
        "OpFOrdEqual".."180",
        "OpFUnordEqual".."181",
        "OpFOrdNotEqual".."182",
        "OpFUnordNotEqual".."183",
        "OpFOrdLessThan".."184",
        "OpFUnordLessThan".."185",
        "OpFOrdGreaterThan".."186",
        "OpFUnordGreaterThan".."187",
        "OpFOrdLessThanEqual".."188",
        "OpFUnordLessThanEqual".."189",
        "OpFOrdGreaterThanEqual".."190",
        "OpFUnordGreaterThanEqual".."191",
        "OpShiftRightLogical".."194",
        "OpShiftRightArithmetic".."195",
        "OpShiftLeftLogical".."196",
        "OpBitwiseOr".."197",
        "OpBitwiseXor".."198",
        "OpBitwiseAnd".."199",
        "OpNot".."200",
        "OpBitFieldInsert".."201",
        "OpBitFieldSExtract".."202",
        "OpBitFieldUExtract".."203",
        "OpBitReverse".."204",
        "OpBitCount".."205",
        "OpDPdx".."207",
        "OpDPdy".."208",
        "OpFwidth".."209",
        "OpDPdxFine".."210",
        "OpDPdyFine".."211",
        "OpFwidthFine".."212",
        "OpDPdxCoarse".."213",
        "OpDPdyCoarse".."214",
        "OpFwidthCoarse".."215",
        "OpEmitVertex".."218",
        "OpEndPrimitive".."219",
        "OpEmitStreamVertex".."220",
        "OpEndStreamPrimitive".."221",
        "OpControlBarrier".."224",
        "OpMemoryBarrier".."225",
        "OpAtomicLoad".."227",
        "OpAtomicStore".."228",
        "OpAtomicExchange".."229",
        "OpAtomicCompareExchange".."230",
        "OpAtomicCompareExchangeWeak".."231",
        "OpAtomicIIncrement".."232",
        "OpAtomicIDecrement".."233",
        "OpAtomicIAdd".."234",
        "OpAtomicISub".."235",
        "OpAtomicSMin".."236",
        "OpAtomicUMin".."237",
        "OpAtomicSMax".."238",
        "OpAtomicUMax".."239",
        "OpAtomicAnd".."240",
        "OpAtomicOr".."241",
        "OpAtomicXor".."242",
        "OpPhi".."245",
        "OpLoopMerge".."246",
        "OpSelectionMerge".."247",
        "OpLabel".."248",
        "OpBranch".."249",
        "OpBranchConditional".."250",
        "OpSwitch".."251",
        "OpKill".."252",
        "OpReturn".."253",
        "OpReturnValue".."254",
        "OpUnreachable".."255",
        "OpLifetimeStart".."256",
        "OpLifetimeStop".."257",
        "OpGroupAsyncCopy".."259",
        "OpGroupWaitEvents".."260",
        "OpGroupAll".."261",
        "OpGroupAny".."262",
        "OpGroupBroadcast".."263",
        "OpGroupIAdd".."264",
        "OpGroupFAdd".."265",
        "OpGroupFMin".."266",
        "OpGroupUMin".."267",
        "OpGroupSMin".."268",
        "OpGroupFMax".."269",
        "OpGroupUMax".."270",
        "OpGroupSMax".."271",
        "OpReadPipe".."274",
        "OpWritePipe".."275",
        "OpReservedReadPipe".."276",
        "OpReservedWritePipe".."277",
        "OpReserveReadPipePackets".."278",
        "OpReserveWritePipePackets".."279",
        "OpCommitReadPipe".."280",
        "OpCommitWritePipe".."281",
        "OpIsValidReserveId".."282",
        "OpGetNumPipePackets".."283",
        "OpGetMaxPipePackets".."284",
        "OpGroupReserveReadPipePackets".."285",
        "OpGroupReserveWritePipePackets".."286",
        "OpGroupCommitReadPipe".."287",
        "OpGroupCommitWritePipe".."288",
        "OpEnqueueMarker".."291",
        "OpEnqueueKernel".."292",
        "OpGetKernelNDrangeSubGroupCount".."293",
        "OpGetKernelNDrangeMaxSubGroupSize".."294",
        "OpGetKernelWorkGroupSize".."295",
        "OpGetKernelPreferredWorkGroupSizeMultiple".."296",
        "OpRetainEvent".."297",
        "OpReleaseEvent".."298",
        "OpCreateUserEvent".."299",
        "OpIsValidEvent".."300",
        "OpSetUserEventStatus".."301",
        "OpCaptureEventProfilingInfo".."302",
        "OpGetDefaultQueue".."303",
        "OpBuildNDRange".."304",
        "OpImageSparseSampleImplicitLod".."305",
        "OpImageSparseSampleExplicitLod".."306",
        "OpImageSparseSampleDrefImplicitLod".."307",
        "OpImageSparseSampleDrefExplicitLod".."308",
        "OpImageSparseSampleProjImplicitLod".."309",
        "OpImageSparseSampleProjExplicitLod".."310",
        "OpImageSparseSampleProjDrefImplicitLod".."311",
        "OpImageSparseSampleProjDrefExplicitLod".."312",
        "OpImageSparseFetch".."313",
        "OpImageSparseGather".."314",
        "OpImageSparseDrefGather".."315",
        "OpImageSparseTexelsResident".."316",
        "OpNoLine".."317",
        "OpAtomicFlagTestAndSet".."318",
        "OpAtomicFlagClear".."319",
        "OpImageSparseRead".."320",
        "OpSizeOf".."321",
        "OpTypePipeStorage".."322",
        "OpConstantPipeStorage".."323",
        "OpCreatePipeFromPipeStorage".."324",
        "OpGetKernelLocalSizeForSubgroupCount".."325",
        "OpGetKernelMaxNumSubgroups".."326",
        "OpTypeNamedBarrier".."327",
        "OpNamedBarrierInitialize".."328",
        "OpMemoryNamedBarrier".."329",
        "OpModuleProcessed".."330",
        "OpExecutionModeId".."331",
        "OpDecorateId".."332",
        "OpGroupNonUniformElect".."333",
        "OpGroupNonUniformAll".."334",
        "OpGroupNonUniformAny".."335",
        "OpGroupNonUniformAllEqual".."336",
        "OpGroupNonUniformBroadcast".."337",
        "OpGroupNonUniformBroadcastFirst".."338",
        "OpGroupNonUniformBallot".."339",
        "OpGroupNonUniformInverseBallot".."340",
        "OpGroupNonUniformBallotBitExtract".."341",
        "OpGroupNonUniformBallotBitCount".."342",
        "OpGroupNonUniformBallotFindLSB".."343",
        "OpGroupNonUniformBallotFindMSB".."344",
        "OpGroupNonUniformShuffle".."345",
        "OpGroupNonUniformShuffleXor".."346",
        "OpGroupNonUniformShuffleUp".."347",
        "OpGroupNonUniformShuffleDown".."348",
        "OpGroupNonUniformIAdd".."349",
        "OpGroupNonUniformFAdd".."350",
        "OpGroupNonUniformIMul".."351",
        "OpGroupNonUniformFMul".."352",
        "OpGroupNonUniformSMin".."353",
        "OpGroupNonUniformUMin".."354",
        "OpGroupNonUniformFMin".."355",
        "OpGroupNonUniformSMax".."356",
        "OpGroupNonUniformUMax".."357",
        "OpGroupNonUniformFMax".."358",
        "OpGroupNonUniformBitwiseAnd".."359",
        "OpGroupNonUniformBitwiseOr".."360",
        "OpGroupNonUniformBitwiseXor".."361",
        "OpGroupNonUniformLogicalAnd".."362",
        "OpGroupNonUniformLogicalOr".."363",
        "OpGroupNonUniformLogicalXor".."364",
        "OpGroupNonUniformQuadBroadcast".."365",
        "OpGroupNonUniformQuadSwap".."366",
        "OpCopyLogical".."400",
        "OpPtrEqual".."401",
        "OpPtrNotEqual".."402",
        "OpPtrDiff".."403",
        "OpTerminateInvocation".."4416",
        "OpSubgroupBallotKHR".."4421",
        "OpSubgroupFirstInvocationKHR".."4422",
        "OpSubgroupAllKHR".."4428",
        "OpSubgroupAnyKHR".."4429",
        "OpSubgroupAllEqualKHR".."4430",
        "OpGroupNonUniformRotateKHR".."4431",
        "OpSubgroupReadInvocationKHR".."4432",
        "OpTraceRayKHR".."4445",
        "OpExecuteCallableKHR".."4446",
        "OpConvertUToAccelerationStructureKHR".."4447",
        "OpIgnoreIntersectionKHR".."4448",
        "OpTerminateRayKHR".."4449",
        "OpSDot".."4450",
        "OpSDotKHR".."4450",
        "OpUDot".."4451",
        "OpUDotKHR".."4451",
        "OpSUDot".."4452",
        "OpSUDotKHR".."4452",
        "OpSDotAccSat".."4453",
        "OpSDotAccSatKHR".."4453",
        "OpUDotAccSat".."4454",
        "OpUDotAccSatKHR".."4454",
        "OpSUDotAccSat".."4455",
        "OpSUDotAccSatKHR".."4455",
        "OpTypeRayQueryKHR".."4472",
        "OpRayQueryInitializeKHR".."4473",
        "OpRayQueryTerminateKHR".."4474",
        "OpRayQueryGenerateIntersectionKHR".."4475",
        "OpRayQueryConfirmIntersectionKHR".."4476",
        "OpRayQueryProceedKHR".."4477",
        "OpRayQueryGetIntersectionTypeKHR".."4479",
        "OpImageSampleWeightedQCOM".."4480",
        "OpImageBoxFilterQCOM".."4481",
        "OpImageBlockMatchSSDQCOM".."4482",
        "OpImageBlockMatchSADQCOM".."4483",
        "OpImageBlockMatchWindowSSDQCOM".."4500",
        "OpImageBlockMatchWindowSADQCOM".."4501",
        "OpImageBlockMatchGatherSSDQCOM".."4502",
        "OpImageBlockMatchGatherSADQCOM".."4503",
        "OpGroupIAddNonUniformAMD".."5000",
        "OpGroupFAddNonUniformAMD".."5001",
        "OpGroupFMinNonUniformAMD".."5002",
        "OpGroupUMinNonUniformAMD".."5003",
        "OpGroupSMinNonUniformAMD".."5004",
        "OpGroupFMaxNonUniformAMD".."5005",
        "OpGroupUMaxNonUniformAMD".."5006",
        "OpGroupSMaxNonUniformAMD".."5007",
        "OpFragmentMaskFetchAMD".."5011",
        "OpFragmentFetchAMD".."5012",
        "OpReadClockKHR".."5056",
        "OpImageSampleFootprintNV".."5283",
        "OpEmitMeshTasksEXT".."5294",
        "OpSetMeshOutputsEXT".."5295",
        "OpGroupNonUniformPartitionNV".."5296",
        "OpWritePackedPrimitiveIndices4x8NV".."5299",
        "OpReportIntersectionKHR".."5334",
        "OpReportIntersectionNV".."5334",
        "OpIgnoreIntersectionNV".."5335",
        "OpTerminateRayNV".."5336",
        "OpTraceNV".."5337",
        "OpTraceMotionNV".."5338",
        "OpTraceRayMotionNV".."5339",
        "OpTypeAccelerationStructureKHR".."5341",
        "OpTypeAccelerationStructureNV".."5341",
        "OpExecuteCallableNV".."5344",
        "OpTypeCooperativeMatrixNV".."5358",
        "OpCooperativeMatrixLoadNV".."5359",
        "OpCooperativeMatrixStoreNV".."5360",
        "OpCooperativeMatrixMulAddNV".."5361",
        "OpCooperativeMatrixLengthNV".."5362",
        "OpBeginInvocationInterlockEXT".."5364",
        "OpEndInvocationInterlockEXT".."5365",
        "OpDemoteToHelperInvocation".."5380",
        "OpDemoteToHelperInvocationEXT".."5380",
        "OpIsHelperInvocationEXT".."5381",
        "OpConvertUToImageNV".."5391",
        "OpConvertUToSamplerNV".."5392",
        "OpConvertImageToUNV".."5393",
        "OpConvertSamplerToUNV".."5394",
        "OpConvertUToSampledImageNV".."5395",
        "OpConvertSampledImageToUNV".."5396",
        "OpSamplerImageAddressingModeNV".."5397",
        "OpSubgroupShuffleINTEL".."5571",
        "OpSubgroupShuffleDownINTEL".."5572",
        "OpSubgroupShuffleUpINTEL".."5573",
        "OpSubgroupShuffleXorINTEL".."5574",
        "OpSubgroupBlockReadINTEL".."5575",
        "OpSubgroupBlockWriteINTEL".."5576",
        "OpSubgroupImageBlockReadINTEL".."5577",
        "OpSubgroupImageBlockWriteINTEL".."5578",
        "OpSubgroupImageMediaBlockReadINTEL".."5580",
        "OpSubgroupImageMediaBlockWriteINTEL".."5581",
        "OpUCountLeadingZerosINTEL".."5585",
        "OpUCountTrailingZerosINTEL".."5586",
        "OpAbsISubINTEL".."5587",
        "OpAbsUSubINTEL".."5588",
        "OpIAddSatINTEL".."5589",
        "OpUAddSatINTEL".."5590",
        "OpIAverageINTEL".."5591",
        "OpUAverageINTEL".."5592",
        "OpIAverageRoundedINTEL".."5593",
        "OpUAverageRoundedINTEL".."5594",
        "OpISubSatINTEL".."5595",
        "OpUSubSatINTEL".."5596",
        "OpIMul32x16INTEL".."5597",
        "OpUMul32x16INTEL".."5598",
        "OpConstantFunctionPointerINTEL".."5600",
        "OpFunctionPointerCallINTEL".."5601",
        "OpAsmTargetINTEL".."5609",
        "OpAsmINTEL".."5610",
        "OpAsmCallINTEL".."5611",
        "OpAtomicFMinEXT".."5614",
        "OpAtomicFMaxEXT".."5615",
        "OpAssumeTrueKHR".."5630",
        "OpExpectKHR".."5631",
        "OpDecorateString".."5632",
        "OpDecorateStringGOOGLE".."5632",
        "OpMemberDecorateString".."5633",
        "OpMemberDecorateStringGOOGLE".."5633",
        "OpVmeImageINTEL".."5699",
        "OpTypeVmeImageINTEL".."5700",
        "OpTypeAvcImePayloadINTEL".."5701",
        "OpTypeAvcRefPayloadINTEL".."5702",
        "OpTypeAvcSicPayloadINTEL".."5703",
        "OpTypeAvcMcePayloadINTEL".."5704",
        "OpTypeAvcMceResultINTEL".."5705",
        "OpTypeAvcImeResultINTEL".."5706",
        "OpTypeAvcImeResultSingleReferenceStreamoutINTEL".."5707",
        "OpTypeAvcImeResultDualReferenceStreamoutINTEL".."5708",
        "OpTypeAvcImeSingleReferenceStreaminINTEL".."5709",
        "OpTypeAvcImeDualReferenceStreaminINTEL".."5710",
        "OpTypeAvcRefResultINTEL".."5711",
        "OpTypeAvcSicResultINTEL".."5712",
        "OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL".."5713",
        "OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL".."5714",
        "OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL".."5715",
        "OpSubgroupAvcMceSetInterShapePenaltyINTEL".."5716",
        "OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL".."5717",
        "OpSubgroupAvcMceSetInterDirectionPenaltyINTEL".."5718",
        "OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL".."5719",
        "OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL".."5720",
        "OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL".."5721",
        "OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL".."5722",
        "OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL".."5723",
        "OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL".."5724",
        "OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL".."5725",
        "OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL".."5726",
        "OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL".."5727",
        "OpSubgroupAvcMceSetAcOnlyHaarINTEL".."5728",
        "OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL".."5729",
        "OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL".."5730",
        "OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL".."5731",
        "OpSubgroupAvcMceConvertToImePayloadINTEL".."5732",
        "OpSubgroupAvcMceConvertToImeResultINTEL".."5733",
        "OpSubgroupAvcMceConvertToRefPayloadINTEL".."5734",
        "OpSubgroupAvcMceConvertToRefResultINTEL".."5735",
        "OpSubgroupAvcMceConvertToSicPayloadINTEL".."5736",
        "OpSubgroupAvcMceConvertToSicResultINTEL".."5737",
        "OpSubgroupAvcMceGetMotionVectorsINTEL".."5738",
        "OpSubgroupAvcMceGetInterDistortionsINTEL".."5739",
        "OpSubgroupAvcMceGetBestInterDistortionsINTEL".."5740",
        "OpSubgroupAvcMceGetInterMajorShapeINTEL".."5741",
        "OpSubgroupAvcMceGetInterMinorShapeINTEL".."5742",
        "OpSubgroupAvcMceGetInterDirectionsINTEL".."5743",
        "OpSubgroupAvcMceGetInterMotionVectorCountINTEL".."5744",
        "OpSubgroupAvcMceGetInterReferenceIdsINTEL".."5745",
        "OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL".."5746",
        "OpSubgroupAvcImeInitializeINTEL".."5747",
        "OpSubgroupAvcImeSetSingleReferenceINTEL".."5748",
        "OpSubgroupAvcImeSetDualReferenceINTEL".."5749",
        "OpSubgroupAvcImeRefWindowSizeINTEL".."5750",
        "OpSubgroupAvcImeAdjustRefOffsetINTEL".."5751",
        "OpSubgroupAvcImeConvertToMcePayloadINTEL".."5752",
        "OpSubgroupAvcImeSetMaxMotionVectorCountINTEL".."5753",
        "OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL".."5754",
        "OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL".."5755",
        "OpSubgroupAvcImeSetWeightedSadINTEL".."5756",
        "OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL".."5757",
        "OpSubgroupAvcImeEvaluateWithDualReferenceINTEL".."5758",
        "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL".."5759",
        "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL".."5760",
        "OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL".."5761",
        "OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL".."5762",
        "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL".."5763",
        "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL".."5764",
        "OpSubgroupAvcImeConvertToMceResultINTEL".."5765",
        "OpSubgroupAvcImeGetSingleReferenceStreaminINTEL".."5766",
        "OpSubgroupAvcImeGetDualReferenceStreaminINTEL".."5767",
        "OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL".."5768",
        "OpSubgroupAvcImeStripDualReferenceStreamoutINTEL".."5769",
        "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL".."5770",
        "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL".."5771",
        "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL".."5772",
        "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL".."5773",
        "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL".."5774",
        "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL".."5775",
        "OpSubgroupAvcImeGetBorderReachedINTEL".."5776",
        "OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL".."5777",
        "OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL".."5778",
        "OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL".."5779",
        "OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL".."5780",
        "OpSubgroupAvcFmeInitializeINTEL".."5781",
        "OpSubgroupAvcBmeInitializeINTEL".."5782",
        "OpSubgroupAvcRefConvertToMcePayloadINTEL".."5783",
        "OpSubgroupAvcRefSetBidirectionalMixDisableINTEL".."5784",
        "OpSubgroupAvcRefSetBilinearFilterEnableINTEL".."5785",
        "OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL".."5786",
        "OpSubgroupAvcRefEvaluateWithDualReferenceINTEL".."5787",
        "OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL".."5788",
        "OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL".."5789",
        "OpSubgroupAvcRefConvertToMceResultINTEL".."5790",
        "OpSubgroupAvcSicInitializeINTEL".."5791",
        "OpSubgroupAvcSicConfigureSkcINTEL".."5792",
        "OpSubgroupAvcSicConfigureIpeLumaINTEL".."5793",
        "OpSubgroupAvcSicConfigureIpeLumaChromaINTEL".."5794",
        "OpSubgroupAvcSicGetMotionVectorMaskINTEL".."5795",
        "OpSubgroupAvcSicConvertToMcePayloadINTEL".."5796",
        "OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL".."5797",
        "OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL".."5798",
        "OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL".."5799",
        "OpSubgroupAvcSicSetBilinearFilterEnableINTEL".."5800",
        "OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL".."5801",
        "OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL".."5802",
        "OpSubgroupAvcSicEvaluateIpeINTEL".."5803",
        "OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL".."5804",
        "OpSubgroupAvcSicEvaluateWithDualReferenceINTEL".."5805",
        "OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL".."5806",
        "OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL".."5807",
        "OpSubgroupAvcSicConvertToMceResultINTEL".."5808",
        "OpSubgroupAvcSicGetIpeLumaShapeINTEL".."5809",
        "OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL".."5810",
        "OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL".."5811",
        "OpSubgroupAvcSicGetPackedIpeLumaModesINTEL".."5812",
        "OpSubgroupAvcSicGetIpeChromaModeINTEL".."5813",
        "OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL".."5814",
        "OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL".."5815",
        "OpSubgroupAvcSicGetInterRawSadsINTEL".."5816",
        "OpVariableLengthArrayINTEL".."5818",
        "OpSaveMemoryINTEL".."5819",
        "OpRestoreMemoryINTEL".."5820",
        "OpArbitraryFloatSinCosPiINTEL".."5840",
        "OpArbitraryFloatCastINTEL".."5841",
        "OpArbitraryFloatCastFromIntINTEL".."5842",
        "OpArbitraryFloatCastToIntINTEL".."5843",
        "OpArbitraryFloatAddINTEL".."5846",
        "OpArbitraryFloatSubINTEL".."5847",
        "OpArbitraryFloatMulINTEL".."5848",
        "OpArbitraryFloatDivINTEL".."5849",
        "OpArbitraryFloatGTINTEL".."5850",
        "OpArbitraryFloatGEINTEL".."5851",
        "OpArbitraryFloatLTINTEL".."5852",
        "OpArbitraryFloatLEINTEL".."5853",
        "OpArbitraryFloatEQINTEL".."5854",
        "OpArbitraryFloatRecipINTEL".."5855",
        "OpArbitraryFloatRSqrtINTEL".."5856",
        "OpArbitraryFloatCbrtINTEL".."5857",
        "OpArbitraryFloatHypotINTEL".."5858",
        "OpArbitraryFloatSqrtINTEL".."5859",
        "OpArbitraryFloatLogINTEL".."5860",
        "OpArbitraryFloatLog2INTEL".."5861",
        "OpArbitraryFloatLog10INTEL".."5862",
        "OpArbitraryFloatLog1pINTEL".."5863",
        "OpArbitraryFloatExpINTEL".."5864",
        "OpArbitraryFloatExp2INTEL".."5865",
        "OpArbitraryFloatExp10INTEL".."5866",
        "OpArbitraryFloatExpm1INTEL".."5867",
        "OpArbitraryFloatSinINTEL".."5868",
        "OpArbitraryFloatCosINTEL".."5869",
        "OpArbitraryFloatSinCosINTEL".."5870",
        "OpArbitraryFloatSinPiINTEL".."5871",
        "OpArbitraryFloatCosPiINTEL".."5872",
        "OpArbitraryFloatASinINTEL".."5873",
        "OpArbitraryFloatASinPiINTEL".."5874",
        "OpArbitraryFloatACosINTEL".."5875",
        "OpArbitraryFloatACosPiINTEL".."5876",
        "OpArbitraryFloatATanINTEL".."5877",
        "OpArbitraryFloatATanPiINTEL".."5878",
        "OpArbitraryFloatATan2INTEL".."5879",
        "OpArbitraryFloatPowINTEL".."5880",
        "OpArbitraryFloatPowRINTEL".."5881",
        "OpArbitraryFloatPowNINTEL".."5882",
        "OpLoopControlINTEL".."5887",
        "OpAliasDomainDeclINTEL".."5911",
        "OpAliasScopeDeclINTEL".."5912",
        "OpAliasScopeListDeclINTEL".."5913",
        "OpFixedSqrtINTEL".."5923",
        "OpFixedRecipINTEL".."5924",
        "OpFixedRsqrtINTEL".."5925",
        "OpFixedSinINTEL".."5926",
        "OpFixedCosINTEL".."5927",
        "OpFixedSinCosINTEL".."5928",
        "OpFixedSinPiINTEL".."5929",
        "OpFixedCosPiINTEL".."5930",
        "OpFixedSinCosPiINTEL".."5931",
        "OpFixedLogINTEL".."5932",
        "OpFixedExpINTEL".."5933",
        "OpPtrCastToCrossWorkgroupINTEL".."5934",
        "OpCrossWorkgroupCastToPtrINTEL".."5938",
        "OpReadPipeBlockingINTEL".."5946",
        "OpWritePipeBlockingINTEL".."5947",
        "OpFPGARegINTEL".."5949",
        "OpRayQueryGetRayTMinKHR".."6016",
        "OpRayQueryGetRayFlagsKHR".."6017",
        "OpRayQueryGetIntersectionTKHR".."6018",
        "OpRayQueryGetIntersectionInstanceCustomIndexKHR".."6019",
        "OpRayQueryGetIntersectionInstanceIdKHR".."6020",
        "OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR".."6021",
        "OpRayQueryGetIntersectionGeometryIndexKHR".."6022",
        "OpRayQueryGetIntersectionPrimitiveIndexKHR".."6023",
        "OpRayQueryGetIntersectionBarycentricsKHR".."6024",
        "OpRayQueryGetIntersectionFrontFaceKHR".."6025",
        "OpRayQueryGetIntersectionCandidateAABBOpaqueKHR".."6026",
        "OpRayQueryGetIntersectionObjectRayDirectionKHR".."6027",
        "OpRayQueryGetIntersectionObjectRayOriginKHR".."6028",
        "OpRayQueryGetWorldRayDirectionKHR".."6029",
        "OpRayQueryGetWorldRayOriginKHR".."6030",
        "OpRayQueryGetIntersectionObjectToWorldKHR".."6031",
        "OpRayQueryGetIntersectionWorldToObjectKHR".."6032",
        "OpAtomicFAddEXT".."6035",
        "OpTypeBufferSurfaceINTEL".."6086",
        "OpTypeStructContinuedINTEL".."6090",
        "OpConstantCompositeContinuedINTEL".."6091",
        "OpSpecConstantCompositeContinuedINTEL".."6092",
        "OpControlBarrierArriveINTEL".."6142",
        "OpControlBarrierWaitINTEL".."6143",
        "OpGroupIMulKHR".."6401",
        "OpGroupFMulKHR".."6402",
        "OpGroupBitwiseAndKHR".."6403",
        "OpGroupBitwiseOrKHR".."6404",
        "OpGroupBitwiseXorKHR".."6405",
        "OpGroupLogicalAndKHR".."6406",
        "OpGroupLogicalOrKHR".."6407",
        "OpGroupLogicalXorKHR".."6408",
        "OpMax".."0x7fffffff",
    )
}
