/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package openxr.templates

import org.lwjgl.generator.*
import openxr.*

val META_environment_depth = "METAEnvironmentDepth".nativeClassXR("META_environment_depth", type = "instance", postfix = "META") {
    documentation =
        """
        The <a href="https://registry.khronos.org/OpenXR/specs/1.1/html/xrspec.html\#XR_META_environment_depth">XR_META_environment_depth</a> extension.

        This extension allows the application to request depth maps of the real-world environment around the headset. The depth maps are generated by the runtime and shared with the application using an {@code XrEnvironmentDepthSwapchainMETA}.
        """

    IntConstant(
        "The extension specification version.",

        "META_environment_depth_SPEC_VERSION".."1"
    )

    StringConstant(
        "The extension name.",

        "META_ENVIRONMENT_DEPTH_EXTENSION_NAME".."XR_META_environment_depth"
    )

    EnumConstant(
        "Extends {@code XrObjectType}.",

        "OBJECT_TYPE_ENVIRONMENT_DEPTH_PROVIDER_META".."1000291000",
        "OBJECT_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_META".."1000291001"
    )

    EnumConstant(
        "Extends {@code XrStructureType}.",

        "TYPE_ENVIRONMENT_DEPTH_PROVIDER_CREATE_INFO_META".."1000291000",
        "TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_CREATE_INFO_META".."1000291001",
        "TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_STATE_META".."1000291002",
        "TYPE_ENVIRONMENT_DEPTH_IMAGE_ACQUIRE_INFO_META".."1000291003",
        "TYPE_ENVIRONMENT_DEPTH_IMAGE_VIEW_META".."1000291004",
        "TYPE_ENVIRONMENT_DEPTH_IMAGE_META".."1000291005",
        "TYPE_ENVIRONMENT_DEPTH_HAND_REMOVAL_SET_INFO_META".."1000291006",
        "TYPE_SYSTEM_ENVIRONMENT_DEPTH_PROPERTIES_META".."1000291007"
    )

    EnumConstant(
        "Extends {@code XrResult}.",

        "ENVIRONMENT_DEPTH_NOT_AVAILABLE_META".."1000291000"
    )

    XrResult(
        "CreateEnvironmentDepthProviderMETA",
        """
        Creates and initializes a depth provider.

        <h5>C Specification</h5>
        The #CreateEnvironmentDepthProviderMETA() function is defined as:

        <pre><code>
￿XrResult xrCreateEnvironmentDepthProviderMETA(
￿    XrSession                                   session,
￿    const XrEnvironmentDepthProviderCreateInfoMETA* createInfo,
￿    XrEnvironmentDepthProviderMETA*             environmentDepthProvider);</code></pre>

        <h5>Description</h5>
        The #CreateEnvironmentDepthProviderMETA() function creates a depth provider instance.

        Creating the depth provider <b>may</b> allocate resources, but <b>should</b> not incur any per-frame compute costs until the provider has been started.

        <ul>
            <li>Runtimes <b>must</b> create the provider in a stopped state.</li>
            <li>Runtimes <b>may</b> limit the number of depth providers per {@code XrInstance}. If #CreateEnvironmentDepthProviderMETA() fails due to reaching this limit, the runtime <b>must</b> return #ERROR_LIMIT_REACHED.</li>
            <li>Runtimes <b>must</b> support at least 1 provider per {@code XrInstance}.</li>
            <li>Runtimes <b>may</b> return #ERROR_NOT_PERMITTED_PASSTHROUGH_FB if the app permissions have not been granted to the calling app.</li>
            <li>Applications <b>can</b> call #StartEnvironmentDepthProviderMETA() to start the generation of depth maps.</li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #CreateEnvironmentDepthProviderMETA()</li>
            <li>{@code session} <b>must</b> be a valid {@code XrSession} handle</li>
            <li>{@code createInfo} <b>must</b> be a pointer to a valid ##XrEnvironmentDepthProviderCreateInfoMETA structure</li>
            <li>{@code environmentDepthProvider} <b>must</b> be a pointer to an {@code XrEnvironmentDepthProviderMETA} handle</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
                <li>#SESSION_LOSS_PENDING</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_SESSION_LOST</li>
                <li>#ERROR_OUT_OF_MEMORY</li>
                <li>#ERROR_LIMIT_REACHED</li>
                <li>#ERROR_NOT_PERMITTED_PASSTHROUGH_FB</li>
            </ul></dd>
        </dl>

        <h5>See Also</h5>
        ##XrEnvironmentDepthProviderCreateInfoMETA
        """,

        XrSession("session", "the {@code XrSession}."),
        XrEnvironmentDepthProviderCreateInfoMETA.const.p("createInfo", "a pointer to an ##XrEnvironmentDepthProviderCreateInfoMETA containing creation options for the depth provider."),
        Check(1)..XrEnvironmentDepthProviderMETA.p("environmentDepthProvider", "the returned {@code XrEnvironmentDepthProviderMETA} handle for the created depth provider.")
    )

    XrResult(
        "DestroyEnvironmentDepthProviderMETA",
        """
        Destroys the depth provider and frees all memory and resources.

        <h5>C Specification</h5>
        The #DestroyEnvironmentDepthProviderMETA() function is defined as:

        <pre><code>
￿XrResult xrDestroyEnvironmentDepthProviderMETA(
￿    XrEnvironmentDepthProviderMETA              environmentDepthProvider);</code></pre>

        <h5>Description</h5>
        The #DestroyEnvironmentDepthProviderMETA() function destroys the depth provider. After this call the runtime <b>may</b> free all related memory and resources.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #DestroyEnvironmentDepthProviderMETA()</li>
            <li>{@code environmentDepthProvider} <b>must</b> be a valid {@code XrEnvironmentDepthProviderMETA} handle</li>
        </ul>

        <h5>Thread Safety</h5>
        <ul>
            <li>Access to {@code environmentDepthProvider}, and any child handles, <b>must</b> be externally synchronized</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
            </ul></dd>
        </dl>
        """,

        XrEnvironmentDepthProviderMETA("environmentDepthProvider", "an {@code XrEnvironmentDepthProviderMETA} handle for the depth provider.")
    )

    XrResult(
        "StartEnvironmentDepthProviderMETA",
        """
        Starts the generation of depth maps.

        <h5>C Specification</h5>
        The #StartEnvironmentDepthProviderMETA() function is defined as:

        <pre><code>
￿XrResult xrStartEnvironmentDepthProviderMETA(
￿    XrEnvironmentDepthProviderMETA              environmentDepthProvider);</code></pre>

        <h5>Description</h5>
        The #StartEnvironmentDepthProviderMETA() function starts the asynchronous generation of depth maps.

        Starting the depth provider <b>may</b> use CPU and GPU resources.

        Runtimes <b>must</b> return #ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB if #StartEnvironmentDepthProviderMETA() is called on an already started {@code XrEnvironmentDepthProviderMETA}.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #StartEnvironmentDepthProviderMETA()</li>
            <li>{@code environmentDepthProvider} <b>must</b> be a valid {@code XrEnvironmentDepthProviderMETA} handle</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
                <li>#SESSION_LOSS_PENDING</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_SESSION_LOST</li>
                <li>#ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB</li>
            </ul></dd>
        </dl>
        """,

        XrEnvironmentDepthProviderMETA("environmentDepthProvider", "an {@code XrEnvironmentDepthProviderMETA} handle for the depth provider.")
    )

    XrResult(
        "StopEnvironmentDepthProviderMETA",
        """
        Stops the depth feature.

        <h5>C Specification</h5>
        The #StopEnvironmentDepthProviderMETA() function is defined as:

        <pre><code>
￿XrResult xrStopEnvironmentDepthProviderMETA(
￿    XrEnvironmentDepthProviderMETA              environmentDepthProvider);</code></pre>

        <h5>Description</h5>
        The #StopEnvironmentDepthProviderMETA() function stops the generation of depth maps. This stops all per frame computation of environment depth for the application.

        Runtimes <b>must</b> return #ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB if #StopEnvironmentDepthProviderMETA() is called on an already stopped {@code XrEnvironmentDepthProviderMETA}.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #StopEnvironmentDepthProviderMETA()</li>
            <li>{@code environmentDepthProvider} <b>must</b> be a valid {@code XrEnvironmentDepthProviderMETA} handle</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
                <li>#SESSION_LOSS_PENDING</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_SESSION_LOST</li>
                <li>#ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB</li>
            </ul></dd>
        </dl>
        """,

        XrEnvironmentDepthProviderMETA("environmentDepthProvider", "an {@code XrEnvironmentDepthProviderMETA} handle for the depth provider.")
    )

    XrResult(
        "CreateEnvironmentDepthSwapchainMETA",
        """
        Returns a readable depth swapchain.

        <h5>C Specification</h5>
        The #CreateEnvironmentDepthSwapchainMETA() function is defined as:

        <pre><code>
￿XrResult xrCreateEnvironmentDepthSwapchainMETA(
￿    XrEnvironmentDepthProviderMETA              environmentDepthProvider,
￿    const XrEnvironmentDepthSwapchainCreateInfoMETA* createInfo,
￿    XrEnvironmentDepthSwapchainMETA*            swapchain);</code></pre>

        <h5>Description</h5>
        The #CreateEnvironmentDepthSwapchainMETA() function creates a readable swapchain, which is used for accessing the depth data.

        The runtime decides on the resolution and length of the swapchain. Additional information about the swapchain <b>can</b> be accessed by calling #GetEnvironmentDepthSwapchainStateMETA().

        Runtimes <b>must</b> create a swapchain with array textures of length 2, which map to a left-eye and right-eye view. View index 0 <b>must</b> represent the left eye and view index 1 <b>must</b> represent the right eye. This is the same convention as for #VIEW_CONFIGURATION_TYPE_PRIMARY_STEREO in {@code XrViewConfigurationType}. Runtimes <b>must</b> create the swapchain with the following image formats depending on the graphics API associated with the session:

        <ul>
            <li>OpenGL: {@code GL_DEPTH_COMPONENT16}</li>
            <li>Vulkan: {@code VK_FORMAT_D16_UNORM}</li>
            <li>Direct3D: {@code DXGI_FORMAT_D16_UNORM}</li>
        </ul>

        Runtimes <b>must</b> only allow maximum one swapchain to exist per depth provider at any given time, and must return #ERROR_LIMIT_REACHED if #CreateEnvironmentDepthSwapchainMETA() is called to create more. Applications <b>should</b> destroy the swapchain when no longer needed. Applications <b>must</b> be able to handle different swapchain lengths and resolutions.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #CreateEnvironmentDepthSwapchainMETA()</li>
            <li>{@code environmentDepthProvider} <b>must</b> be a valid {@code XrEnvironmentDepthProviderMETA} handle</li>
            <li>{@code createInfo} <b>must</b> be a pointer to a valid ##XrEnvironmentDepthSwapchainCreateInfoMETA structure</li>
            <li>{@code swapchain} <b>must</b> be a pointer to an {@code XrEnvironmentDepthSwapchainMETA} handle</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
                <li>#SESSION_LOSS_PENDING</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_SESSION_LOST</li>
                <li>#ERROR_OUT_OF_MEMORY</li>
                <li>#ERROR_LIMIT_REACHED</li>
            </ul></dd>
        </dl>

        <h5>See Also</h5>
        ##XrEnvironmentDepthSwapchainCreateInfoMETA
        """,

        XrEnvironmentDepthProviderMETA("environmentDepthProvider", "an {@code XrEnvironmentDepthProviderMETA} handle for the depth provider."),
        XrEnvironmentDepthSwapchainCreateInfoMETA.const.p("createInfo", "a pointer to an ##XrEnvironmentDepthSwapchainCreateInfoMETA containing creation options for the swapchain."),
        Check(1)..XrEnvironmentDepthSwapchainMETA.p("swapchain", "the returned {@code XrEnvironmentDepthSwapchainMETA} handle for the created swapchain.")
    )

    XrResult(
        "DestroyEnvironmentDepthSwapchainMETA",
        """
        Destroys a readable depth swapchain.

        <h5>C Specification</h5>
        The #DestroyEnvironmentDepthSwapchainMETA() function is defined as:

        <pre><code>
￿XrResult xrDestroyEnvironmentDepthSwapchainMETA(
￿    XrEnvironmentDepthSwapchainMETA             swapchain);</code></pre>

        <h5>Description</h5>
        The #DestroyEnvironmentDepthSwapchainMETA() function destroys a readable environment depth swapchain.

        All submitted graphics API commands that refer to {@code swapchain} <b>must</b> have completed execution. Runtimes <b>may</b> continue to utilize swapchain images after #DestroyEnvironmentDepthSwapchainMETA() is called.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #DestroyEnvironmentDepthSwapchainMETA()</li>
            <li>{@code swapchain} <b>must</b> be a valid {@code XrEnvironmentDepthSwapchainMETA} handle</li>
        </ul>

        <h5>Thread Safety</h5>
        <ul>
            <li>Access to {@code swapchain}, and any child handles, <b>must</b> be externally synchronized</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_HANDLE_INVALID</li>
            </ul></dd>
        </dl>
        """,

        XrEnvironmentDepthSwapchainMETA("swapchain", "the {@code XrEnvironmentDepthSwapchainMETA} to be destroyed.")
    )

    XrResult(
        "EnumerateEnvironmentDepthSwapchainImagesMETA",
        """
        Gets images from a readable depth swapchain.

        <h5>C Specification</h5>
        The #EnumerateEnvironmentDepthSwapchainImagesMETA() function is defined as:

        <pre><code>
￿XrResult xrEnumerateEnvironmentDepthSwapchainImagesMETA(
￿    XrEnvironmentDepthSwapchainMETA             swapchain,
￿    uint32_t                                    imageCapacityInput,
￿    uint32_t*                                   imageCountOutput,
￿    XrSwapchainImageBaseHeader*                 images);</code></pre>

        <h5>Description</h5>
        #EnumerateEnvironmentDepthSwapchainImagesMETA() fills an array of graphics API-specific stext:XrSwapchainImage* structures derived from ##XrSwapchainImageBaseHeader. The resources <b>must</b> be constant and valid for the lifetime of the {@code XrEnvironmentDepthSwapchainMETA}. This function behaves analogously to #EnumerateSwapchainImages().

        Runtimes <b>must</b> always return identical buffer contents from this enumeration for the lifetime of the swapchain.

        Note: {@code images} is a pointer to an array of structures of graphics API-specific type, not an array of structure pointers.

        The pointer submitted as {@code images} will be treated as an array of the expected graphics API-specific type based on the graphics API used at session creation time. If the type member of any array element accessed in this way does not match the expected value, the runtime <b>must</b> return #ERROR_VALIDATION_FAILURE.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #EnumerateEnvironmentDepthSwapchainImagesMETA()</li>
            <li>{@code swapchain} <b>must</b> be a valid {@code XrEnvironmentDepthSwapchainMETA} handle</li>
            <li>{@code imageCountOutput} <b>must</b> be a pointer to a {@code uint32_t} value</li>
            <li>If {@code imageCapacityInput} is not 0, {@code images} <b>must</b> be a pointer to an array of {@code imageCapacityInput} ##XrSwapchainImageBaseHeader-based structures. See also: ##XrSwapchainImageOpenGLKHR, ##XrSwapchainImageVulkanKHR</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
                <li>#SESSION_LOSS_PENDING</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_SESSION_LOST</li>
                <li>#ERROR_SIZE_INSUFFICIENT</li>
            </ul></dd>
        </dl>

        <h5>See Also</h5>
        ##XrSwapchainImageBaseHeader
        """,

        XrEnvironmentDepthSwapchainMETA("swapchain", "the {@code XrEnvironmentDepthSwapchainMETA} to get images from."),
        AutoSize("images")..uint32_t("imageCapacityInput", "the capacity of the images array, or 0 to indicate a request to retrieve the required capacity."),
        Check(1)..uint32_t.p("imageCountOutput", "a pointer to the count of images written, or a pointer to the required capacity in the case that {@code imageCapacityInput} is insufficient."),
        nullable..XrSwapchainImageBaseHeader.p("images", "a pointer to an array of graphics API-specific XrSwapchainImage structures, all of the same type, based on ##XrSwapchainImageBaseHeader. It <b>can</b> be {@code NULL} if {@code imageCapacityInput} is 0.")
    )

    XrResult(
        "GetEnvironmentDepthSwapchainStateMETA",
        """
        Returns the state of the readable depth swapchain.

        <h5>C Specification</h5>
        The #GetEnvironmentDepthSwapchainStateMETA() function is defined as:

        <pre><code>
￿XrResult xrGetEnvironmentDepthSwapchainStateMETA(
￿    XrEnvironmentDepthSwapchainMETA             swapchain,
￿    XrEnvironmentDepthSwapchainStateMETA*       state);</code></pre>

        <h5>Description</h5>
        #GetEnvironmentDepthSwapchainStateMETA() retrieves information about the {@code XrEnvironmentDepthSwapchainMETA}. This information is constant throughout the lifetime of the {@code XrEnvironmentDepthSwapchainMETA}.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #GetEnvironmentDepthSwapchainStateMETA()</li>
            <li>{@code swapchain} <b>must</b> be a valid {@code XrEnvironmentDepthSwapchainMETA} handle</li>
            <li>{@code state} <b>must</b> be a pointer to an ##XrEnvironmentDepthSwapchainStateMETA structure</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
                <li>#SESSION_LOSS_PENDING</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_SESSION_LOST</li>
            </ul></dd>
        </dl>

        <h5>See Also</h5>
        ##XrEnvironmentDepthSwapchainStateMETA
        """,

        XrEnvironmentDepthSwapchainMETA("swapchain", "an {@code XrEnvironmentDepthSwapchainMETA} handle."),
        XrEnvironmentDepthSwapchainStateMETA.p("state", "a pointer to an ##XrEnvironmentDepthSwapchainStateMETA.")
    )

    XrResult(
        "AcquireEnvironmentDepthImageMETA",
        """
        Returns an image index in a readable depth swapchain and associated metadata.

        <h5>C Specification</h5>
        The #AcquireEnvironmentDepthImageMETA() function is defined as:

        <pre><code>
￿XrResult xrAcquireEnvironmentDepthImageMETA(
￿    XrEnvironmentDepthProviderMETA              environmentDepthProvider,
￿    const XrEnvironmentDepthImageAcquireInfoMETA* acquireInfo,
￿    XrEnvironmentDepthImageMETA*                environmentDepthImage);</code></pre>

        <h5>Description</h5>
        Acquires the latest available swapchain image that has been generated by the depth provider and ensures it is ready to be accessed by the application. The application <b>may</b> access and queue GPU operations using the acquired image until the next #EndFrame() call, when the image is released and the depth provider <b>may</b> write new depth data into it after completion of all work queued before the #EndFrame() call.

        The returned ##XrEnvironmentDepthImageMETA contains the swapchain index into the array enumerated by #EnumerateEnvironmentDepthSwapchainImagesMETA(). It also contains other information such as the field of view and pose that are necessary to interpret the depth data.

        There <b>must</b> be no more than one call to #AcquireEnvironmentDepthImageMETA() between any pair of corresponding #BeginFrame() and #EndFrame() calls in a session.

        <ul>
            <li>The runtime <b>may</b> block if previously acquired swapchain images are still being used by the graphics API.</li>
            <li>The runtime <b>must</b> return #ERROR_CALL_ORDER_INVALID if #AcquireEnvironmentDepthImageMETA() is called before #BeginFrame() or after #EndFrame().</li>
            <li>The runtime <b>must</b> return #ERROR_CALL_ORDER_INVALID if #AcquireEnvironmentDepthImageMETA() is called on a stopped {@code XrEnvironmentDepthProviderMETA}.</li>
            <li>The runtime <b>must</b> return #ERROR_LIMIT_REACHED if #AcquireEnvironmentDepthImageMETA() is called more than once per frame - i.e. in a running session, after a call to #BeginFrame() that has not had an associated #EndFrame().</li>
            <li>Runtimes <b>must</b> return #ENVIRONMENT_DEPTH_NOT_AVAILABLE_META if no depth frame is available yet (i.e. the provider was recently started and did not yet have time to compute depth). Note that this is a success code. In this case the output parameters <b>must</b> be unchanged.</li>
            <li>The application <b>must</b> not utilize the swapchain image in calls to the graphics API after #EndFrame() has been called.</li>
            <li>
                A runtime <b>may</b> use the graphics API specific contexts provided to OpenXR. In particular:
                <ul>
                    <li>For OpenGL, a runtime <b>may</b> use the OpenGL context specified in the call to #CreateSession(), which needs external synchronization.</li>
                    <li>For Vulkan, a runtime <b>may</b> use the {@code VkQueue} specified in the ##XrGraphicsBindingVulkan2KHR, which needs external synchronization.</li>
                </ul>
            </li>
        </ul>

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #AcquireEnvironmentDepthImageMETA()</li>
            <li>{@code environmentDepthProvider} <b>must</b> be a valid {@code XrEnvironmentDepthProviderMETA} handle</li>
            <li>{@code acquireInfo} <b>must</b> be a pointer to a valid ##XrEnvironmentDepthImageAcquireInfoMETA structure</li>
            <li>{@code environmentDepthImage} <b>must</b> be a pointer to an ##XrEnvironmentDepthImageMETA structure</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
                <li>#SESSION_LOSS_PENDING</li>
                <li>#ENVIRONMENT_DEPTH_NOT_AVAILABLE_META</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_SESSION_LOST</li>
                <li>#ERROR_TIME_INVALID</li>
                <li>#ERROR_CALL_ORDER_INVALID</li>
            </ul></dd>
        </dl>

        <h5>See Also</h5>
        ##XrEnvironmentDepthImageAcquireInfoMETA, ##XrEnvironmentDepthImageMETA
        """,

        XrEnvironmentDepthProviderMETA("environmentDepthProvider", "an {@code XrEnvironmentDepthProviderMETA} handle for the depth provider."),
        XrEnvironmentDepthImageAcquireInfoMETA.const.p("acquireInfo", "an ##XrEnvironmentDepthImageAcquireInfoMETA containing parameters for populating a depth swapchain image."),
        XrEnvironmentDepthImageMETA.p("environmentDepthImage", "the returned ##XrEnvironmentDepthImageMETA containing information about the acquired depth image.")
    )

    XrResult(
        "SetEnvironmentDepthHandRemovalMETA",
        """
        Enables/disables hand removal from the depth map.

        <h5>C Specification</h5>
        The #SetEnvironmentDepthHandRemovalMETA() function is defined as:

        <pre><code>
￿XrResult xrSetEnvironmentDepthHandRemovalMETA(
￿    XrEnvironmentDepthProviderMETA              environmentDepthProvider,
￿    const XrEnvironmentDepthHandRemovalSetInfoMETA* setInfo);</code></pre>

        <h5>Description</h5>
        The #SetEnvironmentDepthHandRemovalMETA() function sets hand removal options.

        Runtimes <b>should</b> enable or disable the removal of the hand depths from the depth map. If enabled, the corresponding depth pixels <b>should</b> be replaced with the estimated background depth behind the hands. Runtimes <b>must</b> return #ERROR_FEATURE_UNSUPPORTED if and only if ##XrSystemEnvironmentDepthPropertiesMETA{@code ::supportsHandRemoval} is #FALSE.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link METAEnvironmentDepth XR_META_environment_depth} extension <b>must</b> be enabled prior to calling #SetEnvironmentDepthHandRemovalMETA()</li>
            <li>{@code environmentDepthProvider} <b>must</b> be a valid {@code XrEnvironmentDepthProviderMETA} handle</li>
            <li>{@code setInfo} <b>must</b> be a pointer to a valid ##XrEnvironmentDepthHandRemovalSetInfoMETA structure</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
                <li>#SESSION_LOSS_PENDING</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_SESSION_LOST</li>
                <li>#ERROR_FEATURE_UNSUPPORTED</li>
            </ul></dd>
        </dl>

        <h5>See Also</h5>
        ##XrEnvironmentDepthHandRemovalSetInfoMETA
        """,

        XrEnvironmentDepthProviderMETA("environmentDepthProvider", "an {@code XrEnvironmentDepthProviderMETA} handle for the depth provider."),
        XrEnvironmentDepthHandRemovalSetInfoMETA.const.p("setInfo", "a pointer to an ##XrEnvironmentDepthHandRemovalSetInfoMETA containing options for the hand removal.")
    )
}