/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package openxr.templates

import org.lwjgl.generator.*
import core.windows.*
import openxr.*

val KHR_win32_convert_performance_counter_time = "KHRWin32ConvertPerformanceCounterTime".nativeClassXR("KHR_win32_convert_performance_counter_time", type = "instance", postfix = "KHR") {
    javaImport("org.lwjgl.system.windows.*")
    documentation =
        """
        The <a href="https://registry.khronos.org/OpenXR/specs/1.1/html/xrspec.html\#XR_KHR_win32_convert_performance_counter_time">XR_KHR_win32_convert_performance_counter_time</a> extension.

        This extension provides two functions for converting between the Windows performance counter (QPC) time stamps and {@code XrTime}. The #ConvertWin32PerformanceCounterToTimeKHR() function converts from Windows performance counter time stamps to {@code XrTime}, while the #ConvertTimeToWin32PerformanceCounterKHR() function converts {@code XrTime} to Windows performance counter time stamps. The primary use case for this functionality is to be able to synchronize events between the local system and the OpenXR system.
        """

    IntConstant(
        "The extension specification version.",

        "KHR_win32_convert_performance_counter_time_SPEC_VERSION".."1"
    )

    StringConstant(
        "The extension name.",

        "KHR_WIN32_CONVERT_PERFORMANCE_COUNTER_TIME_EXTENSION_NAME".."XR_KHR_win32_convert_performance_counter_time"
    )

    XrResult(
        "ConvertWin32PerformanceCounterToTimeKHR",
        """
        Convert Win32 {@code QueryPerformanceCounter} time to XrTime.

        <h5>C Specification</h5>
        To convert from a Windows performance counter time stamp to {@code XrTime}, call:

        <pre><code>
￿XrResult xrConvertWin32PerformanceCounterToTimeKHR(
￿    XrInstance                                  instance,
￿    const LARGE_INTEGER*                        performanceCounter,
￿    XrTime*                                     time);</code></pre>

        <h5>Description</h5>
        The #ConvertWin32PerformanceCounterToTimeKHR() function converts a time stamp obtained by the {@code QueryPerformanceCounter} Windows function to the equivalent {@code XrTime}.

        If the output {@code time} cannot represent the input {@code performanceCounter}, the runtime <b>must</b> return #ERROR_TIME_INVALID.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link KHRWin32ConvertPerformanceCounterTime XR_KHR_win32_convert_performance_counter_time} extension <b>must</b> be enabled prior to calling #ConvertWin32PerformanceCounterToTimeKHR()</li>
            <li>{@code instance} <b>must</b> be a valid {@code XrInstance} handle</li>
            <li>{@code performanceCounter} <b>must</b> be a pointer to a valid {@code LARGE_INTEGER} value</li>
            <li>{@code time} <b>must</b> be a pointer to an {@code XrTime} value</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_TIME_INVALID</li>
            </ul></dd>
        </dl>
        """,

        XrInstance("instance", "an {@code XrInstance} handle previously created with #CreateInstance()."),
        LARGE_INTEGER.const.p("performanceCounter", "a time returned by {@code QueryPerformanceCounter}."),
        Check(1)..XrTime.p("time", "the resulting {@code XrTime} that is equivalent to the {@code performanceCounter}.")
    )

    XrResult(
        "ConvertTimeToWin32PerformanceCounterKHR",
        """
        Convert XrTime to Win32 {@code QueryPerformanceCounter} time.

        <h5>C Specification</h5>
        To convert from {@code XrTime} to a Windows performance counter time stamp, call:

        <pre><code>
￿XrResult xrConvertTimeToWin32PerformanceCounterKHR(
￿    XrInstance                                  instance,
￿    XrTime                                      time,
￿    LARGE_INTEGER*                              performanceCounter);</code></pre>

        <h5>Description</h5>
        The #ConvertTimeToWin32PerformanceCounterKHR() function converts an {@code XrTime} to time as if generated by the {@code QueryPerformanceCounter} Windows function.

        If the output {@code performanceCounter} cannot represent the input {@code time}, the runtime <b>must</b> return #ERROR_TIME_INVALID.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link KHRWin32ConvertPerformanceCounterTime XR_KHR_win32_convert_performance_counter_time} extension <b>must</b> be enabled prior to calling #ConvertTimeToWin32PerformanceCounterKHR()</li>
            <li>{@code instance} <b>must</b> be a valid {@code XrInstance} handle</li>
            <li>{@code performanceCounter} <b>must</b> be a pointer to a {@code LARGE_INTEGER} value</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_TIME_INVALID</li>
            </ul></dd>
        </dl>
        """,

        XrInstance("instance", "an {@code XrInstance} handle previously created with #CreateInstance()."),
        XrTime("time", "an {@code XrTime}."),
        LARGE_INTEGER.p("performanceCounter", "the resulting Windows performance counter time stamp that is equivalent to the {@code time}.")
    )
}