/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package openxr.templates

import org.lwjgl.generator.*
import openxr.*

val KHR_convert_timespec_time = "KHRConvertTimespecTime".nativeClassXR("KHR_convert_timespec_time", type = "instance", postfix = "KHR") {
    documentation =
        """
        The <a href="https://registry.khronos.org/OpenXR/specs/1.1/html/xrspec.html\#XR_KHR_convert_timespec_time">XR_KHR_convert_timespec_time</a> extension.

        This extension provides two functions for converting between timespec monotonic time and {@code XrTime}. The #ConvertTimespecTimeToTimeKHR() function converts from timespec time to {@code XrTime}, while the #ConvertTimeToTimespecTimeKHR() function converts {@code XrTime} to timespec monotonic time. The primary use case for this functionality is to be able to synchronize events between the local system and the OpenXR system.
        """

    IntConstant(
        "The extension specification version.",

        "KHR_convert_timespec_time_SPEC_VERSION".."1"
    )

    StringConstant(
        "The extension name.",

        "KHR_CONVERT_TIMESPEC_TIME_EXTENSION_NAME".."XR_KHR_convert_timespec_time"
    )

    XrResult(
        "ConvertTimespecTimeToTimeKHR",
        """
        Convert timespec monotonic time to XrTime.

        <h5>C Specification</h5>
        To convert from timespec monotonic time to {@code XrTime}, call:

        <pre><code>
￿XrResult xrConvertTimespecTimeToTimeKHR(
￿    XrInstance                                  instance,
￿    const struct timespec*                      timespecTime,
￿    XrTime*                                     time);</code></pre>

        <h5>Description</h5>
        The #ConvertTimespecTimeToTimeKHR() function converts a time obtained by the {@code clock_gettime} function to the equivalent {@code XrTime}.

        If the output {@code time} cannot represent the input {@code timespecTime}, the runtime <b>must</b> return #ERROR_TIME_INVALID.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link KHRConvertTimespecTime XR_KHR_convert_timespec_time} extension <b>must</b> be enabled prior to calling #ConvertTimespecTimeToTimeKHR()</li>
            <li>{@code instance} <b>must</b> be a valid {@code XrInstance} handle</li>
            <li>{@code timespecTime} <b>must</b> be a pointer to a valid {@code timespec} value</li>
            <li>{@code time} <b>must</b> be a pointer to an {@code XrTime} value</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_TIME_INVALID</li>
            </ul></dd>
        </dl>
        """,

        XrInstance("instance", "an {@code XrInstance} handle previously created with #CreateInstance()."),
        timespec.const.p("timespecTime", "a {@code timespec} obtained from {@code clock_gettime} with {@code CLOCK_MONOTONIC}."),
        Check(1)..XrTime.p("time", "the resulting {@code XrTime} that is equivalent to the {@code timespecTime}.")
    )

    XrResult(
        "ConvertTimeToTimespecTimeKHR",
        """
        Convert XrTime to timespec monotonic time.

        <h5>C Specification</h5>
        To convert from {@code XrTime} to timespec monotonic time, call:

        <pre><code>
￿XrResult xrConvertTimeToTimespecTimeKHR(
￿    XrInstance                                  instance,
￿    XrTime                                      time,
￿    struct timespec*                            timespecTime);</code></pre>

        <h5>Description</h5>
        The #ConvertTimeToTimespecTimeKHR() function converts an {@code XrTime} to time as if generated by {@code clock_gettime}.

        If the output {@code timespecTime} cannot represent the input {@code time}, the runtime <b>must</b> return #ERROR_TIME_INVALID.

        <h5>Valid Usage (Implicit)</h5>
        <ul>
            <li>The {@link KHRConvertTimespecTime XR_KHR_convert_timespec_time} extension <b>must</b> be enabled prior to calling #ConvertTimeToTimespecTimeKHR()</li>
            <li>{@code instance} <b>must</b> be a valid {@code XrInstance} handle</li>
            <li>{@code timespecTime} <b>must</b> be a pointer to a {@code timespec} value</li>
        </ul>

        <h5>Return Codes</h5>
        <dl>
            <dt>On success, this command returns</dt>
            <dd><ul>
                <li>#SUCCESS</li>
            </ul></dd>

            <dt>On failure, this command returns</dt>
            <dd><ul>
                <li>#ERROR_FUNCTION_UNSUPPORTED</li>
                <li>#ERROR_VALIDATION_FAILURE</li>
                <li>#ERROR_RUNTIME_FAILURE</li>
                <li>#ERROR_HANDLE_INVALID</li>
                <li>#ERROR_INSTANCE_LOST</li>
                <li>#ERROR_TIME_INVALID</li>
            </ul></dd>
        </dl>
        """,

        XrInstance("instance", "an {@code XrInstance} handle previously created with #CreateInstance()."),
        XrTime("time", "an {@code XrTime}."),
        timespec.p("timespecTime", "the resulting timespec time that is equivalent to a {@code timespec} obtained from {@code clock_gettime} with {@code CLOCK_MONOTONIC}.")
    )
}