/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 */
package opengles.templates

import org.lwjgl.generator.*
import opengles.*

val EXT_sRGB = "EXTSRGB".nativeClassGLES("EXT_sRGB", postfix = EXT) {
    documentation =
        """
        Native bindings to the $registryLink extension.

        The sRGB color space is based on typical (non-linear) response of the human eye. It has been standardized by the International Electrotechnical
        Commission (IEC) as IEC 61966-2-1. The transfer function of sRGB roughly corresponds to a power function with a gamma of 2.2.

        <h3>FRAMEBUFFERS</h3>

        OpenGL assumes framebuffer color components are stored in a linear color space. In particular, framebuffer blending is a linear operation.

        This extension adds a framebuffer capability for sRGB framebuffer update and blending. When blending is disabled but the new sRGB updated mode is
        enabled (assume the framebuffer supports the capability), high-precision linear color component values for red, green, and blue generated by fragment
        coloring are encoded for sRGB prior to being written into the framebuffer. When blending is enabled along with the new sRGB update mode, red, green,
        and blue framebuffer color components are treated as sRGB values that are converted to linear color values, blended with the high- precision color
        values generated by fragment coloring, and then the blend result is encoded for sRGB just prior to being written into the framebuffer.

        <h3>TEXTURES</h3>

        Conventional texture formats assume a linear color space. So for a conventional internal texture format such as GL_RGB8, the 256 discrete values for
        each 8-bit color component map linearly and uniformly to the [0,1] range.
        """

    IntConstant(
        """
        Accepted by the {@code format} and {@code internalformat} parameter of TexImage2D, and TexImage3DOES. These are also accepted by {@code format}
        parameter of TexSubImage2D and TexSubImage3DOES.
        """,

        "SRGB_EXT"..0x8C40,
        "SRGB_ALPHA_EXT"..0x8C42
    )

    IntConstant(
        "Accepted by the {@code internalformat} parameter of RenderbufferStorage.",

        "SRGB8_ALPHA8_EXT"..0x8C43
    )

    IntConstant(
        "Accepted by the {@code pname} parameter of GetFramebufferAttachmentParameteriv.",

        "FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT"..0x8210
    )
}