/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 */
package opengles.templates

import org.lwjgl.generator.*
import opengles.*

val EXT_render_snorm = "EXTRenderSnorm".nativeClassGLES("EXT_render_snorm", postfix = EXT) {
    documentation =
        """
        Native bindings to the $registryLink extension.

        OpenGL ES 3.0 supports a variety of signed normalized texture and renderbuffer formats which are not color-renderable.

        This extension enables signed normalized texture and renderbuffer formats to be color-renderable.

        Requires ${GLES30.core}.
        """

    IntConstant(
        "Accepted by the {@code internalFormat} parameter of RenderbufferStorage and RenderbufferStorageMultisample.",

        "R16_SNORM_EXT"..0x8F98,
        "RG16_SNORM_EXT"..0x8F99,
        "RGBA16_SNORM_EXT"..0x8F9B
    )
}