/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 */
package opengl.templates

import opengl.*

val ARB_base_instance = "ARBBaseInstance".nativeClassGL("ARB_base_instance") {
    documentation =
        """
        Native bindings to the $registryLink extension.

        This extension allows the offset within buffer objects used for instanced rendering to be specified. This is congruent with the {@code first} parameter
        in #DrawArrays() and the {@code basevertex} parameter in #DrawElements(). When instanced rendering is performed (for example, through
        #DrawArraysInstanced()), instanced vertex attributes whose vertex attribute divisors are non-zero are fetched from enabled vertex arrays
        per-instance rather than per-vertex. However, in unextended OpenGL, there is no way to define the offset into those arrays from which the attributes are
        fetched. This extension adds that offset in the form of a {@code <baseinstance>} parameter to several new procedures.

        The {@code baseinstance} parameter is added to the index of the array element, after division by the vertex attribute divisor. This allows several sets
        of instanced vertex attribute data to be stored in a single vertex array, and the base offset of that data to be specified for each draw. Further, this
        extension exposes the {@code <baseinstance>} parameter as the final and previously undefined structure member of the draw-indirect data structure.

        Requires ${GL31.core} or ${ARB_draw_instanced.link}. ${GL42.promoted}
        """

    reuse(GL42C, "DrawArraysInstancedBaseInstance")
    reuse(GL42C, "DrawElementsInstancedBaseInstance")
    reuse(GL42C, "DrawElementsInstancedBaseVertexBaseInstance")
}