/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 */
package opengl

import org.lwjgl.generator.*
import core.linux.*

val GLXContext = "GLXContext".handle
val GLXFBConfig = "GLXFBConfig".handle
val GLXFBConfigSGIX = "GLXFBConfigSGIX".handle

val GLXWindow = "GLXWindow".handle
val GLXDrawable = "GLXDrawable".handle
val GLXPixmap = "GLXPixmap".handle

val GLXContextID = typedef(XID, "GLXContextID")

val GLXPbuffer = "GLXPbuffer".handle

fun configGLX() {
    struct(Module.OPENGL, "GLXStereoNotifyEventEXT", nativeSubPath = "glx", mutable = false) {
        int("type", "GenericEvent")
        unsigned_long("serial", "\\# of last request server processed")
        Bool("send_event", "{@code True} if generated by {@code SendEvent} request")
        Display.p("display", "display the event was read from")
        int("extension", "GLX major opcode, from {@code XQueryExtension}")
        int("evtype", "always {@code GLX_STEREO_NOTIFY_EXT}")
        GLXDrawable("window", "XID of the X window affected")
        Bool("stereo_tree", "{@code True} if tree contains stereo windows")
    }
}