/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.util.harfbuzz;

import org.jspecify.annotations.*;

import java.nio.*;

import org.lwjgl.system.*;

import static org.lwjgl.system.APIUtil.*;
import static org.lwjgl.system.Checks.*;
import static org.lwjgl.system.JNI.*;
import static org.lwjgl.system.MemoryUtil.*;

/** Native bindings to the Apple Advanced Typography Layout API of the <a href="https://harfbuzz.github.io/">HarfBuzz</a> library. */
public class AAT {

    /** Contains the function pointers loaded from {@code HarfBuzz.getLibrary()}. */
    public static final class Functions {

        private Functions() {}

        /** Function address. */
        public static final long
            layout_get_feature_types               = apiGetFunctionAddress(HarfBuzz.getLibrary(), "hb_att_layout_get_feature_types"),
            layout_feature_type_get_name_id        = apiGetFunctionAddress(HarfBuzz.getLibrary(), "hb_att_layout_feature_type_get_name_id"),
            layout_feature_type_get_selector_infos = apiGetFunctionAddress(HarfBuzz.getLibrary(), "hb_att_layout_feature_type_get_selector_infos"),
            layout_has_substitution                = apiGetFunctionAddress(HarfBuzz.getLibrary(), "hb_att_layout_has_substitution"),
            layout_has_positioning                 = apiGetFunctionAddress(HarfBuzz.getLibrary(), "hb_att_layout_has_positioning"),
            layout_has_tracking                    = apiGetFunctionAddress(HarfBuzz.getLibrary(), "hb_att_layout_has_tracking");

    }

    /**
     * The possible feature types defined for AAT shaping, from Apple <a href="https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html">Font Feature Registry</a>. ({@code hb_aat_layout_feature_type_t})
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #LAYOUT_FEATURE_TYPE_INVALID LAYOUT_FEATURE_TYPE_INVALID}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_LIGATURES LAYOUT_FEATURE_TYPE_LIGATURES}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_CURSIVE_CONNECTION LAYOUT_FEATURE_TYPE_CURSIVE_CONNECTION}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_LETTER_CASE LAYOUT_FEATURE_TYPE_LETTER_CASE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_NUMBER_SPACING LAYOUT_FEATURE_TYPE_NUMBER_SPACING}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_VERTICAL_POSITION LAYOUT_FEATURE_TYPE_VERTICAL_POSITION}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_FRACTIONS LAYOUT_FEATURE_TYPE_FRACTIONS}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_STYLE_OPTIONS LAYOUT_FEATURE_TYPE_STYLE_OPTIONS}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_NUMBER_CASE LAYOUT_FEATURE_TYPE_NUMBER_CASE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_TEXT_SPACING LAYOUT_FEATURE_TYPE_TEXT_SPACING}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_TRANSLITERATION LAYOUT_FEATURE_TYPE_TRANSLITERATION}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_RUBY_KANA LAYOUT_FEATURE_TYPE_RUBY_KANA}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_ALTERNATE_KANA LAYOUT_FEATURE_TYPE_ALTERNATE_KANA}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_LOWER_CASE LAYOUT_FEATURE_TYPE_LOWER_CASE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_UPPER_CASE LAYOUT_FEATURE_TYPE_UPPER_CASE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_LANGUAGE_TAG_TYPE LAYOUT_FEATURE_TYPE_LANGUAGE_TAG_TYPE}</li>
     * <li>{@link #LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE}</li>
     * </ul>
     */
    public static final int
        LAYOUT_FEATURE_TYPE_INVALID                           = 0xFFFF,
        LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC                   = 0,
        LAYOUT_FEATURE_TYPE_LIGATURES                         = 1,
        LAYOUT_FEATURE_TYPE_CURSIVE_CONNECTION                = 2,
        LAYOUT_FEATURE_TYPE_LETTER_CASE                       = 3,
        LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION             = 4,
        LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT          = 5,
        LAYOUT_FEATURE_TYPE_NUMBER_SPACING                    = 6,
        LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE                  = 8,
        LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE                   = 9,
        LAYOUT_FEATURE_TYPE_VERTICAL_POSITION                 = 10,
        LAYOUT_FEATURE_TYPE_FRACTIONS                         = 11,
        LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE       = 13,
        LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS                = 14,
        LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS               = 15,
        LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE                = 16,
        LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES            = 17,
        LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE            = 18,
        LAYOUT_FEATURE_TYPE_STYLE_OPTIONS                     = 19,
        LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE                   = 20,
        LAYOUT_FEATURE_TYPE_NUMBER_CASE                       = 21,
        LAYOUT_FEATURE_TYPE_TEXT_SPACING                      = 22,
        LAYOUT_FEATURE_TYPE_TRANSLITERATION                   = 23,
        LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE                   = 24,
        LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE                 = 25,
        LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE          = 26,
        LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE        = 27,
        LAYOUT_FEATURE_TYPE_RUBY_KANA                         = 28,
        LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE      = 29,
        LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE     = 30,
        LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE = 31,
        LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN                  = 32,
        LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT             = 33,
        LAYOUT_FEATURE_TYPE_ALTERNATE_KANA                    = 34,
        LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES            = 35,
        LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES           = 36,
        LAYOUT_FEATURE_TYPE_LOWER_CASE                        = 37,
        LAYOUT_FEATURE_TYPE_UPPER_CASE                        = 38,
        LAYOUT_FEATURE_TYPE_LANGUAGE_TAG_TYPE                 = 39,
        LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE            = 103;

    /**
     * The selectors defined for specifying AAT feature settings. ({@code hb_aat_layout_feature_selector_t})
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INVALID LAYOUT_FEATURE_SELECTOR_INVALID}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_ON LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_OFF LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LOGOS_ON LAYOUT_FEATURE_SELECTOR_LOGOS_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LOGOS_OFF LAYOUT_FEATURE_SELECTOR_LOGOS_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_ON LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_OFF LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_UNCONNECTED LAYOUT_FEATURE_SELECTOR_UNCONNECTED}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PARTIALLY_CONNECTED LAYOUT_FEATURE_SELECTOR_PARTIALLY_CONNECTED}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CURSIVE LAYOUT_FEATURE_SELECTOR_CURSIVE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_UPPER_AND_LOWER_CASE LAYOUT_FEATURE_SELECTOR_UPPER_AND_LOWER_CASE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALL_CAPS LAYOUT_FEATURE_SELECTOR_ALL_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALL_LOWER_CASE LAYOUT_FEATURE_SELECTOR_ALL_LOWER_CASE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SMALL_CAPS LAYOUT_FEATURE_SELECTOR_SMALL_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS_AND_SMALL_CAPS LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS_AND_SMALL_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_ON LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_OFF LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_ON LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_OFF LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_NUMBERS LAYOUT_FEATURE_SELECTOR_MONOSPACED_NUMBERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_NUMBERS LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_NUMBERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_NUMBERS LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_NUMBERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_NUMBERS LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_NUMBERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_ON LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_OFF LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_ON LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_OFF LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_ON LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_OFF LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_ON LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_OFF LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_ON LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_OFF LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SHOW_DIACRITICS LAYOUT_FEATURE_SELECTOR_SHOW_DIACRITICS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HIDE_DIACRITICS LAYOUT_FEATURE_SELECTOR_HIDE_DIACRITICS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DECOMPOSE_DIACRITICS LAYOUT_FEATURE_SELECTOR_DECOMPOSE_DIACRITICS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NORMAL_POSITION LAYOUT_FEATURE_SELECTOR_NORMAL_POSITION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SUPERIORS LAYOUT_FEATURE_SELECTOR_SUPERIORS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INFERIORS LAYOUT_FEATURE_SELECTOR_INFERIORS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ORDINALS LAYOUT_FEATURE_SELECTOR_ORDINALS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SCIENTIFIC_INFERIORS LAYOUT_FEATURE_SELECTOR_SCIENTIFIC_INFERIORS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_FRACTIONS LAYOUT_FEATURE_SELECTOR_NO_FRACTIONS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_VERTICAL_FRACTIONS LAYOUT_FEATURE_SELECTOR_VERTICAL_FRACTIONS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DIAGONAL_FRACTIONS LAYOUT_FEATURE_SELECTOR_DIAGONAL_FRACTIONS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_ON LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_OFF LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_ON LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_OFF LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_ON LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_OFF LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_ON LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_OFF LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_ON LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_OFF LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_ON LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_OFF LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_ON LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_OFF LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_ON LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_OFF LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_ON LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_OFF LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_ON LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_OFF LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_ON LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_OFF LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_ON LAYOUT_FEATURE_SELECTOR_EXPONENTS_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_OFF LAYOUT_FEATURE_SELECTOR_EXPONENTS_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_ON LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_OFF LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_ORNAMENTS LAYOUT_FEATURE_SELECTOR_NO_ORNAMENTS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DINGBATS LAYOUT_FEATURE_SELECTOR_DINGBATS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PI_CHARACTERS LAYOUT_FEATURE_SELECTOR_PI_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_FLEURONS LAYOUT_FEATURE_SELECTOR_FLEURONS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DECORATIVE_BORDERS LAYOUT_FEATURE_SELECTOR_DECORATIVE_BORDERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INTERNATIONAL_SYMBOLS LAYOUT_FEATURE_SELECTOR_INTERNATIONAL_SYMBOLS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_MATH_SYMBOLS LAYOUT_FEATURE_SELECTOR_MATH_SYMBOLS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_ALTERNATES LAYOUT_FEATURE_SELECTOR_NO_ALTERNATES}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL1 LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL1}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL2 LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL2}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL3 LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL3}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL4 LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL4}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL5 LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL5}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_STYLE_OPTIONS LAYOUT_FEATURE_SELECTOR_NO_STYLE_OPTIONS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DISPLAY_TEXT LAYOUT_FEATURE_SELECTOR_DISPLAY_TEXT}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ENGRAVED_TEXT LAYOUT_FEATURE_SELECTOR_ENGRAVED_TEXT}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ILLUMINATED_CAPS LAYOUT_FEATURE_SELECTOR_ILLUMINATED_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TITLING_CAPS LAYOUT_FEATURE_SELECTOR_TITLING_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TALL_CAPS LAYOUT_FEATURE_SELECTOR_TALL_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_CHARACTERS LAYOUT_FEATURE_SELECTOR_TRADITIONAL_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SIMPLIFIED_CHARACTERS LAYOUT_FEATURE_SELECTOR_SIMPLIFIED_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_JIS1978_CHARACTERS LAYOUT_FEATURE_SELECTOR_JIS1978_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_JIS1983_CHARACTERS LAYOUT_FEATURE_SELECTOR_JIS1983_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_JIS1990_CHARACTERS LAYOUT_FEATURE_SELECTOR_JIS1990_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_ONE LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_ONE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_TWO LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_TWO}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_THREE LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_THREE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FOUR LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FOUR}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FIVE LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FIVE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_EXPERT_CHARACTERS LAYOUT_FEATURE_SELECTOR_EXPERT_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_JIS2004_CHARACTERS LAYOUT_FEATURE_SELECTOR_JIS2004_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HOJO_CHARACTERS LAYOUT_FEATURE_SELECTOR_HOJO_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NLCCHARACTERS LAYOUT_FEATURE_SELECTOR_NLCCHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_NAMES_CHARACTERS LAYOUT_FEATURE_SELECTOR_TRADITIONAL_NAMES_CHARACTERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_NUMBERS LAYOUT_FEATURE_SELECTOR_LOWER_CASE_NUMBERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_NUMBERS LAYOUT_FEATURE_SELECTOR_UPPER_CASE_NUMBERS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_TEXT LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_TEXT}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_TEXT LAYOUT_FEATURE_SELECTOR_MONOSPACED_TEXT}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_TEXT LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_TEXT}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_TEXT LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_TEXT}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_TEXT LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_TEXT}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALT_PROPORTIONAL_TEXT LAYOUT_FEATURE_SELECTOR_ALT_PROPORTIONAL_TEXT}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALT_HALF_WIDTH_TEXT LAYOUT_FEATURE_SELECTOR_ALT_HALF_WIDTH_TEXT}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_TRANSLITERATION LAYOUT_FEATURE_SELECTOR_NO_TRANSLITERATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HIRAGANA_TO_KATAKANA LAYOUT_FEATURE_SELECTOR_HIRAGANA_TO_KATAKANA}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_KATAKANA_TO_HIRAGANA LAYOUT_FEATURE_SELECTOR_KATAKANA_TO_HIRAGANA}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_KANA_TO_ROMANIZATION LAYOUT_FEATURE_SELECTOR_KANA_TO_ROMANIZATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_HIRAGANA LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_HIRAGANA}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_KATAKANA LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_KATAKANA}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_ONE LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_ONE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_TWO LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_TWO}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_THREE LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_THREE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_ANNOTATION LAYOUT_FEATURE_SELECTOR_NO_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_BOX_ANNOTATION LAYOUT_FEATURE_SELECTOR_BOX_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ROUNDED_BOX_ANNOTATION LAYOUT_FEATURE_SELECTOR_ROUNDED_BOX_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CIRCLE_ANNOTATION LAYOUT_FEATURE_SELECTOR_CIRCLE_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INVERTED_CIRCLE_ANNOTATION LAYOUT_FEATURE_SELECTOR_INVERTED_CIRCLE_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PARENTHESIS_ANNOTATION LAYOUT_FEATURE_SELECTOR_PARENTHESIS_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PERIOD_ANNOTATION LAYOUT_FEATURE_SELECTOR_PERIOD_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ROMAN_NUMERAL_ANNOTATION LAYOUT_FEATURE_SELECTOR_ROMAN_NUMERAL_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DIAMOND_ANNOTATION LAYOUT_FEATURE_SELECTOR_DIAMOND_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INVERTED_BOX_ANNOTATION LAYOUT_FEATURE_SELECTOR_INVERTED_BOX_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_INVERTED_ROUNDED_BOX_ANNOTATION LAYOUT_FEATURE_SELECTOR_INVERTED_ROUNDED_BOX_ANNOTATION}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_KANA LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_KANA}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_KANA LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_KANA}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_IDEOGRAPHS LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_IDEOGRAPHS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_IDEOGRAPHS LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_IDEOGRAPHS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_IDEOGRAPHS LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_IDEOGRAPHS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_ON LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_OFF LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_ON LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_OFF LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_ON LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_OFF LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_RUBY_KANA LAYOUT_FEATURE_SELECTOR_NO_RUBY_KANA}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA LAYOUT_FEATURE_SELECTOR_RUBY_KANA}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_CJK_SYMBOL_ALTERNATIVES LAYOUT_FEATURE_SELECTOR_NO_CJK_SYMBOL_ALTERNATIVES}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_ONE LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_ONE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_TWO LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_TWO}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_THREE LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_THREE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FOUR LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FOUR}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FIVE LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FIVE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_IDEOGRAPHIC_ALTERNATIVES LAYOUT_FEATURE_SELECTOR_NO_IDEOGRAPHIC_ALTERNATIVES}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_ONE LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_ONE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_TWO LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_TWO}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_THREE LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_THREE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FOUR LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FOUR}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FIVE LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FIVE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_CENTERED LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_CENTERED}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_HBASELINE LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_HBASELINE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_CJK_ITALIC_ROMAN LAYOUT_FEATURE_SELECTOR_NO_CJK_ITALIC_ROMAN}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_ON LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_OFF LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_ON LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_OFF LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_ON LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_OFF LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_ON LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_OFF LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_STYLISTIC_ALTERNATES LAYOUT_FEATURE_SELECTOR_NO_STYLISTIC_ALTERNATES}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_ON LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_OFF LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_ON LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_OFF LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_ON LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_OFF LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_ON LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_ON}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_OFF LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_OFF}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DEFAULT_LOWER_CASE LAYOUT_FEATURE_SELECTOR_DEFAULT_LOWER_CASE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_SMALL_CAPS LAYOUT_FEATURE_SELECTOR_LOWER_CASE_SMALL_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_PETITE_CAPS LAYOUT_FEATURE_SELECTOR_LOWER_CASE_PETITE_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DEFAULT_UPPER_CASE LAYOUT_FEATURE_SELECTOR_DEFAULT_UPPER_CASE}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_SMALL_CAPS LAYOUT_FEATURE_SELECTOR_UPPER_CASE_SMALL_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_PETITE_CAPS LAYOUT_FEATURE_SELECTOR_UPPER_CASE_PETITE_CAPS}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_CJK_ROMAN LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_CJK_ROMAN}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_CJK_ROMAN LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_CJK_ROMAN}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_DEFAULT_CJK_ROMAN LAYOUT_FEATURE_SELECTOR_DEFAULT_CJK_ROMAN}</li>
     * <li>{@link #HB_ATT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_CJK_ROMAN LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_CJK_ROMAN}</li>
     * </ul>
     */
    public static final int
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INVALID                         = 0xFFFF,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_ON            = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_OFF           = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_ON           = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_OFF          = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_ON             = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_OFF            = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_ON               = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_OFF              = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LOGOS_ON                        = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LOGOS_OFF                       = 7,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_ON               = 8,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_OFF              = 9,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_ON          = 10,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_OFF         = 11,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_ON            = 12,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_OFF           = 13,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_ON     = 14,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_OFF    = 15,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_ON             = 16,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_OFF            = 17,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_ON         = 18,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_OFF        = 19,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_ON         = 20,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_OFF        = 21,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_UNCONNECTED                     = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PARTIALLY_CONNECTED             = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CURSIVE                         = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_UPPER_AND_LOWER_CASE            = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALL_CAPS                        = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALL_LOWER_CASE                  = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SMALL_CAPS                      = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS                    = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS_AND_SMALL_CAPS     = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_ON    = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_OFF   = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_ON     = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_OFF    = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_NUMBERS              = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_NUMBERS            = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_NUMBERS             = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_NUMBERS           = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_ON         = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_OFF        = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_ON           = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_OFF          = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_ON         = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_OFF        = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_ON           = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_OFF          = 7,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_ON            = 8,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_OFF           = 9,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SHOW_DIACRITICS                 = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HIDE_DIACRITICS                 = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DECOMPOSE_DIACRITICS            = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NORMAL_POSITION                 = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SUPERIORS                       = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INFERIORS                       = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ORDINALS                        = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SCIENTIFIC_INFERIORS            = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_FRACTIONS                    = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_VERTICAL_FRACTIONS              = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DIAGONAL_FRACTIONS              = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_ON              = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_OFF             = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_ON           = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_OFF          = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_ON            = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_OFF           = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_ON                 = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_OFF                = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_ON             = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_OFF            = 7,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_ON                 = 8,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_OFF                = 9,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_ON          = 10,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_OFF         = 11,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_ON              = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_OFF             = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_ON         = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_OFF        = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_ON              = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_OFF             = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_ON         = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_OFF        = 7,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_ON                    = 8,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_OFF                   = 9,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_ON           = 10,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_OFF          = 11,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_ORNAMENTS                    = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DINGBATS                        = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PI_CHARACTERS                   = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_FLEURONS                        = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DECORATIVE_BORDERS              = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INTERNATIONAL_SYMBOLS           = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_MATH_SYMBOLS                    = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_ALTERNATES                   = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL1                   = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL2                   = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL3                   = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL4                   = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL5                   = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_STYLE_OPTIONS                = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DISPLAY_TEXT                    = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ENGRAVED_TEXT                   = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ILLUMINATED_CAPS                = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TITLING_CAPS                    = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TALL_CAPS                       = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_CHARACTERS          = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SIMPLIFIED_CHARACTERS           = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_JIS1978_CHARACTERS              = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_JIS1983_CHARACTERS              = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_JIS1990_CHARACTERS              = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_ONE             = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_TWO             = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_THREE           = 7,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FOUR            = 8,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FIVE            = 9,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_EXPERT_CHARACTERS               = 10,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_JIS2004_CHARACTERS              = 11,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HOJO_CHARACTERS                 = 12,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NLCCHARACTERS                   = 13,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_NAMES_CHARACTERS    = 14,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_NUMBERS              = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_NUMBERS              = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_TEXT               = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_TEXT                 = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_TEXT                 = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_TEXT                = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_TEXT              = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALT_PROPORTIONAL_TEXT           = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALT_HALF_WIDTH_TEXT             = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_TRANSLITERATION              = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL                 = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HIRAGANA_TO_KATAKANA            = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_KATAKANA_TO_HIRAGANA            = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_KANA_TO_ROMANIZATION            = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_HIRAGANA        = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_KATAKANA        = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_ONE         = 7,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_TWO         = 8,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_THREE       = 9,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_ANNOTATION                   = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_BOX_ANNOTATION                  = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ROUNDED_BOX_ANNOTATION          = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CIRCLE_ANNOTATION               = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INVERTED_CIRCLE_ANNOTATION      = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PARENTHESIS_ANNOTATION          = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PERIOD_ANNOTATION               = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ROMAN_NUMERAL_ANNOTATION        = 7,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DIAMOND_ANNOTATION              = 8,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INVERTED_BOX_ANNOTATION         = 9,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_INVERTED_ROUNDED_BOX_ANNOTATION = 10,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_KANA                 = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_KANA               = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_IDEOGRAPHS           = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_IDEOGRAPHS         = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_IDEOGRAPHS           = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_ON        = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_OFF       = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_ON    = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_OFF   = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_ON      = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_OFF     = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_RUBY_KANA                    = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA                       = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON                    = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF                   = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_CJK_SYMBOL_ALTERNATIVES      = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_ONE              = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_TWO              = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_THREE            = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FOUR             = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FIVE             = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_IDEOGRAPHIC_ALTERNATIVES     = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_ONE             = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_TWO             = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_THREE           = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FOUR            = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FIVE            = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_CENTERED     = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_HBASELINE    = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_CJK_ITALIC_ROMAN             = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN                = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON             = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF            = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_ON        = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_OFF       = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_ON       = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_OFF      = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_ON         = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_OFF        = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_ON          = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_OFF         = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_NO_STYLISTIC_ALTERNATES         = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_ON            = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_OFF           = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_ON            = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_OFF           = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_ON          = 6,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_OFF         = 7,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_ON           = 8,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_OFF          = 9,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_ON           = 10,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_OFF          = 11,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_ON            = 12,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_OFF           = 13,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_ON          = 14,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_OFF         = 15,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_ON          = 16,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_OFF         = 17,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_ON           = 18,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_OFF          = 19,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_ON            = 20,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_OFF           = 21,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_ON         = 22,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_OFF        = 23,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_ON         = 24,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_OFF        = 25,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_ON       = 26,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_OFF      = 27,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_ON       = 28,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_OFF      = 29,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_ON        = 30,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_OFF       = 31,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_ON        = 32,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_OFF       = 33,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_ON      = 34,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_OFF     = 35,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_ON       = 36,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_OFF      = 37,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_ON       = 38,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_OFF      = 39,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_ON         = 40,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_OFF        = 41,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_ON        = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_OFF       = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_ON             = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_OFF            = 3,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_ON  = 4,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_OFF = 5,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DEFAULT_LOWER_CASE              = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_SMALL_CAPS           = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_PETITE_CAPS          = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DEFAULT_UPPER_CASE              = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_SMALL_CAPS           = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_PETITE_CAPS          = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_CJK_ROMAN            = 0,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_CJK_ROMAN          = 1,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_DEFAULT_CJK_ROMAN               = 2,
        HB_ATT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_CJK_ROMAN            = 3;

    /**
     * Used when getting or setting AAT feature selectors.
     * 
     * <p>Indicates that there is no selector index corresponding to the selector of interest.</p>
     */
    public static final int HB_ATT_LAYOUT_NO_SELECTOR_INDEX = 0xFFFF;

    protected AAT() {
        throw new UnsupportedOperationException();
    }

    // --- [ hb_att_layout_get_feature_types ] ---

    public static int nhb_att_layout_get_feature_types(long face, int start_offset, long feature_count, long features) {
        long __functionAddress = Functions.layout_get_feature_types;
        if (CHECKS) {
            check(face);
        }
        return invokePPPI(face, start_offset, feature_count, features, __functionAddress);
    }

    @NativeType("unsigned int")
    public static int hb_att_layout_get_feature_types(@NativeType("hb_face_t *") long face, @NativeType("unsigned int") int start_offset, @NativeType("unsigned int *") @Nullable IntBuffer feature_count, @NativeType("hb_aat_layout_feature_type_t *") @Nullable IntBuffer features) {
        if (CHECKS) {
            checkSafe(feature_count, 1);
            if (feature_count != null) { checkSafe(features, feature_count.get(feature_count.position())); }
        }
        return nhb_att_layout_get_feature_types(face, start_offset, memAddressSafe(feature_count), memAddressSafe(features));
    }

    // --- [ hb_att_layout_feature_type_get_name_id ] ---

    @NativeType("hb_ot_name_id_t")
    public static int hb_att_layout_feature_type_get_name_id(@NativeType("hb_face_t *") long face, @NativeType("hb_aat_layout_feature_type_t") int feature_type) {
        long __functionAddress = Functions.layout_feature_type_get_name_id;
        if (CHECKS) {
            check(face);
        }
        return invokePI(face, feature_type, __functionAddress);
    }

    // --- [ hb_att_layout_feature_type_get_selector_infos ] ---

    public static int nhb_att_layout_feature_type_get_selector_infos(long face, int feature_type, int start_offset, long selector_count, long selectors, long default_index) {
        long __functionAddress = Functions.layout_feature_type_get_selector_infos;
        if (CHECKS) {
            check(face);
        }
        return invokePPPPI(face, feature_type, start_offset, selector_count, selectors, default_index, __functionAddress);
    }

    @NativeType("unsigned int")
    public static int hb_att_layout_feature_type_get_selector_infos(@NativeType("hb_face_t *") long face, @NativeType("hb_aat_layout_feature_type_t") int feature_type, @NativeType("unsigned int") int start_offset, @NativeType("unsigned int *") @Nullable IntBuffer selector_count, @NativeType("hb_aat_layout_feature_selector_info_t *") hb_aat_layout_feature_selector_info_t.@Nullable Buffer selectors, @NativeType("unsigned int *") @Nullable IntBuffer default_index) {
        if (CHECKS) {
            checkSafe(selector_count, 1);
            if (selector_count != null) { checkSafe(selectors, selector_count.get(selector_count.position())); }
            checkSafe(default_index, 1);
        }
        return nhb_att_layout_feature_type_get_selector_infos(face, feature_type, start_offset, memAddressSafe(selector_count), memAddressSafe(selectors), memAddressSafe(default_index));
    }

    // --- [ hb_att_layout_has_substitution ] ---

    @NativeType("hb_bool_t")
    public static boolean hb_att_layout_has_substitution(@NativeType("hb_face_t *") long face) {
        long __functionAddress = Functions.layout_has_substitution;
        if (CHECKS) {
            check(face);
        }
        return invokePI(face, __functionAddress) != 0;
    }

    // --- [ hb_att_layout_has_positioning ] ---

    @NativeType("hb_bool_t")
    public static boolean hb_att_layout_has_positioning(@NativeType("hb_face_t *") long face) {
        long __functionAddress = Functions.layout_has_positioning;
        if (CHECKS) {
            check(face);
        }
        return invokePI(face, __functionAddress) != 0;
    }

    // --- [ hb_att_layout_has_tracking ] ---

    @NativeType("hb_bool_t")
    public static boolean hb_att_layout_has_tracking(@NativeType("hb_face_t *") long face) {
        long __functionAddress = Functions.layout_has_tracking;
        if (CHECKS) {
            check(face);
        }
        return invokePI(face, __functionAddress) != 0;
    }

}