/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 */
package egl.templates

import egl.*
import org.lwjgl.generator.*

val EXT_gl_colorspace_scrgb = "EXTGLColorspaceSCRGB".nativeClassEGL("EXT_gl_colorspace_scrgb", postfix = EXT) {
    documentation =
        """
        Native bindings to the $registryLink extension.

        This extension provides an extended sRGB (also called scRGB) color space option for applications to choose from when creating an {@code EGLSurface}.
        This extension defines the non-linear display referred scRGB color space. It has the same white point and color primaries as sRGB, and thus is
        backward-compatible with sRGB. Refer to the IEC 61966-2-2:2003 standard for details on scRGB color space.

        This extension chooses to use floating-point formats for scRGB color space. For each color channel, the floating-point values of 0.0 and 1.0 still
        correspond to sRGB chromaticities and luminance levels. However, scRGB space allows for color values beyond the range of {@code [0.0, 1.0]}, and can
        thus achieve a larger color volume than that of sRGB. As it is display referred, scRGB space makes assumptions of how the floating-point color values
        should map to luminance levels by the underlying display pipeline. The expected mapping is such that a color value of {@code (1.0, 1.0, 1.0)}
        corresponds to a luminance level of 80 nits on a standardized studio monitor. As the color value per channel goes beyond 1.0 and up to ~7.83, the
        corresponding luminance levels also increase to a maximum of 10000 nits.

        The application is responsible for applying the sRGB transfer function to color values written to or read from a surface with a colorspace of
        {@code EGL_EXT_gl_colorspace_scrgb}.

        Requires ${KHR_gl_colorspace.link} and ${EXT_pixel_format_float.link}.
        """

    IntConstant(
        "Accepted as attribute values for #GL_COLORSPACE by #CreateWindowSurface(), #CreatePbufferSurface() and #CreatePixmapSurface().",

        "GL_COLORSPACE_SCRGB_EXT"..0x3351
    )
}