/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.system.linux.liburing;

import org.jspecify.annotations.*;

import java.nio.*;

import org.lwjgl.*;
import org.lwjgl.system.*;

import static org.lwjgl.system.Checks.*;
import static org.lwjgl.system.MemoryUtil.*;
import static org.lwjgl.system.MemoryStack.*;

/**
 * <h3>Layout</h3>
 * 
 * <pre><code>
 * struct io_uring_cq {
 *     unsigned * khead;
 *     unsigned * ktail;
 *     unsigned * {@link #kring_mask};
 *     unsigned * {@link #kring_entries};
 *     unsigned * kflags;
 *     unsigned * koverflow;
 *     {@link IOURingCQE struct io_uring_cqe} * cqes;
 *     size_t ring_sz;
 *     void * ring_ptr;
 *     unsigned ring_mask;
 *     unsigned ring_entries;
 *     unsigned int pad[2];
 * }</code></pre>
 */
@NativeType("struct io_uring_cq")
public class IOURingCQ extends Struct<IOURingCQ> implements NativeResource {

    /** The struct size in bytes. */
    public static final int SIZEOF;

    /** The struct alignment in bytes. */
    public static final int ALIGNOF;

    /** The struct member offsets. */
    public static final int
        KHEAD,
        KTAIL,
        KRING_MASK,
        KRING_ENTRIES,
        KFLAGS,
        KOVERFLOW,
        CQES,
        RING_SZ,
        RING_PTR,
        RING_MASK,
        RING_ENTRIES,
        PAD;

    static {
        Layout layout = __struct(
            __member(POINTER_SIZE),
            __member(POINTER_SIZE),
            __member(POINTER_SIZE),
            __member(POINTER_SIZE),
            __member(POINTER_SIZE),
            __member(POINTER_SIZE),
            __member(POINTER_SIZE),
            __member(POINTER_SIZE),
            __member(POINTER_SIZE),
            __member(4),
            __member(4),
            __array(4, 2)
        );

        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();

        KHEAD = layout.offsetof(0);
        KTAIL = layout.offsetof(1);
        KRING_MASK = layout.offsetof(2);
        KRING_ENTRIES = layout.offsetof(3);
        KFLAGS = layout.offsetof(4);
        KOVERFLOW = layout.offsetof(5);
        CQES = layout.offsetof(6);
        RING_SZ = layout.offsetof(7);
        RING_PTR = layout.offsetof(8);
        RING_MASK = layout.offsetof(9);
        RING_ENTRIES = layout.offsetof(10);
        PAD = layout.offsetof(11);
    }

    protected IOURingCQ(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected IOURingCQ create(long address, @Nullable ByteBuffer container) {
        return new IOURingCQ(address, container);
    }

    /**
     * Creates a {@code IOURingCQ} instance at the current position of the specified {@link ByteBuffer} container. Changes to the buffer's content will be
     * visible to the struct instance and vice versa.
     *
     * <p>The created instance holds a strong reference to the container object.</p>
     */
    public IOURingCQ(ByteBuffer container) {
        super(memAddress(container), __checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() { return SIZEOF; }

    /**
     * @return a {@link IntBuffer} view of the data pointed to by the {@code khead} field.
     *
     * @param capacity the number of elements in the returned buffer
     */
    @NativeType("unsigned *")
    public IntBuffer khead(int capacity) { return nkhead(address(), capacity); }
    /**
     * @return a {@link IntBuffer} view of the data pointed to by the {@code ktail} field.
     *
     * @param capacity the number of elements in the returned buffer
     */
    @NativeType("unsigned *")
    public IntBuffer ktail(int capacity) { return nktail(address(), capacity); }
    /**
     * @param capacity the number of elements in the returned buffer
     *
     * @return Deprecated: use {@code ring_mask} instead of {@code *kring_mask}
     */
    @NativeType("unsigned *")
    public IntBuffer kring_mask(int capacity) { return nkring_mask(address(), capacity); }
    /**
     * @param capacity the number of elements in the returned buffer
     *
     * @return Deprecated: use {@code ring_entries} instead of {@code *kring_entries}
     */
    @NativeType("unsigned *")
    public IntBuffer kring_entries(int capacity) { return nkring_entries(address(), capacity); }
    /**
     * @return a {@link IntBuffer} view of the data pointed to by the {@code kflags} field.
     *
     * @param capacity the number of elements in the returned buffer
     */
    @NativeType("unsigned *")
    public IntBuffer kflags(int capacity) { return nkflags(address(), capacity); }
    /**
     * @return a {@link IntBuffer} view of the data pointed to by the {@code koverflow} field.
     *
     * @param capacity the number of elements in the returned buffer
     */
    @NativeType("unsigned *")
    public IntBuffer koverflow(int capacity) { return nkoverflow(address(), capacity); }
    /** @return a {@link IOURingCQE} view of the struct pointed to by the {@code cqes} field. */
    @NativeType("struct io_uring_cqe *")
    public IOURingCQE cqes() { return ncqes(address()); }
    /** @return the value of the {@code ring_sz} field. */
    @NativeType("size_t")
    public long ring_sz() { return nring_sz(address()); }
    /** @return a {@link ByteBuffer} view of the data pointed to by the {@code ring_ptr} field. */
    @NativeType("void *")
    public ByteBuffer ring_ptr() { return nring_ptr(address()); }
    /** @return the value of the {@code ring_mask} field. */
    @NativeType("unsigned")
    public int ring_mask() { return nring_mask(address()); }
    /** @return the value of the {@code ring_entries} field. */
    @NativeType("unsigned")
    public int ring_entries() { return nring_entries(address()); }

    /** Sets the address of the specified {@link IntBuffer} to the {@code khead} field. */
    public IOURingCQ khead(@NativeType("unsigned *") IntBuffer value) { nkhead(address(), value); return this; }
    /** Sets the address of the specified {@link IntBuffer} to the {@code ktail} field. */
    public IOURingCQ ktail(@NativeType("unsigned *") IntBuffer value) { nktail(address(), value); return this; }
    /** Sets the address of the specified {@link IntBuffer} to the {@link #kring_mask} field. */
    public IOURingCQ kring_mask(@NativeType("unsigned *") IntBuffer value) { nkring_mask(address(), value); return this; }
    /** Sets the address of the specified {@link IntBuffer} to the {@link #kring_entries} field. */
    public IOURingCQ kring_entries(@NativeType("unsigned *") IntBuffer value) { nkring_entries(address(), value); return this; }
    /** Sets the address of the specified {@link IntBuffer} to the {@code kflags} field. */
    public IOURingCQ kflags(@NativeType("unsigned *") IntBuffer value) { nkflags(address(), value); return this; }
    /** Sets the address of the specified {@link IntBuffer} to the {@code koverflow} field. */
    public IOURingCQ koverflow(@NativeType("unsigned *") IntBuffer value) { nkoverflow(address(), value); return this; }
    /** Sets the address of the specified {@link IOURingCQE} to the {@code cqes} field. */
    public IOURingCQ cqes(@NativeType("struct io_uring_cqe *") IOURingCQE value) { ncqes(address(), value); return this; }
    /** Sets the address of the specified {@link ByteBuffer} to the {@code ring_ptr} field. */
    public IOURingCQ ring_ptr(@NativeType("void *") ByteBuffer value) { nring_ptr(address(), value); return this; }
    /** Sets the specified value to the {@code ring_mask} field. */
    public IOURingCQ ring_mask(@NativeType("unsigned") int value) { nring_mask(address(), value); return this; }
    /** Sets the specified value to the {@code ring_entries} field. */
    public IOURingCQ ring_entries(@NativeType("unsigned") int value) { nring_entries(address(), value); return this; }

    /** Initializes this struct with the specified values. */
    public IOURingCQ set(
        IntBuffer khead,
        IntBuffer ktail,
        IntBuffer kring_mask,
        IntBuffer kring_entries,
        IntBuffer kflags,
        IntBuffer koverflow,
        IOURingCQE cqes,
        ByteBuffer ring_ptr,
        int ring_mask,
        int ring_entries
    ) {
        khead(khead);
        ktail(ktail);
        kring_mask(kring_mask);
        kring_entries(kring_entries);
        kflags(kflags);
        koverflow(koverflow);
        cqes(cqes);
        ring_ptr(ring_ptr);
        ring_mask(ring_mask);
        ring_entries(ring_entries);

        return this;
    }

    /**
     * Copies the specified struct data to this struct.
     *
     * @param src the source struct
     *
     * @return this struct
     */
    public IOURingCQ set(IOURingCQ src) {
        memCopy(src.address(), address(), SIZEOF);
        return this;
    }

    // -----------------------------------

    /** Returns a new {@code IOURingCQ} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed. */
    public static IOURingCQ malloc() {
        return new IOURingCQ(nmemAllocChecked(SIZEOF), null);
    }

    /** Returns a new {@code IOURingCQ} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed. */
    public static IOURingCQ calloc() {
        return new IOURingCQ(nmemCallocChecked(1, SIZEOF), null);
    }

    /** Returns a new {@code IOURingCQ} instance allocated with {@link BufferUtils}. */
    public static IOURingCQ create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingCQ(memAddress(container), container);
    }

    /** Returns a new {@code IOURingCQ} instance for the specified memory address. */
    public static IOURingCQ create(long address) {
        return new IOURingCQ(address, null);
    }

    /** Like {@link #create(long) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    public static @Nullable IOURingCQ createSafe(long address) {
        return address == NULL ? null : new IOURingCQ(address, null);
    }

    /**
     * Returns a new {@link IOURingCQ.Buffer} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static IOURingCQ.Buffer malloc(int capacity) {
        return new Buffer(nmemAllocChecked(__checkMalloc(capacity, SIZEOF)), capacity);
    }

    /**
     * Returns a new {@link IOURingCQ.Buffer} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static IOURingCQ.Buffer calloc(int capacity) {
        return new Buffer(nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    /**
     * Returns a new {@link IOURingCQ.Buffer} instance allocated with {@link BufferUtils}.
     *
     * @param capacity the buffer capacity
     */
    public static IOURingCQ.Buffer create(int capacity) {
        ByteBuffer container = __create(capacity, SIZEOF);
        return new Buffer(memAddress(container), container, -1, 0, capacity, capacity);
    }

    /**
     * Create a {@link IOURingCQ.Buffer} instance at the specified memory.
     *
     * @param address  the memory address
     * @param capacity the buffer capacity
     */
    public static IOURingCQ.Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    /** Like {@link #create(long, int) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    public static IOURingCQ.@Nullable Buffer createSafe(long address, int capacity) {
        return address == NULL ? null : new Buffer(address, capacity);
    }

    /**
     * Returns a new {@code IOURingCQ} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack the stack from which to allocate
     */
    public static IOURingCQ malloc(MemoryStack stack) {
        return new IOURingCQ(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    /**
     * Returns a new {@code IOURingCQ} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack the stack from which to allocate
     */
    public static IOURingCQ calloc(MemoryStack stack) {
        return new IOURingCQ(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    /**
     * Returns a new {@link IOURingCQ.Buffer} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static IOURingCQ.Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    /**
     * Returns a new {@link IOURingCQ.Buffer} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static IOURingCQ.Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    // -----------------------------------

    /** Unsafe version of {@link #khead(int) khead}. */
    public static IntBuffer nkhead(long struct, int capacity) { return memIntBuffer(memGetAddress(struct + IOURingCQ.KHEAD), capacity); }
    /** Unsafe version of {@link #ktail(int) ktail}. */
    public static IntBuffer nktail(long struct, int capacity) { return memIntBuffer(memGetAddress(struct + IOURingCQ.KTAIL), capacity); }
    /** Unsafe version of {@link #kring_mask(int) kring_mask}. */
    public static IntBuffer nkring_mask(long struct, int capacity) { return memIntBuffer(memGetAddress(struct + IOURingCQ.KRING_MASK), capacity); }
    /** Unsafe version of {@link #kring_entries(int) kring_entries}. */
    public static IntBuffer nkring_entries(long struct, int capacity) { return memIntBuffer(memGetAddress(struct + IOURingCQ.KRING_ENTRIES), capacity); }
    /** Unsafe version of {@link #kflags(int) kflags}. */
    public static IntBuffer nkflags(long struct, int capacity) { return memIntBuffer(memGetAddress(struct + IOURingCQ.KFLAGS), capacity); }
    /** Unsafe version of {@link #koverflow(int) koverflow}. */
    public static IntBuffer nkoverflow(long struct, int capacity) { return memIntBuffer(memGetAddress(struct + IOURingCQ.KOVERFLOW), capacity); }
    /** Unsafe version of {@link #cqes}. */
    public static IOURingCQE ncqes(long struct) { return IOURingCQE.create(memGetAddress(struct + IOURingCQ.CQES)); }
    /** Unsafe version of {@link #ring_sz}. */
    public static long nring_sz(long struct) { return memGetAddress(struct + IOURingCQ.RING_SZ); }
    /** Unsafe version of {@link #ring_ptr() ring_ptr}. */
    public static ByteBuffer nring_ptr(long struct) { return memByteBuffer(memGetAddress(struct + IOURingCQ.RING_PTR), (int)nring_sz(struct)); }
    /** Unsafe version of {@link #ring_mask}. */
    public static int nring_mask(long struct) { return memGetInt(struct + IOURingCQ.RING_MASK); }
    /** Unsafe version of {@link #ring_entries}. */
    public static int nring_entries(long struct) { return memGetInt(struct + IOURingCQ.RING_ENTRIES); }
    public static IntBuffer npad(long struct) { return memIntBuffer(struct + IOURingCQ.PAD, 2); }
    public static int npad(long struct, int index) {
        return memGetInt(struct + IOURingCQ.PAD + check(index, 2) * 4);
    }

    /** Unsafe version of {@link #khead(IntBuffer) khead}. */
    public static void nkhead(long struct, IntBuffer value) { memPutAddress(struct + IOURingCQ.KHEAD, memAddress(value)); }
    /** Unsafe version of {@link #ktail(IntBuffer) ktail}. */
    public static void nktail(long struct, IntBuffer value) { memPutAddress(struct + IOURingCQ.KTAIL, memAddress(value)); }
    /** Unsafe version of {@link #kring_mask(IntBuffer) kring_mask}. */
    public static void nkring_mask(long struct, IntBuffer value) { memPutAddress(struct + IOURingCQ.KRING_MASK, memAddress(value)); }
    /** Unsafe version of {@link #kring_entries(IntBuffer) kring_entries}. */
    public static void nkring_entries(long struct, IntBuffer value) { memPutAddress(struct + IOURingCQ.KRING_ENTRIES, memAddress(value)); }
    /** Unsafe version of {@link #kflags(IntBuffer) kflags}. */
    public static void nkflags(long struct, IntBuffer value) { memPutAddress(struct + IOURingCQ.KFLAGS, memAddress(value)); }
    /** Unsafe version of {@link #koverflow(IntBuffer) koverflow}. */
    public static void nkoverflow(long struct, IntBuffer value) { memPutAddress(struct + IOURingCQ.KOVERFLOW, memAddress(value)); }
    /** Unsafe version of {@link #cqes(IOURingCQE) cqes}. */
    public static void ncqes(long struct, IOURingCQE value) { memPutAddress(struct + IOURingCQ.CQES, value.address()); }
    /** Sets the specified value to the {@code ring_sz} field of the specified {@code struct}. */
    public static void nring_sz(long struct, long value) { memPutAddress(struct + IOURingCQ.RING_SZ, value); }
    /** Unsafe version of {@link #ring_ptr(ByteBuffer) ring_ptr}. */
    public static void nring_ptr(long struct, ByteBuffer value) { memPutAddress(struct + IOURingCQ.RING_PTR, memAddress(value)); nring_sz(struct, value.remaining()); }
    /** Unsafe version of {@link #ring_mask(int) ring_mask}. */
    public static void nring_mask(long struct, int value) { memPutInt(struct + IOURingCQ.RING_MASK, value); }
    /** Unsafe version of {@link #ring_entries(int) ring_entries}. */
    public static void nring_entries(long struct, int value) { memPutInt(struct + IOURingCQ.RING_ENTRIES, value); }
    public static void npad(long struct, IntBuffer value) {
        if (CHECKS) { checkGT(value, 2); }
        memCopy(memAddress(value), struct + IOURingCQ.PAD, value.remaining() * 4);
    }
    public static void npad(long struct, int index, int value) {
        memPutInt(struct + IOURingCQ.PAD + check(index, 2) * 4, value);
    }

    /**
     * Validates pointer members that should not be {@code NULL}.
     *
     * @param struct the struct to validate
     */
    public static void validate(long struct) {
        check(memGetAddress(struct + IOURingCQ.KHEAD));
        check(memGetAddress(struct + IOURingCQ.KTAIL));
        check(memGetAddress(struct + IOURingCQ.KRING_MASK));
        check(memGetAddress(struct + IOURingCQ.KRING_ENTRIES));
        check(memGetAddress(struct + IOURingCQ.KFLAGS));
        check(memGetAddress(struct + IOURingCQ.KOVERFLOW));
        check(memGetAddress(struct + IOURingCQ.CQES));
        check(memGetAddress(struct + IOURingCQ.RING_PTR));
    }

    // -----------------------------------

    /** An array of {@link IOURingCQ} structs. */
    public static class Buffer extends StructBuffer<IOURingCQ, Buffer> implements NativeResource {

        private static final IOURingCQ ELEMENT_FACTORY = IOURingCQ.create(-1L);

        /**
         * Creates a new {@code IOURingCQ.Buffer} instance backed by the specified container.
         *
         * <p>Changes to the container's content will be visible to the struct buffer instance and vice versa. The two buffers' position, limit, and mark values
         * will be independent. The new buffer's position will be zero, its capacity and its limit will be the number of bytes remaining in this buffer divided
         * by {@link IOURingCQ#SIZEOF}, and its mark will be undefined.</p>
         *
         * <p>The created buffer instance holds a strong reference to the container object.</p>
         */
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected IOURingCQ getElementFactory() {
            return ELEMENT_FACTORY;
        }

        /**
         * @return a {@link IntBuffer} view of the data pointed to by the {@code khead} field.
         *
         * @param capacity the number of elements in the returned buffer
         */
        @NativeType("unsigned *")
        public IntBuffer khead(int capacity) { return IOURingCQ.nkhead(address(), capacity); }
        /**
         * @return a {@link IntBuffer} view of the data pointed to by the {@code ktail} field.
         *
         * @param capacity the number of elements in the returned buffer
         */
        @NativeType("unsigned *")
        public IntBuffer ktail(int capacity) { return IOURingCQ.nktail(address(), capacity); }
        /**
         * @return a {@link IntBuffer} view of the data pointed to by the {@link IOURingCQ#kring_mask} field.
         *
         * @param capacity the number of elements in the returned buffer
         */
        @NativeType("unsigned *")
        public IntBuffer kring_mask(int capacity) { return IOURingCQ.nkring_mask(address(), capacity); }
        /**
         * @return a {@link IntBuffer} view of the data pointed to by the {@link IOURingCQ#kring_entries} field.
         *
         * @param capacity the number of elements in the returned buffer
         */
        @NativeType("unsigned *")
        public IntBuffer kring_entries(int capacity) { return IOURingCQ.nkring_entries(address(), capacity); }
        /**
         * @return a {@link IntBuffer} view of the data pointed to by the {@code kflags} field.
         *
         * @param capacity the number of elements in the returned buffer
         */
        @NativeType("unsigned *")
        public IntBuffer kflags(int capacity) { return IOURingCQ.nkflags(address(), capacity); }
        /**
         * @return a {@link IntBuffer} view of the data pointed to by the {@code koverflow} field.
         *
         * @param capacity the number of elements in the returned buffer
         */
        @NativeType("unsigned *")
        public IntBuffer koverflow(int capacity) { return IOURingCQ.nkoverflow(address(), capacity); }
        /** @return a {@link IOURingCQE} view of the struct pointed to by the {@code cqes} field. */
        @NativeType("struct io_uring_cqe *")
        public IOURingCQE cqes() { return IOURingCQ.ncqes(address()); }
        /** @return the value of the {@code ring_sz} field. */
        @NativeType("size_t")
        public long ring_sz() { return IOURingCQ.nring_sz(address()); }
        /** @return a {@link ByteBuffer} view of the data pointed to by the {@code ring_ptr} field. */
        @NativeType("void *")
        public ByteBuffer ring_ptr() { return IOURingCQ.nring_ptr(address()); }
        /** @return the value of the {@code ring_mask} field. */
        @NativeType("unsigned")
        public int ring_mask() { return IOURingCQ.nring_mask(address()); }
        /** @return the value of the {@code ring_entries} field. */
        @NativeType("unsigned")
        public int ring_entries() { return IOURingCQ.nring_entries(address()); }

        /** Sets the address of the specified {@link IntBuffer} to the {@code khead} field. */
        public IOURingCQ.Buffer khead(@NativeType("unsigned *") IntBuffer value) { IOURingCQ.nkhead(address(), value); return this; }
        /** Sets the address of the specified {@link IntBuffer} to the {@code ktail} field. */
        public IOURingCQ.Buffer ktail(@NativeType("unsigned *") IntBuffer value) { IOURingCQ.nktail(address(), value); return this; }
        /** Sets the address of the specified {@link IntBuffer} to the {@link IOURingCQ#kring_mask} field. */
        public IOURingCQ.Buffer kring_mask(@NativeType("unsigned *") IntBuffer value) { IOURingCQ.nkring_mask(address(), value); return this; }
        /** Sets the address of the specified {@link IntBuffer} to the {@link IOURingCQ#kring_entries} field. */
        public IOURingCQ.Buffer kring_entries(@NativeType("unsigned *") IntBuffer value) { IOURingCQ.nkring_entries(address(), value); return this; }
        /** Sets the address of the specified {@link IntBuffer} to the {@code kflags} field. */
        public IOURingCQ.Buffer kflags(@NativeType("unsigned *") IntBuffer value) { IOURingCQ.nkflags(address(), value); return this; }
        /** Sets the address of the specified {@link IntBuffer} to the {@code koverflow} field. */
        public IOURingCQ.Buffer koverflow(@NativeType("unsigned *") IntBuffer value) { IOURingCQ.nkoverflow(address(), value); return this; }
        /** Sets the address of the specified {@link IOURingCQE} to the {@code cqes} field. */
        public IOURingCQ.Buffer cqes(@NativeType("struct io_uring_cqe *") IOURingCQE value) { IOURingCQ.ncqes(address(), value); return this; }
        /** Sets the address of the specified {@link ByteBuffer} to the {@code ring_ptr} field. */
        public IOURingCQ.Buffer ring_ptr(@NativeType("void *") ByteBuffer value) { IOURingCQ.nring_ptr(address(), value); return this; }
        /** Sets the specified value to the {@code ring_mask} field. */
        public IOURingCQ.Buffer ring_mask(@NativeType("unsigned") int value) { IOURingCQ.nring_mask(address(), value); return this; }
        /** Sets the specified value to the {@code ring_entries} field. */
        public IOURingCQ.Buffer ring_entries(@NativeType("unsigned") int value) { IOURingCQ.nring_entries(address(), value); return this; }

    }

}