# Contribute

## Introduction

First, thank you for considering contributing to LWJGL!

We welcome any type of contribution, not only code. You can help with 
- **QA**: file bug reports, the more details you can give the better
- **Marketing**: writing blog posts, guides, tweets ...
- **Community**: presenting the project at meetups or conventions, ...
- **Code**: take a look at the [open issues](https://github.com/LWJGL/lwjgl3/issues). Even if you can't write code, commenting on them, showing that you care about a given issue matters. It helps us triage them.
- **Money**: we welcome financial contributions in full transparency on our [open collective](https://opencollective.com/lwjgl).

## Your First Contribution

Working on your first Pull Request? You can learn how from this *free* series, [How to Contribute to an Open Source Project on GitHub](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github).

## Submitting code

Any code change should be submitted as a pull request. The description should explain what the code does and give steps to execute it.

## Code review process

The bigger the pull request, the longer it will take to review and merge. Try to break down large pull requests in smaller chunks that are easier to review and merge.
It is also always helpful to have some context for your pull request. What was the purpose? Why does it matter to you?

## Financial contributions

We also welcome financial contributions in full transparency on our [open collective](https://opencollective.com/lwjgl).
Anyone can file an expense. If the expense makes sense for the development of the community, it will be "merged" in the ledger of our open collective by the core contributors and the person who filed the expense will be reimbursed.

## Questions

If you have any questions, create an [issue](https://github.com/LWJGL/lwjgl3/issues) (protip: do a quick search first to see if someone else didn't ask the same question before!).
You can also reach us at the LWJGL [forum](http://forum.lwjgl.org/) and [slack](http://slack.lwjgl.org/) team.

<!-- This `CONTRIBUTING.md` is based on @nayafia's template https://github.com/nayafia/contributing-template -->