/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.data.DefaultKeyedValue;
import com.orsoncharts.data.KeyedValue;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class DefaultKeyedValues<T>
implements KeyedValues<T>,
Serializable {
    private List<KeyedValue<T>> data;

    public DefaultKeyedValues() {
        this(new ArrayList());
    }

    public DefaultKeyedValues(List<Comparable<?>> keys) {
        ArgChecks.nullNotPermitted(keys, "keys");
        this.data = new ArrayList<KeyedValue<T>>();
        for (Comparable<?> key : keys) {
            this.data.add(new DefaultKeyedValue<Object>(key, null));
        }
    }

    public void clear() {
        this.data.clear();
    }

    public void put(Comparable<?> key, T value) {
        ArgChecks.nullNotPermitted(key, "key");
        int index = this.getIndex(key);
        if (index >= 0) {
            DefaultKeyedValue dkv = (DefaultKeyedValue)this.data.get(index);
            dkv.setValue(value);
        } else {
            this.data.add(new DefaultKeyedValue<T>(key, value));
        }
    }

    public void remove(Comparable<?> key) {
        ArgChecks.nullNotPermitted(key, "key");
        int index = this.getIndex(key);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        this.data.remove(index);
    }

    @Override
    public Comparable<?> getKey(int index) {
        KeyedValue<T> kv = this.data.get(index);
        return kv.getKey();
    }

    @Override
    public int getIndex(Comparable<?> key) {
        ArgChecks.nullNotPermitted(key, "key");
        for (int i = 0; i < this.data.size(); ++i) {
            KeyedValue<T> kv = this.data.get(i);
            if (!kv.getKey().equals(key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Comparable<?>> getKeys() {
        ArrayList keys = new ArrayList();
        for (KeyedValue<T> kv : this.data) {
            keys.add(kv.getKey());
        }
        return keys;
    }

    @Override
    public T getValue(Comparable<?> key) {
        int index = this.getIndex(key);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public int getItemCount() {
        return this.data.size();
    }

    @Override
    public T getValue(int item) {
        KeyedValue<T> kv = this.data.get(item);
        return kv.getValue();
    }

    @Override
    public double getDoubleValue(int item) {
        T n = this.getValue(item);
        if (n != null && n instanceof Number) {
            return ((Number)n).doubleValue();
        }
        return Double.NaN;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyedValues)) {
            return false;
        }
        DefaultKeyedValues that = (DefaultKeyedValues)obj;
        return this.data.equals(that.data);
    }
}

