/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.utilities;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import org.apache.commons.lang3.tuple.Pair;
import org.imgscalr.Scalr;

public class WatermarkGenerator {
    public static BufferedImage watermark(BufferedImage originalImage, BufferedImage watermarkImage, String position, double watermarkSizeMaxPercentage, int marginX, int marginY) throws IOException {
        int imageWidth = originalImage.getWidth();
        int imageHeight = originalImage.getHeight();
        int watermarkWidth = WatermarkGenerator.getWatermarkWidth(originalImage, watermarkImage, watermarkSizeMaxPercentage);
        int watermarkHeight = WatermarkGenerator.getWatermarkHeight(originalImage, watermarkImage, watermarkSizeMaxPercentage);
        BufferedImage bufferedImage = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.drawImage((Image)originalImage, 0, 0, null);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = 0;
        int y = 0;
        marginX = marginX * originalImage.getWidth() / 100;
        marginY = marginY * originalImage.getHeight() / 100;
        if (position != null) {
            switch (position) {
                case "north_west": {
                    x = 0 + marginX;
                    y = 0 + marginY;
                    break;
                }
                case "north": {
                    x = imageWidth / 2 - watermarkWidth / 2;
                    y = 0 + marginY;
                    break;
                }
                case "north_east": {
                    x = imageWidth - watermarkWidth - marginX;
                    y = 0 + marginY;
                    break;
                }
                case "west": {
                    x = 0 + marginX;
                    y = imageHeight / 2 - watermarkHeight / 2;
                    break;
                }
                case "center": {
                    x = imageWidth / 2 - watermarkWidth / 2;
                    y = imageHeight / 2 - watermarkHeight / 2;
                    break;
                }
                case "east": {
                    x = imageWidth - watermarkWidth - marginX;
                    y = imageHeight / 2 - watermarkHeight / 2;
                    break;
                }
                case "south_west": {
                    x = 0 + marginX;
                    y = imageHeight - watermarkHeight - marginY;
                    break;
                }
                case "south": {
                    x = imageWidth / 2 - watermarkWidth / 2;
                    y = imageHeight - watermarkHeight - marginY;
                    break;
                }
                case "south_east": {
                    x = imageWidth - watermarkWidth - marginX;
                    y = imageHeight - watermarkHeight - marginY;
                    break;
                }
            }
        }
        g2d.drawImage((Image)Scalr.resize((BufferedImage)watermarkImage, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)watermarkWidth, (int)watermarkHeight, (BufferedImageOp[])new BufferedImageOp[0]), x, y, null);
        return bufferedImage;
    }

    private static Pair<Double, Double> calculateWatermarkDimensions(BufferedImage originalImage, BufferedImage watermarkImage, double maxPercentage) {
        double aspectRatio;
        double imageWidth = originalImage.getWidth();
        double imageHeight = originalImage.getHeight();
        double maxWatermarkWidth = imageWidth / 100.0 * maxPercentage;
        double maxWatermarkHeight = imageHeight / 100.0 * maxPercentage;
        double watermarkWidth = watermarkImage.getWidth();
        double watermarkHeight = watermarkImage.getHeight();
        if (watermarkWidth > maxWatermarkWidth) {
            aspectRatio = watermarkWidth / watermarkHeight;
            watermarkWidth = maxWatermarkWidth;
            watermarkHeight = watermarkWidth / aspectRatio;
        }
        if (watermarkHeight > maxWatermarkHeight) {
            aspectRatio = watermarkWidth / watermarkHeight;
            watermarkHeight = maxWatermarkHeight;
            watermarkWidth = watermarkHeight / aspectRatio;
        }
        return Pair.of((Object)watermarkWidth, (Object)watermarkHeight);
    }

    private static int getWatermarkWidth(BufferedImage originalImage, BufferedImage watermarkImage, double maxPercentage) {
        return ((Double)WatermarkGenerator.calculateWatermarkDimensions(originalImage, watermarkImage, maxPercentage).getLeft()).intValue();
    }

    private static int getWatermarkHeight(BufferedImage originalImage, BufferedImage watermarkImage, double maxPercentage) {
        return ((Double)WatermarkGenerator.calculateWatermarkDimensions(originalImage, watermarkImage, maxPercentage).getRight()).intValue();
    }

    public static BufferedImage addTextWatermark(String text, int opacity, Color color, Font font, String position, BufferedImage sourceImage, int marginX, int marginY) {
        BufferedImage returnImage = sourceImage;
        double fontScaleFactor = 1.0;
        fontScaleFactor = returnImage.getHeight() > returnImage.getWidth() ? (double)returnImage.getWidth() / 500.0 : (double)returnImage.getHeight() / 500.0;
        font = new Font(font.getName(), font.getStyle(), (int)((double)font.getSize() * fontScaleFactor));
        Graphics2D g2d = (Graphics2D)returnImage.getGraphics();
        AlphaComposite alphaChannel = AlphaComposite.getInstance(3, (float)opacity / 100.0f);
        g2d.setComposite(alphaChannel);
        g2d.setColor(color);
        g2d.setFont(font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds(text, g2d);
        int width = fontMetrics.stringWidth(text);
        int centerX = 0;
        int centerY = 0;
        marginX = marginX * returnImage.getWidth() / 100;
        marginY = marginY * returnImage.getHeight() / 100;
        if (position != null) {
            switch (position) {
                case "north_west": {
                    centerX = 0 + marginX;
                    centerY = fontMetrics.getHeight() + marginY;
                    break;
                }
                case "north": {
                    centerX = (sourceImage.getWidth() - (int)rect.getWidth()) / 2;
                    centerY = fontMetrics.getHeight() + marginY;
                    break;
                }
                case "north_east": {
                    centerX = sourceImage.getWidth() - (int)rect.getWidth() - marginX;
                    centerY = fontMetrics.getHeight() + marginY;
                    break;
                }
                case "west": {
                    centerX = 0 + marginX;
                    centerY = sourceImage.getHeight() / 2;
                    break;
                }
                case "center": {
                    centerX = (sourceImage.getWidth() - (int)rect.getWidth()) / 2;
                    centerY = sourceImage.getHeight() / 2;
                    break;
                }
                case "east": {
                    centerX = sourceImage.getWidth() - (int)rect.getWidth() - marginX;
                    centerY = sourceImage.getHeight() / 2;
                    break;
                }
                case "south_west": {
                    centerX = 0 + marginX;
                    centerY = sourceImage.getHeight() - marginY;
                    break;
                }
                case "south": {
                    centerX = (sourceImage.getWidth() - (int)rect.getWidth()) / 2;
                    centerY = sourceImage.getHeight() - marginY;
                    break;
                }
                case "south_east": {
                    centerX = sourceImage.getWidth() - (int)rect.getWidth() - marginX;
                    centerY = sourceImage.getHeight() - marginY;
                    break;
                }
            }
        }
        g2d.drawString(text, centerX, centerY);
        g2d.dispose();
        System.out.println("The tex watermark is added to the image.");
        return returnImage;
    }
}

