/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.utilities;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PrintJob
implements Printable {
    private static PrintJob instance;
    private PrinterJob job = PrinterJob.getPrinterJob();
    private PageFormat pageFormat;
    private BufferedImage image;
    private String imagePath;

    public PrinterJob getJob() {
        return this.job;
    }

    public void setJob(PrinterJob job) {
        this.job = job;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void printImage(String imagePath) {
        this.imagePath = imagePath;
        try {
            this.image = ImageIO.read(new File(imagePath));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            this.job.print();
        }
        catch (PrinterException ex) {
            ex.printStackTrace();
        }
    }

    private PrintJob() {
        this.job.setPrintable(this);
    }

    public Printable getOuter() {
        return this;
    }

    public void setUpPrinter() {
        this.job.printDialog();
    }

    public static PrintJob getInstance() {
        if (instance == null) {
            instance = new PrintJob();
        }
        return instance;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g = (Graphics2D)graphics;
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        }
        return 0;
    }
}

