/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.photobooth;

import com.freebooth.utilities.PathCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import say.swing.JFontChooser;

public class WatermarkPanel
extends JPanel {
    Preferences prefs;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JSpinner jSpinner3;
    private JSpinner jSpinner4;
    private JTextField jTextField2;
    private JToggleButton positionCenterButton;
    private JToggleButton positionEastButton;
    private JToggleButton positionNorthButton;
    private JToggleButton positionNorthEastButton;
    private JToggleButton positionNorthWestButton;
    private JToggleButton positionSouthButton;
    private JToggleButton positionSouthEastButton;
    private JToggleButton positionSouthWestButton;
    private JToggleButton positionWestButton;

    public WatermarkPanel() {
        this.initComponents();
        this.prefs = Preferences.userNodeForPackage(WatermarkPanel.class);
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (WatermarkPanel.this.jCheckBox1.isSelected()) {
                    WatermarkPanel.this.prefs.put("watermark", "true");
                    String position = WatermarkPanel.this.prefs.get("watermark_position", "center");
                    WatermarkPanel.this.enableOneButton(position);
                    WatermarkPanel.this.jComboBox1.setEnabled(true);
                    WatermarkPanel.this.positionNorthWestButton.setEnabled(true);
                    WatermarkPanel.this.positionNorthButton.setEnabled(true);
                    WatermarkPanel.this.positionNorthEastButton.setEnabled(true);
                    WatermarkPanel.this.positionWestButton.setEnabled(true);
                    WatermarkPanel.this.positionSouthWestButton.setEnabled(true);
                    WatermarkPanel.this.positionCenterButton.setEnabled(true);
                    WatermarkPanel.this.positionSouthButton.setEnabled(true);
                    WatermarkPanel.this.positionEastButton.setEnabled(true);
                    WatermarkPanel.this.positionSouthEastButton.setEnabled(true);
                    WatermarkPanel.this.jSpinner3.setEnabled(true);
                    WatermarkPanel.this.jSpinner4.setEnabled(true);
                    if (WatermarkPanel.this.jComboBox1.getSelectedItem().toString().equals("Text")) {
                        WatermarkPanel.this.jTextField2.setEnabled(true);
                        WatermarkPanel.this.jButton2.setEnabled(true);
                        WatermarkPanel.this.jButton1.setEnabled(false);
                        WatermarkPanel.this.jButton3.setEnabled(true);
                        WatermarkPanel.this.jSpinner1.setEnabled(false);
                        WatermarkPanel.this.jSpinner2.setEnabled(true);
                    } else {
                        WatermarkPanel.this.jButton1.setEnabled(true);
                        WatermarkPanel.this.jTextField2.setEnabled(false);
                        WatermarkPanel.this.jButton2.setEnabled(false);
                        WatermarkPanel.this.jButton3.setEnabled(false);
                        WatermarkPanel.this.jSpinner1.setEnabled(true);
                    }
                } else {
                    WatermarkPanel.this.disableAll();
                    WatermarkPanel.this.prefs.put("watermark", "false");
                }
            }
        });
        this.jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                WatermarkPanel.this.prefs.put("watermark_text", WatermarkPanel.this.jTextField2.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                WatermarkPanel.this.prefs.put("watermark_text", WatermarkPanel.this.jTextField2.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                WatermarkPanel.this.prefs.put("watermark_text", WatermarkPanel.this.jTextField2.getText());
            }
        });
        this.jSpinner2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Integer.parseInt(WatermarkPanel.this.jSpinner2.getValue().toString()) < 1) {
                    WatermarkPanel.this.jSpinner2.setValue(new Integer(1));
                }
                if (Integer.parseInt(WatermarkPanel.this.jSpinner2.getValue().toString()) > 100) {
                    WatermarkPanel.this.jSpinner2.setValue(new Integer(100));
                }
                WatermarkPanel.this.prefs.put("watermark_opacity", WatermarkPanel.this.jSpinner2.getValue().toString());
            }
        });
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Integer.parseInt(WatermarkPanel.this.jSpinner1.getValue().toString()) < 1) {
                    WatermarkPanel.this.jSpinner1.setValue(new Integer(1));
                }
                if (Integer.parseInt(WatermarkPanel.this.jSpinner1.getValue().toString()) > 100) {
                    WatermarkPanel.this.jSpinner1.setValue(new Integer(100));
                }
                WatermarkPanel.this.prefs.put("watermark_percentage", WatermarkPanel.this.jSpinner1.getValue().toString());
            }
        });
        this.jSpinner3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Integer.parseInt(WatermarkPanel.this.jSpinner1.getValue().toString()) < 0) {
                    WatermarkPanel.this.jSpinner3.setValue(new Integer(0));
                }
                if (Integer.parseInt(WatermarkPanel.this.jSpinner3.getValue().toString()) > 100) {
                    WatermarkPanel.this.jSpinner3.setValue(new Integer(100));
                }
                WatermarkPanel.this.prefs.put("watermark_margin_x", WatermarkPanel.this.jSpinner3.getValue().toString());
            }
        });
        this.jSpinner4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Integer.parseInt(WatermarkPanel.this.jSpinner4.getValue().toString()) < 0) {
                    WatermarkPanel.this.jSpinner4.setValue(new Integer(1));
                }
                if (Integer.parseInt(WatermarkPanel.this.jSpinner4.getValue().toString()) > 100) {
                    WatermarkPanel.this.jSpinner4.setValue(new Integer(100));
                }
                WatermarkPanel.this.prefs.put("watermark_margin_y", WatermarkPanel.this.jSpinner4.getValue().toString());
            }
        });
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (WatermarkPanel.this.jComboBox1.getSelectedItem().toString().equals("Text")) {
                    WatermarkPanel.this.jButton1.setEnabled(false);
                    WatermarkPanel.this.jTextField2.setEnabled(true);
                    WatermarkPanel.this.jButton2.setEnabled(true);
                    WatermarkPanel.this.jButton3.setEnabled(true);
                    WatermarkPanel.this.jSpinner2.setEnabled(true);
                    WatermarkPanel.this.prefs.put("watermark_type", "Text");
                    WatermarkPanel.this.jSpinner1.setEnabled(false);
                } else {
                    WatermarkPanel.this.jButton1.setEnabled(true);
                    WatermarkPanel.this.jTextField2.setEnabled(false);
                    WatermarkPanel.this.jButton2.setEnabled(false);
                    WatermarkPanel.this.jButton3.setEnabled(false);
                    WatermarkPanel.this.jSpinner2.setEnabled(false);
                    WatermarkPanel.this.jSpinner1.setEnabled(true);
                    WatermarkPanel.this.prefs.put("watermark_type", "Image");
                }
            }
        });
        boolean watermarkBool = Boolean.parseBoolean(this.prefs.get("watermark", "false"));
        this.enableOneButton(this.prefs.get("watermark_position", "center"));
        this.jTextField2.setText(this.prefs.get("watermark_text", "FreeBooth"));
        this.jComboBox1.setSelectedItem(this.prefs.get("watermark_type", "Text"));
        this.jSpinner2.setValue(Integer.parseInt(this.prefs.get("watermark_opacity", "0")));
        PathCreator pc = new PathCreator();
        this.jSpinner1.setValue(Integer.parseInt(this.prefs.get("watermark_percentage", "100")));
        this.jSpinner3.setValue(this.prefs.getInt("watermark_margin_x", 0));
        this.jSpinner4.setValue(this.prefs.getInt("watermark_margin_y", 0));
        this.jLabel5.setText(this.prefs.get("watermark_path", pc.getWebPath() + "watermark.png"));
        if (watermarkBool) {
            this.jCheckBox1.setSelected(true);
        } else {
            this.disableAll();
        }
        this.jLabel8.setFont(new Font(this.prefs.get("watermark_font_name", "Arial"), Integer.parseInt(this.prefs.get("watermark_font_style", Integer.toString(0))), 12));
        this.jLabel8.setText(this.prefs.get("watermark_font_name", "Arial") + " " + this.prefs.get("watermark_font_size", "12"));
        this.jLabel8.setForeground(Color.decode(this.prefs.get("watermark_text_color", "#000000")));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.positionNorthWestButton = new JToggleButton();
        this.positionNorthButton = new JToggleButton();
        this.positionNorthEastButton = new JToggleButton();
        this.positionWestButton = new JToggleButton();
        this.positionSouthWestButton = new JToggleButton();
        this.positionCenterButton = new JToggleButton();
        this.positionSouthButton = new JToggleButton();
        this.positionEastButton = new JToggleButton();
        this.positionSouthEastButton = new JToggleButton();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jSpinner2 = new JSpinner();
        this.jButton2 = new JButton();
        this.jLabel8 = new JLabel();
        this.jButton3 = new JButton();
        this.jLabel6 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jSpinner3 = new JSpinner();
        this.jSpinner4 = new JSpinner();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("properties/Bundle");
        this.jCheckBox1.setText(bundle.getString("WatermarkPanel.jCheckBox1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jLabel1.setText(bundle.getString("WatermarkPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.positionNorthWestButton.setIcon(new ImageIcon(this.getClass().getResource("/img/arrows/arrow_north_west.png")));
        this.positionNorthWestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.positionNorthWestButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 24;
        this.add((Component)this.positionNorthWestButton, gridBagConstraints);
        this.positionNorthButton.setIcon(new ImageIcon(this.getClass().getResource("/img/arrows/arrow_north.png")));
        this.positionNorthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.positionNorthButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 24;
        this.add((Component)this.positionNorthButton, gridBagConstraints);
        this.positionNorthEastButton.setIcon(new ImageIcon(this.getClass().getResource("/img/arrows/arrow_north_east.png")));
        this.positionNorthEastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.positionNorthEastButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.positionNorthEastButton, gridBagConstraints);
        this.positionWestButton.setIcon(new ImageIcon(this.getClass().getResource("/img/arrows/arrow_west.png")));
        this.positionWestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.positionWestButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 24;
        this.add((Component)this.positionWestButton, gridBagConstraints);
        this.positionSouthWestButton.setIcon(new ImageIcon(this.getClass().getResource("/img/arrows/arrow_south_west.png")));
        this.positionSouthWestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.positionSouthWestButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.positionSouthWestButton, gridBagConstraints);
        this.positionCenterButton.setIcon(new ImageIcon(this.getClass().getResource("/img/arrows/center.png")));
        this.positionCenterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.positionCenterButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 24;
        this.add((Component)this.positionCenterButton, gridBagConstraints);
        this.positionSouthButton.setIcon(new ImageIcon(this.getClass().getResource("/img/arrows/arrow_south.png")));
        this.positionSouthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.positionSouthButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 24;
        this.add((Component)this.positionSouthButton, gridBagConstraints);
        this.positionEastButton.setIcon(new ImageIcon(this.getClass().getResource("/img/arrows/arrow_east.png")));
        this.positionEastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.positionEastButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.positionEastButton, gridBagConstraints);
        this.positionSouthEastButton.setIcon(new ImageIcon(this.getClass().getResource("/img/arrows/arrow_south_east.png")));
        this.positionSouthEastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.positionSouthEastButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.positionSouthEastButton, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("WatermarkPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Text", "Image"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jComboBox1, gridBagConstraints);
        this.jLabel3.setText(bundle.getString("WatermarkPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(bundle.getString("WatermarkPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jButton1.setText(bundle.getString("WatermarkPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel5.setText(bundle.getString("WatermarkPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jTextField2, gridBagConstraints);
        this.jLabel7.setText(bundle.getString("WatermarkPanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jSpinner2, gridBagConstraints);
        this.jButton2.setText(bundle.getString("WatermarkPanel.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jButton2, gridBagConstraints);
        this.jLabel8.setText(bundle.getString("WatermarkPanel.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.jButton3.setText(bundle.getString("WatermarkPanel.jButton3.text"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatermarkPanel.this.jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jButton3, gridBagConstraints);
        this.jLabel6.setText(bundle.getString("WatermarkPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.jSpinner1, gridBagConstraints);
        this.jLabel9.setText(bundle.getString("WatermarkPanel.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText(bundle.getString("WatermarkPanel.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jSpinner3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jSpinner4, gridBagConstraints);
    }

    private void positionNorthButtonActionPerformed(ActionEvent evt) {
        this.savePosition("north");
    }

    private void positionNorthWestButtonActionPerformed(ActionEvent evt) {
        this.savePosition("north_west");
    }

    private void positionNorthEastButtonActionPerformed(ActionEvent evt) {
        this.savePosition("north_east");
    }

    private void positionWestButtonActionPerformed(ActionEvent evt) {
        this.savePosition("west");
    }

    private void positionCenterButtonActionPerformed(ActionEvent evt) {
        this.savePosition("center");
    }

    private void positionEastButtonActionPerformed(ActionEvent evt) {
        this.savePosition("east");
    }

    private void positionSouthWestButtonActionPerformed(ActionEvent evt) {
        this.savePosition("south_west");
    }

    private void positionSouthButtonActionPerformed(ActionEvent evt) {
        this.savePosition("south");
    }

    private void positionSouthEastButtonActionPerformed(ActionEvent evt) {
        this.savePosition("south_east");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(this.prefs.get("watermark_path", ""));
        fc.setFileSelectionMode(0);
        fc.showOpenDialog(this);
        if (fc.getSelectedFile() != null) {
            String path = fc.getSelectedFile().getAbsolutePath();
            this.prefs.put("watermark_path", path);
            this.jLabel5.setText(path);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        JFontChooser fontChooser = new JFontChooser();
        fontChooser.setSelectedFont(new Font(this.prefs.get("watermark_font_name", "Arial"), Integer.parseInt(this.prefs.get("watermark_font_style", Integer.toString(0))), Integer.parseInt(this.prefs.get("watermark_font_size", "12"))));
        int result = fontChooser.showDialog((Component)this);
        if (result == 0) {
            Font font = fontChooser.getSelectedFont();
            this.prefs.put("watermark_font_family", font.getFamily());
            this.prefs.put("watermark_font_name", font.getName());
            this.prefs.put("watermark_font_style", Integer.toString(font.getStyle()));
            this.prefs.put("watermark_font_size", Integer.toString(font.getSize()));
            System.out.println(font);
            this.jLabel8.setText(font.getFamily() + " " + font.getStyle() + " " + font.getSize());
            this.jLabel8.setFont(new Font(font.getName(), font.getStyle(), 12));
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, ResourceBundle.getBundle("properties/Bundle").getString("WatermarkPanel.jButton3.text"), this.jLabel8.getForeground());
        if (newColor != null) {
            String hexColor = Integer.toHexString(newColor.getRGB() & 0xFFFFFF);
            hexColor = "#" + hexColor;
            this.prefs.put("watermark_text_color", hexColor);
            this.jLabel8.setForeground(Color.decode(hexColor));
        }
    }

    private void savePosition(String position) {
        this.enableOneButton(position);
        this.prefs.put("watermark_position", position);
    }

    private void disableAll() {
        this.jComboBox1.setEnabled(false);
        this.positionNorthWestButton.setEnabled(false);
        this.positionNorthButton.setEnabled(false);
        this.positionNorthEastButton.setEnabled(false);
        this.positionWestButton.setEnabled(false);
        this.positionSouthWestButton.setEnabled(false);
        this.positionCenterButton.setEnabled(false);
        this.positionSouthButton.setEnabled(false);
        this.positionEastButton.setEnabled(false);
        this.positionSouthEastButton.setEnabled(false);
        this.jButton1.setEnabled(false);
        this.jTextField2.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.jSpinner2.setEnabled(false);
        this.jButton3.setEnabled(false);
        this.jSpinner1.setEnabled(false);
        this.jSpinner3.setEnabled(false);
        this.jSpinner4.setEnabled(false);
    }

    private void enableOneButton(String position) {
        this.positionNorthWestButton.setSelected(false);
        this.positionNorthButton.setSelected(false);
        this.positionNorthEastButton.setSelected(false);
        this.positionWestButton.setSelected(false);
        this.positionSouthWestButton.setSelected(false);
        this.positionCenterButton.setSelected(false);
        this.positionSouthButton.setSelected(false);
        this.positionEastButton.setSelected(false);
        this.positionSouthEastButton.setSelected(false);
        switch (position) {
            case "center": {
                this.positionCenterButton.setSelected(true);
                break;
            }
            case "north_west": {
                this.positionNorthWestButton.setSelected(true);
                break;
            }
            case "north": {
                this.positionNorthButton.setSelected(true);
                break;
            }
            case "north_east": {
                this.positionNorthEastButton.setSelected(true);
                break;
            }
            case "west": {
                this.positionWestButton.setSelected(true);
                break;
            }
            case "east": {
                this.positionEastButton.setSelected(true);
                break;
            }
            case "south_west": {
                this.positionSouthWestButton.setSelected(true);
                break;
            }
            case "south": {
                this.positionSouthButton.setSelected(true);
                break;
            }
            case "south_east": {
                this.positionSouthEastButton.setSelected(true);
                break;
            }
        }
    }
}

