/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.photobooth;

import com.freebooth.fileWatcher.ImageDecorator;
import com.freebooth.fileWatcher.PhotoboothFileWatcher;
import com.freebooth.fileWatcher.ThumbDecorator;
import com.freebooth.fileWatcher.WatermarkDecorator;
import com.freebooth.photobooth.OSKSaveDialog;
import com.freebooth.photobooth.Photobooth;
import com.freebooth.photobooth.PrintDialog;
import com.freebooth.photobooth.SaveDialog;
import com.freebooth.photobooth.StartFrame;
import com.freebooth.photobooth.WatermarkPanel;
import com.freebooth.utilities.AltTabStopper;
import com.freebooth.utilities.BILoader;
import com.freebooth.utilities.FileExistenceChecker;
import com.freebooth.utilities.PathCreator;
import com.freebooth.utilities.PrintJob;
import com.freebooth.utilities.StretchIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;
import jiconfont.IconCode;
import jiconfont.IconFont;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.coobird.thumbnailator.Thumbnails;

public class PhotoboothFrame
extends Photobooth {
    int actImageIndex;
    List<String> images;
    PathCreator pathcreator;
    String path;
    Thread tfw;
    AltTabStopper ats;
    Preferences prefs;
    List<JButton> buttonsList;
    private JLabel imageLabel;
    private JLabel imageNumber;
    private JButton nextButton;
    private JButton prevButton;
    private JButton printButton;
    private JButton sendButton;

    public PhotoboothFrame() {
        PrintJob printJob;
        Container parent;
        this.setUndecorated(true);
        this.initComponents();
        this.pathcreator = new PathCreator();
        this.buttonsList = new ArrayList<JButton>();
        this.buttonsList.add(this.printButton);
        this.buttonsList.add(this.sendButton);
        this.images = new CopyOnWriteArrayList<String>();
        this.actImageIndex = -1;
        this.prefs = Preferences.userNodeForPackage(PhotoboothFrame.class);
        for (JButton button : this.buttonsList) {
            button.setOpaque(true);
            button.setBackground(Color.decode(this.prefs.get("button_color", "#ED5E2F")));
            button.setForeground(Color.decode(this.prefs.get("button_foreground", "#ffffff")));
            Font font = button.getFont();
            button.setFont(new Font(font.getName(), font.getStyle(), this.prefs.getInt("button_font_size", 20)));
        }
        IconFontSwing.register((IconFont)FontAwesome.getIconFont());
        Icon icon = IconFontSwing.buildIcon((IconCode)FontAwesome.PRINT, (float)30.0f, (Color)Color.decode(this.prefs.get("button_foreground", "#ffffff")));
        this.printButton.setIcon(icon);
        Icon icon2 = IconFontSwing.buildIcon((IconCode)FontAwesome.ENVELOPE, (float)30.0f, (Color)Color.decode(this.prefs.get("button_foreground", "#ffffff")));
        this.sendButton.setIcon(icon2);
        this.imageLabel.setForeground(Color.decode(this.prefs.get("text_color", "#ffffff")));
        String dark = this.prefs.get("dark_icon", "");
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/img/next_small3" + dark + ".png")));
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/img/previous_small3" + dark + ".png")));
        this.getContentPane().setBackground(Color.decode(this.prefs.get("background_color", "#333333")));
        this.tfw = new Thread(new PhotoboothFileWatcher(this.pathcreator.getImagePath(), this, false));
        this.tfw.start();
        this.path = this.pathcreator.getImagePath();
        String labelText = this.imageLabel.getText();
        String[] lines = labelText.split("<br />");
        labelText = lines[0] + "<br />" + lines[1] + "<br />" + this.path + "<br />" + lines[2] + "<br />" + lines[3];
        this.imageLabel.setMaximumSize(new Dimension(this.prefs.getInt("image_width", 1400), this.prefs.getInt("image_height", 1400)));
        this.imageLabel.setMinimumSize(new Dimension(this.prefs.getInt("image_width", 1400), this.prefs.getInt("image_height", 1400)));
        this.imageLabel.setPreferredSize(new Dimension(this.prefs.getInt("image_width", 1400), this.prefs.getInt("image_height", 1400)));
        this.imageLabel.setText(labelText);
        System.out.println(this.path);
        File folder = new File(this.path);
        File[] listOfFiles = folder.listFiles();
        Preferences startPrefs = Preferences.userNodeForPackage(StartFrame.class);
        if (startPrefs.getBoolean("emailSharing", true) && !startPrefs.getBoolean("printing", false)) {
            parent = this.printButton.getParent();
            parent.remove(this.printButton);
            parent.revalidate();
            parent.repaint();
        } else if (!startPrefs.getBoolean("emailSharing", true) && !startPrefs.getBoolean("printing", false)) {
            parent = this.sendButton.getParent();
            parent.remove(this.sendButton);
            parent.revalidate();
            parent.repaint();
            parent.remove(this.printButton);
            parent.revalidate();
            parent.repaint();
        } else if (!startPrefs.getBoolean("emailSharing", true) && startPrefs.getBoolean("printing", false)) {
            printJob = PrintJob.getInstance();
            printJob.setPageFormat(printJob.getJob().pageDialog(printJob.getJob().defaultPage()));
            printJob.setUpPrinter();
            Container parent2 = this.sendButton.getParent();
            parent2.remove(this.sendButton);
            GridBagLayout layout = (GridBagLayout)parent2.getLayout();
            GridBagConstraints printButtonConstraints = layout.getConstraints(this.printButton);
            printButtonConstraints.gridwidth = 3;
            this.add((Component)this.printButton, printButtonConstraints);
            parent2.revalidate();
            parent2.repaint();
            this.revalidate();
            this.repaint();
        } else if (startPrefs.getBoolean("emailSharing", true) && startPrefs.getBoolean("printing", false)) {
            printJob = PrintJob.getInstance();
            printJob.setPageFormat(printJob.getJob().pageDialog(printJob.getJob().defaultPage()));
            printJob.setUpPrinter();
        }
        WatermarkDecorator decorator = new WatermarkDecorator(new ThumbDecorator(false));
        for (File file : listOfFiles) {
            File decoratedFile;
            boolean allFilesExist;
            if (file.isDirectory()) continue;
            String fileName = file.getName();
            String fileEnding = fileName.substring(fileName.lastIndexOf("."));
            boolean bl = allFilesExist = FileExistenceChecker.thumbExists(fileName) && FileExistenceChecker.watermarkExists(fileName);
            if (!file.isFile() || !fileEnding.equals(".jpg") && !fileEnding.equals(".JPG")) continue;
            if (allFilesExist) {
                decoratedFile = ((ImageDecorator)decorator).processImage(file, null);
            } else {
                BufferedImage image = BILoader.loadImage(this.path + File.separator + file.getName());
                decoratedFile = ((ImageDecorator)decorator).processImage(file, image);
            }
            this.images.add(decoratedFile.getName());
        }
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(39, 0), "Next");
        this.getRootPane().getActionMap().put("Next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoboothFrame.this.actImageIndex = PhotoboothFrame.this.actImageIndex == PhotoboothFrame.this.images.size() - 1 ? 0 : ++PhotoboothFrame.this.actImageIndex;
                PhotoboothFrame.this.updateImage();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(37, 0), "Prev");
        this.getRootPane().getActionMap().put("Prev", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoboothFrame.this.actImageIndex = PhotoboothFrame.this.actImageIndex == 0 ? PhotoboothFrame.this.images.size() - 1 : --PhotoboothFrame.this.actImageIndex;
                PhotoboothFrame.this.updateImage();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(33, 0), "First");
        this.getRootPane().getActionMap().put("First", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoboothFrame.this.actImageIndex = 0;
                PhotoboothFrame.this.updateImage();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(34, 0), "Last");
        this.getRootPane().getActionMap().put("Last", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoboothFrame.this.actImageIndex = PhotoboothFrame.this.images.size() - 1;
                PhotoboothFrame.this.updateImage();
            }
        });
        this.actImageIndex = this.images.size() - 1;
        this.updateImage();
        if (this.prefs.getBoolean("leavepw", false)) {
            this.ats = AltTabStopper.create(this);
        }
    }

    @Override
    public synchronized void addImage(String path) {
        this.images.add(path);
        if (!this.prefs.getBoolean("update_on_new_picture", false)) {
            this.actImageIndex = this.images.size() - 1;
        }
        this.updateImage();
    }

    @Override
    public synchronized void deleteImage(String path) {
        this.images.remove(path);
        this.actImageIndex = this.images.size() - 1;
        this.updateImage();
    }

    private void initComponents() {
        this.prevButton = new JButton();
        this.imageLabel = new JLabel();
        this.nextButton = new JButton();
        this.sendButton = new JButton();
        this.imageNumber = new JLabel();
        this.printButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setAutoRequestFocus(false);
        this.setCursor(new Cursor(0));
        this.setFocusable(false);
        this.setResizable(false);
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 10, 0, 10, 0, 10, 0};
        layout.rowHeights = new int[]{0, 10, 0, 10, 0};
        this.getContentPane().setLayout(layout);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/img/previous_small3.png")));
        this.prevButton.setBorderPainted(false);
        this.prevButton.setContentAreaFilled(false);
        this.prevButton.setEnabled(false);
        this.prevButton.setFocusable(false);
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoboothFrame.this.prevButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.getContentPane().add((Component)this.prevButton, gridBagConstraints);
        this.imageLabel.setFont(new Font("Noto Sans", 0, 18));
        this.imageLabel.setForeground(Color.white);
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/img/photobooth_start.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("properties/Bundle");
        this.imageLabel.setText(bundle.getString("PhotoboothFrame.imageLabel.text_1"));
        this.imageLabel.setHorizontalTextPosition(0);
        this.imageLabel.setIconTextGap(20);
        this.imageLabel.setMaximumSize(new Dimension(1400, 800));
        this.imageLabel.setMinimumSize(new Dimension(1400, 800));
        this.imageLabel.setName("");
        this.imageLabel.setPreferredSize(new Dimension(1400, 800));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 200.0;
        gridBagConstraints.weighty = 200.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.imageLabel, gridBagConstraints);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/img/next_small3.png")));
        this.nextButton.setToolTipText(bundle.getString("PhotoboothFrame.nextButton.toolTipText_1"));
        this.nextButton.setBorderPainted(false);
        this.nextButton.setContentAreaFilled(false);
        this.nextButton.setEnabled(false);
        this.nextButton.setFocusable(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoboothFrame.this.nextButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.getContentPane().add((Component)this.nextButton, gridBagConstraints);
        this.sendButton.setBackground(new Color(36, 42, 106));
        this.sendButton.setFont(new Font("Noto Sans", 0, 20));
        this.sendButton.setForeground(new Color(254, 254, 254));
        this.sendButton.setText(bundle.getString("PhotoboothFrame.sendButton.text_1"));
        this.sendButton.setBorder(new MatteBorder(null));
        this.sendButton.setBorderPainted(false);
        this.sendButton.setContentAreaFilled(false);
        this.sendButton.setEnabled(false);
        this.sendButton.setFocusPainted(false);
        this.sendButton.setMargin(new Insets(5, 5, 5, 5));
        this.sendButton.setMaximumSize(new Dimension(336, 50));
        this.sendButton.setMinimumSize(new Dimension(336, 50));
        this.sendButton.setOpaque(true);
        this.sendButton.setPreferredSize(new Dimension(336, 50));
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoboothFrame.this.sendButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 100, 0, 100);
        this.getContentPane().add((Component)this.sendButton, gridBagConstraints);
        this.imageNumber.setForeground(Color.white);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 26;
        this.getContentPane().add((Component)this.imageNumber, gridBagConstraints);
        this.printButton.setBackground(new Color(36, 42, 106));
        this.printButton.setFont(new Font("Noto Sans", 0, 20));
        this.printButton.setForeground(new Color(254, 254, 254));
        this.printButton.setText(bundle.getString("PhotoboothFrame.printButton.text"));
        this.printButton.setBorder(new MatteBorder(null));
        this.printButton.setBorderPainted(false);
        this.printButton.setContentAreaFilled(false);
        this.printButton.setEnabled(false);
        this.printButton.setFocusPainted(false);
        this.printButton.setMargin(new Insets(5, 5, 5, 5));
        this.printButton.setMaximumSize(new Dimension(336, 50));
        this.printButton.setMinimumSize(new Dimension(336, 50));
        this.printButton.setOpaque(true);
        this.printButton.setPreferredSize(new Dimension(336, 50));
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoboothFrame.this.printButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 100, 0, 100);
        this.getContentPane().add((Component)this.printButton, gridBagConstraints);
        this.pack();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.actImageIndex = this.actImageIndex == this.images.size() - 1 ? 0 : ++this.actImageIndex;
        this.updateImage();
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        this.actImageIndex = this.actImageIndex == 0 ? this.images.size() - 1 : --this.actImageIndex;
        this.updateImage();
    }

    public void showAsDisabled() {
        this.sendButton.setEnabled(false);
        this.printButton.setEnabled(false);
        this.imageLabel.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        this.getContentPane().setBackground(Color.GRAY);
    }

    public void showAsEnabled() {
        this.sendButton.setEnabled(true);
        this.printButton.setEnabled(true);
        this.imageLabel.setEnabled(true);
        this.nextButton.setEnabled(true);
        this.prevButton.setEnabled(true);
        Preferences prefs = Preferences.userNodeForPackage(PhotoboothFrame.class);
        this.getContentPane().setBackground(Color.decode(prefs.get("background_color", "#333333")));
    }

    private void printButtonActionPerformed(ActionEvent evt) {
        PrintDialog print = new PrintDialog((Frame)this, true);
        if (print.result) {
            String printPath = new PathCreator().getFullResPath() + this.images.get(this.actImageIndex);
            PrintJob.getInstance().printImage(printPath);
        }
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        this.showAsDisabled();
        if (!Preferences.userNodeForPackage(StartFrame.class).getBoolean("osk", false)) {
            SaveDialog sd = new SaveDialog((Frame)this, true, this.images.get(this.actImageIndex), this);
            sd.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    PhotoboothFrame.this.showAsEnabled();
                }
            });
        } else {
            OSKSaveDialog sd = new OSKSaveDialog((Frame)this, true, this.images.get(this.actImageIndex), this);
            sd.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    PhotoboothFrame.this.showAsEnabled();
                }
            });
        }
    }

    @Override
    public boolean close() {
        this.setVisible(false);
        this.dispose();
        this.tfw.interrupt();
        if (this.ats != null) {
            this.ats.stop();
        }
        return true;
    }

    public void updateImage() {
        if (this.actImageIndex != -1) {
            if (this.actImageIndex >= 0) {
                this.sendButton.setEnabled(true);
                this.printButton.setEnabled(true);
                this.showAsEnabled();
                this.imageLabel.setText("");
            }
            Object imgBI = null;
            String actPath = "";
            try {
                actPath = this.path + this.images.get(this.actImageIndex);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                System.out.println(this.images.toString());
            }
            Preferences prefsWatermark = Preferences.userNodeForPackage(WatermarkPanel.class);
            if (this.prefs.getBoolean("thumbnails", true) && new File(this.pathcreator.getThumbPath() + this.images.get(this.actImageIndex)).exists()) {
                actPath = this.pathcreator.getThumbPath() + this.images.get(this.actImageIndex);
            } else if (prefsWatermark.getBoolean("watermark", false) && new File(this.pathcreator.getWatermarkPath() + this.images.get(this.actImageIndex)).exists()) {
                actPath = this.pathcreator.getWatermarkPath() + this.images.get(this.actImageIndex);
            }
            BufferedImage bi = BILoader.loadImage(actPath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bi, "jpg", baos);
                baos.flush();
                byte[] imageInByte = baos.toByteArray();
                baos.close();
                StretchIcon si = new StretchIcon(imageInByte);
                this.imageLabel.setIcon(si);
                this.imageNumber.setText(this.actImageIndex + 1 + "/" + this.images.size());
            }
            catch (IOException ex) {
                Logger.getLogger(PhotoboothFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.prefs.getBoolean("thumbnails", true) && !new File(this.pathcreator.getThumbPath() + this.images.get(this.actImageIndex)).exists()) {
                try {
                    Thumbnails.of(this.pathcreator.getImagePath() + this.images.get(this.actImageIndex)).size(this.prefs.getInt("image_height", 800), this.prefs.getInt("image_width", 1400)).toFile(this.pathcreator.getThumbPath() + this.images.get(this.actImageIndex));
                }
                catch (IOException ex) {
                    Logger.getLogger(PhotoboothFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

