/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.photobooth;

import com.freebooth.fileWatcher.PhotoboothFileWatcher;
import com.freebooth.photobooth.Photobooth;
import com.freebooth.utilities.AltTabStopper;
import com.freebooth.utilities.BILoader;
import com.freebooth.utilities.PathCreator;
import com.freebooth.utilities.StretchIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.apache.commons.lang3.SystemUtils;

public class PhotoViewFrame
extends Photobooth {
    int actImageIndex;
    List<String> images;
    PathCreator pathcreator;
    Thread tfw;
    String path;
    AltTabStopper ats;
    Preferences prefs;
    private JLabel imageLabel;
    private JButton maxButton;

    public PhotoViewFrame() {
        this.initComponents();
        this.pathcreator = new PathCreator();
        this.images = new CopyOnWriteArrayList<String>();
        this.actImageIndex = -1;
        this.prefs = Preferences.userNodeForPackage(PhotoViewFrame.class);
        this.getContentPane().setBackground(Color.decode(this.prefs.get("background_color", "#333333")));
        this.tfw = new Thread(new PhotoboothFileWatcher(this.pathcreator.getImagePath(), this, true));
        this.tfw.start();
        this.path = this.pathcreator.getImagePath();
        String labelText = this.imageLabel.getText();
        String[] lines = labelText.split("<br />");
        labelText = lines[0] + "<br />" + lines[1] + "<br />" + this.path + "<br />" + lines[2] + "<br />" + lines[3];
        this.imageLabel.setMaximumSize(new Dimension(this.prefs.getInt("image_width", 1400), this.prefs.getInt("image_height", 1400)));
        this.imageLabel.setMinimumSize(new Dimension(this.prefs.getInt("image_width", 1400), this.prefs.getInt("image_height", 1400)));
        this.imageLabel.setPreferredSize(new Dimension(this.prefs.getInt("image_width", 1400), this.prefs.getInt("image_height", 1400)));
        this.imageLabel.setText(labelText);
        System.out.println(this.path);
        this.actImageIndex = -1;
        if (this.prefs.getBoolean("leavepw", false)) {
            this.ats = AltTabStopper.create(this);
        }
    }

    @Override
    public synchronized void addImage(String path) {
        this.images.add(path);
        this.actImageIndex = this.images.size() - 1;
        this.updateImage();
    }

    @Override
    public synchronized void deleteImage(String path) {
        this.images.remove(path);
        this.actImageIndex = this.images.size() - 1;
        this.updateImage();
    }

    private void initComponents() {
        this.imageLabel = new JLabel();
        this.maxButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setAutoRequestFocus(false);
        this.setCursor(new Cursor(0));
        this.setFocusable(false);
        this.setResizable(false);
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 10, 0, 10, 0, 10, 0};
        layout.rowHeights = new int[]{0, 10, 0, 10, 0};
        this.getContentPane().setLayout(layout);
        this.imageLabel.setFont(new Font("Noto Sans", 0, 18));
        this.imageLabel.setForeground(Color.white);
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/img/photobooth_start.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("properties/Bundle");
        this.imageLabel.setText(bundle.getString("PhotoViewFrame.imageLabel.text_1"));
        this.imageLabel.setHorizontalTextPosition(0);
        this.imageLabel.setIconTextGap(20);
        this.imageLabel.setMaximumSize(new Dimension(1400, 800));
        this.imageLabel.setMinimumSize(new Dimension(1400, 800));
        this.imageLabel.setName("");
        this.imageLabel.setPreferredSize(new Dimension(1400, 800));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 200.0;
        gridBagConstraints.weighty = 200.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.imageLabel, gridBagConstraints);
        this.maxButton.setText(bundle.getString("PhotoViewFrame.maxButton.text"));
        this.maxButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewFrame.this.maxButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.maxButton, gridBagConstraints);
        this.pack();
    }

    private void maxButtonActionPerformed(ActionEvent evt) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
            device.setFullScreenWindow(this);
        }
        this.maxButton.setVisible(false);
        this.setExtendedState(6);
        this.dispose();
        this.setUndecorated(true);
        this.setVisible(true);
    }

    @Override
    public boolean close() {
        this.setVisible(false);
        this.dispose();
        this.tfw.interrupt();
        if (this.ats != null) {
            this.ats.stop();
        }
        return true;
    }

    public void updateImage() {
        if (this.actImageIndex != -1) {
            if (this.actImageIndex >= 0) {
                this.imageLabel.setText("");
            }
            Object imgBI = null;
            String actPath = this.path + this.images.get(this.actImageIndex);
            BufferedImage bi = BILoader.loadImage(actPath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bi, "jpg", baos);
                baos.flush();
                byte[] imageInByte = baos.toByteArray();
                baos.close();
                StretchIcon si = new StretchIcon(imageInByte);
                this.imageLabel.setIcon(si);
            }
            catch (IOException ex) {
                Logger.getLogger(PhotoViewFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

