/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.photobooth;

import com.freebooth.fileWatcher.ImageDecorator;
import com.freebooth.fileWatcher.PhotoboothFileWatcher;
import com.freebooth.fileWatcher.ThumbDecorator;
import com.freebooth.fileWatcher.WatermarkDecorator;
import com.freebooth.photobooth.MultiSelectOSKSaveDialog;
import com.freebooth.photobooth.MultiSelectSaveDialog;
import com.freebooth.photobooth.Photobooth;
import com.freebooth.photobooth.StartFrame;
import com.freebooth.photobooth.WatermarkPanel;
import com.freebooth.utilities.AltTabStopper;
import com.freebooth.utilities.BILoader;
import com.freebooth.utilities.FileExistenceChecker;
import com.freebooth.utilities.PathCreator;
import com.freebooth.utilities.StretchIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;
import net.coobird.thumbnailator.Thumbnails;

public class MultiSelectPhotoboothFrame
extends Photobooth {
    int actImageIndex;
    List<String> images;
    List<String> selectedImages;
    Thread tfw;
    String path;
    Preferences prefs;
    AltTabStopper ats;
    private JButton cancelButton;
    private JLabel imageLabel;
    private JLabel imageNumber;
    private JButton nextButton;
    private JButton prevButton;
    private JButton selectButton;
    private JLabel selectedCounter;
    private JButton sendButton;

    public MultiSelectPhotoboothFrame() {
        this.setUndecorated(true);
        this.initComponents();
        this.images = new CopyOnWriteArrayList<String>();
        this.selectedImages = new ArrayList<String>();
        this.actImageIndex = -1;
        this.tfw = new Thread(new PhotoboothFileWatcher(new PathCreator().getImagePath(), this, false));
        this.tfw.start();
        this.prefs = Preferences.userNodeForPackage(MultiSelectPhotoboothFrame.class);
        Preferences prefsWatermark = Preferences.userNodeForPackage(WatermarkPanel.class);
        this.sendButton.setBackground(Color.GRAY);
        this.selectButton.setBackground(Color.decode(this.prefs.get("button_color", "#ED5E2F")));
        this.cancelButton.setBackground(Color.GRAY);
        this.getContentPane().setBackground(Color.decode(this.prefs.get("background_color", "#333333")));
        System.out.println(this.prefs.get("background_color", "#333333"));
        this.sendButton.setForeground(Color.LIGHT_GRAY);
        this.selectButton.setForeground(Color.decode(this.prefs.get("button_color", "#ffffff")));
        this.cancelButton.setForeground(Color.LIGHT_GRAY);
        this.imageLabel.setForeground(Color.decode(this.prefs.get("text_color", "#ffffff")));
        this.selectedCounter.setForeground(Color.decode(this.prefs.get("text_color", "#ffffff")));
        String dark = this.prefs.get("dark_icon", "");
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/img/next_small3" + dark + ".png")));
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/img/previous_small3" + dark + ".png")));
        ArrayList<JButton> buttonList = new ArrayList<JButton>();
        buttonList.add(this.sendButton);
        buttonList.add(this.cancelButton);
        buttonList.add(this.selectButton);
        for (JButton button : buttonList) {
            Font font = button.getFont();
            button.setFont(new Font(font.getName(), font.getStyle(), this.prefs.getInt("button_font_size", 20)));
        }
        this.path = new PathCreator().getImagePath();
        String labelText = this.imageLabel.getText();
        String[] lines = labelText.split("<br />");
        labelText = lines[0] + "<br />" + lines[1] + "<br />" + this.path + "<br />" + lines[2] + "<br />" + lines[3];
        this.imageLabel.setMaximumSize(new Dimension(this.prefs.getInt("image_width", 1400), this.prefs.getInt("image_height", 1400)));
        this.imageLabel.setMinimumSize(new Dimension(this.prefs.getInt("image_width", 1400), this.prefs.getInt("image_height", 1400)));
        this.imageLabel.setPreferredSize(new Dimension(this.prefs.getInt("image_width", 1400), this.prefs.getInt("image_height", 1400)));
        this.imageLabel.setText(labelText);
        System.out.println(this.path);
        File folder = new File(this.path);
        File[] listOfFiles = folder.listFiles();
        WatermarkDecorator decorator = new WatermarkDecorator(new ThumbDecorator(false));
        for (File file : listOfFiles) {
            File decoratedFile;
            boolean allFilesExist;
            if (file.isDirectory()) continue;
            String fileName = file.getName();
            String fileEnding = fileName.substring(fileName.lastIndexOf("."));
            boolean bl = allFilesExist = FileExistenceChecker.thumbExists(fileName) && FileExistenceChecker.watermarkExists(fileName);
            if (!file.isFile() || !fileEnding.equals(".jpg") && !fileEnding.equals(".JPG")) continue;
            if (allFilesExist) {
                decoratedFile = ((ImageDecorator)decorator).processImage(file, null);
            } else {
                BufferedImage image = BILoader.loadImage(this.path + File.separator + file.getName());
                decoratedFile = ((ImageDecorator)decorator).processImage(file, image);
            }
            this.images.add(decoratedFile.getName());
        }
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(39, 0), "Next");
        this.getRootPane().getActionMap().put("Next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectPhotoboothFrame.this.actImageIndex = MultiSelectPhotoboothFrame.this.actImageIndex == MultiSelectPhotoboothFrame.this.images.size() - 1 ? 0 : ++MultiSelectPhotoboothFrame.this.actImageIndex;
                MultiSelectPhotoboothFrame.this.updateImage();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(37, 0), "Prev");
        this.getRootPane().getActionMap().put("Prev", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectPhotoboothFrame.this.actImageIndex = MultiSelectPhotoboothFrame.this.actImageIndex == 0 ? MultiSelectPhotoboothFrame.this.images.size() - 1 : --MultiSelectPhotoboothFrame.this.actImageIndex;
                MultiSelectPhotoboothFrame.this.updateImage();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(33, 0), "First");
        this.getRootPane().getActionMap().put("First", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectPhotoboothFrame.this.actImageIndex = 0;
                MultiSelectPhotoboothFrame.this.updateImage();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(34, 0), "Last");
        this.getRootPane().getActionMap().put("Last", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectPhotoboothFrame.this.actImageIndex = MultiSelectPhotoboothFrame.this.images.size() - 1;
                MultiSelectPhotoboothFrame.this.updateImage();
            }
        });
        this.actImageIndex = this.images.size() - 1;
        this.updateImage();
        if (this.prefs.getBoolean("leavepw", false)) {
            this.ats = AltTabStopper.create(this);
        }
    }

    @Override
    public synchronized void addImage(String path) {
        this.images.add(path);
        if (!this.prefs.getBoolean("update_on_new_picture", false)) {
            this.actImageIndex = this.images.size() - 1;
            this.updateImage();
        }
    }

    @Override
    public synchronized void deleteImage(String path) {
        this.images.remove(path);
        this.actImageIndex = this.images.size() - 1;
        this.updateImage();
    }

    private void initComponents() {
        this.prevButton = new JButton();
        this.imageLabel = new JLabel();
        this.nextButton = new JButton();
        this.sendButton = new JButton();
        this.imageNumber = new JLabel();
        this.cancelButton = new JButton();
        this.selectButton = new JButton();
        this.selectedCounter = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setAutoRequestFocus(false);
        this.setCursor(new Cursor(0));
        this.setFocusable(false);
        this.setResizable(false);
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 10, 0, 10, 0, 10, 0, 10, 0};
        layout.rowHeights = new int[]{0, 10, 0, 10, 0};
        this.getContentPane().setLayout(layout);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/img/previous_small3.png")));
        this.prevButton.setBorderPainted(false);
        this.prevButton.setContentAreaFilled(false);
        this.prevButton.setEnabled(false);
        this.prevButton.setFocusable(false);
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiSelectPhotoboothFrame.this.prevButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.getContentPane().add((Component)this.prevButton, gridBagConstraints);
        this.imageLabel.setFont(new Font("Noto Sans", 0, 18));
        this.imageLabel.setForeground(Color.white);
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/img/photobooth_start.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("properties/Bundle");
        this.imageLabel.setText(bundle.getString("MultiSelectPhotoboothFrame.imageLabel.text_1"));
        this.imageLabel.setHorizontalTextPosition(0);
        this.imageLabel.setIconTextGap(20);
        this.imageLabel.setMaximumSize(new Dimension(1400, 800));
        this.imageLabel.setMinimumSize(new Dimension(1400, 800));
        this.imageLabel.setName("");
        this.imageLabel.setPreferredSize(new Dimension(1400, 800));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 200.0;
        gridBagConstraints.weighty = 200.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.imageLabel, gridBagConstraints);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/img/next_small3.png")));
        this.nextButton.setToolTipText(bundle.getString("MultiSelectPhotoboothFrame.nextButton.toolTipText_1"));
        this.nextButton.setBorderPainted(false);
        this.nextButton.setContentAreaFilled(false);
        this.nextButton.setEnabled(false);
        this.nextButton.setFocusable(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiSelectPhotoboothFrame.this.nextButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.getContentPane().add((Component)this.nextButton, gridBagConstraints);
        this.sendButton.setBackground(new Color(36, 42, 106));
        this.sendButton.setFont(new Font("Noto Sans", 0, 20));
        this.sendButton.setForeground(new Color(254, 254, 254));
        this.sendButton.setText(bundle.getString("MultiSelectPhotoboothFrame.sendButton.text_1"));
        this.sendButton.setBorder(new MatteBorder(null));
        this.sendButton.setBorderPainted(false);
        this.sendButton.setContentAreaFilled(false);
        this.sendButton.setEnabled(false);
        this.sendButton.setFocusPainted(false);
        this.sendButton.setFocusable(false);
        this.sendButton.setMargin(new Insets(5, 5, 5, 5));
        this.sendButton.setMaximumSize(new Dimension(336, 50));
        this.sendButton.setMinimumSize(new Dimension(336, 50));
        this.sendButton.setOpaque(true);
        this.sendButton.setPreferredSize(new Dimension(336, 50));
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiSelectPhotoboothFrame.this.sendButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.getContentPane().add((Component)this.sendButton, gridBagConstraints);
        this.imageNumber.setForeground(Color.white);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 26;
        this.getContentPane().add((Component)this.imageNumber, gridBagConstraints);
        this.cancelButton.setBackground(new Color(36, 42, 106));
        this.cancelButton.setFont(new Font("Noto Sans", 0, 20));
        this.cancelButton.setForeground(new Color(254, 254, 254));
        this.cancelButton.setText(bundle.getString("MultiSelectPhotoboothFrame.cancelButton.text"));
        this.cancelButton.setBorder(new MatteBorder(null));
        this.cancelButton.setBorderPainted(false);
        this.cancelButton.setContentAreaFilled(false);
        this.cancelButton.setEnabled(false);
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setMargin(new Insets(5, 5, 5, 5));
        this.cancelButton.setMaximumSize(new Dimension(336, 50));
        this.cancelButton.setMinimumSize(new Dimension(336, 50));
        this.cancelButton.setOpaque(true);
        this.cancelButton.setPreferredSize(new Dimension(336, 50));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiSelectPhotoboothFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.selectButton.setBackground(new Color(36, 42, 106));
        this.selectButton.setFont(new Font("Noto Sans", 0, 20));
        this.selectButton.setForeground(new Color(254, 254, 254));
        this.selectButton.setText(bundle.getString("MultiSelectPhotoboothFrame.selectButton.text"));
        this.selectButton.setBorder(new MatteBorder(null));
        this.selectButton.setBorderPainted(false);
        this.selectButton.setContentAreaFilled(false);
        this.selectButton.setFocusPainted(false);
        this.selectButton.setMargin(new Insets(5, 5, 5, 5));
        this.selectButton.setMaximumSize(new Dimension(336, 50));
        this.selectButton.setMinimumSize(new Dimension(336, 50));
        this.selectButton.setOpaque(true);
        this.selectButton.setPreferredSize(new Dimension(336, 50));
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiSelectPhotoboothFrame.this.selectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.getContentPane().add((Component)this.selectButton, gridBagConstraints);
        this.selectedCounter.setText(bundle.getString("MultiSelectPhotoboothFrame.selectedCounter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.selectedCounter, gridBagConstraints);
        this.pack();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.actImageIndex = this.actImageIndex == this.images.size() - 1 ? 0 : ++this.actImageIndex;
        this.updateImage();
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        this.actImageIndex = this.actImageIndex == 0 ? this.images.size() - 1 : --this.actImageIndex;
        this.updateImage();
    }

    public void showAsDisabled() {
        this.sendButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.selectButton.setEnabled(false);
        this.imageLabel.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        this.sendButton.setBackground(Color.LIGHT_GRAY);
        this.cancelButton.setBackground(Color.LIGHT_GRAY);
        this.selectButton.setBackground(Color.LIGHT_GRAY);
        this.sendButton.setForeground(Color.GRAY);
        this.cancelButton.setForeground(Color.GRAY);
        this.selectButton.setForeground(Color.GRAY);
        this.getContentPane().setBackground(Color.GRAY);
    }

    public void showAsEnabled() {
        this.selectButton.setEnabled(true);
        this.selectButton.setBackground(Color.decode(this.prefs.get("button_color", "#ED5E2F")));
        this.selectButton.setForeground(Color.decode(this.prefs.get("button_foreground", "#ffffff")));
        this.imageLabel.setEnabled(true);
        this.nextButton.setEnabled(true);
        this.prevButton.setEnabled(true);
        Preferences prefs = Preferences.userNodeForPackage(MultiSelectPhotoboothFrame.class);
        this.getContentPane().setBackground(Color.decode(prefs.get("background_color", "#333333")));
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        this.showAsDisabled();
        if (!Preferences.userNodeForPackage(StartFrame.class).getBoolean("osk", false)) {
            MultiSelectSaveDialog sd = new MultiSelectSaveDialog((Frame)this, true, this.selectedImages, this);
            sd.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    MultiSelectPhotoboothFrame.this.showAsEnabled();
                }
            });
        } else {
            MultiSelectOSKSaveDialog sd = new MultiSelectOSKSaveDialog((Frame)this, true, this.selectedImages, this);
            sd.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    MultiSelectPhotoboothFrame.this.showAsEnabled();
                }
            });
        }
        this.selectedImages.clear();
        this.selectedCounter.setText(this.selectedImages.size() + " " + ResourceBundle.getBundle("properties/Bundle").getString("MultiSelectPhotoboothFrame.imageCount"));
        this.imageLabel.setBorder(BorderFactory.createEmptyBorder());
        this.selectButton.setText(ResourceBundle.getBundle("properties/Bundle").getString("MultiSelectPhotoboothFrame.selectButton.text"));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selectedImages.clear();
        this.sendButton.setEnabled(false);
        this.sendButton.setBackground(Color.LIGHT_GRAY);
        this.sendButton.setForeground(Color.GRAY);
        this.cancelButton.setEnabled(false);
        this.cancelButton.setBackground(Color.LIGHT_GRAY);
        this.cancelButton.setForeground(Color.GRAY);
        this.selectButton.setText(ResourceBundle.getBundle("properties/Bundle").getString("MultiSelectPhotoboothFrame.selectButton.text"));
        this.selectedCounter.setText(this.selectedImages.size() + " " + ResourceBundle.getBundle("properties/Bundle").getString("MultiSelectPhotoboothFrame.imageCount"));
        this.imageLabel.setBorder(BorderFactory.createEmptyBorder());
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        if (this.selectedImages.contains(this.images.get(this.actImageIndex))) {
            this.selectedImages.remove(this.images.get(this.actImageIndex));
            this.selectButton.setText(ResourceBundle.getBundle("properties/Bundle").getString("MultiSelectPhotoboothFrame.selectButton.text"));
            if (this.selectedImages.size() == 0) {
                this.sendButton.setEnabled(false);
                this.sendButton.setBackground(Color.LIGHT_GRAY);
                this.sendButton.setForeground(Color.GRAY);
                this.cancelButton.setEnabled(false);
                this.cancelButton.setBackground(Color.LIGHT_GRAY);
                this.cancelButton.setForeground(Color.GRAY);
                this.imageLabel.setBorder(BorderFactory.createEmptyBorder());
            }
        } else {
            this.selectedImages.add(this.images.get(this.actImageIndex));
            this.sendButton.setEnabled(true);
            this.sendButton.setBackground(Color.decode(this.prefs.get("button_color", "#ED5E2F")));
            this.sendButton.setForeground(Color.decode(this.prefs.get("button_foreground", "#FFFFFF")));
            this.cancelButton.setEnabled(true);
            this.cancelButton.setBackground(Color.decode(this.prefs.get("button_color", "#ED5E2F")));
            this.cancelButton.setForeground(Color.decode(this.prefs.get("button_foreground", "#FFFFFFF")));
            this.imageLabel.setBorder(BorderFactory.createLineBorder(Color.decode(this.prefs.get("button_color", "#ED5E2F"))));
            this.selectButton.setText(ResourceBundle.getBundle("properties/Bundle").getString("MultiSelectPhotoboothFrame.selectButton.text2"));
        }
        this.selectedCounter.setText(this.selectedImages.size() + " " + ResourceBundle.getBundle("properties/Bundle").getString("MultiSelectPhotoboothFrame.imageCount"));
    }

    @Override
    public boolean close() {
        this.setVisible(false);
        this.dispose();
        this.tfw.interrupt();
        if (this.ats != null) {
            this.ats.stop();
        }
        return true;
    }

    public void updateImage() {
        if (this.actImageIndex != -1) {
            if (this.actImageIndex >= 0) {
                this.showAsEnabled();
                this.imageLabel.setText("");
            }
            if (this.selectedImages.contains(this.images.get(this.actImageIndex))) {
                this.imageLabel.setBorder(BorderFactory.createLineBorder(Color.decode(this.prefs.get("button_color", "#ED5E2F"))));
                this.selectButton.setText(ResourceBundle.getBundle("properties/Bundle").getString("MultiSelectPhotoboothFrame.selectButton.text2"));
            } else {
                this.imageLabel.setBorder(BorderFactory.createEmptyBorder());
                this.selectButton.setText(ResourceBundle.getBundle("properties/Bundle").getString("MultiSelectPhotoboothFrame.selectButton.text"));
            }
            Object imgBI = null;
            String actPath = "";
            try {
                actPath = this.path + this.images.get(this.actImageIndex);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                System.out.println(this.images.toString());
            }
            Preferences prefsWatermark = Preferences.userNodeForPackage(WatermarkPanel.class);
            if (this.prefs.getBoolean("thumbnails", true) && new File(new PathCreator().getThumbPath() + this.images.get(this.actImageIndex)).exists()) {
                actPath = new PathCreator().getThumbPath() + this.images.get(this.actImageIndex);
            } else if (prefsWatermark.getBoolean("watermark", false) && new File(new PathCreator().getWatermarkPath() + this.images.get(this.actImageIndex)).exists()) {
                actPath = new PathCreator().getWatermarkPath() + this.images.get(this.actImageIndex);
            }
            BufferedImage bi = BILoader.loadImage(actPath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bi, "jpg", baos);
                baos.flush();
                byte[] imageInByte = baos.toByteArray();
                baos.close();
                StretchIcon si = new StretchIcon(imageInByte);
                this.imageLabel.setIcon(si);
                this.imageNumber.setText(this.actImageIndex + 1 + "/" + this.images.size());
            }
            catch (IOException ex) {
                Logger.getLogger(MultiSelectPhotoboothFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.prefs.getBoolean("thumbnails", true) && !new File(new PathCreator().getThumbPath() + this.images.get(this.actImageIndex)).exists()) {
                try {
                    Thumbnails.of(new PathCreator().getImagePath() + this.images.get(this.actImageIndex)).size(this.prefs.getInt("image_height", 800), this.prefs.getInt("image_width", 1400)).toFile(new PathCreator().getThumbPath() + this.images.get(this.actImageIndex));
                }
                catch (IOException ex) {
                    Logger.getLogger(MultiSelectPhotoboothFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

