/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.mailWizard;

import com.freebooth.mailWizard.MailConfig;
import com.sun.mail.util.MailSSLSocketFactory;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;

public class MailConfigurator {
    private Properties prop;
    private Session session;
    private MimeMessage message;

    public void conifgureMail(final MailConfig config, String filePath, String fileName, String to, boolean withAttachment) throws EmailException, MessagingException {
        EmailAttachment attachment = new EmailAttachment();
        if (withAttachment) {
            // empty if block
        }
        boolean tls = false;
        boolean starttls = false;
        boolean ssl = false;
        this.prop = new Properties();
        if (config.getProvider().equals("GMail")) {
            this.prop.put("mail.smtp.host", "smtp.gmail.com");
            this.prop.put("mail.smtp.port", "587");
            this.prop.put("mail.smtp.auth", "true");
            this.prop.put("mail.smtp.ssl.trust", "smtp.gmail.com");
            starttls = true;
        } else if (config.getProvider().equals("web.de")) {
            this.prop.put("mail.smtp.host", "smtp.web.de");
            this.prop.put("mail.smtp.port", "587");
            this.prop.put("mail.smtp.auth", "true");
            this.prop.put("mail.smtp.ssl.trust", "smtp.web.de");
            starttls = true;
        } else if (config.getProvider().equals("GMX")) {
            this.prop.put("mail.smtp.host", "mail.gmx.net");
            this.prop.put("mail.smtp.port", "587");
            this.prop.put("mail.smtp.auth", "true");
            this.prop.put("mail.smtp.ssl.trust", "mail.gmx.net");
            starttls = true;
        } else if (config.getProvider().equals("Outlook.com")) {
            this.prop.put("mail.smtp.host", "smtp-mail.outlook.com");
            this.prop.put("mail.smtp.port", "587");
            this.prop.put("mail.smtp.auth", "true");
            this.prop.put("mail.smtp.ssl.trust", "smtp-mail.outlook.com");
            starttls = true;
        } else if (config.getProvider().equals("Yahoo!")) {
            this.prop.put("mail.smtp.host", "smtp.mail.yahoo.com");
            this.prop.put("mail.smtp.port", "587");
            this.prop.put("mail.smtp.auth", "true");
            this.prop.put("mail.smtp.ssl.trust", "smtp.mail.yahoo.com");
            starttls = true;
        } else {
            this.prop.put("mail.smtp.host", config.getHost());
            this.prop.put("mail.smtp.port", (Object)config.getPort());
            this.prop.put("mail.smtp.auth", "true");
            this.prop.put("mail.smtp.ssl.protocols", "TLSv1.2");
            if (config.getEncryption().equals("SSL")) {
                ssl = true;
            } else if (config.getEncryption().equals("TLS")) {
                tls = true;
            } else {
                this.prop.put("mail.smtp.ssl.trust", "*");
                starttls = true;
            }
        }
        this.session = Session.getInstance(this.prop, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(config.getUsername(), config.getPassword());
            }
        });
        if (starttls) {
            this.prop.put("mail.smtp.starttls.enable", "true");
        }
        if (ssl) {
            this.prop.put("mail.smtp.ssl.enable", "true");
            try {
                MailSSLSocketFactory sf = new MailSSLSocketFactory();
                sf.setTrustAllHosts(true);
                this.prop.put("mail.smtp.ssl.checkserveridentity", "true");
                this.prop.put("mail.smtp.ssl.socketFactory", sf);
            }
            catch (GeneralSecurityException ex) {
                Logger.getLogger(MailConfigurator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(config.getMessage() + "\n -- \n" + ResourceBundle.getBundle("properties/Bundle").getString("UploadFrame.Worker.signatory"));
        MimeMultipart multipart = new MimeMultipart();
        ((Multipart)multipart).addBodyPart(messageBodyPart);
        if (withAttachment) {
            messageBodyPart = new MimeBodyPart();
            String path = filePath;
            if (config.sendWatermarked()) {
                path = filePath + "watermarked" + File.separator;
            }
            String fileNameToAttach = new File(path + fileName).exists() ? path + fileName : filePath + fileName;
            FileDataSource source = new FileDataSource(fileNameToAttach);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(fileName);
            ((Multipart)multipart).addBodyPart(messageBodyPart);
        }
        this.message = new MimeMessage(this.session);
        this.message.setContent(multipart);
        this.message.setFrom(new InternetAddress(config.getMail()));
        this.message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
        this.message.setSubject(config.getSubject());
    }

    public void sendMessage() throws MessagingException {
        Transport.send(this.message);
    }
}

