/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.fileWatcher;

import com.freebooth.fileWatcher.ImageDecorator;
import com.freebooth.photobooth.PhotoboothFrame;
import com.freebooth.photobooth.WatermarkPanel;
import com.freebooth.utilities.BILoader;
import com.freebooth.utilities.PathCreator;
import com.freebooth.utilities.WatermarkGenerator;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class WatermarkDecorator
extends ImageDecorator {
    public WatermarkDecorator() {
    }

    public WatermarkDecorator(ImageDecorator decorator) {
        super(decorator);
    }

    @Override
    public File processImage(File file, BufferedImage image) {
        Preferences prefsWatermark = Preferences.userNodeForPackage(WatermarkPanel.class);
        String overlay = file.getName().split(Pattern.quote("."))[0];
        if (Boolean.parseBoolean(prefsWatermark.get("watermark", "false")) && !overlay.equals("overlay")) {
            File watermarkedFile = new File(new PathCreator().getWatermarkPath() + File.separator + file.getName());
            BufferedImage newImage = null;
            if (!watermarkedFile.exists()) {
                if (image == null) {
                    image = BILoader.loadImage(file.getAbsolutePath());
                }
                String position = prefsWatermark.get("watermark_position", "center");
                int opacity = prefsWatermark.getInt("watermark_opacity", 100);
                int marginX = prefsWatermark.getInt("watermark_margin_x", 0);
                int marginY = prefsWatermark.getInt("watermark_margin_y", 0);
                try {
                    if (prefsWatermark.get("watermark_type", "Text").equals("Text")) {
                        Font font = new Font(prefsWatermark.get("watermark_font_name", "Arial"), Integer.parseInt(prefsWatermark.get("watermark_font_style", Integer.toString(0))), Integer.parseInt(prefsWatermark.get("watermark_font_size", "12")));
                        String text = prefsWatermark.get("watermark_text", "FreeBooth");
                        Color color = Color.decode(prefsWatermark.get("watermark_text_color", "#000000"));
                        newImage = WatermarkGenerator.addTextWatermark(text, opacity, color, font, position, image, marginX, marginY);
                    } else {
                        BufferedImage watermark = ImageIO.read(new File(prefsWatermark.get("watermark_path", prefsWatermark.get("watermark_path", new PathCreator().getWebPath() + "watermark.png"))));
                        int percent = prefsWatermark.getInt("watermark_percentage", 100);
                        newImage = WatermarkGenerator.watermark(image, watermark, position, opacity, marginX, marginY);
                    }
                    ImageIO.write((RenderedImage)newImage, "jpg", watermarkedFile);
                }
                catch (IOException ex) {
                    Logger.getLogger(PhotoboothFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.decorator != null) {
                return this.decorator.processImage(watermarkedFile, newImage);
            }
            return watermarkedFile;
        }
        if (this.decorator != null) {
            return this.decorator.processImage(file, image);
        }
        return file;
    }
}

