/*
 * Decompiled with CFR 0.152.
 */
package com.freebooth.fileWatcher;

import com.freebooth.fileWatcher.ImageDecorator;
import com.freebooth.photobooth.MultiSelectPhotoboothFrame;
import com.freebooth.photobooth.StartFrame;
import com.freebooth.utilities.PathCreator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.coobird.thumbnailator.Thumbnails;

public class ThumbDecorator
extends ImageDecorator {
    private boolean slideshow;

    public ThumbDecorator(boolean forServer) {
        this.slideshow = forServer;
    }

    public ThumbDecorator(boolean forServer, ImageDecorator decorator) {
        super(decorator);
        this.slideshow = forServer;
    }

    @Override
    public File processImage(File file, BufferedImage image) {
        Preferences prefs = Preferences.userNodeForPackage(StartFrame.class);
        if (prefs.getBoolean("thumbnails", true) || this.slideshow) {
            File thumbnail = this.slideshow ? new File(new PathCreator().getThumbWebPath() + file.getName()) : new File(new PathCreator().getThumbPath() + file.getName());
            BufferedImage outputImage = null;
            if (!thumbnail.exists()) {
                System.out.println("Thumbnail generated");
                try {
                    int height = prefs.getInt("image_height", 800);
                    int width = prefs.getInt("image_width", 1400);
                    if (image != null) {
                        Thumbnails.of(image).size(width, height).toFile(thumbnail);
                    } else {
                        Thumbnails.of(file).size(width, height).toFile(thumbnail);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(MultiSelectPhotoboothFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.decorator != null) {
                return this.decorator.processImage(thumbnail, outputImage);
            }
            return thumbnail;
        }
        return file;
    }
}

